# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AKSPropertiesArgs',
    'AKSArgs',
    'AccountKeyDatastoreCredentialsArgs',
    'AccountKeyDatastoreSecretsArgs',
    'AksNetworkingConfigurationArgs',
    'AmlComputePropertiesArgs',
    'AmlComputeArgs',
    'AmlTokenArgs',
    'AssignedUserArgs',
    'AutoPausePropertiesArgs',
    'AutoScalePropertiesArgs',
    'AutoScaleSettingsArgs',
    'AzureBlobContentsArgs',
    'AzureDataLakeGen1ContentsArgs',
    'AzureDataLakeGen2ContentsArgs',
    'AzureFileContentsArgs',
    'AzurePostgreSqlContentsArgs',
    'AzureSqlDatabaseContentsArgs',
    'BanditPolicyArgs',
    'BatchDeploymentArgs',
    'BatchEndpointArgs',
    'BatchOutputConfigurationArgs',
    'BatchRetrySettingsArgs',
    'CertificateDatastoreCredentialsArgs',
    'CertificateDatastoreSecretsArgs',
    'CodeConfigurationArgs',
    'CodeContainerArgs',
    'CodeVersionArgs',
    'CommandJobArgs',
    'ComputeConfigurationArgs',
    'ComputeInstancePropertiesArgs',
    'ComputeInstanceSshSettingsArgs',
    'ComputeInstanceArgs',
    'ComputeSchedulesArgs',
    'ComputeStartStopScheduleArgs',
    'ContainerResourceRequirementsArgs',
    'CosmosDbSettingsArgs',
    'CronArgs',
    'DataContainerArgs',
    'DataFactoryArgs',
    'DataLakeAnalyticsPropertiesArgs',
    'DataLakeAnalyticsArgs',
    'DataPathAssetReferenceArgs',
    'DataVersionArgs',
    'DatabricksPropertiesArgs',
    'DatabricksArgs',
    'DatastorePropertiesArgs',
    'DockerBuildArgs',
    'DockerImagePlatformArgs',
    'DockerImageArgs',
    'EncryptionPropertyArgs',
    'EndpointAuthKeysArgs',
    'EnvironmentContainerArgs',
    'EnvironmentSpecificationVersionArgs',
    'FlavorDataArgs',
    'GlusterFsContentsArgs',
    'HDInsightPropertiesArgs',
    'HDInsightArgs',
    'IdAssetReferenceArgs',
    'IdentityForCmkArgs',
    'IdentityArgs',
    'InferenceContainerPropertiesArgs',
    'InputDataBindingArgs',
    'K8sOnlineDeploymentArgs',
    'KeyVaultPropertiesArgs',
    'LabelCategoryArgs',
    'LabelClassArgs',
    'LabelingDatasetConfigurationArgs',
    'LabelingJobImagePropertiesArgs',
    'LabelingJobInstructionsArgs',
    'LabelingJobTextPropertiesArgs',
    'LabelingJobArgs',
    'LinkedInfoArgs',
    'MLAssistConfigurationArgs',
    'ManagedIdentityArgs',
    'ManagedOnlineDeploymentArgs',
    'ManualScaleSettingsArgs',
    'MedianStoppingPolicyArgs',
    'ModelContainerArgs',
    'ModelVersionArgs',
    'MpiArgs',
    'NoneDatastoreCredentialsArgs',
    'NoneDatastoreSecretsArgs',
    'ObjectiveArgs',
    'OnlineEndpointArgs',
    'OnlineRequestSettingsArgs',
    'OutputDataBindingArgs',
    'OutputPathAssetReferenceArgs',
    'PersonalComputeInstanceSettingsArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'ProbeSettingsArgs',
    'PyTorchArgs',
    'RecurrenceScheduleArgs',
    'RecurrenceArgs',
    'ResourceIdentityArgs',
    'ResourceIdArgs',
    'RouteArgs',
    'SasDatastoreCredentialsArgs',
    'SasDatastoreSecretsArgs',
    'ScaleSettingsArgs',
    'ScriptReferenceArgs',
    'ScriptsToExecuteArgs',
    'ServiceManagedResourcesSettingsArgs',
    'ServicePrincipalDatastoreCredentialsArgs',
    'ServicePrincipalDatastoreSecretsArgs',
    'SetupScriptsArgs',
    'SharedPrivateLinkResourceArgs',
    'SkuArgs',
    'SqlAdminDatastoreCredentialsArgs',
    'SqlAdminDatastoreSecretsArgs',
    'SslConfigurationArgs',
    'SweepJobArgs',
    'SynapseSparkPoolPropertiesPropertiesArgs',
    'SynapseSparkArgs',
    'TensorFlowArgs',
    'TrialComponentArgs',
    'TruncationSelectionPolicyArgs',
    'UserAccountCredentialsArgs',
    'UserAssignedIdentityMetaArgs',
    'VirtualMachineImageArgs',
    'VirtualMachinePropertiesArgs',
    'VirtualMachineSshCredentialsArgs',
    'VirtualMachineArgs',
]

@pulumi.input_type
class AKSPropertiesArgs:
    def __init__(__self__, *,
                 agent_count: Optional[pulumi.Input[int]] = None,
                 agent_vm_size: Optional[pulumi.Input[str]] = None,
                 aks_networking_configuration: Optional[pulumi.Input['AksNetworkingConfigurationArgs']] = None,
                 cluster_fqdn: Optional[pulumi.Input[str]] = None,
                 cluster_purpose: Optional[pulumi.Input[Union[str, 'ClusterPurpose']]] = None,
                 load_balancer_subnet: Optional[pulumi.Input[str]] = None,
                 load_balancer_type: Optional[pulumi.Input[Union[str, 'LoadBalancerType']]] = None,
                 ssl_configuration: Optional[pulumi.Input['SslConfigurationArgs']] = None):
        """
        AKS properties
        :param pulumi.Input[int] agent_count: Number of agents
        :param pulumi.Input[str] agent_vm_size: Agent virtual machine size
        :param pulumi.Input['AksNetworkingConfigurationArgs'] aks_networking_configuration: AKS networking configuration for vnet
        :param pulumi.Input[str] cluster_fqdn: Cluster full qualified domain name
        :param pulumi.Input[Union[str, 'ClusterPurpose']] cluster_purpose: Intended usage of the cluster
        :param pulumi.Input[str] load_balancer_subnet: Load Balancer Subnet
        :param pulumi.Input[Union[str, 'LoadBalancerType']] load_balancer_type: Load Balancer Type
        :param pulumi.Input['SslConfigurationArgs'] ssl_configuration: SSL configuration
        """
        if agent_count is not None:
            pulumi.set(__self__, "agent_count", agent_count)
        if agent_vm_size is not None:
            pulumi.set(__self__, "agent_vm_size", agent_vm_size)
        if aks_networking_configuration is not None:
            pulumi.set(__self__, "aks_networking_configuration", aks_networking_configuration)
        if cluster_fqdn is not None:
            pulumi.set(__self__, "cluster_fqdn", cluster_fqdn)
        if cluster_purpose is None:
            cluster_purpose = 'FastProd'
        if cluster_purpose is not None:
            pulumi.set(__self__, "cluster_purpose", cluster_purpose)
        if load_balancer_subnet is not None:
            pulumi.set(__self__, "load_balancer_subnet", load_balancer_subnet)
        if load_balancer_type is None:
            load_balancer_type = 'PublicIp'
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if ssl_configuration is not None:
            pulumi.set(__self__, "ssl_configuration", ssl_configuration)

    @property
    @pulumi.getter(name="agentCount")
    def agent_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of agents
        """
        return pulumi.get(self, "agent_count")

    @agent_count.setter
    def agent_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_count", value)

    @property
    @pulumi.getter(name="agentVmSize")
    def agent_vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        Agent virtual machine size
        """
        return pulumi.get(self, "agent_vm_size")

    @agent_vm_size.setter
    def agent_vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_vm_size", value)

    @property
    @pulumi.getter(name="aksNetworkingConfiguration")
    def aks_networking_configuration(self) -> Optional[pulumi.Input['AksNetworkingConfigurationArgs']]:
        """
        AKS networking configuration for vnet
        """
        return pulumi.get(self, "aks_networking_configuration")

    @aks_networking_configuration.setter
    def aks_networking_configuration(self, value: Optional[pulumi.Input['AksNetworkingConfigurationArgs']]):
        pulumi.set(self, "aks_networking_configuration", value)

    @property
    @pulumi.getter(name="clusterFqdn")
    def cluster_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster full qualified domain name
        """
        return pulumi.get(self, "cluster_fqdn")

    @cluster_fqdn.setter
    def cluster_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_fqdn", value)

    @property
    @pulumi.getter(name="clusterPurpose")
    def cluster_purpose(self) -> Optional[pulumi.Input[Union[str, 'ClusterPurpose']]]:
        """
        Intended usage of the cluster
        """
        return pulumi.get(self, "cluster_purpose")

    @cluster_purpose.setter
    def cluster_purpose(self, value: Optional[pulumi.Input[Union[str, 'ClusterPurpose']]]):
        pulumi.set(self, "cluster_purpose", value)

    @property
    @pulumi.getter(name="loadBalancerSubnet")
    def load_balancer_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Load Balancer Subnet
        """
        return pulumi.get(self, "load_balancer_subnet")

    @load_balancer_subnet.setter
    def load_balancer_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_subnet", value)

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[pulumi.Input[Union[str, 'LoadBalancerType']]]:
        """
        Load Balancer Type
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: Optional[pulumi.Input[Union[str, 'LoadBalancerType']]]):
        pulumi.set(self, "load_balancer_type", value)

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> Optional[pulumi.Input['SslConfigurationArgs']]:
        """
        SSL configuration
        """
        return pulumi.get(self, "ssl_configuration")

    @ssl_configuration.setter
    def ssl_configuration(self, value: Optional[pulumi.Input['SslConfigurationArgs']]):
        pulumi.set(self, "ssl_configuration", value)


@pulumi.input_type
class AKSArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['AKSPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A Machine Learning compute based on AKS.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'AKS'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input['AKSPropertiesArgs'] properties: AKS properties
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'AKS')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'AKS'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['AKSPropertiesArgs']]:
        """
        AKS properties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['AKSPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class AccountKeyDatastoreCredentialsArgs:
    def __init__(__self__, *,
                 credentials_type: pulumi.Input[str],
                 secrets: Optional[pulumi.Input['AccountKeyDatastoreSecretsArgs']] = None):
        """
        Account key datastore credentials configuration.
        :param pulumi.Input[str] credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'AccountKey'.
        :param pulumi.Input['AccountKeyDatastoreSecretsArgs'] secrets: Storage account secrets.
        """
        pulumi.set(__self__, "credentials_type", 'AccountKey')
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'AccountKey'.
        """
        return pulumi.get(self, "credentials_type")

    @credentials_type.setter
    def credentials_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credentials_type", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input['AccountKeyDatastoreSecretsArgs']]:
        """
        Storage account secrets.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input['AccountKeyDatastoreSecretsArgs']]):
        pulumi.set(self, "secrets", value)


@pulumi.input_type
class AccountKeyDatastoreSecretsArgs:
    def __init__(__self__, *,
                 secrets_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None):
        """
        Datastore account key secrets.
        :param pulumi.Input[str] secrets_type: Enum to determine the datastore secrets type.
               Expected value is 'AccountKey'.
        :param pulumi.Input[str] key: Storage account key.
        """
        pulumi.set(__self__, "secrets_type", 'AccountKey')
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter(name="secretsType")
    def secrets_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore secrets type.
        Expected value is 'AccountKey'.
        """
        return pulumi.get(self, "secrets_type")

    @secrets_type.setter
    def secrets_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "secrets_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Storage account key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class AksNetworkingConfigurationArgs:
    def __init__(__self__, *,
                 dns_service_ip: Optional[pulumi.Input[str]] = None,
                 docker_bridge_cidr: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Advance configuration for AKS networking
        :param pulumi.Input[str] dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        :param pulumi.Input[str] docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        :param pulumi.Input[str] service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        :param pulumi.Input[str] subnet_id: Virtual network subnet resource ID the compute nodes belong to
        """
        if dns_service_ip is not None:
            pulumi.set(__self__, "dns_service_ip", dns_service_ip)
        if docker_bridge_cidr is not None:
            pulumi.set(__self__, "docker_bridge_cidr", docker_bridge_cidr)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="dnsServiceIP")
    def dns_service_ip(self) -> Optional[pulumi.Input[str]]:
        """
        An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        """
        return pulumi.get(self, "dns_service_ip")

    @dns_service_ip.setter
    def dns_service_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_service_ip", value)

    @property
    @pulumi.getter(name="dockerBridgeCidr")
    def docker_bridge_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        """
        return pulumi.get(self, "docker_bridge_cidr")

    @docker_bridge_cidr.setter
    def docker_bridge_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_bridge_cidr", value)

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_cidr", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual network subnet resource ID the compute nodes belong to
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class AmlComputePropertiesArgs:
    def __init__(__self__, *,
                 enable_node_public_ip: Optional[pulumi.Input[bool]] = None,
                 isolated_network: Optional[pulumi.Input[bool]] = None,
                 os_type: Optional[pulumi.Input[Union[str, 'OsType']]] = None,
                 remote_login_port_public_access: Optional[pulumi.Input[Union[str, 'RemoteLoginPortPublicAccess']]] = None,
                 scale_settings: Optional[pulumi.Input['ScaleSettingsArgs']] = None,
                 subnet: Optional[pulumi.Input['ResourceIdArgs']] = None,
                 user_account_credentials: Optional[pulumi.Input['UserAccountCredentialsArgs']] = None,
                 virtual_machine_image: Optional[pulumi.Input['VirtualMachineImageArgs']] = None,
                 vm_priority: Optional[pulumi.Input[Union[str, 'VmPriority']]] = None,
                 vm_size: Optional[pulumi.Input[str]] = None):
        """
        AML Compute properties
        :param pulumi.Input[bool] enable_node_public_ip: Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        :param pulumi.Input[bool] isolated_network: Network is isolated or not
        :param pulumi.Input[Union[str, 'OsType']] os_type: Compute OS Type
        :param pulumi.Input[Union[str, 'RemoteLoginPortPublicAccess']] remote_login_port_public_access: State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
        :param pulumi.Input['ScaleSettingsArgs'] scale_settings: Scale settings for AML Compute
        :param pulumi.Input['ResourceIdArgs'] subnet: Virtual network subnet resource ID the compute nodes belong to.
        :param pulumi.Input['UserAccountCredentialsArgs'] user_account_credentials: Credentials for an administrator user account that will be created on each compute node.
        :param pulumi.Input['VirtualMachineImageArgs'] virtual_machine_image: Virtual Machine image for AML Compute - windows only
        :param pulumi.Input[Union[str, 'VmPriority']] vm_priority: Virtual Machine priority
        :param pulumi.Input[str] vm_size: Virtual Machine Size
        """
        if enable_node_public_ip is None:
            enable_node_public_ip = True
        if enable_node_public_ip is not None:
            pulumi.set(__self__, "enable_node_public_ip", enable_node_public_ip)
        if isolated_network is not None:
            pulumi.set(__self__, "isolated_network", isolated_network)
        if os_type is None:
            os_type = 'Linux'
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if remote_login_port_public_access is None:
            remote_login_port_public_access = 'NotSpecified'
        if remote_login_port_public_access is not None:
            pulumi.set(__self__, "remote_login_port_public_access", remote_login_port_public_access)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if user_account_credentials is not None:
            pulumi.set(__self__, "user_account_credentials", user_account_credentials)
        if virtual_machine_image is not None:
            pulumi.set(__self__, "virtual_machine_image", virtual_machine_image)
        if vm_priority is not None:
            pulumi.set(__self__, "vm_priority", vm_priority)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="enableNodePublicIp")
    def enable_node_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        """
        return pulumi.get(self, "enable_node_public_ip")

    @enable_node_public_ip.setter
    def enable_node_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_node_public_ip", value)

    @property
    @pulumi.getter(name="isolatedNetwork")
    def isolated_network(self) -> Optional[pulumi.Input[bool]]:
        """
        Network is isolated or not
        """
        return pulumi.get(self, "isolated_network")

    @isolated_network.setter
    def isolated_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "isolated_network", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[Union[str, 'OsType']]]:
        """
        Compute OS Type
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[Union[str, 'OsType']]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="remoteLoginPortPublicAccess")
    def remote_login_port_public_access(self) -> Optional[pulumi.Input[Union[str, 'RemoteLoginPortPublicAccess']]]:
        """
        State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
        """
        return pulumi.get(self, "remote_login_port_public_access")

    @remote_login_port_public_access.setter
    def remote_login_port_public_access(self, value: Optional[pulumi.Input[Union[str, 'RemoteLoginPortPublicAccess']]]):
        pulumi.set(self, "remote_login_port_public_access", value)

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional[pulumi.Input['ScaleSettingsArgs']]:
        """
        Scale settings for AML Compute
        """
        return pulumi.get(self, "scale_settings")

    @scale_settings.setter
    def scale_settings(self, value: Optional[pulumi.Input['ScaleSettingsArgs']]):
        pulumi.set(self, "scale_settings", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['ResourceIdArgs']]:
        """
        Virtual network subnet resource ID the compute nodes belong to.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['ResourceIdArgs']]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="userAccountCredentials")
    def user_account_credentials(self) -> Optional[pulumi.Input['UserAccountCredentialsArgs']]:
        """
        Credentials for an administrator user account that will be created on each compute node.
        """
        return pulumi.get(self, "user_account_credentials")

    @user_account_credentials.setter
    def user_account_credentials(self, value: Optional[pulumi.Input['UserAccountCredentialsArgs']]):
        pulumi.set(self, "user_account_credentials", value)

    @property
    @pulumi.getter(name="virtualMachineImage")
    def virtual_machine_image(self) -> Optional[pulumi.Input['VirtualMachineImageArgs']]:
        """
        Virtual Machine image for AML Compute - windows only
        """
        return pulumi.get(self, "virtual_machine_image")

    @virtual_machine_image.setter
    def virtual_machine_image(self, value: Optional[pulumi.Input['VirtualMachineImageArgs']]):
        pulumi.set(self, "virtual_machine_image", value)

    @property
    @pulumi.getter(name="vmPriority")
    def vm_priority(self) -> Optional[pulumi.Input[Union[str, 'VmPriority']]]:
        """
        Virtual Machine priority
        """
        return pulumi.get(self, "vm_priority")

    @vm_priority.setter
    def vm_priority(self, value: Optional[pulumi.Input[Union[str, 'VmPriority']]]):
        pulumi.set(self, "vm_priority", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual Machine Size
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_size", value)


@pulumi.input_type
class AmlComputeArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['AmlComputePropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        An Azure Machine Learning compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'AmlCompute'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input['AmlComputePropertiesArgs'] properties: AML Compute properties
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'AmlCompute')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'AmlCompute'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['AmlComputePropertiesArgs']]:
        """
        AML Compute properties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['AmlComputePropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class AmlTokenArgs:
    def __init__(__self__, *,
                 identity_type: pulumi.Input[str]):
        """
        AML Token identity configuration.
        :param pulumi.Input[str] identity_type: Enum to determine identity framework.
               Expected value is 'AMLToken'.
        """
        pulumi.set(__self__, "identity_type", 'AMLToken')

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> pulumi.Input[str]:
        """
        Enum to determine identity framework.
        Expected value is 'AMLToken'.
        """
        return pulumi.get(self, "identity_type")

    @identity_type.setter
    def identity_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "identity_type", value)


@pulumi.input_type
class AssignedUserArgs:
    def __init__(__self__, *,
                 object_id: pulumi.Input[str],
                 tenant_id: pulumi.Input[str]):
        """
        A user that can be assigned to a compute instance.
        :param pulumi.Input[str] object_id: User’s AAD Object Id.
        :param pulumi.Input[str] tenant_id: User’s AAD Tenant Id.
        """
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Input[str]:
        """
        User’s AAD Object Id.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        User’s AAD Tenant Id.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class AutoPausePropertiesArgs:
    def __init__(__self__, *,
                 delay_in_minutes: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Auto pause properties
        """
        if delay_in_minutes is not None:
            pulumi.set(__self__, "delay_in_minutes", delay_in_minutes)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="delayInMinutes")
    def delay_in_minutes(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "delay_in_minutes")

    @delay_in_minutes.setter
    def delay_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_in_minutes", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class AutoScalePropertiesArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 max_node_count: Optional[pulumi.Input[int]] = None,
                 min_node_count: Optional[pulumi.Input[int]] = None):
        """
        Auto scale properties
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_node_count", value)


@pulumi.input_type
class AutoScaleSettingsArgs:
    def __init__(__self__, *,
                 scale_type: pulumi.Input[str],
                 max_instances: Optional[pulumi.Input[int]] = None,
                 min_instances: Optional[pulumi.Input[int]] = None,
                 polling_interval: Optional[pulumi.Input[str]] = None,
                 target_utilization_percentage: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] scale_type: 
               Expected value is 'Auto'.
        :param pulumi.Input[int] max_instances: Maximum number of instances for this deployment.
        :param pulumi.Input[int] min_instances: Minimum number of instances for this deployment.
        :param pulumi.Input[str] polling_interval: The polling interval in ISO 8691 format. Only supports duration with precision as low as Seconds.
        :param pulumi.Input[int] target_utilization_percentage: Target CPU usage for the autoscaler.
        """
        pulumi.set(__self__, "scale_type", 'Auto')
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if polling_interval is not None:
            pulumi.set(__self__, "polling_interval", polling_interval)
        if target_utilization_percentage is not None:
            pulumi.set(__self__, "target_utilization_percentage", target_utilization_percentage)

    @property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'Auto'.
        """
        return pulumi.get(self, "scale_type")

    @scale_type.setter
    def scale_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "scale_type", value)

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of instances for this deployment.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instances", value)

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of instances for this deployment.
        """
        return pulumi.get(self, "min_instances")

    @min_instances.setter
    def min_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instances", value)

    @property
    @pulumi.getter(name="pollingInterval")
    def polling_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The polling interval in ISO 8691 format. Only supports duration with precision as low as Seconds.
        """
        return pulumi.get(self, "polling_interval")

    @polling_interval.setter
    def polling_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "polling_interval", value)

    @property
    @pulumi.getter(name="targetUtilizationPercentage")
    def target_utilization_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        Target CPU usage for the autoscaler.
        """
        return pulumi.get(self, "target_utilization_percentage")

    @target_utilization_percentage.setter
    def target_utilization_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_utilization_percentage", value)


@pulumi.input_type
class AzureBlobContentsArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 container_name: pulumi.Input[str],
                 contents_type: pulumi.Input[str],
                 credentials: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']],
                 endpoint: pulumi.Input[str],
                 protocol: pulumi.Input[str]):
        """
        Azure Blob datastore configuration.
        :param pulumi.Input[str] account_name: [Required] Storage account name.
        :param pulumi.Input[str] container_name: [Required] Storage account container name.
        :param pulumi.Input[str] contents_type: Enum to determine the datastore contents type.
               Expected value is 'AzureBlob'.
        :param pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']] credentials: [Required] Account credentials.
        :param pulumi.Input[str] endpoint: [Required] Azure cloud endpoint for the storage account.
        :param pulumi.Input[str] protocol: [Required] Protocol used to communicate with the storage account.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "contents_type", 'AzureBlob')
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        [Required] Storage account name.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Input[str]:
        """
        [Required] Storage account container name.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="contentsType")
    def contents_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzureBlob'.
        """
        return pulumi.get(self, "contents_type")

    @contents_type.setter
    def contents_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "contents_type", value)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']]:
        """
        [Required] Account credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[str]:
        """
        [Required] Azure cloud endpoint for the storage account.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        [Required] Protocol used to communicate with the storage account.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class AzureDataLakeGen1ContentsArgs:
    def __init__(__self__, *,
                 contents_type: pulumi.Input[str],
                 credentials: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']],
                 store_name: pulumi.Input[str]):
        """
        Azure Data Lake Gen1 datastore configuration.
        :param pulumi.Input[str] contents_type: Enum to determine the datastore contents type.
               Expected value is 'AzureDataLakeGen1'.
        :param pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']] credentials: [Required] Account credentials.
        :param pulumi.Input[str] store_name: [Required] Azure Data Lake store name.
        """
        pulumi.set(__self__, "contents_type", 'AzureDataLakeGen1')
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "store_name", store_name)

    @property
    @pulumi.getter(name="contentsType")
    def contents_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzureDataLakeGen1'.
        """
        return pulumi.get(self, "contents_type")

    @contents_type.setter
    def contents_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "contents_type", value)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']]:
        """
        [Required] Account credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="storeName")
    def store_name(self) -> pulumi.Input[str]:
        """
        [Required] Azure Data Lake store name.
        """
        return pulumi.get(self, "store_name")

    @store_name.setter
    def store_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "store_name", value)


@pulumi.input_type
class AzureDataLakeGen2ContentsArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 container_name: pulumi.Input[str],
                 contents_type: pulumi.Input[str],
                 credentials: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']],
                 endpoint: pulumi.Input[str],
                 protocol: pulumi.Input[str]):
        """
        Azure Data Lake Gen2 datastore configuration.
        :param pulumi.Input[str] account_name: [Required] Storage account name.
        :param pulumi.Input[str] container_name: [Required] Storage account container name.
        :param pulumi.Input[str] contents_type: Enum to determine the datastore contents type.
               Expected value is 'AzureDataLakeGen2'.
        :param pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']] credentials: [Required] Account credentials.
        :param pulumi.Input[str] endpoint: [Required] Azure cloud endpoint for the storage account.
        :param pulumi.Input[str] protocol: [Required] Protocol used to communicate with the storage account.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "contents_type", 'AzureDataLakeGen2')
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        [Required] Storage account name.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Input[str]:
        """
        [Required] Storage account container name.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="contentsType")
    def contents_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzureDataLakeGen2'.
        """
        return pulumi.get(self, "contents_type")

    @contents_type.setter
    def contents_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "contents_type", value)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']]:
        """
        [Required] Account credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[str]:
        """
        [Required] Azure cloud endpoint for the storage account.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        [Required] Protocol used to communicate with the storage account.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class AzureFileContentsArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 container_name: pulumi.Input[str],
                 contents_type: pulumi.Input[str],
                 credentials: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']],
                 endpoint: pulumi.Input[str],
                 protocol: pulumi.Input[str]):
        """
        Azure File datastore configuration.
        :param pulumi.Input[str] account_name: [Required] Storage account name.
        :param pulumi.Input[str] container_name: [Required] Storage account container name.
        :param pulumi.Input[str] contents_type: Enum to determine the datastore contents type.
               Expected value is 'AzureFile'.
        :param pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']] credentials: [Required] Account credentials.
        :param pulumi.Input[str] endpoint: [Required] Azure cloud endpoint for the storage account.
        :param pulumi.Input[str] protocol: [Required] Protocol used to communicate with the storage account.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "contents_type", 'AzureFile')
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        [Required] Storage account name.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Input[str]:
        """
        [Required] Storage account container name.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="contentsType")
    def contents_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzureFile'.
        """
        return pulumi.get(self, "contents_type")

    @contents_type.setter
    def contents_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "contents_type", value)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']]:
        """
        [Required] Account credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[str]:
        """
        [Required] Azure cloud endpoint for the storage account.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        [Required] Protocol used to communicate with the storage account.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class AzurePostgreSqlContentsArgs:
    def __init__(__self__, *,
                 contents_type: pulumi.Input[str],
                 credentials: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']],
                 database_name: pulumi.Input[str],
                 endpoint: pulumi.Input[str],
                 port_number: pulumi.Input[int],
                 server_name: pulumi.Input[str],
                 enable_ssl: Optional[pulumi.Input[bool]] = None):
        """
        Azure Postgre SQL datastore configuration.
        :param pulumi.Input[str] contents_type: Enum to determine the datastore contents type.
               Expected value is 'AzurePostgreSql'.
        :param pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']] credentials: [Required] Account credentials.
        :param pulumi.Input[str] database_name: [Required] Azure SQL database name.
        :param pulumi.Input[str] endpoint: [Required] Azure cloud endpoint for the database.
        :param pulumi.Input[int] port_number: [Required] Azure SQL server port.
        :param pulumi.Input[str] server_name: [Required] Azure SQL server name.
        :param pulumi.Input[bool] enable_ssl: Whether the Azure PostgreSQL server requires SSL.
        """
        pulumi.set(__self__, "contents_type", 'AzurePostgreSql')
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "port_number", port_number)
        pulumi.set(__self__, "server_name", server_name)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)

    @property
    @pulumi.getter(name="contentsType")
    def contents_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzurePostgreSql'.
        """
        return pulumi.get(self, "contents_type")

    @contents_type.setter
    def contents_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "contents_type", value)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']]:
        """
        [Required] Account credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        [Required] Azure SQL database name.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[str]:
        """
        [Required] Azure cloud endpoint for the database.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="portNumber")
    def port_number(self) -> pulumi.Input[int]:
        """
        [Required] Azure SQL server port.
        """
        return pulumi.get(self, "port_number")

    @port_number.setter
    def port_number(self, value: pulumi.Input[int]):
        pulumi.set(self, "port_number", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        [Required] Azure SQL server name.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="enableSSL")
    def enable_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the Azure PostgreSQL server requires SSL.
        """
        return pulumi.get(self, "enable_ssl")

    @enable_ssl.setter
    def enable_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ssl", value)


@pulumi.input_type
class AzureSqlDatabaseContentsArgs:
    def __init__(__self__, *,
                 contents_type: pulumi.Input[str],
                 credentials: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']],
                 database_name: pulumi.Input[str],
                 endpoint: pulumi.Input[str],
                 port_number: pulumi.Input[int],
                 server_name: pulumi.Input[str]):
        """
        Azure SQL Database datastore configuration.
        :param pulumi.Input[str] contents_type: Enum to determine the datastore contents type.
               Expected value is 'AzureSqlDatabase'.
        :param pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']] credentials: [Required] Account credentials.
        :param pulumi.Input[str] database_name: [Required] Azure SQL database name.
        :param pulumi.Input[str] endpoint: [Required] Azure cloud endpoint for the database.
        :param pulumi.Input[int] port_number: [Required] Azure SQL server port.
        :param pulumi.Input[str] server_name: [Required] Azure SQL server name.
        """
        pulumi.set(__self__, "contents_type", 'AzureSqlDatabase')
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "port_number", port_number)
        pulumi.set(__self__, "server_name", server_name)

    @property
    @pulumi.getter(name="contentsType")
    def contents_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzureSqlDatabase'.
        """
        return pulumi.get(self, "contents_type")

    @contents_type.setter
    def contents_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "contents_type", value)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']]:
        """
        [Required] Account credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs', 'SqlAdminDatastoreCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        [Required] Azure SQL database name.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[str]:
        """
        [Required] Azure cloud endpoint for the database.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="portNumber")
    def port_number(self) -> pulumi.Input[int]:
        """
        [Required] Azure SQL server port.
        """
        return pulumi.get(self, "port_number")

    @port_number.setter
    def port_number(self, value: pulumi.Input[int]):
        pulumi.set(self, "port_number", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        [Required] Azure SQL server name.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)


@pulumi.input_type
class BanditPolicyArgs:
    def __init__(__self__, *,
                 policy_type: pulumi.Input[str],
                 delay_evaluation: Optional[pulumi.Input[int]] = None,
                 evaluation_interval: Optional[pulumi.Input[int]] = None,
                 slack_amount: Optional[pulumi.Input[float]] = None,
                 slack_factor: Optional[pulumi.Input[float]] = None):
        """
        Defines an early termination policy based on slack criteria, and a frequency and delay interval for evaluation.
        :param pulumi.Input[str] policy_type: 
               Expected value is 'Bandit'.
        :param pulumi.Input[int] delay_evaluation: Number of intervals by which to delay the first evaluation.
        :param pulumi.Input[int] evaluation_interval: Interval (number of runs) between policy evaluations.
        :param pulumi.Input[float] slack_amount: Absolute distance allowed from the best performing run.
        :param pulumi.Input[float] slack_factor: Ratio of the allowed distance from the best performing run.
        """
        pulumi.set(__self__, "policy_type", 'Bandit')
        if delay_evaluation is not None:
            pulumi.set(__self__, "delay_evaluation", delay_evaluation)
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)
        if slack_amount is not None:
            pulumi.set(__self__, "slack_amount", slack_amount)
        if slack_factor is not None:
            pulumi.set(__self__, "slack_factor", slack_factor)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'Bandit'.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter(name="delayEvaluation")
    def delay_evaluation(self) -> Optional[pulumi.Input[int]]:
        """
        Number of intervals by which to delay the first evaluation.
        """
        return pulumi.get(self, "delay_evaluation")

    @delay_evaluation.setter
    def delay_evaluation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_evaluation", value)

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Interval (number of runs) between policy evaluations.
        """
        return pulumi.get(self, "evaluation_interval")

    @evaluation_interval.setter
    def evaluation_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "evaluation_interval", value)

    @property
    @pulumi.getter(name="slackAmount")
    def slack_amount(self) -> Optional[pulumi.Input[float]]:
        """
        Absolute distance allowed from the best performing run.
        """
        return pulumi.get(self, "slack_amount")

    @slack_amount.setter
    def slack_amount(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "slack_amount", value)

    @property
    @pulumi.getter(name="slackFactor")
    def slack_factor(self) -> Optional[pulumi.Input[float]]:
        """
        Ratio of the allowed distance from the best performing run.
        """
        return pulumi.get(self, "slack_factor")

    @slack_factor.setter
    def slack_factor(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "slack_factor", value)


@pulumi.input_type
class BatchDeploymentArgs:
    def __init__(__self__, *,
                 code_configuration: Optional[pulumi.Input['CodeConfigurationArgs']] = None,
                 compute: Optional[pulumi.Input['ComputeConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 error_threshold: Optional[pulumi.Input[int]] = None,
                 logging_level: Optional[pulumi.Input[Union[str, 'BatchLoggingLevel']]] = None,
                 mini_batch_size: Optional[pulumi.Input[float]] = None,
                 model: Optional[pulumi.Input[Union['DataPathAssetReferenceArgs', 'IdAssetReferenceArgs', 'OutputPathAssetReferenceArgs']]] = None,
                 output_configuration: Optional[pulumi.Input['BatchOutputConfigurationArgs']] = None,
                 partition_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 retry_settings: Optional[pulumi.Input['BatchRetrySettingsArgs']] = None):
        """
        Batch inference settings per deployment.
        :param pulumi.Input['CodeConfigurationArgs'] code_configuration: Code configuration for the endpoint deployment.
        :param pulumi.Input['ComputeConfigurationArgs'] compute: Configuration for compute binding.
        :param pulumi.Input[str] description: Description of the endpoint deployment.
        :param pulumi.Input[str] environment_id: ARM resource ID of the environment specification for the endpoint deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables configuration for the deployment.
        :param pulumi.Input[int] error_threshold: Error threshold, if the error count for the entire input goes above this value,
               the batch inference will be aborted. Range is [-1, int.MaxValue].
               For FileDataset, this value is the count of file failures.
               For TabularDataset, this value is the count of record failures.
               If set to -1 (the lower bound), all failures during batch inference will be ignored.
        :param pulumi.Input[Union[str, 'BatchLoggingLevel']] logging_level: Logging level for batch inference operation.
        :param pulumi.Input[float] mini_batch_size: Size of the mini-batch passed to each batch invocation.
               For FileDataset, this is the number of files per mini-batch.
               For TabularDataset, this is the size of the records in bytes, per mini-batch.
        :param pulumi.Input[Union['DataPathAssetReferenceArgs', 'IdAssetReferenceArgs', 'OutputPathAssetReferenceArgs']] model: Reference to the model asset for the endpoint deployment.
        :param pulumi.Input['BatchOutputConfigurationArgs'] output_configuration: Output configuration for the batch inference operation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] partition_keys: Partition keys list used for Named partitioning.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param pulumi.Input['BatchRetrySettingsArgs'] retry_settings: Retry Settings for the batch inference operation.
        """
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)
        if compute is not None:
            pulumi.set(__self__, "compute", compute)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if error_threshold is not None:
            pulumi.set(__self__, "error_threshold", error_threshold)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if mini_batch_size is not None:
            pulumi.set(__self__, "mini_batch_size", mini_batch_size)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if output_configuration is not None:
            pulumi.set(__self__, "output_configuration", output_configuration)
        if partition_keys is not None:
            pulumi.set(__self__, "partition_keys", partition_keys)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if retry_settings is not None:
            pulumi.set(__self__, "retry_settings", retry_settings)

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional[pulumi.Input['CodeConfigurationArgs']]:
        """
        Code configuration for the endpoint deployment.
        """
        return pulumi.get(self, "code_configuration")

    @code_configuration.setter
    def code_configuration(self, value: Optional[pulumi.Input['CodeConfigurationArgs']]):
        pulumi.set(self, "code_configuration", value)

    @property
    @pulumi.getter
    def compute(self) -> Optional[pulumi.Input['ComputeConfigurationArgs']]:
        """
        Configuration for compute binding.
        """
        return pulumi.get(self, "compute")

    @compute.setter
    def compute(self, value: Optional[pulumi.Input['ComputeConfigurationArgs']]):
        pulumi.set(self, "compute", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the endpoint deployment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the environment specification for the endpoint deployment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables configuration for the deployment.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="errorThreshold")
    def error_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Error threshold, if the error count for the entire input goes above this value,
        the batch inference will be aborted. Range is [-1, int.MaxValue].
        For FileDataset, this value is the count of file failures.
        For TabularDataset, this value is the count of record failures.
        If set to -1 (the lower bound), all failures during batch inference will be ignored.
        """
        return pulumi.get(self, "error_threshold")

    @error_threshold.setter
    def error_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "error_threshold", value)

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[pulumi.Input[Union[str, 'BatchLoggingLevel']]]:
        """
        Logging level for batch inference operation.
        """
        return pulumi.get(self, "logging_level")

    @logging_level.setter
    def logging_level(self, value: Optional[pulumi.Input[Union[str, 'BatchLoggingLevel']]]):
        pulumi.set(self, "logging_level", value)

    @property
    @pulumi.getter(name="miniBatchSize")
    def mini_batch_size(self) -> Optional[pulumi.Input[float]]:
        """
        Size of the mini-batch passed to each batch invocation.
        For FileDataset, this is the number of files per mini-batch.
        For TabularDataset, this is the size of the records in bytes, per mini-batch.
        """
        return pulumi.get(self, "mini_batch_size")

    @mini_batch_size.setter
    def mini_batch_size(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "mini_batch_size", value)

    @property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input[Union['DataPathAssetReferenceArgs', 'IdAssetReferenceArgs', 'OutputPathAssetReferenceArgs']]]:
        """
        Reference to the model asset for the endpoint deployment.
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input[Union['DataPathAssetReferenceArgs', 'IdAssetReferenceArgs', 'OutputPathAssetReferenceArgs']]]):
        pulumi.set(self, "model", value)

    @property
    @pulumi.getter(name="outputConfiguration")
    def output_configuration(self) -> Optional[pulumi.Input['BatchOutputConfigurationArgs']]:
        """
        Output configuration for the batch inference operation.
        """
        return pulumi.get(self, "output_configuration")

    @output_configuration.setter
    def output_configuration(self, value: Optional[pulumi.Input['BatchOutputConfigurationArgs']]):
        pulumi.set(self, "output_configuration", value)

    @property
    @pulumi.getter(name="partitionKeys")
    def partition_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Partition keys list used for Named partitioning.
        """
        return pulumi.get(self, "partition_keys")

    @partition_keys.setter
    def partition_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "partition_keys", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="retrySettings")
    def retry_settings(self) -> Optional[pulumi.Input['BatchRetrySettingsArgs']]:
        """
        Retry Settings for the batch inference operation.
        """
        return pulumi.get(self, "retry_settings")

    @retry_settings.setter
    def retry_settings(self, value: Optional[pulumi.Input['BatchRetrySettingsArgs']]):
        pulumi.set(self, "retry_settings", value)


@pulumi.input_type
class BatchEndpointArgs:
    def __init__(__self__, *,
                 auth_mode: Optional[pulumi.Input[Union[str, 'EndpointAuthMode']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 keys: Optional[pulumi.Input['EndpointAuthKeysArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 traffic: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]] = None):
        """
        Batch endpoint configuration.
        :param pulumi.Input[Union[str, 'EndpointAuthMode']] auth_mode: [Required] Inference endpoint authentication mode type
        :param pulumi.Input[str] description: Description of the inference endpoint.
        :param pulumi.Input['EndpointAuthKeysArgs'] keys: EndpointAuthKeys to set initially on an Endpoint.
               This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param pulumi.Input[Mapping[str, pulumi.Input[int]]] traffic: Traffic rules on how the traffic will be routed across deployments.
        """
        if auth_mode is not None:
            pulumi.set(__self__, "auth_mode", auth_mode)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if traffic is not None:
            pulumi.set(__self__, "traffic", traffic)

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> Optional[pulumi.Input[Union[str, 'EndpointAuthMode']]]:
        """
        [Required] Inference endpoint authentication mode type
        """
        return pulumi.get(self, "auth_mode")

    @auth_mode.setter
    def auth_mode(self, value: Optional[pulumi.Input[Union[str, 'EndpointAuthMode']]]):
        pulumi.set(self, "auth_mode", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the inference endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input['EndpointAuthKeysArgs']]:
        """
        EndpointAuthKeys to set initially on an Endpoint.
        This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input['EndpointAuthKeysArgs']]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def traffic(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]]:
        """
        Traffic rules on how the traffic will be routed across deployments.
        """
        return pulumi.get(self, "traffic")

    @traffic.setter
    def traffic(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]]):
        pulumi.set(self, "traffic", value)


@pulumi.input_type
class BatchOutputConfigurationArgs:
    def __init__(__self__, *,
                 append_row_file_name: Optional[pulumi.Input[str]] = None,
                 output_action: Optional[pulumi.Input[Union[str, 'BatchOutputAction']]] = None):
        """
        Batch inference output configuration.
        :param pulumi.Input[str] append_row_file_name: Customized output file name for append_row output action.
        :param pulumi.Input[Union[str, 'BatchOutputAction']] output_action: Indicates how the output will be organized.
        """
        if append_row_file_name is not None:
            pulumi.set(__self__, "append_row_file_name", append_row_file_name)
        if output_action is not None:
            pulumi.set(__self__, "output_action", output_action)

    @property
    @pulumi.getter(name="appendRowFileName")
    def append_row_file_name(self) -> Optional[pulumi.Input[str]]:
        """
        Customized output file name for append_row output action.
        """
        return pulumi.get(self, "append_row_file_name")

    @append_row_file_name.setter
    def append_row_file_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "append_row_file_name", value)

    @property
    @pulumi.getter(name="outputAction")
    def output_action(self) -> Optional[pulumi.Input[Union[str, 'BatchOutputAction']]]:
        """
        Indicates how the output will be organized.
        """
        return pulumi.get(self, "output_action")

    @output_action.setter
    def output_action(self, value: Optional[pulumi.Input[Union[str, 'BatchOutputAction']]]):
        pulumi.set(self, "output_action", value)


@pulumi.input_type
class BatchRetrySettingsArgs:
    def __init__(__self__, *,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        Retry settings for a batch inference operation.
        :param pulumi.Input[int] max_retries: Maximum retry count for a mini-batch
        :param pulumi.Input[str] timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
        """
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum retry count for a mini-batch
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Invocation timeout for a mini-batch, in ISO 8601 format.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class CertificateDatastoreCredentialsArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[str],
                 credentials_type: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 thumbprint: pulumi.Input[str],
                 authority_url: Optional[pulumi.Input[str]] = None,
                 resource_uri: Optional[pulumi.Input[str]] = None,
                 secrets: Optional[pulumi.Input['CertificateDatastoreSecretsArgs']] = None):
        """
        Certificate datastore credentials configuration.
        :param pulumi.Input[str] client_id: [Required] Service principal client ID.
        :param pulumi.Input[str] credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'Certificate'.
        :param pulumi.Input[str] tenant_id: [Required] ID of the tenant to which the service principal belongs.
        :param pulumi.Input[str] thumbprint: [Required] Thumbprint of the certificate used for authentication.
        :param pulumi.Input[str] authority_url: Authority URL used for authentication.
        :param pulumi.Input[str] resource_uri: Resource the service principal has access to.
        :param pulumi.Input['CertificateDatastoreSecretsArgs'] secrets: Service principal secrets.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "credentials_type", 'Certificate')
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "thumbprint", thumbprint)
        if authority_url is not None:
            pulumi.set(__self__, "authority_url", authority_url)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        [Required] Service principal client ID.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'Certificate'.
        """
        return pulumi.get(self, "credentials_type")

    @credentials_type.setter
    def credentials_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credentials_type", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        [Required] ID of the tenant to which the service principal belongs.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Input[str]:
        """
        [Required] Thumbprint of the certificate used for authentication.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: pulumi.Input[str]):
        pulumi.set(self, "thumbprint", value)

    @property
    @pulumi.getter(name="authorityUrl")
    def authority_url(self) -> Optional[pulumi.Input[str]]:
        """
        Authority URL used for authentication.
        """
        return pulumi.get(self, "authority_url")

    @authority_url.setter
    def authority_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authority_url", value)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Resource the service principal has access to.
        """
        return pulumi.get(self, "resource_uri")

    @resource_uri.setter
    def resource_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_uri", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input['CertificateDatastoreSecretsArgs']]:
        """
        Service principal secrets.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input['CertificateDatastoreSecretsArgs']]):
        pulumi.set(self, "secrets", value)


@pulumi.input_type
class CertificateDatastoreSecretsArgs:
    def __init__(__self__, *,
                 secrets_type: pulumi.Input[str],
                 certificate: Optional[pulumi.Input[str]] = None):
        """
        Datastore certificate secrets.
        :param pulumi.Input[str] secrets_type: Enum to determine the datastore secrets type.
               Expected value is 'Certificate'.
        :param pulumi.Input[str] certificate: Service principal certificate.
        """
        pulumi.set(__self__, "secrets_type", 'Certificate')
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)

    @property
    @pulumi.getter(name="secretsType")
    def secrets_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore secrets type.
        Expected value is 'Certificate'.
        """
        return pulumi.get(self, "secrets_type")

    @secrets_type.setter
    def secrets_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "secrets_type", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Service principal certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)


@pulumi.input_type
class CodeConfigurationArgs:
    def __init__(__self__, *,
                 scoring_script: pulumi.Input[str],
                 code_id: Optional[pulumi.Input[str]] = None):
        """
        Configuration for a scoring code asset.
        :param pulumi.Input[str] scoring_script: [Required] The script to execute on startup. eg. "score.py"
        :param pulumi.Input[str] code_id: ARM resource ID of the code asset.
        """
        pulumi.set(__self__, "scoring_script", scoring_script)
        if code_id is not None:
            pulumi.set(__self__, "code_id", code_id)

    @property
    @pulumi.getter(name="scoringScript")
    def scoring_script(self) -> pulumi.Input[str]:
        """
        [Required] The script to execute on startup. eg. "score.py"
        """
        return pulumi.get(self, "scoring_script")

    @scoring_script.setter
    def scoring_script(self, value: pulumi.Input[str]):
        pulumi.set(self, "scoring_script", value)

    @property
    @pulumi.getter(name="codeId")
    def code_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the code asset.
        """
        return pulumi.get(self, "code_id")

    @code_id.setter
    def code_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_id", value)


@pulumi.input_type
class CodeContainerArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Container for code asset versions.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class CodeVersionArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 datastore_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_anonymous: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Code asset version details.
        :param pulumi.Input[str] path: [Required] The path of the file/directory in the datastore.
        :param pulumi.Input[str] datastore_id: ARM resource ID of the datastore where the asset is located.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[bool] is_anonymous: If the name version are system generated (anonymous registration).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "path", path)
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        [Required] The path of the file/directory in the datastore.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the datastore where the asset is located.
        """
        return pulumi.get(self, "datastore_id")

    @datastore_id.setter
    def datastore_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datastore_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[pulumi.Input[bool]]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @is_anonymous.setter
    def is_anonymous(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_anonymous", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class CommandJobArgs:
    def __init__(__self__, *,
                 command: pulumi.Input[str],
                 compute: pulumi.Input['ComputeConfigurationArgs'],
                 job_type: pulumi.Input[str],
                 code_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 distribution: Optional[pulumi.Input[Union['MpiArgs', 'PyTorchArgs', 'TensorFlowArgs']]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 experiment_name: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs']]] = None,
                 input_data_bindings: Optional[pulumi.Input[Mapping[str, pulumi.Input['InputDataBindingArgs']]]] = None,
                 output_data_bindings: Optional[pulumi.Input[Mapping[str, pulumi.Input['OutputDataBindingArgs']]]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        Command job definition.
        :param pulumi.Input[str] command: [Required] The command to execute on startup of the job. eg. "python train.py"
        :param pulumi.Input['ComputeConfigurationArgs'] compute: [Required] Compute binding for the job.
        :param pulumi.Input[str] job_type: Enum to determine the type of job.
               Expected value is 'Command'.
        :param pulumi.Input[str] code_id: ARM resource ID of the code asset.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[Union['MpiArgs', 'PyTorchArgs', 'TensorFlowArgs']] distribution: Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        :param pulumi.Input[str] environment_id: The ARM resource ID of the Environment specification for the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables included in the job.
        :param pulumi.Input[str] experiment_name: The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        :param pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs']] identity: Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, or null.
               Defaults to AmlToken if null.
        :param pulumi.Input[Mapping[str, pulumi.Input['InputDataBindingArgs']]] input_data_bindings: Mapping of input data bindings used in the job.
        :param pulumi.Input[Mapping[str, pulumi.Input['OutputDataBindingArgs']]] output_data_bindings: Mapping of output data bindings used in the job.
        :param pulumi.Input[int] priority: Job priority for scheduling policy. Only applies to AMLCompute.
               Private preview feature and only available to users on the allow list.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        :param pulumi.Input[str] timeout: The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
        """
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "compute", compute)
        pulumi.set(__self__, "job_type", 'Command')
        if code_id is not None:
            pulumi.set(__self__, "code_id", code_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if experiment_name is not None:
            pulumi.set(__self__, "experiment_name", experiment_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if input_data_bindings is not None:
            pulumi.set(__self__, "input_data_bindings", input_data_bindings)
        if output_data_bindings is not None:
            pulumi.set(__self__, "output_data_bindings", output_data_bindings)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def command(self) -> pulumi.Input[str]:
        """
        [Required] The command to execute on startup of the job. eg. "python train.py"
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: pulumi.Input[str]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter
    def compute(self) -> pulumi.Input['ComputeConfigurationArgs']:
        """
        [Required] Compute binding for the job.
        """
        return pulumi.get(self, "compute")

    @compute.setter
    def compute(self, value: pulumi.Input['ComputeConfigurationArgs']):
        pulumi.set(self, "compute", value)

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the type of job.
        Expected value is 'Command'.
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_type", value)

    @property
    @pulumi.getter(name="codeId")
    def code_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the code asset.
        """
        return pulumi.get(self, "code_id")

    @code_id.setter
    def code_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def distribution(self) -> Optional[pulumi.Input[Union['MpiArgs', 'PyTorchArgs', 'TensorFlowArgs']]]:
        """
        Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        """
        return pulumi.get(self, "distribution")

    @distribution.setter
    def distribution(self, value: Optional[pulumi.Input[Union['MpiArgs', 'PyTorchArgs', 'TensorFlowArgs']]]):
        pulumi.set(self, "distribution", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARM resource ID of the Environment specification for the job.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables included in the job.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="experimentName")
    def experiment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        """
        return pulumi.get(self, "experiment_name")

    @experiment_name.setter
    def experiment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "experiment_name", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs']]]:
        """
        Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, or null.
        Defaults to AmlToken if null.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs']]]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="inputDataBindings")
    def input_data_bindings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['InputDataBindingArgs']]]]:
        """
        Mapping of input data bindings used in the job.
        """
        return pulumi.get(self, "input_data_bindings")

    @input_data_bindings.setter
    def input_data_bindings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['InputDataBindingArgs']]]]):
        pulumi.set(self, "input_data_bindings", value)

    @property
    @pulumi.getter(name="outputDataBindings")
    def output_data_bindings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['OutputDataBindingArgs']]]]:
        """
        Mapping of output data bindings used in the job.
        """
        return pulumi.get(self, "output_data_bindings")

    @output_data_bindings.setter
    def output_data_bindings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['OutputDataBindingArgs']]]]):
        pulumi.set(self, "output_data_bindings", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Job priority for scheduling policy. Only applies to AMLCompute.
        Private preview feature and only available to users on the allow list.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class ComputeConfigurationArgs:
    def __init__(__self__, *,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 is_local: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target: Optional[pulumi.Input[str]] = None):
        """
        Configuration for compute binding.
        :param pulumi.Input[int] instance_count: Number of instances or nodes.
        :param pulumi.Input[str] instance_type: SKU type to run on.
        :param pulumi.Input[bool] is_local: Set to true for jobs running on local compute.
        :param pulumi.Input[str] location: Location for virtual cluster run.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Additional properties.
        :param pulumi.Input[str] target: ARM resource ID of the Compute you are targeting. If not provided the resource will be deployed as Managed.
        """
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if is_local is not None:
            pulumi.set(__self__, "is_local", is_local)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of instances or nodes.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        SKU type to run on.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="isLocal")
    def is_local(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true for jobs running on local compute.
        """
        return pulumi.get(self, "is_local")

    @is_local.setter
    def is_local(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_local", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for virtual cluster run.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the Compute you are targeting. If not provided the resource will be deployed as Managed.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class ComputeInstancePropertiesArgs:
    def __init__(__self__, *,
                 application_sharing_policy: Optional[pulumi.Input[Union[str, 'ApplicationSharingPolicy']]] = None,
                 compute_instance_authorization_type: Optional[pulumi.Input[Union[str, 'ComputeInstanceAuthorizationType']]] = None,
                 enable_node_public_ip: Optional[pulumi.Input[bool]] = None,
                 personal_compute_instance_settings: Optional[pulumi.Input['PersonalComputeInstanceSettingsArgs']] = None,
                 schedules: Optional[pulumi.Input['ComputeSchedulesArgs']] = None,
                 setup_scripts: Optional[pulumi.Input['SetupScriptsArgs']] = None,
                 ssh_settings: Optional[pulumi.Input['ComputeInstanceSshSettingsArgs']] = None,
                 subnet: Optional[pulumi.Input['ResourceIdArgs']] = None,
                 vm_size: Optional[pulumi.Input[str]] = None):
        """
        Compute Instance properties
        :param pulumi.Input[Union[str, 'ApplicationSharingPolicy']] application_sharing_policy: Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
        :param pulumi.Input[Union[str, 'ComputeInstanceAuthorizationType']] compute_instance_authorization_type: The Compute Instance Authorization type. Available values are personal (default).
        :param pulumi.Input[bool] enable_node_public_ip: Enable or disable node public IP address provisioning. Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        :param pulumi.Input['PersonalComputeInstanceSettingsArgs'] personal_compute_instance_settings: Settings for a personal compute instance.
        :param pulumi.Input['ComputeSchedulesArgs'] schedules: The list of schedules to be applied on the compute instance.
        :param pulumi.Input['SetupScriptsArgs'] setup_scripts: Details of customized scripts to execute for setting up the cluster.
        :param pulumi.Input['ComputeInstanceSshSettingsArgs'] ssh_settings: Specifies policy and settings for SSH access.
        :param pulumi.Input['ResourceIdArgs'] subnet: Virtual network subnet resource ID the compute nodes belong to.
        :param pulumi.Input[str] vm_size: Virtual Machine Size
        """
        if application_sharing_policy is None:
            application_sharing_policy = 'Shared'
        if application_sharing_policy is not None:
            pulumi.set(__self__, "application_sharing_policy", application_sharing_policy)
        if compute_instance_authorization_type is None:
            compute_instance_authorization_type = 'personal'
        if compute_instance_authorization_type is not None:
            pulumi.set(__self__, "compute_instance_authorization_type", compute_instance_authorization_type)
        if enable_node_public_ip is None:
            enable_node_public_ip = True
        if enable_node_public_ip is not None:
            pulumi.set(__self__, "enable_node_public_ip", enable_node_public_ip)
        if personal_compute_instance_settings is not None:
            pulumi.set(__self__, "personal_compute_instance_settings", personal_compute_instance_settings)
        if schedules is not None:
            pulumi.set(__self__, "schedules", schedules)
        if setup_scripts is not None:
            pulumi.set(__self__, "setup_scripts", setup_scripts)
        if ssh_settings is not None:
            pulumi.set(__self__, "ssh_settings", ssh_settings)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="applicationSharingPolicy")
    def application_sharing_policy(self) -> Optional[pulumi.Input[Union[str, 'ApplicationSharingPolicy']]]:
        """
        Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
        """
        return pulumi.get(self, "application_sharing_policy")

    @application_sharing_policy.setter
    def application_sharing_policy(self, value: Optional[pulumi.Input[Union[str, 'ApplicationSharingPolicy']]]):
        pulumi.set(self, "application_sharing_policy", value)

    @property
    @pulumi.getter(name="computeInstanceAuthorizationType")
    def compute_instance_authorization_type(self) -> Optional[pulumi.Input[Union[str, 'ComputeInstanceAuthorizationType']]]:
        """
        The Compute Instance Authorization type. Available values are personal (default).
        """
        return pulumi.get(self, "compute_instance_authorization_type")

    @compute_instance_authorization_type.setter
    def compute_instance_authorization_type(self, value: Optional[pulumi.Input[Union[str, 'ComputeInstanceAuthorizationType']]]):
        pulumi.set(self, "compute_instance_authorization_type", value)

    @property
    @pulumi.getter(name="enableNodePublicIp")
    def enable_node_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable node public IP address provisioning. Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        """
        return pulumi.get(self, "enable_node_public_ip")

    @enable_node_public_ip.setter
    def enable_node_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_node_public_ip", value)

    @property
    @pulumi.getter(name="personalComputeInstanceSettings")
    def personal_compute_instance_settings(self) -> Optional[pulumi.Input['PersonalComputeInstanceSettingsArgs']]:
        """
        Settings for a personal compute instance.
        """
        return pulumi.get(self, "personal_compute_instance_settings")

    @personal_compute_instance_settings.setter
    def personal_compute_instance_settings(self, value: Optional[pulumi.Input['PersonalComputeInstanceSettingsArgs']]):
        pulumi.set(self, "personal_compute_instance_settings", value)

    @property
    @pulumi.getter
    def schedules(self) -> Optional[pulumi.Input['ComputeSchedulesArgs']]:
        """
        The list of schedules to be applied on the compute instance.
        """
        return pulumi.get(self, "schedules")

    @schedules.setter
    def schedules(self, value: Optional[pulumi.Input['ComputeSchedulesArgs']]):
        pulumi.set(self, "schedules", value)

    @property
    @pulumi.getter(name="setupScripts")
    def setup_scripts(self) -> Optional[pulumi.Input['SetupScriptsArgs']]:
        """
        Details of customized scripts to execute for setting up the cluster.
        """
        return pulumi.get(self, "setup_scripts")

    @setup_scripts.setter
    def setup_scripts(self, value: Optional[pulumi.Input['SetupScriptsArgs']]):
        pulumi.set(self, "setup_scripts", value)

    @property
    @pulumi.getter(name="sshSettings")
    def ssh_settings(self) -> Optional[pulumi.Input['ComputeInstanceSshSettingsArgs']]:
        """
        Specifies policy and settings for SSH access.
        """
        return pulumi.get(self, "ssh_settings")

    @ssh_settings.setter
    def ssh_settings(self, value: Optional[pulumi.Input['ComputeInstanceSshSettingsArgs']]):
        pulumi.set(self, "ssh_settings", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['ResourceIdArgs']]:
        """
        Virtual network subnet resource ID the compute nodes belong to.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['ResourceIdArgs']]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual Machine Size
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_size", value)


@pulumi.input_type
class ComputeInstanceSshSettingsArgs:
    def __init__(__self__, *,
                 admin_public_key: Optional[pulumi.Input[str]] = None,
                 ssh_public_access: Optional[pulumi.Input[Union[str, 'SshPublicAccess']]] = None):
        """
        Specifies policy and settings for SSH access.
        :param pulumi.Input[str] admin_public_key: Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
        :param pulumi.Input[Union[str, 'SshPublicAccess']] ssh_public_access: State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
        """
        if admin_public_key is not None:
            pulumi.set(__self__, "admin_public_key", admin_public_key)
        if ssh_public_access is None:
            ssh_public_access = 'Disabled'
        if ssh_public_access is not None:
            pulumi.set(__self__, "ssh_public_access", ssh_public_access)

    @property
    @pulumi.getter(name="adminPublicKey")
    def admin_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
        """
        return pulumi.get(self, "admin_public_key")

    @admin_public_key.setter
    def admin_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_public_key", value)

    @property
    @pulumi.getter(name="sshPublicAccess")
    def ssh_public_access(self) -> Optional[pulumi.Input[Union[str, 'SshPublicAccess']]]:
        """
        State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
        """
        return pulumi.get(self, "ssh_public_access")

    @ssh_public_access.setter
    def ssh_public_access(self, value: Optional[pulumi.Input[Union[str, 'SshPublicAccess']]]):
        pulumi.set(self, "ssh_public_access", value)


@pulumi.input_type
class ComputeInstanceArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['ComputeInstancePropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        An Azure Machine Learning compute instance.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'ComputeInstance'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input['ComputeInstancePropertiesArgs'] properties: Compute Instance properties
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'ComputeInstance')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'ComputeInstance'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['ComputeInstancePropertiesArgs']]:
        """
        Compute Instance properties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['ComputeInstancePropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class ComputeSchedulesArgs:
    def __init__(__self__, *,
                 compute_start_stop: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeStartStopScheduleArgs']]]] = None):
        """
        The list of schedules to be applied on the computes
        :param pulumi.Input[Sequence[pulumi.Input['ComputeStartStopScheduleArgs']]] compute_start_stop: The list of compute start stop schedules to be applied.
        """
        if compute_start_stop is not None:
            pulumi.set(__self__, "compute_start_stop", compute_start_stop)

    @property
    @pulumi.getter(name="computeStartStop")
    def compute_start_stop(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeStartStopScheduleArgs']]]]:
        """
        The list of compute start stop schedules to be applied.
        """
        return pulumi.get(self, "compute_start_stop")

    @compute_start_stop.setter
    def compute_start_stop(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeStartStopScheduleArgs']]]]):
        pulumi.set(self, "compute_start_stop", value)


@pulumi.input_type
class ComputeStartStopScheduleArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[Union[str, 'ComputePowerAction']]] = None,
                 cron: Optional[pulumi.Input['CronArgs']] = None,
                 recurrence: Optional[pulumi.Input['RecurrenceArgs']] = None,
                 status: Optional[pulumi.Input[Union[str, 'ScheduleStatus']]] = None,
                 trigger_type: Optional[pulumi.Input[Union[str, 'TriggerType']]] = None):
        """
        Compute start stop schedule properties
        :param pulumi.Input[Union[str, 'ComputePowerAction']] action: The compute power action.
        :param pulumi.Input['CronArgs'] cron: The workflow trigger cron for ComputeStartStop schedule type.
        :param pulumi.Input['RecurrenceArgs'] recurrence: The workflow trigger recurrence for ComputeStartStop schedule type.
        :param pulumi.Input[Union[str, 'ScheduleStatus']] status: The schedule status.
        :param pulumi.Input[Union[str, 'TriggerType']] trigger_type: The schedule trigger type.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if cron is not None:
            pulumi.set(__self__, "cron", cron)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if trigger_type is not None:
            pulumi.set(__self__, "trigger_type", trigger_type)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[Union[str, 'ComputePowerAction']]]:
        """
        The compute power action.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[Union[str, 'ComputePowerAction']]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def cron(self) -> Optional[pulumi.Input['CronArgs']]:
        """
        The workflow trigger cron for ComputeStartStop schedule type.
        """
        return pulumi.get(self, "cron")

    @cron.setter
    def cron(self, value: Optional[pulumi.Input['CronArgs']]):
        pulumi.set(self, "cron", value)

    @property
    @pulumi.getter
    def recurrence(self) -> Optional[pulumi.Input['RecurrenceArgs']]:
        """
        The workflow trigger recurrence for ComputeStartStop schedule type.
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: Optional[pulumi.Input['RecurrenceArgs']]):
        pulumi.set(self, "recurrence", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'ScheduleStatus']]]:
        """
        The schedule status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'ScheduleStatus']]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> Optional[pulumi.Input[Union[str, 'TriggerType']]]:
        """
        The schedule trigger type.
        """
        return pulumi.get(self, "trigger_type")

    @trigger_type.setter
    def trigger_type(self, value: Optional[pulumi.Input[Union[str, 'TriggerType']]]):
        pulumi.set(self, "trigger_type", value)


@pulumi.input_type
class ContainerResourceRequirementsArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input[float]] = None,
                 cpu_limit: Optional[pulumi.Input[float]] = None,
                 fpga: Optional[pulumi.Input[int]] = None,
                 gpu: Optional[pulumi.Input[int]] = None,
                 memory_in_gb: Optional[pulumi.Input[float]] = None,
                 memory_in_gb_limit: Optional[pulumi.Input[float]] = None):
        """
        The resource requirements for the container (cpu and memory).
        :param pulumi.Input[float] cpu: The minimum amount of CPU cores to be used by the container. More info:
               https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        :param pulumi.Input[float] cpu_limit: The maximum amount of CPU cores allowed to be used by the container. More info:
               https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        :param pulumi.Input[int] fpga: The number of FPGA PCIE devices exposed to the container. Must be multiple of 2.
        :param pulumi.Input[int] gpu: The number of GPU cores in the container.
        :param pulumi.Input[float] memory_in_gb: The minimum amount of memory (in GB) to be used by the container. More info:
               https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        :param pulumi.Input[float] memory_in_gb_limit: The maximum amount of memory (in GB) allowed to be used by the container. More info:
               https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if cpu_limit is not None:
            pulumi.set(__self__, "cpu_limit", cpu_limit)
        if fpga is not None:
            pulumi.set(__self__, "fpga", fpga)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if memory_in_gb is not None:
            pulumi.set(__self__, "memory_in_gb", memory_in_gb)
        if memory_in_gb_limit is not None:
            pulumi.set(__self__, "memory_in_gb_limit", memory_in_gb_limit)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        The minimum amount of CPU cores to be used by the container. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum amount of CPU cores allowed to be used by the container. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        return pulumi.get(self, "cpu_limit")

    @cpu_limit.setter
    def cpu_limit(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu_limit", value)

    @property
    @pulumi.getter
    def fpga(self) -> Optional[pulumi.Input[int]]:
        """
        The number of FPGA PCIE devices exposed to the container. Must be multiple of 2.
        """
        return pulumi.get(self, "fpga")

    @fpga.setter
    def fpga(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fpga", value)

    @property
    @pulumi.getter
    def gpu(self) -> Optional[pulumi.Input[int]]:
        """
        The number of GPU cores in the container.
        """
        return pulumi.get(self, "gpu")

    @gpu.setter
    def gpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gpu", value)

    @property
    @pulumi.getter(name="memoryInGB")
    def memory_in_gb(self) -> Optional[pulumi.Input[float]]:
        """
        The minimum amount of memory (in GB) to be used by the container. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        return pulumi.get(self, "memory_in_gb")

    @memory_in_gb.setter
    def memory_in_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_in_gb", value)

    @property
    @pulumi.getter(name="memoryInGBLimit")
    def memory_in_gb_limit(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum amount of memory (in GB) allowed to be used by the container. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        return pulumi.get(self, "memory_in_gb_limit")

    @memory_in_gb_limit.setter
    def memory_in_gb_limit(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_in_gb_limit", value)


@pulumi.input_type
class CosmosDbSettingsArgs:
    def __init__(__self__, *,
                 collections_throughput: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] collections_throughput: The throughput of the collections in cosmosdb database
        """
        if collections_throughput is not None:
            pulumi.set(__self__, "collections_throughput", collections_throughput)

    @property
    @pulumi.getter(name="collectionsThroughput")
    def collections_throughput(self) -> Optional[pulumi.Input[int]]:
        """
        The throughput of the collections in cosmosdb database
        """
        return pulumi.get(self, "collections_throughput")

    @collections_throughput.setter
    def collections_throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "collections_throughput", value)


@pulumi.input_type
class CronArgs:
    def __init__(__self__, *,
                 expression: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        The workflow trigger cron for ComputeStartStop schedule type.
        :param pulumi.Input[str] expression: The cron expression.
        :param pulumi.Input[str] start_time: The start time.
        :param pulumi.Input[str] time_zone: The time zone.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        The cron expression.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The start time.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class DataContainerArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Container for data asset versions.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class DataFactoryArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A DataFactory compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'DataFactory'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'DataFactory')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'DataFactory'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class DataLakeAnalyticsPropertiesArgs:
    def __init__(__self__, *,
                 data_lake_store_account_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] data_lake_store_account_name: DataLake Store Account Name
        """
        if data_lake_store_account_name is not None:
            pulumi.set(__self__, "data_lake_store_account_name", data_lake_store_account_name)

    @property
    @pulumi.getter(name="dataLakeStoreAccountName")
    def data_lake_store_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        DataLake Store Account Name
        """
        return pulumi.get(self, "data_lake_store_account_name")

    @data_lake_store_account_name.setter
    def data_lake_store_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_lake_store_account_name", value)


@pulumi.input_type
class DataLakeAnalyticsArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['DataLakeAnalyticsPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A DataLakeAnalytics compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'DataLakeAnalytics'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'DataLakeAnalytics')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'DataLakeAnalytics'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['DataLakeAnalyticsPropertiesArgs']]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['DataLakeAnalyticsPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class DataPathAssetReferenceArgs:
    def __init__(__self__, *,
                 reference_type: pulumi.Input[str],
                 datastore_id: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        Reference to an asset via its path in a datastore.
        :param pulumi.Input[str] reference_type: Enum to determine which reference method to use for an asset.
               Expected value is 'DataPath'.
        :param pulumi.Input[str] datastore_id: ARM resource ID of the datastore where the asset is located.
        :param pulumi.Input[str] path: The path of the file/directory in the datastore.
        """
        pulumi.set(__self__, "reference_type", 'DataPath')
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="referenceType")
    def reference_type(self) -> pulumi.Input[str]:
        """
        Enum to determine which reference method to use for an asset.
        Expected value is 'DataPath'.
        """
        return pulumi.get(self, "reference_type")

    @reference_type.setter
    def reference_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "reference_type", value)

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the datastore where the asset is located.
        """
        return pulumi.get(self, "datastore_id")

    @datastore_id.setter
    def datastore_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datastore_id", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path of the file/directory in the datastore.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class DataVersionArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 dataset_type: Optional[pulumi.Input[Union[str, 'DatasetType']]] = None,
                 datastore_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_anonymous: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Data asset version details.
        :param pulumi.Input[str] path: [Required] The path of the file/directory in the datastore.
        :param pulumi.Input[Union[str, 'DatasetType']] dataset_type: The Format of dataset.
        :param pulumi.Input[str] datastore_id: ARM resource ID of the datastore where the asset is located.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[bool] is_anonymous: If the name version are system generated (anonymous registration).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "path", path)
        if dataset_type is not None:
            pulumi.set(__self__, "dataset_type", dataset_type)
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        [Required] The path of the file/directory in the datastore.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> Optional[pulumi.Input[Union[str, 'DatasetType']]]:
        """
        The Format of dataset.
        """
        return pulumi.get(self, "dataset_type")

    @dataset_type.setter
    def dataset_type(self, value: Optional[pulumi.Input[Union[str, 'DatasetType']]]):
        pulumi.set(self, "dataset_type", value)

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the datastore where the asset is located.
        """
        return pulumi.get(self, "datastore_id")

    @datastore_id.setter
    def datastore_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datastore_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[pulumi.Input[bool]]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @is_anonymous.setter
    def is_anonymous(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_anonymous", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class DatabricksPropertiesArgs:
    def __init__(__self__, *,
                 databricks_access_token: Optional[pulumi.Input[str]] = None,
                 workspace_url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] databricks_access_token: Databricks access token
        :param pulumi.Input[str] workspace_url: Workspace Url
        """
        if databricks_access_token is not None:
            pulumi.set(__self__, "databricks_access_token", databricks_access_token)
        if workspace_url is not None:
            pulumi.set(__self__, "workspace_url", workspace_url)

    @property
    @pulumi.getter(name="databricksAccessToken")
    def databricks_access_token(self) -> Optional[pulumi.Input[str]]:
        """
        Databricks access token
        """
        return pulumi.get(self, "databricks_access_token")

    @databricks_access_token.setter
    def databricks_access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "databricks_access_token", value)

    @property
    @pulumi.getter(name="workspaceUrl")
    def workspace_url(self) -> Optional[pulumi.Input[str]]:
        """
        Workspace Url
        """
        return pulumi.get(self, "workspace_url")

    @workspace_url.setter
    def workspace_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_url", value)


@pulumi.input_type
class DatabricksArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['DatabricksPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A DataFactory compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'Databricks'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'Databricks')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'Databricks'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['DatabricksPropertiesArgs']]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['DatabricksPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class DatastorePropertiesArgs:
    def __init__(__self__, *,
                 contents: pulumi.Input[Union['AzureBlobContentsArgs', 'AzureDataLakeGen1ContentsArgs', 'AzureDataLakeGen2ContentsArgs', 'AzureFileContentsArgs', 'AzurePostgreSqlContentsArgs', 'AzureSqlDatabaseContentsArgs', 'GlusterFsContentsArgs']],
                 description: Optional[pulumi.Input[str]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 linked_info: Optional[pulumi.Input['LinkedInfoArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Datastore definition.
        :param pulumi.Input[Union['AzureBlobContentsArgs', 'AzureDataLakeGen1ContentsArgs', 'AzureDataLakeGen2ContentsArgs', 'AzureFileContentsArgs', 'AzurePostgreSqlContentsArgs', 'AzureSqlDatabaseContentsArgs', 'GlusterFsContentsArgs']] contents: [Required] Reference to the datastore storage contents.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[bool] is_default: Whether this datastore is the default for the workspace.
        :param pulumi.Input['LinkedInfoArgs'] linked_info: Information about the datastore origin, if linked.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "contents", contents)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if linked_info is not None:
            pulumi.set(__self__, "linked_info", linked_info)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def contents(self) -> pulumi.Input[Union['AzureBlobContentsArgs', 'AzureDataLakeGen1ContentsArgs', 'AzureDataLakeGen2ContentsArgs', 'AzureFileContentsArgs', 'AzurePostgreSqlContentsArgs', 'AzureSqlDatabaseContentsArgs', 'GlusterFsContentsArgs']]:
        """
        [Required] Reference to the datastore storage contents.
        """
        return pulumi.get(self, "contents")

    @contents.setter
    def contents(self, value: pulumi.Input[Union['AzureBlobContentsArgs', 'AzureDataLakeGen1ContentsArgs', 'AzureDataLakeGen2ContentsArgs', 'AzureFileContentsArgs', 'AzurePostgreSqlContentsArgs', 'AzureSqlDatabaseContentsArgs', 'GlusterFsContentsArgs']]):
        pulumi.set(self, "contents", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this datastore is the default for the workspace.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter(name="linkedInfo")
    def linked_info(self) -> Optional[pulumi.Input['LinkedInfoArgs']]:
        """
        Information about the datastore origin, if linked.
        """
        return pulumi.get(self, "linked_info")

    @linked_info.setter
    def linked_info(self, value: Optional[pulumi.Input['LinkedInfoArgs']]):
        pulumi.set(self, "linked_info", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class DockerBuildArgs:
    def __init__(__self__, *,
                 docker_specification_type: pulumi.Input[str],
                 dockerfile: pulumi.Input[str],
                 context: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input['DockerImagePlatformArgs']] = None):
        """
        Class to represent configuration settings for Docker Build
        :param pulumi.Input[str] docker_specification_type: Enum to determine docker specification type. Must be either Build or Image.
               Expected value is 'Build'.
        :param pulumi.Input[str] dockerfile: [Required] Docker command line instructions to assemble an image.
               <seealso href="https://repo2docker.readthedocs.io/en/latest/config_files.html#dockerfile-advanced-environments" />
        :param pulumi.Input[str] context: Path to a snapshot of the Docker Context. This property is only valid if Dockerfile is specified.
               The path is relative to the asset path which must contain a single Blob URI value.
               <seealso href="https://docs.docker.com/engine/context/working-with-contexts/" />
        :param pulumi.Input['DockerImagePlatformArgs'] platform: The platform information of the docker image.
        """
        pulumi.set(__self__, "docker_specification_type", 'Build')
        pulumi.set(__self__, "dockerfile", dockerfile)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)

    @property
    @pulumi.getter(name="dockerSpecificationType")
    def docker_specification_type(self) -> pulumi.Input[str]:
        """
        Enum to determine docker specification type. Must be either Build or Image.
        Expected value is 'Build'.
        """
        return pulumi.get(self, "docker_specification_type")

    @docker_specification_type.setter
    def docker_specification_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "docker_specification_type", value)

    @property
    @pulumi.getter
    def dockerfile(self) -> pulumi.Input[str]:
        """
        [Required] Docker command line instructions to assemble an image.
        <seealso href="https://repo2docker.readthedocs.io/en/latest/config_files.html#dockerfile-advanced-environments" />
        """
        return pulumi.get(self, "dockerfile")

    @dockerfile.setter
    def dockerfile(self, value: pulumi.Input[str]):
        pulumi.set(self, "dockerfile", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[str]]:
        """
        Path to a snapshot of the Docker Context. This property is only valid if Dockerfile is specified.
        The path is relative to the asset path which must contain a single Blob URI value.
        <seealso href="https://docs.docker.com/engine/context/working-with-contexts/" />
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input['DockerImagePlatformArgs']]:
        """
        The platform information of the docker image.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input['DockerImagePlatformArgs']]):
        pulumi.set(self, "platform", value)


@pulumi.input_type
class DockerImagePlatformArgs:
    def __init__(__self__, *,
                 operating_system_type: Optional[pulumi.Input[Union[str, 'OperatingSystemType']]] = None):
        """
        :param pulumi.Input[Union[str, 'OperatingSystemType']] operating_system_type: The OS type the Environment.
        """
        if operating_system_type is not None:
            pulumi.set(__self__, "operating_system_type", operating_system_type)

    @property
    @pulumi.getter(name="operatingSystemType")
    def operating_system_type(self) -> Optional[pulumi.Input[Union[str, 'OperatingSystemType']]]:
        """
        The OS type the Environment.
        """
        return pulumi.get(self, "operating_system_type")

    @operating_system_type.setter
    def operating_system_type(self, value: Optional[pulumi.Input[Union[str, 'OperatingSystemType']]]):
        pulumi.set(self, "operating_system_type", value)


@pulumi.input_type
class DockerImageArgs:
    def __init__(__self__, *,
                 docker_image_uri: pulumi.Input[str],
                 docker_specification_type: pulumi.Input[str],
                 platform: Optional[pulumi.Input['DockerImagePlatformArgs']] = None):
        """
        Class to represent configuration settings for Docker Build
        :param pulumi.Input[str] docker_image_uri: [Required] Image name of a custom base image.
               <seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" />
        :param pulumi.Input[str] docker_specification_type: Enum to determine docker specification type. Must be either Build or Image.
               Expected value is 'Image'.
        :param pulumi.Input['DockerImagePlatformArgs'] platform: The platform information of the docker image.
        """
        pulumi.set(__self__, "docker_image_uri", docker_image_uri)
        pulumi.set(__self__, "docker_specification_type", 'Image')
        if platform is not None:
            pulumi.set(__self__, "platform", platform)

    @property
    @pulumi.getter(name="dockerImageUri")
    def docker_image_uri(self) -> pulumi.Input[str]:
        """
        [Required] Image name of a custom base image.
        <seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" />
        """
        return pulumi.get(self, "docker_image_uri")

    @docker_image_uri.setter
    def docker_image_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "docker_image_uri", value)

    @property
    @pulumi.getter(name="dockerSpecificationType")
    def docker_specification_type(self) -> pulumi.Input[str]:
        """
        Enum to determine docker specification type. Must be either Build or Image.
        Expected value is 'Image'.
        """
        return pulumi.get(self, "docker_specification_type")

    @docker_specification_type.setter
    def docker_specification_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "docker_specification_type", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input['DockerImagePlatformArgs']]:
        """
        The platform information of the docker image.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input['DockerImagePlatformArgs']]):
        pulumi.set(self, "platform", value)


@pulumi.input_type
class EncryptionPropertyArgs:
    def __init__(__self__, *,
                 key_vault_properties: pulumi.Input['KeyVaultPropertiesArgs'],
                 status: pulumi.Input[Union[str, 'EncryptionStatus']],
                 identity: Optional[pulumi.Input['IdentityForCmkArgs']] = None):
        """
        :param pulumi.Input['KeyVaultPropertiesArgs'] key_vault_properties: Customer Key vault properties.
        :param pulumi.Input[Union[str, 'EncryptionStatus']] status: Indicates whether or not the encryption is enabled for the workspace.
        :param pulumi.Input['IdentityForCmkArgs'] identity: The identity that will be used to access the key vault for encryption at rest.
        """
        pulumi.set(__self__, "key_vault_properties", key_vault_properties)
        pulumi.set(__self__, "status", status)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> pulumi.Input['KeyVaultPropertiesArgs']:
        """
        Customer Key vault properties.
        """
        return pulumi.get(self, "key_vault_properties")

    @key_vault_properties.setter
    def key_vault_properties(self, value: pulumi.Input['KeyVaultPropertiesArgs']):
        pulumi.set(self, "key_vault_properties", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[Union[str, 'EncryptionStatus']]:
        """
        Indicates whether or not the encryption is enabled for the workspace.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[Union[str, 'EncryptionStatus']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['IdentityForCmkArgs']]:
        """
        The identity that will be used to access the key vault for encryption at rest.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['IdentityForCmkArgs']]):
        pulumi.set(self, "identity", value)


@pulumi.input_type
class EndpointAuthKeysArgs:
    def __init__(__self__, *,
                 primary_key: Optional[pulumi.Input[str]] = None,
                 secondary_key: Optional[pulumi.Input[str]] = None):
        """
        Keys for endpoint authentication.
        :param pulumi.Input[str] primary_key: The primary key.
        :param pulumi.Input[str] secondary_key: The secondary key.
        """
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[str]]:
        """
        The primary key.
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_key", value)

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[pulumi.Input[str]]:
        """
        The secondary key.
        """
        return pulumi.get(self, "secondary_key")

    @secondary_key.setter
    def secondary_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_key", value)


@pulumi.input_type
class EnvironmentContainerArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Container for environment specification versions.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class EnvironmentSpecificationVersionArgs:
    def __init__(__self__, *,
                 conda_file: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 docker: Optional[pulumi.Input[Union['DockerBuildArgs', 'DockerImageArgs']]] = None,
                 inference_container_properties: Optional[pulumi.Input['InferenceContainerPropertiesArgs']] = None,
                 is_anonymous: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Environment specification version details.
        <see href="https://repo2docker.readthedocs.io/en/latest/specification.html" />
        :param pulumi.Input[str] conda_file: Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
               <see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" />
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[Union['DockerBuildArgs', 'DockerImageArgs']] docker: Configuration settings for Docker.
        :param pulumi.Input['InferenceContainerPropertiesArgs'] inference_container_properties: Defines configuration specific to inference.
        :param pulumi.Input[bool] is_anonymous: If the name version are system generated (anonymous registration).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if conda_file is not None:
            pulumi.set(__self__, "conda_file", conda_file)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if docker is not None:
            pulumi.set(__self__, "docker", docker)
        if inference_container_properties is not None:
            pulumi.set(__self__, "inference_container_properties", inference_container_properties)
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="condaFile")
    def conda_file(self) -> Optional[pulumi.Input[str]]:
        """
        Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
        <see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" />
        """
        return pulumi.get(self, "conda_file")

    @conda_file.setter
    def conda_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "conda_file", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def docker(self) -> Optional[pulumi.Input[Union['DockerBuildArgs', 'DockerImageArgs']]]:
        """
        Configuration settings for Docker.
        """
        return pulumi.get(self, "docker")

    @docker.setter
    def docker(self, value: Optional[pulumi.Input[Union['DockerBuildArgs', 'DockerImageArgs']]]):
        pulumi.set(self, "docker", value)

    @property
    @pulumi.getter(name="inferenceContainerProperties")
    def inference_container_properties(self) -> Optional[pulumi.Input['InferenceContainerPropertiesArgs']]:
        """
        Defines configuration specific to inference.
        """
        return pulumi.get(self, "inference_container_properties")

    @inference_container_properties.setter
    def inference_container_properties(self, value: Optional[pulumi.Input['InferenceContainerPropertiesArgs']]):
        pulumi.set(self, "inference_container_properties", value)

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[pulumi.Input[bool]]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @is_anonymous.setter
    def is_anonymous(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_anonymous", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class FlavorDataArgs:
    def __init__(__self__, *,
                 data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] data: Model flavor-specific data.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Model flavor-specific data.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "data", value)


@pulumi.input_type
class GlusterFsContentsArgs:
    def __init__(__self__, *,
                 contents_type: pulumi.Input[str],
                 server_address: pulumi.Input[str],
                 volume_name: pulumi.Input[str]):
        """
        GlusterFs datastore configuration.
        :param pulumi.Input[str] contents_type: Enum to determine the datastore contents type.
               Expected value is 'GlusterFs'.
        :param pulumi.Input[str] server_address: [Required] GlusterFS server address (can be the IP address or server name).
        :param pulumi.Input[str] volume_name: [Required] GlusterFS volume name.
        """
        pulumi.set(__self__, "contents_type", 'GlusterFs')
        pulumi.set(__self__, "server_address", server_address)
        pulumi.set(__self__, "volume_name", volume_name)

    @property
    @pulumi.getter(name="contentsType")
    def contents_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore contents type.
        Expected value is 'GlusterFs'.
        """
        return pulumi.get(self, "contents_type")

    @contents_type.setter
    def contents_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "contents_type", value)

    @property
    @pulumi.getter(name="serverAddress")
    def server_address(self) -> pulumi.Input[str]:
        """
        [Required] GlusterFS server address (can be the IP address or server name).
        """
        return pulumi.get(self, "server_address")

    @server_address.setter
    def server_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_address", value)

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> pulumi.Input[str]:
        """
        [Required] GlusterFS volume name.
        """
        return pulumi.get(self, "volume_name")

    @volume_name.setter
    def volume_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_name", value)


@pulumi.input_type
class HDInsightPropertiesArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 administrator_account: Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']] = None,
                 ssh_port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] address: Public IP address of the master node of the cluster.
        :param pulumi.Input['VirtualMachineSshCredentialsArgs'] administrator_account: Admin credentials for master node of the cluster
        :param pulumi.Input[int] ssh_port: Port open for ssh connections on the master node of the cluster.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if administrator_account is not None:
            pulumi.set(__self__, "administrator_account", administrator_account)
        if ssh_port is not None:
            pulumi.set(__self__, "ssh_port", ssh_port)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address of the master node of the cluster.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="administratorAccount")
    def administrator_account(self) -> Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']]:
        """
        Admin credentials for master node of the cluster
        """
        return pulumi.get(self, "administrator_account")

    @administrator_account.setter
    def administrator_account(self, value: Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']]):
        pulumi.set(self, "administrator_account", value)

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> Optional[pulumi.Input[int]]:
        """
        Port open for ssh connections on the master node of the cluster.
        """
        return pulumi.get(self, "ssh_port")

    @ssh_port.setter
    def ssh_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ssh_port", value)


@pulumi.input_type
class HDInsightArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['HDInsightPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A HDInsight compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'HDInsight'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'HDInsight')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'HDInsight'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['HDInsightPropertiesArgs']]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['HDInsightPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class IdAssetReferenceArgs:
    def __init__(__self__, *,
                 asset_id: pulumi.Input[str],
                 reference_type: pulumi.Input[str]):
        """
        Reference to an asset via its ARM resource ID.
        :param pulumi.Input[str] asset_id: [Required] ARM resource ID of the asset.
        :param pulumi.Input[str] reference_type: Enum to determine which reference method to use for an asset.
               Expected value is 'Id'.
        """
        pulumi.set(__self__, "asset_id", asset_id)
        pulumi.set(__self__, "reference_type", 'Id')

    @property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> pulumi.Input[str]:
        """
        [Required] ARM resource ID of the asset.
        """
        return pulumi.get(self, "asset_id")

    @asset_id.setter
    def asset_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "asset_id", value)

    @property
    @pulumi.getter(name="referenceType")
    def reference_type(self) -> pulumi.Input[str]:
        """
        Enum to determine which reference method to use for an asset.
        Expected value is 'Id'.
        """
        return pulumi.get(self, "reference_type")

    @reference_type.setter
    def reference_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "reference_type", value)


@pulumi.input_type
class IdentityForCmkArgs:
    def __init__(__self__, *,
                 user_assigned_identity: Optional[pulumi.Input[str]] = None):
        """
        Identity that will be used to access key vault for encryption at rest
        :param pulumi.Input[str] user_assigned_identity: The ArmId of the user assigned identity that will be used to access the customer managed key vault
        """
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[pulumi.Input[str]]:
        """
        The ArmId of the user assigned identity that will be used to access the customer managed key vault
        """
        return pulumi.get(self, "user_assigned_identity")

    @user_assigned_identity.setter
    def user_assigned_identity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_assigned_identity", value)


@pulumi.input_type
class IdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ResourceIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Identity for the resource.
        :param pulumi.Input['ResourceIdentityType'] type: The identity type.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The user assigned identities associated with the resource.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceIdentityType']]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The user assigned identities associated with the resource.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class InferenceContainerPropertiesArgs:
    def __init__(__self__, *,
                 liveness_route: Optional[pulumi.Input['RouteArgs']] = None,
                 readiness_route: Optional[pulumi.Input['RouteArgs']] = None,
                 scoring_route: Optional[pulumi.Input['RouteArgs']] = None):
        """
        :param pulumi.Input['RouteArgs'] liveness_route: The route to check the liveness of the inference server container.
        :param pulumi.Input['RouteArgs'] readiness_route: The route to check the readiness of the inference server container.
        :param pulumi.Input['RouteArgs'] scoring_route: The port to send the scoring requests to, within the inference server container.
        """
        if liveness_route is not None:
            pulumi.set(__self__, "liveness_route", liveness_route)
        if readiness_route is not None:
            pulumi.set(__self__, "readiness_route", readiness_route)
        if scoring_route is not None:
            pulumi.set(__self__, "scoring_route", scoring_route)

    @property
    @pulumi.getter(name="livenessRoute")
    def liveness_route(self) -> Optional[pulumi.Input['RouteArgs']]:
        """
        The route to check the liveness of the inference server container.
        """
        return pulumi.get(self, "liveness_route")

    @liveness_route.setter
    def liveness_route(self, value: Optional[pulumi.Input['RouteArgs']]):
        pulumi.set(self, "liveness_route", value)

    @property
    @pulumi.getter(name="readinessRoute")
    def readiness_route(self) -> Optional[pulumi.Input['RouteArgs']]:
        """
        The route to check the readiness of the inference server container.
        """
        return pulumi.get(self, "readiness_route")

    @readiness_route.setter
    def readiness_route(self, value: Optional[pulumi.Input['RouteArgs']]):
        pulumi.set(self, "readiness_route", value)

    @property
    @pulumi.getter(name="scoringRoute")
    def scoring_route(self) -> Optional[pulumi.Input['RouteArgs']]:
        """
        The port to send the scoring requests to, within the inference server container.
        """
        return pulumi.get(self, "scoring_route")

    @scoring_route.setter
    def scoring_route(self, value: Optional[pulumi.Input['RouteArgs']]):
        pulumi.set(self, "scoring_route", value)


@pulumi.input_type
class InputDataBindingArgs:
    def __init__(__self__, *,
                 data_id: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'DataBindingMode']]] = None,
                 path_on_compute: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] data_id: ARM resource ID of the registered dataVersion.
        :param pulumi.Input[Union[str, 'DataBindingMode']] mode: Mechanism for accessing the data artifact.
        :param pulumi.Input[str] path_on_compute: Location of data inside the container process.
        """
        if data_id is not None:
            pulumi.set(__self__, "data_id", data_id)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if path_on_compute is not None:
            pulumi.set(__self__, "path_on_compute", path_on_compute)

    @property
    @pulumi.getter(name="dataId")
    def data_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the registered dataVersion.
        """
        return pulumi.get(self, "data_id")

    @data_id.setter
    def data_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_id", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'DataBindingMode']]]:
        """
        Mechanism for accessing the data artifact.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'DataBindingMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="pathOnCompute")
    def path_on_compute(self) -> Optional[pulumi.Input[str]]:
        """
        Location of data inside the container process.
        """
        return pulumi.get(self, "path_on_compute")

    @path_on_compute.setter
    def path_on_compute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_on_compute", value)


@pulumi.input_type
class K8sOnlineDeploymentArgs:
    def __init__(__self__, *,
                 endpoint_compute_type: pulumi.Input[str],
                 app_insights_enabled: Optional[pulumi.Input[bool]] = None,
                 code_configuration: Optional[pulumi.Input['CodeConfigurationArgs']] = None,
                 container_resource_requirements: Optional[pulumi.Input['ContainerResourceRequirementsArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 liveness_probe: Optional[pulumi.Input['ProbeSettingsArgs']] = None,
                 model: Optional[pulumi.Input[Union['DataPathAssetReferenceArgs', 'IdAssetReferenceArgs', 'OutputPathAssetReferenceArgs']]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 request_settings: Optional[pulumi.Input['OnlineRequestSettingsArgs']] = None,
                 scale_settings: Optional[pulumi.Input[Union['AutoScaleSettingsArgs', 'ManualScaleSettingsArgs']]] = None):
        """
        :param pulumi.Input[str] endpoint_compute_type: Enum to determine endpoint compute type.
               Expected value is 'K8S'.
        :param pulumi.Input[bool] app_insights_enabled: If true, enables Application Insights logging.
        :param pulumi.Input['CodeConfigurationArgs'] code_configuration: Code configuration for the endpoint deployment.
        :param pulumi.Input['ContainerResourceRequirementsArgs'] container_resource_requirements: Resource requirements for each container instance within an online deployment.
        :param pulumi.Input[str] description: Description of the endpoint deployment.
        :param pulumi.Input[str] environment_id: ARM resource ID of the environment specification for the endpoint deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables configuration for the deployment.
        :param pulumi.Input['ProbeSettingsArgs'] liveness_probe: Deployment container liveness/readiness probe configuration.
        :param pulumi.Input[Union['DataPathAssetReferenceArgs', 'IdAssetReferenceArgs', 'OutputPathAssetReferenceArgs']] model: Reference to the model asset for the endpoint deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param pulumi.Input['OnlineRequestSettingsArgs'] request_settings: Online deployment scoring requests configuration.
        :param pulumi.Input[Union['AutoScaleSettingsArgs', 'ManualScaleSettingsArgs']] scale_settings: Online deployment scaling configuration.
        """
        pulumi.set(__self__, "endpoint_compute_type", 'K8S')
        if app_insights_enabled is not None:
            pulumi.set(__self__, "app_insights_enabled", app_insights_enabled)
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)
        if container_resource_requirements is not None:
            pulumi.set(__self__, "container_resource_requirements", container_resource_requirements)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if request_settings is not None:
            pulumi.set(__self__, "request_settings", request_settings)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)

    @property
    @pulumi.getter(name="endpointComputeType")
    def endpoint_compute_type(self) -> pulumi.Input[str]:
        """
        Enum to determine endpoint compute type.
        Expected value is 'K8S'.
        """
        return pulumi.get(self, "endpoint_compute_type")

    @endpoint_compute_type.setter
    def endpoint_compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_compute_type", value)

    @property
    @pulumi.getter(name="appInsightsEnabled")
    def app_insights_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, enables Application Insights logging.
        """
        return pulumi.get(self, "app_insights_enabled")

    @app_insights_enabled.setter
    def app_insights_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "app_insights_enabled", value)

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional[pulumi.Input['CodeConfigurationArgs']]:
        """
        Code configuration for the endpoint deployment.
        """
        return pulumi.get(self, "code_configuration")

    @code_configuration.setter
    def code_configuration(self, value: Optional[pulumi.Input['CodeConfigurationArgs']]):
        pulumi.set(self, "code_configuration", value)

    @property
    @pulumi.getter(name="containerResourceRequirements")
    def container_resource_requirements(self) -> Optional[pulumi.Input['ContainerResourceRequirementsArgs']]:
        """
        Resource requirements for each container instance within an online deployment.
        """
        return pulumi.get(self, "container_resource_requirements")

    @container_resource_requirements.setter
    def container_resource_requirements(self, value: Optional[pulumi.Input['ContainerResourceRequirementsArgs']]):
        pulumi.set(self, "container_resource_requirements", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the endpoint deployment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the environment specification for the endpoint deployment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables configuration for the deployment.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional[pulumi.Input['ProbeSettingsArgs']]:
        """
        Deployment container liveness/readiness probe configuration.
        """
        return pulumi.get(self, "liveness_probe")

    @liveness_probe.setter
    def liveness_probe(self, value: Optional[pulumi.Input['ProbeSettingsArgs']]):
        pulumi.set(self, "liveness_probe", value)

    @property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input[Union['DataPathAssetReferenceArgs', 'IdAssetReferenceArgs', 'OutputPathAssetReferenceArgs']]]:
        """
        Reference to the model asset for the endpoint deployment.
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input[Union['DataPathAssetReferenceArgs', 'IdAssetReferenceArgs', 'OutputPathAssetReferenceArgs']]]):
        pulumi.set(self, "model", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="requestSettings")
    def request_settings(self) -> Optional[pulumi.Input['OnlineRequestSettingsArgs']]:
        """
        Online deployment scoring requests configuration.
        """
        return pulumi.get(self, "request_settings")

    @request_settings.setter
    def request_settings(self, value: Optional[pulumi.Input['OnlineRequestSettingsArgs']]):
        pulumi.set(self, "request_settings", value)

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional[pulumi.Input[Union['AutoScaleSettingsArgs', 'ManualScaleSettingsArgs']]]:
        """
        Online deployment scaling configuration.
        """
        return pulumi.get(self, "scale_settings")

    @scale_settings.setter
    def scale_settings(self, value: Optional[pulumi.Input[Union['AutoScaleSettingsArgs', 'ManualScaleSettingsArgs']]]):
        pulumi.set(self, "scale_settings", value)


@pulumi.input_type
class KeyVaultPropertiesArgs:
    def __init__(__self__, *,
                 key_identifier: pulumi.Input[str],
                 key_vault_arm_id: pulumi.Input[str],
                 identity_client_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key_identifier: Key vault uri to access the encryption key.
        :param pulumi.Input[str] key_vault_arm_id: The ArmId of the keyVault where the customer owned encryption key is present.
        :param pulumi.Input[str] identity_client_id: For future use - The client id of the identity which will be used to access key vault.
        """
        pulumi.set(__self__, "key_identifier", key_identifier)
        pulumi.set(__self__, "key_vault_arm_id", key_vault_arm_id)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> pulumi.Input[str]:
        """
        Key vault uri to access the encryption key.
        """
        return pulumi.get(self, "key_identifier")

    @key_identifier.setter
    def key_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_identifier", value)

    @property
    @pulumi.getter(name="keyVaultArmId")
    def key_vault_arm_id(self) -> pulumi.Input[str]:
        """
        The ArmId of the keyVault where the customer owned encryption key is present.
        """
        return pulumi.get(self, "key_vault_arm_id")

    @key_vault_arm_id.setter
    def key_vault_arm_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_vault_arm_id", value)

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        For future use - The client id of the identity which will be used to access key vault.
        """
        return pulumi.get(self, "identity_client_id")

    @identity_client_id.setter
    def identity_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_client_id", value)


@pulumi.input_type
class LabelCategoryArgs:
    def __init__(__self__, *,
                 allow_multi_select: Optional[pulumi.Input[bool]] = None,
                 classes: Optional[pulumi.Input[Mapping[str, pulumi.Input['LabelClassArgs']]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None):
        """
        Label category definition
        :param pulumi.Input[bool] allow_multi_select: Indicates whether it is allowed to select multiple classes in this category.
        :param pulumi.Input[Mapping[str, pulumi.Input['LabelClassArgs']]] classes: Dictionary of label classes in this category.
        :param pulumi.Input[str] display_name: Display name of the label category.
        """
        if allow_multi_select is not None:
            pulumi.set(__self__, "allow_multi_select", allow_multi_select)
        if classes is not None:
            pulumi.set(__self__, "classes", classes)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter(name="allowMultiSelect")
    def allow_multi_select(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether it is allowed to select multiple classes in this category.
        """
        return pulumi.get(self, "allow_multi_select")

    @allow_multi_select.setter
    def allow_multi_select(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_multi_select", value)

    @property
    @pulumi.getter
    def classes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['LabelClassArgs']]]]:
        """
        Dictionary of label classes in this category.
        """
        return pulumi.get(self, "classes")

    @classes.setter
    def classes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['LabelClassArgs']]]]):
        pulumi.set(self, "classes", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of the label category.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class LabelClassArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 subclasses: Optional[pulumi.Input[Mapping[str, pulumi.Input['LabelClassArgs']]]] = None):
        """
        Label class definition
        :param pulumi.Input[str] display_name: Display name of the label class.
        :param pulumi.Input[Mapping[str, pulumi.Input['LabelClassArgs']]] subclasses: Dictionary of subclasses of the label class.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if subclasses is not None:
            pulumi.set(__self__, "subclasses", subclasses)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of the label class.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def subclasses(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['LabelClassArgs']]]]:
        """
        Dictionary of subclasses of the label class.
        """
        return pulumi.get(self, "subclasses")

    @subclasses.setter
    def subclasses(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['LabelClassArgs']]]]):
        pulumi.set(self, "subclasses", value)


@pulumi.input_type
class LabelingDatasetConfigurationArgs:
    def __init__(__self__, *,
                 asset_name: Optional[pulumi.Input[str]] = None,
                 dataset_version: Optional[pulumi.Input[str]] = None,
                 incremental_dataset_refresh_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Labeling dataset configuration definition
        :param pulumi.Input[str] asset_name: Name of the data asset to perform labeling.
        :param pulumi.Input[str] dataset_version: AML dataset version.
        :param pulumi.Input[bool] incremental_dataset_refresh_enabled: Indicates whether to enable incremental dataset refresh.
        """
        if asset_name is not None:
            pulumi.set(__self__, "asset_name", asset_name)
        if dataset_version is not None:
            pulumi.set(__self__, "dataset_version", dataset_version)
        if incremental_dataset_refresh_enabled is not None:
            pulumi.set(__self__, "incremental_dataset_refresh_enabled", incremental_dataset_refresh_enabled)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the data asset to perform labeling.
        """
        return pulumi.get(self, "asset_name")

    @asset_name.setter
    def asset_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset_name", value)

    @property
    @pulumi.getter(name="datasetVersion")
    def dataset_version(self) -> Optional[pulumi.Input[str]]:
        """
        AML dataset version.
        """
        return pulumi.get(self, "dataset_version")

    @dataset_version.setter
    def dataset_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_version", value)

    @property
    @pulumi.getter(name="incrementalDatasetRefreshEnabled")
    def incremental_dataset_refresh_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to enable incremental dataset refresh.
        """
        return pulumi.get(self, "incremental_dataset_refresh_enabled")

    @incremental_dataset_refresh_enabled.setter
    def incremental_dataset_refresh_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "incremental_dataset_refresh_enabled", value)


@pulumi.input_type
class LabelingJobImagePropertiesArgs:
    def __init__(__self__, *,
                 media_type: pulumi.Input[str],
                 annotation_type: Optional[pulumi.Input[Union[str, 'ImageAnnotationType']]] = None):
        """
        Properties of a labeling job for image data
        :param pulumi.Input[str] media_type: Media type of data asset.
               Expected value is 'Image'.
        :param pulumi.Input[Union[str, 'ImageAnnotationType']] annotation_type: Annotation type of image labeling job.
        """
        pulumi.set(__self__, "media_type", 'Image')
        if annotation_type is not None:
            pulumi.set(__self__, "annotation_type", annotation_type)

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> pulumi.Input[str]:
        """
        Media type of data asset.
        Expected value is 'Image'.
        """
        return pulumi.get(self, "media_type")

    @media_type.setter
    def media_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "media_type", value)

    @property
    @pulumi.getter(name="annotationType")
    def annotation_type(self) -> Optional[pulumi.Input[Union[str, 'ImageAnnotationType']]]:
        """
        Annotation type of image labeling job.
        """
        return pulumi.get(self, "annotation_type")

    @annotation_type.setter
    def annotation_type(self, value: Optional[pulumi.Input[Union[str, 'ImageAnnotationType']]]):
        pulumi.set(self, "annotation_type", value)


@pulumi.input_type
class LabelingJobInstructionsArgs:
    def __init__(__self__, *,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        Instructions for labeling job
        :param pulumi.Input[str] uri: The link to a page with detailed labeling instructions for labelers.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        The link to a page with detailed labeling instructions for labelers.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class LabelingJobTextPropertiesArgs:
    def __init__(__self__, *,
                 media_type: pulumi.Input[str],
                 annotation_type: Optional[pulumi.Input[Union[str, 'TextAnnotationType']]] = None):
        """
        Properties of a labeling job for text data
        :param pulumi.Input[str] media_type: Media type of data asset.
               Expected value is 'Text'.
        :param pulumi.Input[Union[str, 'TextAnnotationType']] annotation_type: Annotation type of text labeling job.
        """
        pulumi.set(__self__, "media_type", 'Text')
        if annotation_type is not None:
            pulumi.set(__self__, "annotation_type", annotation_type)

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> pulumi.Input[str]:
        """
        Media type of data asset.
        Expected value is 'Text'.
        """
        return pulumi.get(self, "media_type")

    @media_type.setter
    def media_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "media_type", value)

    @property
    @pulumi.getter(name="annotationType")
    def annotation_type(self) -> Optional[pulumi.Input[Union[str, 'TextAnnotationType']]]:
        """
        Annotation type of text labeling job.
        """
        return pulumi.get(self, "annotation_type")

    @annotation_type.setter
    def annotation_type(self, value: Optional[pulumi.Input[Union[str, 'TextAnnotationType']]]):
        pulumi.set(self, "annotation_type", value)


@pulumi.input_type
class LabelingJobArgs:
    def __init__(__self__, *,
                 job_type: pulumi.Input[Union[str, 'JobType']],
                 dataset_configuration: Optional[pulumi.Input['LabelingDatasetConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 job_instructions: Optional[pulumi.Input['LabelingJobInstructionsArgs']] = None,
                 label_categories: Optional[pulumi.Input[Mapping[str, pulumi.Input['LabelCategoryArgs']]]] = None,
                 labeling_job_media_properties: Optional[pulumi.Input[Union['LabelingJobImagePropertiesArgs', 'LabelingJobTextPropertiesArgs']]] = None,
                 ml_assist_configuration: Optional[pulumi.Input['MLAssistConfigurationArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Labeling job definition
        :param pulumi.Input[Union[str, 'JobType']] job_type: [Required] Specifies the type of job. This field should always be set to "Labeling".
        :param pulumi.Input['LabelingDatasetConfigurationArgs'] dataset_configuration: Configuration of dataset used in the job.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input['LabelingJobInstructionsArgs'] job_instructions: Labeling instructions of the job.
        :param pulumi.Input[Mapping[str, pulumi.Input['LabelCategoryArgs']]] label_categories: Label categories of the job.
        :param pulumi.Input[Union['LabelingJobImagePropertiesArgs', 'LabelingJobTextPropertiesArgs']] labeling_job_media_properties: Media type specific properties in the job.
        :param pulumi.Input['MLAssistConfigurationArgs'] ml_assist_configuration: Configuration of MLAssist feature in the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "job_type", job_type)
        if dataset_configuration is not None:
            pulumi.set(__self__, "dataset_configuration", dataset_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if job_instructions is not None:
            pulumi.set(__self__, "job_instructions", job_instructions)
        if label_categories is not None:
            pulumi.set(__self__, "label_categories", label_categories)
        if labeling_job_media_properties is not None:
            pulumi.set(__self__, "labeling_job_media_properties", labeling_job_media_properties)
        if ml_assist_configuration is not None:
            pulumi.set(__self__, "ml_assist_configuration", ml_assist_configuration)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Input[Union[str, 'JobType']]:
        """
        [Required] Specifies the type of job. This field should always be set to "Labeling".
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: pulumi.Input[Union[str, 'JobType']]):
        pulumi.set(self, "job_type", value)

    @property
    @pulumi.getter(name="datasetConfiguration")
    def dataset_configuration(self) -> Optional[pulumi.Input['LabelingDatasetConfigurationArgs']]:
        """
        Configuration of dataset used in the job.
        """
        return pulumi.get(self, "dataset_configuration")

    @dataset_configuration.setter
    def dataset_configuration(self, value: Optional[pulumi.Input['LabelingDatasetConfigurationArgs']]):
        pulumi.set(self, "dataset_configuration", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="jobInstructions")
    def job_instructions(self) -> Optional[pulumi.Input['LabelingJobInstructionsArgs']]:
        """
        Labeling instructions of the job.
        """
        return pulumi.get(self, "job_instructions")

    @job_instructions.setter
    def job_instructions(self, value: Optional[pulumi.Input['LabelingJobInstructionsArgs']]):
        pulumi.set(self, "job_instructions", value)

    @property
    @pulumi.getter(name="labelCategories")
    def label_categories(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['LabelCategoryArgs']]]]:
        """
        Label categories of the job.
        """
        return pulumi.get(self, "label_categories")

    @label_categories.setter
    def label_categories(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['LabelCategoryArgs']]]]):
        pulumi.set(self, "label_categories", value)

    @property
    @pulumi.getter(name="labelingJobMediaProperties")
    def labeling_job_media_properties(self) -> Optional[pulumi.Input[Union['LabelingJobImagePropertiesArgs', 'LabelingJobTextPropertiesArgs']]]:
        """
        Media type specific properties in the job.
        """
        return pulumi.get(self, "labeling_job_media_properties")

    @labeling_job_media_properties.setter
    def labeling_job_media_properties(self, value: Optional[pulumi.Input[Union['LabelingJobImagePropertiesArgs', 'LabelingJobTextPropertiesArgs']]]):
        pulumi.set(self, "labeling_job_media_properties", value)

    @property
    @pulumi.getter(name="mlAssistConfiguration")
    def ml_assist_configuration(self) -> Optional[pulumi.Input['MLAssistConfigurationArgs']]:
        """
        Configuration of MLAssist feature in the job.
        """
        return pulumi.get(self, "ml_assist_configuration")

    @ml_assist_configuration.setter
    def ml_assist_configuration(self, value: Optional[pulumi.Input['MLAssistConfigurationArgs']]):
        pulumi.set(self, "ml_assist_configuration", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class LinkedInfoArgs:
    def __init__(__self__, *,
                 linked_id: Optional[pulumi.Input[str]] = None,
                 linked_resource_name: Optional[pulumi.Input[str]] = None,
                 origin: Optional[pulumi.Input[Union[str, 'OriginType']]] = None):
        """
        Information about a datastore origin, if linked.
        :param pulumi.Input[str] linked_id: Linked service ID.
        :param pulumi.Input[str] linked_resource_name: Linked service resource name.
        :param pulumi.Input[Union[str, 'OriginType']] origin: Type of the linked service.
        """
        if linked_id is not None:
            pulumi.set(__self__, "linked_id", linked_id)
        if linked_resource_name is not None:
            pulumi.set(__self__, "linked_resource_name", linked_resource_name)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)

    @property
    @pulumi.getter(name="linkedId")
    def linked_id(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service ID.
        """
        return pulumi.get(self, "linked_id")

    @linked_id.setter
    def linked_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linked_id", value)

    @property
    @pulumi.getter(name="linkedResourceName")
    def linked_resource_name(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service resource name.
        """
        return pulumi.get(self, "linked_resource_name")

    @linked_resource_name.setter
    def linked_resource_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linked_resource_name", value)

    @property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input[Union[str, 'OriginType']]]:
        """
        Type of the linked service.
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input[Union[str, 'OriginType']]]):
        pulumi.set(self, "origin", value)


@pulumi.input_type
class MLAssistConfigurationArgs:
    def __init__(__self__, *,
                 inferencing_compute_binding: Optional[pulumi.Input['ComputeConfigurationArgs']] = None,
                 ml_assist_enabled: Optional[pulumi.Input[bool]] = None,
                 training_compute_binding: Optional[pulumi.Input['ComputeConfigurationArgs']] = None):
        """
        Labeling MLAssist configuration definition
        :param pulumi.Input['ComputeConfigurationArgs'] inferencing_compute_binding: AML compute binding used in inferencing.
        :param pulumi.Input[bool] ml_assist_enabled: Indicates whether MLAssist feature is enabled.
        :param pulumi.Input['ComputeConfigurationArgs'] training_compute_binding: AML compute binding used in training.
        """
        if inferencing_compute_binding is not None:
            pulumi.set(__self__, "inferencing_compute_binding", inferencing_compute_binding)
        if ml_assist_enabled is not None:
            pulumi.set(__self__, "ml_assist_enabled", ml_assist_enabled)
        if training_compute_binding is not None:
            pulumi.set(__self__, "training_compute_binding", training_compute_binding)

    @property
    @pulumi.getter(name="inferencingComputeBinding")
    def inferencing_compute_binding(self) -> Optional[pulumi.Input['ComputeConfigurationArgs']]:
        """
        AML compute binding used in inferencing.
        """
        return pulumi.get(self, "inferencing_compute_binding")

    @inferencing_compute_binding.setter
    def inferencing_compute_binding(self, value: Optional[pulumi.Input['ComputeConfigurationArgs']]):
        pulumi.set(self, "inferencing_compute_binding", value)

    @property
    @pulumi.getter(name="mlAssistEnabled")
    def ml_assist_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether MLAssist feature is enabled.
        """
        return pulumi.get(self, "ml_assist_enabled")

    @ml_assist_enabled.setter
    def ml_assist_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ml_assist_enabled", value)

    @property
    @pulumi.getter(name="trainingComputeBinding")
    def training_compute_binding(self) -> Optional[pulumi.Input['ComputeConfigurationArgs']]:
        """
        AML compute binding used in training.
        """
        return pulumi.get(self, "training_compute_binding")

    @training_compute_binding.setter
    def training_compute_binding(self, value: Optional[pulumi.Input['ComputeConfigurationArgs']]):
        pulumi.set(self, "training_compute_binding", value)


@pulumi.input_type
class ManagedIdentityArgs:
    def __init__(__self__, *,
                 identity_type: pulumi.Input[str],
                 client_id: Optional[pulumi.Input[str]] = None,
                 object_id: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Managed identity configuration.
        :param pulumi.Input[str] identity_type: Enum to determine identity framework.
               Expected value is 'Managed'.
        :param pulumi.Input[str] client_id: Specifies a user-assigned identity by client ID. For system-assigned, do not set this field.
        :param pulumi.Input[str] object_id: Specifies a user-assigned identity by object ID. For system-assigned, do not set this field.
        :param pulumi.Input[str] resource_id: Specifies a user-assigned identity by ARM resource ID. For system-assigned, do not set this field.
        """
        pulumi.set(__self__, "identity_type", 'Managed')
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> pulumi.Input[str]:
        """
        Enum to determine identity framework.
        Expected value is 'Managed'.
        """
        return pulumi.get(self, "identity_type")

    @identity_type.setter
    def identity_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "identity_type", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a user-assigned identity by client ID. For system-assigned, do not set this field.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a user-assigned identity by object ID. For system-assigned, do not set this field.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a user-assigned identity by ARM resource ID. For system-assigned, do not set this field.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class ManagedOnlineDeploymentArgs:
    def __init__(__self__, *,
                 endpoint_compute_type: pulumi.Input[str],
                 app_insights_enabled: Optional[pulumi.Input[bool]] = None,
                 code_configuration: Optional[pulumi.Input['CodeConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 liveness_probe: Optional[pulumi.Input['ProbeSettingsArgs']] = None,
                 model: Optional[pulumi.Input[Union['DataPathAssetReferenceArgs', 'IdAssetReferenceArgs', 'OutputPathAssetReferenceArgs']]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 readiness_probe: Optional[pulumi.Input['ProbeSettingsArgs']] = None,
                 request_settings: Optional[pulumi.Input['OnlineRequestSettingsArgs']] = None,
                 scale_settings: Optional[pulumi.Input[Union['AutoScaleSettingsArgs', 'ManualScaleSettingsArgs']]] = None):
        """
        :param pulumi.Input[str] endpoint_compute_type: Enum to determine endpoint compute type.
               Expected value is 'Managed'.
        :param pulumi.Input[bool] app_insights_enabled: If true, enables Application Insights logging.
        :param pulumi.Input['CodeConfigurationArgs'] code_configuration: Code configuration for the endpoint deployment.
        :param pulumi.Input[str] description: Description of the endpoint deployment.
        :param pulumi.Input[str] environment_id: ARM resource ID of the environment specification for the endpoint deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables configuration for the deployment.
        :param pulumi.Input[str] instance_type: Compute instance type.
        :param pulumi.Input['ProbeSettingsArgs'] liveness_probe: Deployment container liveness/readiness probe configuration.
        :param pulumi.Input[Union['DataPathAssetReferenceArgs', 'IdAssetReferenceArgs', 'OutputPathAssetReferenceArgs']] model: Reference to the model asset for the endpoint deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param pulumi.Input['ProbeSettingsArgs'] readiness_probe: Deployment container liveness/readiness probe configuration.
        :param pulumi.Input['OnlineRequestSettingsArgs'] request_settings: Online deployment scoring requests configuration.
        :param pulumi.Input[Union['AutoScaleSettingsArgs', 'ManualScaleSettingsArgs']] scale_settings: Online deployment scaling configuration.
        """
        pulumi.set(__self__, "endpoint_compute_type", 'Managed')
        if app_insights_enabled is not None:
            pulumi.set(__self__, "app_insights_enabled", app_insights_enabled)
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if readiness_probe is not None:
            pulumi.set(__self__, "readiness_probe", readiness_probe)
        if request_settings is not None:
            pulumi.set(__self__, "request_settings", request_settings)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)

    @property
    @pulumi.getter(name="endpointComputeType")
    def endpoint_compute_type(self) -> pulumi.Input[str]:
        """
        Enum to determine endpoint compute type.
        Expected value is 'Managed'.
        """
        return pulumi.get(self, "endpoint_compute_type")

    @endpoint_compute_type.setter
    def endpoint_compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_compute_type", value)

    @property
    @pulumi.getter(name="appInsightsEnabled")
    def app_insights_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, enables Application Insights logging.
        """
        return pulumi.get(self, "app_insights_enabled")

    @app_insights_enabled.setter
    def app_insights_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "app_insights_enabled", value)

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional[pulumi.Input['CodeConfigurationArgs']]:
        """
        Code configuration for the endpoint deployment.
        """
        return pulumi.get(self, "code_configuration")

    @code_configuration.setter
    def code_configuration(self, value: Optional[pulumi.Input['CodeConfigurationArgs']]):
        pulumi.set(self, "code_configuration", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the endpoint deployment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the environment specification for the endpoint deployment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables configuration for the deployment.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Compute instance type.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional[pulumi.Input['ProbeSettingsArgs']]:
        """
        Deployment container liveness/readiness probe configuration.
        """
        return pulumi.get(self, "liveness_probe")

    @liveness_probe.setter
    def liveness_probe(self, value: Optional[pulumi.Input['ProbeSettingsArgs']]):
        pulumi.set(self, "liveness_probe", value)

    @property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input[Union['DataPathAssetReferenceArgs', 'IdAssetReferenceArgs', 'OutputPathAssetReferenceArgs']]]:
        """
        Reference to the model asset for the endpoint deployment.
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input[Union['DataPathAssetReferenceArgs', 'IdAssetReferenceArgs', 'OutputPathAssetReferenceArgs']]]):
        pulumi.set(self, "model", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> Optional[pulumi.Input['ProbeSettingsArgs']]:
        """
        Deployment container liveness/readiness probe configuration.
        """
        return pulumi.get(self, "readiness_probe")

    @readiness_probe.setter
    def readiness_probe(self, value: Optional[pulumi.Input['ProbeSettingsArgs']]):
        pulumi.set(self, "readiness_probe", value)

    @property
    @pulumi.getter(name="requestSettings")
    def request_settings(self) -> Optional[pulumi.Input['OnlineRequestSettingsArgs']]:
        """
        Online deployment scoring requests configuration.
        """
        return pulumi.get(self, "request_settings")

    @request_settings.setter
    def request_settings(self, value: Optional[pulumi.Input['OnlineRequestSettingsArgs']]):
        pulumi.set(self, "request_settings", value)

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional[pulumi.Input[Union['AutoScaleSettingsArgs', 'ManualScaleSettingsArgs']]]:
        """
        Online deployment scaling configuration.
        """
        return pulumi.get(self, "scale_settings")

    @scale_settings.setter
    def scale_settings(self, value: Optional[pulumi.Input[Union['AutoScaleSettingsArgs', 'ManualScaleSettingsArgs']]]):
        pulumi.set(self, "scale_settings", value)


@pulumi.input_type
class ManualScaleSettingsArgs:
    def __init__(__self__, *,
                 scale_type: pulumi.Input[str],
                 instance_count: Optional[pulumi.Input[int]] = None,
                 max_instances: Optional[pulumi.Input[int]] = None,
                 min_instances: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] scale_type: 
               Expected value is 'Manual'.
        :param pulumi.Input[int] instance_count: Fixed number of instances for this deployment.
        :param pulumi.Input[int] max_instances: Maximum number of instances for this deployment.
        :param pulumi.Input[int] min_instances: Minimum number of instances for this deployment.
        """
        pulumi.set(__self__, "scale_type", 'Manual')
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)

    @property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'Manual'.
        """
        return pulumi.get(self, "scale_type")

    @scale_type.setter
    def scale_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "scale_type", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        Fixed number of instances for this deployment.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of instances for this deployment.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instances", value)

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of instances for this deployment.
        """
        return pulumi.get(self, "min_instances")

    @min_instances.setter
    def min_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instances", value)


@pulumi.input_type
class MedianStoppingPolicyArgs:
    def __init__(__self__, *,
                 policy_type: pulumi.Input[str],
                 delay_evaluation: Optional[pulumi.Input[int]] = None,
                 evaluation_interval: Optional[pulumi.Input[int]] = None):
        """
        Defines an early termination policy based on running averages of the primary metric of all runs.
        :param pulumi.Input[str] policy_type: 
               Expected value is 'MedianStopping'.
        :param pulumi.Input[int] delay_evaluation: Number of intervals by which to delay the first evaluation.
        :param pulumi.Input[int] evaluation_interval: Interval (number of runs) between policy evaluations.
        """
        pulumi.set(__self__, "policy_type", 'MedianStopping')
        if delay_evaluation is not None:
            pulumi.set(__self__, "delay_evaluation", delay_evaluation)
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'MedianStopping'.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter(name="delayEvaluation")
    def delay_evaluation(self) -> Optional[pulumi.Input[int]]:
        """
        Number of intervals by which to delay the first evaluation.
        """
        return pulumi.get(self, "delay_evaluation")

    @delay_evaluation.setter
    def delay_evaluation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_evaluation", value)

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Interval (number of runs) between policy evaluations.
        """
        return pulumi.get(self, "evaluation_interval")

    @evaluation_interval.setter
    def evaluation_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "evaluation_interval", value)


@pulumi.input_type
class ModelContainerArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class ModelVersionArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 datastore_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flavors: Optional[pulumi.Input[Mapping[str, pulumi.Input['FlavorDataArgs']]]] = None,
                 is_anonymous: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Model asset version details.
        :param pulumi.Input[str] path: [Required] The path of the file/directory in the datastore.
        :param pulumi.Input[str] datastore_id: ARM resource ID of the datastore where the asset is located.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[Mapping[str, pulumi.Input['FlavorDataArgs']]] flavors: Mapping of model flavors to their properties.
        :param pulumi.Input[bool] is_anonymous: If the name version are system generated (anonymous registration).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "path", path)
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flavors is not None:
            pulumi.set(__self__, "flavors", flavors)
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        [Required] The path of the file/directory in the datastore.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the datastore where the asset is located.
        """
        return pulumi.get(self, "datastore_id")

    @datastore_id.setter
    def datastore_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datastore_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def flavors(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['FlavorDataArgs']]]]:
        """
        Mapping of model flavors to their properties.
        """
        return pulumi.get(self, "flavors")

    @flavors.setter
    def flavors(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['FlavorDataArgs']]]]):
        pulumi.set(self, "flavors", value)

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[pulumi.Input[bool]]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @is_anonymous.setter
    def is_anonymous(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_anonymous", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class MpiArgs:
    def __init__(__self__, *,
                 distribution_type: pulumi.Input[str],
                 process_count_per_instance: Optional[pulumi.Input[int]] = None):
        """
        MPI distribution configuration.
        :param pulumi.Input[str] distribution_type: Enum to determine the job distribution type.
               Expected value is 'Mpi'.
        :param pulumi.Input[int] process_count_per_instance: Number of processes per MPI node.
        """
        pulumi.set(__self__, "distribution_type", 'Mpi')
        if process_count_per_instance is not None:
            pulumi.set(__self__, "process_count_per_instance", process_count_per_instance)

    @property
    @pulumi.getter(name="distributionType")
    def distribution_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the job distribution type.
        Expected value is 'Mpi'.
        """
        return pulumi.get(self, "distribution_type")

    @distribution_type.setter
    def distribution_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "distribution_type", value)

    @property
    @pulumi.getter(name="processCountPerInstance")
    def process_count_per_instance(self) -> Optional[pulumi.Input[int]]:
        """
        Number of processes per MPI node.
        """
        return pulumi.get(self, "process_count_per_instance")

    @process_count_per_instance.setter
    def process_count_per_instance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "process_count_per_instance", value)


@pulumi.input_type
class NoneDatastoreCredentialsArgs:
    def __init__(__self__, *,
                 credentials_type: pulumi.Input[str],
                 secrets: Optional[pulumi.Input['NoneDatastoreSecretsArgs']] = None):
        """
        Empty/none datastore credentials.
        :param pulumi.Input[str] credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'None'.
        :param pulumi.Input['NoneDatastoreSecretsArgs'] secrets: Empty/none datastore secret.
        """
        pulumi.set(__self__, "credentials_type", 'None')
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'None'.
        """
        return pulumi.get(self, "credentials_type")

    @credentials_type.setter
    def credentials_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credentials_type", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input['NoneDatastoreSecretsArgs']]:
        """
        Empty/none datastore secret.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input['NoneDatastoreSecretsArgs']]):
        pulumi.set(self, "secrets", value)


@pulumi.input_type
class NoneDatastoreSecretsArgs:
    def __init__(__self__, *,
                 secrets_type: pulumi.Input[str]):
        """
        Empty/none datastore secret.
        :param pulumi.Input[str] secrets_type: Enum to determine the datastore secrets type.
               Expected value is 'None'.
        """
        pulumi.set(__self__, "secrets_type", 'None')

    @property
    @pulumi.getter(name="secretsType")
    def secrets_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore secrets type.
        Expected value is 'None'.
        """
        return pulumi.get(self, "secrets_type")

    @secrets_type.setter
    def secrets_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "secrets_type", value)


@pulumi.input_type
class ObjectiveArgs:
    def __init__(__self__, *,
                 goal: pulumi.Input[Union[str, 'Goal']],
                 primary_metric: pulumi.Input[str]):
        """
        Optimization objective.
        :param pulumi.Input[Union[str, 'Goal']] goal: [Required] Defines supported metric goals for hyperparameter tuning
        :param pulumi.Input[str] primary_metric: [Required] Name of the metric to optimize.
        """
        pulumi.set(__self__, "goal", goal)
        pulumi.set(__self__, "primary_metric", primary_metric)

    @property
    @pulumi.getter
    def goal(self) -> pulumi.Input[Union[str, 'Goal']]:
        """
        [Required] Defines supported metric goals for hyperparameter tuning
        """
        return pulumi.get(self, "goal")

    @goal.setter
    def goal(self, value: pulumi.Input[Union[str, 'Goal']]):
        pulumi.set(self, "goal", value)

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> pulumi.Input[str]:
        """
        [Required] Name of the metric to optimize.
        """
        return pulumi.get(self, "primary_metric")

    @primary_metric.setter
    def primary_metric(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_metric", value)


@pulumi.input_type
class OnlineEndpointArgs:
    def __init__(__self__, *,
                 auth_mode: pulumi.Input[Union[str, 'EndpointAuthMode']],
                 description: Optional[pulumi.Input[str]] = None,
                 keys: Optional[pulumi.Input['EndpointAuthKeysArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 traffic: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]] = None):
        """
        Online endpoint configuration
        :param pulumi.Input[Union[str, 'EndpointAuthMode']] auth_mode: [Required] Inference endpoint authentication mode type
        :param pulumi.Input[str] description: Description of the inference endpoint.
        :param pulumi.Input['EndpointAuthKeysArgs'] keys: EndpointAuthKeys to set initially on an Endpoint.
               This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param pulumi.Input[str] target: ARM resource ID of the compute if it exists.
               optional
        :param pulumi.Input[Mapping[str, pulumi.Input[int]]] traffic: Traffic rules on how the traffic will be routed across deployments.
        """
        pulumi.set(__self__, "auth_mode", auth_mode)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if traffic is not None:
            pulumi.set(__self__, "traffic", traffic)

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> pulumi.Input[Union[str, 'EndpointAuthMode']]:
        """
        [Required] Inference endpoint authentication mode type
        """
        return pulumi.get(self, "auth_mode")

    @auth_mode.setter
    def auth_mode(self, value: pulumi.Input[Union[str, 'EndpointAuthMode']]):
        pulumi.set(self, "auth_mode", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the inference endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input['EndpointAuthKeysArgs']]:
        """
        EndpointAuthKeys to set initially on an Endpoint.
        This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input['EndpointAuthKeysArgs']]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the compute if it exists.
        optional
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def traffic(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]]:
        """
        Traffic rules on how the traffic will be routed across deployments.
        """
        return pulumi.get(self, "traffic")

    @traffic.setter
    def traffic(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]]):
        pulumi.set(self, "traffic", value)


@pulumi.input_type
class OnlineRequestSettingsArgs:
    def __init__(__self__, *,
                 max_concurrent_requests_per_instance: Optional[pulumi.Input[int]] = None,
                 max_queue_wait: Optional[pulumi.Input[str]] = None,
                 request_timeout: Optional[pulumi.Input[str]] = None):
        """
        Online deployment scoring requests configuration.
        :param pulumi.Input[int] max_concurrent_requests_per_instance: The number of requests allowed to queue at once for this deployment.
        :param pulumi.Input[str] max_queue_wait: The maximum queue wait time in ISO 8601 format. Supports millisecond precision.
        :param pulumi.Input[str] request_timeout: The request timeout in ISO 8601 format. Supports millisecond precision.
        """
        if max_concurrent_requests_per_instance is not None:
            pulumi.set(__self__, "max_concurrent_requests_per_instance", max_concurrent_requests_per_instance)
        if max_queue_wait is not None:
            pulumi.set(__self__, "max_queue_wait", max_queue_wait)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)

    @property
    @pulumi.getter(name="maxConcurrentRequestsPerInstance")
    def max_concurrent_requests_per_instance(self) -> Optional[pulumi.Input[int]]:
        """
        The number of requests allowed to queue at once for this deployment.
        """
        return pulumi.get(self, "max_concurrent_requests_per_instance")

    @max_concurrent_requests_per_instance.setter
    def max_concurrent_requests_per_instance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_requests_per_instance", value)

    @property
    @pulumi.getter(name="maxQueueWait")
    def max_queue_wait(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum queue wait time in ISO 8601 format. Supports millisecond precision.
        """
        return pulumi.get(self, "max_queue_wait")

    @max_queue_wait.setter
    def max_queue_wait(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_queue_wait", value)

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The request timeout in ISO 8601 format. Supports millisecond precision.
        """
        return pulumi.get(self, "request_timeout")

    @request_timeout.setter
    def request_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_timeout", value)


@pulumi.input_type
class OutputDataBindingArgs:
    def __init__(__self__, *,
                 datastore_id: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'DataBindingMode']]] = None,
                 path_on_compute: Optional[pulumi.Input[str]] = None,
                 path_on_datastore: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] datastore_id: ARM resource ID of the datastore where the data output will be stored.
        :param pulumi.Input[Union[str, 'DataBindingMode']] mode: Mechanism for data movement to datastore.
        :param pulumi.Input[str] path_on_compute: Location of data inside the container process.
        :param pulumi.Input[str] path_on_datastore: Path within the datastore to the data.
        """
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if path_on_compute is not None:
            pulumi.set(__self__, "path_on_compute", path_on_compute)
        if path_on_datastore is not None:
            pulumi.set(__self__, "path_on_datastore", path_on_datastore)

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the datastore where the data output will be stored.
        """
        return pulumi.get(self, "datastore_id")

    @datastore_id.setter
    def datastore_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datastore_id", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'DataBindingMode']]]:
        """
        Mechanism for data movement to datastore.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'DataBindingMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="pathOnCompute")
    def path_on_compute(self) -> Optional[pulumi.Input[str]]:
        """
        Location of data inside the container process.
        """
        return pulumi.get(self, "path_on_compute")

    @path_on_compute.setter
    def path_on_compute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_on_compute", value)

    @property
    @pulumi.getter(name="pathOnDatastore")
    def path_on_datastore(self) -> Optional[pulumi.Input[str]]:
        """
        Path within the datastore to the data.
        """
        return pulumi.get(self, "path_on_datastore")

    @path_on_datastore.setter
    def path_on_datastore(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_on_datastore", value)


@pulumi.input_type
class OutputPathAssetReferenceArgs:
    def __init__(__self__, *,
                 reference_type: pulumi.Input[str],
                 job_id: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        Reference to an asset via its path in a job output.
        :param pulumi.Input[str] reference_type: Enum to determine which reference method to use for an asset.
               Expected value is 'OutputPath'.
        :param pulumi.Input[str] job_id: ARM resource ID of the job.
        :param pulumi.Input[str] path: The path of the file/directory in the job output.
        """
        pulumi.set(__self__, "reference_type", 'OutputPath')
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="referenceType")
    def reference_type(self) -> pulumi.Input[str]:
        """
        Enum to determine which reference method to use for an asset.
        Expected value is 'OutputPath'.
        """
        return pulumi.get(self, "reference_type")

    @reference_type.setter
    def reference_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "reference_type", value)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the job.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path of the file/directory in the job output.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class PersonalComputeInstanceSettingsArgs:
    def __init__(__self__, *,
                 assigned_user: Optional[pulumi.Input['AssignedUserArgs']] = None):
        """
        Settings for a personal compute instance.
        :param pulumi.Input['AssignedUserArgs'] assigned_user: A user explicitly assigned to a personal compute instance.
        """
        if assigned_user is not None:
            pulumi.set(__self__, "assigned_user", assigned_user)

    @property
    @pulumi.getter(name="assignedUser")
    def assigned_user(self) -> Optional[pulumi.Input['AssignedUserArgs']]:
        """
        A user explicitly assigned to a personal compute instance.
        """
        return pulumi.get(self, "assigned_user")

    @assigned_user.setter
    def assigned_user(self, value: Optional[pulumi.Input['AssignedUserArgs']]):
        pulumi.set(self, "assigned_user", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 actions_required: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param pulumi.Input[str] actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param pulumi.Input[str] description: The reason for approval/rejection of the connection.
        :param pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']] status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[pulumi.Input[str]]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @actions_required.setter
    def actions_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "actions_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ProbeSettingsArgs:
    def __init__(__self__, *,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 initial_delay: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 success_threshold: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        Deployment container liveness/readiness probe configuration.
        :param pulumi.Input[int] failure_threshold: The number of failures to allow before returning an unhealthy status.
        :param pulumi.Input[str] initial_delay: The delay before the first probe in ISO 8601 format.
        :param pulumi.Input[str] period: The length of time between probes in ISO 8601 format.
        :param pulumi.Input[int] success_threshold: The number of successful probes before returning a healthy status.
        :param pulumi.Input[str] timeout: The probe timeout in ISO 8601 format.
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The number of failures to allow before returning an unhealthy status.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[pulumi.Input[str]]:
        """
        The delay before the first probe in ISO 8601 format.
        """
        return pulumi.get(self, "initial_delay")

    @initial_delay.setter
    def initial_delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initial_delay", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[str]]:
        """
        The length of time between probes in ISO 8601 format.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The number of successful probes before returning a healthy status.
        """
        return pulumi.get(self, "success_threshold")

    @success_threshold.setter
    def success_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "success_threshold", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The probe timeout in ISO 8601 format.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class PyTorchArgs:
    def __init__(__self__, *,
                 distribution_type: pulumi.Input[str],
                 process_count: Optional[pulumi.Input[int]] = None):
        """
        PyTorch distribution configuration.
        :param pulumi.Input[str] distribution_type: Enum to determine the job distribution type.
               Expected value is 'PyTorch'.
        :param pulumi.Input[int] process_count: Total process count for the distributed job.
        """
        pulumi.set(__self__, "distribution_type", 'PyTorch')
        if process_count is not None:
            pulumi.set(__self__, "process_count", process_count)

    @property
    @pulumi.getter(name="distributionType")
    def distribution_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the job distribution type.
        Expected value is 'PyTorch'.
        """
        return pulumi.get(self, "distribution_type")

    @distribution_type.setter
    def distribution_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "distribution_type", value)

    @property
    @pulumi.getter(name="processCount")
    def process_count(self) -> Optional[pulumi.Input[int]]:
        """
        Total process count for the distributed job.
        """
        return pulumi.get(self, "process_count")

    @process_count.setter
    def process_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "process_count", value)


@pulumi.input_type
class RecurrenceScheduleArgs:
    def __init__(__self__, *,
                 hours: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 minutes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 week_days: Optional[pulumi.Input[Sequence[pulumi.Input['DaysOfWeek']]]] = None):
        """
        The recurrence schedule
        :param pulumi.Input[Sequence[pulumi.Input[int]]] hours: The hours.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] minutes: The minutes.
        :param pulumi.Input[Sequence[pulumi.Input['DaysOfWeek']]] week_days: The days of the week.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if week_days is not None:
            pulumi.set(__self__, "week_days", week_days)

    @property
    @pulumi.getter
    def hours(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The hours.
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The minutes.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "minutes", value)

    @property
    @pulumi.getter(name="weekDays")
    def week_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DaysOfWeek']]]]:
        """
        The days of the week.
        """
        return pulumi.get(self, "week_days")

    @week_days.setter
    def week_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DaysOfWeek']]]]):
        pulumi.set(self, "week_days", value)


@pulumi.input_type
class RecurrenceArgs:
    def __init__(__self__, *,
                 frequency: Optional[pulumi.Input[Union[str, 'RecurrenceFrequency']]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 schedule: Optional[pulumi.Input['RecurrenceScheduleArgs']] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        The workflow trigger recurrence for ComputeStartStop schedule type.
        :param pulumi.Input[Union[str, 'RecurrenceFrequency']] frequency: The recurrence frequency.
        :param pulumi.Input[int] interval: The interval.
        :param pulumi.Input['RecurrenceScheduleArgs'] schedule: The recurrence schedule
        :param pulumi.Input[str] start_time: The start time.
        :param pulumi.Input[str] time_zone: The time zone.
        """
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[Union[str, 'RecurrenceFrequency']]]:
        """
        The recurrence frequency.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[Union[str, 'RecurrenceFrequency']]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        The interval.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['RecurrenceScheduleArgs']]:
        """
        The recurrence schedule
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['RecurrenceScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The start time.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class ResourceIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'ResourceIdentityAssignment']]] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, pulumi.Input['UserAssignedIdentityMetaArgs']]]] = None):
        """
        Service identity associated with a resource.
        :param pulumi.Input[Union[str, 'ResourceIdentityAssignment']] type: Defines values for a ResourceIdentity's type.
        :param pulumi.Input[Mapping[str, pulumi.Input['UserAssignedIdentityMetaArgs']]] user_assigned_identities: Dictionary of the user assigned identities, key is ARM resource ID of the UAI.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ResourceIdentityAssignment']]]:
        """
        Defines values for a ResourceIdentity's type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ResourceIdentityAssignment']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['UserAssignedIdentityMetaArgs']]]]:
        """
        Dictionary of the user assigned identities, key is ARM resource ID of the UAI.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['UserAssignedIdentityMetaArgs']]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class ResourceIdArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
        :param pulumi.Input[str] id: The ID of the resource
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The ID of the resource
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class RouteArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 port: pulumi.Input[int]):
        """
        :param pulumi.Input[str] path: [Required] The path for the route.
        :param pulumi.Input[int] port: [Required] The port for the route.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        [Required] The path for the route.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        [Required] The port for the route.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class SasDatastoreCredentialsArgs:
    def __init__(__self__, *,
                 credentials_type: pulumi.Input[str],
                 secrets: Optional[pulumi.Input['SasDatastoreSecretsArgs']] = None):
        """
        SAS datastore credentials configuration.
        :param pulumi.Input[str] credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'Sas'.
        :param pulumi.Input['SasDatastoreSecretsArgs'] secrets: Storage container secrets.
        """
        pulumi.set(__self__, "credentials_type", 'Sas')
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'Sas'.
        """
        return pulumi.get(self, "credentials_type")

    @credentials_type.setter
    def credentials_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credentials_type", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input['SasDatastoreSecretsArgs']]:
        """
        Storage container secrets.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input['SasDatastoreSecretsArgs']]):
        pulumi.set(self, "secrets", value)


@pulumi.input_type
class SasDatastoreSecretsArgs:
    def __init__(__self__, *,
                 secrets_type: pulumi.Input[str],
                 sas_token: Optional[pulumi.Input[str]] = None):
        """
        Datastore SAS secrets.
        :param pulumi.Input[str] secrets_type: Enum to determine the datastore secrets type.
               Expected value is 'Sas'.
        :param pulumi.Input[str] sas_token: Storage container SAS token.
        """
        pulumi.set(__self__, "secrets_type", 'Sas')
        if sas_token is not None:
            pulumi.set(__self__, "sas_token", sas_token)

    @property
    @pulumi.getter(name="secretsType")
    def secrets_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore secrets type.
        Expected value is 'Sas'.
        """
        return pulumi.get(self, "secrets_type")

    @secrets_type.setter
    def secrets_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "secrets_type", value)

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> Optional[pulumi.Input[str]]:
        """
        Storage container SAS token.
        """
        return pulumi.get(self, "sas_token")

    @sas_token.setter
    def sas_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_token", value)


@pulumi.input_type
class ScaleSettingsArgs:
    def __init__(__self__, *,
                 max_node_count: pulumi.Input[int],
                 min_node_count: Optional[pulumi.Input[int]] = None,
                 node_idle_time_before_scale_down: Optional[pulumi.Input[str]] = None):
        """
        scale settings for AML Compute
        :param pulumi.Input[int] max_node_count: Max number of nodes to use
        :param pulumi.Input[int] min_node_count: Min number of nodes to use
        :param pulumi.Input[str] node_idle_time_before_scale_down: Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
        """
        pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is None:
            min_node_count = 0
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)
        if node_idle_time_before_scale_down is not None:
            pulumi.set(__self__, "node_idle_time_before_scale_down", node_idle_time_before_scale_down)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> pulumi.Input[int]:
        """
        Max number of nodes to use
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Min number of nodes to use
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_node_count", value)

    @property
    @pulumi.getter(name="nodeIdleTimeBeforeScaleDown")
    def node_idle_time_before_scale_down(self) -> Optional[pulumi.Input[str]]:
        """
        Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
        """
        return pulumi.get(self, "node_idle_time_before_scale_down")

    @node_idle_time_before_scale_down.setter
    def node_idle_time_before_scale_down(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_idle_time_before_scale_down", value)


@pulumi.input_type
class ScriptReferenceArgs:
    def __init__(__self__, *,
                 script_arguments: Optional[pulumi.Input[str]] = None,
                 script_data: Optional[pulumi.Input[str]] = None,
                 script_source: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        Script reference
        :param pulumi.Input[str] script_arguments: Optional command line arguments passed to the script to run.
        :param pulumi.Input[str] script_data: The location of scripts in the mounted volume.
        :param pulumi.Input[str] script_source: The storage source of the script: inline, workspace.
        :param pulumi.Input[str] timeout: Optional time period passed to timeout command.
        """
        if script_arguments is not None:
            pulumi.set(__self__, "script_arguments", script_arguments)
        if script_data is not None:
            pulumi.set(__self__, "script_data", script_data)
        if script_source is not None:
            pulumi.set(__self__, "script_source", script_source)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="scriptArguments")
    def script_arguments(self) -> Optional[pulumi.Input[str]]:
        """
        Optional command line arguments passed to the script to run.
        """
        return pulumi.get(self, "script_arguments")

    @script_arguments.setter
    def script_arguments(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_arguments", value)

    @property
    @pulumi.getter(name="scriptData")
    def script_data(self) -> Optional[pulumi.Input[str]]:
        """
        The location of scripts in the mounted volume.
        """
        return pulumi.get(self, "script_data")

    @script_data.setter
    def script_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_data", value)

    @property
    @pulumi.getter(name="scriptSource")
    def script_source(self) -> Optional[pulumi.Input[str]]:
        """
        The storage source of the script: inline, workspace.
        """
        return pulumi.get(self, "script_source")

    @script_source.setter
    def script_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_source", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Optional time period passed to timeout command.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class ScriptsToExecuteArgs:
    def __init__(__self__, *,
                 creation_script: Optional[pulumi.Input['ScriptReferenceArgs']] = None,
                 startup_script: Optional[pulumi.Input['ScriptReferenceArgs']] = None):
        """
        Customized setup scripts
        :param pulumi.Input['ScriptReferenceArgs'] creation_script: Script that's run only once during provision of the compute.
        :param pulumi.Input['ScriptReferenceArgs'] startup_script: Script that's run every time the machine starts.
        """
        if creation_script is not None:
            pulumi.set(__self__, "creation_script", creation_script)
        if startup_script is not None:
            pulumi.set(__self__, "startup_script", startup_script)

    @property
    @pulumi.getter(name="creationScript")
    def creation_script(self) -> Optional[pulumi.Input['ScriptReferenceArgs']]:
        """
        Script that's run only once during provision of the compute.
        """
        return pulumi.get(self, "creation_script")

    @creation_script.setter
    def creation_script(self, value: Optional[pulumi.Input['ScriptReferenceArgs']]):
        pulumi.set(self, "creation_script", value)

    @property
    @pulumi.getter(name="startupScript")
    def startup_script(self) -> Optional[pulumi.Input['ScriptReferenceArgs']]:
        """
        Script that's run every time the machine starts.
        """
        return pulumi.get(self, "startup_script")

    @startup_script.setter
    def startup_script(self, value: Optional[pulumi.Input['ScriptReferenceArgs']]):
        pulumi.set(self, "startup_script", value)


@pulumi.input_type
class ServiceManagedResourcesSettingsArgs:
    def __init__(__self__, *,
                 cosmos_db: Optional[pulumi.Input['CosmosDbSettingsArgs']] = None):
        """
        :param pulumi.Input['CosmosDbSettingsArgs'] cosmos_db: The settings for the service managed cosmosdb account.
        """
        if cosmos_db is not None:
            pulumi.set(__self__, "cosmos_db", cosmos_db)

    @property
    @pulumi.getter(name="cosmosDb")
    def cosmos_db(self) -> Optional[pulumi.Input['CosmosDbSettingsArgs']]:
        """
        The settings for the service managed cosmosdb account.
        """
        return pulumi.get(self, "cosmos_db")

    @cosmos_db.setter
    def cosmos_db(self, value: Optional[pulumi.Input['CosmosDbSettingsArgs']]):
        pulumi.set(self, "cosmos_db", value)


@pulumi.input_type
class ServicePrincipalDatastoreCredentialsArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[str],
                 credentials_type: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 authority_url: Optional[pulumi.Input[str]] = None,
                 resource_uri: Optional[pulumi.Input[str]] = None,
                 secrets: Optional[pulumi.Input['ServicePrincipalDatastoreSecretsArgs']] = None):
        """
        Service Principal datastore credentials configuration.
        :param pulumi.Input[str] client_id: [Required] Service principal client ID.
        :param pulumi.Input[str] credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'ServicePrincipal'.
        :param pulumi.Input[str] tenant_id: [Required] ID of the tenant to which the service principal belongs.
        :param pulumi.Input[str] authority_url: Authority URL used for authentication.
        :param pulumi.Input[str] resource_uri: Resource the service principal has access to.
        :param pulumi.Input['ServicePrincipalDatastoreSecretsArgs'] secrets: Service principal secrets.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "credentials_type", 'ServicePrincipal')
        pulumi.set(__self__, "tenant_id", tenant_id)
        if authority_url is not None:
            pulumi.set(__self__, "authority_url", authority_url)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        [Required] Service principal client ID.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'ServicePrincipal'.
        """
        return pulumi.get(self, "credentials_type")

    @credentials_type.setter
    def credentials_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credentials_type", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        [Required] ID of the tenant to which the service principal belongs.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="authorityUrl")
    def authority_url(self) -> Optional[pulumi.Input[str]]:
        """
        Authority URL used for authentication.
        """
        return pulumi.get(self, "authority_url")

    @authority_url.setter
    def authority_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authority_url", value)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Resource the service principal has access to.
        """
        return pulumi.get(self, "resource_uri")

    @resource_uri.setter
    def resource_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_uri", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input['ServicePrincipalDatastoreSecretsArgs']]:
        """
        Service principal secrets.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input['ServicePrincipalDatastoreSecretsArgs']]):
        pulumi.set(self, "secrets", value)


@pulumi.input_type
class ServicePrincipalDatastoreSecretsArgs:
    def __init__(__self__, *,
                 secrets_type: pulumi.Input[str],
                 client_secret: Optional[pulumi.Input[str]] = None):
        """
        Datastore Service Principal secrets.
        :param pulumi.Input[str] secrets_type: Enum to determine the datastore secrets type.
               Expected value is 'ServicePrincipal'.
        :param pulumi.Input[str] client_secret: Service principal secret.
        """
        pulumi.set(__self__, "secrets_type", 'ServicePrincipal')
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)

    @property
    @pulumi.getter(name="secretsType")
    def secrets_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore secrets type.
        Expected value is 'ServicePrincipal'.
        """
        return pulumi.get(self, "secrets_type")

    @secrets_type.setter
    def secrets_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "secrets_type", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Service principal secret.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)


@pulumi.input_type
class SetupScriptsArgs:
    def __init__(__self__, *,
                 scripts: Optional[pulumi.Input['ScriptsToExecuteArgs']] = None):
        """
        Details of customized scripts to execute for setting up the cluster.
        :param pulumi.Input['ScriptsToExecuteArgs'] scripts: Customized setup scripts
        """
        if scripts is not None:
            pulumi.set(__self__, "scripts", scripts)

    @property
    @pulumi.getter
    def scripts(self) -> Optional[pulumi.Input['ScriptsToExecuteArgs']]:
        """
        Customized setup scripts
        """
        return pulumi.get(self, "scripts")

    @scripts.setter
    def scripts(self, value: Optional[pulumi.Input['ScriptsToExecuteArgs']]):
        pulumi.set(self, "scripts", value)


@pulumi.input_type
class SharedPrivateLinkResourceArgs:
    def __init__(__self__, *,
                 group_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_link_resource_id: Optional[pulumi.Input[str]] = None,
                 request_message: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]] = None):
        """
        :param pulumi.Input[str] group_id: The private link resource group id.
        :param pulumi.Input[str] name: Unique name of the private link.
        :param pulumi.Input[str] private_link_resource_id: The resource id that private link links to.
        :param pulumi.Input[str] request_message: Request message.
        :param pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']] status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_link_resource_id is not None:
            pulumi.set(__self__, "private_link_resource_id", private_link_resource_id)
        if request_message is not None:
            pulumi.set(__self__, "request_message", request_message)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The private link resource group id.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the private link.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateLinkResourceId")
    def private_link_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id that private link links to.
        """
        return pulumi.get(self, "private_link_resource_id")

    @private_link_resource_id.setter
    def private_link_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_link_resource_id", value)

    @property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> Optional[pulumi.Input[str]]:
        """
        Request message.
        """
        return pulumi.get(self, "request_message")

    @request_message.setter
    def request_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_message", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        Sku of the resource
        :param pulumi.Input[str] name: Name of the sku
        :param pulumi.Input[str] tier: Tier of the sku like Basic or Enterprise
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the sku
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        Tier of the sku like Basic or Enterprise
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SqlAdminDatastoreCredentialsArgs:
    def __init__(__self__, *,
                 credentials_type: pulumi.Input[str],
                 user_id: pulumi.Input[str],
                 secrets: Optional[pulumi.Input['SqlAdminDatastoreSecretsArgs']] = None):
        """
        SQL Admin datastore credentials configuration.
        :param pulumi.Input[str] credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'SqlAdmin'.
        :param pulumi.Input[str] user_id: [Required] SQL database user name.
        :param pulumi.Input['SqlAdminDatastoreSecretsArgs'] secrets: SQL database secrets.
        """
        pulumi.set(__self__, "credentials_type", 'SqlAdmin')
        pulumi.set(__self__, "user_id", user_id)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'SqlAdmin'.
        """
        return pulumi.get(self, "credentials_type")

    @credentials_type.setter
    def credentials_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credentials_type", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[str]:
        """
        [Required] SQL database user name.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input['SqlAdminDatastoreSecretsArgs']]:
        """
        SQL database secrets.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input['SqlAdminDatastoreSecretsArgs']]):
        pulumi.set(self, "secrets", value)


@pulumi.input_type
class SqlAdminDatastoreSecretsArgs:
    def __init__(__self__, *,
                 secrets_type: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None):
        """
        Datastore SQL Admin secrets.
        :param pulumi.Input[str] secrets_type: Enum to determine the datastore secrets type.
               Expected value is 'SqlAdmin'.
        :param pulumi.Input[str] password: SQL database password.
        """
        pulumi.set(__self__, "secrets_type", 'SqlAdmin')
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="secretsType")
    def secrets_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore secrets type.
        Expected value is 'SqlAdmin'.
        """
        return pulumi.get(self, "secrets_type")

    @secrets_type.setter
    def secrets_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "secrets_type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        SQL database password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)


@pulumi.input_type
class SslConfigurationArgs:
    def __init__(__self__, *,
                 cert: Optional[pulumi.Input[str]] = None,
                 cname: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 leaf_domain_label: Optional[pulumi.Input[str]] = None,
                 overwrite_existing_domain: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        The ssl configuration for scoring
        :param pulumi.Input[str] cert: Cert data
        :param pulumi.Input[str] cname: CNAME of the cert
        :param pulumi.Input[str] key: Key data
        :param pulumi.Input[str] leaf_domain_label: Leaf domain label of public endpoint
        :param pulumi.Input[bool] overwrite_existing_domain: Indicates whether to overwrite existing domain label.
        :param pulumi.Input[str] status: Enable or disable ssl for scoring
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if leaf_domain_label is not None:
            pulumi.set(__self__, "leaf_domain_label", leaf_domain_label)
        if overwrite_existing_domain is not None:
            pulumi.set(__self__, "overwrite_existing_domain", overwrite_existing_domain)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[str]]:
        """
        Cert data
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert", value)

    @property
    @pulumi.getter
    def cname(self) -> Optional[pulumi.Input[str]]:
        """
        CNAME of the cert
        """
        return pulumi.get(self, "cname")

    @cname.setter
    def cname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cname", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Key data
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="leafDomainLabel")
    def leaf_domain_label(self) -> Optional[pulumi.Input[str]]:
        """
        Leaf domain label of public endpoint
        """
        return pulumi.get(self, "leaf_domain_label")

    @leaf_domain_label.setter
    def leaf_domain_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "leaf_domain_label", value)

    @property
    @pulumi.getter(name="overwriteExistingDomain")
    def overwrite_existing_domain(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to overwrite existing domain label.
        """
        return pulumi.get(self, "overwrite_existing_domain")

    @overwrite_existing_domain.setter
    def overwrite_existing_domain(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "overwrite_existing_domain", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Enable or disable ssl for scoring
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class SweepJobArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input[Union[str, 'SamplingAlgorithm']],
                 compute: pulumi.Input['ComputeConfigurationArgs'],
                 job_type: pulumi.Input[str],
                 objective: pulumi.Input['ObjectiveArgs'],
                 search_space: pulumi.Input[Mapping[str, Any]],
                 description: Optional[pulumi.Input[str]] = None,
                 early_termination: Optional[pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']]] = None,
                 experiment_name: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs']]] = None,
                 max_concurrent_trials: Optional[pulumi.Input[int]] = None,
                 max_total_trials: Optional[pulumi.Input[int]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 trial: Optional[pulumi.Input['TrialComponentArgs']] = None):
        """
        Sweep job definition.
        :param pulumi.Input[Union[str, 'SamplingAlgorithm']] algorithm: [Required] Type of the hyperparameter sampling algorithms
        :param pulumi.Input['ComputeConfigurationArgs'] compute: [Required] Compute binding for the job.
        :param pulumi.Input[str] job_type: Enum to determine the type of job.
               Expected value is 'Sweep'.
        :param pulumi.Input['ObjectiveArgs'] objective: [Required] Optimization objective.
        :param pulumi.Input[Mapping[str, Any]] search_space: [Required] A dictionary containing each parameter and its distribution. The dictionary key is the name of the parameter
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']] early_termination: Early termination policies enable canceling poor-performing runs before they complete.
        :param pulumi.Input[str] experiment_name: The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        :param pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs']] identity: Identity configuration. If set, this should be one of AmlToken, ManagedIdentity or null.
               Defaults to AmlToken if null.
        :param pulumi.Input[int] max_concurrent_trials: An upper bound on the number of trials performed in parallel.
        :param pulumi.Input[int] max_total_trials: An upper bound on the number of trials to perform.
        :param pulumi.Input[int] priority: Job priority for scheduling policy. Only applies to AMLCompute.
               Private preview feature and only available to users on the allow list.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        :param pulumi.Input[str] timeout: The total timeout in ISO 8601 format. Only supports duration with precision as low as Minutes.
        :param pulumi.Input['TrialComponentArgs'] trial: Trial component definition.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "compute", compute)
        pulumi.set(__self__, "job_type", 'Sweep')
        pulumi.set(__self__, "objective", objective)
        pulumi.set(__self__, "search_space", search_space)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if early_termination is not None:
            pulumi.set(__self__, "early_termination", early_termination)
        if experiment_name is not None:
            pulumi.set(__self__, "experiment_name", experiment_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if max_concurrent_trials is not None:
            pulumi.set(__self__, "max_concurrent_trials", max_concurrent_trials)
        if max_total_trials is not None:
            pulumi.set(__self__, "max_total_trials", max_total_trials)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if trial is not None:
            pulumi.set(__self__, "trial", trial)

    @property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input[Union[str, 'SamplingAlgorithm']]:
        """
        [Required] Type of the hyperparameter sampling algorithms
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input[Union[str, 'SamplingAlgorithm']]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter
    def compute(self) -> pulumi.Input['ComputeConfigurationArgs']:
        """
        [Required] Compute binding for the job.
        """
        return pulumi.get(self, "compute")

    @compute.setter
    def compute(self, value: pulumi.Input['ComputeConfigurationArgs']):
        pulumi.set(self, "compute", value)

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the type of job.
        Expected value is 'Sweep'.
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_type", value)

    @property
    @pulumi.getter
    def objective(self) -> pulumi.Input['ObjectiveArgs']:
        """
        [Required] Optimization objective.
        """
        return pulumi.get(self, "objective")

    @objective.setter
    def objective(self, value: pulumi.Input['ObjectiveArgs']):
        pulumi.set(self, "objective", value)

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> pulumi.Input[Mapping[str, Any]]:
        """
        [Required] A dictionary containing each parameter and its distribution. The dictionary key is the name of the parameter
        """
        return pulumi.get(self, "search_space")

    @search_space.setter
    def search_space(self, value: pulumi.Input[Mapping[str, Any]]):
        pulumi.set(self, "search_space", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="earlyTermination")
    def early_termination(self) -> Optional[pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']]]:
        """
        Early termination policies enable canceling poor-performing runs before they complete.
        """
        return pulumi.get(self, "early_termination")

    @early_termination.setter
    def early_termination(self, value: Optional[pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']]]):
        pulumi.set(self, "early_termination", value)

    @property
    @pulumi.getter(name="experimentName")
    def experiment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        """
        return pulumi.get(self, "experiment_name")

    @experiment_name.setter
    def experiment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "experiment_name", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs']]]:
        """
        Identity configuration. If set, this should be one of AmlToken, ManagedIdentity or null.
        Defaults to AmlToken if null.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs']]]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="maxConcurrentTrials")
    def max_concurrent_trials(self) -> Optional[pulumi.Input[int]]:
        """
        An upper bound on the number of trials performed in parallel.
        """
        return pulumi.get(self, "max_concurrent_trials")

    @max_concurrent_trials.setter
    def max_concurrent_trials(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_trials", value)

    @property
    @pulumi.getter(name="maxTotalTrials")
    def max_total_trials(self) -> Optional[pulumi.Input[int]]:
        """
        An upper bound on the number of trials to perform.
        """
        return pulumi.get(self, "max_total_trials")

    @max_total_trials.setter
    def max_total_trials(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_total_trials", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Job priority for scheduling policy. Only applies to AMLCompute.
        Private preview feature and only available to users on the allow list.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The total timeout in ISO 8601 format. Only supports duration with precision as low as Minutes.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def trial(self) -> Optional[pulumi.Input['TrialComponentArgs']]:
        """
        Trial component definition.
        """
        return pulumi.get(self, "trial")

    @trial.setter
    def trial(self, value: Optional[pulumi.Input['TrialComponentArgs']]):
        pulumi.set(self, "trial", value)


@pulumi.input_type
class SynapseSparkPoolPropertiesPropertiesArgs:
    def __init__(__self__, *,
                 auto_pause_properties: Optional[pulumi.Input['AutoPausePropertiesArgs']] = None,
                 auto_scale_properties: Optional[pulumi.Input['AutoScalePropertiesArgs']] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 node_size: Optional[pulumi.Input[str]] = None,
                 node_size_family: Optional[pulumi.Input[str]] = None,
                 pool_name: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 spark_version: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 workspace_name: Optional[pulumi.Input[str]] = None):
        """
        AKS properties
        :param pulumi.Input['AutoPausePropertiesArgs'] auto_pause_properties: Auto pause properties.
        :param pulumi.Input['AutoScalePropertiesArgs'] auto_scale_properties: Auto scale properties.
        :param pulumi.Input[int] node_count: The number of compute nodes currently assigned to the compute.
        :param pulumi.Input[str] node_size: Node size.
        :param pulumi.Input[str] node_size_family: Node size family.
        :param pulumi.Input[str] pool_name: Pool name.
        :param pulumi.Input[str] resource_group: Name of the resource group in which workspace is located.
        :param pulumi.Input[str] spark_version: Spark version.
        :param pulumi.Input[str] subscription_id: Azure subscription identifier.
        :param pulumi.Input[str] workspace_name: Name of Azure Machine Learning workspace.
        """
        if auto_pause_properties is not None:
            pulumi.set(__self__, "auto_pause_properties", auto_pause_properties)
        if auto_scale_properties is not None:
            pulumi.set(__self__, "auto_scale_properties", auto_scale_properties)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_size is not None:
            pulumi.set(__self__, "node_size", node_size)
        if node_size_family is not None:
            pulumi.set(__self__, "node_size_family", node_size_family)
        if pool_name is not None:
            pulumi.set(__self__, "pool_name", pool_name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if spark_version is not None:
            pulumi.set(__self__, "spark_version", spark_version)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if workspace_name is not None:
            pulumi.set(__self__, "workspace_name", workspace_name)

    @property
    @pulumi.getter(name="autoPauseProperties")
    def auto_pause_properties(self) -> Optional[pulumi.Input['AutoPausePropertiesArgs']]:
        """
        Auto pause properties.
        """
        return pulumi.get(self, "auto_pause_properties")

    @auto_pause_properties.setter
    def auto_pause_properties(self, value: Optional[pulumi.Input['AutoPausePropertiesArgs']]):
        pulumi.set(self, "auto_pause_properties", value)

    @property
    @pulumi.getter(name="autoScaleProperties")
    def auto_scale_properties(self) -> Optional[pulumi.Input['AutoScalePropertiesArgs']]:
        """
        Auto scale properties.
        """
        return pulumi.get(self, "auto_scale_properties")

    @auto_scale_properties.setter
    def auto_scale_properties(self, value: Optional[pulumi.Input['AutoScalePropertiesArgs']]):
        pulumi.set(self, "auto_scale_properties", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of compute nodes currently assigned to the compute.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nodeSize")
    def node_size(self) -> Optional[pulumi.Input[str]]:
        """
        Node size.
        """
        return pulumi.get(self, "node_size")

    @node_size.setter
    def node_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_size", value)

    @property
    @pulumi.getter(name="nodeSizeFamily")
    def node_size_family(self) -> Optional[pulumi.Input[str]]:
        """
        Node size family.
        """
        return pulumi.get(self, "node_size_family")

    @node_size_family.setter
    def node_size_family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_size_family", value)

    @property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        Pool name.
        """
        return pulumi.get(self, "pool_name")

    @pool_name.setter
    def pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool_name", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource group in which workspace is located.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> Optional[pulumi.Input[str]]:
        """
        Spark version.
        """
        return pulumi.get(self, "spark_version")

    @spark_version.setter
    def spark_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spark_version", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure subscription identifier.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of Azure Machine Learning workspace.
        """
        return pulumi.get(self, "workspace_name")

    @workspace_name.setter
    def workspace_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_name", value)


@pulumi.input_type
class SynapseSparkArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['SynapseSparkPoolPropertiesPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A SynapseSpark compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'SynapseSpark'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input['SynapseSparkPoolPropertiesPropertiesArgs'] properties: AKS properties
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'SynapseSpark')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'SynapseSpark'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['SynapseSparkPoolPropertiesPropertiesArgs']]:
        """
        AKS properties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['SynapseSparkPoolPropertiesPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class TensorFlowArgs:
    def __init__(__self__, *,
                 distribution_type: pulumi.Input[str],
                 parameter_server_count: Optional[pulumi.Input[int]] = None,
                 worker_count: Optional[pulumi.Input[int]] = None):
        """
        TensorFlow distribution configuration.
        :param pulumi.Input[str] distribution_type: Enum to determine the job distribution type.
               Expected value is 'TensorFlow'.
        :param pulumi.Input[int] parameter_server_count: Number of parameter server tasks.
        :param pulumi.Input[int] worker_count: Number of workers. Overwrites the node count in compute binding.
        """
        pulumi.set(__self__, "distribution_type", 'TensorFlow')
        if parameter_server_count is not None:
            pulumi.set(__self__, "parameter_server_count", parameter_server_count)
        if worker_count is not None:
            pulumi.set(__self__, "worker_count", worker_count)

    @property
    @pulumi.getter(name="distributionType")
    def distribution_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the job distribution type.
        Expected value is 'TensorFlow'.
        """
        return pulumi.get(self, "distribution_type")

    @distribution_type.setter
    def distribution_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "distribution_type", value)

    @property
    @pulumi.getter(name="parameterServerCount")
    def parameter_server_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of parameter server tasks.
        """
        return pulumi.get(self, "parameter_server_count")

    @parameter_server_count.setter
    def parameter_server_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "parameter_server_count", value)

    @property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of workers. Overwrites the node count in compute binding.
        """
        return pulumi.get(self, "worker_count")

    @worker_count.setter
    def worker_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "worker_count", value)


@pulumi.input_type
class TrialComponentArgs:
    def __init__(__self__, *,
                 command: pulumi.Input[str],
                 code_id: Optional[pulumi.Input[str]] = None,
                 distribution: Optional[pulumi.Input[Union['MpiArgs', 'PyTorchArgs', 'TensorFlowArgs']]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input_data_bindings: Optional[pulumi.Input[Mapping[str, pulumi.Input['InputDataBindingArgs']]]] = None,
                 output_data_bindings: Optional[pulumi.Input[Mapping[str, pulumi.Input['OutputDataBindingArgs']]]] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        Trial component definition.
        :param pulumi.Input[str] command: [Required] The command to execute on startup of the job. eg. "python train.py"
        :param pulumi.Input[str] code_id: ARM resource ID of the code asset.
        :param pulumi.Input[Union['MpiArgs', 'PyTorchArgs', 'TensorFlowArgs']] distribution: Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        :param pulumi.Input[str] environment_id: The ARM resource ID of the Environment specification for the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables included in the job.
        :param pulumi.Input[Mapping[str, pulumi.Input['InputDataBindingArgs']]] input_data_bindings: Mapping of input data bindings used in the job.
        :param pulumi.Input[Mapping[str, pulumi.Input['OutputDataBindingArgs']]] output_data_bindings: Mapping of output data bindings used in the job.
        :param pulumi.Input[str] timeout: The max run duration in ISO 8601 format, after which the trial component will be cancelled.
               Only supports duration with precision as low as Seconds.
        """
        pulumi.set(__self__, "command", command)
        if code_id is not None:
            pulumi.set(__self__, "code_id", code_id)
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if input_data_bindings is not None:
            pulumi.set(__self__, "input_data_bindings", input_data_bindings)
        if output_data_bindings is not None:
            pulumi.set(__self__, "output_data_bindings", output_data_bindings)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def command(self) -> pulumi.Input[str]:
        """
        [Required] The command to execute on startup of the job. eg. "python train.py"
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: pulumi.Input[str]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter(name="codeId")
    def code_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the code asset.
        """
        return pulumi.get(self, "code_id")

    @code_id.setter
    def code_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_id", value)

    @property
    @pulumi.getter
    def distribution(self) -> Optional[pulumi.Input[Union['MpiArgs', 'PyTorchArgs', 'TensorFlowArgs']]]:
        """
        Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        """
        return pulumi.get(self, "distribution")

    @distribution.setter
    def distribution(self, value: Optional[pulumi.Input[Union['MpiArgs', 'PyTorchArgs', 'TensorFlowArgs']]]):
        pulumi.set(self, "distribution", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARM resource ID of the Environment specification for the job.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables included in the job.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="inputDataBindings")
    def input_data_bindings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['InputDataBindingArgs']]]]:
        """
        Mapping of input data bindings used in the job.
        """
        return pulumi.get(self, "input_data_bindings")

    @input_data_bindings.setter
    def input_data_bindings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['InputDataBindingArgs']]]]):
        pulumi.set(self, "input_data_bindings", value)

    @property
    @pulumi.getter(name="outputDataBindings")
    def output_data_bindings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['OutputDataBindingArgs']]]]:
        """
        Mapping of output data bindings used in the job.
        """
        return pulumi.get(self, "output_data_bindings")

    @output_data_bindings.setter
    def output_data_bindings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['OutputDataBindingArgs']]]]):
        pulumi.set(self, "output_data_bindings", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The max run duration in ISO 8601 format, after which the trial component will be cancelled.
        Only supports duration with precision as low as Seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class TruncationSelectionPolicyArgs:
    def __init__(__self__, *,
                 policy_type: pulumi.Input[str],
                 delay_evaluation: Optional[pulumi.Input[int]] = None,
                 evaluation_interval: Optional[pulumi.Input[int]] = None,
                 truncation_percentage: Optional[pulumi.Input[int]] = None):
        """
        Defines an early termination policy that cancels a given percentage of runs at each evaluation interval.
        :param pulumi.Input[str] policy_type: 
               Expected value is 'TruncationSelection'.
        :param pulumi.Input[int] delay_evaluation: Number of intervals by which to delay the first evaluation.
        :param pulumi.Input[int] evaluation_interval: Interval (number of runs) between policy evaluations.
        :param pulumi.Input[int] truncation_percentage: The percentage of runs to cancel at each evaluation interval.
        """
        pulumi.set(__self__, "policy_type", 'TruncationSelection')
        if delay_evaluation is not None:
            pulumi.set(__self__, "delay_evaluation", delay_evaluation)
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)
        if truncation_percentage is not None:
            pulumi.set(__self__, "truncation_percentage", truncation_percentage)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'TruncationSelection'.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter(name="delayEvaluation")
    def delay_evaluation(self) -> Optional[pulumi.Input[int]]:
        """
        Number of intervals by which to delay the first evaluation.
        """
        return pulumi.get(self, "delay_evaluation")

    @delay_evaluation.setter
    def delay_evaluation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_evaluation", value)

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Interval (number of runs) between policy evaluations.
        """
        return pulumi.get(self, "evaluation_interval")

    @evaluation_interval.setter
    def evaluation_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "evaluation_interval", value)

    @property
    @pulumi.getter(name="truncationPercentage")
    def truncation_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage of runs to cancel at each evaluation interval.
        """
        return pulumi.get(self, "truncation_percentage")

    @truncation_percentage.setter
    def truncation_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "truncation_percentage", value)


@pulumi.input_type
class UserAccountCredentialsArgs:
    def __init__(__self__, *,
                 admin_user_name: pulumi.Input[str],
                 admin_user_password: Optional[pulumi.Input[str]] = None,
                 admin_user_ssh_public_key: Optional[pulumi.Input[str]] = None):
        """
        Settings for user account that gets created on each on the nodes of a compute.
        :param pulumi.Input[str] admin_user_name: Name of the administrator user account which can be used to SSH to nodes.
        :param pulumi.Input[str] admin_user_password: Password of the administrator user account.
        :param pulumi.Input[str] admin_user_ssh_public_key: SSH public key of the administrator user account.
        """
        pulumi.set(__self__, "admin_user_name", admin_user_name)
        if admin_user_password is not None:
            pulumi.set(__self__, "admin_user_password", admin_user_password)
        if admin_user_ssh_public_key is not None:
            pulumi.set(__self__, "admin_user_ssh_public_key", admin_user_ssh_public_key)

    @property
    @pulumi.getter(name="adminUserName")
    def admin_user_name(self) -> pulumi.Input[str]:
        """
        Name of the administrator user account which can be used to SSH to nodes.
        """
        return pulumi.get(self, "admin_user_name")

    @admin_user_name.setter
    def admin_user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_user_name", value)

    @property
    @pulumi.getter(name="adminUserPassword")
    def admin_user_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password of the administrator user account.
        """
        return pulumi.get(self, "admin_user_password")

    @admin_user_password.setter
    def admin_user_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_user_password", value)

    @property
    @pulumi.getter(name="adminUserSshPublicKey")
    def admin_user_ssh_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        SSH public key of the administrator user account.
        """
        return pulumi.get(self, "admin_user_ssh_public_key")

    @admin_user_ssh_public_key.setter
    def admin_user_ssh_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_user_ssh_public_key", value)


@pulumi.input_type
class UserAssignedIdentityMetaArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 principal_id: Optional[pulumi.Input[str]] = None):
        """
        User assigned identities associated with a resource.
        :param pulumi.Input[str] client_id: Aka application ID, a unique identifier generated by Azure AD that is tied to an application and service principal during its initial provisioning.
        :param pulumi.Input[str] principal_id: The object ID of the service principal object for your managed identity that is used to grant role-based access to an Azure resource.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Aka application ID, a unique identifier generated by Azure AD that is tied to an application and service principal during its initial provisioning.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        The object ID of the service principal object for your managed identity that is used to grant role-based access to an Azure resource.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)


@pulumi.input_type
class VirtualMachineImageArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Virtual Machine image for Windows AML Compute
        :param pulumi.Input[str] id: Virtual Machine image path
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Virtual Machine image path
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class VirtualMachinePropertiesArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 administrator_account: Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']] = None,
                 is_notebook_instance_compute: Optional[pulumi.Input[bool]] = None,
                 ssh_port: Optional[pulumi.Input[int]] = None,
                 virtual_machine_size: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: Public IP address of the virtual machine.
        :param pulumi.Input['VirtualMachineSshCredentialsArgs'] administrator_account: Admin credentials for virtual machine
        :param pulumi.Input[bool] is_notebook_instance_compute: Indicates whether this compute will be used for running notebooks.
        :param pulumi.Input[int] ssh_port: Port open for ssh connections.
        :param pulumi.Input[str] virtual_machine_size: Virtual Machine size
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if administrator_account is not None:
            pulumi.set(__self__, "administrator_account", administrator_account)
        if is_notebook_instance_compute is not None:
            pulumi.set(__self__, "is_notebook_instance_compute", is_notebook_instance_compute)
        if ssh_port is not None:
            pulumi.set(__self__, "ssh_port", ssh_port)
        if virtual_machine_size is not None:
            pulumi.set(__self__, "virtual_machine_size", virtual_machine_size)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address of the virtual machine.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="administratorAccount")
    def administrator_account(self) -> Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']]:
        """
        Admin credentials for virtual machine
        """
        return pulumi.get(self, "administrator_account")

    @administrator_account.setter
    def administrator_account(self, value: Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']]):
        pulumi.set(self, "administrator_account", value)

    @property
    @pulumi.getter(name="isNotebookInstanceCompute")
    def is_notebook_instance_compute(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this compute will be used for running notebooks.
        """
        return pulumi.get(self, "is_notebook_instance_compute")

    @is_notebook_instance_compute.setter
    def is_notebook_instance_compute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_notebook_instance_compute", value)

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> Optional[pulumi.Input[int]]:
        """
        Port open for ssh connections.
        """
        return pulumi.get(self, "ssh_port")

    @ssh_port.setter
    def ssh_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ssh_port", value)

    @property
    @pulumi.getter(name="virtualMachineSize")
    def virtual_machine_size(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual Machine size
        """
        return pulumi.get(self, "virtual_machine_size")

    @virtual_machine_size.setter
    def virtual_machine_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_size", value)


@pulumi.input_type
class VirtualMachineSshCredentialsArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 private_key_data: Optional[pulumi.Input[str]] = None,
                 public_key_data: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Admin credentials for virtual machine
        :param pulumi.Input[str] password: Password of admin account
        :param pulumi.Input[str] private_key_data: Private key data
        :param pulumi.Input[str] public_key_data: Public key data
        :param pulumi.Input[str] username: Username of admin account
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key_data is not None:
            pulumi.set(__self__, "private_key_data", private_key_data)
        if public_key_data is not None:
            pulumi.set(__self__, "public_key_data", public_key_data)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password of admin account
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateKeyData")
    def private_key_data(self) -> Optional[pulumi.Input[str]]:
        """
        Private key data
        """
        return pulumi.get(self, "private_key_data")

    @private_key_data.setter
    def private_key_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_data", value)

    @property
    @pulumi.getter(name="publicKeyData")
    def public_key_data(self) -> Optional[pulumi.Input[str]]:
        """
        Public key data
        """
        return pulumi.get(self, "public_key_data")

    @public_key_data.setter
    def public_key_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key_data", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username of admin account
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class VirtualMachineArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['VirtualMachinePropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A Machine Learning compute based on Azure Virtual Machines.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'VirtualMachine'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'VirtualMachine')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'VirtualMachine'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['VirtualMachinePropertiesArgs']]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['VirtualMachinePropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


