# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = ['DistributedAvailabilityGroupArgs', 'DistributedAvailabilityGroup']

@pulumi.input_type
class DistributedAvailabilityGroupArgs:
    def __init__(__self__, *,
                 managed_instance_name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 distributed_availability_group_name: Optional[pulumi.Input[str]] = None,
                 primary_availability_group_name: Optional[pulumi.Input[str]] = None,
                 replication_mode: Optional[pulumi.Input[Union[str, 'ReplicationMode']]] = None,
                 secondary_availability_group_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint: Optional[pulumi.Input[str]] = None,
                 target_database: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DistributedAvailabilityGroup resource.
        :param pulumi.Input[str] managed_instance_name: The name of the managed instance.
        :param pulumi.Input[str] resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        :param pulumi.Input[str] distributed_availability_group_name: The distributed availability group name.
        :param pulumi.Input[str] primary_availability_group_name: The primary availability group name
        :param pulumi.Input[Union[str, 'ReplicationMode']] replication_mode: The replication mode of a distributed availability group. Parameter will be ignored during link creation.
        :param pulumi.Input[str] secondary_availability_group_name: The secondary availability group name
        :param pulumi.Input[str] source_endpoint: The source endpoint
        :param pulumi.Input[str] target_database: The name of the target database
        """
        pulumi.set(__self__, "managed_instance_name", managed_instance_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if distributed_availability_group_name is not None:
            pulumi.set(__self__, "distributed_availability_group_name", distributed_availability_group_name)
        if primary_availability_group_name is not None:
            pulumi.set(__self__, "primary_availability_group_name", primary_availability_group_name)
        if replication_mode is not None:
            pulumi.set(__self__, "replication_mode", replication_mode)
        if secondary_availability_group_name is not None:
            pulumi.set(__self__, "secondary_availability_group_name", secondary_availability_group_name)
        if source_endpoint is not None:
            pulumi.set(__self__, "source_endpoint", source_endpoint)
        if target_database is not None:
            pulumi.set(__self__, "target_database", target_database)

    @property
    @pulumi.getter(name="managedInstanceName")
    def managed_instance_name(self) -> pulumi.Input[str]:
        """
        The name of the managed instance.
        """
        return pulumi.get(self, "managed_instance_name")

    @managed_instance_name.setter
    def managed_instance_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "managed_instance_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="distributedAvailabilityGroupName")
    def distributed_availability_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The distributed availability group name.
        """
        return pulumi.get(self, "distributed_availability_group_name")

    @distributed_availability_group_name.setter
    def distributed_availability_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "distributed_availability_group_name", value)

    @property
    @pulumi.getter(name="primaryAvailabilityGroupName")
    def primary_availability_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The primary availability group name
        """
        return pulumi.get(self, "primary_availability_group_name")

    @primary_availability_group_name.setter
    def primary_availability_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_availability_group_name", value)

    @property
    @pulumi.getter(name="replicationMode")
    def replication_mode(self) -> Optional[pulumi.Input[Union[str, 'ReplicationMode']]]:
        """
        The replication mode of a distributed availability group. Parameter will be ignored during link creation.
        """
        return pulumi.get(self, "replication_mode")

    @replication_mode.setter
    def replication_mode(self, value: Optional[pulumi.Input[Union[str, 'ReplicationMode']]]):
        pulumi.set(self, "replication_mode", value)

    @property
    @pulumi.getter(name="secondaryAvailabilityGroupName")
    def secondary_availability_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The secondary availability group name
        """
        return pulumi.get(self, "secondary_availability_group_name")

    @secondary_availability_group_name.setter
    def secondary_availability_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_availability_group_name", value)

    @property
    @pulumi.getter(name="sourceEndpoint")
    def source_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The source endpoint
        """
        return pulumi.get(self, "source_endpoint")

    @source_endpoint.setter
    def source_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint", value)

    @property
    @pulumi.getter(name="targetDatabase")
    def target_database(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the target database
        """
        return pulumi.get(self, "target_database")

    @target_database.setter
    def target_database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_database", value)


class DistributedAvailabilityGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 distributed_availability_group_name: Optional[pulumi.Input[str]] = None,
                 managed_instance_name: Optional[pulumi.Input[str]] = None,
                 primary_availability_group_name: Optional[pulumi.Input[str]] = None,
                 replication_mode: Optional[pulumi.Input[Union[str, 'ReplicationMode']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 secondary_availability_group_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint: Optional[pulumi.Input[str]] = None,
                 target_database: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Distributed availability group between box and Sql Managed Instance.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] distributed_availability_group_name: The distributed availability group name.
        :param pulumi.Input[str] managed_instance_name: The name of the managed instance.
        :param pulumi.Input[str] primary_availability_group_name: The primary availability group name
        :param pulumi.Input[Union[str, 'ReplicationMode']] replication_mode: The replication mode of a distributed availability group. Parameter will be ignored during link creation.
        :param pulumi.Input[str] resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        :param pulumi.Input[str] secondary_availability_group_name: The secondary availability group name
        :param pulumi.Input[str] source_endpoint: The source endpoint
        :param pulumi.Input[str] target_database: The name of the target database
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DistributedAvailabilityGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Distributed availability group between box and Sql Managed Instance.

        :param str resource_name: The name of the resource.
        :param DistributedAvailabilityGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DistributedAvailabilityGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 distributed_availability_group_name: Optional[pulumi.Input[str]] = None,
                 managed_instance_name: Optional[pulumi.Input[str]] = None,
                 primary_availability_group_name: Optional[pulumi.Input[str]] = None,
                 replication_mode: Optional[pulumi.Input[Union[str, 'ReplicationMode']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 secondary_availability_group_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint: Optional[pulumi.Input[str]] = None,
                 target_database: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DistributedAvailabilityGroupArgs.__new__(DistributedAvailabilityGroupArgs)

            __props__.__dict__["distributed_availability_group_name"] = distributed_availability_group_name
            if managed_instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_name'")
            __props__.__dict__["managed_instance_name"] = managed_instance_name
            __props__.__dict__["primary_availability_group_name"] = primary_availability_group_name
            __props__.__dict__["replication_mode"] = replication_mode
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["secondary_availability_group_name"] = secondary_availability_group_name
            __props__.__dict__["source_endpoint"] = source_endpoint
            __props__.__dict__["target_database"] = target_database
            __props__.__dict__["distributed_availability_group_id"] = None
            __props__.__dict__["last_hardened_lsn"] = None
            __props__.__dict__["link_state"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["source_replica_id"] = None
            __props__.__dict__["target_replica_id"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:sql:DistributedAvailabilityGroup"), pulumi.Alias(type_="azure-native:sql/v20210501preview:DistributedAvailabilityGroup"), pulumi.Alias(type_="azure-native:sql/v20210801preview:DistributedAvailabilityGroup"), pulumi.Alias(type_="azure-native:sql/v20211101preview:DistributedAvailabilityGroup"), pulumi.Alias(type_="azure-native:sql/v20220201preview:DistributedAvailabilityGroup"), pulumi.Alias(type_="azure-native:sql/v20220501preview:DistributedAvailabilityGroup")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(DistributedAvailabilityGroup, __self__).__init__(
            'azure-native:sql/v20211101:DistributedAvailabilityGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DistributedAvailabilityGroup':
        """
        Get an existing DistributedAvailabilityGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DistributedAvailabilityGroupArgs.__new__(DistributedAvailabilityGroupArgs)

        __props__.__dict__["distributed_availability_group_id"] = None
        __props__.__dict__["last_hardened_lsn"] = None
        __props__.__dict__["link_state"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["primary_availability_group_name"] = None
        __props__.__dict__["replication_mode"] = None
        __props__.__dict__["secondary_availability_group_name"] = None
        __props__.__dict__["source_endpoint"] = None
        __props__.__dict__["source_replica_id"] = None
        __props__.__dict__["target_database"] = None
        __props__.__dict__["target_replica_id"] = None
        __props__.__dict__["type"] = None
        return DistributedAvailabilityGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="distributedAvailabilityGroupId")
    def distributed_availability_group_id(self) -> pulumi.Output[str]:
        """
        The distributed availability group id
        """
        return pulumi.get(self, "distributed_availability_group_id")

    @property
    @pulumi.getter(name="lastHardenedLsn")
    def last_hardened_lsn(self) -> pulumi.Output[str]:
        """
        The last hardened lsn
        """
        return pulumi.get(self, "last_hardened_lsn")

    @property
    @pulumi.getter(name="linkState")
    def link_state(self) -> pulumi.Output[str]:
        """
        The link state
        """
        return pulumi.get(self, "link_state")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryAvailabilityGroupName")
    def primary_availability_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        The primary availability group name
        """
        return pulumi.get(self, "primary_availability_group_name")

    @property
    @pulumi.getter(name="replicationMode")
    def replication_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The replication mode of a distributed availability group. Parameter will be ignored during link creation.
        """
        return pulumi.get(self, "replication_mode")

    @property
    @pulumi.getter(name="secondaryAvailabilityGroupName")
    def secondary_availability_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        The secondary availability group name
        """
        return pulumi.get(self, "secondary_availability_group_name")

    @property
    @pulumi.getter(name="sourceEndpoint")
    def source_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        The source endpoint
        """
        return pulumi.get(self, "source_endpoint")

    @property
    @pulumi.getter(name="sourceReplicaId")
    def source_replica_id(self) -> pulumi.Output[str]:
        """
        The source replica id
        """
        return pulumi.get(self, "source_replica_id")

    @property
    @pulumi.getter(name="targetDatabase")
    def target_database(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the target database
        """
        return pulumi.get(self, "target_database")

    @property
    @pulumi.getter(name="targetReplicaId")
    def target_replica_id(self) -> pulumi.Output[str]:
        """
        The target replica id
        """
        return pulumi.get(self, "target_replica_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

