# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ColumnArgs',
    'RestoredLogsArgs',
    'SchemaArgs',
    'SearchResultsArgs',
    'WorkspaceCappingArgs',
    'WorkspaceFeaturesArgs',
    'WorkspaceSkuArgs',
]

@pulumi.input_type
class ColumnArgs:
    def __init__(__self__, *,
                 data_type_hint: Optional[pulumi.Input[Union[str, 'ColumnDataTypeHintEnum']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ColumnTypeEnum']]] = None):
        """
        Table column.
        :param pulumi.Input[Union[str, 'ColumnDataTypeHintEnum']] data_type_hint: Column data type logical hint.
        :param pulumi.Input[str] description: Column description.
        :param pulumi.Input[str] display_name: Column display name.
        :param pulumi.Input[str] name: Column name.
        :param pulumi.Input[Union[str, 'ColumnTypeEnum']] type: Column data type.
        """
        if data_type_hint is not None:
            pulumi.set(__self__, "data_type_hint", data_type_hint)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="dataTypeHint")
    def data_type_hint(self) -> Optional[pulumi.Input[Union[str, 'ColumnDataTypeHintEnum']]]:
        """
        Column data type logical hint.
        """
        return pulumi.get(self, "data_type_hint")

    @data_type_hint.setter
    def data_type_hint(self, value: Optional[pulumi.Input[Union[str, 'ColumnDataTypeHintEnum']]]):
        pulumi.set(self, "data_type_hint", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Column description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Column display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Column name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ColumnTypeEnum']]]:
        """
        Column data type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ColumnTypeEnum']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class RestoredLogsArgs:
    def __init__(__self__, *,
                 end_restore_time: Optional[pulumi.Input[str]] = None,
                 source_table: Optional[pulumi.Input[str]] = None,
                 start_restore_time: Optional[pulumi.Input[str]] = None):
        """
        Restore parameters.
        :param pulumi.Input[str] end_restore_time: The timestamp to end the restore by (UTC).
        :param pulumi.Input[str] source_table: The table to restore data from.
        :param pulumi.Input[str] start_restore_time: The timestamp to start the restore from (UTC).
        """
        if end_restore_time is not None:
            pulumi.set(__self__, "end_restore_time", end_restore_time)
        if source_table is not None:
            pulumi.set(__self__, "source_table", source_table)
        if start_restore_time is not None:
            pulumi.set(__self__, "start_restore_time", start_restore_time)

    @property
    @pulumi.getter(name="endRestoreTime")
    def end_restore_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp to end the restore by (UTC).
        """
        return pulumi.get(self, "end_restore_time")

    @end_restore_time.setter
    def end_restore_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_restore_time", value)

    @property
    @pulumi.getter(name="sourceTable")
    def source_table(self) -> Optional[pulumi.Input[str]]:
        """
        The table to restore data from.
        """
        return pulumi.get(self, "source_table")

    @source_table.setter
    def source_table(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_table", value)

    @property
    @pulumi.getter(name="startRestoreTime")
    def start_restore_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp to start the restore from (UTC).
        """
        return pulumi.get(self, "start_restore_time")

    @start_restore_time.setter
    def start_restore_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_restore_time", value)


@pulumi.input_type
class SchemaArgs:
    def __init__(__self__, *,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['ColumnArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Table's schema.
        :param pulumi.Input[Sequence[pulumi.Input['ColumnArgs']]] columns: A list of table custom columns.
        :param pulumi.Input[str] description: Table description.
        :param pulumi.Input[str] display_name: Table display name.
        :param pulumi.Input[str] name: Table name.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ColumnArgs']]]]:
        """
        A list of table custom columns.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ColumnArgs']]]]):
        pulumi.set(self, "columns", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Table description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Table display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Table name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class SearchResultsArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 end_search_time: Optional[pulumi.Input[str]] = None,
                 limit: Optional[pulumi.Input[int]] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 start_search_time: Optional[pulumi.Input[str]] = None):
        """
        Parameters of the search job that initiated this table.
        :param pulumi.Input[str] description: Search job Description.
        :param pulumi.Input[str] end_search_time: The timestamp to end the search by (UTC)
        :param pulumi.Input[int] limit: Limit the search job to return up to specified number of rows.
        :param pulumi.Input[str] query: Search job query.
        :param pulumi.Input[str] start_search_time: The timestamp to start the search from (UTC)
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_search_time is not None:
            pulumi.set(__self__, "end_search_time", end_search_time)
        if limit is not None:
            pulumi.set(__self__, "limit", limit)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if start_search_time is not None:
            pulumi.set(__self__, "start_search_time", start_search_time)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Search job Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="endSearchTime")
    def end_search_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp to end the search by (UTC)
        """
        return pulumi.get(self, "end_search_time")

    @end_search_time.setter
    def end_search_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_search_time", value)

    @property
    @pulumi.getter
    def limit(self) -> Optional[pulumi.Input[int]]:
        """
        Limit the search job to return up to specified number of rows.
        """
        return pulumi.get(self, "limit")

    @limit.setter
    def limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "limit", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        Search job query.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="startSearchTime")
    def start_search_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp to start the search from (UTC)
        """
        return pulumi.get(self, "start_search_time")

    @start_search_time.setter
    def start_search_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_search_time", value)


@pulumi.input_type
class WorkspaceCappingArgs:
    def __init__(__self__, *,
                 daily_quota_gb: Optional[pulumi.Input[float]] = None):
        """
        The daily volume cap for ingestion.
        :param pulumi.Input[float] daily_quota_gb: The workspace daily quota for ingestion.
        """
        if daily_quota_gb is not None:
            pulumi.set(__self__, "daily_quota_gb", daily_quota_gb)

    @property
    @pulumi.getter(name="dailyQuotaGb")
    def daily_quota_gb(self) -> Optional[pulumi.Input[float]]:
        """
        The workspace daily quota for ingestion.
        """
        return pulumi.get(self, "daily_quota_gb")

    @daily_quota_gb.setter
    def daily_quota_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "daily_quota_gb", value)


@pulumi.input_type
class WorkspaceFeaturesArgs:
    def __init__(__self__, *,
                 cluster_resource_id: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 enable_data_export: Optional[pulumi.Input[bool]] = None,
                 enable_log_access_using_only_resource_permissions: Optional[pulumi.Input[bool]] = None,
                 immediate_purge_data_on30_days: Optional[pulumi.Input[bool]] = None):
        """
        Workspace features.
        :param pulumi.Input[str] cluster_resource_id: Dedicated LA cluster resourceId that is linked to the workspaces.
        :param pulumi.Input[bool] disable_local_auth: Disable Non-AAD based Auth.
        :param pulumi.Input[bool] enable_data_export: Flag that indicate if data should be exported.
        :param pulumi.Input[bool] enable_log_access_using_only_resource_permissions: Flag that indicate which permission to use - resource or workspace or both.
        :param pulumi.Input[bool] immediate_purge_data_on30_days: Flag that describes if we want to remove the data after 30 days.
        """
        if cluster_resource_id is not None:
            pulumi.set(__self__, "cluster_resource_id", cluster_resource_id)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if enable_data_export is not None:
            pulumi.set(__self__, "enable_data_export", enable_data_export)
        if enable_log_access_using_only_resource_permissions is not None:
            pulumi.set(__self__, "enable_log_access_using_only_resource_permissions", enable_log_access_using_only_resource_permissions)
        if immediate_purge_data_on30_days is not None:
            pulumi.set(__self__, "immediate_purge_data_on30_days", immediate_purge_data_on30_days)

    @property
    @pulumi.getter(name="clusterResourceId")
    def cluster_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Dedicated LA cluster resourceId that is linked to the workspaces.
        """
        return pulumi.get(self, "cluster_resource_id")

    @cluster_resource_id.setter
    def cluster_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_resource_id", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable Non-AAD based Auth.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter(name="enableDataExport")
    def enable_data_export(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that indicate if data should be exported.
        """
        return pulumi.get(self, "enable_data_export")

    @enable_data_export.setter
    def enable_data_export(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_data_export", value)

    @property
    @pulumi.getter(name="enableLogAccessUsingOnlyResourcePermissions")
    def enable_log_access_using_only_resource_permissions(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that indicate which permission to use - resource or workspace or both.
        """
        return pulumi.get(self, "enable_log_access_using_only_resource_permissions")

    @enable_log_access_using_only_resource_permissions.setter
    def enable_log_access_using_only_resource_permissions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_log_access_using_only_resource_permissions", value)

    @property
    @pulumi.getter(name="immediatePurgeDataOn30Days")
    def immediate_purge_data_on30_days(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that describes if we want to remove the data after 30 days.
        """
        return pulumi.get(self, "immediate_purge_data_on30_days")

    @immediate_purge_data_on30_days.setter
    def immediate_purge_data_on30_days(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "immediate_purge_data_on30_days", value)


@pulumi.input_type
class WorkspaceSkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'WorkspaceSkuNameEnum']],
                 capacity_reservation_level: Optional[pulumi.Input[int]] = None):
        """
        The SKU (tier) of a workspace.
        :param pulumi.Input[Union[str, 'WorkspaceSkuNameEnum']] name: The name of the SKU.
        :param pulumi.Input[int] capacity_reservation_level: The capacity reservation level in GB for this workspace, when CapacityReservation sku is selected.
        """
        pulumi.set(__self__, "name", name)
        if capacity_reservation_level is not None:
            pulumi.set(__self__, "capacity_reservation_level", capacity_reservation_level)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'WorkspaceSkuNameEnum']]:
        """
        The name of the SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'WorkspaceSkuNameEnum']]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="capacityReservationLevel")
    def capacity_reservation_level(self) -> Optional[pulumi.Input[int]]:
        """
        The capacity reservation level in GB for this workspace, when CapacityReservation sku is selected.
        """
        return pulumi.get(self, "capacity_reservation_level")

    @capacity_reservation_level.setter
    def capacity_reservation_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity_reservation_level", value)


