# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetChannelFullUrlResult',
    'AwaitableGetChannelFullUrlResult',
    'get_channel_full_url',
    'get_channel_full_url_output',
]

@pulumi.output_type
class GetChannelFullUrlResult:
    """
    Full endpoint url of an event subscription
    """
    def __init__(__self__, endpoint_url=None):
        if endpoint_url and not isinstance(endpoint_url, str):
            raise TypeError("Expected argument 'endpoint_url' to be a str")
        pulumi.set(__self__, "endpoint_url", endpoint_url)

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[str]:
        """
        The URL that represents the endpoint of the destination of an event subscription.
        """
        return pulumi.get(self, "endpoint_url")


class AwaitableGetChannelFullUrlResult(GetChannelFullUrlResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetChannelFullUrlResult(
            endpoint_url=self.endpoint_url)


def get_channel_full_url(channel_name: Optional[str] = None,
                         partner_namespace_name: Optional[str] = None,
                         resource_group_name: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetChannelFullUrlResult:
    """
    Full endpoint url of an event subscription
    API Version: 2021-10-15-preview.


    :param str channel_name: Name of the Channel.
    :param str partner_namespace_name: Name of the partner namespace.
    :param str resource_group_name: The name of the resource group within the partners subscription.
    """
    __args__ = dict()
    __args__['channelName'] = channel_name
    __args__['partnerNamespaceName'] = partner_namespace_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:eventgrid:getChannelFullUrl', __args__, opts=opts, typ=GetChannelFullUrlResult).value

    return AwaitableGetChannelFullUrlResult(
        endpoint_url=__ret__.endpoint_url)


@_utilities.lift_output_func(get_channel_full_url)
def get_channel_full_url_output(channel_name: Optional[pulumi.Input[str]] = None,
                                partner_namespace_name: Optional[pulumi.Input[str]] = None,
                                resource_group_name: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetChannelFullUrlResult]:
    """
    Full endpoint url of an event subscription
    API Version: 2021-10-15-preview.


    :param str channel_name: Name of the Channel.
    :param str partner_namespace_name: Name of the partner namespace.
    :param str resource_group_name: The name of the resource group within the partners subscription.
    """
    ...
