# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReportArgs', 'Report']

@pulumi.input_type
class ReportArgs:
    def __init__(__self__, *,
                 properties: pulumi.Input['ReportPropertiesArgs'],
                 report_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Report resource.
        :param pulumi.Input['ReportPropertiesArgs'] properties: Report property.
        :param pulumi.Input[str] report_name: Report Name.
        """
        pulumi.set(__self__, "properties", properties)
        if report_name is not None:
            pulumi.set(__self__, "report_name", report_name)

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Input['ReportPropertiesArgs']:
        """
        Report property.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: pulumi.Input['ReportPropertiesArgs']):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="reportName")
    def report_name(self) -> Optional[pulumi.Input[str]]:
        """
        Report Name.
        """
        return pulumi.get(self, "report_name")

    @report_name.setter
    def report_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "report_name", value)


class Report(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 properties: Optional[pulumi.Input[pulumi.InputType['ReportPropertiesArgs']]] = None,
                 report_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A class represent an AppComplianceAutomation report resource.
        API Version: 2022-11-16-preview.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ReportPropertiesArgs']] properties: Report property.
        :param pulumi.Input[str] report_name: Report Name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReportArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A class represent an AppComplianceAutomation report resource.
        API Version: 2022-11-16-preview.

        :param str resource_name: The name of the resource.
        :param ReportArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReportArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 properties: Optional[pulumi.Input[pulumi.InputType['ReportPropertiesArgs']]] = None,
                 report_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReportArgs.__new__(ReportArgs)

            if properties is None and not opts.urn:
                raise TypeError("Missing required property 'properties'")
            __props__.__dict__["properties"] = properties
            __props__.__dict__["report_name"] = report_name
            __props__.__dict__["name"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:appcomplianceautomation/v20221116preview:Report")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Report, __self__).__init__(
            'azure-native:appcomplianceautomation:Report',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Report':
        """
        Get an existing Report resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ReportArgs.__new__(ReportArgs)

        __props__.__dict__["name"] = None
        __props__.__dict__["properties"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["type"] = None
        return Report(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output['outputs.ReportPropertiesResponse']:
        """
        Report property.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

