# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ArcConnectivityPropertiesResponse',
    'ClusterDesiredPropertiesResponse',
    'ClusterNodeResponse',
    'ClusterReportedPropertiesResponse',
    'PerNodeExtensionStateResponse',
    'PerNodeStateResponse',
    'SoftwareAssurancePropertiesResponse',
    'SystemDataResponse',
    'UserAssignedIdentityResponse',
]

@pulumi.output_type
class ArcConnectivityPropertiesResponse(dict):
    """
    Connectivity related configuration required by arc server.
    """
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        Connectivity related configuration required by arc server.
        :param bool enabled: True indicates ARC connectivity is enabled
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        True indicates ARC connectivity is enabled
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterDesiredPropertiesResponse(dict):
    """
    Desired properties of the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diagnosticLevel":
            suggest = "diagnostic_level"
        elif key == "windowsServerSubscription":
            suggest = "windows_server_subscription"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterDesiredPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterDesiredPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterDesiredPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 diagnostic_level: Optional[str] = None,
                 windows_server_subscription: Optional[str] = None):
        """
        Desired properties of the cluster.
        :param str diagnostic_level: Desired level of diagnostic data emitted by the cluster.
        :param str windows_server_subscription: Desired state of Windows Server Subscription.
        """
        if diagnostic_level is not None:
            pulumi.set(__self__, "diagnostic_level", diagnostic_level)
        if windows_server_subscription is not None:
            pulumi.set(__self__, "windows_server_subscription", windows_server_subscription)

    @property
    @pulumi.getter(name="diagnosticLevel")
    def diagnostic_level(self) -> Optional[str]:
        """
        Desired level of diagnostic data emitted by the cluster.
        """
        return pulumi.get(self, "diagnostic_level")

    @property
    @pulumi.getter(name="windowsServerSubscription")
    def windows_server_subscription(self) -> Optional[str]:
        """
        Desired state of Windows Server Subscription.
        """
        return pulumi.get(self, "windows_server_subscription")


@pulumi.output_type
class ClusterNodeResponse(dict):
    """
    Cluster node details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coreCount":
            suggest = "core_count"
        elif key == "memoryInGiB":
            suggest = "memory_in_gi_b"
        elif key == "nodeType":
            suggest = "node_type"
        elif key == "osDisplayVersion":
            suggest = "os_display_version"
        elif key == "osName":
            suggest = "os_name"
        elif key == "osVersion":
            suggest = "os_version"
        elif key == "serialNumber":
            suggest = "serial_number"
        elif key == "windowsServerSubscription":
            suggest = "windows_server_subscription"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 core_count: float,
                 id: float,
                 manufacturer: str,
                 memory_in_gi_b: float,
                 model: str,
                 name: str,
                 node_type: str,
                 os_display_version: str,
                 os_name: str,
                 os_version: str,
                 serial_number: str,
                 windows_server_subscription: str):
        """
        Cluster node details.
        :param float core_count: Number of physical cores on the cluster node.
        :param float id: Id of the node in the cluster.
        :param str manufacturer: Manufacturer of the cluster node hardware.
        :param float memory_in_gi_b: Total available memory on the cluster node (in GiB).
        :param str model: Model name of the cluster node hardware.
        :param str name: Name of the cluster node.
        :param str node_type: Type of the cluster node hardware.
        :param str os_display_version: Display version of the operating system running on the cluster node.
        :param str os_name: Operating system running on the cluster node.
        :param str os_version: Version of the operating system running on the cluster node.
        :param str serial_number: Immutable id of the cluster node.
        :param str windows_server_subscription: State of Windows Server Subscription.
        """
        pulumi.set(__self__, "core_count", core_count)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "manufacturer", manufacturer)
        pulumi.set(__self__, "memory_in_gi_b", memory_in_gi_b)
        pulumi.set(__self__, "model", model)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "os_display_version", os_display_version)
        pulumi.set(__self__, "os_name", os_name)
        pulumi.set(__self__, "os_version", os_version)
        pulumi.set(__self__, "serial_number", serial_number)
        pulumi.set(__self__, "windows_server_subscription", windows_server_subscription)

    @property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> float:
        """
        Number of physical cores on the cluster node.
        """
        return pulumi.get(self, "core_count")

    @property
    @pulumi.getter
    def id(self) -> float:
        """
        Id of the node in the cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def manufacturer(self) -> str:
        """
        Manufacturer of the cluster node hardware.
        """
        return pulumi.get(self, "manufacturer")

    @property
    @pulumi.getter(name="memoryInGiB")
    def memory_in_gi_b(self) -> float:
        """
        Total available memory on the cluster node (in GiB).
        """
        return pulumi.get(self, "memory_in_gi_b")

    @property
    @pulumi.getter
    def model(self) -> str:
        """
        Model name of the cluster node hardware.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the cluster node.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> str:
        """
        Type of the cluster node hardware.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="osDisplayVersion")
    def os_display_version(self) -> str:
        """
        Display version of the operating system running on the cluster node.
        """
        return pulumi.get(self, "os_display_version")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> str:
        """
        Operating system running on the cluster node.
        """
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> str:
        """
        Version of the operating system running on the cluster node.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> str:
        """
        Immutable id of the cluster node.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="windowsServerSubscription")
    def windows_server_subscription(self) -> str:
        """
        State of Windows Server Subscription.
        """
        return pulumi.get(self, "windows_server_subscription")


@pulumi.output_type
class ClusterReportedPropertiesResponse(dict):
    """
    Properties reported by cluster agent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterId":
            suggest = "cluster_id"
        elif key == "clusterName":
            suggest = "cluster_name"
        elif key == "clusterVersion":
            suggest = "cluster_version"
        elif key == "imdsAttestation":
            suggest = "imds_attestation"
        elif key == "lastUpdated":
            suggest = "last_updated"
        elif key == "diagnosticLevel":
            suggest = "diagnostic_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterReportedPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterReportedPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterReportedPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_id: str,
                 cluster_name: str,
                 cluster_version: str,
                 imds_attestation: str,
                 last_updated: str,
                 nodes: Sequence['outputs.ClusterNodeResponse'],
                 diagnostic_level: Optional[str] = None):
        """
        Properties reported by cluster agent.
        :param str cluster_id: Unique id generated by the on-prem cluster.
        :param str cluster_name: Name of the on-prem cluster connected to this resource.
        :param str cluster_version: Version of the cluster software.
        :param str imds_attestation: IMDS attestation status of the cluster.
        :param str last_updated: Last time the cluster reported the data.
        :param Sequence['ClusterNodeResponse'] nodes: List of nodes reported by the cluster.
        :param str diagnostic_level: Level of diagnostic data emitted by the cluster.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "cluster_version", cluster_version)
        pulumi.set(__self__, "imds_attestation", imds_attestation)
        pulumi.set(__self__, "last_updated", last_updated)
        pulumi.set(__self__, "nodes", nodes)
        if diagnostic_level is not None:
            pulumi.set(__self__, "diagnostic_level", diagnostic_level)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        Unique id generated by the on-prem cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        Name of the on-prem cluster connected to this resource.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> str:
        """
        Version of the cluster software.
        """
        return pulumi.get(self, "cluster_version")

    @property
    @pulumi.getter(name="imdsAttestation")
    def imds_attestation(self) -> str:
        """
        IMDS attestation status of the cluster.
        """
        return pulumi.get(self, "imds_attestation")

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> str:
        """
        Last time the cluster reported the data.
        """
        return pulumi.get(self, "last_updated")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.ClusterNodeResponse']:
        """
        List of nodes reported by the cluster.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="diagnosticLevel")
    def diagnostic_level(self) -> Optional[str]:
        """
        Level of diagnostic data emitted by the cluster.
        """
        return pulumi.get(self, "diagnostic_level")


@pulumi.output_type
class PerNodeExtensionStateResponse(dict):
    """
    Status of Arc Extension for a particular node in HCI Cluster.
    """
    def __init__(__self__, *,
                 extension: str,
                 name: str,
                 state: str):
        """
        Status of Arc Extension for a particular node in HCI Cluster.
        :param str extension: Fully qualified resource ID for the particular Arc Extension on this node.
        :param str name: Name of the node in HCI Cluster.
        :param str state: State of Arc Extension in this node.
        """
        pulumi.set(__self__, "extension", extension)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def extension(self) -> str:
        """
        Fully qualified resource ID for the particular Arc Extension on this node.
        """
        return pulumi.get(self, "extension")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the node in HCI Cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of Arc Extension in this node.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class PerNodeStateResponse(dict):
    """
    Status of Arc agent for a particular node in HCI Cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "arcInstance":
            suggest = "arc_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PerNodeStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PerNodeStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PerNodeStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arc_instance: str,
                 name: str,
                 state: str):
        """
        Status of Arc agent for a particular node in HCI Cluster.
        :param str arc_instance: Fully qualified resource ID for the Arc agent of this node.
        :param str name: Name of the Node in HCI Cluster
        :param str state: State of Arc agent in this node.
        """
        pulumi.set(__self__, "arc_instance", arc_instance)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="arcInstance")
    def arc_instance(self) -> str:
        """
        Fully qualified resource ID for the Arc agent of this node.
        """
        return pulumi.get(self, "arc_instance")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Node in HCI Cluster
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of Arc agent in this node.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class SoftwareAssurancePropertiesResponse(dict):
    """
    Software Assurance properties of the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastUpdated":
            suggest = "last_updated"
        elif key == "softwareAssuranceIntent":
            suggest = "software_assurance_intent"
        elif key == "softwareAssuranceStatus":
            suggest = "software_assurance_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareAssurancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareAssurancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareAssurancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_updated: str,
                 software_assurance_intent: Optional[str] = None,
                 software_assurance_status: Optional[str] = None):
        """
        Software Assurance properties of the cluster.
        :param str last_updated: TimeStamp denoting the latest SA benefit applicability is validated.
        :param str software_assurance_intent: Customer Intent for Software Assurance Benefit.
        :param str software_assurance_status: Status of the Software Assurance for the cluster.
        """
        pulumi.set(__self__, "last_updated", last_updated)
        if software_assurance_intent is not None:
            pulumi.set(__self__, "software_assurance_intent", software_assurance_intent)
        if software_assurance_status is not None:
            pulumi.set(__self__, "software_assurance_status", software_assurance_status)

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> str:
        """
        TimeStamp denoting the latest SA benefit applicability is validated.
        """
        return pulumi.get(self, "last_updated")

    @property
    @pulumi.getter(name="softwareAssuranceIntent")
    def software_assurance_intent(self) -> Optional[str]:
        """
        Customer Intent for Software Assurance Benefit.
        """
        return pulumi.get(self, "software_assurance_intent")

    @property
    @pulumi.getter(name="softwareAssuranceStatus")
    def software_assurance_status(self) -> Optional[str]:
        """
        Status of the Software Assurance for the cluster.
        """
        return pulumi.get(self, "software_assurance_status")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class UserAssignedIdentityResponse(dict):
    """
    User assigned identity properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        User assigned identity properties
        :param str client_id: The client ID of the assigned identity.
        :param str principal_id: The principal ID of the assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID of the assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of the assigned identity.
        """
        return pulumi.get(self, "principal_id")


