# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AuthorizationResponse',
    'BootstrapConfigurationResponse',
    'CodeRepositoryResponse',
    'PipelineTemplateResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class AuthorizationResponse(dict):
    """
    Authorization info used to access a resource (like code repository).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationType":
            suggest = "authorization_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_type: str,
                 parameters: Optional[Mapping[str, str]] = None):
        """
        Authorization info used to access a resource (like code repository).
        :param str authorization_type: Type of authorization.
        :param Mapping[str, str] parameters: Authorization parameters corresponding to the authorization type.
        """
        pulumi.set(__self__, "authorization_type", authorization_type)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> str:
        """
        Type of authorization.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, str]]:
        """
        Authorization parameters corresponding to the authorization type.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class BootstrapConfigurationResponse(dict):
    """
    Configuration used to bootstrap a Pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRepository":
            suggest = "source_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BootstrapConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BootstrapConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BootstrapConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 template: 'outputs.PipelineTemplateResponse',
                 source_repository: Optional['outputs.CodeRepositoryResponse'] = None):
        """
        Configuration used to bootstrap a Pipeline.
        :param 'PipelineTemplateResponse' template: Template used to bootstrap the pipeline.
        :param 'CodeRepositoryResponse' source_repository: Repository containing the source code for the pipeline. Currently only 'azurePipeline' pipeline type supports this.
        """
        pulumi.set(__self__, "template", template)
        if source_repository is not None:
            pulumi.set(__self__, "source_repository", source_repository)

    @property
    @pulumi.getter
    def template(self) -> 'outputs.PipelineTemplateResponse':
        """
        Template used to bootstrap the pipeline.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="sourceRepository")
    def source_repository(self) -> Optional['outputs.CodeRepositoryResponse']:
        """
        Repository containing the source code for the pipeline. Currently only 'azurePipeline' pipeline type supports this.
        """
        return pulumi.get(self, "source_repository")


@pulumi.output_type
class CodeRepositoryResponse(dict):
    """
    Repository containing the source code for a pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultBranch":
            suggest = "default_branch"
        elif key == "repositoryType":
            suggest = "repository_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeRepositoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeRepositoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeRepositoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_branch: str,
                 id: str,
                 repository_type: str,
                 authorization: Optional['outputs.AuthorizationResponse'] = None,
                 properties: Optional[Mapping[str, str]] = None):
        """
        Repository containing the source code for a pipeline.
        :param str default_branch: Default branch used to configure Continuous Integration (CI) in the pipeline.
        :param str id: Unique immutable identifier of the code repository.
        :param str repository_type: Type of code repository.
        :param 'AuthorizationResponse' authorization: Authorization info to access the code repository.
        :param Mapping[str, str] properties: Repository-specific properties.
        """
        pulumi.set(__self__, "default_branch", default_branch)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "repository_type", repository_type)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> str:
        """
        Default branch used to configure Continuous Integration (CI) in the pipeline.
        """
        return pulumi.get(self, "default_branch")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique immutable identifier of the code repository.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="repositoryType")
    def repository_type(self) -> str:
        """
        Type of code repository.
        """
        return pulumi.get(self, "repository_type")

    @property
    @pulumi.getter
    def authorization(self) -> Optional['outputs.AuthorizationResponse']:
        """
        Authorization info to access the code repository.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Repository-specific properties.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class PipelineTemplateResponse(dict):
    """
    Template used to bootstrap the pipeline.
    """
    def __init__(__self__, *,
                 id: str,
                 parameters: Optional[Mapping[str, str]] = None):
        """
        Template used to bootstrap the pipeline.
        :param str id: Unique identifier of the pipeline template.
        :param Mapping[str, str] parameters: Dictionary of input parameters used in the pipeline template.
        """
        pulumi.set(__self__, "id", id)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier of the pipeline template.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, str]]:
        """
        Dictionary of input parameters used in the pipeline template.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


