# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AzureActiveDirectoryAppArgs',
    'BlobShareArgs',
    'ConnectToSourcePostgreSqlSyncTaskInputArgs',
    'ConnectToSourcePostgreSqlSyncTaskPropertiesArgs',
    'ConnectToSourceSqlServerSyncTaskPropertiesArgs',
    'ConnectToSourceSqlServerTaskInputArgs',
    'ConnectToSourceSqlServerTaskPropertiesArgs',
    'ConnectToTargetAzureDbForMySqlTaskInputArgs',
    'ConnectToTargetAzureDbForMySqlTaskPropertiesArgs',
    'ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs',
    'ConnectToTargetAzureDbForPostgreSqlSyncTaskPropertiesArgs',
    'ConnectToTargetSqlDbTaskInputArgs',
    'ConnectToTargetSqlDbTaskPropertiesArgs',
    'ConnectToTargetSqlMISyncTaskInputArgs',
    'ConnectToTargetSqlMISyncTaskPropertiesArgs',
    'ConnectToTargetSqlMITaskInputArgs',
    'ConnectToTargetSqlMITaskPropertiesArgs',
    'ConnectToTargetSqlSqlDbSyncTaskInputArgs',
    'ConnectToTargetSqlSqlDbSyncTaskPropertiesArgs',
    'DatabaseInfoArgs',
    'DatabaseMigrationPropertiesSqlDbArgs',
    'FileShareArgs',
    'GetTdeCertificatesSqlTaskInputArgs',
    'GetTdeCertificatesSqlTaskPropertiesArgs',
    'GetUserTablesSqlSyncTaskInputArgs',
    'GetUserTablesSqlSyncTaskPropertiesArgs',
    'GetUserTablesSqlTaskInputArgs',
    'GetUserTablesSqlTaskPropertiesArgs',
    'MiSqlConnectionInfoArgs',
    'MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs',
    'MigrateMySqlAzureDbForMySqlSyncTaskInputArgs',
    'MigrateMySqlAzureDbForMySqlSyncTaskPropertiesArgs',
    'MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs',
    'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs',
    'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskPropertiesArgs',
    'MigrateSqlServerSqlDbDatabaseInputArgs',
    'MigrateSqlServerSqlDbSyncDatabaseInputArgs',
    'MigrateSqlServerSqlDbSyncTaskInputArgs',
    'MigrateSqlServerSqlDbSyncTaskPropertiesArgs',
    'MigrateSqlServerSqlDbTaskInputArgs',
    'MigrateSqlServerSqlDbTaskPropertiesArgs',
    'MigrateSqlServerSqlMIDatabaseInputArgs',
    'MigrateSqlServerSqlMISyncTaskInputArgs',
    'MigrateSqlServerSqlMISyncTaskPropertiesArgs',
    'MigrateSqlServerSqlMITaskInputArgs',
    'MigrateSqlServerSqlMITaskPropertiesArgs',
    'MigrationValidationOptionsArgs',
    'MySqlConnectionInfoArgs',
    'PostgreSqlConnectionInfoArgs',
    'ProjectFilePropertiesArgs',
    'SelectedCertificateInputArgs',
    'ServiceSkuArgs',
    'SqlConnectionInformationArgs',
    'SqlConnectionInfoArgs',
    'ValidateMigrationInputSqlServerSqlDbSyncTaskPropertiesArgs',
    'ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs',
    'ValidateMigrationInputSqlServerSqlMISyncTaskPropertiesArgs',
    'ValidateMigrationInputSqlServerSqlMITaskInputArgs',
    'ValidateMigrationInputSqlServerSqlMITaskPropertiesArgs',
    'ValidateSyncMigrationInputSqlServerTaskInputArgs',
]

@pulumi.input_type
class AzureActiveDirectoryAppArgs:
    def __init__(__self__, *,
                 app_key: pulumi.Input[str],
                 application_id: pulumi.Input[str],
                 tenant_id: pulumi.Input[str]):
        """
        Azure Active Directory Application
        :param pulumi.Input[str] app_key: Key used to authenticate to the Azure Active Directory Application
        :param pulumi.Input[str] application_id: Application ID of the Azure Active Directory Application
        :param pulumi.Input[str] tenant_id: Tenant id of the customer
        """
        pulumi.set(__self__, "app_key", app_key)
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="appKey")
    def app_key(self) -> pulumi.Input[str]:
        """
        Key used to authenticate to the Azure Active Directory Application
        """
        return pulumi.get(self, "app_key")

    @app_key.setter
    def app_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_key", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[str]:
        """
        Application ID of the Azure Active Directory Application
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        Tenant id of the customer
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class BlobShareArgs:
    def __init__(__self__, *,
                 sas_uri: pulumi.Input[str]):
        """
        Blob container storage information.
        :param pulumi.Input[str] sas_uri: SAS URI of Azure Storage Account Container.
        """
        pulumi.set(__self__, "sas_uri", sas_uri)

    @property
    @pulumi.getter(name="sasUri")
    def sas_uri(self) -> pulumi.Input[str]:
        """
        SAS URI of Azure Storage Account Container.
        """
        return pulumi.get(self, "sas_uri")

    @sas_uri.setter
    def sas_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "sas_uri", value)


@pulumi.input_type
class ConnectToSourcePostgreSqlSyncTaskInputArgs:
    def __init__(__self__, *,
                 source_connection_info: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        """
        Input for the task that validates connection to PostgreSQL and source server requirements
        :param pulumi.Input['PostgreSqlConnectionInfoArgs'] source_connection_info: Connection information for source PostgreSQL server
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['PostgreSqlConnectionInfoArgs']:
        """
        Connection information for source PostgreSQL server
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)


@pulumi.input_type
class ConnectToSourcePostgreSqlSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['ConnectToSourcePostgreSqlSyncTaskInputArgs']] = None):
        """
        Properties for the task that validates connection to PostgreSQL server and source server requirements for online migration
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToSource.PostgreSql.Sync'.
        :param pulumi.Input['ConnectToSourcePostgreSqlSyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToSource.PostgreSql.Sync')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToSource.PostgreSql.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToSourcePostgreSqlSyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToSourcePostgreSqlSyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToSourceSqlServerSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['ConnectToSourceSqlServerTaskInputArgs']] = None):
        """
        Properties for the task that validates connection to SQL Server and source server requirements for online migration
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToSource.SqlServer.Sync'.
        :param pulumi.Input['ConnectToSourceSqlServerTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToSource.SqlServer.Sync')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToSource.SqlServer.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToSourceSqlServerTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToSourceSqlServerTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToSourceSqlServerTaskInputArgs:
    def __init__(__self__, *,
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 check_permissions_group: Optional[pulumi.Input[Union[str, 'ServerLevelPermissionsGroup']]] = None,
                 collect_agent_jobs: Optional[pulumi.Input[bool]] = None,
                 collect_logins: Optional[pulumi.Input[bool]] = None):
        """
        Input for the task that validates connection to SQL Server and also validates source server requirements
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Connection information for Source SQL Server
        :param pulumi.Input[Union[str, 'ServerLevelPermissionsGroup']] check_permissions_group: Permission group for validations
        :param pulumi.Input[bool] collect_agent_jobs: Flag for whether to collect agent jobs from source server.
        :param pulumi.Input[bool] collect_logins: Flag for whether to collect logins from source server.
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        if check_permissions_group is not None:
            pulumi.set(__self__, "check_permissions_group", check_permissions_group)
        if collect_agent_jobs is None:
            collect_agent_jobs = False
        if collect_agent_jobs is not None:
            pulumi.set(__self__, "collect_agent_jobs", collect_agent_jobs)
        if collect_logins is None:
            collect_logins = False
        if collect_logins is not None:
            pulumi.set(__self__, "collect_logins", collect_logins)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for Source SQL Server
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="checkPermissionsGroup")
    def check_permissions_group(self) -> Optional[pulumi.Input[Union[str, 'ServerLevelPermissionsGroup']]]:
        """
        Permission group for validations
        """
        return pulumi.get(self, "check_permissions_group")

    @check_permissions_group.setter
    def check_permissions_group(self, value: Optional[pulumi.Input[Union[str, 'ServerLevelPermissionsGroup']]]):
        pulumi.set(self, "check_permissions_group", value)

    @property
    @pulumi.getter(name="collectAgentJobs")
    def collect_agent_jobs(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag for whether to collect agent jobs from source server.
        """
        return pulumi.get(self, "collect_agent_jobs")

    @collect_agent_jobs.setter
    def collect_agent_jobs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "collect_agent_jobs", value)

    @property
    @pulumi.getter(name="collectLogins")
    def collect_logins(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag for whether to collect logins from source server.
        """
        return pulumi.get(self, "collect_logins")

    @collect_logins.setter
    def collect_logins(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "collect_logins", value)


@pulumi.input_type
class ConnectToSourceSqlServerTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['ConnectToSourceSqlServerTaskInputArgs']] = None):
        """
        Properties for the task that validates connection to SQL Server and also validates source server requirements
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToSource.SqlServer'.
        :param pulumi.Input['ConnectToSourceSqlServerTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToSource.SqlServer')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToSource.SqlServer'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToSourceSqlServerTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToSourceSqlServerTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToTargetAzureDbForMySqlTaskInputArgs:
    def __init__(__self__, *,
                 source_connection_info: pulumi.Input['MySqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['MySqlConnectionInfoArgs']):
        """
        Input for the task that validates connection to Azure Database for MySQL and target server requirements
        :param pulumi.Input['MySqlConnectionInfoArgs'] source_connection_info: Connection information for source MySQL server
        :param pulumi.Input['MySqlConnectionInfoArgs'] target_connection_info: Connection information for target Azure Database for MySQL server
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['MySqlConnectionInfoArgs']:
        """
        Connection information for source MySQL server
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['MySqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['MySqlConnectionInfoArgs']:
        """
        Connection information for target Azure Database for MySQL server
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['MySqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


@pulumi.input_type
class ConnectToTargetAzureDbForMySqlTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['ConnectToTargetAzureDbForMySqlTaskInputArgs']] = None):
        """
        Properties for the task that validates connection to Azure Database for MySQL and target server requirements
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToTarget.AzureDbForMySql'.
        :param pulumi.Input['ConnectToTargetAzureDbForMySqlTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToTarget.AzureDbForMySql')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToTarget.AzureDbForMySql'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToTargetAzureDbForMySqlTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToTargetAzureDbForMySqlTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs:
    def __init__(__self__, *,
                 source_connection_info: pulumi.Input['PostgreSqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        """
        Input for the task that validates connection to Azure Database for PostgreSQL and target server requirements
        :param pulumi.Input['PostgreSqlConnectionInfoArgs'] source_connection_info: Connection information for source PostgreSQL server
        :param pulumi.Input['PostgreSqlConnectionInfoArgs'] target_connection_info: Connection information for target Azure Database for PostgreSQL server
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['PostgreSqlConnectionInfoArgs']:
        """
        Connection information for source PostgreSQL server
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['PostgreSqlConnectionInfoArgs']:
        """
        Connection information for target Azure Database for PostgreSQL server
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


@pulumi.input_type
class ConnectToTargetAzureDbForPostgreSqlSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs']] = None):
        """
        Properties for the task that validates connection to Azure Database For PostgreSQL server and target server requirements for online migration
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToTarget.AzureDbForPostgreSql.Sync'.
        :param pulumi.Input['ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToTarget.AzureDbForPostgreSql.Sync')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToTarget.AzureDbForPostgreSql.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToTargetSqlDbTaskInputArgs:
    def __init__(__self__, *,
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs']):
        """
        Input for the task that validates connection to SQL DB and target server requirements
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Connection information for target SQL DB
        """
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for target SQL DB
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


@pulumi.input_type
class ConnectToTargetSqlDbTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['ConnectToTargetSqlDbTaskInputArgs']] = None):
        """
        Properties for the task that validates connection to SQL DB and target server requirements
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToTarget.SqlDb'.
        :param pulumi.Input['ConnectToTargetSqlDbTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToTarget.SqlDb')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToTarget.SqlDb'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToTargetSqlDbTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToTargetSqlDbTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToTargetSqlMISyncTaskInputArgs:
    def __init__(__self__, *,
                 azure_app: pulumi.Input['AzureActiveDirectoryAppArgs'],
                 target_connection_info: pulumi.Input['MiSqlConnectionInfoArgs']):
        """
        Input for the task that validates connection to Azure SQL Database Managed Instance online scenario.
        :param pulumi.Input['AzureActiveDirectoryAppArgs'] azure_app: Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
        :param pulumi.Input['MiSqlConnectionInfoArgs'] target_connection_info: Connection information for Azure SQL Database Managed Instance
        """
        pulumi.set(__self__, "azure_app", azure_app)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="azureApp")
    def azure_app(self) -> pulumi.Input['AzureActiveDirectoryAppArgs']:
        """
        Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
        """
        return pulumi.get(self, "azure_app")

    @azure_app.setter
    def azure_app(self, value: pulumi.Input['AzureActiveDirectoryAppArgs']):
        pulumi.set(self, "azure_app", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['MiSqlConnectionInfoArgs']:
        """
        Connection information for Azure SQL Database Managed Instance
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['MiSqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


@pulumi.input_type
class ConnectToTargetSqlMISyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['ConnectToTargetSqlMISyncTaskInputArgs']] = None):
        """
        Properties for the task that validates connection to Azure SQL Database Managed Instance
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToTarget.AzureSqlDbMI.Sync.LRS'.
        :param pulumi.Input['ConnectToTargetSqlMISyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToTarget.AzureSqlDbMI.Sync.LRS')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToTarget.AzureSqlDbMI.Sync.LRS'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToTargetSqlMISyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToTargetSqlMISyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToTargetSqlMITaskInputArgs:
    def __init__(__self__, *,
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs']):
        """
        Input for the task that validates connection to Azure SQL Database Managed Instance.
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Connection information for target SQL Server
        """
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for target SQL Server
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


@pulumi.input_type
class ConnectToTargetSqlMITaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['ConnectToTargetSqlMITaskInputArgs']] = None):
        """
        Properties for the task that validates connection to Azure SQL Database Managed Instance
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToTarget.AzureSqlDbMI'.
        :param pulumi.Input['ConnectToTargetSqlMITaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToTarget.AzureSqlDbMI')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToTarget.AzureSqlDbMI'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToTargetSqlMITaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToTargetSqlMITaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToTargetSqlSqlDbSyncTaskInputArgs:
    def __init__(__self__, *,
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs']):
        """
        Input for the task that validates connection to Azure SQL DB and target server requirements
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Connection information for source SQL Server
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Connection information for target SQL DB
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for source SQL Server
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for target SQL DB
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


@pulumi.input_type
class ConnectToTargetSqlSqlDbSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['ConnectToTargetSqlSqlDbSyncTaskInputArgs']] = None):
        """
        Properties for the task that validates connection to SQL DB and target server requirements for online migration
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToTarget.SqlDb.Sync'.
        :param pulumi.Input['ConnectToTargetSqlSqlDbSyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToTarget.SqlDb.Sync')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToTarget.SqlDb.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToTargetSqlSqlDbSyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToTargetSqlSqlDbSyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class DatabaseInfoArgs:
    def __init__(__self__, *,
                 source_database_name: pulumi.Input[str]):
        """
        Project Database Details
        :param pulumi.Input[str] source_database_name: Name of the database
        """
        pulumi.set(__self__, "source_database_name", source_database_name)

    @property
    @pulumi.getter(name="sourceDatabaseName")
    def source_database_name(self) -> pulumi.Input[str]:
        """
        Name of the database
        """
        return pulumi.get(self, "source_database_name")

    @source_database_name.setter
    def source_database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_database_name", value)


@pulumi.input_type
class DatabaseMigrationPropertiesSqlDbArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 migration_operation_id: Optional[pulumi.Input[str]] = None,
                 migration_service: Optional[pulumi.Input[str]] = None,
                 provisioning_error: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 source_database_name: Optional[pulumi.Input[str]] = None,
                 source_sql_connection: Optional[pulumi.Input['SqlConnectionInformationArgs']] = None,
                 table_list: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_database_collation: Optional[pulumi.Input[str]] = None,
                 target_sql_connection: Optional[pulumi.Input['SqlConnectionInformationArgs']] = None):
        """
        Database Migration Resource properties for SQL database.
        :param pulumi.Input[str] kind: 
               Expected value is 'SqlDb'.
        :param pulumi.Input[str] migration_operation_id: ID tracking current migration operation.
        :param pulumi.Input[str] migration_service: Resource Id of the Migration Service.
        :param pulumi.Input[str] provisioning_error: Error message for migration provisioning failure, if any.
        :param pulumi.Input[str] scope: Resource Id of the target resource (SQL VM or SQL Managed Instance).
        :param pulumi.Input[str] source_database_name: Name of the source database.
        :param pulumi.Input['SqlConnectionInformationArgs'] source_sql_connection: Source SQL Server connection details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] table_list: List of tables to copy.
        :param pulumi.Input[str] target_database_collation: Database collation to be used for the target database.
        :param pulumi.Input['SqlConnectionInformationArgs'] target_sql_connection: Target SQL DB connection details.
        """
        pulumi.set(__self__, "kind", 'SqlDb')
        if migration_operation_id is not None:
            pulumi.set(__self__, "migration_operation_id", migration_operation_id)
        if migration_service is not None:
            pulumi.set(__self__, "migration_service", migration_service)
        if provisioning_error is not None:
            pulumi.set(__self__, "provisioning_error", provisioning_error)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if source_database_name is not None:
            pulumi.set(__self__, "source_database_name", source_database_name)
        if source_sql_connection is not None:
            pulumi.set(__self__, "source_sql_connection", source_sql_connection)
        if table_list is not None:
            pulumi.set(__self__, "table_list", table_list)
        if target_database_collation is not None:
            pulumi.set(__self__, "target_database_collation", target_database_collation)
        if target_sql_connection is not None:
            pulumi.set(__self__, "target_sql_connection", target_sql_connection)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """

        Expected value is 'SqlDb'.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="migrationOperationId")
    def migration_operation_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID tracking current migration operation.
        """
        return pulumi.get(self, "migration_operation_id")

    @migration_operation_id.setter
    def migration_operation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "migration_operation_id", value)

    @property
    @pulumi.getter(name="migrationService")
    def migration_service(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id of the Migration Service.
        """
        return pulumi.get(self, "migration_service")

    @migration_service.setter
    def migration_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "migration_service", value)

    @property
    @pulumi.getter(name="provisioningError")
    def provisioning_error(self) -> Optional[pulumi.Input[str]]:
        """
        Error message for migration provisioning failure, if any.
        """
        return pulumi.get(self, "provisioning_error")

    @provisioning_error.setter
    def provisioning_error(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_error", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id of the target resource (SQL VM or SQL Managed Instance).
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="sourceDatabaseName")
    def source_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the source database.
        """
        return pulumi.get(self, "source_database_name")

    @source_database_name.setter
    def source_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_database_name", value)

    @property
    @pulumi.getter(name="sourceSqlConnection")
    def source_sql_connection(self) -> Optional[pulumi.Input['SqlConnectionInformationArgs']]:
        """
        Source SQL Server connection details.
        """
        return pulumi.get(self, "source_sql_connection")

    @source_sql_connection.setter
    def source_sql_connection(self, value: Optional[pulumi.Input['SqlConnectionInformationArgs']]):
        pulumi.set(self, "source_sql_connection", value)

    @property
    @pulumi.getter(name="tableList")
    def table_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of tables to copy.
        """
        return pulumi.get(self, "table_list")

    @table_list.setter
    def table_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "table_list", value)

    @property
    @pulumi.getter(name="targetDatabaseCollation")
    def target_database_collation(self) -> Optional[pulumi.Input[str]]:
        """
        Database collation to be used for the target database.
        """
        return pulumi.get(self, "target_database_collation")

    @target_database_collation.setter
    def target_database_collation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_database_collation", value)

    @property
    @pulumi.getter(name="targetSqlConnection")
    def target_sql_connection(self) -> Optional[pulumi.Input['SqlConnectionInformationArgs']]:
        """
        Target SQL DB connection details.
        """
        return pulumi.get(self, "target_sql_connection")

    @target_sql_connection.setter
    def target_sql_connection(self, value: Optional[pulumi.Input['SqlConnectionInformationArgs']]):
        pulumi.set(self, "target_sql_connection", value)


@pulumi.input_type
class FileShareArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        File share information with Path, Username, and Password.
        :param pulumi.Input[str] path: The folder path for this share.
        :param pulumi.Input[str] password: Password credential used to connect to the share location.
        :param pulumi.Input[str] user_name: User name credential to connect to the share location
        """
        pulumi.set(__self__, "path", path)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The folder path for this share.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password credential used to connect to the share location.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        User name credential to connect to the share location
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class GetTdeCertificatesSqlTaskInputArgs:
    def __init__(__self__, *,
                 backup_file_share: pulumi.Input['FileShareArgs'],
                 connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 selected_certificates: pulumi.Input[Sequence[pulumi.Input['SelectedCertificateInputArgs']]]):
        """
        Input for the task that gets TDE certificates in Base64 encoded format.
        :param pulumi.Input['FileShareArgs'] backup_file_share: Backup file share information for file share to be used for temporarily storing files.
        :param pulumi.Input['SqlConnectionInfoArgs'] connection_info: Connection information for SQL Server
        :param pulumi.Input[Sequence[pulumi.Input['SelectedCertificateInputArgs']]] selected_certificates: List containing certificate names and corresponding password to use for encrypting the exported certificate.
        """
        pulumi.set(__self__, "backup_file_share", backup_file_share)
        pulumi.set(__self__, "connection_info", connection_info)
        pulumi.set(__self__, "selected_certificates", selected_certificates)

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> pulumi.Input['FileShareArgs']:
        """
        Backup file share information for file share to be used for temporarily storing files.
        """
        return pulumi.get(self, "backup_file_share")

    @backup_file_share.setter
    def backup_file_share(self, value: pulumi.Input['FileShareArgs']):
        pulumi.set(self, "backup_file_share", value)

    @property
    @pulumi.getter(name="connectionInfo")
    def connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for SQL Server
        """
        return pulumi.get(self, "connection_info")

    @connection_info.setter
    def connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "connection_info", value)

    @property
    @pulumi.getter(name="selectedCertificates")
    def selected_certificates(self) -> pulumi.Input[Sequence[pulumi.Input['SelectedCertificateInputArgs']]]:
        """
        List containing certificate names and corresponding password to use for encrypting the exported certificate.
        """
        return pulumi.get(self, "selected_certificates")

    @selected_certificates.setter
    def selected_certificates(self, value: pulumi.Input[Sequence[pulumi.Input['SelectedCertificateInputArgs']]]):
        pulumi.set(self, "selected_certificates", value)


@pulumi.input_type
class GetTdeCertificatesSqlTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['GetTdeCertificatesSqlTaskInputArgs']] = None):
        """
        Properties for the task that gets TDE certificates in Base64 encoded format.
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'GetTDECertificates.Sql'.
        :param pulumi.Input['GetTdeCertificatesSqlTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'GetTDECertificates.Sql')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'GetTDECertificates.Sql'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['GetTdeCertificatesSqlTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['GetTdeCertificatesSqlTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class GetUserTablesSqlSyncTaskInputArgs:
    def __init__(__self__, *,
                 selected_source_databases: pulumi.Input[Sequence[pulumi.Input[str]]],
                 selected_target_databases: pulumi.Input[Sequence[pulumi.Input[str]]],
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs']):
        """
        Input for the task that collects user tables for the given list of databases
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_source_databases: List of source database names to collect tables for
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_target_databases: List of target database names to collect tables for
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Connection information for SQL Server
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Connection information for SQL DB
        """
        pulumi.set(__self__, "selected_source_databases", selected_source_databases)
        pulumi.set(__self__, "selected_target_databases", selected_target_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="selectedSourceDatabases")
    def selected_source_databases(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of source database names to collect tables for
        """
        return pulumi.get(self, "selected_source_databases")

    @selected_source_databases.setter
    def selected_source_databases(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "selected_source_databases", value)

    @property
    @pulumi.getter(name="selectedTargetDatabases")
    def selected_target_databases(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of target database names to collect tables for
        """
        return pulumi.get(self, "selected_target_databases")

    @selected_target_databases.setter
    def selected_target_databases(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "selected_target_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for SQL Server
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for SQL DB
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


@pulumi.input_type
class GetUserTablesSqlSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['GetUserTablesSqlSyncTaskInputArgs']] = None):
        """
        Properties for the task that collects user tables for the given list of databases
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'GetUserTables.AzureSqlDb.Sync'.
        :param pulumi.Input['GetUserTablesSqlSyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'GetUserTables.AzureSqlDb.Sync')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'GetUserTables.AzureSqlDb.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['GetUserTablesSqlSyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['GetUserTablesSqlSyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class GetUserTablesSqlTaskInputArgs:
    def __init__(__self__, *,
                 connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 selected_databases: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Input for the task that collects user tables for the given list of databases
        :param pulumi.Input['SqlConnectionInfoArgs'] connection_info: Connection information for SQL Server
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_databases: List of database names to collect tables for
        """
        pulumi.set(__self__, "connection_info", connection_info)
        pulumi.set(__self__, "selected_databases", selected_databases)

    @property
    @pulumi.getter(name="connectionInfo")
    def connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for SQL Server
        """
        return pulumi.get(self, "connection_info")

    @connection_info.setter
    def connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "connection_info", value)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of database names to collect tables for
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "selected_databases", value)


@pulumi.input_type
class GetUserTablesSqlTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['GetUserTablesSqlTaskInputArgs']] = None):
        """
        Properties for the task that collects user tables for the given list of databases
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'GetUserTables.Sql'.
        :param pulumi.Input['GetUserTablesSqlTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'GetUserTables.Sql')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'GetUserTables.Sql'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['GetUserTablesSqlTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['GetUserTablesSqlTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class MiSqlConnectionInfoArgs:
    def __init__(__self__, *,
                 managed_instance_resource_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Properties required to create a connection to Azure SQL database Managed instance
        :param pulumi.Input[str] managed_instance_resource_id: Resource id for Azure SQL database Managed instance
        :param pulumi.Input[str] type: Type of connection info
               Expected value is 'MiSqlConnectionInfo'.
        :param pulumi.Input[str] password: Password credential.
        :param pulumi.Input[str] user_name: User name
        """
        pulumi.set(__self__, "managed_instance_resource_id", managed_instance_resource_id)
        pulumi.set(__self__, "type", 'MiSqlConnectionInfo')
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="managedInstanceResourceId")
    def managed_instance_resource_id(self) -> pulumi.Input[str]:
        """
        Resource id for Azure SQL database Managed instance
        """
        return pulumi.get(self, "managed_instance_resource_id")

    @managed_instance_resource_id.setter
    def managed_instance_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "managed_instance_resource_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of connection info
        Expected value is 'MiSqlConnectionInfo'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password credential.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        User name
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs:
    def __init__(__self__, *,
                 migration_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_database_name: Optional[pulumi.Input[str]] = None,
                 target_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Database specific information for MySQL to Azure Database for MySQL migration task inputs
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] migration_setting: Migration settings which tune the migration behavior
        :param pulumi.Input[str] name: Name of the database
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] source_setting: Source settings to tune source endpoint migration behavior
        :param pulumi.Input[str] target_database_name: Name of target database. Note: Target database will be truncated before starting migration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] target_setting: Target settings to tune target endpoint migration behavior
        """
        if migration_setting is not None:
            pulumi.set(__self__, "migration_setting", migration_setting)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_setting is not None:
            pulumi.set(__self__, "source_setting", source_setting)
        if target_database_name is not None:
            pulumi.set(__self__, "target_database_name", target_database_name)
        if target_setting is not None:
            pulumi.set(__self__, "target_setting", target_setting)

    @property
    @pulumi.getter(name="migrationSetting")
    def migration_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Migration settings which tune the migration behavior
        """
        return pulumi.get(self, "migration_setting")

    @migration_setting.setter
    def migration_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "migration_setting", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the database
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceSetting")
    def source_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Source settings to tune source endpoint migration behavior
        """
        return pulumi.get(self, "source_setting")

    @source_setting.setter
    def source_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "source_setting", value)

    @property
    @pulumi.getter(name="targetDatabaseName")
    def target_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of target database. Note: Target database will be truncated before starting migration.
        """
        return pulumi.get(self, "target_database_name")

    @target_database_name.setter
    def target_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_database_name", value)

    @property
    @pulumi.getter(name="targetSetting")
    def target_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Target settings to tune target endpoint migration behavior
        """
        return pulumi.get(self, "target_setting")

    @target_setting.setter
    def target_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "target_setting", value)


@pulumi.input_type
class MigrateMySqlAzureDbForMySqlSyncTaskInputArgs:
    def __init__(__self__, *,
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['MySqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['MySqlConnectionInfoArgs']):
        """
        Input for the task that migrates MySQL databases to Azure Database for MySQL for online migrations
        :param pulumi.Input[Sequence[pulumi.Input['MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['MySqlConnectionInfoArgs'] source_connection_info: Connection information for source MySQL
        :param pulumi.Input['MySqlConnectionInfoArgs'] target_connection_info: Connection information for target Azure Database for MySQL
        """
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['MySqlConnectionInfoArgs']:
        """
        Connection information for source MySQL
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['MySqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['MySqlConnectionInfoArgs']:
        """
        Connection information for target Azure Database for MySQL
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['MySqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


@pulumi.input_type
class MigrateMySqlAzureDbForMySqlSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['MigrateMySqlAzureDbForMySqlSyncTaskInputArgs']] = None):
        """
        Properties for the task that migrates MySQL databases to Azure Database for MySQL for online migrations
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Migrate.MySql.AzureDbForMySql.Sync'.
        :param pulumi.Input['MigrateMySqlAzureDbForMySqlSyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'Migrate.MySql.AzureDbForMySql.Sync')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Migrate.MySql.AzureDbForMySql.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MigrateMySqlAzureDbForMySqlSyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MigrateMySqlAzureDbForMySqlSyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs:
    def __init__(__self__, *,
                 migration_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_database_name: Optional[pulumi.Input[str]] = None,
                 target_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Database specific information for PostgreSQL to Azure Database for PostgreSQL migration task inputs
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] migration_setting: Migration settings which tune the migration behavior
        :param pulumi.Input[str] name: Name of the database
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] source_setting: Source settings to tune source endpoint migration behavior
        :param pulumi.Input[str] target_database_name: Name of target database. Note: Target database will be truncated before starting migration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] target_setting: Target settings to tune target endpoint migration behavior
        """
        if migration_setting is not None:
            pulumi.set(__self__, "migration_setting", migration_setting)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_setting is not None:
            pulumi.set(__self__, "source_setting", source_setting)
        if target_database_name is not None:
            pulumi.set(__self__, "target_database_name", target_database_name)
        if target_setting is not None:
            pulumi.set(__self__, "target_setting", target_setting)

    @property
    @pulumi.getter(name="migrationSetting")
    def migration_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Migration settings which tune the migration behavior
        """
        return pulumi.get(self, "migration_setting")

    @migration_setting.setter
    def migration_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "migration_setting", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the database
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceSetting")
    def source_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Source settings to tune source endpoint migration behavior
        """
        return pulumi.get(self, "source_setting")

    @source_setting.setter
    def source_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "source_setting", value)

    @property
    @pulumi.getter(name="targetDatabaseName")
    def target_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of target database. Note: Target database will be truncated before starting migration.
        """
        return pulumi.get(self, "target_database_name")

    @target_database_name.setter
    def target_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_database_name", value)

    @property
    @pulumi.getter(name="targetSetting")
    def target_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Target settings to tune target endpoint migration behavior
        """
        return pulumi.get(self, "target_setting")

    @target_setting.setter
    def target_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "target_setting", value)


@pulumi.input_type
class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs:
    def __init__(__self__, *,
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['PostgreSqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        """
        Input for the task that migrates PostgreSQL databases to Azure Database for PostgreSQL for online migrations
        :param pulumi.Input[Sequence[pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['PostgreSqlConnectionInfoArgs'] source_connection_info: Connection information for source PostgreSQL
        :param pulumi.Input['PostgreSqlConnectionInfoArgs'] target_connection_info: Connection information for target Azure Database for PostgreSQL
        """
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['PostgreSqlConnectionInfoArgs']:
        """
        Connection information for source PostgreSQL
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['PostgreSqlConnectionInfoArgs']:
        """
        Connection information for target Azure Database for PostgreSQL
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


@pulumi.input_type
class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs']] = None):
        """
        Properties for the task that migrates PostgreSQL databases to Azure Database for PostgreSQL for online migrations
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Migrate.PostgreSql.AzureDbForPostgreSql.Sync'.
        :param pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'Migrate.PostgreSql.AzureDbForPostgreSql.Sync')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Migrate.PostgreSql.AzureDbForPostgreSql.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class MigrateSqlServerSqlDbDatabaseInputArgs:
    def __init__(__self__, *,
                 make_source_db_read_only: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 table_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_database_name: Optional[pulumi.Input[str]] = None):
        """
        Database specific information for SQL to Azure SQL DB migration task inputs
        :param pulumi.Input[bool] make_source_db_read_only: Whether to set database read only before migration
        :param pulumi.Input[str] name: Name of the database
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] table_map: Mapping of source to target tables
        :param pulumi.Input[str] target_database_name: Name of target database. Note: Target database will be truncated before starting migration.
        """
        if make_source_db_read_only is not None:
            pulumi.set(__self__, "make_source_db_read_only", make_source_db_read_only)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if table_map is not None:
            pulumi.set(__self__, "table_map", table_map)
        if target_database_name is not None:
            pulumi.set(__self__, "target_database_name", target_database_name)

    @property
    @pulumi.getter(name="makeSourceDbReadOnly")
    def make_source_db_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to set database read only before migration
        """
        return pulumi.get(self, "make_source_db_read_only")

    @make_source_db_read_only.setter
    def make_source_db_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "make_source_db_read_only", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the database
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tableMap")
    def table_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping of source to target tables
        """
        return pulumi.get(self, "table_map")

    @table_map.setter
    def table_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "table_map", value)

    @property
    @pulumi.getter(name="targetDatabaseName")
    def target_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of target database. Note: Target database will be truncated before starting migration.
        """
        return pulumi.get(self, "target_database_name")

    @target_database_name.setter
    def target_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_database_name", value)


@pulumi.input_type
class MigrateSqlServerSqlDbSyncDatabaseInputArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 migration_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 source_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 table_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_database_name: Optional[pulumi.Input[str]] = None,
                 target_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Database specific information for SQL to Azure SQL DB sync migration task inputs
        :param pulumi.Input[str] id: Unique identifier for database
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] migration_setting: Migration settings which tune the migration behavior
        :param pulumi.Input[str] name: Name of database
        :param pulumi.Input[str] schema_name: Schema name to be migrated
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] source_setting: Source settings to tune source endpoint migration behavior
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] table_map: Mapping of source to target tables
        :param pulumi.Input[str] target_database_name: Target database name
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] target_setting: Target settings to tune target endpoint migration behavior
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if migration_setting is not None:
            pulumi.set(__self__, "migration_setting", migration_setting)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if source_setting is not None:
            pulumi.set(__self__, "source_setting", source_setting)
        if table_map is not None:
            pulumi.set(__self__, "table_map", table_map)
        if target_database_name is not None:
            pulumi.set(__self__, "target_database_name", target_database_name)
        if target_setting is not None:
            pulumi.set(__self__, "target_setting", target_setting)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for database
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="migrationSetting")
    def migration_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Migration settings which tune the migration behavior
        """
        return pulumi.get(self, "migration_setting")

    @migration_setting.setter
    def migration_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "migration_setting", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of database
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        Schema name to be migrated
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter(name="sourceSetting")
    def source_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Source settings to tune source endpoint migration behavior
        """
        return pulumi.get(self, "source_setting")

    @source_setting.setter
    def source_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "source_setting", value)

    @property
    @pulumi.getter(name="tableMap")
    def table_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping of source to target tables
        """
        return pulumi.get(self, "table_map")

    @table_map.setter
    def table_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "table_map", value)

    @property
    @pulumi.getter(name="targetDatabaseName")
    def target_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Target database name
        """
        return pulumi.get(self, "target_database_name")

    @target_database_name.setter
    def target_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_database_name", value)

    @property
    @pulumi.getter(name="targetSetting")
    def target_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Target settings to tune target endpoint migration behavior
        """
        return pulumi.get(self, "target_setting")

    @target_setting.setter
    def target_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "target_setting", value)


@pulumi.input_type
class MigrateSqlServerSqlDbSyncTaskInputArgs:
    def __init__(__self__, *,
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbSyncDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 validation_options: Optional[pulumi.Input['MigrationValidationOptionsArgs']] = None):
        """
        Input for the task that migrates on-prem SQL Server databases to Azure SQL Database for online migrations
        :param pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbSyncDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Information for connecting to source
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Information for connecting to target
        :param pulumi.Input['MigrationValidationOptionsArgs'] validation_options: Validation options
        """
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if validation_options is not None:
            pulumi.set(__self__, "validation_options", validation_options)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbSyncDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbSyncDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to source
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)

    @property
    @pulumi.getter(name="validationOptions")
    def validation_options(self) -> Optional[pulumi.Input['MigrationValidationOptionsArgs']]:
        """
        Validation options
        """
        return pulumi.get(self, "validation_options")

    @validation_options.setter
    def validation_options(self, value: Optional[pulumi.Input['MigrationValidationOptionsArgs']]):
        pulumi.set(self, "validation_options", value)


@pulumi.input_type
class MigrateSqlServerSqlDbSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['MigrateSqlServerSqlDbSyncTaskInputArgs']] = None):
        """
        Properties for the task that migrates on-prem SQL Server databases to Azure SQL Database for online migrations
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Migrate.SqlServer.AzureSqlDb.Sync'.
        :param pulumi.Input['MigrateSqlServerSqlDbSyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'Migrate.SqlServer.AzureSqlDb.Sync')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Migrate.SqlServer.AzureSqlDb.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MigrateSqlServerSqlDbSyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MigrateSqlServerSqlDbSyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class MigrateSqlServerSqlDbTaskInputArgs:
    def __init__(__self__, *,
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 validation_options: Optional[pulumi.Input['MigrationValidationOptionsArgs']] = None):
        """
        Input for the task that migrates on-prem SQL Server databases to Azure SQL Database
        :param pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Information for connecting to source
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Information for connecting to target
        :param pulumi.Input['MigrationValidationOptionsArgs'] validation_options: Options for enabling various post migration validations. Available options, 
                1.) Data Integrity Check: Performs a checksum based comparison on source and target tables after the migration to ensure the correctness of the data. 
                2.) Schema Validation: Performs a thorough schema comparison between the source and target tables and provides a list of differences between the source and target database, 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and execute them and compares the execution time between the source and target database.
        """
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if validation_options is not None:
            pulumi.set(__self__, "validation_options", validation_options)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to source
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)

    @property
    @pulumi.getter(name="validationOptions")
    def validation_options(self) -> Optional[pulumi.Input['MigrationValidationOptionsArgs']]:
        """
        Options for enabling various post migration validations. Available options, 
         1.) Data Integrity Check: Performs a checksum based comparison on source and target tables after the migration to ensure the correctness of the data. 
         2.) Schema Validation: Performs a thorough schema comparison between the source and target tables and provides a list of differences between the source and target database, 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and execute them and compares the execution time between the source and target database.
        """
        return pulumi.get(self, "validation_options")

    @validation_options.setter
    def validation_options(self, value: Optional[pulumi.Input['MigrationValidationOptionsArgs']]):
        pulumi.set(self, "validation_options", value)


@pulumi.input_type
class MigrateSqlServerSqlDbTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['MigrateSqlServerSqlDbTaskInputArgs']] = None):
        """
        Properties for the task that migrates on-prem SQL Server databases to Azure SQL Database
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Migrate.SqlServer.SqlDb'.
        :param pulumi.Input['MigrateSqlServerSqlDbTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'Migrate.SqlServer.SqlDb')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Migrate.SqlServer.SqlDb'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MigrateSqlServerSqlDbTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MigrateSqlServerSqlDbTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class MigrateSqlServerSqlMIDatabaseInputArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 restore_database_name: pulumi.Input[str],
                 backup_file_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_file_share: Optional[pulumi.Input['FileShareArgs']] = None):
        """
        Database specific information for SQL to Azure SQL DB Managed Instance migration task inputs
        :param pulumi.Input[str] name: Name of the database
        :param pulumi.Input[str] restore_database_name: Name of the database at destination
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_file_paths: The list of backup files to be used in case of existing backups.
        :param pulumi.Input['FileShareArgs'] backup_file_share: Backup file share information for backing up this database.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "restore_database_name", restore_database_name)
        if backup_file_paths is not None:
            pulumi.set(__self__, "backup_file_paths", backup_file_paths)
        if backup_file_share is not None:
            pulumi.set(__self__, "backup_file_share", backup_file_share)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the database
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="restoreDatabaseName")
    def restore_database_name(self) -> pulumi.Input[str]:
        """
        Name of the database at destination
        """
        return pulumi.get(self, "restore_database_name")

    @restore_database_name.setter
    def restore_database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "restore_database_name", value)

    @property
    @pulumi.getter(name="backupFilePaths")
    def backup_file_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of backup files to be used in case of existing backups.
        """
        return pulumi.get(self, "backup_file_paths")

    @backup_file_paths.setter
    def backup_file_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "backup_file_paths", value)

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> Optional[pulumi.Input['FileShareArgs']]:
        """
        Backup file share information for backing up this database.
        """
        return pulumi.get(self, "backup_file_share")

    @backup_file_share.setter
    def backup_file_share(self, value: Optional[pulumi.Input['FileShareArgs']]):
        pulumi.set(self, "backup_file_share", value)


@pulumi.input_type
class MigrateSqlServerSqlMISyncTaskInputArgs:
    def __init__(__self__, *,
                 azure_app: pulumi.Input['AzureActiveDirectoryAppArgs'],
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 storage_resource_id: pulumi.Input[str],
                 target_connection_info: pulumi.Input['MiSqlConnectionInfoArgs'],
                 backup_file_share: Optional[pulumi.Input['FileShareArgs']] = None):
        """
        Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance online scenario.
        :param pulumi.Input['AzureActiveDirectoryAppArgs'] azure_app: Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
        :param pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Connection information for source SQL Server
        :param pulumi.Input[str] storage_resource_id: Fully qualified resourceId of storage
        :param pulumi.Input['MiSqlConnectionInfoArgs'] target_connection_info: Connection information for Azure SQL Database Managed Instance
        :param pulumi.Input['FileShareArgs'] backup_file_share: Backup file share information for all selected databases.
        """
        pulumi.set(__self__, "azure_app", azure_app)
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "storage_resource_id", storage_resource_id)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if backup_file_share is not None:
            pulumi.set(__self__, "backup_file_share", backup_file_share)

    @property
    @pulumi.getter(name="azureApp")
    def azure_app(self) -> pulumi.Input['AzureActiveDirectoryAppArgs']:
        """
        Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
        """
        return pulumi.get(self, "azure_app")

    @azure_app.setter
    def azure_app(self, value: pulumi.Input['AzureActiveDirectoryAppArgs']):
        pulumi.set(self, "azure_app", value)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for source SQL Server
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="storageResourceId")
    def storage_resource_id(self) -> pulumi.Input[str]:
        """
        Fully qualified resourceId of storage
        """
        return pulumi.get(self, "storage_resource_id")

    @storage_resource_id.setter
    def storage_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_resource_id", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['MiSqlConnectionInfoArgs']:
        """
        Connection information for Azure SQL Database Managed Instance
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['MiSqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> Optional[pulumi.Input['FileShareArgs']]:
        """
        Backup file share information for all selected databases.
        """
        return pulumi.get(self, "backup_file_share")

    @backup_file_share.setter
    def backup_file_share(self, value: Optional[pulumi.Input['FileShareArgs']]):
        pulumi.set(self, "backup_file_share", value)


@pulumi.input_type
class MigrateSqlServerSqlMISyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['MigrateSqlServerSqlMISyncTaskInputArgs']] = None):
        """
        Properties for task that migrates SQL Server databases to Azure SQL Database Managed Instance sync scenario
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Migrate.SqlServer.AzureSqlDbMI.Sync.LRS'.
        :param pulumi.Input['MigrateSqlServerSqlMISyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'Migrate.SqlServer.AzureSqlDbMI.Sync.LRS')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Migrate.SqlServer.AzureSqlDbMI.Sync.LRS'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MigrateSqlServerSqlMISyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MigrateSqlServerSqlMISyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class MigrateSqlServerSqlMITaskInputArgs:
    def __init__(__self__, *,
                 backup_blob_share: pulumi.Input['BlobShareArgs'],
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 backup_file_share: Optional[pulumi.Input['FileShareArgs']] = None,
                 backup_mode: Optional[pulumi.Input[Union[str, 'BackupMode']]] = None,
                 selected_agent_jobs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 selected_logins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance.
        :param pulumi.Input['BlobShareArgs'] backup_blob_share: SAS URI of Azure Storage Account Container to be used for storing backup files.
        :param pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Information for connecting to source
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Information for connecting to target
        :param pulumi.Input['FileShareArgs'] backup_file_share: Backup file share information for all selected databases.
        :param pulumi.Input[Union[str, 'BackupMode']] backup_mode: Backup Mode to specify whether to use existing backup or create new backup. If using existing backups, backup file paths are required to be provided in selectedDatabases.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_agent_jobs: Agent Jobs to migrate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_logins: Logins to migrate.
        """
        pulumi.set(__self__, "backup_blob_share", backup_blob_share)
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if backup_file_share is not None:
            pulumi.set(__self__, "backup_file_share", backup_file_share)
        if backup_mode is not None:
            pulumi.set(__self__, "backup_mode", backup_mode)
        if selected_agent_jobs is not None:
            pulumi.set(__self__, "selected_agent_jobs", selected_agent_jobs)
        if selected_logins is not None:
            pulumi.set(__self__, "selected_logins", selected_logins)

    @property
    @pulumi.getter(name="backupBlobShare")
    def backup_blob_share(self) -> pulumi.Input['BlobShareArgs']:
        """
        SAS URI of Azure Storage Account Container to be used for storing backup files.
        """
        return pulumi.get(self, "backup_blob_share")

    @backup_blob_share.setter
    def backup_blob_share(self, value: pulumi.Input['BlobShareArgs']):
        pulumi.set(self, "backup_blob_share", value)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to source
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> Optional[pulumi.Input['FileShareArgs']]:
        """
        Backup file share information for all selected databases.
        """
        return pulumi.get(self, "backup_file_share")

    @backup_file_share.setter
    def backup_file_share(self, value: Optional[pulumi.Input['FileShareArgs']]):
        pulumi.set(self, "backup_file_share", value)

    @property
    @pulumi.getter(name="backupMode")
    def backup_mode(self) -> Optional[pulumi.Input[Union[str, 'BackupMode']]]:
        """
        Backup Mode to specify whether to use existing backup or create new backup. If using existing backups, backup file paths are required to be provided in selectedDatabases.
        """
        return pulumi.get(self, "backup_mode")

    @backup_mode.setter
    def backup_mode(self, value: Optional[pulumi.Input[Union[str, 'BackupMode']]]):
        pulumi.set(self, "backup_mode", value)

    @property
    @pulumi.getter(name="selectedAgentJobs")
    def selected_agent_jobs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Agent Jobs to migrate.
        """
        return pulumi.get(self, "selected_agent_jobs")

    @selected_agent_jobs.setter
    def selected_agent_jobs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "selected_agent_jobs", value)

    @property
    @pulumi.getter(name="selectedLogins")
    def selected_logins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Logins to migrate.
        """
        return pulumi.get(self, "selected_logins")

    @selected_logins.setter
    def selected_logins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "selected_logins", value)


@pulumi.input_type
class MigrateSqlServerSqlMITaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['MigrateSqlServerSqlMITaskInputArgs']] = None):
        """
        Properties for task that migrates SQL Server databases to Azure SQL Database Managed Instance
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Migrate.SqlServer.AzureSqlDbMI'.
        :param pulumi.Input['MigrateSqlServerSqlMITaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'Migrate.SqlServer.AzureSqlDbMI')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Migrate.SqlServer.AzureSqlDbMI'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MigrateSqlServerSqlMITaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MigrateSqlServerSqlMITaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class MigrationValidationOptionsArgs:
    def __init__(__self__, *,
                 enable_data_integrity_validation: Optional[pulumi.Input[bool]] = None,
                 enable_query_analysis_validation: Optional[pulumi.Input[bool]] = None,
                 enable_schema_validation: Optional[pulumi.Input[bool]] = None):
        """
        Types of validations to run after the migration
        :param pulumi.Input[bool] enable_data_integrity_validation: Allows to perform a checksum based data integrity validation between source and target for the selected database / tables .
        :param pulumi.Input[bool] enable_query_analysis_validation: Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them in the target. The result will have execution statistics for executions in source and target databases for the extracted queries.
        :param pulumi.Input[bool] enable_schema_validation: Allows to compare the schema information between source and target.
        """
        if enable_data_integrity_validation is not None:
            pulumi.set(__self__, "enable_data_integrity_validation", enable_data_integrity_validation)
        if enable_query_analysis_validation is not None:
            pulumi.set(__self__, "enable_query_analysis_validation", enable_query_analysis_validation)
        if enable_schema_validation is not None:
            pulumi.set(__self__, "enable_schema_validation", enable_schema_validation)

    @property
    @pulumi.getter(name="enableDataIntegrityValidation")
    def enable_data_integrity_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows to perform a checksum based data integrity validation between source and target for the selected database / tables .
        """
        return pulumi.get(self, "enable_data_integrity_validation")

    @enable_data_integrity_validation.setter
    def enable_data_integrity_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_data_integrity_validation", value)

    @property
    @pulumi.getter(name="enableQueryAnalysisValidation")
    def enable_query_analysis_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them in the target. The result will have execution statistics for executions in source and target databases for the extracted queries.
        """
        return pulumi.get(self, "enable_query_analysis_validation")

    @enable_query_analysis_validation.setter
    def enable_query_analysis_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_query_analysis_validation", value)

    @property
    @pulumi.getter(name="enableSchemaValidation")
    def enable_schema_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows to compare the schema information between source and target.
        """
        return pulumi.get(self, "enable_schema_validation")

    @enable_schema_validation.setter
    def enable_schema_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_schema_validation", value)


@pulumi.input_type
class MySqlConnectionInfoArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 server_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Information for connecting to MySQL server
        :param pulumi.Input[int] port: Port for Server
        :param pulumi.Input[str] server_name: Name of the server
        :param pulumi.Input[str] type: Type of connection info
               Expected value is 'MySqlConnectionInfo'.
        :param pulumi.Input[str] password: Password credential.
        :param pulumi.Input[str] user_name: User name
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "type", 'MySqlConnectionInfo')
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Port for Server
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        Name of the server
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of connection info
        Expected value is 'MySqlConnectionInfo'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password credential.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        User name
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class PostgreSqlConnectionInfoArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 server_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 database_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Information for connecting to PostgreSQL server
        :param pulumi.Input[int] port: Port for Server
        :param pulumi.Input[str] server_name: Name of the server
        :param pulumi.Input[str] type: Type of connection info
               Expected value is 'PostgreSqlConnectionInfo'.
        :param pulumi.Input[str] database_name: Name of the database
        :param pulumi.Input[str] password: Password credential.
        :param pulumi.Input[str] user_name: User name
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "type", 'PostgreSqlConnectionInfo')
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Port for Server
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        Name of the server
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of connection info
        Expected value is 'PostgreSqlConnectionInfo'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the database
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password credential.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        User name
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class ProjectFilePropertiesArgs:
    def __init__(__self__, *,
                 extension: Optional[pulumi.Input[str]] = None,
                 file_path: Optional[pulumi.Input[str]] = None,
                 media_type: Optional[pulumi.Input[str]] = None):
        """
        Base class for file properties.
        :param pulumi.Input[str] extension: Optional File extension. If submitted it should not have a leading period and must match the extension from filePath.
        :param pulumi.Input[str] file_path: Relative path of this file resource. This property can be set when creating or updating the file resource.
        :param pulumi.Input[str] media_type: File content type. This property can be modified to reflect the file content type.
        """
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if media_type is not None:
            pulumi.set(__self__, "media_type", media_type)

    @property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input[str]]:
        """
        Optional File extension. If submitted it should not have a leading period and must match the extension from filePath.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extension", value)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[pulumi.Input[str]]:
        """
        Relative path of this file resource. This property can be set when creating or updating the file resource.
        """
        return pulumi.get(self, "file_path")

    @file_path.setter
    def file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_path", value)

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> Optional[pulumi.Input[str]]:
        """
        File content type. This property can be modified to reflect the file content type.
        """
        return pulumi.get(self, "media_type")

    @media_type.setter
    def media_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "media_type", value)


@pulumi.input_type
class SelectedCertificateInputArgs:
    def __init__(__self__, *,
                 certificate_name: pulumi.Input[str],
                 password: pulumi.Input[str]):
        """
        Info for certificate to be exported for TDE enabled databases.
        :param pulumi.Input[str] certificate_name: Name of certificate to be exported.
        :param pulumi.Input[str] password: Password to use for encrypting the exported certificate.
        """
        pulumi.set(__self__, "certificate_name", certificate_name)
        pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Input[str]:
        """
        Name of certificate to be exported.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_name", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Password to use for encrypting the exported certificate.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)


@pulumi.input_type
class ServiceSkuArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[int]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        An Azure SKU instance
        :param pulumi.Input[int] capacity: The capacity of the SKU, if it supports scaling
        :param pulumi.Input[str] family: The SKU family, used when the service has multiple performance classes within a tier, such as 'A', 'D', etc. for virtual machines
        :param pulumi.Input[str] name: The unique name of the SKU, such as 'P3'
        :param pulumi.Input[str] size: The size of the SKU, used when the name alone does not denote a service size or when a SKU has multiple performance classes within a family, e.g. 'A1' for virtual machines
        :param pulumi.Input[str] tier: The tier of the SKU, such as 'Free', 'Basic', 'Standard', or 'Premium'
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The capacity of the SKU, if it supports scaling
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU family, used when the service has multiple performance classes within a tier, such as 'A', 'D', etc. for virtual machines
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name of the SKU, such as 'P3'
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the SKU, used when the name alone does not denote a service size or when a SKU has multiple performance classes within a family, e.g. 'A1' for virtual machines
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        The tier of the SKU, such as 'Free', 'Basic', 'Standard', or 'Premium'
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SqlConnectionInformationArgs:
    def __init__(__self__, *,
                 authentication: Optional[pulumi.Input[str]] = None,
                 data_source: Optional[pulumi.Input[str]] = None,
                 encrypt_connection: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 trust_server_certificate: Optional[pulumi.Input[bool]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Source SQL Connection
        :param pulumi.Input[str] authentication: Authentication type.
        :param pulumi.Input[str] data_source: Data source.
        :param pulumi.Input[bool] encrypt_connection: Whether to encrypt connection or not.
        :param pulumi.Input[str] password: Password to connect to source SQL.
        :param pulumi.Input[bool] trust_server_certificate: Whether to trust server certificate or not.
        :param pulumi.Input[str] user_name: User name to connect to source SQL.
        """
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if encrypt_connection is not None:
            pulumi.set(__self__, "encrypt_connection", encrypt_connection)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if trust_server_certificate is not None:
            pulumi.set(__self__, "trust_server_certificate", trust_server_certificate)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input[str]]:
        """
        Authentication type.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input[str]]:
        """
        Data source.
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter(name="encryptConnection")
    def encrypt_connection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to encrypt connection or not.
        """
        return pulumi.get(self, "encrypt_connection")

    @encrypt_connection.setter
    def encrypt_connection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_connection", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password to connect to source SQL.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="trustServerCertificate")
    def trust_server_certificate(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to trust server certificate or not.
        """
        return pulumi.get(self, "trust_server_certificate")

    @trust_server_certificate.setter
    def trust_server_certificate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "trust_server_certificate", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        User name to connect to source SQL.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class SqlConnectionInfoArgs:
    def __init__(__self__, *,
                 data_source: pulumi.Input[str],
                 type: pulumi.Input[str],
                 additional_settings: Optional[pulumi.Input[str]] = None,
                 authentication: Optional[pulumi.Input[Union[str, 'AuthenticationType']]] = None,
                 encrypt_connection: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[Union[str, 'SqlSourcePlatform']]] = None,
                 trust_server_certificate: Optional[pulumi.Input[bool]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Information for connecting to SQL database server
        :param pulumi.Input[str] data_source: Data source in the format Protocol:MachineName\\SQLServerInstanceName,PortNumber
        :param pulumi.Input[str] type: Type of connection info
               Expected value is 'SqlConnectionInfo'.
        :param pulumi.Input[str] additional_settings: Additional connection settings
        :param pulumi.Input[Union[str, 'AuthenticationType']] authentication: Authentication type to use for connection
        :param pulumi.Input[bool] encrypt_connection: Whether to encrypt the connection
        :param pulumi.Input[str] password: Password credential.
        :param pulumi.Input[Union[str, 'SqlSourcePlatform']] platform: Server platform type for connection
        :param pulumi.Input[bool] trust_server_certificate: Whether to trust the server certificate
        :param pulumi.Input[str] user_name: User name
        """
        pulumi.set(__self__, "data_source", data_source)
        pulumi.set(__self__, "type", 'SqlConnectionInfo')
        if additional_settings is not None:
            pulumi.set(__self__, "additional_settings", additional_settings)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if encrypt_connection is None:
            encrypt_connection = True
        if encrypt_connection is not None:
            pulumi.set(__self__, "encrypt_connection", encrypt_connection)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if trust_server_certificate is None:
            trust_server_certificate = False
        if trust_server_certificate is not None:
            pulumi.set(__self__, "trust_server_certificate", trust_server_certificate)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> pulumi.Input[str]:
        """
        Data source in the format Protocol:MachineName\\SQLServerInstanceName,PortNumber
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of connection info
        Expected value is 'SqlConnectionInfo'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="additionalSettings")
    def additional_settings(self) -> Optional[pulumi.Input[str]]:
        """
        Additional connection settings
        """
        return pulumi.get(self, "additional_settings")

    @additional_settings.setter
    def additional_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_settings", value)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationType']]]:
        """
        Authentication type to use for connection
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationType']]]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="encryptConnection")
    def encrypt_connection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to encrypt the connection
        """
        return pulumi.get(self, "encrypt_connection")

    @encrypt_connection.setter
    def encrypt_connection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_connection", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password credential.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[Union[str, 'SqlSourcePlatform']]]:
        """
        Server platform type for connection
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[Union[str, 'SqlSourcePlatform']]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="trustServerCertificate")
    def trust_server_certificate(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to trust the server certificate
        """
        return pulumi.get(self, "trust_server_certificate")

    @trust_server_certificate.setter
    def trust_server_certificate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "trust_server_certificate", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        User name
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class ValidateMigrationInputSqlServerSqlDbSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['ValidateSyncMigrationInputSqlServerTaskInputArgs']] = None):
        """
        Properties for task that validates migration input for SQL to Azure SQL DB sync migrations
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ValidateMigrationInput.SqlServer.SqlDb.Sync'.
        :param pulumi.Input['ValidateSyncMigrationInputSqlServerTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ValidateMigrationInput.SqlServer.SqlDb.Sync')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ValidateMigrationInput.SqlServer.SqlDb.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ValidateSyncMigrationInputSqlServerTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ValidateSyncMigrationInputSqlServerTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs:
    def __init__(__self__, *,
                 azure_app: pulumi.Input['AzureActiveDirectoryAppArgs'],
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 storage_resource_id: pulumi.Input[str],
                 target_connection_info: pulumi.Input['MiSqlConnectionInfoArgs'],
                 backup_file_share: Optional[pulumi.Input['FileShareArgs']] = None):
        """
        Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance online scenario.
        :param pulumi.Input['AzureActiveDirectoryAppArgs'] azure_app: Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
        :param pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Connection information for source SQL Server
        :param pulumi.Input[str] storage_resource_id: Fully qualified resourceId of storage
        :param pulumi.Input['MiSqlConnectionInfoArgs'] target_connection_info: Connection information for Azure SQL Database Managed Instance
        :param pulumi.Input['FileShareArgs'] backup_file_share: Backup file share information for all selected databases.
        """
        pulumi.set(__self__, "azure_app", azure_app)
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "storage_resource_id", storage_resource_id)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if backup_file_share is not None:
            pulumi.set(__self__, "backup_file_share", backup_file_share)

    @property
    @pulumi.getter(name="azureApp")
    def azure_app(self) -> pulumi.Input['AzureActiveDirectoryAppArgs']:
        """
        Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
        """
        return pulumi.get(self, "azure_app")

    @azure_app.setter
    def azure_app(self, value: pulumi.Input['AzureActiveDirectoryAppArgs']):
        pulumi.set(self, "azure_app", value)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for source SQL Server
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="storageResourceId")
    def storage_resource_id(self) -> pulumi.Input[str]:
        """
        Fully qualified resourceId of storage
        """
        return pulumi.get(self, "storage_resource_id")

    @storage_resource_id.setter
    def storage_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_resource_id", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['MiSqlConnectionInfoArgs']:
        """
        Connection information for Azure SQL Database Managed Instance
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['MiSqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> Optional[pulumi.Input['FileShareArgs']]:
        """
        Backup file share information for all selected databases.
        """
        return pulumi.get(self, "backup_file_share")

    @backup_file_share.setter
    def backup_file_share(self, value: Optional[pulumi.Input['FileShareArgs']]):
        pulumi.set(self, "backup_file_share", value)


@pulumi.input_type
class ValidateMigrationInputSqlServerSqlMISyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs']] = None):
        """
        Properties for task that validates migration input for SQL to Azure SQL Database Managed Instance sync scenario
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS'.
        :param pulumi.Input['ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ValidateMigrationInputSqlServerSqlMITaskInputArgs:
    def __init__(__self__, *,
                 backup_blob_share: pulumi.Input['BlobShareArgs'],
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 backup_file_share: Optional[pulumi.Input['FileShareArgs']] = None,
                 backup_mode: Optional[pulumi.Input[Union[str, 'BackupMode']]] = None,
                 selected_logins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input for task that validates migration input for SQL to Azure SQL Managed Instance
        :param pulumi.Input['BlobShareArgs'] backup_blob_share: SAS URI of Azure Storage Account Container to be used for storing backup files.
        :param pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Information for connecting to source
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Information for connecting to target
        :param pulumi.Input['FileShareArgs'] backup_file_share: Backup file share information for all selected databases.
        :param pulumi.Input[Union[str, 'BackupMode']] backup_mode: Backup Mode to specify whether to use existing backup or create new backup.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_logins: Logins to migrate
        """
        pulumi.set(__self__, "backup_blob_share", backup_blob_share)
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if backup_file_share is not None:
            pulumi.set(__self__, "backup_file_share", backup_file_share)
        if backup_mode is not None:
            pulumi.set(__self__, "backup_mode", backup_mode)
        if selected_logins is not None:
            pulumi.set(__self__, "selected_logins", selected_logins)

    @property
    @pulumi.getter(name="backupBlobShare")
    def backup_blob_share(self) -> pulumi.Input['BlobShareArgs']:
        """
        SAS URI of Azure Storage Account Container to be used for storing backup files.
        """
        return pulumi.get(self, "backup_blob_share")

    @backup_blob_share.setter
    def backup_blob_share(self, value: pulumi.Input['BlobShareArgs']):
        pulumi.set(self, "backup_blob_share", value)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to source
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> Optional[pulumi.Input['FileShareArgs']]:
        """
        Backup file share information for all selected databases.
        """
        return pulumi.get(self, "backup_file_share")

    @backup_file_share.setter
    def backup_file_share(self, value: Optional[pulumi.Input['FileShareArgs']]):
        pulumi.set(self, "backup_file_share", value)

    @property
    @pulumi.getter(name="backupMode")
    def backup_mode(self) -> Optional[pulumi.Input[Union[str, 'BackupMode']]]:
        """
        Backup Mode to specify whether to use existing backup or create new backup.
        """
        return pulumi.get(self, "backup_mode")

    @backup_mode.setter
    def backup_mode(self, value: Optional[pulumi.Input[Union[str, 'BackupMode']]]):
        pulumi.set(self, "backup_mode", value)

    @property
    @pulumi.getter(name="selectedLogins")
    def selected_logins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Logins to migrate
        """
        return pulumi.get(self, "selected_logins")

    @selected_logins.setter
    def selected_logins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "selected_logins", value)


@pulumi.input_type
class ValidateMigrationInputSqlServerSqlMITaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 input: Optional[pulumi.Input['ValidateMigrationInputSqlServerSqlMITaskInputArgs']] = None):
        """
        Properties for task that validates migration input for SQL to Azure SQL Database Managed Instance
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ValidateMigrationInput.SqlServer.AzureSqlDbMI'.
        :param pulumi.Input['ValidateMigrationInputSqlServerSqlMITaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ValidateMigrationInput.SqlServer.AzureSqlDbMI')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ValidateMigrationInput.SqlServer.AzureSqlDbMI'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ValidateMigrationInputSqlServerSqlMITaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ValidateMigrationInputSqlServerSqlMITaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ValidateSyncMigrationInputSqlServerTaskInputArgs:
    def __init__(__self__, *,
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbSyncDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs']):
        """
        Input for task that validates migration input for SQL sync migrations
        :param pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbSyncDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Information for connecting to source SQL server
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Information for connecting to target
        """
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbSyncDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbSyncDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to source SQL server
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


