# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'CopyCompletionErrorArgs',
    'CreationDataArgs',
    'DiskSecurityProfileArgs',
    'DiskSkuArgs',
    'EncryptionSetIdentityArgs',
    'EncryptionSettingsCollectionArgs',
    'EncryptionSettingsElementArgs',
    'EncryptionArgs',
    'ExtendedLocationArgs',
    'ImageDiskReferenceArgs',
    'KeyForDiskEncryptionSetArgs',
    'KeyVaultAndKeyReferenceArgs',
    'KeyVaultAndSecretReferenceArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'PurchasePlanArgs',
    'SnapshotSkuArgs',
    'SourceVaultArgs',
    'SupportedCapabilitiesArgs',
]

@pulumi.input_type
class CopyCompletionErrorArgs:
    def __init__(__self__, *,
                 error_code: pulumi.Input[Union[str, 'CopyCompletionErrorReason']],
                 error_message: pulumi.Input[str]):
        """
        Indicates the error details if the background copy of a resource created via the CopyStart operation fails.
        :param pulumi.Input[Union[str, 'CopyCompletionErrorReason']] error_code: Indicates the error code if the background copy of a resource created via the CopyStart operation fails.
        :param pulumi.Input[str] error_message: Indicates the error message if the background copy of a resource created via the CopyStart operation fails.
        """
        pulumi.set(__self__, "error_code", error_code)
        pulumi.set(__self__, "error_message", error_message)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> pulumi.Input[Union[str, 'CopyCompletionErrorReason']]:
        """
        Indicates the error code if the background copy of a resource created via the CopyStart operation fails.
        """
        return pulumi.get(self, "error_code")

    @error_code.setter
    def error_code(self, value: pulumi.Input[Union[str, 'CopyCompletionErrorReason']]):
        pulumi.set(self, "error_code", value)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> pulumi.Input[str]:
        """
        Indicates the error message if the background copy of a resource created via the CopyStart operation fails.
        """
        return pulumi.get(self, "error_message")

    @error_message.setter
    def error_message(self, value: pulumi.Input[str]):
        pulumi.set(self, "error_message", value)


@pulumi.input_type
class CreationDataArgs:
    def __init__(__self__, *,
                 create_option: pulumi.Input[Union[str, 'DiskCreateOption']],
                 gallery_image_reference: Optional[pulumi.Input['ImageDiskReferenceArgs']] = None,
                 image_reference: Optional[pulumi.Input['ImageDiskReferenceArgs']] = None,
                 logical_sector_size: Optional[pulumi.Input[int]] = None,
                 security_data_uri: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 source_uri: Optional[pulumi.Input[str]] = None,
                 storage_account_id: Optional[pulumi.Input[str]] = None,
                 upload_size_bytes: Optional[pulumi.Input[float]] = None):
        """
        Data used when creating a disk.
        :param pulumi.Input[Union[str, 'DiskCreateOption']] create_option: This enumerates the possible sources of a disk's creation.
        :param pulumi.Input['ImageDiskReferenceArgs'] gallery_image_reference: Required if creating from a Gallery Image. The id/sharedGalleryImageId/communityGalleryImageId of the ImageDiskReference will be the ARM id of the shared galley image version from which to create a disk.
        :param pulumi.Input['ImageDiskReferenceArgs'] image_reference: Disk source information for PIR or user images.
        :param pulumi.Input[int] logical_sector_size: Logical sector size in bytes for Ultra disks. Supported values are 512 ad 4096. 4096 is the default.
        :param pulumi.Input[str] security_data_uri: If createOption is ImportSecure, this is the URI of a blob to be imported into VM guest state.
        :param pulumi.Input[str] source_resource_id: If createOption is Copy, this is the ARM id of the source snapshot or disk.
        :param pulumi.Input[str] source_uri: If createOption is Import, this is the URI of a blob to be imported into a managed disk.
        :param pulumi.Input[str] storage_account_id: Required if createOption is Import. The Azure Resource Manager identifier of the storage account containing the blob to import as a disk.
        :param pulumi.Input[float] upload_size_bytes: If createOption is Upload, this is the size of the contents of the upload including the VHD footer. This value should be between 20972032 (20 MiB + 512 bytes for the VHD footer) and 35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
        """
        pulumi.set(__self__, "create_option", create_option)
        if gallery_image_reference is not None:
            pulumi.set(__self__, "gallery_image_reference", gallery_image_reference)
        if image_reference is not None:
            pulumi.set(__self__, "image_reference", image_reference)
        if logical_sector_size is not None:
            pulumi.set(__self__, "logical_sector_size", logical_sector_size)
        if security_data_uri is not None:
            pulumi.set(__self__, "security_data_uri", security_data_uri)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if source_uri is not None:
            pulumi.set(__self__, "source_uri", source_uri)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if upload_size_bytes is not None:
            pulumi.set(__self__, "upload_size_bytes", upload_size_bytes)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> pulumi.Input[Union[str, 'DiskCreateOption']]:
        """
        This enumerates the possible sources of a disk's creation.
        """
        return pulumi.get(self, "create_option")

    @create_option.setter
    def create_option(self, value: pulumi.Input[Union[str, 'DiskCreateOption']]):
        pulumi.set(self, "create_option", value)

    @property
    @pulumi.getter(name="galleryImageReference")
    def gallery_image_reference(self) -> Optional[pulumi.Input['ImageDiskReferenceArgs']]:
        """
        Required if creating from a Gallery Image. The id/sharedGalleryImageId/communityGalleryImageId of the ImageDiskReference will be the ARM id of the shared galley image version from which to create a disk.
        """
        return pulumi.get(self, "gallery_image_reference")

    @gallery_image_reference.setter
    def gallery_image_reference(self, value: Optional[pulumi.Input['ImageDiskReferenceArgs']]):
        pulumi.set(self, "gallery_image_reference", value)

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> Optional[pulumi.Input['ImageDiskReferenceArgs']]:
        """
        Disk source information for PIR or user images.
        """
        return pulumi.get(self, "image_reference")

    @image_reference.setter
    def image_reference(self, value: Optional[pulumi.Input['ImageDiskReferenceArgs']]):
        pulumi.set(self, "image_reference", value)

    @property
    @pulumi.getter(name="logicalSectorSize")
    def logical_sector_size(self) -> Optional[pulumi.Input[int]]:
        """
        Logical sector size in bytes for Ultra disks. Supported values are 512 ad 4096. 4096 is the default.
        """
        return pulumi.get(self, "logical_sector_size")

    @logical_sector_size.setter
    def logical_sector_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "logical_sector_size", value)

    @property
    @pulumi.getter(name="securityDataUri")
    def security_data_uri(self) -> Optional[pulumi.Input[str]]:
        """
        If createOption is ImportSecure, this is the URI of a blob to be imported into VM guest state.
        """
        return pulumi.get(self, "security_data_uri")

    @security_data_uri.setter
    def security_data_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_data_uri", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        If createOption is Copy, this is the ARM id of the source snapshot or disk.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> Optional[pulumi.Input[str]]:
        """
        If createOption is Import, this is the URI of a blob to be imported into a managed disk.
        """
        return pulumi.get(self, "source_uri")

    @source_uri.setter
    def source_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_uri", value)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required if createOption is Import. The Azure Resource Manager identifier of the storage account containing the blob to import as a disk.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_id", value)

    @property
    @pulumi.getter(name="uploadSizeBytes")
    def upload_size_bytes(self) -> Optional[pulumi.Input[float]]:
        """
        If createOption is Upload, this is the size of the contents of the upload including the VHD footer. This value should be between 20972032 (20 MiB + 512 bytes for the VHD footer) and 35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
        """
        return pulumi.get(self, "upload_size_bytes")

    @upload_size_bytes.setter
    def upload_size_bytes(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "upload_size_bytes", value)


@pulumi.input_type
class DiskSecurityProfileArgs:
    def __init__(__self__, *,
                 secure_vm_disk_encryption_set_id: Optional[pulumi.Input[str]] = None,
                 security_type: Optional[pulumi.Input[Union[str, 'DiskSecurityTypes']]] = None):
        """
        Contains the security related information for the resource.
        :param pulumi.Input[str] secure_vm_disk_encryption_set_id: ResourceId of the disk encryption set associated to Confidential VM supported disk encrypted with customer managed key
        :param pulumi.Input[Union[str, 'DiskSecurityTypes']] security_type: Specifies the SecurityType of the VM. Applicable for OS disks only.
        """
        if secure_vm_disk_encryption_set_id is not None:
            pulumi.set(__self__, "secure_vm_disk_encryption_set_id", secure_vm_disk_encryption_set_id)
        if security_type is not None:
            pulumi.set(__self__, "security_type", security_type)

    @property
    @pulumi.getter(name="secureVMDiskEncryptionSetId")
    def secure_vm_disk_encryption_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        ResourceId of the disk encryption set associated to Confidential VM supported disk encrypted with customer managed key
        """
        return pulumi.get(self, "secure_vm_disk_encryption_set_id")

    @secure_vm_disk_encryption_set_id.setter
    def secure_vm_disk_encryption_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secure_vm_disk_encryption_set_id", value)

    @property
    @pulumi.getter(name="securityType")
    def security_type(self) -> Optional[pulumi.Input[Union[str, 'DiskSecurityTypes']]]:
        """
        Specifies the SecurityType of the VM. Applicable for OS disks only.
        """
        return pulumi.get(self, "security_type")

    @security_type.setter
    def security_type(self, value: Optional[pulumi.Input[Union[str, 'DiskSecurityTypes']]]):
        pulumi.set(self, "security_type", value)


@pulumi.input_type
class DiskSkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[Union[str, 'DiskStorageAccountTypes']]] = None):
        """
        The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
        :param pulumi.Input[Union[str, 'DiskStorageAccountTypes']] name: The sku name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'DiskStorageAccountTypes']]]:
        """
        The sku name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'DiskStorageAccountTypes']]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class EncryptionSetIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'DiskEncryptionSetIdentityType']]] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The managed identity for the disk encryption set. It should be given permission on the key vault before it can be used to encrypt disks.
        :param pulumi.Input[Union[str, 'DiskEncryptionSetIdentityType']] type: The type of Managed Identity used by the DiskEncryptionSet. Only SystemAssigned is supported for new creations. Disk Encryption Sets can be updated with Identity type None during migration of subscription to a new Azure Active Directory tenant; it will cause the encrypted resources to lose access to the keys.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The list of user identities associated with the disk encryption set. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'DiskEncryptionSetIdentityType']]]:
        """
        The type of Managed Identity used by the DiskEncryptionSet. Only SystemAssigned is supported for new creations. Disk Encryption Sets can be updated with Identity type None during migration of subscription to a new Azure Active Directory tenant; it will cause the encrypted resources to lose access to the keys.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'DiskEncryptionSetIdentityType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The list of user identities associated with the disk encryption set. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class EncryptionSettingsCollectionArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 encryption_settings: Optional[pulumi.Input[Sequence[pulumi.Input['EncryptionSettingsElementArgs']]]] = None,
                 encryption_settings_version: Optional[pulumi.Input[str]] = None):
        """
        Encryption settings for disk or snapshot
        :param pulumi.Input[bool] enabled: Set this flag to true and provide DiskEncryptionKey and optional KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object, the existing settings remain unchanged.
        :param pulumi.Input[Sequence[pulumi.Input['EncryptionSettingsElementArgs']]] encryption_settings: A collection of encryption settings, one for each disk volume.
        :param pulumi.Input[str] encryption_settings_version: Describes what type of encryption is used for the disks. Once this field is set, it cannot be overwritten. '1.0' corresponds to Azure Disk Encryption with AAD app.'1.1' corresponds to Azure Disk Encryption.
        """
        pulumi.set(__self__, "enabled", enabled)
        if encryption_settings is not None:
            pulumi.set(__self__, "encryption_settings", encryption_settings)
        if encryption_settings_version is not None:
            pulumi.set(__self__, "encryption_settings_version", encryption_settings_version)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Set this flag to true and provide DiskEncryptionKey and optional KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object, the existing settings remain unchanged.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="encryptionSettings")
    def encryption_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EncryptionSettingsElementArgs']]]]:
        """
        A collection of encryption settings, one for each disk volume.
        """
        return pulumi.get(self, "encryption_settings")

    @encryption_settings.setter
    def encryption_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EncryptionSettingsElementArgs']]]]):
        pulumi.set(self, "encryption_settings", value)

    @property
    @pulumi.getter(name="encryptionSettingsVersion")
    def encryption_settings_version(self) -> Optional[pulumi.Input[str]]:
        """
        Describes what type of encryption is used for the disks. Once this field is set, it cannot be overwritten. '1.0' corresponds to Azure Disk Encryption with AAD app.'1.1' corresponds to Azure Disk Encryption.
        """
        return pulumi.get(self, "encryption_settings_version")

    @encryption_settings_version.setter
    def encryption_settings_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_settings_version", value)


@pulumi.input_type
class EncryptionSettingsElementArgs:
    def __init__(__self__, *,
                 disk_encryption_key: Optional[pulumi.Input['KeyVaultAndSecretReferenceArgs']] = None,
                 key_encryption_key: Optional[pulumi.Input['KeyVaultAndKeyReferenceArgs']] = None):
        """
        Encryption settings for one disk volume.
        :param pulumi.Input['KeyVaultAndSecretReferenceArgs'] disk_encryption_key: Key Vault Secret Url and vault id of the disk encryption key
        :param pulumi.Input['KeyVaultAndKeyReferenceArgs'] key_encryption_key: Key Vault Key Url and vault id of the key encryption key. KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
        """
        if disk_encryption_key is not None:
            pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        if key_encryption_key is not None:
            pulumi.set(__self__, "key_encryption_key", key_encryption_key)

    @property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> Optional[pulumi.Input['KeyVaultAndSecretReferenceArgs']]:
        """
        Key Vault Secret Url and vault id of the disk encryption key
        """
        return pulumi.get(self, "disk_encryption_key")

    @disk_encryption_key.setter
    def disk_encryption_key(self, value: Optional[pulumi.Input['KeyVaultAndSecretReferenceArgs']]):
        pulumi.set(self, "disk_encryption_key", value)

    @property
    @pulumi.getter(name="keyEncryptionKey")
    def key_encryption_key(self) -> Optional[pulumi.Input['KeyVaultAndKeyReferenceArgs']]:
        """
        Key Vault Key Url and vault id of the key encryption key. KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
        """
        return pulumi.get(self, "key_encryption_key")

    @key_encryption_key.setter
    def key_encryption_key(self, value: Optional[pulumi.Input['KeyVaultAndKeyReferenceArgs']]):
        pulumi.set(self, "key_encryption_key", value)


@pulumi.input_type
class EncryptionArgs:
    def __init__(__self__, *,
                 disk_encryption_set_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'EncryptionType']]] = None):
        """
        Encryption at rest settings for disk or snapshot
        :param pulumi.Input[str] disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling encryption at rest.
        :param pulumi.Input[Union[str, 'EncryptionType']] type: The type of key used to encrypt the data of the disk.
        """
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        ResourceId of the disk encryption set to use for enabling encryption at rest.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @disk_encryption_set_id.setter
    def disk_encryption_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_encryption_set_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'EncryptionType']]]:
        """
        The type of key used to encrypt the data of the disk.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'EncryptionType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ExtendedLocationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]] = None):
        """
        The complex type of the extended location.
        :param pulumi.Input[str] name: The name of the extended location.
        :param pulumi.Input[Union[str, 'ExtendedLocationTypes']] type: The type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]]:
        """
        The type of the extended location.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ImageDiskReferenceArgs:
    def __init__(__self__, *,
                 community_gallery_image_id: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 lun: Optional[pulumi.Input[int]] = None,
                 shared_gallery_image_id: Optional[pulumi.Input[str]] = None):
        """
        The source image used for creating the disk.
        :param pulumi.Input[str] community_gallery_image_id: A relative uri containing a community Azure Compute Gallery image reference.
        :param pulumi.Input[str] id: A relative uri containing either a Platform Image Repository, user image, or Azure Compute Gallery image reference.
        :param pulumi.Input[int] lun: If the disk is created from an image's data disk, this is an index that indicates which of the data disks in the image to use. For OS disks, this field is null.
        :param pulumi.Input[str] shared_gallery_image_id: A relative uri containing a direct shared Azure Compute Gallery image reference.
        """
        if community_gallery_image_id is not None:
            pulumi.set(__self__, "community_gallery_image_id", community_gallery_image_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if lun is not None:
            pulumi.set(__self__, "lun", lun)
        if shared_gallery_image_id is not None:
            pulumi.set(__self__, "shared_gallery_image_id", shared_gallery_image_id)

    @property
    @pulumi.getter(name="communityGalleryImageId")
    def community_gallery_image_id(self) -> Optional[pulumi.Input[str]]:
        """
        A relative uri containing a community Azure Compute Gallery image reference.
        """
        return pulumi.get(self, "community_gallery_image_id")

    @community_gallery_image_id.setter
    def community_gallery_image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "community_gallery_image_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        A relative uri containing either a Platform Image Repository, user image, or Azure Compute Gallery image reference.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def lun(self) -> Optional[pulumi.Input[int]]:
        """
        If the disk is created from an image's data disk, this is an index that indicates which of the data disks in the image to use. For OS disks, this field is null.
        """
        return pulumi.get(self, "lun")

    @lun.setter
    def lun(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lun", value)

    @property
    @pulumi.getter(name="sharedGalleryImageId")
    def shared_gallery_image_id(self) -> Optional[pulumi.Input[str]]:
        """
        A relative uri containing a direct shared Azure Compute Gallery image reference.
        """
        return pulumi.get(self, "shared_gallery_image_id")

    @shared_gallery_image_id.setter
    def shared_gallery_image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_gallery_image_id", value)


@pulumi.input_type
class KeyForDiskEncryptionSetArgs:
    def __init__(__self__, *,
                 key_url: pulumi.Input[str],
                 source_vault: Optional[pulumi.Input['SourceVaultArgs']] = None):
        """
        Key Vault Key Url to be used for server side encryption of Managed Disks and Snapshots
        :param pulumi.Input[str] key_url: Fully versioned Key Url pointing to a key in KeyVault. Version segment of the Url is required regardless of rotationToLatestKeyVersionEnabled value.
        :param pulumi.Input['SourceVaultArgs'] source_vault: Resource id of the KeyVault containing the key or secret. This property is optional and cannot be used if the KeyVault subscription is not the same as the Disk Encryption Set subscription.
        """
        pulumi.set(__self__, "key_url", key_url)
        if source_vault is not None:
            pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> pulumi.Input[str]:
        """
        Fully versioned Key Url pointing to a key in KeyVault. Version segment of the Url is required regardless of rotationToLatestKeyVersionEnabled value.
        """
        return pulumi.get(self, "key_url")

    @key_url.setter
    def key_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_url", value)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> Optional[pulumi.Input['SourceVaultArgs']]:
        """
        Resource id of the KeyVault containing the key or secret. This property is optional and cannot be used if the KeyVault subscription is not the same as the Disk Encryption Set subscription.
        """
        return pulumi.get(self, "source_vault")

    @source_vault.setter
    def source_vault(self, value: Optional[pulumi.Input['SourceVaultArgs']]):
        pulumi.set(self, "source_vault", value)


@pulumi.input_type
class KeyVaultAndKeyReferenceArgs:
    def __init__(__self__, *,
                 key_url: pulumi.Input[str],
                 source_vault: pulumi.Input['SourceVaultArgs']):
        """
        Key Vault Key Url and vault id of KeK, KeK is optional and when provided is used to unwrap the encryptionKey
        :param pulumi.Input[str] key_url: Url pointing to a key or secret in KeyVault
        :param pulumi.Input['SourceVaultArgs'] source_vault: Resource id of the KeyVault containing the key or secret
        """
        pulumi.set(__self__, "key_url", key_url)
        pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> pulumi.Input[str]:
        """
        Url pointing to a key or secret in KeyVault
        """
        return pulumi.get(self, "key_url")

    @key_url.setter
    def key_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_url", value)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> pulumi.Input['SourceVaultArgs']:
        """
        Resource id of the KeyVault containing the key or secret
        """
        return pulumi.get(self, "source_vault")

    @source_vault.setter
    def source_vault(self, value: pulumi.Input['SourceVaultArgs']):
        pulumi.set(self, "source_vault", value)


@pulumi.input_type
class KeyVaultAndSecretReferenceArgs:
    def __init__(__self__, *,
                 secret_url: pulumi.Input[str],
                 source_vault: pulumi.Input['SourceVaultArgs']):
        """
        Key Vault Secret Url and vault id of the encryption key 
        :param pulumi.Input[str] secret_url: Url pointing to a key or secret in KeyVault
        :param pulumi.Input['SourceVaultArgs'] source_vault: Resource id of the KeyVault containing the key or secret
        """
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> pulumi.Input[str]:
        """
        Url pointing to a key or secret in KeyVault
        """
        return pulumi.get(self, "secret_url")

    @secret_url.setter
    def secret_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_url", value)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> pulumi.Input['SourceVaultArgs']:
        """
        Resource id of the KeyVault containing the key or secret
        """
        return pulumi.get(self, "source_vault")

    @source_vault.setter
    def source_vault(self, value: pulumi.Input['SourceVaultArgs']):
        pulumi.set(self, "source_vault", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 actions_required: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param pulumi.Input[str] actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param pulumi.Input[str] description: The reason for approval/rejection of the connection.
        :param pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']] status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[pulumi.Input[str]]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @actions_required.setter
    def actions_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "actions_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class PurchasePlanArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 product: pulumi.Input[str],
                 publisher: pulumi.Input[str],
                 promotion_code: Optional[pulumi.Input[str]] = None):
        """
        Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.
        :param pulumi.Input[str] name: The plan ID.
        :param pulumi.Input[str] product: Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
        :param pulumi.Input[str] publisher: The publisher ID.
        :param pulumi.Input[str] promotion_code: The Offer Promotion Code.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "publisher", publisher)
        if promotion_code is not None:
            pulumi.set(__self__, "promotion_code", promotion_code)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The plan ID.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def product(self) -> pulumi.Input[str]:
        """
        Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: pulumi.Input[str]):
        pulumi.set(self, "product", value)

    @property
    @pulumi.getter
    def publisher(self) -> pulumi.Input[str]:
        """
        The publisher ID.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: pulumi.Input[str]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter(name="promotionCode")
    def promotion_code(self) -> Optional[pulumi.Input[str]]:
        """
        The Offer Promotion Code.
        """
        return pulumi.get(self, "promotion_code")

    @promotion_code.setter
    def promotion_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "promotion_code", value)


@pulumi.input_type
class SnapshotSkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[Union[str, 'SnapshotStorageAccountTypes']]] = None):
        """
        The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is an optional parameter for incremental snapshot and the default behavior is the SKU will be set to the same sku as the previous snapshot
        :param pulumi.Input[Union[str, 'SnapshotStorageAccountTypes']] name: The sku name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'SnapshotStorageAccountTypes']]]:
        """
        The sku name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'SnapshotStorageAccountTypes']]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class SourceVaultArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        The vault id is an Azure Resource Manager Resource id in the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}
        :param pulumi.Input[str] id: Resource Id
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class SupportedCapabilitiesArgs:
    def __init__(__self__, *,
                 accelerated_network: Optional[pulumi.Input[bool]] = None,
                 architecture: Optional[pulumi.Input[Union[str, 'Architecture']]] = None):
        """
        List of supported capabilities persisted on the disk resource for VM use.
        :param pulumi.Input[bool] accelerated_network: True if the image from which the OS disk is created supports accelerated networking.
        :param pulumi.Input[Union[str, 'Architecture']] architecture: CPU architecture supported by an OS disk.
        """
        if accelerated_network is not None:
            pulumi.set(__self__, "accelerated_network", accelerated_network)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)

    @property
    @pulumi.getter(name="acceleratedNetwork")
    def accelerated_network(self) -> Optional[pulumi.Input[bool]]:
        """
        True if the image from which the OS disk is created supports accelerated networking.
        """
        return pulumi.get(self, "accelerated_network")

    @accelerated_network.setter
    def accelerated_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "accelerated_network", value)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[Union[str, 'Architecture']]]:
        """
        CPU architecture supported by an OS disk.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[Union[str, 'Architecture']]]):
        pulumi.set(self, "architecture", value)


