# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApplicationServerConfigurationResponse',
    'BackupProfileResponse',
    'CacheProfileResponse',
    'CentralServerConfigurationResponse',
    'CentralServerVmDetailsResponse',
    'DB2ProviderInstancePropertiesResponse',
    'DatabaseConfigurationResponse',
    'DatabaseProfileResponse',
    'DatabaseVmDetailsResponse',
    'DeployerVmPackagesResponse',
    'DeploymentConfigurationResponse',
    'DeploymentWithOSConfigurationResponse',
    'DiscoveryConfigurationResponse',
    'DiskInfoResponse',
    'EnqueueReplicationServerPropertiesResponse',
    'EnqueueServerPropertiesResponse',
    'ErrorDefinitionResponse',
    'ErrorResponse',
    'ErrorResponseInnerError',
    'FileshareProfileResponse',
    'GatewayServerPropertiesResponse',
    'HanaDbProviderInstancePropertiesResponse',
    'HighAvailabilityConfigurationResponse',
    'HighAvailabilitySoftwareConfigurationResponse',
    'ImageReferenceResponse',
    'LinuxConfigurationResponse',
    'ManagedRGConfigurationResponse',
    'MessageServerPropertiesResponse',
    'MonitorPropertiesResponseErrors',
    'MsSqlServerProviderInstancePropertiesResponse',
    'NetworkConfigurationResponse',
    'NetworkProfileResponse',
    'NodeProfileResponse',
    'OSProfileResponse',
    'OsImageProfileResponse',
    'OsSapConfigurationResponse',
    'PhpProfileResponse',
    'PhpWorkloadResourceResponseIdentity',
    'PrometheusHaClusterProviderInstancePropertiesResponse',
    'PrometheusOSProviderInstancePropertiesResponse',
    'ProviderInstancePropertiesResponseErrors',
    'SAPAvailabilityZonePairResponse',
    'SAPDiskConfigurationResponse',
    'SAPInstallWithoutOSConfigSoftwareConfigurationResponse',
    'SAPSupportedSkuResponse',
    'SAPVirtualInstanceErrorResponse',
    'SapNetWeaverProviderInstancePropertiesResponse',
    'SearchProfileResponse',
    'ServiceInitiatedSoftwareConfigurationResponse',
    'SingleServerConfigurationResponse',
    'SiteProfileResponse',
    'SkuResponse',
    'SshConfigurationResponse',
    'SshKeyPairResponse',
    'SshPublicKeyResponse',
    'SystemDataResponse',
    'ThreeTierConfigurationResponse',
    'UserAssignedIdentityResponse',
    'UserAssignedServiceIdentityResponse',
    'UserProfileResponse',
    'VirtualMachineConfigurationResponse',
    'VmssNodesProfileResponse',
    'WindowsConfigurationResponse',
]

@pulumi.output_type
class ApplicationServerConfigurationResponse(dict):
    """
    Gets or sets the application server configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "virtualMachineConfiguration":
            suggest = "virtual_machine_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationServerConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationServerConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationServerConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: float,
                 subnet_id: str,
                 virtual_machine_configuration: 'outputs.VirtualMachineConfigurationResponse'):
        """
        Gets or sets the application server configuration.
        :param float instance_count: The number of app server instances.
        :param str subnet_id: The subnet id.
        :param 'VirtualMachineConfigurationResponse' virtual_machine_configuration: Gets or sets the virtual machine configuration.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> float:
        """
        The number of app server instances.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> 'outputs.VirtualMachineConfigurationResponse':
        """
        Gets or sets the virtual machine configuration.
        """
        return pulumi.get(self, "virtual_machine_configuration")


@pulumi.output_type
class BackupProfileResponse(dict):
    """
    Backup profile
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupEnabled":
            suggest = "backup_enabled"
        elif key == "vaultResourceId":
            suggest = "vault_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_enabled: str,
                 vault_resource_id: str):
        """
        Backup profile
        :param str backup_enabled: Whether to enable Azure backup for the workload
        :param str vault_resource_id: Backup vault resource Id
        """
        pulumi.set(__self__, "backup_enabled", backup_enabled)
        pulumi.set(__self__, "vault_resource_id", vault_resource_id)

    @property
    @pulumi.getter(name="backupEnabled")
    def backup_enabled(self) -> str:
        """
        Whether to enable Azure backup for the workload
        """
        return pulumi.get(self, "backup_enabled")

    @property
    @pulumi.getter(name="vaultResourceId")
    def vault_resource_id(self) -> str:
        """
        Backup vault resource Id
        """
        return pulumi.get(self, "vault_resource_id")


@pulumi.output_type
class CacheProfileResponse(dict):
    """
    Cache profile
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheResourceId":
            suggest = "cache_resource_id"
        elif key == "skuName":
            suggest = "sku_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cache_resource_id: str,
                 capacity: float,
                 family: str,
                 sku_name: str,
                 name: Optional[str] = None):
        """
        Cache profile
        :param str cache_resource_id: Cache resource Id
        :param float capacity: Cache capacity
        :param str family: Cache family
        :param str sku_name: Cache SKU name
        :param str name: Cache name
        """
        pulumi.set(__self__, "cache_resource_id", cache_resource_id)
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "sku_name", sku_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="cacheResourceId")
    def cache_resource_id(self) -> str:
        """
        Cache resource Id
        """
        return pulumi.get(self, "cache_resource_id")

    @property
    @pulumi.getter
    def capacity(self) -> float:
        """
        Cache capacity
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> str:
        """
        Cache family
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> str:
        """
        Cache SKU name
        """
        return pulumi.get(self, "sku_name")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Cache name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CentralServerConfigurationResponse(dict):
    """
    Gets or sets the central server configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "virtualMachineConfiguration":
            suggest = "virtual_machine_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CentralServerConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CentralServerConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CentralServerConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: float,
                 subnet_id: str,
                 virtual_machine_configuration: 'outputs.VirtualMachineConfigurationResponse'):
        """
        Gets or sets the central server configuration.
        :param float instance_count: The number of central server VMs.
        :param str subnet_id: The subnet id.
        :param 'VirtualMachineConfigurationResponse' virtual_machine_configuration: Gets or sets the virtual machine configuration.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> float:
        """
        The number of central server VMs.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> 'outputs.VirtualMachineConfigurationResponse':
        """
        Gets or sets the virtual machine configuration.
        """
        return pulumi.get(self, "virtual_machine_configuration")


@pulumi.output_type
class CentralServerVmDetailsResponse(dict):
    """
    The SAP Central Services Instance VM details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "virtualMachineId":
            suggest = "virtual_machine_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CentralServerVmDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CentralServerVmDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CentralServerVmDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 virtual_machine_id: str):
        """
        The SAP Central Services Instance VM details.
        :param str type: Defines the type of central server VM.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Defines the type of central server VM.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> str:
        return pulumi.get(self, "virtual_machine_id")


@pulumi.output_type
class DB2ProviderInstancePropertiesResponse(dict):
    """
    Gets or sets the DB2 provider properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerType":
            suggest = "provider_type"
        elif key == "dbName":
            suggest = "db_name"
        elif key == "dbPassword":
            suggest = "db_password"
        elif key == "dbPasswordUri":
            suggest = "db_password_uri"
        elif key == "dbPort":
            suggest = "db_port"
        elif key == "dbUsername":
            suggest = "db_username"
        elif key == "sapSid":
            suggest = "sap_sid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DB2ProviderInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DB2ProviderInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DB2ProviderInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provider_type: str,
                 db_name: Optional[str] = None,
                 db_password: Optional[str] = None,
                 db_password_uri: Optional[str] = None,
                 db_port: Optional[str] = None,
                 db_username: Optional[str] = None,
                 hostname: Optional[str] = None,
                 sap_sid: Optional[str] = None):
        """
        Gets or sets the DB2 provider properties.
        :param str provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'Db2'.
        :param str db_name: Gets or sets the db2 database name.
        :param str db_password: Gets or sets the db2 database password.
        :param str db_password_uri: Gets or sets the key vault URI to secret with the database password.
        :param str db_port: Gets or sets the db2 database sql port.
        :param str db_username: Gets or sets the db2 database user name.
        :param str hostname: Gets or sets the target virtual machine name.
        :param str sap_sid: Gets or sets the SAP System Identifier
        """
        pulumi.set(__self__, "provider_type", 'Db2')
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_password is not None:
            pulumi.set(__self__, "db_password", db_password)
        if db_password_uri is not None:
            pulumi.set(__self__, "db_password_uri", db_password_uri)
        if db_port is not None:
            pulumi.set(__self__, "db_port", db_port)
        if db_username is not None:
            pulumi.set(__self__, "db_username", db_username)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if sap_sid is not None:
            pulumi.set(__self__, "sap_sid", sap_sid)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> str:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'Db2'.
        """
        return pulumi.get(self, "provider_type")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[str]:
        """
        Gets or sets the db2 database name.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="dbPassword")
    def db_password(self) -> Optional[str]:
        """
        Gets or sets the db2 database password.
        """
        return pulumi.get(self, "db_password")

    @property
    @pulumi.getter(name="dbPasswordUri")
    def db_password_uri(self) -> Optional[str]:
        """
        Gets or sets the key vault URI to secret with the database password.
        """
        return pulumi.get(self, "db_password_uri")

    @property
    @pulumi.getter(name="dbPort")
    def db_port(self) -> Optional[str]:
        """
        Gets or sets the db2 database sql port.
        """
        return pulumi.get(self, "db_port")

    @property
    @pulumi.getter(name="dbUsername")
    def db_username(self) -> Optional[str]:
        """
        Gets or sets the db2 database user name.
        """
        return pulumi.get(self, "db_username")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        Gets or sets the target virtual machine name.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="sapSid")
    def sap_sid(self) -> Optional[str]:
        """
        Gets or sets the SAP System Identifier
        """
        return pulumi.get(self, "sap_sid")


@pulumi.output_type
class DatabaseConfigurationResponse(dict):
    """
    Gets or sets the database configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "virtualMachineConfiguration":
            suggest = "virtual_machine_configuration"
        elif key == "databaseType":
            suggest = "database_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: float,
                 subnet_id: str,
                 virtual_machine_configuration: 'outputs.VirtualMachineConfigurationResponse',
                 database_type: Optional[str] = None):
        """
        Gets or sets the database configuration.
        :param float instance_count: The number of database VMs.
        :param str subnet_id: The subnet id.
        :param 'VirtualMachineConfigurationResponse' virtual_machine_configuration: Gets or sets the virtual machine configuration.
        :param str database_type: The database type.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> float:
        """
        The number of database VMs.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> 'outputs.VirtualMachineConfigurationResponse':
        """
        Gets or sets the virtual machine configuration.
        """
        return pulumi.get(self, "virtual_machine_configuration")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[str]:
        """
        The database type.
        """
        return pulumi.get(self, "database_type")


@pulumi.output_type
class DatabaseProfileResponse(dict):
    """
    Workload database profile
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverResourceId":
            suggest = "server_resource_id"
        elif key == "backupRetentionDays":
            suggest = "backup_retention_days"
        elif key == "haEnabled":
            suggest = "ha_enabled"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "sslEnforcementEnabled":
            suggest = "ssl_enforcement_enabled"
        elif key == "storageInGB":
            suggest = "storage_in_gb"
        elif key == "storageIops":
            suggest = "storage_iops"
        elif key == "storageSku":
            suggest = "storage_sku"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_resource_id: str,
                 sku: str,
                 tier: str,
                 type: str,
                 backup_retention_days: Optional[int] = None,
                 ha_enabled: Optional[str] = None,
                 server_name: Optional[str] = None,
                 ssl_enforcement_enabled: Optional[str] = None,
                 storage_in_gb: Optional[float] = None,
                 storage_iops: Optional[float] = None,
                 storage_sku: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Workload database profile
        :param str server_resource_id: Azure Database Server resource Id
        :param str sku: The name of the server SKU, e.g. Standard_D32s_v4
        :param str tier: Tier of the server SKU
        :param str type: Database type
        :param int backup_retention_days: Backup retention days for the server
        :param str ha_enabled: Whether to enable HA for the server
        :param str server_name: Database server name
        :param str ssl_enforcement_enabled: Whether to enable SSL enforcement on the database
        :param float storage_in_gb: Database storage size in GB
        :param float storage_iops: Storage IOPS for the server
        :param str storage_sku: SKU name for database storage
        :param str version: Database version
        """
        pulumi.set(__self__, "server_resource_id", server_resource_id)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "tier", tier)
        pulumi.set(__self__, "type", type)
        if backup_retention_days is not None:
            pulumi.set(__self__, "backup_retention_days", backup_retention_days)
        if ha_enabled is not None:
            pulumi.set(__self__, "ha_enabled", ha_enabled)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if ssl_enforcement_enabled is not None:
            pulumi.set(__self__, "ssl_enforcement_enabled", ssl_enforcement_enabled)
        if storage_in_gb is not None:
            pulumi.set(__self__, "storage_in_gb", storage_in_gb)
        if storage_iops is not None:
            pulumi.set(__self__, "storage_iops", storage_iops)
        if storage_sku is not None:
            pulumi.set(__self__, "storage_sku", storage_sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="serverResourceId")
    def server_resource_id(self) -> str:
        """
        Azure Database Server resource Id
        """
        return pulumi.get(self, "server_resource_id")

    @property
    @pulumi.getter
    def sku(self) -> str:
        """
        The name of the server SKU, e.g. Standard_D32s_v4
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        Tier of the server SKU
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Database type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="backupRetentionDays")
    def backup_retention_days(self) -> Optional[int]:
        """
        Backup retention days for the server
        """
        return pulumi.get(self, "backup_retention_days")

    @property
    @pulumi.getter(name="haEnabled")
    def ha_enabled(self) -> Optional[str]:
        """
        Whether to enable HA for the server
        """
        return pulumi.get(self, "ha_enabled")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[str]:
        """
        Database server name
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="sslEnforcementEnabled")
    def ssl_enforcement_enabled(self) -> Optional[str]:
        """
        Whether to enable SSL enforcement on the database
        """
        return pulumi.get(self, "ssl_enforcement_enabled")

    @property
    @pulumi.getter(name="storageInGB")
    def storage_in_gb(self) -> Optional[float]:
        """
        Database storage size in GB
        """
        return pulumi.get(self, "storage_in_gb")

    @property
    @pulumi.getter(name="storageIops")
    def storage_iops(self) -> Optional[float]:
        """
        Storage IOPS for the server
        """
        return pulumi.get(self, "storage_iops")

    @property
    @pulumi.getter(name="storageSku")
    def storage_sku(self) -> Optional[str]:
        """
        SKU name for database storage
        """
        return pulumi.get(self, "storage_sku")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Database version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class DatabaseVmDetailsResponse(dict):
    """
    Database VM details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "virtualMachineId":
            suggest = "virtual_machine_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseVmDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseVmDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseVmDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: str,
                 virtual_machine_id: str):
        """
        Database VM details.
        :param str status: Defines the SAP Instance status.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Defines the SAP Instance status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> str:
        return pulumi.get(self, "virtual_machine_id")


@pulumi.output_type
class DeployerVmPackagesResponse(dict):
    """
    Defines the url and storage account ID where deployer VM packages are uploaded
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountId":
            suggest = "storage_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeployerVmPackagesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeployerVmPackagesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeployerVmPackagesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_account_id: Optional[str] = None,
                 url: Optional[str] = None):
        """
        Defines the url and storage account ID where deployer VM packages are uploaded
        :param str storage_account_id: The deployer VM packages storage account id
        :param str url: The URL to the deployer VM packages file.
        """
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[str]:
        """
        The deployer VM packages storage account id
        """
        return pulumi.get(self, "storage_account_id")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The URL to the deployer VM packages file.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class DeploymentConfigurationResponse(dict):
    """
    Deployment Configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationType":
            suggest = "configuration_type"
        elif key == "appLocation":
            suggest = "app_location"
        elif key == "infrastructureConfiguration":
            suggest = "infrastructure_configuration"
        elif key == "softwareConfiguration":
            suggest = "software_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_type: str,
                 app_location: Optional[str] = None,
                 infrastructure_configuration: Optional[Any] = None,
                 software_configuration: Optional[Any] = None):
        """
        Deployment Configuration.
        :param str configuration_type: The configuration Type.
               Expected value is 'Deployment'.
        :param str app_location: The geo-location where the SAP system is to be created.
        :param Union['SingleServerConfigurationResponse', 'ThreeTierConfigurationResponse'] infrastructure_configuration: The infrastructure configuration.
        :param Union['SAPInstallWithoutOSConfigSoftwareConfigurationResponse', 'ServiceInitiatedSoftwareConfigurationResponse'] software_configuration: The software configuration.
        """
        pulumi.set(__self__, "configuration_type", 'Deployment')
        if app_location is not None:
            pulumi.set(__self__, "app_location", app_location)
        if infrastructure_configuration is not None:
            pulumi.set(__self__, "infrastructure_configuration", infrastructure_configuration)
        if software_configuration is not None:
            pulumi.set(__self__, "software_configuration", software_configuration)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> str:
        """
        The configuration Type.
        Expected value is 'Deployment'.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter(name="appLocation")
    def app_location(self) -> Optional[str]:
        """
        The geo-location where the SAP system is to be created.
        """
        return pulumi.get(self, "app_location")

    @property
    @pulumi.getter(name="infrastructureConfiguration")
    def infrastructure_configuration(self) -> Optional[Any]:
        """
        The infrastructure configuration.
        """
        return pulumi.get(self, "infrastructure_configuration")

    @property
    @pulumi.getter(name="softwareConfiguration")
    def software_configuration(self) -> Optional[Any]:
        """
        The software configuration.
        """
        return pulumi.get(self, "software_configuration")


@pulumi.output_type
class DeploymentWithOSConfigurationResponse(dict):
    """
    Deployment along with OS Configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationType":
            suggest = "configuration_type"
        elif key == "appLocation":
            suggest = "app_location"
        elif key == "infrastructureConfiguration":
            suggest = "infrastructure_configuration"
        elif key == "osSapConfiguration":
            suggest = "os_sap_configuration"
        elif key == "softwareConfiguration":
            suggest = "software_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentWithOSConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentWithOSConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentWithOSConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_type: str,
                 app_location: Optional[str] = None,
                 infrastructure_configuration: Optional[Any] = None,
                 os_sap_configuration: Optional['outputs.OsSapConfigurationResponse'] = None,
                 software_configuration: Optional[Any] = None):
        """
        Deployment along with OS Configuration.
        :param str configuration_type: The configuration Type.
               Expected value is 'DeploymentWithOSConfig'.
        :param str app_location: The geo-location where the SAP system is to be created.
        :param Union['SingleServerConfigurationResponse', 'ThreeTierConfigurationResponse'] infrastructure_configuration: The infrastructure configuration.
        :param 'OsSapConfigurationResponse' os_sap_configuration: The OS and SAP configuration.
        :param Union['SAPInstallWithoutOSConfigSoftwareConfigurationResponse', 'ServiceInitiatedSoftwareConfigurationResponse'] software_configuration: The software configuration.
        """
        pulumi.set(__self__, "configuration_type", 'DeploymentWithOSConfig')
        if app_location is not None:
            pulumi.set(__self__, "app_location", app_location)
        if infrastructure_configuration is not None:
            pulumi.set(__self__, "infrastructure_configuration", infrastructure_configuration)
        if os_sap_configuration is not None:
            pulumi.set(__self__, "os_sap_configuration", os_sap_configuration)
        if software_configuration is not None:
            pulumi.set(__self__, "software_configuration", software_configuration)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> str:
        """
        The configuration Type.
        Expected value is 'DeploymentWithOSConfig'.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter(name="appLocation")
    def app_location(self) -> Optional[str]:
        """
        The geo-location where the SAP system is to be created.
        """
        return pulumi.get(self, "app_location")

    @property
    @pulumi.getter(name="infrastructureConfiguration")
    def infrastructure_configuration(self) -> Optional[Any]:
        """
        The infrastructure configuration.
        """
        return pulumi.get(self, "infrastructure_configuration")

    @property
    @pulumi.getter(name="osSapConfiguration")
    def os_sap_configuration(self) -> Optional['outputs.OsSapConfigurationResponse']:
        """
        The OS and SAP configuration.
        """
        return pulumi.get(self, "os_sap_configuration")

    @property
    @pulumi.getter(name="softwareConfiguration")
    def software_configuration(self) -> Optional[Any]:
        """
        The software configuration.
        """
        return pulumi.get(self, "software_configuration")


@pulumi.output_type
class DiscoveryConfigurationResponse(dict):
    """
    Discovery Details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appLocation":
            suggest = "app_location"
        elif key == "configurationType":
            suggest = "configuration_type"
        elif key == "centralServerVmId":
            suggest = "central_server_vm_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_location: str,
                 configuration_type: str,
                 central_server_vm_id: Optional[str] = None):
        """
        Discovery Details.
        :param str app_location: The geo-location where the SAP system exists.
        :param str configuration_type: The configuration Type.
               Expected value is 'Discovery'.
        :param str central_server_vm_id: The virtual machine ID of the Central Server.
        """
        pulumi.set(__self__, "app_location", app_location)
        pulumi.set(__self__, "configuration_type", 'Discovery')
        if central_server_vm_id is not None:
            pulumi.set(__self__, "central_server_vm_id", central_server_vm_id)

    @property
    @pulumi.getter(name="appLocation")
    def app_location(self) -> str:
        """
        The geo-location where the SAP system exists.
        """
        return pulumi.get(self, "app_location")

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> str:
        """
        The configuration Type.
        Expected value is 'Discovery'.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter(name="centralServerVmId")
    def central_server_vm_id(self) -> Optional[str]:
        """
        The virtual machine ID of the Central Server.
        """
        return pulumi.get(self, "central_server_vm_id")


@pulumi.output_type
class DiskInfoResponse(dict):
    """
    Disk resource creation details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageType":
            suggest = "storage_type"
        elif key == "sizeInGB":
            suggest = "size_in_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_type: str,
                 size_in_gb: Optional[float] = None):
        """
        Disk resource creation details
        :param str storage_type: Storage type
        :param float size_in_gb: Disk size in GB
        """
        pulumi.set(__self__, "storage_type", storage_type)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        """
        Storage type
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="sizeInGB")
    def size_in_gb(self) -> Optional[float]:
        """
        Disk size in GB
        """
        return pulumi.get(self, "size_in_gb")


@pulumi.output_type
class EnqueueReplicationServerPropertiesResponse(dict):
    """
    Defines the SAP Enqueue Replication Server (ERS) properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ersVersion":
            suggest = "ers_version"
        elif key == "instanceNo":
            suggest = "instance_no"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "kernelPatch":
            suggest = "kernel_patch"
        elif key == "kernelVersion":
            suggest = "kernel_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnqueueReplicationServerPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnqueueReplicationServerPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnqueueReplicationServerPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ers_version: str,
                 health: str,
                 hostname: str,
                 instance_no: str,
                 ip_address: str,
                 kernel_patch: str,
                 kernel_version: str):
        """
        Defines the SAP Enqueue Replication Server (ERS) properties.
        :param str ers_version: Defines the type of Enqueue Replication Server.
        :param str health: Defines the health of SAP Instances.
        :param str hostname: ERS SAP Hostname.
        :param str instance_no: ERS Instance Number.
        :param str ip_address: ERS SAP IP Address.
        :param str kernel_patch: ERS SAP Kernel Patch level.
        :param str kernel_version: ERS SAP Kernel Version.
        """
        pulumi.set(__self__, "ers_version", ers_version)
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "instance_no", instance_no)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "kernel_patch", kernel_patch)
        pulumi.set(__self__, "kernel_version", kernel_version)

    @property
    @pulumi.getter(name="ersVersion")
    def ers_version(self) -> str:
        """
        Defines the type of Enqueue Replication Server.
        """
        return pulumi.get(self, "ers_version")

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        Defines the health of SAP Instances.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        ERS SAP Hostname.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="instanceNo")
    def instance_no(self) -> str:
        """
        ERS Instance Number.
        """
        return pulumi.get(self, "instance_no")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        ERS SAP IP Address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="kernelPatch")
    def kernel_patch(self) -> str:
        """
        ERS SAP Kernel Patch level.
        """
        return pulumi.get(self, "kernel_patch")

    @property
    @pulumi.getter(name="kernelVersion")
    def kernel_version(self) -> str:
        """
        ERS SAP Kernel Version.
        """
        return pulumi.get(self, "kernel_version")


@pulumi.output_type
class EnqueueServerPropertiesResponse(dict):
    """
    Defines the SAP Enqueue Server properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnqueueServerPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnqueueServerPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnqueueServerPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health: str,
                 hostname: str,
                 ip_address: str,
                 port: float):
        """
        Defines the SAP Enqueue Server properties.
        :param str health: Defines the health of SAP Instances.
        :param str hostname: Enqueue Server SAP Hostname.
        :param str ip_address: Enqueue Server SAP IP Address.
        :param float port: Enqueue Server Port.
        """
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        Defines the health of SAP Instances.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Enqueue Server SAP Hostname.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        Enqueue Server SAP IP Address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        Enqueue Server Port.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ErrorDefinitionResponse(dict):
    """
    Error definition.
    """
    def __init__(__self__, *,
                 code: str,
                 details: Sequence['outputs.ErrorDefinitionResponse'],
                 message: str):
        """
        Error definition.
        :param str code: Service specific error code which serves as the substatus for the HTTP error code.
        :param Sequence['ErrorDefinitionResponse'] details: Internal error details.
        :param str message: Description of the error.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Service specific error code which serves as the substatus for the HTTP error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.ErrorDefinitionResponse']:
        """
        Internal error details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Description of the error.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ErrorResponse(dict):
    """
    Standard error object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "innerError":
            suggest = "inner_error"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: str,
                 details: Sequence['outputs.ErrorResponse'],
                 inner_error: 'outputs.ErrorResponseInnerError',
                 message: str,
                 target: str):
        """
        Standard error object.
        :param str code: Server-defined set of error codes.
        :param Sequence['ErrorResponse'] details: Array of details about specific errors that led to this reported error.
        :param 'ErrorResponseInnerError' inner_error: Object containing more specific information than  the current object about the error.
        :param str message: Human-readable representation of the error.
        :param str target: Target of the error.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "inner_error", inner_error)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Server-defined set of error codes.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.ErrorResponse']:
        """
        Array of details about specific errors that led to this reported error.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="innerError")
    def inner_error(self) -> 'outputs.ErrorResponseInnerError':
        """
        Object containing more specific information than  the current object about the error.
        """
        return pulumi.get(self, "inner_error")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Human-readable representation of the error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Target of the error.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ErrorResponseInnerError(dict):
    """
    Object containing more specific information than  the current object about the error.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "innerError":
            suggest = "inner_error"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ErrorResponseInnerError. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ErrorResponseInnerError.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ErrorResponseInnerError.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inner_error: Optional['outputs.ErrorResponse'] = None):
        """
        Object containing more specific information than  the current object about the error.
        :param 'ErrorResponse' inner_error: Standard error object.
        """
        if inner_error is not None:
            pulumi.set(__self__, "inner_error", inner_error)

    @property
    @pulumi.getter(name="innerError")
    def inner_error(self) -> Optional['outputs.ErrorResponse']:
        """
        Standard error object.
        """
        return pulumi.get(self, "inner_error")


@pulumi.output_type
class FileshareProfileResponse(dict):
    """
    File share profile
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shareName":
            suggest = "share_name"
        elif key == "shareType":
            suggest = "share_type"
        elif key == "storageResourceId":
            suggest = "storage_resource_id"
        elif key == "storageType":
            suggest = "storage_type"
        elif key == "shareSizeInGB":
            suggest = "share_size_in_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileshareProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileshareProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileshareProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 share_name: str,
                 share_type: str,
                 storage_resource_id: str,
                 storage_type: str,
                 share_size_in_gb: Optional[float] = None):
        """
        File share profile
        :param str share_name: File share name
        :param str share_type: Share type
        :param str storage_resource_id: File share storage resource id
        :param str storage_type: File share backing storage type
        :param float share_size_in_gb: File share size in GB
        """
        pulumi.set(__self__, "share_name", share_name)
        pulumi.set(__self__, "share_type", share_type)
        pulumi.set(__self__, "storage_resource_id", storage_resource_id)
        pulumi.set(__self__, "storage_type", storage_type)
        if share_size_in_gb is not None:
            pulumi.set(__self__, "share_size_in_gb", share_size_in_gb)

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> str:
        """
        File share name
        """
        return pulumi.get(self, "share_name")

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> str:
        """
        Share type
        """
        return pulumi.get(self, "share_type")

    @property
    @pulumi.getter(name="storageResourceId")
    def storage_resource_id(self) -> str:
        """
        File share storage resource id
        """
        return pulumi.get(self, "storage_resource_id")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        """
        File share backing storage type
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="shareSizeInGB")
    def share_size_in_gb(self) -> Optional[float]:
        """
        File share size in GB
        """
        return pulumi.get(self, "share_size_in_gb")


@pulumi.output_type
class GatewayServerPropertiesResponse(dict):
    """
    Defines the SAP Gateway Server properties.
    """
    def __init__(__self__, *,
                 health: str,
                 port: float):
        """
        Defines the SAP Gateway Server properties.
        :param str health: Defines the health of SAP Instances.
        :param float port: Gateway Port.
        """
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        Defines the health of SAP Instances.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        Gateway Port.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class HanaDbProviderInstancePropertiesResponse(dict):
    """
    Gets or sets the provider properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerType":
            suggest = "provider_type"
        elif key == "dbName":
            suggest = "db_name"
        elif key == "dbPassword":
            suggest = "db_password"
        elif key == "dbPasswordUri":
            suggest = "db_password_uri"
        elif key == "dbSslCertificateUri":
            suggest = "db_ssl_certificate_uri"
        elif key == "dbUsername":
            suggest = "db_username"
        elif key == "instanceNumber":
            suggest = "instance_number"
        elif key == "sqlPort":
            suggest = "sql_port"
        elif key == "sslHostNameInCertificate":
            suggest = "ssl_host_name_in_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HanaDbProviderInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HanaDbProviderInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HanaDbProviderInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provider_type: str,
                 db_name: Optional[str] = None,
                 db_password: Optional[str] = None,
                 db_password_uri: Optional[str] = None,
                 db_ssl_certificate_uri: Optional[str] = None,
                 db_username: Optional[str] = None,
                 hostname: Optional[str] = None,
                 instance_number: Optional[str] = None,
                 sql_port: Optional[str] = None,
                 ssl_host_name_in_certificate: Optional[str] = None):
        """
        Gets or sets the provider properties.
        :param str provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'SapHana'.
        :param str db_name: Gets or sets the hana database name.
        :param str db_password: Gets or sets the database password.
        :param str db_password_uri: Gets or sets the key vault URI to secret with the database password.
        :param str db_ssl_certificate_uri: Gets or sets the blob URI to SSL certificate for the DB.
        :param str db_username: Gets or sets the database user name.
        :param str hostname: Gets or sets the target virtual machine size.
        :param str instance_number: Gets or sets the database instance number.
        :param str sql_port: Gets or sets the database sql port.
        :param str ssl_host_name_in_certificate: Gets or sets the hostname(s) in the SSL certificate.
        """
        pulumi.set(__self__, "provider_type", 'SapHana')
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_password is not None:
            pulumi.set(__self__, "db_password", db_password)
        if db_password_uri is not None:
            pulumi.set(__self__, "db_password_uri", db_password_uri)
        if db_ssl_certificate_uri is not None:
            pulumi.set(__self__, "db_ssl_certificate_uri", db_ssl_certificate_uri)
        if db_username is not None:
            pulumi.set(__self__, "db_username", db_username)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if instance_number is not None:
            pulumi.set(__self__, "instance_number", instance_number)
        if sql_port is not None:
            pulumi.set(__self__, "sql_port", sql_port)
        if ssl_host_name_in_certificate is not None:
            pulumi.set(__self__, "ssl_host_name_in_certificate", ssl_host_name_in_certificate)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> str:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'SapHana'.
        """
        return pulumi.get(self, "provider_type")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[str]:
        """
        Gets or sets the hana database name.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="dbPassword")
    def db_password(self) -> Optional[str]:
        """
        Gets or sets the database password.
        """
        return pulumi.get(self, "db_password")

    @property
    @pulumi.getter(name="dbPasswordUri")
    def db_password_uri(self) -> Optional[str]:
        """
        Gets or sets the key vault URI to secret with the database password.
        """
        return pulumi.get(self, "db_password_uri")

    @property
    @pulumi.getter(name="dbSslCertificateUri")
    def db_ssl_certificate_uri(self) -> Optional[str]:
        """
        Gets or sets the blob URI to SSL certificate for the DB.
        """
        return pulumi.get(self, "db_ssl_certificate_uri")

    @property
    @pulumi.getter(name="dbUsername")
    def db_username(self) -> Optional[str]:
        """
        Gets or sets the database user name.
        """
        return pulumi.get(self, "db_username")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        Gets or sets the target virtual machine size.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="instanceNumber")
    def instance_number(self) -> Optional[str]:
        """
        Gets or sets the database instance number.
        """
        return pulumi.get(self, "instance_number")

    @property
    @pulumi.getter(name="sqlPort")
    def sql_port(self) -> Optional[str]:
        """
        Gets or sets the database sql port.
        """
        return pulumi.get(self, "sql_port")

    @property
    @pulumi.getter(name="sslHostNameInCertificate")
    def ssl_host_name_in_certificate(self) -> Optional[str]:
        """
        Gets or sets the hostname(s) in the SSL certificate.
        """
        return pulumi.get(self, "ssl_host_name_in_certificate")


@pulumi.output_type
class HighAvailabilityConfigurationResponse(dict):
    """
    Gets or sets the high availability configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "highAvailabilityType":
            suggest = "high_availability_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HighAvailabilityConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HighAvailabilityConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HighAvailabilityConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 high_availability_type: str):
        """
        Gets or sets the high availability configuration.
        :param str high_availability_type: The high availability type.
        """
        pulumi.set(__self__, "high_availability_type", high_availability_type)

    @property
    @pulumi.getter(name="highAvailabilityType")
    def high_availability_type(self) -> str:
        """
        The high availability type.
        """
        return pulumi.get(self, "high_availability_type")


@pulumi.output_type
class HighAvailabilitySoftwareConfigurationResponse(dict):
    """
    Gets or sets the HA software configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fencingClientId":
            suggest = "fencing_client_id"
        elif key == "fencingClientPassword":
            suggest = "fencing_client_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HighAvailabilitySoftwareConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HighAvailabilitySoftwareConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HighAvailabilitySoftwareConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fencing_client_id: str,
                 fencing_client_password: str):
        """
        Gets or sets the HA software configuration.
        :param str fencing_client_id: The fencing client id.
        :param str fencing_client_password: The fencing client id secret/password. The secret should never expire. This will be used pacemaker to start/stop the cluster VMs.
        """
        pulumi.set(__self__, "fencing_client_id", fencing_client_id)
        pulumi.set(__self__, "fencing_client_password", fencing_client_password)

    @property
    @pulumi.getter(name="fencingClientId")
    def fencing_client_id(self) -> str:
        """
        The fencing client id.
        """
        return pulumi.get(self, "fencing_client_id")

    @property
    @pulumi.getter(name="fencingClientPassword")
    def fencing_client_password(self) -> str:
        """
        The fencing client id secret/password. The secret should never expire. This will be used pacemaker to start/stop the cluster VMs.
        """
        return pulumi.get(self, "fencing_client_password")


@pulumi.output_type
class ImageReferenceResponse(dict):
    """
    Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exactVersion":
            suggest = "exact_version"
        elif key == "sharedGalleryImageId":
            suggest = "shared_gallery_image_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exact_version: str,
                 offer: Optional[str] = None,
                 publisher: Optional[str] = None,
                 shared_gallery_image_id: Optional[str] = None,
                 sku: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.
        :param str exact_version: Specifies in decimal numbers, the version of platform image or marketplace image used to create the virtual machine. This readonly field differs from 'version', only if the value specified in 'version' field is 'latest'.
        :param str offer: Specifies the offer of the platform image or marketplace image used to create the virtual machine.
        :param str publisher: The image publisher.
        :param str shared_gallery_image_id: Specified the shared gallery image unique id for vm deployment. This can be fetched from shared gallery image GET call.
        :param str sku: The image SKU.
        :param str version: Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
        """
        pulumi.set(__self__, "exact_version", exact_version)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if shared_gallery_image_id is not None:
            pulumi.set(__self__, "shared_gallery_image_id", shared_gallery_image_id)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="exactVersion")
    def exact_version(self) -> str:
        """
        Specifies in decimal numbers, the version of platform image or marketplace image used to create the virtual machine. This readonly field differs from 'version', only if the value specified in 'version' field is 'latest'.
        """
        return pulumi.get(self, "exact_version")

    @property
    @pulumi.getter
    def offer(self) -> Optional[str]:
        """
        Specifies the offer of the platform image or marketplace image used to create the virtual machine.
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The image publisher.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter(name="sharedGalleryImageId")
    def shared_gallery_image_id(self) -> Optional[str]:
        """
        Specified the shared gallery image unique id for vm deployment. This can be fetched from shared gallery image GET call.
        """
        return pulumi.get(self, "shared_gallery_image_id")

    @property
    @pulumi.getter
    def sku(self) -> Optional[str]:
        """
        The image SKU.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class LinuxConfigurationResponse(dict):
    """
    Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osType":
            suggest = "os_type"
        elif key == "disablePasswordAuthentication":
            suggest = "disable_password_authentication"
        elif key == "sshKeyPair":
            suggest = "ssh_key_pair"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_type: str,
                 disable_password_authentication: Optional[bool] = None,
                 ssh: Optional['outputs.SshConfigurationResponse'] = None,
                 ssh_key_pair: Optional['outputs.SshKeyPairResponse'] = None):
        """
        Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
        :param str os_type: The OS Type
               Expected value is 'Linux'.
        :param bool disable_password_authentication: Specifies whether password authentication should be disabled.
        :param 'SshConfigurationResponse' ssh: Specifies the ssh key configuration for a Linux OS. (This property is deprecated, please use 'sshKeyPair' instead)
        :param 'SshKeyPairResponse' ssh_key_pair: The SSH Key-pair used to authenticate with the VM's.
        """
        pulumi.set(__self__, "os_type", 'Linux')
        if disable_password_authentication is not None:
            pulumi.set(__self__, "disable_password_authentication", disable_password_authentication)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)
        if ssh_key_pair is not None:
            pulumi.set(__self__, "ssh_key_pair", ssh_key_pair)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The OS Type
        Expected value is 'Linux'.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="disablePasswordAuthentication")
    def disable_password_authentication(self) -> Optional[bool]:
        """
        Specifies whether password authentication should be disabled.
        """
        return pulumi.get(self, "disable_password_authentication")

    @property
    @pulumi.getter
    def ssh(self) -> Optional['outputs.SshConfigurationResponse']:
        """
        Specifies the ssh key configuration for a Linux OS. (This property is deprecated, please use 'sshKeyPair' instead)
        """
        return pulumi.get(self, "ssh")

    @property
    @pulumi.getter(name="sshKeyPair")
    def ssh_key_pair(self) -> Optional['outputs.SshKeyPairResponse']:
        """
        The SSH Key-pair used to authenticate with the VM's.
        """
        return pulumi.get(self, "ssh_key_pair")


@pulumi.output_type
class ManagedRGConfigurationResponse(dict):
    """
    Managed resource group configuration
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Managed resource group configuration
        :param str name: Managed resource group name
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Managed resource group name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class MessageServerPropertiesResponse(dict):
    """
    Defines the SAP Message Server properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpPort":
            suggest = "http_port"
        elif key == "httpsPort":
            suggest = "https_port"
        elif key == "internalMsPort":
            suggest = "internal_ms_port"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "msPort":
            suggest = "ms_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MessageServerPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MessageServerPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MessageServerPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health: str,
                 hostname: str,
                 http_port: float,
                 https_port: float,
                 internal_ms_port: float,
                 ip_address: str,
                 ms_port: float):
        """
        Defines the SAP Message Server properties.
        :param str health: Defines the health of SAP Instances.
        :param str hostname: Message Server SAP Hostname.
        :param float http_port: Message Server HTTP Port.
        :param float https_port: Message Server HTTPS Port.
        :param float internal_ms_port: Message Server internal MS port.
        :param str ip_address: Message server IP Address.
        :param float ms_port: Message Server port.
        """
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "http_port", http_port)
        pulumi.set(__self__, "https_port", https_port)
        pulumi.set(__self__, "internal_ms_port", internal_ms_port)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ms_port", ms_port)

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        Defines the health of SAP Instances.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Message Server SAP Hostname.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> float:
        """
        Message Server HTTP Port.
        """
        return pulumi.get(self, "http_port")

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> float:
        """
        Message Server HTTPS Port.
        """
        return pulumi.get(self, "https_port")

    @property
    @pulumi.getter(name="internalMsPort")
    def internal_ms_port(self) -> float:
        """
        Message Server internal MS port.
        """
        return pulumi.get(self, "internal_ms_port")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        Message server IP Address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="msPort")
    def ms_port(self) -> float:
        """
        Message Server port.
        """
        return pulumi.get(self, "ms_port")


@pulumi.output_type
class MonitorPropertiesResponseErrors(dict):
    """
    Defines the SAP monitor errors.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "innerError":
            suggest = "inner_error"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitorPropertiesResponseErrors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitorPropertiesResponseErrors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitorPropertiesResponseErrors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: str,
                 details: Sequence['outputs.ErrorResponse'],
                 inner_error: 'outputs.ErrorResponseInnerError',
                 message: str,
                 target: str):
        """
        Defines the SAP monitor errors.
        :param str code: Server-defined set of error codes.
        :param Sequence['ErrorResponse'] details: Array of details about specific errors that led to this reported error.
        :param 'ErrorResponseInnerError' inner_error: Object containing more specific information than  the current object about the error.
        :param str message: Human-readable representation of the error.
        :param str target: Target of the error.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "inner_error", inner_error)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Server-defined set of error codes.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.ErrorResponse']:
        """
        Array of details about specific errors that led to this reported error.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="innerError")
    def inner_error(self) -> 'outputs.ErrorResponseInnerError':
        """
        Object containing more specific information than  the current object about the error.
        """
        return pulumi.get(self, "inner_error")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Human-readable representation of the error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Target of the error.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class MsSqlServerProviderInstancePropertiesResponse(dict):
    """
    Gets or sets the SQL server provider properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerType":
            suggest = "provider_type"
        elif key == "dbPassword":
            suggest = "db_password"
        elif key == "dbPasswordUri":
            suggest = "db_password_uri"
        elif key == "dbPort":
            suggest = "db_port"
        elif key == "dbUsername":
            suggest = "db_username"
        elif key == "sapSid":
            suggest = "sap_sid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MsSqlServerProviderInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MsSqlServerProviderInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MsSqlServerProviderInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provider_type: str,
                 db_password: Optional[str] = None,
                 db_password_uri: Optional[str] = None,
                 db_port: Optional[str] = None,
                 db_username: Optional[str] = None,
                 hostname: Optional[str] = None,
                 sap_sid: Optional[str] = None):
        """
        Gets or sets the SQL server provider properties.
        :param str provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'MsSqlServer'.
        :param str db_password: Gets or sets the database password.
        :param str db_password_uri: Gets or sets the key vault URI to secret with the database password.
        :param str db_port: Gets or sets the database sql port.
        :param str db_username: Gets or sets the database user name.
        :param str hostname: Gets or sets the SQL server host name.
        :param str sap_sid: Gets or sets the SAP System Identifier
        """
        pulumi.set(__self__, "provider_type", 'MsSqlServer')
        if db_password is not None:
            pulumi.set(__self__, "db_password", db_password)
        if db_password_uri is not None:
            pulumi.set(__self__, "db_password_uri", db_password_uri)
        if db_port is not None:
            pulumi.set(__self__, "db_port", db_port)
        if db_username is not None:
            pulumi.set(__self__, "db_username", db_username)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if sap_sid is not None:
            pulumi.set(__self__, "sap_sid", sap_sid)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> str:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'MsSqlServer'.
        """
        return pulumi.get(self, "provider_type")

    @property
    @pulumi.getter(name="dbPassword")
    def db_password(self) -> Optional[str]:
        """
        Gets or sets the database password.
        """
        return pulumi.get(self, "db_password")

    @property
    @pulumi.getter(name="dbPasswordUri")
    def db_password_uri(self) -> Optional[str]:
        """
        Gets or sets the key vault URI to secret with the database password.
        """
        return pulumi.get(self, "db_password_uri")

    @property
    @pulumi.getter(name="dbPort")
    def db_port(self) -> Optional[str]:
        """
        Gets or sets the database sql port.
        """
        return pulumi.get(self, "db_port")

    @property
    @pulumi.getter(name="dbUsername")
    def db_username(self) -> Optional[str]:
        """
        Gets or sets the database user name.
        """
        return pulumi.get(self, "db_username")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        Gets or sets the SQL server host name.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="sapSid")
    def sap_sid(self) -> Optional[str]:
        """
        Gets or sets the SAP System Identifier
        """
        return pulumi.get(self, "sap_sid")


@pulumi.output_type
class NetworkConfigurationResponse(dict):
    """
    Defines the network configuration type for SAP system infrastructure that is being deployed 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isSecondaryIpEnabled":
            suggest = "is_secondary_ip_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_secondary_ip_enabled: Optional[bool] = None):
        """
        Defines the network configuration type for SAP system infrastructure that is being deployed 
        :param bool is_secondary_ip_enabled: Specifies whether a secondary IP address should be added to the network interface on all VMs of the SAP system being deployed
        """
        if is_secondary_ip_enabled is None:
            is_secondary_ip_enabled = False
        if is_secondary_ip_enabled is not None:
            pulumi.set(__self__, "is_secondary_ip_enabled", is_secondary_ip_enabled)

    @property
    @pulumi.getter(name="isSecondaryIpEnabled")
    def is_secondary_ip_enabled(self) -> Optional[bool]:
        """
        Specifies whether a secondary IP address should be added to the network interface on all VMs of the SAP system being deployed
        """
        return pulumi.get(self, "is_secondary_ip_enabled")


@pulumi.output_type
class NetworkProfileResponse(dict):
    """
    Network profile
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureFrontDoorResourceId":
            suggest = "azure_front_door_resource_id"
        elif key == "frontEndPublicIpResourceId":
            suggest = "front_end_public_ip_resource_id"
        elif key == "loadBalancerResourceId":
            suggest = "load_balancer_resource_id"
        elif key == "loadBalancerType":
            suggest = "load_balancer_type"
        elif key == "outboundPublicIpResourceIds":
            suggest = "outbound_public_ip_resource_ids"
        elif key == "vNetResourceId":
            suggest = "v_net_resource_id"
        elif key == "azureFrontDoorEnabled":
            suggest = "azure_front_door_enabled"
        elif key == "loadBalancerSku":
            suggest = "load_balancer_sku"
        elif key == "loadBalancerTier":
            suggest = "load_balancer_tier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_front_door_resource_id: str,
                 front_end_public_ip_resource_id: str,
                 load_balancer_resource_id: str,
                 load_balancer_type: str,
                 outbound_public_ip_resource_ids: Sequence[str],
                 v_net_resource_id: str,
                 azure_front_door_enabled: Optional[str] = None,
                 capacity: Optional[int] = None,
                 load_balancer_sku: Optional[str] = None,
                 load_balancer_tier: Optional[str] = None):
        """
        Network profile
        :param str azure_front_door_resource_id: Azure front door resource id
        :param str front_end_public_ip_resource_id: Loadbalancer front-end IP address resource Id
        :param str load_balancer_resource_id: Azure Loadbalancer or ApplicationGateway resource Id
        :param str load_balancer_type: Load balancer type
        :param Sequence[str] outbound_public_ip_resource_ids: List of outbound public IP resource IDs
        :param str v_net_resource_id: Virtual network resource Id
        :param str azure_front_door_enabled: Whether to enable Azure front door
        :param int capacity: Capacity, applicable only for Application Gateway
        :param str load_balancer_sku: Load balancer SKU
        :param str load_balancer_tier: Load balancer tier
        """
        pulumi.set(__self__, "azure_front_door_resource_id", azure_front_door_resource_id)
        pulumi.set(__self__, "front_end_public_ip_resource_id", front_end_public_ip_resource_id)
        pulumi.set(__self__, "load_balancer_resource_id", load_balancer_resource_id)
        pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        pulumi.set(__self__, "outbound_public_ip_resource_ids", outbound_public_ip_resource_ids)
        pulumi.set(__self__, "v_net_resource_id", v_net_resource_id)
        if azure_front_door_enabled is not None:
            pulumi.set(__self__, "azure_front_door_enabled", azure_front_door_enabled)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if load_balancer_sku is not None:
            pulumi.set(__self__, "load_balancer_sku", load_balancer_sku)
        if load_balancer_tier is not None:
            pulumi.set(__self__, "load_balancer_tier", load_balancer_tier)

    @property
    @pulumi.getter(name="azureFrontDoorResourceId")
    def azure_front_door_resource_id(self) -> str:
        """
        Azure front door resource id
        """
        return pulumi.get(self, "azure_front_door_resource_id")

    @property
    @pulumi.getter(name="frontEndPublicIpResourceId")
    def front_end_public_ip_resource_id(self) -> str:
        """
        Loadbalancer front-end IP address resource Id
        """
        return pulumi.get(self, "front_end_public_ip_resource_id")

    @property
    @pulumi.getter(name="loadBalancerResourceId")
    def load_balancer_resource_id(self) -> str:
        """
        Azure Loadbalancer or ApplicationGateway resource Id
        """
        return pulumi.get(self, "load_balancer_resource_id")

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> str:
        """
        Load balancer type
        """
        return pulumi.get(self, "load_balancer_type")

    @property
    @pulumi.getter(name="outboundPublicIpResourceIds")
    def outbound_public_ip_resource_ids(self) -> Sequence[str]:
        """
        List of outbound public IP resource IDs
        """
        return pulumi.get(self, "outbound_public_ip_resource_ids")

    @property
    @pulumi.getter(name="vNetResourceId")
    def v_net_resource_id(self) -> str:
        """
        Virtual network resource Id
        """
        return pulumi.get(self, "v_net_resource_id")

    @property
    @pulumi.getter(name="azureFrontDoorEnabled")
    def azure_front_door_enabled(self) -> Optional[str]:
        """
        Whether to enable Azure front door
        """
        return pulumi.get(self, "azure_front_door_enabled")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Capacity, applicable only for Application Gateway
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="loadBalancerSku")
    def load_balancer_sku(self) -> Optional[str]:
        """
        Load balancer SKU
        """
        return pulumi.get(self, "load_balancer_sku")

    @property
    @pulumi.getter(name="loadBalancerTier")
    def load_balancer_tier(self) -> Optional[str]:
        """
        Load balancer tier
        """
        return pulumi.get(self, "load_balancer_tier")


@pulumi.output_type
class NodeProfileResponse(dict):
    """
    VM or VMSS node profile
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeResourceIds":
            suggest = "node_resource_ids"
        elif key == "nodeSku":
            suggest = "node_sku"
        elif key == "osDisk":
            suggest = "os_disk"
        elif key == "osImage":
            suggest = "os_image"
        elif key == "dataDisks":
            suggest = "data_disks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_resource_ids: Sequence[str],
                 node_sku: str,
                 os_disk: 'outputs.DiskInfoResponse',
                 os_image: 'outputs.OsImageProfileResponse',
                 data_disks: Optional[Sequence['outputs.DiskInfoResponse']] = None,
                 name: Optional[str] = None):
        """
        VM or VMSS node profile
        :param Sequence[str] node_resource_ids: VM/VMSS resource ARM Ids
        :param str node_sku: VM SKU for node(s)
        :param 'DiskInfoResponse' os_disk: OS disk details
        :param 'OsImageProfileResponse' os_image: OS image used for creating the nodes
        :param Sequence['DiskInfoResponse'] data_disks: Data disks details. This property is not in use right now
        :param str name: VM or VMSS name
        """
        pulumi.set(__self__, "node_resource_ids", node_resource_ids)
        pulumi.set(__self__, "node_sku", node_sku)
        pulumi.set(__self__, "os_disk", os_disk)
        pulumi.set(__self__, "os_image", os_image)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="nodeResourceIds")
    def node_resource_ids(self) -> Sequence[str]:
        """
        VM/VMSS resource ARM Ids
        """
        return pulumi.get(self, "node_resource_ids")

    @property
    @pulumi.getter(name="nodeSku")
    def node_sku(self) -> str:
        """
        VM SKU for node(s)
        """
        return pulumi.get(self, "node_sku")

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> 'outputs.DiskInfoResponse':
        """
        OS disk details
        """
        return pulumi.get(self, "os_disk")

    @property
    @pulumi.getter(name="osImage")
    def os_image(self) -> 'outputs.OsImageProfileResponse':
        """
        OS image used for creating the nodes
        """
        return pulumi.get(self, "os_image")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[Sequence['outputs.DiskInfoResponse']]:
        """
        Data disks details. This property is not in use right now
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        VM or VMSS name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OSProfileResponse(dict):
    """
    Specifies the operating system settings for the virtual machine. Some of the settings cannot be changed once VM is provisioned.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminPassword":
            suggest = "admin_password"
        elif key == "adminUsername":
            suggest = "admin_username"
        elif key == "osConfiguration":
            suggest = "os_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_password: Optional[str] = None,
                 admin_username: Optional[str] = None,
                 os_configuration: Optional[Any] = None):
        """
        Specifies the operating system settings for the virtual machine. Some of the settings cannot be changed once VM is provisioned.
        :param str admin_password: Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
        :param str admin_username: Specifies the name of the administrator account. <br><br> This property cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters.
        :param Union['LinuxConfigurationResponse', 'WindowsConfigurationResponse'] os_configuration: Specifies Windows operating system settings on the virtual machine.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if os_configuration is not None:
            pulumi.set(__self__, "os_configuration", os_configuration)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[str]:
        """
        Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[str]:
        """
        Specifies the name of the administrator account. <br><br> This property cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters.
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="osConfiguration")
    def os_configuration(self) -> Optional[Any]:
        """
        Specifies Windows operating system settings on the virtual machine.
        """
        return pulumi.get(self, "os_configuration")


@pulumi.output_type
class OsImageProfileResponse(dict):
    """
    OS image profile
    """
    def __init__(__self__, *,
                 offer: Optional[str] = None,
                 publisher: Optional[str] = None,
                 sku: Optional[str] = None,
                 version: Optional[str] = None):
        """
        OS image profile
        :param str offer: OS image offer
        :param str publisher: OS image publisher
        :param str sku: OS image sku
        :param str version: OS image version
        """
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def offer(self) -> Optional[str]:
        """
        OS image offer
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        OS image publisher
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def sku(self) -> Optional[str]:
        """
        OS image sku
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        OS image version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class OsSapConfigurationResponse(dict):
    """
    Defines the OS and SAP Configurations for Deployment
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployerVmPackages":
            suggest = "deployer_vm_packages"
        elif key == "sapFqdn":
            suggest = "sap_fqdn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsSapConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsSapConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsSapConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployer_vm_packages: Optional['outputs.DeployerVmPackagesResponse'] = None,
                 sap_fqdn: Optional[str] = None):
        """
        Defines the OS and SAP Configurations for Deployment
        :param 'DeployerVmPackagesResponse' deployer_vm_packages: The url and storage account ID where deployer VM packages are uploaded
        :param str sap_fqdn: The FQDN to set for the SAP system
        """
        if deployer_vm_packages is not None:
            pulumi.set(__self__, "deployer_vm_packages", deployer_vm_packages)
        if sap_fqdn is not None:
            pulumi.set(__self__, "sap_fqdn", sap_fqdn)

    @property
    @pulumi.getter(name="deployerVmPackages")
    def deployer_vm_packages(self) -> Optional['outputs.DeployerVmPackagesResponse']:
        """
        The url and storage account ID where deployer VM packages are uploaded
        """
        return pulumi.get(self, "deployer_vm_packages")

    @property
    @pulumi.getter(name="sapFqdn")
    def sap_fqdn(self) -> Optional[str]:
        """
        The FQDN to set for the SAP system
        """
        return pulumi.get(self, "sap_fqdn")


@pulumi.output_type
class PhpProfileResponse(dict):
    """
    PHP profile
    """
    def __init__(__self__, *,
                 version: str):
        """
        PHP profile
        :param str version: PHP version
        """
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        PHP version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PhpWorkloadResourceResponseIdentity(dict):
    """
    Identity for the resource. Currently not supported
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PhpWorkloadResourceResponseIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PhpWorkloadResourceResponseIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PhpWorkloadResourceResponseIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']] = None):
        """
        Identity for the resource. Currently not supported
        :param str type: Type of manage identity
        :param Mapping[str, 'UserAssignedIdentityResponse'] user_assigned_identities: User assigned identities dictionary
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of manage identity
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']]:
        """
        User assigned identities dictionary
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class PrometheusHaClusterProviderInstancePropertiesResponse(dict):
    """
    Gets or sets the PrometheusHaCluster provider properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerType":
            suggest = "provider_type"
        elif key == "clusterName":
            suggest = "cluster_name"
        elif key == "prometheusUrl":
            suggest = "prometheus_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrometheusHaClusterProviderInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrometheusHaClusterProviderInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrometheusHaClusterProviderInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provider_type: str,
                 cluster_name: Optional[str] = None,
                 hostname: Optional[str] = None,
                 prometheus_url: Optional[str] = None,
                 sid: Optional[str] = None):
        """
        Gets or sets the PrometheusHaCluster provider properties.
        :param str provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'PrometheusHaCluster'.
        :param str cluster_name: Gets or sets the clusterName.
        :param str hostname: Gets or sets the target machine name.
        :param str prometheus_url: URL of the Node Exporter endpoint.
        :param str sid: Gets or sets the cluster sid.
        """
        pulumi.set(__self__, "provider_type", 'PrometheusHaCluster')
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if prometheus_url is not None:
            pulumi.set(__self__, "prometheus_url", prometheus_url)
        if sid is not None:
            pulumi.set(__self__, "sid", sid)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> str:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'PrometheusHaCluster'.
        """
        return pulumi.get(self, "provider_type")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[str]:
        """
        Gets or sets the clusterName.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        Gets or sets the target machine name.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="prometheusUrl")
    def prometheus_url(self) -> Optional[str]:
        """
        URL of the Node Exporter endpoint.
        """
        return pulumi.get(self, "prometheus_url")

    @property
    @pulumi.getter
    def sid(self) -> Optional[str]:
        """
        Gets or sets the cluster sid.
        """
        return pulumi.get(self, "sid")


@pulumi.output_type
class PrometheusOSProviderInstancePropertiesResponse(dict):
    """
    Gets or sets the PrometheusOS provider properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerType":
            suggest = "provider_type"
        elif key == "prometheusUrl":
            suggest = "prometheus_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrometheusOSProviderInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrometheusOSProviderInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrometheusOSProviderInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provider_type: str,
                 prometheus_url: Optional[str] = None):
        """
        Gets or sets the PrometheusOS provider properties.
        :param str provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'PrometheusOS'.
        :param str prometheus_url: URL of the Node Exporter endpoint
        """
        pulumi.set(__self__, "provider_type", 'PrometheusOS')
        if prometheus_url is not None:
            pulumi.set(__self__, "prometheus_url", prometheus_url)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> str:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'PrometheusOS'.
        """
        return pulumi.get(self, "provider_type")

    @property
    @pulumi.getter(name="prometheusUrl")
    def prometheus_url(self) -> Optional[str]:
        """
        URL of the Node Exporter endpoint
        """
        return pulumi.get(self, "prometheus_url")


@pulumi.output_type
class ProviderInstancePropertiesResponseErrors(dict):
    """
    Defines the provider instance errors.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "innerError":
            suggest = "inner_error"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProviderInstancePropertiesResponseErrors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProviderInstancePropertiesResponseErrors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProviderInstancePropertiesResponseErrors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: str,
                 details: Sequence['outputs.ErrorResponse'],
                 inner_error: 'outputs.ErrorResponseInnerError',
                 message: str,
                 target: str):
        """
        Defines the provider instance errors.
        :param str code: Server-defined set of error codes.
        :param Sequence['ErrorResponse'] details: Array of details about specific errors that led to this reported error.
        :param 'ErrorResponseInnerError' inner_error: Object containing more specific information than  the current object about the error.
        :param str message: Human-readable representation of the error.
        :param str target: Target of the error.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "inner_error", inner_error)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Server-defined set of error codes.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.ErrorResponse']:
        """
        Array of details about specific errors that led to this reported error.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="innerError")
    def inner_error(self) -> 'outputs.ErrorResponseInnerError':
        """
        Object containing more specific information than  the current object about the error.
        """
        return pulumi.get(self, "inner_error")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Human-readable representation of the error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Target of the error.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class SAPAvailabilityZonePairResponse(dict):
    """
    The SAP Availability Zone Pair.
    """
    def __init__(__self__, *,
                 zone_a: Optional[float] = None,
                 zone_b: Optional[float] = None):
        """
        The SAP Availability Zone Pair.
        :param float zone_a: The zone A.
        :param float zone_b: The zone B.
        """
        if zone_a is not None:
            pulumi.set(__self__, "zone_a", zone_a)
        if zone_b is not None:
            pulumi.set(__self__, "zone_b", zone_b)

    @property
    @pulumi.getter(name="zoneA")
    def zone_a(self) -> Optional[float]:
        """
        The zone A.
        """
        return pulumi.get(self, "zone_a")

    @property
    @pulumi.getter(name="zoneB")
    def zone_b(self) -> Optional[float]:
        """
        The zone B.
        """
        return pulumi.get(self, "zone_b")


@pulumi.output_type
class SAPDiskConfigurationResponse(dict):
    """
    The SAP Disk Configuration.
    """
    def __init__(__self__, *,
                 disk_count: Optional[float] = None,
                 disk_iops_read_write: Optional[float] = None,
                 disk_m_bps_read_write: Optional[float] = None,
                 disk_size_gb: Optional[float] = None,
                 disk_storage_type: Optional[str] = None,
                 disk_type: Optional[str] = None,
                 volume: Optional[str] = None):
        """
        The SAP Disk Configuration.
        :param float disk_count: The disk count.
        :param float disk_iops_read_write: The disk Iops.
        :param float disk_m_bps_read_write: The disk provisioned throughput in MBps.
        :param float disk_size_gb: The disk size in GB.
        :param str disk_storage_type: The disk storage type
        :param str disk_type: The disk type.
        :param str volume: The volume name.
        """
        if disk_count is not None:
            pulumi.set(__self__, "disk_count", disk_count)
        if disk_iops_read_write is not None:
            pulumi.set(__self__, "disk_iops_read_write", disk_iops_read_write)
        if disk_m_bps_read_write is not None:
            pulumi.set(__self__, "disk_m_bps_read_write", disk_m_bps_read_write)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_storage_type is not None:
            pulumi.set(__self__, "disk_storage_type", disk_storage_type)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if volume is not None:
            pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter(name="diskCount")
    def disk_count(self) -> Optional[float]:
        """
        The disk count.
        """
        return pulumi.get(self, "disk_count")

    @property
    @pulumi.getter(name="diskIopsReadWrite")
    def disk_iops_read_write(self) -> Optional[float]:
        """
        The disk Iops.
        """
        return pulumi.get(self, "disk_iops_read_write")

    @property
    @pulumi.getter(name="diskMBpsReadWrite")
    def disk_m_bps_read_write(self) -> Optional[float]:
        """
        The disk provisioned throughput in MBps.
        """
        return pulumi.get(self, "disk_m_bps_read_write")

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[float]:
        """
        The disk size in GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskStorageType")
    def disk_storage_type(self) -> Optional[str]:
        """
        The disk storage type
        """
        return pulumi.get(self, "disk_storage_type")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[str]:
        """
        The disk type.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter
    def volume(self) -> Optional[str]:
        """
        The volume name.
        """
        return pulumi.get(self, "volume")


@pulumi.output_type
class SAPInstallWithoutOSConfigSoftwareConfigurationResponse(dict):
    """
    The SAP Software configuration Input when the software is to be installed by service without OS Configurations
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bomUrl":
            suggest = "bom_url"
        elif key == "sapBitsStorageAccountId":
            suggest = "sap_bits_storage_account_id"
        elif key == "softwareInstallationType":
            suggest = "software_installation_type"
        elif key == "softwareVersion":
            suggest = "software_version"
        elif key == "highAvailabilitySoftwareConfiguration":
            suggest = "high_availability_software_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SAPInstallWithoutOSConfigSoftwareConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SAPInstallWithoutOSConfigSoftwareConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SAPInstallWithoutOSConfigSoftwareConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bom_url: str,
                 sap_bits_storage_account_id: str,
                 software_installation_type: str,
                 software_version: str,
                 high_availability_software_configuration: Optional['outputs.HighAvailabilitySoftwareConfigurationResponse'] = None):
        """
        The SAP Software configuration Input when the software is to be installed by service without OS Configurations
        :param str bom_url: The URL to the SAP Build of Materials(BOM) file.
        :param str sap_bits_storage_account_id: The SAP bits storage account id.
        :param str software_installation_type: The SAP software installation Type.
               Expected value is 'SAPInstallWithoutOSConfig'.
        :param str software_version: The software version to install.
        :param 'HighAvailabilitySoftwareConfigurationResponse' high_availability_software_configuration: Gets or sets the HA software configuration.
        """
        pulumi.set(__self__, "bom_url", bom_url)
        pulumi.set(__self__, "sap_bits_storage_account_id", sap_bits_storage_account_id)
        pulumi.set(__self__, "software_installation_type", 'SAPInstallWithoutOSConfig')
        pulumi.set(__self__, "software_version", software_version)
        if high_availability_software_configuration is not None:
            pulumi.set(__self__, "high_availability_software_configuration", high_availability_software_configuration)

    @property
    @pulumi.getter(name="bomUrl")
    def bom_url(self) -> str:
        """
        The URL to the SAP Build of Materials(BOM) file.
        """
        return pulumi.get(self, "bom_url")

    @property
    @pulumi.getter(name="sapBitsStorageAccountId")
    def sap_bits_storage_account_id(self) -> str:
        """
        The SAP bits storage account id.
        """
        return pulumi.get(self, "sap_bits_storage_account_id")

    @property
    @pulumi.getter(name="softwareInstallationType")
    def software_installation_type(self) -> str:
        """
        The SAP software installation Type.
        Expected value is 'SAPInstallWithoutOSConfig'.
        """
        return pulumi.get(self, "software_installation_type")

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> str:
        """
        The software version to install.
        """
        return pulumi.get(self, "software_version")

    @property
    @pulumi.getter(name="highAvailabilitySoftwareConfiguration")
    def high_availability_software_configuration(self) -> Optional['outputs.HighAvailabilitySoftwareConfigurationResponse']:
        """
        Gets or sets the HA software configuration.
        """
        return pulumi.get(self, "high_availability_software_configuration")


@pulumi.output_type
class SAPSupportedSkuResponse(dict):
    """
    The SAP supported SKU.
    """
    def __init__(__self__, *,
                 is_app_server_certified: Optional[bool] = None,
                 is_database_certified: Optional[bool] = None,
                 vm_sku: Optional[str] = None):
        """
        The SAP supported SKU.
        :param bool is_app_server_certified: True if the Sku is certified for App server in the SAP system.
        :param bool is_database_certified: True if the Sku is certified for Database server in the SAP system.
        :param str vm_sku: The VM Sku.
        """
        if is_app_server_certified is not None:
            pulumi.set(__self__, "is_app_server_certified", is_app_server_certified)
        if is_database_certified is not None:
            pulumi.set(__self__, "is_database_certified", is_database_certified)
        if vm_sku is not None:
            pulumi.set(__self__, "vm_sku", vm_sku)

    @property
    @pulumi.getter(name="isAppServerCertified")
    def is_app_server_certified(self) -> Optional[bool]:
        """
        True if the Sku is certified for App server in the SAP system.
        """
        return pulumi.get(self, "is_app_server_certified")

    @property
    @pulumi.getter(name="isDatabaseCertified")
    def is_database_certified(self) -> Optional[bool]:
        """
        True if the Sku is certified for Database server in the SAP system.
        """
        return pulumi.get(self, "is_database_certified")

    @property
    @pulumi.getter(name="vmSku")
    def vm_sku(self) -> Optional[str]:
        """
        The VM Sku.
        """
        return pulumi.get(self, "vm_sku")


@pulumi.output_type
class SAPVirtualInstanceErrorResponse(dict):
    """
    An error response from the Virtual Instance for SAP Workload service.
    """
    def __init__(__self__, *,
                 properties: Optional['outputs.ErrorDefinitionResponse'] = None):
        """
        An error response from the Virtual Instance for SAP Workload service.
        :param 'ErrorDefinitionResponse' properties: The Virtual Instance for SAP error body.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.ErrorDefinitionResponse']:
        """
        The Virtual Instance for SAP error body.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class SapNetWeaverProviderInstancePropertiesResponse(dict):
    """
    Gets or sets the provider properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerType":
            suggest = "provider_type"
        elif key == "sapClientId":
            suggest = "sap_client_id"
        elif key == "sapHostFileEntries":
            suggest = "sap_host_file_entries"
        elif key == "sapHostname":
            suggest = "sap_hostname"
        elif key == "sapInstanceNr":
            suggest = "sap_instance_nr"
        elif key == "sapPassword":
            suggest = "sap_password"
        elif key == "sapPasswordUri":
            suggest = "sap_password_uri"
        elif key == "sapPortNumber":
            suggest = "sap_port_number"
        elif key == "sapSid":
            suggest = "sap_sid"
        elif key == "sapSslCertificateUri":
            suggest = "sap_ssl_certificate_uri"
        elif key == "sapUsername":
            suggest = "sap_username"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SapNetWeaverProviderInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SapNetWeaverProviderInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SapNetWeaverProviderInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provider_type: str,
                 sap_client_id: Optional[str] = None,
                 sap_host_file_entries: Optional[Sequence[str]] = None,
                 sap_hostname: Optional[str] = None,
                 sap_instance_nr: Optional[str] = None,
                 sap_password: Optional[str] = None,
                 sap_password_uri: Optional[str] = None,
                 sap_port_number: Optional[str] = None,
                 sap_sid: Optional[str] = None,
                 sap_ssl_certificate_uri: Optional[str] = None,
                 sap_username: Optional[str] = None):
        """
        Gets or sets the provider properties.
        :param str provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'SapNetWeaver'.
        :param str sap_client_id: Gets or sets the SAP Client ID.
        :param Sequence[str] sap_host_file_entries: Gets or sets the list of HostFile Entries
        :param str sap_hostname: Gets or sets the target virtual machine IP Address/FQDN.
        :param str sap_instance_nr: Gets or sets the instance number of SAP NetWeaver.
        :param str sap_password: Sets the SAP password.
        :param str sap_password_uri: Gets or sets the key vault URI to secret with the SAP password.
        :param str sap_port_number: Gets or sets the SAP HTTP port number.
        :param str sap_sid: Gets or sets the SAP System Identifier
        :param str sap_ssl_certificate_uri: Gets or sets the blob URI to SSL certificate for the SAP system.
        :param str sap_username: Gets or sets the SAP user name.
        """
        pulumi.set(__self__, "provider_type", 'SapNetWeaver')
        if sap_client_id is not None:
            pulumi.set(__self__, "sap_client_id", sap_client_id)
        if sap_host_file_entries is not None:
            pulumi.set(__self__, "sap_host_file_entries", sap_host_file_entries)
        if sap_hostname is not None:
            pulumi.set(__self__, "sap_hostname", sap_hostname)
        if sap_instance_nr is not None:
            pulumi.set(__self__, "sap_instance_nr", sap_instance_nr)
        if sap_password is not None:
            pulumi.set(__self__, "sap_password", sap_password)
        if sap_password_uri is not None:
            pulumi.set(__self__, "sap_password_uri", sap_password_uri)
        if sap_port_number is not None:
            pulumi.set(__self__, "sap_port_number", sap_port_number)
        if sap_sid is not None:
            pulumi.set(__self__, "sap_sid", sap_sid)
        if sap_ssl_certificate_uri is not None:
            pulumi.set(__self__, "sap_ssl_certificate_uri", sap_ssl_certificate_uri)
        if sap_username is not None:
            pulumi.set(__self__, "sap_username", sap_username)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> str:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'SapNetWeaver'.
        """
        return pulumi.get(self, "provider_type")

    @property
    @pulumi.getter(name="sapClientId")
    def sap_client_id(self) -> Optional[str]:
        """
        Gets or sets the SAP Client ID.
        """
        return pulumi.get(self, "sap_client_id")

    @property
    @pulumi.getter(name="sapHostFileEntries")
    def sap_host_file_entries(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the list of HostFile Entries
        """
        return pulumi.get(self, "sap_host_file_entries")

    @property
    @pulumi.getter(name="sapHostname")
    def sap_hostname(self) -> Optional[str]:
        """
        Gets or sets the target virtual machine IP Address/FQDN.
        """
        return pulumi.get(self, "sap_hostname")

    @property
    @pulumi.getter(name="sapInstanceNr")
    def sap_instance_nr(self) -> Optional[str]:
        """
        Gets or sets the instance number of SAP NetWeaver.
        """
        return pulumi.get(self, "sap_instance_nr")

    @property
    @pulumi.getter(name="sapPassword")
    def sap_password(self) -> Optional[str]:
        """
        Sets the SAP password.
        """
        return pulumi.get(self, "sap_password")

    @property
    @pulumi.getter(name="sapPasswordUri")
    def sap_password_uri(self) -> Optional[str]:
        """
        Gets or sets the key vault URI to secret with the SAP password.
        """
        return pulumi.get(self, "sap_password_uri")

    @property
    @pulumi.getter(name="sapPortNumber")
    def sap_port_number(self) -> Optional[str]:
        """
        Gets or sets the SAP HTTP port number.
        """
        return pulumi.get(self, "sap_port_number")

    @property
    @pulumi.getter(name="sapSid")
    def sap_sid(self) -> Optional[str]:
        """
        Gets or sets the SAP System Identifier
        """
        return pulumi.get(self, "sap_sid")

    @property
    @pulumi.getter(name="sapSslCertificateUri")
    def sap_ssl_certificate_uri(self) -> Optional[str]:
        """
        Gets or sets the blob URI to SSL certificate for the SAP system.
        """
        return pulumi.get(self, "sap_ssl_certificate_uri")

    @property
    @pulumi.getter(name="sapUsername")
    def sap_username(self) -> Optional[str]:
        """
        Gets or sets the SAP user name.
        """
        return pulumi.get(self, "sap_username")


@pulumi.output_type
class SearchProfileResponse(dict):
    """
    Search profile
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeResourceIds":
            suggest = "node_resource_ids"
        elif key == "nodeSku":
            suggest = "node_sku"
        elif key == "osDisk":
            suggest = "os_disk"
        elif key == "osImage":
            suggest = "os_image"
        elif key == "searchType":
            suggest = "search_type"
        elif key == "dataDisks":
            suggest = "data_disks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SearchProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SearchProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SearchProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_resource_ids: Sequence[str],
                 node_sku: str,
                 os_disk: 'outputs.DiskInfoResponse',
                 os_image: 'outputs.OsImageProfileResponse',
                 search_type: str,
                 data_disks: Optional[Sequence['outputs.DiskInfoResponse']] = None,
                 name: Optional[str] = None):
        """
        Search profile
        :param Sequence[str] node_resource_ids: VM/VMSS resource ARM Ids
        :param str node_sku: VM SKU for node(s)
        :param 'DiskInfoResponse' os_disk: OS disk details
        :param 'OsImageProfileResponse' os_image: OS image used for creating the nodes
        :param str search_type: Search type
        :param Sequence['DiskInfoResponse'] data_disks: Data disks details. This property is not in use right now
        :param str name: VM or VMSS name
        """
        pulumi.set(__self__, "node_resource_ids", node_resource_ids)
        pulumi.set(__self__, "node_sku", node_sku)
        pulumi.set(__self__, "os_disk", os_disk)
        pulumi.set(__self__, "os_image", os_image)
        pulumi.set(__self__, "search_type", search_type)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="nodeResourceIds")
    def node_resource_ids(self) -> Sequence[str]:
        """
        VM/VMSS resource ARM Ids
        """
        return pulumi.get(self, "node_resource_ids")

    @property
    @pulumi.getter(name="nodeSku")
    def node_sku(self) -> str:
        """
        VM SKU for node(s)
        """
        return pulumi.get(self, "node_sku")

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> 'outputs.DiskInfoResponse':
        """
        OS disk details
        """
        return pulumi.get(self, "os_disk")

    @property
    @pulumi.getter(name="osImage")
    def os_image(self) -> 'outputs.OsImageProfileResponse':
        """
        OS image used for creating the nodes
        """
        return pulumi.get(self, "os_image")

    @property
    @pulumi.getter(name="searchType")
    def search_type(self) -> str:
        """
        Search type
        """
        return pulumi.get(self, "search_type")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[Sequence['outputs.DiskInfoResponse']]:
        """
        Data disks details. This property is not in use right now
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        VM or VMSS name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceInitiatedSoftwareConfigurationResponse(dict):
    """
    The SAP Software configuration Input when the software is to be installed by service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bomUrl":
            suggest = "bom_url"
        elif key == "sapBitsStorageAccountId":
            suggest = "sap_bits_storage_account_id"
        elif key == "sapFqdn":
            suggest = "sap_fqdn"
        elif key == "softwareInstallationType":
            suggest = "software_installation_type"
        elif key == "softwareVersion":
            suggest = "software_version"
        elif key == "sshPrivateKey":
            suggest = "ssh_private_key"
        elif key == "highAvailabilitySoftwareConfiguration":
            suggest = "high_availability_software_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceInitiatedSoftwareConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceInitiatedSoftwareConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceInitiatedSoftwareConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bom_url: str,
                 sap_bits_storage_account_id: str,
                 sap_fqdn: str,
                 software_installation_type: str,
                 software_version: str,
                 ssh_private_key: str,
                 high_availability_software_configuration: Optional['outputs.HighAvailabilitySoftwareConfigurationResponse'] = None):
        """
        The SAP Software configuration Input when the software is to be installed by service.
        :param str bom_url: The URL to the SAP Build of Materials(BOM) file.
        :param str sap_bits_storage_account_id: The SAP bits storage account id.
        :param str sap_fqdn: The FQDN to set for the SAP system during install.
        :param str software_installation_type: The SAP software installation Type.
               Expected value is 'ServiceInitiated'.
        :param str software_version: The software version to install.
        :param str ssh_private_key: The SSH private key.
        :param 'HighAvailabilitySoftwareConfigurationResponse' high_availability_software_configuration: Gets or sets the HA software configuration.
        """
        pulumi.set(__self__, "bom_url", bom_url)
        pulumi.set(__self__, "sap_bits_storage_account_id", sap_bits_storage_account_id)
        pulumi.set(__self__, "sap_fqdn", sap_fqdn)
        pulumi.set(__self__, "software_installation_type", 'ServiceInitiated')
        pulumi.set(__self__, "software_version", software_version)
        pulumi.set(__self__, "ssh_private_key", ssh_private_key)
        if high_availability_software_configuration is not None:
            pulumi.set(__self__, "high_availability_software_configuration", high_availability_software_configuration)

    @property
    @pulumi.getter(name="bomUrl")
    def bom_url(self) -> str:
        """
        The URL to the SAP Build of Materials(BOM) file.
        """
        return pulumi.get(self, "bom_url")

    @property
    @pulumi.getter(name="sapBitsStorageAccountId")
    def sap_bits_storage_account_id(self) -> str:
        """
        The SAP bits storage account id.
        """
        return pulumi.get(self, "sap_bits_storage_account_id")

    @property
    @pulumi.getter(name="sapFqdn")
    def sap_fqdn(self) -> str:
        """
        The FQDN to set for the SAP system during install.
        """
        return pulumi.get(self, "sap_fqdn")

    @property
    @pulumi.getter(name="softwareInstallationType")
    def software_installation_type(self) -> str:
        """
        The SAP software installation Type.
        Expected value is 'ServiceInitiated'.
        """
        return pulumi.get(self, "software_installation_type")

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> str:
        """
        The software version to install.
        """
        return pulumi.get(self, "software_version")

    @property
    @pulumi.getter(name="sshPrivateKey")
    def ssh_private_key(self) -> str:
        """
        The SSH private key.
        """
        return pulumi.get(self, "ssh_private_key")

    @property
    @pulumi.getter(name="highAvailabilitySoftwareConfiguration")
    def high_availability_software_configuration(self) -> Optional['outputs.HighAvailabilitySoftwareConfigurationResponse']:
        """
        Gets or sets the HA software configuration.
        """
        return pulumi.get(self, "high_availability_software_configuration")


@pulumi.output_type
class SingleServerConfigurationResponse(dict):
    """
    Gets or sets the single server configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appResourceGroup":
            suggest = "app_resource_group"
        elif key == "deploymentType":
            suggest = "deployment_type"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "virtualMachineConfiguration":
            suggest = "virtual_machine_configuration"
        elif key == "databaseType":
            suggest = "database_type"
        elif key == "networkConfiguration":
            suggest = "network_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SingleServerConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SingleServerConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SingleServerConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_resource_group: str,
                 deployment_type: str,
                 subnet_id: str,
                 virtual_machine_configuration: 'outputs.VirtualMachineConfigurationResponse',
                 database_type: Optional[str] = None,
                 network_configuration: Optional['outputs.NetworkConfigurationResponse'] = None):
        """
        Gets or sets the single server configuration.
        :param str app_resource_group: The application resource group where SAP system resources will be deployed.
        :param str deployment_type: The type of SAP deployment, single server or Three tier.
               Expected value is 'SingleServer'.
        :param str subnet_id: The subnet id.
        :param 'VirtualMachineConfigurationResponse' virtual_machine_configuration: Gets or sets the virtual machine configuration.
        :param str database_type: The database type.
        :param 'NetworkConfigurationResponse' network_configuration: Network configuration for the server
        """
        pulumi.set(__self__, "app_resource_group", app_resource_group)
        pulumi.set(__self__, "deployment_type", 'SingleServer')
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)

    @property
    @pulumi.getter(name="appResourceGroup")
    def app_resource_group(self) -> str:
        """
        The application resource group where SAP system resources will be deployed.
        """
        return pulumi.get(self, "app_resource_group")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        The type of SAP deployment, single server or Three tier.
        Expected value is 'SingleServer'.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> 'outputs.VirtualMachineConfigurationResponse':
        """
        Gets or sets the virtual machine configuration.
        """
        return pulumi.get(self, "virtual_machine_configuration")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[str]:
        """
        The database type.
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional['outputs.NetworkConfigurationResponse']:
        """
        Network configuration for the server
        """
        return pulumi.get(self, "network_configuration")


@pulumi.output_type
class SiteProfileResponse(dict):
    """
    Workload website profile
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[str] = None):
        """
        Workload website profile
        :param str domain_name: Domain name for the application site URL
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        """
        Domain name for the application site URL
        """
        return pulumi.get(self, "domain_name")


@pulumi.output_type
class SkuResponse(dict):
    """
    The resource model definition representing SKU
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        The resource model definition representing SKU
        :param str name: The name of the SKU. Ex - P3. It is typically a letter+number code
        :param int capacity: If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        :param str family: If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param str size: The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        :param str tier: This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU. Ex - P3. It is typically a letter+number code
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SshConfigurationResponse(dict):
    """
    SSH configuration for Linux based VMs running on Azure
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKeys":
            suggest = "public_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_keys: Optional[Sequence['outputs.SshPublicKeyResponse']] = None):
        """
        SSH configuration for Linux based VMs running on Azure
        :param Sequence['SshPublicKeyResponse'] public_keys: The list of SSH public keys used to authenticate with linux based VMs.
        """
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[Sequence['outputs.SshPublicKeyResponse']]:
        """
        The list of SSH public keys used to authenticate with linux based VMs.
        """
        return pulumi.get(self, "public_keys")


@pulumi.output_type
class SshKeyPairResponse(dict):
    """
    The SSH Key-pair used to authenticate with the VM. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKey":
            suggest = "private_key"
        elif key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshKeyPairResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshKeyPairResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshKeyPairResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_key: Optional[str] = None,
                 public_key: Optional[str] = None):
        """
        The SSH Key-pair used to authenticate with the VM. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        :param str private_key: SSH private key.
        :param str public_key: SSH public key
        """
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[str]:
        """
        SSH private key.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        SSH public key
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class SshPublicKeyResponse(dict):
    """
    Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyData":
            suggest = "key_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshPublicKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshPublicKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshPublicKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_data: Optional[str] = None):
        """
        Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
        :param str key_data: SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        """
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        """
        return pulumi.get(self, "key_data")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class ThreeTierConfigurationResponse(dict):
    """
    Gets or sets the three tier SAP configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appResourceGroup":
            suggest = "app_resource_group"
        elif key == "applicationServer":
            suggest = "application_server"
        elif key == "centralServer":
            suggest = "central_server"
        elif key == "databaseServer":
            suggest = "database_server"
        elif key == "deploymentType":
            suggest = "deployment_type"
        elif key == "highAvailabilityConfig":
            suggest = "high_availability_config"
        elif key == "networkConfiguration":
            suggest = "network_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ThreeTierConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ThreeTierConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ThreeTierConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_resource_group: str,
                 application_server: 'outputs.ApplicationServerConfigurationResponse',
                 central_server: 'outputs.CentralServerConfigurationResponse',
                 database_server: 'outputs.DatabaseConfigurationResponse',
                 deployment_type: str,
                 high_availability_config: Optional['outputs.HighAvailabilityConfigurationResponse'] = None,
                 network_configuration: Optional['outputs.NetworkConfigurationResponse'] = None):
        """
        Gets or sets the three tier SAP configuration.
        :param str app_resource_group: The application resource group where SAP system resources will be deployed.
        :param 'ApplicationServerConfigurationResponse' application_server: The application server configuration.
        :param 'CentralServerConfigurationResponse' central_server: The central server configuration.
        :param 'DatabaseConfigurationResponse' database_server: The database configuration.
        :param str deployment_type: The type of SAP deployment, single server or Three tier.
               Expected value is 'ThreeTier'.
        :param 'HighAvailabilityConfigurationResponse' high_availability_config: The high availability configuration.
        :param 'NetworkConfigurationResponse' network_configuration: Network configuration common to all servers
        """
        pulumi.set(__self__, "app_resource_group", app_resource_group)
        pulumi.set(__self__, "application_server", application_server)
        pulumi.set(__self__, "central_server", central_server)
        pulumi.set(__self__, "database_server", database_server)
        pulumi.set(__self__, "deployment_type", 'ThreeTier')
        if high_availability_config is not None:
            pulumi.set(__self__, "high_availability_config", high_availability_config)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)

    @property
    @pulumi.getter(name="appResourceGroup")
    def app_resource_group(self) -> str:
        """
        The application resource group where SAP system resources will be deployed.
        """
        return pulumi.get(self, "app_resource_group")

    @property
    @pulumi.getter(name="applicationServer")
    def application_server(self) -> 'outputs.ApplicationServerConfigurationResponse':
        """
        The application server configuration.
        """
        return pulumi.get(self, "application_server")

    @property
    @pulumi.getter(name="centralServer")
    def central_server(self) -> 'outputs.CentralServerConfigurationResponse':
        """
        The central server configuration.
        """
        return pulumi.get(self, "central_server")

    @property
    @pulumi.getter(name="databaseServer")
    def database_server(self) -> 'outputs.DatabaseConfigurationResponse':
        """
        The database configuration.
        """
        return pulumi.get(self, "database_server")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        The type of SAP deployment, single server or Three tier.
        Expected value is 'ThreeTier'.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="highAvailabilityConfig")
    def high_availability_config(self) -> Optional['outputs.HighAvailabilityConfigurationResponse']:
        """
        The high availability configuration.
        """
        return pulumi.get(self, "high_availability_config")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional['outputs.NetworkConfigurationResponse']:
        """
        Network configuration common to all servers
        """
        return pulumi.get(self, "network_configuration")


@pulumi.output_type
class UserAssignedIdentityResponse(dict):
    """
    User assigned identity properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        User assigned identity properties
        :param str client_id: The client ID of the assigned identity.
        :param str principal_id: The principal ID of the assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID of the assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of the assigned identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class UserAssignedServiceIdentityResponse(dict):
    """
    Managed service identity (user assigned identities)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedServiceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedServiceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedServiceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']] = None):
        """
        Managed service identity (user assigned identities)
        :param str type: Type of manage identity
        :param Mapping[str, 'UserAssignedIdentityResponse'] user_assigned_identities: User assigned identities dictionary
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of manage identity
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']]:
        """
        User assigned identities dictionary
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class UserProfileResponse(dict):
    """
    User profile to configure on a compute resources such as VM, VMSS
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshPublicKey":
            suggest = "ssh_public_key"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ssh_public_key: str,
                 user_name: str):
        """
        User profile to configure on a compute resources such as VM, VMSS
        :param str ssh_public_key: SSH public key data
        :param str user_name: User name
        """
        pulumi.set(__self__, "ssh_public_key", ssh_public_key)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> str:
        """
        SSH public key data
        """
        return pulumi.get(self, "ssh_public_key")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        User name
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class VirtualMachineConfigurationResponse(dict):
    """
    Defines the virtual machine configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageReference":
            suggest = "image_reference"
        elif key == "osProfile":
            suggest = "os_profile"
        elif key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_reference: 'outputs.ImageReferenceResponse',
                 os_profile: 'outputs.OSProfileResponse',
                 vm_size: str):
        """
        Defines the virtual machine configuration.
        :param 'ImageReferenceResponse' image_reference: The image reference.
        :param 'OSProfileResponse' os_profile: The OS profile.
        :param str vm_size: The virtual machine size.
        """
        pulumi.set(__self__, "image_reference", image_reference)
        pulumi.set(__self__, "os_profile", os_profile)
        pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> 'outputs.ImageReferenceResponse':
        """
        The image reference.
        """
        return pulumi.get(self, "image_reference")

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> 'outputs.OSProfileResponse':
        """
        The OS profile.
        """
        return pulumi.get(self, "os_profile")

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> str:
        """
        The virtual machine size.
        """
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class VmssNodesProfileResponse(dict):
    """
    VMSS profile
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeResourceIds":
            suggest = "node_resource_ids"
        elif key == "nodeSku":
            suggest = "node_sku"
        elif key == "osDisk":
            suggest = "os_disk"
        elif key == "osImage":
            suggest = "os_image"
        elif key == "autoScaleMaxCount":
            suggest = "auto_scale_max_count"
        elif key == "autoScaleMinCount":
            suggest = "auto_scale_min_count"
        elif key == "dataDisks":
            suggest = "data_disks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmssNodesProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmssNodesProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmssNodesProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_resource_ids: Sequence[str],
                 node_sku: str,
                 os_disk: 'outputs.DiskInfoResponse',
                 os_image: 'outputs.OsImageProfileResponse',
                 auto_scale_max_count: Optional[int] = None,
                 auto_scale_min_count: Optional[int] = None,
                 data_disks: Optional[Sequence['outputs.DiskInfoResponse']] = None,
                 name: Optional[str] = None):
        """
        VMSS profile
        :param Sequence[str] node_resource_ids: VM/VMSS resource ARM Ids
        :param str node_sku: VM SKU for node(s)
        :param 'DiskInfoResponse' os_disk: OS disk details
        :param 'OsImageProfileResponse' os_image: OS image used for creating the nodes
        :param int auto_scale_max_count: Maximum number of nodes for autoscale
        :param int auto_scale_min_count: Minimum number of nodes for autoscale
        :param Sequence['DiskInfoResponse'] data_disks: Data disks details. This property is not in use right now
        :param str name: VM or VMSS name
        """
        pulumi.set(__self__, "node_resource_ids", node_resource_ids)
        pulumi.set(__self__, "node_sku", node_sku)
        pulumi.set(__self__, "os_disk", os_disk)
        pulumi.set(__self__, "os_image", os_image)
        if auto_scale_max_count is not None:
            pulumi.set(__self__, "auto_scale_max_count", auto_scale_max_count)
        if auto_scale_min_count is not None:
            pulumi.set(__self__, "auto_scale_min_count", auto_scale_min_count)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="nodeResourceIds")
    def node_resource_ids(self) -> Sequence[str]:
        """
        VM/VMSS resource ARM Ids
        """
        return pulumi.get(self, "node_resource_ids")

    @property
    @pulumi.getter(name="nodeSku")
    def node_sku(self) -> str:
        """
        VM SKU for node(s)
        """
        return pulumi.get(self, "node_sku")

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> 'outputs.DiskInfoResponse':
        """
        OS disk details
        """
        return pulumi.get(self, "os_disk")

    @property
    @pulumi.getter(name="osImage")
    def os_image(self) -> 'outputs.OsImageProfileResponse':
        """
        OS image used for creating the nodes
        """
        return pulumi.get(self, "os_image")

    @property
    @pulumi.getter(name="autoScaleMaxCount")
    def auto_scale_max_count(self) -> Optional[int]:
        """
        Maximum number of nodes for autoscale
        """
        return pulumi.get(self, "auto_scale_max_count")

    @property
    @pulumi.getter(name="autoScaleMinCount")
    def auto_scale_min_count(self) -> Optional[int]:
        """
        Minimum number of nodes for autoscale
        """
        return pulumi.get(self, "auto_scale_min_count")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[Sequence['outputs.DiskInfoResponse']]:
        """
        Data disks details. This property is not in use right now
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        VM or VMSS name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class WindowsConfigurationResponse(dict):
    """
    Specifies Windows operating system settings on the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osType":
            suggest = "os_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_type: str):
        """
        Specifies Windows operating system settings on the virtual machine.
        :param str os_type: The OS Type
               Expected value is 'Windows'.
        """
        pulumi.set(__self__, "os_type", 'Windows')

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The OS Type
        Expected value is 'Windows'.
        """
        return pulumi.get(self, "os_type")


