# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ContactDetailsArgs',
    'DataBoxDiskJobDetailsArgs',
    'DataBoxHeavyJobDetailsArgs',
    'DataBoxJobDetailsArgs',
    'DestinationManagedDiskDetailsArgs',
    'DestinationStorageAccountDetailsArgs',
    'JobDeliveryInfoArgs',
    'NotificationPreferenceArgs',
    'PreferencesArgs',
    'ShippingAddressArgs',
    'SkuArgs',
    'TransportPreferencesArgs',
]

@pulumi.input_type
class ContactDetailsArgs:
    def __init__(__self__, *,
                 contact_name: pulumi.Input[str],
                 email_list: pulumi.Input[Sequence[pulumi.Input[str]]],
                 phone: pulumi.Input[str],
                 mobile: Optional[pulumi.Input[str]] = None,
                 notification_preference: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPreferenceArgs']]]] = None,
                 phone_extension: Optional[pulumi.Input[str]] = None):
        """
        Contact Details.
        :param pulumi.Input[str] contact_name: Contact name of the person.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] email_list: List of Email-ids to be notified about job progress.
        :param pulumi.Input[str] phone: Phone number of the contact person.
        :param pulumi.Input[str] mobile: Mobile number of the contact person.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationPreferenceArgs']]] notification_preference: Notification preference for a job stage.
        :param pulumi.Input[str] phone_extension: Phone extension number of the contact person.
        """
        pulumi.set(__self__, "contact_name", contact_name)
        pulumi.set(__self__, "email_list", email_list)
        pulumi.set(__self__, "phone", phone)
        if mobile is not None:
            pulumi.set(__self__, "mobile", mobile)
        if notification_preference is not None:
            pulumi.set(__self__, "notification_preference", notification_preference)
        if phone_extension is not None:
            pulumi.set(__self__, "phone_extension", phone_extension)

    @property
    @pulumi.getter(name="contactName")
    def contact_name(self) -> pulumi.Input[str]:
        """
        Contact name of the person.
        """
        return pulumi.get(self, "contact_name")

    @contact_name.setter
    def contact_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "contact_name", value)

    @property
    @pulumi.getter(name="emailList")
    def email_list(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of Email-ids to be notified about job progress.
        """
        return pulumi.get(self, "email_list")

    @email_list.setter
    def email_list(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "email_list", value)

    @property
    @pulumi.getter
    def phone(self) -> pulumi.Input[str]:
        """
        Phone number of the contact person.
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: pulumi.Input[str]):
        pulumi.set(self, "phone", value)

    @property
    @pulumi.getter
    def mobile(self) -> Optional[pulumi.Input[str]]:
        """
        Mobile number of the contact person.
        """
        return pulumi.get(self, "mobile")

    @mobile.setter
    def mobile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mobile", value)

    @property
    @pulumi.getter(name="notificationPreference")
    def notification_preference(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPreferenceArgs']]]]:
        """
        Notification preference for a job stage.
        """
        return pulumi.get(self, "notification_preference")

    @notification_preference.setter
    def notification_preference(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPreferenceArgs']]]]):
        pulumi.set(self, "notification_preference", value)

    @property
    @pulumi.getter(name="phoneExtension")
    def phone_extension(self) -> Optional[pulumi.Input[str]]:
        """
        Phone extension number of the contact person.
        """
        return pulumi.get(self, "phone_extension")

    @phone_extension.setter
    def phone_extension(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone_extension", value)


@pulumi.input_type
class DataBoxDiskJobDetailsArgs:
    def __init__(__self__, *,
                 contact_details: pulumi.Input['ContactDetailsArgs'],
                 destination_account_details: pulumi.Input[Sequence[pulumi.Input[Union['DestinationManagedDiskDetailsArgs', 'DestinationStorageAccountDetailsArgs']]]],
                 job_details_type: pulumi.Input[str],
                 shipping_address: pulumi.Input['ShippingAddressArgs'],
                 expected_data_size_in_tera_bytes: Optional[pulumi.Input[int]] = None,
                 passkey: Optional[pulumi.Input[str]] = None,
                 preferences: Optional[pulumi.Input['PreferencesArgs']] = None,
                 preferred_disks: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]] = None):
        """
        DataBox Disk Job Details.
        :param pulumi.Input['ContactDetailsArgs'] contact_details: Contact details for notification and shipping.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DestinationManagedDiskDetailsArgs', 'DestinationStorageAccountDetailsArgs']]]] destination_account_details: Destination account details.
        :param pulumi.Input[str] job_details_type: Indicates the type of job details.
               Expected value is 'DataBoxDisk'.
        :param pulumi.Input['ShippingAddressArgs'] shipping_address: Shipping address of the customer.
        :param pulumi.Input[int] expected_data_size_in_tera_bytes: The expected size of the data, which needs to be transferred in this job, in terabytes.
        :param pulumi.Input[str] passkey: User entered passkey for DataBox Disk job.
        :param pulumi.Input['PreferencesArgs'] preferences: Preferences for the order.
        :param pulumi.Input[Mapping[str, pulumi.Input[int]]] preferred_disks: User preference on what size disks are needed for the job. The map is from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but will be checked against an int.
        """
        pulumi.set(__self__, "contact_details", contact_details)
        pulumi.set(__self__, "destination_account_details", destination_account_details)
        pulumi.set(__self__, "job_details_type", 'DataBoxDisk')
        pulumi.set(__self__, "shipping_address", shipping_address)
        if expected_data_size_in_tera_bytes is not None:
            pulumi.set(__self__, "expected_data_size_in_tera_bytes", expected_data_size_in_tera_bytes)
        if passkey is not None:
            pulumi.set(__self__, "passkey", passkey)
        if preferences is not None:
            pulumi.set(__self__, "preferences", preferences)
        if preferred_disks is not None:
            pulumi.set(__self__, "preferred_disks", preferred_disks)

    @property
    @pulumi.getter(name="contactDetails")
    def contact_details(self) -> pulumi.Input['ContactDetailsArgs']:
        """
        Contact details for notification and shipping.
        """
        return pulumi.get(self, "contact_details")

    @contact_details.setter
    def contact_details(self, value: pulumi.Input['ContactDetailsArgs']):
        pulumi.set(self, "contact_details", value)

    @property
    @pulumi.getter(name="destinationAccountDetails")
    def destination_account_details(self) -> pulumi.Input[Sequence[pulumi.Input[Union['DestinationManagedDiskDetailsArgs', 'DestinationStorageAccountDetailsArgs']]]]:
        """
        Destination account details.
        """
        return pulumi.get(self, "destination_account_details")

    @destination_account_details.setter
    def destination_account_details(self, value: pulumi.Input[Sequence[pulumi.Input[Union['DestinationManagedDiskDetailsArgs', 'DestinationStorageAccountDetailsArgs']]]]):
        pulumi.set(self, "destination_account_details", value)

    @property
    @pulumi.getter(name="jobDetailsType")
    def job_details_type(self) -> pulumi.Input[str]:
        """
        Indicates the type of job details.
        Expected value is 'DataBoxDisk'.
        """
        return pulumi.get(self, "job_details_type")

    @job_details_type.setter
    def job_details_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_details_type", value)

    @property
    @pulumi.getter(name="shippingAddress")
    def shipping_address(self) -> pulumi.Input['ShippingAddressArgs']:
        """
        Shipping address of the customer.
        """
        return pulumi.get(self, "shipping_address")

    @shipping_address.setter
    def shipping_address(self, value: pulumi.Input['ShippingAddressArgs']):
        pulumi.set(self, "shipping_address", value)

    @property
    @pulumi.getter(name="expectedDataSizeInTeraBytes")
    def expected_data_size_in_tera_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The expected size of the data, which needs to be transferred in this job, in terabytes.
        """
        return pulumi.get(self, "expected_data_size_in_tera_bytes")

    @expected_data_size_in_tera_bytes.setter
    def expected_data_size_in_tera_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expected_data_size_in_tera_bytes", value)

    @property
    @pulumi.getter
    def passkey(self) -> Optional[pulumi.Input[str]]:
        """
        User entered passkey for DataBox Disk job.
        """
        return pulumi.get(self, "passkey")

    @passkey.setter
    def passkey(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "passkey", value)

    @property
    @pulumi.getter
    def preferences(self) -> Optional[pulumi.Input['PreferencesArgs']]:
        """
        Preferences for the order.
        """
        return pulumi.get(self, "preferences")

    @preferences.setter
    def preferences(self, value: Optional[pulumi.Input['PreferencesArgs']]):
        pulumi.set(self, "preferences", value)

    @property
    @pulumi.getter(name="preferredDisks")
    def preferred_disks(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]]:
        """
        User preference on what size disks are needed for the job. The map is from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but will be checked against an int.
        """
        return pulumi.get(self, "preferred_disks")

    @preferred_disks.setter
    def preferred_disks(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]]):
        pulumi.set(self, "preferred_disks", value)


@pulumi.input_type
class DataBoxHeavyJobDetailsArgs:
    def __init__(__self__, *,
                 contact_details: pulumi.Input['ContactDetailsArgs'],
                 destination_account_details: pulumi.Input[Sequence[pulumi.Input[Union['DestinationManagedDiskDetailsArgs', 'DestinationStorageAccountDetailsArgs']]]],
                 job_details_type: pulumi.Input[str],
                 shipping_address: pulumi.Input['ShippingAddressArgs'],
                 device_password: Optional[pulumi.Input[str]] = None,
                 expected_data_size_in_tera_bytes: Optional[pulumi.Input[int]] = None,
                 preferences: Optional[pulumi.Input['PreferencesArgs']] = None):
        """
        Databox Heavy Device Job Details
        :param pulumi.Input['ContactDetailsArgs'] contact_details: Contact details for notification and shipping.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DestinationManagedDiskDetailsArgs', 'DestinationStorageAccountDetailsArgs']]]] destination_account_details: Destination account details.
        :param pulumi.Input[str] job_details_type: Indicates the type of job details.
               Expected value is 'DataBoxHeavy'.
        :param pulumi.Input['ShippingAddressArgs'] shipping_address: Shipping address of the customer.
        :param pulumi.Input[str] device_password: Set Device password for unlocking Databox Heavy
        :param pulumi.Input[int] expected_data_size_in_tera_bytes: The expected size of the data, which needs to be transferred in this job, in terabytes.
        :param pulumi.Input['PreferencesArgs'] preferences: Preferences for the order.
        """
        pulumi.set(__self__, "contact_details", contact_details)
        pulumi.set(__self__, "destination_account_details", destination_account_details)
        pulumi.set(__self__, "job_details_type", 'DataBoxHeavy')
        pulumi.set(__self__, "shipping_address", shipping_address)
        if device_password is not None:
            pulumi.set(__self__, "device_password", device_password)
        if expected_data_size_in_tera_bytes is not None:
            pulumi.set(__self__, "expected_data_size_in_tera_bytes", expected_data_size_in_tera_bytes)
        if preferences is not None:
            pulumi.set(__self__, "preferences", preferences)

    @property
    @pulumi.getter(name="contactDetails")
    def contact_details(self) -> pulumi.Input['ContactDetailsArgs']:
        """
        Contact details for notification and shipping.
        """
        return pulumi.get(self, "contact_details")

    @contact_details.setter
    def contact_details(self, value: pulumi.Input['ContactDetailsArgs']):
        pulumi.set(self, "contact_details", value)

    @property
    @pulumi.getter(name="destinationAccountDetails")
    def destination_account_details(self) -> pulumi.Input[Sequence[pulumi.Input[Union['DestinationManagedDiskDetailsArgs', 'DestinationStorageAccountDetailsArgs']]]]:
        """
        Destination account details.
        """
        return pulumi.get(self, "destination_account_details")

    @destination_account_details.setter
    def destination_account_details(self, value: pulumi.Input[Sequence[pulumi.Input[Union['DestinationManagedDiskDetailsArgs', 'DestinationStorageAccountDetailsArgs']]]]):
        pulumi.set(self, "destination_account_details", value)

    @property
    @pulumi.getter(name="jobDetailsType")
    def job_details_type(self) -> pulumi.Input[str]:
        """
        Indicates the type of job details.
        Expected value is 'DataBoxHeavy'.
        """
        return pulumi.get(self, "job_details_type")

    @job_details_type.setter
    def job_details_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_details_type", value)

    @property
    @pulumi.getter(name="shippingAddress")
    def shipping_address(self) -> pulumi.Input['ShippingAddressArgs']:
        """
        Shipping address of the customer.
        """
        return pulumi.get(self, "shipping_address")

    @shipping_address.setter
    def shipping_address(self, value: pulumi.Input['ShippingAddressArgs']):
        pulumi.set(self, "shipping_address", value)

    @property
    @pulumi.getter(name="devicePassword")
    def device_password(self) -> Optional[pulumi.Input[str]]:
        """
        Set Device password for unlocking Databox Heavy
        """
        return pulumi.get(self, "device_password")

    @device_password.setter
    def device_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_password", value)

    @property
    @pulumi.getter(name="expectedDataSizeInTeraBytes")
    def expected_data_size_in_tera_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The expected size of the data, which needs to be transferred in this job, in terabytes.
        """
        return pulumi.get(self, "expected_data_size_in_tera_bytes")

    @expected_data_size_in_tera_bytes.setter
    def expected_data_size_in_tera_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expected_data_size_in_tera_bytes", value)

    @property
    @pulumi.getter
    def preferences(self) -> Optional[pulumi.Input['PreferencesArgs']]:
        """
        Preferences for the order.
        """
        return pulumi.get(self, "preferences")

    @preferences.setter
    def preferences(self, value: Optional[pulumi.Input['PreferencesArgs']]):
        pulumi.set(self, "preferences", value)


@pulumi.input_type
class DataBoxJobDetailsArgs:
    def __init__(__self__, *,
                 contact_details: pulumi.Input['ContactDetailsArgs'],
                 destination_account_details: pulumi.Input[Sequence[pulumi.Input[Union['DestinationManagedDiskDetailsArgs', 'DestinationStorageAccountDetailsArgs']]]],
                 job_details_type: pulumi.Input[str],
                 shipping_address: pulumi.Input['ShippingAddressArgs'],
                 device_password: Optional[pulumi.Input[str]] = None,
                 expected_data_size_in_tera_bytes: Optional[pulumi.Input[int]] = None,
                 preferences: Optional[pulumi.Input['PreferencesArgs']] = None):
        """
        Databox Job Details
        :param pulumi.Input['ContactDetailsArgs'] contact_details: Contact details for notification and shipping.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DestinationManagedDiskDetailsArgs', 'DestinationStorageAccountDetailsArgs']]]] destination_account_details: Destination account details.
        :param pulumi.Input[str] job_details_type: Indicates the type of job details.
               Expected value is 'DataBox'.
        :param pulumi.Input['ShippingAddressArgs'] shipping_address: Shipping address of the customer.
        :param pulumi.Input[str] device_password: Set Device password for unlocking Databox
        :param pulumi.Input[int] expected_data_size_in_tera_bytes: The expected size of the data, which needs to be transferred in this job, in terabytes.
        :param pulumi.Input['PreferencesArgs'] preferences: Preferences for the order.
        """
        pulumi.set(__self__, "contact_details", contact_details)
        pulumi.set(__self__, "destination_account_details", destination_account_details)
        pulumi.set(__self__, "job_details_type", 'DataBox')
        pulumi.set(__self__, "shipping_address", shipping_address)
        if device_password is not None:
            pulumi.set(__self__, "device_password", device_password)
        if expected_data_size_in_tera_bytes is not None:
            pulumi.set(__self__, "expected_data_size_in_tera_bytes", expected_data_size_in_tera_bytes)
        if preferences is not None:
            pulumi.set(__self__, "preferences", preferences)

    @property
    @pulumi.getter(name="contactDetails")
    def contact_details(self) -> pulumi.Input['ContactDetailsArgs']:
        """
        Contact details for notification and shipping.
        """
        return pulumi.get(self, "contact_details")

    @contact_details.setter
    def contact_details(self, value: pulumi.Input['ContactDetailsArgs']):
        pulumi.set(self, "contact_details", value)

    @property
    @pulumi.getter(name="destinationAccountDetails")
    def destination_account_details(self) -> pulumi.Input[Sequence[pulumi.Input[Union['DestinationManagedDiskDetailsArgs', 'DestinationStorageAccountDetailsArgs']]]]:
        """
        Destination account details.
        """
        return pulumi.get(self, "destination_account_details")

    @destination_account_details.setter
    def destination_account_details(self, value: pulumi.Input[Sequence[pulumi.Input[Union['DestinationManagedDiskDetailsArgs', 'DestinationStorageAccountDetailsArgs']]]]):
        pulumi.set(self, "destination_account_details", value)

    @property
    @pulumi.getter(name="jobDetailsType")
    def job_details_type(self) -> pulumi.Input[str]:
        """
        Indicates the type of job details.
        Expected value is 'DataBox'.
        """
        return pulumi.get(self, "job_details_type")

    @job_details_type.setter
    def job_details_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_details_type", value)

    @property
    @pulumi.getter(name="shippingAddress")
    def shipping_address(self) -> pulumi.Input['ShippingAddressArgs']:
        """
        Shipping address of the customer.
        """
        return pulumi.get(self, "shipping_address")

    @shipping_address.setter
    def shipping_address(self, value: pulumi.Input['ShippingAddressArgs']):
        pulumi.set(self, "shipping_address", value)

    @property
    @pulumi.getter(name="devicePassword")
    def device_password(self) -> Optional[pulumi.Input[str]]:
        """
        Set Device password for unlocking Databox
        """
        return pulumi.get(self, "device_password")

    @device_password.setter
    def device_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_password", value)

    @property
    @pulumi.getter(name="expectedDataSizeInTeraBytes")
    def expected_data_size_in_tera_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The expected size of the data, which needs to be transferred in this job, in terabytes.
        """
        return pulumi.get(self, "expected_data_size_in_tera_bytes")

    @expected_data_size_in_tera_bytes.setter
    def expected_data_size_in_tera_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expected_data_size_in_tera_bytes", value)

    @property
    @pulumi.getter
    def preferences(self) -> Optional[pulumi.Input['PreferencesArgs']]:
        """
        Preferences for the order.
        """
        return pulumi.get(self, "preferences")

    @preferences.setter
    def preferences(self, value: Optional[pulumi.Input['PreferencesArgs']]):
        pulumi.set(self, "preferences", value)


@pulumi.input_type
class DestinationManagedDiskDetailsArgs:
    def __init__(__self__, *,
                 data_destination_type: pulumi.Input[str],
                 resource_group_id: pulumi.Input[str],
                 staging_storage_account_id: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 share_password: Optional[pulumi.Input[str]] = None):
        """
        Details for the destination compute disks.
        :param pulumi.Input[str] data_destination_type: Data Destination Type.
               Expected value is 'ManagedDisk'.
        :param pulumi.Input[str] resource_group_id: Destination Resource Group Id where the Compute disks should be created.
        :param pulumi.Input[str] staging_storage_account_id: Arm Id of the storage account that can be used to copy the vhd for staging.
        :param pulumi.Input[str] account_id: Arm Id of the destination where the data has to be moved.
        :param pulumi.Input[str] share_password: Share password to be shared by all shares in SA.
        """
        pulumi.set(__self__, "data_destination_type", 'ManagedDisk')
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "staging_storage_account_id", staging_storage_account_id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if share_password is not None:
            pulumi.set(__self__, "share_password", share_password)

    @property
    @pulumi.getter(name="dataDestinationType")
    def data_destination_type(self) -> pulumi.Input[str]:
        """
        Data Destination Type.
        Expected value is 'ManagedDisk'.
        """
        return pulumi.get(self, "data_destination_type")

    @data_destination_type.setter
    def data_destination_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_destination_type", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Input[str]:
        """
        Destination Resource Group Id where the Compute disks should be created.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="stagingStorageAccountId")
    def staging_storage_account_id(self) -> pulumi.Input[str]:
        """
        Arm Id of the storage account that can be used to copy the vhd for staging.
        """
        return pulumi.get(self, "staging_storage_account_id")

    @staging_storage_account_id.setter
    def staging_storage_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "staging_storage_account_id", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Arm Id of the destination where the data has to be moved.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="sharePassword")
    def share_password(self) -> Optional[pulumi.Input[str]]:
        """
        Share password to be shared by all shares in SA.
        """
        return pulumi.get(self, "share_password")

    @share_password.setter
    def share_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "share_password", value)


@pulumi.input_type
class DestinationStorageAccountDetailsArgs:
    def __init__(__self__, *,
                 data_destination_type: pulumi.Input[str],
                 storage_account_id: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 share_password: Optional[pulumi.Input[str]] = None):
        """
        Details for the destination storage account.
        :param pulumi.Input[str] data_destination_type: Data Destination Type.
               Expected value is 'StorageAccount'.
        :param pulumi.Input[str] storage_account_id: Destination Storage Account Arm Id.
        :param pulumi.Input[str] account_id: Arm Id of the destination where the data has to be moved.
        :param pulumi.Input[str] share_password: Share password to be shared by all shares in SA.
        """
        pulumi.set(__self__, "data_destination_type", 'StorageAccount')
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if share_password is not None:
            pulumi.set(__self__, "share_password", share_password)

    @property
    @pulumi.getter(name="dataDestinationType")
    def data_destination_type(self) -> pulumi.Input[str]:
        """
        Data Destination Type.
        Expected value is 'StorageAccount'.
        """
        return pulumi.get(self, "data_destination_type")

    @data_destination_type.setter
    def data_destination_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_destination_type", value)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[str]:
        """
        Destination Storage Account Arm Id.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_account_id", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Arm Id of the destination where the data has to be moved.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="sharePassword")
    def share_password(self) -> Optional[pulumi.Input[str]]:
        """
        Share password to be shared by all shares in SA.
        """
        return pulumi.get(self, "share_password")

    @share_password.setter
    def share_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "share_password", value)


@pulumi.input_type
class JobDeliveryInfoArgs:
    def __init__(__self__, *,
                 scheduled_date_time: Optional[pulumi.Input[str]] = None):
        """
        Additional delivery info.
        :param pulumi.Input[str] scheduled_date_time: Scheduled date time.
        """
        if scheduled_date_time is not None:
            pulumi.set(__self__, "scheduled_date_time", scheduled_date_time)

    @property
    @pulumi.getter(name="scheduledDateTime")
    def scheduled_date_time(self) -> Optional[pulumi.Input[str]]:
        """
        Scheduled date time.
        """
        return pulumi.get(self, "scheduled_date_time")

    @scheduled_date_time.setter
    def scheduled_date_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduled_date_time", value)


@pulumi.input_type
class NotificationPreferenceArgs:
    def __init__(__self__, *,
                 send_notification: pulumi.Input[bool],
                 stage_name: pulumi.Input[Union[str, 'NotificationStageName']]):
        """
        Notification preference for a job stage.
        :param pulumi.Input[bool] send_notification: Notification is required or not.
        :param pulumi.Input[Union[str, 'NotificationStageName']] stage_name: Name of the stage.
        """
        if send_notification is None:
            send_notification = True
        pulumi.set(__self__, "send_notification", send_notification)
        pulumi.set(__self__, "stage_name", stage_name)

    @property
    @pulumi.getter(name="sendNotification")
    def send_notification(self) -> pulumi.Input[bool]:
        """
        Notification is required or not.
        """
        return pulumi.get(self, "send_notification")

    @send_notification.setter
    def send_notification(self, value: pulumi.Input[bool]):
        pulumi.set(self, "send_notification", value)

    @property
    @pulumi.getter(name="stageName")
    def stage_name(self) -> pulumi.Input[Union[str, 'NotificationStageName']]:
        """
        Name of the stage.
        """
        return pulumi.get(self, "stage_name")

    @stage_name.setter
    def stage_name(self, value: pulumi.Input[Union[str, 'NotificationStageName']]):
        pulumi.set(self, "stage_name", value)


@pulumi.input_type
class PreferencesArgs:
    def __init__(__self__, *,
                 preferred_data_center_region: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transport_preferences: Optional[pulumi.Input['TransportPreferencesArgs']] = None):
        """
        Preferences related to the order
        :param pulumi.Input[Sequence[pulumi.Input[str]]] preferred_data_center_region: Preferred Data Center Region.
        :param pulumi.Input['TransportPreferencesArgs'] transport_preferences: Preferences related to the shipment logistics of the sku.
        """
        if preferred_data_center_region is not None:
            pulumi.set(__self__, "preferred_data_center_region", preferred_data_center_region)
        if transport_preferences is not None:
            pulumi.set(__self__, "transport_preferences", transport_preferences)

    @property
    @pulumi.getter(name="preferredDataCenterRegion")
    def preferred_data_center_region(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Preferred Data Center Region.
        """
        return pulumi.get(self, "preferred_data_center_region")

    @preferred_data_center_region.setter
    def preferred_data_center_region(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "preferred_data_center_region", value)

    @property
    @pulumi.getter(name="transportPreferences")
    def transport_preferences(self) -> Optional[pulumi.Input['TransportPreferencesArgs']]:
        """
        Preferences related to the shipment logistics of the sku.
        """
        return pulumi.get(self, "transport_preferences")

    @transport_preferences.setter
    def transport_preferences(self, value: Optional[pulumi.Input['TransportPreferencesArgs']]):
        pulumi.set(self, "transport_preferences", value)


@pulumi.input_type
class ShippingAddressArgs:
    def __init__(__self__, *,
                 country: pulumi.Input[str],
                 postal_code: pulumi.Input[str],
                 street_address1: pulumi.Input[str],
                 address_type: Optional[pulumi.Input[Union[str, 'AddressType']]] = None,
                 city: Optional[pulumi.Input[str]] = None,
                 company_name: Optional[pulumi.Input[str]] = None,
                 state_or_province: Optional[pulumi.Input[str]] = None,
                 street_address2: Optional[pulumi.Input[str]] = None,
                 street_address3: Optional[pulumi.Input[str]] = None,
                 zip_extended_code: Optional[pulumi.Input[str]] = None):
        """
        Shipping address where customer wishes to receive the device.
        :param pulumi.Input[str] country: Name of the Country.
        :param pulumi.Input[str] postal_code: Postal code.
        :param pulumi.Input[str] street_address1: Street Address line 1.
        :param pulumi.Input[Union[str, 'AddressType']] address_type: Type of address.
        :param pulumi.Input[str] city: Name of the City.
        :param pulumi.Input[str] company_name: Name of the company.
        :param pulumi.Input[str] state_or_province: Name of the State or Province.
        :param pulumi.Input[str] street_address2: Street Address line 2.
        :param pulumi.Input[str] street_address3: Street Address line 3.
        :param pulumi.Input[str] zip_extended_code: Extended Zip Code.
        """
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "postal_code", postal_code)
        pulumi.set(__self__, "street_address1", street_address1)
        if address_type is None:
            address_type = 'None'
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)
        if state_or_province is not None:
            pulumi.set(__self__, "state_or_province", state_or_province)
        if street_address2 is not None:
            pulumi.set(__self__, "street_address2", street_address2)
        if street_address3 is not None:
            pulumi.set(__self__, "street_address3", street_address3)
        if zip_extended_code is not None:
            pulumi.set(__self__, "zip_extended_code", zip_extended_code)

    @property
    @pulumi.getter
    def country(self) -> pulumi.Input[str]:
        """
        Name of the Country.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: pulumi.Input[str]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> pulumi.Input[str]:
        """
        Postal code.
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "postal_code", value)

    @property
    @pulumi.getter(name="streetAddress1")
    def street_address1(self) -> pulumi.Input[str]:
        """
        Street Address line 1.
        """
        return pulumi.get(self, "street_address1")

    @street_address1.setter
    def street_address1(self, value: pulumi.Input[str]):
        pulumi.set(self, "street_address1", value)

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[Union[str, 'AddressType']]]:
        """
        Type of address.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[Union[str, 'AddressType']]]):
        pulumi.set(self, "address_type", value)

    @property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the City.
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "city", value)

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the company.
        """
        return pulumi.get(self, "company_name")

    @company_name.setter
    def company_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "company_name", value)

    @property
    @pulumi.getter(name="stateOrProvince")
    def state_or_province(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the State or Province.
        """
        return pulumi.get(self, "state_or_province")

    @state_or_province.setter
    def state_or_province(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state_or_province", value)

    @property
    @pulumi.getter(name="streetAddress2")
    def street_address2(self) -> Optional[pulumi.Input[str]]:
        """
        Street Address line 2.
        """
        return pulumi.get(self, "street_address2")

    @street_address2.setter
    def street_address2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "street_address2", value)

    @property
    @pulumi.getter(name="streetAddress3")
    def street_address3(self) -> Optional[pulumi.Input[str]]:
        """
        Street Address line 3.
        """
        return pulumi.get(self, "street_address3")

    @street_address3.setter
    def street_address3(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "street_address3", value)

    @property
    @pulumi.getter(name="zipExtendedCode")
    def zip_extended_code(self) -> Optional[pulumi.Input[str]]:
        """
        Extended Zip Code.
        """
        return pulumi.get(self, "zip_extended_code")

    @zip_extended_code.setter
    def zip_extended_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zip_extended_code", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'SkuName']],
                 display_name: Optional[pulumi.Input[str]] = None,
                 family: Optional[pulumi.Input[str]] = None):
        """
        The Sku.
        :param pulumi.Input[Union[str, 'SkuName']] name: The sku name.
        :param pulumi.Input[str] display_name: The display name of the sku.
        :param pulumi.Input[str] family: The sku family.
        """
        pulumi.set(__self__, "name", name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if family is not None:
            pulumi.set(__self__, "family", family)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'SkuName']]:
        """
        The sku name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'SkuName']]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the sku.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        The sku family.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)


@pulumi.input_type
class TransportPreferencesArgs:
    def __init__(__self__, *,
                 preferred_shipment_type: pulumi.Input[Union[str, 'TransportShipmentTypes']]):
        """
        Preferences related to the shipment logistics of the sku
        :param pulumi.Input[Union[str, 'TransportShipmentTypes']] preferred_shipment_type: Indicates Shipment Logistics type that the customer preferred.
        """
        pulumi.set(__self__, "preferred_shipment_type", preferred_shipment_type)

    @property
    @pulumi.getter(name="preferredShipmentType")
    def preferred_shipment_type(self) -> pulumi.Input[Union[str, 'TransportShipmentTypes']]:
        """
        Indicates Shipment Logistics type that the customer preferred.
        """
        return pulumi.get(self, "preferred_shipment_type")

    @preferred_shipment_type.setter
    def preferred_shipment_type(self, value: pulumi.Input[Union[str, 'TransportShipmentTypes']]):
        pulumi.set(self, "preferred_shipment_type", value)


