# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AssignmentPrincipalArgs',
    'ConnectorMappingAvailabilityArgs',
    'ConnectorMappingCompleteOperationArgs',
    'ConnectorMappingErrorManagementArgs',
    'ConnectorMappingFormatArgs',
    'ConnectorMappingPropertiesArgs',
    'ConnectorMappingStructureArgs',
    'HubBillingInfoFormatArgs',
    'KpiAliasArgs',
    'KpiExtractArgs',
    'KpiThresholdsArgs',
    'ParticipantProfilePropertyReferenceArgs',
    'ParticipantPropertyReferenceArgs',
    'PredictionGradesArgs',
    'PredictionMappingsArgs',
    'ProfileEnumValidValuesFormatArgs',
    'PropertyDefinitionArgs',
    'RelationshipLinkFieldMappingArgs',
    'RelationshipTypeFieldMappingArgs',
    'RelationshipTypeMappingArgs',
    'ResourceSetDescriptionArgs',
    'StrongIdArgs',
    'TypePropertiesMappingArgs',
]

@pulumi.input_type
class AssignmentPrincipalArgs:
    def __init__(__self__, *,
                 principal_id: pulumi.Input[str],
                 principal_type: pulumi.Input[str],
                 principal_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The AssignmentPrincipal
        :param pulumi.Input[str] principal_id: The principal id being assigned to.
        :param pulumi.Input[str] principal_type: The Type of the principal ID.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] principal_metadata: Other metadata for the principal.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_type", principal_type)
        if principal_metadata is not None:
            pulumi.set(__self__, "principal_metadata", principal_metadata)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[str]:
        """
        The principal id being assigned to.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Input[str]:
        """
        The Type of the principal ID.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal_type", value)

    @property
    @pulumi.getter(name="principalMetadata")
    def principal_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Other metadata for the principal.
        """
        return pulumi.get(self, "principal_metadata")

    @principal_metadata.setter
    def principal_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "principal_metadata", value)


@pulumi.input_type
class ConnectorMappingAvailabilityArgs:
    def __init__(__self__, *,
                 interval: pulumi.Input[int],
                 frequency: Optional[pulumi.Input['FrequencyTypes']] = None):
        """
        Connector mapping property availability.
        :param pulumi.Input[int] interval: The interval of the given frequency to use.
        :param pulumi.Input['FrequencyTypes'] frequency: The frequency to update.
        """
        pulumi.set(__self__, "interval", interval)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Input[int]:
        """
        The interval of the given frequency to use.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: pulumi.Input[int]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input['FrequencyTypes']]:
        """
        The frequency to update.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input['FrequencyTypes']]):
        pulumi.set(self, "frequency", value)


@pulumi.input_type
class ConnectorMappingCompleteOperationArgs:
    def __init__(__self__, *,
                 completion_operation_type: Optional[pulumi.Input['CompletionOperationTypes']] = None,
                 destination_folder: Optional[pulumi.Input[str]] = None):
        """
        The complete operation.
        :param pulumi.Input['CompletionOperationTypes'] completion_operation_type: The type of completion operation.
        :param pulumi.Input[str] destination_folder: The destination folder where files will be moved to once the import is done.
        """
        if completion_operation_type is not None:
            pulumi.set(__self__, "completion_operation_type", completion_operation_type)
        if destination_folder is not None:
            pulumi.set(__self__, "destination_folder", destination_folder)

    @property
    @pulumi.getter(name="completionOperationType")
    def completion_operation_type(self) -> Optional[pulumi.Input['CompletionOperationTypes']]:
        """
        The type of completion operation.
        """
        return pulumi.get(self, "completion_operation_type")

    @completion_operation_type.setter
    def completion_operation_type(self, value: Optional[pulumi.Input['CompletionOperationTypes']]):
        pulumi.set(self, "completion_operation_type", value)

    @property
    @pulumi.getter(name="destinationFolder")
    def destination_folder(self) -> Optional[pulumi.Input[str]]:
        """
        The destination folder where files will be moved to once the import is done.
        """
        return pulumi.get(self, "destination_folder")

    @destination_folder.setter
    def destination_folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_folder", value)


@pulumi.input_type
class ConnectorMappingErrorManagementArgs:
    def __init__(__self__, *,
                 error_management_type: pulumi.Input['ErrorManagementTypes'],
                 error_limit: Optional[pulumi.Input[int]] = None):
        """
        The error management.
        :param pulumi.Input['ErrorManagementTypes'] error_management_type: The type of error management to use for the mapping.
        :param pulumi.Input[int] error_limit: The error limit allowed while importing data.
        """
        pulumi.set(__self__, "error_management_type", error_management_type)
        if error_limit is not None:
            pulumi.set(__self__, "error_limit", error_limit)

    @property
    @pulumi.getter(name="errorManagementType")
    def error_management_type(self) -> pulumi.Input['ErrorManagementTypes']:
        """
        The type of error management to use for the mapping.
        """
        return pulumi.get(self, "error_management_type")

    @error_management_type.setter
    def error_management_type(self, value: pulumi.Input['ErrorManagementTypes']):
        pulumi.set(self, "error_management_type", value)

    @property
    @pulumi.getter(name="errorLimit")
    def error_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The error limit allowed while importing data.
        """
        return pulumi.get(self, "error_limit")

    @error_limit.setter
    def error_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "error_limit", value)


@pulumi.input_type
class ConnectorMappingFormatArgs:
    def __init__(__self__, *,
                 format_type: pulumi.Input['FormatTypes'],
                 accept_language: Optional[pulumi.Input[str]] = None,
                 array_separator: Optional[pulumi.Input[str]] = None,
                 column_delimiter: Optional[pulumi.Input[str]] = None,
                 quote_character: Optional[pulumi.Input[str]] = None,
                 quote_escape_character: Optional[pulumi.Input[str]] = None):
        """
        Connector mapping property format.
        :param pulumi.Input['FormatTypes'] format_type: The type mapping format.
        :param pulumi.Input[str] accept_language: The oData language.
        :param pulumi.Input[str] array_separator: Character separating array elements.
        :param pulumi.Input[str] column_delimiter: The character that signifies a break between columns.
        :param pulumi.Input[str] quote_character: Quote character, used to indicate enquoted fields.
        :param pulumi.Input[str] quote_escape_character: Escape character for quotes, can be the same as the quoteCharacter.
        """
        pulumi.set(__self__, "format_type", format_type)
        if accept_language is not None:
            pulumi.set(__self__, "accept_language", accept_language)
        if array_separator is not None:
            pulumi.set(__self__, "array_separator", array_separator)
        if column_delimiter is not None:
            pulumi.set(__self__, "column_delimiter", column_delimiter)
        if quote_character is not None:
            pulumi.set(__self__, "quote_character", quote_character)
        if quote_escape_character is not None:
            pulumi.set(__self__, "quote_escape_character", quote_escape_character)

    @property
    @pulumi.getter(name="formatType")
    def format_type(self) -> pulumi.Input['FormatTypes']:
        """
        The type mapping format.
        """
        return pulumi.get(self, "format_type")

    @format_type.setter
    def format_type(self, value: pulumi.Input['FormatTypes']):
        pulumi.set(self, "format_type", value)

    @property
    @pulumi.getter(name="acceptLanguage")
    def accept_language(self) -> Optional[pulumi.Input[str]]:
        """
        The oData language.
        """
        return pulumi.get(self, "accept_language")

    @accept_language.setter
    def accept_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accept_language", value)

    @property
    @pulumi.getter(name="arraySeparator")
    def array_separator(self) -> Optional[pulumi.Input[str]]:
        """
        Character separating array elements.
        """
        return pulumi.get(self, "array_separator")

    @array_separator.setter
    def array_separator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "array_separator", value)

    @property
    @pulumi.getter(name="columnDelimiter")
    def column_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        The character that signifies a break between columns.
        """
        return pulumi.get(self, "column_delimiter")

    @column_delimiter.setter
    def column_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "column_delimiter", value)

    @property
    @pulumi.getter(name="quoteCharacter")
    def quote_character(self) -> Optional[pulumi.Input[str]]:
        """
        Quote character, used to indicate enquoted fields.
        """
        return pulumi.get(self, "quote_character")

    @quote_character.setter
    def quote_character(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quote_character", value)

    @property
    @pulumi.getter(name="quoteEscapeCharacter")
    def quote_escape_character(self) -> Optional[pulumi.Input[str]]:
        """
        Escape character for quotes, can be the same as the quoteCharacter.
        """
        return pulumi.get(self, "quote_escape_character")

    @quote_escape_character.setter
    def quote_escape_character(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quote_escape_character", value)


@pulumi.input_type
class ConnectorMappingPropertiesArgs:
    def __init__(__self__, *,
                 availability: pulumi.Input['ConnectorMappingAvailabilityArgs'],
                 complete_operation: pulumi.Input['ConnectorMappingCompleteOperationArgs'],
                 error_management: pulumi.Input['ConnectorMappingErrorManagementArgs'],
                 format: pulumi.Input['ConnectorMappingFormatArgs'],
                 structure: pulumi.Input[Sequence[pulumi.Input['ConnectorMappingStructureArgs']]],
                 file_filter: Optional[pulumi.Input[str]] = None,
                 folder_path: Optional[pulumi.Input[str]] = None,
                 has_header: Optional[pulumi.Input[bool]] = None):
        """
        The connector mapping properties.
        :param pulumi.Input['ConnectorMappingAvailabilityArgs'] availability: The availability of mapping property.
        :param pulumi.Input['ConnectorMappingCompleteOperationArgs'] complete_operation: The operation after import is done.
        :param pulumi.Input['ConnectorMappingErrorManagementArgs'] error_management: The error management setting for the mapping.
        :param pulumi.Input['ConnectorMappingFormatArgs'] format: The format of mapping property.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectorMappingStructureArgs']]] structure: Ingestion mapping information at property level.
        :param pulumi.Input[str] file_filter: The file filter for the mapping.
        :param pulumi.Input[str] folder_path: The folder path for the mapping.
        :param pulumi.Input[bool] has_header: If the file contains a header or not.
        """
        pulumi.set(__self__, "availability", availability)
        pulumi.set(__self__, "complete_operation", complete_operation)
        pulumi.set(__self__, "error_management", error_management)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "structure", structure)
        if file_filter is not None:
            pulumi.set(__self__, "file_filter", file_filter)
        if folder_path is not None:
            pulumi.set(__self__, "folder_path", folder_path)
        if has_header is not None:
            pulumi.set(__self__, "has_header", has_header)

    @property
    @pulumi.getter
    def availability(self) -> pulumi.Input['ConnectorMappingAvailabilityArgs']:
        """
        The availability of mapping property.
        """
        return pulumi.get(self, "availability")

    @availability.setter
    def availability(self, value: pulumi.Input['ConnectorMappingAvailabilityArgs']):
        pulumi.set(self, "availability", value)

    @property
    @pulumi.getter(name="completeOperation")
    def complete_operation(self) -> pulumi.Input['ConnectorMappingCompleteOperationArgs']:
        """
        The operation after import is done.
        """
        return pulumi.get(self, "complete_operation")

    @complete_operation.setter
    def complete_operation(self, value: pulumi.Input['ConnectorMappingCompleteOperationArgs']):
        pulumi.set(self, "complete_operation", value)

    @property
    @pulumi.getter(name="errorManagement")
    def error_management(self) -> pulumi.Input['ConnectorMappingErrorManagementArgs']:
        """
        The error management setting for the mapping.
        """
        return pulumi.get(self, "error_management")

    @error_management.setter
    def error_management(self, value: pulumi.Input['ConnectorMappingErrorManagementArgs']):
        pulumi.set(self, "error_management", value)

    @property
    @pulumi.getter
    def format(self) -> pulumi.Input['ConnectorMappingFormatArgs']:
        """
        The format of mapping property.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input['ConnectorMappingFormatArgs']):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def structure(self) -> pulumi.Input[Sequence[pulumi.Input['ConnectorMappingStructureArgs']]]:
        """
        Ingestion mapping information at property level.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: pulumi.Input[Sequence[pulumi.Input['ConnectorMappingStructureArgs']]]):
        pulumi.set(self, "structure", value)

    @property
    @pulumi.getter(name="fileFilter")
    def file_filter(self) -> Optional[pulumi.Input[str]]:
        """
        The file filter for the mapping.
        """
        return pulumi.get(self, "file_filter")

    @file_filter.setter
    def file_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_filter", value)

    @property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> Optional[pulumi.Input[str]]:
        """
        The folder path for the mapping.
        """
        return pulumi.get(self, "folder_path")

    @folder_path.setter
    def folder_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_path", value)

    @property
    @pulumi.getter(name="hasHeader")
    def has_header(self) -> Optional[pulumi.Input[bool]]:
        """
        If the file contains a header or not.
        """
        return pulumi.get(self, "has_header")

    @has_header.setter
    def has_header(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_header", value)


@pulumi.input_type
class ConnectorMappingStructureArgs:
    def __init__(__self__, *,
                 column_name: pulumi.Input[str],
                 property_name: pulumi.Input[str],
                 custom_format_specifier: Optional[pulumi.Input[str]] = None,
                 is_encrypted: Optional[pulumi.Input[bool]] = None):
        """
        Connector mapping property structure.
        :param pulumi.Input[str] column_name: The column name of the import file.
        :param pulumi.Input[str] property_name: The property name of the mapping entity.
        :param pulumi.Input[str] custom_format_specifier: Custom format specifier for input parsing.
        :param pulumi.Input[bool] is_encrypted: Indicates if the column is encrypted.
        """
        pulumi.set(__self__, "column_name", column_name)
        pulumi.set(__self__, "property_name", property_name)
        if custom_format_specifier is not None:
            pulumi.set(__self__, "custom_format_specifier", custom_format_specifier)
        if is_encrypted is not None:
            pulumi.set(__self__, "is_encrypted", is_encrypted)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> pulumi.Input[str]:
        """
        The column name of the import file.
        """
        return pulumi.get(self, "column_name")

    @column_name.setter
    def column_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "column_name", value)

    @property
    @pulumi.getter(name="propertyName")
    def property_name(self) -> pulumi.Input[str]:
        """
        The property name of the mapping entity.
        """
        return pulumi.get(self, "property_name")

    @property_name.setter
    def property_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "property_name", value)

    @property
    @pulumi.getter(name="customFormatSpecifier")
    def custom_format_specifier(self) -> Optional[pulumi.Input[str]]:
        """
        Custom format specifier for input parsing.
        """
        return pulumi.get(self, "custom_format_specifier")

    @custom_format_specifier.setter
    def custom_format_specifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_format_specifier", value)

    @property
    @pulumi.getter(name="isEncrypted")
    def is_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the column is encrypted.
        """
        return pulumi.get(self, "is_encrypted")

    @is_encrypted.setter
    def is_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_encrypted", value)


@pulumi.input_type
class HubBillingInfoFormatArgs:
    def __init__(__self__, *,
                 max_units: Optional[pulumi.Input[int]] = None,
                 min_units: Optional[pulumi.Input[int]] = None,
                 sku_name: Optional[pulumi.Input[str]] = None):
        """
        Hub billing info.
        :param pulumi.Input[int] max_units: The maximum number of units can be used.  One unit is 10,000 Profiles and 100,000 Interactions.
        :param pulumi.Input[int] min_units: The minimum number of units will be billed. One unit is 10,000 Profiles and 100,000 Interactions.
        :param pulumi.Input[str] sku_name: The sku name.
        """
        if max_units is not None:
            pulumi.set(__self__, "max_units", max_units)
        if min_units is not None:
            pulumi.set(__self__, "min_units", min_units)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)

    @property
    @pulumi.getter(name="maxUnits")
    def max_units(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of units can be used.  One unit is 10,000 Profiles and 100,000 Interactions.
        """
        return pulumi.get(self, "max_units")

    @max_units.setter
    def max_units(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_units", value)

    @property
    @pulumi.getter(name="minUnits")
    def min_units(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of units will be billed. One unit is 10,000 Profiles and 100,000 Interactions.
        """
        return pulumi.get(self, "min_units")

    @min_units.setter
    def min_units(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_units", value)

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[str]]:
        """
        The sku name.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sku_name", value)


@pulumi.input_type
class KpiAliasArgs:
    def __init__(__self__, *,
                 alias_name: pulumi.Input[str],
                 expression: pulumi.Input[str]):
        """
        The KPI alias.
        :param pulumi.Input[str] alias_name: KPI alias name.
        :param pulumi.Input[str] expression: The expression.
        """
        pulumi.set(__self__, "alias_name", alias_name)
        pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter(name="aliasName")
    def alias_name(self) -> pulumi.Input[str]:
        """
        KPI alias name.
        """
        return pulumi.get(self, "alias_name")

    @alias_name.setter
    def alias_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "alias_name", value)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        """
        The expression.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)


@pulumi.input_type
class KpiExtractArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 extract_name: pulumi.Input[str]):
        """
        The KPI extract.
        :param pulumi.Input[str] expression: The expression.
        :param pulumi.Input[str] extract_name: KPI extract name.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "extract_name", extract_name)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        """
        The expression.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter(name="extractName")
    def extract_name(self) -> pulumi.Input[str]:
        """
        KPI extract name.
        """
        return pulumi.get(self, "extract_name")

    @extract_name.setter
    def extract_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "extract_name", value)


@pulumi.input_type
class KpiThresholdsArgs:
    def __init__(__self__, *,
                 increasing_kpi: pulumi.Input[bool],
                 lower_limit: pulumi.Input[float],
                 upper_limit: pulumi.Input[float]):
        """
        Defines the KPI Threshold limits.
        :param pulumi.Input[bool] increasing_kpi: Whether or not the KPI is an increasing KPI.
        :param pulumi.Input[float] lower_limit: The lower threshold limit.
        :param pulumi.Input[float] upper_limit: The upper threshold limit.
        """
        pulumi.set(__self__, "increasing_kpi", increasing_kpi)
        pulumi.set(__self__, "lower_limit", lower_limit)
        pulumi.set(__self__, "upper_limit", upper_limit)

    @property
    @pulumi.getter(name="increasingKpi")
    def increasing_kpi(self) -> pulumi.Input[bool]:
        """
        Whether or not the KPI is an increasing KPI.
        """
        return pulumi.get(self, "increasing_kpi")

    @increasing_kpi.setter
    def increasing_kpi(self, value: pulumi.Input[bool]):
        pulumi.set(self, "increasing_kpi", value)

    @property
    @pulumi.getter(name="lowerLimit")
    def lower_limit(self) -> pulumi.Input[float]:
        """
        The lower threshold limit.
        """
        return pulumi.get(self, "lower_limit")

    @lower_limit.setter
    def lower_limit(self, value: pulumi.Input[float]):
        pulumi.set(self, "lower_limit", value)

    @property
    @pulumi.getter(name="upperLimit")
    def upper_limit(self) -> pulumi.Input[float]:
        """
        The upper threshold limit.
        """
        return pulumi.get(self, "upper_limit")

    @upper_limit.setter
    def upper_limit(self, value: pulumi.Input[float]):
        pulumi.set(self, "upper_limit", value)


@pulumi.input_type
class ParticipantProfilePropertyReferenceArgs:
    def __init__(__self__, *,
                 interaction_property_name: pulumi.Input[str],
                 profile_property_name: pulumi.Input[str]):
        """
        The participant profile property reference.
        :param pulumi.Input[str] interaction_property_name: The source interaction property that maps to the target profile property.
        :param pulumi.Input[str] profile_property_name: The target profile property that maps to the source interaction property.
        """
        pulumi.set(__self__, "interaction_property_name", interaction_property_name)
        pulumi.set(__self__, "profile_property_name", profile_property_name)

    @property
    @pulumi.getter(name="interactionPropertyName")
    def interaction_property_name(self) -> pulumi.Input[str]:
        """
        The source interaction property that maps to the target profile property.
        """
        return pulumi.get(self, "interaction_property_name")

    @interaction_property_name.setter
    def interaction_property_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "interaction_property_name", value)

    @property
    @pulumi.getter(name="profilePropertyName")
    def profile_property_name(self) -> pulumi.Input[str]:
        """
        The target profile property that maps to the source interaction property.
        """
        return pulumi.get(self, "profile_property_name")

    @profile_property_name.setter
    def profile_property_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "profile_property_name", value)


@pulumi.input_type
class ParticipantPropertyReferenceArgs:
    def __init__(__self__, *,
                 source_property_name: pulumi.Input[str],
                 target_property_name: pulumi.Input[str]):
        """
        The participant property reference.
        :param pulumi.Input[str] source_property_name: The source property that maps to the target property.
        :param pulumi.Input[str] target_property_name: The target property that maps to the source property.
        """
        pulumi.set(__self__, "source_property_name", source_property_name)
        pulumi.set(__self__, "target_property_name", target_property_name)

    @property
    @pulumi.getter(name="sourcePropertyName")
    def source_property_name(self) -> pulumi.Input[str]:
        """
        The source property that maps to the target property.
        """
        return pulumi.get(self, "source_property_name")

    @source_property_name.setter
    def source_property_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_property_name", value)

    @property
    @pulumi.getter(name="targetPropertyName")
    def target_property_name(self) -> pulumi.Input[str]:
        """
        The target property that maps to the source property.
        """
        return pulumi.get(self, "target_property_name")

    @target_property_name.setter
    def target_property_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_property_name", value)


@pulumi.input_type
class PredictionGradesArgs:
    def __init__(__self__, *,
                 grade_name: Optional[pulumi.Input[str]] = None,
                 max_score_threshold: Optional[pulumi.Input[int]] = None,
                 min_score_threshold: Optional[pulumi.Input[int]] = None):
        """
        The definition of a prediction grade.
        :param pulumi.Input[str] grade_name: Name of the grade.
        :param pulumi.Input[int] max_score_threshold: Maximum score threshold.
        :param pulumi.Input[int] min_score_threshold: Minimum score threshold.
        """
        if grade_name is not None:
            pulumi.set(__self__, "grade_name", grade_name)
        if max_score_threshold is not None:
            pulumi.set(__self__, "max_score_threshold", max_score_threshold)
        if min_score_threshold is not None:
            pulumi.set(__self__, "min_score_threshold", min_score_threshold)

    @property
    @pulumi.getter(name="gradeName")
    def grade_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the grade.
        """
        return pulumi.get(self, "grade_name")

    @grade_name.setter
    def grade_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grade_name", value)

    @property
    @pulumi.getter(name="maxScoreThreshold")
    def max_score_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum score threshold.
        """
        return pulumi.get(self, "max_score_threshold")

    @max_score_threshold.setter
    def max_score_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_score_threshold", value)

    @property
    @pulumi.getter(name="minScoreThreshold")
    def min_score_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum score threshold.
        """
        return pulumi.get(self, "min_score_threshold")

    @min_score_threshold.setter
    def min_score_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_score_threshold", value)


@pulumi.input_type
class PredictionMappingsArgs:
    def __init__(__self__, *,
                 grade: pulumi.Input[str],
                 reason: pulumi.Input[str],
                 score: pulumi.Input[str]):
        """
        Definition of the link mapping of prediction.
        :param pulumi.Input[str] grade: The grade of the link mapping.
        :param pulumi.Input[str] reason: The reason of the link mapping.
        :param pulumi.Input[str] score: The score of the link mapping.
        """
        pulumi.set(__self__, "grade", grade)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "score", score)

    @property
    @pulumi.getter
    def grade(self) -> pulumi.Input[str]:
        """
        The grade of the link mapping.
        """
        return pulumi.get(self, "grade")

    @grade.setter
    def grade(self, value: pulumi.Input[str]):
        pulumi.set(self, "grade", value)

    @property
    @pulumi.getter
    def reason(self) -> pulumi.Input[str]:
        """
        The reason of the link mapping.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: pulumi.Input[str]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def score(self) -> pulumi.Input[str]:
        """
        The score of the link mapping.
        """
        return pulumi.get(self, "score")

    @score.setter
    def score(self, value: pulumi.Input[str]):
        pulumi.set(self, "score", value)


@pulumi.input_type
class ProfileEnumValidValuesFormatArgs:
    def __init__(__self__, *,
                 localized_value_names: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 value: Optional[pulumi.Input[int]] = None):
        """
        Valid enum values in case of an enum property.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] localized_value_names: Localized names of the enum member.
        :param pulumi.Input[int] value: The integer value of the enum member.
        """
        if localized_value_names is not None:
            pulumi.set(__self__, "localized_value_names", localized_value_names)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="localizedValueNames")
    def localized_value_names(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Localized names of the enum member.
        """
        return pulumi.get(self, "localized_value_names")

    @localized_value_names.setter
    def localized_value_names(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "localized_value_names", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[int]]:
        """
        The integer value of the enum member.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class PropertyDefinitionArgs:
    def __init__(__self__, *,
                 field_name: pulumi.Input[str],
                 field_type: pulumi.Input[str],
                 array_value_separator: Optional[pulumi.Input[str]] = None,
                 enum_valid_values: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileEnumValidValuesFormatArgs']]]] = None,
                 is_array: Optional[pulumi.Input[bool]] = None,
                 is_available_in_graph: Optional[pulumi.Input[bool]] = None,
                 is_enum: Optional[pulumi.Input[bool]] = None,
                 is_flag_enum: Optional[pulumi.Input[bool]] = None,
                 is_image: Optional[pulumi.Input[bool]] = None,
                 is_localized_string: Optional[pulumi.Input[bool]] = None,
                 is_name: Optional[pulumi.Input[bool]] = None,
                 is_required: Optional[pulumi.Input[bool]] = None,
                 max_length: Optional[pulumi.Input[int]] = None,
                 property_id: Optional[pulumi.Input[str]] = None,
                 schema_item_prop_link: Optional[pulumi.Input[str]] = None):
        """
        Property definition.
        :param pulumi.Input[str] field_name: Name of the property.
        :param pulumi.Input[str] field_type: Type of the property.
        :param pulumi.Input[str] array_value_separator: Array value separator for properties with isArray set.
        :param pulumi.Input[Sequence[pulumi.Input['ProfileEnumValidValuesFormatArgs']]] enum_valid_values: Describes valid values for an enum property.
        :param pulumi.Input[bool] is_array: Indicates if the property is actually an array of the fieldType above on the data api.
        :param pulumi.Input[bool] is_available_in_graph: Whether property is available in graph or not.
        :param pulumi.Input[bool] is_enum: Indicates if the property is an enum.
        :param pulumi.Input[bool] is_flag_enum: Indicates if the property is an flag enum.
        :param pulumi.Input[bool] is_image: Whether the property is an Image.
        :param pulumi.Input[bool] is_localized_string: Whether the property is a localized string.
        :param pulumi.Input[bool] is_name: Whether the property is a name or a part of name.
        :param pulumi.Input[bool] is_required: Whether property value is required on instances, IsRequired field only for Interaction. Profile Instance will not check for required field.
        :param pulumi.Input[int] max_length: Max length of string. Used only if type is string.
        :param pulumi.Input[str] property_id: The ID associated with the property.
        :param pulumi.Input[str] schema_item_prop_link: URL encoded schema.org item prop link for the property.
        """
        pulumi.set(__self__, "field_name", field_name)
        pulumi.set(__self__, "field_type", field_type)
        if array_value_separator is not None:
            pulumi.set(__self__, "array_value_separator", array_value_separator)
        if enum_valid_values is not None:
            pulumi.set(__self__, "enum_valid_values", enum_valid_values)
        if is_array is not None:
            pulumi.set(__self__, "is_array", is_array)
        if is_available_in_graph is not None:
            pulumi.set(__self__, "is_available_in_graph", is_available_in_graph)
        if is_enum is not None:
            pulumi.set(__self__, "is_enum", is_enum)
        if is_flag_enum is not None:
            pulumi.set(__self__, "is_flag_enum", is_flag_enum)
        if is_image is not None:
            pulumi.set(__self__, "is_image", is_image)
        if is_localized_string is not None:
            pulumi.set(__self__, "is_localized_string", is_localized_string)
        if is_name is not None:
            pulumi.set(__self__, "is_name", is_name)
        if is_required is not None:
            pulumi.set(__self__, "is_required", is_required)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if property_id is not None:
            pulumi.set(__self__, "property_id", property_id)
        if schema_item_prop_link is not None:
            pulumi.set(__self__, "schema_item_prop_link", schema_item_prop_link)

    @property
    @pulumi.getter(name="fieldName")
    def field_name(self) -> pulumi.Input[str]:
        """
        Name of the property.
        """
        return pulumi.get(self, "field_name")

    @field_name.setter
    def field_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "field_name", value)

    @property
    @pulumi.getter(name="fieldType")
    def field_type(self) -> pulumi.Input[str]:
        """
        Type of the property.
        """
        return pulumi.get(self, "field_type")

    @field_type.setter
    def field_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "field_type", value)

    @property
    @pulumi.getter(name="arrayValueSeparator")
    def array_value_separator(self) -> Optional[pulumi.Input[str]]:
        """
        Array value separator for properties with isArray set.
        """
        return pulumi.get(self, "array_value_separator")

    @array_value_separator.setter
    def array_value_separator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "array_value_separator", value)

    @property
    @pulumi.getter(name="enumValidValues")
    def enum_valid_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfileEnumValidValuesFormatArgs']]]]:
        """
        Describes valid values for an enum property.
        """
        return pulumi.get(self, "enum_valid_values")

    @enum_valid_values.setter
    def enum_valid_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileEnumValidValuesFormatArgs']]]]):
        pulumi.set(self, "enum_valid_values", value)

    @property
    @pulumi.getter(name="isArray")
    def is_array(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the property is actually an array of the fieldType above on the data api.
        """
        return pulumi.get(self, "is_array")

    @is_array.setter
    def is_array(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_array", value)

    @property
    @pulumi.getter(name="isAvailableInGraph")
    def is_available_in_graph(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether property is available in graph or not.
        """
        return pulumi.get(self, "is_available_in_graph")

    @is_available_in_graph.setter
    def is_available_in_graph(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_available_in_graph", value)

    @property
    @pulumi.getter(name="isEnum")
    def is_enum(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the property is an enum.
        """
        return pulumi.get(self, "is_enum")

    @is_enum.setter
    def is_enum(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enum", value)

    @property
    @pulumi.getter(name="isFlagEnum")
    def is_flag_enum(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the property is an flag enum.
        """
        return pulumi.get(self, "is_flag_enum")

    @is_flag_enum.setter
    def is_flag_enum(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_flag_enum", value)

    @property
    @pulumi.getter(name="isImage")
    def is_image(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the property is an Image.
        """
        return pulumi.get(self, "is_image")

    @is_image.setter
    def is_image(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_image", value)

    @property
    @pulumi.getter(name="isLocalizedString")
    def is_localized_string(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the property is a localized string.
        """
        return pulumi.get(self, "is_localized_string")

    @is_localized_string.setter
    def is_localized_string(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_localized_string", value)

    @property
    @pulumi.getter(name="isName")
    def is_name(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the property is a name or a part of name.
        """
        return pulumi.get(self, "is_name")

    @is_name.setter
    def is_name(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_name", value)

    @property
    @pulumi.getter(name="isRequired")
    def is_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether property value is required on instances, IsRequired field only for Interaction. Profile Instance will not check for required field.
        """
        return pulumi.get(self, "is_required")

    @is_required.setter
    def is_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_required", value)

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[int]]:
        """
        Max length of string. Used only if type is string.
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_length", value)

    @property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID associated with the property.
        """
        return pulumi.get(self, "property_id")

    @property_id.setter
    def property_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "property_id", value)

    @property
    @pulumi.getter(name="schemaItemPropLink")
    def schema_item_prop_link(self) -> Optional[pulumi.Input[str]]:
        """
        URL encoded schema.org item prop link for the property.
        """
        return pulumi.get(self, "schema_item_prop_link")

    @schema_item_prop_link.setter
    def schema_item_prop_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_item_prop_link", value)


@pulumi.input_type
class RelationshipLinkFieldMappingArgs:
    def __init__(__self__, *,
                 interaction_field_name: pulumi.Input[str],
                 relationship_field_name: pulumi.Input[str],
                 link_type: Optional[pulumi.Input['LinkTypes']] = None):
        """
        The fields mapping for Relationships.
        :param pulumi.Input[str] interaction_field_name: The field name on the Interaction Type.
        :param pulumi.Input[str] relationship_field_name: The field name on the Relationship metadata.
        :param pulumi.Input['LinkTypes'] link_type: Link type.
        """
        pulumi.set(__self__, "interaction_field_name", interaction_field_name)
        pulumi.set(__self__, "relationship_field_name", relationship_field_name)
        if link_type is not None:
            pulumi.set(__self__, "link_type", link_type)

    @property
    @pulumi.getter(name="interactionFieldName")
    def interaction_field_name(self) -> pulumi.Input[str]:
        """
        The field name on the Interaction Type.
        """
        return pulumi.get(self, "interaction_field_name")

    @interaction_field_name.setter
    def interaction_field_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "interaction_field_name", value)

    @property
    @pulumi.getter(name="relationshipFieldName")
    def relationship_field_name(self) -> pulumi.Input[str]:
        """
        The field name on the Relationship metadata.
        """
        return pulumi.get(self, "relationship_field_name")

    @relationship_field_name.setter
    def relationship_field_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "relationship_field_name", value)

    @property
    @pulumi.getter(name="linkType")
    def link_type(self) -> Optional[pulumi.Input['LinkTypes']]:
        """
        Link type.
        """
        return pulumi.get(self, "link_type")

    @link_type.setter
    def link_type(self, value: Optional[pulumi.Input['LinkTypes']]):
        pulumi.set(self, "link_type", value)


@pulumi.input_type
class RelationshipTypeFieldMappingArgs:
    def __init__(__self__, *,
                 profile_field_name: pulumi.Input[str],
                 related_profile_key_property: pulumi.Input[str]):
        """
        Map a field of profile to its corresponding StrongId in Related Profile.
        :param pulumi.Input[str] profile_field_name: Specifies the fieldName in profile.
        :param pulumi.Input[str] related_profile_key_property: Specifies the KeyProperty (from StrongId) of the related profile.
        """
        pulumi.set(__self__, "profile_field_name", profile_field_name)
        pulumi.set(__self__, "related_profile_key_property", related_profile_key_property)

    @property
    @pulumi.getter(name="profileFieldName")
    def profile_field_name(self) -> pulumi.Input[str]:
        """
        Specifies the fieldName in profile.
        """
        return pulumi.get(self, "profile_field_name")

    @profile_field_name.setter
    def profile_field_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "profile_field_name", value)

    @property
    @pulumi.getter(name="relatedProfileKeyProperty")
    def related_profile_key_property(self) -> pulumi.Input[str]:
        """
        Specifies the KeyProperty (from StrongId) of the related profile.
        """
        return pulumi.get(self, "related_profile_key_property")

    @related_profile_key_property.setter
    def related_profile_key_property(self, value: pulumi.Input[str]):
        pulumi.set(self, "related_profile_key_property", value)


@pulumi.input_type
class RelationshipTypeMappingArgs:
    def __init__(__self__, *,
                 field_mappings: pulumi.Input[Sequence[pulumi.Input['RelationshipTypeFieldMappingArgs']]]):
        """
        Maps fields in Profile to their corresponding StrongIds in Related Profile.
        :param pulumi.Input[Sequence[pulumi.Input['RelationshipTypeFieldMappingArgs']]] field_mappings: Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are composite key as well.
        """
        pulumi.set(__self__, "field_mappings", field_mappings)

    @property
    @pulumi.getter(name="fieldMappings")
    def field_mappings(self) -> pulumi.Input[Sequence[pulumi.Input['RelationshipTypeFieldMappingArgs']]]:
        """
        Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are composite key as well.
        """
        return pulumi.get(self, "field_mappings")

    @field_mappings.setter
    def field_mappings(self, value: pulumi.Input[Sequence[pulumi.Input['RelationshipTypeFieldMappingArgs']]]):
        pulumi.set(self, "field_mappings", value)


@pulumi.input_type
class ResourceSetDescriptionArgs:
    def __init__(__self__, *,
                 elements: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exceptions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The resource set description.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] elements: The elements included in the set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exceptions: The elements that are not included in the set, in case elements contains '*' indicating 'all'.
        """
        if elements is not None:
            pulumi.set(__self__, "elements", elements)
        if exceptions is not None:
            pulumi.set(__self__, "exceptions", exceptions)

    @property
    @pulumi.getter
    def elements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The elements included in the set.
        """
        return pulumi.get(self, "elements")

    @elements.setter
    def elements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "elements", value)

    @property
    @pulumi.getter
    def exceptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The elements that are not included in the set, in case elements contains '*' indicating 'all'.
        """
        return pulumi.get(self, "exceptions")

    @exceptions.setter
    def exceptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exceptions", value)


@pulumi.input_type
class StrongIdArgs:
    def __init__(__self__, *,
                 key_property_names: pulumi.Input[Sequence[pulumi.Input[str]]],
                 strong_id_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Property/Properties which represent a unique ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] key_property_names: The properties which make up the unique ID.
        :param pulumi.Input[str] strong_id_name: The Name identifying the strong ID.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] description: Localized descriptions.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] display_name: Localized display name.
        """
        pulumi.set(__self__, "key_property_names", key_property_names)
        pulumi.set(__self__, "strong_id_name", strong_id_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter(name="keyPropertyNames")
    def key_property_names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The properties which make up the unique ID.
        """
        return pulumi.get(self, "key_property_names")

    @key_property_names.setter
    def key_property_names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "key_property_names", value)

    @property
    @pulumi.getter(name="strongIdName")
    def strong_id_name(self) -> pulumi.Input[str]:
        """
        The Name identifying the strong ID.
        """
        return pulumi.get(self, "strong_id_name")

    @strong_id_name.setter
    def strong_id_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "strong_id_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Localized descriptions.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Localized display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class TypePropertiesMappingArgs:
    def __init__(__self__, *,
                 source_property_name: pulumi.Input[str],
                 target_property_name: pulumi.Input[str],
                 link_type: Optional[pulumi.Input['LinkTypes']] = None):
        """
        Metadata for a Link's property mapping.
        :param pulumi.Input[str] source_property_name:  Property name on the source Entity Type.
        :param pulumi.Input[str] target_property_name: Property name on the target Entity Type.
        :param pulumi.Input['LinkTypes'] link_type: Link type.
        """
        pulumi.set(__self__, "source_property_name", source_property_name)
        pulumi.set(__self__, "target_property_name", target_property_name)
        if link_type is not None:
            pulumi.set(__self__, "link_type", link_type)

    @property
    @pulumi.getter(name="sourcePropertyName")
    def source_property_name(self) -> pulumi.Input[str]:
        """
         Property name on the source Entity Type.
        """
        return pulumi.get(self, "source_property_name")

    @source_property_name.setter
    def source_property_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_property_name", value)

    @property
    @pulumi.getter(name="targetPropertyName")
    def target_property_name(self) -> pulumi.Input[str]:
        """
        Property name on the target Entity Type.
        """
        return pulumi.get(self, "target_property_name")

    @target_property_name.setter
    def target_property_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_property_name", value)

    @property
    @pulumi.getter(name="linkType")
    def link_type(self) -> Optional[pulumi.Input['LinkTypes']]:
        """
        Link type.
        """
        return pulumi.get(self, "link_type")

    @link_type.setter
    def link_type(self, value: Optional[pulumi.Input['LinkTypes']]):
        pulumi.set(self, "link_type", value)


