# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ManagedClusterArgs', 'ManagedCluster']

@pulumi.input_type
class ManagedClusterArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 aad_profile: Optional[pulumi.Input['ManagedClusterAADProfileArgs']] = None,
                 addon_profiles: Optional[pulumi.Input[Mapping[str, pulumi.Input['ManagedClusterAddonProfileArgs']]]] = None,
                 agent_pool_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterAgentPoolProfileArgs']]]] = None,
                 api_server_access_profile: Optional[pulumi.Input['ManagedClusterAPIServerAccessProfileArgs']] = None,
                 auto_scaler_profile: Optional[pulumi.Input['ManagedClusterPropertiesAutoScalerProfileArgs']] = None,
                 auto_upgrade_profile: Optional[pulumi.Input['ManagedClusterAutoUpgradeProfileArgs']] = None,
                 creation_data: Optional[pulumi.Input['CreationDataArgs']] = None,
                 disable_local_accounts: Optional[pulumi.Input[bool]] = None,
                 disk_encryption_set_id: Optional[pulumi.Input[str]] = None,
                 dns_prefix: Optional[pulumi.Input[str]] = None,
                 enable_namespace_resources: Optional[pulumi.Input[bool]] = None,
                 enable_pod_security_policy: Optional[pulumi.Input[bool]] = None,
                 enable_rbac: Optional[pulumi.Input[bool]] = None,
                 extended_location: Optional[pulumi.Input['ExtendedLocationArgs']] = None,
                 fqdn_subdomain: Optional[pulumi.Input[str]] = None,
                 http_proxy_config: Optional[pulumi.Input['ManagedClusterHTTPProxyConfigArgs']] = None,
                 identity: Optional[pulumi.Input['ManagedClusterIdentityArgs']] = None,
                 identity_profile: Optional[pulumi.Input[Mapping[str, pulumi.Input['UserAssignedIdentityArgs']]]] = None,
                 ingress_profile: Optional[pulumi.Input['ManagedClusterIngressProfileArgs']] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 linux_profile: Optional[pulumi.Input['ContainerServiceLinuxProfileArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 network_profile: Optional[pulumi.Input['ContainerServiceNetworkProfileArgs']] = None,
                 node_resource_group: Optional[pulumi.Input[str]] = None,
                 oidc_issuer_profile: Optional[pulumi.Input['ManagedClusterOIDCIssuerProfileArgs']] = None,
                 pod_identity_profile: Optional[pulumi.Input['ManagedClusterPodIdentityProfileArgs']] = None,
                 private_link_resources: Optional[pulumi.Input[Sequence[pulumi.Input['PrivateLinkResourceArgs']]]] = None,
                 public_network_access: Optional[pulumi.Input[Union[str, 'PublicNetworkAccess']]] = None,
                 resource_name: Optional[pulumi.Input[str]] = None,
                 security_profile: Optional[pulumi.Input['ManagedClusterSecurityProfileArgs']] = None,
                 service_principal_profile: Optional[pulumi.Input['ManagedClusterServicePrincipalProfileArgs']] = None,
                 sku: Optional[pulumi.Input['ManagedClusterSKUArgs']] = None,
                 storage_profile: Optional[pulumi.Input['ManagedClusterStorageProfileArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 windows_profile: Optional[pulumi.Input['ManagedClusterWindowsProfileArgs']] = None,
                 workload_auto_scaler_profile: Optional[pulumi.Input['ManagedClusterWorkloadAutoScalerProfileArgs']] = None):
        """
        The set of arguments for constructing a ManagedCluster resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input['ManagedClusterAADProfileArgs'] aad_profile: The Azure Active Directory configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input['ManagedClusterAddonProfileArgs']]] addon_profiles: The profile of managed cluster add-on.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedClusterAgentPoolProfileArgs']]] agent_pool_profiles: The agent pool properties.
        :param pulumi.Input['ManagedClusterAPIServerAccessProfileArgs'] api_server_access_profile: The access profile for managed cluster API server.
        :param pulumi.Input['ManagedClusterPropertiesAutoScalerProfileArgs'] auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when enabled
        :param pulumi.Input['ManagedClusterAutoUpgradeProfileArgs'] auto_upgrade_profile: The auto upgrade configuration.
        :param pulumi.Input['CreationDataArgs'] creation_data: CreationData to be used to specify the source Snapshot ID if the cluster will be created/upgraded using a snapshot.
        :param pulumi.Input[bool] disable_local_accounts: If set to true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters that are AAD enabled. For more details see [disable local accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
        :param pulumi.Input[str] disk_encryption_set_id: This is of the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'
        :param pulumi.Input[str] dns_prefix: This cannot be updated once the Managed Cluster has been created.
        :param pulumi.Input[bool] enable_namespace_resources: The default value is false. It can be enabled/disabled on creation and updation of the managed cluster. See [https://aka.ms/NamespaceARMResource](https://aka.ms/NamespaceARMResource) for more details on Namespace as a ARM Resource.
        :param pulumi.Input[bool] enable_pod_security_policy: (DEPRECATING) Whether to enable Kubernetes pod security policy (preview). This feature is set for removal on October 15th, 2020. Learn more at aka.ms/aks/azpodpolicy.
        :param pulumi.Input[bool] enable_rbac: Whether to enable Kubernetes Role-Based Access Control.
        :param pulumi.Input['ExtendedLocationArgs'] extended_location: The extended location of the Virtual Machine.
        :param pulumi.Input[str] fqdn_subdomain: This cannot be updated once the Managed Cluster has been created.
        :param pulumi.Input['ManagedClusterHTTPProxyConfigArgs'] http_proxy_config: Configurations for provisioning the cluster with HTTP proxy servers.
        :param pulumi.Input['ManagedClusterIdentityArgs'] identity: The identity of the managed cluster, if configured.
        :param pulumi.Input[Mapping[str, pulumi.Input['UserAssignedIdentityArgs']]] identity_profile: Identities associated with the cluster.
        :param pulumi.Input['ManagedClusterIngressProfileArgs'] ingress_profile: Ingress profile for the managed cluster.
        :param pulumi.Input[str] kubernetes_version: When you upgrade a supported AKS cluster, Kubernetes minor versions cannot be skipped. All upgrades must be performed sequentially by major version number. For example, upgrades between 1.14.x -> 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See [upgrading an AKS cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more details.
        :param pulumi.Input['ContainerServiceLinuxProfileArgs'] linux_profile: The profile for Linux VMs in the Managed Cluster.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input['ContainerServiceNetworkProfileArgs'] network_profile: The network configuration profile.
        :param pulumi.Input[str] node_resource_group: The name of the resource group containing agent pool nodes.
        :param pulumi.Input['ManagedClusterOIDCIssuerProfileArgs'] oidc_issuer_profile: The OIDC issuer profile of the Managed Cluster.
        :param pulumi.Input['ManagedClusterPodIdentityProfileArgs'] pod_identity_profile: See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity integration.
        :param pulumi.Input[Sequence[pulumi.Input['PrivateLinkResourceArgs']]] private_link_resources: Private link resources associated with the cluster.
        :param pulumi.Input[Union[str, 'PublicNetworkAccess']] public_network_access: Allow or deny public network access for AKS
        :param pulumi.Input[str] resource_name: The name of the managed cluster resource.
        :param pulumi.Input['ManagedClusterSecurityProfileArgs'] security_profile: Security profile for the managed cluster.
        :param pulumi.Input['ManagedClusterServicePrincipalProfileArgs'] service_principal_profile: Information about a service principal identity for the cluster to use for manipulating Azure APIs.
        :param pulumi.Input['ManagedClusterSKUArgs'] sku: The managed cluster SKU.
        :param pulumi.Input['ManagedClusterStorageProfileArgs'] storage_profile: Storage profile for the managed cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input['ManagedClusterWindowsProfileArgs'] windows_profile: The profile for Windows VMs in the Managed Cluster.
        :param pulumi.Input['ManagedClusterWorkloadAutoScalerProfileArgs'] workload_auto_scaler_profile: Workload Auto-scaler profile for the container service cluster.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if aad_profile is not None:
            pulumi.set(__self__, "aad_profile", aad_profile)
        if addon_profiles is not None:
            pulumi.set(__self__, "addon_profiles", addon_profiles)
        if agent_pool_profiles is not None:
            pulumi.set(__self__, "agent_pool_profiles", agent_pool_profiles)
        if api_server_access_profile is not None:
            pulumi.set(__self__, "api_server_access_profile", api_server_access_profile)
        if auto_scaler_profile is not None:
            pulumi.set(__self__, "auto_scaler_profile", auto_scaler_profile)
        if auto_upgrade_profile is not None:
            pulumi.set(__self__, "auto_upgrade_profile", auto_upgrade_profile)
        if creation_data is not None:
            pulumi.set(__self__, "creation_data", creation_data)
        if disable_local_accounts is not None:
            pulumi.set(__self__, "disable_local_accounts", disable_local_accounts)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if dns_prefix is not None:
            pulumi.set(__self__, "dns_prefix", dns_prefix)
        if enable_namespace_resources is not None:
            pulumi.set(__self__, "enable_namespace_resources", enable_namespace_resources)
        if enable_pod_security_policy is not None:
            pulumi.set(__self__, "enable_pod_security_policy", enable_pod_security_policy)
        if enable_rbac is not None:
            pulumi.set(__self__, "enable_rbac", enable_rbac)
        if extended_location is not None:
            pulumi.set(__self__, "extended_location", extended_location)
        if fqdn_subdomain is not None:
            pulumi.set(__self__, "fqdn_subdomain", fqdn_subdomain)
        if http_proxy_config is not None:
            pulumi.set(__self__, "http_proxy_config", http_proxy_config)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if identity_profile is not None:
            pulumi.set(__self__, "identity_profile", identity_profile)
        if ingress_profile is not None:
            pulumi.set(__self__, "ingress_profile", ingress_profile)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if linux_profile is not None:
            pulumi.set(__self__, "linux_profile", linux_profile)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if node_resource_group is not None:
            pulumi.set(__self__, "node_resource_group", node_resource_group)
        if oidc_issuer_profile is not None:
            pulumi.set(__self__, "oidc_issuer_profile", oidc_issuer_profile)
        if pod_identity_profile is not None:
            pulumi.set(__self__, "pod_identity_profile", pod_identity_profile)
        if private_link_resources is not None:
            pulumi.set(__self__, "private_link_resources", private_link_resources)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if security_profile is not None:
            pulumi.set(__self__, "security_profile", security_profile)
        if service_principal_profile is not None:
            pulumi.set(__self__, "service_principal_profile", service_principal_profile)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if storage_profile is not None:
            pulumi.set(__self__, "storage_profile", storage_profile)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if windows_profile is not None:
            pulumi.set(__self__, "windows_profile", windows_profile)
        if workload_auto_scaler_profile is not None:
            pulumi.set(__self__, "workload_auto_scaler_profile", workload_auto_scaler_profile)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="aadProfile")
    def aad_profile(self) -> Optional[pulumi.Input['ManagedClusterAADProfileArgs']]:
        """
        The Azure Active Directory configuration.
        """
        return pulumi.get(self, "aad_profile")

    @aad_profile.setter
    def aad_profile(self, value: Optional[pulumi.Input['ManagedClusterAADProfileArgs']]):
        pulumi.set(self, "aad_profile", value)

    @property
    @pulumi.getter(name="addonProfiles")
    def addon_profiles(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ManagedClusterAddonProfileArgs']]]]:
        """
        The profile of managed cluster add-on.
        """
        return pulumi.get(self, "addon_profiles")

    @addon_profiles.setter
    def addon_profiles(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ManagedClusterAddonProfileArgs']]]]):
        pulumi.set(self, "addon_profiles", value)

    @property
    @pulumi.getter(name="agentPoolProfiles")
    def agent_pool_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterAgentPoolProfileArgs']]]]:
        """
        The agent pool properties.
        """
        return pulumi.get(self, "agent_pool_profiles")

    @agent_pool_profiles.setter
    def agent_pool_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterAgentPoolProfileArgs']]]]):
        pulumi.set(self, "agent_pool_profiles", value)

    @property
    @pulumi.getter(name="apiServerAccessProfile")
    def api_server_access_profile(self) -> Optional[pulumi.Input['ManagedClusterAPIServerAccessProfileArgs']]:
        """
        The access profile for managed cluster API server.
        """
        return pulumi.get(self, "api_server_access_profile")

    @api_server_access_profile.setter
    def api_server_access_profile(self, value: Optional[pulumi.Input['ManagedClusterAPIServerAccessProfileArgs']]):
        pulumi.set(self, "api_server_access_profile", value)

    @property
    @pulumi.getter(name="autoScalerProfile")
    def auto_scaler_profile(self) -> Optional[pulumi.Input['ManagedClusterPropertiesAutoScalerProfileArgs']]:
        """
        Parameters to be applied to the cluster-autoscaler when enabled
        """
        return pulumi.get(self, "auto_scaler_profile")

    @auto_scaler_profile.setter
    def auto_scaler_profile(self, value: Optional[pulumi.Input['ManagedClusterPropertiesAutoScalerProfileArgs']]):
        pulumi.set(self, "auto_scaler_profile", value)

    @property
    @pulumi.getter(name="autoUpgradeProfile")
    def auto_upgrade_profile(self) -> Optional[pulumi.Input['ManagedClusterAutoUpgradeProfileArgs']]:
        """
        The auto upgrade configuration.
        """
        return pulumi.get(self, "auto_upgrade_profile")

    @auto_upgrade_profile.setter
    def auto_upgrade_profile(self, value: Optional[pulumi.Input['ManagedClusterAutoUpgradeProfileArgs']]):
        pulumi.set(self, "auto_upgrade_profile", value)

    @property
    @pulumi.getter(name="creationData")
    def creation_data(self) -> Optional[pulumi.Input['CreationDataArgs']]:
        """
        CreationData to be used to specify the source Snapshot ID if the cluster will be created/upgraded using a snapshot.
        """
        return pulumi.get(self, "creation_data")

    @creation_data.setter
    def creation_data(self, value: Optional[pulumi.Input['CreationDataArgs']]):
        pulumi.set(self, "creation_data", value)

    @property
    @pulumi.getter(name="disableLocalAccounts")
    def disable_local_accounts(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters that are AAD enabled. For more details see [disable local accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
        """
        return pulumi.get(self, "disable_local_accounts")

    @disable_local_accounts.setter
    def disable_local_accounts(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_accounts", value)

    @property
    @pulumi.getter(name="diskEncryptionSetID")
    def disk_encryption_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        This is of the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @disk_encryption_set_id.setter
    def disk_encryption_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_encryption_set_id", value)

    @property
    @pulumi.getter(name="dnsPrefix")
    def dns_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        This cannot be updated once the Managed Cluster has been created.
        """
        return pulumi.get(self, "dns_prefix")

    @dns_prefix.setter
    def dns_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_prefix", value)

    @property
    @pulumi.getter(name="enableNamespaceResources")
    def enable_namespace_resources(self) -> Optional[pulumi.Input[bool]]:
        """
        The default value is false. It can be enabled/disabled on creation and updation of the managed cluster. See [https://aka.ms/NamespaceARMResource](https://aka.ms/NamespaceARMResource) for more details on Namespace as a ARM Resource.
        """
        return pulumi.get(self, "enable_namespace_resources")

    @enable_namespace_resources.setter
    def enable_namespace_resources(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_namespace_resources", value)

    @property
    @pulumi.getter(name="enablePodSecurityPolicy")
    def enable_pod_security_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        (DEPRECATING) Whether to enable Kubernetes pod security policy (preview). This feature is set for removal on October 15th, 2020. Learn more at aka.ms/aks/azpodpolicy.
        """
        return pulumi.get(self, "enable_pod_security_policy")

    @enable_pod_security_policy.setter
    def enable_pod_security_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_pod_security_policy", value)

    @property
    @pulumi.getter(name="enableRBAC")
    def enable_rbac(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable Kubernetes Role-Based Access Control.
        """
        return pulumi.get(self, "enable_rbac")

    @enable_rbac.setter
    def enable_rbac(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_rbac", value)

    @property
    @pulumi.getter(name="extendedLocation")
    def extended_location(self) -> Optional[pulumi.Input['ExtendedLocationArgs']]:
        """
        The extended location of the Virtual Machine.
        """
        return pulumi.get(self, "extended_location")

    @extended_location.setter
    def extended_location(self, value: Optional[pulumi.Input['ExtendedLocationArgs']]):
        pulumi.set(self, "extended_location", value)

    @property
    @pulumi.getter(name="fqdnSubdomain")
    def fqdn_subdomain(self) -> Optional[pulumi.Input[str]]:
        """
        This cannot be updated once the Managed Cluster has been created.
        """
        return pulumi.get(self, "fqdn_subdomain")

    @fqdn_subdomain.setter
    def fqdn_subdomain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn_subdomain", value)

    @property
    @pulumi.getter(name="httpProxyConfig")
    def http_proxy_config(self) -> Optional[pulumi.Input['ManagedClusterHTTPProxyConfigArgs']]:
        """
        Configurations for provisioning the cluster with HTTP proxy servers.
        """
        return pulumi.get(self, "http_proxy_config")

    @http_proxy_config.setter
    def http_proxy_config(self, value: Optional[pulumi.Input['ManagedClusterHTTPProxyConfigArgs']]):
        pulumi.set(self, "http_proxy_config", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ManagedClusterIdentityArgs']]:
        """
        The identity of the managed cluster, if configured.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ManagedClusterIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="identityProfile")
    def identity_profile(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['UserAssignedIdentityArgs']]]]:
        """
        Identities associated with the cluster.
        """
        return pulumi.get(self, "identity_profile")

    @identity_profile.setter
    def identity_profile(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['UserAssignedIdentityArgs']]]]):
        pulumi.set(self, "identity_profile", value)

    @property
    @pulumi.getter(name="ingressProfile")
    def ingress_profile(self) -> Optional[pulumi.Input['ManagedClusterIngressProfileArgs']]:
        """
        Ingress profile for the managed cluster.
        """
        return pulumi.get(self, "ingress_profile")

    @ingress_profile.setter
    def ingress_profile(self, value: Optional[pulumi.Input['ManagedClusterIngressProfileArgs']]):
        pulumi.set(self, "ingress_profile", value)

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[str]]:
        """
        When you upgrade a supported AKS cluster, Kubernetes minor versions cannot be skipped. All upgrades must be performed sequentially by major version number. For example, upgrades between 1.14.x -> 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See [upgrading an AKS cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more details.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_version", value)

    @property
    @pulumi.getter(name="linuxProfile")
    def linux_profile(self) -> Optional[pulumi.Input['ContainerServiceLinuxProfileArgs']]:
        """
        The profile for Linux VMs in the Managed Cluster.
        """
        return pulumi.get(self, "linux_profile")

    @linux_profile.setter
    def linux_profile(self, value: Optional[pulumi.Input['ContainerServiceLinuxProfileArgs']]):
        pulumi.set(self, "linux_profile", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input['ContainerServiceNetworkProfileArgs']]:
        """
        The network configuration profile.
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input['ContainerServiceNetworkProfileArgs']]):
        pulumi.set(self, "network_profile", value)

    @property
    @pulumi.getter(name="nodeResourceGroup")
    def node_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource group containing agent pool nodes.
        """
        return pulumi.get(self, "node_resource_group")

    @node_resource_group.setter
    def node_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_resource_group", value)

    @property
    @pulumi.getter(name="oidcIssuerProfile")
    def oidc_issuer_profile(self) -> Optional[pulumi.Input['ManagedClusterOIDCIssuerProfileArgs']]:
        """
        The OIDC issuer profile of the Managed Cluster.
        """
        return pulumi.get(self, "oidc_issuer_profile")

    @oidc_issuer_profile.setter
    def oidc_issuer_profile(self, value: Optional[pulumi.Input['ManagedClusterOIDCIssuerProfileArgs']]):
        pulumi.set(self, "oidc_issuer_profile", value)

    @property
    @pulumi.getter(name="podIdentityProfile")
    def pod_identity_profile(self) -> Optional[pulumi.Input['ManagedClusterPodIdentityProfileArgs']]:
        """
        See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity integration.
        """
        return pulumi.get(self, "pod_identity_profile")

    @pod_identity_profile.setter
    def pod_identity_profile(self, value: Optional[pulumi.Input['ManagedClusterPodIdentityProfileArgs']]):
        pulumi.set(self, "pod_identity_profile", value)

    @property
    @pulumi.getter(name="privateLinkResources")
    def private_link_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PrivateLinkResourceArgs']]]]:
        """
        Private link resources associated with the cluster.
        """
        return pulumi.get(self, "private_link_resources")

    @private_link_resources.setter
    def private_link_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PrivateLinkResourceArgs']]]]):
        pulumi.set(self, "private_link_resources", value)

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[Union[str, 'PublicNetworkAccess']]]:
        """
        Allow or deny public network access for AKS
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[Union[str, 'PublicNetworkAccess']]]):
        pulumi.set(self, "public_network_access", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the managed cluster resource.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> Optional[pulumi.Input['ManagedClusterSecurityProfileArgs']]:
        """
        Security profile for the managed cluster.
        """
        return pulumi.get(self, "security_profile")

    @security_profile.setter
    def security_profile(self, value: Optional[pulumi.Input['ManagedClusterSecurityProfileArgs']]):
        pulumi.set(self, "security_profile", value)

    @property
    @pulumi.getter(name="servicePrincipalProfile")
    def service_principal_profile(self) -> Optional[pulumi.Input['ManagedClusterServicePrincipalProfileArgs']]:
        """
        Information about a service principal identity for the cluster to use for manipulating Azure APIs.
        """
        return pulumi.get(self, "service_principal_profile")

    @service_principal_profile.setter
    def service_principal_profile(self, value: Optional[pulumi.Input['ManagedClusterServicePrincipalProfileArgs']]):
        pulumi.set(self, "service_principal_profile", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['ManagedClusterSKUArgs']]:
        """
        The managed cluster SKU.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['ManagedClusterSKUArgs']]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> Optional[pulumi.Input['ManagedClusterStorageProfileArgs']]:
        """
        Storage profile for the managed cluster.
        """
        return pulumi.get(self, "storage_profile")

    @storage_profile.setter
    def storage_profile(self, value: Optional[pulumi.Input['ManagedClusterStorageProfileArgs']]):
        pulumi.set(self, "storage_profile", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="windowsProfile")
    def windows_profile(self) -> Optional[pulumi.Input['ManagedClusterWindowsProfileArgs']]:
        """
        The profile for Windows VMs in the Managed Cluster.
        """
        return pulumi.get(self, "windows_profile")

    @windows_profile.setter
    def windows_profile(self, value: Optional[pulumi.Input['ManagedClusterWindowsProfileArgs']]):
        pulumi.set(self, "windows_profile", value)

    @property
    @pulumi.getter(name="workloadAutoScalerProfile")
    def workload_auto_scaler_profile(self) -> Optional[pulumi.Input['ManagedClusterWorkloadAutoScalerProfileArgs']]:
        """
        Workload Auto-scaler profile for the container service cluster.
        """
        return pulumi.get(self, "workload_auto_scaler_profile")

    @workload_auto_scaler_profile.setter
    def workload_auto_scaler_profile(self, value: Optional[pulumi.Input['ManagedClusterWorkloadAutoScalerProfileArgs']]):
        pulumi.set(self, "workload_auto_scaler_profile", value)


class ManagedCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aad_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterAADProfileArgs']]] = None,
                 addon_profiles: Optional[pulumi.Input[Mapping[str, pulumi.Input[pulumi.InputType['ManagedClusterAddonProfileArgs']]]]] = None,
                 agent_pool_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedClusterAgentPoolProfileArgs']]]]] = None,
                 api_server_access_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterAPIServerAccessProfileArgs']]] = None,
                 auto_scaler_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterPropertiesAutoScalerProfileArgs']]] = None,
                 auto_upgrade_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterAutoUpgradeProfileArgs']]] = None,
                 creation_data: Optional[pulumi.Input[pulumi.InputType['CreationDataArgs']]] = None,
                 disable_local_accounts: Optional[pulumi.Input[bool]] = None,
                 disk_encryption_set_id: Optional[pulumi.Input[str]] = None,
                 dns_prefix: Optional[pulumi.Input[str]] = None,
                 enable_namespace_resources: Optional[pulumi.Input[bool]] = None,
                 enable_pod_security_policy: Optional[pulumi.Input[bool]] = None,
                 enable_rbac: Optional[pulumi.Input[bool]] = None,
                 extended_location: Optional[pulumi.Input[pulumi.InputType['ExtendedLocationArgs']]] = None,
                 fqdn_subdomain: Optional[pulumi.Input[str]] = None,
                 http_proxy_config: Optional[pulumi.Input[pulumi.InputType['ManagedClusterHTTPProxyConfigArgs']]] = None,
                 identity: Optional[pulumi.Input[pulumi.InputType['ManagedClusterIdentityArgs']]] = None,
                 identity_profile: Optional[pulumi.Input[Mapping[str, pulumi.Input[pulumi.InputType['UserAssignedIdentityArgs']]]]] = None,
                 ingress_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterIngressProfileArgs']]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 linux_profile: Optional[pulumi.Input[pulumi.InputType['ContainerServiceLinuxProfileArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 network_profile: Optional[pulumi.Input[pulumi.InputType['ContainerServiceNetworkProfileArgs']]] = None,
                 node_resource_group: Optional[pulumi.Input[str]] = None,
                 oidc_issuer_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterOIDCIssuerProfileArgs']]] = None,
                 pod_identity_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterPodIdentityProfileArgs']]] = None,
                 private_link_resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PrivateLinkResourceArgs']]]]] = None,
                 public_network_access: Optional[pulumi.Input[Union[str, 'PublicNetworkAccess']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 resource_name_: Optional[pulumi.Input[str]] = None,
                 security_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterSecurityProfileArgs']]] = None,
                 service_principal_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterServicePrincipalProfileArgs']]] = None,
                 sku: Optional[pulumi.Input[pulumi.InputType['ManagedClusterSKUArgs']]] = None,
                 storage_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterStorageProfileArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 windows_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterWindowsProfileArgs']]] = None,
                 workload_auto_scaler_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterWorkloadAutoScalerProfileArgs']]] = None,
                 __props__=None):
        """
        Managed cluster.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ManagedClusterAADProfileArgs']] aad_profile: The Azure Active Directory configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[pulumi.InputType['ManagedClusterAddonProfileArgs']]]] addon_profiles: The profile of managed cluster add-on.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedClusterAgentPoolProfileArgs']]]] agent_pool_profiles: The agent pool properties.
        :param pulumi.Input[pulumi.InputType['ManagedClusterAPIServerAccessProfileArgs']] api_server_access_profile: The access profile for managed cluster API server.
        :param pulumi.Input[pulumi.InputType['ManagedClusterPropertiesAutoScalerProfileArgs']] auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when enabled
        :param pulumi.Input[pulumi.InputType['ManagedClusterAutoUpgradeProfileArgs']] auto_upgrade_profile: The auto upgrade configuration.
        :param pulumi.Input[pulumi.InputType['CreationDataArgs']] creation_data: CreationData to be used to specify the source Snapshot ID if the cluster will be created/upgraded using a snapshot.
        :param pulumi.Input[bool] disable_local_accounts: If set to true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters that are AAD enabled. For more details see [disable local accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
        :param pulumi.Input[str] disk_encryption_set_id: This is of the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'
        :param pulumi.Input[str] dns_prefix: This cannot be updated once the Managed Cluster has been created.
        :param pulumi.Input[bool] enable_namespace_resources: The default value is false. It can be enabled/disabled on creation and updation of the managed cluster. See [https://aka.ms/NamespaceARMResource](https://aka.ms/NamespaceARMResource) for more details on Namespace as a ARM Resource.
        :param pulumi.Input[bool] enable_pod_security_policy: (DEPRECATING) Whether to enable Kubernetes pod security policy (preview). This feature is set for removal on October 15th, 2020. Learn more at aka.ms/aks/azpodpolicy.
        :param pulumi.Input[bool] enable_rbac: Whether to enable Kubernetes Role-Based Access Control.
        :param pulumi.Input[pulumi.InputType['ExtendedLocationArgs']] extended_location: The extended location of the Virtual Machine.
        :param pulumi.Input[str] fqdn_subdomain: This cannot be updated once the Managed Cluster has been created.
        :param pulumi.Input[pulumi.InputType['ManagedClusterHTTPProxyConfigArgs']] http_proxy_config: Configurations for provisioning the cluster with HTTP proxy servers.
        :param pulumi.Input[pulumi.InputType['ManagedClusterIdentityArgs']] identity: The identity of the managed cluster, if configured.
        :param pulumi.Input[Mapping[str, pulumi.Input[pulumi.InputType['UserAssignedIdentityArgs']]]] identity_profile: Identities associated with the cluster.
        :param pulumi.Input[pulumi.InputType['ManagedClusterIngressProfileArgs']] ingress_profile: Ingress profile for the managed cluster.
        :param pulumi.Input[str] kubernetes_version: When you upgrade a supported AKS cluster, Kubernetes minor versions cannot be skipped. All upgrades must be performed sequentially by major version number. For example, upgrades between 1.14.x -> 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See [upgrading an AKS cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more details.
        :param pulumi.Input[pulumi.InputType['ContainerServiceLinuxProfileArgs']] linux_profile: The profile for Linux VMs in the Managed Cluster.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[pulumi.InputType['ContainerServiceNetworkProfileArgs']] network_profile: The network configuration profile.
        :param pulumi.Input[str] node_resource_group: The name of the resource group containing agent pool nodes.
        :param pulumi.Input[pulumi.InputType['ManagedClusterOIDCIssuerProfileArgs']] oidc_issuer_profile: The OIDC issuer profile of the Managed Cluster.
        :param pulumi.Input[pulumi.InputType['ManagedClusterPodIdentityProfileArgs']] pod_identity_profile: See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity integration.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PrivateLinkResourceArgs']]]] private_link_resources: Private link resources associated with the cluster.
        :param pulumi.Input[Union[str, 'PublicNetworkAccess']] public_network_access: Allow or deny public network access for AKS
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] resource_name_: The name of the managed cluster resource.
        :param pulumi.Input[pulumi.InputType['ManagedClusterSecurityProfileArgs']] security_profile: Security profile for the managed cluster.
        :param pulumi.Input[pulumi.InputType['ManagedClusterServicePrincipalProfileArgs']] service_principal_profile: Information about a service principal identity for the cluster to use for manipulating Azure APIs.
        :param pulumi.Input[pulumi.InputType['ManagedClusterSKUArgs']] sku: The managed cluster SKU.
        :param pulumi.Input[pulumi.InputType['ManagedClusterStorageProfileArgs']] storage_profile: Storage profile for the managed cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input[pulumi.InputType['ManagedClusterWindowsProfileArgs']] windows_profile: The profile for Windows VMs in the Managed Cluster.
        :param pulumi.Input[pulumi.InputType['ManagedClusterWorkloadAutoScalerProfileArgs']] workload_auto_scaler_profile: Workload Auto-scaler profile for the container service cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Managed cluster.

        :param str resource_name: The name of the resource.
        :param ManagedClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aad_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterAADProfileArgs']]] = None,
                 addon_profiles: Optional[pulumi.Input[Mapping[str, pulumi.Input[pulumi.InputType['ManagedClusterAddonProfileArgs']]]]] = None,
                 agent_pool_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedClusterAgentPoolProfileArgs']]]]] = None,
                 api_server_access_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterAPIServerAccessProfileArgs']]] = None,
                 auto_scaler_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterPropertiesAutoScalerProfileArgs']]] = None,
                 auto_upgrade_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterAutoUpgradeProfileArgs']]] = None,
                 creation_data: Optional[pulumi.Input[pulumi.InputType['CreationDataArgs']]] = None,
                 disable_local_accounts: Optional[pulumi.Input[bool]] = None,
                 disk_encryption_set_id: Optional[pulumi.Input[str]] = None,
                 dns_prefix: Optional[pulumi.Input[str]] = None,
                 enable_namespace_resources: Optional[pulumi.Input[bool]] = None,
                 enable_pod_security_policy: Optional[pulumi.Input[bool]] = None,
                 enable_rbac: Optional[pulumi.Input[bool]] = None,
                 extended_location: Optional[pulumi.Input[pulumi.InputType['ExtendedLocationArgs']]] = None,
                 fqdn_subdomain: Optional[pulumi.Input[str]] = None,
                 http_proxy_config: Optional[pulumi.Input[pulumi.InputType['ManagedClusterHTTPProxyConfigArgs']]] = None,
                 identity: Optional[pulumi.Input[pulumi.InputType['ManagedClusterIdentityArgs']]] = None,
                 identity_profile: Optional[pulumi.Input[Mapping[str, pulumi.Input[pulumi.InputType['UserAssignedIdentityArgs']]]]] = None,
                 ingress_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterIngressProfileArgs']]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 linux_profile: Optional[pulumi.Input[pulumi.InputType['ContainerServiceLinuxProfileArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 network_profile: Optional[pulumi.Input[pulumi.InputType['ContainerServiceNetworkProfileArgs']]] = None,
                 node_resource_group: Optional[pulumi.Input[str]] = None,
                 oidc_issuer_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterOIDCIssuerProfileArgs']]] = None,
                 pod_identity_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterPodIdentityProfileArgs']]] = None,
                 private_link_resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PrivateLinkResourceArgs']]]]] = None,
                 public_network_access: Optional[pulumi.Input[Union[str, 'PublicNetworkAccess']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 resource_name_: Optional[pulumi.Input[str]] = None,
                 security_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterSecurityProfileArgs']]] = None,
                 service_principal_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterServicePrincipalProfileArgs']]] = None,
                 sku: Optional[pulumi.Input[pulumi.InputType['ManagedClusterSKUArgs']]] = None,
                 storage_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterStorageProfileArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 windows_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterWindowsProfileArgs']]] = None,
                 workload_auto_scaler_profile: Optional[pulumi.Input[pulumi.InputType['ManagedClusterWorkloadAutoScalerProfileArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedClusterArgs.__new__(ManagedClusterArgs)

            __props__.__dict__["aad_profile"] = aad_profile
            __props__.__dict__["addon_profiles"] = addon_profiles
            __props__.__dict__["agent_pool_profiles"] = agent_pool_profiles
            __props__.__dict__["api_server_access_profile"] = api_server_access_profile
            __props__.__dict__["auto_scaler_profile"] = auto_scaler_profile
            __props__.__dict__["auto_upgrade_profile"] = auto_upgrade_profile
            __props__.__dict__["creation_data"] = creation_data
            __props__.__dict__["disable_local_accounts"] = disable_local_accounts
            __props__.__dict__["disk_encryption_set_id"] = disk_encryption_set_id
            __props__.__dict__["dns_prefix"] = dns_prefix
            __props__.__dict__["enable_namespace_resources"] = enable_namespace_resources
            __props__.__dict__["enable_pod_security_policy"] = enable_pod_security_policy
            __props__.__dict__["enable_rbac"] = enable_rbac
            __props__.__dict__["extended_location"] = extended_location
            __props__.__dict__["fqdn_subdomain"] = fqdn_subdomain
            __props__.__dict__["http_proxy_config"] = http_proxy_config
            __props__.__dict__["identity"] = identity
            __props__.__dict__["identity_profile"] = identity_profile
            __props__.__dict__["ingress_profile"] = ingress_profile
            __props__.__dict__["kubernetes_version"] = kubernetes_version
            __props__.__dict__["linux_profile"] = linux_profile
            __props__.__dict__["location"] = location
            __props__.__dict__["network_profile"] = network_profile
            __props__.__dict__["node_resource_group"] = node_resource_group
            __props__.__dict__["oidc_issuer_profile"] = oidc_issuer_profile
            __props__.__dict__["pod_identity_profile"] = pod_identity_profile
            __props__.__dict__["private_link_resources"] = private_link_resources
            __props__.__dict__["public_network_access"] = public_network_access
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["resource_name"] = resource_name_
            __props__.__dict__["security_profile"] = security_profile
            __props__.__dict__["service_principal_profile"] = service_principal_profile
            __props__.__dict__["sku"] = sku
            __props__.__dict__["storage_profile"] = storage_profile
            __props__.__dict__["tags"] = tags
            __props__.__dict__["windows_profile"] = windows_profile
            __props__.__dict__["workload_auto_scaler_profile"] = workload_auto_scaler_profile
            __props__.__dict__["azure_portal_fqdn"] = None
            __props__.__dict__["current_kubernetes_version"] = None
            __props__.__dict__["fqdn"] = None
            __props__.__dict__["max_agent_pools"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["power_state"] = None
            __props__.__dict__["private_fqdn"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:containerservice:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20170831:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20180331:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20180801preview:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20190201:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20190401:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20190601:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20190801:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20191001:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20191101:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20200101:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20200201:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20200301:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20200401:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20200601:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20200701:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20200901:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20201101:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20201201:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20210201:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20210301:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20210501:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20210701:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20210801:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20210901:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20211001:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20211101preview:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20220101:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20220102preview:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20220201:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20220202preview:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20220301:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20220302preview:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20220401:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20220402preview:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20220502preview:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20220601:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20220701:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20220702preview:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20220802preview:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20220803preview:ManagedCluster"), pulumi.Alias(type_="azure-native:containerservice/v20220902preview:ManagedCluster")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ManagedCluster, __self__).__init__(
            'azure-native:containerservice/v20220602preview:ManagedCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ManagedCluster':
        """
        Get an existing ManagedCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ManagedClusterArgs.__new__(ManagedClusterArgs)

        __props__.__dict__["aad_profile"] = None
        __props__.__dict__["addon_profiles"] = None
        __props__.__dict__["agent_pool_profiles"] = None
        __props__.__dict__["api_server_access_profile"] = None
        __props__.__dict__["auto_scaler_profile"] = None
        __props__.__dict__["auto_upgrade_profile"] = None
        __props__.__dict__["azure_portal_fqdn"] = None
        __props__.__dict__["creation_data"] = None
        __props__.__dict__["current_kubernetes_version"] = None
        __props__.__dict__["disable_local_accounts"] = None
        __props__.__dict__["disk_encryption_set_id"] = None
        __props__.__dict__["dns_prefix"] = None
        __props__.__dict__["enable_namespace_resources"] = None
        __props__.__dict__["enable_pod_security_policy"] = None
        __props__.__dict__["enable_rbac"] = None
        __props__.__dict__["extended_location"] = None
        __props__.__dict__["fqdn"] = None
        __props__.__dict__["fqdn_subdomain"] = None
        __props__.__dict__["http_proxy_config"] = None
        __props__.__dict__["identity"] = None
        __props__.__dict__["identity_profile"] = None
        __props__.__dict__["ingress_profile"] = None
        __props__.__dict__["kubernetes_version"] = None
        __props__.__dict__["linux_profile"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["max_agent_pools"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["network_profile"] = None
        __props__.__dict__["node_resource_group"] = None
        __props__.__dict__["oidc_issuer_profile"] = None
        __props__.__dict__["pod_identity_profile"] = None
        __props__.__dict__["power_state"] = None
        __props__.__dict__["private_fqdn"] = None
        __props__.__dict__["private_link_resources"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["public_network_access"] = None
        __props__.__dict__["security_profile"] = None
        __props__.__dict__["service_principal_profile"] = None
        __props__.__dict__["sku"] = None
        __props__.__dict__["storage_profile"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["windows_profile"] = None
        __props__.__dict__["workload_auto_scaler_profile"] = None
        return ManagedCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aadProfile")
    def aad_profile(self) -> pulumi.Output[Optional['outputs.ManagedClusterAADProfileResponse']]:
        """
        The Azure Active Directory configuration.
        """
        return pulumi.get(self, "aad_profile")

    @property
    @pulumi.getter(name="addonProfiles")
    def addon_profiles(self) -> pulumi.Output[Optional[Mapping[str, 'outputs.ManagedClusterAddonProfileResponse']]]:
        """
        The profile of managed cluster add-on.
        """
        return pulumi.get(self, "addon_profiles")

    @property
    @pulumi.getter(name="agentPoolProfiles")
    def agent_pool_profiles(self) -> pulumi.Output[Optional[Sequence['outputs.ManagedClusterAgentPoolProfileResponse']]]:
        """
        The agent pool properties.
        """
        return pulumi.get(self, "agent_pool_profiles")

    @property
    @pulumi.getter(name="apiServerAccessProfile")
    def api_server_access_profile(self) -> pulumi.Output[Optional['outputs.ManagedClusterAPIServerAccessProfileResponse']]:
        """
        The access profile for managed cluster API server.
        """
        return pulumi.get(self, "api_server_access_profile")

    @property
    @pulumi.getter(name="autoScalerProfile")
    def auto_scaler_profile(self) -> pulumi.Output[Optional['outputs.ManagedClusterPropertiesResponseAutoScalerProfile']]:
        """
        Parameters to be applied to the cluster-autoscaler when enabled
        """
        return pulumi.get(self, "auto_scaler_profile")

    @property
    @pulumi.getter(name="autoUpgradeProfile")
    def auto_upgrade_profile(self) -> pulumi.Output[Optional['outputs.ManagedClusterAutoUpgradeProfileResponse']]:
        """
        The auto upgrade configuration.
        """
        return pulumi.get(self, "auto_upgrade_profile")

    @property
    @pulumi.getter(name="azurePortalFQDN")
    def azure_portal_fqdn(self) -> pulumi.Output[str]:
        """
        The Azure Portal requires certain Cross-Origin Resource Sharing (CORS) headers to be sent in some responses, which Kubernetes APIServer doesn't handle by default. This special FQDN supports CORS, allowing the Azure Portal to function properly.
        """
        return pulumi.get(self, "azure_portal_fqdn")

    @property
    @pulumi.getter(name="creationData")
    def creation_data(self) -> pulumi.Output[Optional['outputs.CreationDataResponse']]:
        """
        CreationData to be used to specify the source Snapshot ID if the cluster will be created/upgraded using a snapshot.
        """
        return pulumi.get(self, "creation_data")

    @property
    @pulumi.getter(name="currentKubernetesVersion")
    def current_kubernetes_version(self) -> pulumi.Output[str]:
        """
        The version of Kubernetes the Managed Cluster is running.
        """
        return pulumi.get(self, "current_kubernetes_version")

    @property
    @pulumi.getter(name="disableLocalAccounts")
    def disable_local_accounts(self) -> pulumi.Output[Optional[bool]]:
        """
        If set to true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters that are AAD enabled. For more details see [disable local accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
        """
        return pulumi.get(self, "disable_local_accounts")

    @property
    @pulumi.getter(name="diskEncryptionSetID")
    def disk_encryption_set_id(self) -> pulumi.Output[Optional[str]]:
        """
        This is of the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @property
    @pulumi.getter(name="dnsPrefix")
    def dns_prefix(self) -> pulumi.Output[Optional[str]]:
        """
        This cannot be updated once the Managed Cluster has been created.
        """
        return pulumi.get(self, "dns_prefix")

    @property
    @pulumi.getter(name="enableNamespaceResources")
    def enable_namespace_resources(self) -> pulumi.Output[Optional[bool]]:
        """
        The default value is false. It can be enabled/disabled on creation and updation of the managed cluster. See [https://aka.ms/NamespaceARMResource](https://aka.ms/NamespaceARMResource) for more details on Namespace as a ARM Resource.
        """
        return pulumi.get(self, "enable_namespace_resources")

    @property
    @pulumi.getter(name="enablePodSecurityPolicy")
    def enable_pod_security_policy(self) -> pulumi.Output[Optional[bool]]:
        """
        (DEPRECATING) Whether to enable Kubernetes pod security policy (preview). This feature is set for removal on October 15th, 2020. Learn more at aka.ms/aks/azpodpolicy.
        """
        return pulumi.get(self, "enable_pod_security_policy")

    @property
    @pulumi.getter(name="enableRBAC")
    def enable_rbac(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable Kubernetes Role-Based Access Control.
        """
        return pulumi.get(self, "enable_rbac")

    @property
    @pulumi.getter(name="extendedLocation")
    def extended_location(self) -> pulumi.Output[Optional['outputs.ExtendedLocationResponse']]:
        """
        The extended location of the Virtual Machine.
        """
        return pulumi.get(self, "extended_location")

    @property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[str]:
        """
        The FQDN of the master pool.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="fqdnSubdomain")
    def fqdn_subdomain(self) -> pulumi.Output[Optional[str]]:
        """
        This cannot be updated once the Managed Cluster has been created.
        """
        return pulumi.get(self, "fqdn_subdomain")

    @property
    @pulumi.getter(name="httpProxyConfig")
    def http_proxy_config(self) -> pulumi.Output[Optional['outputs.ManagedClusterHTTPProxyConfigResponse']]:
        """
        Configurations for provisioning the cluster with HTTP proxy servers.
        """
        return pulumi.get(self, "http_proxy_config")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ManagedClusterIdentityResponse']]:
        """
        The identity of the managed cluster, if configured.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="identityProfile")
    def identity_profile(self) -> pulumi.Output[Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']]]:
        """
        Identities associated with the cluster.
        """
        return pulumi.get(self, "identity_profile")

    @property
    @pulumi.getter(name="ingressProfile")
    def ingress_profile(self) -> pulumi.Output[Optional['outputs.ManagedClusterIngressProfileResponse']]:
        """
        Ingress profile for the managed cluster.
        """
        return pulumi.get(self, "ingress_profile")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> pulumi.Output[Optional[str]]:
        """
        When you upgrade a supported AKS cluster, Kubernetes minor versions cannot be skipped. All upgrades must be performed sequentially by major version number. For example, upgrades between 1.14.x -> 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See [upgrading an AKS cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more details.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="linuxProfile")
    def linux_profile(self) -> pulumi.Output[Optional['outputs.ContainerServiceLinuxProfileResponse']]:
        """
        The profile for Linux VMs in the Managed Cluster.
        """
        return pulumi.get(self, "linux_profile")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maxAgentPools")
    def max_agent_pools(self) -> pulumi.Output[int]:
        """
        The max number of agent pools for the managed cluster.
        """
        return pulumi.get(self, "max_agent_pools")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> pulumi.Output[Optional['outputs.ContainerServiceNetworkProfileResponse']]:
        """
        The network configuration profile.
        """
        return pulumi.get(self, "network_profile")

    @property
    @pulumi.getter(name="nodeResourceGroup")
    def node_resource_group(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the resource group containing agent pool nodes.
        """
        return pulumi.get(self, "node_resource_group")

    @property
    @pulumi.getter(name="oidcIssuerProfile")
    def oidc_issuer_profile(self) -> pulumi.Output[Optional['outputs.ManagedClusterOIDCIssuerProfileResponse']]:
        """
        The OIDC issuer profile of the Managed Cluster.
        """
        return pulumi.get(self, "oidc_issuer_profile")

    @property
    @pulumi.getter(name="podIdentityProfile")
    def pod_identity_profile(self) -> pulumi.Output[Optional['outputs.ManagedClusterPodIdentityProfileResponse']]:
        """
        See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity integration.
        """
        return pulumi.get(self, "pod_identity_profile")

    @property
    @pulumi.getter(name="powerState")
    def power_state(self) -> pulumi.Output['outputs.PowerStateResponse']:
        """
        The Power State of the cluster.
        """
        return pulumi.get(self, "power_state")

    @property
    @pulumi.getter(name="privateFQDN")
    def private_fqdn(self) -> pulumi.Output[str]:
        """
        The FQDN of private cluster.
        """
        return pulumi.get(self, "private_fqdn")

    @property
    @pulumi.getter(name="privateLinkResources")
    def private_link_resources(self) -> pulumi.Output[Optional[Sequence['outputs.PrivateLinkResourceResponse']]]:
        """
        Private link resources associated with the cluster.
        """
        return pulumi.get(self, "private_link_resources")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        The current provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> pulumi.Output[Optional[str]]:
        """
        Allow or deny public network access for AKS
        """
        return pulumi.get(self, "public_network_access")

    @property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> pulumi.Output[Optional['outputs.ManagedClusterSecurityProfileResponse']]:
        """
        Security profile for the managed cluster.
        """
        return pulumi.get(self, "security_profile")

    @property
    @pulumi.getter(name="servicePrincipalProfile")
    def service_principal_profile(self) -> pulumi.Output[Optional['outputs.ManagedClusterServicePrincipalProfileResponse']]:
        """
        Information about a service principal identity for the cluster to use for manipulating Azure APIs.
        """
        return pulumi.get(self, "service_principal_profile")

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Output[Optional['outputs.ManagedClusterSKUResponse']]:
        """
        The managed cluster SKU.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> pulumi.Output[Optional['outputs.ManagedClusterStorageProfileResponse']]:
        """
        Storage profile for the managed cluster.
        """
        return pulumi.get(self, "storage_profile")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="windowsProfile")
    def windows_profile(self) -> pulumi.Output[Optional['outputs.ManagedClusterWindowsProfileResponse']]:
        """
        The profile for Windows VMs in the Managed Cluster.
        """
        return pulumi.get(self, "windows_profile")

    @property
    @pulumi.getter(name="workloadAutoScalerProfile")
    def workload_auto_scaler_profile(self) -> pulumi.Output[Optional['outputs.ManagedClusterWorkloadAutoScalerProfileResponse']]:
        """
        Workload Auto-scaler profile for the container service cluster.
        """
        return pulumi.get(self, "workload_auto_scaler_profile")

