# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetConnectionResult',
    'AwaitableGetConnectionResult',
    'get_connection',
    'get_connection_output',
]

@pulumi.output_type
class GetConnectionResult:
    """
    API Connection
    """
    def __init__(__self__, api=None, changed_time=None, created_time=None, custom_parameter_values=None, display_name=None, first_expiration_time=None, id=None, keywords=None, kind=None, location=None, metadata=None, name=None, non_secret_parameter_values=None, parameter_values=None, statuses=None, tags=None, tenant_id=None, type=None):
        if api and not isinstance(api, dict):
            raise TypeError("Expected argument 'api' to be a dict")
        pulumi.set(__self__, "api", api)
        if changed_time and not isinstance(changed_time, str):
            raise TypeError("Expected argument 'changed_time' to be a str")
        pulumi.set(__self__, "changed_time", changed_time)
        if created_time and not isinstance(created_time, str):
            raise TypeError("Expected argument 'created_time' to be a str")
        pulumi.set(__self__, "created_time", created_time)
        if custom_parameter_values and not isinstance(custom_parameter_values, dict):
            raise TypeError("Expected argument 'custom_parameter_values' to be a dict")
        pulumi.set(__self__, "custom_parameter_values", custom_parameter_values)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if first_expiration_time and not isinstance(first_expiration_time, str):
            raise TypeError("Expected argument 'first_expiration_time' to be a str")
        pulumi.set(__self__, "first_expiration_time", first_expiration_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if keywords and not isinstance(keywords, list):
            raise TypeError("Expected argument 'keywords' to be a list")
        pulumi.set(__self__, "keywords", keywords)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if non_secret_parameter_values and not isinstance(non_secret_parameter_values, dict):
            raise TypeError("Expected argument 'non_secret_parameter_values' to be a dict")
        pulumi.set(__self__, "non_secret_parameter_values", non_secret_parameter_values)
        if parameter_values and not isinstance(parameter_values, dict):
            raise TypeError("Expected argument 'parameter_values' to be a dict")
        pulumi.set(__self__, "parameter_values", parameter_values)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def api(self) -> Optional['outputs.ExpandedParentApiEntityResponse']:
        """
        expanded connection provider name
        """
        return pulumi.get(self, "api")

    @property
    @pulumi.getter(name="changedTime")
    def changed_time(self) -> Optional[str]:
        """
        Timestamp of last connection change.
        """
        return pulumi.get(self, "changed_time")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[str]:
        """
        Timestamp of the connection creation
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="customParameterValues")
    def custom_parameter_values(self) -> Optional[Mapping[str, 'outputs.ParameterCustomLoginSettingValuesResponse']]:
        """
        Custom login setting values.
        """
        return pulumi.get(self, "custom_parameter_values")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="firstExpirationTime")
    def first_expiration_time(self) -> Optional[str]:
        """
        Time in UTC when the first expiration of OAuth tokens
        """
        return pulumi.get(self, "first_expiration_time")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def keywords(self) -> Optional[Sequence[str]]:
        """
        List of Keywords that tag the acl
        """
        return pulumi.get(self, "keywords")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Any]:
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nonSecretParameterValues")
    def non_secret_parameter_values(self) -> Optional[Mapping[str, Any]]:
        """
        Tokens/Claim
        """
        return pulumi.get(self, "non_secret_parameter_values")

    @property
    @pulumi.getter(name="parameterValues")
    def parameter_values(self) -> Optional[Mapping[str, Any]]:
        """
        Tokens/Claim
        """
        return pulumi.get(self, "parameter_values")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.ConnectionStatusResponse']]:
        """
        Status of the connection
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")


class AwaitableGetConnectionResult(GetConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionResult(
            api=self.api,
            changed_time=self.changed_time,
            created_time=self.created_time,
            custom_parameter_values=self.custom_parameter_values,
            display_name=self.display_name,
            first_expiration_time=self.first_expiration_time,
            id=self.id,
            keywords=self.keywords,
            kind=self.kind,
            location=self.location,
            metadata=self.metadata,
            name=self.name,
            non_secret_parameter_values=self.non_secret_parameter_values,
            parameter_values=self.parameter_values,
            statuses=self.statuses,
            tags=self.tags,
            tenant_id=self.tenant_id,
            type=self.type)


def get_connection(connection_name: Optional[str] = None,
                   resource_group_name: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionResult:
    """
    API Connection


    :param str connection_name: The connection name.
    :param str resource_group_name: The resource group name.
    """
    __args__ = dict()
    __args__['connectionName'] = connection_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:web/v20150801preview:getConnection', __args__, opts=opts, typ=GetConnectionResult).value

    return AwaitableGetConnectionResult(
        api=__ret__.api,
        changed_time=__ret__.changed_time,
        created_time=__ret__.created_time,
        custom_parameter_values=__ret__.custom_parameter_values,
        display_name=__ret__.display_name,
        first_expiration_time=__ret__.first_expiration_time,
        id=__ret__.id,
        keywords=__ret__.keywords,
        kind=__ret__.kind,
        location=__ret__.location,
        metadata=__ret__.metadata,
        name=__ret__.name,
        non_secret_parameter_values=__ret__.non_secret_parameter_values,
        parameter_values=__ret__.parameter_values,
        statuses=__ret__.statuses,
        tags=__ret__.tags,
        tenant_id=__ret__.tenant_id,
        type=__ret__.type)


@_utilities.lift_output_func(get_connection)
def get_connection_output(connection_name: Optional[pulumi.Input[str]] = None,
                          resource_group_name: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConnectionResult]:
    """
    API Connection


    :param str connection_name: The connection name.
    :param str resource_group_name: The resource group name.
    """
    ...
