# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AS2AcknowledgementConnectionSettingsResponse',
    'AS2AgreementContentResponse',
    'AS2EnvelopeSettingsResponse',
    'AS2ErrorSettingsResponse',
    'AS2MdnSettingsResponse',
    'AS2MessageConnectionSettingsResponse',
    'AS2OneWayAgreementResponse',
    'AS2ProtocolSettingsResponse',
    'AS2SecuritySettingsResponse',
    'AS2ValidationSettingsResponse',
    'AgreementContentResponse',
    'B2BPartnerContentResponse',
    'BusinessIdentityResponse',
    'EdifactAcknowledgementSettingsResponse',
    'EdifactAgreementContentResponse',
    'EdifactDelimiterOverrideResponse',
    'EdifactEnvelopeOverrideResponse',
    'EdifactEnvelopeSettingsResponse',
    'EdifactFramingSettingsResponse',
    'EdifactMessageFilterResponse',
    'EdifactMessageIdentifierResponse',
    'EdifactOneWayAgreementResponse',
    'EdifactProcessingSettingsResponse',
    'EdifactProtocolSettingsResponse',
    'EdifactSchemaReferenceResponse',
    'EdifactValidationOverrideResponse',
    'EdifactValidationSettingsResponse',
    'IntegrationAccountContentHashResponse',
    'IntegrationAccountContentLinkResponse',
    'IntegrationAccountSkuResponse',
    'KeyVaultKeyReferenceResponse',
    'KeyVaultKeyReferenceResponseKeyVault',
    'PartnerContentResponse',
    'X12AcknowledgementSettingsResponse',
    'X12AgreementContentResponse',
    'X12DelimiterOverridesResponse',
    'X12EnvelopeOverrideResponse',
    'X12EnvelopeSettingsResponse',
    'X12FramingSettingsResponse',
    'X12MessageFilterResponse',
    'X12MessageIdentifierResponse',
    'X12OneWayAgreementResponse',
    'X12ProcessingSettingsResponse',
    'X12ProtocolSettingsResponse',
    'X12SchemaReferenceResponse',
    'X12SecuritySettingsResponse',
    'X12ValidationOverrideResponse',
    'X12ValidationSettingsResponse',
]

@pulumi.output_type
class AS2AcknowledgementConnectionSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCertificateNameMismatch":
            suggest = "ignore_certificate_name_mismatch"
        elif key == "keepHttpConnectionAlive":
            suggest = "keep_http_connection_alive"
        elif key == "supportHttpStatusCodeContinue":
            suggest = "support_http_status_code_continue"
        elif key == "unfoldHttpHeaders":
            suggest = "unfold_http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2AcknowledgementConnectionSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2AcknowledgementConnectionSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2AcknowledgementConnectionSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ignore_certificate_name_mismatch: Optional[bool] = None,
                 keep_http_connection_alive: Optional[bool] = None,
                 support_http_status_code_continue: Optional[bool] = None,
                 unfold_http_headers: Optional[bool] = None):
        """
        :param bool ignore_certificate_name_mismatch: The value indicating whether to ignore mismatch in certificate name.
        :param bool keep_http_connection_alive: The value indicating whether to keep the connection alive.
        :param bool support_http_status_code_continue: The value indicating whether to support HTTP status code 'CONTINUE'.
        :param bool unfold_http_headers: The value indicating whether to unfold the HTTP headers.
        """
        if ignore_certificate_name_mismatch is not None:
            pulumi.set(__self__, "ignore_certificate_name_mismatch", ignore_certificate_name_mismatch)
        if keep_http_connection_alive is not None:
            pulumi.set(__self__, "keep_http_connection_alive", keep_http_connection_alive)
        if support_http_status_code_continue is not None:
            pulumi.set(__self__, "support_http_status_code_continue", support_http_status_code_continue)
        if unfold_http_headers is not None:
            pulumi.set(__self__, "unfold_http_headers", unfold_http_headers)

    @property
    @pulumi.getter(name="ignoreCertificateNameMismatch")
    def ignore_certificate_name_mismatch(self) -> Optional[bool]:
        """
        The value indicating whether to ignore mismatch in certificate name.
        """
        return pulumi.get(self, "ignore_certificate_name_mismatch")

    @property
    @pulumi.getter(name="keepHttpConnectionAlive")
    def keep_http_connection_alive(self) -> Optional[bool]:
        """
        The value indicating whether to keep the connection alive.
        """
        return pulumi.get(self, "keep_http_connection_alive")

    @property
    @pulumi.getter(name="supportHttpStatusCodeContinue")
    def support_http_status_code_continue(self) -> Optional[bool]:
        """
        The value indicating whether to support HTTP status code 'CONTINUE'.
        """
        return pulumi.get(self, "support_http_status_code_continue")

    @property
    @pulumi.getter(name="unfoldHttpHeaders")
    def unfold_http_headers(self) -> Optional[bool]:
        """
        The value indicating whether to unfold the HTTP headers.
        """
        return pulumi.get(self, "unfold_http_headers")


@pulumi.output_type
class AS2AgreementContentResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "receiveAgreement":
            suggest = "receive_agreement"
        elif key == "sendAgreement":
            suggest = "send_agreement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2AgreementContentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2AgreementContentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2AgreementContentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 receive_agreement: Optional['outputs.AS2OneWayAgreementResponse'] = None,
                 send_agreement: Optional['outputs.AS2OneWayAgreementResponse'] = None):
        """
        :param 'AS2OneWayAgreementResponse' receive_agreement: The AS2 one-way receive agreement.
        :param 'AS2OneWayAgreementResponse' send_agreement: The AS2 one-way send agreement.
        """
        if receive_agreement is not None:
            pulumi.set(__self__, "receive_agreement", receive_agreement)
        if send_agreement is not None:
            pulumi.set(__self__, "send_agreement", send_agreement)

    @property
    @pulumi.getter(name="receiveAgreement")
    def receive_agreement(self) -> Optional['outputs.AS2OneWayAgreementResponse']:
        """
        The AS2 one-way receive agreement.
        """
        return pulumi.get(self, "receive_agreement")

    @property
    @pulumi.getter(name="sendAgreement")
    def send_agreement(self) -> Optional['outputs.AS2OneWayAgreementResponse']:
        """
        The AS2 one-way send agreement.
        """
        return pulumi.get(self, "send_agreement")


@pulumi.output_type
class AS2EnvelopeSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autogenerateFileName":
            suggest = "autogenerate_file_name"
        elif key == "fileNameTemplate":
            suggest = "file_name_template"
        elif key == "messageContentType":
            suggest = "message_content_type"
        elif key == "suspendMessageOnFileNameGenerationError":
            suggest = "suspend_message_on_file_name_generation_error"
        elif key == "transmitFileNameInMimeHeader":
            suggest = "transmit_file_name_in_mime_header"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2EnvelopeSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2EnvelopeSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2EnvelopeSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autogenerate_file_name: Optional[bool] = None,
                 file_name_template: Optional[str] = None,
                 message_content_type: Optional[str] = None,
                 suspend_message_on_file_name_generation_error: Optional[bool] = None,
                 transmit_file_name_in_mime_header: Optional[bool] = None):
        """
        :param bool autogenerate_file_name: The value indicating whether to auto generate file name.
        :param str file_name_template: The template for file name.
        :param str message_content_type: The message content type.
        :param bool suspend_message_on_file_name_generation_error: The value indicating whether to suspend message on file name generation error.
        :param bool transmit_file_name_in_mime_header: The value indicating whether to transmit file name in mime header.
        """
        if autogenerate_file_name is not None:
            pulumi.set(__self__, "autogenerate_file_name", autogenerate_file_name)
        if file_name_template is not None:
            pulumi.set(__self__, "file_name_template", file_name_template)
        if message_content_type is not None:
            pulumi.set(__self__, "message_content_type", message_content_type)
        if suspend_message_on_file_name_generation_error is not None:
            pulumi.set(__self__, "suspend_message_on_file_name_generation_error", suspend_message_on_file_name_generation_error)
        if transmit_file_name_in_mime_header is not None:
            pulumi.set(__self__, "transmit_file_name_in_mime_header", transmit_file_name_in_mime_header)

    @property
    @pulumi.getter(name="autogenerateFileName")
    def autogenerate_file_name(self) -> Optional[bool]:
        """
        The value indicating whether to auto generate file name.
        """
        return pulumi.get(self, "autogenerate_file_name")

    @property
    @pulumi.getter(name="fileNameTemplate")
    def file_name_template(self) -> Optional[str]:
        """
        The template for file name.
        """
        return pulumi.get(self, "file_name_template")

    @property
    @pulumi.getter(name="messageContentType")
    def message_content_type(self) -> Optional[str]:
        """
        The message content type.
        """
        return pulumi.get(self, "message_content_type")

    @property
    @pulumi.getter(name="suspendMessageOnFileNameGenerationError")
    def suspend_message_on_file_name_generation_error(self) -> Optional[bool]:
        """
        The value indicating whether to suspend message on file name generation error.
        """
        return pulumi.get(self, "suspend_message_on_file_name_generation_error")

    @property
    @pulumi.getter(name="transmitFileNameInMimeHeader")
    def transmit_file_name_in_mime_header(self) -> Optional[bool]:
        """
        The value indicating whether to transmit file name in mime header.
        """
        return pulumi.get(self, "transmit_file_name_in_mime_header")


@pulumi.output_type
class AS2ErrorSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resendIfMdnNotReceived":
            suggest = "resend_if_mdn_not_received"
        elif key == "suspendDuplicateMessage":
            suggest = "suspend_duplicate_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2ErrorSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2ErrorSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2ErrorSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resend_if_mdn_not_received: Optional[bool] = None,
                 suspend_duplicate_message: Optional[bool] = None):
        """
        :param bool resend_if_mdn_not_received: The value indicating whether to resend message If MDN is not received.
        :param bool suspend_duplicate_message: The value indicating whether to suspend duplicate message.
        """
        if resend_if_mdn_not_received is not None:
            pulumi.set(__self__, "resend_if_mdn_not_received", resend_if_mdn_not_received)
        if suspend_duplicate_message is not None:
            pulumi.set(__self__, "suspend_duplicate_message", suspend_duplicate_message)

    @property
    @pulumi.getter(name="resendIfMdnNotReceived")
    def resend_if_mdn_not_received(self) -> Optional[bool]:
        """
        The value indicating whether to resend message If MDN is not received.
        """
        return pulumi.get(self, "resend_if_mdn_not_received")

    @property
    @pulumi.getter(name="suspendDuplicateMessage")
    def suspend_duplicate_message(self) -> Optional[bool]:
        """
        The value indicating whether to suspend duplicate message.
        """
        return pulumi.get(self, "suspend_duplicate_message")


@pulumi.output_type
class AS2MdnSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dispositionNotificationTo":
            suggest = "disposition_notification_to"
        elif key == "mdnText":
            suggest = "mdn_text"
        elif key == "micHashingAlgorithm":
            suggest = "mic_hashing_algorithm"
        elif key == "needMdn":
            suggest = "need_mdn"
        elif key == "receiptDeliveryUrl":
            suggest = "receipt_delivery_url"
        elif key == "sendInboundMdnToMessageBox":
            suggest = "send_inbound_mdn_to_message_box"
        elif key == "sendMdnAsynchronously":
            suggest = "send_mdn_asynchronously"
        elif key == "signMdn":
            suggest = "sign_mdn"
        elif key == "signOutboundMdnIfOptional":
            suggest = "sign_outbound_mdn_if_optional"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2MdnSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2MdnSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2MdnSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disposition_notification_to: Optional[str] = None,
                 mdn_text: Optional[str] = None,
                 mic_hashing_algorithm: Optional[str] = None,
                 need_mdn: Optional[bool] = None,
                 receipt_delivery_url: Optional[str] = None,
                 send_inbound_mdn_to_message_box: Optional[bool] = None,
                 send_mdn_asynchronously: Optional[bool] = None,
                 sign_mdn: Optional[bool] = None,
                 sign_outbound_mdn_if_optional: Optional[bool] = None):
        """
        :param str disposition_notification_to: The disposition notification to header value.
        :param str mdn_text: The MDN text.
        :param str mic_hashing_algorithm: The signing or hashing algorithm.
        :param bool need_mdn: The value indicating whether to send or request a MDN.
        :param str receipt_delivery_url: The receipt delivery URL.
        :param bool send_inbound_mdn_to_message_box: The value indicating whether to send inbound MDN to message box.
        :param bool send_mdn_asynchronously: The value indicating whether to send the asynchronous MDN.
        :param bool sign_mdn: The value indicating whether the MDN needs to be signed or not.
        :param bool sign_outbound_mdn_if_optional: The value indicating whether to sign the outbound MDN if optional.
        """
        if disposition_notification_to is not None:
            pulumi.set(__self__, "disposition_notification_to", disposition_notification_to)
        if mdn_text is not None:
            pulumi.set(__self__, "mdn_text", mdn_text)
        if mic_hashing_algorithm is not None:
            pulumi.set(__self__, "mic_hashing_algorithm", mic_hashing_algorithm)
        if need_mdn is not None:
            pulumi.set(__self__, "need_mdn", need_mdn)
        if receipt_delivery_url is not None:
            pulumi.set(__self__, "receipt_delivery_url", receipt_delivery_url)
        if send_inbound_mdn_to_message_box is not None:
            pulumi.set(__self__, "send_inbound_mdn_to_message_box", send_inbound_mdn_to_message_box)
        if send_mdn_asynchronously is not None:
            pulumi.set(__self__, "send_mdn_asynchronously", send_mdn_asynchronously)
        if sign_mdn is not None:
            pulumi.set(__self__, "sign_mdn", sign_mdn)
        if sign_outbound_mdn_if_optional is not None:
            pulumi.set(__self__, "sign_outbound_mdn_if_optional", sign_outbound_mdn_if_optional)

    @property
    @pulumi.getter(name="dispositionNotificationTo")
    def disposition_notification_to(self) -> Optional[str]:
        """
        The disposition notification to header value.
        """
        return pulumi.get(self, "disposition_notification_to")

    @property
    @pulumi.getter(name="mdnText")
    def mdn_text(self) -> Optional[str]:
        """
        The MDN text.
        """
        return pulumi.get(self, "mdn_text")

    @property
    @pulumi.getter(name="micHashingAlgorithm")
    def mic_hashing_algorithm(self) -> Optional[str]:
        """
        The signing or hashing algorithm.
        """
        return pulumi.get(self, "mic_hashing_algorithm")

    @property
    @pulumi.getter(name="needMdn")
    def need_mdn(self) -> Optional[bool]:
        """
        The value indicating whether to send or request a MDN.
        """
        return pulumi.get(self, "need_mdn")

    @property
    @pulumi.getter(name="receiptDeliveryUrl")
    def receipt_delivery_url(self) -> Optional[str]:
        """
        The receipt delivery URL.
        """
        return pulumi.get(self, "receipt_delivery_url")

    @property
    @pulumi.getter(name="sendInboundMdnToMessageBox")
    def send_inbound_mdn_to_message_box(self) -> Optional[bool]:
        """
        The value indicating whether to send inbound MDN to message box.
        """
        return pulumi.get(self, "send_inbound_mdn_to_message_box")

    @property
    @pulumi.getter(name="sendMdnAsynchronously")
    def send_mdn_asynchronously(self) -> Optional[bool]:
        """
        The value indicating whether to send the asynchronous MDN.
        """
        return pulumi.get(self, "send_mdn_asynchronously")

    @property
    @pulumi.getter(name="signMdn")
    def sign_mdn(self) -> Optional[bool]:
        """
        The value indicating whether the MDN needs to be signed or not.
        """
        return pulumi.get(self, "sign_mdn")

    @property
    @pulumi.getter(name="signOutboundMdnIfOptional")
    def sign_outbound_mdn_if_optional(self) -> Optional[bool]:
        """
        The value indicating whether to sign the outbound MDN if optional.
        """
        return pulumi.get(self, "sign_outbound_mdn_if_optional")


@pulumi.output_type
class AS2MessageConnectionSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCertificateNameMismatch":
            suggest = "ignore_certificate_name_mismatch"
        elif key == "keepHttpConnectionAlive":
            suggest = "keep_http_connection_alive"
        elif key == "supportHttpStatusCodeContinue":
            suggest = "support_http_status_code_continue"
        elif key == "unfoldHttpHeaders":
            suggest = "unfold_http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2MessageConnectionSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2MessageConnectionSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2MessageConnectionSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ignore_certificate_name_mismatch: Optional[bool] = None,
                 keep_http_connection_alive: Optional[bool] = None,
                 support_http_status_code_continue: Optional[bool] = None,
                 unfold_http_headers: Optional[bool] = None):
        """
        :param bool ignore_certificate_name_mismatch: The value indicating whether to ignore mismatch in certificate name.
        :param bool keep_http_connection_alive: The value indicating whether to keep the connection alive.
        :param bool support_http_status_code_continue: The value indicating whether to support HTTP status code 'CONTINUE'.
        :param bool unfold_http_headers: The value indicating whether to unfold the HTTP headers.
        """
        if ignore_certificate_name_mismatch is not None:
            pulumi.set(__self__, "ignore_certificate_name_mismatch", ignore_certificate_name_mismatch)
        if keep_http_connection_alive is not None:
            pulumi.set(__self__, "keep_http_connection_alive", keep_http_connection_alive)
        if support_http_status_code_continue is not None:
            pulumi.set(__self__, "support_http_status_code_continue", support_http_status_code_continue)
        if unfold_http_headers is not None:
            pulumi.set(__self__, "unfold_http_headers", unfold_http_headers)

    @property
    @pulumi.getter(name="ignoreCertificateNameMismatch")
    def ignore_certificate_name_mismatch(self) -> Optional[bool]:
        """
        The value indicating whether to ignore mismatch in certificate name.
        """
        return pulumi.get(self, "ignore_certificate_name_mismatch")

    @property
    @pulumi.getter(name="keepHttpConnectionAlive")
    def keep_http_connection_alive(self) -> Optional[bool]:
        """
        The value indicating whether to keep the connection alive.
        """
        return pulumi.get(self, "keep_http_connection_alive")

    @property
    @pulumi.getter(name="supportHttpStatusCodeContinue")
    def support_http_status_code_continue(self) -> Optional[bool]:
        """
        The value indicating whether to support HTTP status code 'CONTINUE'.
        """
        return pulumi.get(self, "support_http_status_code_continue")

    @property
    @pulumi.getter(name="unfoldHttpHeaders")
    def unfold_http_headers(self) -> Optional[bool]:
        """
        The value indicating whether to unfold the HTTP headers.
        """
        return pulumi.get(self, "unfold_http_headers")


@pulumi.output_type
class AS2OneWayAgreementResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protocolSettings":
            suggest = "protocol_settings"
        elif key == "receiverBusinessIdentity":
            suggest = "receiver_business_identity"
        elif key == "senderBusinessIdentity":
            suggest = "sender_business_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2OneWayAgreementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2OneWayAgreementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2OneWayAgreementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol_settings: Optional['outputs.AS2ProtocolSettingsResponse'] = None,
                 receiver_business_identity: Optional['outputs.BusinessIdentityResponse'] = None,
                 sender_business_identity: Optional['outputs.BusinessIdentityResponse'] = None):
        """
        :param 'AS2ProtocolSettingsResponse' protocol_settings: The AS2 protocol settings.
        :param 'BusinessIdentityResponse' receiver_business_identity: The receiver business identity
        :param 'BusinessIdentityResponse' sender_business_identity: The sender business identity
        """
        if protocol_settings is not None:
            pulumi.set(__self__, "protocol_settings", protocol_settings)
        if receiver_business_identity is not None:
            pulumi.set(__self__, "receiver_business_identity", receiver_business_identity)
        if sender_business_identity is not None:
            pulumi.set(__self__, "sender_business_identity", sender_business_identity)

    @property
    @pulumi.getter(name="protocolSettings")
    def protocol_settings(self) -> Optional['outputs.AS2ProtocolSettingsResponse']:
        """
        The AS2 protocol settings.
        """
        return pulumi.get(self, "protocol_settings")

    @property
    @pulumi.getter(name="receiverBusinessIdentity")
    def receiver_business_identity(self) -> Optional['outputs.BusinessIdentityResponse']:
        """
        The receiver business identity
        """
        return pulumi.get(self, "receiver_business_identity")

    @property
    @pulumi.getter(name="senderBusinessIdentity")
    def sender_business_identity(self) -> Optional['outputs.BusinessIdentityResponse']:
        """
        The sender business identity
        """
        return pulumi.get(self, "sender_business_identity")


@pulumi.output_type
class AS2ProtocolSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acknowledgementConnectionSettings":
            suggest = "acknowledgement_connection_settings"
        elif key == "envelopeSettings":
            suggest = "envelope_settings"
        elif key == "errorSettings":
            suggest = "error_settings"
        elif key == "mdnSettings":
            suggest = "mdn_settings"
        elif key == "messageConnectionSettings":
            suggest = "message_connection_settings"
        elif key == "securitySettings":
            suggest = "security_settings"
        elif key == "validationSettings":
            suggest = "validation_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2ProtocolSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2ProtocolSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2ProtocolSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acknowledgement_connection_settings: Optional['outputs.AS2AcknowledgementConnectionSettingsResponse'] = None,
                 envelope_settings: Optional['outputs.AS2EnvelopeSettingsResponse'] = None,
                 error_settings: Optional['outputs.AS2ErrorSettingsResponse'] = None,
                 mdn_settings: Optional['outputs.AS2MdnSettingsResponse'] = None,
                 message_connection_settings: Optional['outputs.AS2MessageConnectionSettingsResponse'] = None,
                 security_settings: Optional['outputs.AS2SecuritySettingsResponse'] = None,
                 validation_settings: Optional['outputs.AS2ValidationSettingsResponse'] = None):
        """
        :param 'AS2AcknowledgementConnectionSettingsResponse' acknowledgement_connection_settings: The acknowledgement connection settings.
        :param 'AS2EnvelopeSettingsResponse' envelope_settings: The envelope settings.
        :param 'AS2ErrorSettingsResponse' error_settings: The error settings.
        :param 'AS2MdnSettingsResponse' mdn_settings: The MDN settings.
        :param 'AS2MessageConnectionSettingsResponse' message_connection_settings: The message connection settings.
        :param 'AS2SecuritySettingsResponse' security_settings: The security settings.
        :param 'AS2ValidationSettingsResponse' validation_settings: The validation settings.
        """
        if acknowledgement_connection_settings is not None:
            pulumi.set(__self__, "acknowledgement_connection_settings", acknowledgement_connection_settings)
        if envelope_settings is not None:
            pulumi.set(__self__, "envelope_settings", envelope_settings)
        if error_settings is not None:
            pulumi.set(__self__, "error_settings", error_settings)
        if mdn_settings is not None:
            pulumi.set(__self__, "mdn_settings", mdn_settings)
        if message_connection_settings is not None:
            pulumi.set(__self__, "message_connection_settings", message_connection_settings)
        if security_settings is not None:
            pulumi.set(__self__, "security_settings", security_settings)
        if validation_settings is not None:
            pulumi.set(__self__, "validation_settings", validation_settings)

    @property
    @pulumi.getter(name="acknowledgementConnectionSettings")
    def acknowledgement_connection_settings(self) -> Optional['outputs.AS2AcknowledgementConnectionSettingsResponse']:
        """
        The acknowledgement connection settings.
        """
        return pulumi.get(self, "acknowledgement_connection_settings")

    @property
    @pulumi.getter(name="envelopeSettings")
    def envelope_settings(self) -> Optional['outputs.AS2EnvelopeSettingsResponse']:
        """
        The envelope settings.
        """
        return pulumi.get(self, "envelope_settings")

    @property
    @pulumi.getter(name="errorSettings")
    def error_settings(self) -> Optional['outputs.AS2ErrorSettingsResponse']:
        """
        The error settings.
        """
        return pulumi.get(self, "error_settings")

    @property
    @pulumi.getter(name="mdnSettings")
    def mdn_settings(self) -> Optional['outputs.AS2MdnSettingsResponse']:
        """
        The MDN settings.
        """
        return pulumi.get(self, "mdn_settings")

    @property
    @pulumi.getter(name="messageConnectionSettings")
    def message_connection_settings(self) -> Optional['outputs.AS2MessageConnectionSettingsResponse']:
        """
        The message connection settings.
        """
        return pulumi.get(self, "message_connection_settings")

    @property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> Optional['outputs.AS2SecuritySettingsResponse']:
        """
        The security settings.
        """
        return pulumi.get(self, "security_settings")

    @property
    @pulumi.getter(name="validationSettings")
    def validation_settings(self) -> Optional['outputs.AS2ValidationSettingsResponse']:
        """
        The validation settings.
        """
        return pulumi.get(self, "validation_settings")


@pulumi.output_type
class AS2SecuritySettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableNrrForInboundDecodedMessages":
            suggest = "enable_nrr_for_inbound_decoded_messages"
        elif key == "enableNrrForInboundEncodedMessages":
            suggest = "enable_nrr_for_inbound_encoded_messages"
        elif key == "enableNrrForInboundMdn":
            suggest = "enable_nrr_for_inbound_mdn"
        elif key == "enableNrrForOutboundDecodedMessages":
            suggest = "enable_nrr_for_outbound_decoded_messages"
        elif key == "enableNrrForOutboundEncodedMessages":
            suggest = "enable_nrr_for_outbound_encoded_messages"
        elif key == "enableNrrForOutboundMdn":
            suggest = "enable_nrr_for_outbound_mdn"
        elif key == "encryptionCertificateName":
            suggest = "encryption_certificate_name"
        elif key == "overrideGroupSigningCertificate":
            suggest = "override_group_signing_certificate"
        elif key == "signingCertificateName":
            suggest = "signing_certificate_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2SecuritySettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2SecuritySettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2SecuritySettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_nrr_for_inbound_decoded_messages: Optional[bool] = None,
                 enable_nrr_for_inbound_encoded_messages: Optional[bool] = None,
                 enable_nrr_for_inbound_mdn: Optional[bool] = None,
                 enable_nrr_for_outbound_decoded_messages: Optional[bool] = None,
                 enable_nrr_for_outbound_encoded_messages: Optional[bool] = None,
                 enable_nrr_for_outbound_mdn: Optional[bool] = None,
                 encryption_certificate_name: Optional[str] = None,
                 override_group_signing_certificate: Optional[bool] = None,
                 signing_certificate_name: Optional[str] = None):
        """
        :param bool enable_nrr_for_inbound_decoded_messages: The value indicating whether to enable NRR for inbound decoded messages.
        :param bool enable_nrr_for_inbound_encoded_messages: The value indicating whether to enable NRR for inbound encoded messages.
        :param bool enable_nrr_for_inbound_mdn: The value indicating whether to enable NRR for inbound MDN.
        :param bool enable_nrr_for_outbound_decoded_messages: The value indicating whether to enable NRR for outbound decoded messages.
        :param bool enable_nrr_for_outbound_encoded_messages: The value indicating whether to enable NRR for outbound encoded messages.
        :param bool enable_nrr_for_outbound_mdn: The value indicating whether to enable NRR for outbound MDN.
        :param str encryption_certificate_name: The name of the encryption certificate.
        :param bool override_group_signing_certificate: The value indicating whether to send or request a MDN.
        :param str signing_certificate_name: The name of the signing certificate.
        """
        if enable_nrr_for_inbound_decoded_messages is not None:
            pulumi.set(__self__, "enable_nrr_for_inbound_decoded_messages", enable_nrr_for_inbound_decoded_messages)
        if enable_nrr_for_inbound_encoded_messages is not None:
            pulumi.set(__self__, "enable_nrr_for_inbound_encoded_messages", enable_nrr_for_inbound_encoded_messages)
        if enable_nrr_for_inbound_mdn is not None:
            pulumi.set(__self__, "enable_nrr_for_inbound_mdn", enable_nrr_for_inbound_mdn)
        if enable_nrr_for_outbound_decoded_messages is not None:
            pulumi.set(__self__, "enable_nrr_for_outbound_decoded_messages", enable_nrr_for_outbound_decoded_messages)
        if enable_nrr_for_outbound_encoded_messages is not None:
            pulumi.set(__self__, "enable_nrr_for_outbound_encoded_messages", enable_nrr_for_outbound_encoded_messages)
        if enable_nrr_for_outbound_mdn is not None:
            pulumi.set(__self__, "enable_nrr_for_outbound_mdn", enable_nrr_for_outbound_mdn)
        if encryption_certificate_name is not None:
            pulumi.set(__self__, "encryption_certificate_name", encryption_certificate_name)
        if override_group_signing_certificate is not None:
            pulumi.set(__self__, "override_group_signing_certificate", override_group_signing_certificate)
        if signing_certificate_name is not None:
            pulumi.set(__self__, "signing_certificate_name", signing_certificate_name)

    @property
    @pulumi.getter(name="enableNrrForInboundDecodedMessages")
    def enable_nrr_for_inbound_decoded_messages(self) -> Optional[bool]:
        """
        The value indicating whether to enable NRR for inbound decoded messages.
        """
        return pulumi.get(self, "enable_nrr_for_inbound_decoded_messages")

    @property
    @pulumi.getter(name="enableNrrForInboundEncodedMessages")
    def enable_nrr_for_inbound_encoded_messages(self) -> Optional[bool]:
        """
        The value indicating whether to enable NRR for inbound encoded messages.
        """
        return pulumi.get(self, "enable_nrr_for_inbound_encoded_messages")

    @property
    @pulumi.getter(name="enableNrrForInboundMdn")
    def enable_nrr_for_inbound_mdn(self) -> Optional[bool]:
        """
        The value indicating whether to enable NRR for inbound MDN.
        """
        return pulumi.get(self, "enable_nrr_for_inbound_mdn")

    @property
    @pulumi.getter(name="enableNrrForOutboundDecodedMessages")
    def enable_nrr_for_outbound_decoded_messages(self) -> Optional[bool]:
        """
        The value indicating whether to enable NRR for outbound decoded messages.
        """
        return pulumi.get(self, "enable_nrr_for_outbound_decoded_messages")

    @property
    @pulumi.getter(name="enableNrrForOutboundEncodedMessages")
    def enable_nrr_for_outbound_encoded_messages(self) -> Optional[bool]:
        """
        The value indicating whether to enable NRR for outbound encoded messages.
        """
        return pulumi.get(self, "enable_nrr_for_outbound_encoded_messages")

    @property
    @pulumi.getter(name="enableNrrForOutboundMdn")
    def enable_nrr_for_outbound_mdn(self) -> Optional[bool]:
        """
        The value indicating whether to enable NRR for outbound MDN.
        """
        return pulumi.get(self, "enable_nrr_for_outbound_mdn")

    @property
    @pulumi.getter(name="encryptionCertificateName")
    def encryption_certificate_name(self) -> Optional[str]:
        """
        The name of the encryption certificate.
        """
        return pulumi.get(self, "encryption_certificate_name")

    @property
    @pulumi.getter(name="overrideGroupSigningCertificate")
    def override_group_signing_certificate(self) -> Optional[bool]:
        """
        The value indicating whether to send or request a MDN.
        """
        return pulumi.get(self, "override_group_signing_certificate")

    @property
    @pulumi.getter(name="signingCertificateName")
    def signing_certificate_name(self) -> Optional[str]:
        """
        The name of the signing certificate.
        """
        return pulumi.get(self, "signing_certificate_name")


@pulumi.output_type
class AS2ValidationSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkCertificateRevocationListOnReceive":
            suggest = "check_certificate_revocation_list_on_receive"
        elif key == "checkCertificateRevocationListOnSend":
            suggest = "check_certificate_revocation_list_on_send"
        elif key == "checkDuplicateMessage":
            suggest = "check_duplicate_message"
        elif key == "compressMessage":
            suggest = "compress_message"
        elif key == "encryptMessage":
            suggest = "encrypt_message"
        elif key == "encryptionAlgorithm":
            suggest = "encryption_algorithm"
        elif key == "interchangeDuplicatesValidityDays":
            suggest = "interchange_duplicates_validity_days"
        elif key == "overrideMessageProperties":
            suggest = "override_message_properties"
        elif key == "signMessage":
            suggest = "sign_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2ValidationSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2ValidationSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2ValidationSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 check_certificate_revocation_list_on_receive: Optional[bool] = None,
                 check_certificate_revocation_list_on_send: Optional[bool] = None,
                 check_duplicate_message: Optional[bool] = None,
                 compress_message: Optional[bool] = None,
                 encrypt_message: Optional[bool] = None,
                 encryption_algorithm: Optional[str] = None,
                 interchange_duplicates_validity_days: Optional[int] = None,
                 override_message_properties: Optional[bool] = None,
                 sign_message: Optional[bool] = None):
        """
        :param bool check_certificate_revocation_list_on_receive: The value indicating whether to check for certificate revocation list on receive.
        :param bool check_certificate_revocation_list_on_send: The value indicating whether to check for certificate revocation list on send.
        :param bool check_duplicate_message: The value indicating whether to check for duplicate message.
        :param bool compress_message: The value indicating whether the message has to be compressed.
        :param bool encrypt_message: The value indicating whether the message has to be encrypted.
        :param str encryption_algorithm: The encryption algorithm.
        :param int interchange_duplicates_validity_days: The number of days to look back for duplicate interchange.
        :param bool override_message_properties: The value indicating whether to override incoming message properties with those in agreement.
        :param bool sign_message: The value indicating whether the message has to be signed.
        """
        if check_certificate_revocation_list_on_receive is not None:
            pulumi.set(__self__, "check_certificate_revocation_list_on_receive", check_certificate_revocation_list_on_receive)
        if check_certificate_revocation_list_on_send is not None:
            pulumi.set(__self__, "check_certificate_revocation_list_on_send", check_certificate_revocation_list_on_send)
        if check_duplicate_message is not None:
            pulumi.set(__self__, "check_duplicate_message", check_duplicate_message)
        if compress_message is not None:
            pulumi.set(__self__, "compress_message", compress_message)
        if encrypt_message is not None:
            pulumi.set(__self__, "encrypt_message", encrypt_message)
        if encryption_algorithm is not None:
            pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        if interchange_duplicates_validity_days is not None:
            pulumi.set(__self__, "interchange_duplicates_validity_days", interchange_duplicates_validity_days)
        if override_message_properties is not None:
            pulumi.set(__self__, "override_message_properties", override_message_properties)
        if sign_message is not None:
            pulumi.set(__self__, "sign_message", sign_message)

    @property
    @pulumi.getter(name="checkCertificateRevocationListOnReceive")
    def check_certificate_revocation_list_on_receive(self) -> Optional[bool]:
        """
        The value indicating whether to check for certificate revocation list on receive.
        """
        return pulumi.get(self, "check_certificate_revocation_list_on_receive")

    @property
    @pulumi.getter(name="checkCertificateRevocationListOnSend")
    def check_certificate_revocation_list_on_send(self) -> Optional[bool]:
        """
        The value indicating whether to check for certificate revocation list on send.
        """
        return pulumi.get(self, "check_certificate_revocation_list_on_send")

    @property
    @pulumi.getter(name="checkDuplicateMessage")
    def check_duplicate_message(self) -> Optional[bool]:
        """
        The value indicating whether to check for duplicate message.
        """
        return pulumi.get(self, "check_duplicate_message")

    @property
    @pulumi.getter(name="compressMessage")
    def compress_message(self) -> Optional[bool]:
        """
        The value indicating whether the message has to be compressed.
        """
        return pulumi.get(self, "compress_message")

    @property
    @pulumi.getter(name="encryptMessage")
    def encrypt_message(self) -> Optional[bool]:
        """
        The value indicating whether the message has to be encrypted.
        """
        return pulumi.get(self, "encrypt_message")

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> Optional[str]:
        """
        The encryption algorithm.
        """
        return pulumi.get(self, "encryption_algorithm")

    @property
    @pulumi.getter(name="interchangeDuplicatesValidityDays")
    def interchange_duplicates_validity_days(self) -> Optional[int]:
        """
        The number of days to look back for duplicate interchange.
        """
        return pulumi.get(self, "interchange_duplicates_validity_days")

    @property
    @pulumi.getter(name="overrideMessageProperties")
    def override_message_properties(self) -> Optional[bool]:
        """
        The value indicating whether to override incoming message properties with those in agreement.
        """
        return pulumi.get(self, "override_message_properties")

    @property
    @pulumi.getter(name="signMessage")
    def sign_message(self) -> Optional[bool]:
        """
        The value indicating whether the message has to be signed.
        """
        return pulumi.get(self, "sign_message")


@pulumi.output_type
class AgreementContentResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aS2":
            suggest = "a_s2"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgreementContentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgreementContentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgreementContentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 a_s2: Optional['outputs.AS2AgreementContentResponse'] = None,
                 edifact: Optional['outputs.EdifactAgreementContentResponse'] = None,
                 x12: Optional['outputs.X12AgreementContentResponse'] = None):
        """
        :param 'AS2AgreementContentResponse' a_s2: The AS2 agreement content.
        :param 'EdifactAgreementContentResponse' edifact: The EDIFACT agreement content.
        :param 'X12AgreementContentResponse' x12: The X12 agreement content.
        """
        if a_s2 is not None:
            pulumi.set(__self__, "a_s2", a_s2)
        if edifact is not None:
            pulumi.set(__self__, "edifact", edifact)
        if x12 is not None:
            pulumi.set(__self__, "x12", x12)

    @property
    @pulumi.getter(name="aS2")
    def a_s2(self) -> Optional['outputs.AS2AgreementContentResponse']:
        """
        The AS2 agreement content.
        """
        return pulumi.get(self, "a_s2")

    @property
    @pulumi.getter
    def edifact(self) -> Optional['outputs.EdifactAgreementContentResponse']:
        """
        The EDIFACT agreement content.
        """
        return pulumi.get(self, "edifact")

    @property
    @pulumi.getter
    def x12(self) -> Optional['outputs.X12AgreementContentResponse']:
        """
        The X12 agreement content.
        """
        return pulumi.get(self, "x12")


@pulumi.output_type
class B2BPartnerContentResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "businessIdentities":
            suggest = "business_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in B2BPartnerContentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        B2BPartnerContentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        B2BPartnerContentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 business_identities: Optional[Sequence['outputs.BusinessIdentityResponse']] = None):
        """
        :param Sequence['BusinessIdentityResponse'] business_identities: The list of partner business identities.
        """
        if business_identities is not None:
            pulumi.set(__self__, "business_identities", business_identities)

    @property
    @pulumi.getter(name="businessIdentities")
    def business_identities(self) -> Optional[Sequence['outputs.BusinessIdentityResponse']]:
        """
        The list of partner business identities.
        """
        return pulumi.get(self, "business_identities")


@pulumi.output_type
class BusinessIdentityResponse(dict):
    def __init__(__self__, *,
                 qualifier: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str qualifier: The business identity qualifier.
        :param str value: The business identity value.
        """
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def qualifier(self) -> Optional[str]:
        """
        The business identity qualifier.
        """
        return pulumi.get(self, "qualifier")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The business identity value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EdifactAcknowledgementSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acknowledgementControlNumberLowerBound":
            suggest = "acknowledgement_control_number_lower_bound"
        elif key == "acknowledgementControlNumberPrefix":
            suggest = "acknowledgement_control_number_prefix"
        elif key == "acknowledgementControlNumberSuffix":
            suggest = "acknowledgement_control_number_suffix"
        elif key == "acknowledgementControlNumberUpperBound":
            suggest = "acknowledgement_control_number_upper_bound"
        elif key == "batchFunctionalAcknowledgements":
            suggest = "batch_functional_acknowledgements"
        elif key == "batchTechnicalAcknowledgements":
            suggest = "batch_technical_acknowledgements"
        elif key == "needFunctionalAcknowledgement":
            suggest = "need_functional_acknowledgement"
        elif key == "needLoopForValidMessages":
            suggest = "need_loop_for_valid_messages"
        elif key == "needTechnicalAcknowledgement":
            suggest = "need_technical_acknowledgement"
        elif key == "rolloverAcknowledgementControlNumber":
            suggest = "rollover_acknowledgement_control_number"
        elif key == "sendSynchronousAcknowledgement":
            suggest = "send_synchronous_acknowledgement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactAcknowledgementSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactAcknowledgementSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactAcknowledgementSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acknowledgement_control_number_lower_bound: Optional[int] = None,
                 acknowledgement_control_number_prefix: Optional[str] = None,
                 acknowledgement_control_number_suffix: Optional[str] = None,
                 acknowledgement_control_number_upper_bound: Optional[int] = None,
                 batch_functional_acknowledgements: Optional[bool] = None,
                 batch_technical_acknowledgements: Optional[bool] = None,
                 need_functional_acknowledgement: Optional[bool] = None,
                 need_loop_for_valid_messages: Optional[bool] = None,
                 need_technical_acknowledgement: Optional[bool] = None,
                 rollover_acknowledgement_control_number: Optional[bool] = None,
                 send_synchronous_acknowledgement: Optional[bool] = None):
        """
        :param int acknowledgement_control_number_lower_bound: The acknowledgement control number lower bound.
        :param str acknowledgement_control_number_prefix: The acknowledgement control number prefix.
        :param str acknowledgement_control_number_suffix: The acknowledgement control number suffix.
        :param int acknowledgement_control_number_upper_bound: The acknowledgement control number upper bound.
        :param bool batch_functional_acknowledgements: The value indicating whether to batch functional acknowledgements.
        :param bool batch_technical_acknowledgements: The value indicating whether to batch the technical acknowledgements.
        :param bool need_functional_acknowledgement: The value indicating whether functional acknowledgement is needed.
        :param bool need_loop_for_valid_messages: The value indicating whether a loop is needed for valid messages.
        :param bool need_technical_acknowledgement: The value indicating whether technical acknowledgement is needed.
        :param bool rollover_acknowledgement_control_number: The value indicating whether to rollover acknowledgement control number.
        :param bool send_synchronous_acknowledgement: The value indicating whether to send synchronous acknowledgement.
        """
        if acknowledgement_control_number_lower_bound is not None:
            pulumi.set(__self__, "acknowledgement_control_number_lower_bound", acknowledgement_control_number_lower_bound)
        if acknowledgement_control_number_prefix is not None:
            pulumi.set(__self__, "acknowledgement_control_number_prefix", acknowledgement_control_number_prefix)
        if acknowledgement_control_number_suffix is not None:
            pulumi.set(__self__, "acknowledgement_control_number_suffix", acknowledgement_control_number_suffix)
        if acknowledgement_control_number_upper_bound is not None:
            pulumi.set(__self__, "acknowledgement_control_number_upper_bound", acknowledgement_control_number_upper_bound)
        if batch_functional_acknowledgements is not None:
            pulumi.set(__self__, "batch_functional_acknowledgements", batch_functional_acknowledgements)
        if batch_technical_acknowledgements is not None:
            pulumi.set(__self__, "batch_technical_acknowledgements", batch_technical_acknowledgements)
        if need_functional_acknowledgement is not None:
            pulumi.set(__self__, "need_functional_acknowledgement", need_functional_acknowledgement)
        if need_loop_for_valid_messages is not None:
            pulumi.set(__self__, "need_loop_for_valid_messages", need_loop_for_valid_messages)
        if need_technical_acknowledgement is not None:
            pulumi.set(__self__, "need_technical_acknowledgement", need_technical_acknowledgement)
        if rollover_acknowledgement_control_number is not None:
            pulumi.set(__self__, "rollover_acknowledgement_control_number", rollover_acknowledgement_control_number)
        if send_synchronous_acknowledgement is not None:
            pulumi.set(__self__, "send_synchronous_acknowledgement", send_synchronous_acknowledgement)

    @property
    @pulumi.getter(name="acknowledgementControlNumberLowerBound")
    def acknowledgement_control_number_lower_bound(self) -> Optional[int]:
        """
        The acknowledgement control number lower bound.
        """
        return pulumi.get(self, "acknowledgement_control_number_lower_bound")

    @property
    @pulumi.getter(name="acknowledgementControlNumberPrefix")
    def acknowledgement_control_number_prefix(self) -> Optional[str]:
        """
        The acknowledgement control number prefix.
        """
        return pulumi.get(self, "acknowledgement_control_number_prefix")

    @property
    @pulumi.getter(name="acknowledgementControlNumberSuffix")
    def acknowledgement_control_number_suffix(self) -> Optional[str]:
        """
        The acknowledgement control number suffix.
        """
        return pulumi.get(self, "acknowledgement_control_number_suffix")

    @property
    @pulumi.getter(name="acknowledgementControlNumberUpperBound")
    def acknowledgement_control_number_upper_bound(self) -> Optional[int]:
        """
        The acknowledgement control number upper bound.
        """
        return pulumi.get(self, "acknowledgement_control_number_upper_bound")

    @property
    @pulumi.getter(name="batchFunctionalAcknowledgements")
    def batch_functional_acknowledgements(self) -> Optional[bool]:
        """
        The value indicating whether to batch functional acknowledgements.
        """
        return pulumi.get(self, "batch_functional_acknowledgements")

    @property
    @pulumi.getter(name="batchTechnicalAcknowledgements")
    def batch_technical_acknowledgements(self) -> Optional[bool]:
        """
        The value indicating whether to batch the technical acknowledgements.
        """
        return pulumi.get(self, "batch_technical_acknowledgements")

    @property
    @pulumi.getter(name="needFunctionalAcknowledgement")
    def need_functional_acknowledgement(self) -> Optional[bool]:
        """
        The value indicating whether functional acknowledgement is needed.
        """
        return pulumi.get(self, "need_functional_acknowledgement")

    @property
    @pulumi.getter(name="needLoopForValidMessages")
    def need_loop_for_valid_messages(self) -> Optional[bool]:
        """
        The value indicating whether a loop is needed for valid messages.
        """
        return pulumi.get(self, "need_loop_for_valid_messages")

    @property
    @pulumi.getter(name="needTechnicalAcknowledgement")
    def need_technical_acknowledgement(self) -> Optional[bool]:
        """
        The value indicating whether technical acknowledgement is needed.
        """
        return pulumi.get(self, "need_technical_acknowledgement")

    @property
    @pulumi.getter(name="rolloverAcknowledgementControlNumber")
    def rollover_acknowledgement_control_number(self) -> Optional[bool]:
        """
        The value indicating whether to rollover acknowledgement control number.
        """
        return pulumi.get(self, "rollover_acknowledgement_control_number")

    @property
    @pulumi.getter(name="sendSynchronousAcknowledgement")
    def send_synchronous_acknowledgement(self) -> Optional[bool]:
        """
        The value indicating whether to send synchronous acknowledgement.
        """
        return pulumi.get(self, "send_synchronous_acknowledgement")


@pulumi.output_type
class EdifactAgreementContentResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "receiveAgreement":
            suggest = "receive_agreement"
        elif key == "sendAgreement":
            suggest = "send_agreement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactAgreementContentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactAgreementContentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactAgreementContentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 receive_agreement: Optional['outputs.EdifactOneWayAgreementResponse'] = None,
                 send_agreement: Optional['outputs.EdifactOneWayAgreementResponse'] = None):
        """
        :param 'EdifactOneWayAgreementResponse' receive_agreement: The EDIFACT one-way receive agreement.
        :param 'EdifactOneWayAgreementResponse' send_agreement: The EDIFACT one-way send agreement.
        """
        if receive_agreement is not None:
            pulumi.set(__self__, "receive_agreement", receive_agreement)
        if send_agreement is not None:
            pulumi.set(__self__, "send_agreement", send_agreement)

    @property
    @pulumi.getter(name="receiveAgreement")
    def receive_agreement(self) -> Optional['outputs.EdifactOneWayAgreementResponse']:
        """
        The EDIFACT one-way receive agreement.
        """
        return pulumi.get(self, "receive_agreement")

    @property
    @pulumi.getter(name="sendAgreement")
    def send_agreement(self) -> Optional['outputs.EdifactOneWayAgreementResponse']:
        """
        The EDIFACT one-way send agreement.
        """
        return pulumi.get(self, "send_agreement")


@pulumi.output_type
class EdifactDelimiterOverrideResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentSeparator":
            suggest = "component_separator"
        elif key == "dataElementSeparator":
            suggest = "data_element_separator"
        elif key == "decimalPointIndicator":
            suggest = "decimal_point_indicator"
        elif key == "messageAssociationAssignedCode":
            suggest = "message_association_assigned_code"
        elif key == "messageId":
            suggest = "message_id"
        elif key == "messageRelease":
            suggest = "message_release"
        elif key == "messageVersion":
            suggest = "message_version"
        elif key == "releaseIndicator":
            suggest = "release_indicator"
        elif key == "repetitionSeparator":
            suggest = "repetition_separator"
        elif key == "segmentTerminator":
            suggest = "segment_terminator"
        elif key == "segmentTerminatorSuffix":
            suggest = "segment_terminator_suffix"
        elif key == "targetNamespace":
            suggest = "target_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactDelimiterOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactDelimiterOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactDelimiterOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_separator: Optional[int] = None,
                 data_element_separator: Optional[int] = None,
                 decimal_point_indicator: Optional[str] = None,
                 message_association_assigned_code: Optional[str] = None,
                 message_id: Optional[str] = None,
                 message_release: Optional[str] = None,
                 message_version: Optional[str] = None,
                 release_indicator: Optional[int] = None,
                 repetition_separator: Optional[int] = None,
                 segment_terminator: Optional[int] = None,
                 segment_terminator_suffix: Optional[str] = None,
                 target_namespace: Optional[str] = None):
        """
        :param int component_separator: The component separator.
        :param int data_element_separator: The data element separator.
        :param str decimal_point_indicator: The decimal point indicator.
        :param str message_association_assigned_code: The message association assigned code.
        :param str message_id: The message id.
        :param str message_release: The message release version.
        :param str message_version: The message version.
        :param int release_indicator: The release indicator.
        :param int repetition_separator: The repetition separator.
        :param int segment_terminator: The segment terminator.
        :param str segment_terminator_suffix: The segment terminator suffix.
        :param str target_namespace: The target namespace on which this delimiter settings has to be applied.
        """
        if component_separator is not None:
            pulumi.set(__self__, "component_separator", component_separator)
        if data_element_separator is not None:
            pulumi.set(__self__, "data_element_separator", data_element_separator)
        if decimal_point_indicator is not None:
            pulumi.set(__self__, "decimal_point_indicator", decimal_point_indicator)
        if message_association_assigned_code is not None:
            pulumi.set(__self__, "message_association_assigned_code", message_association_assigned_code)
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)
        if message_release is not None:
            pulumi.set(__self__, "message_release", message_release)
        if message_version is not None:
            pulumi.set(__self__, "message_version", message_version)
        if release_indicator is not None:
            pulumi.set(__self__, "release_indicator", release_indicator)
        if repetition_separator is not None:
            pulumi.set(__self__, "repetition_separator", repetition_separator)
        if segment_terminator is not None:
            pulumi.set(__self__, "segment_terminator", segment_terminator)
        if segment_terminator_suffix is not None:
            pulumi.set(__self__, "segment_terminator_suffix", segment_terminator_suffix)
        if target_namespace is not None:
            pulumi.set(__self__, "target_namespace", target_namespace)

    @property
    @pulumi.getter(name="componentSeparator")
    def component_separator(self) -> Optional[int]:
        """
        The component separator.
        """
        return pulumi.get(self, "component_separator")

    @property
    @pulumi.getter(name="dataElementSeparator")
    def data_element_separator(self) -> Optional[int]:
        """
        The data element separator.
        """
        return pulumi.get(self, "data_element_separator")

    @property
    @pulumi.getter(name="decimalPointIndicator")
    def decimal_point_indicator(self) -> Optional[str]:
        """
        The decimal point indicator.
        """
        return pulumi.get(self, "decimal_point_indicator")

    @property
    @pulumi.getter(name="messageAssociationAssignedCode")
    def message_association_assigned_code(self) -> Optional[str]:
        """
        The message association assigned code.
        """
        return pulumi.get(self, "message_association_assigned_code")

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[str]:
        """
        The message id.
        """
        return pulumi.get(self, "message_id")

    @property
    @pulumi.getter(name="messageRelease")
    def message_release(self) -> Optional[str]:
        """
        The message release version.
        """
        return pulumi.get(self, "message_release")

    @property
    @pulumi.getter(name="messageVersion")
    def message_version(self) -> Optional[str]:
        """
        The message version.
        """
        return pulumi.get(self, "message_version")

    @property
    @pulumi.getter(name="releaseIndicator")
    def release_indicator(self) -> Optional[int]:
        """
        The release indicator.
        """
        return pulumi.get(self, "release_indicator")

    @property
    @pulumi.getter(name="repetitionSeparator")
    def repetition_separator(self) -> Optional[int]:
        """
        The repetition separator.
        """
        return pulumi.get(self, "repetition_separator")

    @property
    @pulumi.getter(name="segmentTerminator")
    def segment_terminator(self) -> Optional[int]:
        """
        The segment terminator.
        """
        return pulumi.get(self, "segment_terminator")

    @property
    @pulumi.getter(name="segmentTerminatorSuffix")
    def segment_terminator_suffix(self) -> Optional[str]:
        """
        The segment terminator suffix.
        """
        return pulumi.get(self, "segment_terminator_suffix")

    @property
    @pulumi.getter(name="targetNamespace")
    def target_namespace(self) -> Optional[str]:
        """
        The target namespace on which this delimiter settings has to be applied.
        """
        return pulumi.get(self, "target_namespace")


@pulumi.output_type
class EdifactEnvelopeOverrideResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationPassword":
            suggest = "application_password"
        elif key == "associationAssignedCode":
            suggest = "association_assigned_code"
        elif key == "controllingAgencyCode":
            suggest = "controlling_agency_code"
        elif key == "functionalGroupId":
            suggest = "functional_group_id"
        elif key == "groupHeaderMessageRelease":
            suggest = "group_header_message_release"
        elif key == "groupHeaderMessageVersion":
            suggest = "group_header_message_version"
        elif key == "messageAssociationAssignedCode":
            suggest = "message_association_assigned_code"
        elif key == "messageId":
            suggest = "message_id"
        elif key == "messageRelease":
            suggest = "message_release"
        elif key == "messageVersion":
            suggest = "message_version"
        elif key == "receiverApplicationId":
            suggest = "receiver_application_id"
        elif key == "receiverApplicationQualifier":
            suggest = "receiver_application_qualifier"
        elif key == "senderApplicationId":
            suggest = "sender_application_id"
        elif key == "senderApplicationQualifier":
            suggest = "sender_application_qualifier"
        elif key == "targetNamespace":
            suggest = "target_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactEnvelopeOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactEnvelopeOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactEnvelopeOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_password: Optional[str] = None,
                 association_assigned_code: Optional[str] = None,
                 controlling_agency_code: Optional[str] = None,
                 functional_group_id: Optional[str] = None,
                 group_header_message_release: Optional[str] = None,
                 group_header_message_version: Optional[str] = None,
                 message_association_assigned_code: Optional[str] = None,
                 message_id: Optional[str] = None,
                 message_release: Optional[str] = None,
                 message_version: Optional[str] = None,
                 receiver_application_id: Optional[str] = None,
                 receiver_application_qualifier: Optional[str] = None,
                 sender_application_id: Optional[str] = None,
                 sender_application_qualifier: Optional[str] = None,
                 target_namespace: Optional[str] = None):
        """
        :param str application_password: The application password.
        :param str association_assigned_code: The association assigned code.
        :param str controlling_agency_code: The controlling agency code.
        :param str functional_group_id: The functional group id.
        :param str group_header_message_release: The group header message release.
        :param str group_header_message_version: The group header message version.
        :param str message_association_assigned_code: The message association assigned code.
        :param str message_id: The message id on which this envelope settings has to be applied.
        :param str message_release: The message release version on which this envelope settings has to be applied.
        :param str message_version: The message version on which this envelope settings has to be applied.
        :param str receiver_application_id: The receiver application id.
        :param str receiver_application_qualifier: The receiver application qualifier.
        :param str sender_application_id: The sender application id.
        :param str sender_application_qualifier: The sender application qualifier.
        :param str target_namespace: The target namespace on which this envelope settings has to be applied.
        """
        if application_password is not None:
            pulumi.set(__self__, "application_password", application_password)
        if association_assigned_code is not None:
            pulumi.set(__self__, "association_assigned_code", association_assigned_code)
        if controlling_agency_code is not None:
            pulumi.set(__self__, "controlling_agency_code", controlling_agency_code)
        if functional_group_id is not None:
            pulumi.set(__self__, "functional_group_id", functional_group_id)
        if group_header_message_release is not None:
            pulumi.set(__self__, "group_header_message_release", group_header_message_release)
        if group_header_message_version is not None:
            pulumi.set(__self__, "group_header_message_version", group_header_message_version)
        if message_association_assigned_code is not None:
            pulumi.set(__self__, "message_association_assigned_code", message_association_assigned_code)
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)
        if message_release is not None:
            pulumi.set(__self__, "message_release", message_release)
        if message_version is not None:
            pulumi.set(__self__, "message_version", message_version)
        if receiver_application_id is not None:
            pulumi.set(__self__, "receiver_application_id", receiver_application_id)
        if receiver_application_qualifier is not None:
            pulumi.set(__self__, "receiver_application_qualifier", receiver_application_qualifier)
        if sender_application_id is not None:
            pulumi.set(__self__, "sender_application_id", sender_application_id)
        if sender_application_qualifier is not None:
            pulumi.set(__self__, "sender_application_qualifier", sender_application_qualifier)
        if target_namespace is not None:
            pulumi.set(__self__, "target_namespace", target_namespace)

    @property
    @pulumi.getter(name="applicationPassword")
    def application_password(self) -> Optional[str]:
        """
        The application password.
        """
        return pulumi.get(self, "application_password")

    @property
    @pulumi.getter(name="associationAssignedCode")
    def association_assigned_code(self) -> Optional[str]:
        """
        The association assigned code.
        """
        return pulumi.get(self, "association_assigned_code")

    @property
    @pulumi.getter(name="controllingAgencyCode")
    def controlling_agency_code(self) -> Optional[str]:
        """
        The controlling agency code.
        """
        return pulumi.get(self, "controlling_agency_code")

    @property
    @pulumi.getter(name="functionalGroupId")
    def functional_group_id(self) -> Optional[str]:
        """
        The functional group id.
        """
        return pulumi.get(self, "functional_group_id")

    @property
    @pulumi.getter(name="groupHeaderMessageRelease")
    def group_header_message_release(self) -> Optional[str]:
        """
        The group header message release.
        """
        return pulumi.get(self, "group_header_message_release")

    @property
    @pulumi.getter(name="groupHeaderMessageVersion")
    def group_header_message_version(self) -> Optional[str]:
        """
        The group header message version.
        """
        return pulumi.get(self, "group_header_message_version")

    @property
    @pulumi.getter(name="messageAssociationAssignedCode")
    def message_association_assigned_code(self) -> Optional[str]:
        """
        The message association assigned code.
        """
        return pulumi.get(self, "message_association_assigned_code")

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[str]:
        """
        The message id on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "message_id")

    @property
    @pulumi.getter(name="messageRelease")
    def message_release(self) -> Optional[str]:
        """
        The message release version on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "message_release")

    @property
    @pulumi.getter(name="messageVersion")
    def message_version(self) -> Optional[str]:
        """
        The message version on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "message_version")

    @property
    @pulumi.getter(name="receiverApplicationId")
    def receiver_application_id(self) -> Optional[str]:
        """
        The receiver application id.
        """
        return pulumi.get(self, "receiver_application_id")

    @property
    @pulumi.getter(name="receiverApplicationQualifier")
    def receiver_application_qualifier(self) -> Optional[str]:
        """
        The receiver application qualifier.
        """
        return pulumi.get(self, "receiver_application_qualifier")

    @property
    @pulumi.getter(name="senderApplicationId")
    def sender_application_id(self) -> Optional[str]:
        """
        The sender application id.
        """
        return pulumi.get(self, "sender_application_id")

    @property
    @pulumi.getter(name="senderApplicationQualifier")
    def sender_application_qualifier(self) -> Optional[str]:
        """
        The sender application qualifier.
        """
        return pulumi.get(self, "sender_application_qualifier")

    @property
    @pulumi.getter(name="targetNamespace")
    def target_namespace(self) -> Optional[str]:
        """
        The target namespace on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "target_namespace")


@pulumi.output_type
class EdifactEnvelopeSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationReferenceId":
            suggest = "application_reference_id"
        elif key == "applyDelimiterStringAdvice":
            suggest = "apply_delimiter_string_advice"
        elif key == "communicationAgreementId":
            suggest = "communication_agreement_id"
        elif key == "createGroupingSegments":
            suggest = "create_grouping_segments"
        elif key == "enableDefaultGroupHeaders":
            suggest = "enable_default_group_headers"
        elif key == "functionalGroupId":
            suggest = "functional_group_id"
        elif key == "groupApplicationPassword":
            suggest = "group_application_password"
        elif key == "groupApplicationReceiverId":
            suggest = "group_application_receiver_id"
        elif key == "groupApplicationReceiverQualifier":
            suggest = "group_application_receiver_qualifier"
        elif key == "groupApplicationSenderId":
            suggest = "group_application_sender_id"
        elif key == "groupApplicationSenderQualifier":
            suggest = "group_application_sender_qualifier"
        elif key == "groupAssociationAssignedCode":
            suggest = "group_association_assigned_code"
        elif key == "groupControlNumberLowerBound":
            suggest = "group_control_number_lower_bound"
        elif key == "groupControlNumberPrefix":
            suggest = "group_control_number_prefix"
        elif key == "groupControlNumberSuffix":
            suggest = "group_control_number_suffix"
        elif key == "groupControlNumberUpperBound":
            suggest = "group_control_number_upper_bound"
        elif key == "groupControllingAgencyCode":
            suggest = "group_controlling_agency_code"
        elif key == "groupMessageRelease":
            suggest = "group_message_release"
        elif key == "groupMessageVersion":
            suggest = "group_message_version"
        elif key == "interchangeControlNumberLowerBound":
            suggest = "interchange_control_number_lower_bound"
        elif key == "interchangeControlNumberPrefix":
            suggest = "interchange_control_number_prefix"
        elif key == "interchangeControlNumberSuffix":
            suggest = "interchange_control_number_suffix"
        elif key == "interchangeControlNumberUpperBound":
            suggest = "interchange_control_number_upper_bound"
        elif key == "isTestInterchange":
            suggest = "is_test_interchange"
        elif key == "overwriteExistingTransactionSetControlNumber":
            suggest = "overwrite_existing_transaction_set_control_number"
        elif key == "processingPriorityCode":
            suggest = "processing_priority_code"
        elif key == "receiverInternalIdentification":
            suggest = "receiver_internal_identification"
        elif key == "receiverInternalSubIdentification":
            suggest = "receiver_internal_sub_identification"
        elif key == "receiverReverseRoutingAddress":
            suggest = "receiver_reverse_routing_address"
        elif key == "recipientReferencePasswordQualifier":
            suggest = "recipient_reference_password_qualifier"
        elif key == "recipientReferencePasswordValue":
            suggest = "recipient_reference_password_value"
        elif key == "rolloverGroupControlNumber":
            suggest = "rollover_group_control_number"
        elif key == "rolloverInterchangeControlNumber":
            suggest = "rollover_interchange_control_number"
        elif key == "rolloverTransactionSetControlNumber":
            suggest = "rollover_transaction_set_control_number"
        elif key == "senderInternalIdentification":
            suggest = "sender_internal_identification"
        elif key == "senderInternalSubIdentification":
            suggest = "sender_internal_sub_identification"
        elif key == "senderReverseRoutingAddress":
            suggest = "sender_reverse_routing_address"
        elif key == "transactionSetControlNumberLowerBound":
            suggest = "transaction_set_control_number_lower_bound"
        elif key == "transactionSetControlNumberPrefix":
            suggest = "transaction_set_control_number_prefix"
        elif key == "transactionSetControlNumberSuffix":
            suggest = "transaction_set_control_number_suffix"
        elif key == "transactionSetControlNumberUpperBound":
            suggest = "transaction_set_control_number_upper_bound"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactEnvelopeSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactEnvelopeSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactEnvelopeSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_reference_id: Optional[str] = None,
                 apply_delimiter_string_advice: Optional[bool] = None,
                 communication_agreement_id: Optional[str] = None,
                 create_grouping_segments: Optional[bool] = None,
                 enable_default_group_headers: Optional[bool] = None,
                 functional_group_id: Optional[str] = None,
                 group_application_password: Optional[str] = None,
                 group_application_receiver_id: Optional[str] = None,
                 group_application_receiver_qualifier: Optional[str] = None,
                 group_application_sender_id: Optional[str] = None,
                 group_application_sender_qualifier: Optional[str] = None,
                 group_association_assigned_code: Optional[str] = None,
                 group_control_number_lower_bound: Optional[float] = None,
                 group_control_number_prefix: Optional[str] = None,
                 group_control_number_suffix: Optional[str] = None,
                 group_control_number_upper_bound: Optional[float] = None,
                 group_controlling_agency_code: Optional[str] = None,
                 group_message_release: Optional[str] = None,
                 group_message_version: Optional[str] = None,
                 interchange_control_number_lower_bound: Optional[float] = None,
                 interchange_control_number_prefix: Optional[str] = None,
                 interchange_control_number_suffix: Optional[str] = None,
                 interchange_control_number_upper_bound: Optional[float] = None,
                 is_test_interchange: Optional[bool] = None,
                 overwrite_existing_transaction_set_control_number: Optional[bool] = None,
                 processing_priority_code: Optional[str] = None,
                 receiver_internal_identification: Optional[str] = None,
                 receiver_internal_sub_identification: Optional[str] = None,
                 receiver_reverse_routing_address: Optional[str] = None,
                 recipient_reference_password_qualifier: Optional[str] = None,
                 recipient_reference_password_value: Optional[str] = None,
                 rollover_group_control_number: Optional[bool] = None,
                 rollover_interchange_control_number: Optional[bool] = None,
                 rollover_transaction_set_control_number: Optional[bool] = None,
                 sender_internal_identification: Optional[str] = None,
                 sender_internal_sub_identification: Optional[str] = None,
                 sender_reverse_routing_address: Optional[str] = None,
                 transaction_set_control_number_lower_bound: Optional[float] = None,
                 transaction_set_control_number_prefix: Optional[str] = None,
                 transaction_set_control_number_suffix: Optional[str] = None,
                 transaction_set_control_number_upper_bound: Optional[float] = None):
        """
        :param str application_reference_id: The application reference id.
        :param bool apply_delimiter_string_advice: The value indicating whether to apply delimiter string advice.
        :param str communication_agreement_id: The communication agreement id.
        :param bool create_grouping_segments: The value indicating whether to create grouping segments.
        :param bool enable_default_group_headers: The value indicating whether to enable default group headers.
        :param str functional_group_id: The functional group id.
        :param str group_application_password: The group application password.
        :param str group_application_receiver_id: The group application receiver id.
        :param str group_application_receiver_qualifier: The group application receiver qualifier.
        :param str group_application_sender_id: The group application sender id.
        :param str group_application_sender_qualifier: The group application sender qualifier.
        :param str group_association_assigned_code: The group association assigned code.
        :param float group_control_number_lower_bound: The group control number lower bound.
        :param str group_control_number_prefix: The group control number prefix.
        :param str group_control_number_suffix: The group control number suffix.
        :param float group_control_number_upper_bound: The group control number upper bound.
        :param str group_controlling_agency_code: The group controlling agency code.
        :param str group_message_release: The group message release.
        :param str group_message_version: The group message version.
        :param float interchange_control_number_lower_bound: The interchange control number lower bound.
        :param str interchange_control_number_prefix: The interchange control number prefix.
        :param str interchange_control_number_suffix: The interchange control number suffix.
        :param float interchange_control_number_upper_bound: The interchange control number upper bound.
        :param bool is_test_interchange: The value indicating whether the message is a test interchange.
        :param bool overwrite_existing_transaction_set_control_number: The value indicating whether to overwrite existing transaction set control number.
        :param str processing_priority_code: The processing priority code.
        :param str receiver_internal_identification: The receiver internal identification.
        :param str receiver_internal_sub_identification: The receiver internal sub identification.
        :param str receiver_reverse_routing_address: The receiver reverse routing address.
        :param str recipient_reference_password_qualifier: The recipient reference password qualifier.
        :param str recipient_reference_password_value: The recipient reference password value.
        :param bool rollover_group_control_number: The value indicating whether to rollover group control number.
        :param bool rollover_interchange_control_number: The value indicating whether to rollover interchange control number.
        :param bool rollover_transaction_set_control_number: The value indicating whether to rollover transaction set control number.
        :param str sender_internal_identification: The sender internal identification.
        :param str sender_internal_sub_identification: The sender internal sub identification.
        :param str sender_reverse_routing_address: The sender reverse routing address.
        :param float transaction_set_control_number_lower_bound: The transaction set control number lower bound.
        :param str transaction_set_control_number_prefix: The transaction set control number prefix.
        :param str transaction_set_control_number_suffix: The transaction set control number suffix.
        :param float transaction_set_control_number_upper_bound: The transaction set control number upper bound.
        """
        if application_reference_id is not None:
            pulumi.set(__self__, "application_reference_id", application_reference_id)
        if apply_delimiter_string_advice is not None:
            pulumi.set(__self__, "apply_delimiter_string_advice", apply_delimiter_string_advice)
        if communication_agreement_id is not None:
            pulumi.set(__self__, "communication_agreement_id", communication_agreement_id)
        if create_grouping_segments is not None:
            pulumi.set(__self__, "create_grouping_segments", create_grouping_segments)
        if enable_default_group_headers is not None:
            pulumi.set(__self__, "enable_default_group_headers", enable_default_group_headers)
        if functional_group_id is not None:
            pulumi.set(__self__, "functional_group_id", functional_group_id)
        if group_application_password is not None:
            pulumi.set(__self__, "group_application_password", group_application_password)
        if group_application_receiver_id is not None:
            pulumi.set(__self__, "group_application_receiver_id", group_application_receiver_id)
        if group_application_receiver_qualifier is not None:
            pulumi.set(__self__, "group_application_receiver_qualifier", group_application_receiver_qualifier)
        if group_application_sender_id is not None:
            pulumi.set(__self__, "group_application_sender_id", group_application_sender_id)
        if group_application_sender_qualifier is not None:
            pulumi.set(__self__, "group_application_sender_qualifier", group_application_sender_qualifier)
        if group_association_assigned_code is not None:
            pulumi.set(__self__, "group_association_assigned_code", group_association_assigned_code)
        if group_control_number_lower_bound is not None:
            pulumi.set(__self__, "group_control_number_lower_bound", group_control_number_lower_bound)
        if group_control_number_prefix is not None:
            pulumi.set(__self__, "group_control_number_prefix", group_control_number_prefix)
        if group_control_number_suffix is not None:
            pulumi.set(__self__, "group_control_number_suffix", group_control_number_suffix)
        if group_control_number_upper_bound is not None:
            pulumi.set(__self__, "group_control_number_upper_bound", group_control_number_upper_bound)
        if group_controlling_agency_code is not None:
            pulumi.set(__self__, "group_controlling_agency_code", group_controlling_agency_code)
        if group_message_release is not None:
            pulumi.set(__self__, "group_message_release", group_message_release)
        if group_message_version is not None:
            pulumi.set(__self__, "group_message_version", group_message_version)
        if interchange_control_number_lower_bound is not None:
            pulumi.set(__self__, "interchange_control_number_lower_bound", interchange_control_number_lower_bound)
        if interchange_control_number_prefix is not None:
            pulumi.set(__self__, "interchange_control_number_prefix", interchange_control_number_prefix)
        if interchange_control_number_suffix is not None:
            pulumi.set(__self__, "interchange_control_number_suffix", interchange_control_number_suffix)
        if interchange_control_number_upper_bound is not None:
            pulumi.set(__self__, "interchange_control_number_upper_bound", interchange_control_number_upper_bound)
        if is_test_interchange is not None:
            pulumi.set(__self__, "is_test_interchange", is_test_interchange)
        if overwrite_existing_transaction_set_control_number is not None:
            pulumi.set(__self__, "overwrite_existing_transaction_set_control_number", overwrite_existing_transaction_set_control_number)
        if processing_priority_code is not None:
            pulumi.set(__self__, "processing_priority_code", processing_priority_code)
        if receiver_internal_identification is not None:
            pulumi.set(__self__, "receiver_internal_identification", receiver_internal_identification)
        if receiver_internal_sub_identification is not None:
            pulumi.set(__self__, "receiver_internal_sub_identification", receiver_internal_sub_identification)
        if receiver_reverse_routing_address is not None:
            pulumi.set(__self__, "receiver_reverse_routing_address", receiver_reverse_routing_address)
        if recipient_reference_password_qualifier is not None:
            pulumi.set(__self__, "recipient_reference_password_qualifier", recipient_reference_password_qualifier)
        if recipient_reference_password_value is not None:
            pulumi.set(__self__, "recipient_reference_password_value", recipient_reference_password_value)
        if rollover_group_control_number is not None:
            pulumi.set(__self__, "rollover_group_control_number", rollover_group_control_number)
        if rollover_interchange_control_number is not None:
            pulumi.set(__self__, "rollover_interchange_control_number", rollover_interchange_control_number)
        if rollover_transaction_set_control_number is not None:
            pulumi.set(__self__, "rollover_transaction_set_control_number", rollover_transaction_set_control_number)
        if sender_internal_identification is not None:
            pulumi.set(__self__, "sender_internal_identification", sender_internal_identification)
        if sender_internal_sub_identification is not None:
            pulumi.set(__self__, "sender_internal_sub_identification", sender_internal_sub_identification)
        if sender_reverse_routing_address is not None:
            pulumi.set(__self__, "sender_reverse_routing_address", sender_reverse_routing_address)
        if transaction_set_control_number_lower_bound is not None:
            pulumi.set(__self__, "transaction_set_control_number_lower_bound", transaction_set_control_number_lower_bound)
        if transaction_set_control_number_prefix is not None:
            pulumi.set(__self__, "transaction_set_control_number_prefix", transaction_set_control_number_prefix)
        if transaction_set_control_number_suffix is not None:
            pulumi.set(__self__, "transaction_set_control_number_suffix", transaction_set_control_number_suffix)
        if transaction_set_control_number_upper_bound is not None:
            pulumi.set(__self__, "transaction_set_control_number_upper_bound", transaction_set_control_number_upper_bound)

    @property
    @pulumi.getter(name="applicationReferenceId")
    def application_reference_id(self) -> Optional[str]:
        """
        The application reference id.
        """
        return pulumi.get(self, "application_reference_id")

    @property
    @pulumi.getter(name="applyDelimiterStringAdvice")
    def apply_delimiter_string_advice(self) -> Optional[bool]:
        """
        The value indicating whether to apply delimiter string advice.
        """
        return pulumi.get(self, "apply_delimiter_string_advice")

    @property
    @pulumi.getter(name="communicationAgreementId")
    def communication_agreement_id(self) -> Optional[str]:
        """
        The communication agreement id.
        """
        return pulumi.get(self, "communication_agreement_id")

    @property
    @pulumi.getter(name="createGroupingSegments")
    def create_grouping_segments(self) -> Optional[bool]:
        """
        The value indicating whether to create grouping segments.
        """
        return pulumi.get(self, "create_grouping_segments")

    @property
    @pulumi.getter(name="enableDefaultGroupHeaders")
    def enable_default_group_headers(self) -> Optional[bool]:
        """
        The value indicating whether to enable default group headers.
        """
        return pulumi.get(self, "enable_default_group_headers")

    @property
    @pulumi.getter(name="functionalGroupId")
    def functional_group_id(self) -> Optional[str]:
        """
        The functional group id.
        """
        return pulumi.get(self, "functional_group_id")

    @property
    @pulumi.getter(name="groupApplicationPassword")
    def group_application_password(self) -> Optional[str]:
        """
        The group application password.
        """
        return pulumi.get(self, "group_application_password")

    @property
    @pulumi.getter(name="groupApplicationReceiverId")
    def group_application_receiver_id(self) -> Optional[str]:
        """
        The group application receiver id.
        """
        return pulumi.get(self, "group_application_receiver_id")

    @property
    @pulumi.getter(name="groupApplicationReceiverQualifier")
    def group_application_receiver_qualifier(self) -> Optional[str]:
        """
        The group application receiver qualifier.
        """
        return pulumi.get(self, "group_application_receiver_qualifier")

    @property
    @pulumi.getter(name="groupApplicationSenderId")
    def group_application_sender_id(self) -> Optional[str]:
        """
        The group application sender id.
        """
        return pulumi.get(self, "group_application_sender_id")

    @property
    @pulumi.getter(name="groupApplicationSenderQualifier")
    def group_application_sender_qualifier(self) -> Optional[str]:
        """
        The group application sender qualifier.
        """
        return pulumi.get(self, "group_application_sender_qualifier")

    @property
    @pulumi.getter(name="groupAssociationAssignedCode")
    def group_association_assigned_code(self) -> Optional[str]:
        """
        The group association assigned code.
        """
        return pulumi.get(self, "group_association_assigned_code")

    @property
    @pulumi.getter(name="groupControlNumberLowerBound")
    def group_control_number_lower_bound(self) -> Optional[float]:
        """
        The group control number lower bound.
        """
        return pulumi.get(self, "group_control_number_lower_bound")

    @property
    @pulumi.getter(name="groupControlNumberPrefix")
    def group_control_number_prefix(self) -> Optional[str]:
        """
        The group control number prefix.
        """
        return pulumi.get(self, "group_control_number_prefix")

    @property
    @pulumi.getter(name="groupControlNumberSuffix")
    def group_control_number_suffix(self) -> Optional[str]:
        """
        The group control number suffix.
        """
        return pulumi.get(self, "group_control_number_suffix")

    @property
    @pulumi.getter(name="groupControlNumberUpperBound")
    def group_control_number_upper_bound(self) -> Optional[float]:
        """
        The group control number upper bound.
        """
        return pulumi.get(self, "group_control_number_upper_bound")

    @property
    @pulumi.getter(name="groupControllingAgencyCode")
    def group_controlling_agency_code(self) -> Optional[str]:
        """
        The group controlling agency code.
        """
        return pulumi.get(self, "group_controlling_agency_code")

    @property
    @pulumi.getter(name="groupMessageRelease")
    def group_message_release(self) -> Optional[str]:
        """
        The group message release.
        """
        return pulumi.get(self, "group_message_release")

    @property
    @pulumi.getter(name="groupMessageVersion")
    def group_message_version(self) -> Optional[str]:
        """
        The group message version.
        """
        return pulumi.get(self, "group_message_version")

    @property
    @pulumi.getter(name="interchangeControlNumberLowerBound")
    def interchange_control_number_lower_bound(self) -> Optional[float]:
        """
        The interchange control number lower bound.
        """
        return pulumi.get(self, "interchange_control_number_lower_bound")

    @property
    @pulumi.getter(name="interchangeControlNumberPrefix")
    def interchange_control_number_prefix(self) -> Optional[str]:
        """
        The interchange control number prefix.
        """
        return pulumi.get(self, "interchange_control_number_prefix")

    @property
    @pulumi.getter(name="interchangeControlNumberSuffix")
    def interchange_control_number_suffix(self) -> Optional[str]:
        """
        The interchange control number suffix.
        """
        return pulumi.get(self, "interchange_control_number_suffix")

    @property
    @pulumi.getter(name="interchangeControlNumberUpperBound")
    def interchange_control_number_upper_bound(self) -> Optional[float]:
        """
        The interchange control number upper bound.
        """
        return pulumi.get(self, "interchange_control_number_upper_bound")

    @property
    @pulumi.getter(name="isTestInterchange")
    def is_test_interchange(self) -> Optional[bool]:
        """
        The value indicating whether the message is a test interchange.
        """
        return pulumi.get(self, "is_test_interchange")

    @property
    @pulumi.getter(name="overwriteExistingTransactionSetControlNumber")
    def overwrite_existing_transaction_set_control_number(self) -> Optional[bool]:
        """
        The value indicating whether to overwrite existing transaction set control number.
        """
        return pulumi.get(self, "overwrite_existing_transaction_set_control_number")

    @property
    @pulumi.getter(name="processingPriorityCode")
    def processing_priority_code(self) -> Optional[str]:
        """
        The processing priority code.
        """
        return pulumi.get(self, "processing_priority_code")

    @property
    @pulumi.getter(name="receiverInternalIdentification")
    def receiver_internal_identification(self) -> Optional[str]:
        """
        The receiver internal identification.
        """
        return pulumi.get(self, "receiver_internal_identification")

    @property
    @pulumi.getter(name="receiverInternalSubIdentification")
    def receiver_internal_sub_identification(self) -> Optional[str]:
        """
        The receiver internal sub identification.
        """
        return pulumi.get(self, "receiver_internal_sub_identification")

    @property
    @pulumi.getter(name="receiverReverseRoutingAddress")
    def receiver_reverse_routing_address(self) -> Optional[str]:
        """
        The receiver reverse routing address.
        """
        return pulumi.get(self, "receiver_reverse_routing_address")

    @property
    @pulumi.getter(name="recipientReferencePasswordQualifier")
    def recipient_reference_password_qualifier(self) -> Optional[str]:
        """
        The recipient reference password qualifier.
        """
        return pulumi.get(self, "recipient_reference_password_qualifier")

    @property
    @pulumi.getter(name="recipientReferencePasswordValue")
    def recipient_reference_password_value(self) -> Optional[str]:
        """
        The recipient reference password value.
        """
        return pulumi.get(self, "recipient_reference_password_value")

    @property
    @pulumi.getter(name="rolloverGroupControlNumber")
    def rollover_group_control_number(self) -> Optional[bool]:
        """
        The value indicating whether to rollover group control number.
        """
        return pulumi.get(self, "rollover_group_control_number")

    @property
    @pulumi.getter(name="rolloverInterchangeControlNumber")
    def rollover_interchange_control_number(self) -> Optional[bool]:
        """
        The value indicating whether to rollover interchange control number.
        """
        return pulumi.get(self, "rollover_interchange_control_number")

    @property
    @pulumi.getter(name="rolloverTransactionSetControlNumber")
    def rollover_transaction_set_control_number(self) -> Optional[bool]:
        """
        The value indicating whether to rollover transaction set control number.
        """
        return pulumi.get(self, "rollover_transaction_set_control_number")

    @property
    @pulumi.getter(name="senderInternalIdentification")
    def sender_internal_identification(self) -> Optional[str]:
        """
        The sender internal identification.
        """
        return pulumi.get(self, "sender_internal_identification")

    @property
    @pulumi.getter(name="senderInternalSubIdentification")
    def sender_internal_sub_identification(self) -> Optional[str]:
        """
        The sender internal sub identification.
        """
        return pulumi.get(self, "sender_internal_sub_identification")

    @property
    @pulumi.getter(name="senderReverseRoutingAddress")
    def sender_reverse_routing_address(self) -> Optional[str]:
        """
        The sender reverse routing address.
        """
        return pulumi.get(self, "sender_reverse_routing_address")

    @property
    @pulumi.getter(name="transactionSetControlNumberLowerBound")
    def transaction_set_control_number_lower_bound(self) -> Optional[float]:
        """
        The transaction set control number lower bound.
        """
        return pulumi.get(self, "transaction_set_control_number_lower_bound")

    @property
    @pulumi.getter(name="transactionSetControlNumberPrefix")
    def transaction_set_control_number_prefix(self) -> Optional[str]:
        """
        The transaction set control number prefix.
        """
        return pulumi.get(self, "transaction_set_control_number_prefix")

    @property
    @pulumi.getter(name="transactionSetControlNumberSuffix")
    def transaction_set_control_number_suffix(self) -> Optional[str]:
        """
        The transaction set control number suffix.
        """
        return pulumi.get(self, "transaction_set_control_number_suffix")

    @property
    @pulumi.getter(name="transactionSetControlNumberUpperBound")
    def transaction_set_control_number_upper_bound(self) -> Optional[float]:
        """
        The transaction set control number upper bound.
        """
        return pulumi.get(self, "transaction_set_control_number_upper_bound")


@pulumi.output_type
class EdifactFramingSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "characterEncoding":
            suggest = "character_encoding"
        elif key == "characterSet":
            suggest = "character_set"
        elif key == "componentSeparator":
            suggest = "component_separator"
        elif key == "dataElementSeparator":
            suggest = "data_element_separator"
        elif key == "decimalPointIndicator":
            suggest = "decimal_point_indicator"
        elif key == "protocolVersion":
            suggest = "protocol_version"
        elif key == "releaseIndicator":
            suggest = "release_indicator"
        elif key == "repetitionSeparator":
            suggest = "repetition_separator"
        elif key == "segmentTerminator":
            suggest = "segment_terminator"
        elif key == "segmentTerminatorSuffix":
            suggest = "segment_terminator_suffix"
        elif key == "serviceCodeListDirectoryVersion":
            suggest = "service_code_list_directory_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactFramingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactFramingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactFramingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 character_encoding: Optional[str] = None,
                 character_set: Optional[str] = None,
                 component_separator: Optional[int] = None,
                 data_element_separator: Optional[int] = None,
                 decimal_point_indicator: Optional[str] = None,
                 protocol_version: Optional[int] = None,
                 release_indicator: Optional[int] = None,
                 repetition_separator: Optional[int] = None,
                 segment_terminator: Optional[int] = None,
                 segment_terminator_suffix: Optional[str] = None,
                 service_code_list_directory_version: Optional[str] = None):
        """
        :param str character_encoding: The character encoding.
        :param str character_set: The EDIFACT frame setting characterSet.
        :param int component_separator: The component separator.
        :param int data_element_separator: The data element separator.
        :param str decimal_point_indicator: The EDIFACT frame setting decimal indicator.
        :param int protocol_version: The protocol version.
        :param int release_indicator: The release indicator.
        :param int repetition_separator: The repetition separator.
        :param int segment_terminator: The segment terminator.
        :param str segment_terminator_suffix: The EDIFACT frame setting segment terminator suffix.
        :param str service_code_list_directory_version: The service code list directory version.
        """
        if character_encoding is not None:
            pulumi.set(__self__, "character_encoding", character_encoding)
        if character_set is not None:
            pulumi.set(__self__, "character_set", character_set)
        if component_separator is not None:
            pulumi.set(__self__, "component_separator", component_separator)
        if data_element_separator is not None:
            pulumi.set(__self__, "data_element_separator", data_element_separator)
        if decimal_point_indicator is not None:
            pulumi.set(__self__, "decimal_point_indicator", decimal_point_indicator)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if release_indicator is not None:
            pulumi.set(__self__, "release_indicator", release_indicator)
        if repetition_separator is not None:
            pulumi.set(__self__, "repetition_separator", repetition_separator)
        if segment_terminator is not None:
            pulumi.set(__self__, "segment_terminator", segment_terminator)
        if segment_terminator_suffix is not None:
            pulumi.set(__self__, "segment_terminator_suffix", segment_terminator_suffix)
        if service_code_list_directory_version is not None:
            pulumi.set(__self__, "service_code_list_directory_version", service_code_list_directory_version)

    @property
    @pulumi.getter(name="characterEncoding")
    def character_encoding(self) -> Optional[str]:
        """
        The character encoding.
        """
        return pulumi.get(self, "character_encoding")

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> Optional[str]:
        """
        The EDIFACT frame setting characterSet.
        """
        return pulumi.get(self, "character_set")

    @property
    @pulumi.getter(name="componentSeparator")
    def component_separator(self) -> Optional[int]:
        """
        The component separator.
        """
        return pulumi.get(self, "component_separator")

    @property
    @pulumi.getter(name="dataElementSeparator")
    def data_element_separator(self) -> Optional[int]:
        """
        The data element separator.
        """
        return pulumi.get(self, "data_element_separator")

    @property
    @pulumi.getter(name="decimalPointIndicator")
    def decimal_point_indicator(self) -> Optional[str]:
        """
        The EDIFACT frame setting decimal indicator.
        """
        return pulumi.get(self, "decimal_point_indicator")

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[int]:
        """
        The protocol version.
        """
        return pulumi.get(self, "protocol_version")

    @property
    @pulumi.getter(name="releaseIndicator")
    def release_indicator(self) -> Optional[int]:
        """
        The release indicator.
        """
        return pulumi.get(self, "release_indicator")

    @property
    @pulumi.getter(name="repetitionSeparator")
    def repetition_separator(self) -> Optional[int]:
        """
        The repetition separator.
        """
        return pulumi.get(self, "repetition_separator")

    @property
    @pulumi.getter(name="segmentTerminator")
    def segment_terminator(self) -> Optional[int]:
        """
        The segment terminator.
        """
        return pulumi.get(self, "segment_terminator")

    @property
    @pulumi.getter(name="segmentTerminatorSuffix")
    def segment_terminator_suffix(self) -> Optional[str]:
        """
        The EDIFACT frame setting segment terminator suffix.
        """
        return pulumi.get(self, "segment_terminator_suffix")

    @property
    @pulumi.getter(name="serviceCodeListDirectoryVersion")
    def service_code_list_directory_version(self) -> Optional[str]:
        """
        The service code list directory version.
        """
        return pulumi.get(self, "service_code_list_directory_version")


@pulumi.output_type
class EdifactMessageFilterResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageFilterType":
            suggest = "message_filter_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactMessageFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactMessageFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactMessageFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_filter_type: Optional[str] = None):
        """
        :param str message_filter_type: The message filter type.
        """
        if message_filter_type is not None:
            pulumi.set(__self__, "message_filter_type", message_filter_type)

    @property
    @pulumi.getter(name="messageFilterType")
    def message_filter_type(self) -> Optional[str]:
        """
        The message filter type.
        """
        return pulumi.get(self, "message_filter_type")


@pulumi.output_type
class EdifactMessageIdentifierResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageId":
            suggest = "message_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactMessageIdentifierResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactMessageIdentifierResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactMessageIdentifierResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_id: Optional[str] = None):
        """
        :param str message_id: The message id on which this envelope settings has to be applied.
        """
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[str]:
        """
        The message id on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "message_id")


@pulumi.output_type
class EdifactOneWayAgreementResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protocolSettings":
            suggest = "protocol_settings"
        elif key == "receiverBusinessIdentity":
            suggest = "receiver_business_identity"
        elif key == "senderBusinessIdentity":
            suggest = "sender_business_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactOneWayAgreementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactOneWayAgreementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactOneWayAgreementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol_settings: Optional['outputs.EdifactProtocolSettingsResponse'] = None,
                 receiver_business_identity: Optional['outputs.BusinessIdentityResponse'] = None,
                 sender_business_identity: Optional['outputs.BusinessIdentityResponse'] = None):
        """
        :param 'EdifactProtocolSettingsResponse' protocol_settings: The EDIFACT protocol settings.
        :param 'BusinessIdentityResponse' receiver_business_identity: The receiver business identity
        :param 'BusinessIdentityResponse' sender_business_identity: The sender business identity
        """
        if protocol_settings is not None:
            pulumi.set(__self__, "protocol_settings", protocol_settings)
        if receiver_business_identity is not None:
            pulumi.set(__self__, "receiver_business_identity", receiver_business_identity)
        if sender_business_identity is not None:
            pulumi.set(__self__, "sender_business_identity", sender_business_identity)

    @property
    @pulumi.getter(name="protocolSettings")
    def protocol_settings(self) -> Optional['outputs.EdifactProtocolSettingsResponse']:
        """
        The EDIFACT protocol settings.
        """
        return pulumi.get(self, "protocol_settings")

    @property
    @pulumi.getter(name="receiverBusinessIdentity")
    def receiver_business_identity(self) -> Optional['outputs.BusinessIdentityResponse']:
        """
        The receiver business identity
        """
        return pulumi.get(self, "receiver_business_identity")

    @property
    @pulumi.getter(name="senderBusinessIdentity")
    def sender_business_identity(self) -> Optional['outputs.BusinessIdentityResponse']:
        """
        The sender business identity
        """
        return pulumi.get(self, "sender_business_identity")


@pulumi.output_type
class EdifactProcessingSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createEmptyXmlTagsForTrailingSeparators":
            suggest = "create_empty_xml_tags_for_trailing_separators"
        elif key == "maskSecurityInfo":
            suggest = "mask_security_info"
        elif key == "preserveInterchange":
            suggest = "preserve_interchange"
        elif key == "suspendInterchangeOnError":
            suggest = "suspend_interchange_on_error"
        elif key == "useDotAsDecimalSeparator":
            suggest = "use_dot_as_decimal_separator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactProcessingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactProcessingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactProcessingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_empty_xml_tags_for_trailing_separators: Optional[bool] = None,
                 mask_security_info: Optional[bool] = None,
                 preserve_interchange: Optional[bool] = None,
                 suspend_interchange_on_error: Optional[bool] = None,
                 use_dot_as_decimal_separator: Optional[bool] = None):
        """
        :param bool create_empty_xml_tags_for_trailing_separators: The value indicating whether to create empty xml tags for trailing separators.
        :param bool mask_security_info: The value indicating whether to mask security information.
        :param bool preserve_interchange: The value indicating whether to preserve interchange.
        :param bool suspend_interchange_on_error: The value indicating whether to suspend interchange on error.
        :param bool use_dot_as_decimal_separator: The value indicating whether to use dot as decimal separator.
        """
        if create_empty_xml_tags_for_trailing_separators is not None:
            pulumi.set(__self__, "create_empty_xml_tags_for_trailing_separators", create_empty_xml_tags_for_trailing_separators)
        if mask_security_info is not None:
            pulumi.set(__self__, "mask_security_info", mask_security_info)
        if preserve_interchange is not None:
            pulumi.set(__self__, "preserve_interchange", preserve_interchange)
        if suspend_interchange_on_error is not None:
            pulumi.set(__self__, "suspend_interchange_on_error", suspend_interchange_on_error)
        if use_dot_as_decimal_separator is not None:
            pulumi.set(__self__, "use_dot_as_decimal_separator", use_dot_as_decimal_separator)

    @property
    @pulumi.getter(name="createEmptyXmlTagsForTrailingSeparators")
    def create_empty_xml_tags_for_trailing_separators(self) -> Optional[bool]:
        """
        The value indicating whether to create empty xml tags for trailing separators.
        """
        return pulumi.get(self, "create_empty_xml_tags_for_trailing_separators")

    @property
    @pulumi.getter(name="maskSecurityInfo")
    def mask_security_info(self) -> Optional[bool]:
        """
        The value indicating whether to mask security information.
        """
        return pulumi.get(self, "mask_security_info")

    @property
    @pulumi.getter(name="preserveInterchange")
    def preserve_interchange(self) -> Optional[bool]:
        """
        The value indicating whether to preserve interchange.
        """
        return pulumi.get(self, "preserve_interchange")

    @property
    @pulumi.getter(name="suspendInterchangeOnError")
    def suspend_interchange_on_error(self) -> Optional[bool]:
        """
        The value indicating whether to suspend interchange on error.
        """
        return pulumi.get(self, "suspend_interchange_on_error")

    @property
    @pulumi.getter(name="useDotAsDecimalSeparator")
    def use_dot_as_decimal_separator(self) -> Optional[bool]:
        """
        The value indicating whether to use dot as decimal separator.
        """
        return pulumi.get(self, "use_dot_as_decimal_separator")


@pulumi.output_type
class EdifactProtocolSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acknowledgementSettings":
            suggest = "acknowledgement_settings"
        elif key == "edifactDelimiterOverrides":
            suggest = "edifact_delimiter_overrides"
        elif key == "envelopeOverrides":
            suggest = "envelope_overrides"
        elif key == "envelopeSettings":
            suggest = "envelope_settings"
        elif key == "framingSettings":
            suggest = "framing_settings"
        elif key == "messageFilter":
            suggest = "message_filter"
        elif key == "messageFilterList":
            suggest = "message_filter_list"
        elif key == "processingSettings":
            suggest = "processing_settings"
        elif key == "schemaReferences":
            suggest = "schema_references"
        elif key == "validationOverrides":
            suggest = "validation_overrides"
        elif key == "validationSettings":
            suggest = "validation_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactProtocolSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactProtocolSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactProtocolSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acknowledgement_settings: Optional['outputs.EdifactAcknowledgementSettingsResponse'] = None,
                 edifact_delimiter_overrides: Optional[Sequence['outputs.EdifactDelimiterOverrideResponse']] = None,
                 envelope_overrides: Optional[Sequence['outputs.EdifactEnvelopeOverrideResponse']] = None,
                 envelope_settings: Optional['outputs.EdifactEnvelopeSettingsResponse'] = None,
                 framing_settings: Optional['outputs.EdifactFramingSettingsResponse'] = None,
                 message_filter: Optional['outputs.EdifactMessageFilterResponse'] = None,
                 message_filter_list: Optional[Sequence['outputs.EdifactMessageIdentifierResponse']] = None,
                 processing_settings: Optional['outputs.EdifactProcessingSettingsResponse'] = None,
                 schema_references: Optional[Sequence['outputs.EdifactSchemaReferenceResponse']] = None,
                 validation_overrides: Optional[Sequence['outputs.EdifactValidationOverrideResponse']] = None,
                 validation_settings: Optional['outputs.EdifactValidationSettingsResponse'] = None):
        """
        :param 'EdifactAcknowledgementSettingsResponse' acknowledgement_settings: The EDIFACT acknowledgement settings.
        :param Sequence['EdifactDelimiterOverrideResponse'] edifact_delimiter_overrides: The EDIFACT delimiter override settings.
        :param Sequence['EdifactEnvelopeOverrideResponse'] envelope_overrides: The EDIFACT envelope override settings.
        :param 'EdifactEnvelopeSettingsResponse' envelope_settings: The EDIFACT envelope settings.
        :param 'EdifactFramingSettingsResponse' framing_settings: The EDIFACT framing settings.
        :param 'EdifactMessageFilterResponse' message_filter: The EDIFACT message filter.
        :param Sequence['EdifactMessageIdentifierResponse'] message_filter_list: The EDIFACT message filter list.
        :param 'EdifactProcessingSettingsResponse' processing_settings: The EDIFACT processing Settings.
        :param Sequence['EdifactSchemaReferenceResponse'] schema_references: The EDIFACT schema references.
        :param Sequence['EdifactValidationOverrideResponse'] validation_overrides: The EDIFACT validation override settings.
        :param 'EdifactValidationSettingsResponse' validation_settings: The EDIFACT validation settings.
        """
        if acknowledgement_settings is not None:
            pulumi.set(__self__, "acknowledgement_settings", acknowledgement_settings)
        if edifact_delimiter_overrides is not None:
            pulumi.set(__self__, "edifact_delimiter_overrides", edifact_delimiter_overrides)
        if envelope_overrides is not None:
            pulumi.set(__self__, "envelope_overrides", envelope_overrides)
        if envelope_settings is not None:
            pulumi.set(__self__, "envelope_settings", envelope_settings)
        if framing_settings is not None:
            pulumi.set(__self__, "framing_settings", framing_settings)
        if message_filter is not None:
            pulumi.set(__self__, "message_filter", message_filter)
        if message_filter_list is not None:
            pulumi.set(__self__, "message_filter_list", message_filter_list)
        if processing_settings is not None:
            pulumi.set(__self__, "processing_settings", processing_settings)
        if schema_references is not None:
            pulumi.set(__self__, "schema_references", schema_references)
        if validation_overrides is not None:
            pulumi.set(__self__, "validation_overrides", validation_overrides)
        if validation_settings is not None:
            pulumi.set(__self__, "validation_settings", validation_settings)

    @property
    @pulumi.getter(name="acknowledgementSettings")
    def acknowledgement_settings(self) -> Optional['outputs.EdifactAcknowledgementSettingsResponse']:
        """
        The EDIFACT acknowledgement settings.
        """
        return pulumi.get(self, "acknowledgement_settings")

    @property
    @pulumi.getter(name="edifactDelimiterOverrides")
    def edifact_delimiter_overrides(self) -> Optional[Sequence['outputs.EdifactDelimiterOverrideResponse']]:
        """
        The EDIFACT delimiter override settings.
        """
        return pulumi.get(self, "edifact_delimiter_overrides")

    @property
    @pulumi.getter(name="envelopeOverrides")
    def envelope_overrides(self) -> Optional[Sequence['outputs.EdifactEnvelopeOverrideResponse']]:
        """
        The EDIFACT envelope override settings.
        """
        return pulumi.get(self, "envelope_overrides")

    @property
    @pulumi.getter(name="envelopeSettings")
    def envelope_settings(self) -> Optional['outputs.EdifactEnvelopeSettingsResponse']:
        """
        The EDIFACT envelope settings.
        """
        return pulumi.get(self, "envelope_settings")

    @property
    @pulumi.getter(name="framingSettings")
    def framing_settings(self) -> Optional['outputs.EdifactFramingSettingsResponse']:
        """
        The EDIFACT framing settings.
        """
        return pulumi.get(self, "framing_settings")

    @property
    @pulumi.getter(name="messageFilter")
    def message_filter(self) -> Optional['outputs.EdifactMessageFilterResponse']:
        """
        The EDIFACT message filter.
        """
        return pulumi.get(self, "message_filter")

    @property
    @pulumi.getter(name="messageFilterList")
    def message_filter_list(self) -> Optional[Sequence['outputs.EdifactMessageIdentifierResponse']]:
        """
        The EDIFACT message filter list.
        """
        return pulumi.get(self, "message_filter_list")

    @property
    @pulumi.getter(name="processingSettings")
    def processing_settings(self) -> Optional['outputs.EdifactProcessingSettingsResponse']:
        """
        The EDIFACT processing Settings.
        """
        return pulumi.get(self, "processing_settings")

    @property
    @pulumi.getter(name="schemaReferences")
    def schema_references(self) -> Optional[Sequence['outputs.EdifactSchemaReferenceResponse']]:
        """
        The EDIFACT schema references.
        """
        return pulumi.get(self, "schema_references")

    @property
    @pulumi.getter(name="validationOverrides")
    def validation_overrides(self) -> Optional[Sequence['outputs.EdifactValidationOverrideResponse']]:
        """
        The EDIFACT validation override settings.
        """
        return pulumi.get(self, "validation_overrides")

    @property
    @pulumi.getter(name="validationSettings")
    def validation_settings(self) -> Optional['outputs.EdifactValidationSettingsResponse']:
        """
        The EDIFACT validation settings.
        """
        return pulumi.get(self, "validation_settings")


@pulumi.output_type
class EdifactSchemaReferenceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "associationAssignedCode":
            suggest = "association_assigned_code"
        elif key == "messageId":
            suggest = "message_id"
        elif key == "messageRelease":
            suggest = "message_release"
        elif key == "messageVersion":
            suggest = "message_version"
        elif key == "schemaName":
            suggest = "schema_name"
        elif key == "senderApplicationId":
            suggest = "sender_application_id"
        elif key == "senderApplicationQualifier":
            suggest = "sender_application_qualifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactSchemaReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactSchemaReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactSchemaReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 association_assigned_code: Optional[str] = None,
                 message_id: Optional[str] = None,
                 message_release: Optional[str] = None,
                 message_version: Optional[str] = None,
                 schema_name: Optional[str] = None,
                 sender_application_id: Optional[str] = None,
                 sender_application_qualifier: Optional[str] = None):
        """
        :param str association_assigned_code: The association assigned code.
        :param str message_id: The message id.
        :param str message_release: The message release version.
        :param str message_version: The message version.
        :param str schema_name: The schema name.
        :param str sender_application_id: The sender application id.
        :param str sender_application_qualifier: The sender application qualifier.
        """
        if association_assigned_code is not None:
            pulumi.set(__self__, "association_assigned_code", association_assigned_code)
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)
        if message_release is not None:
            pulumi.set(__self__, "message_release", message_release)
        if message_version is not None:
            pulumi.set(__self__, "message_version", message_version)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if sender_application_id is not None:
            pulumi.set(__self__, "sender_application_id", sender_application_id)
        if sender_application_qualifier is not None:
            pulumi.set(__self__, "sender_application_qualifier", sender_application_qualifier)

    @property
    @pulumi.getter(name="associationAssignedCode")
    def association_assigned_code(self) -> Optional[str]:
        """
        The association assigned code.
        """
        return pulumi.get(self, "association_assigned_code")

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[str]:
        """
        The message id.
        """
        return pulumi.get(self, "message_id")

    @property
    @pulumi.getter(name="messageRelease")
    def message_release(self) -> Optional[str]:
        """
        The message release version.
        """
        return pulumi.get(self, "message_release")

    @property
    @pulumi.getter(name="messageVersion")
    def message_version(self) -> Optional[str]:
        """
        The message version.
        """
        return pulumi.get(self, "message_version")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[str]:
        """
        The schema name.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="senderApplicationId")
    def sender_application_id(self) -> Optional[str]:
        """
        The sender application id.
        """
        return pulumi.get(self, "sender_application_id")

    @property
    @pulumi.getter(name="senderApplicationQualifier")
    def sender_application_qualifier(self) -> Optional[str]:
        """
        The sender application qualifier.
        """
        return pulumi.get(self, "sender_application_qualifier")


@pulumi.output_type
class EdifactValidationOverrideResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowLeadingAndTrailingSpacesAndZeroes":
            suggest = "allow_leading_and_trailing_spaces_and_zeroes"
        elif key == "enforceCharacterSet":
            suggest = "enforce_character_set"
        elif key == "messageId":
            suggest = "message_id"
        elif key == "trailingSeparatorPolicy":
            suggest = "trailing_separator_policy"
        elif key == "trimLeadingAndTrailingSpacesAndZeroes":
            suggest = "trim_leading_and_trailing_spaces_and_zeroes"
        elif key == "validateEDITypes":
            suggest = "validate_edi_types"
        elif key == "validateXSDTypes":
            suggest = "validate_xsd_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactValidationOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactValidationOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactValidationOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_leading_and_trailing_spaces_and_zeroes: Optional[bool] = None,
                 enforce_character_set: Optional[bool] = None,
                 message_id: Optional[str] = None,
                 trailing_separator_policy: Optional[str] = None,
                 trim_leading_and_trailing_spaces_and_zeroes: Optional[bool] = None,
                 validate_edi_types: Optional[bool] = None,
                 validate_xsd_types: Optional[bool] = None):
        """
        :param bool allow_leading_and_trailing_spaces_and_zeroes: The value indicating whether to allow leading and trailing spaces and zeroes.
        :param bool enforce_character_set: The value indicating whether to validate character Set.
        :param str message_id: The message id on which the validation settings has to be applied.
        :param str trailing_separator_policy: The trailing separator policy.
        :param bool trim_leading_and_trailing_spaces_and_zeroes: The value indicating whether to trim leading and trailing spaces and zeroes.
        :param bool validate_edi_types: The value indicating whether to validate EDI types.
        :param bool validate_xsd_types: The value indicating whether to validate XSD types.
        """
        if allow_leading_and_trailing_spaces_and_zeroes is not None:
            pulumi.set(__self__, "allow_leading_and_trailing_spaces_and_zeroes", allow_leading_and_trailing_spaces_and_zeroes)
        if enforce_character_set is not None:
            pulumi.set(__self__, "enforce_character_set", enforce_character_set)
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)
        if trailing_separator_policy is not None:
            pulumi.set(__self__, "trailing_separator_policy", trailing_separator_policy)
        if trim_leading_and_trailing_spaces_and_zeroes is not None:
            pulumi.set(__self__, "trim_leading_and_trailing_spaces_and_zeroes", trim_leading_and_trailing_spaces_and_zeroes)
        if validate_edi_types is not None:
            pulumi.set(__self__, "validate_edi_types", validate_edi_types)
        if validate_xsd_types is not None:
            pulumi.set(__self__, "validate_xsd_types", validate_xsd_types)

    @property
    @pulumi.getter(name="allowLeadingAndTrailingSpacesAndZeroes")
    def allow_leading_and_trailing_spaces_and_zeroes(self) -> Optional[bool]:
        """
        The value indicating whether to allow leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "allow_leading_and_trailing_spaces_and_zeroes")

    @property
    @pulumi.getter(name="enforceCharacterSet")
    def enforce_character_set(self) -> Optional[bool]:
        """
        The value indicating whether to validate character Set.
        """
        return pulumi.get(self, "enforce_character_set")

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[str]:
        """
        The message id on which the validation settings has to be applied.
        """
        return pulumi.get(self, "message_id")

    @property
    @pulumi.getter(name="trailingSeparatorPolicy")
    def trailing_separator_policy(self) -> Optional[str]:
        """
        The trailing separator policy.
        """
        return pulumi.get(self, "trailing_separator_policy")

    @property
    @pulumi.getter(name="trimLeadingAndTrailingSpacesAndZeroes")
    def trim_leading_and_trailing_spaces_and_zeroes(self) -> Optional[bool]:
        """
        The value indicating whether to trim leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "trim_leading_and_trailing_spaces_and_zeroes")

    @property
    @pulumi.getter(name="validateEDITypes")
    def validate_edi_types(self) -> Optional[bool]:
        """
        The value indicating whether to validate EDI types.
        """
        return pulumi.get(self, "validate_edi_types")

    @property
    @pulumi.getter(name="validateXSDTypes")
    def validate_xsd_types(self) -> Optional[bool]:
        """
        The value indicating whether to validate XSD types.
        """
        return pulumi.get(self, "validate_xsd_types")


@pulumi.output_type
class EdifactValidationSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowLeadingAndTrailingSpacesAndZeroes":
            suggest = "allow_leading_and_trailing_spaces_and_zeroes"
        elif key == "checkDuplicateGroupControlNumber":
            suggest = "check_duplicate_group_control_number"
        elif key == "checkDuplicateInterchangeControlNumber":
            suggest = "check_duplicate_interchange_control_number"
        elif key == "checkDuplicateTransactionSetControlNumber":
            suggest = "check_duplicate_transaction_set_control_number"
        elif key == "interchangeControlNumberValidityDays":
            suggest = "interchange_control_number_validity_days"
        elif key == "trailingSeparatorPolicy":
            suggest = "trailing_separator_policy"
        elif key == "trimLeadingAndTrailingSpacesAndZeroes":
            suggest = "trim_leading_and_trailing_spaces_and_zeroes"
        elif key == "validateCharacterSet":
            suggest = "validate_character_set"
        elif key == "validateEDITypes":
            suggest = "validate_edi_types"
        elif key == "validateXSDTypes":
            suggest = "validate_xsd_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactValidationSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactValidationSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactValidationSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_leading_and_trailing_spaces_and_zeroes: Optional[bool] = None,
                 check_duplicate_group_control_number: Optional[bool] = None,
                 check_duplicate_interchange_control_number: Optional[bool] = None,
                 check_duplicate_transaction_set_control_number: Optional[bool] = None,
                 interchange_control_number_validity_days: Optional[int] = None,
                 trailing_separator_policy: Optional[str] = None,
                 trim_leading_and_trailing_spaces_and_zeroes: Optional[bool] = None,
                 validate_character_set: Optional[bool] = None,
                 validate_edi_types: Optional[bool] = None,
                 validate_xsd_types: Optional[bool] = None):
        """
        :param bool allow_leading_and_trailing_spaces_and_zeroes: The value indicating whether to allow leading and trailing spaces and zeroes.
        :param bool check_duplicate_group_control_number: The value indicating whether to check for duplicate group control number.
        :param bool check_duplicate_interchange_control_number: The value indicating whether to check for duplicate interchange control number.
        :param bool check_duplicate_transaction_set_control_number: The value indicating whether to check for duplicate transaction set control number.
        :param int interchange_control_number_validity_days: The validity period of interchange control number.
        :param str trailing_separator_policy: The trailing separator policy.
        :param bool trim_leading_and_trailing_spaces_and_zeroes: The value indicating whether to trim leading and trailing spaces and zeroes.
        :param bool validate_character_set: The value indicating whether to validate character set in the message.
        :param bool validate_edi_types: The value indicating whether to Whether to validate EDI types.
        :param bool validate_xsd_types: The value indicating whether to Whether to validate XSD types.
        """
        if allow_leading_and_trailing_spaces_and_zeroes is not None:
            pulumi.set(__self__, "allow_leading_and_trailing_spaces_and_zeroes", allow_leading_and_trailing_spaces_and_zeroes)
        if check_duplicate_group_control_number is not None:
            pulumi.set(__self__, "check_duplicate_group_control_number", check_duplicate_group_control_number)
        if check_duplicate_interchange_control_number is not None:
            pulumi.set(__self__, "check_duplicate_interchange_control_number", check_duplicate_interchange_control_number)
        if check_duplicate_transaction_set_control_number is not None:
            pulumi.set(__self__, "check_duplicate_transaction_set_control_number", check_duplicate_transaction_set_control_number)
        if interchange_control_number_validity_days is not None:
            pulumi.set(__self__, "interchange_control_number_validity_days", interchange_control_number_validity_days)
        if trailing_separator_policy is not None:
            pulumi.set(__self__, "trailing_separator_policy", trailing_separator_policy)
        if trim_leading_and_trailing_spaces_and_zeroes is not None:
            pulumi.set(__self__, "trim_leading_and_trailing_spaces_and_zeroes", trim_leading_and_trailing_spaces_and_zeroes)
        if validate_character_set is not None:
            pulumi.set(__self__, "validate_character_set", validate_character_set)
        if validate_edi_types is not None:
            pulumi.set(__self__, "validate_edi_types", validate_edi_types)
        if validate_xsd_types is not None:
            pulumi.set(__self__, "validate_xsd_types", validate_xsd_types)

    @property
    @pulumi.getter(name="allowLeadingAndTrailingSpacesAndZeroes")
    def allow_leading_and_trailing_spaces_and_zeroes(self) -> Optional[bool]:
        """
        The value indicating whether to allow leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "allow_leading_and_trailing_spaces_and_zeroes")

    @property
    @pulumi.getter(name="checkDuplicateGroupControlNumber")
    def check_duplicate_group_control_number(self) -> Optional[bool]:
        """
        The value indicating whether to check for duplicate group control number.
        """
        return pulumi.get(self, "check_duplicate_group_control_number")

    @property
    @pulumi.getter(name="checkDuplicateInterchangeControlNumber")
    def check_duplicate_interchange_control_number(self) -> Optional[bool]:
        """
        The value indicating whether to check for duplicate interchange control number.
        """
        return pulumi.get(self, "check_duplicate_interchange_control_number")

    @property
    @pulumi.getter(name="checkDuplicateTransactionSetControlNumber")
    def check_duplicate_transaction_set_control_number(self) -> Optional[bool]:
        """
        The value indicating whether to check for duplicate transaction set control number.
        """
        return pulumi.get(self, "check_duplicate_transaction_set_control_number")

    @property
    @pulumi.getter(name="interchangeControlNumberValidityDays")
    def interchange_control_number_validity_days(self) -> Optional[int]:
        """
        The validity period of interchange control number.
        """
        return pulumi.get(self, "interchange_control_number_validity_days")

    @property
    @pulumi.getter(name="trailingSeparatorPolicy")
    def trailing_separator_policy(self) -> Optional[str]:
        """
        The trailing separator policy.
        """
        return pulumi.get(self, "trailing_separator_policy")

    @property
    @pulumi.getter(name="trimLeadingAndTrailingSpacesAndZeroes")
    def trim_leading_and_trailing_spaces_and_zeroes(self) -> Optional[bool]:
        """
        The value indicating whether to trim leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "trim_leading_and_trailing_spaces_and_zeroes")

    @property
    @pulumi.getter(name="validateCharacterSet")
    def validate_character_set(self) -> Optional[bool]:
        """
        The value indicating whether to validate character set in the message.
        """
        return pulumi.get(self, "validate_character_set")

    @property
    @pulumi.getter(name="validateEDITypes")
    def validate_edi_types(self) -> Optional[bool]:
        """
        The value indicating whether to Whether to validate EDI types.
        """
        return pulumi.get(self, "validate_edi_types")

    @property
    @pulumi.getter(name="validateXSDTypes")
    def validate_xsd_types(self) -> Optional[bool]:
        """
        The value indicating whether to Whether to validate XSD types.
        """
        return pulumi.get(self, "validate_xsd_types")


@pulumi.output_type
class IntegrationAccountContentHashResponse(dict):
    def __init__(__self__, *,
                 algorithm: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str algorithm: The content hash algorithm.
        :param str value: The content hash value.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[str]:
        """
        The content hash algorithm.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The content hash value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class IntegrationAccountContentLinkResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentHash":
            suggest = "content_hash"
        elif key == "contentSize":
            suggest = "content_size"
        elif key == "contentVersion":
            suggest = "content_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationAccountContentLinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationAccountContentLinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationAccountContentLinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_hash: Optional['outputs.IntegrationAccountContentHashResponse'] = None,
                 content_size: Optional[float] = None,
                 content_version: Optional[str] = None,
                 metadata: Optional[Any] = None,
                 uri: Optional[str] = None):
        """
        :param 'IntegrationAccountContentHashResponse' content_hash: The content hash.
        :param float content_size: The content size.
        :param str content_version: The content version.
        :param Any metadata: The metadata.
        :param str uri: The content link URI.
        """
        if content_hash is not None:
            pulumi.set(__self__, "content_hash", content_hash)
        if content_size is not None:
            pulumi.set(__self__, "content_size", content_size)
        if content_version is not None:
            pulumi.set(__self__, "content_version", content_version)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="contentHash")
    def content_hash(self) -> Optional['outputs.IntegrationAccountContentHashResponse']:
        """
        The content hash.
        """
        return pulumi.get(self, "content_hash")

    @property
    @pulumi.getter(name="contentSize")
    def content_size(self) -> Optional[float]:
        """
        The content size.
        """
        return pulumi.get(self, "content_size")

    @property
    @pulumi.getter(name="contentVersion")
    def content_version(self) -> Optional[str]:
        """
        The content version.
        """
        return pulumi.get(self, "content_version")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Any]:
        """
        The metadata.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        The content link URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class IntegrationAccountSkuResponse(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        :param str name: The sku name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The sku name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class KeyVaultKeyReferenceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyName":
            suggest = "key_name"
        elif key == "keyVault":
            suggest = "key_vault"
        elif key == "keyVersion":
            suggest = "key_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultKeyReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultKeyReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultKeyReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_name: Optional[str] = None,
                 key_vault: Optional['outputs.KeyVaultKeyReferenceResponseKeyVault'] = None,
                 key_version: Optional[str] = None):
        """
        :param str key_name: The private key name in key vault.
        :param 'KeyVaultKeyReferenceResponseKeyVault' key_vault: The key vault reference.
        :param str key_version: The private key version in key vault.
        """
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_vault is not None:
            pulumi.set(__self__, "key_vault", key_vault)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[str]:
        """
        The private key name in key vault.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyVault")
    def key_vault(self) -> Optional['outputs.KeyVaultKeyReferenceResponseKeyVault']:
        """
        The key vault reference.
        """
        return pulumi.get(self, "key_vault")

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[str]:
        """
        The private key version in key vault.
        """
        return pulumi.get(self, "key_version")


@pulumi.output_type
class KeyVaultKeyReferenceResponseKeyVault(dict):
    """
    The key vault reference.
    """
    def __init__(__self__, *,
                 name: str,
                 type: str,
                 id: Optional[str] = None):
        """
        The key vault reference.
        :param str name: The resource name.
        :param str type: The resource type.
        :param str id: The resource id.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PartnerContentResponse(dict):
    def __init__(__self__, *,
                 b2b: Optional['outputs.B2BPartnerContentResponse'] = None):
        """
        :param 'B2BPartnerContentResponse' b2b: The B2B partner content.
        """
        if b2b is not None:
            pulumi.set(__self__, "b2b", b2b)

    @property
    @pulumi.getter
    def b2b(self) -> Optional['outputs.B2BPartnerContentResponse']:
        """
        The B2B partner content.
        """
        return pulumi.get(self, "b2b")


@pulumi.output_type
class X12AcknowledgementSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acknowledgementControlNumberLowerBound":
            suggest = "acknowledgement_control_number_lower_bound"
        elif key == "acknowledgementControlNumberPrefix":
            suggest = "acknowledgement_control_number_prefix"
        elif key == "acknowledgementControlNumberSuffix":
            suggest = "acknowledgement_control_number_suffix"
        elif key == "acknowledgementControlNumberUpperBound":
            suggest = "acknowledgement_control_number_upper_bound"
        elif key == "batchFunctionalAcknowledgements":
            suggest = "batch_functional_acknowledgements"
        elif key == "batchImplementationAcknowledgements":
            suggest = "batch_implementation_acknowledgements"
        elif key == "batchTechnicalAcknowledgements":
            suggest = "batch_technical_acknowledgements"
        elif key == "functionalAcknowledgementVersion":
            suggest = "functional_acknowledgement_version"
        elif key == "implementationAcknowledgementVersion":
            suggest = "implementation_acknowledgement_version"
        elif key == "needFunctionalAcknowledgement":
            suggest = "need_functional_acknowledgement"
        elif key == "needImplementationAcknowledgement":
            suggest = "need_implementation_acknowledgement"
        elif key == "needLoopForValidMessages":
            suggest = "need_loop_for_valid_messages"
        elif key == "needTechnicalAcknowledgement":
            suggest = "need_technical_acknowledgement"
        elif key == "rolloverAcknowledgementControlNumber":
            suggest = "rollover_acknowledgement_control_number"
        elif key == "sendSynchronousAcknowledgement":
            suggest = "send_synchronous_acknowledgement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12AcknowledgementSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12AcknowledgementSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12AcknowledgementSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acknowledgement_control_number_lower_bound: Optional[int] = None,
                 acknowledgement_control_number_prefix: Optional[str] = None,
                 acknowledgement_control_number_suffix: Optional[str] = None,
                 acknowledgement_control_number_upper_bound: Optional[int] = None,
                 batch_functional_acknowledgements: Optional[bool] = None,
                 batch_implementation_acknowledgements: Optional[bool] = None,
                 batch_technical_acknowledgements: Optional[bool] = None,
                 functional_acknowledgement_version: Optional[str] = None,
                 implementation_acknowledgement_version: Optional[str] = None,
                 need_functional_acknowledgement: Optional[bool] = None,
                 need_implementation_acknowledgement: Optional[bool] = None,
                 need_loop_for_valid_messages: Optional[bool] = None,
                 need_technical_acknowledgement: Optional[bool] = None,
                 rollover_acknowledgement_control_number: Optional[bool] = None,
                 send_synchronous_acknowledgement: Optional[bool] = None):
        """
        :param int acknowledgement_control_number_lower_bound: The acknowledgement control number lower bound.
        :param str acknowledgement_control_number_prefix: The acknowledgement control number prefix.
        :param str acknowledgement_control_number_suffix: The acknowledgement control number suffix.
        :param int acknowledgement_control_number_upper_bound: The acknowledgement control number upper bound.
        :param bool batch_functional_acknowledgements: The value indicating whether to batch functional acknowledgements.
        :param bool batch_implementation_acknowledgements: The value indicating whether to batch implementation acknowledgements.
        :param bool batch_technical_acknowledgements: The value indicating whether to batch the technical acknowledgements.
        :param str functional_acknowledgement_version: The functional acknowledgement version.
        :param str implementation_acknowledgement_version: The implementation acknowledgement version.
        :param bool need_functional_acknowledgement: The value indicating whether functional acknowledgement is needed.
        :param bool need_implementation_acknowledgement: The value indicating whether implementation acknowledgement is needed.
        :param bool need_loop_for_valid_messages: The value indicating whether a loop is needed for valid messages.
        :param bool need_technical_acknowledgement: The value indicating whether technical acknowledgement is needed.
        :param bool rollover_acknowledgement_control_number: The value indicating whether to rollover acknowledgement control number.
        :param bool send_synchronous_acknowledgement: The value indicating whether to send synchronous acknowledgement.
        """
        if acknowledgement_control_number_lower_bound is not None:
            pulumi.set(__self__, "acknowledgement_control_number_lower_bound", acknowledgement_control_number_lower_bound)
        if acknowledgement_control_number_prefix is not None:
            pulumi.set(__self__, "acknowledgement_control_number_prefix", acknowledgement_control_number_prefix)
        if acknowledgement_control_number_suffix is not None:
            pulumi.set(__self__, "acknowledgement_control_number_suffix", acknowledgement_control_number_suffix)
        if acknowledgement_control_number_upper_bound is not None:
            pulumi.set(__self__, "acknowledgement_control_number_upper_bound", acknowledgement_control_number_upper_bound)
        if batch_functional_acknowledgements is not None:
            pulumi.set(__self__, "batch_functional_acknowledgements", batch_functional_acknowledgements)
        if batch_implementation_acknowledgements is not None:
            pulumi.set(__self__, "batch_implementation_acknowledgements", batch_implementation_acknowledgements)
        if batch_technical_acknowledgements is not None:
            pulumi.set(__self__, "batch_technical_acknowledgements", batch_technical_acknowledgements)
        if functional_acknowledgement_version is not None:
            pulumi.set(__self__, "functional_acknowledgement_version", functional_acknowledgement_version)
        if implementation_acknowledgement_version is not None:
            pulumi.set(__self__, "implementation_acknowledgement_version", implementation_acknowledgement_version)
        if need_functional_acknowledgement is not None:
            pulumi.set(__self__, "need_functional_acknowledgement", need_functional_acknowledgement)
        if need_implementation_acknowledgement is not None:
            pulumi.set(__self__, "need_implementation_acknowledgement", need_implementation_acknowledgement)
        if need_loop_for_valid_messages is not None:
            pulumi.set(__self__, "need_loop_for_valid_messages", need_loop_for_valid_messages)
        if need_technical_acknowledgement is not None:
            pulumi.set(__self__, "need_technical_acknowledgement", need_technical_acknowledgement)
        if rollover_acknowledgement_control_number is not None:
            pulumi.set(__self__, "rollover_acknowledgement_control_number", rollover_acknowledgement_control_number)
        if send_synchronous_acknowledgement is not None:
            pulumi.set(__self__, "send_synchronous_acknowledgement", send_synchronous_acknowledgement)

    @property
    @pulumi.getter(name="acknowledgementControlNumberLowerBound")
    def acknowledgement_control_number_lower_bound(self) -> Optional[int]:
        """
        The acknowledgement control number lower bound.
        """
        return pulumi.get(self, "acknowledgement_control_number_lower_bound")

    @property
    @pulumi.getter(name="acknowledgementControlNumberPrefix")
    def acknowledgement_control_number_prefix(self) -> Optional[str]:
        """
        The acknowledgement control number prefix.
        """
        return pulumi.get(self, "acknowledgement_control_number_prefix")

    @property
    @pulumi.getter(name="acknowledgementControlNumberSuffix")
    def acknowledgement_control_number_suffix(self) -> Optional[str]:
        """
        The acknowledgement control number suffix.
        """
        return pulumi.get(self, "acknowledgement_control_number_suffix")

    @property
    @pulumi.getter(name="acknowledgementControlNumberUpperBound")
    def acknowledgement_control_number_upper_bound(self) -> Optional[int]:
        """
        The acknowledgement control number upper bound.
        """
        return pulumi.get(self, "acknowledgement_control_number_upper_bound")

    @property
    @pulumi.getter(name="batchFunctionalAcknowledgements")
    def batch_functional_acknowledgements(self) -> Optional[bool]:
        """
        The value indicating whether to batch functional acknowledgements.
        """
        return pulumi.get(self, "batch_functional_acknowledgements")

    @property
    @pulumi.getter(name="batchImplementationAcknowledgements")
    def batch_implementation_acknowledgements(self) -> Optional[bool]:
        """
        The value indicating whether to batch implementation acknowledgements.
        """
        return pulumi.get(self, "batch_implementation_acknowledgements")

    @property
    @pulumi.getter(name="batchTechnicalAcknowledgements")
    def batch_technical_acknowledgements(self) -> Optional[bool]:
        """
        The value indicating whether to batch the technical acknowledgements.
        """
        return pulumi.get(self, "batch_technical_acknowledgements")

    @property
    @pulumi.getter(name="functionalAcknowledgementVersion")
    def functional_acknowledgement_version(self) -> Optional[str]:
        """
        The functional acknowledgement version.
        """
        return pulumi.get(self, "functional_acknowledgement_version")

    @property
    @pulumi.getter(name="implementationAcknowledgementVersion")
    def implementation_acknowledgement_version(self) -> Optional[str]:
        """
        The implementation acknowledgement version.
        """
        return pulumi.get(self, "implementation_acknowledgement_version")

    @property
    @pulumi.getter(name="needFunctionalAcknowledgement")
    def need_functional_acknowledgement(self) -> Optional[bool]:
        """
        The value indicating whether functional acknowledgement is needed.
        """
        return pulumi.get(self, "need_functional_acknowledgement")

    @property
    @pulumi.getter(name="needImplementationAcknowledgement")
    def need_implementation_acknowledgement(self) -> Optional[bool]:
        """
        The value indicating whether implementation acknowledgement is needed.
        """
        return pulumi.get(self, "need_implementation_acknowledgement")

    @property
    @pulumi.getter(name="needLoopForValidMessages")
    def need_loop_for_valid_messages(self) -> Optional[bool]:
        """
        The value indicating whether a loop is needed for valid messages.
        """
        return pulumi.get(self, "need_loop_for_valid_messages")

    @property
    @pulumi.getter(name="needTechnicalAcknowledgement")
    def need_technical_acknowledgement(self) -> Optional[bool]:
        """
        The value indicating whether technical acknowledgement is needed.
        """
        return pulumi.get(self, "need_technical_acknowledgement")

    @property
    @pulumi.getter(name="rolloverAcknowledgementControlNumber")
    def rollover_acknowledgement_control_number(self) -> Optional[bool]:
        """
        The value indicating whether to rollover acknowledgement control number.
        """
        return pulumi.get(self, "rollover_acknowledgement_control_number")

    @property
    @pulumi.getter(name="sendSynchronousAcknowledgement")
    def send_synchronous_acknowledgement(self) -> Optional[bool]:
        """
        The value indicating whether to send synchronous acknowledgement.
        """
        return pulumi.get(self, "send_synchronous_acknowledgement")


@pulumi.output_type
class X12AgreementContentResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "receiveAgreement":
            suggest = "receive_agreement"
        elif key == "sendAgreement":
            suggest = "send_agreement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12AgreementContentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12AgreementContentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12AgreementContentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 receive_agreement: Optional['outputs.X12OneWayAgreementResponse'] = None,
                 send_agreement: Optional['outputs.X12OneWayAgreementResponse'] = None):
        """
        :param 'X12OneWayAgreementResponse' receive_agreement: The X12 one-way receive agreement.
        :param 'X12OneWayAgreementResponse' send_agreement: The X12 one-way send agreement.
        """
        if receive_agreement is not None:
            pulumi.set(__self__, "receive_agreement", receive_agreement)
        if send_agreement is not None:
            pulumi.set(__self__, "send_agreement", send_agreement)

    @property
    @pulumi.getter(name="receiveAgreement")
    def receive_agreement(self) -> Optional['outputs.X12OneWayAgreementResponse']:
        """
        The X12 one-way receive agreement.
        """
        return pulumi.get(self, "receive_agreement")

    @property
    @pulumi.getter(name="sendAgreement")
    def send_agreement(self) -> Optional['outputs.X12OneWayAgreementResponse']:
        """
        The X12 one-way send agreement.
        """
        return pulumi.get(self, "send_agreement")


@pulumi.output_type
class X12DelimiterOverridesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentSeparator":
            suggest = "component_separator"
        elif key == "dataElementSeparator":
            suggest = "data_element_separator"
        elif key == "messageId":
            suggest = "message_id"
        elif key == "protocolVersion":
            suggest = "protocol_version"
        elif key == "replaceCharacter":
            suggest = "replace_character"
        elif key == "replaceSeparatorsInPayload":
            suggest = "replace_separators_in_payload"
        elif key == "segmentTerminator":
            suggest = "segment_terminator"
        elif key == "segmentTerminatorSuffix":
            suggest = "segment_terminator_suffix"
        elif key == "targetNamespace":
            suggest = "target_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12DelimiterOverridesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12DelimiterOverridesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12DelimiterOverridesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_separator: Optional[int] = None,
                 data_element_separator: Optional[int] = None,
                 message_id: Optional[str] = None,
                 protocol_version: Optional[str] = None,
                 replace_character: Optional[int] = None,
                 replace_separators_in_payload: Optional[bool] = None,
                 segment_terminator: Optional[int] = None,
                 segment_terminator_suffix: Optional[str] = None,
                 target_namespace: Optional[str] = None):
        """
        :param int component_separator: The component separator.
        :param int data_element_separator: The data element separator.
        :param str message_id: The message id.
        :param str protocol_version: The protocol version.
        :param int replace_character: The replacement character.
        :param bool replace_separators_in_payload: The value indicating whether to replace separators in payload.
        :param int segment_terminator: The segment terminator.
        :param str segment_terminator_suffix: The segment terminator suffix.
        :param str target_namespace: The target namespace on which this delimiter settings has to be applied.
        """
        if component_separator is not None:
            pulumi.set(__self__, "component_separator", component_separator)
        if data_element_separator is not None:
            pulumi.set(__self__, "data_element_separator", data_element_separator)
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if replace_character is not None:
            pulumi.set(__self__, "replace_character", replace_character)
        if replace_separators_in_payload is not None:
            pulumi.set(__self__, "replace_separators_in_payload", replace_separators_in_payload)
        if segment_terminator is not None:
            pulumi.set(__self__, "segment_terminator", segment_terminator)
        if segment_terminator_suffix is not None:
            pulumi.set(__self__, "segment_terminator_suffix", segment_terminator_suffix)
        if target_namespace is not None:
            pulumi.set(__self__, "target_namespace", target_namespace)

    @property
    @pulumi.getter(name="componentSeparator")
    def component_separator(self) -> Optional[int]:
        """
        The component separator.
        """
        return pulumi.get(self, "component_separator")

    @property
    @pulumi.getter(name="dataElementSeparator")
    def data_element_separator(self) -> Optional[int]:
        """
        The data element separator.
        """
        return pulumi.get(self, "data_element_separator")

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[str]:
        """
        The message id.
        """
        return pulumi.get(self, "message_id")

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[str]:
        """
        The protocol version.
        """
        return pulumi.get(self, "protocol_version")

    @property
    @pulumi.getter(name="replaceCharacter")
    def replace_character(self) -> Optional[int]:
        """
        The replacement character.
        """
        return pulumi.get(self, "replace_character")

    @property
    @pulumi.getter(name="replaceSeparatorsInPayload")
    def replace_separators_in_payload(self) -> Optional[bool]:
        """
        The value indicating whether to replace separators in payload.
        """
        return pulumi.get(self, "replace_separators_in_payload")

    @property
    @pulumi.getter(name="segmentTerminator")
    def segment_terminator(self) -> Optional[int]:
        """
        The segment terminator.
        """
        return pulumi.get(self, "segment_terminator")

    @property
    @pulumi.getter(name="segmentTerminatorSuffix")
    def segment_terminator_suffix(self) -> Optional[str]:
        """
        The segment terminator suffix.
        """
        return pulumi.get(self, "segment_terminator_suffix")

    @property
    @pulumi.getter(name="targetNamespace")
    def target_namespace(self) -> Optional[str]:
        """
        The target namespace on which this delimiter settings has to be applied.
        """
        return pulumi.get(self, "target_namespace")


@pulumi.output_type
class X12EnvelopeOverrideResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateFormat":
            suggest = "date_format"
        elif key == "functionalIdentifierCode":
            suggest = "functional_identifier_code"
        elif key == "headerVersion":
            suggest = "header_version"
        elif key == "messageId":
            suggest = "message_id"
        elif key == "protocolVersion":
            suggest = "protocol_version"
        elif key == "receiverApplicationId":
            suggest = "receiver_application_id"
        elif key == "responsibleAgencyCode":
            suggest = "responsible_agency_code"
        elif key == "senderApplicationId":
            suggest = "sender_application_id"
        elif key == "targetNamespace":
            suggest = "target_namespace"
        elif key == "timeFormat":
            suggest = "time_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12EnvelopeOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12EnvelopeOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12EnvelopeOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date_format: Optional[str] = None,
                 functional_identifier_code: Optional[str] = None,
                 header_version: Optional[str] = None,
                 message_id: Optional[str] = None,
                 protocol_version: Optional[str] = None,
                 receiver_application_id: Optional[str] = None,
                 responsible_agency_code: Optional[int] = None,
                 sender_application_id: Optional[str] = None,
                 target_namespace: Optional[str] = None,
                 time_format: Optional[str] = None):
        """
        :param str date_format: The date format.
        :param str functional_identifier_code: The functional identifier code.
        :param str header_version: The header version.
        :param str message_id: The message id on which this envelope settings has to be applied.
        :param str protocol_version: The protocol version on which this envelope settings has to be applied.
        :param str receiver_application_id: The receiver application id.
        :param int responsible_agency_code: The responsible agency code.
        :param str sender_application_id: The sender application id.
        :param str target_namespace: The target namespace on which this envelope settings has to be applied.
        :param str time_format: The time format.
        """
        if date_format is not None:
            pulumi.set(__self__, "date_format", date_format)
        if functional_identifier_code is not None:
            pulumi.set(__self__, "functional_identifier_code", functional_identifier_code)
        if header_version is not None:
            pulumi.set(__self__, "header_version", header_version)
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if receiver_application_id is not None:
            pulumi.set(__self__, "receiver_application_id", receiver_application_id)
        if responsible_agency_code is not None:
            pulumi.set(__self__, "responsible_agency_code", responsible_agency_code)
        if sender_application_id is not None:
            pulumi.set(__self__, "sender_application_id", sender_application_id)
        if target_namespace is not None:
            pulumi.set(__self__, "target_namespace", target_namespace)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)

    @property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> Optional[str]:
        """
        The date format.
        """
        return pulumi.get(self, "date_format")

    @property
    @pulumi.getter(name="functionalIdentifierCode")
    def functional_identifier_code(self) -> Optional[str]:
        """
        The functional identifier code.
        """
        return pulumi.get(self, "functional_identifier_code")

    @property
    @pulumi.getter(name="headerVersion")
    def header_version(self) -> Optional[str]:
        """
        The header version.
        """
        return pulumi.get(self, "header_version")

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[str]:
        """
        The message id on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "message_id")

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[str]:
        """
        The protocol version on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "protocol_version")

    @property
    @pulumi.getter(name="receiverApplicationId")
    def receiver_application_id(self) -> Optional[str]:
        """
        The receiver application id.
        """
        return pulumi.get(self, "receiver_application_id")

    @property
    @pulumi.getter(name="responsibleAgencyCode")
    def responsible_agency_code(self) -> Optional[int]:
        """
        The responsible agency code.
        """
        return pulumi.get(self, "responsible_agency_code")

    @property
    @pulumi.getter(name="senderApplicationId")
    def sender_application_id(self) -> Optional[str]:
        """
        The sender application id.
        """
        return pulumi.get(self, "sender_application_id")

    @property
    @pulumi.getter(name="targetNamespace")
    def target_namespace(self) -> Optional[str]:
        """
        The target namespace on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "target_namespace")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[str]:
        """
        The time format.
        """
        return pulumi.get(self, "time_format")


@pulumi.output_type
class X12EnvelopeSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "controlStandardsId":
            suggest = "control_standards_id"
        elif key == "controlVersionNumber":
            suggest = "control_version_number"
        elif key == "enableDefaultGroupHeaders":
            suggest = "enable_default_group_headers"
        elif key == "functionalGroupId":
            suggest = "functional_group_id"
        elif key == "groupControlNumberLowerBound":
            suggest = "group_control_number_lower_bound"
        elif key == "groupControlNumberUpperBound":
            suggest = "group_control_number_upper_bound"
        elif key == "groupHeaderAgencyCode":
            suggest = "group_header_agency_code"
        elif key == "groupHeaderDateFormat":
            suggest = "group_header_date_format"
        elif key == "groupHeaderTimeFormat":
            suggest = "group_header_time_format"
        elif key == "groupHeaderVersion":
            suggest = "group_header_version"
        elif key == "interchangeControlNumberLowerBound":
            suggest = "interchange_control_number_lower_bound"
        elif key == "interchangeControlNumberUpperBound":
            suggest = "interchange_control_number_upper_bound"
        elif key == "overwriteExistingTransactionSetControlNumber":
            suggest = "overwrite_existing_transaction_set_control_number"
        elif key == "receiverApplicationId":
            suggest = "receiver_application_id"
        elif key == "rolloverGroupControlNumber":
            suggest = "rollover_group_control_number"
        elif key == "rolloverInterchangeControlNumber":
            suggest = "rollover_interchange_control_number"
        elif key == "rolloverTransactionSetControlNumber":
            suggest = "rollover_transaction_set_control_number"
        elif key == "senderApplicationId":
            suggest = "sender_application_id"
        elif key == "transactionSetControlNumberLowerBound":
            suggest = "transaction_set_control_number_lower_bound"
        elif key == "transactionSetControlNumberPrefix":
            suggest = "transaction_set_control_number_prefix"
        elif key == "transactionSetControlNumberSuffix":
            suggest = "transaction_set_control_number_suffix"
        elif key == "transactionSetControlNumberUpperBound":
            suggest = "transaction_set_control_number_upper_bound"
        elif key == "usageIndicator":
            suggest = "usage_indicator"
        elif key == "useControlStandardsIdAsRepetitionCharacter":
            suggest = "use_control_standards_id_as_repetition_character"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12EnvelopeSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12EnvelopeSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12EnvelopeSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 control_standards_id: Optional[int] = None,
                 control_version_number: Optional[str] = None,
                 enable_default_group_headers: Optional[bool] = None,
                 functional_group_id: Optional[str] = None,
                 group_control_number_lower_bound: Optional[int] = None,
                 group_control_number_upper_bound: Optional[int] = None,
                 group_header_agency_code: Optional[str] = None,
                 group_header_date_format: Optional[str] = None,
                 group_header_time_format: Optional[str] = None,
                 group_header_version: Optional[str] = None,
                 interchange_control_number_lower_bound: Optional[int] = None,
                 interchange_control_number_upper_bound: Optional[int] = None,
                 overwrite_existing_transaction_set_control_number: Optional[bool] = None,
                 receiver_application_id: Optional[str] = None,
                 rollover_group_control_number: Optional[bool] = None,
                 rollover_interchange_control_number: Optional[bool] = None,
                 rollover_transaction_set_control_number: Optional[bool] = None,
                 sender_application_id: Optional[str] = None,
                 transaction_set_control_number_lower_bound: Optional[int] = None,
                 transaction_set_control_number_prefix: Optional[str] = None,
                 transaction_set_control_number_suffix: Optional[str] = None,
                 transaction_set_control_number_upper_bound: Optional[int] = None,
                 usage_indicator: Optional[str] = None,
                 use_control_standards_id_as_repetition_character: Optional[bool] = None):
        """
        :param int control_standards_id: The controls standards id.
        :param str control_version_number: The control version number.
        :param bool enable_default_group_headers: The value indicating whether to enable default group headers.
        :param str functional_group_id: The functional group id.
        :param int group_control_number_lower_bound: The group control number lower bound.
        :param int group_control_number_upper_bound: The group control number upper bound.
        :param str group_header_agency_code: The group header agency code.
        :param str group_header_date_format: The group header date format.
        :param str group_header_time_format: The group header time format.
        :param str group_header_version: The group header version.
        :param int interchange_control_number_lower_bound: The interchange  control number lower bound.
        :param int interchange_control_number_upper_bound: The interchange  control number upper bound.
        :param bool overwrite_existing_transaction_set_control_number: The value indicating whether to overwrite existing transaction set control number.
        :param str receiver_application_id: The receiver application id.
        :param bool rollover_group_control_number: The value indicating whether to rollover group control number.
        :param bool rollover_interchange_control_number: The value indicating whether to rollover interchange control number.
        :param bool rollover_transaction_set_control_number: The value indicating whether to rollover transaction set control number.
        :param str sender_application_id: The sender application id.
        :param int transaction_set_control_number_lower_bound: The transaction set control number lower bound.
        :param str transaction_set_control_number_prefix: The transaction set control number prefix.
        :param str transaction_set_control_number_suffix: The transaction set control number suffix.
        :param int transaction_set_control_number_upper_bound: The transaction set control number upper bound.
        :param str usage_indicator: The usage indicator.
        :param bool use_control_standards_id_as_repetition_character: The value indicating whether to use control standards id as repetition character.
        """
        if control_standards_id is not None:
            pulumi.set(__self__, "control_standards_id", control_standards_id)
        if control_version_number is not None:
            pulumi.set(__self__, "control_version_number", control_version_number)
        if enable_default_group_headers is not None:
            pulumi.set(__self__, "enable_default_group_headers", enable_default_group_headers)
        if functional_group_id is not None:
            pulumi.set(__self__, "functional_group_id", functional_group_id)
        if group_control_number_lower_bound is not None:
            pulumi.set(__self__, "group_control_number_lower_bound", group_control_number_lower_bound)
        if group_control_number_upper_bound is not None:
            pulumi.set(__self__, "group_control_number_upper_bound", group_control_number_upper_bound)
        if group_header_agency_code is not None:
            pulumi.set(__self__, "group_header_agency_code", group_header_agency_code)
        if group_header_date_format is not None:
            pulumi.set(__self__, "group_header_date_format", group_header_date_format)
        if group_header_time_format is not None:
            pulumi.set(__self__, "group_header_time_format", group_header_time_format)
        if group_header_version is not None:
            pulumi.set(__self__, "group_header_version", group_header_version)
        if interchange_control_number_lower_bound is not None:
            pulumi.set(__self__, "interchange_control_number_lower_bound", interchange_control_number_lower_bound)
        if interchange_control_number_upper_bound is not None:
            pulumi.set(__self__, "interchange_control_number_upper_bound", interchange_control_number_upper_bound)
        if overwrite_existing_transaction_set_control_number is not None:
            pulumi.set(__self__, "overwrite_existing_transaction_set_control_number", overwrite_existing_transaction_set_control_number)
        if receiver_application_id is not None:
            pulumi.set(__self__, "receiver_application_id", receiver_application_id)
        if rollover_group_control_number is not None:
            pulumi.set(__self__, "rollover_group_control_number", rollover_group_control_number)
        if rollover_interchange_control_number is not None:
            pulumi.set(__self__, "rollover_interchange_control_number", rollover_interchange_control_number)
        if rollover_transaction_set_control_number is not None:
            pulumi.set(__self__, "rollover_transaction_set_control_number", rollover_transaction_set_control_number)
        if sender_application_id is not None:
            pulumi.set(__self__, "sender_application_id", sender_application_id)
        if transaction_set_control_number_lower_bound is not None:
            pulumi.set(__self__, "transaction_set_control_number_lower_bound", transaction_set_control_number_lower_bound)
        if transaction_set_control_number_prefix is not None:
            pulumi.set(__self__, "transaction_set_control_number_prefix", transaction_set_control_number_prefix)
        if transaction_set_control_number_suffix is not None:
            pulumi.set(__self__, "transaction_set_control_number_suffix", transaction_set_control_number_suffix)
        if transaction_set_control_number_upper_bound is not None:
            pulumi.set(__self__, "transaction_set_control_number_upper_bound", transaction_set_control_number_upper_bound)
        if usage_indicator is not None:
            pulumi.set(__self__, "usage_indicator", usage_indicator)
        if use_control_standards_id_as_repetition_character is not None:
            pulumi.set(__self__, "use_control_standards_id_as_repetition_character", use_control_standards_id_as_repetition_character)

    @property
    @pulumi.getter(name="controlStandardsId")
    def control_standards_id(self) -> Optional[int]:
        """
        The controls standards id.
        """
        return pulumi.get(self, "control_standards_id")

    @property
    @pulumi.getter(name="controlVersionNumber")
    def control_version_number(self) -> Optional[str]:
        """
        The control version number.
        """
        return pulumi.get(self, "control_version_number")

    @property
    @pulumi.getter(name="enableDefaultGroupHeaders")
    def enable_default_group_headers(self) -> Optional[bool]:
        """
        The value indicating whether to enable default group headers.
        """
        return pulumi.get(self, "enable_default_group_headers")

    @property
    @pulumi.getter(name="functionalGroupId")
    def functional_group_id(self) -> Optional[str]:
        """
        The functional group id.
        """
        return pulumi.get(self, "functional_group_id")

    @property
    @pulumi.getter(name="groupControlNumberLowerBound")
    def group_control_number_lower_bound(self) -> Optional[int]:
        """
        The group control number lower bound.
        """
        return pulumi.get(self, "group_control_number_lower_bound")

    @property
    @pulumi.getter(name="groupControlNumberUpperBound")
    def group_control_number_upper_bound(self) -> Optional[int]:
        """
        The group control number upper bound.
        """
        return pulumi.get(self, "group_control_number_upper_bound")

    @property
    @pulumi.getter(name="groupHeaderAgencyCode")
    def group_header_agency_code(self) -> Optional[str]:
        """
        The group header agency code.
        """
        return pulumi.get(self, "group_header_agency_code")

    @property
    @pulumi.getter(name="groupHeaderDateFormat")
    def group_header_date_format(self) -> Optional[str]:
        """
        The group header date format.
        """
        return pulumi.get(self, "group_header_date_format")

    @property
    @pulumi.getter(name="groupHeaderTimeFormat")
    def group_header_time_format(self) -> Optional[str]:
        """
        The group header time format.
        """
        return pulumi.get(self, "group_header_time_format")

    @property
    @pulumi.getter(name="groupHeaderVersion")
    def group_header_version(self) -> Optional[str]:
        """
        The group header version.
        """
        return pulumi.get(self, "group_header_version")

    @property
    @pulumi.getter(name="interchangeControlNumberLowerBound")
    def interchange_control_number_lower_bound(self) -> Optional[int]:
        """
        The interchange  control number lower bound.
        """
        return pulumi.get(self, "interchange_control_number_lower_bound")

    @property
    @pulumi.getter(name="interchangeControlNumberUpperBound")
    def interchange_control_number_upper_bound(self) -> Optional[int]:
        """
        The interchange  control number upper bound.
        """
        return pulumi.get(self, "interchange_control_number_upper_bound")

    @property
    @pulumi.getter(name="overwriteExistingTransactionSetControlNumber")
    def overwrite_existing_transaction_set_control_number(self) -> Optional[bool]:
        """
        The value indicating whether to overwrite existing transaction set control number.
        """
        return pulumi.get(self, "overwrite_existing_transaction_set_control_number")

    @property
    @pulumi.getter(name="receiverApplicationId")
    def receiver_application_id(self) -> Optional[str]:
        """
        The receiver application id.
        """
        return pulumi.get(self, "receiver_application_id")

    @property
    @pulumi.getter(name="rolloverGroupControlNumber")
    def rollover_group_control_number(self) -> Optional[bool]:
        """
        The value indicating whether to rollover group control number.
        """
        return pulumi.get(self, "rollover_group_control_number")

    @property
    @pulumi.getter(name="rolloverInterchangeControlNumber")
    def rollover_interchange_control_number(self) -> Optional[bool]:
        """
        The value indicating whether to rollover interchange control number.
        """
        return pulumi.get(self, "rollover_interchange_control_number")

    @property
    @pulumi.getter(name="rolloverTransactionSetControlNumber")
    def rollover_transaction_set_control_number(self) -> Optional[bool]:
        """
        The value indicating whether to rollover transaction set control number.
        """
        return pulumi.get(self, "rollover_transaction_set_control_number")

    @property
    @pulumi.getter(name="senderApplicationId")
    def sender_application_id(self) -> Optional[str]:
        """
        The sender application id.
        """
        return pulumi.get(self, "sender_application_id")

    @property
    @pulumi.getter(name="transactionSetControlNumberLowerBound")
    def transaction_set_control_number_lower_bound(self) -> Optional[int]:
        """
        The transaction set control number lower bound.
        """
        return pulumi.get(self, "transaction_set_control_number_lower_bound")

    @property
    @pulumi.getter(name="transactionSetControlNumberPrefix")
    def transaction_set_control_number_prefix(self) -> Optional[str]:
        """
        The transaction set control number prefix.
        """
        return pulumi.get(self, "transaction_set_control_number_prefix")

    @property
    @pulumi.getter(name="transactionSetControlNumberSuffix")
    def transaction_set_control_number_suffix(self) -> Optional[str]:
        """
        The transaction set control number suffix.
        """
        return pulumi.get(self, "transaction_set_control_number_suffix")

    @property
    @pulumi.getter(name="transactionSetControlNumberUpperBound")
    def transaction_set_control_number_upper_bound(self) -> Optional[int]:
        """
        The transaction set control number upper bound.
        """
        return pulumi.get(self, "transaction_set_control_number_upper_bound")

    @property
    @pulumi.getter(name="usageIndicator")
    def usage_indicator(self) -> Optional[str]:
        """
        The usage indicator.
        """
        return pulumi.get(self, "usage_indicator")

    @property
    @pulumi.getter(name="useControlStandardsIdAsRepetitionCharacter")
    def use_control_standards_id_as_repetition_character(self) -> Optional[bool]:
        """
        The value indicating whether to use control standards id as repetition character.
        """
        return pulumi.get(self, "use_control_standards_id_as_repetition_character")


@pulumi.output_type
class X12FramingSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "characterSet":
            suggest = "character_set"
        elif key == "componentSeparator":
            suggest = "component_separator"
        elif key == "dataElementSeparator":
            suggest = "data_element_separator"
        elif key == "replaceCharacter":
            suggest = "replace_character"
        elif key == "replaceSeparatorsInPayload":
            suggest = "replace_separators_in_payload"
        elif key == "segmentTerminator":
            suggest = "segment_terminator"
        elif key == "segmentTerminatorSuffix":
            suggest = "segment_terminator_suffix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12FramingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12FramingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12FramingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 character_set: Optional[str] = None,
                 component_separator: Optional[int] = None,
                 data_element_separator: Optional[int] = None,
                 replace_character: Optional[int] = None,
                 replace_separators_in_payload: Optional[bool] = None,
                 segment_terminator: Optional[int] = None,
                 segment_terminator_suffix: Optional[str] = None):
        """
        :param str character_set: The X12 character set.
        :param int component_separator: The component separator.
        :param int data_element_separator: The data element separator.
        :param int replace_character: The replacement character.
        :param bool replace_separators_in_payload: The value indicating whether to replace separators in payload.
        :param int segment_terminator: The segment terminator.
        :param str segment_terminator_suffix: The segment terminator suffix.
        """
        if character_set is not None:
            pulumi.set(__self__, "character_set", character_set)
        if component_separator is not None:
            pulumi.set(__self__, "component_separator", component_separator)
        if data_element_separator is not None:
            pulumi.set(__self__, "data_element_separator", data_element_separator)
        if replace_character is not None:
            pulumi.set(__self__, "replace_character", replace_character)
        if replace_separators_in_payload is not None:
            pulumi.set(__self__, "replace_separators_in_payload", replace_separators_in_payload)
        if segment_terminator is not None:
            pulumi.set(__self__, "segment_terminator", segment_terminator)
        if segment_terminator_suffix is not None:
            pulumi.set(__self__, "segment_terminator_suffix", segment_terminator_suffix)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> Optional[str]:
        """
        The X12 character set.
        """
        return pulumi.get(self, "character_set")

    @property
    @pulumi.getter(name="componentSeparator")
    def component_separator(self) -> Optional[int]:
        """
        The component separator.
        """
        return pulumi.get(self, "component_separator")

    @property
    @pulumi.getter(name="dataElementSeparator")
    def data_element_separator(self) -> Optional[int]:
        """
        The data element separator.
        """
        return pulumi.get(self, "data_element_separator")

    @property
    @pulumi.getter(name="replaceCharacter")
    def replace_character(self) -> Optional[int]:
        """
        The replacement character.
        """
        return pulumi.get(self, "replace_character")

    @property
    @pulumi.getter(name="replaceSeparatorsInPayload")
    def replace_separators_in_payload(self) -> Optional[bool]:
        """
        The value indicating whether to replace separators in payload.
        """
        return pulumi.get(self, "replace_separators_in_payload")

    @property
    @pulumi.getter(name="segmentTerminator")
    def segment_terminator(self) -> Optional[int]:
        """
        The segment terminator.
        """
        return pulumi.get(self, "segment_terminator")

    @property
    @pulumi.getter(name="segmentTerminatorSuffix")
    def segment_terminator_suffix(self) -> Optional[str]:
        """
        The segment terminator suffix.
        """
        return pulumi.get(self, "segment_terminator_suffix")


@pulumi.output_type
class X12MessageFilterResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageFilterType":
            suggest = "message_filter_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12MessageFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12MessageFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12MessageFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_filter_type: Optional[str] = None):
        """
        :param str message_filter_type: The message filter type.
        """
        if message_filter_type is not None:
            pulumi.set(__self__, "message_filter_type", message_filter_type)

    @property
    @pulumi.getter(name="messageFilterType")
    def message_filter_type(self) -> Optional[str]:
        """
        The message filter type.
        """
        return pulumi.get(self, "message_filter_type")


@pulumi.output_type
class X12MessageIdentifierResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageId":
            suggest = "message_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12MessageIdentifierResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12MessageIdentifierResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12MessageIdentifierResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_id: Optional[str] = None):
        """
        :param str message_id: The message id.
        """
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[str]:
        """
        The message id.
        """
        return pulumi.get(self, "message_id")


@pulumi.output_type
class X12OneWayAgreementResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protocolSettings":
            suggest = "protocol_settings"
        elif key == "receiverBusinessIdentity":
            suggest = "receiver_business_identity"
        elif key == "senderBusinessIdentity":
            suggest = "sender_business_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12OneWayAgreementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12OneWayAgreementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12OneWayAgreementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol_settings: Optional['outputs.X12ProtocolSettingsResponse'] = None,
                 receiver_business_identity: Optional['outputs.BusinessIdentityResponse'] = None,
                 sender_business_identity: Optional['outputs.BusinessIdentityResponse'] = None):
        """
        :param 'X12ProtocolSettingsResponse' protocol_settings: The X12 protocol settings.
        :param 'BusinessIdentityResponse' receiver_business_identity: The receiver business identity
        :param 'BusinessIdentityResponse' sender_business_identity: The sender business identity
        """
        if protocol_settings is not None:
            pulumi.set(__self__, "protocol_settings", protocol_settings)
        if receiver_business_identity is not None:
            pulumi.set(__self__, "receiver_business_identity", receiver_business_identity)
        if sender_business_identity is not None:
            pulumi.set(__self__, "sender_business_identity", sender_business_identity)

    @property
    @pulumi.getter(name="protocolSettings")
    def protocol_settings(self) -> Optional['outputs.X12ProtocolSettingsResponse']:
        """
        The X12 protocol settings.
        """
        return pulumi.get(self, "protocol_settings")

    @property
    @pulumi.getter(name="receiverBusinessIdentity")
    def receiver_business_identity(self) -> Optional['outputs.BusinessIdentityResponse']:
        """
        The receiver business identity
        """
        return pulumi.get(self, "receiver_business_identity")

    @property
    @pulumi.getter(name="senderBusinessIdentity")
    def sender_business_identity(self) -> Optional['outputs.BusinessIdentityResponse']:
        """
        The sender business identity
        """
        return pulumi.get(self, "sender_business_identity")


@pulumi.output_type
class X12ProcessingSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "convertImpliedDecimal":
            suggest = "convert_implied_decimal"
        elif key == "createEmptyXmlTagsForTrailingSeparators":
            suggest = "create_empty_xml_tags_for_trailing_separators"
        elif key == "maskSecurityInfo":
            suggest = "mask_security_info"
        elif key == "preserveInterchange":
            suggest = "preserve_interchange"
        elif key == "suspendInterchangeOnError":
            suggest = "suspend_interchange_on_error"
        elif key == "useDotAsDecimalSeparator":
            suggest = "use_dot_as_decimal_separator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12ProcessingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12ProcessingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12ProcessingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 convert_implied_decimal: Optional[bool] = None,
                 create_empty_xml_tags_for_trailing_separators: Optional[bool] = None,
                 mask_security_info: Optional[bool] = None,
                 preserve_interchange: Optional[bool] = None,
                 suspend_interchange_on_error: Optional[bool] = None,
                 use_dot_as_decimal_separator: Optional[bool] = None):
        """
        :param bool convert_implied_decimal: The value indicating whether to convert numerical type to implied decimal.
        :param bool create_empty_xml_tags_for_trailing_separators: The value indicating whether to create empty xml tags for trailing separators.
        :param bool mask_security_info: The value indicating whether to mask security information.
        :param bool preserve_interchange: The value indicating whether to preserve interchange.
        :param bool suspend_interchange_on_error: The value indicating whether to suspend interchange on error.
        :param bool use_dot_as_decimal_separator: The value indicating whether to use dot as decimal separator.
        """
        if convert_implied_decimal is not None:
            pulumi.set(__self__, "convert_implied_decimal", convert_implied_decimal)
        if create_empty_xml_tags_for_trailing_separators is not None:
            pulumi.set(__self__, "create_empty_xml_tags_for_trailing_separators", create_empty_xml_tags_for_trailing_separators)
        if mask_security_info is not None:
            pulumi.set(__self__, "mask_security_info", mask_security_info)
        if preserve_interchange is not None:
            pulumi.set(__self__, "preserve_interchange", preserve_interchange)
        if suspend_interchange_on_error is not None:
            pulumi.set(__self__, "suspend_interchange_on_error", suspend_interchange_on_error)
        if use_dot_as_decimal_separator is not None:
            pulumi.set(__self__, "use_dot_as_decimal_separator", use_dot_as_decimal_separator)

    @property
    @pulumi.getter(name="convertImpliedDecimal")
    def convert_implied_decimal(self) -> Optional[bool]:
        """
        The value indicating whether to convert numerical type to implied decimal.
        """
        return pulumi.get(self, "convert_implied_decimal")

    @property
    @pulumi.getter(name="createEmptyXmlTagsForTrailingSeparators")
    def create_empty_xml_tags_for_trailing_separators(self) -> Optional[bool]:
        """
        The value indicating whether to create empty xml tags for trailing separators.
        """
        return pulumi.get(self, "create_empty_xml_tags_for_trailing_separators")

    @property
    @pulumi.getter(name="maskSecurityInfo")
    def mask_security_info(self) -> Optional[bool]:
        """
        The value indicating whether to mask security information.
        """
        return pulumi.get(self, "mask_security_info")

    @property
    @pulumi.getter(name="preserveInterchange")
    def preserve_interchange(self) -> Optional[bool]:
        """
        The value indicating whether to preserve interchange.
        """
        return pulumi.get(self, "preserve_interchange")

    @property
    @pulumi.getter(name="suspendInterchangeOnError")
    def suspend_interchange_on_error(self) -> Optional[bool]:
        """
        The value indicating whether to suspend interchange on error.
        """
        return pulumi.get(self, "suspend_interchange_on_error")

    @property
    @pulumi.getter(name="useDotAsDecimalSeparator")
    def use_dot_as_decimal_separator(self) -> Optional[bool]:
        """
        The value indicating whether to use dot as decimal separator.
        """
        return pulumi.get(self, "use_dot_as_decimal_separator")


@pulumi.output_type
class X12ProtocolSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acknowledgementSettings":
            suggest = "acknowledgement_settings"
        elif key == "envelopeOverrides":
            suggest = "envelope_overrides"
        elif key == "envelopeSettings":
            suggest = "envelope_settings"
        elif key == "framingSettings":
            suggest = "framing_settings"
        elif key == "messageFilter":
            suggest = "message_filter"
        elif key == "messageFilterList":
            suggest = "message_filter_list"
        elif key == "processingSettings":
            suggest = "processing_settings"
        elif key == "schemaReferences":
            suggest = "schema_references"
        elif key == "securitySettings":
            suggest = "security_settings"
        elif key == "validationOverrides":
            suggest = "validation_overrides"
        elif key == "validationSettings":
            suggest = "validation_settings"
        elif key == "x12DelimiterOverrides":
            suggest = "x12_delimiter_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12ProtocolSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12ProtocolSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12ProtocolSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acknowledgement_settings: Optional['outputs.X12AcknowledgementSettingsResponse'] = None,
                 envelope_overrides: Optional[Sequence['outputs.X12EnvelopeOverrideResponse']] = None,
                 envelope_settings: Optional['outputs.X12EnvelopeSettingsResponse'] = None,
                 framing_settings: Optional['outputs.X12FramingSettingsResponse'] = None,
                 message_filter: Optional['outputs.X12MessageFilterResponse'] = None,
                 message_filter_list: Optional[Sequence['outputs.X12MessageIdentifierResponse']] = None,
                 processing_settings: Optional['outputs.X12ProcessingSettingsResponse'] = None,
                 schema_references: Optional[Sequence['outputs.X12SchemaReferenceResponse']] = None,
                 security_settings: Optional['outputs.X12SecuritySettingsResponse'] = None,
                 validation_overrides: Optional[Sequence['outputs.X12ValidationOverrideResponse']] = None,
                 validation_settings: Optional['outputs.X12ValidationSettingsResponse'] = None,
                 x12_delimiter_overrides: Optional[Sequence['outputs.X12DelimiterOverridesResponse']] = None):
        """
        :param 'X12AcknowledgementSettingsResponse' acknowledgement_settings: The X12 acknowledgment settings.
        :param Sequence['X12EnvelopeOverrideResponse'] envelope_overrides: The X12 envelope override settings.
        :param 'X12EnvelopeSettingsResponse' envelope_settings: The X12 envelope settings.
        :param 'X12FramingSettingsResponse' framing_settings: The X12 framing settings.
        :param 'X12MessageFilterResponse' message_filter: The X12 message filter.
        :param Sequence['X12MessageIdentifierResponse'] message_filter_list: The X12 message filter list.
        :param 'X12ProcessingSettingsResponse' processing_settings: The X12 processing settings.
        :param Sequence['X12SchemaReferenceResponse'] schema_references: The X12 schema references.
        :param 'X12SecuritySettingsResponse' security_settings: The X12 security settings.
        :param Sequence['X12ValidationOverrideResponse'] validation_overrides: The X12 validation override settings.
        :param 'X12ValidationSettingsResponse' validation_settings: The X12 validation settings.
        :param Sequence['X12DelimiterOverridesResponse'] x12_delimiter_overrides: The X12 delimiter override settings.
        """
        if acknowledgement_settings is not None:
            pulumi.set(__self__, "acknowledgement_settings", acknowledgement_settings)
        if envelope_overrides is not None:
            pulumi.set(__self__, "envelope_overrides", envelope_overrides)
        if envelope_settings is not None:
            pulumi.set(__self__, "envelope_settings", envelope_settings)
        if framing_settings is not None:
            pulumi.set(__self__, "framing_settings", framing_settings)
        if message_filter is not None:
            pulumi.set(__self__, "message_filter", message_filter)
        if message_filter_list is not None:
            pulumi.set(__self__, "message_filter_list", message_filter_list)
        if processing_settings is not None:
            pulumi.set(__self__, "processing_settings", processing_settings)
        if schema_references is not None:
            pulumi.set(__self__, "schema_references", schema_references)
        if security_settings is not None:
            pulumi.set(__self__, "security_settings", security_settings)
        if validation_overrides is not None:
            pulumi.set(__self__, "validation_overrides", validation_overrides)
        if validation_settings is not None:
            pulumi.set(__self__, "validation_settings", validation_settings)
        if x12_delimiter_overrides is not None:
            pulumi.set(__self__, "x12_delimiter_overrides", x12_delimiter_overrides)

    @property
    @pulumi.getter(name="acknowledgementSettings")
    def acknowledgement_settings(self) -> Optional['outputs.X12AcknowledgementSettingsResponse']:
        """
        The X12 acknowledgment settings.
        """
        return pulumi.get(self, "acknowledgement_settings")

    @property
    @pulumi.getter(name="envelopeOverrides")
    def envelope_overrides(self) -> Optional[Sequence['outputs.X12EnvelopeOverrideResponse']]:
        """
        The X12 envelope override settings.
        """
        return pulumi.get(self, "envelope_overrides")

    @property
    @pulumi.getter(name="envelopeSettings")
    def envelope_settings(self) -> Optional['outputs.X12EnvelopeSettingsResponse']:
        """
        The X12 envelope settings.
        """
        return pulumi.get(self, "envelope_settings")

    @property
    @pulumi.getter(name="framingSettings")
    def framing_settings(self) -> Optional['outputs.X12FramingSettingsResponse']:
        """
        The X12 framing settings.
        """
        return pulumi.get(self, "framing_settings")

    @property
    @pulumi.getter(name="messageFilter")
    def message_filter(self) -> Optional['outputs.X12MessageFilterResponse']:
        """
        The X12 message filter.
        """
        return pulumi.get(self, "message_filter")

    @property
    @pulumi.getter(name="messageFilterList")
    def message_filter_list(self) -> Optional[Sequence['outputs.X12MessageIdentifierResponse']]:
        """
        The X12 message filter list.
        """
        return pulumi.get(self, "message_filter_list")

    @property
    @pulumi.getter(name="processingSettings")
    def processing_settings(self) -> Optional['outputs.X12ProcessingSettingsResponse']:
        """
        The X12 processing settings.
        """
        return pulumi.get(self, "processing_settings")

    @property
    @pulumi.getter(name="schemaReferences")
    def schema_references(self) -> Optional[Sequence['outputs.X12SchemaReferenceResponse']]:
        """
        The X12 schema references.
        """
        return pulumi.get(self, "schema_references")

    @property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> Optional['outputs.X12SecuritySettingsResponse']:
        """
        The X12 security settings.
        """
        return pulumi.get(self, "security_settings")

    @property
    @pulumi.getter(name="validationOverrides")
    def validation_overrides(self) -> Optional[Sequence['outputs.X12ValidationOverrideResponse']]:
        """
        The X12 validation override settings.
        """
        return pulumi.get(self, "validation_overrides")

    @property
    @pulumi.getter(name="validationSettings")
    def validation_settings(self) -> Optional['outputs.X12ValidationSettingsResponse']:
        """
        The X12 validation settings.
        """
        return pulumi.get(self, "validation_settings")

    @property
    @pulumi.getter(name="x12DelimiterOverrides")
    def x12_delimiter_overrides(self) -> Optional[Sequence['outputs.X12DelimiterOverridesResponse']]:
        """
        The X12 delimiter override settings.
        """
        return pulumi.get(self, "x12_delimiter_overrides")


@pulumi.output_type
class X12SchemaReferenceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageId":
            suggest = "message_id"
        elif key == "schemaName":
            suggest = "schema_name"
        elif key == "schemaVersion":
            suggest = "schema_version"
        elif key == "senderApplicationId":
            suggest = "sender_application_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12SchemaReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12SchemaReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12SchemaReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_id: Optional[str] = None,
                 schema_name: Optional[str] = None,
                 schema_version: Optional[str] = None,
                 sender_application_id: Optional[str] = None):
        """
        :param str message_id: The message id.
        :param str schema_name: The schema name.
        :param str schema_version: The schema version.
        :param str sender_application_id: The sender application id.
        """
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if schema_version is not None:
            pulumi.set(__self__, "schema_version", schema_version)
        if sender_application_id is not None:
            pulumi.set(__self__, "sender_application_id", sender_application_id)

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[str]:
        """
        The message id.
        """
        return pulumi.get(self, "message_id")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[str]:
        """
        The schema name.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="schemaVersion")
    def schema_version(self) -> Optional[str]:
        """
        The schema version.
        """
        return pulumi.get(self, "schema_version")

    @property
    @pulumi.getter(name="senderApplicationId")
    def sender_application_id(self) -> Optional[str]:
        """
        The sender application id.
        """
        return pulumi.get(self, "sender_application_id")


@pulumi.output_type
class X12SecuritySettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationQualifier":
            suggest = "authorization_qualifier"
        elif key == "authorizationValue":
            suggest = "authorization_value"
        elif key == "passwordValue":
            suggest = "password_value"
        elif key == "securityQualifier":
            suggest = "security_qualifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12SecuritySettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12SecuritySettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12SecuritySettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_qualifier: Optional[str] = None,
                 authorization_value: Optional[str] = None,
                 password_value: Optional[str] = None,
                 security_qualifier: Optional[str] = None):
        """
        :param str authorization_qualifier: The authorization qualifier.
        :param str authorization_value: The authorization value.
        :param str password_value: The password value.
        :param str security_qualifier: The security qualifier.
        """
        if authorization_qualifier is not None:
            pulumi.set(__self__, "authorization_qualifier", authorization_qualifier)
        if authorization_value is not None:
            pulumi.set(__self__, "authorization_value", authorization_value)
        if password_value is not None:
            pulumi.set(__self__, "password_value", password_value)
        if security_qualifier is not None:
            pulumi.set(__self__, "security_qualifier", security_qualifier)

    @property
    @pulumi.getter(name="authorizationQualifier")
    def authorization_qualifier(self) -> Optional[str]:
        """
        The authorization qualifier.
        """
        return pulumi.get(self, "authorization_qualifier")

    @property
    @pulumi.getter(name="authorizationValue")
    def authorization_value(self) -> Optional[str]:
        """
        The authorization value.
        """
        return pulumi.get(self, "authorization_value")

    @property
    @pulumi.getter(name="passwordValue")
    def password_value(self) -> Optional[str]:
        """
        The password value.
        """
        return pulumi.get(self, "password_value")

    @property
    @pulumi.getter(name="securityQualifier")
    def security_qualifier(self) -> Optional[str]:
        """
        The security qualifier.
        """
        return pulumi.get(self, "security_qualifier")


@pulumi.output_type
class X12ValidationOverrideResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowLeadingAndTrailingSpacesAndZeroes":
            suggest = "allow_leading_and_trailing_spaces_and_zeroes"
        elif key == "messageId":
            suggest = "message_id"
        elif key == "trailingSeparatorPolicy":
            suggest = "trailing_separator_policy"
        elif key == "trimLeadingAndTrailingSpacesAndZeroes":
            suggest = "trim_leading_and_trailing_spaces_and_zeroes"
        elif key == "validateCharacterSet":
            suggest = "validate_character_set"
        elif key == "validateEDITypes":
            suggest = "validate_edi_types"
        elif key == "validateXSDTypes":
            suggest = "validate_xsd_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12ValidationOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12ValidationOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12ValidationOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_leading_and_trailing_spaces_and_zeroes: Optional[bool] = None,
                 message_id: Optional[str] = None,
                 trailing_separator_policy: Optional[str] = None,
                 trim_leading_and_trailing_spaces_and_zeroes: Optional[bool] = None,
                 validate_character_set: Optional[bool] = None,
                 validate_edi_types: Optional[bool] = None,
                 validate_xsd_types: Optional[bool] = None):
        """
        :param bool allow_leading_and_trailing_spaces_and_zeroes: The value indicating whether to allow leading and trailing spaces and zeroes.
        :param str message_id: The message id on which the validation settings has to be applied.
        :param str trailing_separator_policy: The trailing separator policy.
        :param bool trim_leading_and_trailing_spaces_and_zeroes: The value indicating whether to trim leading and trailing spaces and zeroes.
        :param bool validate_character_set: The value indicating whether to validate character Set.
        :param bool validate_edi_types: The value indicating whether to validate EDI types.
        :param bool validate_xsd_types: The value indicating whether to validate XSD types.
        """
        if allow_leading_and_trailing_spaces_and_zeroes is not None:
            pulumi.set(__self__, "allow_leading_and_trailing_spaces_and_zeroes", allow_leading_and_trailing_spaces_and_zeroes)
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)
        if trailing_separator_policy is not None:
            pulumi.set(__self__, "trailing_separator_policy", trailing_separator_policy)
        if trim_leading_and_trailing_spaces_and_zeroes is not None:
            pulumi.set(__self__, "trim_leading_and_trailing_spaces_and_zeroes", trim_leading_and_trailing_spaces_and_zeroes)
        if validate_character_set is not None:
            pulumi.set(__self__, "validate_character_set", validate_character_set)
        if validate_edi_types is not None:
            pulumi.set(__self__, "validate_edi_types", validate_edi_types)
        if validate_xsd_types is not None:
            pulumi.set(__self__, "validate_xsd_types", validate_xsd_types)

    @property
    @pulumi.getter(name="allowLeadingAndTrailingSpacesAndZeroes")
    def allow_leading_and_trailing_spaces_and_zeroes(self) -> Optional[bool]:
        """
        The value indicating whether to allow leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "allow_leading_and_trailing_spaces_and_zeroes")

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[str]:
        """
        The message id on which the validation settings has to be applied.
        """
        return pulumi.get(self, "message_id")

    @property
    @pulumi.getter(name="trailingSeparatorPolicy")
    def trailing_separator_policy(self) -> Optional[str]:
        """
        The trailing separator policy.
        """
        return pulumi.get(self, "trailing_separator_policy")

    @property
    @pulumi.getter(name="trimLeadingAndTrailingSpacesAndZeroes")
    def trim_leading_and_trailing_spaces_and_zeroes(self) -> Optional[bool]:
        """
        The value indicating whether to trim leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "trim_leading_and_trailing_spaces_and_zeroes")

    @property
    @pulumi.getter(name="validateCharacterSet")
    def validate_character_set(self) -> Optional[bool]:
        """
        The value indicating whether to validate character Set.
        """
        return pulumi.get(self, "validate_character_set")

    @property
    @pulumi.getter(name="validateEDITypes")
    def validate_edi_types(self) -> Optional[bool]:
        """
        The value indicating whether to validate EDI types.
        """
        return pulumi.get(self, "validate_edi_types")

    @property
    @pulumi.getter(name="validateXSDTypes")
    def validate_xsd_types(self) -> Optional[bool]:
        """
        The value indicating whether to validate XSD types.
        """
        return pulumi.get(self, "validate_xsd_types")


@pulumi.output_type
class X12ValidationSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowLeadingAndTrailingSpacesAndZeroes":
            suggest = "allow_leading_and_trailing_spaces_and_zeroes"
        elif key == "checkDuplicateGroupControlNumber":
            suggest = "check_duplicate_group_control_number"
        elif key == "checkDuplicateInterchangeControlNumber":
            suggest = "check_duplicate_interchange_control_number"
        elif key == "checkDuplicateTransactionSetControlNumber":
            suggest = "check_duplicate_transaction_set_control_number"
        elif key == "interchangeControlNumberValidityDays":
            suggest = "interchange_control_number_validity_days"
        elif key == "trailingSeparatorPolicy":
            suggest = "trailing_separator_policy"
        elif key == "trimLeadingAndTrailingSpacesAndZeroes":
            suggest = "trim_leading_and_trailing_spaces_and_zeroes"
        elif key == "validateCharacterSet":
            suggest = "validate_character_set"
        elif key == "validateEDITypes":
            suggest = "validate_edi_types"
        elif key == "validateXSDTypes":
            suggest = "validate_xsd_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12ValidationSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12ValidationSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12ValidationSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_leading_and_trailing_spaces_and_zeroes: Optional[bool] = None,
                 check_duplicate_group_control_number: Optional[bool] = None,
                 check_duplicate_interchange_control_number: Optional[bool] = None,
                 check_duplicate_transaction_set_control_number: Optional[bool] = None,
                 interchange_control_number_validity_days: Optional[int] = None,
                 trailing_separator_policy: Optional[str] = None,
                 trim_leading_and_trailing_spaces_and_zeroes: Optional[bool] = None,
                 validate_character_set: Optional[bool] = None,
                 validate_edi_types: Optional[bool] = None,
                 validate_xsd_types: Optional[bool] = None):
        """
        :param bool allow_leading_and_trailing_spaces_and_zeroes: The value indicating whether to allow leading and trailing spaces and zeroes.
        :param bool check_duplicate_group_control_number: The value indicating whether to check for duplicate group control number.
        :param bool check_duplicate_interchange_control_number: The value indicating whether to check for duplicate interchange control number.
        :param bool check_duplicate_transaction_set_control_number: The value indicating whether to check for duplicate transaction set control number.
        :param int interchange_control_number_validity_days: The validity period of interchange control number.
        :param str trailing_separator_policy: The trailing separator policy.
        :param bool trim_leading_and_trailing_spaces_and_zeroes: The value indicating whether to trim leading and trailing spaces and zeroes.
        :param bool validate_character_set: The value indicating whether to validate character set in the message.
        :param bool validate_edi_types: The value indicating whether to Whether to validate EDI types.
        :param bool validate_xsd_types: The value indicating whether to Whether to validate XSD types.
        """
        if allow_leading_and_trailing_spaces_and_zeroes is not None:
            pulumi.set(__self__, "allow_leading_and_trailing_spaces_and_zeroes", allow_leading_and_trailing_spaces_and_zeroes)
        if check_duplicate_group_control_number is not None:
            pulumi.set(__self__, "check_duplicate_group_control_number", check_duplicate_group_control_number)
        if check_duplicate_interchange_control_number is not None:
            pulumi.set(__self__, "check_duplicate_interchange_control_number", check_duplicate_interchange_control_number)
        if check_duplicate_transaction_set_control_number is not None:
            pulumi.set(__self__, "check_duplicate_transaction_set_control_number", check_duplicate_transaction_set_control_number)
        if interchange_control_number_validity_days is not None:
            pulumi.set(__self__, "interchange_control_number_validity_days", interchange_control_number_validity_days)
        if trailing_separator_policy is not None:
            pulumi.set(__self__, "trailing_separator_policy", trailing_separator_policy)
        if trim_leading_and_trailing_spaces_and_zeroes is not None:
            pulumi.set(__self__, "trim_leading_and_trailing_spaces_and_zeroes", trim_leading_and_trailing_spaces_and_zeroes)
        if validate_character_set is not None:
            pulumi.set(__self__, "validate_character_set", validate_character_set)
        if validate_edi_types is not None:
            pulumi.set(__self__, "validate_edi_types", validate_edi_types)
        if validate_xsd_types is not None:
            pulumi.set(__self__, "validate_xsd_types", validate_xsd_types)

    @property
    @pulumi.getter(name="allowLeadingAndTrailingSpacesAndZeroes")
    def allow_leading_and_trailing_spaces_and_zeroes(self) -> Optional[bool]:
        """
        The value indicating whether to allow leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "allow_leading_and_trailing_spaces_and_zeroes")

    @property
    @pulumi.getter(name="checkDuplicateGroupControlNumber")
    def check_duplicate_group_control_number(self) -> Optional[bool]:
        """
        The value indicating whether to check for duplicate group control number.
        """
        return pulumi.get(self, "check_duplicate_group_control_number")

    @property
    @pulumi.getter(name="checkDuplicateInterchangeControlNumber")
    def check_duplicate_interchange_control_number(self) -> Optional[bool]:
        """
        The value indicating whether to check for duplicate interchange control number.
        """
        return pulumi.get(self, "check_duplicate_interchange_control_number")

    @property
    @pulumi.getter(name="checkDuplicateTransactionSetControlNumber")
    def check_duplicate_transaction_set_control_number(self) -> Optional[bool]:
        """
        The value indicating whether to check for duplicate transaction set control number.
        """
        return pulumi.get(self, "check_duplicate_transaction_set_control_number")

    @property
    @pulumi.getter(name="interchangeControlNumberValidityDays")
    def interchange_control_number_validity_days(self) -> Optional[int]:
        """
        The validity period of interchange control number.
        """
        return pulumi.get(self, "interchange_control_number_validity_days")

    @property
    @pulumi.getter(name="trailingSeparatorPolicy")
    def trailing_separator_policy(self) -> Optional[str]:
        """
        The trailing separator policy.
        """
        return pulumi.get(self, "trailing_separator_policy")

    @property
    @pulumi.getter(name="trimLeadingAndTrailingSpacesAndZeroes")
    def trim_leading_and_trailing_spaces_and_zeroes(self) -> Optional[bool]:
        """
        The value indicating whether to trim leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "trim_leading_and_trailing_spaces_and_zeroes")

    @property
    @pulumi.getter(name="validateCharacterSet")
    def validate_character_set(self) -> Optional[bool]:
        """
        The value indicating whether to validate character set in the message.
        """
        return pulumi.get(self, "validate_character_set")

    @property
    @pulumi.getter(name="validateEDITypes")
    def validate_edi_types(self) -> Optional[bool]:
        """
        The value indicating whether to Whether to validate EDI types.
        """
        return pulumi.get(self, "validate_edi_types")

    @property
    @pulumi.getter(name="validateXSDTypes")
    def validate_xsd_types(self) -> Optional[bool]:
        """
        The value indicating whether to Whether to validate XSD types.
        """
        return pulumi.get(self, "validate_xsd_types")


