# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DiskArgs',
    'IpAddressArgs',
    'NetworkProfileArgs',
    'OSProfileArgs',
    'SAPSystemIDArgs',
    'StorageProfileArgs',
]

@pulumi.input_type
class DiskArgs:
    def __init__(__self__, *,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Specifies the disk information for the HANA instance
        :param pulumi.Input[int] disk_size_gb: Specifies the size of an empty data disk in gigabytes.
        :param pulumi.Input[str] name: The disk name.
        """
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of an empty data disk in gigabytes.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class IpAddressArgs:
    def __init__(__self__, *,
                 ip_address: Optional[pulumi.Input[str]] = None):
        """
        Specifies the IP address of the network interface.
        :param pulumi.Input[str] ip_address: Specifies the IP address of the network interface.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IP address of the network interface.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)


@pulumi.input_type
class NetworkProfileArgs:
    def __init__(__self__, *,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['IpAddressArgs']]]] = None):
        """
        Specifies the network settings for the HANA instance disks.
        :param pulumi.Input[Sequence[pulumi.Input['IpAddressArgs']]] network_interfaces: Specifies the network interfaces for the HANA instance.
        """
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpAddressArgs']]]]:
        """
        Specifies the network interfaces for the HANA instance.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpAddressArgs']]]]):
        pulumi.set(self, "network_interfaces", value)


@pulumi.input_type
class OSProfileArgs:
    def __init__(__self__, *,
                 computer_name: Optional[pulumi.Input[str]] = None,
                 ssh_public_key: Optional[pulumi.Input[str]] = None):
        """
        Specifies the operating system settings for the HANA instance.
        :param pulumi.Input[str] computer_name: Specifies the host OS name of the HANA instance.
        :param pulumi.Input[str] ssh_public_key: Specifies the SSH public key used to access the operating system.
        """
        if computer_name is not None:
            pulumi.set(__self__, "computer_name", computer_name)
        if ssh_public_key is not None:
            pulumi.set(__self__, "ssh_public_key", ssh_public_key)

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the host OS name of the HANA instance.
        """
        return pulumi.get(self, "computer_name")

    @computer_name.setter
    def computer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "computer_name", value)

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the SSH public key used to access the operating system.
        """
        return pulumi.get(self, "ssh_public_key")

    @ssh_public_key.setter
    def ssh_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_public_key", value)


@pulumi.input_type
class SAPSystemIDArgs:
    def __init__(__self__, *,
                 gid: Optional[pulumi.Input[str]] = None,
                 sid: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Specifies information related to a SAP system ID
        :param pulumi.Input[str] gid: Group ID of the HANA database user.
        :param pulumi.Input[str] sid: SAP system ID as database identifier.
        :param pulumi.Input[str] uid: User ID of the HANA database user.
        :param pulumi.Input[str] username: Name of the HANA database user.
        """
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if sid is not None:
            pulumi.set(__self__, "sid", sid)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def gid(self) -> Optional[pulumi.Input[str]]:
        """
        Group ID of the HANA database user.
        """
        return pulumi.get(self, "gid")

    @gid.setter
    def gid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gid", value)

    @property
    @pulumi.getter
    def sid(self) -> Optional[pulumi.Input[str]]:
        """
        SAP system ID as database identifier.
        """
        return pulumi.get(self, "sid")

    @sid.setter
    def sid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sid", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        User ID of the HANA database user.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the HANA database user.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class StorageProfileArgs:
    def __init__(__self__, *,
                 hana_sids: Optional[pulumi.Input[Sequence[pulumi.Input['SAPSystemIDArgs']]]] = None,
                 os_disks: Optional[pulumi.Input[Sequence[pulumi.Input['DiskArgs']]]] = None):
        """
        Specifies the storage settings for the HANA instance disks.
        :param pulumi.Input[Sequence[pulumi.Input['SAPSystemIDArgs']]] hana_sids: Specifies information related to SAP system IDs for the hana instance.
        :param pulumi.Input[Sequence[pulumi.Input['DiskArgs']]] os_disks: Specifies information about the operating system disk used by the hana instance.
        """
        if hana_sids is not None:
            pulumi.set(__self__, "hana_sids", hana_sids)
        if os_disks is not None:
            pulumi.set(__self__, "os_disks", os_disks)

    @property
    @pulumi.getter(name="hanaSids")
    def hana_sids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SAPSystemIDArgs']]]]:
        """
        Specifies information related to SAP system IDs for the hana instance.
        """
        return pulumi.get(self, "hana_sids")

    @hana_sids.setter
    def hana_sids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SAPSystemIDArgs']]]]):
        pulumi.set(self, "hana_sids", value)

    @property
    @pulumi.getter(name="osDisks")
    def os_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiskArgs']]]]:
        """
        Specifies information about the operating system disk used by the hana instance.
        """
        return pulumi.get(self, "os_disks")

    @os_disks.setter
    def os_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiskArgs']]]]):
        pulumi.set(self, "os_disks", value)


