# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AssignmentLockSettingsResponse',
    'AssignmentStatusResponse',
    'BlueprintStatusResponse',
    'ManagedServiceIdentityResponse',
    'ParameterDefinitionResponse',
    'ParameterValueBaseResponse',
    'ResourceGroupDefinitionResponse',
    'ResourceGroupValueResponse',
]

@pulumi.output_type
class AssignmentLockSettingsResponse(dict):
    """
    Defines how Blueprint-managed resources will be locked.
    """
    def __init__(__self__, *,
                 mode: Optional[str] = None):
        """
        Defines how Blueprint-managed resources will be locked.
        :param str mode: Lock mode.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Lock mode.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class AssignmentStatusResponse(dict):
    """
    The status of Blueprint assignment. This field is readonly.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastModified":
            suggest = "last_modified"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssignmentStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssignmentStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssignmentStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_modified: str,
                 time_created: str):
        """
        The status of Blueprint assignment. This field is readonly.
        :param str last_modified: Last modified time of this blueprint.
        :param str time_created: Creation time of this blueprint.
        """
        pulumi.set(__self__, "last_modified", last_modified)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> str:
        """
        Last modified time of this blueprint.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Creation time of this blueprint.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class BlueprintStatusResponse(dict):
    """
    The status of the blueprint. This field is readonly.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastModified":
            suggest = "last_modified"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlueprintStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlueprintStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlueprintStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_modified: str,
                 time_created: str):
        """
        The status of the blueprint. This field is readonly.
        :param str last_modified: Last modified time of this blueprint.
        :param str time_created: Creation time of this blueprint.
        """
        pulumi.set(__self__, "last_modified", last_modified)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> str:
        """
        Last modified time of this blueprint.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Creation time of this blueprint.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class ManagedServiceIdentityResponse(dict):
    """
    Managed Service Identity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedServiceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedServiceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedServiceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 principal_id: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Managed Service Identity
        :param str type: Type of the Managed Service Identity.
        :param str principal_id: Azure Active Directory principal ID associated with this Identity.
        :param str tenant_id: ID of the Azure Active Directory.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the Managed Service Identity.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[str]:
        """
        Azure Active Directory principal ID associated with this Identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        ID of the Azure Active Directory.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ParameterDefinitionResponse(dict):
    """
    Represent a parameter with constrains and metadata.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedValues":
            suggest = "allowed_values"
        elif key == "defaultValue":
            suggest = "default_value"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "strongType":
            suggest = "strong_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParameterDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParameterDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParameterDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 allowed_values: Optional[Sequence[Any]] = None,
                 default_value: Optional[Any] = None,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None,
                 strong_type: Optional[str] = None):
        """
        Represent a parameter with constrains and metadata.
        :param str type: Allowed data types for Azure Resource Manager template parameters.
        :param Sequence[Any] allowed_values: Array of allowed values for this parameter.
        :param Any default_value: Default Value for this parameter.
        :param str description: Description of this parameter/resourceGroup.
        :param str display_name: DisplayName of this parameter/resourceGroup.
        :param str strong_type: StrongType for UI to render rich experience during assignment time.
        """
        pulumi.set(__self__, "type", type)
        if allowed_values is not None:
            pulumi.set(__self__, "allowed_values", allowed_values)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if strong_type is not None:
            pulumi.set(__self__, "strong_type", strong_type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Allowed data types for Azure Resource Manager template parameters.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Optional[Sequence[Any]]:
        """
        Array of allowed values for this parameter.
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[Any]:
        """
        Default Value for this parameter.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of this parameter/resourceGroup.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        DisplayName of this parameter/resourceGroup.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="strongType")
    def strong_type(self) -> Optional[str]:
        """
        StrongType for UI to render rich experience during assignment time.
        """
        return pulumi.get(self, "strong_type")


@pulumi.output_type
class ParameterValueBaseResponse(dict):
    """
    Base class for ParameterValue.
    """
    def __init__(__self__, *,
                 description: Optional[str] = None):
        """
        Base class for ParameterValue.
        :param str description: Optional property, just to establish ParameterValueBase as a BaseClass.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Optional property, just to establish ParameterValueBase as a BaseClass.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ResourceGroupDefinitionResponse(dict):
    """
    Represents an Azure resource group in a Blueprint definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOn":
            suggest = "depends_on"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "strongType":
            suggest = "strong_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceGroupDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceGroupDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceGroupDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 depends_on: Optional[Sequence[str]] = None,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None,
                 location: Optional[str] = None,
                 name: Optional[str] = None,
                 strong_type: Optional[str] = None):
        """
        Represents an Azure resource group in a Blueprint definition.
        :param Sequence[str] depends_on: Artifacts which need to be deployed before this resource group.
        :param str description: Description of this parameter/resourceGroup.
        :param str display_name: DisplayName of this parameter/resourceGroup.
        :param str location: Location of this resourceGroup, leave empty if the resource group location will be specified during the Blueprint assignment.
        :param str name: Name of this resourceGroup, leave empty if the resource group name will be specified during the Blueprint assignment.
        :param str strong_type: StrongType for UI to render rich experience during assignment time.
        """
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if strong_type is not None:
            pulumi.set(__self__, "strong_type", strong_type)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence[str]]:
        """
        Artifacts which need to be deployed before this resource group.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of this parameter/resourceGroup.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        DisplayName of this parameter/resourceGroup.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Location of this resourceGroup, leave empty if the resource group location will be specified during the Blueprint assignment.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of this resourceGroup, leave empty if the resource group name will be specified during the Blueprint assignment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="strongType")
    def strong_type(self) -> Optional[str]:
        """
        StrongType for UI to render rich experience during assignment time.
        """
        return pulumi.get(self, "strong_type")


@pulumi.output_type
class ResourceGroupValueResponse(dict):
    """
    Represents an Azure resource group.
    """
    def __init__(__self__, *,
                 location: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Represents an Azure resource group.
        :param str location: Location of the resource group
        :param str name: Name of the resource group
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Location of the resource group
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource group
        """
        return pulumi.get(self, "name")


