# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ActiveDirectoryPropertiesArgs',
    'AzureFilesIdentityBasedAuthenticationArgs',
    'BlobInventoryPolicyDefinitionArgs',
    'BlobInventoryPolicyFilterArgs',
    'BlobInventoryPolicyRuleArgs',
    'BlobInventoryPolicySchemaArgs',
    'ChangeFeedArgs',
    'CorsRulesArgs',
    'CorsRuleArgs',
    'CustomDomainArgs',
    'DateAfterCreationArgs',
    'DateAfterModificationArgs',
    'DeleteRetentionPolicyArgs',
    'EncryptionIdentityArgs',
    'EncryptionScopeKeyVaultPropertiesArgs',
    'EncryptionServicesArgs',
    'EncryptionServiceArgs',
    'EncryptionArgs',
    'ExtendedLocationArgs',
    'IPRuleArgs',
    'IdentityArgs',
    'KeyVaultPropertiesArgs',
    'LastAccessTimeTrackingPolicyArgs',
    'ManagementPolicyActionArgs',
    'ManagementPolicyBaseBlobArgs',
    'ManagementPolicyDefinitionArgs',
    'ManagementPolicyFilterArgs',
    'ManagementPolicyRuleArgs',
    'ManagementPolicySchemaArgs',
    'ManagementPolicySnapShotArgs',
    'ManagementPolicyVersionArgs',
    'MultichannelArgs',
    'NetworkRuleSetArgs',
    'ObjectReplicationPolicyFilterArgs',
    'ObjectReplicationPolicyRuleArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'ProtocolSettingsArgs',
    'ResourceAccessRuleArgs',
    'RestorePolicyPropertiesArgs',
    'RoutingPreferenceArgs',
    'SkuArgs',
    'SmbSettingArgs',
    'TagFilterArgs',
    'VirtualNetworkRuleArgs',
]

@pulumi.input_type
class ActiveDirectoryPropertiesArgs:
    def __init__(__self__, *,
                 azure_storage_sid: pulumi.Input[str],
                 domain_guid: pulumi.Input[str],
                 domain_name: pulumi.Input[str],
                 domain_sid: pulumi.Input[str],
                 forest_name: pulumi.Input[str],
                 net_bios_domain_name: pulumi.Input[str]):
        """
        Settings properties for Active Directory (AD).
        :param pulumi.Input[str] azure_storage_sid: Specifies the security identifier (SID) for Azure Storage.
        :param pulumi.Input[str] domain_guid: Specifies the domain GUID.
        :param pulumi.Input[str] domain_name: Specifies the primary domain that the AD DNS server is authoritative for.
        :param pulumi.Input[str] domain_sid: Specifies the security identifier (SID).
        :param pulumi.Input[str] forest_name: Specifies the Active Directory forest to get.
        :param pulumi.Input[str] net_bios_domain_name: Specifies the NetBIOS domain name.
        """
        pulumi.set(__self__, "azure_storage_sid", azure_storage_sid)
        pulumi.set(__self__, "domain_guid", domain_guid)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "domain_sid", domain_sid)
        pulumi.set(__self__, "forest_name", forest_name)
        pulumi.set(__self__, "net_bios_domain_name", net_bios_domain_name)

    @property
    @pulumi.getter(name="azureStorageSid")
    def azure_storage_sid(self) -> pulumi.Input[str]:
        """
        Specifies the security identifier (SID) for Azure Storage.
        """
        return pulumi.get(self, "azure_storage_sid")

    @azure_storage_sid.setter
    def azure_storage_sid(self, value: pulumi.Input[str]):
        pulumi.set(self, "azure_storage_sid", value)

    @property
    @pulumi.getter(name="domainGuid")
    def domain_guid(self) -> pulumi.Input[str]:
        """
        Specifies the domain GUID.
        """
        return pulumi.get(self, "domain_guid")

    @domain_guid.setter
    def domain_guid(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_guid", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        Specifies the primary domain that the AD DNS server is authoritative for.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="domainSid")
    def domain_sid(self) -> pulumi.Input[str]:
        """
        Specifies the security identifier (SID).
        """
        return pulumi.get(self, "domain_sid")

    @domain_sid.setter
    def domain_sid(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_sid", value)

    @property
    @pulumi.getter(name="forestName")
    def forest_name(self) -> pulumi.Input[str]:
        """
        Specifies the Active Directory forest to get.
        """
        return pulumi.get(self, "forest_name")

    @forest_name.setter
    def forest_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "forest_name", value)

    @property
    @pulumi.getter(name="netBiosDomainName")
    def net_bios_domain_name(self) -> pulumi.Input[str]:
        """
        Specifies the NetBIOS domain name.
        """
        return pulumi.get(self, "net_bios_domain_name")

    @net_bios_domain_name.setter
    def net_bios_domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "net_bios_domain_name", value)


@pulumi.input_type
class AzureFilesIdentityBasedAuthenticationArgs:
    def __init__(__self__, *,
                 directory_service_options: pulumi.Input[Union[str, 'DirectoryServiceOptions']],
                 active_directory_properties: Optional[pulumi.Input['ActiveDirectoryPropertiesArgs']] = None):
        """
        Settings for Azure Files identity based authentication.
        :param pulumi.Input[Union[str, 'DirectoryServiceOptions']] directory_service_options: Indicates the directory service used.
        :param pulumi.Input['ActiveDirectoryPropertiesArgs'] active_directory_properties: Required if choose AD.
        """
        pulumi.set(__self__, "directory_service_options", directory_service_options)
        if active_directory_properties is not None:
            pulumi.set(__self__, "active_directory_properties", active_directory_properties)

    @property
    @pulumi.getter(name="directoryServiceOptions")
    def directory_service_options(self) -> pulumi.Input[Union[str, 'DirectoryServiceOptions']]:
        """
        Indicates the directory service used.
        """
        return pulumi.get(self, "directory_service_options")

    @directory_service_options.setter
    def directory_service_options(self, value: pulumi.Input[Union[str, 'DirectoryServiceOptions']]):
        pulumi.set(self, "directory_service_options", value)

    @property
    @pulumi.getter(name="activeDirectoryProperties")
    def active_directory_properties(self) -> Optional[pulumi.Input['ActiveDirectoryPropertiesArgs']]:
        """
        Required if choose AD.
        """
        return pulumi.get(self, "active_directory_properties")

    @active_directory_properties.setter
    def active_directory_properties(self, value: Optional[pulumi.Input['ActiveDirectoryPropertiesArgs']]):
        pulumi.set(self, "active_directory_properties", value)


@pulumi.input_type
class BlobInventoryPolicyDefinitionArgs:
    def __init__(__self__, *,
                 filters: pulumi.Input['BlobInventoryPolicyFilterArgs']):
        """
        An object that defines the blob inventory rule. Each definition consists of a set of filters.
        :param pulumi.Input['BlobInventoryPolicyFilterArgs'] filters: An object that defines the filter set.
        """
        pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def filters(self) -> pulumi.Input['BlobInventoryPolicyFilterArgs']:
        """
        An object that defines the filter set.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: pulumi.Input['BlobInventoryPolicyFilterArgs']):
        pulumi.set(self, "filters", value)


@pulumi.input_type
class BlobInventoryPolicyFilterArgs:
    def __init__(__self__, *,
                 blob_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 include_blob_versions: Optional[pulumi.Input[bool]] = None,
                 include_snapshots: Optional[pulumi.Input[bool]] = None,
                 prefix_match: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        An object that defines the blob inventory rule filter conditions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blob_types: An array of predefined enum values. Valid values include blockBlob, appendBlob, pageBlob. Hns accounts does not support pageBlobs.
        :param pulumi.Input[bool] include_blob_versions: Includes blob versions in blob inventory when value set to true.
        :param pulumi.Input[bool] include_snapshots: Includes blob snapshots in blob inventory when value set to true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prefix_match: An array of strings for blob prefixes to be matched.
        """
        pulumi.set(__self__, "blob_types", blob_types)
        if include_blob_versions is not None:
            pulumi.set(__self__, "include_blob_versions", include_blob_versions)
        if include_snapshots is not None:
            pulumi.set(__self__, "include_snapshots", include_snapshots)
        if prefix_match is not None:
            pulumi.set(__self__, "prefix_match", prefix_match)

    @property
    @pulumi.getter(name="blobTypes")
    def blob_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        An array of predefined enum values. Valid values include blockBlob, appendBlob, pageBlob. Hns accounts does not support pageBlobs.
        """
        return pulumi.get(self, "blob_types")

    @blob_types.setter
    def blob_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "blob_types", value)

    @property
    @pulumi.getter(name="includeBlobVersions")
    def include_blob_versions(self) -> Optional[pulumi.Input[bool]]:
        """
        Includes blob versions in blob inventory when value set to true.
        """
        return pulumi.get(self, "include_blob_versions")

    @include_blob_versions.setter
    def include_blob_versions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_blob_versions", value)

    @property
    @pulumi.getter(name="includeSnapshots")
    def include_snapshots(self) -> Optional[pulumi.Input[bool]]:
        """
        Includes blob snapshots in blob inventory when value set to true.
        """
        return pulumi.get(self, "include_snapshots")

    @include_snapshots.setter
    def include_snapshots(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_snapshots", value)

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of strings for blob prefixes to be matched.
        """
        return pulumi.get(self, "prefix_match")

    @prefix_match.setter
    def prefix_match(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prefix_match", value)


@pulumi.input_type
class BlobInventoryPolicyRuleArgs:
    def __init__(__self__, *,
                 definition: pulumi.Input['BlobInventoryPolicyDefinitionArgs'],
                 enabled: pulumi.Input[bool],
                 name: pulumi.Input[str]):
        """
        An object that wraps the blob inventory rule. Each rule is uniquely defined by name.
        :param pulumi.Input['BlobInventoryPolicyDefinitionArgs'] definition: An object that defines the blob inventory policy rule.
        :param pulumi.Input[bool] enabled: Rule is enabled when set to true.
        :param pulumi.Input[str] name: A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
        """
        pulumi.set(__self__, "definition", definition)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def definition(self) -> pulumi.Input['BlobInventoryPolicyDefinitionArgs']:
        """
        An object that defines the blob inventory policy rule.
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: pulumi.Input['BlobInventoryPolicyDefinitionArgs']):
        pulumi.set(self, "definition", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Rule is enabled when set to true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class BlobInventoryPolicySchemaArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input[str],
                 enabled: pulumi.Input[bool],
                 rules: pulumi.Input[Sequence[pulumi.Input['BlobInventoryPolicyRuleArgs']]],
                 type: pulumi.Input[Union[str, 'InventoryRuleType']]):
        """
        The storage account blob inventory policy rules.
        :param pulumi.Input[str] destination: Container name where blob inventory files are stored. Must be pre-created.
        :param pulumi.Input[bool] enabled: Policy is enabled if set to true.
        :param pulumi.Input[Sequence[pulumi.Input['BlobInventoryPolicyRuleArgs']]] rules: The storage account blob inventory policy rules. The rule is applied when it is enabled.
        :param pulumi.Input[Union[str, 'InventoryRuleType']] type: The valid value is Inventory
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input[str]:
        """
        Container name where blob inventory files are stored. Must be pre-created.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Policy is enabled if set to true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['BlobInventoryPolicyRuleArgs']]]:
        """
        The storage account blob inventory policy rules. The rule is applied when it is enabled.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['BlobInventoryPolicyRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'InventoryRuleType']]:
        """
        The valid value is Inventory
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'InventoryRuleType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ChangeFeedArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 retention_in_days: Optional[pulumi.Input[int]] = None):
        """
        The blob service properties for change feed events.
        :param pulumi.Input[bool] enabled: Indicates whether change feed event logging is enabled for the Blob service.
        :param pulumi.Input[int] retention_in_days: Indicates the duration of changeFeed retention in days. Minimum value is 1 day and maximum value is 146000 days (400 years). A null value indicates an infinite retention of the change feed.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether change feed event logging is enabled for the Blob service.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the duration of changeFeed retention in days. Minimum value is 1 day and maximum value is 146000 days (400 years). A null value indicates an infinite retention of the change feed.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_in_days", value)


@pulumi.input_type
class CorsRulesArgs:
    def __init__(__self__, *,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CorsRuleArgs']]]] = None):
        """
        Sets the CORS rules. You can include up to five CorsRule elements in the request. 
        :param pulumi.Input[Sequence[pulumi.Input['CorsRuleArgs']]] cors_rules: The List of CORS rules. You can include up to five CorsRule elements in the request. 
        """
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)

    @property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CorsRuleArgs']]]]:
        """
        The List of CORS rules. You can include up to five CorsRule elements in the request. 
        """
        return pulumi.get(self, "cors_rules")

    @cors_rules.setter
    def cors_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CorsRuleArgs']]]]):
        pulumi.set(self, "cors_rules", value)


@pulumi.input_type
class CorsRuleArgs:
    def __init__(__self__, *,
                 allowed_headers: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allowed_methods: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allowed_origins: pulumi.Input[Sequence[pulumi.Input[str]]],
                 exposed_headers: pulumi.Input[Sequence[pulumi.Input[str]]],
                 max_age_in_seconds: pulumi.Input[int]):
        """
        Specifies a CORS rule for the Blob service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_headers: Required if CorsRule element is present. A list of headers allowed to be part of the cross-origin request.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_methods: Required if CorsRule element is present. A list of HTTP methods that are allowed to be executed by the origin.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: Required if CorsRule element is present. A list of origin domains that will be allowed via CORS, or "*" to allow all domains
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exposed_headers: Required if CorsRule element is present. A list of response headers to expose to CORS clients.
        :param pulumi.Input[int] max_age_in_seconds: Required if CorsRule element is present. The number of seconds that the client/browser should cache a preflight response.
        """
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "exposed_headers", exposed_headers)
        pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Required if CorsRule element is present. A list of headers allowed to be part of the cross-origin request.
        """
        return pulumi.get(self, "allowed_headers")

    @allowed_headers.setter
    def allowed_headers(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_headers", value)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Required if CorsRule element is present. A list of HTTP methods that are allowed to be executed by the origin.
        """
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_methods", value)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Required if CorsRule element is present. A list of origin domains that will be allowed via CORS, or "*" to allow all domains
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="exposedHeaders")
    def exposed_headers(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Required if CorsRule element is present. A list of response headers to expose to CORS clients.
        """
        return pulumi.get(self, "exposed_headers")

    @exposed_headers.setter
    def exposed_headers(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "exposed_headers", value)

    @property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> pulumi.Input[int]:
        """
        Required if CorsRule element is present. The number of seconds that the client/browser should cache a preflight response.
        """
        return pulumi.get(self, "max_age_in_seconds")

    @max_age_in_seconds.setter
    def max_age_in_seconds(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_age_in_seconds", value)


@pulumi.input_type
class CustomDomainArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 use_sub_domain_name: Optional[pulumi.Input[bool]] = None):
        """
        The custom domain assigned to this storage account. This can be set via Update.
        :param pulumi.Input[str] name: Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
        :param pulumi.Input[bool] use_sub_domain_name: Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
        """
        pulumi.set(__self__, "name", name)
        if use_sub_domain_name is not None:
            pulumi.set(__self__, "use_sub_domain_name", use_sub_domain_name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="useSubDomainName")
    def use_sub_domain_name(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
        """
        return pulumi.get(self, "use_sub_domain_name")

    @use_sub_domain_name.setter
    def use_sub_domain_name(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_sub_domain_name", value)


@pulumi.input_type
class DateAfterCreationArgs:
    def __init__(__self__, *,
                 days_after_creation_greater_than: pulumi.Input[float]):
        """
        Object to define the number of days after creation.
        :param pulumi.Input[float] days_after_creation_greater_than: Value indicating the age in days after creation
        """
        pulumi.set(__self__, "days_after_creation_greater_than", days_after_creation_greater_than)

    @property
    @pulumi.getter(name="daysAfterCreationGreaterThan")
    def days_after_creation_greater_than(self) -> pulumi.Input[float]:
        """
        Value indicating the age in days after creation
        """
        return pulumi.get(self, "days_after_creation_greater_than")

    @days_after_creation_greater_than.setter
    def days_after_creation_greater_than(self, value: pulumi.Input[float]):
        pulumi.set(self, "days_after_creation_greater_than", value)


@pulumi.input_type
class DateAfterModificationArgs:
    def __init__(__self__, *,
                 days_after_last_access_time_greater_than: Optional[pulumi.Input[float]] = None,
                 days_after_modification_greater_than: Optional[pulumi.Input[float]] = None):
        """
        Object to define the number of days after object last modification Or last access. Properties daysAfterModificationGreaterThan and daysAfterLastAccessTimeGreaterThan are mutually exclusive.
        :param pulumi.Input[float] days_after_last_access_time_greater_than: Value indicating the age in days after last blob access. This property can only be used in conjunction with last access time tracking policy
        :param pulumi.Input[float] days_after_modification_greater_than: Value indicating the age in days after last modification
        """
        if days_after_last_access_time_greater_than is not None:
            pulumi.set(__self__, "days_after_last_access_time_greater_than", days_after_last_access_time_greater_than)
        if days_after_modification_greater_than is not None:
            pulumi.set(__self__, "days_after_modification_greater_than", days_after_modification_greater_than)

    @property
    @pulumi.getter(name="daysAfterLastAccessTimeGreaterThan")
    def days_after_last_access_time_greater_than(self) -> Optional[pulumi.Input[float]]:
        """
        Value indicating the age in days after last blob access. This property can only be used in conjunction with last access time tracking policy
        """
        return pulumi.get(self, "days_after_last_access_time_greater_than")

    @days_after_last_access_time_greater_than.setter
    def days_after_last_access_time_greater_than(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "days_after_last_access_time_greater_than", value)

    @property
    @pulumi.getter(name="daysAfterModificationGreaterThan")
    def days_after_modification_greater_than(self) -> Optional[pulumi.Input[float]]:
        """
        Value indicating the age in days after last modification
        """
        return pulumi.get(self, "days_after_modification_greater_than")

    @days_after_modification_greater_than.setter
    def days_after_modification_greater_than(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "days_after_modification_greater_than", value)


@pulumi.input_type
class DeleteRetentionPolicyArgs:
    def __init__(__self__, *,
                 days: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        The service properties for soft delete.
        :param pulumi.Input[int] days: Indicates the number of days that the deleted item should be retained. The minimum specified value can be 1 and the maximum value can be 365.
        :param pulumi.Input[bool] enabled: Indicates whether DeleteRetentionPolicy is enabled.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the number of days that the deleted item should be retained. The minimum specified value can be 1 and the maximum value can be 365.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether DeleteRetentionPolicy is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class EncryptionIdentityArgs:
    def __init__(__self__, *,
                 encryption_user_assigned_identity: Optional[pulumi.Input[str]] = None):
        """
        Encryption identity for the storage account.
        :param pulumi.Input[str] encryption_user_assigned_identity: Resource identifier of the UserAssigned identity to be associated with server-side encryption on the storage account.
        """
        if encryption_user_assigned_identity is not None:
            pulumi.set(__self__, "encryption_user_assigned_identity", encryption_user_assigned_identity)

    @property
    @pulumi.getter(name="encryptionUserAssignedIdentity")
    def encryption_user_assigned_identity(self) -> Optional[pulumi.Input[str]]:
        """
        Resource identifier of the UserAssigned identity to be associated with server-side encryption on the storage account.
        """
        return pulumi.get(self, "encryption_user_assigned_identity")

    @encryption_user_assigned_identity.setter
    def encryption_user_assigned_identity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_user_assigned_identity", value)


@pulumi.input_type
class EncryptionScopeKeyVaultPropertiesArgs:
    def __init__(__self__, *,
                 key_uri: Optional[pulumi.Input[str]] = None):
        """
        The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
        :param pulumi.Input[str] key_uri: The object identifier for a key vault key object. When applied, the encryption scope will use the key referenced by the identifier to enable customer-managed key support on this encryption scope.
        """
        if key_uri is not None:
            pulumi.set(__self__, "key_uri", key_uri)

    @property
    @pulumi.getter(name="keyUri")
    def key_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The object identifier for a key vault key object. When applied, the encryption scope will use the key referenced by the identifier to enable customer-managed key support on this encryption scope.
        """
        return pulumi.get(self, "key_uri")

    @key_uri.setter
    def key_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_uri", value)


@pulumi.input_type
class EncryptionServicesArgs:
    def __init__(__self__, *,
                 blob: Optional[pulumi.Input['EncryptionServiceArgs']] = None,
                 file: Optional[pulumi.Input['EncryptionServiceArgs']] = None,
                 queue: Optional[pulumi.Input['EncryptionServiceArgs']] = None,
                 table: Optional[pulumi.Input['EncryptionServiceArgs']] = None):
        """
        A list of services that support encryption.
        :param pulumi.Input['EncryptionServiceArgs'] blob: The encryption function of the blob storage service.
        :param pulumi.Input['EncryptionServiceArgs'] file: The encryption function of the file storage service.
        :param pulumi.Input['EncryptionServiceArgs'] queue: The encryption function of the queue storage service.
        :param pulumi.Input['EncryptionServiceArgs'] table: The encryption function of the table storage service.
        """
        if blob is not None:
            pulumi.set(__self__, "blob", blob)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if queue is not None:
            pulumi.set(__self__, "queue", queue)
        if table is not None:
            pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter
    def blob(self) -> Optional[pulumi.Input['EncryptionServiceArgs']]:
        """
        The encryption function of the blob storage service.
        """
        return pulumi.get(self, "blob")

    @blob.setter
    def blob(self, value: Optional[pulumi.Input['EncryptionServiceArgs']]):
        pulumi.set(self, "blob", value)

    @property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input['EncryptionServiceArgs']]:
        """
        The encryption function of the file storage service.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input['EncryptionServiceArgs']]):
        pulumi.set(self, "file", value)

    @property
    @pulumi.getter
    def queue(self) -> Optional[pulumi.Input['EncryptionServiceArgs']]:
        """
        The encryption function of the queue storage service.
        """
        return pulumi.get(self, "queue")

    @queue.setter
    def queue(self, value: Optional[pulumi.Input['EncryptionServiceArgs']]):
        pulumi.set(self, "queue", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input['EncryptionServiceArgs']]:
        """
        The encryption function of the table storage service.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input['EncryptionServiceArgs']]):
        pulumi.set(self, "table", value)


@pulumi.input_type
class EncryptionServiceArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 key_type: Optional[pulumi.Input[Union[str, 'KeyType']]] = None):
        """
        A service that allows server-side encryption to be used.
        :param pulumi.Input[bool] enabled: A boolean indicating whether or not the service encrypts the data as it is stored.
        :param pulumi.Input[Union[str, 'KeyType']] key_type: Encryption key type to be used for the encryption service. 'Account' key type implies that an account-scoped encryption key will be used. 'Service' key type implies that a default service key is used.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether or not the service encrypts the data as it is stored.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[Union[str, 'KeyType']]]:
        """
        Encryption key type to be used for the encryption service. 'Account' key type implies that an account-scoped encryption key will be used. 'Service' key type implies that a default service key is used.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[Union[str, 'KeyType']]]):
        pulumi.set(self, "key_type", value)


@pulumi.input_type
class EncryptionArgs:
    def __init__(__self__, *,
                 key_source: pulumi.Input[Union[str, 'KeySource']],
                 encryption_identity: Optional[pulumi.Input['EncryptionIdentityArgs']] = None,
                 key_vault_properties: Optional[pulumi.Input['KeyVaultPropertiesArgs']] = None,
                 require_infrastructure_encryption: Optional[pulumi.Input[bool]] = None,
                 services: Optional[pulumi.Input['EncryptionServicesArgs']] = None):
        """
        The encryption settings on the storage account.
        :param pulumi.Input[Union[str, 'KeySource']] key_source: The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault
        :param pulumi.Input['EncryptionIdentityArgs'] encryption_identity: The identity to be used with service-side encryption at rest.
        :param pulumi.Input['KeyVaultPropertiesArgs'] key_vault_properties: Properties provided by key vault.
        :param pulumi.Input[bool] require_infrastructure_encryption: A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for data at rest.
        :param pulumi.Input['EncryptionServicesArgs'] services: List of services which support encryption.
        """
        if key_source is None:
            key_source = 'Microsoft.Storage'
        pulumi.set(__self__, "key_source", key_source)
        if encryption_identity is not None:
            pulumi.set(__self__, "encryption_identity", encryption_identity)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)
        if require_infrastructure_encryption is not None:
            pulumi.set(__self__, "require_infrastructure_encryption", require_infrastructure_encryption)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter(name="keySource")
    def key_source(self) -> pulumi.Input[Union[str, 'KeySource']]:
        """
        The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault
        """
        return pulumi.get(self, "key_source")

    @key_source.setter
    def key_source(self, value: pulumi.Input[Union[str, 'KeySource']]):
        pulumi.set(self, "key_source", value)

    @property
    @pulumi.getter(name="encryptionIdentity")
    def encryption_identity(self) -> Optional[pulumi.Input['EncryptionIdentityArgs']]:
        """
        The identity to be used with service-side encryption at rest.
        """
        return pulumi.get(self, "encryption_identity")

    @encryption_identity.setter
    def encryption_identity(self, value: Optional[pulumi.Input['EncryptionIdentityArgs']]):
        pulumi.set(self, "encryption_identity", value)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional[pulumi.Input['KeyVaultPropertiesArgs']]:
        """
        Properties provided by key vault.
        """
        return pulumi.get(self, "key_vault_properties")

    @key_vault_properties.setter
    def key_vault_properties(self, value: Optional[pulumi.Input['KeyVaultPropertiesArgs']]):
        pulumi.set(self, "key_vault_properties", value)

    @property
    @pulumi.getter(name="requireInfrastructureEncryption")
    def require_infrastructure_encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for data at rest.
        """
        return pulumi.get(self, "require_infrastructure_encryption")

    @require_infrastructure_encryption.setter
    def require_infrastructure_encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_infrastructure_encryption", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input['EncryptionServicesArgs']]:
        """
        List of services which support encryption.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input['EncryptionServicesArgs']]):
        pulumi.set(self, "services", value)


@pulumi.input_type
class ExtendedLocationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]] = None):
        """
        The complex type of the extended location.
        :param pulumi.Input[str] name: The name of the extended location.
        :param pulumi.Input[Union[str, 'ExtendedLocationTypes']] type: The type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]]:
        """
        The type of the extended location.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class IPRuleArgs:
    def __init__(__self__, *,
                 i_p_address_or_range: pulumi.Input[str],
                 action: Optional[pulumi.Input['Action']] = None):
        """
        IP rule with specific IP or IP range in CIDR format.
        :param pulumi.Input[str] i_p_address_or_range: Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
        :param pulumi.Input['Action'] action: The action of IP ACL rule.
        """
        pulumi.set(__self__, "i_p_address_or_range", i_p_address_or_range)
        if action is None:
            action = 'Allow'
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="iPAddressOrRange")
    def i_p_address_or_range(self) -> pulumi.Input[str]:
        """
        Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
        """
        return pulumi.get(self, "i_p_address_or_range")

    @i_p_address_or_range.setter
    def i_p_address_or_range(self, value: pulumi.Input[str]):
        pulumi.set(self, "i_p_address_or_range", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['Action']]:
        """
        The action of IP ACL rule.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['Action']]):
        pulumi.set(self, "action", value)


@pulumi.input_type
class IdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'IdentityType']],
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Identity for the resource.
        :param pulumi.Input[Union[str, 'IdentityType']] type: The identity type.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: Gets or sets a list of key value pairs that describe the set of User Assigned identities that will be used with this storage account. The key is the ARM resource identifier of the identity. Only 1 User Assigned identity is permitted here.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'IdentityType']]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'IdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Gets or sets a list of key value pairs that describe the set of User Assigned identities that will be used with this storage account. The key is the ARM resource identifier of the identity. Only 1 User Assigned identity is permitted here.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class KeyVaultPropertiesArgs:
    def __init__(__self__, *,
                 key_name: Optional[pulumi.Input[str]] = None,
                 key_vault_uri: Optional[pulumi.Input[str]] = None,
                 key_version: Optional[pulumi.Input[str]] = None):
        """
        Properties of key vault.
        :param pulumi.Input[str] key_name: The name of KeyVault key.
        :param pulumi.Input[str] key_vault_uri: The Uri of KeyVault.
        :param pulumi.Input[str] key_version: The version of KeyVault key.
        """
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_vault_uri is not None:
            pulumi.set(__self__, "key_vault_uri", key_vault_uri)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of KeyVault key.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Uri of KeyVault.
        """
        return pulumi.get(self, "key_vault_uri")

    @key_vault_uri.setter
    def key_vault_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_uri", value)

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of KeyVault key.
        """
        return pulumi.get(self, "key_version")

    @key_version.setter
    def key_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_version", value)


@pulumi.input_type
class LastAccessTimeTrackingPolicyArgs:
    def __init__(__self__, *,
                 enable: pulumi.Input[bool],
                 blob_type: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[Union[str, 'Name']]] = None,
                 tracking_granularity_in_days: Optional[pulumi.Input[int]] = None):
        """
        The blob service properties for Last access time based tracking policy.
        :param pulumi.Input[bool] enable: When set to true last access time based tracking is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blob_type: An array of predefined supported blob types. Only blockBlob is the supported value. This field is currently read only
        :param pulumi.Input[Union[str, 'Name']] name: Name of the policy. The valid value is AccessTimeTracking. This field is currently read only
        :param pulumi.Input[int] tracking_granularity_in_days: The field specifies blob object tracking granularity in days, typically how often the blob object should be tracked.This field is currently read only with value as 1
        """
        pulumi.set(__self__, "enable", enable)
        if blob_type is not None:
            pulumi.set(__self__, "blob_type", blob_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tracking_granularity_in_days is not None:
            pulumi.set(__self__, "tracking_granularity_in_days", tracking_granularity_in_days)

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Input[bool]:
        """
        When set to true last access time based tracking is enabled.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="blobType")
    def blob_type(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of predefined supported blob types. Only blockBlob is the supported value. This field is currently read only
        """
        return pulumi.get(self, "blob_type")

    @blob_type.setter
    def blob_type(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blob_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'Name']]]:
        """
        Name of the policy. The valid value is AccessTimeTracking. This field is currently read only
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'Name']]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="trackingGranularityInDays")
    def tracking_granularity_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        The field specifies blob object tracking granularity in days, typically how often the blob object should be tracked.This field is currently read only with value as 1
        """
        return pulumi.get(self, "tracking_granularity_in_days")

    @tracking_granularity_in_days.setter
    def tracking_granularity_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tracking_granularity_in_days", value)


@pulumi.input_type
class ManagementPolicyActionArgs:
    def __init__(__self__, *,
                 base_blob: Optional[pulumi.Input['ManagementPolicyBaseBlobArgs']] = None,
                 snapshot: Optional[pulumi.Input['ManagementPolicySnapShotArgs']] = None,
                 version: Optional[pulumi.Input['ManagementPolicyVersionArgs']] = None):
        """
        Actions are applied to the filtered blobs when the execution condition is met.
        :param pulumi.Input['ManagementPolicyBaseBlobArgs'] base_blob: The management policy action for base blob
        :param pulumi.Input['ManagementPolicySnapShotArgs'] snapshot: The management policy action for snapshot
        :param pulumi.Input['ManagementPolicyVersionArgs'] version: The management policy action for version
        """
        if base_blob is not None:
            pulumi.set(__self__, "base_blob", base_blob)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="baseBlob")
    def base_blob(self) -> Optional[pulumi.Input['ManagementPolicyBaseBlobArgs']]:
        """
        The management policy action for base blob
        """
        return pulumi.get(self, "base_blob")

    @base_blob.setter
    def base_blob(self, value: Optional[pulumi.Input['ManagementPolicyBaseBlobArgs']]):
        pulumi.set(self, "base_blob", value)

    @property
    @pulumi.getter
    def snapshot(self) -> Optional[pulumi.Input['ManagementPolicySnapShotArgs']]:
        """
        The management policy action for snapshot
        """
        return pulumi.get(self, "snapshot")

    @snapshot.setter
    def snapshot(self, value: Optional[pulumi.Input['ManagementPolicySnapShotArgs']]):
        pulumi.set(self, "snapshot", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input['ManagementPolicyVersionArgs']]:
        """
        The management policy action for version
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input['ManagementPolicyVersionArgs']]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ManagementPolicyBaseBlobArgs:
    def __init__(__self__, *,
                 delete: Optional[pulumi.Input['DateAfterModificationArgs']] = None,
                 enable_auto_tier_to_hot_from_cool: Optional[pulumi.Input[bool]] = None,
                 tier_to_archive: Optional[pulumi.Input['DateAfterModificationArgs']] = None,
                 tier_to_cool: Optional[pulumi.Input['DateAfterModificationArgs']] = None):
        """
        Management policy action for base blob.
        :param pulumi.Input['DateAfterModificationArgs'] delete: The function to delete the blob
        :param pulumi.Input[bool] enable_auto_tier_to_hot_from_cool: This property enables auto tiering of a blob from cool to hot on a blob access. This property requires tierToCool.daysAfterLastAccessTimeGreaterThan.
        :param pulumi.Input['DateAfterModificationArgs'] tier_to_archive: The function to tier blobs to archive storage. Support blobs currently at Hot or Cool tier
        :param pulumi.Input['DateAfterModificationArgs'] tier_to_cool: The function to tier blobs to cool storage. Support blobs currently at Hot tier
        """
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if enable_auto_tier_to_hot_from_cool is not None:
            pulumi.set(__self__, "enable_auto_tier_to_hot_from_cool", enable_auto_tier_to_hot_from_cool)
        if tier_to_archive is not None:
            pulumi.set(__self__, "tier_to_archive", tier_to_archive)
        if tier_to_cool is not None:
            pulumi.set(__self__, "tier_to_cool", tier_to_cool)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input['DateAfterModificationArgs']]:
        """
        The function to delete the blob
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input['DateAfterModificationArgs']]):
        pulumi.set(self, "delete", value)

    @property
    @pulumi.getter(name="enableAutoTierToHotFromCool")
    def enable_auto_tier_to_hot_from_cool(self) -> Optional[pulumi.Input[bool]]:
        """
        This property enables auto tiering of a blob from cool to hot on a blob access. This property requires tierToCool.daysAfterLastAccessTimeGreaterThan.
        """
        return pulumi.get(self, "enable_auto_tier_to_hot_from_cool")

    @enable_auto_tier_to_hot_from_cool.setter
    def enable_auto_tier_to_hot_from_cool(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_auto_tier_to_hot_from_cool", value)

    @property
    @pulumi.getter(name="tierToArchive")
    def tier_to_archive(self) -> Optional[pulumi.Input['DateAfterModificationArgs']]:
        """
        The function to tier blobs to archive storage. Support blobs currently at Hot or Cool tier
        """
        return pulumi.get(self, "tier_to_archive")

    @tier_to_archive.setter
    def tier_to_archive(self, value: Optional[pulumi.Input['DateAfterModificationArgs']]):
        pulumi.set(self, "tier_to_archive", value)

    @property
    @pulumi.getter(name="tierToCool")
    def tier_to_cool(self) -> Optional[pulumi.Input['DateAfterModificationArgs']]:
        """
        The function to tier blobs to cool storage. Support blobs currently at Hot tier
        """
        return pulumi.get(self, "tier_to_cool")

    @tier_to_cool.setter
    def tier_to_cool(self, value: Optional[pulumi.Input['DateAfterModificationArgs']]):
        pulumi.set(self, "tier_to_cool", value)


@pulumi.input_type
class ManagementPolicyDefinitionArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input['ManagementPolicyActionArgs'],
                 filters: Optional[pulumi.Input['ManagementPolicyFilterArgs']] = None):
        """
        An object that defines the Lifecycle rule. Each definition is made up with a filters set and an actions set.
        :param pulumi.Input['ManagementPolicyActionArgs'] actions: An object that defines the action set.
        :param pulumi.Input['ManagementPolicyFilterArgs'] filters: An object that defines the filter set.
        """
        pulumi.set(__self__, "actions", actions)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Input['ManagementPolicyActionArgs']:
        """
        An object that defines the action set.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input['ManagementPolicyActionArgs']):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['ManagementPolicyFilterArgs']]:
        """
        An object that defines the filter set.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['ManagementPolicyFilterArgs']]):
        pulumi.set(self, "filters", value)


@pulumi.input_type
class ManagementPolicyFilterArgs:
    def __init__(__self__, *,
                 blob_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 blob_index_match: Optional[pulumi.Input[Sequence[pulumi.Input['TagFilterArgs']]]] = None,
                 prefix_match: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Filters limit rule actions to a subset of blobs within the storage account. If multiple filters are defined, a logical AND is performed on all filters. 
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blob_types: An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob.
        :param pulumi.Input[Sequence[pulumi.Input['TagFilterArgs']]] blob_index_match: An array of blob index tag based filters, there can be at most 10 tag filters
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prefix_match: An array of strings for prefixes to be match.
        """
        pulumi.set(__self__, "blob_types", blob_types)
        if blob_index_match is not None:
            pulumi.set(__self__, "blob_index_match", blob_index_match)
        if prefix_match is not None:
            pulumi.set(__self__, "prefix_match", prefix_match)

    @property
    @pulumi.getter(name="blobTypes")
    def blob_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob.
        """
        return pulumi.get(self, "blob_types")

    @blob_types.setter
    def blob_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "blob_types", value)

    @property
    @pulumi.getter(name="blobIndexMatch")
    def blob_index_match(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TagFilterArgs']]]]:
        """
        An array of blob index tag based filters, there can be at most 10 tag filters
        """
        return pulumi.get(self, "blob_index_match")

    @blob_index_match.setter
    def blob_index_match(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TagFilterArgs']]]]):
        pulumi.set(self, "blob_index_match", value)

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of strings for prefixes to be match.
        """
        return pulumi.get(self, "prefix_match")

    @prefix_match.setter
    def prefix_match(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prefix_match", value)


@pulumi.input_type
class ManagementPolicyRuleArgs:
    def __init__(__self__, *,
                 definition: pulumi.Input['ManagementPolicyDefinitionArgs'],
                 name: pulumi.Input[str],
                 type: pulumi.Input[Union[str, 'RuleType']],
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        An object that wraps the Lifecycle rule. Each rule is uniquely defined by name.
        :param pulumi.Input['ManagementPolicyDefinitionArgs'] definition: An object that defines the Lifecycle rule.
        :param pulumi.Input[str] name: A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
        :param pulumi.Input[Union[str, 'RuleType']] type: The valid value is Lifecycle
        :param pulumi.Input[bool] enabled: Rule is enabled if set to true.
        """
        pulumi.set(__self__, "definition", definition)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def definition(self) -> pulumi.Input['ManagementPolicyDefinitionArgs']:
        """
        An object that defines the Lifecycle rule.
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: pulumi.Input['ManagementPolicyDefinitionArgs']):
        pulumi.set(self, "definition", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'RuleType']]:
        """
        The valid value is Lifecycle
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'RuleType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Rule is enabled if set to true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ManagementPolicySchemaArgs:
    def __init__(__self__, *,
                 rules: pulumi.Input[Sequence[pulumi.Input['ManagementPolicyRuleArgs']]]):
        """
        The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
        :param pulumi.Input[Sequence[pulumi.Input['ManagementPolicyRuleArgs']]] rules: The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['ManagementPolicyRuleArgs']]]:
        """
        The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['ManagementPolicyRuleArgs']]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class ManagementPolicySnapShotArgs:
    def __init__(__self__, *,
                 delete: Optional[pulumi.Input['DateAfterCreationArgs']] = None,
                 tier_to_archive: Optional[pulumi.Input['DateAfterCreationArgs']] = None,
                 tier_to_cool: Optional[pulumi.Input['DateAfterCreationArgs']] = None):
        """
        Management policy action for snapshot.
        :param pulumi.Input['DateAfterCreationArgs'] delete: The function to delete the blob snapshot
        :param pulumi.Input['DateAfterCreationArgs'] tier_to_archive: The function to tier blob snapshot to archive storage. Support blob snapshot currently at Hot or Cool tier
        :param pulumi.Input['DateAfterCreationArgs'] tier_to_cool: The function to tier blob snapshot to cool storage. Support blob snapshot currently at Hot tier
        """
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if tier_to_archive is not None:
            pulumi.set(__self__, "tier_to_archive", tier_to_archive)
        if tier_to_cool is not None:
            pulumi.set(__self__, "tier_to_cool", tier_to_cool)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input['DateAfterCreationArgs']]:
        """
        The function to delete the blob snapshot
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input['DateAfterCreationArgs']]):
        pulumi.set(self, "delete", value)

    @property
    @pulumi.getter(name="tierToArchive")
    def tier_to_archive(self) -> Optional[pulumi.Input['DateAfterCreationArgs']]:
        """
        The function to tier blob snapshot to archive storage. Support blob snapshot currently at Hot or Cool tier
        """
        return pulumi.get(self, "tier_to_archive")

    @tier_to_archive.setter
    def tier_to_archive(self, value: Optional[pulumi.Input['DateAfterCreationArgs']]):
        pulumi.set(self, "tier_to_archive", value)

    @property
    @pulumi.getter(name="tierToCool")
    def tier_to_cool(self) -> Optional[pulumi.Input['DateAfterCreationArgs']]:
        """
        The function to tier blob snapshot to cool storage. Support blob snapshot currently at Hot tier
        """
        return pulumi.get(self, "tier_to_cool")

    @tier_to_cool.setter
    def tier_to_cool(self, value: Optional[pulumi.Input['DateAfterCreationArgs']]):
        pulumi.set(self, "tier_to_cool", value)


@pulumi.input_type
class ManagementPolicyVersionArgs:
    def __init__(__self__, *,
                 delete: Optional[pulumi.Input['DateAfterCreationArgs']] = None,
                 tier_to_archive: Optional[pulumi.Input['DateAfterCreationArgs']] = None,
                 tier_to_cool: Optional[pulumi.Input['DateAfterCreationArgs']] = None):
        """
        Management policy action for blob version.
        :param pulumi.Input['DateAfterCreationArgs'] delete: The function to delete the blob version
        :param pulumi.Input['DateAfterCreationArgs'] tier_to_archive: The function to tier blob version to archive storage. Support blob version currently at Hot or Cool tier
        :param pulumi.Input['DateAfterCreationArgs'] tier_to_cool: The function to tier blob version to cool storage. Support blob version currently at Hot tier
        """
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if tier_to_archive is not None:
            pulumi.set(__self__, "tier_to_archive", tier_to_archive)
        if tier_to_cool is not None:
            pulumi.set(__self__, "tier_to_cool", tier_to_cool)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input['DateAfterCreationArgs']]:
        """
        The function to delete the blob version
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input['DateAfterCreationArgs']]):
        pulumi.set(self, "delete", value)

    @property
    @pulumi.getter(name="tierToArchive")
    def tier_to_archive(self) -> Optional[pulumi.Input['DateAfterCreationArgs']]:
        """
        The function to tier blob version to archive storage. Support blob version currently at Hot or Cool tier
        """
        return pulumi.get(self, "tier_to_archive")

    @tier_to_archive.setter
    def tier_to_archive(self, value: Optional[pulumi.Input['DateAfterCreationArgs']]):
        pulumi.set(self, "tier_to_archive", value)

    @property
    @pulumi.getter(name="tierToCool")
    def tier_to_cool(self) -> Optional[pulumi.Input['DateAfterCreationArgs']]:
        """
        The function to tier blob version to cool storage. Support blob version currently at Hot tier
        """
        return pulumi.get(self, "tier_to_cool")

    @tier_to_cool.setter
    def tier_to_cool(self, value: Optional[pulumi.Input['DateAfterCreationArgs']]):
        pulumi.set(self, "tier_to_cool", value)


@pulumi.input_type
class MultichannelArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Multichannel setting. Applies to Premium FileStorage only.
        :param pulumi.Input[bool] enabled: Indicates whether multichannel is enabled
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether multichannel is enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class NetworkRuleSetArgs:
    def __init__(__self__, *,
                 default_action: pulumi.Input['DefaultAction'],
                 bypass: Optional[pulumi.Input[Union[str, 'Bypass']]] = None,
                 ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input['IPRuleArgs']]]] = None,
                 resource_access_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceAccessRuleArgs']]]] = None,
                 virtual_network_rules: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]]] = None):
        """
        Network rule set
        :param pulumi.Input['DefaultAction'] default_action: Specifies the default action of allow or deny when no other rules match.
        :param pulumi.Input[Union[str, 'Bypass']] bypass: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics.
        :param pulumi.Input[Sequence[pulumi.Input['IPRuleArgs']]] ip_rules: Sets the IP ACL rules
        :param pulumi.Input[Sequence[pulumi.Input['ResourceAccessRuleArgs']]] resource_access_rules: Sets the resource access rules
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]] virtual_network_rules: Sets the virtual network rules
        """
        if default_action is None:
            default_action = 'Allow'
        pulumi.set(__self__, "default_action", default_action)
        if bypass is None:
            bypass = 'AzureServices'
        if bypass is not None:
            pulumi.set(__self__, "bypass", bypass)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if resource_access_rules is not None:
            pulumi.set(__self__, "resource_access_rules", resource_access_rules)
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Input['DefaultAction']:
        """
        Specifies the default action of allow or deny when no other rules match.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: pulumi.Input['DefaultAction']):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter
    def bypass(self) -> Optional[pulumi.Input[Union[str, 'Bypass']]]:
        """
        Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics.
        """
        return pulumi.get(self, "bypass")

    @bypass.setter
    def bypass(self, value: Optional[pulumi.Input[Union[str, 'Bypass']]]):
        pulumi.set(self, "bypass", value)

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IPRuleArgs']]]]:
        """
        Sets the IP ACL rules
        """
        return pulumi.get(self, "ip_rules")

    @ip_rules.setter
    def ip_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IPRuleArgs']]]]):
        pulumi.set(self, "ip_rules", value)

    @property
    @pulumi.getter(name="resourceAccessRules")
    def resource_access_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceAccessRuleArgs']]]]:
        """
        Sets the resource access rules
        """
        return pulumi.get(self, "resource_access_rules")

    @resource_access_rules.setter
    def resource_access_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceAccessRuleArgs']]]]):
        pulumi.set(self, "resource_access_rules", value)

    @property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]]]:
        """
        Sets the virtual network rules
        """
        return pulumi.get(self, "virtual_network_rules")

    @virtual_network_rules.setter
    def virtual_network_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]]]):
        pulumi.set(self, "virtual_network_rules", value)


@pulumi.input_type
class ObjectReplicationPolicyFilterArgs:
    def __init__(__self__, *,
                 min_creation_time: Optional[pulumi.Input[str]] = None,
                 prefix_match: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Filters limit replication to a subset of blobs within the storage account. A logical OR is performed on values in the filter. If multiple filters are defined, a logical AND is performed on all filters.
        :param pulumi.Input[str] min_creation_time: Blobs created after the time will be replicated to the destination. It must be in datetime format 'yyyy-MM-ddTHH:mm:ssZ'. Example: 2020-02-19T16:05:00Z
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prefix_match: Optional. Filters the results to replicate only blobs whose names begin with the specified prefix.
        """
        if min_creation_time is not None:
            pulumi.set(__self__, "min_creation_time", min_creation_time)
        if prefix_match is not None:
            pulumi.set(__self__, "prefix_match", prefix_match)

    @property
    @pulumi.getter(name="minCreationTime")
    def min_creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        Blobs created after the time will be replicated to the destination. It must be in datetime format 'yyyy-MM-ddTHH:mm:ssZ'. Example: 2020-02-19T16:05:00Z
        """
        return pulumi.get(self, "min_creation_time")

    @min_creation_time.setter
    def min_creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_creation_time", value)

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. Filters the results to replicate only blobs whose names begin with the specified prefix.
        """
        return pulumi.get(self, "prefix_match")

    @prefix_match.setter
    def prefix_match(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prefix_match", value)


@pulumi.input_type
class ObjectReplicationPolicyRuleArgs:
    def __init__(__self__, *,
                 destination_container: pulumi.Input[str],
                 source_container: pulumi.Input[str],
                 filters: Optional[pulumi.Input['ObjectReplicationPolicyFilterArgs']] = None,
                 rule_id: Optional[pulumi.Input[str]] = None):
        """
        The replication policy rule between two containers.
        :param pulumi.Input[str] destination_container: Required. Destination container name.
        :param pulumi.Input[str] source_container: Required. Source container name.
        :param pulumi.Input['ObjectReplicationPolicyFilterArgs'] filters: Optional. An object that defines the filter set.
        :param pulumi.Input[str] rule_id: Rule Id is auto-generated for each new rule on destination account. It is required for put policy on source account.
        """
        pulumi.set(__self__, "destination_container", destination_container)
        pulumi.set(__self__, "source_container", source_container)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)

    @property
    @pulumi.getter(name="destinationContainer")
    def destination_container(self) -> pulumi.Input[str]:
        """
        Required. Destination container name.
        """
        return pulumi.get(self, "destination_container")

    @destination_container.setter
    def destination_container(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_container", value)

    @property
    @pulumi.getter(name="sourceContainer")
    def source_container(self) -> pulumi.Input[str]:
        """
        Required. Source container name.
        """
        return pulumi.get(self, "source_container")

    @source_container.setter
    def source_container(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_container", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['ObjectReplicationPolicyFilterArgs']]:
        """
        Optional. An object that defines the filter set.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['ObjectReplicationPolicyFilterArgs']]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[str]]:
        """
        Rule Id is auto-generated for each new rule on destination account. It is required for put policy on source account.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_id", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 action_required: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param pulumi.Input[str] action_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param pulumi.Input[str] description: The reason for approval/rejection of the connection.
        :param pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']] status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if action_required is not None:
            pulumi.set(__self__, "action_required", action_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionRequired")
    def action_required(self) -> Optional[pulumi.Input[str]]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "action_required")

    @action_required.setter
    def action_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ProtocolSettingsArgs:
    def __init__(__self__, *,
                 smb: Optional[pulumi.Input['SmbSettingArgs']] = None):
        """
        Protocol settings for file service
        :param pulumi.Input['SmbSettingArgs'] smb: Setting for SMB protocol
        """
        if smb is not None:
            pulumi.set(__self__, "smb", smb)

    @property
    @pulumi.getter
    def smb(self) -> Optional[pulumi.Input['SmbSettingArgs']]:
        """
        Setting for SMB protocol
        """
        return pulumi.get(self, "smb")

    @smb.setter
    def smb(self, value: Optional[pulumi.Input['SmbSettingArgs']]):
        pulumi.set(self, "smb", value)


@pulumi.input_type
class ResourceAccessRuleArgs:
    def __init__(__self__, *,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Resource Access Rule.
        :param pulumi.Input[str] resource_id: Resource Id
        :param pulumi.Input[str] tenant_id: Tenant Id
        """
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tenant Id
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class RestorePolicyPropertiesArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 days: Optional[pulumi.Input[int]] = None):
        """
        The blob service properties for blob restore policy
        :param pulumi.Input[bool] enabled: Blob restore is enabled if set to true.
        :param pulumi.Input[int] days: how long this blob can be restored. It should be great than zero and less than DeleteRetentionPolicy.days.
        """
        pulumi.set(__self__, "enabled", enabled)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Blob restore is enabled if set to true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        how long this blob can be restored. It should be great than zero and less than DeleteRetentionPolicy.days.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)


@pulumi.input_type
class RoutingPreferenceArgs:
    def __init__(__self__, *,
                 publish_internet_endpoints: Optional[pulumi.Input[bool]] = None,
                 publish_microsoft_endpoints: Optional[pulumi.Input[bool]] = None,
                 routing_choice: Optional[pulumi.Input[Union[str, 'RoutingChoice']]] = None):
        """
        Routing preference defines the type of network, either microsoft or internet routing to be used to deliver the user data, the default option is microsoft routing
        :param pulumi.Input[bool] publish_internet_endpoints: A boolean flag which indicates whether internet routing storage endpoints are to be published
        :param pulumi.Input[bool] publish_microsoft_endpoints: A boolean flag which indicates whether microsoft routing storage endpoints are to be published
        :param pulumi.Input[Union[str, 'RoutingChoice']] routing_choice: Routing Choice defines the kind of network routing opted by the user.
        """
        if publish_internet_endpoints is not None:
            pulumi.set(__self__, "publish_internet_endpoints", publish_internet_endpoints)
        if publish_microsoft_endpoints is not None:
            pulumi.set(__self__, "publish_microsoft_endpoints", publish_microsoft_endpoints)
        if routing_choice is not None:
            pulumi.set(__self__, "routing_choice", routing_choice)

    @property
    @pulumi.getter(name="publishInternetEndpoints")
    def publish_internet_endpoints(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean flag which indicates whether internet routing storage endpoints are to be published
        """
        return pulumi.get(self, "publish_internet_endpoints")

    @publish_internet_endpoints.setter
    def publish_internet_endpoints(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publish_internet_endpoints", value)

    @property
    @pulumi.getter(name="publishMicrosoftEndpoints")
    def publish_microsoft_endpoints(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean flag which indicates whether microsoft routing storage endpoints are to be published
        """
        return pulumi.get(self, "publish_microsoft_endpoints")

    @publish_microsoft_endpoints.setter
    def publish_microsoft_endpoints(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publish_microsoft_endpoints", value)

    @property
    @pulumi.getter(name="routingChoice")
    def routing_choice(self) -> Optional[pulumi.Input[Union[str, 'RoutingChoice']]]:
        """
        Routing Choice defines the kind of network routing opted by the user.
        """
        return pulumi.get(self, "routing_choice")

    @routing_choice.setter
    def routing_choice(self, value: Optional[pulumi.Input[Union[str, 'RoutingChoice']]]):
        pulumi.set(self, "routing_choice", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'SkuName']]):
        """
        The SKU of the storage account.
        :param pulumi.Input[Union[str, 'SkuName']] name: The SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was called accountType.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'SkuName']]:
        """
        The SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was called accountType.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'SkuName']]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class SmbSettingArgs:
    def __init__(__self__, *,
                 authentication_methods: Optional[pulumi.Input[str]] = None,
                 channel_encryption: Optional[pulumi.Input[str]] = None,
                 kerberos_ticket_encryption: Optional[pulumi.Input[str]] = None,
                 multichannel: Optional[pulumi.Input['MultichannelArgs']] = None,
                 versions: Optional[pulumi.Input[str]] = None):
        """
        Setting for SMB protocol
        :param pulumi.Input[str] authentication_methods: SMB authentication methods supported by server. Valid values are NTLMv2, Kerberos. Should be passed as a string with delimiter ';'.
        :param pulumi.Input[str] channel_encryption: SMB channel encryption supported by server. Valid values are AES-128-CCM, AES-128-GCM, AES-256-GCM. Should be passed as a string with delimiter ';'.
        :param pulumi.Input[str] kerberos_ticket_encryption: Kerberos ticket encryption supported by server. Valid values are RC4-HMAC, AES-256. Should be passed as a string with delimiter ';'
        :param pulumi.Input['MultichannelArgs'] multichannel: Multichannel setting. Applies to Premium FileStorage only.
        :param pulumi.Input[str] versions: SMB protocol versions supported by server. Valid values are SMB2.1, SMB3.0, SMB3.1.1. Should be passed as a string with delimiter ';'.
        """
        if authentication_methods is not None:
            pulumi.set(__self__, "authentication_methods", authentication_methods)
        if channel_encryption is not None:
            pulumi.set(__self__, "channel_encryption", channel_encryption)
        if kerberos_ticket_encryption is not None:
            pulumi.set(__self__, "kerberos_ticket_encryption", kerberos_ticket_encryption)
        if multichannel is not None:
            pulumi.set(__self__, "multichannel", multichannel)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter(name="authenticationMethods")
    def authentication_methods(self) -> Optional[pulumi.Input[str]]:
        """
        SMB authentication methods supported by server. Valid values are NTLMv2, Kerberos. Should be passed as a string with delimiter ';'.
        """
        return pulumi.get(self, "authentication_methods")

    @authentication_methods.setter
    def authentication_methods(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_methods", value)

    @property
    @pulumi.getter(name="channelEncryption")
    def channel_encryption(self) -> Optional[pulumi.Input[str]]:
        """
        SMB channel encryption supported by server. Valid values are AES-128-CCM, AES-128-GCM, AES-256-GCM. Should be passed as a string with delimiter ';'.
        """
        return pulumi.get(self, "channel_encryption")

    @channel_encryption.setter
    def channel_encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel_encryption", value)

    @property
    @pulumi.getter(name="kerberosTicketEncryption")
    def kerberos_ticket_encryption(self) -> Optional[pulumi.Input[str]]:
        """
        Kerberos ticket encryption supported by server. Valid values are RC4-HMAC, AES-256. Should be passed as a string with delimiter ';'
        """
        return pulumi.get(self, "kerberos_ticket_encryption")

    @kerberos_ticket_encryption.setter
    def kerberos_ticket_encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kerberos_ticket_encryption", value)

    @property
    @pulumi.getter
    def multichannel(self) -> Optional[pulumi.Input['MultichannelArgs']]:
        """
        Multichannel setting. Applies to Premium FileStorage only.
        """
        return pulumi.get(self, "multichannel")

    @multichannel.setter
    def multichannel(self, value: Optional[pulumi.Input['MultichannelArgs']]):
        pulumi.set(self, "multichannel", value)

    @property
    @pulumi.getter
    def versions(self) -> Optional[pulumi.Input[str]]:
        """
        SMB protocol versions supported by server. Valid values are SMB2.1, SMB3.0, SMB3.1.1. Should be passed as a string with delimiter ';'.
        """
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "versions", value)


@pulumi.input_type
class TagFilterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 op: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Blob index tag based filtering for blob objects
        :param pulumi.Input[str] name: This is the filter tag name, it can have 1 - 128 characters
        :param pulumi.Input[str] op: This is the comparison operator which is used for object comparison and filtering. Only == (equality operator) is currently supported
        :param pulumi.Input[str] value: This is the filter tag value field used for tag based filtering, it can have 0 - 256 characters
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        This is the filter tag name, it can have 1 - 128 characters
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def op(self) -> pulumi.Input[str]:
        """
        This is the comparison operator which is used for object comparison and filtering. Only == (equality operator) is currently supported
        """
        return pulumi.get(self, "op")

    @op.setter
    def op(self, value: pulumi.Input[str]):
        pulumi.set(self, "op", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        This is the filter tag value field used for tag based filtering, it can have 0 - 256 characters
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class VirtualNetworkRuleArgs:
    def __init__(__self__, *,
                 virtual_network_resource_id: pulumi.Input[str],
                 action: Optional[pulumi.Input['Action']] = None,
                 state: Optional[pulumi.Input[Union[str, 'State']]] = None):
        """
        Virtual Network rule.
        :param pulumi.Input[str] virtual_network_resource_id: Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        :param pulumi.Input['Action'] action: The action of virtual network rule.
        :param pulumi.Input[Union[str, 'State']] state: Gets the state of virtual network rule.
        """
        pulumi.set(__self__, "virtual_network_resource_id", virtual_network_resource_id)
        if action is None:
            action = 'Allow'
        if action is not None:
            pulumi.set(__self__, "action", action)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="virtualNetworkResourceId")
    def virtual_network_resource_id(self) -> pulumi.Input[str]:
        """
        Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        """
        return pulumi.get(self, "virtual_network_resource_id")

    @virtual_network_resource_id.setter
    def virtual_network_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "virtual_network_resource_id", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['Action']]:
        """
        The action of virtual network rule.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['Action']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'State']]]:
        """
        Gets the state of virtual network rule.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'State']]]):
        pulumi.set(self, "state", value)


