# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AdmCredentialPropertiesResponse',
    'AdmCredentialResponse',
    'ApnsCredentialPropertiesResponse',
    'ApnsCredentialResponse',
    'BaiduCredentialPropertiesResponse',
    'BaiduCredentialResponse',
    'GcmCredentialPropertiesResponse',
    'GcmCredentialResponse',
    'MpnsCredentialPropertiesResponse',
    'MpnsCredentialResponse',
    'NamespacePropertiesResponse',
    'NotificationHubPropertiesResponse',
    'SharedAccessAuthorizationRulePropertiesResponse',
    'WnsCredentialPropertiesResponse',
    'WnsCredentialResponse',
]

@pulumi.output_type
class AdmCredentialPropertiesResponse(dict):
    """
    Description of a NotificationHub AdmCredential.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authTokenUrl":
            suggest = "auth_token_url"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AdmCredentialPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AdmCredentialPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AdmCredentialPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_token_url: Optional[str] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None):
        """
        Description of a NotificationHub AdmCredential.
        :param str auth_token_url: Gets or sets the URL of the authorization token.
        :param str client_id: Gets or sets the client identifier.
        :param str client_secret: Gets or sets the credential secret access key.
        """
        if auth_token_url is not None:
            pulumi.set(__self__, "auth_token_url", auth_token_url)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)

    @property
    @pulumi.getter(name="authTokenUrl")
    def auth_token_url(self) -> Optional[str]:
        """
        Gets or sets the URL of the authorization token.
        """
        return pulumi.get(self, "auth_token_url")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        Gets or sets the client identifier.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        Gets or sets the credential secret access key.
        """
        return pulumi.get(self, "client_secret")


@pulumi.output_type
class AdmCredentialResponse(dict):
    """
    Description of a NotificationHub AdmCredential.
    """
    def __init__(__self__, *,
                 properties: Optional['outputs.AdmCredentialPropertiesResponse'] = None):
        """
        Description of a NotificationHub AdmCredential.
        :param 'AdmCredentialPropertiesResponse' properties: Gets or sets properties of NotificationHub AdmCredential.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.AdmCredentialPropertiesResponse']:
        """
        Gets or sets properties of NotificationHub AdmCredential.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class ApnsCredentialPropertiesResponse(dict):
    """
    Description of a NotificationHub ApnsCredential.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apnsCertificate":
            suggest = "apns_certificate"
        elif key == "certificateKey":
            suggest = "certificate_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApnsCredentialPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApnsCredentialPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApnsCredentialPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apns_certificate: Optional[str] = None,
                 certificate_key: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 thumbprint: Optional[str] = None):
        """
        Description of a NotificationHub ApnsCredential.
        :param str apns_certificate: Gets or sets the APNS certificate.
        :param str certificate_key: Gets or sets the certificate key.
        :param str endpoint: Gets or sets the endpoint of this credential.
        :param str thumbprint: Gets or sets the Apns certificate Thumbprint
        """
        if apns_certificate is not None:
            pulumi.set(__self__, "apns_certificate", apns_certificate)
        if certificate_key is not None:
            pulumi.set(__self__, "certificate_key", certificate_key)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="apnsCertificate")
    def apns_certificate(self) -> Optional[str]:
        """
        Gets or sets the APNS certificate.
        """
        return pulumi.get(self, "apns_certificate")

    @property
    @pulumi.getter(name="certificateKey")
    def certificate_key(self) -> Optional[str]:
        """
        Gets or sets the certificate key.
        """
        return pulumi.get(self, "certificate_key")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        Gets or sets the endpoint of this credential.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        Gets or sets the Apns certificate Thumbprint
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class ApnsCredentialResponse(dict):
    """
    Description of a NotificationHub ApnsCredential.
    """
    def __init__(__self__, *,
                 properties: Optional['outputs.ApnsCredentialPropertiesResponse'] = None):
        """
        Description of a NotificationHub ApnsCredential.
        :param 'ApnsCredentialPropertiesResponse' properties: Gets or sets properties of NotificationHub ApnsCredential.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.ApnsCredentialPropertiesResponse']:
        """
        Gets or sets properties of NotificationHub ApnsCredential.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class BaiduCredentialPropertiesResponse(dict):
    """
    Description of a NotificationHub BaiduCredential.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baiduApiKey":
            suggest = "baidu_api_key"
        elif key == "baiduEndPoint":
            suggest = "baidu_end_point"
        elif key == "baiduSecretKey":
            suggest = "baidu_secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BaiduCredentialPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BaiduCredentialPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BaiduCredentialPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 baidu_api_key: Optional[str] = None,
                 baidu_end_point: Optional[str] = None,
                 baidu_secret_key: Optional[str] = None):
        """
        Description of a NotificationHub BaiduCredential.
        :param str baidu_api_key: Get or Set Baidu Api Key.
        :param str baidu_end_point: Get or Set Baidu Endpoint.
        :param str baidu_secret_key: Get or Set Baidu Secret Key
        """
        if baidu_api_key is not None:
            pulumi.set(__self__, "baidu_api_key", baidu_api_key)
        if baidu_end_point is not None:
            pulumi.set(__self__, "baidu_end_point", baidu_end_point)
        if baidu_secret_key is not None:
            pulumi.set(__self__, "baidu_secret_key", baidu_secret_key)

    @property
    @pulumi.getter(name="baiduApiKey")
    def baidu_api_key(self) -> Optional[str]:
        """
        Get or Set Baidu Api Key.
        """
        return pulumi.get(self, "baidu_api_key")

    @property
    @pulumi.getter(name="baiduEndPoint")
    def baidu_end_point(self) -> Optional[str]:
        """
        Get or Set Baidu Endpoint.
        """
        return pulumi.get(self, "baidu_end_point")

    @property
    @pulumi.getter(name="baiduSecretKey")
    def baidu_secret_key(self) -> Optional[str]:
        """
        Get or Set Baidu Secret Key
        """
        return pulumi.get(self, "baidu_secret_key")


@pulumi.output_type
class BaiduCredentialResponse(dict):
    """
    Description of a NotificationHub BaiduCredential.
    """
    def __init__(__self__, *,
                 properties: Optional['outputs.BaiduCredentialPropertiesResponse'] = None):
        """
        Description of a NotificationHub BaiduCredential.
        :param 'BaiduCredentialPropertiesResponse' properties: Gets or sets properties of NotificationHub BaiduCredential.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.BaiduCredentialPropertiesResponse']:
        """
        Gets or sets properties of NotificationHub BaiduCredential.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class GcmCredentialPropertiesResponse(dict):
    """
    Description of a NotificationHub GcmCredential.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcmEndpoint":
            suggest = "gcm_endpoint"
        elif key == "googleApiKey":
            suggest = "google_api_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcmCredentialPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcmCredentialPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcmCredentialPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcm_endpoint: Optional[str] = None,
                 google_api_key: Optional[str] = None):
        """
        Description of a NotificationHub GcmCredential.
        :param str gcm_endpoint: Gets or sets the GCM endpoint.
        :param str google_api_key: Gets or sets the Google API key.
        """
        if gcm_endpoint is not None:
            pulumi.set(__self__, "gcm_endpoint", gcm_endpoint)
        if google_api_key is not None:
            pulumi.set(__self__, "google_api_key", google_api_key)

    @property
    @pulumi.getter(name="gcmEndpoint")
    def gcm_endpoint(self) -> Optional[str]:
        """
        Gets or sets the GCM endpoint.
        """
        return pulumi.get(self, "gcm_endpoint")

    @property
    @pulumi.getter(name="googleApiKey")
    def google_api_key(self) -> Optional[str]:
        """
        Gets or sets the Google API key.
        """
        return pulumi.get(self, "google_api_key")


@pulumi.output_type
class GcmCredentialResponse(dict):
    """
    Description of a NotificationHub GcmCredential.
    """
    def __init__(__self__, *,
                 properties: Optional['outputs.GcmCredentialPropertiesResponse'] = None):
        """
        Description of a NotificationHub GcmCredential.
        :param 'GcmCredentialPropertiesResponse' properties: Gets or sets properties of NotificationHub GcmCredential.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.GcmCredentialPropertiesResponse']:
        """
        Gets or sets properties of NotificationHub GcmCredential.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class MpnsCredentialPropertiesResponse(dict):
    """
    Description of a NotificationHub MpnsCredential.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateKey":
            suggest = "certificate_key"
        elif key == "mpnsCertificate":
            suggest = "mpns_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MpnsCredentialPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MpnsCredentialPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MpnsCredentialPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_key: Optional[str] = None,
                 mpns_certificate: Optional[str] = None,
                 thumbprint: Optional[str] = None):
        """
        Description of a NotificationHub MpnsCredential.
        :param str certificate_key: Gets or sets the certificate key for this credential.
        :param str mpns_certificate: Gets or sets the MPNS certificate.
        :param str thumbprint: Gets or sets the Mpns certificate Thumbprint
        """
        if certificate_key is not None:
            pulumi.set(__self__, "certificate_key", certificate_key)
        if mpns_certificate is not None:
            pulumi.set(__self__, "mpns_certificate", mpns_certificate)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="certificateKey")
    def certificate_key(self) -> Optional[str]:
        """
        Gets or sets the certificate key for this credential.
        """
        return pulumi.get(self, "certificate_key")

    @property
    @pulumi.getter(name="mpnsCertificate")
    def mpns_certificate(self) -> Optional[str]:
        """
        Gets or sets the MPNS certificate.
        """
        return pulumi.get(self, "mpns_certificate")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        Gets or sets the Mpns certificate Thumbprint
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class MpnsCredentialResponse(dict):
    """
    Description of a NotificationHub MpnsCredential.
    """
    def __init__(__self__, *,
                 properties: Optional['outputs.MpnsCredentialPropertiesResponse'] = None):
        """
        Description of a NotificationHub MpnsCredential.
        :param 'MpnsCredentialPropertiesResponse' properties: Gets or sets properties of NotificationHub MpnsCredential.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.MpnsCredentialPropertiesResponse']:
        """
        Gets or sets properties of NotificationHub MpnsCredential.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class NamespacePropertiesResponse(dict):
    """
    Namespace properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "namespaceType":
            suggest = "namespace_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "scaleUnit":
            suggest = "scale_unit"
        elif key == "serviceBusEndpoint":
            suggest = "service_bus_endpoint"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamespacePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamespacePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamespacePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 critical: Optional[bool] = None,
                 enabled: Optional[bool] = None,
                 name: Optional[str] = None,
                 namespace_type: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 region: Optional[str] = None,
                 scale_unit: Optional[str] = None,
                 service_bus_endpoint: Optional[str] = None,
                 status: Optional[str] = None,
                 subscription_id: Optional[str] = None):
        """
        Namespace properties.
        :param str created_at: The time the namespace was created.
        :param bool critical: Whether or not the namespace is set as Critical.
        :param bool enabled: Whether or not the namespace is currently enabled.
        :param str name: The name of the namespace.
        :param str namespace_type: Gets or sets the namespace type.
        :param str provisioning_state: Gets or sets provisioning state of the Namespace.
        :param str region: Specifies the targeted region in which the namespace should be created. It can be any of the following values: Australia East, Australia Southeast, Central US, East US, East US 2, West US, North Central US, South Central US, East Asia, Southeast Asia, Brazil South, Japan East, Japan West, North Europe, West Europe
        :param str scale_unit: ScaleUnit where the namespace gets created
        :param str service_bus_endpoint: Endpoint you can use to perform NotificationHub operations.
        :param str status: Status of the namespace. It can be any of these values:1 = Created/Active2 = Creating3 = Suspended4 = Deleting
        :param str subscription_id: The Id of the Azure subscription associated with the namespace.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if critical is not None:
            pulumi.set(__self__, "critical", critical)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_type is not None:
            pulumi.set(__self__, "namespace_type", namespace_type)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scale_unit is not None:
            pulumi.set(__self__, "scale_unit", scale_unit)
        if service_bus_endpoint is not None:
            pulumi.set(__self__, "service_bus_endpoint", service_bus_endpoint)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The time the namespace was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def critical(self) -> Optional[bool]:
        """
        Whether or not the namespace is set as Critical.
        """
        return pulumi.get(self, "critical")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether or not the namespace is currently enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the namespace.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceType")
    def namespace_type(self) -> Optional[str]:
        """
        Gets or sets the namespace type.
        """
        return pulumi.get(self, "namespace_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets provisioning state of the Namespace.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Specifies the targeted region in which the namespace should be created. It can be any of the following values: Australia East, Australia Southeast, Central US, East US, East US 2, West US, North Central US, South Central US, East Asia, Southeast Asia, Brazil South, Japan East, Japan West, North Europe, West Europe
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="scaleUnit")
    def scale_unit(self) -> Optional[str]:
        """
        ScaleUnit where the namespace gets created
        """
        return pulumi.get(self, "scale_unit")

    @property
    @pulumi.getter(name="serviceBusEndpoint")
    def service_bus_endpoint(self) -> Optional[str]:
        """
        Endpoint you can use to perform NotificationHub operations.
        """
        return pulumi.get(self, "service_bus_endpoint")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of the namespace. It can be any of these values:1 = Created/Active2 = Creating3 = Suspended4 = Deleting
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        The Id of the Azure subscription associated with the namespace.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class NotificationHubPropertiesResponse(dict):
    """
    NotificationHub properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "admCredential":
            suggest = "adm_credential"
        elif key == "apnsCredential":
            suggest = "apns_credential"
        elif key == "authorizationRules":
            suggest = "authorization_rules"
        elif key == "baiduCredential":
            suggest = "baidu_credential"
        elif key == "gcmCredential":
            suggest = "gcm_credential"
        elif key == "mpnsCredential":
            suggest = "mpns_credential"
        elif key == "registrationTtl":
            suggest = "registration_ttl"
        elif key == "wnsCredential":
            suggest = "wns_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationHubPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationHubPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationHubPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 adm_credential: Optional['outputs.AdmCredentialResponse'] = None,
                 apns_credential: Optional['outputs.ApnsCredentialResponse'] = None,
                 authorization_rules: Optional[Sequence['outputs.SharedAccessAuthorizationRulePropertiesResponse']] = None,
                 baidu_credential: Optional['outputs.BaiduCredentialResponse'] = None,
                 gcm_credential: Optional['outputs.GcmCredentialResponse'] = None,
                 mpns_credential: Optional['outputs.MpnsCredentialResponse'] = None,
                 name: Optional[str] = None,
                 registration_ttl: Optional[str] = None,
                 wns_credential: Optional['outputs.WnsCredentialResponse'] = None):
        """
        NotificationHub properties.
        :param 'AdmCredentialResponse' adm_credential: The AdmCredential of the created NotificationHub
        :param 'ApnsCredentialResponse' apns_credential: The ApnsCredential of the created NotificationHub
        :param Sequence['SharedAccessAuthorizationRulePropertiesResponse'] authorization_rules: The AuthorizationRules of the created NotificationHub
        :param 'BaiduCredentialResponse' baidu_credential: The BaiduCredential of the created NotificationHub
        :param 'GcmCredentialResponse' gcm_credential: The GcmCredential of the created NotificationHub
        :param 'MpnsCredentialResponse' mpns_credential: The MpnsCredential of the created NotificationHub
        :param str name: The NotificationHub name.
        :param str registration_ttl: The RegistrationTtl of the created NotificationHub
        :param 'WnsCredentialResponse' wns_credential: The WnsCredential of the created NotificationHub
        """
        if adm_credential is not None:
            pulumi.set(__self__, "adm_credential", adm_credential)
        if apns_credential is not None:
            pulumi.set(__self__, "apns_credential", apns_credential)
        if authorization_rules is not None:
            pulumi.set(__self__, "authorization_rules", authorization_rules)
        if baidu_credential is not None:
            pulumi.set(__self__, "baidu_credential", baidu_credential)
        if gcm_credential is not None:
            pulumi.set(__self__, "gcm_credential", gcm_credential)
        if mpns_credential is not None:
            pulumi.set(__self__, "mpns_credential", mpns_credential)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if registration_ttl is not None:
            pulumi.set(__self__, "registration_ttl", registration_ttl)
        if wns_credential is not None:
            pulumi.set(__self__, "wns_credential", wns_credential)

    @property
    @pulumi.getter(name="admCredential")
    def adm_credential(self) -> Optional['outputs.AdmCredentialResponse']:
        """
        The AdmCredential of the created NotificationHub
        """
        return pulumi.get(self, "adm_credential")

    @property
    @pulumi.getter(name="apnsCredential")
    def apns_credential(self) -> Optional['outputs.ApnsCredentialResponse']:
        """
        The ApnsCredential of the created NotificationHub
        """
        return pulumi.get(self, "apns_credential")

    @property
    @pulumi.getter(name="authorizationRules")
    def authorization_rules(self) -> Optional[Sequence['outputs.SharedAccessAuthorizationRulePropertiesResponse']]:
        """
        The AuthorizationRules of the created NotificationHub
        """
        return pulumi.get(self, "authorization_rules")

    @property
    @pulumi.getter(name="baiduCredential")
    def baidu_credential(self) -> Optional['outputs.BaiduCredentialResponse']:
        """
        The BaiduCredential of the created NotificationHub
        """
        return pulumi.get(self, "baidu_credential")

    @property
    @pulumi.getter(name="gcmCredential")
    def gcm_credential(self) -> Optional['outputs.GcmCredentialResponse']:
        """
        The GcmCredential of the created NotificationHub
        """
        return pulumi.get(self, "gcm_credential")

    @property
    @pulumi.getter(name="mpnsCredential")
    def mpns_credential(self) -> Optional['outputs.MpnsCredentialResponse']:
        """
        The MpnsCredential of the created NotificationHub
        """
        return pulumi.get(self, "mpns_credential")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The NotificationHub name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="registrationTtl")
    def registration_ttl(self) -> Optional[str]:
        """
        The RegistrationTtl of the created NotificationHub
        """
        return pulumi.get(self, "registration_ttl")

    @property
    @pulumi.getter(name="wnsCredential")
    def wns_credential(self) -> Optional['outputs.WnsCredentialResponse']:
        """
        The WnsCredential of the created NotificationHub
        """
        return pulumi.get(self, "wns_credential")


@pulumi.output_type
class SharedAccessAuthorizationRulePropertiesResponse(dict):
    """
    SharedAccessAuthorizationRule properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "claimType":
            suggest = "claim_type"
        elif key == "claimValue":
            suggest = "claim_value"
        elif key == "createdTime":
            suggest = "created_time"
        elif key == "keyName":
            suggest = "key_name"
        elif key == "modifiedTime":
            suggest = "modified_time"
        elif key == "primaryKey":
            suggest = "primary_key"
        elif key == "secondaryKey":
            suggest = "secondary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SharedAccessAuthorizationRulePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SharedAccessAuthorizationRulePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SharedAccessAuthorizationRulePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 claim_type: Optional[str] = None,
                 claim_value: Optional[str] = None,
                 created_time: Optional[str] = None,
                 key_name: Optional[str] = None,
                 modified_time: Optional[str] = None,
                 primary_key: Optional[str] = None,
                 revision: Optional[int] = None,
                 rights: Optional[Sequence[str]] = None,
                 secondary_key: Optional[str] = None):
        """
        SharedAccessAuthorizationRule properties.
        :param str claim_type: The type of the claim.
        :param str claim_value: The value of the claim.
        :param str created_time: The time at which the authorization rule was created.
        :param str key_name: The name of the key that was used.
        :param str modified_time: The most recent time the rule was updated.
        :param str primary_key: The primary key that was used.
        :param int revision: The revision number for the rule.
        :param Sequence[str] rights: The rights associated with the rule.
        :param str secondary_key: The secondary key that was used.
        """
        if claim_type is not None:
            pulumi.set(__self__, "claim_type", claim_type)
        if claim_value is not None:
            pulumi.set(__self__, "claim_value", claim_value)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if modified_time is not None:
            pulumi.set(__self__, "modified_time", modified_time)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if rights is not None:
            pulumi.set(__self__, "rights", rights)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)

    @property
    @pulumi.getter(name="claimType")
    def claim_type(self) -> Optional[str]:
        """
        The type of the claim.
        """
        return pulumi.get(self, "claim_type")

    @property
    @pulumi.getter(name="claimValue")
    def claim_value(self) -> Optional[str]:
        """
        The value of the claim.
        """
        return pulumi.get(self, "claim_value")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[str]:
        """
        The time at which the authorization rule was created.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[str]:
        """
        The name of the key that was used.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> Optional[str]:
        """
        The most recent time the rule was updated.
        """
        return pulumi.get(self, "modified_time")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[str]:
        """
        The primary key that was used.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter
    def revision(self) -> Optional[int]:
        """
        The revision number for the rule.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def rights(self) -> Optional[Sequence[str]]:
        """
        The rights associated with the rule.
        """
        return pulumi.get(self, "rights")

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[str]:
        """
        The secondary key that was used.
        """
        return pulumi.get(self, "secondary_key")


@pulumi.output_type
class WnsCredentialPropertiesResponse(dict):
    """
    Description of a NotificationHub WnsCredential.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "packageSid":
            suggest = "package_sid"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "windowsLiveEndpoint":
            suggest = "windows_live_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WnsCredentialPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WnsCredentialPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WnsCredentialPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 package_sid: Optional[str] = None,
                 secret_key: Optional[str] = None,
                 windows_live_endpoint: Optional[str] = None):
        """
        Description of a NotificationHub WnsCredential.
        :param str package_sid: Gets or sets the package ID for this credential.
        :param str secret_key: Gets or sets the secret key.
        :param str windows_live_endpoint: Gets or sets the Windows Live endpoint.
        """
        if package_sid is not None:
            pulumi.set(__self__, "package_sid", package_sid)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if windows_live_endpoint is not None:
            pulumi.set(__self__, "windows_live_endpoint", windows_live_endpoint)

    @property
    @pulumi.getter(name="packageSid")
    def package_sid(self) -> Optional[str]:
        """
        Gets or sets the package ID for this credential.
        """
        return pulumi.get(self, "package_sid")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        Gets or sets the secret key.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="windowsLiveEndpoint")
    def windows_live_endpoint(self) -> Optional[str]:
        """
        Gets or sets the Windows Live endpoint.
        """
        return pulumi.get(self, "windows_live_endpoint")


@pulumi.output_type
class WnsCredentialResponse(dict):
    """
    Description of a NotificationHub WnsCredential.
    """
    def __init__(__self__, *,
                 properties: Optional['outputs.WnsCredentialPropertiesResponse'] = None):
        """
        Description of a NotificationHub WnsCredential.
        :param 'WnsCredentialPropertiesResponse' properties: Gets or sets properties of NotificationHub WnsCredential.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.WnsCredentialPropertiesResponse']:
        """
        Gets or sets properties of NotificationHub WnsCredential.
        """
        return pulumi.get(self, "properties")


