# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ResourceSkuResponse',
]

@pulumi.output_type
class ResourceSkuResponse(dict):
    """
    The billing information of the resource.(e.g. basic vs. standard)
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        The billing information of the resource.(e.g. basic vs. standard)
        :param str name: The name of the SKU. This is typically a letter + number code, such as A0 or P3.  Required (if sku is specified)
        :param int capacity: Optional, integer. If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not 
               possible for the resource this may be omitted.
        :param str family: Optional, string. If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param str size: Optional, string. When the name field is the combination of tier and some other value, this would be the standalone code.
        :param str tier: Optional tier of this particular SKU. `Basic` is deprecated, use `Standard` instead for Basic tier
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU. This is typically a letter + number code, such as A0 or P3.  Required (if sku is specified)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Optional, integer. If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not 
        possible for the resource this may be omitted.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        Optional, string. If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        Optional, string. When the name field is the combination of tier and some other value, this would be the standalone code.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Optional tier of this particular SKU. `Basic` is deprecated, use `Standard` instead for Basic tier
        """
        return pulumi.get(self, "tier")


