# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AKSResponse',
    'AKSSchemaResponseProperties',
    'AccountKeyDatastoreCredentialsResponse',
    'AksNetworkingConfigurationResponse',
    'AmlComputeNodeInformationResponse',
    'AmlComputePropertiesResponse',
    'AmlComputeResponse',
    'AmlTokenResponse',
    'AssignedUserResponse',
    'AutoForecastHorizonResponse',
    'AutoMLJobResponse',
    'AutoNCrossValidationsResponse',
    'AutoPausePropertiesResponse',
    'AutoScalePropertiesResponse',
    'AutoSeasonalityResponse',
    'AutoTargetLagsResponse',
    'AutoTargetRollingWindowSizeResponse',
    'AzureBlobDatastoreResponse',
    'AzureDataLakeGen1DatastoreResponse',
    'AzureDataLakeGen2DatastoreResponse',
    'AzureFileDatastoreResponse',
    'BanditPolicyResponse',
    'BatchDeploymentResponse',
    'BatchEndpointDefaultsResponse',
    'BatchEndpointResponse',
    'BatchRetrySettingsResponse',
    'BayesianSamplingAlgorithmResponse',
    'BuildContextResponse',
    'CertificateDatastoreCredentialsResponse',
    'ClassificationResponse',
    'ClassificationTrainingSettingsResponse',
    'CodeConfigurationResponse',
    'CodeContainerResponse',
    'CodeVersionResponse',
    'ColumnTransformerResponse',
    'CommandJobLimitsResponse',
    'CommandJobResponse',
    'ComponentContainerResponse',
    'ComponentVersionResponse',
    'ComputeInstanceApplicationResponse',
    'ComputeInstanceConnectivityEndpointsResponse',
    'ComputeInstanceContainerResponse',
    'ComputeInstanceCreatedByResponse',
    'ComputeInstanceDataDiskResponse',
    'ComputeInstanceDataMountResponse',
    'ComputeInstanceEnvironmentInfoResponse',
    'ComputeInstanceLastOperationResponse',
    'ComputeInstancePropertiesResponse',
    'ComputeInstanceResponse',
    'ComputeInstanceSshSettingsResponse',
    'ComputeInstanceVersionResponse',
    'ComputeSchedulesResponse',
    'ComputeStartStopScheduleResponse',
    'ContainerResourceRequirementsResponse',
    'ContainerResourceSettingsResponse',
    'CosmosDbSettingsResponse',
    'CronTriggerResponse',
    'CustomForecastHorizonResponse',
    'CustomModelJobInputResponse',
    'CustomModelJobOutputResponse',
    'CustomNCrossValidationsResponse',
    'CustomSeasonalityResponse',
    'CustomTargetLagsResponse',
    'CustomTargetRollingWindowSizeResponse',
    'DataContainerResponse',
    'DataFactoryResponse',
    'DataLakeAnalyticsResponse',
    'DataLakeAnalyticsSchemaResponseProperties',
    'DataPathAssetReferenceResponse',
    'DatabricksPropertiesResponse',
    'DatabricksResponse',
    'DefaultScaleSettingsResponse',
    'DeploymentResourceConfigurationResponse',
    'EncryptionKeyVaultPropertiesResponse',
    'EncryptionPropertyResponse',
    'EndpointScheduleActionResponse',
    'EnvironmentContainerResponse',
    'EnvironmentVersionResponse',
    'ErrorAdditionalInfoResponse',
    'ErrorDetailResponse',
    'ErrorResponseResponse',
    'FlavorDataResponse',
    'ForecastingResponse',
    'ForecastingSettingsResponse',
    'ForecastingTrainingSettingsResponse',
    'GridSamplingAlgorithmResponse',
    'HDInsightPropertiesResponse',
    'HDInsightResponse',
    'IdAssetReferenceResponse',
    'IdentityForCmkResponse',
    'ImageClassificationMultilabelResponse',
    'ImageClassificationResponse',
    'ImageInstanceSegmentationResponse',
    'ImageLimitSettingsResponse',
    'ImageModelDistributionSettingsClassificationResponse',
    'ImageModelDistributionSettingsObjectDetectionResponse',
    'ImageModelSettingsClassificationResponse',
    'ImageModelSettingsObjectDetectionResponse',
    'ImageObjectDetectionResponse',
    'ImageSweepSettingsResponse',
    'InferenceContainerPropertiesResponse',
    'InstanceTypeSchemaResponse',
    'InstanceTypeSchemaResponseResources',
    'JobResourceConfigurationResponse',
    'JobScheduleActionResponse',
    'JobServiceResponse',
    'KubernetesOnlineDeploymentResponse',
    'KubernetesPropertiesResponse',
    'KubernetesResponse',
    'ListNotebookKeysResultResponse',
    'LiteralJobInputResponse',
    'MLFlowModelJobInputResponse',
    'MLFlowModelJobOutputResponse',
    'MLTableDataResponse',
    'MLTableJobInputResponse',
    'MLTableJobOutputResponse',
    'ManagedIdentityAuthTypeWorkspaceConnectionPropertiesResponse',
    'ManagedIdentityResponse',
    'ManagedOnlineDeploymentResponse',
    'ManagedServiceIdentityResponse',
    'MedianStoppingPolicyResponse',
    'ModelContainerResponse',
    'ModelVersionResponse',
    'MpiResponse',
    'NlpVerticalFeaturizationSettingsResponse',
    'NlpVerticalLimitSettingsResponse',
    'NodeStateCountsResponse',
    'NoneAuthTypeWorkspaceConnectionPropertiesResponse',
    'NoneDatastoreCredentialsResponse',
    'NotebookPreparationErrorResponse',
    'NotebookResourceInfoResponse',
    'ObjectiveResponse',
    'OnlineEndpointResponse',
    'OnlineRequestSettingsResponse',
    'OutputPathAssetReferenceResponse',
    'PATAuthTypeWorkspaceConnectionPropertiesResponse',
    'PasswordResponse',
    'PersonalComputeInstanceSettingsResponse',
    'PipelineJobResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'ProbeSettingsResponse',
    'PyTorchResponse',
    'RandomSamplingAlgorithmResponse',
    'RecurrenceScheduleResponse',
    'RecurrenceTriggerResponse',
    'RegistryListCredentialsResultResponse',
    'RegressionResponse',
    'RegressionTrainingSettingsResponse',
    'ResourceIdResponse',
    'RouteResponse',
    'SASAuthTypeWorkspaceConnectionPropertiesResponse',
    'SasDatastoreCredentialsResponse',
    'ScaleSettingsResponse',
    'ScheduleBaseResponse',
    'ScheduleResponse',
    'ScriptReferenceResponse',
    'ScriptsToExecuteResponse',
    'ServiceManagedResourcesSettingsResponse',
    'ServicePrincipalDatastoreCredentialsResponse',
    'SetupScriptsResponse',
    'SharedPrivateLinkResourceResponse',
    'SkuResponse',
    'SslConfigurationResponse',
    'StackEnsembleSettingsResponse',
    'SweepJobLimitsResponse',
    'SweepJobResponse',
    'SynapseSparkResponse',
    'SynapseSparkResponseProperties',
    'SystemDataResponse',
    'SystemServiceResponse',
    'TableVerticalFeaturizationSettingsResponse',
    'TableVerticalLimitSettingsResponse',
    'TargetUtilizationScaleSettingsResponse',
    'TensorFlowResponse',
    'TextClassificationMultilabelResponse',
    'TextClassificationResponse',
    'TextNerResponse',
    'TrialComponentResponse',
    'TritonModelJobInputResponse',
    'TritonModelJobOutputResponse',
    'TruncationSelectionPolicyResponse',
    'UriFileDataVersionResponse',
    'UriFileJobInputResponse',
    'UriFileJobOutputResponse',
    'UriFolderDataVersionResponse',
    'UriFolderJobInputResponse',
    'UriFolderJobOutputResponse',
    'UserAccountCredentialsResponse',
    'UserAssignedIdentityResponse',
    'UserIdentityResponse',
    'UsernamePasswordAuthTypeWorkspaceConnectionPropertiesResponse',
    'VirtualMachineImageResponse',
    'VirtualMachineResponse',
    'VirtualMachineSchemaResponseProperties',
    'VirtualMachineSshCredentialsResponse',
    'WorkspaceConnectionManagedIdentityResponse',
    'WorkspaceConnectionPersonalAccessTokenResponse',
    'WorkspaceConnectionSharedAccessSignatureResponse',
    'WorkspaceConnectionUsernamePasswordResponse',
]

@pulumi.output_type
class AKSResponse(dict):
    """
    A Machine Learning compute based on AKS.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 properties: Optional['outputs.AKSSchemaResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A Machine Learning compute based on AKS.
        :param str compute_type: The type of compute
               Expected value is 'AKS'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param 'AKSSchemaResponseProperties' properties: AKS properties
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'AKS')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'AKS'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.AKSSchemaResponseProperties']:
        """
        AKS properties
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class AKSSchemaResponseProperties(dict):
    """
    AKS properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "systemServices":
            suggest = "system_services"
        elif key == "agentCount":
            suggest = "agent_count"
        elif key == "agentVmSize":
            suggest = "agent_vm_size"
        elif key == "aksNetworkingConfiguration":
            suggest = "aks_networking_configuration"
        elif key == "clusterFqdn":
            suggest = "cluster_fqdn"
        elif key == "clusterPurpose":
            suggest = "cluster_purpose"
        elif key == "loadBalancerSubnet":
            suggest = "load_balancer_subnet"
        elif key == "loadBalancerType":
            suggest = "load_balancer_type"
        elif key == "sslConfiguration":
            suggest = "ssl_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSSchemaResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSSchemaResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSSchemaResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 system_services: Sequence['outputs.SystemServiceResponse'],
                 agent_count: Optional[int] = None,
                 agent_vm_size: Optional[str] = None,
                 aks_networking_configuration: Optional['outputs.AksNetworkingConfigurationResponse'] = None,
                 cluster_fqdn: Optional[str] = None,
                 cluster_purpose: Optional[str] = None,
                 load_balancer_subnet: Optional[str] = None,
                 load_balancer_type: Optional[str] = None,
                 ssl_configuration: Optional['outputs.SslConfigurationResponse'] = None):
        """
        AKS properties
        :param Sequence['SystemServiceResponse'] system_services: System services
        :param int agent_count: Number of agents
        :param str agent_vm_size: Agent virtual machine size
        :param 'AksNetworkingConfigurationResponse' aks_networking_configuration: AKS networking configuration for vnet
        :param str cluster_fqdn: Cluster full qualified domain name
        :param str cluster_purpose: Intended usage of the cluster
        :param str load_balancer_subnet: Load Balancer Subnet
        :param str load_balancer_type: Load Balancer Type
        :param 'SslConfigurationResponse' ssl_configuration: SSL configuration
        """
        pulumi.set(__self__, "system_services", system_services)
        if agent_count is not None:
            pulumi.set(__self__, "agent_count", agent_count)
        if agent_vm_size is not None:
            pulumi.set(__self__, "agent_vm_size", agent_vm_size)
        if aks_networking_configuration is not None:
            pulumi.set(__self__, "aks_networking_configuration", aks_networking_configuration)
        if cluster_fqdn is not None:
            pulumi.set(__self__, "cluster_fqdn", cluster_fqdn)
        if cluster_purpose is None:
            cluster_purpose = 'FastProd'
        if cluster_purpose is not None:
            pulumi.set(__self__, "cluster_purpose", cluster_purpose)
        if load_balancer_subnet is not None:
            pulumi.set(__self__, "load_balancer_subnet", load_balancer_subnet)
        if load_balancer_type is None:
            load_balancer_type = 'PublicIp'
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if ssl_configuration is not None:
            pulumi.set(__self__, "ssl_configuration", ssl_configuration)

    @property
    @pulumi.getter(name="systemServices")
    def system_services(self) -> Sequence['outputs.SystemServiceResponse']:
        """
        System services
        """
        return pulumi.get(self, "system_services")

    @property
    @pulumi.getter(name="agentCount")
    def agent_count(self) -> Optional[int]:
        """
        Number of agents
        """
        return pulumi.get(self, "agent_count")

    @property
    @pulumi.getter(name="agentVmSize")
    def agent_vm_size(self) -> Optional[str]:
        """
        Agent virtual machine size
        """
        return pulumi.get(self, "agent_vm_size")

    @property
    @pulumi.getter(name="aksNetworkingConfiguration")
    def aks_networking_configuration(self) -> Optional['outputs.AksNetworkingConfigurationResponse']:
        """
        AKS networking configuration for vnet
        """
        return pulumi.get(self, "aks_networking_configuration")

    @property
    @pulumi.getter(name="clusterFqdn")
    def cluster_fqdn(self) -> Optional[str]:
        """
        Cluster full qualified domain name
        """
        return pulumi.get(self, "cluster_fqdn")

    @property
    @pulumi.getter(name="clusterPurpose")
    def cluster_purpose(self) -> Optional[str]:
        """
        Intended usage of the cluster
        """
        return pulumi.get(self, "cluster_purpose")

    @property
    @pulumi.getter(name="loadBalancerSubnet")
    def load_balancer_subnet(self) -> Optional[str]:
        """
        Load Balancer Subnet
        """
        return pulumi.get(self, "load_balancer_subnet")

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[str]:
        """
        Load Balancer Type
        """
        return pulumi.get(self, "load_balancer_type")

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> Optional['outputs.SslConfigurationResponse']:
        """
        SSL configuration
        """
        return pulumi.get(self, "ssl_configuration")


@pulumi.output_type
class AccountKeyDatastoreCredentialsResponse(dict):
    """
    Account key datastore credentials configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialsType":
            suggest = "credentials_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountKeyDatastoreCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountKeyDatastoreCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountKeyDatastoreCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials_type: str):
        """
        Account key datastore credentials configuration.
        :param str credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'AccountKey'.
        """
        pulumi.set(__self__, "credentials_type", 'AccountKey')

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> str:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'AccountKey'.
        """
        return pulumi.get(self, "credentials_type")


@pulumi.output_type
class AksNetworkingConfigurationResponse(dict):
    """
    Advance configuration for AKS networking
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsServiceIP":
            suggest = "dns_service_ip"
        elif key == "dockerBridgeCidr":
            suggest = "docker_bridge_cidr"
        elif key == "serviceCidr":
            suggest = "service_cidr"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AksNetworkingConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AksNetworkingConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AksNetworkingConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_service_ip: Optional[str] = None,
                 docker_bridge_cidr: Optional[str] = None,
                 service_cidr: Optional[str] = None,
                 subnet_id: Optional[str] = None):
        """
        Advance configuration for AKS networking
        :param str dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        :param str docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        :param str service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        :param str subnet_id: Virtual network subnet resource ID the compute nodes belong to
        """
        if dns_service_ip is not None:
            pulumi.set(__self__, "dns_service_ip", dns_service_ip)
        if docker_bridge_cidr is not None:
            pulumi.set(__self__, "docker_bridge_cidr", docker_bridge_cidr)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="dnsServiceIP")
    def dns_service_ip(self) -> Optional[str]:
        """
        An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        """
        return pulumi.get(self, "dns_service_ip")

    @property
    @pulumi.getter(name="dockerBridgeCidr")
    def docker_bridge_cidr(self) -> Optional[str]:
        """
        A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        """
        return pulumi.get(self, "docker_bridge_cidr")

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[str]:
        """
        A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        """
        return pulumi.get(self, "service_cidr")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        Virtual network subnet resource ID the compute nodes belong to
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class AmlComputeNodeInformationResponse(dict):
    """
    Compute node information related to a AmlCompute.
    """
    def __init__(__self__, *,
                 node_id: str,
                 node_state: str,
                 port: float,
                 private_ip_address: str,
                 public_ip_address: str,
                 run_id: str):
        """
        Compute node information related to a AmlCompute.
        :param str node_id: ID of the compute node.
        :param str node_state: State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted.
        :param float port: SSH port number of the node.
        :param str private_ip_address: Private IP address of the compute node.
        :param str public_ip_address: Public IP address of the compute node.
        :param str run_id: ID of the Experiment running on the node, if any else null.
        """
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_state", node_state)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        pulumi.set(__self__, "run_id", run_id)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        ID of the compute node.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeState")
    def node_state(self) -> str:
        """
        State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted.
        """
        return pulumi.get(self, "node_state")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        SSH port number of the node.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> str:
        """
        Private IP address of the compute node.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        """
        Public IP address of the compute node.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> str:
        """
        ID of the Experiment running on the node, if any else null.
        """
        return pulumi.get(self, "run_id")


@pulumi.output_type
class AmlComputePropertiesResponse(dict):
    """
    AML Compute properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocationState":
            suggest = "allocation_state"
        elif key == "allocationStateTransitionTime":
            suggest = "allocation_state_transition_time"
        elif key == "currentNodeCount":
            suggest = "current_node_count"
        elif key == "nodeStateCounts":
            suggest = "node_state_counts"
        elif key == "targetNodeCount":
            suggest = "target_node_count"
        elif key == "enableNodePublicIp":
            suggest = "enable_node_public_ip"
        elif key == "isolatedNetwork":
            suggest = "isolated_network"
        elif key == "osType":
            suggest = "os_type"
        elif key == "propertyBag":
            suggest = "property_bag"
        elif key == "remoteLoginPortPublicAccess":
            suggest = "remote_login_port_public_access"
        elif key == "scaleSettings":
            suggest = "scale_settings"
        elif key == "userAccountCredentials":
            suggest = "user_account_credentials"
        elif key == "virtualMachineImage":
            suggest = "virtual_machine_image"
        elif key == "vmPriority":
            suggest = "vm_priority"
        elif key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AmlComputePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AmlComputePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AmlComputePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation_state: str,
                 allocation_state_transition_time: str,
                 current_node_count: int,
                 errors: Sequence['outputs.ErrorResponseResponse'],
                 node_state_counts: 'outputs.NodeStateCountsResponse',
                 target_node_count: int,
                 enable_node_public_ip: Optional[bool] = None,
                 isolated_network: Optional[bool] = None,
                 os_type: Optional[str] = None,
                 property_bag: Optional[Any] = None,
                 remote_login_port_public_access: Optional[str] = None,
                 scale_settings: Optional['outputs.ScaleSettingsResponse'] = None,
                 subnet: Optional['outputs.ResourceIdResponse'] = None,
                 user_account_credentials: Optional['outputs.UserAccountCredentialsResponse'] = None,
                 virtual_machine_image: Optional['outputs.VirtualMachineImageResponse'] = None,
                 vm_priority: Optional[str] = None,
                 vm_size: Optional[str] = None):
        """
        AML Compute properties
        :param str allocation_state: Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute.
        :param str allocation_state_transition_time: The time at which the compute entered its current allocation state.
        :param int current_node_count: The number of compute nodes currently assigned to the compute.
        :param Sequence['ErrorResponseResponse'] errors: Collection of errors encountered by various compute nodes during node setup.
        :param 'NodeStateCountsResponse' node_state_counts: Counts of various node states on the compute.
        :param int target_node_count: The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes the target node count for the ongoing resize operation. If the allocationState is steady, this property denotes the target node count for the previous resize operation.
        :param bool enable_node_public_ip: Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        :param bool isolated_network: Network is isolated or not
        :param str os_type: Compute OS Type
        :param Any property_bag: A property bag containing additional properties.
        :param str remote_login_port_public_access: State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
        :param 'ScaleSettingsResponse' scale_settings: Scale settings for AML Compute
        :param 'ResourceIdResponse' subnet: Virtual network subnet resource ID the compute nodes belong to.
        :param 'UserAccountCredentialsResponse' user_account_credentials: Credentials for an administrator user account that will be created on each compute node.
        :param 'VirtualMachineImageResponse' virtual_machine_image: Virtual Machine image for AML Compute - windows only
        :param str vm_priority: Virtual Machine priority
        :param str vm_size: Virtual Machine Size
        """
        pulumi.set(__self__, "allocation_state", allocation_state)
        pulumi.set(__self__, "allocation_state_transition_time", allocation_state_transition_time)
        pulumi.set(__self__, "current_node_count", current_node_count)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "node_state_counts", node_state_counts)
        pulumi.set(__self__, "target_node_count", target_node_count)
        if enable_node_public_ip is None:
            enable_node_public_ip = True
        if enable_node_public_ip is not None:
            pulumi.set(__self__, "enable_node_public_ip", enable_node_public_ip)
        if isolated_network is not None:
            pulumi.set(__self__, "isolated_network", isolated_network)
        if os_type is None:
            os_type = 'Linux'
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if property_bag is not None:
            pulumi.set(__self__, "property_bag", property_bag)
        if remote_login_port_public_access is None:
            remote_login_port_public_access = 'NotSpecified'
        if remote_login_port_public_access is not None:
            pulumi.set(__self__, "remote_login_port_public_access", remote_login_port_public_access)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if user_account_credentials is not None:
            pulumi.set(__self__, "user_account_credentials", user_account_credentials)
        if virtual_machine_image is not None:
            pulumi.set(__self__, "virtual_machine_image", virtual_machine_image)
        if vm_priority is not None:
            pulumi.set(__self__, "vm_priority", vm_priority)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="allocationState")
    def allocation_state(self) -> str:
        """
        Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute.
        """
        return pulumi.get(self, "allocation_state")

    @property
    @pulumi.getter(name="allocationStateTransitionTime")
    def allocation_state_transition_time(self) -> str:
        """
        The time at which the compute entered its current allocation state.
        """
        return pulumi.get(self, "allocation_state_transition_time")

    @property
    @pulumi.getter(name="currentNodeCount")
    def current_node_count(self) -> int:
        """
        The number of compute nodes currently assigned to the compute.
        """
        return pulumi.get(self, "current_node_count")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Collection of errors encountered by various compute nodes during node setup.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="nodeStateCounts")
    def node_state_counts(self) -> 'outputs.NodeStateCountsResponse':
        """
        Counts of various node states on the compute.
        """
        return pulumi.get(self, "node_state_counts")

    @property
    @pulumi.getter(name="targetNodeCount")
    def target_node_count(self) -> int:
        """
        The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes the target node count for the ongoing resize operation. If the allocationState is steady, this property denotes the target node count for the previous resize operation.
        """
        return pulumi.get(self, "target_node_count")

    @property
    @pulumi.getter(name="enableNodePublicIp")
    def enable_node_public_ip(self) -> Optional[bool]:
        """
        Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        """
        return pulumi.get(self, "enable_node_public_ip")

    @property
    @pulumi.getter(name="isolatedNetwork")
    def isolated_network(self) -> Optional[bool]:
        """
        Network is isolated or not
        """
        return pulumi.get(self, "isolated_network")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        Compute OS Type
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="propertyBag")
    def property_bag(self) -> Optional[Any]:
        """
        A property bag containing additional properties.
        """
        return pulumi.get(self, "property_bag")

    @property
    @pulumi.getter(name="remoteLoginPortPublicAccess")
    def remote_login_port_public_access(self) -> Optional[str]:
        """
        State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
        """
        return pulumi.get(self, "remote_login_port_public_access")

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional['outputs.ScaleSettingsResponse']:
        """
        Scale settings for AML Compute
        """
        return pulumi.get(self, "scale_settings")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.ResourceIdResponse']:
        """
        Virtual network subnet resource ID the compute nodes belong to.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="userAccountCredentials")
    def user_account_credentials(self) -> Optional['outputs.UserAccountCredentialsResponse']:
        """
        Credentials for an administrator user account that will be created on each compute node.
        """
        return pulumi.get(self, "user_account_credentials")

    @property
    @pulumi.getter(name="virtualMachineImage")
    def virtual_machine_image(self) -> Optional['outputs.VirtualMachineImageResponse']:
        """
        Virtual Machine image for AML Compute - windows only
        """
        return pulumi.get(self, "virtual_machine_image")

    @property
    @pulumi.getter(name="vmPriority")
    def vm_priority(self) -> Optional[str]:
        """
        Virtual Machine priority
        """
        return pulumi.get(self, "vm_priority")

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[str]:
        """
        Virtual Machine Size
        """
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class AmlComputeResponse(dict):
    """
    An Azure Machine Learning compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AmlComputeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AmlComputeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AmlComputeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 properties: Optional['outputs.AmlComputePropertiesResponse'] = None,
                 resource_id: Optional[str] = None):
        """
        An Azure Machine Learning compute.
        :param str compute_type: The type of compute
               Expected value is 'AmlCompute'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param 'AmlComputePropertiesResponse' properties: Properties of AmlCompute
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'AmlCompute')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'AmlCompute'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.AmlComputePropertiesResponse']:
        """
        Properties of AmlCompute
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class AmlTokenResponse(dict):
    """
    AML Token identity configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityType":
            suggest = "identity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AmlTokenResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AmlTokenResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AmlTokenResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_type: str):
        """
        AML Token identity configuration.
        :param str identity_type: Enum to determine identity framework.
               Expected value is 'AMLToken'.
        """
        pulumi.set(__self__, "identity_type", 'AMLToken')

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> str:
        """
        Enum to determine identity framework.
        Expected value is 'AMLToken'.
        """
        return pulumi.get(self, "identity_type")


@pulumi.output_type
class AssignedUserResponse(dict):
    """
    A user that can be assigned to a compute instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssignedUserResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssignedUserResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssignedUserResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id: str,
                 tenant_id: str):
        """
        A user that can be assigned to a compute instance.
        :param str object_id: User’s AAD Object Id.
        :param str tenant_id: User’s AAD Tenant Id.
        """
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> str:
        """
        User’s AAD Object Id.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        User’s AAD Tenant Id.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class AutoForecastHorizonResponse(dict):
    """
    Forecast horizon determined automatically by system.
    """
    def __init__(__self__, *,
                 mode: str):
        """
        Forecast horizon determined automatically by system.
        :param str mode: Enum to determine forecast horizon selection mode.
               Expected value is 'Auto'.
        """
        pulumi.set(__self__, "mode", 'Auto')

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Enum to determine forecast horizon selection mode.
        Expected value is 'Auto'.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class AutoMLJobResponse(dict):
    """
    AutoMLJob class.
    Use this class for executing AutoML tasks like Classification/Regression etc.
    See TaskType enum for all the tasks supported.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobType":
            suggest = "job_type"
        elif key == "taskDetails":
            suggest = "task_details"
        elif key == "componentId":
            suggest = "component_id"
        elif key == "computeId":
            suggest = "compute_id"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "environmentId":
            suggest = "environment_id"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "experimentName":
            suggest = "experiment_name"
        elif key == "isArchived":
            suggest = "is_archived"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoMLJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoMLJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoMLJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_type: str,
                 status: str,
                 task_details: Any,
                 component_id: Optional[str] = None,
                 compute_id: Optional[str] = None,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None,
                 environment_id: Optional[str] = None,
                 environment_variables: Optional[Mapping[str, str]] = None,
                 experiment_name: Optional[str] = None,
                 identity: Optional[Any] = None,
                 is_archived: Optional[bool] = None,
                 outputs: Optional[Mapping[str, Any]] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 resources: Optional['outputs.JobResourceConfigurationResponse'] = None,
                 services: Optional[Mapping[str, 'outputs.JobServiceResponse']] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        AutoMLJob class.
        Use this class for executing AutoML tasks like Classification/Regression etc.
        See TaskType enum for all the tasks supported.
        :param str job_type: Enum to determine the type of job.
               Expected value is 'AutoML'.
        :param str status: Status of the job.
        :param Union['ClassificationResponse', 'ForecastingResponse', 'ImageClassificationResponse', 'ImageClassificationMultilabelResponse', 'ImageInstanceSegmentationResponse', 'ImageObjectDetectionResponse', 'RegressionResponse', 'TextClassificationResponse', 'TextClassificationMultilabelResponse', 'TextNerResponse'] task_details: [Required] This represents scenario which can be one of Tables/NLP/Image
        :param str component_id: ARM resource ID of the component resource.
        :param str compute_id: ARM resource ID of the compute resource.
        :param str description: The asset description text.
        :param str display_name: Display name of job.
        :param str environment_id: The ARM resource ID of the Environment specification for the job.
               This is optional value to provide, if not provided, AutoML will default this to Production AutoML curated environment version when running the job.
        :param Mapping[str, str] environment_variables: Environment variables included in the job.
        :param str experiment_name: The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        :param Union['AmlTokenResponse', 'ManagedIdentityResponse', 'UserIdentityResponse'] identity: Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
               Defaults to AmlToken if null.
        :param bool is_archived: Is the asset archived?
        :param Mapping[str, Union['CustomModelJobOutputResponse', 'MLFlowModelJobOutputResponse', 'MLTableJobOutputResponse', 'TritonModelJobOutputResponse', 'UriFileJobOutputResponse', 'UriFolderJobOutputResponse']] outputs: Mapping of output data bindings used in the job.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param 'JobResourceConfigurationResponse' resources: Compute Resource configuration for the job.
        :param Mapping[str, 'JobServiceResponse'] services: List of JobEndpoints.
               For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "job_type", 'AutoML')
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "task_details", task_details)
        if component_id is not None:
            pulumi.set(__self__, "component_id", component_id)
        if compute_id is not None:
            pulumi.set(__self__, "compute_id", compute_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if experiment_name is None:
            experiment_name = 'Default'
        if experiment_name is not None:
            pulumi.set(__self__, "experiment_name", experiment_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> str:
        """
        Enum to determine the type of job.
        Expected value is 'AutoML'.
        """
        return pulumi.get(self, "job_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the job.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="taskDetails")
    def task_details(self) -> Any:
        """
        [Required] This represents scenario which can be one of Tables/NLP/Image
        """
        return pulumi.get(self, "task_details")

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> Optional[str]:
        """
        ARM resource ID of the component resource.
        """
        return pulumi.get(self, "component_id")

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> Optional[str]:
        """
        ARM resource ID of the compute resource.
        """
        return pulumi.get(self, "compute_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of job.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[str]:
        """
        The ARM resource ID of the Environment specification for the job.
        This is optional value to provide, if not provided, AutoML will default this to Production AutoML curated environment version when running the job.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables included in the job.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="experimentName")
    def experiment_name(self) -> Optional[str]:
        """
        The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        """
        return pulumi.get(self, "experiment_name")

    @property
    @pulumi.getter
    def identity(self) -> Optional[Any]:
        """
        Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
        Defaults to AmlToken if null.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[bool]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @property
    @pulumi.getter
    def outputs(self) -> Optional[Mapping[str, Any]]:
        """
        Mapping of output data bindings used in the job.
        """
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.JobResourceConfigurationResponse']:
        """
        Compute Resource configuration for the job.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def services(self) -> Optional[Mapping[str, 'outputs.JobServiceResponse']]:
        """
        List of JobEndpoints.
        For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class AutoNCrossValidationsResponse(dict):
    """
    N-Cross validations determined automatically.
    """
    def __init__(__self__, *,
                 mode: str):
        """
        N-Cross validations determined automatically.
        :param str mode: Determines how N-Cross validations value is determined.
               Expected value is 'Auto'.
        """
        pulumi.set(__self__, "mode", 'Auto')

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Determines how N-Cross validations value is determined.
        Expected value is 'Auto'.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class AutoPausePropertiesResponse(dict):
    """
    Auto pause properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "delayInMinutes":
            suggest = "delay_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoPausePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoPausePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoPausePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delay_in_minutes: Optional[int] = None,
                 enabled: Optional[bool] = None):
        """
        Auto pause properties
        """
        if delay_in_minutes is not None:
            pulumi.set(__self__, "delay_in_minutes", delay_in_minutes)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="delayInMinutes")
    def delay_in_minutes(self) -> Optional[int]:
        return pulumi.get(self, "delay_in_minutes")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class AutoScalePropertiesResponse(dict):
    """
    Auto scale properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "minNodeCount":
            suggest = "min_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 max_node_count: Optional[int] = None,
                 min_node_count: Optional[int] = None):
        """
        Auto scale properties
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[int]:
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[int]:
        return pulumi.get(self, "min_node_count")


@pulumi.output_type
class AutoSeasonalityResponse(dict):
    def __init__(__self__, *,
                 mode: str):
        """
        :param str mode: Forecasting seasonality mode.
               Expected value is 'Auto'.
        """
        pulumi.set(__self__, "mode", 'Auto')

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Forecasting seasonality mode.
        Expected value is 'Auto'.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class AutoTargetLagsResponse(dict):
    def __init__(__self__, *,
                 mode: str):
        """
        :param str mode: Target lags selection modes.
               Expected value is 'Auto'.
        """
        pulumi.set(__self__, "mode", 'Auto')

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Target lags selection modes.
        Expected value is 'Auto'.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class AutoTargetRollingWindowSizeResponse(dict):
    """
    Target lags rolling window determined automatically.
    """
    def __init__(__self__, *,
                 mode: str):
        """
        Target lags rolling window determined automatically.
        :param str mode: Target rolling windows size mode.
               Expected value is 'Auto'.
        """
        pulumi.set(__self__, "mode", 'Auto')

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Target rolling windows size mode.
        Expected value is 'Auto'.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class AzureBlobDatastoreResponse(dict):
    """
    Azure Blob datastore configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datastoreType":
            suggest = "datastore_type"
        elif key == "isDefault":
            suggest = "is_default"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "serviceDataAccessAuthIdentity":
            suggest = "service_data_access_auth_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureBlobDatastoreResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureBlobDatastoreResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureBlobDatastoreResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials: Any,
                 datastore_type: str,
                 is_default: bool,
                 account_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 description: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 protocol: Optional[str] = None,
                 service_data_access_auth_identity: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Azure Blob datastore configuration.
        :param Union['AccountKeyDatastoreCredentialsResponse', 'CertificateDatastoreCredentialsResponse', 'NoneDatastoreCredentialsResponse', 'SasDatastoreCredentialsResponse', 'ServicePrincipalDatastoreCredentialsResponse'] credentials: [Required] Account credentials.
        :param str datastore_type: Enum to determine the datastore contents type.
               Expected value is 'AzureBlob'.
        :param bool is_default: Readonly property to indicate if datastore is the workspace default datastore
        :param str account_name: Storage account name.
        :param str container_name: Storage account container name.
        :param str description: The asset description text.
        :param str endpoint: Azure cloud endpoint for the storage account.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param str protocol: Protocol used to communicate with the storage account.
        :param str service_data_access_auth_identity: Indicates which identity to use to authenticate service data access to customer's storage.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "datastore_type", 'AzureBlob')
        pulumi.set(__self__, "is_default", is_default)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if service_data_access_auth_identity is None:
            service_data_access_auth_identity = 'None'
        if service_data_access_auth_identity is not None:
            pulumi.set(__self__, "service_data_access_auth_identity", service_data_access_auth_identity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def credentials(self) -> Any:
        """
        [Required] Account credentials.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> str:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzureBlob'.
        """
        return pulumi.get(self, "datastore_type")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Readonly property to indicate if datastore is the workspace default datastore
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        Storage account name.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Storage account container name.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        Azure cloud endpoint for the storage account.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol used to communicate with the storage account.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="serviceDataAccessAuthIdentity")
    def service_data_access_auth_identity(self) -> Optional[str]:
        """
        Indicates which identity to use to authenticate service data access to customer's storage.
        """
        return pulumi.get(self, "service_data_access_auth_identity")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class AzureDataLakeGen1DatastoreResponse(dict):
    """
    Azure Data Lake Gen1 datastore configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datastoreType":
            suggest = "datastore_type"
        elif key == "isDefault":
            suggest = "is_default"
        elif key == "storeName":
            suggest = "store_name"
        elif key == "serviceDataAccessAuthIdentity":
            suggest = "service_data_access_auth_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureDataLakeGen1DatastoreResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureDataLakeGen1DatastoreResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureDataLakeGen1DatastoreResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials: Any,
                 datastore_type: str,
                 is_default: bool,
                 store_name: str,
                 description: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 service_data_access_auth_identity: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Azure Data Lake Gen1 datastore configuration.
        :param Union['AccountKeyDatastoreCredentialsResponse', 'CertificateDatastoreCredentialsResponse', 'NoneDatastoreCredentialsResponse', 'SasDatastoreCredentialsResponse', 'ServicePrincipalDatastoreCredentialsResponse'] credentials: [Required] Account credentials.
        :param str datastore_type: Enum to determine the datastore contents type.
               Expected value is 'AzureDataLakeGen1'.
        :param bool is_default: Readonly property to indicate if datastore is the workspace default datastore
        :param str store_name: [Required] Azure Data Lake store name.
        :param str description: The asset description text.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param str service_data_access_auth_identity: Indicates which identity to use to authenticate service data access to customer's storage.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "datastore_type", 'AzureDataLakeGen1')
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "store_name", store_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if service_data_access_auth_identity is None:
            service_data_access_auth_identity = 'None'
        if service_data_access_auth_identity is not None:
            pulumi.set(__self__, "service_data_access_auth_identity", service_data_access_auth_identity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def credentials(self) -> Any:
        """
        [Required] Account credentials.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> str:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzureDataLakeGen1'.
        """
        return pulumi.get(self, "datastore_type")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Readonly property to indicate if datastore is the workspace default datastore
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="storeName")
    def store_name(self) -> str:
        """
        [Required] Azure Data Lake store name.
        """
        return pulumi.get(self, "store_name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="serviceDataAccessAuthIdentity")
    def service_data_access_auth_identity(self) -> Optional[str]:
        """
        Indicates which identity to use to authenticate service data access to customer's storage.
        """
        return pulumi.get(self, "service_data_access_auth_identity")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class AzureDataLakeGen2DatastoreResponse(dict):
    """
    Azure Data Lake Gen2 datastore configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "datastoreType":
            suggest = "datastore_type"
        elif key == "isDefault":
            suggest = "is_default"
        elif key == "serviceDataAccessAuthIdentity":
            suggest = "service_data_access_auth_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureDataLakeGen2DatastoreResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureDataLakeGen2DatastoreResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureDataLakeGen2DatastoreResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: str,
                 credentials: Any,
                 datastore_type: str,
                 filesystem: str,
                 is_default: bool,
                 description: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 protocol: Optional[str] = None,
                 service_data_access_auth_identity: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Azure Data Lake Gen2 datastore configuration.
        :param str account_name: [Required] Storage account name.
        :param Union['AccountKeyDatastoreCredentialsResponse', 'CertificateDatastoreCredentialsResponse', 'NoneDatastoreCredentialsResponse', 'SasDatastoreCredentialsResponse', 'ServicePrincipalDatastoreCredentialsResponse'] credentials: [Required] Account credentials.
        :param str datastore_type: Enum to determine the datastore contents type.
               Expected value is 'AzureDataLakeGen2'.
        :param str filesystem: [Required] The name of the Data Lake Gen2 filesystem.
        :param bool is_default: Readonly property to indicate if datastore is the workspace default datastore
        :param str description: The asset description text.
        :param str endpoint: Azure cloud endpoint for the storage account.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param str protocol: Protocol used to communicate with the storage account.
        :param str service_data_access_auth_identity: Indicates which identity to use to authenticate service data access to customer's storage.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "datastore_type", 'AzureDataLakeGen2')
        pulumi.set(__self__, "filesystem", filesystem)
        pulumi.set(__self__, "is_default", is_default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if service_data_access_auth_identity is None:
            service_data_access_auth_identity = 'None'
        if service_data_access_auth_identity is not None:
            pulumi.set(__self__, "service_data_access_auth_identity", service_data_access_auth_identity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        [Required] Storage account name.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def credentials(self) -> Any:
        """
        [Required] Account credentials.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> str:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzureDataLakeGen2'.
        """
        return pulumi.get(self, "datastore_type")

    @property
    @pulumi.getter
    def filesystem(self) -> str:
        """
        [Required] The name of the Data Lake Gen2 filesystem.
        """
        return pulumi.get(self, "filesystem")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Readonly property to indicate if datastore is the workspace default datastore
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        Azure cloud endpoint for the storage account.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol used to communicate with the storage account.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="serviceDataAccessAuthIdentity")
    def service_data_access_auth_identity(self) -> Optional[str]:
        """
        Indicates which identity to use to authenticate service data access to customer's storage.
        """
        return pulumi.get(self, "service_data_access_auth_identity")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class AzureFileDatastoreResponse(dict):
    """
    Azure File datastore configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "datastoreType":
            suggest = "datastore_type"
        elif key == "fileShareName":
            suggest = "file_share_name"
        elif key == "isDefault":
            suggest = "is_default"
        elif key == "serviceDataAccessAuthIdentity":
            suggest = "service_data_access_auth_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFileDatastoreResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFileDatastoreResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFileDatastoreResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: str,
                 credentials: Any,
                 datastore_type: str,
                 file_share_name: str,
                 is_default: bool,
                 description: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 protocol: Optional[str] = None,
                 service_data_access_auth_identity: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Azure File datastore configuration.
        :param str account_name: [Required] Storage account name.
        :param Union['AccountKeyDatastoreCredentialsResponse', 'CertificateDatastoreCredentialsResponse', 'NoneDatastoreCredentialsResponse', 'SasDatastoreCredentialsResponse', 'ServicePrincipalDatastoreCredentialsResponse'] credentials: [Required] Account credentials.
        :param str datastore_type: Enum to determine the datastore contents type.
               Expected value is 'AzureFile'.
        :param str file_share_name: [Required] The name of the Azure file share that the datastore points to.
        :param bool is_default: Readonly property to indicate if datastore is the workspace default datastore
        :param str description: The asset description text.
        :param str endpoint: Azure cloud endpoint for the storage account.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param str protocol: Protocol used to communicate with the storage account.
        :param str service_data_access_auth_identity: Indicates which identity to use to authenticate service data access to customer's storage.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "datastore_type", 'AzureFile')
        pulumi.set(__self__, "file_share_name", file_share_name)
        pulumi.set(__self__, "is_default", is_default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if service_data_access_auth_identity is None:
            service_data_access_auth_identity = 'None'
        if service_data_access_auth_identity is not None:
            pulumi.set(__self__, "service_data_access_auth_identity", service_data_access_auth_identity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        [Required] Storage account name.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def credentials(self) -> Any:
        """
        [Required] Account credentials.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> str:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzureFile'.
        """
        return pulumi.get(self, "datastore_type")

    @property
    @pulumi.getter(name="fileShareName")
    def file_share_name(self) -> str:
        """
        [Required] The name of the Azure file share that the datastore points to.
        """
        return pulumi.get(self, "file_share_name")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Readonly property to indicate if datastore is the workspace default datastore
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        Azure cloud endpoint for the storage account.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol used to communicate with the storage account.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="serviceDataAccessAuthIdentity")
    def service_data_access_auth_identity(self) -> Optional[str]:
        """
        Indicates which identity to use to authenticate service data access to customer's storage.
        """
        return pulumi.get(self, "service_data_access_auth_identity")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class BanditPolicyResponse(dict):
    """
    Defines an early termination policy based on slack criteria, and a frequency and delay interval for evaluation
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyType":
            suggest = "policy_type"
        elif key == "delayEvaluation":
            suggest = "delay_evaluation"
        elif key == "evaluationInterval":
            suggest = "evaluation_interval"
        elif key == "slackAmount":
            suggest = "slack_amount"
        elif key == "slackFactor":
            suggest = "slack_factor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BanditPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BanditPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BanditPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_type: str,
                 delay_evaluation: Optional[int] = None,
                 evaluation_interval: Optional[int] = None,
                 slack_amount: Optional[float] = None,
                 slack_factor: Optional[float] = None):
        """
        Defines an early termination policy based on slack criteria, and a frequency and delay interval for evaluation
        :param str policy_type: 
               Expected value is 'Bandit'.
        :param int delay_evaluation: Number of intervals by which to delay the first evaluation.
        :param int evaluation_interval: Interval (number of runs) between policy evaluations.
        :param float slack_amount: Absolute distance allowed from the best performing run.
        :param float slack_factor: Ratio of the allowed distance from the best performing run.
        """
        pulumi.set(__self__, "policy_type", 'Bandit')
        if delay_evaluation is None:
            delay_evaluation = 0
        if delay_evaluation is not None:
            pulumi.set(__self__, "delay_evaluation", delay_evaluation)
        if evaluation_interval is None:
            evaluation_interval = 0
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)
        if slack_amount is None:
            slack_amount = 0
        if slack_amount is not None:
            pulumi.set(__self__, "slack_amount", slack_amount)
        if slack_factor is None:
            slack_factor = 0
        if slack_factor is not None:
            pulumi.set(__self__, "slack_factor", slack_factor)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> str:
        """

        Expected value is 'Bandit'.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="delayEvaluation")
    def delay_evaluation(self) -> Optional[int]:
        """
        Number of intervals by which to delay the first evaluation.
        """
        return pulumi.get(self, "delay_evaluation")

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[int]:
        """
        Interval (number of runs) between policy evaluations.
        """
        return pulumi.get(self, "evaluation_interval")

    @property
    @pulumi.getter(name="slackAmount")
    def slack_amount(self) -> Optional[float]:
        """
        Absolute distance allowed from the best performing run.
        """
        return pulumi.get(self, "slack_amount")

    @property
    @pulumi.getter(name="slackFactor")
    def slack_factor(self) -> Optional[float]:
        """
        Ratio of the allowed distance from the best performing run.
        """
        return pulumi.get(self, "slack_factor")


@pulumi.output_type
class BatchDeploymentResponse(dict):
    """
    Batch inference settings per deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "codeConfiguration":
            suggest = "code_configuration"
        elif key == "environmentId":
            suggest = "environment_id"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "errorThreshold":
            suggest = "error_threshold"
        elif key == "loggingLevel":
            suggest = "logging_level"
        elif key == "maxConcurrencyPerInstance":
            suggest = "max_concurrency_per_instance"
        elif key == "miniBatchSize":
            suggest = "mini_batch_size"
        elif key == "outputAction":
            suggest = "output_action"
        elif key == "outputFileName":
            suggest = "output_file_name"
        elif key == "retrySettings":
            suggest = "retry_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchDeploymentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchDeploymentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchDeploymentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 code_configuration: Optional['outputs.CodeConfigurationResponse'] = None,
                 compute: Optional[str] = None,
                 description: Optional[str] = None,
                 environment_id: Optional[str] = None,
                 environment_variables: Optional[Mapping[str, str]] = None,
                 error_threshold: Optional[int] = None,
                 logging_level: Optional[str] = None,
                 max_concurrency_per_instance: Optional[int] = None,
                 mini_batch_size: Optional[float] = None,
                 model: Optional[Any] = None,
                 output_action: Optional[str] = None,
                 output_file_name: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 resources: Optional['outputs.DeploymentResourceConfigurationResponse'] = None,
                 retry_settings: Optional['outputs.BatchRetrySettingsResponse'] = None):
        """
        Batch inference settings per deployment.
        :param str provisioning_state: Provisioning state for the endpoint deployment.
        :param 'CodeConfigurationResponse' code_configuration: Code configuration for the endpoint deployment.
        :param str compute: Compute target for batch inference operation.
        :param str description: Description of the endpoint deployment.
        :param str environment_id: ARM resource ID or AssetId of the environment specification for the endpoint deployment.
        :param Mapping[str, str] environment_variables: Environment variables configuration for the deployment.
        :param int error_threshold: Error threshold, if the error count for the entire input goes above this value,
               the batch inference will be aborted. Range is [-1, int.MaxValue].
               For FileDataset, this value is the count of file failures.
               For TabularDataset, this value is the count of record failures.
               If set to -1 (the lower bound), all failures during batch inference will be ignored.
        :param str logging_level: Logging level for batch inference operation.
        :param int max_concurrency_per_instance: Indicates maximum number of parallelism per instance.
        :param float mini_batch_size: Size of the mini-batch passed to each batch invocation.
               For FileDataset, this is the number of files per mini-batch.
               For TabularDataset, this is the size of the records in bytes, per mini-batch.
        :param Union['DataPathAssetReferenceResponse', 'IdAssetReferenceResponse', 'OutputPathAssetReferenceResponse'] model: Reference to the model asset for the endpoint deployment.
        :param str output_action: Indicates how the output will be organized.
        :param str output_file_name: Customized output file name for append_row output action.
        :param Mapping[str, str] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param 'DeploymentResourceConfigurationResponse' resources: Indicates compute configuration for the job.
               If not provided, will default to the defaults defined in ResourceConfiguration.
        :param 'BatchRetrySettingsResponse' retry_settings: Retry Settings for the batch inference operation.
               If not provided, will default to the defaults defined in BatchRetrySettings.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)
        if compute is not None:
            pulumi.set(__self__, "compute", compute)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if error_threshold is None:
            error_threshold = -1
        if error_threshold is not None:
            pulumi.set(__self__, "error_threshold", error_threshold)
        if logging_level is None:
            logging_level = 'Info'
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if max_concurrency_per_instance is None:
            max_concurrency_per_instance = 1
        if max_concurrency_per_instance is not None:
            pulumi.set(__self__, "max_concurrency_per_instance", max_concurrency_per_instance)
        if mini_batch_size is None:
            mini_batch_size = 10
        if mini_batch_size is not None:
            pulumi.set(__self__, "mini_batch_size", mini_batch_size)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if output_action is None:
            output_action = 'AppendRow'
        if output_action is not None:
            pulumi.set(__self__, "output_action", output_action)
        if output_file_name is None:
            output_file_name = 'predictions.csv'
        if output_file_name is not None:
            pulumi.set(__self__, "output_file_name", output_file_name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if retry_settings is not None:
            pulumi.set(__self__, "retry_settings", retry_settings)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state for the endpoint deployment.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional['outputs.CodeConfigurationResponse']:
        """
        Code configuration for the endpoint deployment.
        """
        return pulumi.get(self, "code_configuration")

    @property
    @pulumi.getter
    def compute(self) -> Optional[str]:
        """
        Compute target for batch inference operation.
        """
        return pulumi.get(self, "compute")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the endpoint deployment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[str]:
        """
        ARM resource ID or AssetId of the environment specification for the endpoint deployment.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables configuration for the deployment.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="errorThreshold")
    def error_threshold(self) -> Optional[int]:
        """
        Error threshold, if the error count for the entire input goes above this value,
        the batch inference will be aborted. Range is [-1, int.MaxValue].
        For FileDataset, this value is the count of file failures.
        For TabularDataset, this value is the count of record failures.
        If set to -1 (the lower bound), all failures during batch inference will be ignored.
        """
        return pulumi.get(self, "error_threshold")

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[str]:
        """
        Logging level for batch inference operation.
        """
        return pulumi.get(self, "logging_level")

    @property
    @pulumi.getter(name="maxConcurrencyPerInstance")
    def max_concurrency_per_instance(self) -> Optional[int]:
        """
        Indicates maximum number of parallelism per instance.
        """
        return pulumi.get(self, "max_concurrency_per_instance")

    @property
    @pulumi.getter(name="miniBatchSize")
    def mini_batch_size(self) -> Optional[float]:
        """
        Size of the mini-batch passed to each batch invocation.
        For FileDataset, this is the number of files per mini-batch.
        For TabularDataset, this is the size of the records in bytes, per mini-batch.
        """
        return pulumi.get(self, "mini_batch_size")

    @property
    @pulumi.getter
    def model(self) -> Optional[Any]:
        """
        Reference to the model asset for the endpoint deployment.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter(name="outputAction")
    def output_action(self) -> Optional[str]:
        """
        Indicates how the output will be organized.
        """
        return pulumi.get(self, "output_action")

    @property
    @pulumi.getter(name="outputFileName")
    def output_file_name(self) -> Optional[str]:
        """
        Customized output file name for append_row output action.
        """
        return pulumi.get(self, "output_file_name")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.DeploymentResourceConfigurationResponse']:
        """
        Indicates compute configuration for the job.
        If not provided, will default to the defaults defined in ResourceConfiguration.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="retrySettings")
    def retry_settings(self) -> Optional['outputs.BatchRetrySettingsResponse']:
        """
        Retry Settings for the batch inference operation.
        If not provided, will default to the defaults defined in BatchRetrySettings.
        """
        return pulumi.get(self, "retry_settings")


@pulumi.output_type
class BatchEndpointDefaultsResponse(dict):
    """
    Batch endpoint default values
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentName":
            suggest = "deployment_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchEndpointDefaultsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchEndpointDefaultsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchEndpointDefaultsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_name: Optional[str] = None):
        """
        Batch endpoint default values
        :param str deployment_name: Name of the deployment that will be default for the endpoint.
               This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
        """
        if deployment_name is not None:
            pulumi.set(__self__, "deployment_name", deployment_name)

    @property
    @pulumi.getter(name="deploymentName")
    def deployment_name(self) -> Optional[str]:
        """
        Name of the deployment that will be default for the endpoint.
        This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
        """
        return pulumi.get(self, "deployment_name")


@pulumi.output_type
class BatchEndpointResponse(dict):
    """
    Batch endpoint configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authMode":
            suggest = "auth_mode"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "scoringUri":
            suggest = "scoring_uri"
        elif key == "swaggerUri":
            suggest = "swagger_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_mode: str,
                 provisioning_state: str,
                 scoring_uri: str,
                 swagger_uri: str,
                 defaults: Optional['outputs.BatchEndpointDefaultsResponse'] = None,
                 description: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None):
        """
        Batch endpoint configuration.
        :param str auth_mode: [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
        :param str provisioning_state: Provisioning state for the endpoint.
        :param str scoring_uri: Endpoint URI.
        :param str swagger_uri: Endpoint Swagger URI.
        :param 'BatchEndpointDefaultsResponse' defaults: Default values for Batch Endpoint
        :param str description: Description of the inference endpoint.
        :param Mapping[str, str] properties: Property dictionary. Properties can be added, but not removed or altered.
        """
        pulumi.set(__self__, "auth_mode", auth_mode)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "scoring_uri", scoring_uri)
        pulumi.set(__self__, "swagger_uri", swagger_uri)
        if defaults is not None:
            pulumi.set(__self__, "defaults", defaults)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> str:
        """
        [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
        """
        return pulumi.get(self, "auth_mode")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state for the endpoint.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="scoringUri")
    def scoring_uri(self) -> str:
        """
        Endpoint URI.
        """
        return pulumi.get(self, "scoring_uri")

    @property
    @pulumi.getter(name="swaggerUri")
    def swagger_uri(self) -> str:
        """
        Endpoint Swagger URI.
        """
        return pulumi.get(self, "swagger_uri")

    @property
    @pulumi.getter
    def defaults(self) -> Optional['outputs.BatchEndpointDefaultsResponse']:
        """
        Default values for Batch Endpoint
        """
        return pulumi.get(self, "defaults")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the inference endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class BatchRetrySettingsResponse(dict):
    """
    Retry settings for a batch inference operation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRetries":
            suggest = "max_retries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchRetrySettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchRetrySettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchRetrySettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_retries: Optional[int] = None,
                 timeout: Optional[str] = None):
        """
        Retry settings for a batch inference operation.
        :param int max_retries: Maximum retry count for a mini-batch
        :param str timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
        """
        if max_retries is None:
            max_retries = 3
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if timeout is None:
            timeout = 'PT30S'
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[int]:
        """
        Maximum retry count for a mini-batch
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        Invocation timeout for a mini-batch, in ISO 8601 format.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class BayesianSamplingAlgorithmResponse(dict):
    """
    Defines a Sampling Algorithm that generates values based on previous values
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "samplingAlgorithmType":
            suggest = "sampling_algorithm_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BayesianSamplingAlgorithmResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BayesianSamplingAlgorithmResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BayesianSamplingAlgorithmResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sampling_algorithm_type: str):
        """
        Defines a Sampling Algorithm that generates values based on previous values
        :param str sampling_algorithm_type: 
               Expected value is 'Bayesian'.
        """
        pulumi.set(__self__, "sampling_algorithm_type", 'Bayesian')

    @property
    @pulumi.getter(name="samplingAlgorithmType")
    def sampling_algorithm_type(self) -> str:
        """

        Expected value is 'Bayesian'.
        """
        return pulumi.get(self, "sampling_algorithm_type")


@pulumi.output_type
class BuildContextResponse(dict):
    """
    Configuration settings for Docker build context
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contextUri":
            suggest = "context_uri"
        elif key == "dockerfilePath":
            suggest = "dockerfile_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 context_uri: str,
                 dockerfile_path: Optional[str] = None):
        """
        Configuration settings for Docker build context
        :param str context_uri: [Required] URI of the Docker build context used to build the image. Supports blob URIs on environment creation and may return blob or Git URIs.
               <seealso href="https://docs.docker.com/engine/reference/commandline/build/#extended-description" />
        :param str dockerfile_path: Path to the Dockerfile in the build context.
               <seealso href="https://docs.docker.com/engine/reference/builder/" />
        """
        pulumi.set(__self__, "context_uri", context_uri)
        if dockerfile_path is None:
            dockerfile_path = 'Dockerfile'
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)

    @property
    @pulumi.getter(name="contextUri")
    def context_uri(self) -> str:
        """
        [Required] URI of the Docker build context used to build the image. Supports blob URIs on environment creation and may return blob or Git URIs.
        <seealso href="https://docs.docker.com/engine/reference/commandline/build/#extended-description" />
        """
        return pulumi.get(self, "context_uri")

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[str]:
        """
        Path to the Dockerfile in the build context.
        <seealso href="https://docs.docker.com/engine/reference/builder/" />
        """
        return pulumi.get(self, "dockerfile_path")


@pulumi.output_type
class CertificateDatastoreCredentialsResponse(dict):
    """
    Certificate datastore credentials configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "credentialsType":
            suggest = "credentials_type"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "authorityUrl":
            suggest = "authority_url"
        elif key == "resourceUrl":
            suggest = "resource_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateDatastoreCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateDatastoreCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateDatastoreCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 credentials_type: str,
                 tenant_id: str,
                 thumbprint: str,
                 authority_url: Optional[str] = None,
                 resource_url: Optional[str] = None):
        """
        Certificate datastore credentials configuration.
        :param str client_id: [Required] Service principal client ID.
        :param str credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'Certificate'.
        :param str tenant_id: [Required] ID of the tenant to which the service principal belongs.
        :param str thumbprint: [Required] Thumbprint of the certificate used for authentication.
        :param str authority_url: Authority URL used for authentication.
        :param str resource_url: Resource the service principal has access to.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "credentials_type", 'Certificate')
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "thumbprint", thumbprint)
        if authority_url is not None:
            pulumi.set(__self__, "authority_url", authority_url)
        if resource_url is not None:
            pulumi.set(__self__, "resource_url", resource_url)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        [Required] Service principal client ID.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> str:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'Certificate'.
        """
        return pulumi.get(self, "credentials_type")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        [Required] ID of the tenant to which the service principal belongs.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def thumbprint(self) -> str:
        """
        [Required] Thumbprint of the certificate used for authentication.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter(name="authorityUrl")
    def authority_url(self) -> Optional[str]:
        """
        Authority URL used for authentication.
        """
        return pulumi.get(self, "authority_url")

    @property
    @pulumi.getter(name="resourceUrl")
    def resource_url(self) -> Optional[str]:
        """
        Resource the service principal has access to.
        """
        return pulumi.get(self, "resource_url")


@pulumi.output_type
class ClassificationResponse(dict):
    """
    Classification task in AutoML Table vertical.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"
        elif key == "trainingData":
            suggest = "training_data"
        elif key == "cvSplitColumnNames":
            suggest = "cv_split_column_names"
        elif key == "featurizationSettings":
            suggest = "featurization_settings"
        elif key == "limitSettings":
            suggest = "limit_settings"
        elif key == "logVerbosity":
            suggest = "log_verbosity"
        elif key == "nCrossValidations":
            suggest = "n_cross_validations"
        elif key == "positiveLabel":
            suggest = "positive_label"
        elif key == "primaryMetric":
            suggest = "primary_metric"
        elif key == "targetColumnName":
            suggest = "target_column_name"
        elif key == "testData":
            suggest = "test_data"
        elif key == "testDataSize":
            suggest = "test_data_size"
        elif key == "trainingSettings":
            suggest = "training_settings"
        elif key == "validationData":
            suggest = "validation_data"
        elif key == "validationDataSize":
            suggest = "validation_data_size"
        elif key == "weightColumnName":
            suggest = "weight_column_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_type: str,
                 training_data: 'outputs.MLTableJobInputResponse',
                 cv_split_column_names: Optional[Sequence[str]] = None,
                 featurization_settings: Optional['outputs.TableVerticalFeaturizationSettingsResponse'] = None,
                 limit_settings: Optional['outputs.TableVerticalLimitSettingsResponse'] = None,
                 log_verbosity: Optional[str] = None,
                 n_cross_validations: Optional[Any] = None,
                 positive_label: Optional[str] = None,
                 primary_metric: Optional[str] = None,
                 target_column_name: Optional[str] = None,
                 test_data: Optional['outputs.MLTableJobInputResponse'] = None,
                 test_data_size: Optional[float] = None,
                 training_settings: Optional['outputs.ClassificationTrainingSettingsResponse'] = None,
                 validation_data: Optional['outputs.MLTableJobInputResponse'] = None,
                 validation_data_size: Optional[float] = None,
                 weight_column_name: Optional[str] = None):
        """
        Classification task in AutoML Table vertical.
        :param str task_type: AutoMLJob Task type.
               Expected value is 'Classification'.
        :param 'MLTableJobInputResponse' training_data: [Required] Training data input.
        :param Sequence[str] cv_split_column_names: Columns to use for CVSplit data.
        :param 'TableVerticalFeaturizationSettingsResponse' featurization_settings: Featurization inputs needed for AutoML job.
        :param 'TableVerticalLimitSettingsResponse' limit_settings: Execution constraints for AutoMLJob.
        :param str log_verbosity: Log verbosity for the job.
        :param Union['AutoNCrossValidationsResponse', 'CustomNCrossValidationsResponse'] n_cross_validations: Number of cross validation folds to be applied on training dataset
               when validation dataset is not provided.
        :param str positive_label: Positive label for binary metrics calculation.
        :param str primary_metric: Primary metric for the task.
        :param str target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param 'MLTableJobInputResponse' test_data: Test data input.
        :param float test_data_size: The fraction of test dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        :param 'ClassificationTrainingSettingsResponse' training_settings: Inputs for training phase for an AutoML Job.
        :param 'MLTableJobInputResponse' validation_data: Validation data inputs.
        :param float validation_data_size: The fraction of training dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        :param str weight_column_name: The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
        """
        pulumi.set(__self__, "task_type", 'Classification')
        pulumi.set(__self__, "training_data", training_data)
        if cv_split_column_names is not None:
            pulumi.set(__self__, "cv_split_column_names", cv_split_column_names)
        if featurization_settings is not None:
            pulumi.set(__self__, "featurization_settings", featurization_settings)
        if limit_settings is not None:
            pulumi.set(__self__, "limit_settings", limit_settings)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if n_cross_validations is not None:
            pulumi.set(__self__, "n_cross_validations", n_cross_validations)
        if positive_label is not None:
            pulumi.set(__self__, "positive_label", positive_label)
        if primary_metric is None:
            primary_metric = 'AUCWeighted'
        if primary_metric is not None:
            pulumi.set(__self__, "primary_metric", primary_metric)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if test_data is not None:
            pulumi.set(__self__, "test_data", test_data)
        if test_data_size is not None:
            pulumi.set(__self__, "test_data_size", test_data_size)
        if training_settings is not None:
            pulumi.set(__self__, "training_settings", training_settings)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)
        if validation_data_size is not None:
            pulumi.set(__self__, "validation_data_size", validation_data_size)
        if weight_column_name is not None:
            pulumi.set(__self__, "weight_column_name", weight_column_name)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        AutoMLJob Task type.
        Expected value is 'Classification'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> 'outputs.MLTableJobInputResponse':
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @property
    @pulumi.getter(name="cvSplitColumnNames")
    def cv_split_column_names(self) -> Optional[Sequence[str]]:
        """
        Columns to use for CVSplit data.
        """
        return pulumi.get(self, "cv_split_column_names")

    @property
    @pulumi.getter(name="featurizationSettings")
    def featurization_settings(self) -> Optional['outputs.TableVerticalFeaturizationSettingsResponse']:
        """
        Featurization inputs needed for AutoML job.
        """
        return pulumi.get(self, "featurization_settings")

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> Optional['outputs.TableVerticalLimitSettingsResponse']:
        """
        Execution constraints for AutoMLJob.
        """
        return pulumi.get(self, "limit_settings")

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[str]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @property
    @pulumi.getter(name="nCrossValidations")
    def n_cross_validations(self) -> Optional[Any]:
        """
        Number of cross validation folds to be applied on training dataset
        when validation dataset is not provided.
        """
        return pulumi.get(self, "n_cross_validations")

    @property
    @pulumi.getter(name="positiveLabel")
    def positive_label(self) -> Optional[str]:
        """
        Positive label for binary metrics calculation.
        """
        return pulumi.get(self, "positive_label")

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> Optional[str]:
        """
        Primary metric for the task.
        """
        return pulumi.get(self, "primary_metric")

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[str]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @property
    @pulumi.getter(name="testData")
    def test_data(self) -> Optional['outputs.MLTableJobInputResponse']:
        """
        Test data input.
        """
        return pulumi.get(self, "test_data")

    @property
    @pulumi.getter(name="testDataSize")
    def test_data_size(self) -> Optional[float]:
        """
        The fraction of test dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "test_data_size")

    @property
    @pulumi.getter(name="trainingSettings")
    def training_settings(self) -> Optional['outputs.ClassificationTrainingSettingsResponse']:
        """
        Inputs for training phase for an AutoML Job.
        """
        return pulumi.get(self, "training_settings")

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional['outputs.MLTableJobInputResponse']:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")

    @property
    @pulumi.getter(name="validationDataSize")
    def validation_data_size(self) -> Optional[float]:
        """
        The fraction of training dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "validation_data_size")

    @property
    @pulumi.getter(name="weightColumnName")
    def weight_column_name(self) -> Optional[str]:
        """
        The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
        """
        return pulumi.get(self, "weight_column_name")


@pulumi.output_type
class ClassificationTrainingSettingsResponse(dict):
    """
    Classification Training related configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedTrainingAlgorithms":
            suggest = "allowed_training_algorithms"
        elif key == "blockedTrainingAlgorithms":
            suggest = "blocked_training_algorithms"
        elif key == "enableDnnTraining":
            suggest = "enable_dnn_training"
        elif key == "enableModelExplainability":
            suggest = "enable_model_explainability"
        elif key == "enableOnnxCompatibleModels":
            suggest = "enable_onnx_compatible_models"
        elif key == "enableStackEnsemble":
            suggest = "enable_stack_ensemble"
        elif key == "enableVoteEnsemble":
            suggest = "enable_vote_ensemble"
        elif key == "ensembleModelDownloadTimeout":
            suggest = "ensemble_model_download_timeout"
        elif key == "stackEnsembleSettings":
            suggest = "stack_ensemble_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassificationTrainingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassificationTrainingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassificationTrainingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_training_algorithms: Optional[Sequence[str]] = None,
                 blocked_training_algorithms: Optional[Sequence[str]] = None,
                 enable_dnn_training: Optional[bool] = None,
                 enable_model_explainability: Optional[bool] = None,
                 enable_onnx_compatible_models: Optional[bool] = None,
                 enable_stack_ensemble: Optional[bool] = None,
                 enable_vote_ensemble: Optional[bool] = None,
                 ensemble_model_download_timeout: Optional[str] = None,
                 stack_ensemble_settings: Optional['outputs.StackEnsembleSettingsResponse'] = None):
        """
        Classification Training related configuration.
        :param Sequence[str] allowed_training_algorithms: Allowed models for classification task.
        :param Sequence[str] blocked_training_algorithms: Blocked models for classification task.
        :param bool enable_dnn_training: Enable recommendation of DNN models.
        :param bool enable_model_explainability: Flag to turn on explainability on best model.
        :param bool enable_onnx_compatible_models: Flag for enabling onnx compatible models.
        :param bool enable_stack_ensemble: Enable stack ensemble run.
        :param bool enable_vote_ensemble: Enable voting ensemble run.
        :param str ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
               Configure this parameter with a higher value than 300 secs, if more time is needed.
        :param 'StackEnsembleSettingsResponse' stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
        """
        if allowed_training_algorithms is not None:
            pulumi.set(__self__, "allowed_training_algorithms", allowed_training_algorithms)
        if blocked_training_algorithms is not None:
            pulumi.set(__self__, "blocked_training_algorithms", blocked_training_algorithms)
        if enable_dnn_training is None:
            enable_dnn_training = False
        if enable_dnn_training is not None:
            pulumi.set(__self__, "enable_dnn_training", enable_dnn_training)
        if enable_model_explainability is None:
            enable_model_explainability = True
        if enable_model_explainability is not None:
            pulumi.set(__self__, "enable_model_explainability", enable_model_explainability)
        if enable_onnx_compatible_models is None:
            enable_onnx_compatible_models = False
        if enable_onnx_compatible_models is not None:
            pulumi.set(__self__, "enable_onnx_compatible_models", enable_onnx_compatible_models)
        if enable_stack_ensemble is None:
            enable_stack_ensemble = True
        if enable_stack_ensemble is not None:
            pulumi.set(__self__, "enable_stack_ensemble", enable_stack_ensemble)
        if enable_vote_ensemble is None:
            enable_vote_ensemble = True
        if enable_vote_ensemble is not None:
            pulumi.set(__self__, "enable_vote_ensemble", enable_vote_ensemble)
        if ensemble_model_download_timeout is None:
            ensemble_model_download_timeout = 'PT5M'
        if ensemble_model_download_timeout is not None:
            pulumi.set(__self__, "ensemble_model_download_timeout", ensemble_model_download_timeout)
        if stack_ensemble_settings is not None:
            pulumi.set(__self__, "stack_ensemble_settings", stack_ensemble_settings)

    @property
    @pulumi.getter(name="allowedTrainingAlgorithms")
    def allowed_training_algorithms(self) -> Optional[Sequence[str]]:
        """
        Allowed models for classification task.
        """
        return pulumi.get(self, "allowed_training_algorithms")

    @property
    @pulumi.getter(name="blockedTrainingAlgorithms")
    def blocked_training_algorithms(self) -> Optional[Sequence[str]]:
        """
        Blocked models for classification task.
        """
        return pulumi.get(self, "blocked_training_algorithms")

    @property
    @pulumi.getter(name="enableDnnTraining")
    def enable_dnn_training(self) -> Optional[bool]:
        """
        Enable recommendation of DNN models.
        """
        return pulumi.get(self, "enable_dnn_training")

    @property
    @pulumi.getter(name="enableModelExplainability")
    def enable_model_explainability(self) -> Optional[bool]:
        """
        Flag to turn on explainability on best model.
        """
        return pulumi.get(self, "enable_model_explainability")

    @property
    @pulumi.getter(name="enableOnnxCompatibleModels")
    def enable_onnx_compatible_models(self) -> Optional[bool]:
        """
        Flag for enabling onnx compatible models.
        """
        return pulumi.get(self, "enable_onnx_compatible_models")

    @property
    @pulumi.getter(name="enableStackEnsemble")
    def enable_stack_ensemble(self) -> Optional[bool]:
        """
        Enable stack ensemble run.
        """
        return pulumi.get(self, "enable_stack_ensemble")

    @property
    @pulumi.getter(name="enableVoteEnsemble")
    def enable_vote_ensemble(self) -> Optional[bool]:
        """
        Enable voting ensemble run.
        """
        return pulumi.get(self, "enable_vote_ensemble")

    @property
    @pulumi.getter(name="ensembleModelDownloadTimeout")
    def ensemble_model_download_timeout(self) -> Optional[str]:
        """
        During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
        Configure this parameter with a higher value than 300 secs, if more time is needed.
        """
        return pulumi.get(self, "ensemble_model_download_timeout")

    @property
    @pulumi.getter(name="stackEnsembleSettings")
    def stack_ensemble_settings(self) -> Optional['outputs.StackEnsembleSettingsResponse']:
        """
        Stack ensemble settings for stack ensemble run.
        """
        return pulumi.get(self, "stack_ensemble_settings")


@pulumi.output_type
class CodeConfigurationResponse(dict):
    """
    Configuration for a scoring code asset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scoringScript":
            suggest = "scoring_script"
        elif key == "codeId":
            suggest = "code_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scoring_script: str,
                 code_id: Optional[str] = None):
        """
        Configuration for a scoring code asset.
        :param str scoring_script: [Required] The script to execute on startup. eg. "score.py"
        :param str code_id: ARM resource ID of the code asset.
        """
        pulumi.set(__self__, "scoring_script", scoring_script)
        if code_id is not None:
            pulumi.set(__self__, "code_id", code_id)

    @property
    @pulumi.getter(name="scoringScript")
    def scoring_script(self) -> str:
        """
        [Required] The script to execute on startup. eg. "score.py"
        """
        return pulumi.get(self, "scoring_script")

    @property
    @pulumi.getter(name="codeId")
    def code_id(self) -> Optional[str]:
        """
        ARM resource ID of the code asset.
        """
        return pulumi.get(self, "code_id")


@pulumi.output_type
class CodeContainerResponse(dict):
    """
    Container for code asset versions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latestVersion":
            suggest = "latest_version"
        elif key == "nextVersion":
            suggest = "next_version"
        elif key == "isArchived":
            suggest = "is_archived"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 latest_version: str,
                 next_version: str,
                 description: Optional[str] = None,
                 is_archived: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Container for code asset versions.
        :param str latest_version: The latest version inside this container.
        :param str next_version: The next auto incremental version
        :param str description: The asset description text.
        :param bool is_archived: Is the asset archived?
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "latest_version", latest_version)
        pulumi.set(__self__, "next_version", next_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> str:
        """
        The latest version inside this container.
        """
        return pulumi.get(self, "latest_version")

    @property
    @pulumi.getter(name="nextVersion")
    def next_version(self) -> str:
        """
        The next auto incremental version
        """
        return pulumi.get(self, "next_version")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[bool]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class CodeVersionResponse(dict):
    """
    Code asset version details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeUri":
            suggest = "code_uri"
        elif key == "isAnonymous":
            suggest = "is_anonymous"
        elif key == "isArchived":
            suggest = "is_archived"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code_uri: Optional[str] = None,
                 description: Optional[str] = None,
                 is_anonymous: Optional[bool] = None,
                 is_archived: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Code asset version details.
        :param str code_uri: Uri where code is located
        :param str description: The asset description text.
        :param bool is_anonymous: If the name version are system generated (anonymous registration).
        :param bool is_archived: Is the asset archived?
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if code_uri is not None:
            pulumi.set(__self__, "code_uri", code_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_anonymous is None:
            is_anonymous = False
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="codeUri")
    def code_uri(self) -> Optional[str]:
        """
        Uri where code is located
        """
        return pulumi.get(self, "code_uri")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[bool]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[bool]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ColumnTransformerResponse(dict):
    """
    Column transformer parameters.
    """
    def __init__(__self__, *,
                 fields: Optional[Sequence[str]] = None,
                 parameters: Optional[Any] = None):
        """
        Column transformer parameters.
        :param Sequence[str] fields: Fields to apply transformer logic on.
        :param Any parameters: Different properties to be passed to transformer.
               Input expected is dictionary of key,value pairs in JSON format.
        """
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def fields(self) -> Optional[Sequence[str]]:
        """
        Fields to apply transformer logic on.
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Any]:
        """
        Different properties to be passed to transformer.
        Input expected is dictionary of key,value pairs in JSON format.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class CommandJobLimitsResponse(dict):
    """
    Command Job limit class.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobLimitsType":
            suggest = "job_limits_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommandJobLimitsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommandJobLimitsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommandJobLimitsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_limits_type: str,
                 timeout: Optional[str] = None):
        """
        Command Job limit class.
        :param str job_limits_type: 
               Expected value is 'Command'.
        :param str timeout: The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
        """
        pulumi.set(__self__, "job_limits_type", 'Command')
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="jobLimitsType")
    def job_limits_type(self) -> str:
        """

        Expected value is 'Command'.
        """
        return pulumi.get(self, "job_limits_type")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class CommandJobResponse(dict):
    """
    Command job definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentId":
            suggest = "environment_id"
        elif key == "jobType":
            suggest = "job_type"
        elif key == "codeId":
            suggest = "code_id"
        elif key == "componentId":
            suggest = "component_id"
        elif key == "computeId":
            suggest = "compute_id"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "experimentName":
            suggest = "experiment_name"
        elif key == "isArchived":
            suggest = "is_archived"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommandJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommandJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommandJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: str,
                 environment_id: str,
                 job_type: str,
                 parameters: Any,
                 status: str,
                 code_id: Optional[str] = None,
                 component_id: Optional[str] = None,
                 compute_id: Optional[str] = None,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None,
                 distribution: Optional[Any] = None,
                 environment_variables: Optional[Mapping[str, str]] = None,
                 experiment_name: Optional[str] = None,
                 identity: Optional[Any] = None,
                 inputs: Optional[Mapping[str, Any]] = None,
                 is_archived: Optional[bool] = None,
                 limits: Optional['outputs.CommandJobLimitsResponse'] = None,
                 outputs: Optional[Mapping[str, Any]] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 resources: Optional['outputs.JobResourceConfigurationResponse'] = None,
                 services: Optional[Mapping[str, 'outputs.JobServiceResponse']] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Command job definition.
        :param str command: [Required] The command to execute on startup of the job. eg. "python train.py"
        :param str environment_id: [Required] The ARM resource ID of the Environment specification for the job.
        :param str job_type: Enum to determine the type of job.
               Expected value is 'Command'.
        :param Any parameters: Input parameters.
        :param str status: Status of the job.
        :param str code_id: ARM resource ID of the code asset.
        :param str component_id: ARM resource ID of the component resource.
        :param str compute_id: ARM resource ID of the compute resource.
        :param str description: The asset description text.
        :param str display_name: Display name of job.
        :param Union['MpiResponse', 'PyTorchResponse', 'TensorFlowResponse'] distribution: Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        :param Mapping[str, str] environment_variables: Environment variables included in the job.
        :param str experiment_name: The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        :param Union['AmlTokenResponse', 'ManagedIdentityResponse', 'UserIdentityResponse'] identity: Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
               Defaults to AmlToken if null.
        :param Mapping[str, Union['CustomModelJobInputResponse', 'LiteralJobInputResponse', 'MLFlowModelJobInputResponse', 'MLTableJobInputResponse', 'TritonModelJobInputResponse', 'UriFileJobInputResponse', 'UriFolderJobInputResponse']] inputs: Mapping of input data bindings used in the job.
        :param bool is_archived: Is the asset archived?
        :param 'CommandJobLimitsResponse' limits: Command Job limit.
        :param Mapping[str, Union['CustomModelJobOutputResponse', 'MLFlowModelJobOutputResponse', 'MLTableJobOutputResponse', 'TritonModelJobOutputResponse', 'UriFileJobOutputResponse', 'UriFolderJobOutputResponse']] outputs: Mapping of output data bindings used in the job.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param 'JobResourceConfigurationResponse' resources: Compute Resource configuration for the job.
        :param Mapping[str, 'JobServiceResponse'] services: List of JobEndpoints.
               For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "job_type", 'Command')
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "status", status)
        if code_id is not None:
            pulumi.set(__self__, "code_id", code_id)
        if component_id is not None:
            pulumi.set(__self__, "component_id", component_id)
        if compute_id is not None:
            pulumi.set(__self__, "compute_id", compute_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if experiment_name is None:
            experiment_name = 'Default'
        if experiment_name is not None:
            pulumi.set(__self__, "experiment_name", experiment_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def command(self) -> str:
        """
        [Required] The command to execute on startup of the job. eg. "python train.py"
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> str:
        """
        [Required] The ARM resource ID of the Environment specification for the job.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> str:
        """
        Enum to determine the type of job.
        Expected value is 'Command'.
        """
        return pulumi.get(self, "job_type")

    @property
    @pulumi.getter
    def parameters(self) -> Any:
        """
        Input parameters.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the job.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="codeId")
    def code_id(self) -> Optional[str]:
        """
        ARM resource ID of the code asset.
        """
        return pulumi.get(self, "code_id")

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> Optional[str]:
        """
        ARM resource ID of the component resource.
        """
        return pulumi.get(self, "component_id")

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> Optional[str]:
        """
        ARM resource ID of the compute resource.
        """
        return pulumi.get(self, "compute_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of job.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def distribution(self) -> Optional[Any]:
        """
        Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables included in the job.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="experimentName")
    def experiment_name(self) -> Optional[str]:
        """
        The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        """
        return pulumi.get(self, "experiment_name")

    @property
    @pulumi.getter
    def identity(self) -> Optional[Any]:
        """
        Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
        Defaults to AmlToken if null.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def inputs(self) -> Optional[Mapping[str, Any]]:
        """
        Mapping of input data bindings used in the job.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[bool]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @property
    @pulumi.getter
    def limits(self) -> Optional['outputs.CommandJobLimitsResponse']:
        """
        Command Job limit.
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def outputs(self) -> Optional[Mapping[str, Any]]:
        """
        Mapping of output data bindings used in the job.
        """
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.JobResourceConfigurationResponse']:
        """
        Compute Resource configuration for the job.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def services(self) -> Optional[Mapping[str, 'outputs.JobServiceResponse']]:
        """
        List of JobEndpoints.
        For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ComponentContainerResponse(dict):
    """
    Component container definition.
    <see href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command" />
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latestVersion":
            suggest = "latest_version"
        elif key == "nextVersion":
            suggest = "next_version"
        elif key == "isArchived":
            suggest = "is_archived"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 latest_version: str,
                 next_version: str,
                 description: Optional[str] = None,
                 is_archived: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Component container definition.
        <see href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command" />
        :param str latest_version: The latest version inside this container.
        :param str next_version: The next auto incremental version
        :param str description: The asset description text.
        :param bool is_archived: Is the asset archived?
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "latest_version", latest_version)
        pulumi.set(__self__, "next_version", next_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> str:
        """
        The latest version inside this container.
        """
        return pulumi.get(self, "latest_version")

    @property
    @pulumi.getter(name="nextVersion")
    def next_version(self) -> str:
        """
        The next auto incremental version
        """
        return pulumi.get(self, "next_version")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[bool]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ComponentVersionResponse(dict):
    """
    Definition of a component version: defines resources that span component types.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentSpec":
            suggest = "component_spec"
        elif key == "isAnonymous":
            suggest = "is_anonymous"
        elif key == "isArchived":
            suggest = "is_archived"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_spec: Optional[Any] = None,
                 description: Optional[str] = None,
                 is_anonymous: Optional[bool] = None,
                 is_archived: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Definition of a component version: defines resources that span component types.
        :param Any component_spec: Defines Component definition details.
               <see href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command" />
        :param str description: The asset description text.
        :param bool is_anonymous: If the name version are system generated (anonymous registration).
        :param bool is_archived: Is the asset archived?
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if component_spec is not None:
            pulumi.set(__self__, "component_spec", component_spec)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_anonymous is None:
            is_anonymous = False
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="componentSpec")
    def component_spec(self) -> Optional[Any]:
        """
        Defines Component definition details.
        <see href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command" />
        """
        return pulumi.get(self, "component_spec")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[bool]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[bool]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ComputeInstanceApplicationResponse(dict):
    """
    Defines an Aml Instance application and its connectivity endpoint URI.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "endpointUri":
            suggest = "endpoint_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceApplicationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceApplicationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceApplicationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 endpoint_uri: Optional[str] = None):
        """
        Defines an Aml Instance application and its connectivity endpoint URI.
        :param str display_name: Name of the ComputeInstance application.
        :param str endpoint_uri: Application' endpoint URI.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Name of the ComputeInstance application.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[str]:
        """
        Application' endpoint URI.
        """
        return pulumi.get(self, "endpoint_uri")


@pulumi.output_type
class ComputeInstanceConnectivityEndpointsResponse(dict):
    """
    Defines all connectivity endpoints and properties for an ComputeInstance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "publicIpAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceConnectivityEndpointsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceConnectivityEndpointsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceConnectivityEndpointsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_ip_address: str,
                 public_ip_address: str):
        """
        Defines all connectivity endpoints and properties for an ComputeInstance.
        :param str private_ip_address: Private IP Address of this ComputeInstance (local to the VNET in which the compute instance is deployed).
        :param str public_ip_address: Public IP Address of this ComputeInstance.
        """
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "public_ip_address", public_ip_address)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> str:
        """
        Private IP Address of this ComputeInstance (local to the VNET in which the compute instance is deployed).
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        """
        Public IP Address of this ComputeInstance.
        """
        return pulumi.get(self, "public_ip_address")


@pulumi.output_type
class ComputeInstanceContainerResponse(dict):
    """
    Defines an Aml Instance container.
    """
    def __init__(__self__, *,
                 services: Sequence[Any],
                 autosave: Optional[str] = None,
                 environment: Optional['outputs.ComputeInstanceEnvironmentInfoResponse'] = None,
                 gpu: Optional[str] = None,
                 name: Optional[str] = None,
                 network: Optional[str] = None):
        """
        Defines an Aml Instance container.
        :param Sequence[Any] services: services of this containers.
        :param str autosave: Auto save settings.
        :param 'ComputeInstanceEnvironmentInfoResponse' environment: Environment information of this container.
        :param str gpu: Information of GPU.
        :param str name: Name of the ComputeInstance container.
        :param str network: network of this container.
        """
        pulumi.set(__self__, "services", services)
        if autosave is not None:
            pulumi.set(__self__, "autosave", autosave)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)

    @property
    @pulumi.getter
    def services(self) -> Sequence[Any]:
        """
        services of this containers.
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter
    def autosave(self) -> Optional[str]:
        """
        Auto save settings.
        """
        return pulumi.get(self, "autosave")

    @property
    @pulumi.getter
    def environment(self) -> Optional['outputs.ComputeInstanceEnvironmentInfoResponse']:
        """
        Environment information of this container.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def gpu(self) -> Optional[str]:
        """
        Information of GPU.
        """
        return pulumi.get(self, "gpu")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the ComputeInstance container.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> Optional[str]:
        """
        network of this container.
        """
        return pulumi.get(self, "network")


@pulumi.output_type
class ComputeInstanceCreatedByResponse(dict):
    """
    Describes information on user who created this ComputeInstance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userId":
            suggest = "user_id"
        elif key == "userName":
            suggest = "user_name"
        elif key == "userOrgId":
            suggest = "user_org_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceCreatedByResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceCreatedByResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceCreatedByResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_id: str,
                 user_name: str,
                 user_org_id: str):
        """
        Describes information on user who created this ComputeInstance.
        :param str user_id: Uniquely identifies the user within his/her organization.
        :param str user_name: Name of the user.
        :param str user_org_id: Uniquely identifies user' Azure Active Directory organization.
        """
        pulumi.set(__self__, "user_id", user_id)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "user_org_id", user_org_id)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        Uniquely identifies the user within his/her organization.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        Name of the user.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="userOrgId")
    def user_org_id(self) -> str:
        """
        Uniquely identifies user' Azure Active Directory organization.
        """
        return pulumi.get(self, "user_org_id")


@pulumi.output_type
class ComputeInstanceDataDiskResponse(dict):
    """
    Defines an Aml Instance DataDisk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "storageAccountType":
            suggest = "storage_account_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceDataDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceDataDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceDataDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caching: Optional[str] = None,
                 disk_size_gb: Optional[int] = None,
                 lun: Optional[int] = None,
                 storage_account_type: Optional[str] = None):
        """
        Defines an Aml Instance DataDisk.
        :param str caching: Caching type of Data Disk.
        :param int disk_size_gb: The initial disk size in gigabytes.
        :param int lun: The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun.
        :param str storage_account_type: type of this storage account.
        """
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if lun is not None:
            pulumi.set(__self__, "lun", lun)
        if storage_account_type is None:
            storage_account_type = 'Standard_LRS'
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter
    def caching(self) -> Optional[str]:
        """
        Caching type of Data Disk.
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[int]:
        """
        The initial disk size in gigabytes.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter
    def lun(self) -> Optional[int]:
        """
        The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun.
        """
        return pulumi.get(self, "lun")

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[str]:
        """
        type of this storage account.
        """
        return pulumi.get(self, "storage_account_type")


@pulumi.output_type
class ComputeInstanceDataMountResponse(dict):
    """
    Defines an Aml Instance DataMount.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdBy":
            suggest = "created_by"
        elif key == "mountAction":
            suggest = "mount_action"
        elif key == "mountName":
            suggest = "mount_name"
        elif key == "mountPath":
            suggest = "mount_path"
        elif key == "mountState":
            suggest = "mount_state"
        elif key == "mountedOn":
            suggest = "mounted_on"
        elif key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceDataMountResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceDataMountResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceDataMountResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_by: Optional[str] = None,
                 error: Optional[str] = None,
                 mount_action: Optional[str] = None,
                 mount_name: Optional[str] = None,
                 mount_path: Optional[str] = None,
                 mount_state: Optional[str] = None,
                 mounted_on: Optional[str] = None,
                 source: Optional[str] = None,
                 source_type: Optional[str] = None):
        """
        Defines an Aml Instance DataMount.
        :param str created_by: who this data mount created by.
        :param str error: Error of this data mount.
        :param str mount_action: Mount Action.
        :param str mount_name: name of the ComputeInstance data mount.
        :param str mount_path: Path of this data mount.
        :param str mount_state: Mount state.
        :param str mounted_on: The time when the disk mounted.
        :param str source: Source of the ComputeInstance data mount.
        :param str source_type: Data source type.
        """
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if mount_action is not None:
            pulumi.set(__self__, "mount_action", mount_action)
        if mount_name is not None:
            pulumi.set(__self__, "mount_name", mount_name)
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if mount_state is not None:
            pulumi.set(__self__, "mount_state", mount_state)
        if mounted_on is not None:
            pulumi.set(__self__, "mounted_on", mounted_on)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        who this data mount created by.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def error(self) -> Optional[str]:
        """
        Error of this data mount.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="mountAction")
    def mount_action(self) -> Optional[str]:
        """
        Mount Action.
        """
        return pulumi.get(self, "mount_action")

    @property
    @pulumi.getter(name="mountName")
    def mount_name(self) -> Optional[str]:
        """
        name of the ComputeInstance data mount.
        """
        return pulumi.get(self, "mount_name")

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[str]:
        """
        Path of this data mount.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter(name="mountState")
    def mount_state(self) -> Optional[str]:
        """
        Mount state.
        """
        return pulumi.get(self, "mount_state")

    @property
    @pulumi.getter(name="mountedOn")
    def mounted_on(self) -> Optional[str]:
        """
        The time when the disk mounted.
        """
        return pulumi.get(self, "mounted_on")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        Source of the ComputeInstance data mount.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[str]:
        """
        Data source type.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class ComputeInstanceEnvironmentInfoResponse(dict):
    """
    Environment information
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Environment information
        :param str name: name of environment.
        :param str version: version of environment.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        name of environment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        version of environment.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ComputeInstanceLastOperationResponse(dict):
    """
    The last operation on ComputeInstance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationName":
            suggest = "operation_name"
        elif key == "operationStatus":
            suggest = "operation_status"
        elif key == "operationTime":
            suggest = "operation_time"
        elif key == "operationTrigger":
            suggest = "operation_trigger"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceLastOperationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceLastOperationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceLastOperationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation_name: Optional[str] = None,
                 operation_status: Optional[str] = None,
                 operation_time: Optional[str] = None,
                 operation_trigger: Optional[str] = None):
        """
        The last operation on ComputeInstance.
        :param str operation_name: Name of the last operation.
        :param str operation_status: Operation status.
        :param str operation_time: Time of the last operation.
        :param str operation_trigger: Trigger of operation.
        """
        if operation_name is not None:
            pulumi.set(__self__, "operation_name", operation_name)
        if operation_status is not None:
            pulumi.set(__self__, "operation_status", operation_status)
        if operation_time is not None:
            pulumi.set(__self__, "operation_time", operation_time)
        if operation_trigger is not None:
            pulumi.set(__self__, "operation_trigger", operation_trigger)

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> Optional[str]:
        """
        Name of the last operation.
        """
        return pulumi.get(self, "operation_name")

    @property
    @pulumi.getter(name="operationStatus")
    def operation_status(self) -> Optional[str]:
        """
        Operation status.
        """
        return pulumi.get(self, "operation_status")

    @property
    @pulumi.getter(name="operationTime")
    def operation_time(self) -> Optional[str]:
        """
        Time of the last operation.
        """
        return pulumi.get(self, "operation_time")

    @property
    @pulumi.getter(name="operationTrigger")
    def operation_trigger(self) -> Optional[str]:
        """
        Trigger of operation.
        """
        return pulumi.get(self, "operation_trigger")


@pulumi.output_type
class ComputeInstancePropertiesResponse(dict):
    """
    Compute Instance properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectivityEndpoints":
            suggest = "connectivity_endpoints"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "dataDisks":
            suggest = "data_disks"
        elif key == "dataMounts":
            suggest = "data_mounts"
        elif key == "lastOperation":
            suggest = "last_operation"
        elif key == "applicationSharingPolicy":
            suggest = "application_sharing_policy"
        elif key == "computeInstanceAuthorizationType":
            suggest = "compute_instance_authorization_type"
        elif key == "enableNodePublicIp":
            suggest = "enable_node_public_ip"
        elif key == "personalComputeInstanceSettings":
            suggest = "personal_compute_instance_settings"
        elif key == "setupScripts":
            suggest = "setup_scripts"
        elif key == "sshSettings":
            suggest = "ssh_settings"
        elif key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 applications: Sequence['outputs.ComputeInstanceApplicationResponse'],
                 connectivity_endpoints: 'outputs.ComputeInstanceConnectivityEndpointsResponse',
                 containers: Sequence['outputs.ComputeInstanceContainerResponse'],
                 created_by: 'outputs.ComputeInstanceCreatedByResponse',
                 data_disks: Sequence['outputs.ComputeInstanceDataDiskResponse'],
                 data_mounts: Sequence['outputs.ComputeInstanceDataMountResponse'],
                 errors: Sequence['outputs.ErrorResponseResponse'],
                 last_operation: 'outputs.ComputeInstanceLastOperationResponse',
                 schedules: 'outputs.ComputeSchedulesResponse',
                 state: str,
                 versions: 'outputs.ComputeInstanceVersionResponse',
                 application_sharing_policy: Optional[str] = None,
                 compute_instance_authorization_type: Optional[str] = None,
                 enable_node_public_ip: Optional[bool] = None,
                 personal_compute_instance_settings: Optional['outputs.PersonalComputeInstanceSettingsResponse'] = None,
                 setup_scripts: Optional['outputs.SetupScriptsResponse'] = None,
                 ssh_settings: Optional['outputs.ComputeInstanceSshSettingsResponse'] = None,
                 subnet: Optional['outputs.ResourceIdResponse'] = None,
                 vm_size: Optional[str] = None):
        """
        Compute Instance properties
        :param Sequence['ComputeInstanceApplicationResponse'] applications: Describes available applications and their endpoints on this ComputeInstance.
        :param 'ComputeInstanceConnectivityEndpointsResponse' connectivity_endpoints: Describes all connectivity endpoints available for this ComputeInstance.
        :param Sequence['ComputeInstanceContainerResponse'] containers: Describes informations of containers on this ComputeInstance.
        :param 'ComputeInstanceCreatedByResponse' created_by: Describes information on user who created this ComputeInstance.
        :param Sequence['ComputeInstanceDataDiskResponse'] data_disks: Describes informations of dataDisks on this ComputeInstance.
        :param Sequence['ComputeInstanceDataMountResponse'] data_mounts: Describes informations of dataMounts on this ComputeInstance.
        :param Sequence['ErrorResponseResponse'] errors: Collection of errors encountered on this ComputeInstance.
        :param 'ComputeInstanceLastOperationResponse' last_operation: The last operation on ComputeInstance.
        :param 'ComputeSchedulesResponse' schedules: The list of schedules to be applied on the computes.
        :param str state: The current state of this ComputeInstance.
        :param 'ComputeInstanceVersionResponse' versions: ComputeInstance version.
        :param str application_sharing_policy: Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
        :param str compute_instance_authorization_type: The Compute Instance Authorization type. Available values are personal (default).
        :param bool enable_node_public_ip: Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        :param 'PersonalComputeInstanceSettingsResponse' personal_compute_instance_settings: Settings for a personal compute instance.
        :param 'SetupScriptsResponse' setup_scripts: Details of customized scripts to execute for setting up the cluster.
        :param 'ComputeInstanceSshSettingsResponse' ssh_settings: Specifies policy and settings for SSH access.
        :param 'ResourceIdResponse' subnet: Virtual network subnet resource ID the compute nodes belong to.
        :param str vm_size: Virtual Machine Size
        """
        pulumi.set(__self__, "applications", applications)
        pulumi.set(__self__, "connectivity_endpoints", connectivity_endpoints)
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "data_disks", data_disks)
        pulumi.set(__self__, "data_mounts", data_mounts)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "last_operation", last_operation)
        pulumi.set(__self__, "schedules", schedules)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "versions", versions)
        if application_sharing_policy is None:
            application_sharing_policy = 'Shared'
        if application_sharing_policy is not None:
            pulumi.set(__self__, "application_sharing_policy", application_sharing_policy)
        if compute_instance_authorization_type is None:
            compute_instance_authorization_type = 'personal'
        if compute_instance_authorization_type is not None:
            pulumi.set(__self__, "compute_instance_authorization_type", compute_instance_authorization_type)
        if enable_node_public_ip is not None:
            pulumi.set(__self__, "enable_node_public_ip", enable_node_public_ip)
        if personal_compute_instance_settings is not None:
            pulumi.set(__self__, "personal_compute_instance_settings", personal_compute_instance_settings)
        if setup_scripts is not None:
            pulumi.set(__self__, "setup_scripts", setup_scripts)
        if ssh_settings is not None:
            pulumi.set(__self__, "ssh_settings", ssh_settings)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter
    def applications(self) -> Sequence['outputs.ComputeInstanceApplicationResponse']:
        """
        Describes available applications and their endpoints on this ComputeInstance.
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter(name="connectivityEndpoints")
    def connectivity_endpoints(self) -> 'outputs.ComputeInstanceConnectivityEndpointsResponse':
        """
        Describes all connectivity endpoints available for this ComputeInstance.
        """
        return pulumi.get(self, "connectivity_endpoints")

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.ComputeInstanceContainerResponse']:
        """
        Describes informations of containers on this ComputeInstance.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> 'outputs.ComputeInstanceCreatedByResponse':
        """
        Describes information on user who created this ComputeInstance.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Sequence['outputs.ComputeInstanceDataDiskResponse']:
        """
        Describes informations of dataDisks on this ComputeInstance.
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="dataMounts")
    def data_mounts(self) -> Sequence['outputs.ComputeInstanceDataMountResponse']:
        """
        Describes informations of dataMounts on this ComputeInstance.
        """
        return pulumi.get(self, "data_mounts")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Collection of errors encountered on this ComputeInstance.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="lastOperation")
    def last_operation(self) -> 'outputs.ComputeInstanceLastOperationResponse':
        """
        The last operation on ComputeInstance.
        """
        return pulumi.get(self, "last_operation")

    @property
    @pulumi.getter
    def schedules(self) -> 'outputs.ComputeSchedulesResponse':
        """
        The list of schedules to be applied on the computes.
        """
        return pulumi.get(self, "schedules")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of this ComputeInstance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def versions(self) -> 'outputs.ComputeInstanceVersionResponse':
        """
        ComputeInstance version.
        """
        return pulumi.get(self, "versions")

    @property
    @pulumi.getter(name="applicationSharingPolicy")
    def application_sharing_policy(self) -> Optional[str]:
        """
        Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
        """
        return pulumi.get(self, "application_sharing_policy")

    @property
    @pulumi.getter(name="computeInstanceAuthorizationType")
    def compute_instance_authorization_type(self) -> Optional[str]:
        """
        The Compute Instance Authorization type. Available values are personal (default).
        """
        return pulumi.get(self, "compute_instance_authorization_type")

    @property
    @pulumi.getter(name="enableNodePublicIp")
    def enable_node_public_ip(self) -> Optional[bool]:
        """
        Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        """
        return pulumi.get(self, "enable_node_public_ip")

    @property
    @pulumi.getter(name="personalComputeInstanceSettings")
    def personal_compute_instance_settings(self) -> Optional['outputs.PersonalComputeInstanceSettingsResponse']:
        """
        Settings for a personal compute instance.
        """
        return pulumi.get(self, "personal_compute_instance_settings")

    @property
    @pulumi.getter(name="setupScripts")
    def setup_scripts(self) -> Optional['outputs.SetupScriptsResponse']:
        """
        Details of customized scripts to execute for setting up the cluster.
        """
        return pulumi.get(self, "setup_scripts")

    @property
    @pulumi.getter(name="sshSettings")
    def ssh_settings(self) -> Optional['outputs.ComputeInstanceSshSettingsResponse']:
        """
        Specifies policy and settings for SSH access.
        """
        return pulumi.get(self, "ssh_settings")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.ResourceIdResponse']:
        """
        Virtual network subnet resource ID the compute nodes belong to.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[str]:
        """
        Virtual Machine Size
        """
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class ComputeInstanceResponse(dict):
    """
    An Azure Machine Learning compute instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 properties: Optional['outputs.ComputeInstancePropertiesResponse'] = None,
                 resource_id: Optional[str] = None):
        """
        An Azure Machine Learning compute instance.
        :param str compute_type: The type of compute
               Expected value is 'ComputeInstance'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param 'ComputeInstancePropertiesResponse' properties: Properties of ComputeInstance
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'ComputeInstance')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'ComputeInstance'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.ComputeInstancePropertiesResponse']:
        """
        Properties of ComputeInstance
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class ComputeInstanceSshSettingsResponse(dict):
    """
    Specifies policy and settings for SSH access.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminUserName":
            suggest = "admin_user_name"
        elif key == "sshPort":
            suggest = "ssh_port"
        elif key == "adminPublicKey":
            suggest = "admin_public_key"
        elif key == "sshPublicAccess":
            suggest = "ssh_public_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceSshSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceSshSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceSshSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_user_name: str,
                 ssh_port: int,
                 admin_public_key: Optional[str] = None,
                 ssh_public_access: Optional[str] = None):
        """
        Specifies policy and settings for SSH access.
        :param str admin_user_name: Describes the admin user name.
        :param int ssh_port: Describes the port for connecting through SSH.
        :param str admin_public_key: Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
        :param str ssh_public_access: State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
        """
        pulumi.set(__self__, "admin_user_name", admin_user_name)
        pulumi.set(__self__, "ssh_port", ssh_port)
        if admin_public_key is not None:
            pulumi.set(__self__, "admin_public_key", admin_public_key)
        if ssh_public_access is None:
            ssh_public_access = 'Disabled'
        if ssh_public_access is not None:
            pulumi.set(__self__, "ssh_public_access", ssh_public_access)

    @property
    @pulumi.getter(name="adminUserName")
    def admin_user_name(self) -> str:
        """
        Describes the admin user name.
        """
        return pulumi.get(self, "admin_user_name")

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> int:
        """
        Describes the port for connecting through SSH.
        """
        return pulumi.get(self, "ssh_port")

    @property
    @pulumi.getter(name="adminPublicKey")
    def admin_public_key(self) -> Optional[str]:
        """
        Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
        """
        return pulumi.get(self, "admin_public_key")

    @property
    @pulumi.getter(name="sshPublicAccess")
    def ssh_public_access(self) -> Optional[str]:
        """
        State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
        """
        return pulumi.get(self, "ssh_public_access")


@pulumi.output_type
class ComputeInstanceVersionResponse(dict):
    """
    Version of computeInstance.
    """
    def __init__(__self__, *,
                 runtime: Optional[str] = None):
        """
        Version of computeInstance.
        :param str runtime: Runtime of compute instance.
        """
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[str]:
        """
        Runtime of compute instance.
        """
        return pulumi.get(self, "runtime")


@pulumi.output_type
class ComputeSchedulesResponse(dict):
    """
    The list of schedules to be applied on the computes
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeStartStop":
            suggest = "compute_start_stop"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeSchedulesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeSchedulesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeSchedulesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_start_stop: Optional[Sequence['outputs.ComputeStartStopScheduleResponse']] = None):
        """
        The list of schedules to be applied on the computes
        :param Sequence['ComputeStartStopScheduleResponse'] compute_start_stop: The list of compute start stop schedules to be applied.
        """
        if compute_start_stop is not None:
            pulumi.set(__self__, "compute_start_stop", compute_start_stop)

    @property
    @pulumi.getter(name="computeStartStop")
    def compute_start_stop(self) -> Optional[Sequence['outputs.ComputeStartStopScheduleResponse']]:
        """
        The list of compute start stop schedules to be applied.
        """
        return pulumi.get(self, "compute_start_stop")


@pulumi.output_type
class ComputeStartStopScheduleResponse(dict):
    """
    Compute start stop schedule properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningStatus":
            suggest = "provisioning_status"
        elif key == "triggerType":
            suggest = "trigger_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeStartStopScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeStartStopScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeStartStopScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 provisioning_status: str,
                 action: Optional[str] = None,
                 cron: Optional['outputs.CronTriggerResponse'] = None,
                 recurrence: Optional['outputs.RecurrenceTriggerResponse'] = None,
                 schedule: Optional['outputs.ScheduleBaseResponse'] = None,
                 status: Optional[str] = None,
                 trigger_type: Optional[str] = None):
        """
        Compute start stop schedule properties
        :param str id: A system assigned id for the schedule.
        :param str provisioning_status: The current deployment state of schedule.
        :param str action: [Required] The compute power action.
        :param 'CronTriggerResponse' cron: Required if triggerType is Cron.
        :param 'RecurrenceTriggerResponse' recurrence: Required if triggerType is Recurrence.
        :param 'ScheduleBaseResponse' schedule: [Deprecated] Not used any more.
        :param str status: Is the schedule enabled or disabled?
        :param str trigger_type: [Required] The schedule trigger type.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "provisioning_status", provisioning_status)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if cron is not None:
            pulumi.set(__self__, "cron", cron)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if trigger_type is not None:
            pulumi.set(__self__, "trigger_type", trigger_type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A system assigned id for the schedule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> str:
        """
        The current deployment state of schedule.
        """
        return pulumi.get(self, "provisioning_status")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        [Required] The compute power action.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def cron(self) -> Optional['outputs.CronTriggerResponse']:
        """
        Required if triggerType is Cron.
        """
        return pulumi.get(self, "cron")

    @property
    @pulumi.getter
    def recurrence(self) -> Optional['outputs.RecurrenceTriggerResponse']:
        """
        Required if triggerType is Recurrence.
        """
        return pulumi.get(self, "recurrence")

    @property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.ScheduleBaseResponse']:
        """
        [Deprecated] Not used any more.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Is the schedule enabled or disabled?
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> Optional[str]:
        """
        [Required] The schedule trigger type.
        """
        return pulumi.get(self, "trigger_type")


@pulumi.output_type
class ContainerResourceRequirementsResponse(dict):
    """
    Resource requirements for each container instance within an online deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerResourceLimits":
            suggest = "container_resource_limits"
        elif key == "containerResourceRequests":
            suggest = "container_resource_requests"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerResourceRequirementsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerResourceRequirementsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerResourceRequirementsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_resource_limits: Optional['outputs.ContainerResourceSettingsResponse'] = None,
                 container_resource_requests: Optional['outputs.ContainerResourceSettingsResponse'] = None):
        """
        Resource requirements for each container instance within an online deployment.
        :param 'ContainerResourceSettingsResponse' container_resource_limits: Container resource limit info:
        :param 'ContainerResourceSettingsResponse' container_resource_requests: Container resource request info:
        """
        if container_resource_limits is not None:
            pulumi.set(__self__, "container_resource_limits", container_resource_limits)
        if container_resource_requests is not None:
            pulumi.set(__self__, "container_resource_requests", container_resource_requests)

    @property
    @pulumi.getter(name="containerResourceLimits")
    def container_resource_limits(self) -> Optional['outputs.ContainerResourceSettingsResponse']:
        """
        Container resource limit info:
        """
        return pulumi.get(self, "container_resource_limits")

    @property
    @pulumi.getter(name="containerResourceRequests")
    def container_resource_requests(self) -> Optional['outputs.ContainerResourceSettingsResponse']:
        """
        Container resource request info:
        """
        return pulumi.get(self, "container_resource_requests")


@pulumi.output_type
class ContainerResourceSettingsResponse(dict):
    def __init__(__self__, *,
                 cpu: Optional[str] = None,
                 gpu: Optional[str] = None,
                 memory: Optional[str] = None):
        """
        :param str cpu: Number of vCPUs request/limit for container. More info:
               https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        :param str gpu: Number of Nvidia GPU cards request/limit for container. More info:
               https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        :param str memory: Memory size request/limit for container. More info:
               https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[str]:
        """
        Number of vCPUs request/limit for container. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def gpu(self) -> Optional[str]:
        """
        Number of Nvidia GPU cards request/limit for container. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        return pulumi.get(self, "gpu")

    @property
    @pulumi.getter
    def memory(self) -> Optional[str]:
        """
        Memory size request/limit for container. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class CosmosDbSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collectionsThroughput":
            suggest = "collections_throughput"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CosmosDbSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CosmosDbSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CosmosDbSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collections_throughput: Optional[int] = None):
        """
        :param int collections_throughput: The throughput of the collections in cosmosdb database
        """
        if collections_throughput is not None:
            pulumi.set(__self__, "collections_throughput", collections_throughput)

    @property
    @pulumi.getter(name="collectionsThroughput")
    def collections_throughput(self) -> Optional[int]:
        """
        The throughput of the collections in cosmosdb database
        """
        return pulumi.get(self, "collections_throughput")


@pulumi.output_type
class CronTriggerResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "triggerType":
            suggest = "trigger_type"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CronTriggerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CronTriggerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CronTriggerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expression: str,
                 trigger_type: str,
                 end_time: Optional[str] = None,
                 start_time: Optional[str] = None,
                 time_zone: Optional[str] = None):
        """
        :param str expression: [Required] Specifies cron expression of schedule.
               The expression should follow NCronTab format.
        :param str trigger_type: 
               Expected value is 'Cron'.
        :param str end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601.
               Recommented format would be "2022-06-01T00:00:01"
               If not present, the schedule will run indefinitely
        :param str start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC offset.
        :param str time_zone: Specifies time zone in which the schedule runs.
               TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "trigger_type", 'Cron')
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is None:
            time_zone = 'UTC'
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        [Required] Specifies cron expression of schedule.
        The expression should follow NCronTab format.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> str:
        """

        Expected value is 'Cron'.
        """
        return pulumi.get(self, "trigger_type")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601.
        Recommented format would be "2022-06-01T00:00:01"
        If not present, the schedule will run indefinitely
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Specifies start time of schedule in ISO 8601 format, but without a UTC offset.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        Specifies time zone in which the schedule runs.
        TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class CustomForecastHorizonResponse(dict):
    """
    The desired maximum forecast horizon in units of time-series frequency.
    """
    def __init__(__self__, *,
                 mode: str,
                 value: int):
        """
        The desired maximum forecast horizon in units of time-series frequency.
        :param str mode: Enum to determine forecast horizon selection mode.
               Expected value is 'Custom'.
        :param int value: [Required] Forecast horizon value.
        """
        pulumi.set(__self__, "mode", 'Custom')
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Enum to determine forecast horizon selection mode.
        Expected value is 'Custom'.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> int:
        """
        [Required] Forecast horizon value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CustomModelJobInputResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobInputType":
            suggest = "job_input_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomModelJobInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomModelJobInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomModelJobInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_input_type: str,
                 uri: str,
                 description: Optional[str] = None,
                 mode: Optional[str] = None):
        """
        :param str job_input_type: Enum to determine the Job Input Type.
               Expected value is 'custom_model'.
        :param str uri: [Required] Input Asset URI.
        :param str description: Description for the input.
        :param str mode: Input Asset Delivery Mode.
        """
        pulumi.set(__self__, "job_input_type", 'custom_model')
        pulumi.set(__self__, "uri", uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadOnlyMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="jobInputType")
    def job_input_type(self) -> str:
        """
        Enum to determine the Job Input Type.
        Expected value is 'custom_model'.
        """
        return pulumi.get(self, "job_input_type")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        [Required] Input Asset URI.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description for the input.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Input Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class CustomModelJobOutputResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobOutputType":
            suggest = "job_output_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomModelJobOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomModelJobOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomModelJobOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_output_type: str,
                 description: Optional[str] = None,
                 mode: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param str job_output_type: Enum to determine the Job Output Type.
               Expected value is 'custom_model'.
        :param str description: Description for the output.
        :param str mode: Output Asset Delivery Mode.
        :param str uri: Output Asset URI.
        """
        pulumi.set(__self__, "job_output_type", 'custom_model')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadWriteMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="jobOutputType")
    def job_output_type(self) -> str:
        """
        Enum to determine the Job Output Type.
        Expected value is 'custom_model'.
        """
        return pulumi.get(self, "job_output_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description for the output.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Output Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Output Asset URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class CustomNCrossValidationsResponse(dict):
    """
    N-Cross validations are specified by user.
    """
    def __init__(__self__, *,
                 mode: str,
                 value: int):
        """
        N-Cross validations are specified by user.
        :param str mode: Determines how N-Cross validations value is determined.
               Expected value is 'Custom'.
        :param int value: [Required] N-Cross validations value.
        """
        pulumi.set(__self__, "mode", 'Custom')
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Determines how N-Cross validations value is determined.
        Expected value is 'Custom'.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> int:
        """
        [Required] N-Cross validations value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CustomSeasonalityResponse(dict):
    def __init__(__self__, *,
                 mode: str,
                 value: int):
        """
        :param str mode: Forecasting seasonality mode.
               Expected value is 'Custom'.
        :param int value: [Required] Seasonality value.
        """
        pulumi.set(__self__, "mode", 'Custom')
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Forecasting seasonality mode.
        Expected value is 'Custom'.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> int:
        """
        [Required] Seasonality value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CustomTargetLagsResponse(dict):
    def __init__(__self__, *,
                 mode: str,
                 values: Sequence[int]):
        """
        :param str mode: Target lags selection modes.
               Expected value is 'Custom'.
        :param Sequence[int] values: [Required] Set target lags values.
        """
        pulumi.set(__self__, "mode", 'Custom')
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Target lags selection modes.
        Expected value is 'Custom'.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def values(self) -> Sequence[int]:
        """
        [Required] Set target lags values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class CustomTargetRollingWindowSizeResponse(dict):
    def __init__(__self__, *,
                 mode: str,
                 value: int):
        """
        :param str mode: Target rolling windows size mode.
               Expected value is 'Custom'.
        :param int value: [Required] TargetRollingWindowSize value.
        """
        pulumi.set(__self__, "mode", 'Custom')
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Target rolling windows size mode.
        Expected value is 'Custom'.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> int:
        """
        [Required] TargetRollingWindowSize value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DataContainerResponse(dict):
    """
    Container for data asset versions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "latestVersion":
            suggest = "latest_version"
        elif key == "nextVersion":
            suggest = "next_version"
        elif key == "isArchived":
            suggest = "is_archived"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_type: str,
                 latest_version: str,
                 next_version: str,
                 description: Optional[str] = None,
                 is_archived: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Container for data asset versions.
        :param str data_type: [Required] Specifies the type of data.
        :param str latest_version: The latest version inside this container.
        :param str next_version: The next auto incremental version
        :param str description: The asset description text.
        :param bool is_archived: Is the asset archived?
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "latest_version", latest_version)
        pulumi.set(__self__, "next_version", next_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> str:
        """
        [Required] Specifies the type of data.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> str:
        """
        The latest version inside this container.
        """
        return pulumi.get(self, "latest_version")

    @property
    @pulumi.getter(name="nextVersion")
    def next_version(self) -> str:
        """
        The next auto incremental version
        """
        return pulumi.get(self, "next_version")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[bool]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class DataFactoryResponse(dict):
    """
    A DataFactory compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataFactoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataFactoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataFactoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 resource_id: Optional[str] = None):
        """
        A DataFactory compute.
        :param str compute_type: The type of compute
               Expected value is 'DataFactory'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'DataFactory')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'DataFactory'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class DataLakeAnalyticsResponse(dict):
    """
    A DataLakeAnalytics compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLakeAnalyticsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLakeAnalyticsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLakeAnalyticsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 properties: Optional['outputs.DataLakeAnalyticsSchemaResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A DataLakeAnalytics compute.
        :param str compute_type: The type of compute
               Expected value is 'DataLakeAnalytics'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'DataLakeAnalytics')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'DataLakeAnalytics'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.DataLakeAnalyticsSchemaResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class DataLakeAnalyticsSchemaResponseProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataLakeStoreAccountName":
            suggest = "data_lake_store_account_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLakeAnalyticsSchemaResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLakeAnalyticsSchemaResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLakeAnalyticsSchemaResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_lake_store_account_name: Optional[str] = None):
        """
        :param str data_lake_store_account_name: DataLake Store Account Name
        """
        if data_lake_store_account_name is not None:
            pulumi.set(__self__, "data_lake_store_account_name", data_lake_store_account_name)

    @property
    @pulumi.getter(name="dataLakeStoreAccountName")
    def data_lake_store_account_name(self) -> Optional[str]:
        """
        DataLake Store Account Name
        """
        return pulumi.get(self, "data_lake_store_account_name")


@pulumi.output_type
class DataPathAssetReferenceResponse(dict):
    """
    Reference to an asset via its path in a datastore.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referenceType":
            suggest = "reference_type"
        elif key == "datastoreId":
            suggest = "datastore_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataPathAssetReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataPathAssetReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataPathAssetReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reference_type: str,
                 datastore_id: Optional[str] = None,
                 path: Optional[str] = None):
        """
        Reference to an asset via its path in a datastore.
        :param str reference_type: Enum to determine which reference method to use for an asset.
               Expected value is 'DataPath'.
        :param str datastore_id: ARM resource ID of the datastore where the asset is located.
        :param str path: The path of the file/directory in the datastore.
        """
        pulumi.set(__self__, "reference_type", 'DataPath')
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="referenceType")
    def reference_type(self) -> str:
        """
        Enum to determine which reference method to use for an asset.
        Expected value is 'DataPath'.
        """
        return pulumi.get(self, "reference_type")

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[str]:
        """
        ARM resource ID of the datastore where the asset is located.
        """
        return pulumi.get(self, "datastore_id")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path of the file/directory in the datastore.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class DatabricksPropertiesResponse(dict):
    """
    Properties of Databricks
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databricksAccessToken":
            suggest = "databricks_access_token"
        elif key == "workspaceUrl":
            suggest = "workspace_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabricksPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabricksPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabricksPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 databricks_access_token: Optional[str] = None,
                 workspace_url: Optional[str] = None):
        """
        Properties of Databricks
        :param str databricks_access_token: Databricks access token
        :param str workspace_url: Workspace Url
        """
        if databricks_access_token is not None:
            pulumi.set(__self__, "databricks_access_token", databricks_access_token)
        if workspace_url is not None:
            pulumi.set(__self__, "workspace_url", workspace_url)

    @property
    @pulumi.getter(name="databricksAccessToken")
    def databricks_access_token(self) -> Optional[str]:
        """
        Databricks access token
        """
        return pulumi.get(self, "databricks_access_token")

    @property
    @pulumi.getter(name="workspaceUrl")
    def workspace_url(self) -> Optional[str]:
        """
        Workspace Url
        """
        return pulumi.get(self, "workspace_url")


@pulumi.output_type
class DatabricksResponse(dict):
    """
    A DataFactory compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabricksResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabricksResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabricksResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 properties: Optional['outputs.DatabricksPropertiesResponse'] = None,
                 resource_id: Optional[str] = None):
        """
        A DataFactory compute.
        :param str compute_type: The type of compute
               Expected value is 'Databricks'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param 'DatabricksPropertiesResponse' properties: Properties of Databricks
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'Databricks')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'Databricks'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.DatabricksPropertiesResponse']:
        """
        Properties of Databricks
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class DefaultScaleSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scaleType":
            suggest = "scale_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefaultScaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefaultScaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefaultScaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scale_type: str):
        """
        :param str scale_type: 
               Expected value is 'Default'.
        """
        pulumi.set(__self__, "scale_type", 'Default')

    @property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> str:
        """

        Expected value is 'Default'.
        """
        return pulumi.get(self, "scale_type")


@pulumi.output_type
class DeploymentResourceConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceType":
            suggest = "instance_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentResourceConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentResourceConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentResourceConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: Optional[int] = None,
                 instance_type: Optional[str] = None,
                 properties: Optional[Mapping[str, Any]] = None):
        """
        :param int instance_count: Optional number of instances or nodes used by the compute target.
        :param str instance_type: Optional type of VM used as supported by the compute target.
        :param Mapping[str, Any] properties: Additional properties bag.
        """
        if instance_count is None:
            instance_count = 1
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        Optional number of instances or nodes used by the compute target.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        Optional type of VM used as supported by the compute target.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, Any]]:
        """
        Additional properties bag.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class EncryptionKeyVaultPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyIdentifier":
            suggest = "key_identifier"
        elif key == "keyVaultArmId":
            suggest = "key_vault_arm_id"
        elif key == "identityClientId":
            suggest = "identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionKeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionKeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionKeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_identifier: str,
                 key_vault_arm_id: str,
                 identity_client_id: Optional[str] = None):
        """
        :param str key_identifier: Key vault uri to access the encryption key.
        :param str key_vault_arm_id: The ArmId of the keyVault where the customer owned encryption key is present.
        :param str identity_client_id: For future use - The client id of the identity which will be used to access key vault.
        """
        pulumi.set(__self__, "key_identifier", key_identifier)
        pulumi.set(__self__, "key_vault_arm_id", key_vault_arm_id)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> str:
        """
        Key vault uri to access the encryption key.
        """
        return pulumi.get(self, "key_identifier")

    @property
    @pulumi.getter(name="keyVaultArmId")
    def key_vault_arm_id(self) -> str:
        """
        The ArmId of the keyVault where the customer owned encryption key is present.
        """
        return pulumi.get(self, "key_vault_arm_id")

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[str]:
        """
        For future use - The client id of the identity which will be used to access key vault.
        """
        return pulumi.get(self, "identity_client_id")


@pulumi.output_type
class EncryptionPropertyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionPropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionPropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionPropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_vault_properties: 'outputs.EncryptionKeyVaultPropertiesResponse',
                 status: str,
                 identity: Optional['outputs.IdentityForCmkResponse'] = None):
        """
        :param 'EncryptionKeyVaultPropertiesResponse' key_vault_properties: Customer Key vault properties.
        :param str status: Indicates whether or not the encryption is enabled for the workspace.
        :param 'IdentityForCmkResponse' identity: The identity that will be used to access the key vault for encryption at rest.
        """
        pulumi.set(__self__, "key_vault_properties", key_vault_properties)
        pulumi.set(__self__, "status", status)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> 'outputs.EncryptionKeyVaultPropertiesResponse':
        """
        Customer Key vault properties.
        """
        return pulumi.get(self, "key_vault_properties")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates whether or not the encryption is enabled for the workspace.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.IdentityForCmkResponse']:
        """
        The identity that will be used to access the key vault for encryption at rest.
        """
        return pulumi.get(self, "identity")


@pulumi.output_type
class EndpointScheduleActionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionType":
            suggest = "action_type"
        elif key == "endpointInvocationDefinition":
            suggest = "endpoint_invocation_definition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointScheduleActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointScheduleActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointScheduleActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_type: str,
                 endpoint_invocation_definition: Any):
        """
        :param str action_type: 
               Expected value is 'InvokeBatchEndpoint'.
        :param Any endpoint_invocation_definition: [Required] Defines Schedule action definition details.
               <see href="TBD" />
        """
        pulumi.set(__self__, "action_type", 'InvokeBatchEndpoint')
        pulumi.set(__self__, "endpoint_invocation_definition", endpoint_invocation_definition)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """

        Expected value is 'InvokeBatchEndpoint'.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter(name="endpointInvocationDefinition")
    def endpoint_invocation_definition(self) -> Any:
        """
        [Required] Defines Schedule action definition details.
        <see href="TBD" />
        """
        return pulumi.get(self, "endpoint_invocation_definition")


@pulumi.output_type
class EnvironmentContainerResponse(dict):
    """
    Container for environment specification versions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latestVersion":
            suggest = "latest_version"
        elif key == "nextVersion":
            suggest = "next_version"
        elif key == "isArchived":
            suggest = "is_archived"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 latest_version: str,
                 next_version: str,
                 description: Optional[str] = None,
                 is_archived: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Container for environment specification versions.
        :param str latest_version: The latest version inside this container.
        :param str next_version: The next auto incremental version
        :param str description: The asset description text.
        :param bool is_archived: Is the asset archived?
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "latest_version", latest_version)
        pulumi.set(__self__, "next_version", next_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> str:
        """
        The latest version inside this container.
        """
        return pulumi.get(self, "latest_version")

    @property
    @pulumi.getter(name="nextVersion")
    def next_version(self) -> str:
        """
        The next auto incremental version
        """
        return pulumi.get(self, "next_version")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[bool]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class EnvironmentVersionResponse(dict):
    """
    Environment version details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentType":
            suggest = "environment_type"
        elif key == "autoRebuild":
            suggest = "auto_rebuild"
        elif key == "condaFile":
            suggest = "conda_file"
        elif key == "inferenceConfig":
            suggest = "inference_config"
        elif key == "isAnonymous":
            suggest = "is_anonymous"
        elif key == "isArchived":
            suggest = "is_archived"
        elif key == "osType":
            suggest = "os_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 environment_type: str,
                 auto_rebuild: Optional[str] = None,
                 build: Optional['outputs.BuildContextResponse'] = None,
                 conda_file: Optional[str] = None,
                 description: Optional[str] = None,
                 image: Optional[str] = None,
                 inference_config: Optional['outputs.InferenceContainerPropertiesResponse'] = None,
                 is_anonymous: Optional[bool] = None,
                 is_archived: Optional[bool] = None,
                 os_type: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Environment version details.
        :param str environment_type: Environment type is either user managed or curated by the Azure ML service
               <see href="https://docs.microsoft.com/en-us/azure/machine-learning/resource-curated-environments" />
        :param str auto_rebuild: Defines if image needs to be rebuilt based on base image changes.
        :param 'BuildContextResponse' build: Configuration settings for Docker build context.
        :param str conda_file: Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
               <see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" />
        :param str description: The asset description text.
        :param str image: Name of the image that will be used for the environment.
               <seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" />
        :param 'InferenceContainerPropertiesResponse' inference_config: Defines configuration specific to inference.
        :param bool is_anonymous: If the name version are system generated (anonymous registration).
        :param bool is_archived: Is the asset archived?
        :param str os_type: The OS type of the environment.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "environment_type", environment_type)
        if auto_rebuild is None:
            auto_rebuild = 'Disabled'
        if auto_rebuild is not None:
            pulumi.set(__self__, "auto_rebuild", auto_rebuild)
        if build is not None:
            pulumi.set(__self__, "build", build)
        if conda_file is not None:
            pulumi.set(__self__, "conda_file", conda_file)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if inference_config is not None:
            pulumi.set(__self__, "inference_config", inference_config)
        if is_anonymous is None:
            is_anonymous = False
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if os_type is None:
            os_type = 'Linux'
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> str:
        """
        Environment type is either user managed or curated by the Azure ML service
        <see href="https://docs.microsoft.com/en-us/azure/machine-learning/resource-curated-environments" />
        """
        return pulumi.get(self, "environment_type")

    @property
    @pulumi.getter(name="autoRebuild")
    def auto_rebuild(self) -> Optional[str]:
        """
        Defines if image needs to be rebuilt based on base image changes.
        """
        return pulumi.get(self, "auto_rebuild")

    @property
    @pulumi.getter
    def build(self) -> Optional['outputs.BuildContextResponse']:
        """
        Configuration settings for Docker build context.
        """
        return pulumi.get(self, "build")

    @property
    @pulumi.getter(name="condaFile")
    def conda_file(self) -> Optional[str]:
        """
        Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
        <see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" />
        """
        return pulumi.get(self, "conda_file")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Name of the image that will be used for the environment.
        <seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" />
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="inferenceConfig")
    def inference_config(self) -> Optional['outputs.InferenceContainerPropertiesResponse']:
        """
        Defines configuration specific to inference.
        """
        return pulumi.get(self, "inference_config")

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[bool]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[bool]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        The OS type of the environment.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ErrorAdditionalInfoResponse(dict):
    """
    The resource management error additional info.
    """
    def __init__(__self__, *,
                 info: Any,
                 type: str):
        """
        The resource management error additional info.
        :param Any info: The additional info.
        :param str type: The additional info type.
        """
        pulumi.set(__self__, "info", info)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def info(self) -> Any:
        """
        The additional info.
        """
        return pulumi.get(self, "info")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The additional info type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ErrorDetailResponse(dict):
    """
    The error detail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalInfo":
            suggest = "additional_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ErrorDetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ErrorDetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ErrorDetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_info: Sequence['outputs.ErrorAdditionalInfoResponse'],
                 code: str,
                 details: Sequence['outputs.ErrorDetailResponse'],
                 message: str,
                 target: str):
        """
        The error detail.
        :param Sequence['ErrorAdditionalInfoResponse'] additional_info: The error additional info.
        :param str code: The error code.
        :param Sequence['ErrorDetailResponse'] details: The error details.
        :param str message: The error message.
        :param str target: The error target.
        """
        pulumi.set(__self__, "additional_info", additional_info)
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="additionalInfo")
    def additional_info(self) -> Sequence['outputs.ErrorAdditionalInfoResponse']:
        """
        The error additional info.
        """
        return pulumi.get(self, "additional_info")

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.ErrorDetailResponse']:
        """
        The error details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        The error target.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ErrorResponseResponse(dict):
    """
    Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).
    """
    def __init__(__self__, *,
                 error: Optional['outputs.ErrorDetailResponse'] = None):
        """
        Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).
        :param 'ErrorDetailResponse' error: The error object.
        """
        if error is not None:
            pulumi.set(__self__, "error", error)

    @property
    @pulumi.getter
    def error(self) -> Optional['outputs.ErrorDetailResponse']:
        """
        The error object.
        """
        return pulumi.get(self, "error")


@pulumi.output_type
class FlavorDataResponse(dict):
    def __init__(__self__, *,
                 data: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] data: Model flavor-specific data.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, str]]:
        """
        Model flavor-specific data.
        """
        return pulumi.get(self, "data")


@pulumi.output_type
class ForecastingResponse(dict):
    """
    Forecasting task in AutoML Table vertical.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"
        elif key == "trainingData":
            suggest = "training_data"
        elif key == "cvSplitColumnNames":
            suggest = "cv_split_column_names"
        elif key == "featurizationSettings":
            suggest = "featurization_settings"
        elif key == "forecastingSettings":
            suggest = "forecasting_settings"
        elif key == "limitSettings":
            suggest = "limit_settings"
        elif key == "logVerbosity":
            suggest = "log_verbosity"
        elif key == "nCrossValidations":
            suggest = "n_cross_validations"
        elif key == "primaryMetric":
            suggest = "primary_metric"
        elif key == "targetColumnName":
            suggest = "target_column_name"
        elif key == "testData":
            suggest = "test_data"
        elif key == "testDataSize":
            suggest = "test_data_size"
        elif key == "trainingSettings":
            suggest = "training_settings"
        elif key == "validationData":
            suggest = "validation_data"
        elif key == "validationDataSize":
            suggest = "validation_data_size"
        elif key == "weightColumnName":
            suggest = "weight_column_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ForecastingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ForecastingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ForecastingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_type: str,
                 training_data: 'outputs.MLTableJobInputResponse',
                 cv_split_column_names: Optional[Sequence[str]] = None,
                 featurization_settings: Optional['outputs.TableVerticalFeaturizationSettingsResponse'] = None,
                 forecasting_settings: Optional['outputs.ForecastingSettingsResponse'] = None,
                 limit_settings: Optional['outputs.TableVerticalLimitSettingsResponse'] = None,
                 log_verbosity: Optional[str] = None,
                 n_cross_validations: Optional[Any] = None,
                 primary_metric: Optional[str] = None,
                 target_column_name: Optional[str] = None,
                 test_data: Optional['outputs.MLTableJobInputResponse'] = None,
                 test_data_size: Optional[float] = None,
                 training_settings: Optional['outputs.ForecastingTrainingSettingsResponse'] = None,
                 validation_data: Optional['outputs.MLTableJobInputResponse'] = None,
                 validation_data_size: Optional[float] = None,
                 weight_column_name: Optional[str] = None):
        """
        Forecasting task in AutoML Table vertical.
        :param str task_type: AutoMLJob Task type.
               Expected value is 'Forecasting'.
        :param 'MLTableJobInputResponse' training_data: [Required] Training data input.
        :param Sequence[str] cv_split_column_names: Columns to use for CVSplit data.
        :param 'TableVerticalFeaturizationSettingsResponse' featurization_settings: Featurization inputs needed for AutoML job.
        :param 'ForecastingSettingsResponse' forecasting_settings: Forecasting task specific inputs.
        :param 'TableVerticalLimitSettingsResponse' limit_settings: Execution constraints for AutoMLJob.
        :param str log_verbosity: Log verbosity for the job.
        :param Union['AutoNCrossValidationsResponse', 'CustomNCrossValidationsResponse'] n_cross_validations: Number of cross validation folds to be applied on training dataset
               when validation dataset is not provided.
        :param str primary_metric: Primary metric for forecasting task.
        :param str target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param 'MLTableJobInputResponse' test_data: Test data input.
        :param float test_data_size: The fraction of test dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        :param 'ForecastingTrainingSettingsResponse' training_settings: Inputs for training phase for an AutoML Job.
        :param 'MLTableJobInputResponse' validation_data: Validation data inputs.
        :param float validation_data_size: The fraction of training dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        :param str weight_column_name: The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
        """
        pulumi.set(__self__, "task_type", 'Forecasting')
        pulumi.set(__self__, "training_data", training_data)
        if cv_split_column_names is not None:
            pulumi.set(__self__, "cv_split_column_names", cv_split_column_names)
        if featurization_settings is not None:
            pulumi.set(__self__, "featurization_settings", featurization_settings)
        if forecasting_settings is not None:
            pulumi.set(__self__, "forecasting_settings", forecasting_settings)
        if limit_settings is not None:
            pulumi.set(__self__, "limit_settings", limit_settings)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if n_cross_validations is not None:
            pulumi.set(__self__, "n_cross_validations", n_cross_validations)
        if primary_metric is None:
            primary_metric = 'NormalizedRootMeanSquaredError'
        if primary_metric is not None:
            pulumi.set(__self__, "primary_metric", primary_metric)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if test_data is not None:
            pulumi.set(__self__, "test_data", test_data)
        if test_data_size is not None:
            pulumi.set(__self__, "test_data_size", test_data_size)
        if training_settings is not None:
            pulumi.set(__self__, "training_settings", training_settings)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)
        if validation_data_size is not None:
            pulumi.set(__self__, "validation_data_size", validation_data_size)
        if weight_column_name is not None:
            pulumi.set(__self__, "weight_column_name", weight_column_name)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        AutoMLJob Task type.
        Expected value is 'Forecasting'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> 'outputs.MLTableJobInputResponse':
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @property
    @pulumi.getter(name="cvSplitColumnNames")
    def cv_split_column_names(self) -> Optional[Sequence[str]]:
        """
        Columns to use for CVSplit data.
        """
        return pulumi.get(self, "cv_split_column_names")

    @property
    @pulumi.getter(name="featurizationSettings")
    def featurization_settings(self) -> Optional['outputs.TableVerticalFeaturizationSettingsResponse']:
        """
        Featurization inputs needed for AutoML job.
        """
        return pulumi.get(self, "featurization_settings")

    @property
    @pulumi.getter(name="forecastingSettings")
    def forecasting_settings(self) -> Optional['outputs.ForecastingSettingsResponse']:
        """
        Forecasting task specific inputs.
        """
        return pulumi.get(self, "forecasting_settings")

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> Optional['outputs.TableVerticalLimitSettingsResponse']:
        """
        Execution constraints for AutoMLJob.
        """
        return pulumi.get(self, "limit_settings")

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[str]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @property
    @pulumi.getter(name="nCrossValidations")
    def n_cross_validations(self) -> Optional[Any]:
        """
        Number of cross validation folds to be applied on training dataset
        when validation dataset is not provided.
        """
        return pulumi.get(self, "n_cross_validations")

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> Optional[str]:
        """
        Primary metric for forecasting task.
        """
        return pulumi.get(self, "primary_metric")

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[str]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @property
    @pulumi.getter(name="testData")
    def test_data(self) -> Optional['outputs.MLTableJobInputResponse']:
        """
        Test data input.
        """
        return pulumi.get(self, "test_data")

    @property
    @pulumi.getter(name="testDataSize")
    def test_data_size(self) -> Optional[float]:
        """
        The fraction of test dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "test_data_size")

    @property
    @pulumi.getter(name="trainingSettings")
    def training_settings(self) -> Optional['outputs.ForecastingTrainingSettingsResponse']:
        """
        Inputs for training phase for an AutoML Job.
        """
        return pulumi.get(self, "training_settings")

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional['outputs.MLTableJobInputResponse']:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")

    @property
    @pulumi.getter(name="validationDataSize")
    def validation_data_size(self) -> Optional[float]:
        """
        The fraction of training dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "validation_data_size")

    @property
    @pulumi.getter(name="weightColumnName")
    def weight_column_name(self) -> Optional[str]:
        """
        The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
        """
        return pulumi.get(self, "weight_column_name")


@pulumi.output_type
class ForecastingSettingsResponse(dict):
    """
    Forecasting specific parameters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countryOrRegionForHolidays":
            suggest = "country_or_region_for_holidays"
        elif key == "cvStepSize":
            suggest = "cv_step_size"
        elif key == "featureLags":
            suggest = "feature_lags"
        elif key == "forecastHorizon":
            suggest = "forecast_horizon"
        elif key == "shortSeriesHandlingConfig":
            suggest = "short_series_handling_config"
        elif key == "targetAggregateFunction":
            suggest = "target_aggregate_function"
        elif key == "targetLags":
            suggest = "target_lags"
        elif key == "targetRollingWindowSize":
            suggest = "target_rolling_window_size"
        elif key == "timeColumnName":
            suggest = "time_column_name"
        elif key == "timeSeriesIdColumnNames":
            suggest = "time_series_id_column_names"
        elif key == "useStl":
            suggest = "use_stl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ForecastingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ForecastingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ForecastingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 country_or_region_for_holidays: Optional[str] = None,
                 cv_step_size: Optional[int] = None,
                 feature_lags: Optional[str] = None,
                 forecast_horizon: Optional[Any] = None,
                 frequency: Optional[str] = None,
                 seasonality: Optional[Any] = None,
                 short_series_handling_config: Optional[str] = None,
                 target_aggregate_function: Optional[str] = None,
                 target_lags: Optional[Any] = None,
                 target_rolling_window_size: Optional[Any] = None,
                 time_column_name: Optional[str] = None,
                 time_series_id_column_names: Optional[Sequence[str]] = None,
                 use_stl: Optional[str] = None):
        """
        Forecasting specific parameters.
        :param str country_or_region_for_holidays: Country or region for holidays for forecasting tasks.
               These should be ISO 3166 two-letter country/region codes, for example 'US' or 'GB'.
        :param int cv_step_size: Number of periods between the origin time of one CV fold and the next fold. For
               example, if `CVStepSize` = 3 for daily data, the origin time for each fold will be
               three days apart.
        :param str feature_lags: Flag for generating lags for the numeric features with 'auto' or null.
        :param Union['AutoForecastHorizonResponse', 'CustomForecastHorizonResponse'] forecast_horizon: The desired maximum forecast horizon in units of time-series frequency.
        :param str frequency: When forecasting, this parameter represents the period with which the forecast is desired, for example daily, weekly, yearly, etc. The forecast frequency is dataset frequency by default.
        :param Union['AutoSeasonalityResponse', 'CustomSeasonalityResponse'] seasonality: Set time series seasonality as an integer multiple of the series frequency.
               If seasonality is set to 'auto', it will be inferred.
        :param str short_series_handling_config: The parameter defining how if AutoML should handle short time series.
        :param str target_aggregate_function: The function to be used to aggregate the time series target column to conform to a user specified frequency.
               If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
        :param Union['AutoTargetLagsResponse', 'CustomTargetLagsResponse'] target_lags: The number of past periods to lag from the target column.
        :param Union['AutoTargetRollingWindowSizeResponse', 'CustomTargetRollingWindowSizeResponse'] target_rolling_window_size: The number of past periods used to create a rolling window average of the target column.
        :param str time_column_name: The name of the time column. This parameter is required when forecasting to specify the datetime column in the input data used for building the time series and inferring its frequency.
        :param Sequence[str] time_series_id_column_names: The names of columns used to group a timeseries. It can be used to create multiple series.
               If grain is not defined, the data set is assumed to be one time-series. This parameter is used with task type forecasting.
        :param str use_stl: Configure STL Decomposition of the time-series target column.
        """
        if country_or_region_for_holidays is not None:
            pulumi.set(__self__, "country_or_region_for_holidays", country_or_region_for_holidays)
        if cv_step_size is not None:
            pulumi.set(__self__, "cv_step_size", cv_step_size)
        if feature_lags is None:
            feature_lags = 'None'
        if feature_lags is not None:
            pulumi.set(__self__, "feature_lags", feature_lags)
        if forecast_horizon is not None:
            pulumi.set(__self__, "forecast_horizon", forecast_horizon)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if seasonality is not None:
            pulumi.set(__self__, "seasonality", seasonality)
        if short_series_handling_config is None:
            short_series_handling_config = 'Auto'
        if short_series_handling_config is not None:
            pulumi.set(__self__, "short_series_handling_config", short_series_handling_config)
        if target_aggregate_function is None:
            target_aggregate_function = 'None'
        if target_aggregate_function is not None:
            pulumi.set(__self__, "target_aggregate_function", target_aggregate_function)
        if target_lags is not None:
            pulumi.set(__self__, "target_lags", target_lags)
        if target_rolling_window_size is not None:
            pulumi.set(__self__, "target_rolling_window_size", target_rolling_window_size)
        if time_column_name is not None:
            pulumi.set(__self__, "time_column_name", time_column_name)
        if time_series_id_column_names is not None:
            pulumi.set(__self__, "time_series_id_column_names", time_series_id_column_names)
        if use_stl is None:
            use_stl = 'None'
        if use_stl is not None:
            pulumi.set(__self__, "use_stl", use_stl)

    @property
    @pulumi.getter(name="countryOrRegionForHolidays")
    def country_or_region_for_holidays(self) -> Optional[str]:
        """
        Country or region for holidays for forecasting tasks.
        These should be ISO 3166 two-letter country/region codes, for example 'US' or 'GB'.
        """
        return pulumi.get(self, "country_or_region_for_holidays")

    @property
    @pulumi.getter(name="cvStepSize")
    def cv_step_size(self) -> Optional[int]:
        """
        Number of periods between the origin time of one CV fold and the next fold. For
        example, if `CVStepSize` = 3 for daily data, the origin time for each fold will be
        three days apart.
        """
        return pulumi.get(self, "cv_step_size")

    @property
    @pulumi.getter(name="featureLags")
    def feature_lags(self) -> Optional[str]:
        """
        Flag for generating lags for the numeric features with 'auto' or null.
        """
        return pulumi.get(self, "feature_lags")

    @property
    @pulumi.getter(name="forecastHorizon")
    def forecast_horizon(self) -> Optional[Any]:
        """
        The desired maximum forecast horizon in units of time-series frequency.
        """
        return pulumi.get(self, "forecast_horizon")

    @property
    @pulumi.getter
    def frequency(self) -> Optional[str]:
        """
        When forecasting, this parameter represents the period with which the forecast is desired, for example daily, weekly, yearly, etc. The forecast frequency is dataset frequency by default.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def seasonality(self) -> Optional[Any]:
        """
        Set time series seasonality as an integer multiple of the series frequency.
        If seasonality is set to 'auto', it will be inferred.
        """
        return pulumi.get(self, "seasonality")

    @property
    @pulumi.getter(name="shortSeriesHandlingConfig")
    def short_series_handling_config(self) -> Optional[str]:
        """
        The parameter defining how if AutoML should handle short time series.
        """
        return pulumi.get(self, "short_series_handling_config")

    @property
    @pulumi.getter(name="targetAggregateFunction")
    def target_aggregate_function(self) -> Optional[str]:
        """
        The function to be used to aggregate the time series target column to conform to a user specified frequency.
        If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
        """
        return pulumi.get(self, "target_aggregate_function")

    @property
    @pulumi.getter(name="targetLags")
    def target_lags(self) -> Optional[Any]:
        """
        The number of past periods to lag from the target column.
        """
        return pulumi.get(self, "target_lags")

    @property
    @pulumi.getter(name="targetRollingWindowSize")
    def target_rolling_window_size(self) -> Optional[Any]:
        """
        The number of past periods used to create a rolling window average of the target column.
        """
        return pulumi.get(self, "target_rolling_window_size")

    @property
    @pulumi.getter(name="timeColumnName")
    def time_column_name(self) -> Optional[str]:
        """
        The name of the time column. This parameter is required when forecasting to specify the datetime column in the input data used for building the time series and inferring its frequency.
        """
        return pulumi.get(self, "time_column_name")

    @property
    @pulumi.getter(name="timeSeriesIdColumnNames")
    def time_series_id_column_names(self) -> Optional[Sequence[str]]:
        """
        The names of columns used to group a timeseries. It can be used to create multiple series.
        If grain is not defined, the data set is assumed to be one time-series. This parameter is used with task type forecasting.
        """
        return pulumi.get(self, "time_series_id_column_names")

    @property
    @pulumi.getter(name="useStl")
    def use_stl(self) -> Optional[str]:
        """
        Configure STL Decomposition of the time-series target column.
        """
        return pulumi.get(self, "use_stl")


@pulumi.output_type
class ForecastingTrainingSettingsResponse(dict):
    """
    Forecasting Training related configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedTrainingAlgorithms":
            suggest = "allowed_training_algorithms"
        elif key == "blockedTrainingAlgorithms":
            suggest = "blocked_training_algorithms"
        elif key == "enableDnnTraining":
            suggest = "enable_dnn_training"
        elif key == "enableModelExplainability":
            suggest = "enable_model_explainability"
        elif key == "enableOnnxCompatibleModels":
            suggest = "enable_onnx_compatible_models"
        elif key == "enableStackEnsemble":
            suggest = "enable_stack_ensemble"
        elif key == "enableVoteEnsemble":
            suggest = "enable_vote_ensemble"
        elif key == "ensembleModelDownloadTimeout":
            suggest = "ensemble_model_download_timeout"
        elif key == "stackEnsembleSettings":
            suggest = "stack_ensemble_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ForecastingTrainingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ForecastingTrainingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ForecastingTrainingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_training_algorithms: Optional[Sequence[str]] = None,
                 blocked_training_algorithms: Optional[Sequence[str]] = None,
                 enable_dnn_training: Optional[bool] = None,
                 enable_model_explainability: Optional[bool] = None,
                 enable_onnx_compatible_models: Optional[bool] = None,
                 enable_stack_ensemble: Optional[bool] = None,
                 enable_vote_ensemble: Optional[bool] = None,
                 ensemble_model_download_timeout: Optional[str] = None,
                 stack_ensemble_settings: Optional['outputs.StackEnsembleSettingsResponse'] = None):
        """
        Forecasting Training related configuration.
        :param Sequence[str] allowed_training_algorithms: Allowed models for forecasting task.
        :param Sequence[str] blocked_training_algorithms: Blocked models for forecasting task.
        :param bool enable_dnn_training: Enable recommendation of DNN models.
        :param bool enable_model_explainability: Flag to turn on explainability on best model.
        :param bool enable_onnx_compatible_models: Flag for enabling onnx compatible models.
        :param bool enable_stack_ensemble: Enable stack ensemble run.
        :param bool enable_vote_ensemble: Enable voting ensemble run.
        :param str ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
               Configure this parameter with a higher value than 300 secs, if more time is needed.
        :param 'StackEnsembleSettingsResponse' stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
        """
        if allowed_training_algorithms is not None:
            pulumi.set(__self__, "allowed_training_algorithms", allowed_training_algorithms)
        if blocked_training_algorithms is not None:
            pulumi.set(__self__, "blocked_training_algorithms", blocked_training_algorithms)
        if enable_dnn_training is None:
            enable_dnn_training = False
        if enable_dnn_training is not None:
            pulumi.set(__self__, "enable_dnn_training", enable_dnn_training)
        if enable_model_explainability is None:
            enable_model_explainability = True
        if enable_model_explainability is not None:
            pulumi.set(__self__, "enable_model_explainability", enable_model_explainability)
        if enable_onnx_compatible_models is None:
            enable_onnx_compatible_models = False
        if enable_onnx_compatible_models is not None:
            pulumi.set(__self__, "enable_onnx_compatible_models", enable_onnx_compatible_models)
        if enable_stack_ensemble is None:
            enable_stack_ensemble = True
        if enable_stack_ensemble is not None:
            pulumi.set(__self__, "enable_stack_ensemble", enable_stack_ensemble)
        if enable_vote_ensemble is None:
            enable_vote_ensemble = True
        if enable_vote_ensemble is not None:
            pulumi.set(__self__, "enable_vote_ensemble", enable_vote_ensemble)
        if ensemble_model_download_timeout is None:
            ensemble_model_download_timeout = 'PT5M'
        if ensemble_model_download_timeout is not None:
            pulumi.set(__self__, "ensemble_model_download_timeout", ensemble_model_download_timeout)
        if stack_ensemble_settings is not None:
            pulumi.set(__self__, "stack_ensemble_settings", stack_ensemble_settings)

    @property
    @pulumi.getter(name="allowedTrainingAlgorithms")
    def allowed_training_algorithms(self) -> Optional[Sequence[str]]:
        """
        Allowed models for forecasting task.
        """
        return pulumi.get(self, "allowed_training_algorithms")

    @property
    @pulumi.getter(name="blockedTrainingAlgorithms")
    def blocked_training_algorithms(self) -> Optional[Sequence[str]]:
        """
        Blocked models for forecasting task.
        """
        return pulumi.get(self, "blocked_training_algorithms")

    @property
    @pulumi.getter(name="enableDnnTraining")
    def enable_dnn_training(self) -> Optional[bool]:
        """
        Enable recommendation of DNN models.
        """
        return pulumi.get(self, "enable_dnn_training")

    @property
    @pulumi.getter(name="enableModelExplainability")
    def enable_model_explainability(self) -> Optional[bool]:
        """
        Flag to turn on explainability on best model.
        """
        return pulumi.get(self, "enable_model_explainability")

    @property
    @pulumi.getter(name="enableOnnxCompatibleModels")
    def enable_onnx_compatible_models(self) -> Optional[bool]:
        """
        Flag for enabling onnx compatible models.
        """
        return pulumi.get(self, "enable_onnx_compatible_models")

    @property
    @pulumi.getter(name="enableStackEnsemble")
    def enable_stack_ensemble(self) -> Optional[bool]:
        """
        Enable stack ensemble run.
        """
        return pulumi.get(self, "enable_stack_ensemble")

    @property
    @pulumi.getter(name="enableVoteEnsemble")
    def enable_vote_ensemble(self) -> Optional[bool]:
        """
        Enable voting ensemble run.
        """
        return pulumi.get(self, "enable_vote_ensemble")

    @property
    @pulumi.getter(name="ensembleModelDownloadTimeout")
    def ensemble_model_download_timeout(self) -> Optional[str]:
        """
        During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
        Configure this parameter with a higher value than 300 secs, if more time is needed.
        """
        return pulumi.get(self, "ensemble_model_download_timeout")

    @property
    @pulumi.getter(name="stackEnsembleSettings")
    def stack_ensemble_settings(self) -> Optional['outputs.StackEnsembleSettingsResponse']:
        """
        Stack ensemble settings for stack ensemble run.
        """
        return pulumi.get(self, "stack_ensemble_settings")


@pulumi.output_type
class GridSamplingAlgorithmResponse(dict):
    """
    Defines a Sampling Algorithm that exhaustively generates every value combination in the space
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "samplingAlgorithmType":
            suggest = "sampling_algorithm_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GridSamplingAlgorithmResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GridSamplingAlgorithmResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GridSamplingAlgorithmResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sampling_algorithm_type: str):
        """
        Defines a Sampling Algorithm that exhaustively generates every value combination in the space
        :param str sampling_algorithm_type: 
               Expected value is 'Grid'.
        """
        pulumi.set(__self__, "sampling_algorithm_type", 'Grid')

    @property
    @pulumi.getter(name="samplingAlgorithmType")
    def sampling_algorithm_type(self) -> str:
        """

        Expected value is 'Grid'.
        """
        return pulumi.get(self, "sampling_algorithm_type")


@pulumi.output_type
class HDInsightPropertiesResponse(dict):
    """
    HDInsight compute properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "administratorAccount":
            suggest = "administrator_account"
        elif key == "sshPort":
            suggest = "ssh_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HDInsightPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HDInsightPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HDInsightPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 administrator_account: Optional['outputs.VirtualMachineSshCredentialsResponse'] = None,
                 ssh_port: Optional[int] = None):
        """
        HDInsight compute properties
        :param str address: Public IP address of the master node of the cluster.
        :param 'VirtualMachineSshCredentialsResponse' administrator_account: Admin credentials for master node of the cluster
        :param int ssh_port: Port open for ssh connections on the master node of the cluster.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if administrator_account is not None:
            pulumi.set(__self__, "administrator_account", administrator_account)
        if ssh_port is not None:
            pulumi.set(__self__, "ssh_port", ssh_port)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Public IP address of the master node of the cluster.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="administratorAccount")
    def administrator_account(self) -> Optional['outputs.VirtualMachineSshCredentialsResponse']:
        """
        Admin credentials for master node of the cluster
        """
        return pulumi.get(self, "administrator_account")

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> Optional[int]:
        """
        Port open for ssh connections on the master node of the cluster.
        """
        return pulumi.get(self, "ssh_port")


@pulumi.output_type
class HDInsightResponse(dict):
    """
    A HDInsight compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HDInsightResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HDInsightResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HDInsightResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 properties: Optional['outputs.HDInsightPropertiesResponse'] = None,
                 resource_id: Optional[str] = None):
        """
        A HDInsight compute.
        :param str compute_type: The type of compute
               Expected value is 'HDInsight'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param 'HDInsightPropertiesResponse' properties: HDInsight compute properties
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'HDInsight')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'HDInsight'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.HDInsightPropertiesResponse']:
        """
        HDInsight compute properties
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class IdAssetReferenceResponse(dict):
    """
    Reference to an asset via its ARM resource ID.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assetId":
            suggest = "asset_id"
        elif key == "referenceType":
            suggest = "reference_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdAssetReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdAssetReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdAssetReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asset_id: str,
                 reference_type: str):
        """
        Reference to an asset via its ARM resource ID.
        :param str asset_id: [Required] ARM resource ID of the asset.
        :param str reference_type: Enum to determine which reference method to use for an asset.
               Expected value is 'Id'.
        """
        pulumi.set(__self__, "asset_id", asset_id)
        pulumi.set(__self__, "reference_type", 'Id')

    @property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> str:
        """
        [Required] ARM resource ID of the asset.
        """
        return pulumi.get(self, "asset_id")

    @property
    @pulumi.getter(name="referenceType")
    def reference_type(self) -> str:
        """
        Enum to determine which reference method to use for an asset.
        Expected value is 'Id'.
        """
        return pulumi.get(self, "reference_type")


@pulumi.output_type
class IdentityForCmkResponse(dict):
    """
    Identity that will be used to access key vault for encryption at rest
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityForCmkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityForCmkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityForCmkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_assigned_identity: Optional[str] = None):
        """
        Identity that will be used to access key vault for encryption at rest
        :param str user_assigned_identity: The ArmId of the user assigned identity that will be used to access the customer managed key vault
        """
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[str]:
        """
        The ArmId of the user assigned identity that will be used to access the customer managed key vault
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class ImageClassificationMultilabelResponse(dict):
    """
    Image Classification Multilabel. Multi-label image classification is used when an image could have one or more labels
    from a set of labels - e.g. an image could be labeled with both 'cat' and 'dog'.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "limitSettings":
            suggest = "limit_settings"
        elif key == "taskType":
            suggest = "task_type"
        elif key == "trainingData":
            suggest = "training_data"
        elif key == "logVerbosity":
            suggest = "log_verbosity"
        elif key == "modelSettings":
            suggest = "model_settings"
        elif key == "primaryMetric":
            suggest = "primary_metric"
        elif key == "searchSpace":
            suggest = "search_space"
        elif key == "sweepSettings":
            suggest = "sweep_settings"
        elif key == "targetColumnName":
            suggest = "target_column_name"
        elif key == "validationData":
            suggest = "validation_data"
        elif key == "validationDataSize":
            suggest = "validation_data_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageClassificationMultilabelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageClassificationMultilabelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageClassificationMultilabelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 limit_settings: 'outputs.ImageLimitSettingsResponse',
                 task_type: str,
                 training_data: 'outputs.MLTableJobInputResponse',
                 log_verbosity: Optional[str] = None,
                 model_settings: Optional['outputs.ImageModelSettingsClassificationResponse'] = None,
                 primary_metric: Optional[str] = None,
                 search_space: Optional[Sequence['outputs.ImageModelDistributionSettingsClassificationResponse']] = None,
                 sweep_settings: Optional['outputs.ImageSweepSettingsResponse'] = None,
                 target_column_name: Optional[str] = None,
                 validation_data: Optional['outputs.MLTableJobInputResponse'] = None,
                 validation_data_size: Optional[float] = None):
        """
        Image Classification Multilabel. Multi-label image classification is used when an image could have one or more labels
        from a set of labels - e.g. an image could be labeled with both 'cat' and 'dog'.
        :param 'ImageLimitSettingsResponse' limit_settings: [Required] Limit settings for the AutoML job.
        :param str task_type: AutoMLJob Task type.
               Expected value is 'ImageClassificationMultilabel'.
        :param 'MLTableJobInputResponse' training_data: [Required] Training data input.
        :param str log_verbosity: Log verbosity for the job.
        :param 'ImageModelSettingsClassificationResponse' model_settings: Settings used for training the model.
        :param str primary_metric: Primary metric to optimize for this task.
        :param Sequence['ImageModelDistributionSettingsClassificationResponse'] search_space: Search space for sampling different combinations of models and their hyperparameters.
        :param 'ImageSweepSettingsResponse' sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :param str target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param 'MLTableJobInputResponse' validation_data: Validation data inputs.
        :param float validation_data_size: The fraction of training dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        """
        pulumi.set(__self__, "limit_settings", limit_settings)
        pulumi.set(__self__, "task_type", 'ImageClassificationMultilabel')
        pulumi.set(__self__, "training_data", training_data)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if model_settings is not None:
            pulumi.set(__self__, "model_settings", model_settings)
        if primary_metric is None:
            primary_metric = 'IOU'
        if primary_metric is not None:
            pulumi.set(__self__, "primary_metric", primary_metric)
        if search_space is not None:
            pulumi.set(__self__, "search_space", search_space)
        if sweep_settings is not None:
            pulumi.set(__self__, "sweep_settings", sweep_settings)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)
        if validation_data_size is not None:
            pulumi.set(__self__, "validation_data_size", validation_data_size)

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> 'outputs.ImageLimitSettingsResponse':
        """
        [Required] Limit settings for the AutoML job.
        """
        return pulumi.get(self, "limit_settings")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        AutoMLJob Task type.
        Expected value is 'ImageClassificationMultilabel'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> 'outputs.MLTableJobInputResponse':
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[str]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @property
    @pulumi.getter(name="modelSettings")
    def model_settings(self) -> Optional['outputs.ImageModelSettingsClassificationResponse']:
        """
        Settings used for training the model.
        """
        return pulumi.get(self, "model_settings")

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> Optional[str]:
        """
        Primary metric to optimize for this task.
        """
        return pulumi.get(self, "primary_metric")

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> Optional[Sequence['outputs.ImageModelDistributionSettingsClassificationResponse']]:
        """
        Search space for sampling different combinations of models and their hyperparameters.
        """
        return pulumi.get(self, "search_space")

    @property
    @pulumi.getter(name="sweepSettings")
    def sweep_settings(self) -> Optional['outputs.ImageSweepSettingsResponse']:
        """
        Model sweeping and hyperparameter sweeping related settings.
        """
        return pulumi.get(self, "sweep_settings")

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[str]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional['outputs.MLTableJobInputResponse']:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")

    @property
    @pulumi.getter(name="validationDataSize")
    def validation_data_size(self) -> Optional[float]:
        """
        The fraction of training dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "validation_data_size")


@pulumi.output_type
class ImageClassificationResponse(dict):
    """
    Image Classification. Multi-class image classification is used when an image is classified with only a single label
    from a set of classes - e.g. each image is classified as either an image of a 'cat' or a 'dog' or a 'duck'.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "limitSettings":
            suggest = "limit_settings"
        elif key == "taskType":
            suggest = "task_type"
        elif key == "trainingData":
            suggest = "training_data"
        elif key == "logVerbosity":
            suggest = "log_verbosity"
        elif key == "modelSettings":
            suggest = "model_settings"
        elif key == "primaryMetric":
            suggest = "primary_metric"
        elif key == "searchSpace":
            suggest = "search_space"
        elif key == "sweepSettings":
            suggest = "sweep_settings"
        elif key == "targetColumnName":
            suggest = "target_column_name"
        elif key == "validationData":
            suggest = "validation_data"
        elif key == "validationDataSize":
            suggest = "validation_data_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageClassificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageClassificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageClassificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 limit_settings: 'outputs.ImageLimitSettingsResponse',
                 task_type: str,
                 training_data: 'outputs.MLTableJobInputResponse',
                 log_verbosity: Optional[str] = None,
                 model_settings: Optional['outputs.ImageModelSettingsClassificationResponse'] = None,
                 primary_metric: Optional[str] = None,
                 search_space: Optional[Sequence['outputs.ImageModelDistributionSettingsClassificationResponse']] = None,
                 sweep_settings: Optional['outputs.ImageSweepSettingsResponse'] = None,
                 target_column_name: Optional[str] = None,
                 validation_data: Optional['outputs.MLTableJobInputResponse'] = None,
                 validation_data_size: Optional[float] = None):
        """
        Image Classification. Multi-class image classification is used when an image is classified with only a single label
        from a set of classes - e.g. each image is classified as either an image of a 'cat' or a 'dog' or a 'duck'.
        :param 'ImageLimitSettingsResponse' limit_settings: [Required] Limit settings for the AutoML job.
        :param str task_type: AutoMLJob Task type.
               Expected value is 'ImageClassification'.
        :param 'MLTableJobInputResponse' training_data: [Required] Training data input.
        :param str log_verbosity: Log verbosity for the job.
        :param 'ImageModelSettingsClassificationResponse' model_settings: Settings used for training the model.
        :param str primary_metric: Primary metric to optimize for this task.
        :param Sequence['ImageModelDistributionSettingsClassificationResponse'] search_space: Search space for sampling different combinations of models and their hyperparameters.
        :param 'ImageSweepSettingsResponse' sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :param str target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param 'MLTableJobInputResponse' validation_data: Validation data inputs.
        :param float validation_data_size: The fraction of training dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        """
        pulumi.set(__self__, "limit_settings", limit_settings)
        pulumi.set(__self__, "task_type", 'ImageClassification')
        pulumi.set(__self__, "training_data", training_data)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if model_settings is not None:
            pulumi.set(__self__, "model_settings", model_settings)
        if primary_metric is None:
            primary_metric = 'Accuracy'
        if primary_metric is not None:
            pulumi.set(__self__, "primary_metric", primary_metric)
        if search_space is not None:
            pulumi.set(__self__, "search_space", search_space)
        if sweep_settings is not None:
            pulumi.set(__self__, "sweep_settings", sweep_settings)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)
        if validation_data_size is not None:
            pulumi.set(__self__, "validation_data_size", validation_data_size)

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> 'outputs.ImageLimitSettingsResponse':
        """
        [Required] Limit settings for the AutoML job.
        """
        return pulumi.get(self, "limit_settings")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        AutoMLJob Task type.
        Expected value is 'ImageClassification'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> 'outputs.MLTableJobInputResponse':
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[str]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @property
    @pulumi.getter(name="modelSettings")
    def model_settings(self) -> Optional['outputs.ImageModelSettingsClassificationResponse']:
        """
        Settings used for training the model.
        """
        return pulumi.get(self, "model_settings")

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> Optional[str]:
        """
        Primary metric to optimize for this task.
        """
        return pulumi.get(self, "primary_metric")

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> Optional[Sequence['outputs.ImageModelDistributionSettingsClassificationResponse']]:
        """
        Search space for sampling different combinations of models and their hyperparameters.
        """
        return pulumi.get(self, "search_space")

    @property
    @pulumi.getter(name="sweepSettings")
    def sweep_settings(self) -> Optional['outputs.ImageSweepSettingsResponse']:
        """
        Model sweeping and hyperparameter sweeping related settings.
        """
        return pulumi.get(self, "sweep_settings")

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[str]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional['outputs.MLTableJobInputResponse']:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")

    @property
    @pulumi.getter(name="validationDataSize")
    def validation_data_size(self) -> Optional[float]:
        """
        The fraction of training dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "validation_data_size")


@pulumi.output_type
class ImageInstanceSegmentationResponse(dict):
    """
    Image Instance Segmentation. Instance segmentation is used to identify objects in an image at the pixel level,
    drawing a polygon around each object in the image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "limitSettings":
            suggest = "limit_settings"
        elif key == "taskType":
            suggest = "task_type"
        elif key == "trainingData":
            suggest = "training_data"
        elif key == "logVerbosity":
            suggest = "log_verbosity"
        elif key == "modelSettings":
            suggest = "model_settings"
        elif key == "primaryMetric":
            suggest = "primary_metric"
        elif key == "searchSpace":
            suggest = "search_space"
        elif key == "sweepSettings":
            suggest = "sweep_settings"
        elif key == "targetColumnName":
            suggest = "target_column_name"
        elif key == "validationData":
            suggest = "validation_data"
        elif key == "validationDataSize":
            suggest = "validation_data_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageInstanceSegmentationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageInstanceSegmentationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageInstanceSegmentationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 limit_settings: 'outputs.ImageLimitSettingsResponse',
                 task_type: str,
                 training_data: 'outputs.MLTableJobInputResponse',
                 log_verbosity: Optional[str] = None,
                 model_settings: Optional['outputs.ImageModelSettingsObjectDetectionResponse'] = None,
                 primary_metric: Optional[str] = None,
                 search_space: Optional[Sequence['outputs.ImageModelDistributionSettingsObjectDetectionResponse']] = None,
                 sweep_settings: Optional['outputs.ImageSweepSettingsResponse'] = None,
                 target_column_name: Optional[str] = None,
                 validation_data: Optional['outputs.MLTableJobInputResponse'] = None,
                 validation_data_size: Optional[float] = None):
        """
        Image Instance Segmentation. Instance segmentation is used to identify objects in an image at the pixel level,
        drawing a polygon around each object in the image.
        :param 'ImageLimitSettingsResponse' limit_settings: [Required] Limit settings for the AutoML job.
        :param str task_type: AutoMLJob Task type.
               Expected value is 'ImageInstanceSegmentation'.
        :param 'MLTableJobInputResponse' training_data: [Required] Training data input.
        :param str log_verbosity: Log verbosity for the job.
        :param 'ImageModelSettingsObjectDetectionResponse' model_settings: Settings used for training the model.
        :param str primary_metric: Primary metric to optimize for this task.
        :param Sequence['ImageModelDistributionSettingsObjectDetectionResponse'] search_space: Search space for sampling different combinations of models and their hyperparameters.
        :param 'ImageSweepSettingsResponse' sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :param str target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param 'MLTableJobInputResponse' validation_data: Validation data inputs.
        :param float validation_data_size: The fraction of training dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        """
        pulumi.set(__self__, "limit_settings", limit_settings)
        pulumi.set(__self__, "task_type", 'ImageInstanceSegmentation')
        pulumi.set(__self__, "training_data", training_data)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if model_settings is not None:
            pulumi.set(__self__, "model_settings", model_settings)
        if primary_metric is None:
            primary_metric = 'MeanAveragePrecision'
        if primary_metric is not None:
            pulumi.set(__self__, "primary_metric", primary_metric)
        if search_space is not None:
            pulumi.set(__self__, "search_space", search_space)
        if sweep_settings is not None:
            pulumi.set(__self__, "sweep_settings", sweep_settings)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)
        if validation_data_size is not None:
            pulumi.set(__self__, "validation_data_size", validation_data_size)

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> 'outputs.ImageLimitSettingsResponse':
        """
        [Required] Limit settings for the AutoML job.
        """
        return pulumi.get(self, "limit_settings")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        AutoMLJob Task type.
        Expected value is 'ImageInstanceSegmentation'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> 'outputs.MLTableJobInputResponse':
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[str]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @property
    @pulumi.getter(name="modelSettings")
    def model_settings(self) -> Optional['outputs.ImageModelSettingsObjectDetectionResponse']:
        """
        Settings used for training the model.
        """
        return pulumi.get(self, "model_settings")

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> Optional[str]:
        """
        Primary metric to optimize for this task.
        """
        return pulumi.get(self, "primary_metric")

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> Optional[Sequence['outputs.ImageModelDistributionSettingsObjectDetectionResponse']]:
        """
        Search space for sampling different combinations of models and their hyperparameters.
        """
        return pulumi.get(self, "search_space")

    @property
    @pulumi.getter(name="sweepSettings")
    def sweep_settings(self) -> Optional['outputs.ImageSweepSettingsResponse']:
        """
        Model sweeping and hyperparameter sweeping related settings.
        """
        return pulumi.get(self, "sweep_settings")

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[str]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional['outputs.MLTableJobInputResponse']:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")

    @property
    @pulumi.getter(name="validationDataSize")
    def validation_data_size(self) -> Optional[float]:
        """
        The fraction of training dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "validation_data_size")


@pulumi.output_type
class ImageLimitSettingsResponse(dict):
    """
    Limit settings for the AutoML job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxConcurrentTrials":
            suggest = "max_concurrent_trials"
        elif key == "maxTrials":
            suggest = "max_trials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageLimitSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageLimitSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageLimitSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_concurrent_trials: Optional[int] = None,
                 max_trials: Optional[int] = None,
                 timeout: Optional[str] = None):
        """
        Limit settings for the AutoML job.
        :param int max_concurrent_trials: Maximum number of concurrent AutoML iterations.
        :param int max_trials: Maximum number of AutoML iterations.
        :param str timeout: AutoML job timeout.
        """
        if max_concurrent_trials is None:
            max_concurrent_trials = 1
        if max_concurrent_trials is not None:
            pulumi.set(__self__, "max_concurrent_trials", max_concurrent_trials)
        if max_trials is None:
            max_trials = 1
        if max_trials is not None:
            pulumi.set(__self__, "max_trials", max_trials)
        if timeout is None:
            timeout = 'P7D'
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="maxConcurrentTrials")
    def max_concurrent_trials(self) -> Optional[int]:
        """
        Maximum number of concurrent AutoML iterations.
        """
        return pulumi.get(self, "max_concurrent_trials")

    @property
    @pulumi.getter(name="maxTrials")
    def max_trials(self) -> Optional[int]:
        """
        Maximum number of AutoML iterations.
        """
        return pulumi.get(self, "max_trials")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        AutoML job timeout.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ImageModelDistributionSettingsClassificationResponse(dict):
    """
    Distribution expressions to sweep over values of model settings.
    <example>
    Some examples are:
    <code>
    ModelName = "choice('seresnext', 'resnest50')";
    LearningRate = "uniform(0.001, 0.01)";
    LayersToFreeze = "choice(0, 2)";
    </code></example>
    For more details on how to compose distribution expressions please check the documentation:
    https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
    For more information on the available settings please visit the official documentation:
    https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "amsGradient":
            suggest = "ams_gradient"
        elif key == "earlyStopping":
            suggest = "early_stopping"
        elif key == "earlyStoppingDelay":
            suggest = "early_stopping_delay"
        elif key == "earlyStoppingPatience":
            suggest = "early_stopping_patience"
        elif key == "enableOnnxNormalization":
            suggest = "enable_onnx_normalization"
        elif key == "evaluationFrequency":
            suggest = "evaluation_frequency"
        elif key == "gradientAccumulationStep":
            suggest = "gradient_accumulation_step"
        elif key == "layersToFreeze":
            suggest = "layers_to_freeze"
        elif key == "learningRate":
            suggest = "learning_rate"
        elif key == "learningRateScheduler":
            suggest = "learning_rate_scheduler"
        elif key == "modelName":
            suggest = "model_name"
        elif key == "numberOfEpochs":
            suggest = "number_of_epochs"
        elif key == "numberOfWorkers":
            suggest = "number_of_workers"
        elif key == "randomSeed":
            suggest = "random_seed"
        elif key == "stepLRGamma":
            suggest = "step_lr_gamma"
        elif key == "stepLRStepSize":
            suggest = "step_lr_step_size"
        elif key == "trainingBatchSize":
            suggest = "training_batch_size"
        elif key == "trainingCropSize":
            suggest = "training_crop_size"
        elif key == "validationBatchSize":
            suggest = "validation_batch_size"
        elif key == "validationCropSize":
            suggest = "validation_crop_size"
        elif key == "validationResizeSize":
            suggest = "validation_resize_size"
        elif key == "warmupCosineLRCycles":
            suggest = "warmup_cosine_lr_cycles"
        elif key == "warmupCosineLRWarmupEpochs":
            suggest = "warmup_cosine_lr_warmup_epochs"
        elif key == "weightDecay":
            suggest = "weight_decay"
        elif key == "weightedLoss":
            suggest = "weighted_loss"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageModelDistributionSettingsClassificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageModelDistributionSettingsClassificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageModelDistributionSettingsClassificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ams_gradient: Optional[str] = None,
                 augmentations: Optional[str] = None,
                 beta1: Optional[str] = None,
                 beta2: Optional[str] = None,
                 distributed: Optional[str] = None,
                 early_stopping: Optional[str] = None,
                 early_stopping_delay: Optional[str] = None,
                 early_stopping_patience: Optional[str] = None,
                 enable_onnx_normalization: Optional[str] = None,
                 evaluation_frequency: Optional[str] = None,
                 gradient_accumulation_step: Optional[str] = None,
                 layers_to_freeze: Optional[str] = None,
                 learning_rate: Optional[str] = None,
                 learning_rate_scheduler: Optional[str] = None,
                 model_name: Optional[str] = None,
                 momentum: Optional[str] = None,
                 nesterov: Optional[str] = None,
                 number_of_epochs: Optional[str] = None,
                 number_of_workers: Optional[str] = None,
                 optimizer: Optional[str] = None,
                 random_seed: Optional[str] = None,
                 step_lr_gamma: Optional[str] = None,
                 step_lr_step_size: Optional[str] = None,
                 training_batch_size: Optional[str] = None,
                 training_crop_size: Optional[str] = None,
                 validation_batch_size: Optional[str] = None,
                 validation_crop_size: Optional[str] = None,
                 validation_resize_size: Optional[str] = None,
                 warmup_cosine_lr_cycles: Optional[str] = None,
                 warmup_cosine_lr_warmup_epochs: Optional[str] = None,
                 weight_decay: Optional[str] = None,
                 weighted_loss: Optional[str] = None):
        """
        Distribution expressions to sweep over values of model settings.
        <example>
        Some examples are:
        <code>
        ModelName = "choice('seresnext', 'resnest50')";
        LearningRate = "uniform(0.001, 0.01)";
        LayersToFreeze = "choice(0, 2)";
        </code></example>
        For more details on how to compose distribution expressions please check the documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
        For more information on the available settings please visit the official documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param str ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :param str augmentations: Settings for using Augmentations.
        :param str beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        :param str beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        :param str distributed: Whether to use distributer training.
        :param str early_stopping: Enable early stopping logic during training.
        :param str early_stopping_delay: Minimum number of epochs or validation evaluations to wait before primary metric improvement
               is tracked for early stopping. Must be a positive integer.
        :param str early_stopping_patience: Minimum number of epochs or validation evaluations with no primary metric improvement before
               the run is stopped. Must be a positive integer.
        :param str enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :param str evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
        :param str gradient_accumulation_step: Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
               updating the model weights while accumulating the gradients of those steps, and then using
               the accumulated gradients to compute the weight updates. Must be a positive integer.
        :param str layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
               For instance, passing 2 as value for 'seresnext' means
               freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
               see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param str learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :param str learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
        :param str model_name: Name of the model to use for training.
               For more information on the available models please visit the official documentation:
               https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param str momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
        :param str nesterov: Enable nesterov when optimizer is 'sgd'.
        :param str number_of_epochs: Number of training epochs. Must be a positive integer.
        :param str number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :param str optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        :param str random_seed: Random seed to be used when using deterministic training.
        :param str step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
        :param str step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
        :param str training_batch_size: Training batch size. Must be a positive integer.
        :param str training_crop_size: Image crop size that is input to the neural network for the training dataset. Must be a positive integer.
        :param str validation_batch_size: Validation batch size. Must be a positive integer.
        :param str validation_crop_size: Image crop size that is input to the neural network for the validation dataset. Must be a positive integer.
        :param str validation_resize_size: Image size to which to resize before cropping for validation dataset. Must be a positive integer.
        :param str warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
        :param str warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
        :param str weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
        :param str weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
               1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be 0 or 1 or 2.
        """
        if ams_gradient is not None:
            pulumi.set(__self__, "ams_gradient", ams_gradient)
        if augmentations is not None:
            pulumi.set(__self__, "augmentations", augmentations)
        if beta1 is not None:
            pulumi.set(__self__, "beta1", beta1)
        if beta2 is not None:
            pulumi.set(__self__, "beta2", beta2)
        if distributed is not None:
            pulumi.set(__self__, "distributed", distributed)
        if early_stopping is not None:
            pulumi.set(__self__, "early_stopping", early_stopping)
        if early_stopping_delay is not None:
            pulumi.set(__self__, "early_stopping_delay", early_stopping_delay)
        if early_stopping_patience is not None:
            pulumi.set(__self__, "early_stopping_patience", early_stopping_patience)
        if enable_onnx_normalization is not None:
            pulumi.set(__self__, "enable_onnx_normalization", enable_onnx_normalization)
        if evaluation_frequency is not None:
            pulumi.set(__self__, "evaluation_frequency", evaluation_frequency)
        if gradient_accumulation_step is not None:
            pulumi.set(__self__, "gradient_accumulation_step", gradient_accumulation_step)
        if layers_to_freeze is not None:
            pulumi.set(__self__, "layers_to_freeze", layers_to_freeze)
        if learning_rate is not None:
            pulumi.set(__self__, "learning_rate", learning_rate)
        if learning_rate_scheduler is not None:
            pulumi.set(__self__, "learning_rate_scheduler", learning_rate_scheduler)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if momentum is not None:
            pulumi.set(__self__, "momentum", momentum)
        if nesterov is not None:
            pulumi.set(__self__, "nesterov", nesterov)
        if number_of_epochs is not None:
            pulumi.set(__self__, "number_of_epochs", number_of_epochs)
        if number_of_workers is not None:
            pulumi.set(__self__, "number_of_workers", number_of_workers)
        if optimizer is not None:
            pulumi.set(__self__, "optimizer", optimizer)
        if random_seed is not None:
            pulumi.set(__self__, "random_seed", random_seed)
        if step_lr_gamma is not None:
            pulumi.set(__self__, "step_lr_gamma", step_lr_gamma)
        if step_lr_step_size is not None:
            pulumi.set(__self__, "step_lr_step_size", step_lr_step_size)
        if training_batch_size is not None:
            pulumi.set(__self__, "training_batch_size", training_batch_size)
        if training_crop_size is not None:
            pulumi.set(__self__, "training_crop_size", training_crop_size)
        if validation_batch_size is not None:
            pulumi.set(__self__, "validation_batch_size", validation_batch_size)
        if validation_crop_size is not None:
            pulumi.set(__self__, "validation_crop_size", validation_crop_size)
        if validation_resize_size is not None:
            pulumi.set(__self__, "validation_resize_size", validation_resize_size)
        if warmup_cosine_lr_cycles is not None:
            pulumi.set(__self__, "warmup_cosine_lr_cycles", warmup_cosine_lr_cycles)
        if warmup_cosine_lr_warmup_epochs is not None:
            pulumi.set(__self__, "warmup_cosine_lr_warmup_epochs", warmup_cosine_lr_warmup_epochs)
        if weight_decay is not None:
            pulumi.set(__self__, "weight_decay", weight_decay)
        if weighted_loss is not None:
            pulumi.set(__self__, "weighted_loss", weighted_loss)

    @property
    @pulumi.getter(name="amsGradient")
    def ams_gradient(self) -> Optional[str]:
        """
        Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        """
        return pulumi.get(self, "ams_gradient")

    @property
    @pulumi.getter
    def augmentations(self) -> Optional[str]:
        """
        Settings for using Augmentations.
        """
        return pulumi.get(self, "augmentations")

    @property
    @pulumi.getter
    def beta1(self) -> Optional[str]:
        """
        Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "beta1")

    @property
    @pulumi.getter
    def beta2(self) -> Optional[str]:
        """
        Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "beta2")

    @property
    @pulumi.getter
    def distributed(self) -> Optional[str]:
        """
        Whether to use distributer training.
        """
        return pulumi.get(self, "distributed")

    @property
    @pulumi.getter(name="earlyStopping")
    def early_stopping(self) -> Optional[str]:
        """
        Enable early stopping logic during training.
        """
        return pulumi.get(self, "early_stopping")

    @property
    @pulumi.getter(name="earlyStoppingDelay")
    def early_stopping_delay(self) -> Optional[str]:
        """
        Minimum number of epochs or validation evaluations to wait before primary metric improvement
        is tracked for early stopping. Must be a positive integer.
        """
        return pulumi.get(self, "early_stopping_delay")

    @property
    @pulumi.getter(name="earlyStoppingPatience")
    def early_stopping_patience(self) -> Optional[str]:
        """
        Minimum number of epochs or validation evaluations with no primary metric improvement before
        the run is stopped. Must be a positive integer.
        """
        return pulumi.get(self, "early_stopping_patience")

    @property
    @pulumi.getter(name="enableOnnxNormalization")
    def enable_onnx_normalization(self) -> Optional[str]:
        """
        Enable normalization when exporting ONNX model.
        """
        return pulumi.get(self, "enable_onnx_normalization")

    @property
    @pulumi.getter(name="evaluationFrequency")
    def evaluation_frequency(self) -> Optional[str]:
        """
        Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
        """
        return pulumi.get(self, "evaluation_frequency")

    @property
    @pulumi.getter(name="gradientAccumulationStep")
    def gradient_accumulation_step(self) -> Optional[str]:
        """
        Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
        updating the model weights while accumulating the gradients of those steps, and then using
        the accumulated gradients to compute the weight updates. Must be a positive integer.
        """
        return pulumi.get(self, "gradient_accumulation_step")

    @property
    @pulumi.getter(name="layersToFreeze")
    def layers_to_freeze(self) -> Optional[str]:
        """
        Number of layers to freeze for the model. Must be a positive integer.
        For instance, passing 2 as value for 'seresnext' means
        freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
        see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        """
        return pulumi.get(self, "layers_to_freeze")

    @property
    @pulumi.getter(name="learningRate")
    def learning_rate(self) -> Optional[str]:
        """
        Initial learning rate. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "learning_rate")

    @property
    @pulumi.getter(name="learningRateScheduler")
    def learning_rate_scheduler(self) -> Optional[str]:
        """
        Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
        """
        return pulumi.get(self, "learning_rate_scheduler")

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[str]:
        """
        Name of the model to use for training.
        For more information on the available models please visit the official documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        """
        return pulumi.get(self, "model_name")

    @property
    @pulumi.getter
    def momentum(self) -> Optional[str]:
        """
        Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "momentum")

    @property
    @pulumi.getter
    def nesterov(self) -> Optional[str]:
        """
        Enable nesterov when optimizer is 'sgd'.
        """
        return pulumi.get(self, "nesterov")

    @property
    @pulumi.getter(name="numberOfEpochs")
    def number_of_epochs(self) -> Optional[str]:
        """
        Number of training epochs. Must be a positive integer.
        """
        return pulumi.get(self, "number_of_epochs")

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> Optional[str]:
        """
        Number of data loader workers. Must be a non-negative integer.
        """
        return pulumi.get(self, "number_of_workers")

    @property
    @pulumi.getter
    def optimizer(self) -> Optional[str]:
        """
        Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        """
        return pulumi.get(self, "optimizer")

    @property
    @pulumi.getter(name="randomSeed")
    def random_seed(self) -> Optional[str]:
        """
        Random seed to be used when using deterministic training.
        """
        return pulumi.get(self, "random_seed")

    @property
    @pulumi.getter(name="stepLRGamma")
    def step_lr_gamma(self) -> Optional[str]:
        """
        Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "step_lr_gamma")

    @property
    @pulumi.getter(name="stepLRStepSize")
    def step_lr_step_size(self) -> Optional[str]:
        """
        Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
        """
        return pulumi.get(self, "step_lr_step_size")

    @property
    @pulumi.getter(name="trainingBatchSize")
    def training_batch_size(self) -> Optional[str]:
        """
        Training batch size. Must be a positive integer.
        """
        return pulumi.get(self, "training_batch_size")

    @property
    @pulumi.getter(name="trainingCropSize")
    def training_crop_size(self) -> Optional[str]:
        """
        Image crop size that is input to the neural network for the training dataset. Must be a positive integer.
        """
        return pulumi.get(self, "training_crop_size")

    @property
    @pulumi.getter(name="validationBatchSize")
    def validation_batch_size(self) -> Optional[str]:
        """
        Validation batch size. Must be a positive integer.
        """
        return pulumi.get(self, "validation_batch_size")

    @property
    @pulumi.getter(name="validationCropSize")
    def validation_crop_size(self) -> Optional[str]:
        """
        Image crop size that is input to the neural network for the validation dataset. Must be a positive integer.
        """
        return pulumi.get(self, "validation_crop_size")

    @property
    @pulumi.getter(name="validationResizeSize")
    def validation_resize_size(self) -> Optional[str]:
        """
        Image size to which to resize before cropping for validation dataset. Must be a positive integer.
        """
        return pulumi.get(self, "validation_resize_size")

    @property
    @pulumi.getter(name="warmupCosineLRCycles")
    def warmup_cosine_lr_cycles(self) -> Optional[str]:
        """
        Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "warmup_cosine_lr_cycles")

    @property
    @pulumi.getter(name="warmupCosineLRWarmupEpochs")
    def warmup_cosine_lr_warmup_epochs(self) -> Optional[str]:
        """
        Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
        """
        return pulumi.get(self, "warmup_cosine_lr_warmup_epochs")

    @property
    @pulumi.getter(name="weightDecay")
    def weight_decay(self) -> Optional[str]:
        """
        Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
        """
        return pulumi.get(self, "weight_decay")

    @property
    @pulumi.getter(name="weightedLoss")
    def weighted_loss(self) -> Optional[str]:
        """
        Weighted loss. The accepted values are 0 for no weighted loss.
        1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be 0 or 1 or 2.
        """
        return pulumi.get(self, "weighted_loss")


@pulumi.output_type
class ImageModelDistributionSettingsObjectDetectionResponse(dict):
    """
    Distribution expressions to sweep over values of model settings.
    <example>
    Some examples are:
    <code>
    ModelName = "choice('seresnext', 'resnest50')";
    LearningRate = "uniform(0.001, 0.01)";
    LayersToFreeze = "choice(0, 2)";
    </code></example>
    For more details on how to compose distribution expressions please check the documentation:
    https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
    For more information on the available settings please visit the official documentation:
    https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "amsGradient":
            suggest = "ams_gradient"
        elif key == "boxDetectionsPerImage":
            suggest = "box_detections_per_image"
        elif key == "boxScoreThreshold":
            suggest = "box_score_threshold"
        elif key == "earlyStopping":
            suggest = "early_stopping"
        elif key == "earlyStoppingDelay":
            suggest = "early_stopping_delay"
        elif key == "earlyStoppingPatience":
            suggest = "early_stopping_patience"
        elif key == "enableOnnxNormalization":
            suggest = "enable_onnx_normalization"
        elif key == "evaluationFrequency":
            suggest = "evaluation_frequency"
        elif key == "gradientAccumulationStep":
            suggest = "gradient_accumulation_step"
        elif key == "imageSize":
            suggest = "image_size"
        elif key == "layersToFreeze":
            suggest = "layers_to_freeze"
        elif key == "learningRate":
            suggest = "learning_rate"
        elif key == "learningRateScheduler":
            suggest = "learning_rate_scheduler"
        elif key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"
        elif key == "modelName":
            suggest = "model_name"
        elif key == "modelSize":
            suggest = "model_size"
        elif key == "multiScale":
            suggest = "multi_scale"
        elif key == "nmsIouThreshold":
            suggest = "nms_iou_threshold"
        elif key == "numberOfEpochs":
            suggest = "number_of_epochs"
        elif key == "numberOfWorkers":
            suggest = "number_of_workers"
        elif key == "randomSeed":
            suggest = "random_seed"
        elif key == "stepLRGamma":
            suggest = "step_lr_gamma"
        elif key == "stepLRStepSize":
            suggest = "step_lr_step_size"
        elif key == "tileGridSize":
            suggest = "tile_grid_size"
        elif key == "tileOverlapRatio":
            suggest = "tile_overlap_ratio"
        elif key == "tilePredictionsNmsThreshold":
            suggest = "tile_predictions_nms_threshold"
        elif key == "trainingBatchSize":
            suggest = "training_batch_size"
        elif key == "validationBatchSize":
            suggest = "validation_batch_size"
        elif key == "validationIouThreshold":
            suggest = "validation_iou_threshold"
        elif key == "validationMetricType":
            suggest = "validation_metric_type"
        elif key == "warmupCosineLRCycles":
            suggest = "warmup_cosine_lr_cycles"
        elif key == "warmupCosineLRWarmupEpochs":
            suggest = "warmup_cosine_lr_warmup_epochs"
        elif key == "weightDecay":
            suggest = "weight_decay"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageModelDistributionSettingsObjectDetectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageModelDistributionSettingsObjectDetectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageModelDistributionSettingsObjectDetectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ams_gradient: Optional[str] = None,
                 augmentations: Optional[str] = None,
                 beta1: Optional[str] = None,
                 beta2: Optional[str] = None,
                 box_detections_per_image: Optional[str] = None,
                 box_score_threshold: Optional[str] = None,
                 distributed: Optional[str] = None,
                 early_stopping: Optional[str] = None,
                 early_stopping_delay: Optional[str] = None,
                 early_stopping_patience: Optional[str] = None,
                 enable_onnx_normalization: Optional[str] = None,
                 evaluation_frequency: Optional[str] = None,
                 gradient_accumulation_step: Optional[str] = None,
                 image_size: Optional[str] = None,
                 layers_to_freeze: Optional[str] = None,
                 learning_rate: Optional[str] = None,
                 learning_rate_scheduler: Optional[str] = None,
                 max_size: Optional[str] = None,
                 min_size: Optional[str] = None,
                 model_name: Optional[str] = None,
                 model_size: Optional[str] = None,
                 momentum: Optional[str] = None,
                 multi_scale: Optional[str] = None,
                 nesterov: Optional[str] = None,
                 nms_iou_threshold: Optional[str] = None,
                 number_of_epochs: Optional[str] = None,
                 number_of_workers: Optional[str] = None,
                 optimizer: Optional[str] = None,
                 random_seed: Optional[str] = None,
                 step_lr_gamma: Optional[str] = None,
                 step_lr_step_size: Optional[str] = None,
                 tile_grid_size: Optional[str] = None,
                 tile_overlap_ratio: Optional[str] = None,
                 tile_predictions_nms_threshold: Optional[str] = None,
                 training_batch_size: Optional[str] = None,
                 validation_batch_size: Optional[str] = None,
                 validation_iou_threshold: Optional[str] = None,
                 validation_metric_type: Optional[str] = None,
                 warmup_cosine_lr_cycles: Optional[str] = None,
                 warmup_cosine_lr_warmup_epochs: Optional[str] = None,
                 weight_decay: Optional[str] = None):
        """
        Distribution expressions to sweep over values of model settings.
        <example>
        Some examples are:
        <code>
        ModelName = "choice('seresnext', 'resnest50')";
        LearningRate = "uniform(0.001, 0.01)";
        LayersToFreeze = "choice(0, 2)";
        </code></example>
        For more details on how to compose distribution expressions please check the documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
        For more information on the available settings please visit the official documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param str ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :param str augmentations: Settings for using Augmentations.
        :param str beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        :param str beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        :param str box_detections_per_image: Maximum number of detections per image, for all classes. Must be a positive integer.
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param str box_score_threshold: During inference, only return proposals with a classification score greater than
               BoxScoreThreshold. Must be a float in the range[0, 1].
        :param str distributed: Whether to use distributer training.
        :param str early_stopping: Enable early stopping logic during training.
        :param str early_stopping_delay: Minimum number of epochs or validation evaluations to wait before primary metric improvement
               is tracked for early stopping. Must be a positive integer.
        :param str early_stopping_patience: Minimum number of epochs or validation evaluations with no primary metric improvement before
               the run is stopped. Must be a positive integer.
        :param str enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :param str evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
        :param str gradient_accumulation_step: Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
               updating the model weights while accumulating the gradients of those steps, and then using
               the accumulated gradients to compute the weight updates. Must be a positive integer.
        :param str image_size: Image size for train and validation. Must be a positive integer.
               Note: The training run may get into CUDA OOM if the size is too big.
               Note: This settings is only supported for the 'yolov5' algorithm.
        :param str layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
               For instance, passing 2 as value for 'seresnext' means
               freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
               see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param str learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :param str learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
        :param str max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
               Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param str min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
               Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param str model_name: Name of the model to use for training.
               For more information on the available models please visit the official documentation:
               https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param str model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
               Note: training run may get into CUDA OOM if the model size is too big.
               Note: This settings is only supported for the 'yolov5' algorithm.
        :param str momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
        :param str multi_scale: Enable multi-scale image by varying image size by +/- 50%.
               Note: training run may get into CUDA OOM if no sufficient GPU memory.
               Note: This settings is only supported for the 'yolov5' algorithm.
        :param str nesterov: Enable nesterov when optimizer is 'sgd'.
        :param str nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be float in the range [0, 1].
        :param str number_of_epochs: Number of training epochs. Must be a positive integer.
        :param str number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :param str optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        :param str random_seed: Random seed to be used when using deterministic training.
        :param str step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
        :param str step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
        :param str tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must not be
               None to enable small object detection logic. A string containing two integers in mxn format.
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param str tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be float in the range [0, 1).
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param str tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging predictions from tiles and image.
               Used in validation/ inference. Must be float in the range [0, 1].
               Note: This settings is not supported for the 'yolov5' algorithm.
               NMS: Non-maximum suppression
        :param str training_batch_size: Training batch size. Must be a positive integer.
        :param str validation_batch_size: Validation batch size. Must be a positive integer.
        :param str validation_iou_threshold: IOU threshold to use when computing validation metric. Must be float in the range [0, 1].
        :param str validation_metric_type: Metric computation method to use for validation metrics. Must be 'none', 'coco', 'voc', or 'coco_voc'.
        :param str warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
        :param str warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
        :param str weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
        """
        if ams_gradient is not None:
            pulumi.set(__self__, "ams_gradient", ams_gradient)
        if augmentations is not None:
            pulumi.set(__self__, "augmentations", augmentations)
        if beta1 is not None:
            pulumi.set(__self__, "beta1", beta1)
        if beta2 is not None:
            pulumi.set(__self__, "beta2", beta2)
        if box_detections_per_image is not None:
            pulumi.set(__self__, "box_detections_per_image", box_detections_per_image)
        if box_score_threshold is not None:
            pulumi.set(__self__, "box_score_threshold", box_score_threshold)
        if distributed is not None:
            pulumi.set(__self__, "distributed", distributed)
        if early_stopping is not None:
            pulumi.set(__self__, "early_stopping", early_stopping)
        if early_stopping_delay is not None:
            pulumi.set(__self__, "early_stopping_delay", early_stopping_delay)
        if early_stopping_patience is not None:
            pulumi.set(__self__, "early_stopping_patience", early_stopping_patience)
        if enable_onnx_normalization is not None:
            pulumi.set(__self__, "enable_onnx_normalization", enable_onnx_normalization)
        if evaluation_frequency is not None:
            pulumi.set(__self__, "evaluation_frequency", evaluation_frequency)
        if gradient_accumulation_step is not None:
            pulumi.set(__self__, "gradient_accumulation_step", gradient_accumulation_step)
        if image_size is not None:
            pulumi.set(__self__, "image_size", image_size)
        if layers_to_freeze is not None:
            pulumi.set(__self__, "layers_to_freeze", layers_to_freeze)
        if learning_rate is not None:
            pulumi.set(__self__, "learning_rate", learning_rate)
        if learning_rate_scheduler is not None:
            pulumi.set(__self__, "learning_rate_scheduler", learning_rate_scheduler)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if model_size is not None:
            pulumi.set(__self__, "model_size", model_size)
        if momentum is not None:
            pulumi.set(__self__, "momentum", momentum)
        if multi_scale is not None:
            pulumi.set(__self__, "multi_scale", multi_scale)
        if nesterov is not None:
            pulumi.set(__self__, "nesterov", nesterov)
        if nms_iou_threshold is not None:
            pulumi.set(__self__, "nms_iou_threshold", nms_iou_threshold)
        if number_of_epochs is not None:
            pulumi.set(__self__, "number_of_epochs", number_of_epochs)
        if number_of_workers is not None:
            pulumi.set(__self__, "number_of_workers", number_of_workers)
        if optimizer is not None:
            pulumi.set(__self__, "optimizer", optimizer)
        if random_seed is not None:
            pulumi.set(__self__, "random_seed", random_seed)
        if step_lr_gamma is not None:
            pulumi.set(__self__, "step_lr_gamma", step_lr_gamma)
        if step_lr_step_size is not None:
            pulumi.set(__self__, "step_lr_step_size", step_lr_step_size)
        if tile_grid_size is not None:
            pulumi.set(__self__, "tile_grid_size", tile_grid_size)
        if tile_overlap_ratio is not None:
            pulumi.set(__self__, "tile_overlap_ratio", tile_overlap_ratio)
        if tile_predictions_nms_threshold is not None:
            pulumi.set(__self__, "tile_predictions_nms_threshold", tile_predictions_nms_threshold)
        if training_batch_size is not None:
            pulumi.set(__self__, "training_batch_size", training_batch_size)
        if validation_batch_size is not None:
            pulumi.set(__self__, "validation_batch_size", validation_batch_size)
        if validation_iou_threshold is not None:
            pulumi.set(__self__, "validation_iou_threshold", validation_iou_threshold)
        if validation_metric_type is not None:
            pulumi.set(__self__, "validation_metric_type", validation_metric_type)
        if warmup_cosine_lr_cycles is not None:
            pulumi.set(__self__, "warmup_cosine_lr_cycles", warmup_cosine_lr_cycles)
        if warmup_cosine_lr_warmup_epochs is not None:
            pulumi.set(__self__, "warmup_cosine_lr_warmup_epochs", warmup_cosine_lr_warmup_epochs)
        if weight_decay is not None:
            pulumi.set(__self__, "weight_decay", weight_decay)

    @property
    @pulumi.getter(name="amsGradient")
    def ams_gradient(self) -> Optional[str]:
        """
        Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        """
        return pulumi.get(self, "ams_gradient")

    @property
    @pulumi.getter
    def augmentations(self) -> Optional[str]:
        """
        Settings for using Augmentations.
        """
        return pulumi.get(self, "augmentations")

    @property
    @pulumi.getter
    def beta1(self) -> Optional[str]:
        """
        Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "beta1")

    @property
    @pulumi.getter
    def beta2(self) -> Optional[str]:
        """
        Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "beta2")

    @property
    @pulumi.getter(name="boxDetectionsPerImage")
    def box_detections_per_image(self) -> Optional[str]:
        """
        Maximum number of detections per image, for all classes. Must be a positive integer.
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "box_detections_per_image")

    @property
    @pulumi.getter(name="boxScoreThreshold")
    def box_score_threshold(self) -> Optional[str]:
        """
        During inference, only return proposals with a classification score greater than
        BoxScoreThreshold. Must be a float in the range[0, 1].
        """
        return pulumi.get(self, "box_score_threshold")

    @property
    @pulumi.getter
    def distributed(self) -> Optional[str]:
        """
        Whether to use distributer training.
        """
        return pulumi.get(self, "distributed")

    @property
    @pulumi.getter(name="earlyStopping")
    def early_stopping(self) -> Optional[str]:
        """
        Enable early stopping logic during training.
        """
        return pulumi.get(self, "early_stopping")

    @property
    @pulumi.getter(name="earlyStoppingDelay")
    def early_stopping_delay(self) -> Optional[str]:
        """
        Minimum number of epochs or validation evaluations to wait before primary metric improvement
        is tracked for early stopping. Must be a positive integer.
        """
        return pulumi.get(self, "early_stopping_delay")

    @property
    @pulumi.getter(name="earlyStoppingPatience")
    def early_stopping_patience(self) -> Optional[str]:
        """
        Minimum number of epochs or validation evaluations with no primary metric improvement before
        the run is stopped. Must be a positive integer.
        """
        return pulumi.get(self, "early_stopping_patience")

    @property
    @pulumi.getter(name="enableOnnxNormalization")
    def enable_onnx_normalization(self) -> Optional[str]:
        """
        Enable normalization when exporting ONNX model.
        """
        return pulumi.get(self, "enable_onnx_normalization")

    @property
    @pulumi.getter(name="evaluationFrequency")
    def evaluation_frequency(self) -> Optional[str]:
        """
        Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
        """
        return pulumi.get(self, "evaluation_frequency")

    @property
    @pulumi.getter(name="gradientAccumulationStep")
    def gradient_accumulation_step(self) -> Optional[str]:
        """
        Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
        updating the model weights while accumulating the gradients of those steps, and then using
        the accumulated gradients to compute the weight updates. Must be a positive integer.
        """
        return pulumi.get(self, "gradient_accumulation_step")

    @property
    @pulumi.getter(name="imageSize")
    def image_size(self) -> Optional[str]:
        """
        Image size for train and validation. Must be a positive integer.
        Note: The training run may get into CUDA OOM if the size is too big.
        Note: This settings is only supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "image_size")

    @property
    @pulumi.getter(name="layersToFreeze")
    def layers_to_freeze(self) -> Optional[str]:
        """
        Number of layers to freeze for the model. Must be a positive integer.
        For instance, passing 2 as value for 'seresnext' means
        freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
        see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        """
        return pulumi.get(self, "layers_to_freeze")

    @property
    @pulumi.getter(name="learningRate")
    def learning_rate(self) -> Optional[str]:
        """
        Initial learning rate. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "learning_rate")

    @property
    @pulumi.getter(name="learningRateScheduler")
    def learning_rate_scheduler(self) -> Optional[str]:
        """
        Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
        """
        return pulumi.get(self, "learning_rate_scheduler")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[str]:
        """
        Maximum size of the image to be rescaled before feeding it to the backbone.
        Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[str]:
        """
        Minimum size of the image to be rescaled before feeding it to the backbone.
        Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[str]:
        """
        Name of the model to use for training.
        For more information on the available models please visit the official documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        """
        return pulumi.get(self, "model_name")

    @property
    @pulumi.getter(name="modelSize")
    def model_size(self) -> Optional[str]:
        """
        Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
        Note: training run may get into CUDA OOM if the model size is too big.
        Note: This settings is only supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "model_size")

    @property
    @pulumi.getter
    def momentum(self) -> Optional[str]:
        """
        Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "momentum")

    @property
    @pulumi.getter(name="multiScale")
    def multi_scale(self) -> Optional[str]:
        """
        Enable multi-scale image by varying image size by +/- 50%.
        Note: training run may get into CUDA OOM if no sufficient GPU memory.
        Note: This settings is only supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "multi_scale")

    @property
    @pulumi.getter
    def nesterov(self) -> Optional[str]:
        """
        Enable nesterov when optimizer is 'sgd'.
        """
        return pulumi.get(self, "nesterov")

    @property
    @pulumi.getter(name="nmsIouThreshold")
    def nms_iou_threshold(self) -> Optional[str]:
        """
        IOU threshold used during inference in NMS post processing. Must be float in the range [0, 1].
        """
        return pulumi.get(self, "nms_iou_threshold")

    @property
    @pulumi.getter(name="numberOfEpochs")
    def number_of_epochs(self) -> Optional[str]:
        """
        Number of training epochs. Must be a positive integer.
        """
        return pulumi.get(self, "number_of_epochs")

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> Optional[str]:
        """
        Number of data loader workers. Must be a non-negative integer.
        """
        return pulumi.get(self, "number_of_workers")

    @property
    @pulumi.getter
    def optimizer(self) -> Optional[str]:
        """
        Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        """
        return pulumi.get(self, "optimizer")

    @property
    @pulumi.getter(name="randomSeed")
    def random_seed(self) -> Optional[str]:
        """
        Random seed to be used when using deterministic training.
        """
        return pulumi.get(self, "random_seed")

    @property
    @pulumi.getter(name="stepLRGamma")
    def step_lr_gamma(self) -> Optional[str]:
        """
        Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "step_lr_gamma")

    @property
    @pulumi.getter(name="stepLRStepSize")
    def step_lr_step_size(self) -> Optional[str]:
        """
        Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
        """
        return pulumi.get(self, "step_lr_step_size")

    @property
    @pulumi.getter(name="tileGridSize")
    def tile_grid_size(self) -> Optional[str]:
        """
        The grid size to use for tiling each image. Note: TileGridSize must not be
        None to enable small object detection logic. A string containing two integers in mxn format.
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "tile_grid_size")

    @property
    @pulumi.getter(name="tileOverlapRatio")
    def tile_overlap_ratio(self) -> Optional[str]:
        """
        Overlap ratio between adjacent tiles in each dimension. Must be float in the range [0, 1).
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "tile_overlap_ratio")

    @property
    @pulumi.getter(name="tilePredictionsNmsThreshold")
    def tile_predictions_nms_threshold(self) -> Optional[str]:
        """
        The IOU threshold to use to perform NMS while merging predictions from tiles and image.
        Used in validation/ inference. Must be float in the range [0, 1].
        Note: This settings is not supported for the 'yolov5' algorithm.
        NMS: Non-maximum suppression
        """
        return pulumi.get(self, "tile_predictions_nms_threshold")

    @property
    @pulumi.getter(name="trainingBatchSize")
    def training_batch_size(self) -> Optional[str]:
        """
        Training batch size. Must be a positive integer.
        """
        return pulumi.get(self, "training_batch_size")

    @property
    @pulumi.getter(name="validationBatchSize")
    def validation_batch_size(self) -> Optional[str]:
        """
        Validation batch size. Must be a positive integer.
        """
        return pulumi.get(self, "validation_batch_size")

    @property
    @pulumi.getter(name="validationIouThreshold")
    def validation_iou_threshold(self) -> Optional[str]:
        """
        IOU threshold to use when computing validation metric. Must be float in the range [0, 1].
        """
        return pulumi.get(self, "validation_iou_threshold")

    @property
    @pulumi.getter(name="validationMetricType")
    def validation_metric_type(self) -> Optional[str]:
        """
        Metric computation method to use for validation metrics. Must be 'none', 'coco', 'voc', or 'coco_voc'.
        """
        return pulumi.get(self, "validation_metric_type")

    @property
    @pulumi.getter(name="warmupCosineLRCycles")
    def warmup_cosine_lr_cycles(self) -> Optional[str]:
        """
        Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "warmup_cosine_lr_cycles")

    @property
    @pulumi.getter(name="warmupCosineLRWarmupEpochs")
    def warmup_cosine_lr_warmup_epochs(self) -> Optional[str]:
        """
        Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
        """
        return pulumi.get(self, "warmup_cosine_lr_warmup_epochs")

    @property
    @pulumi.getter(name="weightDecay")
    def weight_decay(self) -> Optional[str]:
        """
        Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
        """
        return pulumi.get(self, "weight_decay")


@pulumi.output_type
class ImageModelSettingsClassificationResponse(dict):
    """
    Settings used for training the model.
    For more information on the available settings please visit the official documentation:
    https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advancedSettings":
            suggest = "advanced_settings"
        elif key == "amsGradient":
            suggest = "ams_gradient"
        elif key == "checkpointFrequency":
            suggest = "checkpoint_frequency"
        elif key == "checkpointModel":
            suggest = "checkpoint_model"
        elif key == "checkpointRunId":
            suggest = "checkpoint_run_id"
        elif key == "earlyStopping":
            suggest = "early_stopping"
        elif key == "earlyStoppingDelay":
            suggest = "early_stopping_delay"
        elif key == "earlyStoppingPatience":
            suggest = "early_stopping_patience"
        elif key == "enableOnnxNormalization":
            suggest = "enable_onnx_normalization"
        elif key == "evaluationFrequency":
            suggest = "evaluation_frequency"
        elif key == "gradientAccumulationStep":
            suggest = "gradient_accumulation_step"
        elif key == "layersToFreeze":
            suggest = "layers_to_freeze"
        elif key == "learningRate":
            suggest = "learning_rate"
        elif key == "learningRateScheduler":
            suggest = "learning_rate_scheduler"
        elif key == "modelName":
            suggest = "model_name"
        elif key == "numberOfEpochs":
            suggest = "number_of_epochs"
        elif key == "numberOfWorkers":
            suggest = "number_of_workers"
        elif key == "randomSeed":
            suggest = "random_seed"
        elif key == "stepLRGamma":
            suggest = "step_lr_gamma"
        elif key == "stepLRStepSize":
            suggest = "step_lr_step_size"
        elif key == "trainingBatchSize":
            suggest = "training_batch_size"
        elif key == "trainingCropSize":
            suggest = "training_crop_size"
        elif key == "validationBatchSize":
            suggest = "validation_batch_size"
        elif key == "validationCropSize":
            suggest = "validation_crop_size"
        elif key == "validationResizeSize":
            suggest = "validation_resize_size"
        elif key == "warmupCosineLRCycles":
            suggest = "warmup_cosine_lr_cycles"
        elif key == "warmupCosineLRWarmupEpochs":
            suggest = "warmup_cosine_lr_warmup_epochs"
        elif key == "weightDecay":
            suggest = "weight_decay"
        elif key == "weightedLoss":
            suggest = "weighted_loss"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageModelSettingsClassificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageModelSettingsClassificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageModelSettingsClassificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advanced_settings: Optional[str] = None,
                 ams_gradient: Optional[bool] = None,
                 augmentations: Optional[str] = None,
                 beta1: Optional[float] = None,
                 beta2: Optional[float] = None,
                 checkpoint_frequency: Optional[int] = None,
                 checkpoint_model: Optional['outputs.MLFlowModelJobInputResponse'] = None,
                 checkpoint_run_id: Optional[str] = None,
                 distributed: Optional[bool] = None,
                 early_stopping: Optional[bool] = None,
                 early_stopping_delay: Optional[int] = None,
                 early_stopping_patience: Optional[int] = None,
                 enable_onnx_normalization: Optional[bool] = None,
                 evaluation_frequency: Optional[int] = None,
                 gradient_accumulation_step: Optional[int] = None,
                 layers_to_freeze: Optional[int] = None,
                 learning_rate: Optional[float] = None,
                 learning_rate_scheduler: Optional[str] = None,
                 model_name: Optional[str] = None,
                 momentum: Optional[float] = None,
                 nesterov: Optional[bool] = None,
                 number_of_epochs: Optional[int] = None,
                 number_of_workers: Optional[int] = None,
                 optimizer: Optional[str] = None,
                 random_seed: Optional[int] = None,
                 step_lr_gamma: Optional[float] = None,
                 step_lr_step_size: Optional[int] = None,
                 training_batch_size: Optional[int] = None,
                 training_crop_size: Optional[int] = None,
                 validation_batch_size: Optional[int] = None,
                 validation_crop_size: Optional[int] = None,
                 validation_resize_size: Optional[int] = None,
                 warmup_cosine_lr_cycles: Optional[float] = None,
                 warmup_cosine_lr_warmup_epochs: Optional[int] = None,
                 weight_decay: Optional[float] = None,
                 weighted_loss: Optional[int] = None):
        """
        Settings used for training the model.
        For more information on the available settings please visit the official documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param str advanced_settings: Settings for advanced scenarios.
        :param bool ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :param str augmentations: Settings for using Augmentations.
        :param float beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        :param float beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        :param int checkpoint_frequency: Frequency to store model checkpoints. Must be a positive integer.
        :param 'MLFlowModelJobInputResponse' checkpoint_model: The pretrained checkpoint model for incremental training.
        :param str checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for incremental training.
        :param bool distributed: Whether to use distributed training.
        :param bool early_stopping: Enable early stopping logic during training.
        :param int early_stopping_delay: Minimum number of epochs or validation evaluations to wait before primary metric improvement
               is tracked for early stopping. Must be a positive integer.
        :param int early_stopping_patience: Minimum number of epochs or validation evaluations with no primary metric improvement before
               the run is stopped. Must be a positive integer.
        :param bool enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :param int evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
        :param int gradient_accumulation_step: Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
               updating the model weights while accumulating the gradients of those steps, and then using
               the accumulated gradients to compute the weight updates. Must be a positive integer.
        :param int layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
               For instance, passing 2 as value for 'seresnext' means
               freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
               see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param float learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :param str learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
        :param str model_name: Name of the model to use for training.
               For more information on the available models please visit the official documentation:
               https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param float momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
        :param bool nesterov: Enable nesterov when optimizer is 'sgd'.
        :param int number_of_epochs: Number of training epochs. Must be a positive integer.
        :param int number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :param str optimizer: Type of optimizer.
        :param int random_seed: Random seed to be used when using deterministic training.
        :param float step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
        :param int step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
        :param int training_batch_size: Training batch size. Must be a positive integer.
        :param int training_crop_size: Image crop size that is input to the neural network for the training dataset. Must be a positive integer.
        :param int validation_batch_size: Validation batch size. Must be a positive integer.
        :param int validation_crop_size: Image crop size that is input to the neural network for the validation dataset. Must be a positive integer.
        :param int validation_resize_size: Image size to which to resize before cropping for validation dataset. Must be a positive integer.
        :param float warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
        :param int warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
        :param float weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
        :param int weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
               1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be 0 or 1 or 2.
        """
        if advanced_settings is not None:
            pulumi.set(__self__, "advanced_settings", advanced_settings)
        if ams_gradient is not None:
            pulumi.set(__self__, "ams_gradient", ams_gradient)
        if augmentations is not None:
            pulumi.set(__self__, "augmentations", augmentations)
        if beta1 is not None:
            pulumi.set(__self__, "beta1", beta1)
        if beta2 is not None:
            pulumi.set(__self__, "beta2", beta2)
        if checkpoint_frequency is not None:
            pulumi.set(__self__, "checkpoint_frequency", checkpoint_frequency)
        if checkpoint_model is not None:
            pulumi.set(__self__, "checkpoint_model", checkpoint_model)
        if checkpoint_run_id is not None:
            pulumi.set(__self__, "checkpoint_run_id", checkpoint_run_id)
        if distributed is not None:
            pulumi.set(__self__, "distributed", distributed)
        if early_stopping is not None:
            pulumi.set(__self__, "early_stopping", early_stopping)
        if early_stopping_delay is not None:
            pulumi.set(__self__, "early_stopping_delay", early_stopping_delay)
        if early_stopping_patience is not None:
            pulumi.set(__self__, "early_stopping_patience", early_stopping_patience)
        if enable_onnx_normalization is not None:
            pulumi.set(__self__, "enable_onnx_normalization", enable_onnx_normalization)
        if evaluation_frequency is not None:
            pulumi.set(__self__, "evaluation_frequency", evaluation_frequency)
        if gradient_accumulation_step is not None:
            pulumi.set(__self__, "gradient_accumulation_step", gradient_accumulation_step)
        if layers_to_freeze is not None:
            pulumi.set(__self__, "layers_to_freeze", layers_to_freeze)
        if learning_rate is not None:
            pulumi.set(__self__, "learning_rate", learning_rate)
        if learning_rate_scheduler is None:
            learning_rate_scheduler = 'None'
        if learning_rate_scheduler is not None:
            pulumi.set(__self__, "learning_rate_scheduler", learning_rate_scheduler)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if momentum is not None:
            pulumi.set(__self__, "momentum", momentum)
        if nesterov is not None:
            pulumi.set(__self__, "nesterov", nesterov)
        if number_of_epochs is not None:
            pulumi.set(__self__, "number_of_epochs", number_of_epochs)
        if number_of_workers is not None:
            pulumi.set(__self__, "number_of_workers", number_of_workers)
        if optimizer is None:
            optimizer = 'None'
        if optimizer is not None:
            pulumi.set(__self__, "optimizer", optimizer)
        if random_seed is not None:
            pulumi.set(__self__, "random_seed", random_seed)
        if step_lr_gamma is not None:
            pulumi.set(__self__, "step_lr_gamma", step_lr_gamma)
        if step_lr_step_size is not None:
            pulumi.set(__self__, "step_lr_step_size", step_lr_step_size)
        if training_batch_size is not None:
            pulumi.set(__self__, "training_batch_size", training_batch_size)
        if training_crop_size is not None:
            pulumi.set(__self__, "training_crop_size", training_crop_size)
        if validation_batch_size is not None:
            pulumi.set(__self__, "validation_batch_size", validation_batch_size)
        if validation_crop_size is not None:
            pulumi.set(__self__, "validation_crop_size", validation_crop_size)
        if validation_resize_size is not None:
            pulumi.set(__self__, "validation_resize_size", validation_resize_size)
        if warmup_cosine_lr_cycles is not None:
            pulumi.set(__self__, "warmup_cosine_lr_cycles", warmup_cosine_lr_cycles)
        if warmup_cosine_lr_warmup_epochs is not None:
            pulumi.set(__self__, "warmup_cosine_lr_warmup_epochs", warmup_cosine_lr_warmup_epochs)
        if weight_decay is not None:
            pulumi.set(__self__, "weight_decay", weight_decay)
        if weighted_loss is not None:
            pulumi.set(__self__, "weighted_loss", weighted_loss)

    @property
    @pulumi.getter(name="advancedSettings")
    def advanced_settings(self) -> Optional[str]:
        """
        Settings for advanced scenarios.
        """
        return pulumi.get(self, "advanced_settings")

    @property
    @pulumi.getter(name="amsGradient")
    def ams_gradient(self) -> Optional[bool]:
        """
        Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        """
        return pulumi.get(self, "ams_gradient")

    @property
    @pulumi.getter
    def augmentations(self) -> Optional[str]:
        """
        Settings for using Augmentations.
        """
        return pulumi.get(self, "augmentations")

    @property
    @pulumi.getter
    def beta1(self) -> Optional[float]:
        """
        Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "beta1")

    @property
    @pulumi.getter
    def beta2(self) -> Optional[float]:
        """
        Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "beta2")

    @property
    @pulumi.getter(name="checkpointFrequency")
    def checkpoint_frequency(self) -> Optional[int]:
        """
        Frequency to store model checkpoints. Must be a positive integer.
        """
        return pulumi.get(self, "checkpoint_frequency")

    @property
    @pulumi.getter(name="checkpointModel")
    def checkpoint_model(self) -> Optional['outputs.MLFlowModelJobInputResponse']:
        """
        The pretrained checkpoint model for incremental training.
        """
        return pulumi.get(self, "checkpoint_model")

    @property
    @pulumi.getter(name="checkpointRunId")
    def checkpoint_run_id(self) -> Optional[str]:
        """
        The id of a previous run that has a pretrained checkpoint for incremental training.
        """
        return pulumi.get(self, "checkpoint_run_id")

    @property
    @pulumi.getter
    def distributed(self) -> Optional[bool]:
        """
        Whether to use distributed training.
        """
        return pulumi.get(self, "distributed")

    @property
    @pulumi.getter(name="earlyStopping")
    def early_stopping(self) -> Optional[bool]:
        """
        Enable early stopping logic during training.
        """
        return pulumi.get(self, "early_stopping")

    @property
    @pulumi.getter(name="earlyStoppingDelay")
    def early_stopping_delay(self) -> Optional[int]:
        """
        Minimum number of epochs or validation evaluations to wait before primary metric improvement
        is tracked for early stopping. Must be a positive integer.
        """
        return pulumi.get(self, "early_stopping_delay")

    @property
    @pulumi.getter(name="earlyStoppingPatience")
    def early_stopping_patience(self) -> Optional[int]:
        """
        Minimum number of epochs or validation evaluations with no primary metric improvement before
        the run is stopped. Must be a positive integer.
        """
        return pulumi.get(self, "early_stopping_patience")

    @property
    @pulumi.getter(name="enableOnnxNormalization")
    def enable_onnx_normalization(self) -> Optional[bool]:
        """
        Enable normalization when exporting ONNX model.
        """
        return pulumi.get(self, "enable_onnx_normalization")

    @property
    @pulumi.getter(name="evaluationFrequency")
    def evaluation_frequency(self) -> Optional[int]:
        """
        Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
        """
        return pulumi.get(self, "evaluation_frequency")

    @property
    @pulumi.getter(name="gradientAccumulationStep")
    def gradient_accumulation_step(self) -> Optional[int]:
        """
        Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
        updating the model weights while accumulating the gradients of those steps, and then using
        the accumulated gradients to compute the weight updates. Must be a positive integer.
        """
        return pulumi.get(self, "gradient_accumulation_step")

    @property
    @pulumi.getter(name="layersToFreeze")
    def layers_to_freeze(self) -> Optional[int]:
        """
        Number of layers to freeze for the model. Must be a positive integer.
        For instance, passing 2 as value for 'seresnext' means
        freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
        see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        """
        return pulumi.get(self, "layers_to_freeze")

    @property
    @pulumi.getter(name="learningRate")
    def learning_rate(self) -> Optional[float]:
        """
        Initial learning rate. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "learning_rate")

    @property
    @pulumi.getter(name="learningRateScheduler")
    def learning_rate_scheduler(self) -> Optional[str]:
        """
        Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
        """
        return pulumi.get(self, "learning_rate_scheduler")

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[str]:
        """
        Name of the model to use for training.
        For more information on the available models please visit the official documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        """
        return pulumi.get(self, "model_name")

    @property
    @pulumi.getter
    def momentum(self) -> Optional[float]:
        """
        Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "momentum")

    @property
    @pulumi.getter
    def nesterov(self) -> Optional[bool]:
        """
        Enable nesterov when optimizer is 'sgd'.
        """
        return pulumi.get(self, "nesterov")

    @property
    @pulumi.getter(name="numberOfEpochs")
    def number_of_epochs(self) -> Optional[int]:
        """
        Number of training epochs. Must be a positive integer.
        """
        return pulumi.get(self, "number_of_epochs")

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> Optional[int]:
        """
        Number of data loader workers. Must be a non-negative integer.
        """
        return pulumi.get(self, "number_of_workers")

    @property
    @pulumi.getter
    def optimizer(self) -> Optional[str]:
        """
        Type of optimizer.
        """
        return pulumi.get(self, "optimizer")

    @property
    @pulumi.getter(name="randomSeed")
    def random_seed(self) -> Optional[int]:
        """
        Random seed to be used when using deterministic training.
        """
        return pulumi.get(self, "random_seed")

    @property
    @pulumi.getter(name="stepLRGamma")
    def step_lr_gamma(self) -> Optional[float]:
        """
        Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "step_lr_gamma")

    @property
    @pulumi.getter(name="stepLRStepSize")
    def step_lr_step_size(self) -> Optional[int]:
        """
        Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
        """
        return pulumi.get(self, "step_lr_step_size")

    @property
    @pulumi.getter(name="trainingBatchSize")
    def training_batch_size(self) -> Optional[int]:
        """
        Training batch size. Must be a positive integer.
        """
        return pulumi.get(self, "training_batch_size")

    @property
    @pulumi.getter(name="trainingCropSize")
    def training_crop_size(self) -> Optional[int]:
        """
        Image crop size that is input to the neural network for the training dataset. Must be a positive integer.
        """
        return pulumi.get(self, "training_crop_size")

    @property
    @pulumi.getter(name="validationBatchSize")
    def validation_batch_size(self) -> Optional[int]:
        """
        Validation batch size. Must be a positive integer.
        """
        return pulumi.get(self, "validation_batch_size")

    @property
    @pulumi.getter(name="validationCropSize")
    def validation_crop_size(self) -> Optional[int]:
        """
        Image crop size that is input to the neural network for the validation dataset. Must be a positive integer.
        """
        return pulumi.get(self, "validation_crop_size")

    @property
    @pulumi.getter(name="validationResizeSize")
    def validation_resize_size(self) -> Optional[int]:
        """
        Image size to which to resize before cropping for validation dataset. Must be a positive integer.
        """
        return pulumi.get(self, "validation_resize_size")

    @property
    @pulumi.getter(name="warmupCosineLRCycles")
    def warmup_cosine_lr_cycles(self) -> Optional[float]:
        """
        Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "warmup_cosine_lr_cycles")

    @property
    @pulumi.getter(name="warmupCosineLRWarmupEpochs")
    def warmup_cosine_lr_warmup_epochs(self) -> Optional[int]:
        """
        Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
        """
        return pulumi.get(self, "warmup_cosine_lr_warmup_epochs")

    @property
    @pulumi.getter(name="weightDecay")
    def weight_decay(self) -> Optional[float]:
        """
        Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
        """
        return pulumi.get(self, "weight_decay")

    @property
    @pulumi.getter(name="weightedLoss")
    def weighted_loss(self) -> Optional[int]:
        """
        Weighted loss. The accepted values are 0 for no weighted loss.
        1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be 0 or 1 or 2.
        """
        return pulumi.get(self, "weighted_loss")


@pulumi.output_type
class ImageModelSettingsObjectDetectionResponse(dict):
    """
    Settings used for training the model.
    For more information on the available settings please visit the official documentation:
    https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advancedSettings":
            suggest = "advanced_settings"
        elif key == "amsGradient":
            suggest = "ams_gradient"
        elif key == "boxDetectionsPerImage":
            suggest = "box_detections_per_image"
        elif key == "boxScoreThreshold":
            suggest = "box_score_threshold"
        elif key == "checkpointFrequency":
            suggest = "checkpoint_frequency"
        elif key == "checkpointModel":
            suggest = "checkpoint_model"
        elif key == "checkpointRunId":
            suggest = "checkpoint_run_id"
        elif key == "earlyStopping":
            suggest = "early_stopping"
        elif key == "earlyStoppingDelay":
            suggest = "early_stopping_delay"
        elif key == "earlyStoppingPatience":
            suggest = "early_stopping_patience"
        elif key == "enableOnnxNormalization":
            suggest = "enable_onnx_normalization"
        elif key == "evaluationFrequency":
            suggest = "evaluation_frequency"
        elif key == "gradientAccumulationStep":
            suggest = "gradient_accumulation_step"
        elif key == "imageSize":
            suggest = "image_size"
        elif key == "layersToFreeze":
            suggest = "layers_to_freeze"
        elif key == "learningRate":
            suggest = "learning_rate"
        elif key == "learningRateScheduler":
            suggest = "learning_rate_scheduler"
        elif key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"
        elif key == "modelName":
            suggest = "model_name"
        elif key == "modelSize":
            suggest = "model_size"
        elif key == "multiScale":
            suggest = "multi_scale"
        elif key == "nmsIouThreshold":
            suggest = "nms_iou_threshold"
        elif key == "numberOfEpochs":
            suggest = "number_of_epochs"
        elif key == "numberOfWorkers":
            suggest = "number_of_workers"
        elif key == "randomSeed":
            suggest = "random_seed"
        elif key == "stepLRGamma":
            suggest = "step_lr_gamma"
        elif key == "stepLRStepSize":
            suggest = "step_lr_step_size"
        elif key == "tileGridSize":
            suggest = "tile_grid_size"
        elif key == "tileOverlapRatio":
            suggest = "tile_overlap_ratio"
        elif key == "tilePredictionsNmsThreshold":
            suggest = "tile_predictions_nms_threshold"
        elif key == "trainingBatchSize":
            suggest = "training_batch_size"
        elif key == "validationBatchSize":
            suggest = "validation_batch_size"
        elif key == "validationIouThreshold":
            suggest = "validation_iou_threshold"
        elif key == "validationMetricType":
            suggest = "validation_metric_type"
        elif key == "warmupCosineLRCycles":
            suggest = "warmup_cosine_lr_cycles"
        elif key == "warmupCosineLRWarmupEpochs":
            suggest = "warmup_cosine_lr_warmup_epochs"
        elif key == "weightDecay":
            suggest = "weight_decay"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageModelSettingsObjectDetectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageModelSettingsObjectDetectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageModelSettingsObjectDetectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advanced_settings: Optional[str] = None,
                 ams_gradient: Optional[bool] = None,
                 augmentations: Optional[str] = None,
                 beta1: Optional[float] = None,
                 beta2: Optional[float] = None,
                 box_detections_per_image: Optional[int] = None,
                 box_score_threshold: Optional[float] = None,
                 checkpoint_frequency: Optional[int] = None,
                 checkpoint_model: Optional['outputs.MLFlowModelJobInputResponse'] = None,
                 checkpoint_run_id: Optional[str] = None,
                 distributed: Optional[bool] = None,
                 early_stopping: Optional[bool] = None,
                 early_stopping_delay: Optional[int] = None,
                 early_stopping_patience: Optional[int] = None,
                 enable_onnx_normalization: Optional[bool] = None,
                 evaluation_frequency: Optional[int] = None,
                 gradient_accumulation_step: Optional[int] = None,
                 image_size: Optional[int] = None,
                 layers_to_freeze: Optional[int] = None,
                 learning_rate: Optional[float] = None,
                 learning_rate_scheduler: Optional[str] = None,
                 max_size: Optional[int] = None,
                 min_size: Optional[int] = None,
                 model_name: Optional[str] = None,
                 model_size: Optional[str] = None,
                 momentum: Optional[float] = None,
                 multi_scale: Optional[bool] = None,
                 nesterov: Optional[bool] = None,
                 nms_iou_threshold: Optional[float] = None,
                 number_of_epochs: Optional[int] = None,
                 number_of_workers: Optional[int] = None,
                 optimizer: Optional[str] = None,
                 random_seed: Optional[int] = None,
                 step_lr_gamma: Optional[float] = None,
                 step_lr_step_size: Optional[int] = None,
                 tile_grid_size: Optional[str] = None,
                 tile_overlap_ratio: Optional[float] = None,
                 tile_predictions_nms_threshold: Optional[float] = None,
                 training_batch_size: Optional[int] = None,
                 validation_batch_size: Optional[int] = None,
                 validation_iou_threshold: Optional[float] = None,
                 validation_metric_type: Optional[str] = None,
                 warmup_cosine_lr_cycles: Optional[float] = None,
                 warmup_cosine_lr_warmup_epochs: Optional[int] = None,
                 weight_decay: Optional[float] = None):
        """
        Settings used for training the model.
        For more information on the available settings please visit the official documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param str advanced_settings: Settings for advanced scenarios.
        :param bool ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :param str augmentations: Settings for using Augmentations.
        :param float beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        :param float beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        :param int box_detections_per_image: Maximum number of detections per image, for all classes. Must be a positive integer.
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param float box_score_threshold: During inference, only return proposals with a classification score greater than
               BoxScoreThreshold. Must be a float in the range[0, 1].
        :param int checkpoint_frequency: Frequency to store model checkpoints. Must be a positive integer.
        :param 'MLFlowModelJobInputResponse' checkpoint_model: The pretrained checkpoint model for incremental training.
        :param str checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for incremental training.
        :param bool distributed: Whether to use distributed training.
        :param bool early_stopping: Enable early stopping logic during training.
        :param int early_stopping_delay: Minimum number of epochs or validation evaluations to wait before primary metric improvement
               is tracked for early stopping. Must be a positive integer.
        :param int early_stopping_patience: Minimum number of epochs or validation evaluations with no primary metric improvement before
               the run is stopped. Must be a positive integer.
        :param bool enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :param int evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
        :param int gradient_accumulation_step: Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
               updating the model weights while accumulating the gradients of those steps, and then using
               the accumulated gradients to compute the weight updates. Must be a positive integer.
        :param int image_size: Image size for train and validation. Must be a positive integer.
               Note: The training run may get into CUDA OOM if the size is too big.
               Note: This settings is only supported for the 'yolov5' algorithm.
        :param int layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
               For instance, passing 2 as value for 'seresnext' means
               freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
               see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param float learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :param str learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
        :param int max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
               Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param int min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
               Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param str model_name: Name of the model to use for training.
               For more information on the available models please visit the official documentation:
               https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param str model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
               Note: training run may get into CUDA OOM if the model size is too big.
               Note: This settings is only supported for the 'yolov5' algorithm.
        :param float momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
        :param bool multi_scale: Enable multi-scale image by varying image size by +/- 50%.
               Note: training run may get into CUDA OOM if no sufficient GPU memory.
               Note: This settings is only supported for the 'yolov5' algorithm.
        :param bool nesterov: Enable nesterov when optimizer is 'sgd'.
        :param float nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be a float in the range [0, 1].
        :param int number_of_epochs: Number of training epochs. Must be a positive integer.
        :param int number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :param str optimizer: Type of optimizer.
        :param int random_seed: Random seed to be used when using deterministic training.
        :param float step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
        :param int step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
        :param str tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must not be
               None to enable small object detection logic. A string containing two integers in mxn format.
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param float tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be float in the range [0, 1).
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param float tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging predictions from tiles and image.
               Used in validation/ inference. Must be float in the range [0, 1].
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param int training_batch_size: Training batch size. Must be a positive integer.
        :param int validation_batch_size: Validation batch size. Must be a positive integer.
        :param float validation_iou_threshold: IOU threshold to use when computing validation metric. Must be float in the range [0, 1].
        :param str validation_metric_type: Metric computation method to use for validation metrics.
        :param float warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
        :param int warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
        :param float weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
        """
        if advanced_settings is not None:
            pulumi.set(__self__, "advanced_settings", advanced_settings)
        if ams_gradient is not None:
            pulumi.set(__self__, "ams_gradient", ams_gradient)
        if augmentations is not None:
            pulumi.set(__self__, "augmentations", augmentations)
        if beta1 is not None:
            pulumi.set(__self__, "beta1", beta1)
        if beta2 is not None:
            pulumi.set(__self__, "beta2", beta2)
        if box_detections_per_image is not None:
            pulumi.set(__self__, "box_detections_per_image", box_detections_per_image)
        if box_score_threshold is not None:
            pulumi.set(__self__, "box_score_threshold", box_score_threshold)
        if checkpoint_frequency is not None:
            pulumi.set(__self__, "checkpoint_frequency", checkpoint_frequency)
        if checkpoint_model is not None:
            pulumi.set(__self__, "checkpoint_model", checkpoint_model)
        if checkpoint_run_id is not None:
            pulumi.set(__self__, "checkpoint_run_id", checkpoint_run_id)
        if distributed is not None:
            pulumi.set(__self__, "distributed", distributed)
        if early_stopping is not None:
            pulumi.set(__self__, "early_stopping", early_stopping)
        if early_stopping_delay is not None:
            pulumi.set(__self__, "early_stopping_delay", early_stopping_delay)
        if early_stopping_patience is not None:
            pulumi.set(__self__, "early_stopping_patience", early_stopping_patience)
        if enable_onnx_normalization is not None:
            pulumi.set(__self__, "enable_onnx_normalization", enable_onnx_normalization)
        if evaluation_frequency is not None:
            pulumi.set(__self__, "evaluation_frequency", evaluation_frequency)
        if gradient_accumulation_step is not None:
            pulumi.set(__self__, "gradient_accumulation_step", gradient_accumulation_step)
        if image_size is not None:
            pulumi.set(__self__, "image_size", image_size)
        if layers_to_freeze is not None:
            pulumi.set(__self__, "layers_to_freeze", layers_to_freeze)
        if learning_rate is not None:
            pulumi.set(__self__, "learning_rate", learning_rate)
        if learning_rate_scheduler is None:
            learning_rate_scheduler = 'None'
        if learning_rate_scheduler is not None:
            pulumi.set(__self__, "learning_rate_scheduler", learning_rate_scheduler)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if model_size is None:
            model_size = 'None'
        if model_size is not None:
            pulumi.set(__self__, "model_size", model_size)
        if momentum is not None:
            pulumi.set(__self__, "momentum", momentum)
        if multi_scale is not None:
            pulumi.set(__self__, "multi_scale", multi_scale)
        if nesterov is not None:
            pulumi.set(__self__, "nesterov", nesterov)
        if nms_iou_threshold is not None:
            pulumi.set(__self__, "nms_iou_threshold", nms_iou_threshold)
        if number_of_epochs is not None:
            pulumi.set(__self__, "number_of_epochs", number_of_epochs)
        if number_of_workers is not None:
            pulumi.set(__self__, "number_of_workers", number_of_workers)
        if optimizer is None:
            optimizer = 'None'
        if optimizer is not None:
            pulumi.set(__self__, "optimizer", optimizer)
        if random_seed is not None:
            pulumi.set(__self__, "random_seed", random_seed)
        if step_lr_gamma is not None:
            pulumi.set(__self__, "step_lr_gamma", step_lr_gamma)
        if step_lr_step_size is not None:
            pulumi.set(__self__, "step_lr_step_size", step_lr_step_size)
        if tile_grid_size is not None:
            pulumi.set(__self__, "tile_grid_size", tile_grid_size)
        if tile_overlap_ratio is not None:
            pulumi.set(__self__, "tile_overlap_ratio", tile_overlap_ratio)
        if tile_predictions_nms_threshold is not None:
            pulumi.set(__self__, "tile_predictions_nms_threshold", tile_predictions_nms_threshold)
        if training_batch_size is not None:
            pulumi.set(__self__, "training_batch_size", training_batch_size)
        if validation_batch_size is not None:
            pulumi.set(__self__, "validation_batch_size", validation_batch_size)
        if validation_iou_threshold is not None:
            pulumi.set(__self__, "validation_iou_threshold", validation_iou_threshold)
        if validation_metric_type is None:
            validation_metric_type = 'None'
        if validation_metric_type is not None:
            pulumi.set(__self__, "validation_metric_type", validation_metric_type)
        if warmup_cosine_lr_cycles is not None:
            pulumi.set(__self__, "warmup_cosine_lr_cycles", warmup_cosine_lr_cycles)
        if warmup_cosine_lr_warmup_epochs is not None:
            pulumi.set(__self__, "warmup_cosine_lr_warmup_epochs", warmup_cosine_lr_warmup_epochs)
        if weight_decay is not None:
            pulumi.set(__self__, "weight_decay", weight_decay)

    @property
    @pulumi.getter(name="advancedSettings")
    def advanced_settings(self) -> Optional[str]:
        """
        Settings for advanced scenarios.
        """
        return pulumi.get(self, "advanced_settings")

    @property
    @pulumi.getter(name="amsGradient")
    def ams_gradient(self) -> Optional[bool]:
        """
        Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        """
        return pulumi.get(self, "ams_gradient")

    @property
    @pulumi.getter
    def augmentations(self) -> Optional[str]:
        """
        Settings for using Augmentations.
        """
        return pulumi.get(self, "augmentations")

    @property
    @pulumi.getter
    def beta1(self) -> Optional[float]:
        """
        Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "beta1")

    @property
    @pulumi.getter
    def beta2(self) -> Optional[float]:
        """
        Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "beta2")

    @property
    @pulumi.getter(name="boxDetectionsPerImage")
    def box_detections_per_image(self) -> Optional[int]:
        """
        Maximum number of detections per image, for all classes. Must be a positive integer.
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "box_detections_per_image")

    @property
    @pulumi.getter(name="boxScoreThreshold")
    def box_score_threshold(self) -> Optional[float]:
        """
        During inference, only return proposals with a classification score greater than
        BoxScoreThreshold. Must be a float in the range[0, 1].
        """
        return pulumi.get(self, "box_score_threshold")

    @property
    @pulumi.getter(name="checkpointFrequency")
    def checkpoint_frequency(self) -> Optional[int]:
        """
        Frequency to store model checkpoints. Must be a positive integer.
        """
        return pulumi.get(self, "checkpoint_frequency")

    @property
    @pulumi.getter(name="checkpointModel")
    def checkpoint_model(self) -> Optional['outputs.MLFlowModelJobInputResponse']:
        """
        The pretrained checkpoint model for incremental training.
        """
        return pulumi.get(self, "checkpoint_model")

    @property
    @pulumi.getter(name="checkpointRunId")
    def checkpoint_run_id(self) -> Optional[str]:
        """
        The id of a previous run that has a pretrained checkpoint for incremental training.
        """
        return pulumi.get(self, "checkpoint_run_id")

    @property
    @pulumi.getter
    def distributed(self) -> Optional[bool]:
        """
        Whether to use distributed training.
        """
        return pulumi.get(self, "distributed")

    @property
    @pulumi.getter(name="earlyStopping")
    def early_stopping(self) -> Optional[bool]:
        """
        Enable early stopping logic during training.
        """
        return pulumi.get(self, "early_stopping")

    @property
    @pulumi.getter(name="earlyStoppingDelay")
    def early_stopping_delay(self) -> Optional[int]:
        """
        Minimum number of epochs or validation evaluations to wait before primary metric improvement
        is tracked for early stopping. Must be a positive integer.
        """
        return pulumi.get(self, "early_stopping_delay")

    @property
    @pulumi.getter(name="earlyStoppingPatience")
    def early_stopping_patience(self) -> Optional[int]:
        """
        Minimum number of epochs or validation evaluations with no primary metric improvement before
        the run is stopped. Must be a positive integer.
        """
        return pulumi.get(self, "early_stopping_patience")

    @property
    @pulumi.getter(name="enableOnnxNormalization")
    def enable_onnx_normalization(self) -> Optional[bool]:
        """
        Enable normalization when exporting ONNX model.
        """
        return pulumi.get(self, "enable_onnx_normalization")

    @property
    @pulumi.getter(name="evaluationFrequency")
    def evaluation_frequency(self) -> Optional[int]:
        """
        Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
        """
        return pulumi.get(self, "evaluation_frequency")

    @property
    @pulumi.getter(name="gradientAccumulationStep")
    def gradient_accumulation_step(self) -> Optional[int]:
        """
        Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
        updating the model weights while accumulating the gradients of those steps, and then using
        the accumulated gradients to compute the weight updates. Must be a positive integer.
        """
        return pulumi.get(self, "gradient_accumulation_step")

    @property
    @pulumi.getter(name="imageSize")
    def image_size(self) -> Optional[int]:
        """
        Image size for train and validation. Must be a positive integer.
        Note: The training run may get into CUDA OOM if the size is too big.
        Note: This settings is only supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "image_size")

    @property
    @pulumi.getter(name="layersToFreeze")
    def layers_to_freeze(self) -> Optional[int]:
        """
        Number of layers to freeze for the model. Must be a positive integer.
        For instance, passing 2 as value for 'seresnext' means
        freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
        see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        """
        return pulumi.get(self, "layers_to_freeze")

    @property
    @pulumi.getter(name="learningRate")
    def learning_rate(self) -> Optional[float]:
        """
        Initial learning rate. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "learning_rate")

    @property
    @pulumi.getter(name="learningRateScheduler")
    def learning_rate_scheduler(self) -> Optional[str]:
        """
        Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
        """
        return pulumi.get(self, "learning_rate_scheduler")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[int]:
        """
        Maximum size of the image to be rescaled before feeding it to the backbone.
        Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[int]:
        """
        Minimum size of the image to be rescaled before feeding it to the backbone.
        Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[str]:
        """
        Name of the model to use for training.
        For more information on the available models please visit the official documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        """
        return pulumi.get(self, "model_name")

    @property
    @pulumi.getter(name="modelSize")
    def model_size(self) -> Optional[str]:
        """
        Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
        Note: training run may get into CUDA OOM if the model size is too big.
        Note: This settings is only supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "model_size")

    @property
    @pulumi.getter
    def momentum(self) -> Optional[float]:
        """
        Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "momentum")

    @property
    @pulumi.getter(name="multiScale")
    def multi_scale(self) -> Optional[bool]:
        """
        Enable multi-scale image by varying image size by +/- 50%.
        Note: training run may get into CUDA OOM if no sufficient GPU memory.
        Note: This settings is only supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "multi_scale")

    @property
    @pulumi.getter
    def nesterov(self) -> Optional[bool]:
        """
        Enable nesterov when optimizer is 'sgd'.
        """
        return pulumi.get(self, "nesterov")

    @property
    @pulumi.getter(name="nmsIouThreshold")
    def nms_iou_threshold(self) -> Optional[float]:
        """
        IOU threshold used during inference in NMS post processing. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "nms_iou_threshold")

    @property
    @pulumi.getter(name="numberOfEpochs")
    def number_of_epochs(self) -> Optional[int]:
        """
        Number of training epochs. Must be a positive integer.
        """
        return pulumi.get(self, "number_of_epochs")

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> Optional[int]:
        """
        Number of data loader workers. Must be a non-negative integer.
        """
        return pulumi.get(self, "number_of_workers")

    @property
    @pulumi.getter
    def optimizer(self) -> Optional[str]:
        """
        Type of optimizer.
        """
        return pulumi.get(self, "optimizer")

    @property
    @pulumi.getter(name="randomSeed")
    def random_seed(self) -> Optional[int]:
        """
        Random seed to be used when using deterministic training.
        """
        return pulumi.get(self, "random_seed")

    @property
    @pulumi.getter(name="stepLRGamma")
    def step_lr_gamma(self) -> Optional[float]:
        """
        Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "step_lr_gamma")

    @property
    @pulumi.getter(name="stepLRStepSize")
    def step_lr_step_size(self) -> Optional[int]:
        """
        Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
        """
        return pulumi.get(self, "step_lr_step_size")

    @property
    @pulumi.getter(name="tileGridSize")
    def tile_grid_size(self) -> Optional[str]:
        """
        The grid size to use for tiling each image. Note: TileGridSize must not be
        None to enable small object detection logic. A string containing two integers in mxn format.
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "tile_grid_size")

    @property
    @pulumi.getter(name="tileOverlapRatio")
    def tile_overlap_ratio(self) -> Optional[float]:
        """
        Overlap ratio between adjacent tiles in each dimension. Must be float in the range [0, 1).
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "tile_overlap_ratio")

    @property
    @pulumi.getter(name="tilePredictionsNmsThreshold")
    def tile_predictions_nms_threshold(self) -> Optional[float]:
        """
        The IOU threshold to use to perform NMS while merging predictions from tiles and image.
        Used in validation/ inference. Must be float in the range [0, 1].
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "tile_predictions_nms_threshold")

    @property
    @pulumi.getter(name="trainingBatchSize")
    def training_batch_size(self) -> Optional[int]:
        """
        Training batch size. Must be a positive integer.
        """
        return pulumi.get(self, "training_batch_size")

    @property
    @pulumi.getter(name="validationBatchSize")
    def validation_batch_size(self) -> Optional[int]:
        """
        Validation batch size. Must be a positive integer.
        """
        return pulumi.get(self, "validation_batch_size")

    @property
    @pulumi.getter(name="validationIouThreshold")
    def validation_iou_threshold(self) -> Optional[float]:
        """
        IOU threshold to use when computing validation metric. Must be float in the range [0, 1].
        """
        return pulumi.get(self, "validation_iou_threshold")

    @property
    @pulumi.getter(name="validationMetricType")
    def validation_metric_type(self) -> Optional[str]:
        """
        Metric computation method to use for validation metrics.
        """
        return pulumi.get(self, "validation_metric_type")

    @property
    @pulumi.getter(name="warmupCosineLRCycles")
    def warmup_cosine_lr_cycles(self) -> Optional[float]:
        """
        Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "warmup_cosine_lr_cycles")

    @property
    @pulumi.getter(name="warmupCosineLRWarmupEpochs")
    def warmup_cosine_lr_warmup_epochs(self) -> Optional[int]:
        """
        Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
        """
        return pulumi.get(self, "warmup_cosine_lr_warmup_epochs")

    @property
    @pulumi.getter(name="weightDecay")
    def weight_decay(self) -> Optional[float]:
        """
        Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
        """
        return pulumi.get(self, "weight_decay")


@pulumi.output_type
class ImageObjectDetectionResponse(dict):
    """
    Image Object Detection. Object detection is used to identify objects in an image and locate each object with a
    bounding box e.g. locate all dogs and cats in an image and draw a bounding box around each.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "limitSettings":
            suggest = "limit_settings"
        elif key == "taskType":
            suggest = "task_type"
        elif key == "trainingData":
            suggest = "training_data"
        elif key == "logVerbosity":
            suggest = "log_verbosity"
        elif key == "modelSettings":
            suggest = "model_settings"
        elif key == "primaryMetric":
            suggest = "primary_metric"
        elif key == "searchSpace":
            suggest = "search_space"
        elif key == "sweepSettings":
            suggest = "sweep_settings"
        elif key == "targetColumnName":
            suggest = "target_column_name"
        elif key == "validationData":
            suggest = "validation_data"
        elif key == "validationDataSize":
            suggest = "validation_data_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageObjectDetectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageObjectDetectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageObjectDetectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 limit_settings: 'outputs.ImageLimitSettingsResponse',
                 task_type: str,
                 training_data: 'outputs.MLTableJobInputResponse',
                 log_verbosity: Optional[str] = None,
                 model_settings: Optional['outputs.ImageModelSettingsObjectDetectionResponse'] = None,
                 primary_metric: Optional[str] = None,
                 search_space: Optional[Sequence['outputs.ImageModelDistributionSettingsObjectDetectionResponse']] = None,
                 sweep_settings: Optional['outputs.ImageSweepSettingsResponse'] = None,
                 target_column_name: Optional[str] = None,
                 validation_data: Optional['outputs.MLTableJobInputResponse'] = None,
                 validation_data_size: Optional[float] = None):
        """
        Image Object Detection. Object detection is used to identify objects in an image and locate each object with a
        bounding box e.g. locate all dogs and cats in an image and draw a bounding box around each.
        :param 'ImageLimitSettingsResponse' limit_settings: [Required] Limit settings for the AutoML job.
        :param str task_type: AutoMLJob Task type.
               Expected value is 'ImageObjectDetection'.
        :param 'MLTableJobInputResponse' training_data: [Required] Training data input.
        :param str log_verbosity: Log verbosity for the job.
        :param 'ImageModelSettingsObjectDetectionResponse' model_settings: Settings used for training the model.
        :param str primary_metric: Primary metric to optimize for this task.
        :param Sequence['ImageModelDistributionSettingsObjectDetectionResponse'] search_space: Search space for sampling different combinations of models and their hyperparameters.
        :param 'ImageSweepSettingsResponse' sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :param str target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param 'MLTableJobInputResponse' validation_data: Validation data inputs.
        :param float validation_data_size: The fraction of training dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        """
        pulumi.set(__self__, "limit_settings", limit_settings)
        pulumi.set(__self__, "task_type", 'ImageObjectDetection')
        pulumi.set(__self__, "training_data", training_data)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if model_settings is not None:
            pulumi.set(__self__, "model_settings", model_settings)
        if primary_metric is None:
            primary_metric = 'MeanAveragePrecision'
        if primary_metric is not None:
            pulumi.set(__self__, "primary_metric", primary_metric)
        if search_space is not None:
            pulumi.set(__self__, "search_space", search_space)
        if sweep_settings is not None:
            pulumi.set(__self__, "sweep_settings", sweep_settings)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)
        if validation_data_size is not None:
            pulumi.set(__self__, "validation_data_size", validation_data_size)

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> 'outputs.ImageLimitSettingsResponse':
        """
        [Required] Limit settings for the AutoML job.
        """
        return pulumi.get(self, "limit_settings")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        AutoMLJob Task type.
        Expected value is 'ImageObjectDetection'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> 'outputs.MLTableJobInputResponse':
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[str]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @property
    @pulumi.getter(name="modelSettings")
    def model_settings(self) -> Optional['outputs.ImageModelSettingsObjectDetectionResponse']:
        """
        Settings used for training the model.
        """
        return pulumi.get(self, "model_settings")

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> Optional[str]:
        """
        Primary metric to optimize for this task.
        """
        return pulumi.get(self, "primary_metric")

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> Optional[Sequence['outputs.ImageModelDistributionSettingsObjectDetectionResponse']]:
        """
        Search space for sampling different combinations of models and their hyperparameters.
        """
        return pulumi.get(self, "search_space")

    @property
    @pulumi.getter(name="sweepSettings")
    def sweep_settings(self) -> Optional['outputs.ImageSweepSettingsResponse']:
        """
        Model sweeping and hyperparameter sweeping related settings.
        """
        return pulumi.get(self, "sweep_settings")

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[str]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional['outputs.MLTableJobInputResponse']:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")

    @property
    @pulumi.getter(name="validationDataSize")
    def validation_data_size(self) -> Optional[float]:
        """
        The fraction of training dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "validation_data_size")


@pulumi.output_type
class ImageSweepSettingsResponse(dict):
    """
    Model sweeping and hyperparameter sweeping related settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "samplingAlgorithm":
            suggest = "sampling_algorithm"
        elif key == "earlyTermination":
            suggest = "early_termination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageSweepSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageSweepSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageSweepSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sampling_algorithm: str,
                 early_termination: Optional[Any] = None):
        """
        Model sweeping and hyperparameter sweeping related settings.
        :param str sampling_algorithm: [Required] Type of the hyperparameter sampling algorithms.
        :param Union['BanditPolicyResponse', 'MedianStoppingPolicyResponse', 'TruncationSelectionPolicyResponse'] early_termination: Type of early termination policy.
        """
        pulumi.set(__self__, "sampling_algorithm", sampling_algorithm)
        if early_termination is not None:
            pulumi.set(__self__, "early_termination", early_termination)

    @property
    @pulumi.getter(name="samplingAlgorithm")
    def sampling_algorithm(self) -> str:
        """
        [Required] Type of the hyperparameter sampling algorithms.
        """
        return pulumi.get(self, "sampling_algorithm")

    @property
    @pulumi.getter(name="earlyTermination")
    def early_termination(self) -> Optional[Any]:
        """
        Type of early termination policy.
        """
        return pulumi.get(self, "early_termination")


@pulumi.output_type
class InferenceContainerPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "livenessRoute":
            suggest = "liveness_route"
        elif key == "readinessRoute":
            suggest = "readiness_route"
        elif key == "scoringRoute":
            suggest = "scoring_route"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceContainerPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceContainerPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceContainerPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 liveness_route: Optional['outputs.RouteResponse'] = None,
                 readiness_route: Optional['outputs.RouteResponse'] = None,
                 scoring_route: Optional['outputs.RouteResponse'] = None):
        """
        :param 'RouteResponse' liveness_route: The route to check the liveness of the inference server container.
        :param 'RouteResponse' readiness_route: The route to check the readiness of the inference server container.
        :param 'RouteResponse' scoring_route: The port to send the scoring requests to, within the inference server container.
        """
        if liveness_route is not None:
            pulumi.set(__self__, "liveness_route", liveness_route)
        if readiness_route is not None:
            pulumi.set(__self__, "readiness_route", readiness_route)
        if scoring_route is not None:
            pulumi.set(__self__, "scoring_route", scoring_route)

    @property
    @pulumi.getter(name="livenessRoute")
    def liveness_route(self) -> Optional['outputs.RouteResponse']:
        """
        The route to check the liveness of the inference server container.
        """
        return pulumi.get(self, "liveness_route")

    @property
    @pulumi.getter(name="readinessRoute")
    def readiness_route(self) -> Optional['outputs.RouteResponse']:
        """
        The route to check the readiness of the inference server container.
        """
        return pulumi.get(self, "readiness_route")

    @property
    @pulumi.getter(name="scoringRoute")
    def scoring_route(self) -> Optional['outputs.RouteResponse']:
        """
        The port to send the scoring requests to, within the inference server container.
        """
        return pulumi.get(self, "scoring_route")


@pulumi.output_type
class InstanceTypeSchemaResponse(dict):
    """
    Instance type schema.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeSelector":
            suggest = "node_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceTypeSchemaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceTypeSchemaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceTypeSchemaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_selector: Optional[Mapping[str, str]] = None,
                 resources: Optional['outputs.InstanceTypeSchemaResponseResources'] = None):
        """
        Instance type schema.
        :param Mapping[str, str] node_selector: Node Selector
        :param 'InstanceTypeSchemaResponseResources' resources: Resource requests/limits for this instance type
        """
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[Mapping[str, str]]:
        """
        Node Selector
        """
        return pulumi.get(self, "node_selector")

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.InstanceTypeSchemaResponseResources']:
        """
        Resource requests/limits for this instance type
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class InstanceTypeSchemaResponseResources(dict):
    """
    Resource requests/limits for this instance type
    """
    def __init__(__self__, *,
                 limits: Optional[Mapping[str, str]] = None,
                 requests: Optional[Mapping[str, str]] = None):
        """
        Resource requests/limits for this instance type
        :param Mapping[str, str] limits: Resource limits for this instance type
        :param Mapping[str, str] requests: Resource requests for this instance type
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Optional[Mapping[str, str]]:
        """
        Resource limits for this instance type
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Mapping[str, str]]:
        """
        Resource requests for this instance type
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class JobResourceConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dockerArgs":
            suggest = "docker_args"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "shmSize":
            suggest = "shm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobResourceConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobResourceConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobResourceConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 docker_args: Optional[str] = None,
                 instance_count: Optional[int] = None,
                 instance_type: Optional[str] = None,
                 properties: Optional[Mapping[str, Any]] = None,
                 shm_size: Optional[str] = None):
        """
        :param str docker_args: Extra arguments to pass to the Docker run command. This would override any parameters that have already been set by the system, or in this section. This parameter is only supported for Azure ML compute types.
        :param int instance_count: Optional number of instances or nodes used by the compute target.
        :param str instance_type: Optional type of VM used as supported by the compute target.
        :param Mapping[str, Any] properties: Additional properties bag.
        :param str shm_size: Size of the docker container's shared memory block. This should be in the format of (number)(unit) where number as to be greater than 0 and the unit can be one of b(bytes), k(kilobytes), m(megabytes), or g(gigabytes).
        """
        if docker_args is not None:
            pulumi.set(__self__, "docker_args", docker_args)
        if instance_count is None:
            instance_count = 1
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if shm_size is None:
            shm_size = '2g'
        if shm_size is not None:
            pulumi.set(__self__, "shm_size", shm_size)

    @property
    @pulumi.getter(name="dockerArgs")
    def docker_args(self) -> Optional[str]:
        """
        Extra arguments to pass to the Docker run command. This would override any parameters that have already been set by the system, or in this section. This parameter is only supported for Azure ML compute types.
        """
        return pulumi.get(self, "docker_args")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        Optional number of instances or nodes used by the compute target.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        Optional type of VM used as supported by the compute target.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, Any]]:
        """
        Additional properties bag.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="shmSize")
    def shm_size(self) -> Optional[str]:
        """
        Size of the docker container's shared memory block. This should be in the format of (number)(unit) where number as to be greater than 0 and the unit can be one of b(bytes), k(kilobytes), m(megabytes), or g(gigabytes).
        """
        return pulumi.get(self, "shm_size")


@pulumi.output_type
class JobScheduleActionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionType":
            suggest = "action_type"
        elif key == "jobBaseProperties":
            suggest = "job_base_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobScheduleActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobScheduleActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobScheduleActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_type: str,
                 job_base_properties: Any):
        """
        :param str action_type: 
               Expected value is 'CreateJob'.
        :param Union['AutoMLJobResponse', 'CommandJobResponse', 'PipelineJobResponse', 'SweepJobResponse'] job_base_properties: [Required] Defines Schedule action definition details.
        """
        pulumi.set(__self__, "action_type", 'CreateJob')
        pulumi.set(__self__, "job_base_properties", job_base_properties)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """

        Expected value is 'CreateJob'.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter(name="jobBaseProperties")
    def job_base_properties(self) -> Any:
        """
        [Required] Defines Schedule action definition details.
        """
        return pulumi.get(self, "job_base_properties")


@pulumi.output_type
class JobServiceResponse(dict):
    """
    Job endpoint definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorMessage":
            suggest = "error_message"
        elif key == "jobServiceType":
            suggest = "job_service_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_message: str,
                 status: str,
                 endpoint: Optional[str] = None,
                 job_service_type: Optional[str] = None,
                 port: Optional[int] = None,
                 properties: Optional[Mapping[str, str]] = None):
        """
        Job endpoint definition
        :param str error_message: Any error in the service.
        :param str status: Status of endpoint.
        :param str endpoint: Url for endpoint.
        :param str job_service_type: Endpoint type.
        :param int port: Port for endpoint.
        :param Mapping[str, str] properties: Additional properties to set on the endpoint.
        """
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "status", status)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if job_service_type is not None:
            pulumi.set(__self__, "job_service_type", job_service_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        Any error in the service.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of endpoint.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        Url for endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="jobServiceType")
    def job_service_type(self) -> Optional[str]:
        """
        Endpoint type.
        """
        return pulumi.get(self, "job_service_type")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port for endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Additional properties to set on the endpoint.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class KubernetesOnlineDeploymentResponse(dict):
    """
    Properties specific to a KubernetesOnlineDeployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointComputeType":
            suggest = "endpoint_compute_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "appInsightsEnabled":
            suggest = "app_insights_enabled"
        elif key == "codeConfiguration":
            suggest = "code_configuration"
        elif key == "containerResourceRequirements":
            suggest = "container_resource_requirements"
        elif key == "egressPublicNetworkAccess":
            suggest = "egress_public_network_access"
        elif key == "environmentId":
            suggest = "environment_id"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "modelMountPath":
            suggest = "model_mount_path"
        elif key == "readinessProbe":
            suggest = "readiness_probe"
        elif key == "requestSettings":
            suggest = "request_settings"
        elif key == "scaleSettings":
            suggest = "scale_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesOnlineDeploymentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesOnlineDeploymentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesOnlineDeploymentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_compute_type: str,
                 provisioning_state: str,
                 app_insights_enabled: Optional[bool] = None,
                 code_configuration: Optional['outputs.CodeConfigurationResponse'] = None,
                 container_resource_requirements: Optional['outputs.ContainerResourceRequirementsResponse'] = None,
                 description: Optional[str] = None,
                 egress_public_network_access: Optional[str] = None,
                 environment_id: Optional[str] = None,
                 environment_variables: Optional[Mapping[str, str]] = None,
                 instance_type: Optional[str] = None,
                 liveness_probe: Optional['outputs.ProbeSettingsResponse'] = None,
                 model: Optional[str] = None,
                 model_mount_path: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 readiness_probe: Optional['outputs.ProbeSettingsResponse'] = None,
                 request_settings: Optional['outputs.OnlineRequestSettingsResponse'] = None,
                 scale_settings: Optional[Any] = None):
        """
        Properties specific to a KubernetesOnlineDeployment.
        :param str endpoint_compute_type: Enum to determine endpoint compute type.
               Expected value is 'Kubernetes'.
        :param str provisioning_state: Provisioning state for the endpoint deployment.
        :param bool app_insights_enabled: If true, enables Application Insights logging.
        :param 'CodeConfigurationResponse' code_configuration: Code configuration for the endpoint deployment.
        :param 'ContainerResourceRequirementsResponse' container_resource_requirements: The resource requirements for the container (cpu and memory).
        :param str description: Description of the endpoint deployment.
        :param str egress_public_network_access: If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled.
        :param str environment_id: ARM resource ID or AssetId of the environment specification for the endpoint deployment.
        :param Mapping[str, str] environment_variables: Environment variables configuration for the deployment.
        :param str instance_type: Compute instance type.
        :param 'ProbeSettingsResponse' liveness_probe: Liveness probe monitors the health of the container regularly.
        :param str model: The URI path to the model.
        :param str model_mount_path: The path to mount the model in custom container.
        :param Mapping[str, str] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param 'ProbeSettingsResponse' readiness_probe: Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe.
        :param 'OnlineRequestSettingsResponse' request_settings: Request settings for the deployment.
        :param Union['DefaultScaleSettingsResponse', 'TargetUtilizationScaleSettingsResponse'] scale_settings: Scale settings for the deployment.
               If it is null or not provided,
               it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
               and to DefaultScaleSettings for ManagedOnlineDeployment.
        """
        pulumi.set(__self__, "endpoint_compute_type", 'Kubernetes')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if app_insights_enabled is None:
            app_insights_enabled = False
        if app_insights_enabled is not None:
            pulumi.set(__self__, "app_insights_enabled", app_insights_enabled)
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)
        if container_resource_requirements is not None:
            pulumi.set(__self__, "container_resource_requirements", container_resource_requirements)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if egress_public_network_access is None:
            egress_public_network_access = 'Enabled'
        if egress_public_network_access is not None:
            pulumi.set(__self__, "egress_public_network_access", egress_public_network_access)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if model_mount_path is not None:
            pulumi.set(__self__, "model_mount_path", model_mount_path)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if readiness_probe is not None:
            pulumi.set(__self__, "readiness_probe", readiness_probe)
        if request_settings is not None:
            pulumi.set(__self__, "request_settings", request_settings)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)

    @property
    @pulumi.getter(name="endpointComputeType")
    def endpoint_compute_type(self) -> str:
        """
        Enum to determine endpoint compute type.
        Expected value is 'Kubernetes'.
        """
        return pulumi.get(self, "endpoint_compute_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state for the endpoint deployment.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="appInsightsEnabled")
    def app_insights_enabled(self) -> Optional[bool]:
        """
        If true, enables Application Insights logging.
        """
        return pulumi.get(self, "app_insights_enabled")

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional['outputs.CodeConfigurationResponse']:
        """
        Code configuration for the endpoint deployment.
        """
        return pulumi.get(self, "code_configuration")

    @property
    @pulumi.getter(name="containerResourceRequirements")
    def container_resource_requirements(self) -> Optional['outputs.ContainerResourceRequirementsResponse']:
        """
        The resource requirements for the container (cpu and memory).
        """
        return pulumi.get(self, "container_resource_requirements")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the endpoint deployment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="egressPublicNetworkAccess")
    def egress_public_network_access(self) -> Optional[str]:
        """
        If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled.
        """
        return pulumi.get(self, "egress_public_network_access")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[str]:
        """
        ARM resource ID or AssetId of the environment specification for the endpoint deployment.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables configuration for the deployment.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        Compute instance type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional['outputs.ProbeSettingsResponse']:
        """
        Liveness probe monitors the health of the container regularly.
        """
        return pulumi.get(self, "liveness_probe")

    @property
    @pulumi.getter
    def model(self) -> Optional[str]:
        """
        The URI path to the model.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter(name="modelMountPath")
    def model_mount_path(self) -> Optional[str]:
        """
        The path to mount the model in custom container.
        """
        return pulumi.get(self, "model_mount_path")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> Optional['outputs.ProbeSettingsResponse']:
        """
        Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe.
        """
        return pulumi.get(self, "readiness_probe")

    @property
    @pulumi.getter(name="requestSettings")
    def request_settings(self) -> Optional['outputs.OnlineRequestSettingsResponse']:
        """
        Request settings for the deployment.
        """
        return pulumi.get(self, "request_settings")

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional[Any]:
        """
        Scale settings for the deployment.
        If it is null or not provided,
        it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
        and to DefaultScaleSettings for ManagedOnlineDeployment.
        """
        return pulumi.get(self, "scale_settings")


@pulumi.output_type
class KubernetesPropertiesResponse(dict):
    """
    Kubernetes properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultInstanceType":
            suggest = "default_instance_type"
        elif key == "extensionInstanceReleaseTrain":
            suggest = "extension_instance_release_train"
        elif key == "extensionPrincipalId":
            suggest = "extension_principal_id"
        elif key == "instanceTypes":
            suggest = "instance_types"
        elif key == "relayConnectionString":
            suggest = "relay_connection_string"
        elif key == "serviceBusConnectionString":
            suggest = "service_bus_connection_string"
        elif key == "vcName":
            suggest = "vc_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_instance_type: Optional[str] = None,
                 extension_instance_release_train: Optional[str] = None,
                 extension_principal_id: Optional[str] = None,
                 instance_types: Optional[Mapping[str, 'outputs.InstanceTypeSchemaResponse']] = None,
                 namespace: Optional[str] = None,
                 relay_connection_string: Optional[str] = None,
                 service_bus_connection_string: Optional[str] = None,
                 vc_name: Optional[str] = None):
        """
        Kubernetes properties
        :param str default_instance_type: Default instance type
        :param str extension_instance_release_train: Extension instance release train.
        :param str extension_principal_id: Extension principal-id.
        :param Mapping[str, 'InstanceTypeSchemaResponse'] instance_types: Instance Type Schema
        :param str namespace: Compute namespace
        :param str relay_connection_string: Relay connection string.
        :param str service_bus_connection_string: ServiceBus connection string.
        :param str vc_name: VC name.
        """
        if default_instance_type is not None:
            pulumi.set(__self__, "default_instance_type", default_instance_type)
        if extension_instance_release_train is not None:
            pulumi.set(__self__, "extension_instance_release_train", extension_instance_release_train)
        if extension_principal_id is not None:
            pulumi.set(__self__, "extension_principal_id", extension_principal_id)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if namespace is None:
            namespace = 'default'
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if relay_connection_string is not None:
            pulumi.set(__self__, "relay_connection_string", relay_connection_string)
        if service_bus_connection_string is not None:
            pulumi.set(__self__, "service_bus_connection_string", service_bus_connection_string)
        if vc_name is not None:
            pulumi.set(__self__, "vc_name", vc_name)

    @property
    @pulumi.getter(name="defaultInstanceType")
    def default_instance_type(self) -> Optional[str]:
        """
        Default instance type
        """
        return pulumi.get(self, "default_instance_type")

    @property
    @pulumi.getter(name="extensionInstanceReleaseTrain")
    def extension_instance_release_train(self) -> Optional[str]:
        """
        Extension instance release train.
        """
        return pulumi.get(self, "extension_instance_release_train")

    @property
    @pulumi.getter(name="extensionPrincipalId")
    def extension_principal_id(self) -> Optional[str]:
        """
        Extension principal-id.
        """
        return pulumi.get(self, "extension_principal_id")

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[Mapping[str, 'outputs.InstanceTypeSchemaResponse']]:
        """
        Instance Type Schema
        """
        return pulumi.get(self, "instance_types")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        Compute namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="relayConnectionString")
    def relay_connection_string(self) -> Optional[str]:
        """
        Relay connection string.
        """
        return pulumi.get(self, "relay_connection_string")

    @property
    @pulumi.getter(name="serviceBusConnectionString")
    def service_bus_connection_string(self) -> Optional[str]:
        """
        ServiceBus connection string.
        """
        return pulumi.get(self, "service_bus_connection_string")

    @property
    @pulumi.getter(name="vcName")
    def vc_name(self) -> Optional[str]:
        """
        VC name.
        """
        return pulumi.get(self, "vc_name")


@pulumi.output_type
class KubernetesResponse(dict):
    """
    A Machine Learning compute based on Kubernetes Compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 properties: Optional['outputs.KubernetesPropertiesResponse'] = None,
                 resource_id: Optional[str] = None):
        """
        A Machine Learning compute based on Kubernetes Compute.
        :param str compute_type: The type of compute
               Expected value is 'Kubernetes'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param 'KubernetesPropertiesResponse' properties: Properties of Kubernetes
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'Kubernetes')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'Kubernetes'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.KubernetesPropertiesResponse']:
        """
        Properties of Kubernetes
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class ListNotebookKeysResultResponse(dict):
    def __init__(__self__, *,
                 primary_access_key: str,
                 secondary_access_key: str):
        pulumi.set(__self__, "primary_access_key", primary_access_key)
        pulumi.set(__self__, "secondary_access_key", secondary_access_key)

    @property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> str:
        return pulumi.get(self, "primary_access_key")

    @property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> str:
        return pulumi.get(self, "secondary_access_key")


@pulumi.output_type
class LiteralJobInputResponse(dict):
    """
    Literal input type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobInputType":
            suggest = "job_input_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiteralJobInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiteralJobInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiteralJobInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_input_type: str,
                 value: str,
                 description: Optional[str] = None):
        """
        Literal input type.
        :param str job_input_type: Enum to determine the Job Input Type.
               Expected value is 'literal'.
        :param str value: [Required] Literal value for the input.
        :param str description: Description for the input.
        """
        pulumi.set(__self__, "job_input_type", 'literal')
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="jobInputType")
    def job_input_type(self) -> str:
        """
        Enum to determine the Job Input Type.
        Expected value is 'literal'.
        """
        return pulumi.get(self, "job_input_type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        [Required] Literal value for the input.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description for the input.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class MLFlowModelJobInputResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobInputType":
            suggest = "job_input_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MLFlowModelJobInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MLFlowModelJobInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MLFlowModelJobInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_input_type: str,
                 uri: str,
                 description: Optional[str] = None,
                 mode: Optional[str] = None):
        """
        :param str job_input_type: Enum to determine the Job Input Type.
               Expected value is 'mlflow_model'.
        :param str uri: [Required] Input Asset URI.
        :param str description: Description for the input.
        :param str mode: Input Asset Delivery Mode.
        """
        pulumi.set(__self__, "job_input_type", 'mlflow_model')
        pulumi.set(__self__, "uri", uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadOnlyMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="jobInputType")
    def job_input_type(self) -> str:
        """
        Enum to determine the Job Input Type.
        Expected value is 'mlflow_model'.
        """
        return pulumi.get(self, "job_input_type")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        [Required] Input Asset URI.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description for the input.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Input Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class MLFlowModelJobOutputResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobOutputType":
            suggest = "job_output_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MLFlowModelJobOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MLFlowModelJobOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MLFlowModelJobOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_output_type: str,
                 description: Optional[str] = None,
                 mode: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param str job_output_type: Enum to determine the Job Output Type.
               Expected value is 'mlflow_model'.
        :param str description: Description for the output.
        :param str mode: Output Asset Delivery Mode.
        :param str uri: Output Asset URI.
        """
        pulumi.set(__self__, "job_output_type", 'mlflow_model')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadWriteMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="jobOutputType")
    def job_output_type(self) -> str:
        """
        Enum to determine the Job Output Type.
        Expected value is 'mlflow_model'.
        """
        return pulumi.get(self, "job_output_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description for the output.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Output Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Output Asset URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class MLTableDataResponse(dict):
    """
    MLTable data definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "dataUri":
            suggest = "data_uri"
        elif key == "isAnonymous":
            suggest = "is_anonymous"
        elif key == "isArchived":
            suggest = "is_archived"
        elif key == "referencedUris":
            suggest = "referenced_uris"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MLTableDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MLTableDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MLTableDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_type: str,
                 data_uri: str,
                 description: Optional[str] = None,
                 is_anonymous: Optional[bool] = None,
                 is_archived: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 referenced_uris: Optional[Sequence[str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        MLTable data definition
        :param str data_type: Enum to determine the type of data.
               Expected value is 'mltable'.
        :param str data_uri: [Required] Uri of the data. Usage/meaning depends on Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20221001.Assets.DataVersionBase.DataType
        :param str description: The asset description text.
        :param bool is_anonymous: If the name version are system generated (anonymous registration).
        :param bool is_archived: Is the asset archived?
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Sequence[str] referenced_uris: Uris referenced in the MLTable definition (required for lineage)
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "data_type", 'mltable')
        pulumi.set(__self__, "data_uri", data_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_anonymous is None:
            is_anonymous = False
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if referenced_uris is not None:
            pulumi.set(__self__, "referenced_uris", referenced_uris)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> str:
        """
        Enum to determine the type of data.
        Expected value is 'mltable'.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="dataUri")
    def data_uri(self) -> str:
        """
        [Required] Uri of the data. Usage/meaning depends on Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20221001.Assets.DataVersionBase.DataType
        """
        return pulumi.get(self, "data_uri")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[bool]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[bool]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="referencedUris")
    def referenced_uris(self) -> Optional[Sequence[str]]:
        """
        Uris referenced in the MLTable definition (required for lineage)
        """
        return pulumi.get(self, "referenced_uris")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class MLTableJobInputResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobInputType":
            suggest = "job_input_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MLTableJobInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MLTableJobInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MLTableJobInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_input_type: str,
                 uri: str,
                 description: Optional[str] = None,
                 mode: Optional[str] = None):
        """
        :param str job_input_type: Enum to determine the Job Input Type.
               Expected value is 'mltable'.
        :param str uri: [Required] Input Asset URI.
        :param str description: Description for the input.
        :param str mode: Input Asset Delivery Mode.
        """
        pulumi.set(__self__, "job_input_type", 'mltable')
        pulumi.set(__self__, "uri", uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadOnlyMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="jobInputType")
    def job_input_type(self) -> str:
        """
        Enum to determine the Job Input Type.
        Expected value is 'mltable'.
        """
        return pulumi.get(self, "job_input_type")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        [Required] Input Asset URI.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description for the input.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Input Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class MLTableJobOutputResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobOutputType":
            suggest = "job_output_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MLTableJobOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MLTableJobOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MLTableJobOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_output_type: str,
                 description: Optional[str] = None,
                 mode: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param str job_output_type: Enum to determine the Job Output Type.
               Expected value is 'mltable'.
        :param str description: Description for the output.
        :param str mode: Output Asset Delivery Mode.
        :param str uri: Output Asset URI.
        """
        pulumi.set(__self__, "job_output_type", 'mltable')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadWriteMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="jobOutputType")
    def job_output_type(self) -> str:
        """
        Enum to determine the Job Output Type.
        Expected value is 'mltable'.
        """
        return pulumi.get(self, "job_output_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description for the output.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Output Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Output Asset URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class ManagedIdentityAuthTypeWorkspaceConnectionPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "valueFormat":
            suggest = "value_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedIdentityAuthTypeWorkspaceConnectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedIdentityAuthTypeWorkspaceConnectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedIdentityAuthTypeWorkspaceConnectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: str,
                 category: Optional[str] = None,
                 credentials: Optional['outputs.WorkspaceConnectionManagedIdentityResponse'] = None,
                 target: Optional[str] = None,
                 value: Optional[str] = None,
                 value_format: Optional[str] = None):
        """
        :param str auth_type: Authentication type of the connection target
               Expected value is 'ManagedIdentity'.
        :param str category: Category of the connection
        :param str value: Value details of the workspace connection.
        :param str value_format: format for the workspace connection value
        """
        pulumi.set(__self__, "auth_type", 'ManagedIdentity')
        if category is not None:
            pulumi.set(__self__, "category", category)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_format is not None:
            pulumi.set(__self__, "value_format", value_format)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> str:
        """
        Authentication type of the connection target
        Expected value is 'ManagedIdentity'.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        Category of the connection
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.WorkspaceConnectionManagedIdentityResponse']:
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value details of the workspace connection.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueFormat")
    def value_format(self) -> Optional[str]:
        """
        format for the workspace connection value
        """
        return pulumi.get(self, "value_format")


@pulumi.output_type
class ManagedIdentityResponse(dict):
    """
    Managed identity configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityType":
            suggest = "identity_type"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_type: str,
                 client_id: Optional[str] = None,
                 object_id: Optional[str] = None,
                 resource_id: Optional[str] = None):
        """
        Managed identity configuration.
        :param str identity_type: Enum to determine identity framework.
               Expected value is 'Managed'.
        :param str client_id: Specifies a user-assigned identity by client ID. For system-assigned, do not set this field.
        :param str object_id: Specifies a user-assigned identity by object ID. For system-assigned, do not set this field.
        :param str resource_id: Specifies a user-assigned identity by ARM resource ID. For system-assigned, do not set this field.
        """
        pulumi.set(__self__, "identity_type", 'Managed')
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> str:
        """
        Enum to determine identity framework.
        Expected value is 'Managed'.
        """
        return pulumi.get(self, "identity_type")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        Specifies a user-assigned identity by client ID. For system-assigned, do not set this field.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        Specifies a user-assigned identity by object ID. For system-assigned, do not set this field.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        Specifies a user-assigned identity by ARM resource ID. For system-assigned, do not set this field.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class ManagedOnlineDeploymentResponse(dict):
    """
    Properties specific to a ManagedOnlineDeployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointComputeType":
            suggest = "endpoint_compute_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "appInsightsEnabled":
            suggest = "app_insights_enabled"
        elif key == "codeConfiguration":
            suggest = "code_configuration"
        elif key == "egressPublicNetworkAccess":
            suggest = "egress_public_network_access"
        elif key == "environmentId":
            suggest = "environment_id"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "modelMountPath":
            suggest = "model_mount_path"
        elif key == "readinessProbe":
            suggest = "readiness_probe"
        elif key == "requestSettings":
            suggest = "request_settings"
        elif key == "scaleSettings":
            suggest = "scale_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedOnlineDeploymentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedOnlineDeploymentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedOnlineDeploymentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_compute_type: str,
                 provisioning_state: str,
                 app_insights_enabled: Optional[bool] = None,
                 code_configuration: Optional['outputs.CodeConfigurationResponse'] = None,
                 description: Optional[str] = None,
                 egress_public_network_access: Optional[str] = None,
                 environment_id: Optional[str] = None,
                 environment_variables: Optional[Mapping[str, str]] = None,
                 instance_type: Optional[str] = None,
                 liveness_probe: Optional['outputs.ProbeSettingsResponse'] = None,
                 model: Optional[str] = None,
                 model_mount_path: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 readiness_probe: Optional['outputs.ProbeSettingsResponse'] = None,
                 request_settings: Optional['outputs.OnlineRequestSettingsResponse'] = None,
                 scale_settings: Optional[Any] = None):
        """
        Properties specific to a ManagedOnlineDeployment.
        :param str endpoint_compute_type: Enum to determine endpoint compute type.
               Expected value is 'Managed'.
        :param str provisioning_state: Provisioning state for the endpoint deployment.
        :param bool app_insights_enabled: If true, enables Application Insights logging.
        :param 'CodeConfigurationResponse' code_configuration: Code configuration for the endpoint deployment.
        :param str description: Description of the endpoint deployment.
        :param str egress_public_network_access: If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled.
        :param str environment_id: ARM resource ID or AssetId of the environment specification for the endpoint deployment.
        :param Mapping[str, str] environment_variables: Environment variables configuration for the deployment.
        :param str instance_type: Compute instance type.
        :param 'ProbeSettingsResponse' liveness_probe: Liveness probe monitors the health of the container regularly.
        :param str model: The URI path to the model.
        :param str model_mount_path: The path to mount the model in custom container.
        :param Mapping[str, str] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param 'ProbeSettingsResponse' readiness_probe: Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe.
        :param 'OnlineRequestSettingsResponse' request_settings: Request settings for the deployment.
        :param Union['DefaultScaleSettingsResponse', 'TargetUtilizationScaleSettingsResponse'] scale_settings: Scale settings for the deployment.
               If it is null or not provided,
               it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
               and to DefaultScaleSettings for ManagedOnlineDeployment.
        """
        pulumi.set(__self__, "endpoint_compute_type", 'Managed')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if app_insights_enabled is None:
            app_insights_enabled = False
        if app_insights_enabled is not None:
            pulumi.set(__self__, "app_insights_enabled", app_insights_enabled)
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if egress_public_network_access is None:
            egress_public_network_access = 'Enabled'
        if egress_public_network_access is not None:
            pulumi.set(__self__, "egress_public_network_access", egress_public_network_access)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if model_mount_path is not None:
            pulumi.set(__self__, "model_mount_path", model_mount_path)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if readiness_probe is not None:
            pulumi.set(__self__, "readiness_probe", readiness_probe)
        if request_settings is not None:
            pulumi.set(__self__, "request_settings", request_settings)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)

    @property
    @pulumi.getter(name="endpointComputeType")
    def endpoint_compute_type(self) -> str:
        """
        Enum to determine endpoint compute type.
        Expected value is 'Managed'.
        """
        return pulumi.get(self, "endpoint_compute_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state for the endpoint deployment.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="appInsightsEnabled")
    def app_insights_enabled(self) -> Optional[bool]:
        """
        If true, enables Application Insights logging.
        """
        return pulumi.get(self, "app_insights_enabled")

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional['outputs.CodeConfigurationResponse']:
        """
        Code configuration for the endpoint deployment.
        """
        return pulumi.get(self, "code_configuration")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the endpoint deployment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="egressPublicNetworkAccess")
    def egress_public_network_access(self) -> Optional[str]:
        """
        If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled.
        """
        return pulumi.get(self, "egress_public_network_access")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[str]:
        """
        ARM resource ID or AssetId of the environment specification for the endpoint deployment.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables configuration for the deployment.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        Compute instance type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional['outputs.ProbeSettingsResponse']:
        """
        Liveness probe monitors the health of the container regularly.
        """
        return pulumi.get(self, "liveness_probe")

    @property
    @pulumi.getter
    def model(self) -> Optional[str]:
        """
        The URI path to the model.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter(name="modelMountPath")
    def model_mount_path(self) -> Optional[str]:
        """
        The path to mount the model in custom container.
        """
        return pulumi.get(self, "model_mount_path")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> Optional['outputs.ProbeSettingsResponse']:
        """
        Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe.
        """
        return pulumi.get(self, "readiness_probe")

    @property
    @pulumi.getter(name="requestSettings")
    def request_settings(self) -> Optional['outputs.OnlineRequestSettingsResponse']:
        """
        Request settings for the deployment.
        """
        return pulumi.get(self, "request_settings")

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional[Any]:
        """
        Scale settings for the deployment.
        If it is null or not provided,
        it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
        and to DefaultScaleSettings for ManagedOnlineDeployment.
        """
        return pulumi.get(self, "scale_settings")


@pulumi.output_type
class ManagedServiceIdentityResponse(dict):
    """
    Managed service identity (system assigned and/or user assigned identities)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedServiceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedServiceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedServiceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']] = None):
        """
        Managed service identity (system assigned and/or user assigned identities)
        :param str principal_id: The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
        :param str tenant_id: The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
        :param str type: Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        :param Mapping[str, 'UserAssignedIdentityResponse'] user_assigned_identities: The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']]:
        """
        The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class MedianStoppingPolicyResponse(dict):
    """
    Defines an early termination policy based on running averages of the primary metric of all runs
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyType":
            suggest = "policy_type"
        elif key == "delayEvaluation":
            suggest = "delay_evaluation"
        elif key == "evaluationInterval":
            suggest = "evaluation_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MedianStoppingPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MedianStoppingPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MedianStoppingPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_type: str,
                 delay_evaluation: Optional[int] = None,
                 evaluation_interval: Optional[int] = None):
        """
        Defines an early termination policy based on running averages of the primary metric of all runs
        :param str policy_type: 
               Expected value is 'MedianStopping'.
        :param int delay_evaluation: Number of intervals by which to delay the first evaluation.
        :param int evaluation_interval: Interval (number of runs) between policy evaluations.
        """
        pulumi.set(__self__, "policy_type", 'MedianStopping')
        if delay_evaluation is None:
            delay_evaluation = 0
        if delay_evaluation is not None:
            pulumi.set(__self__, "delay_evaluation", delay_evaluation)
        if evaluation_interval is None:
            evaluation_interval = 0
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> str:
        """

        Expected value is 'MedianStopping'.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="delayEvaluation")
    def delay_evaluation(self) -> Optional[int]:
        """
        Number of intervals by which to delay the first evaluation.
        """
        return pulumi.get(self, "delay_evaluation")

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[int]:
        """
        Interval (number of runs) between policy evaluations.
        """
        return pulumi.get(self, "evaluation_interval")


@pulumi.output_type
class ModelContainerResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latestVersion":
            suggest = "latest_version"
        elif key == "nextVersion":
            suggest = "next_version"
        elif key == "isArchived":
            suggest = "is_archived"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 latest_version: str,
                 next_version: str,
                 description: Optional[str] = None,
                 is_archived: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        :param str latest_version: The latest version inside this container.
        :param str next_version: The next auto incremental version
        :param str description: The asset description text.
        :param bool is_archived: Is the asset archived?
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "latest_version", latest_version)
        pulumi.set(__self__, "next_version", next_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> str:
        """
        The latest version inside this container.
        """
        return pulumi.get(self, "latest_version")

    @property
    @pulumi.getter(name="nextVersion")
    def next_version(self) -> str:
        """
        The next auto incremental version
        """
        return pulumi.get(self, "next_version")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[bool]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ModelVersionResponse(dict):
    """
    Model asset version details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isAnonymous":
            suggest = "is_anonymous"
        elif key == "isArchived":
            suggest = "is_archived"
        elif key == "jobName":
            suggest = "job_name"
        elif key == "modelType":
            suggest = "model_type"
        elif key == "modelUri":
            suggest = "model_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 flavors: Optional[Mapping[str, 'outputs.FlavorDataResponse']] = None,
                 is_anonymous: Optional[bool] = None,
                 is_archived: Optional[bool] = None,
                 job_name: Optional[str] = None,
                 model_type: Optional[str] = None,
                 model_uri: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Model asset version details.
        :param str description: The asset description text.
        :param Mapping[str, 'FlavorDataResponse'] flavors: Mapping of model flavors to their properties.
        :param bool is_anonymous: If the name version are system generated (anonymous registration).
        :param bool is_archived: Is the asset archived?
        :param str job_name: Name of the training job which produced this model
        :param str model_type: The storage format for this entity. Used for NCD.
        :param str model_uri: The URI path to the model contents.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flavors is not None:
            pulumi.set(__self__, "flavors", flavors)
        if is_anonymous is None:
            is_anonymous = False
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if job_name is not None:
            pulumi.set(__self__, "job_name", job_name)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if model_uri is not None:
            pulumi.set(__self__, "model_uri", model_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def flavors(self) -> Optional[Mapping[str, 'outputs.FlavorDataResponse']]:
        """
        Mapping of model flavors to their properties.
        """
        return pulumi.get(self, "flavors")

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[bool]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[bool]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> Optional[str]:
        """
        Name of the training job which produced this model
        """
        return pulumi.get(self, "job_name")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[str]:
        """
        The storage format for this entity. Used for NCD.
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="modelUri")
    def model_uri(self) -> Optional[str]:
        """
        The URI path to the model contents.
        """
        return pulumi.get(self, "model_uri")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class MpiResponse(dict):
    """
    MPI distribution configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionType":
            suggest = "distribution_type"
        elif key == "processCountPerInstance":
            suggest = "process_count_per_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MpiResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MpiResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MpiResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_type: str,
                 process_count_per_instance: Optional[int] = None):
        """
        MPI distribution configuration.
        :param str distribution_type: Enum to determine the job distribution type.
               Expected value is 'Mpi'.
        :param int process_count_per_instance: Number of processes per MPI node.
        """
        pulumi.set(__self__, "distribution_type", 'Mpi')
        if process_count_per_instance is not None:
            pulumi.set(__self__, "process_count_per_instance", process_count_per_instance)

    @property
    @pulumi.getter(name="distributionType")
    def distribution_type(self) -> str:
        """
        Enum to determine the job distribution type.
        Expected value is 'Mpi'.
        """
        return pulumi.get(self, "distribution_type")

    @property
    @pulumi.getter(name="processCountPerInstance")
    def process_count_per_instance(self) -> Optional[int]:
        """
        Number of processes per MPI node.
        """
        return pulumi.get(self, "process_count_per_instance")


@pulumi.output_type
class NlpVerticalFeaturizationSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetLanguage":
            suggest = "dataset_language"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NlpVerticalFeaturizationSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NlpVerticalFeaturizationSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NlpVerticalFeaturizationSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_language: Optional[str] = None):
        """
        :param str dataset_language: Dataset language, useful for the text data.
        """
        if dataset_language is not None:
            pulumi.set(__self__, "dataset_language", dataset_language)

    @property
    @pulumi.getter(name="datasetLanguage")
    def dataset_language(self) -> Optional[str]:
        """
        Dataset language, useful for the text data.
        """
        return pulumi.get(self, "dataset_language")


@pulumi.output_type
class NlpVerticalLimitSettingsResponse(dict):
    """
    Job execution constraints.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxConcurrentTrials":
            suggest = "max_concurrent_trials"
        elif key == "maxTrials":
            suggest = "max_trials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NlpVerticalLimitSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NlpVerticalLimitSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NlpVerticalLimitSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_concurrent_trials: Optional[int] = None,
                 max_trials: Optional[int] = None,
                 timeout: Optional[str] = None):
        """
        Job execution constraints.
        :param int max_concurrent_trials: Maximum Concurrent AutoML iterations.
        :param int max_trials: Number of AutoML iterations.
        :param str timeout: AutoML job timeout.
        """
        if max_concurrent_trials is None:
            max_concurrent_trials = 1
        if max_concurrent_trials is not None:
            pulumi.set(__self__, "max_concurrent_trials", max_concurrent_trials)
        if max_trials is None:
            max_trials = 1
        if max_trials is not None:
            pulumi.set(__self__, "max_trials", max_trials)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="maxConcurrentTrials")
    def max_concurrent_trials(self) -> Optional[int]:
        """
        Maximum Concurrent AutoML iterations.
        """
        return pulumi.get(self, "max_concurrent_trials")

    @property
    @pulumi.getter(name="maxTrials")
    def max_trials(self) -> Optional[int]:
        """
        Number of AutoML iterations.
        """
        return pulumi.get(self, "max_trials")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        AutoML job timeout.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class NodeStateCountsResponse(dict):
    """
    Counts of various compute node states on the amlCompute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleNodeCount":
            suggest = "idle_node_count"
        elif key == "leavingNodeCount":
            suggest = "leaving_node_count"
        elif key == "preemptedNodeCount":
            suggest = "preempted_node_count"
        elif key == "preparingNodeCount":
            suggest = "preparing_node_count"
        elif key == "runningNodeCount":
            suggest = "running_node_count"
        elif key == "unusableNodeCount":
            suggest = "unusable_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeStateCountsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeStateCountsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeStateCountsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idle_node_count: int,
                 leaving_node_count: int,
                 preempted_node_count: int,
                 preparing_node_count: int,
                 running_node_count: int,
                 unusable_node_count: int):
        """
        Counts of various compute node states on the amlCompute.
        :param int idle_node_count: Number of compute nodes in idle state.
        :param int leaving_node_count: Number of compute nodes which are leaving the amlCompute.
        :param int preempted_node_count: Number of compute nodes which are in preempted state.
        :param int preparing_node_count: Number of compute nodes which are being prepared.
        :param int running_node_count: Number of compute nodes which are running jobs.
        :param int unusable_node_count: Number of compute nodes which are in unusable state.
        """
        pulumi.set(__self__, "idle_node_count", idle_node_count)
        pulumi.set(__self__, "leaving_node_count", leaving_node_count)
        pulumi.set(__self__, "preempted_node_count", preempted_node_count)
        pulumi.set(__self__, "preparing_node_count", preparing_node_count)
        pulumi.set(__self__, "running_node_count", running_node_count)
        pulumi.set(__self__, "unusable_node_count", unusable_node_count)

    @property
    @pulumi.getter(name="idleNodeCount")
    def idle_node_count(self) -> int:
        """
        Number of compute nodes in idle state.
        """
        return pulumi.get(self, "idle_node_count")

    @property
    @pulumi.getter(name="leavingNodeCount")
    def leaving_node_count(self) -> int:
        """
        Number of compute nodes which are leaving the amlCompute.
        """
        return pulumi.get(self, "leaving_node_count")

    @property
    @pulumi.getter(name="preemptedNodeCount")
    def preempted_node_count(self) -> int:
        """
        Number of compute nodes which are in preempted state.
        """
        return pulumi.get(self, "preempted_node_count")

    @property
    @pulumi.getter(name="preparingNodeCount")
    def preparing_node_count(self) -> int:
        """
        Number of compute nodes which are being prepared.
        """
        return pulumi.get(self, "preparing_node_count")

    @property
    @pulumi.getter(name="runningNodeCount")
    def running_node_count(self) -> int:
        """
        Number of compute nodes which are running jobs.
        """
        return pulumi.get(self, "running_node_count")

    @property
    @pulumi.getter(name="unusableNodeCount")
    def unusable_node_count(self) -> int:
        """
        Number of compute nodes which are in unusable state.
        """
        return pulumi.get(self, "unusable_node_count")


@pulumi.output_type
class NoneAuthTypeWorkspaceConnectionPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "valueFormat":
            suggest = "value_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NoneAuthTypeWorkspaceConnectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NoneAuthTypeWorkspaceConnectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NoneAuthTypeWorkspaceConnectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: str,
                 category: Optional[str] = None,
                 target: Optional[str] = None,
                 value: Optional[str] = None,
                 value_format: Optional[str] = None):
        """
        :param str auth_type: Authentication type of the connection target
               Expected value is 'None'.
        :param str category: Category of the connection
        :param str value: Value details of the workspace connection.
        :param str value_format: format for the workspace connection value
        """
        pulumi.set(__self__, "auth_type", 'None')
        if category is not None:
            pulumi.set(__self__, "category", category)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_format is not None:
            pulumi.set(__self__, "value_format", value_format)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> str:
        """
        Authentication type of the connection target
        Expected value is 'None'.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        Category of the connection
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value details of the workspace connection.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueFormat")
    def value_format(self) -> Optional[str]:
        """
        format for the workspace connection value
        """
        return pulumi.get(self, "value_format")


@pulumi.output_type
class NoneDatastoreCredentialsResponse(dict):
    """
    Empty/none datastore credentials.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialsType":
            suggest = "credentials_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NoneDatastoreCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NoneDatastoreCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NoneDatastoreCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials_type: str):
        """
        Empty/none datastore credentials.
        :param str credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'None'.
        """
        pulumi.set(__self__, "credentials_type", 'None')

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> str:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'None'.
        """
        return pulumi.get(self, "credentials_type")


@pulumi.output_type
class NotebookPreparationErrorResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorMessage":
            suggest = "error_message"
        elif key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotebookPreparationErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotebookPreparationErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotebookPreparationErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_message: Optional[str] = None,
                 status_code: Optional[int] = None):
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[int]:
        return pulumi.get(self, "status_code")


@pulumi.output_type
class NotebookResourceInfoResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notebookPreparationError":
            suggest = "notebook_preparation_error"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotebookResourceInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotebookResourceInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotebookResourceInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: Optional[str] = None,
                 notebook_preparation_error: Optional['outputs.NotebookPreparationErrorResponse'] = None,
                 resource_id: Optional[str] = None):
        """
        :param 'NotebookPreparationErrorResponse' notebook_preparation_error: The error that occurs when preparing notebook.
        :param str resource_id: the data plane resourceId that used to initialize notebook component
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if notebook_preparation_error is not None:
            pulumi.set(__self__, "notebook_preparation_error", notebook_preparation_error)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="notebookPreparationError")
    def notebook_preparation_error(self) -> Optional['outputs.NotebookPreparationErrorResponse']:
        """
        The error that occurs when preparing notebook.
        """
        return pulumi.get(self, "notebook_preparation_error")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        the data plane resourceId that used to initialize notebook component
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class ObjectiveResponse(dict):
    """
    Optimization objective.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryMetric":
            suggest = "primary_metric"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectiveResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectiveResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectiveResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 goal: str,
                 primary_metric: str):
        """
        Optimization objective.
        :param str goal: [Required] Defines supported metric goals for hyperparameter tuning
        :param str primary_metric: [Required] Name of the metric to optimize.
        """
        pulumi.set(__self__, "goal", goal)
        pulumi.set(__self__, "primary_metric", primary_metric)

    @property
    @pulumi.getter
    def goal(self) -> str:
        """
        [Required] Defines supported metric goals for hyperparameter tuning
        """
        return pulumi.get(self, "goal")

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> str:
        """
        [Required] Name of the metric to optimize.
        """
        return pulumi.get(self, "primary_metric")


@pulumi.output_type
class OnlineEndpointResponse(dict):
    """
    Online endpoint configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authMode":
            suggest = "auth_mode"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "scoringUri":
            suggest = "scoring_uri"
        elif key == "swaggerUri":
            suggest = "swagger_uri"
        elif key == "publicNetworkAccess":
            suggest = "public_network_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OnlineEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OnlineEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OnlineEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_mode: str,
                 provisioning_state: str,
                 scoring_uri: str,
                 swagger_uri: str,
                 compute: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 public_network_access: Optional[str] = None,
                 traffic: Optional[Mapping[str, int]] = None):
        """
        Online endpoint configuration
        :param str auth_mode: [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
        :param str provisioning_state: Provisioning state for the endpoint.
        :param str scoring_uri: Endpoint URI.
        :param str swagger_uri: Endpoint Swagger URI.
        :param str compute: ARM resource ID of the compute if it exists.
               optional
        :param str description: Description of the inference endpoint.
        :param Mapping[str, str] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param str public_network_access: Set to "Enabled" for endpoints that should allow public access when Private Link is enabled.
        :param Mapping[str, int] traffic: Percentage of traffic from endpoint to divert to each deployment. Traffic values need to sum to 100.
        """
        pulumi.set(__self__, "auth_mode", auth_mode)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "scoring_uri", scoring_uri)
        pulumi.set(__self__, "swagger_uri", swagger_uri)
        if compute is not None:
            pulumi.set(__self__, "compute", compute)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if public_network_access is None:
            public_network_access = 'Enabled'
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if traffic is not None:
            pulumi.set(__self__, "traffic", traffic)

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> str:
        """
        [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
        """
        return pulumi.get(self, "auth_mode")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state for the endpoint.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="scoringUri")
    def scoring_uri(self) -> str:
        """
        Endpoint URI.
        """
        return pulumi.get(self, "scoring_uri")

    @property
    @pulumi.getter(name="swaggerUri")
    def swagger_uri(self) -> str:
        """
        Endpoint Swagger URI.
        """
        return pulumi.get(self, "swagger_uri")

    @property
    @pulumi.getter
    def compute(self) -> Optional[str]:
        """
        ARM resource ID of the compute if it exists.
        optional
        """
        return pulumi.get(self, "compute")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the inference endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[str]:
        """
        Set to "Enabled" for endpoints that should allow public access when Private Link is enabled.
        """
        return pulumi.get(self, "public_network_access")

    @property
    @pulumi.getter
    def traffic(self) -> Optional[Mapping[str, int]]:
        """
        Percentage of traffic from endpoint to divert to each deployment. Traffic values need to sum to 100.
        """
        return pulumi.get(self, "traffic")


@pulumi.output_type
class OnlineRequestSettingsResponse(dict):
    """
    Online deployment scoring requests configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxConcurrentRequestsPerInstance":
            suggest = "max_concurrent_requests_per_instance"
        elif key == "maxQueueWait":
            suggest = "max_queue_wait"
        elif key == "requestTimeout":
            suggest = "request_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OnlineRequestSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OnlineRequestSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OnlineRequestSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_concurrent_requests_per_instance: Optional[int] = None,
                 max_queue_wait: Optional[str] = None,
                 request_timeout: Optional[str] = None):
        """
        Online deployment scoring requests configuration.
        :param int max_concurrent_requests_per_instance: The number of maximum concurrent requests per node allowed per deployment. Defaults to 1.
        :param str max_queue_wait: The maximum amount of time a request will stay in the queue in ISO 8601 format.
               Defaults to 500ms.
        :param str request_timeout: The scoring timeout in ISO 8601 format.
               Defaults to 5000ms.
        """
        if max_concurrent_requests_per_instance is None:
            max_concurrent_requests_per_instance = 1
        if max_concurrent_requests_per_instance is not None:
            pulumi.set(__self__, "max_concurrent_requests_per_instance", max_concurrent_requests_per_instance)
        if max_queue_wait is None:
            max_queue_wait = 'PT0.5S'
        if max_queue_wait is not None:
            pulumi.set(__self__, "max_queue_wait", max_queue_wait)
        if request_timeout is None:
            request_timeout = 'PT5S'
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)

    @property
    @pulumi.getter(name="maxConcurrentRequestsPerInstance")
    def max_concurrent_requests_per_instance(self) -> Optional[int]:
        """
        The number of maximum concurrent requests per node allowed per deployment. Defaults to 1.
        """
        return pulumi.get(self, "max_concurrent_requests_per_instance")

    @property
    @pulumi.getter(name="maxQueueWait")
    def max_queue_wait(self) -> Optional[str]:
        """
        The maximum amount of time a request will stay in the queue in ISO 8601 format.
        Defaults to 500ms.
        """
        return pulumi.get(self, "max_queue_wait")

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[str]:
        """
        The scoring timeout in ISO 8601 format.
        Defaults to 5000ms.
        """
        return pulumi.get(self, "request_timeout")


@pulumi.output_type
class OutputPathAssetReferenceResponse(dict):
    """
    Reference to an asset via its path in a job output.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referenceType":
            suggest = "reference_type"
        elif key == "jobId":
            suggest = "job_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OutputPathAssetReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OutputPathAssetReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OutputPathAssetReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reference_type: str,
                 job_id: Optional[str] = None,
                 path: Optional[str] = None):
        """
        Reference to an asset via its path in a job output.
        :param str reference_type: Enum to determine which reference method to use for an asset.
               Expected value is 'OutputPath'.
        :param str job_id: ARM resource ID of the job.
        :param str path: The path of the file/directory in the job output.
        """
        pulumi.set(__self__, "reference_type", 'OutputPath')
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="referenceType")
    def reference_type(self) -> str:
        """
        Enum to determine which reference method to use for an asset.
        Expected value is 'OutputPath'.
        """
        return pulumi.get(self, "reference_type")

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[str]:
        """
        ARM resource ID of the job.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path of the file/directory in the job output.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class PATAuthTypeWorkspaceConnectionPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "valueFormat":
            suggest = "value_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PATAuthTypeWorkspaceConnectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PATAuthTypeWorkspaceConnectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PATAuthTypeWorkspaceConnectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: str,
                 category: Optional[str] = None,
                 credentials: Optional['outputs.WorkspaceConnectionPersonalAccessTokenResponse'] = None,
                 target: Optional[str] = None,
                 value: Optional[str] = None,
                 value_format: Optional[str] = None):
        """
        :param str auth_type: Authentication type of the connection target
               Expected value is 'PAT'.
        :param str category: Category of the connection
        :param str value: Value details of the workspace connection.
        :param str value_format: format for the workspace connection value
        """
        pulumi.set(__self__, "auth_type", 'PAT')
        if category is not None:
            pulumi.set(__self__, "category", category)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_format is not None:
            pulumi.set(__self__, "value_format", value_format)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> str:
        """
        Authentication type of the connection target
        Expected value is 'PAT'.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        Category of the connection
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.WorkspaceConnectionPersonalAccessTokenResponse']:
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value details of the workspace connection.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueFormat")
    def value_format(self) -> Optional[str]:
        """
        format for the workspace connection value
        """
        return pulumi.get(self, "value_format")


@pulumi.output_type
class PasswordResponse(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class PersonalComputeInstanceSettingsResponse(dict):
    """
    Settings for a personal compute instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignedUser":
            suggest = "assigned_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersonalComputeInstanceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersonalComputeInstanceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersonalComputeInstanceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assigned_user: Optional['outputs.AssignedUserResponse'] = None):
        """
        Settings for a personal compute instance.
        :param 'AssignedUserResponse' assigned_user: A user explicitly assigned to a personal compute instance.
        """
        if assigned_user is not None:
            pulumi.set(__self__, "assigned_user", assigned_user)

    @property
    @pulumi.getter(name="assignedUser")
    def assigned_user(self) -> Optional['outputs.AssignedUserResponse']:
        """
        A user explicitly assigned to a personal compute instance.
        """
        return pulumi.get(self, "assigned_user")


@pulumi.output_type
class PipelineJobResponse(dict):
    """
    Pipeline Job definition: defines generic to MFE attributes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobType":
            suggest = "job_type"
        elif key == "componentId":
            suggest = "component_id"
        elif key == "computeId":
            suggest = "compute_id"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "experimentName":
            suggest = "experiment_name"
        elif key == "isArchived":
            suggest = "is_archived"
        elif key == "sourceJobId":
            suggest = "source_job_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_type: str,
                 status: str,
                 component_id: Optional[str] = None,
                 compute_id: Optional[str] = None,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None,
                 experiment_name: Optional[str] = None,
                 identity: Optional[Any] = None,
                 inputs: Optional[Mapping[str, Any]] = None,
                 is_archived: Optional[bool] = None,
                 jobs: Optional[Mapping[str, Any]] = None,
                 outputs: Optional[Mapping[str, Any]] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 services: Optional[Mapping[str, 'outputs.JobServiceResponse']] = None,
                 settings: Optional[Any] = None,
                 source_job_id: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Pipeline Job definition: defines generic to MFE attributes.
        :param str job_type: Enum to determine the type of job.
               Expected value is 'Pipeline'.
        :param str status: Status of the job.
        :param str component_id: ARM resource ID of the component resource.
        :param str compute_id: ARM resource ID of the compute resource.
        :param str description: The asset description text.
        :param str display_name: Display name of job.
        :param str experiment_name: The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        :param Union['AmlTokenResponse', 'ManagedIdentityResponse', 'UserIdentityResponse'] identity: Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
               Defaults to AmlToken if null.
        :param Mapping[str, Union['CustomModelJobInputResponse', 'LiteralJobInputResponse', 'MLFlowModelJobInputResponse', 'MLTableJobInputResponse', 'TritonModelJobInputResponse', 'UriFileJobInputResponse', 'UriFolderJobInputResponse']] inputs: Inputs for the pipeline job.
        :param bool is_archived: Is the asset archived?
        :param Mapping[str, Any] jobs: Jobs construct the Pipeline Job.
        :param Mapping[str, Union['CustomModelJobOutputResponse', 'MLFlowModelJobOutputResponse', 'MLTableJobOutputResponse', 'TritonModelJobOutputResponse', 'UriFileJobOutputResponse', 'UriFolderJobOutputResponse']] outputs: Outputs for the pipeline job
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, 'JobServiceResponse'] services: List of JobEndpoints.
               For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :param Any settings: Pipeline settings, for things like ContinueRunOnStepFailure etc.
        :param str source_job_id: ARM resource ID of source job.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "job_type", 'Pipeline')
        pulumi.set(__self__, "status", status)
        if component_id is not None:
            pulumi.set(__self__, "component_id", component_id)
        if compute_id is not None:
            pulumi.set(__self__, "compute_id", compute_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if experiment_name is None:
            experiment_name = 'Default'
        if experiment_name is not None:
            pulumi.set(__self__, "experiment_name", experiment_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if jobs is not None:
            pulumi.set(__self__, "jobs", jobs)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if source_job_id is not None:
            pulumi.set(__self__, "source_job_id", source_job_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> str:
        """
        Enum to determine the type of job.
        Expected value is 'Pipeline'.
        """
        return pulumi.get(self, "job_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the job.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> Optional[str]:
        """
        ARM resource ID of the component resource.
        """
        return pulumi.get(self, "component_id")

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> Optional[str]:
        """
        ARM resource ID of the compute resource.
        """
        return pulumi.get(self, "compute_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of job.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="experimentName")
    def experiment_name(self) -> Optional[str]:
        """
        The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        """
        return pulumi.get(self, "experiment_name")

    @property
    @pulumi.getter
    def identity(self) -> Optional[Any]:
        """
        Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
        Defaults to AmlToken if null.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def inputs(self) -> Optional[Mapping[str, Any]]:
        """
        Inputs for the pipeline job.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[bool]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @property
    @pulumi.getter
    def jobs(self) -> Optional[Mapping[str, Any]]:
        """
        Jobs construct the Pipeline Job.
        """
        return pulumi.get(self, "jobs")

    @property
    @pulumi.getter
    def outputs(self) -> Optional[Mapping[str, Any]]:
        """
        Outputs for the pipeline job
        """
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def services(self) -> Optional[Mapping[str, 'outputs.JobServiceResponse']]:
        """
        List of JobEndpoints.
        For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Any]:
        """
        Pipeline settings, for things like ContinueRunOnStepFailure etc.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="sourceJobId")
    def source_job_id(self) -> Optional[str]:
        """
        ARM resource ID of source job.
        """
        return pulumi.get(self, "source_job_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    The Private Endpoint Connection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "systemData":
            suggest = "system_data"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 private_link_service_connection_state: 'outputs.PrivateLinkServiceConnectionStateResponse',
                 provisioning_state: str,
                 system_data: 'outputs.SystemDataResponse',
                 type: str,
                 identity: Optional['outputs.ManagedServiceIdentityResponse'] = None,
                 location: Optional[str] = None,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None,
                 sku: Optional['outputs.SkuResponse'] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        The Private Endpoint Connection resource.
        :param str id: Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        :param str name: The name of the resource
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: A collection of information about the state of the connection between service consumer and provider.
        :param str provisioning_state: The provisioning state of the private endpoint connection resource.
        :param 'SystemDataResponse' system_data: Azure Resource Manager metadata containing createdBy and modifiedBy information.
        :param str type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        :param 'ManagedServiceIdentityResponse' identity: The identity of the resource.
        :param str location: Specifies the location of the resource.
        :param 'PrivateEndpointResponse' private_endpoint: The resource of private end point.
        :param 'SkuResponse' sku: The sku of the workspace.
        :param Mapping[str, str] tags: Contains resource tags defined as key/value pairs.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "system_data", system_data)
        pulumi.set(__self__, "type", type)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.PrivateLinkServiceConnectionStateResponse':
        """
        A collection of information about the state of the connection between service consumer and provider.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the private endpoint connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.ManagedServiceIdentityResponse']:
        """
        The identity of the resource.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The resource of private end point.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter
    def sku(self) -> Optional['outputs.SkuResponse']:
        """
        The sku of the workspace.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Contains resource tags defined as key/value pairs.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetArmId":
            suggest = "subnet_arm_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 subnet_arm_id: str):
        """
        The Private Endpoint resource.
        :param str id: The ARM identifier for Private Endpoint
        :param str subnet_arm_id: The ARM identifier for Subnet resource that private endpoint links to
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "subnet_arm_id", subnet_arm_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ARM identifier for Private Endpoint
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="subnetArmId")
    def subnet_arm_id(self) -> str:
        """
        The ARM identifier for Subnet resource that private endpoint links to
        """
        return pulumi.get(self, "subnet_arm_id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    A collection of information about the state of the connection between service consumer and provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param str actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The reason for approval/rejection of the connection.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ProbeSettingsResponse(dict):
    """
    Deployment container liveness/readiness probe configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "initialDelay":
            suggest = "initial_delay"
        elif key == "successThreshold":
            suggest = "success_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProbeSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProbeSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProbeSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[int] = None,
                 initial_delay: Optional[str] = None,
                 period: Optional[str] = None,
                 success_threshold: Optional[int] = None,
                 timeout: Optional[str] = None):
        """
        Deployment container liveness/readiness probe configuration.
        :param int failure_threshold: The number of failures to allow before returning an unhealthy status.
        :param str initial_delay: The delay before the first probe in ISO 8601 format.
        :param str period: The length of time between probes in ISO 8601 format.
        :param int success_threshold: The number of successful probes before returning a healthy status.
        :param str timeout: The probe timeout in ISO 8601 format.
        """
        if failure_threshold is None:
            failure_threshold = 30
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if period is None:
            period = 'PT10S'
        if period is not None:
            pulumi.set(__self__, "period", period)
        if success_threshold is None:
            success_threshold = 1
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout is None:
            timeout = 'PT2S'
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[int]:
        """
        The number of failures to allow before returning an unhealthy status.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[str]:
        """
        The delay before the first probe in ISO 8601 format.
        """
        return pulumi.get(self, "initial_delay")

    @property
    @pulumi.getter
    def period(self) -> Optional[str]:
        """
        The length of time between probes in ISO 8601 format.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[int]:
        """
        The number of successful probes before returning a healthy status.
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        The probe timeout in ISO 8601 format.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class PyTorchResponse(dict):
    """
    PyTorch distribution configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionType":
            suggest = "distribution_type"
        elif key == "processCountPerInstance":
            suggest = "process_count_per_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PyTorchResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PyTorchResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PyTorchResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_type: str,
                 process_count_per_instance: Optional[int] = None):
        """
        PyTorch distribution configuration.
        :param str distribution_type: Enum to determine the job distribution type.
               Expected value is 'PyTorch'.
        :param int process_count_per_instance: Number of processes per node.
        """
        pulumi.set(__self__, "distribution_type", 'PyTorch')
        if process_count_per_instance is not None:
            pulumi.set(__self__, "process_count_per_instance", process_count_per_instance)

    @property
    @pulumi.getter(name="distributionType")
    def distribution_type(self) -> str:
        """
        Enum to determine the job distribution type.
        Expected value is 'PyTorch'.
        """
        return pulumi.get(self, "distribution_type")

    @property
    @pulumi.getter(name="processCountPerInstance")
    def process_count_per_instance(self) -> Optional[int]:
        """
        Number of processes per node.
        """
        return pulumi.get(self, "process_count_per_instance")


@pulumi.output_type
class RandomSamplingAlgorithmResponse(dict):
    """
    Defines a Sampling Algorithm that generates values randomly
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "samplingAlgorithmType":
            suggest = "sampling_algorithm_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RandomSamplingAlgorithmResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RandomSamplingAlgorithmResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RandomSamplingAlgorithmResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sampling_algorithm_type: str,
                 rule: Optional[str] = None,
                 seed: Optional[int] = None):
        """
        Defines a Sampling Algorithm that generates values randomly
        :param str sampling_algorithm_type: 
               Expected value is 'Random'.
        :param str rule: The specific type of random algorithm
        :param int seed: An optional integer to use as the seed for random number generation
        """
        pulumi.set(__self__, "sampling_algorithm_type", 'Random')
        if rule is None:
            rule = 'Random'
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if seed is not None:
            pulumi.set(__self__, "seed", seed)

    @property
    @pulumi.getter(name="samplingAlgorithmType")
    def sampling_algorithm_type(self) -> str:
        """

        Expected value is 'Random'.
        """
        return pulumi.get(self, "sampling_algorithm_type")

    @property
    @pulumi.getter
    def rule(self) -> Optional[str]:
        """
        The specific type of random algorithm
        """
        return pulumi.get(self, "rule")

    @property
    @pulumi.getter
    def seed(self) -> Optional[int]:
        """
        An optional integer to use as the seed for random number generation
        """
        return pulumi.get(self, "seed")


@pulumi.output_type
class RecurrenceScheduleResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monthDays":
            suggest = "month_days"
        elif key == "weekDays":
            suggest = "week_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecurrenceScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecurrenceScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecurrenceScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hours: Sequence[int],
                 minutes: Sequence[int],
                 month_days: Optional[Sequence[int]] = None,
                 week_days: Optional[Sequence[str]] = None):
        """
        :param Sequence[int] hours: [Required] List of hours for the schedule.
        :param Sequence[int] minutes: [Required] List of minutes for the schedule.
        :param Sequence[int] month_days: List of month days for the schedule
        :param Sequence[str] week_days: List of days for the schedule.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        if month_days is not None:
            pulumi.set(__self__, "month_days", month_days)
        if week_days is not None:
            pulumi.set(__self__, "week_days", week_days)

    @property
    @pulumi.getter
    def hours(self) -> Sequence[int]:
        """
        [Required] List of hours for the schedule.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Sequence[int]:
        """
        [Required] List of minutes for the schedule.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter(name="monthDays")
    def month_days(self) -> Optional[Sequence[int]]:
        """
        List of month days for the schedule
        """
        return pulumi.get(self, "month_days")

    @property
    @pulumi.getter(name="weekDays")
    def week_days(self) -> Optional[Sequence[str]]:
        """
        List of days for the schedule.
        """
        return pulumi.get(self, "week_days")


@pulumi.output_type
class RecurrenceTriggerResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "triggerType":
            suggest = "trigger_type"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecurrenceTriggerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecurrenceTriggerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecurrenceTriggerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frequency: str,
                 interval: int,
                 trigger_type: str,
                 end_time: Optional[str] = None,
                 schedule: Optional['outputs.RecurrenceScheduleResponse'] = None,
                 start_time: Optional[str] = None,
                 time_zone: Optional[str] = None):
        """
        :param str frequency: [Required] The frequency to trigger schedule.
        :param int interval: [Required] Specifies schedule interval in conjunction with frequency
        :param str trigger_type: 
               Expected value is 'Recurrence'.
        :param str end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601.
               Recommented format would be "2022-06-01T00:00:01"
               If not present, the schedule will run indefinitely
        :param 'RecurrenceScheduleResponse' schedule: The recurrence schedule.
        :param str start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC offset.
        :param str time_zone: Specifies time zone in which the schedule runs.
               TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
        """
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "trigger_type", 'Recurrence')
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is None:
            time_zone = 'UTC'
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def frequency(self) -> str:
        """
        [Required] The frequency to trigger schedule.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def interval(self) -> int:
        """
        [Required] Specifies schedule interval in conjunction with frequency
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> str:
        """

        Expected value is 'Recurrence'.
        """
        return pulumi.get(self, "trigger_type")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601.
        Recommented format would be "2022-06-01T00:00:01"
        If not present, the schedule will run indefinitely
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.RecurrenceScheduleResponse']:
        """
        The recurrence schedule.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Specifies start time of schedule in ISO 8601 format, but without a UTC offset.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        Specifies time zone in which the schedule runs.
        TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class RegistryListCredentialsResultResponse(dict):
    def __init__(__self__, *,
                 location: str,
                 username: str,
                 passwords: Optional[Sequence['outputs.PasswordResponse']] = None):
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "username", username)
        if passwords is not None:
            pulumi.set(__self__, "passwords", passwords)

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def passwords(self) -> Optional[Sequence['outputs.PasswordResponse']]:
        return pulumi.get(self, "passwords")


@pulumi.output_type
class RegressionResponse(dict):
    """
    Regression task in AutoML Table vertical.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"
        elif key == "trainingData":
            suggest = "training_data"
        elif key == "cvSplitColumnNames":
            suggest = "cv_split_column_names"
        elif key == "featurizationSettings":
            suggest = "featurization_settings"
        elif key == "limitSettings":
            suggest = "limit_settings"
        elif key == "logVerbosity":
            suggest = "log_verbosity"
        elif key == "nCrossValidations":
            suggest = "n_cross_validations"
        elif key == "primaryMetric":
            suggest = "primary_metric"
        elif key == "targetColumnName":
            suggest = "target_column_name"
        elif key == "testData":
            suggest = "test_data"
        elif key == "testDataSize":
            suggest = "test_data_size"
        elif key == "trainingSettings":
            suggest = "training_settings"
        elif key == "validationData":
            suggest = "validation_data"
        elif key == "validationDataSize":
            suggest = "validation_data_size"
        elif key == "weightColumnName":
            suggest = "weight_column_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegressionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegressionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegressionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_type: str,
                 training_data: 'outputs.MLTableJobInputResponse',
                 cv_split_column_names: Optional[Sequence[str]] = None,
                 featurization_settings: Optional['outputs.TableVerticalFeaturizationSettingsResponse'] = None,
                 limit_settings: Optional['outputs.TableVerticalLimitSettingsResponse'] = None,
                 log_verbosity: Optional[str] = None,
                 n_cross_validations: Optional[Any] = None,
                 primary_metric: Optional[str] = None,
                 target_column_name: Optional[str] = None,
                 test_data: Optional['outputs.MLTableJobInputResponse'] = None,
                 test_data_size: Optional[float] = None,
                 training_settings: Optional['outputs.RegressionTrainingSettingsResponse'] = None,
                 validation_data: Optional['outputs.MLTableJobInputResponse'] = None,
                 validation_data_size: Optional[float] = None,
                 weight_column_name: Optional[str] = None):
        """
        Regression task in AutoML Table vertical.
        :param str task_type: AutoMLJob Task type.
               Expected value is 'Regression'.
        :param 'MLTableJobInputResponse' training_data: [Required] Training data input.
        :param Sequence[str] cv_split_column_names: Columns to use for CVSplit data.
        :param 'TableVerticalFeaturizationSettingsResponse' featurization_settings: Featurization inputs needed for AutoML job.
        :param 'TableVerticalLimitSettingsResponse' limit_settings: Execution constraints for AutoMLJob.
        :param str log_verbosity: Log verbosity for the job.
        :param Union['AutoNCrossValidationsResponse', 'CustomNCrossValidationsResponse'] n_cross_validations: Number of cross validation folds to be applied on training dataset
               when validation dataset is not provided.
        :param str primary_metric: Primary metric for regression task.
        :param str target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param 'MLTableJobInputResponse' test_data: Test data input.
        :param float test_data_size: The fraction of test dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        :param 'RegressionTrainingSettingsResponse' training_settings: Inputs for training phase for an AutoML Job.
        :param 'MLTableJobInputResponse' validation_data: Validation data inputs.
        :param float validation_data_size: The fraction of training dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        :param str weight_column_name: The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
        """
        pulumi.set(__self__, "task_type", 'Regression')
        pulumi.set(__self__, "training_data", training_data)
        if cv_split_column_names is not None:
            pulumi.set(__self__, "cv_split_column_names", cv_split_column_names)
        if featurization_settings is not None:
            pulumi.set(__self__, "featurization_settings", featurization_settings)
        if limit_settings is not None:
            pulumi.set(__self__, "limit_settings", limit_settings)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if n_cross_validations is not None:
            pulumi.set(__self__, "n_cross_validations", n_cross_validations)
        if primary_metric is None:
            primary_metric = 'NormalizedRootMeanSquaredError'
        if primary_metric is not None:
            pulumi.set(__self__, "primary_metric", primary_metric)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if test_data is not None:
            pulumi.set(__self__, "test_data", test_data)
        if test_data_size is not None:
            pulumi.set(__self__, "test_data_size", test_data_size)
        if training_settings is not None:
            pulumi.set(__self__, "training_settings", training_settings)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)
        if validation_data_size is not None:
            pulumi.set(__self__, "validation_data_size", validation_data_size)
        if weight_column_name is not None:
            pulumi.set(__self__, "weight_column_name", weight_column_name)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        AutoMLJob Task type.
        Expected value is 'Regression'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> 'outputs.MLTableJobInputResponse':
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @property
    @pulumi.getter(name="cvSplitColumnNames")
    def cv_split_column_names(self) -> Optional[Sequence[str]]:
        """
        Columns to use for CVSplit data.
        """
        return pulumi.get(self, "cv_split_column_names")

    @property
    @pulumi.getter(name="featurizationSettings")
    def featurization_settings(self) -> Optional['outputs.TableVerticalFeaturizationSettingsResponse']:
        """
        Featurization inputs needed for AutoML job.
        """
        return pulumi.get(self, "featurization_settings")

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> Optional['outputs.TableVerticalLimitSettingsResponse']:
        """
        Execution constraints for AutoMLJob.
        """
        return pulumi.get(self, "limit_settings")

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[str]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @property
    @pulumi.getter(name="nCrossValidations")
    def n_cross_validations(self) -> Optional[Any]:
        """
        Number of cross validation folds to be applied on training dataset
        when validation dataset is not provided.
        """
        return pulumi.get(self, "n_cross_validations")

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> Optional[str]:
        """
        Primary metric for regression task.
        """
        return pulumi.get(self, "primary_metric")

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[str]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @property
    @pulumi.getter(name="testData")
    def test_data(self) -> Optional['outputs.MLTableJobInputResponse']:
        """
        Test data input.
        """
        return pulumi.get(self, "test_data")

    @property
    @pulumi.getter(name="testDataSize")
    def test_data_size(self) -> Optional[float]:
        """
        The fraction of test dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "test_data_size")

    @property
    @pulumi.getter(name="trainingSettings")
    def training_settings(self) -> Optional['outputs.RegressionTrainingSettingsResponse']:
        """
        Inputs for training phase for an AutoML Job.
        """
        return pulumi.get(self, "training_settings")

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional['outputs.MLTableJobInputResponse']:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")

    @property
    @pulumi.getter(name="validationDataSize")
    def validation_data_size(self) -> Optional[float]:
        """
        The fraction of training dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "validation_data_size")

    @property
    @pulumi.getter(name="weightColumnName")
    def weight_column_name(self) -> Optional[str]:
        """
        The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
        """
        return pulumi.get(self, "weight_column_name")


@pulumi.output_type
class RegressionTrainingSettingsResponse(dict):
    """
    Regression Training related configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedTrainingAlgorithms":
            suggest = "allowed_training_algorithms"
        elif key == "blockedTrainingAlgorithms":
            suggest = "blocked_training_algorithms"
        elif key == "enableDnnTraining":
            suggest = "enable_dnn_training"
        elif key == "enableModelExplainability":
            suggest = "enable_model_explainability"
        elif key == "enableOnnxCompatibleModels":
            suggest = "enable_onnx_compatible_models"
        elif key == "enableStackEnsemble":
            suggest = "enable_stack_ensemble"
        elif key == "enableVoteEnsemble":
            suggest = "enable_vote_ensemble"
        elif key == "ensembleModelDownloadTimeout":
            suggest = "ensemble_model_download_timeout"
        elif key == "stackEnsembleSettings":
            suggest = "stack_ensemble_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegressionTrainingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegressionTrainingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegressionTrainingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_training_algorithms: Optional[Sequence[str]] = None,
                 blocked_training_algorithms: Optional[Sequence[str]] = None,
                 enable_dnn_training: Optional[bool] = None,
                 enable_model_explainability: Optional[bool] = None,
                 enable_onnx_compatible_models: Optional[bool] = None,
                 enable_stack_ensemble: Optional[bool] = None,
                 enable_vote_ensemble: Optional[bool] = None,
                 ensemble_model_download_timeout: Optional[str] = None,
                 stack_ensemble_settings: Optional['outputs.StackEnsembleSettingsResponse'] = None):
        """
        Regression Training related configuration.
        :param Sequence[str] allowed_training_algorithms: Allowed models for regression task.
        :param Sequence[str] blocked_training_algorithms: Blocked models for regression task.
        :param bool enable_dnn_training: Enable recommendation of DNN models.
        :param bool enable_model_explainability: Flag to turn on explainability on best model.
        :param bool enable_onnx_compatible_models: Flag for enabling onnx compatible models.
        :param bool enable_stack_ensemble: Enable stack ensemble run.
        :param bool enable_vote_ensemble: Enable voting ensemble run.
        :param str ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
               Configure this parameter with a higher value than 300 secs, if more time is needed.
        :param 'StackEnsembleSettingsResponse' stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
        """
        if allowed_training_algorithms is not None:
            pulumi.set(__self__, "allowed_training_algorithms", allowed_training_algorithms)
        if blocked_training_algorithms is not None:
            pulumi.set(__self__, "blocked_training_algorithms", blocked_training_algorithms)
        if enable_dnn_training is None:
            enable_dnn_training = False
        if enable_dnn_training is not None:
            pulumi.set(__self__, "enable_dnn_training", enable_dnn_training)
        if enable_model_explainability is None:
            enable_model_explainability = True
        if enable_model_explainability is not None:
            pulumi.set(__self__, "enable_model_explainability", enable_model_explainability)
        if enable_onnx_compatible_models is None:
            enable_onnx_compatible_models = False
        if enable_onnx_compatible_models is not None:
            pulumi.set(__self__, "enable_onnx_compatible_models", enable_onnx_compatible_models)
        if enable_stack_ensemble is None:
            enable_stack_ensemble = True
        if enable_stack_ensemble is not None:
            pulumi.set(__self__, "enable_stack_ensemble", enable_stack_ensemble)
        if enable_vote_ensemble is None:
            enable_vote_ensemble = True
        if enable_vote_ensemble is not None:
            pulumi.set(__self__, "enable_vote_ensemble", enable_vote_ensemble)
        if ensemble_model_download_timeout is None:
            ensemble_model_download_timeout = 'PT5M'
        if ensemble_model_download_timeout is not None:
            pulumi.set(__self__, "ensemble_model_download_timeout", ensemble_model_download_timeout)
        if stack_ensemble_settings is not None:
            pulumi.set(__self__, "stack_ensemble_settings", stack_ensemble_settings)

    @property
    @pulumi.getter(name="allowedTrainingAlgorithms")
    def allowed_training_algorithms(self) -> Optional[Sequence[str]]:
        """
        Allowed models for regression task.
        """
        return pulumi.get(self, "allowed_training_algorithms")

    @property
    @pulumi.getter(name="blockedTrainingAlgorithms")
    def blocked_training_algorithms(self) -> Optional[Sequence[str]]:
        """
        Blocked models for regression task.
        """
        return pulumi.get(self, "blocked_training_algorithms")

    @property
    @pulumi.getter(name="enableDnnTraining")
    def enable_dnn_training(self) -> Optional[bool]:
        """
        Enable recommendation of DNN models.
        """
        return pulumi.get(self, "enable_dnn_training")

    @property
    @pulumi.getter(name="enableModelExplainability")
    def enable_model_explainability(self) -> Optional[bool]:
        """
        Flag to turn on explainability on best model.
        """
        return pulumi.get(self, "enable_model_explainability")

    @property
    @pulumi.getter(name="enableOnnxCompatibleModels")
    def enable_onnx_compatible_models(self) -> Optional[bool]:
        """
        Flag for enabling onnx compatible models.
        """
        return pulumi.get(self, "enable_onnx_compatible_models")

    @property
    @pulumi.getter(name="enableStackEnsemble")
    def enable_stack_ensemble(self) -> Optional[bool]:
        """
        Enable stack ensemble run.
        """
        return pulumi.get(self, "enable_stack_ensemble")

    @property
    @pulumi.getter(name="enableVoteEnsemble")
    def enable_vote_ensemble(self) -> Optional[bool]:
        """
        Enable voting ensemble run.
        """
        return pulumi.get(self, "enable_vote_ensemble")

    @property
    @pulumi.getter(name="ensembleModelDownloadTimeout")
    def ensemble_model_download_timeout(self) -> Optional[str]:
        """
        During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
        Configure this parameter with a higher value than 300 secs, if more time is needed.
        """
        return pulumi.get(self, "ensemble_model_download_timeout")

    @property
    @pulumi.getter(name="stackEnsembleSettings")
    def stack_ensemble_settings(self) -> Optional['outputs.StackEnsembleSettingsResponse']:
        """
        Stack ensemble settings for stack ensemble run.
        """
        return pulumi.get(self, "stack_ensemble_settings")


@pulumi.output_type
class ResourceIdResponse(dict):
    """
    Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
    """
    def __init__(__self__, *,
                 id: str):
        """
        Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
        :param str id: The ID of the resource
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the resource
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class RouteResponse(dict):
    def __init__(__self__, *,
                 path: str,
                 port: int):
        """
        :param str path: [Required] The path for the route.
        :param int port: [Required] The port for the route.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        [Required] The path for the route.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        [Required] The port for the route.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class SASAuthTypeWorkspaceConnectionPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "valueFormat":
            suggest = "value_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SASAuthTypeWorkspaceConnectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SASAuthTypeWorkspaceConnectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SASAuthTypeWorkspaceConnectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: str,
                 category: Optional[str] = None,
                 credentials: Optional['outputs.WorkspaceConnectionSharedAccessSignatureResponse'] = None,
                 target: Optional[str] = None,
                 value: Optional[str] = None,
                 value_format: Optional[str] = None):
        """
        :param str auth_type: Authentication type of the connection target
               Expected value is 'SAS'.
        :param str category: Category of the connection
        :param str value: Value details of the workspace connection.
        :param str value_format: format for the workspace connection value
        """
        pulumi.set(__self__, "auth_type", 'SAS')
        if category is not None:
            pulumi.set(__self__, "category", category)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_format is not None:
            pulumi.set(__self__, "value_format", value_format)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> str:
        """
        Authentication type of the connection target
        Expected value is 'SAS'.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        Category of the connection
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.WorkspaceConnectionSharedAccessSignatureResponse']:
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value details of the workspace connection.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueFormat")
    def value_format(self) -> Optional[str]:
        """
        format for the workspace connection value
        """
        return pulumi.get(self, "value_format")


@pulumi.output_type
class SasDatastoreCredentialsResponse(dict):
    """
    SAS datastore credentials configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialsType":
            suggest = "credentials_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SasDatastoreCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SasDatastoreCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SasDatastoreCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials_type: str):
        """
        SAS datastore credentials configuration.
        :param str credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'Sas'.
        """
        pulumi.set(__self__, "credentials_type", 'Sas')

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> str:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'Sas'.
        """
        return pulumi.get(self, "credentials_type")


@pulumi.output_type
class ScaleSettingsResponse(dict):
    """
    scale settings for AML Compute
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "minNodeCount":
            suggest = "min_node_count"
        elif key == "nodeIdleTimeBeforeScaleDown":
            suggest = "node_idle_time_before_scale_down"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_node_count: int,
                 min_node_count: Optional[int] = None,
                 node_idle_time_before_scale_down: Optional[str] = None):
        """
        scale settings for AML Compute
        :param int max_node_count: Max number of nodes to use
        :param int min_node_count: Min number of nodes to use
        :param str node_idle_time_before_scale_down: Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
        """
        pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is None:
            min_node_count = 0
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)
        if node_idle_time_before_scale_down is not None:
            pulumi.set(__self__, "node_idle_time_before_scale_down", node_idle_time_before_scale_down)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> int:
        """
        Max number of nodes to use
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[int]:
        """
        Min number of nodes to use
        """
        return pulumi.get(self, "min_node_count")

    @property
    @pulumi.getter(name="nodeIdleTimeBeforeScaleDown")
    def node_idle_time_before_scale_down(self) -> Optional[str]:
        """
        Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
        """
        return pulumi.get(self, "node_idle_time_before_scale_down")


@pulumi.output_type
class ScheduleBaseResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningStatus":
            suggest = "provisioning_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleBaseResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleBaseResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleBaseResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 provisioning_status: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str id: A system assigned id for the schedule.
        :param str provisioning_status: The current deployment state of schedule.
        :param str status: Is the schedule enabled or disabled?
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if provisioning_status is not None:
            pulumi.set(__self__, "provisioning_status", provisioning_status)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        A system assigned id for the schedule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> Optional[str]:
        """
        The current deployment state of schedule.
        """
        return pulumi.get(self, "provisioning_status")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Is the schedule enabled or disabled?
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ScheduleResponse(dict):
    """
    Base definition of a schedule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Any,
                 provisioning_state: str,
                 trigger: Any,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None,
                 is_enabled: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Base definition of a schedule
        :param Union['EndpointScheduleActionResponse', 'JobScheduleActionResponse'] action: [Required] Specifies the action of the schedule
        :param str provisioning_state: Provisioning state for the schedule.
        :param Union['CronTriggerResponse', 'RecurrenceTriggerResponse'] trigger: [Required] Specifies the trigger details
        :param str description: The asset description text.
        :param str display_name: Display name of schedule.
        :param bool is_enabled: Is the schedule enabled?
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "trigger", trigger)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if is_enabled is None:
            is_enabled = True
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def action(self) -> Any:
        """
        [Required] Specifies the action of the schedule
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state for the schedule.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def trigger(self) -> Any:
        """
        [Required] Specifies the trigger details
        """
        return pulumi.get(self, "trigger")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of schedule.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Is the schedule enabled?
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ScriptReferenceResponse(dict):
    """
    Script reference
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scriptArguments":
            suggest = "script_arguments"
        elif key == "scriptData":
            suggest = "script_data"
        elif key == "scriptSource":
            suggest = "script_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScriptReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScriptReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScriptReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 script_arguments: Optional[str] = None,
                 script_data: Optional[str] = None,
                 script_source: Optional[str] = None,
                 timeout: Optional[str] = None):
        """
        Script reference
        :param str script_arguments: Optional command line arguments passed to the script to run.
        :param str script_data: The location of scripts in the mounted volume.
        :param str script_source: The storage source of the script: inline, workspace.
        :param str timeout: Optional time period passed to timeout command.
        """
        if script_arguments is not None:
            pulumi.set(__self__, "script_arguments", script_arguments)
        if script_data is not None:
            pulumi.set(__self__, "script_data", script_data)
        if script_source is not None:
            pulumi.set(__self__, "script_source", script_source)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="scriptArguments")
    def script_arguments(self) -> Optional[str]:
        """
        Optional command line arguments passed to the script to run.
        """
        return pulumi.get(self, "script_arguments")

    @property
    @pulumi.getter(name="scriptData")
    def script_data(self) -> Optional[str]:
        """
        The location of scripts in the mounted volume.
        """
        return pulumi.get(self, "script_data")

    @property
    @pulumi.getter(name="scriptSource")
    def script_source(self) -> Optional[str]:
        """
        The storage source of the script: inline, workspace.
        """
        return pulumi.get(self, "script_source")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        Optional time period passed to timeout command.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ScriptsToExecuteResponse(dict):
    """
    Customized setup scripts
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationScript":
            suggest = "creation_script"
        elif key == "startupScript":
            suggest = "startup_script"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScriptsToExecuteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScriptsToExecuteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScriptsToExecuteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_script: Optional['outputs.ScriptReferenceResponse'] = None,
                 startup_script: Optional['outputs.ScriptReferenceResponse'] = None):
        """
        Customized setup scripts
        :param 'ScriptReferenceResponse' creation_script: Script that's run only once during provision of the compute.
        :param 'ScriptReferenceResponse' startup_script: Script that's run every time the machine starts.
        """
        if creation_script is not None:
            pulumi.set(__self__, "creation_script", creation_script)
        if startup_script is not None:
            pulumi.set(__self__, "startup_script", startup_script)

    @property
    @pulumi.getter(name="creationScript")
    def creation_script(self) -> Optional['outputs.ScriptReferenceResponse']:
        """
        Script that's run only once during provision of the compute.
        """
        return pulumi.get(self, "creation_script")

    @property
    @pulumi.getter(name="startupScript")
    def startup_script(self) -> Optional['outputs.ScriptReferenceResponse']:
        """
        Script that's run every time the machine starts.
        """
        return pulumi.get(self, "startup_script")


@pulumi.output_type
class ServiceManagedResourcesSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cosmosDb":
            suggest = "cosmos_db"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceManagedResourcesSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceManagedResourcesSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceManagedResourcesSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cosmos_db: Optional['outputs.CosmosDbSettingsResponse'] = None):
        """
        :param 'CosmosDbSettingsResponse' cosmos_db: The settings for the service managed cosmosdb account.
        """
        if cosmos_db is not None:
            pulumi.set(__self__, "cosmos_db", cosmos_db)

    @property
    @pulumi.getter(name="cosmosDb")
    def cosmos_db(self) -> Optional['outputs.CosmosDbSettingsResponse']:
        """
        The settings for the service managed cosmosdb account.
        """
        return pulumi.get(self, "cosmos_db")


@pulumi.output_type
class ServicePrincipalDatastoreCredentialsResponse(dict):
    """
    Service Principal datastore credentials configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "credentialsType":
            suggest = "credentials_type"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "authorityUrl":
            suggest = "authority_url"
        elif key == "resourceUrl":
            suggest = "resource_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePrincipalDatastoreCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePrincipalDatastoreCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePrincipalDatastoreCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 credentials_type: str,
                 tenant_id: str,
                 authority_url: Optional[str] = None,
                 resource_url: Optional[str] = None):
        """
        Service Principal datastore credentials configuration.
        :param str client_id: [Required] Service principal client ID.
        :param str credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'ServicePrincipal'.
        :param str tenant_id: [Required] ID of the tenant to which the service principal belongs.
        :param str authority_url: Authority URL used for authentication.
        :param str resource_url: Resource the service principal has access to.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "credentials_type", 'ServicePrincipal')
        pulumi.set(__self__, "tenant_id", tenant_id)
        if authority_url is not None:
            pulumi.set(__self__, "authority_url", authority_url)
        if resource_url is not None:
            pulumi.set(__self__, "resource_url", resource_url)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        [Required] Service principal client ID.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> str:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'ServicePrincipal'.
        """
        return pulumi.get(self, "credentials_type")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        [Required] ID of the tenant to which the service principal belongs.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="authorityUrl")
    def authority_url(self) -> Optional[str]:
        """
        Authority URL used for authentication.
        """
        return pulumi.get(self, "authority_url")

    @property
    @pulumi.getter(name="resourceUrl")
    def resource_url(self) -> Optional[str]:
        """
        Resource the service principal has access to.
        """
        return pulumi.get(self, "resource_url")


@pulumi.output_type
class SetupScriptsResponse(dict):
    """
    Details of customized scripts to execute for setting up the cluster.
    """
    def __init__(__self__, *,
                 scripts: Optional['outputs.ScriptsToExecuteResponse'] = None):
        """
        Details of customized scripts to execute for setting up the cluster.
        :param 'ScriptsToExecuteResponse' scripts: Customized setup scripts
        """
        if scripts is not None:
            pulumi.set(__self__, "scripts", scripts)

    @property
    @pulumi.getter
    def scripts(self) -> Optional['outputs.ScriptsToExecuteResponse']:
        """
        Customized setup scripts
        """
        return pulumi.get(self, "scripts")


@pulumi.output_type
class SharedPrivateLinkResourceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupId":
            suggest = "group_id"
        elif key == "privateLinkResourceId":
            suggest = "private_link_resource_id"
        elif key == "requestMessage":
            suggest = "request_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SharedPrivateLinkResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SharedPrivateLinkResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SharedPrivateLinkResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_link_resource_id: Optional[str] = None,
                 request_message: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str group_id: The private link resource group id.
        :param str name: Unique name of the private link.
        :param str private_link_resource_id: The resource id that private link links to.
        :param str request_message: Request message.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_link_resource_id is not None:
            pulumi.set(__self__, "private_link_resource_id", private_link_resource_id)
        if request_message is not None:
            pulumi.set(__self__, "request_message", request_message)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[str]:
        """
        The private link resource group id.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Unique name of the private link.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkResourceId")
    def private_link_resource_id(self) -> Optional[str]:
        """
        The resource id that private link links to.
        """
        return pulumi.get(self, "private_link_resource_id")

    @property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> Optional[str]:
        """
        Request message.
        """
        return pulumi.get(self, "request_message")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class SkuResponse(dict):
    """
    The resource model definition representing SKU
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        The resource model definition representing SKU
        :param str name: The name of the SKU. Ex - P3. It is typically a letter+number code
        :param int capacity: If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        :param str family: If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param str size: The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        :param str tier: This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU. Ex - P3. It is typically a letter+number code
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SslConfigurationResponse(dict):
    """
    The ssl configuration for scoring
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "leafDomainLabel":
            suggest = "leaf_domain_label"
        elif key == "overwriteExistingDomain":
            suggest = "overwrite_existing_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SslConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SslConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SslConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert: Optional[str] = None,
                 cname: Optional[str] = None,
                 key: Optional[str] = None,
                 leaf_domain_label: Optional[str] = None,
                 overwrite_existing_domain: Optional[bool] = None,
                 status: Optional[str] = None):
        """
        The ssl configuration for scoring
        :param str cert: Cert data
        :param str cname: CNAME of the cert
        :param str key: Key data
        :param str leaf_domain_label: Leaf domain label of public endpoint
        :param bool overwrite_existing_domain: Indicates whether to overwrite existing domain label.
        :param str status: Enable or disable ssl for scoring
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if leaf_domain_label is not None:
            pulumi.set(__self__, "leaf_domain_label", leaf_domain_label)
        if overwrite_existing_domain is not None:
            pulumi.set(__self__, "overwrite_existing_domain", overwrite_existing_domain)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def cert(self) -> Optional[str]:
        """
        Cert data
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter
    def cname(self) -> Optional[str]:
        """
        CNAME of the cert
        """
        return pulumi.get(self, "cname")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        Key data
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="leafDomainLabel")
    def leaf_domain_label(self) -> Optional[str]:
        """
        Leaf domain label of public endpoint
        """
        return pulumi.get(self, "leaf_domain_label")

    @property
    @pulumi.getter(name="overwriteExistingDomain")
    def overwrite_existing_domain(self) -> Optional[bool]:
        """
        Indicates whether to overwrite existing domain label.
        """
        return pulumi.get(self, "overwrite_existing_domain")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Enable or disable ssl for scoring
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class StackEnsembleSettingsResponse(dict):
    """
    Advances setting to customize StackEnsemble run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stackMetaLearnerKWargs":
            suggest = "stack_meta_learner_k_wargs"
        elif key == "stackMetaLearnerTrainPercentage":
            suggest = "stack_meta_learner_train_percentage"
        elif key == "stackMetaLearnerType":
            suggest = "stack_meta_learner_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackEnsembleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackEnsembleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackEnsembleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 stack_meta_learner_k_wargs: Optional[Any] = None,
                 stack_meta_learner_train_percentage: Optional[float] = None,
                 stack_meta_learner_type: Optional[str] = None):
        """
        Advances setting to customize StackEnsemble run.
        :param Any stack_meta_learner_k_wargs: Optional parameters to pass to the initializer of the meta-learner.
        :param float stack_meta_learner_train_percentage: Specifies the proportion of the training set (when choosing train and validation type of training) to be reserved for training the meta-learner. Default value is 0.2.
        :param str stack_meta_learner_type: The meta-learner is a model trained on the output of the individual heterogeneous models.
        """
        if stack_meta_learner_k_wargs is not None:
            pulumi.set(__self__, "stack_meta_learner_k_wargs", stack_meta_learner_k_wargs)
        if stack_meta_learner_train_percentage is None:
            stack_meta_learner_train_percentage = 0.2
        if stack_meta_learner_train_percentage is not None:
            pulumi.set(__self__, "stack_meta_learner_train_percentage", stack_meta_learner_train_percentage)
        if stack_meta_learner_type is None:
            stack_meta_learner_type = 'None'
        if stack_meta_learner_type is not None:
            pulumi.set(__self__, "stack_meta_learner_type", stack_meta_learner_type)

    @property
    @pulumi.getter(name="stackMetaLearnerKWargs")
    def stack_meta_learner_k_wargs(self) -> Optional[Any]:
        """
        Optional parameters to pass to the initializer of the meta-learner.
        """
        return pulumi.get(self, "stack_meta_learner_k_wargs")

    @property
    @pulumi.getter(name="stackMetaLearnerTrainPercentage")
    def stack_meta_learner_train_percentage(self) -> Optional[float]:
        """
        Specifies the proportion of the training set (when choosing train and validation type of training) to be reserved for training the meta-learner. Default value is 0.2.
        """
        return pulumi.get(self, "stack_meta_learner_train_percentage")

    @property
    @pulumi.getter(name="stackMetaLearnerType")
    def stack_meta_learner_type(self) -> Optional[str]:
        """
        The meta-learner is a model trained on the output of the individual heterogeneous models.
        """
        return pulumi.get(self, "stack_meta_learner_type")


@pulumi.output_type
class SweepJobLimitsResponse(dict):
    """
    Sweep Job limit class.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobLimitsType":
            suggest = "job_limits_type"
        elif key == "maxConcurrentTrials":
            suggest = "max_concurrent_trials"
        elif key == "maxTotalTrials":
            suggest = "max_total_trials"
        elif key == "trialTimeout":
            suggest = "trial_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SweepJobLimitsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SweepJobLimitsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SweepJobLimitsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_limits_type: str,
                 max_concurrent_trials: Optional[int] = None,
                 max_total_trials: Optional[int] = None,
                 timeout: Optional[str] = None,
                 trial_timeout: Optional[str] = None):
        """
        Sweep Job limit class.
        :param str job_limits_type: 
               Expected value is 'Sweep'.
        :param int max_concurrent_trials: Sweep Job max concurrent trials.
        :param int max_total_trials: Sweep Job max total trials.
        :param str timeout: The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
        :param str trial_timeout: Sweep Job Trial timeout value.
        """
        pulumi.set(__self__, "job_limits_type", 'Sweep')
        if max_concurrent_trials is not None:
            pulumi.set(__self__, "max_concurrent_trials", max_concurrent_trials)
        if max_total_trials is not None:
            pulumi.set(__self__, "max_total_trials", max_total_trials)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if trial_timeout is not None:
            pulumi.set(__self__, "trial_timeout", trial_timeout)

    @property
    @pulumi.getter(name="jobLimitsType")
    def job_limits_type(self) -> str:
        """

        Expected value is 'Sweep'.
        """
        return pulumi.get(self, "job_limits_type")

    @property
    @pulumi.getter(name="maxConcurrentTrials")
    def max_concurrent_trials(self) -> Optional[int]:
        """
        Sweep Job max concurrent trials.
        """
        return pulumi.get(self, "max_concurrent_trials")

    @property
    @pulumi.getter(name="maxTotalTrials")
    def max_total_trials(self) -> Optional[int]:
        """
        Sweep Job max total trials.
        """
        return pulumi.get(self, "max_total_trials")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="trialTimeout")
    def trial_timeout(self) -> Optional[str]:
        """
        Sweep Job Trial timeout value.
        """
        return pulumi.get(self, "trial_timeout")


@pulumi.output_type
class SweepJobResponse(dict):
    """
    Sweep job definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobType":
            suggest = "job_type"
        elif key == "samplingAlgorithm":
            suggest = "sampling_algorithm"
        elif key == "searchSpace":
            suggest = "search_space"
        elif key == "componentId":
            suggest = "component_id"
        elif key == "computeId":
            suggest = "compute_id"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "earlyTermination":
            suggest = "early_termination"
        elif key == "experimentName":
            suggest = "experiment_name"
        elif key == "isArchived":
            suggest = "is_archived"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SweepJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SweepJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SweepJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_type: str,
                 objective: 'outputs.ObjectiveResponse',
                 sampling_algorithm: Any,
                 search_space: Any,
                 status: str,
                 trial: 'outputs.TrialComponentResponse',
                 component_id: Optional[str] = None,
                 compute_id: Optional[str] = None,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None,
                 early_termination: Optional[Any] = None,
                 experiment_name: Optional[str] = None,
                 identity: Optional[Any] = None,
                 inputs: Optional[Mapping[str, Any]] = None,
                 is_archived: Optional[bool] = None,
                 limits: Optional['outputs.SweepJobLimitsResponse'] = None,
                 outputs: Optional[Mapping[str, Any]] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 services: Optional[Mapping[str, 'outputs.JobServiceResponse']] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Sweep job definition.
        :param str job_type: Enum to determine the type of job.
               Expected value is 'Sweep'.
        :param 'ObjectiveResponse' objective: [Required] Optimization objective.
        :param Union['BayesianSamplingAlgorithmResponse', 'GridSamplingAlgorithmResponse', 'RandomSamplingAlgorithmResponse'] sampling_algorithm: [Required] The hyperparameter sampling algorithm
        :param Any search_space: [Required] A dictionary containing each parameter and its distribution. The dictionary key is the name of the parameter
        :param str status: Status of the job.
        :param 'TrialComponentResponse' trial: [Required] Trial component definition.
        :param str component_id: ARM resource ID of the component resource.
        :param str compute_id: ARM resource ID of the compute resource.
        :param str description: The asset description text.
        :param str display_name: Display name of job.
        :param Union['BanditPolicyResponse', 'MedianStoppingPolicyResponse', 'TruncationSelectionPolicyResponse'] early_termination: Early termination policies enable canceling poor-performing runs before they complete
        :param str experiment_name: The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        :param Union['AmlTokenResponse', 'ManagedIdentityResponse', 'UserIdentityResponse'] identity: Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
               Defaults to AmlToken if null.
        :param Mapping[str, Union['CustomModelJobInputResponse', 'LiteralJobInputResponse', 'MLFlowModelJobInputResponse', 'MLTableJobInputResponse', 'TritonModelJobInputResponse', 'UriFileJobInputResponse', 'UriFolderJobInputResponse']] inputs: Mapping of input data bindings used in the job.
        :param bool is_archived: Is the asset archived?
        :param 'SweepJobLimitsResponse' limits: Sweep Job limit.
        :param Mapping[str, Union['CustomModelJobOutputResponse', 'MLFlowModelJobOutputResponse', 'MLTableJobOutputResponse', 'TritonModelJobOutputResponse', 'UriFileJobOutputResponse', 'UriFolderJobOutputResponse']] outputs: Mapping of output data bindings used in the job.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, 'JobServiceResponse'] services: List of JobEndpoints.
               For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "job_type", 'Sweep')
        pulumi.set(__self__, "objective", objective)
        pulumi.set(__self__, "sampling_algorithm", sampling_algorithm)
        pulumi.set(__self__, "search_space", search_space)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "trial", trial)
        if component_id is not None:
            pulumi.set(__self__, "component_id", component_id)
        if compute_id is not None:
            pulumi.set(__self__, "compute_id", compute_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if early_termination is not None:
            pulumi.set(__self__, "early_termination", early_termination)
        if experiment_name is None:
            experiment_name = 'Default'
        if experiment_name is not None:
            pulumi.set(__self__, "experiment_name", experiment_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> str:
        """
        Enum to determine the type of job.
        Expected value is 'Sweep'.
        """
        return pulumi.get(self, "job_type")

    @property
    @pulumi.getter
    def objective(self) -> 'outputs.ObjectiveResponse':
        """
        [Required] Optimization objective.
        """
        return pulumi.get(self, "objective")

    @property
    @pulumi.getter(name="samplingAlgorithm")
    def sampling_algorithm(self) -> Any:
        """
        [Required] The hyperparameter sampling algorithm
        """
        return pulumi.get(self, "sampling_algorithm")

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> Any:
        """
        [Required] A dictionary containing each parameter and its distribution. The dictionary key is the name of the parameter
        """
        return pulumi.get(self, "search_space")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the job.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def trial(self) -> 'outputs.TrialComponentResponse':
        """
        [Required] Trial component definition.
        """
        return pulumi.get(self, "trial")

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> Optional[str]:
        """
        ARM resource ID of the component resource.
        """
        return pulumi.get(self, "component_id")

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> Optional[str]:
        """
        ARM resource ID of the compute resource.
        """
        return pulumi.get(self, "compute_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of job.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="earlyTermination")
    def early_termination(self) -> Optional[Any]:
        """
        Early termination policies enable canceling poor-performing runs before they complete
        """
        return pulumi.get(self, "early_termination")

    @property
    @pulumi.getter(name="experimentName")
    def experiment_name(self) -> Optional[str]:
        """
        The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        """
        return pulumi.get(self, "experiment_name")

    @property
    @pulumi.getter
    def identity(self) -> Optional[Any]:
        """
        Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
        Defaults to AmlToken if null.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def inputs(self) -> Optional[Mapping[str, Any]]:
        """
        Mapping of input data bindings used in the job.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[bool]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @property
    @pulumi.getter
    def limits(self) -> Optional['outputs.SweepJobLimitsResponse']:
        """
        Sweep Job limit.
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def outputs(self) -> Optional[Mapping[str, Any]]:
        """
        Mapping of output data bindings used in the job.
        """
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def services(self) -> Optional[Mapping[str, 'outputs.JobServiceResponse']]:
        """
        List of JobEndpoints.
        For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class SynapseSparkResponse(dict):
    """
    A SynapseSpark compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SynapseSparkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SynapseSparkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SynapseSparkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 properties: Optional['outputs.SynapseSparkResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A SynapseSpark compute.
        :param str compute_type: The type of compute
               Expected value is 'SynapseSpark'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'SynapseSpark')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'SynapseSpark'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.SynapseSparkResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class SynapseSparkResponseProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoPauseProperties":
            suggest = "auto_pause_properties"
        elif key == "autoScaleProperties":
            suggest = "auto_scale_properties"
        elif key == "nodeCount":
            suggest = "node_count"
        elif key == "nodeSize":
            suggest = "node_size"
        elif key == "nodeSizeFamily":
            suggest = "node_size_family"
        elif key == "poolName":
            suggest = "pool_name"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "sparkVersion":
            suggest = "spark_version"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "workspaceName":
            suggest = "workspace_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SynapseSparkResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SynapseSparkResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SynapseSparkResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_pause_properties: Optional['outputs.AutoPausePropertiesResponse'] = None,
                 auto_scale_properties: Optional['outputs.AutoScalePropertiesResponse'] = None,
                 node_count: Optional[int] = None,
                 node_size: Optional[str] = None,
                 node_size_family: Optional[str] = None,
                 pool_name: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 spark_version: Optional[str] = None,
                 subscription_id: Optional[str] = None,
                 workspace_name: Optional[str] = None):
        """
        :param 'AutoPausePropertiesResponse' auto_pause_properties: Auto pause properties.
        :param 'AutoScalePropertiesResponse' auto_scale_properties: Auto scale properties.
        :param int node_count: The number of compute nodes currently assigned to the compute.
        :param str node_size: Node size.
        :param str node_size_family: Node size family.
        :param str pool_name: Pool name.
        :param str resource_group: Name of the resource group in which workspace is located.
        :param str spark_version: Spark version.
        :param str subscription_id: Azure subscription identifier.
        :param str workspace_name: Name of Azure Machine Learning workspace.
        """
        if auto_pause_properties is not None:
            pulumi.set(__self__, "auto_pause_properties", auto_pause_properties)
        if auto_scale_properties is not None:
            pulumi.set(__self__, "auto_scale_properties", auto_scale_properties)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_size is not None:
            pulumi.set(__self__, "node_size", node_size)
        if node_size_family is not None:
            pulumi.set(__self__, "node_size_family", node_size_family)
        if pool_name is not None:
            pulumi.set(__self__, "pool_name", pool_name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if spark_version is not None:
            pulumi.set(__self__, "spark_version", spark_version)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if workspace_name is not None:
            pulumi.set(__self__, "workspace_name", workspace_name)

    @property
    @pulumi.getter(name="autoPauseProperties")
    def auto_pause_properties(self) -> Optional['outputs.AutoPausePropertiesResponse']:
        """
        Auto pause properties.
        """
        return pulumi.get(self, "auto_pause_properties")

    @property
    @pulumi.getter(name="autoScaleProperties")
    def auto_scale_properties(self) -> Optional['outputs.AutoScalePropertiesResponse']:
        """
        Auto scale properties.
        """
        return pulumi.get(self, "auto_scale_properties")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[int]:
        """
        The number of compute nodes currently assigned to the compute.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeSize")
    def node_size(self) -> Optional[str]:
        """
        Node size.
        """
        return pulumi.get(self, "node_size")

    @property
    @pulumi.getter(name="nodeSizeFamily")
    def node_size_family(self) -> Optional[str]:
        """
        Node size family.
        """
        return pulumi.get(self, "node_size_family")

    @property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> Optional[str]:
        """
        Pool name.
        """
        return pulumi.get(self, "pool_name")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Name of the resource group in which workspace is located.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> Optional[str]:
        """
        Spark version.
        """
        return pulumi.get(self, "spark_version")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        Azure subscription identifier.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> Optional[str]:
        """
        Name of Azure Machine Learning workspace.
        """
        return pulumi.get(self, "workspace_name")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class SystemServiceResponse(dict):
    """
    A system service running on a compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicIpAddress":
            suggest = "public_ip_address"
        elif key == "systemServiceType":
            suggest = "system_service_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_ip_address: str,
                 system_service_type: str,
                 version: str):
        """
        A system service running on a compute.
        :param str public_ip_address: Public IP address
        :param str system_service_type: The type of this system service.
        :param str version: The version for this type.
        """
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        pulumi.set(__self__, "system_service_type", system_service_type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        """
        Public IP address
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter(name="systemServiceType")
    def system_service_type(self) -> str:
        """
        The type of this system service.
        """
        return pulumi.get(self, "system_service_type")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version for this type.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class TableVerticalFeaturizationSettingsResponse(dict):
    """
    Featurization Configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockedTransformers":
            suggest = "blocked_transformers"
        elif key == "columnNameAndTypes":
            suggest = "column_name_and_types"
        elif key == "datasetLanguage":
            suggest = "dataset_language"
        elif key == "enableDnnFeaturization":
            suggest = "enable_dnn_featurization"
        elif key == "transformerParams":
            suggest = "transformer_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableVerticalFeaturizationSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableVerticalFeaturizationSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableVerticalFeaturizationSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blocked_transformers: Optional[Sequence[str]] = None,
                 column_name_and_types: Optional[Mapping[str, str]] = None,
                 dataset_language: Optional[str] = None,
                 enable_dnn_featurization: Optional[bool] = None,
                 mode: Optional[str] = None,
                 transformer_params: Optional[Mapping[str, Sequence['outputs.ColumnTransformerResponse']]] = None):
        """
        Featurization Configuration.
        :param Sequence[str] blocked_transformers: These transformers shall not be used in featurization.
        :param Mapping[str, str] column_name_and_types: Dictionary of column name and its type (int, float, string, datetime etc).
        :param str dataset_language: Dataset language, useful for the text data.
        :param bool enable_dnn_featurization: Determines whether to use Dnn based featurizers for data featurization.
        :param str mode: Featurization mode - User can keep the default 'Auto' mode and AutoML will take care of necessary transformation of the data in featurization phase.
               If 'Off' is selected then no featurization is done.
               If 'Custom' is selected then user can specify additional inputs to customize how featurization is done.
        :param Mapping[str, Sequence['ColumnTransformerResponse']] transformer_params: User can specify additional transformers to be used along with the columns to which it would be applied and parameters for the transformer constructor.
        """
        if blocked_transformers is not None:
            pulumi.set(__self__, "blocked_transformers", blocked_transformers)
        if column_name_and_types is not None:
            pulumi.set(__self__, "column_name_and_types", column_name_and_types)
        if dataset_language is not None:
            pulumi.set(__self__, "dataset_language", dataset_language)
        if enable_dnn_featurization is None:
            enable_dnn_featurization = False
        if enable_dnn_featurization is not None:
            pulumi.set(__self__, "enable_dnn_featurization", enable_dnn_featurization)
        if mode is None:
            mode = 'Auto'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if transformer_params is not None:
            pulumi.set(__self__, "transformer_params", transformer_params)

    @property
    @pulumi.getter(name="blockedTransformers")
    def blocked_transformers(self) -> Optional[Sequence[str]]:
        """
        These transformers shall not be used in featurization.
        """
        return pulumi.get(self, "blocked_transformers")

    @property
    @pulumi.getter(name="columnNameAndTypes")
    def column_name_and_types(self) -> Optional[Mapping[str, str]]:
        """
        Dictionary of column name and its type (int, float, string, datetime etc).
        """
        return pulumi.get(self, "column_name_and_types")

    @property
    @pulumi.getter(name="datasetLanguage")
    def dataset_language(self) -> Optional[str]:
        """
        Dataset language, useful for the text data.
        """
        return pulumi.get(self, "dataset_language")

    @property
    @pulumi.getter(name="enableDnnFeaturization")
    def enable_dnn_featurization(self) -> Optional[bool]:
        """
        Determines whether to use Dnn based featurizers for data featurization.
        """
        return pulumi.get(self, "enable_dnn_featurization")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Featurization mode - User can keep the default 'Auto' mode and AutoML will take care of necessary transformation of the data in featurization phase.
        If 'Off' is selected then no featurization is done.
        If 'Custom' is selected then user can specify additional inputs to customize how featurization is done.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="transformerParams")
    def transformer_params(self) -> Optional[Mapping[str, Sequence['outputs.ColumnTransformerResponse']]]:
        """
        User can specify additional transformers to be used along with the columns to which it would be applied and parameters for the transformer constructor.
        """
        return pulumi.get(self, "transformer_params")


@pulumi.output_type
class TableVerticalLimitSettingsResponse(dict):
    """
    Job execution constraints.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableEarlyTermination":
            suggest = "enable_early_termination"
        elif key == "exitScore":
            suggest = "exit_score"
        elif key == "maxConcurrentTrials":
            suggest = "max_concurrent_trials"
        elif key == "maxCoresPerTrial":
            suggest = "max_cores_per_trial"
        elif key == "maxTrials":
            suggest = "max_trials"
        elif key == "trialTimeout":
            suggest = "trial_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableVerticalLimitSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableVerticalLimitSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableVerticalLimitSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_early_termination: Optional[bool] = None,
                 exit_score: Optional[float] = None,
                 max_concurrent_trials: Optional[int] = None,
                 max_cores_per_trial: Optional[int] = None,
                 max_trials: Optional[int] = None,
                 timeout: Optional[str] = None,
                 trial_timeout: Optional[str] = None):
        """
        Job execution constraints.
        :param bool enable_early_termination: Enable early termination, determines whether or not if AutoMLJob will terminate early if there is no score improvement in last 20 iterations.
        :param float exit_score: Exit score for the AutoML job.
        :param int max_concurrent_trials: Maximum Concurrent iterations.
        :param int max_cores_per_trial: Max cores per iteration.
        :param int max_trials: Number of iterations.
        :param str timeout: AutoML job timeout.
        :param str trial_timeout: Iteration timeout.
        """
        if enable_early_termination is None:
            enable_early_termination = True
        if enable_early_termination is not None:
            pulumi.set(__self__, "enable_early_termination", enable_early_termination)
        if exit_score is not None:
            pulumi.set(__self__, "exit_score", exit_score)
        if max_concurrent_trials is None:
            max_concurrent_trials = 1
        if max_concurrent_trials is not None:
            pulumi.set(__self__, "max_concurrent_trials", max_concurrent_trials)
        if max_cores_per_trial is None:
            max_cores_per_trial = -1
        if max_cores_per_trial is not None:
            pulumi.set(__self__, "max_cores_per_trial", max_cores_per_trial)
        if max_trials is None:
            max_trials = 1000
        if max_trials is not None:
            pulumi.set(__self__, "max_trials", max_trials)
        if timeout is None:
            timeout = 'PT6H'
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if trial_timeout is None:
            trial_timeout = 'PT30M'
        if trial_timeout is not None:
            pulumi.set(__self__, "trial_timeout", trial_timeout)

    @property
    @pulumi.getter(name="enableEarlyTermination")
    def enable_early_termination(self) -> Optional[bool]:
        """
        Enable early termination, determines whether or not if AutoMLJob will terminate early if there is no score improvement in last 20 iterations.
        """
        return pulumi.get(self, "enable_early_termination")

    @property
    @pulumi.getter(name="exitScore")
    def exit_score(self) -> Optional[float]:
        """
        Exit score for the AutoML job.
        """
        return pulumi.get(self, "exit_score")

    @property
    @pulumi.getter(name="maxConcurrentTrials")
    def max_concurrent_trials(self) -> Optional[int]:
        """
        Maximum Concurrent iterations.
        """
        return pulumi.get(self, "max_concurrent_trials")

    @property
    @pulumi.getter(name="maxCoresPerTrial")
    def max_cores_per_trial(self) -> Optional[int]:
        """
        Max cores per iteration.
        """
        return pulumi.get(self, "max_cores_per_trial")

    @property
    @pulumi.getter(name="maxTrials")
    def max_trials(self) -> Optional[int]:
        """
        Number of iterations.
        """
        return pulumi.get(self, "max_trials")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        AutoML job timeout.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="trialTimeout")
    def trial_timeout(self) -> Optional[str]:
        """
        Iteration timeout.
        """
        return pulumi.get(self, "trial_timeout")


@pulumi.output_type
class TargetUtilizationScaleSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scaleType":
            suggest = "scale_type"
        elif key == "maxInstances":
            suggest = "max_instances"
        elif key == "minInstances":
            suggest = "min_instances"
        elif key == "pollingInterval":
            suggest = "polling_interval"
        elif key == "targetUtilizationPercentage":
            suggest = "target_utilization_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetUtilizationScaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetUtilizationScaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetUtilizationScaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scale_type: str,
                 max_instances: Optional[int] = None,
                 min_instances: Optional[int] = None,
                 polling_interval: Optional[str] = None,
                 target_utilization_percentage: Optional[int] = None):
        """
        :param str scale_type: 
               Expected value is 'TargetUtilization'.
        :param int max_instances: The maximum number of instances that the deployment can scale to. The quota will be reserved for max_instances.
        :param int min_instances: The minimum number of instances to always be present.
        :param str polling_interval: The polling interval in ISO 8691 format. Only supports duration with precision as low as Seconds.
        :param int target_utilization_percentage: Target CPU usage for the autoscaler.
        """
        pulumi.set(__self__, "scale_type", 'TargetUtilization')
        if max_instances is None:
            max_instances = 1
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is None:
            min_instances = 1
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if polling_interval is None:
            polling_interval = 'PT1S'
        if polling_interval is not None:
            pulumi.set(__self__, "polling_interval", polling_interval)
        if target_utilization_percentage is None:
            target_utilization_percentage = 70
        if target_utilization_percentage is not None:
            pulumi.set(__self__, "target_utilization_percentage", target_utilization_percentage)

    @property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> str:
        """

        Expected value is 'TargetUtilization'.
        """
        return pulumi.get(self, "scale_type")

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[int]:
        """
        The maximum number of instances that the deployment can scale to. The quota will be reserved for max_instances.
        """
        return pulumi.get(self, "max_instances")

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[int]:
        """
        The minimum number of instances to always be present.
        """
        return pulumi.get(self, "min_instances")

    @property
    @pulumi.getter(name="pollingInterval")
    def polling_interval(self) -> Optional[str]:
        """
        The polling interval in ISO 8691 format. Only supports duration with precision as low as Seconds.
        """
        return pulumi.get(self, "polling_interval")

    @property
    @pulumi.getter(name="targetUtilizationPercentage")
    def target_utilization_percentage(self) -> Optional[int]:
        """
        Target CPU usage for the autoscaler.
        """
        return pulumi.get(self, "target_utilization_percentage")


@pulumi.output_type
class TensorFlowResponse(dict):
    """
    TensorFlow distribution configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionType":
            suggest = "distribution_type"
        elif key == "parameterServerCount":
            suggest = "parameter_server_count"
        elif key == "workerCount":
            suggest = "worker_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TensorFlowResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TensorFlowResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TensorFlowResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_type: str,
                 parameter_server_count: Optional[int] = None,
                 worker_count: Optional[int] = None):
        """
        TensorFlow distribution configuration.
        :param str distribution_type: Enum to determine the job distribution type.
               Expected value is 'TensorFlow'.
        :param int parameter_server_count: Number of parameter server tasks.
        :param int worker_count: Number of workers. If not specified, will default to the instance count.
        """
        pulumi.set(__self__, "distribution_type", 'TensorFlow')
        if parameter_server_count is None:
            parameter_server_count = 0
        if parameter_server_count is not None:
            pulumi.set(__self__, "parameter_server_count", parameter_server_count)
        if worker_count is not None:
            pulumi.set(__self__, "worker_count", worker_count)

    @property
    @pulumi.getter(name="distributionType")
    def distribution_type(self) -> str:
        """
        Enum to determine the job distribution type.
        Expected value is 'TensorFlow'.
        """
        return pulumi.get(self, "distribution_type")

    @property
    @pulumi.getter(name="parameterServerCount")
    def parameter_server_count(self) -> Optional[int]:
        """
        Number of parameter server tasks.
        """
        return pulumi.get(self, "parameter_server_count")

    @property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> Optional[int]:
        """
        Number of workers. If not specified, will default to the instance count.
        """
        return pulumi.get(self, "worker_count")


@pulumi.output_type
class TextClassificationMultilabelResponse(dict):
    """
    Text Classification Multilabel task in AutoML NLP vertical.
    NLP - Natural Language Processing.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryMetric":
            suggest = "primary_metric"
        elif key == "taskType":
            suggest = "task_type"
        elif key == "trainingData":
            suggest = "training_data"
        elif key == "featurizationSettings":
            suggest = "featurization_settings"
        elif key == "limitSettings":
            suggest = "limit_settings"
        elif key == "logVerbosity":
            suggest = "log_verbosity"
        elif key == "targetColumnName":
            suggest = "target_column_name"
        elif key == "validationData":
            suggest = "validation_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TextClassificationMultilabelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TextClassificationMultilabelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TextClassificationMultilabelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primary_metric: str,
                 task_type: str,
                 training_data: 'outputs.MLTableJobInputResponse',
                 featurization_settings: Optional['outputs.NlpVerticalFeaturizationSettingsResponse'] = None,
                 limit_settings: Optional['outputs.NlpVerticalLimitSettingsResponse'] = None,
                 log_verbosity: Optional[str] = None,
                 target_column_name: Optional[str] = None,
                 validation_data: Optional['outputs.MLTableJobInputResponse'] = None):
        """
        Text Classification Multilabel task in AutoML NLP vertical.
        NLP - Natural Language Processing.
        :param str primary_metric: Primary metric for Text-Classification-Multilabel task.
               Currently only Accuracy is supported as primary metric, hence user need not set it explicitly.
        :param str task_type: AutoMLJob Task type.
               Expected value is 'TextClassificationMultilabel'.
        :param 'MLTableJobInputResponse' training_data: [Required] Training data input.
        :param 'NlpVerticalFeaturizationSettingsResponse' featurization_settings: Featurization inputs needed for AutoML job.
        :param 'NlpVerticalLimitSettingsResponse' limit_settings: Execution constraints for AutoMLJob.
        :param str log_verbosity: Log verbosity for the job.
        :param str target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param 'MLTableJobInputResponse' validation_data: Validation data inputs.
        """
        pulumi.set(__self__, "primary_metric", primary_metric)
        pulumi.set(__self__, "task_type", 'TextClassificationMultilabel')
        pulumi.set(__self__, "training_data", training_data)
        if featurization_settings is not None:
            pulumi.set(__self__, "featurization_settings", featurization_settings)
        if limit_settings is not None:
            pulumi.set(__self__, "limit_settings", limit_settings)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> str:
        """
        Primary metric for Text-Classification-Multilabel task.
        Currently only Accuracy is supported as primary metric, hence user need not set it explicitly.
        """
        return pulumi.get(self, "primary_metric")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        AutoMLJob Task type.
        Expected value is 'TextClassificationMultilabel'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> 'outputs.MLTableJobInputResponse':
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @property
    @pulumi.getter(name="featurizationSettings")
    def featurization_settings(self) -> Optional['outputs.NlpVerticalFeaturizationSettingsResponse']:
        """
        Featurization inputs needed for AutoML job.
        """
        return pulumi.get(self, "featurization_settings")

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> Optional['outputs.NlpVerticalLimitSettingsResponse']:
        """
        Execution constraints for AutoMLJob.
        """
        return pulumi.get(self, "limit_settings")

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[str]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[str]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional['outputs.MLTableJobInputResponse']:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")


@pulumi.output_type
class TextClassificationResponse(dict):
    """
    Text Classification task in AutoML NLP vertical.
    NLP - Natural Language Processing.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"
        elif key == "trainingData":
            suggest = "training_data"
        elif key == "featurizationSettings":
            suggest = "featurization_settings"
        elif key == "limitSettings":
            suggest = "limit_settings"
        elif key == "logVerbosity":
            suggest = "log_verbosity"
        elif key == "primaryMetric":
            suggest = "primary_metric"
        elif key == "targetColumnName":
            suggest = "target_column_name"
        elif key == "validationData":
            suggest = "validation_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TextClassificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TextClassificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TextClassificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_type: str,
                 training_data: 'outputs.MLTableJobInputResponse',
                 featurization_settings: Optional['outputs.NlpVerticalFeaturizationSettingsResponse'] = None,
                 limit_settings: Optional['outputs.NlpVerticalLimitSettingsResponse'] = None,
                 log_verbosity: Optional[str] = None,
                 primary_metric: Optional[str] = None,
                 target_column_name: Optional[str] = None,
                 validation_data: Optional['outputs.MLTableJobInputResponse'] = None):
        """
        Text Classification task in AutoML NLP vertical.
        NLP - Natural Language Processing.
        :param str task_type: AutoMLJob Task type.
               Expected value is 'TextClassification'.
        :param 'MLTableJobInputResponse' training_data: [Required] Training data input.
        :param 'NlpVerticalFeaturizationSettingsResponse' featurization_settings: Featurization inputs needed for AutoML job.
        :param 'NlpVerticalLimitSettingsResponse' limit_settings: Execution constraints for AutoMLJob.
        :param str log_verbosity: Log verbosity for the job.
        :param str primary_metric: Primary metric for Text-Classification task.
        :param str target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param 'MLTableJobInputResponse' validation_data: Validation data inputs.
        """
        pulumi.set(__self__, "task_type", 'TextClassification')
        pulumi.set(__self__, "training_data", training_data)
        if featurization_settings is not None:
            pulumi.set(__self__, "featurization_settings", featurization_settings)
        if limit_settings is not None:
            pulumi.set(__self__, "limit_settings", limit_settings)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if primary_metric is None:
            primary_metric = 'Accuracy'
        if primary_metric is not None:
            pulumi.set(__self__, "primary_metric", primary_metric)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        AutoMLJob Task type.
        Expected value is 'TextClassification'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> 'outputs.MLTableJobInputResponse':
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @property
    @pulumi.getter(name="featurizationSettings")
    def featurization_settings(self) -> Optional['outputs.NlpVerticalFeaturizationSettingsResponse']:
        """
        Featurization inputs needed for AutoML job.
        """
        return pulumi.get(self, "featurization_settings")

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> Optional['outputs.NlpVerticalLimitSettingsResponse']:
        """
        Execution constraints for AutoMLJob.
        """
        return pulumi.get(self, "limit_settings")

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[str]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> Optional[str]:
        """
        Primary metric for Text-Classification task.
        """
        return pulumi.get(self, "primary_metric")

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[str]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional['outputs.MLTableJobInputResponse']:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")


@pulumi.output_type
class TextNerResponse(dict):
    """
    Text-NER task in AutoML NLP vertical.
    NER - Named Entity Recognition.
    NLP - Natural Language Processing.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryMetric":
            suggest = "primary_metric"
        elif key == "taskType":
            suggest = "task_type"
        elif key == "trainingData":
            suggest = "training_data"
        elif key == "featurizationSettings":
            suggest = "featurization_settings"
        elif key == "limitSettings":
            suggest = "limit_settings"
        elif key == "logVerbosity":
            suggest = "log_verbosity"
        elif key == "targetColumnName":
            suggest = "target_column_name"
        elif key == "validationData":
            suggest = "validation_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TextNerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TextNerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TextNerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primary_metric: str,
                 task_type: str,
                 training_data: 'outputs.MLTableJobInputResponse',
                 featurization_settings: Optional['outputs.NlpVerticalFeaturizationSettingsResponse'] = None,
                 limit_settings: Optional['outputs.NlpVerticalLimitSettingsResponse'] = None,
                 log_verbosity: Optional[str] = None,
                 target_column_name: Optional[str] = None,
                 validation_data: Optional['outputs.MLTableJobInputResponse'] = None):
        """
        Text-NER task in AutoML NLP vertical.
        NER - Named Entity Recognition.
        NLP - Natural Language Processing.
        :param str primary_metric: Primary metric for Text-NER task.
               Only 'Accuracy' is supported for Text-NER, so user need not set this explicitly.
        :param str task_type: AutoMLJob Task type.
               Expected value is 'TextNER'.
        :param 'MLTableJobInputResponse' training_data: [Required] Training data input.
        :param 'NlpVerticalFeaturizationSettingsResponse' featurization_settings: Featurization inputs needed for AutoML job.
        :param 'NlpVerticalLimitSettingsResponse' limit_settings: Execution constraints for AutoMLJob.
        :param str log_verbosity: Log verbosity for the job.
        :param str target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param 'MLTableJobInputResponse' validation_data: Validation data inputs.
        """
        pulumi.set(__self__, "primary_metric", primary_metric)
        pulumi.set(__self__, "task_type", 'TextNER')
        pulumi.set(__self__, "training_data", training_data)
        if featurization_settings is not None:
            pulumi.set(__self__, "featurization_settings", featurization_settings)
        if limit_settings is not None:
            pulumi.set(__self__, "limit_settings", limit_settings)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> str:
        """
        Primary metric for Text-NER task.
        Only 'Accuracy' is supported for Text-NER, so user need not set this explicitly.
        """
        return pulumi.get(self, "primary_metric")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        AutoMLJob Task type.
        Expected value is 'TextNER'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> 'outputs.MLTableJobInputResponse':
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @property
    @pulumi.getter(name="featurizationSettings")
    def featurization_settings(self) -> Optional['outputs.NlpVerticalFeaturizationSettingsResponse']:
        """
        Featurization inputs needed for AutoML job.
        """
        return pulumi.get(self, "featurization_settings")

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> Optional['outputs.NlpVerticalLimitSettingsResponse']:
        """
        Execution constraints for AutoMLJob.
        """
        return pulumi.get(self, "limit_settings")

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[str]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[str]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional['outputs.MLTableJobInputResponse']:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")


@pulumi.output_type
class TrialComponentResponse(dict):
    """
    Trial component definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentId":
            suggest = "environment_id"
        elif key == "codeId":
            suggest = "code_id"
        elif key == "environmentVariables":
            suggest = "environment_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrialComponentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrialComponentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrialComponentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: str,
                 environment_id: str,
                 code_id: Optional[str] = None,
                 distribution: Optional[Any] = None,
                 environment_variables: Optional[Mapping[str, str]] = None,
                 resources: Optional['outputs.JobResourceConfigurationResponse'] = None):
        """
        Trial component definition.
        :param str command: [Required] The command to execute on startup of the job. eg. "python train.py"
        :param str environment_id: [Required] The ARM resource ID of the Environment specification for the job.
        :param str code_id: ARM resource ID of the code asset.
        :param Union['MpiResponse', 'PyTorchResponse', 'TensorFlowResponse'] distribution: Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        :param Mapping[str, str] environment_variables: Environment variables included in the job.
        :param 'JobResourceConfigurationResponse' resources: Compute Resource configuration for the job.
        """
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "environment_id", environment_id)
        if code_id is not None:
            pulumi.set(__self__, "code_id", code_id)
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def command(self) -> str:
        """
        [Required] The command to execute on startup of the job. eg. "python train.py"
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> str:
        """
        [Required] The ARM resource ID of the Environment specification for the job.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="codeId")
    def code_id(self) -> Optional[str]:
        """
        ARM resource ID of the code asset.
        """
        return pulumi.get(self, "code_id")

    @property
    @pulumi.getter
    def distribution(self) -> Optional[Any]:
        """
        Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables included in the job.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.JobResourceConfigurationResponse']:
        """
        Compute Resource configuration for the job.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class TritonModelJobInputResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobInputType":
            suggest = "job_input_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TritonModelJobInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TritonModelJobInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TritonModelJobInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_input_type: str,
                 uri: str,
                 description: Optional[str] = None,
                 mode: Optional[str] = None):
        """
        :param str job_input_type: Enum to determine the Job Input Type.
               Expected value is 'triton_model'.
        :param str uri: [Required] Input Asset URI.
        :param str description: Description for the input.
        :param str mode: Input Asset Delivery Mode.
        """
        pulumi.set(__self__, "job_input_type", 'triton_model')
        pulumi.set(__self__, "uri", uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadOnlyMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="jobInputType")
    def job_input_type(self) -> str:
        """
        Enum to determine the Job Input Type.
        Expected value is 'triton_model'.
        """
        return pulumi.get(self, "job_input_type")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        [Required] Input Asset URI.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description for the input.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Input Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class TritonModelJobOutputResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobOutputType":
            suggest = "job_output_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TritonModelJobOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TritonModelJobOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TritonModelJobOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_output_type: str,
                 description: Optional[str] = None,
                 mode: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param str job_output_type: Enum to determine the Job Output Type.
               Expected value is 'triton_model'.
        :param str description: Description for the output.
        :param str mode: Output Asset Delivery Mode.
        :param str uri: Output Asset URI.
        """
        pulumi.set(__self__, "job_output_type", 'triton_model')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadWriteMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="jobOutputType")
    def job_output_type(self) -> str:
        """
        Enum to determine the Job Output Type.
        Expected value is 'triton_model'.
        """
        return pulumi.get(self, "job_output_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description for the output.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Output Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Output Asset URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class TruncationSelectionPolicyResponse(dict):
    """
    Defines an early termination policy that cancels a given percentage of runs at each evaluation interval.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyType":
            suggest = "policy_type"
        elif key == "delayEvaluation":
            suggest = "delay_evaluation"
        elif key == "evaluationInterval":
            suggest = "evaluation_interval"
        elif key == "truncationPercentage":
            suggest = "truncation_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TruncationSelectionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TruncationSelectionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TruncationSelectionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_type: str,
                 delay_evaluation: Optional[int] = None,
                 evaluation_interval: Optional[int] = None,
                 truncation_percentage: Optional[int] = None):
        """
        Defines an early termination policy that cancels a given percentage of runs at each evaluation interval.
        :param str policy_type: 
               Expected value is 'TruncationSelection'.
        :param int delay_evaluation: Number of intervals by which to delay the first evaluation.
        :param int evaluation_interval: Interval (number of runs) between policy evaluations.
        :param int truncation_percentage: The percentage of runs to cancel at each evaluation interval.
        """
        pulumi.set(__self__, "policy_type", 'TruncationSelection')
        if delay_evaluation is None:
            delay_evaluation = 0
        if delay_evaluation is not None:
            pulumi.set(__self__, "delay_evaluation", delay_evaluation)
        if evaluation_interval is None:
            evaluation_interval = 0
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)
        if truncation_percentage is None:
            truncation_percentage = 0
        if truncation_percentage is not None:
            pulumi.set(__self__, "truncation_percentage", truncation_percentage)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> str:
        """

        Expected value is 'TruncationSelection'.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="delayEvaluation")
    def delay_evaluation(self) -> Optional[int]:
        """
        Number of intervals by which to delay the first evaluation.
        """
        return pulumi.get(self, "delay_evaluation")

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[int]:
        """
        Interval (number of runs) between policy evaluations.
        """
        return pulumi.get(self, "evaluation_interval")

    @property
    @pulumi.getter(name="truncationPercentage")
    def truncation_percentage(self) -> Optional[int]:
        """
        The percentage of runs to cancel at each evaluation interval.
        """
        return pulumi.get(self, "truncation_percentage")


@pulumi.output_type
class UriFileDataVersionResponse(dict):
    """
    uri-file data version entity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "dataUri":
            suggest = "data_uri"
        elif key == "isAnonymous":
            suggest = "is_anonymous"
        elif key == "isArchived":
            suggest = "is_archived"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UriFileDataVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UriFileDataVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UriFileDataVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_type: str,
                 data_uri: str,
                 description: Optional[str] = None,
                 is_anonymous: Optional[bool] = None,
                 is_archived: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        uri-file data version entity
        :param str data_type: Enum to determine the type of data.
               Expected value is 'uri_file'.
        :param str data_uri: [Required] Uri of the data. Usage/meaning depends on Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20221001.Assets.DataVersionBase.DataType
        :param str description: The asset description text.
        :param bool is_anonymous: If the name version are system generated (anonymous registration).
        :param bool is_archived: Is the asset archived?
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "data_type", 'uri_file')
        pulumi.set(__self__, "data_uri", data_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_anonymous is None:
            is_anonymous = False
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> str:
        """
        Enum to determine the type of data.
        Expected value is 'uri_file'.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="dataUri")
    def data_uri(self) -> str:
        """
        [Required] Uri of the data. Usage/meaning depends on Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20221001.Assets.DataVersionBase.DataType
        """
        return pulumi.get(self, "data_uri")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[bool]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[bool]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class UriFileJobInputResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobInputType":
            suggest = "job_input_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UriFileJobInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UriFileJobInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UriFileJobInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_input_type: str,
                 uri: str,
                 description: Optional[str] = None,
                 mode: Optional[str] = None):
        """
        :param str job_input_type: Enum to determine the Job Input Type.
               Expected value is 'uri_file'.
        :param str uri: [Required] Input Asset URI.
        :param str description: Description for the input.
        :param str mode: Input Asset Delivery Mode.
        """
        pulumi.set(__self__, "job_input_type", 'uri_file')
        pulumi.set(__self__, "uri", uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadOnlyMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="jobInputType")
    def job_input_type(self) -> str:
        """
        Enum to determine the Job Input Type.
        Expected value is 'uri_file'.
        """
        return pulumi.get(self, "job_input_type")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        [Required] Input Asset URI.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description for the input.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Input Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class UriFileJobOutputResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobOutputType":
            suggest = "job_output_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UriFileJobOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UriFileJobOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UriFileJobOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_output_type: str,
                 description: Optional[str] = None,
                 mode: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param str job_output_type: Enum to determine the Job Output Type.
               Expected value is 'uri_file'.
        :param str description: Description for the output.
        :param str mode: Output Asset Delivery Mode.
        :param str uri: Output Asset URI.
        """
        pulumi.set(__self__, "job_output_type", 'uri_file')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadWriteMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="jobOutputType")
    def job_output_type(self) -> str:
        """
        Enum to determine the Job Output Type.
        Expected value is 'uri_file'.
        """
        return pulumi.get(self, "job_output_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description for the output.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Output Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Output Asset URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class UriFolderDataVersionResponse(dict):
    """
    uri-folder data version entity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "dataUri":
            suggest = "data_uri"
        elif key == "isAnonymous":
            suggest = "is_anonymous"
        elif key == "isArchived":
            suggest = "is_archived"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UriFolderDataVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UriFolderDataVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UriFolderDataVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_type: str,
                 data_uri: str,
                 description: Optional[str] = None,
                 is_anonymous: Optional[bool] = None,
                 is_archived: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        uri-folder data version entity
        :param str data_type: Enum to determine the type of data.
               Expected value is 'uri_folder'.
        :param str data_uri: [Required] Uri of the data. Usage/meaning depends on Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20221001.Assets.DataVersionBase.DataType
        :param str description: The asset description text.
        :param bool is_anonymous: If the name version are system generated (anonymous registration).
        :param bool is_archived: Is the asset archived?
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "data_type", 'uri_folder')
        pulumi.set(__self__, "data_uri", data_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_anonymous is None:
            is_anonymous = False
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> str:
        """
        Enum to determine the type of data.
        Expected value is 'uri_folder'.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="dataUri")
    def data_uri(self) -> str:
        """
        [Required] Uri of the data. Usage/meaning depends on Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20221001.Assets.DataVersionBase.DataType
        """
        return pulumi.get(self, "data_uri")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[bool]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[bool]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class UriFolderJobInputResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobInputType":
            suggest = "job_input_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UriFolderJobInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UriFolderJobInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UriFolderJobInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_input_type: str,
                 uri: str,
                 description: Optional[str] = None,
                 mode: Optional[str] = None):
        """
        :param str job_input_type: Enum to determine the Job Input Type.
               Expected value is 'uri_folder'.
        :param str uri: [Required] Input Asset URI.
        :param str description: Description for the input.
        :param str mode: Input Asset Delivery Mode.
        """
        pulumi.set(__self__, "job_input_type", 'uri_folder')
        pulumi.set(__self__, "uri", uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadOnlyMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="jobInputType")
    def job_input_type(self) -> str:
        """
        Enum to determine the Job Input Type.
        Expected value is 'uri_folder'.
        """
        return pulumi.get(self, "job_input_type")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        [Required] Input Asset URI.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description for the input.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Input Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class UriFolderJobOutputResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobOutputType":
            suggest = "job_output_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UriFolderJobOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UriFolderJobOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UriFolderJobOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_output_type: str,
                 description: Optional[str] = None,
                 mode: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param str job_output_type: Enum to determine the Job Output Type.
               Expected value is 'uri_folder'.
        :param str description: Description for the output.
        :param str mode: Output Asset Delivery Mode.
        :param str uri: Output Asset URI.
        """
        pulumi.set(__self__, "job_output_type", 'uri_folder')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadWriteMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="jobOutputType")
    def job_output_type(self) -> str:
        """
        Enum to determine the Job Output Type.
        Expected value is 'uri_folder'.
        """
        return pulumi.get(self, "job_output_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description for the output.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Output Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Output Asset URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class UserAccountCredentialsResponse(dict):
    """
    Settings for user account that gets created on each on the nodes of a compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminUserName":
            suggest = "admin_user_name"
        elif key == "adminUserPassword":
            suggest = "admin_user_password"
        elif key == "adminUserSshPublicKey":
            suggest = "admin_user_ssh_public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAccountCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAccountCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAccountCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_user_name: str,
                 admin_user_password: Optional[str] = None,
                 admin_user_ssh_public_key: Optional[str] = None):
        """
        Settings for user account that gets created on each on the nodes of a compute.
        :param str admin_user_name: Name of the administrator user account which can be used to SSH to nodes.
        :param str admin_user_password: Password of the administrator user account.
        :param str admin_user_ssh_public_key: SSH public key of the administrator user account.
        """
        pulumi.set(__self__, "admin_user_name", admin_user_name)
        if admin_user_password is not None:
            pulumi.set(__self__, "admin_user_password", admin_user_password)
        if admin_user_ssh_public_key is not None:
            pulumi.set(__self__, "admin_user_ssh_public_key", admin_user_ssh_public_key)

    @property
    @pulumi.getter(name="adminUserName")
    def admin_user_name(self) -> str:
        """
        Name of the administrator user account which can be used to SSH to nodes.
        """
        return pulumi.get(self, "admin_user_name")

    @property
    @pulumi.getter(name="adminUserPassword")
    def admin_user_password(self) -> Optional[str]:
        """
        Password of the administrator user account.
        """
        return pulumi.get(self, "admin_user_password")

    @property
    @pulumi.getter(name="adminUserSshPublicKey")
    def admin_user_ssh_public_key(self) -> Optional[str]:
        """
        SSH public key of the administrator user account.
        """
        return pulumi.get(self, "admin_user_ssh_public_key")


@pulumi.output_type
class UserAssignedIdentityResponse(dict):
    """
    User assigned identity properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        User assigned identity properties
        :param str client_id: The client ID of the assigned identity.
        :param str principal_id: The principal ID of the assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID of the assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of the assigned identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class UserIdentityResponse(dict):
    """
    User identity configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityType":
            suggest = "identity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_type: str):
        """
        User identity configuration.
        :param str identity_type: Enum to determine identity framework.
               Expected value is 'UserIdentity'.
        """
        pulumi.set(__self__, "identity_type", 'UserIdentity')

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> str:
        """
        Enum to determine identity framework.
        Expected value is 'UserIdentity'.
        """
        return pulumi.get(self, "identity_type")


@pulumi.output_type
class UsernamePasswordAuthTypeWorkspaceConnectionPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "valueFormat":
            suggest = "value_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UsernamePasswordAuthTypeWorkspaceConnectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UsernamePasswordAuthTypeWorkspaceConnectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UsernamePasswordAuthTypeWorkspaceConnectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: str,
                 category: Optional[str] = None,
                 credentials: Optional['outputs.WorkspaceConnectionUsernamePasswordResponse'] = None,
                 target: Optional[str] = None,
                 value: Optional[str] = None,
                 value_format: Optional[str] = None):
        """
        :param str auth_type: Authentication type of the connection target
               Expected value is 'UsernamePassword'.
        :param str category: Category of the connection
        :param str value: Value details of the workspace connection.
        :param str value_format: format for the workspace connection value
        """
        pulumi.set(__self__, "auth_type", 'UsernamePassword')
        if category is not None:
            pulumi.set(__self__, "category", category)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_format is not None:
            pulumi.set(__self__, "value_format", value_format)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> str:
        """
        Authentication type of the connection target
        Expected value is 'UsernamePassword'.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        Category of the connection
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.WorkspaceConnectionUsernamePasswordResponse']:
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value details of the workspace connection.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueFormat")
    def value_format(self) -> Optional[str]:
        """
        format for the workspace connection value
        """
        return pulumi.get(self, "value_format")


@pulumi.output_type
class VirtualMachineImageResponse(dict):
    """
    Virtual Machine image for Windows AML Compute
    """
    def __init__(__self__, *,
                 id: str):
        """
        Virtual Machine image for Windows AML Compute
        :param str id: Virtual Machine image path
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Virtual Machine image path
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class VirtualMachineResponse(dict):
    """
    A Machine Learning compute based on Azure Virtual Machines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 properties: Optional['outputs.VirtualMachineSchemaResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A Machine Learning compute based on Azure Virtual Machines.
        :param str compute_type: The type of compute
               Expected value is 'VirtualMachine'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'VirtualMachine')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'VirtualMachine'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.VirtualMachineSchemaResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class VirtualMachineSchemaResponseProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "administratorAccount":
            suggest = "administrator_account"
        elif key == "isNotebookInstanceCompute":
            suggest = "is_notebook_instance_compute"
        elif key == "notebookServerPort":
            suggest = "notebook_server_port"
        elif key == "sshPort":
            suggest = "ssh_port"
        elif key == "virtualMachineSize":
            suggest = "virtual_machine_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineSchemaResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineSchemaResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineSchemaResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 administrator_account: Optional['outputs.VirtualMachineSshCredentialsResponse'] = None,
                 is_notebook_instance_compute: Optional[bool] = None,
                 notebook_server_port: Optional[int] = None,
                 ssh_port: Optional[int] = None,
                 virtual_machine_size: Optional[str] = None):
        """
        :param str address: Public IP address of the virtual machine.
        :param 'VirtualMachineSshCredentialsResponse' administrator_account: Admin credentials for virtual machine
        :param bool is_notebook_instance_compute: Indicates whether this compute will be used for running notebooks.
        :param int notebook_server_port: Notebook server port open for ssh connections.
        :param int ssh_port: Port open for ssh connections.
        :param str virtual_machine_size: Virtual Machine size
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if administrator_account is not None:
            pulumi.set(__self__, "administrator_account", administrator_account)
        if is_notebook_instance_compute is not None:
            pulumi.set(__self__, "is_notebook_instance_compute", is_notebook_instance_compute)
        if notebook_server_port is not None:
            pulumi.set(__self__, "notebook_server_port", notebook_server_port)
        if ssh_port is not None:
            pulumi.set(__self__, "ssh_port", ssh_port)
        if virtual_machine_size is not None:
            pulumi.set(__self__, "virtual_machine_size", virtual_machine_size)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Public IP address of the virtual machine.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="administratorAccount")
    def administrator_account(self) -> Optional['outputs.VirtualMachineSshCredentialsResponse']:
        """
        Admin credentials for virtual machine
        """
        return pulumi.get(self, "administrator_account")

    @property
    @pulumi.getter(name="isNotebookInstanceCompute")
    def is_notebook_instance_compute(self) -> Optional[bool]:
        """
        Indicates whether this compute will be used for running notebooks.
        """
        return pulumi.get(self, "is_notebook_instance_compute")

    @property
    @pulumi.getter(name="notebookServerPort")
    def notebook_server_port(self) -> Optional[int]:
        """
        Notebook server port open for ssh connections.
        """
        return pulumi.get(self, "notebook_server_port")

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> Optional[int]:
        """
        Port open for ssh connections.
        """
        return pulumi.get(self, "ssh_port")

    @property
    @pulumi.getter(name="virtualMachineSize")
    def virtual_machine_size(self) -> Optional[str]:
        """
        Virtual Machine size
        """
        return pulumi.get(self, "virtual_machine_size")


@pulumi.output_type
class VirtualMachineSshCredentialsResponse(dict):
    """
    Admin credentials for virtual machine
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKeyData":
            suggest = "private_key_data"
        elif key == "publicKeyData":
            suggest = "public_key_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineSshCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineSshCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineSshCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: Optional[str] = None,
                 private_key_data: Optional[str] = None,
                 public_key_data: Optional[str] = None,
                 username: Optional[str] = None):
        """
        Admin credentials for virtual machine
        :param str password: Password of admin account
        :param str private_key_data: Private key data
        :param str public_key_data: Public key data
        :param str username: Username of admin account
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key_data is not None:
            pulumi.set(__self__, "private_key_data", private_key_data)
        if public_key_data is not None:
            pulumi.set(__self__, "public_key_data", public_key_data)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password of admin account
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="privateKeyData")
    def private_key_data(self) -> Optional[str]:
        """
        Private key data
        """
        return pulumi.get(self, "private_key_data")

    @property
    @pulumi.getter(name="publicKeyData")
    def public_key_data(self) -> Optional[str]:
        """
        Public key data
        """
        return pulumi.get(self, "public_key_data")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username of admin account
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class WorkspaceConnectionManagedIdentityResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceConnectionManagedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceConnectionManagedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceConnectionManagedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[str] = None,
                 resource_id: Optional[str] = None):
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class WorkspaceConnectionPersonalAccessTokenResponse(dict):
    def __init__(__self__, *,
                 pat: Optional[str] = None):
        if pat is not None:
            pulumi.set(__self__, "pat", pat)

    @property
    @pulumi.getter
    def pat(self) -> Optional[str]:
        return pulumi.get(self, "pat")


@pulumi.output_type
class WorkspaceConnectionSharedAccessSignatureResponse(dict):
    def __init__(__self__, *,
                 sas: Optional[str] = None):
        if sas is not None:
            pulumi.set(__self__, "sas", sas)

    @property
    @pulumi.getter
    def sas(self) -> Optional[str]:
        return pulumi.get(self, "sas")


@pulumi.output_type
class WorkspaceConnectionUsernamePasswordResponse(dict):
    def __init__(__self__, *,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        return pulumi.get(self, "username")


