# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = ['SiteAuthSettingsArgs', 'SiteAuthSettings']

@pulumi.input_type
class SiteAuthSettingsArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 aad_client_id: Optional[pulumi.Input[str]] = None,
                 additional_login_params: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_external_redirect_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 default_provider: Optional[pulumi.Input['BuiltInAuthenticationProvider']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 facebook_app_id: Optional[pulumi.Input[str]] = None,
                 facebook_app_secret: Optional[pulumi.Input[str]] = None,
                 facebook_o_auth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 google_client_id: Optional[pulumi.Input[str]] = None,
                 google_client_secret: Optional[pulumi.Input[str]] = None,
                 google_o_auth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 http_api_prefix_path: Optional[pulumi.Input[str]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 microsoft_account_client_id: Optional[pulumi.Input[str]] = None,
                 microsoft_account_client_secret: Optional[pulumi.Input[str]] = None,
                 microsoft_account_o_auth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 open_id_issuer: Optional[pulumi.Input[str]] = None,
                 token_refresh_extension_hours: Optional[pulumi.Input[float]] = None,
                 token_store_enabled: Optional[pulumi.Input[bool]] = None,
                 twitter_consumer_key: Optional[pulumi.Input[str]] = None,
                 twitter_consumer_secret: Optional[pulumi.Input[str]] = None,
                 unauthenticated_client_action: Optional[pulumi.Input['UnauthenticatedClientAction']] = None):
        """
        The set of arguments for constructing a SiteAuthSettings resource.
        :param pulumi.Input[str] name: Name of web app
        :param pulumi.Input[str] resource_group_name: Name of resource group
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_login_params: Gets or sets a list of login parameters to send to the OpenID Connect authorization endpoint when
                           a user logs in. Each parameter must be in the form "key=value".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_audiences: Gets or sets a list of allowed audience values to consider when validating JWTs issued by 
                           Azure Active Directory. Note that the {Microsoft.Web.Hosting.Administration.SiteAuthSettings.ClientId} value is always considered an
                           allowed audience, regardless of this setting.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_external_redirect_urls: Gets or sets a collection of external URLs that can be redirected to as part of logging in
                           or logging out of the web app. Note that the query string part of the URL is ignored.
                           This is an advanced setting typically only needed by Windows Store application backends.
                           Note that URLs within the current domain are always implicitly allowed.
        :param pulumi.Input[str] client_id: Gets or sets the Client ID of this relying party application, known as the client_id.
                           This setting is required for enabling OpenID Connection authentication with Azure Active Directory or 
                           other 3rd party OpenID Connect providers.
                           More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
        :param pulumi.Input[str] client_secret: Gets or sets the Client Secret of this relying party application (in Azure Active Directory, this is also referred to as the Key).
                           This setting is optional. If no client secret is configured, the OpenID Connect implicit auth flow is used to authenticate end users.
                           Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
                           More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
        :param pulumi.Input['BuiltInAuthenticationProvider'] default_provider: Gets or sets the default authentication provider to use when multiple providers are configured.
                           This setting is only needed if multiple providers are configured and the unauthenticated client
                           action is set to "RedirectToLoginPage".
        :param pulumi.Input[bool] enabled: Gets or sets a value indicating whether the Authentication / Authorization feature is enabled for the current app.
        :param pulumi.Input[str] facebook_app_id: Gets or sets the App ID of the Facebook app used for login.
                           This setting is required for enabling Facebook Login.
                           Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
        :param pulumi.Input[str] facebook_app_secret: Gets or sets the App Secret of the Facebook app used for Facebook Login.
                           This setting is required for enabling Facebook Login.
                           Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
        :param pulumi.Input[Sequence[pulumi.Input[str]]] facebook_o_auth_scopes: Gets or sets the OAuth 2.0 scopes that will be requested as part of Facebook Login authentication.
                           This setting is optional.
                           Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
        :param pulumi.Input[str] google_client_id: Gets or sets the OpenID Connect Client ID for the Google web application.
                           This setting is required for enabling Google Sign-In.
                           Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
        :param pulumi.Input[str] google_client_secret: Gets or sets the client secret associated with the Google web application.
                           This setting is required for enabling Google Sign-In.
                           Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
        :param pulumi.Input[Sequence[pulumi.Input[str]]] google_o_auth_scopes: Gets or sets the OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication.
                           This setting is optional. If not specified, "openid", "profile", and "email" are used as default scopes.
                           Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
        :param pulumi.Input[str] http_api_prefix_path: Gets or sets the relative path prefix used by platform HTTP APIs.
                           Changing this value is not recommended except for compatibility reasons.
        :param pulumi.Input[str] issuer: Gets or sets the OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
                           When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://sts.windows.net/{tenant-guid}/.
                           This URI is a case-sensitive identifier for the token issuer.
                           More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
        :param pulumi.Input[str] microsoft_account_client_id: Gets or sets the OAuth 2.0 client ID that was created for the app used for authentication.
                           This setting is required for enabling Microsoft Account authentication.
                           Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
        :param pulumi.Input[str] microsoft_account_client_secret: Gets or sets the OAuth 2.0 client secret that was created for the app used for authentication.
                           This setting is required for enabling Microsoft Account authentication.
                           Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
        :param pulumi.Input[Sequence[pulumi.Input[str]]] microsoft_account_o_auth_scopes: Gets or sets the OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication.
                           This setting is optional. If not specified, "wl.basic" is used as the default scope.
                           Microsoft Account Scopes and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx
        :param pulumi.Input[float] token_refresh_extension_hours: Gets or sets the number of hours after session token expiration that a session token can be used to
                           call the token refresh API. The default is 72 hours.
        :param pulumi.Input[bool] token_store_enabled: Gets or sets a value indicating whether to durably store platform-specific security tokens
                           obtained during login flows. This capability is disabled by default.
        :param pulumi.Input[str] twitter_consumer_key: Gets or sets the OAuth 1.0a consumer key of the Twitter application used for sign-in.
                           This setting is required for enabling Twitter Sign-In.
                           Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
        :param pulumi.Input[str] twitter_consumer_secret: Gets or sets the OAuth 1.0a consumer secret of the Twitter application used for sign-in.
                           This setting is required for enabling Twitter Sign-In.
                           Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
        :param pulumi.Input['UnauthenticatedClientAction'] unauthenticated_client_action: Gets or sets the action to take when an unauthenticated client attempts to access the app.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if aad_client_id is not None:
            pulumi.set(__self__, "aad_client_id", aad_client_id)
        if additional_login_params is not None:
            pulumi.set(__self__, "additional_login_params", additional_login_params)
        if allowed_audiences is not None:
            pulumi.set(__self__, "allowed_audiences", allowed_audiences)
        if allowed_external_redirect_urls is not None:
            pulumi.set(__self__, "allowed_external_redirect_urls", allowed_external_redirect_urls)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if default_provider is not None:
            pulumi.set(__self__, "default_provider", default_provider)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if facebook_app_id is not None:
            pulumi.set(__self__, "facebook_app_id", facebook_app_id)
        if facebook_app_secret is not None:
            pulumi.set(__self__, "facebook_app_secret", facebook_app_secret)
        if facebook_o_auth_scopes is not None:
            pulumi.set(__self__, "facebook_o_auth_scopes", facebook_o_auth_scopes)
        if google_client_id is not None:
            pulumi.set(__self__, "google_client_id", google_client_id)
        if google_client_secret is not None:
            pulumi.set(__self__, "google_client_secret", google_client_secret)
        if google_o_auth_scopes is not None:
            pulumi.set(__self__, "google_o_auth_scopes", google_o_auth_scopes)
        if http_api_prefix_path is not None:
            pulumi.set(__self__, "http_api_prefix_path", http_api_prefix_path)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if microsoft_account_client_id is not None:
            pulumi.set(__self__, "microsoft_account_client_id", microsoft_account_client_id)
        if microsoft_account_client_secret is not None:
            pulumi.set(__self__, "microsoft_account_client_secret", microsoft_account_client_secret)
        if microsoft_account_o_auth_scopes is not None:
            pulumi.set(__self__, "microsoft_account_o_auth_scopes", microsoft_account_o_auth_scopes)
        if open_id_issuer is not None:
            pulumi.set(__self__, "open_id_issuer", open_id_issuer)
        if token_refresh_extension_hours is not None:
            pulumi.set(__self__, "token_refresh_extension_hours", token_refresh_extension_hours)
        if token_store_enabled is not None:
            pulumi.set(__self__, "token_store_enabled", token_store_enabled)
        if twitter_consumer_key is not None:
            pulumi.set(__self__, "twitter_consumer_key", twitter_consumer_key)
        if twitter_consumer_secret is not None:
            pulumi.set(__self__, "twitter_consumer_secret", twitter_consumer_secret)
        if unauthenticated_client_action is not None:
            pulumi.set(__self__, "unauthenticated_client_action", unauthenticated_client_action)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of web app
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        Name of resource group
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="aadClientId")
    def aad_client_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "aad_client_id")

    @aad_client_id.setter
    def aad_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aad_client_id", value)

    @property
    @pulumi.getter(name="additionalLoginParams")
    def additional_login_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets a list of login parameters to send to the OpenID Connect authorization endpoint when
                    a user logs in. Each parameter must be in the form "key=value".
        """
        return pulumi.get(self, "additional_login_params")

    @additional_login_params.setter
    def additional_login_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "additional_login_params", value)

    @property
    @pulumi.getter(name="allowedAudiences")
    def allowed_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets a list of allowed audience values to consider when validating JWTs issued by 
                    Azure Active Directory. Note that the {Microsoft.Web.Hosting.Administration.SiteAuthSettings.ClientId} value is always considered an
                    allowed audience, regardless of this setting.
        """
        return pulumi.get(self, "allowed_audiences")

    @allowed_audiences.setter
    def allowed_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_audiences", value)

    @property
    @pulumi.getter(name="allowedExternalRedirectUrls")
    def allowed_external_redirect_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets a collection of external URLs that can be redirected to as part of logging in
                    or logging out of the web app. Note that the query string part of the URL is ignored.
                    This is an advanced setting typically only needed by Windows Store application backends.
                    Note that URLs within the current domain are always implicitly allowed.
        """
        return pulumi.get(self, "allowed_external_redirect_urls")

    @allowed_external_redirect_urls.setter
    def allowed_external_redirect_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_external_redirect_urls", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Client ID of this relying party application, known as the client_id.
                    This setting is required for enabling OpenID Connection authentication with Azure Active Directory or 
                    other 3rd party OpenID Connect providers.
                    More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Client Secret of this relying party application (in Azure Active Directory, this is also referred to as the Key).
                    This setting is optional. If no client secret is configured, the OpenID Connect implicit auth flow is used to authenticate end users.
                    Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
                    More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="defaultProvider")
    def default_provider(self) -> Optional[pulumi.Input['BuiltInAuthenticationProvider']]:
        """
        Gets or sets the default authentication provider to use when multiple providers are configured.
                    This setting is only needed if multiple providers are configured and the unauthenticated client
                    action is set to "RedirectToLoginPage".
        """
        return pulumi.get(self, "default_provider")

    @default_provider.setter
    def default_provider(self, value: Optional[pulumi.Input['BuiltInAuthenticationProvider']]):
        pulumi.set(self, "default_provider", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets a value indicating whether the Authentication / Authorization feature is enabled for the current app.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="facebookAppId")
    def facebook_app_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the App ID of the Facebook app used for login.
                    This setting is required for enabling Facebook Login.
                    Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
        """
        return pulumi.get(self, "facebook_app_id")

    @facebook_app_id.setter
    def facebook_app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "facebook_app_id", value)

    @property
    @pulumi.getter(name="facebookAppSecret")
    def facebook_app_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the App Secret of the Facebook app used for Facebook Login.
                    This setting is required for enabling Facebook Login.
                    Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
        """
        return pulumi.get(self, "facebook_app_secret")

    @facebook_app_secret.setter
    def facebook_app_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "facebook_app_secret", value)

    @property
    @pulumi.getter(name="facebookOAuthScopes")
    def facebook_o_auth_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets the OAuth 2.0 scopes that will be requested as part of Facebook Login authentication.
                    This setting is optional.
                    Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
        """
        return pulumi.get(self, "facebook_o_auth_scopes")

    @facebook_o_auth_scopes.setter
    def facebook_o_auth_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "facebook_o_auth_scopes", value)

    @property
    @pulumi.getter(name="googleClientId")
    def google_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the OpenID Connect Client ID for the Google web application.
                    This setting is required for enabling Google Sign-In.
                    Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
        """
        return pulumi.get(self, "google_client_id")

    @google_client_id.setter
    def google_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "google_client_id", value)

    @property
    @pulumi.getter(name="googleClientSecret")
    def google_client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the client secret associated with the Google web application.
                    This setting is required for enabling Google Sign-In.
                    Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
        """
        return pulumi.get(self, "google_client_secret")

    @google_client_secret.setter
    def google_client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "google_client_secret", value)

    @property
    @pulumi.getter(name="googleOAuthScopes")
    def google_o_auth_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets the OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication.
                    This setting is optional. If not specified, "openid", "profile", and "email" are used as default scopes.
                    Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
        """
        return pulumi.get(self, "google_o_auth_scopes")

    @google_o_auth_scopes.setter
    def google_o_auth_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "google_o_auth_scopes", value)

    @property
    @pulumi.getter(name="httpApiPrefixPath")
    def http_api_prefix_path(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the relative path prefix used by platform HTTP APIs.
                    Changing this value is not recommended except for compatibility reasons.
        """
        return pulumi.get(self, "http_api_prefix_path")

    @http_api_prefix_path.setter
    def http_api_prefix_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_api_prefix_path", value)

    @property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
                    When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://sts.windows.net/{tenant-guid}/.
                    This URI is a case-sensitive identifier for the token issuer.
                    More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="microsoftAccountClientId")
    def microsoft_account_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the OAuth 2.0 client ID that was created for the app used for authentication.
                    This setting is required for enabling Microsoft Account authentication.
                    Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
        """
        return pulumi.get(self, "microsoft_account_client_id")

    @microsoft_account_client_id.setter
    def microsoft_account_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "microsoft_account_client_id", value)

    @property
    @pulumi.getter(name="microsoftAccountClientSecret")
    def microsoft_account_client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the OAuth 2.0 client secret that was created for the app used for authentication.
                    This setting is required for enabling Microsoft Account authentication.
                    Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
        """
        return pulumi.get(self, "microsoft_account_client_secret")

    @microsoft_account_client_secret.setter
    def microsoft_account_client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "microsoft_account_client_secret", value)

    @property
    @pulumi.getter(name="microsoftAccountOAuthScopes")
    def microsoft_account_o_auth_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets the OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication.
                    This setting is optional. If not specified, "wl.basic" is used as the default scope.
                    Microsoft Account Scopes and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx
        """
        return pulumi.get(self, "microsoft_account_o_auth_scopes")

    @microsoft_account_o_auth_scopes.setter
    def microsoft_account_o_auth_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "microsoft_account_o_auth_scopes", value)

    @property
    @pulumi.getter(name="openIdIssuer")
    def open_id_issuer(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "open_id_issuer")

    @open_id_issuer.setter
    def open_id_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "open_id_issuer", value)

    @property
    @pulumi.getter(name="tokenRefreshExtensionHours")
    def token_refresh_extension_hours(self) -> Optional[pulumi.Input[float]]:
        """
        Gets or sets the number of hours after session token expiration that a session token can be used to
                    call the token refresh API. The default is 72 hours.
        """
        return pulumi.get(self, "token_refresh_extension_hours")

    @token_refresh_extension_hours.setter
    def token_refresh_extension_hours(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "token_refresh_extension_hours", value)

    @property
    @pulumi.getter(name="tokenStoreEnabled")
    def token_store_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets a value indicating whether to durably store platform-specific security tokens
                    obtained during login flows. This capability is disabled by default.
        """
        return pulumi.get(self, "token_store_enabled")

    @token_store_enabled.setter
    def token_store_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "token_store_enabled", value)

    @property
    @pulumi.getter(name="twitterConsumerKey")
    def twitter_consumer_key(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the OAuth 1.0a consumer key of the Twitter application used for sign-in.
                    This setting is required for enabling Twitter Sign-In.
                    Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
        """
        return pulumi.get(self, "twitter_consumer_key")

    @twitter_consumer_key.setter
    def twitter_consumer_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "twitter_consumer_key", value)

    @property
    @pulumi.getter(name="twitterConsumerSecret")
    def twitter_consumer_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the OAuth 1.0a consumer secret of the Twitter application used for sign-in.
                    This setting is required for enabling Twitter Sign-In.
                    Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
        """
        return pulumi.get(self, "twitter_consumer_secret")

    @twitter_consumer_secret.setter
    def twitter_consumer_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "twitter_consumer_secret", value)

    @property
    @pulumi.getter(name="unauthenticatedClientAction")
    def unauthenticated_client_action(self) -> Optional[pulumi.Input['UnauthenticatedClientAction']]:
        """
        Gets or sets the action to take when an unauthenticated client attempts to access the app.
        """
        return pulumi.get(self, "unauthenticated_client_action")

    @unauthenticated_client_action.setter
    def unauthenticated_client_action(self, value: Optional[pulumi.Input['UnauthenticatedClientAction']]):
        pulumi.set(self, "unauthenticated_client_action", value)


warnings.warn("""Version 2015-08-01 will be removed in v2 of the provider.""", DeprecationWarning)


class SiteAuthSettings(pulumi.CustomResource):
    warnings.warn("""Version 2015-08-01 will be removed in v2 of the provider.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aad_client_id: Optional[pulumi.Input[str]] = None,
                 additional_login_params: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_external_redirect_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 default_provider: Optional[pulumi.Input['BuiltInAuthenticationProvider']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 facebook_app_id: Optional[pulumi.Input[str]] = None,
                 facebook_app_secret: Optional[pulumi.Input[str]] = None,
                 facebook_o_auth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 google_client_id: Optional[pulumi.Input[str]] = None,
                 google_client_secret: Optional[pulumi.Input[str]] = None,
                 google_o_auth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 http_api_prefix_path: Optional[pulumi.Input[str]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 microsoft_account_client_id: Optional[pulumi.Input[str]] = None,
                 microsoft_account_client_secret: Optional[pulumi.Input[str]] = None,
                 microsoft_account_o_auth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 open_id_issuer: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 token_refresh_extension_hours: Optional[pulumi.Input[float]] = None,
                 token_store_enabled: Optional[pulumi.Input[bool]] = None,
                 twitter_consumer_key: Optional[pulumi.Input[str]] = None,
                 twitter_consumer_secret: Optional[pulumi.Input[str]] = None,
                 unauthenticated_client_action: Optional[pulumi.Input['UnauthenticatedClientAction']] = None,
                 __props__=None):
        """
        Configuration settings for the Azure App Service Authentication / Authorization feature.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_login_params: Gets or sets a list of login parameters to send to the OpenID Connect authorization endpoint when
                           a user logs in. Each parameter must be in the form "key=value".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_audiences: Gets or sets a list of allowed audience values to consider when validating JWTs issued by 
                           Azure Active Directory. Note that the {Microsoft.Web.Hosting.Administration.SiteAuthSettings.ClientId} value is always considered an
                           allowed audience, regardless of this setting.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_external_redirect_urls: Gets or sets a collection of external URLs that can be redirected to as part of logging in
                           or logging out of the web app. Note that the query string part of the URL is ignored.
                           This is an advanced setting typically only needed by Windows Store application backends.
                           Note that URLs within the current domain are always implicitly allowed.
        :param pulumi.Input[str] client_id: Gets or sets the Client ID of this relying party application, known as the client_id.
                           This setting is required for enabling OpenID Connection authentication with Azure Active Directory or 
                           other 3rd party OpenID Connect providers.
                           More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
        :param pulumi.Input[str] client_secret: Gets or sets the Client Secret of this relying party application (in Azure Active Directory, this is also referred to as the Key).
                           This setting is optional. If no client secret is configured, the OpenID Connect implicit auth flow is used to authenticate end users.
                           Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
                           More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
        :param pulumi.Input['BuiltInAuthenticationProvider'] default_provider: Gets or sets the default authentication provider to use when multiple providers are configured.
                           This setting is only needed if multiple providers are configured and the unauthenticated client
                           action is set to "RedirectToLoginPage".
        :param pulumi.Input[bool] enabled: Gets or sets a value indicating whether the Authentication / Authorization feature is enabled for the current app.
        :param pulumi.Input[str] facebook_app_id: Gets or sets the App ID of the Facebook app used for login.
                           This setting is required for enabling Facebook Login.
                           Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
        :param pulumi.Input[str] facebook_app_secret: Gets or sets the App Secret of the Facebook app used for Facebook Login.
                           This setting is required for enabling Facebook Login.
                           Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
        :param pulumi.Input[Sequence[pulumi.Input[str]]] facebook_o_auth_scopes: Gets or sets the OAuth 2.0 scopes that will be requested as part of Facebook Login authentication.
                           This setting is optional.
                           Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
        :param pulumi.Input[str] google_client_id: Gets or sets the OpenID Connect Client ID for the Google web application.
                           This setting is required for enabling Google Sign-In.
                           Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
        :param pulumi.Input[str] google_client_secret: Gets or sets the client secret associated with the Google web application.
                           This setting is required for enabling Google Sign-In.
                           Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
        :param pulumi.Input[Sequence[pulumi.Input[str]]] google_o_auth_scopes: Gets or sets the OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication.
                           This setting is optional. If not specified, "openid", "profile", and "email" are used as default scopes.
                           Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
        :param pulumi.Input[str] http_api_prefix_path: Gets or sets the relative path prefix used by platform HTTP APIs.
                           Changing this value is not recommended except for compatibility reasons.
        :param pulumi.Input[str] issuer: Gets or sets the OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
                           When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://sts.windows.net/{tenant-guid}/.
                           This URI is a case-sensitive identifier for the token issuer.
                           More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
        :param pulumi.Input[str] microsoft_account_client_id: Gets or sets the OAuth 2.0 client ID that was created for the app used for authentication.
                           This setting is required for enabling Microsoft Account authentication.
                           Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
        :param pulumi.Input[str] microsoft_account_client_secret: Gets or sets the OAuth 2.0 client secret that was created for the app used for authentication.
                           This setting is required for enabling Microsoft Account authentication.
                           Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
        :param pulumi.Input[Sequence[pulumi.Input[str]]] microsoft_account_o_auth_scopes: Gets or sets the OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication.
                           This setting is optional. If not specified, "wl.basic" is used as the default scope.
                           Microsoft Account Scopes and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx
        :param pulumi.Input[str] name: Name of web app
        :param pulumi.Input[str] resource_group_name: Name of resource group
        :param pulumi.Input[float] token_refresh_extension_hours: Gets or sets the number of hours after session token expiration that a session token can be used to
                           call the token refresh API. The default is 72 hours.
        :param pulumi.Input[bool] token_store_enabled: Gets or sets a value indicating whether to durably store platform-specific security tokens
                           obtained during login flows. This capability is disabled by default.
        :param pulumi.Input[str] twitter_consumer_key: Gets or sets the OAuth 1.0a consumer key of the Twitter application used for sign-in.
                           This setting is required for enabling Twitter Sign-In.
                           Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
        :param pulumi.Input[str] twitter_consumer_secret: Gets or sets the OAuth 1.0a consumer secret of the Twitter application used for sign-in.
                           This setting is required for enabling Twitter Sign-In.
                           Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
        :param pulumi.Input['UnauthenticatedClientAction'] unauthenticated_client_action: Gets or sets the action to take when an unauthenticated client attempts to access the app.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SiteAuthSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Configuration settings for the Azure App Service Authentication / Authorization feature.

        :param str resource_name: The name of the resource.
        :param SiteAuthSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SiteAuthSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aad_client_id: Optional[pulumi.Input[str]] = None,
                 additional_login_params: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_external_redirect_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 default_provider: Optional[pulumi.Input['BuiltInAuthenticationProvider']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 facebook_app_id: Optional[pulumi.Input[str]] = None,
                 facebook_app_secret: Optional[pulumi.Input[str]] = None,
                 facebook_o_auth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 google_client_id: Optional[pulumi.Input[str]] = None,
                 google_client_secret: Optional[pulumi.Input[str]] = None,
                 google_o_auth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 http_api_prefix_path: Optional[pulumi.Input[str]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 microsoft_account_client_id: Optional[pulumi.Input[str]] = None,
                 microsoft_account_client_secret: Optional[pulumi.Input[str]] = None,
                 microsoft_account_o_auth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 open_id_issuer: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 token_refresh_extension_hours: Optional[pulumi.Input[float]] = None,
                 token_store_enabled: Optional[pulumi.Input[bool]] = None,
                 twitter_consumer_key: Optional[pulumi.Input[str]] = None,
                 twitter_consumer_secret: Optional[pulumi.Input[str]] = None,
                 unauthenticated_client_action: Optional[pulumi.Input['UnauthenticatedClientAction']] = None,
                 __props__=None):
        pulumi.log.warn("""SiteAuthSettings is deprecated: Version 2015-08-01 will be removed in v2 of the provider.""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SiteAuthSettingsArgs.__new__(SiteAuthSettingsArgs)

            __props__.__dict__["aad_client_id"] = aad_client_id
            __props__.__dict__["additional_login_params"] = additional_login_params
            __props__.__dict__["allowed_audiences"] = allowed_audiences
            __props__.__dict__["allowed_external_redirect_urls"] = allowed_external_redirect_urls
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_secret"] = client_secret
            __props__.__dict__["default_provider"] = default_provider
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["facebook_app_id"] = facebook_app_id
            __props__.__dict__["facebook_app_secret"] = facebook_app_secret
            __props__.__dict__["facebook_o_auth_scopes"] = facebook_o_auth_scopes
            __props__.__dict__["google_client_id"] = google_client_id
            __props__.__dict__["google_client_secret"] = google_client_secret
            __props__.__dict__["google_o_auth_scopes"] = google_o_auth_scopes
            __props__.__dict__["http_api_prefix_path"] = http_api_prefix_path
            __props__.__dict__["issuer"] = issuer
            __props__.__dict__["microsoft_account_client_id"] = microsoft_account_client_id
            __props__.__dict__["microsoft_account_client_secret"] = microsoft_account_client_secret
            __props__.__dict__["microsoft_account_o_auth_scopes"] = microsoft_account_o_auth_scopes
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["open_id_issuer"] = open_id_issuer
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["token_refresh_extension_hours"] = token_refresh_extension_hours
            __props__.__dict__["token_store_enabled"] = token_store_enabled
            __props__.__dict__["twitter_consumer_key"] = twitter_consumer_key
            __props__.__dict__["twitter_consumer_secret"] = twitter_consumer_secret
            __props__.__dict__["unauthenticated_client_action"] = unauthenticated_client_action
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:web:SiteAuthSettings"), pulumi.Alias(type_="azure-native:web/v20160801:SiteAuthSettings"), pulumi.Alias(type_="azure-native:web/v20180201:SiteAuthSettings"), pulumi.Alias(type_="azure-native:web/v20181101:SiteAuthSettings"), pulumi.Alias(type_="azure-native:web/v20190801:SiteAuthSettings"), pulumi.Alias(type_="azure-native:web/v20200601:SiteAuthSettings"), pulumi.Alias(type_="azure-native:web/v20200901:SiteAuthSettings"), pulumi.Alias(type_="azure-native:web/v20201001:SiteAuthSettings"), pulumi.Alias(type_="azure-native:web/v20201201:SiteAuthSettings"), pulumi.Alias(type_="azure-native:web/v20210101:SiteAuthSettings"), pulumi.Alias(type_="azure-native:web/v20210115:SiteAuthSettings"), pulumi.Alias(type_="azure-native:web/v20210201:SiteAuthSettings"), pulumi.Alias(type_="azure-native:web/v20210301:SiteAuthSettings"), pulumi.Alias(type_="azure-native:web/v20220301:SiteAuthSettings")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(SiteAuthSettings, __self__).__init__(
            'azure-native:web/v20150801:SiteAuthSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SiteAuthSettings':
        """
        Get an existing SiteAuthSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SiteAuthSettingsArgs.__new__(SiteAuthSettingsArgs)

        __props__.__dict__["aad_client_id"] = None
        __props__.__dict__["additional_login_params"] = None
        __props__.__dict__["allowed_audiences"] = None
        __props__.__dict__["allowed_external_redirect_urls"] = None
        __props__.__dict__["client_id"] = None
        __props__.__dict__["client_secret"] = None
        __props__.__dict__["default_provider"] = None
        __props__.__dict__["enabled"] = None
        __props__.__dict__["facebook_app_id"] = None
        __props__.__dict__["facebook_app_secret"] = None
        __props__.__dict__["facebook_o_auth_scopes"] = None
        __props__.__dict__["google_client_id"] = None
        __props__.__dict__["google_client_secret"] = None
        __props__.__dict__["google_o_auth_scopes"] = None
        __props__.__dict__["http_api_prefix_path"] = None
        __props__.__dict__["issuer"] = None
        __props__.__dict__["microsoft_account_client_id"] = None
        __props__.__dict__["microsoft_account_client_secret"] = None
        __props__.__dict__["microsoft_account_o_auth_scopes"] = None
        __props__.__dict__["open_id_issuer"] = None
        __props__.__dict__["token_refresh_extension_hours"] = None
        __props__.__dict__["token_store_enabled"] = None
        __props__.__dict__["twitter_consumer_key"] = None
        __props__.__dict__["twitter_consumer_secret"] = None
        __props__.__dict__["unauthenticated_client_action"] = None
        return SiteAuthSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aadClientId")
    def aad_client_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "aad_client_id")

    @property
    @pulumi.getter(name="additionalLoginParams")
    def additional_login_params(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Gets or sets a list of login parameters to send to the OpenID Connect authorization endpoint when
                    a user logs in. Each parameter must be in the form "key=value".
        """
        return pulumi.get(self, "additional_login_params")

    @property
    @pulumi.getter(name="allowedAudiences")
    def allowed_audiences(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Gets or sets a list of allowed audience values to consider when validating JWTs issued by 
                    Azure Active Directory. Note that the {Microsoft.Web.Hosting.Administration.SiteAuthSettings.ClientId} value is always considered an
                    allowed audience, regardless of this setting.
        """
        return pulumi.get(self, "allowed_audiences")

    @property
    @pulumi.getter(name="allowedExternalRedirectUrls")
    def allowed_external_redirect_urls(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Gets or sets a collection of external URLs that can be redirected to as part of logging in
                    or logging out of the web app. Note that the query string part of the URL is ignored.
                    This is an advanced setting typically only needed by Windows Store application backends.
                    Note that URLs within the current domain are always implicitly allowed.
        """
        return pulumi.get(self, "allowed_external_redirect_urls")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the Client ID of this relying party application, known as the client_id.
                    This setting is required for enabling OpenID Connection authentication with Azure Active Directory or 
                    other 3rd party OpenID Connect providers.
                    More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the Client Secret of this relying party application (in Azure Active Directory, this is also referred to as the Key).
                    This setting is optional. If no client secret is configured, the OpenID Connect implicit auth flow is used to authenticate end users.
                    Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
                    More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="defaultProvider")
    def default_provider(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the default authentication provider to use when multiple providers are configured.
                    This setting is only needed if multiple providers are configured and the unauthenticated client
                    action is set to "RedirectToLoginPage".
        """
        return pulumi.get(self, "default_provider")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Gets or sets a value indicating whether the Authentication / Authorization feature is enabled for the current app.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="facebookAppId")
    def facebook_app_id(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the App ID of the Facebook app used for login.
                    This setting is required for enabling Facebook Login.
                    Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
        """
        return pulumi.get(self, "facebook_app_id")

    @property
    @pulumi.getter(name="facebookAppSecret")
    def facebook_app_secret(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the App Secret of the Facebook app used for Facebook Login.
                    This setting is required for enabling Facebook Login.
                    Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
        """
        return pulumi.get(self, "facebook_app_secret")

    @property
    @pulumi.getter(name="facebookOAuthScopes")
    def facebook_o_auth_scopes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Gets or sets the OAuth 2.0 scopes that will be requested as part of Facebook Login authentication.
                    This setting is optional.
                    Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
        """
        return pulumi.get(self, "facebook_o_auth_scopes")

    @property
    @pulumi.getter(name="googleClientId")
    def google_client_id(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the OpenID Connect Client ID for the Google web application.
                    This setting is required for enabling Google Sign-In.
                    Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
        """
        return pulumi.get(self, "google_client_id")

    @property
    @pulumi.getter(name="googleClientSecret")
    def google_client_secret(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the client secret associated with the Google web application.
                    This setting is required for enabling Google Sign-In.
                    Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
        """
        return pulumi.get(self, "google_client_secret")

    @property
    @pulumi.getter(name="googleOAuthScopes")
    def google_o_auth_scopes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Gets or sets the OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication.
                    This setting is optional. If not specified, "openid", "profile", and "email" are used as default scopes.
                    Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
        """
        return pulumi.get(self, "google_o_auth_scopes")

    @property
    @pulumi.getter(name="httpApiPrefixPath")
    def http_api_prefix_path(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the relative path prefix used by platform HTTP APIs.
                    Changing this value is not recommended except for compatibility reasons.
        """
        return pulumi.get(self, "http_api_prefix_path")

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
                    When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://sts.windows.net/{tenant-guid}/.
                    This URI is a case-sensitive identifier for the token issuer.
                    More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="microsoftAccountClientId")
    def microsoft_account_client_id(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the OAuth 2.0 client ID that was created for the app used for authentication.
                    This setting is required for enabling Microsoft Account authentication.
                    Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
        """
        return pulumi.get(self, "microsoft_account_client_id")

    @property
    @pulumi.getter(name="microsoftAccountClientSecret")
    def microsoft_account_client_secret(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the OAuth 2.0 client secret that was created for the app used for authentication.
                    This setting is required for enabling Microsoft Account authentication.
                    Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
        """
        return pulumi.get(self, "microsoft_account_client_secret")

    @property
    @pulumi.getter(name="microsoftAccountOAuthScopes")
    def microsoft_account_o_auth_scopes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Gets or sets the OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication.
                    This setting is optional. If not specified, "wl.basic" is used as the default scope.
                    Microsoft Account Scopes and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx
        """
        return pulumi.get(self, "microsoft_account_o_auth_scopes")

    @property
    @pulumi.getter(name="openIdIssuer")
    def open_id_issuer(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "open_id_issuer")

    @property
    @pulumi.getter(name="tokenRefreshExtensionHours")
    def token_refresh_extension_hours(self) -> pulumi.Output[Optional[float]]:
        """
        Gets or sets the number of hours after session token expiration that a session token can be used to
                    call the token refresh API. The default is 72 hours.
        """
        return pulumi.get(self, "token_refresh_extension_hours")

    @property
    @pulumi.getter(name="tokenStoreEnabled")
    def token_store_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Gets or sets a value indicating whether to durably store platform-specific security tokens
                    obtained during login flows. This capability is disabled by default.
        """
        return pulumi.get(self, "token_store_enabled")

    @property
    @pulumi.getter(name="twitterConsumerKey")
    def twitter_consumer_key(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the OAuth 1.0a consumer key of the Twitter application used for sign-in.
                    This setting is required for enabling Twitter Sign-In.
                    Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
        """
        return pulumi.get(self, "twitter_consumer_key")

    @property
    @pulumi.getter(name="twitterConsumerSecret")
    def twitter_consumer_secret(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the OAuth 1.0a consumer secret of the Twitter application used for sign-in.
                    This setting is required for enabling Twitter Sign-In.
                    Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
        """
        return pulumi.get(self, "twitter_consumer_secret")

    @property
    @pulumi.getter(name="unauthenticatedClientAction")
    def unauthenticated_client_action(self) -> pulumi.Output[Optional[str]]:
        """
        Gets or sets the action to take when an unauthenticated client attempts to access the app.
        """
        return pulumi.get(self, "unauthenticated_client_action")

