# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AllowedAudiencesValidationResponse',
    'AllowedPrincipalsResponse',
    'AppLogsConfigurationResponse',
    'AppRegistrationResponse',
    'AppleRegistrationResponse',
    'AppleResponse',
    'AuthPlatformResponse',
    'AzureActiveDirectoryLoginResponse',
    'AzureActiveDirectoryRegistrationResponse',
    'AzureActiveDirectoryResponse',
    'AzureActiveDirectoryValidationResponse',
    'AzureCredentialsResponse',
    'AzureFilePropertiesResponse',
    'AzureStaticWebAppsRegistrationResponse',
    'AzureStaticWebAppsResponse',
    'CertificateResponseProperties',
    'ClientRegistrationResponse',
    'ConfigurationResponse',
    'ContainerAppProbeResponse',
    'ContainerAppProbeResponseHttpGet',
    'ContainerAppProbeResponseHttpHeaders',
    'ContainerAppProbeResponseTcpSocket',
    'ContainerAppSecretResponse',
    'ContainerResourcesResponse',
    'ContainerResponse',
    'CookieExpirationResponse',
    'CustomDomainResponse',
    'CustomHostnameAnalysisResultResponseCustomDomainVerificationFailureInfo',
    'CustomHostnameAnalysisResultResponseDetails',
    'CustomOpenIdConnectProviderResponse',
    'CustomScaleRuleResponse',
    'DaprMetadataResponse',
    'DaprResponse',
    'DaprSecretResponse',
    'DefaultAuthorizationPolicyResponse',
    'EnvironmentVarResponse',
    'FacebookResponse',
    'ForwardProxyResponse',
    'GitHubResponse',
    'GithubActionConfigurationResponse',
    'GlobalValidationResponse',
    'GoogleResponse',
    'HttpScaleRuleResponse',
    'HttpSettingsResponse',
    'HttpSettingsRoutesResponse',
    'IdentityProvidersResponse',
    'IngressResponse',
    'JwtClaimChecksResponse',
    'LogAnalyticsConfigurationResponse',
    'LoginResponse',
    'LoginRoutesResponse',
    'LoginScopesResponse',
    'ManagedEnvironmentStorageResponseProperties',
    'ManagedServiceIdentityResponse',
    'NonceResponse',
    'OpenIdConnectClientCredentialResponse',
    'OpenIdConnectConfigResponse',
    'OpenIdConnectLoginResponse',
    'OpenIdConnectRegistrationResponse',
    'QueueScaleRuleResponse',
    'RegistryCredentialsResponse',
    'RegistryInfoResponse',
    'ScaleResponse',
    'ScaleRuleAuthResponse',
    'ScaleRuleResponse',
    'SecretResponse',
    'SystemDataResponse',
    'TemplateResponse',
    'TrafficWeightResponse',
    'TwitterRegistrationResponse',
    'TwitterResponse',
    'UserAssignedIdentityResponse',
    'VnetConfigurationResponse',
    'VolumeMountResponse',
    'VolumeResponse',
]

@pulumi.output_type
class AllowedAudiencesValidationResponse(dict):
    """
    The configuration settings of the Allowed Audiences validation flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedAudiences":
            suggest = "allowed_audiences"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllowedAudiencesValidationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllowedAudiencesValidationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllowedAudiencesValidationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_audiences: Optional[Sequence[str]] = None):
        """
        The configuration settings of the Allowed Audiences validation flow.
        :param Sequence[str] allowed_audiences: The configuration settings of the allowed list of audiences from which to validate the JWT token.
        """
        if allowed_audiences is not None:
            pulumi.set(__self__, "allowed_audiences", allowed_audiences)

    @property
    @pulumi.getter(name="allowedAudiences")
    def allowed_audiences(self) -> Optional[Sequence[str]]:
        """
        The configuration settings of the allowed list of audiences from which to validate the JWT token.
        """
        return pulumi.get(self, "allowed_audiences")


@pulumi.output_type
class AllowedPrincipalsResponse(dict):
    """
    The configuration settings of the Azure Active Directory allowed principals.
    """
    def __init__(__self__, *,
                 groups: Optional[Sequence[str]] = None,
                 identities: Optional[Sequence[str]] = None):
        """
        The configuration settings of the Azure Active Directory allowed principals.
        :param Sequence[str] groups: The list of the allowed groups.
        :param Sequence[str] identities: The list of the allowed identities.
        """
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if identities is not None:
            pulumi.set(__self__, "identities", identities)

    @property
    @pulumi.getter
    def groups(self) -> Optional[Sequence[str]]:
        """
        The list of the allowed groups.
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def identities(self) -> Optional[Sequence[str]]:
        """
        The list of the allowed identities.
        """
        return pulumi.get(self, "identities")


@pulumi.output_type
class AppLogsConfigurationResponse(dict):
    """
    Configuration of application logs
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logAnalyticsConfiguration":
            suggest = "log_analytics_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppLogsConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppLogsConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppLogsConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: Optional[str] = None,
                 log_analytics_configuration: Optional['outputs.LogAnalyticsConfigurationResponse'] = None):
        """
        Configuration of application logs
        :param str destination: Logs destination
        :param 'LogAnalyticsConfigurationResponse' log_analytics_configuration: Log Analytics configuration
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if log_analytics_configuration is not None:
            pulumi.set(__self__, "log_analytics_configuration", log_analytics_configuration)

    @property
    @pulumi.getter
    def destination(self) -> Optional[str]:
        """
        Logs destination
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="logAnalyticsConfiguration")
    def log_analytics_configuration(self) -> Optional['outputs.LogAnalyticsConfigurationResponse']:
        """
        Log Analytics configuration
        """
        return pulumi.get(self, "log_analytics_configuration")


@pulumi.output_type
class AppRegistrationResponse(dict):
    """
    The configuration settings of the app registration for providers that have app ids and app secrets
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appId":
            suggest = "app_id"
        elif key == "appSecretSettingName":
            suggest = "app_secret_setting_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppRegistrationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppRegistrationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppRegistrationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_id: Optional[str] = None,
                 app_secret_setting_name: Optional[str] = None):
        """
        The configuration settings of the app registration for providers that have app ids and app secrets
        :param str app_id: The App ID of the app used for login.
        :param str app_secret_setting_name: The app setting name that contains the app secret.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_secret_setting_name is not None:
            pulumi.set(__self__, "app_secret_setting_name", app_secret_setting_name)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[str]:
        """
        The App ID of the app used for login.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="appSecretSettingName")
    def app_secret_setting_name(self) -> Optional[str]:
        """
        The app setting name that contains the app secret.
        """
        return pulumi.get(self, "app_secret_setting_name")


@pulumi.output_type
class AppleRegistrationResponse(dict):
    """
    The configuration settings of the registration for the Apple provider
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecretSettingName":
            suggest = "client_secret_setting_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppleRegistrationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppleRegistrationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppleRegistrationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[str] = None,
                 client_secret_setting_name: Optional[str] = None):
        """
        The configuration settings of the registration for the Apple provider
        :param str client_id: The Client ID of the app used for login.
        :param str client_secret_setting_name: The app setting name that contains the client secret.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret_setting_name is not None:
            pulumi.set(__self__, "client_secret_setting_name", client_secret_setting_name)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The Client ID of the app used for login.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecretSettingName")
    def client_secret_setting_name(self) -> Optional[str]:
        """
        The app setting name that contains the client secret.
        """
        return pulumi.get(self, "client_secret_setting_name")


@pulumi.output_type
class AppleResponse(dict):
    """
    The configuration settings of the Apple provider.
    """
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 login: Optional['outputs.LoginScopesResponse'] = None,
                 registration: Optional['outputs.AppleRegistrationResponse'] = None):
        """
        The configuration settings of the Apple provider.
        :param bool enabled: <code>false</code> if the Apple provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param 'LoginScopesResponse' login: The configuration settings of the login flow.
        :param 'AppleRegistrationResponse' registration: The configuration settings of the Apple registration.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        <code>false</code> if the Apple provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def login(self) -> Optional['outputs.LoginScopesResponse']:
        """
        The configuration settings of the login flow.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter
    def registration(self) -> Optional['outputs.AppleRegistrationResponse']:
        """
        The configuration settings of the Apple registration.
        """
        return pulumi.get(self, "registration")


@pulumi.output_type
class AuthPlatformResponse(dict):
    """
    The configuration settings of the platform of ContainerApp Service Authentication/Authorization.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runtimeVersion":
            suggest = "runtime_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthPlatformResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthPlatformResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthPlatformResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 runtime_version: Optional[str] = None):
        """
        The configuration settings of the platform of ContainerApp Service Authentication/Authorization.
        :param bool enabled: <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
        :param str runtime_version: The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
               The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[str]:
        """
        The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
        The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class AzureActiveDirectoryLoginResponse(dict):
    """
    The configuration settings of the Azure Active Directory login flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableWWWAuthenticate":
            suggest = "disable_www_authenticate"
        elif key == "loginParameters":
            suggest = "login_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureActiveDirectoryLoginResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureActiveDirectoryLoginResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureActiveDirectoryLoginResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_www_authenticate: Optional[bool] = None,
                 login_parameters: Optional[Sequence[str]] = None):
        """
        The configuration settings of the Azure Active Directory login flow.
        :param bool disable_www_authenticate: <code>true</code> if the www-authenticate provider should be omitted from the request; otherwise, <code>false</code>.
        :param Sequence[str] login_parameters: Login parameters to send to the OpenID Connect authorization endpoint when
               a user logs in. Each parameter must be in the form "key=value".
        """
        if disable_www_authenticate is not None:
            pulumi.set(__self__, "disable_www_authenticate", disable_www_authenticate)
        if login_parameters is not None:
            pulumi.set(__self__, "login_parameters", login_parameters)

    @property
    @pulumi.getter(name="disableWWWAuthenticate")
    def disable_www_authenticate(self) -> Optional[bool]:
        """
        <code>true</code> if the www-authenticate provider should be omitted from the request; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "disable_www_authenticate")

    @property
    @pulumi.getter(name="loginParameters")
    def login_parameters(self) -> Optional[Sequence[str]]:
        """
        Login parameters to send to the OpenID Connect authorization endpoint when
        a user logs in. Each parameter must be in the form "key=value".
        """
        return pulumi.get(self, "login_parameters")


@pulumi.output_type
class AzureActiveDirectoryRegistrationResponse(dict):
    """
    The configuration settings of the Azure Active Directory app registration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecretCertificateIssuer":
            suggest = "client_secret_certificate_issuer"
        elif key == "clientSecretCertificateSubjectAlternativeName":
            suggest = "client_secret_certificate_subject_alternative_name"
        elif key == "clientSecretCertificateThumbprint":
            suggest = "client_secret_certificate_thumbprint"
        elif key == "clientSecretSettingName":
            suggest = "client_secret_setting_name"
        elif key == "openIdIssuer":
            suggest = "open_id_issuer"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureActiveDirectoryRegistrationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureActiveDirectoryRegistrationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureActiveDirectoryRegistrationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[str] = None,
                 client_secret_certificate_issuer: Optional[str] = None,
                 client_secret_certificate_subject_alternative_name: Optional[str] = None,
                 client_secret_certificate_thumbprint: Optional[str] = None,
                 client_secret_setting_name: Optional[str] = None,
                 open_id_issuer: Optional[str] = None):
        """
        The configuration settings of the Azure Active Directory app registration.
        :param str client_id: The Client ID of this relying party application, known as the client_id.
               This setting is required for enabling OpenID Connection authentication with Azure Active Directory or 
               other 3rd party OpenID Connect providers.
               More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
        :param str client_secret_certificate_issuer: An alternative to the client secret thumbprint, that is the issuer of a certificate used for signing purposes. This property acts as
               a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        :param str client_secret_certificate_subject_alternative_name: An alternative to the client secret thumbprint, that is the subject alternative name of a certificate used for signing purposes. This property acts as
               a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        :param str client_secret_certificate_thumbprint: An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts as
               a replacement for the Client Secret. It is also optional.
        :param str client_secret_setting_name: The app setting name that contains the client secret of the relying party application.
        :param str open_id_issuer: The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
               When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://login.microsoftonline.com/v2.0/{tenant-guid}/.
               This URI is a case-sensitive identifier for the token issuer.
               More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret_certificate_issuer is not None:
            pulumi.set(__self__, "client_secret_certificate_issuer", client_secret_certificate_issuer)
        if client_secret_certificate_subject_alternative_name is not None:
            pulumi.set(__self__, "client_secret_certificate_subject_alternative_name", client_secret_certificate_subject_alternative_name)
        if client_secret_certificate_thumbprint is not None:
            pulumi.set(__self__, "client_secret_certificate_thumbprint", client_secret_certificate_thumbprint)
        if client_secret_setting_name is not None:
            pulumi.set(__self__, "client_secret_setting_name", client_secret_setting_name)
        if open_id_issuer is not None:
            pulumi.set(__self__, "open_id_issuer", open_id_issuer)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The Client ID of this relying party application, known as the client_id.
        This setting is required for enabling OpenID Connection authentication with Azure Active Directory or 
        other 3rd party OpenID Connect providers.
        More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecretCertificateIssuer")
    def client_secret_certificate_issuer(self) -> Optional[str]:
        """
        An alternative to the client secret thumbprint, that is the issuer of a certificate used for signing purposes. This property acts as
        a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        """
        return pulumi.get(self, "client_secret_certificate_issuer")

    @property
    @pulumi.getter(name="clientSecretCertificateSubjectAlternativeName")
    def client_secret_certificate_subject_alternative_name(self) -> Optional[str]:
        """
        An alternative to the client secret thumbprint, that is the subject alternative name of a certificate used for signing purposes. This property acts as
        a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        """
        return pulumi.get(self, "client_secret_certificate_subject_alternative_name")

    @property
    @pulumi.getter(name="clientSecretCertificateThumbprint")
    def client_secret_certificate_thumbprint(self) -> Optional[str]:
        """
        An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts as
        a replacement for the Client Secret. It is also optional.
        """
        return pulumi.get(self, "client_secret_certificate_thumbprint")

    @property
    @pulumi.getter(name="clientSecretSettingName")
    def client_secret_setting_name(self) -> Optional[str]:
        """
        The app setting name that contains the client secret of the relying party application.
        """
        return pulumi.get(self, "client_secret_setting_name")

    @property
    @pulumi.getter(name="openIdIssuer")
    def open_id_issuer(self) -> Optional[str]:
        """
        The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
        When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://login.microsoftonline.com/v2.0/{tenant-guid}/.
        This URI is a case-sensitive identifier for the token issuer.
        More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
        """
        return pulumi.get(self, "open_id_issuer")


@pulumi.output_type
class AzureActiveDirectoryResponse(dict):
    """
    The configuration settings of the Azure Active directory provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isAutoProvisioned":
            suggest = "is_auto_provisioned"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureActiveDirectoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureActiveDirectoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureActiveDirectoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 is_auto_provisioned: Optional[bool] = None,
                 login: Optional['outputs.AzureActiveDirectoryLoginResponse'] = None,
                 registration: Optional['outputs.AzureActiveDirectoryRegistrationResponse'] = None,
                 validation: Optional['outputs.AzureActiveDirectoryValidationResponse'] = None):
        """
        The configuration settings of the Azure Active directory provider.
        :param bool enabled: <code>false</code> if the Azure Active Directory provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param bool is_auto_provisioned: Gets a value indicating whether the Azure AD configuration was auto-provisioned using 1st party tooling.
               This is an internal flag primarily intended to support the Azure Management Portal. Users should not
               read or write to this property.
        :param 'AzureActiveDirectoryLoginResponse' login: The configuration settings of the Azure Active Directory login flow.
        :param 'AzureActiveDirectoryRegistrationResponse' registration: The configuration settings of the Azure Active Directory app registration.
        :param 'AzureActiveDirectoryValidationResponse' validation: The configuration settings of the Azure Active Directory token validation flow.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if is_auto_provisioned is not None:
            pulumi.set(__self__, "is_auto_provisioned", is_auto_provisioned)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)
        if validation is not None:
            pulumi.set(__self__, "validation", validation)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        <code>false</code> if the Azure Active Directory provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="isAutoProvisioned")
    def is_auto_provisioned(self) -> Optional[bool]:
        """
        Gets a value indicating whether the Azure AD configuration was auto-provisioned using 1st party tooling.
        This is an internal flag primarily intended to support the Azure Management Portal. Users should not
        read or write to this property.
        """
        return pulumi.get(self, "is_auto_provisioned")

    @property
    @pulumi.getter
    def login(self) -> Optional['outputs.AzureActiveDirectoryLoginResponse']:
        """
        The configuration settings of the Azure Active Directory login flow.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter
    def registration(self) -> Optional['outputs.AzureActiveDirectoryRegistrationResponse']:
        """
        The configuration settings of the Azure Active Directory app registration.
        """
        return pulumi.get(self, "registration")

    @property
    @pulumi.getter
    def validation(self) -> Optional['outputs.AzureActiveDirectoryValidationResponse']:
        """
        The configuration settings of the Azure Active Directory token validation flow.
        """
        return pulumi.get(self, "validation")


@pulumi.output_type
class AzureActiveDirectoryValidationResponse(dict):
    """
    The configuration settings of the Azure Active Directory token validation flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedAudiences":
            suggest = "allowed_audiences"
        elif key == "defaultAuthorizationPolicy":
            suggest = "default_authorization_policy"
        elif key == "jwtClaimChecks":
            suggest = "jwt_claim_checks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureActiveDirectoryValidationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureActiveDirectoryValidationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureActiveDirectoryValidationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_audiences: Optional[Sequence[str]] = None,
                 default_authorization_policy: Optional['outputs.DefaultAuthorizationPolicyResponse'] = None,
                 jwt_claim_checks: Optional['outputs.JwtClaimChecksResponse'] = None):
        """
        The configuration settings of the Azure Active Directory token validation flow.
        :param Sequence[str] allowed_audiences: The list of audiences that can make successful authentication/authorization requests.
        :param 'DefaultAuthorizationPolicyResponse' default_authorization_policy: The configuration settings of the default authorization policy.
        :param 'JwtClaimChecksResponse' jwt_claim_checks: The configuration settings of the checks that should be made while validating the JWT Claims.
        """
        if allowed_audiences is not None:
            pulumi.set(__self__, "allowed_audiences", allowed_audiences)
        if default_authorization_policy is not None:
            pulumi.set(__self__, "default_authorization_policy", default_authorization_policy)
        if jwt_claim_checks is not None:
            pulumi.set(__self__, "jwt_claim_checks", jwt_claim_checks)

    @property
    @pulumi.getter(name="allowedAudiences")
    def allowed_audiences(self) -> Optional[Sequence[str]]:
        """
        The list of audiences that can make successful authentication/authorization requests.
        """
        return pulumi.get(self, "allowed_audiences")

    @property
    @pulumi.getter(name="defaultAuthorizationPolicy")
    def default_authorization_policy(self) -> Optional['outputs.DefaultAuthorizationPolicyResponse']:
        """
        The configuration settings of the default authorization policy.
        """
        return pulumi.get(self, "default_authorization_policy")

    @property
    @pulumi.getter(name="jwtClaimChecks")
    def jwt_claim_checks(self) -> Optional['outputs.JwtClaimChecksResponse']:
        """
        The configuration settings of the checks that should be made while validating the JWT Claims.
        """
        return pulumi.get(self, "jwt_claim_checks")


@pulumi.output_type
class AzureCredentialsResponse(dict):
    """
    Container App credentials.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subscription_id: Optional[str] = None):
        """
        Container App credentials.
        :param str subscription_id: Subscription Id.
        """
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        Subscription Id.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class AzureFilePropertiesResponse(dict):
    """
    Azure File Properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessMode":
            suggest = "access_mode"
        elif key == "accountKey":
            suggest = "account_key"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "shareName":
            suggest = "share_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFilePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFilePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFilePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_mode: Optional[str] = None,
                 account_key: Optional[str] = None,
                 account_name: Optional[str] = None,
                 share_name: Optional[str] = None):
        """
        Azure File Properties.
        :param str access_mode: Access mode for storage
        :param str account_key: Storage account key for azure file.
        :param str account_name: Storage account name for azure file.
        :param str share_name: Azure file share name.
        """
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if share_name is not None:
            pulumi.set(__self__, "share_name", share_name)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[str]:
        """
        Access mode for storage
        """
        return pulumi.get(self, "access_mode")

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[str]:
        """
        Storage account key for azure file.
        """
        return pulumi.get(self, "account_key")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        Storage account name for azure file.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> Optional[str]:
        """
        Azure file share name.
        """
        return pulumi.get(self, "share_name")


@pulumi.output_type
class AzureStaticWebAppsRegistrationResponse(dict):
    """
    The configuration settings of the registration for the Azure Static Web Apps provider
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureStaticWebAppsRegistrationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureStaticWebAppsRegistrationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureStaticWebAppsRegistrationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[str] = None):
        """
        The configuration settings of the registration for the Azure Static Web Apps provider
        :param str client_id: The Client ID of the app used for login.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The Client ID of the app used for login.
        """
        return pulumi.get(self, "client_id")


@pulumi.output_type
class AzureStaticWebAppsResponse(dict):
    """
    The configuration settings of the Azure Static Web Apps provider.
    """
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 registration: Optional['outputs.AzureStaticWebAppsRegistrationResponse'] = None):
        """
        The configuration settings of the Azure Static Web Apps provider.
        :param bool enabled: <code>false</code> if the Azure Static Web Apps provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param 'AzureStaticWebAppsRegistrationResponse' registration: The configuration settings of the Azure Static Web Apps registration.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        <code>false</code> if the Azure Static Web Apps provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def registration(self) -> Optional['outputs.AzureStaticWebAppsRegistrationResponse']:
        """
        The configuration settings of the Azure Static Web Apps registration.
        """
        return pulumi.get(self, "registration")


@pulumi.output_type
class CertificateResponseProperties(dict):
    """
    Certificate resource specific properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationDate":
            suggest = "expiration_date"
        elif key == "issueDate":
            suggest = "issue_date"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicKeyHash":
            suggest = "public_key_hash"
        elif key == "subjectName":
            suggest = "subject_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiration_date: str,
                 issue_date: str,
                 issuer: str,
                 provisioning_state: str,
                 public_key_hash: str,
                 subject_name: str,
                 thumbprint: str,
                 valid: bool):
        """
        Certificate resource specific properties
        :param str expiration_date: Certificate expiration date.
        :param str issue_date: Certificate issue Date.
        :param str issuer: Certificate issuer.
        :param str provisioning_state: Provisioning state of the certificate.
        :param str public_key_hash: Public key hash.
        :param str subject_name: Subject name of the certificate.
        :param str thumbprint: Certificate thumbprint.
        :param bool valid: Is the certificate valid?.
        """
        pulumi.set(__self__, "expiration_date", expiration_date)
        pulumi.set(__self__, "issue_date", issue_date)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "public_key_hash", public_key_hash)
        pulumi.set(__self__, "subject_name", subject_name)
        pulumi.set(__self__, "thumbprint", thumbprint)
        pulumi.set(__self__, "valid", valid)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> str:
        """
        Certificate expiration date.
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="issueDate")
    def issue_date(self) -> str:
        """
        Certificate issue Date.
        """
        return pulumi.get(self, "issue_date")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        Certificate issuer.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the certificate.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicKeyHash")
    def public_key_hash(self) -> str:
        """
        Public key hash.
        """
        return pulumi.get(self, "public_key_hash")

    @property
    @pulumi.getter(name="subjectName")
    def subject_name(self) -> str:
        """
        Subject name of the certificate.
        """
        return pulumi.get(self, "subject_name")

    @property
    @pulumi.getter
    def thumbprint(self) -> str:
        """
        Certificate thumbprint.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter
    def valid(self) -> bool:
        """
        Is the certificate valid?.
        """
        return pulumi.get(self, "valid")


@pulumi.output_type
class ClientRegistrationResponse(dict):
    """
    The configuration settings of the app registration for providers that have client ids and client secrets
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecretSettingName":
            suggest = "client_secret_setting_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientRegistrationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientRegistrationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientRegistrationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[str] = None,
                 client_secret_setting_name: Optional[str] = None):
        """
        The configuration settings of the app registration for providers that have client ids and client secrets
        :param str client_id: The Client ID of the app used for login.
        :param str client_secret_setting_name: The app setting name that contains the client secret.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret_setting_name is not None:
            pulumi.set(__self__, "client_secret_setting_name", client_secret_setting_name)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The Client ID of the app used for login.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecretSettingName")
    def client_secret_setting_name(self) -> Optional[str]:
        """
        The app setting name that contains the client secret.
        """
        return pulumi.get(self, "client_secret_setting_name")


@pulumi.output_type
class ConfigurationResponse(dict):
    """
    Non versioned Container App configuration properties that define the mutable settings of a Container app
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeRevisionsMode":
            suggest = "active_revisions_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_revisions_mode: Optional[str] = None,
                 dapr: Optional['outputs.DaprResponse'] = None,
                 ingress: Optional['outputs.IngressResponse'] = None,
                 registries: Optional[Sequence['outputs.RegistryCredentialsResponse']] = None,
                 secrets: Optional[Sequence['outputs.SecretResponse']] = None):
        """
        Non versioned Container App configuration properties that define the mutable settings of a Container app
        :param str active_revisions_mode: ActiveRevisionsMode controls how active revisions are handled for the Container app:
               <list><item>Multiple: multiple revisions can be active.</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode. If no value if provided, this is the default.</item></list>
        :param 'DaprResponse' dapr: Dapr configuration for the Container App.
        :param 'IngressResponse' ingress: Ingress configurations.
        :param Sequence['RegistryCredentialsResponse'] registries: Collection of private container registry credentials for containers used by the Container app
        :param Sequence['SecretResponse'] secrets: Collection of secrets used by a Container app
        """
        if active_revisions_mode is not None:
            pulumi.set(__self__, "active_revisions_mode", active_revisions_mode)
        if dapr is not None:
            pulumi.set(__self__, "dapr", dapr)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if registries is not None:
            pulumi.set(__self__, "registries", registries)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter(name="activeRevisionsMode")
    def active_revisions_mode(self) -> Optional[str]:
        """
        ActiveRevisionsMode controls how active revisions are handled for the Container app:
        <list><item>Multiple: multiple revisions can be active.</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode. If no value if provided, this is the default.</item></list>
        """
        return pulumi.get(self, "active_revisions_mode")

    @property
    @pulumi.getter
    def dapr(self) -> Optional['outputs.DaprResponse']:
        """
        Dapr configuration for the Container App.
        """
        return pulumi.get(self, "dapr")

    @property
    @pulumi.getter
    def ingress(self) -> Optional['outputs.IngressResponse']:
        """
        Ingress configurations.
        """
        return pulumi.get(self, "ingress")

    @property
    @pulumi.getter
    def registries(self) -> Optional[Sequence['outputs.RegistryCredentialsResponse']]:
        """
        Collection of private container registry credentials for containers used by the Container app
        """
        return pulumi.get(self, "registries")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.SecretResponse']]:
        """
        Collection of secrets used by a Container app
        """
        return pulumi.get(self, "secrets")


@pulumi.output_type
class ContainerAppProbeResponse(dict):
    """
    Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "successThreshold":
            suggest = "success_threshold"
        elif key == "tcpSocket":
            suggest = "tcp_socket"
        elif key == "terminationGracePeriodSeconds":
            suggest = "termination_grace_period_seconds"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerAppProbeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerAppProbeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerAppProbeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[int] = None,
                 http_get: Optional['outputs.ContainerAppProbeResponseHttpGet'] = None,
                 initial_delay_seconds: Optional[int] = None,
                 period_seconds: Optional[int] = None,
                 success_threshold: Optional[int] = None,
                 tcp_socket: Optional['outputs.ContainerAppProbeResponseTcpSocket'] = None,
                 termination_grace_period_seconds: Optional[float] = None,
                 timeout_seconds: Optional[int] = None,
                 type: Optional[str] = None):
        """
        Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
        :param int failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Maximum value is 10.
        :param 'ContainerAppProbeResponseHttpGet' http_get: HTTPGet specifies the http request to perform.
        :param int initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Minimum value is 1. Maximum value is 60.
        :param int period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value is 240.
        :param int success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Maximum value is 10.
        :param 'ContainerAppProbeResponseTcpSocket' tcp_socket: TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.
        :param float termination_grace_period_seconds: Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). This is an alpha field and requires enabling ProbeTerminationGracePeriod feature gate. Maximum value is 3600 seconds (1 hour)
        :param int timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 240.
        :param str type: The type of probe.
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[int]:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Maximum value is 10.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional['outputs.ContainerAppProbeResponseHttpGet']:
        """
        HTTPGet specifies the http request to perform.
        """
        return pulumi.get(self, "http_get")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[int]:
        """
        Number of seconds after the container has started before liveness probes are initiated. Minimum value is 1. Maximum value is 60.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[int]:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value is 240.
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[int]:
        """
        Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Maximum value is 10.
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional['outputs.ContainerAppProbeResponseTcpSocket']:
        """
        TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.
        """
        return pulumi.get(self, "tcp_socket")

    @property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[float]:
        """
        Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). This is an alpha field and requires enabling ProbeTerminationGracePeriod feature gate. Maximum value is 3600 seconds (1 hour)
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 240.
        """
        return pulumi.get(self, "timeout_seconds")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of probe.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ContainerAppProbeResponseHttpGet(dict):
    """
    HTTPGet specifies the http request to perform.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerAppProbeResponseHttpGet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerAppProbeResponseHttpGet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerAppProbeResponseHttpGet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: int,
                 host: Optional[str] = None,
                 http_headers: Optional[Sequence['outputs.ContainerAppProbeResponseHttpHeaders']] = None,
                 path: Optional[str] = None,
                 scheme: Optional[str] = None):
        """
        HTTPGet specifies the http request to perform.
        :param int port: Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        :param str host: Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
        :param Sequence['ContainerAppProbeResponseHttpHeaders'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
        :param str path: Path to access on the HTTP server.
        :param str scheme: Scheme to use for connecting to the host. Defaults to HTTP.
        """
        pulumi.set(__self__, "port", port)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Sequence['outputs.ContainerAppProbeResponseHttpHeaders']]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        """
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to access on the HTTP server.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def scheme(self) -> Optional[str]:
        """
        Scheme to use for connecting to the host. Defaults to HTTP.
        """
        return pulumi.get(self, "scheme")


@pulumi.output_type
class ContainerAppProbeResponseHttpHeaders(dict):
    """
    HTTPHeader describes a custom header to be used in HTTP probes
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        HTTPHeader describes a custom header to be used in HTTP probes
        :param str name: The header field name
        :param str value: The header field value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The header field value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerAppProbeResponseTcpSocket(dict):
    """
    TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.
    """
    def __init__(__self__, *,
                 port: int,
                 host: Optional[str] = None):
        """
        TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.
        :param int port: Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        :param str host: Optional: Host name to connect to, defaults to the pod IP.
        """
        pulumi.set(__self__, "port", port)
        if host is not None:
            pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        Optional: Host name to connect to, defaults to the pod IP.
        """
        return pulumi.get(self, "host")


@pulumi.output_type
class ContainerAppSecretResponse(dict):
    """
    Container App Secret.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Container App Secret.
        :param str name: Secret Name.
        :param str value: Secret Value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Secret Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Secret Value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerResourcesResponse(dict):
    """
    Container App container resource requirements.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ephemeralStorage":
            suggest = "ephemeral_storage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerResourcesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerResourcesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerResourcesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ephemeral_storage: str,
                 cpu: Optional[float] = None,
                 memory: Optional[str] = None):
        """
        Container App container resource requirements.
        :param str ephemeral_storage: Ephemeral Storage, e.g. "1Gi"
        :param float cpu: Required CPU in cores, e.g. 0.5
        :param str memory: Required memory, e.g. "250Mb"
        """
        pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> str:
        """
        Ephemeral Storage, e.g. "1Gi"
        """
        return pulumi.get(self, "ephemeral_storage")

    @property
    @pulumi.getter
    def cpu(self) -> Optional[float]:
        """
        Required CPU in cores, e.g. 0.5
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def memory(self) -> Optional[str]:
        """
        Required memory, e.g. "250Mb"
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class ContainerResponse(dict):
    """
    Container App container definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeMounts":
            suggest = "volume_mounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Optional[Sequence[str]] = None,
                 command: Optional[Sequence[str]] = None,
                 env: Optional[Sequence['outputs.EnvironmentVarResponse']] = None,
                 image: Optional[str] = None,
                 name: Optional[str] = None,
                 probes: Optional[Sequence['outputs.ContainerAppProbeResponse']] = None,
                 resources: Optional['outputs.ContainerResourcesResponse'] = None,
                 volume_mounts: Optional[Sequence['outputs.VolumeMountResponse']] = None):
        """
        Container App container definition.
        :param Sequence[str] args: Container start command arguments.
        :param Sequence[str] command: Container start command.
        :param Sequence['EnvironmentVarResponse'] env: Container environment variables.
        :param str image: Container image tag.
        :param str name: Custom container name.
        :param Sequence['ContainerAppProbeResponse'] probes: List of probes for the container.
        :param 'ContainerResourcesResponse' resources: Container resource requirements.
        :param Sequence['VolumeMountResponse'] volume_mounts: Container volume mounts.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if probes is not None:
            pulumi.set(__self__, "probes", probes)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        Container start command arguments.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def command(self) -> Optional[Sequence[str]]:
        """
        Container start command.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def env(self) -> Optional[Sequence['outputs.EnvironmentVarResponse']]:
        """
        Container environment variables.
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Container image tag.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Custom container name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def probes(self) -> Optional[Sequence['outputs.ContainerAppProbeResponse']]:
        """
        List of probes for the container.
        """
        return pulumi.get(self, "probes")

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.ContainerResourcesResponse']:
        """
        Container resource requirements.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.VolumeMountResponse']]:
        """
        Container volume mounts.
        """
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class CookieExpirationResponse(dict):
    """
    The configuration settings of the session cookie's expiration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeToExpiration":
            suggest = "time_to_expiration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CookieExpirationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CookieExpirationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CookieExpirationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 convention: Optional[str] = None,
                 time_to_expiration: Optional[str] = None):
        """
        The configuration settings of the session cookie's expiration.
        :param str convention: The convention used when determining the session cookie's expiration.
        :param str time_to_expiration: The time after the request is made when the session cookie should expire.
        """
        if convention is not None:
            pulumi.set(__self__, "convention", convention)
        if time_to_expiration is not None:
            pulumi.set(__self__, "time_to_expiration", time_to_expiration)

    @property
    @pulumi.getter
    def convention(self) -> Optional[str]:
        """
        The convention used when determining the session cookie's expiration.
        """
        return pulumi.get(self, "convention")

    @property
    @pulumi.getter(name="timeToExpiration")
    def time_to_expiration(self) -> Optional[str]:
        """
        The time after the request is made when the session cookie should expire.
        """
        return pulumi.get(self, "time_to_expiration")


@pulumi.output_type
class CustomDomainResponse(dict):
    """
    Custom Domain of a Container App
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateId":
            suggest = "certificate_id"
        elif key == "bindingType":
            suggest = "binding_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDomainResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDomainResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDomainResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_id: str,
                 name: str,
                 binding_type: Optional[str] = None):
        """
        Custom Domain of a Container App
        :param str certificate_id: Resource Id of the Certificate to be bound to this hostname. Must exist in the Managed Environment.
        :param str name: Hostname.
        :param str binding_type: Custom Domain binding type.
        """
        pulumi.set(__self__, "certificate_id", certificate_id)
        pulumi.set(__self__, "name", name)
        if binding_type is not None:
            pulumi.set(__self__, "binding_type", binding_type)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> str:
        """
        Resource Id of the Certificate to be bound to this hostname. Must exist in the Managed Environment.
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Hostname.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="bindingType")
    def binding_type(self) -> Optional[str]:
        """
        Custom Domain binding type.
        """
        return pulumi.get(self, "binding_type")


@pulumi.output_type
class CustomHostnameAnalysisResultResponseCustomDomainVerificationFailureInfo(dict):
    """
    Raw failure information if DNS verification fails.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 target: str,
                 details: Optional[Sequence['outputs.CustomHostnameAnalysisResultResponseDetails']] = None):
        """
        Raw failure information if DNS verification fails.
        :param str code: Standardized string to programmatically identify the error.
        :param str message: Detailed error description and debugging information.
        :param str target: Detailed error description and debugging information.
        :param Sequence['CustomHostnameAnalysisResultResponseDetails'] details: Details or the error
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "target", target)
        if details is not None:
            pulumi.set(__self__, "details", details)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Standardized string to programmatically identify the error.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Detailed error description and debugging information.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Detailed error description and debugging information.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.CustomHostnameAnalysisResultResponseDetails']]:
        """
        Details or the error
        """
        return pulumi.get(self, "details")


@pulumi.output_type
class CustomHostnameAnalysisResultResponseDetails(dict):
    """
    Detailed errors.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 target: str):
        """
        Detailed errors.
        :param str code: Standardized string to programmatically identify the error.
        :param str message: Detailed error description and debugging information.
        :param str target: Detailed error description and debugging information.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Standardized string to programmatically identify the error.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Detailed error description and debugging information.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Detailed error description and debugging information.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class CustomOpenIdConnectProviderResponse(dict):
    """
    The configuration settings of the custom Open ID Connect provider.
    """
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 login: Optional['outputs.OpenIdConnectLoginResponse'] = None,
                 registration: Optional['outputs.OpenIdConnectRegistrationResponse'] = None):
        """
        The configuration settings of the custom Open ID Connect provider.
        :param bool enabled: <code>false</code> if the custom Open ID provider provider should not be enabled; otherwise, <code>true</code>.
        :param 'OpenIdConnectLoginResponse' login: The configuration settings of the login flow of the custom Open ID Connect provider.
        :param 'OpenIdConnectRegistrationResponse' registration: The configuration settings of the app registration for the custom Open ID Connect provider.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        <code>false</code> if the custom Open ID provider provider should not be enabled; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def login(self) -> Optional['outputs.OpenIdConnectLoginResponse']:
        """
        The configuration settings of the login flow of the custom Open ID Connect provider.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter
    def registration(self) -> Optional['outputs.OpenIdConnectRegistrationResponse']:
        """
        The configuration settings of the app registration for the custom Open ID Connect provider.
        """
        return pulumi.get(self, "registration")


@pulumi.output_type
class CustomScaleRuleResponse(dict):
    """
    Container App container Custom scaling rule.
    """
    def __init__(__self__, *,
                 auth: Optional[Sequence['outputs.ScaleRuleAuthResponse']] = None,
                 metadata: Optional[Mapping[str, str]] = None,
                 type: Optional[str] = None):
        """
        Container App container Custom scaling rule.
        :param Sequence['ScaleRuleAuthResponse'] auth: Authentication secrets for the custom scale rule.
        :param Mapping[str, str] metadata: Metadata properties to describe custom scale rule.
        :param str type: Type of the custom scale rule
               eg: azure-servicebus, redis etc.
        """
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def auth(self) -> Optional[Sequence['outputs.ScaleRuleAuthResponse']]:
        """
        Authentication secrets for the custom scale rule.
        """
        return pulumi.get(self, "auth")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, str]]:
        """
        Metadata properties to describe custom scale rule.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the custom scale rule
        eg: azure-servicebus, redis etc.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DaprMetadataResponse(dict):
    """
    Dapr component metadata.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaprMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaprMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaprMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 secret_ref: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Dapr component metadata.
        :param str name: Metadata property name.
        :param str secret_ref: Name of the Dapr Component secret from which to pull the metadata property value.
        :param str value: Metadata property value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Metadata property name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[str]:
        """
        Name of the Dapr Component secret from which to pull the metadata property value.
        """
        return pulumi.get(self, "secret_ref")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Metadata property value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DaprResponse(dict):
    """
    Container App Dapr configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appId":
            suggest = "app_id"
        elif key == "appPort":
            suggest = "app_port"
        elif key == "appProtocol":
            suggest = "app_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaprResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaprResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaprResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_id: Optional[str] = None,
                 app_port: Optional[int] = None,
                 app_protocol: Optional[str] = None,
                 enabled: Optional[bool] = None):
        """
        Container App Dapr configuration.
        :param str app_id: Dapr application identifier
        :param int app_port: Tells Dapr which port your application is listening on
        :param str app_protocol: Tells Dapr which protocol your application is using. Valid options are http and grpc. Default is http
        :param bool enabled: Boolean indicating if the Dapr side car is enabled
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_port is not None:
            pulumi.set(__self__, "app_port", app_port)
        if app_protocol is not None:
            pulumi.set(__self__, "app_protocol", app_protocol)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[str]:
        """
        Dapr application identifier
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="appPort")
    def app_port(self) -> Optional[int]:
        """
        Tells Dapr which port your application is listening on
        """
        return pulumi.get(self, "app_port")

    @property
    @pulumi.getter(name="appProtocol")
    def app_protocol(self) -> Optional[str]:
        """
        Tells Dapr which protocol your application is using. Valid options are http and grpc. Default is http
        """
        return pulumi.get(self, "app_protocol")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Boolean indicating if the Dapr side car is enabled
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DaprSecretResponse(dict):
    """
    Dapr component Secret for ListSecrets Action
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Dapr component Secret for ListSecrets Action
        :param str name: Secret Name.
        :param str value: Secret Value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Secret Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Secret Value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DefaultAuthorizationPolicyResponse(dict):
    """
    The configuration settings of the Azure Active Directory default authorization policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedApplications":
            suggest = "allowed_applications"
        elif key == "allowedPrincipals":
            suggest = "allowed_principals"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefaultAuthorizationPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefaultAuthorizationPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefaultAuthorizationPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_applications: Optional[Sequence[str]] = None,
                 allowed_principals: Optional['outputs.AllowedPrincipalsResponse'] = None):
        """
        The configuration settings of the Azure Active Directory default authorization policy.
        :param Sequence[str] allowed_applications: The configuration settings of the Azure Active Directory allowed applications.
        :param 'AllowedPrincipalsResponse' allowed_principals: The configuration settings of the Azure Active Directory allowed principals.
        """
        if allowed_applications is not None:
            pulumi.set(__self__, "allowed_applications", allowed_applications)
        if allowed_principals is not None:
            pulumi.set(__self__, "allowed_principals", allowed_principals)

    @property
    @pulumi.getter(name="allowedApplications")
    def allowed_applications(self) -> Optional[Sequence[str]]:
        """
        The configuration settings of the Azure Active Directory allowed applications.
        """
        return pulumi.get(self, "allowed_applications")

    @property
    @pulumi.getter(name="allowedPrincipals")
    def allowed_principals(self) -> Optional['outputs.AllowedPrincipalsResponse']:
        """
        The configuration settings of the Azure Active Directory allowed principals.
        """
        return pulumi.get(self, "allowed_principals")


@pulumi.output_type
class EnvironmentVarResponse(dict):
    """
    Container App container environment variable.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentVarResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentVarResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentVarResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 secret_ref: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Container App container environment variable.
        :param str name: Environment variable name.
        :param str secret_ref: Name of the Container App secret from which to pull the environment variable value.
        :param str value: Non-secret environment variable value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Environment variable name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[str]:
        """
        Name of the Container App secret from which to pull the environment variable value.
        """
        return pulumi.get(self, "secret_ref")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Non-secret environment variable value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class FacebookResponse(dict):
    """
    The configuration settings of the Facebook provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "graphApiVersion":
            suggest = "graph_api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FacebookResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FacebookResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FacebookResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 graph_api_version: Optional[str] = None,
                 login: Optional['outputs.LoginScopesResponse'] = None,
                 registration: Optional['outputs.AppRegistrationResponse'] = None):
        """
        The configuration settings of the Facebook provider.
        :param bool enabled: <code>false</code> if the Facebook provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param str graph_api_version: The version of the Facebook api to be used while logging in.
        :param 'LoginScopesResponse' login: The configuration settings of the login flow.
        :param 'AppRegistrationResponse' registration: The configuration settings of the app registration for the Facebook provider.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if graph_api_version is not None:
            pulumi.set(__self__, "graph_api_version", graph_api_version)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        <code>false</code> if the Facebook provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="graphApiVersion")
    def graph_api_version(self) -> Optional[str]:
        """
        The version of the Facebook api to be used while logging in.
        """
        return pulumi.get(self, "graph_api_version")

    @property
    @pulumi.getter
    def login(self) -> Optional['outputs.LoginScopesResponse']:
        """
        The configuration settings of the login flow.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter
    def registration(self) -> Optional['outputs.AppRegistrationResponse']:
        """
        The configuration settings of the app registration for the Facebook provider.
        """
        return pulumi.get(self, "registration")


@pulumi.output_type
class ForwardProxyResponse(dict):
    """
    The configuration settings of a forward proxy used to make the requests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customHostHeaderName":
            suggest = "custom_host_header_name"
        elif key == "customProtoHeaderName":
            suggest = "custom_proto_header_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ForwardProxyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ForwardProxyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ForwardProxyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 convention: Optional[str] = None,
                 custom_host_header_name: Optional[str] = None,
                 custom_proto_header_name: Optional[str] = None):
        """
        The configuration settings of a forward proxy used to make the requests.
        :param str convention: The convention used to determine the url of the request made.
        :param str custom_host_header_name: The name of the header containing the host of the request.
        :param str custom_proto_header_name: The name of the header containing the scheme of the request.
        """
        if convention is not None:
            pulumi.set(__self__, "convention", convention)
        if custom_host_header_name is not None:
            pulumi.set(__self__, "custom_host_header_name", custom_host_header_name)
        if custom_proto_header_name is not None:
            pulumi.set(__self__, "custom_proto_header_name", custom_proto_header_name)

    @property
    @pulumi.getter
    def convention(self) -> Optional[str]:
        """
        The convention used to determine the url of the request made.
        """
        return pulumi.get(self, "convention")

    @property
    @pulumi.getter(name="customHostHeaderName")
    def custom_host_header_name(self) -> Optional[str]:
        """
        The name of the header containing the host of the request.
        """
        return pulumi.get(self, "custom_host_header_name")

    @property
    @pulumi.getter(name="customProtoHeaderName")
    def custom_proto_header_name(self) -> Optional[str]:
        """
        The name of the header containing the scheme of the request.
        """
        return pulumi.get(self, "custom_proto_header_name")


@pulumi.output_type
class GitHubResponse(dict):
    """
    The configuration settings of the GitHub provider.
    """
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 login: Optional['outputs.LoginScopesResponse'] = None,
                 registration: Optional['outputs.ClientRegistrationResponse'] = None):
        """
        The configuration settings of the GitHub provider.
        :param bool enabled: <code>false</code> if the GitHub provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param 'LoginScopesResponse' login: The configuration settings of the login flow.
        :param 'ClientRegistrationResponse' registration: The configuration settings of the app registration for the GitHub provider.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        <code>false</code> if the GitHub provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def login(self) -> Optional['outputs.LoginScopesResponse']:
        """
        The configuration settings of the login flow.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter
    def registration(self) -> Optional['outputs.ClientRegistrationResponse']:
        """
        The configuration settings of the app registration for the GitHub provider.
        """
        return pulumi.get(self, "registration")


@pulumi.output_type
class GithubActionConfigurationResponse(dict):
    """
    Configuration properties that define the mutable settings of a Container App SourceControl
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureCredentials":
            suggest = "azure_credentials"
        elif key == "contextPath":
            suggest = "context_path"
        elif key == "publishType":
            suggest = "publish_type"
        elif key == "registryInfo":
            suggest = "registry_info"
        elif key == "runtimeStack":
            suggest = "runtime_stack"
        elif key == "runtimeVersion":
            suggest = "runtime_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GithubActionConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GithubActionConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GithubActionConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_credentials: Optional['outputs.AzureCredentialsResponse'] = None,
                 context_path: Optional[str] = None,
                 image: Optional[str] = None,
                 os: Optional[str] = None,
                 publish_type: Optional[str] = None,
                 registry_info: Optional['outputs.RegistryInfoResponse'] = None,
                 runtime_stack: Optional[str] = None,
                 runtime_version: Optional[str] = None):
        """
        Configuration properties that define the mutable settings of a Container App SourceControl
        :param 'AzureCredentialsResponse' azure_credentials: AzureCredentials configurations.
        :param str context_path: Context path
        :param str image: Image name
        :param str os: Operation system
        :param str publish_type: Code or Image
        :param 'RegistryInfoResponse' registry_info: Registry configurations.
        :param str runtime_stack: Runtime stack
        :param str runtime_version: Runtime version
        """
        if azure_credentials is not None:
            pulumi.set(__self__, "azure_credentials", azure_credentials)
        if context_path is not None:
            pulumi.set(__self__, "context_path", context_path)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if publish_type is not None:
            pulumi.set(__self__, "publish_type", publish_type)
        if registry_info is not None:
            pulumi.set(__self__, "registry_info", registry_info)
        if runtime_stack is not None:
            pulumi.set(__self__, "runtime_stack", runtime_stack)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter(name="azureCredentials")
    def azure_credentials(self) -> Optional['outputs.AzureCredentialsResponse']:
        """
        AzureCredentials configurations.
        """
        return pulumi.get(self, "azure_credentials")

    @property
    @pulumi.getter(name="contextPath")
    def context_path(self) -> Optional[str]:
        """
        Context path
        """
        return pulumi.get(self, "context_path")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Image name
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def os(self) -> Optional[str]:
        """
        Operation system
        """
        return pulumi.get(self, "os")

    @property
    @pulumi.getter(name="publishType")
    def publish_type(self) -> Optional[str]:
        """
        Code or Image
        """
        return pulumi.get(self, "publish_type")

    @property
    @pulumi.getter(name="registryInfo")
    def registry_info(self) -> Optional['outputs.RegistryInfoResponse']:
        """
        Registry configurations.
        """
        return pulumi.get(self, "registry_info")

    @property
    @pulumi.getter(name="runtimeStack")
    def runtime_stack(self) -> Optional[str]:
        """
        Runtime stack
        """
        return pulumi.get(self, "runtime_stack")

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[str]:
        """
        Runtime version
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class GlobalValidationResponse(dict):
    """
    The configuration settings that determines the validation flow of users using ContainerApp Service Authentication/Authorization.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedPaths":
            suggest = "excluded_paths"
        elif key == "redirectToProvider":
            suggest = "redirect_to_provider"
        elif key == "unauthenticatedClientAction":
            suggest = "unauthenticated_client_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalValidationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalValidationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalValidationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excluded_paths: Optional[Sequence[str]] = None,
                 redirect_to_provider: Optional[str] = None,
                 unauthenticated_client_action: Optional[str] = None):
        """
        The configuration settings that determines the validation flow of users using ContainerApp Service Authentication/Authorization.
        :param Sequence[str] excluded_paths: The paths for which unauthenticated flow would not be redirected to the login page.
        :param str redirect_to_provider: The default authentication provider to use when multiple providers are configured.
               This setting is only needed if multiple providers are configured and the unauthenticated client
               action is set to "RedirectToLoginPage".
        :param str unauthenticated_client_action: The action to take when an unauthenticated client attempts to access the app.
        """
        if excluded_paths is not None:
            pulumi.set(__self__, "excluded_paths", excluded_paths)
        if redirect_to_provider is not None:
            pulumi.set(__self__, "redirect_to_provider", redirect_to_provider)
        if unauthenticated_client_action is not None:
            pulumi.set(__self__, "unauthenticated_client_action", unauthenticated_client_action)

    @property
    @pulumi.getter(name="excludedPaths")
    def excluded_paths(self) -> Optional[Sequence[str]]:
        """
        The paths for which unauthenticated flow would not be redirected to the login page.
        """
        return pulumi.get(self, "excluded_paths")

    @property
    @pulumi.getter(name="redirectToProvider")
    def redirect_to_provider(self) -> Optional[str]:
        """
        The default authentication provider to use when multiple providers are configured.
        This setting is only needed if multiple providers are configured and the unauthenticated client
        action is set to "RedirectToLoginPage".
        """
        return pulumi.get(self, "redirect_to_provider")

    @property
    @pulumi.getter(name="unauthenticatedClientAction")
    def unauthenticated_client_action(self) -> Optional[str]:
        """
        The action to take when an unauthenticated client attempts to access the app.
        """
        return pulumi.get(self, "unauthenticated_client_action")


@pulumi.output_type
class GoogleResponse(dict):
    """
    The configuration settings of the Google provider.
    """
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 login: Optional['outputs.LoginScopesResponse'] = None,
                 registration: Optional['outputs.ClientRegistrationResponse'] = None,
                 validation: Optional['outputs.AllowedAudiencesValidationResponse'] = None):
        """
        The configuration settings of the Google provider.
        :param bool enabled: <code>false</code> if the Google provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param 'LoginScopesResponse' login: The configuration settings of the login flow.
        :param 'ClientRegistrationResponse' registration: The configuration settings of the app registration for the Google provider.
        :param 'AllowedAudiencesValidationResponse' validation: The configuration settings of the Azure Active Directory token validation flow.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)
        if validation is not None:
            pulumi.set(__self__, "validation", validation)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        <code>false</code> if the Google provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def login(self) -> Optional['outputs.LoginScopesResponse']:
        """
        The configuration settings of the login flow.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter
    def registration(self) -> Optional['outputs.ClientRegistrationResponse']:
        """
        The configuration settings of the app registration for the Google provider.
        """
        return pulumi.get(self, "registration")

    @property
    @pulumi.getter
    def validation(self) -> Optional['outputs.AllowedAudiencesValidationResponse']:
        """
        The configuration settings of the Azure Active Directory token validation flow.
        """
        return pulumi.get(self, "validation")


@pulumi.output_type
class HttpScaleRuleResponse(dict):
    """
    Container App container Custom scaling rule.
    """
    def __init__(__self__, *,
                 auth: Optional[Sequence['outputs.ScaleRuleAuthResponse']] = None,
                 metadata: Optional[Mapping[str, str]] = None):
        """
        Container App container Custom scaling rule.
        :param Sequence['ScaleRuleAuthResponse'] auth: Authentication secrets for the custom scale rule.
        :param Mapping[str, str] metadata: Metadata properties to describe http scale rule.
        """
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def auth(self) -> Optional[Sequence['outputs.ScaleRuleAuthResponse']]:
        """
        Authentication secrets for the custom scale rule.
        """
        return pulumi.get(self, "auth")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, str]]:
        """
        Metadata properties to describe http scale rule.
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class HttpSettingsResponse(dict):
    """
    The configuration settings of the HTTP requests for authentication and authorization requests made against ContainerApp Service Authentication/Authorization.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forwardProxy":
            suggest = "forward_proxy"
        elif key == "requireHttps":
            suggest = "require_https"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 forward_proxy: Optional['outputs.ForwardProxyResponse'] = None,
                 require_https: Optional[bool] = None,
                 routes: Optional['outputs.HttpSettingsRoutesResponse'] = None):
        """
        The configuration settings of the HTTP requests for authentication and authorization requests made against ContainerApp Service Authentication/Authorization.
        :param 'ForwardProxyResponse' forward_proxy: The configuration settings of a forward proxy used to make the requests.
        :param bool require_https: <code>false</code> if the authentication/authorization responses not having the HTTPS scheme are permissible; otherwise, <code>true</code>.
        :param 'HttpSettingsRoutesResponse' routes: The configuration settings of the paths HTTP requests.
        """
        if forward_proxy is not None:
            pulumi.set(__self__, "forward_proxy", forward_proxy)
        if require_https is not None:
            pulumi.set(__self__, "require_https", require_https)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter(name="forwardProxy")
    def forward_proxy(self) -> Optional['outputs.ForwardProxyResponse']:
        """
        The configuration settings of a forward proxy used to make the requests.
        """
        return pulumi.get(self, "forward_proxy")

    @property
    @pulumi.getter(name="requireHttps")
    def require_https(self) -> Optional[bool]:
        """
        <code>false</code> if the authentication/authorization responses not having the HTTPS scheme are permissible; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "require_https")

    @property
    @pulumi.getter
    def routes(self) -> Optional['outputs.HttpSettingsRoutesResponse']:
        """
        The configuration settings of the paths HTTP requests.
        """
        return pulumi.get(self, "routes")


@pulumi.output_type
class HttpSettingsRoutesResponse(dict):
    """
    The configuration settings of the paths HTTP requests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiPrefix":
            suggest = "api_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpSettingsRoutesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpSettingsRoutesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpSettingsRoutesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_prefix: Optional[str] = None):
        """
        The configuration settings of the paths HTTP requests.
        :param str api_prefix: The prefix that should precede all the authentication/authorization paths.
        """
        if api_prefix is not None:
            pulumi.set(__self__, "api_prefix", api_prefix)

    @property
    @pulumi.getter(name="apiPrefix")
    def api_prefix(self) -> Optional[str]:
        """
        The prefix that should precede all the authentication/authorization paths.
        """
        return pulumi.get(self, "api_prefix")


@pulumi.output_type
class IdentityProvidersResponse(dict):
    """
    The configuration settings of each of the identity providers used to configure ContainerApp Service Authentication/Authorization.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureActiveDirectory":
            suggest = "azure_active_directory"
        elif key == "azureStaticWebApps":
            suggest = "azure_static_web_apps"
        elif key == "customOpenIdConnectProviders":
            suggest = "custom_open_id_connect_providers"
        elif key == "gitHub":
            suggest = "git_hub"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityProvidersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityProvidersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityProvidersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apple: Optional['outputs.AppleResponse'] = None,
                 azure_active_directory: Optional['outputs.AzureActiveDirectoryResponse'] = None,
                 azure_static_web_apps: Optional['outputs.AzureStaticWebAppsResponse'] = None,
                 custom_open_id_connect_providers: Optional[Mapping[str, 'outputs.CustomOpenIdConnectProviderResponse']] = None,
                 facebook: Optional['outputs.FacebookResponse'] = None,
                 git_hub: Optional['outputs.GitHubResponse'] = None,
                 google: Optional['outputs.GoogleResponse'] = None,
                 twitter: Optional['outputs.TwitterResponse'] = None):
        """
        The configuration settings of each of the identity providers used to configure ContainerApp Service Authentication/Authorization.
        :param 'AppleResponse' apple: The configuration settings of the Apple provider.
        :param 'AzureActiveDirectoryResponse' azure_active_directory: The configuration settings of the Azure Active directory provider.
        :param 'AzureStaticWebAppsResponse' azure_static_web_apps: The configuration settings of the Azure Static Web Apps provider.
        :param Mapping[str, 'CustomOpenIdConnectProviderResponse'] custom_open_id_connect_providers: The map of the name of the alias of each custom Open ID Connect provider to the
               configuration settings of the custom Open ID Connect provider.
        :param 'FacebookResponse' facebook: The configuration settings of the Facebook provider.
        :param 'GitHubResponse' git_hub: The configuration settings of the GitHub provider.
        :param 'GoogleResponse' google: The configuration settings of the Google provider.
        :param 'TwitterResponse' twitter: The configuration settings of the Twitter provider.
        """
        if apple is not None:
            pulumi.set(__self__, "apple", apple)
        if azure_active_directory is not None:
            pulumi.set(__self__, "azure_active_directory", azure_active_directory)
        if azure_static_web_apps is not None:
            pulumi.set(__self__, "azure_static_web_apps", azure_static_web_apps)
        if custom_open_id_connect_providers is not None:
            pulumi.set(__self__, "custom_open_id_connect_providers", custom_open_id_connect_providers)
        if facebook is not None:
            pulumi.set(__self__, "facebook", facebook)
        if git_hub is not None:
            pulumi.set(__self__, "git_hub", git_hub)
        if google is not None:
            pulumi.set(__self__, "google", google)
        if twitter is not None:
            pulumi.set(__self__, "twitter", twitter)

    @property
    @pulumi.getter
    def apple(self) -> Optional['outputs.AppleResponse']:
        """
        The configuration settings of the Apple provider.
        """
        return pulumi.get(self, "apple")

    @property
    @pulumi.getter(name="azureActiveDirectory")
    def azure_active_directory(self) -> Optional['outputs.AzureActiveDirectoryResponse']:
        """
        The configuration settings of the Azure Active directory provider.
        """
        return pulumi.get(self, "azure_active_directory")

    @property
    @pulumi.getter(name="azureStaticWebApps")
    def azure_static_web_apps(self) -> Optional['outputs.AzureStaticWebAppsResponse']:
        """
        The configuration settings of the Azure Static Web Apps provider.
        """
        return pulumi.get(self, "azure_static_web_apps")

    @property
    @pulumi.getter(name="customOpenIdConnectProviders")
    def custom_open_id_connect_providers(self) -> Optional[Mapping[str, 'outputs.CustomOpenIdConnectProviderResponse']]:
        """
        The map of the name of the alias of each custom Open ID Connect provider to the
        configuration settings of the custom Open ID Connect provider.
        """
        return pulumi.get(self, "custom_open_id_connect_providers")

    @property
    @pulumi.getter
    def facebook(self) -> Optional['outputs.FacebookResponse']:
        """
        The configuration settings of the Facebook provider.
        """
        return pulumi.get(self, "facebook")

    @property
    @pulumi.getter(name="gitHub")
    def git_hub(self) -> Optional['outputs.GitHubResponse']:
        """
        The configuration settings of the GitHub provider.
        """
        return pulumi.get(self, "git_hub")

    @property
    @pulumi.getter
    def google(self) -> Optional['outputs.GoogleResponse']:
        """
        The configuration settings of the Google provider.
        """
        return pulumi.get(self, "google")

    @property
    @pulumi.getter
    def twitter(self) -> Optional['outputs.TwitterResponse']:
        """
        The configuration settings of the Twitter provider.
        """
        return pulumi.get(self, "twitter")


@pulumi.output_type
class IngressResponse(dict):
    """
    Container App Ingress configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowInsecure":
            suggest = "allow_insecure"
        elif key == "customDomains":
            suggest = "custom_domains"
        elif key == "targetPort":
            suggest = "target_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: str,
                 allow_insecure: Optional[bool] = None,
                 custom_domains: Optional[Sequence['outputs.CustomDomainResponse']] = None,
                 external: Optional[bool] = None,
                 target_port: Optional[int] = None,
                 traffic: Optional[Sequence['outputs.TrafficWeightResponse']] = None,
                 transport: Optional[str] = None):
        """
        Container App Ingress configuration.
        :param str fqdn: Hostname.
        :param bool allow_insecure: Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS connections
        :param Sequence['CustomDomainResponse'] custom_domains: custom domain bindings for Container Apps' hostnames.
        :param bool external: Bool indicating if app exposes an external http endpoint
        :param int target_port: Target Port in containers for traffic from ingress
        :param Sequence['TrafficWeightResponse'] traffic: Traffic weights for app's revisions
        :param str transport: Ingress transport protocol
        """
        pulumi.set(__self__, "fqdn", fqdn)
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if custom_domains is not None:
            pulumi.set(__self__, "custom_domains", custom_domains)
        if external is None:
            external = False
        if external is not None:
            pulumi.set(__self__, "external", external)
        if target_port is not None:
            pulumi.set(__self__, "target_port", target_port)
        if traffic is not None:
            pulumi.set(__self__, "traffic", traffic)
        if transport is not None:
            pulumi.set(__self__, "transport", transport)

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        Hostname.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[bool]:
        """
        Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS connections
        """
        return pulumi.get(self, "allow_insecure")

    @property
    @pulumi.getter(name="customDomains")
    def custom_domains(self) -> Optional[Sequence['outputs.CustomDomainResponse']]:
        """
        custom domain bindings for Container Apps' hostnames.
        """
        return pulumi.get(self, "custom_domains")

    @property
    @pulumi.getter
    def external(self) -> Optional[bool]:
        """
        Bool indicating if app exposes an external http endpoint
        """
        return pulumi.get(self, "external")

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> Optional[int]:
        """
        Target Port in containers for traffic from ingress
        """
        return pulumi.get(self, "target_port")

    @property
    @pulumi.getter
    def traffic(self) -> Optional[Sequence['outputs.TrafficWeightResponse']]:
        """
        Traffic weights for app's revisions
        """
        return pulumi.get(self, "traffic")

    @property
    @pulumi.getter
    def transport(self) -> Optional[str]:
        """
        Ingress transport protocol
        """
        return pulumi.get(self, "transport")


@pulumi.output_type
class JwtClaimChecksResponse(dict):
    """
    The configuration settings of the checks that should be made while validating the JWT Claims.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedClientApplications":
            suggest = "allowed_client_applications"
        elif key == "allowedGroups":
            suggest = "allowed_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JwtClaimChecksResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JwtClaimChecksResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JwtClaimChecksResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_client_applications: Optional[Sequence[str]] = None,
                 allowed_groups: Optional[Sequence[str]] = None):
        """
        The configuration settings of the checks that should be made while validating the JWT Claims.
        :param Sequence[str] allowed_client_applications: The list of the allowed client applications.
        :param Sequence[str] allowed_groups: The list of the allowed groups.
        """
        if allowed_client_applications is not None:
            pulumi.set(__self__, "allowed_client_applications", allowed_client_applications)
        if allowed_groups is not None:
            pulumi.set(__self__, "allowed_groups", allowed_groups)

    @property
    @pulumi.getter(name="allowedClientApplications")
    def allowed_client_applications(self) -> Optional[Sequence[str]]:
        """
        The list of the allowed client applications.
        """
        return pulumi.get(self, "allowed_client_applications")

    @property
    @pulumi.getter(name="allowedGroups")
    def allowed_groups(self) -> Optional[Sequence[str]]:
        """
        The list of the allowed groups.
        """
        return pulumi.get(self, "allowed_groups")


@pulumi.output_type
class LogAnalyticsConfigurationResponse(dict):
    """
    Log analytics configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerId":
            suggest = "customer_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogAnalyticsConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogAnalyticsConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogAnalyticsConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_id: Optional[str] = None):
        """
        Log analytics configuration
        :param str customer_id: Log analytics customer id
        """
        if customer_id is not None:
            pulumi.set(__self__, "customer_id", customer_id)

    @property
    @pulumi.getter(name="customerId")
    def customer_id(self) -> Optional[str]:
        """
        Log analytics customer id
        """
        return pulumi.get(self, "customer_id")


@pulumi.output_type
class LoginResponse(dict):
    """
    The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedExternalRedirectUrls":
            suggest = "allowed_external_redirect_urls"
        elif key == "cookieExpiration":
            suggest = "cookie_expiration"
        elif key == "preserveUrlFragmentsForLogins":
            suggest = "preserve_url_fragments_for_logins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoginResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoginResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoginResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_external_redirect_urls: Optional[Sequence[str]] = None,
                 cookie_expiration: Optional['outputs.CookieExpirationResponse'] = None,
                 nonce: Optional['outputs.NonceResponse'] = None,
                 preserve_url_fragments_for_logins: Optional[bool] = None,
                 routes: Optional['outputs.LoginRoutesResponse'] = None):
        """
        The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization.
        :param Sequence[str] allowed_external_redirect_urls: External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
               This is an advanced setting typically only needed by Windows Store application backends.
               Note that URLs within the current domain are always implicitly allowed.
        :param 'CookieExpirationResponse' cookie_expiration: The configuration settings of the session cookie's expiration.
        :param 'NonceResponse' nonce: The configuration settings of the nonce used in the login flow.
        :param bool preserve_url_fragments_for_logins: <code>true</code> if the fragments from the request are preserved after the login request is made; otherwise, <code>false</code>.
        :param 'LoginRoutesResponse' routes: The routes that specify the endpoints used for login and logout requests.
        """
        if allowed_external_redirect_urls is not None:
            pulumi.set(__self__, "allowed_external_redirect_urls", allowed_external_redirect_urls)
        if cookie_expiration is not None:
            pulumi.set(__self__, "cookie_expiration", cookie_expiration)
        if nonce is not None:
            pulumi.set(__self__, "nonce", nonce)
        if preserve_url_fragments_for_logins is not None:
            pulumi.set(__self__, "preserve_url_fragments_for_logins", preserve_url_fragments_for_logins)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter(name="allowedExternalRedirectUrls")
    def allowed_external_redirect_urls(self) -> Optional[Sequence[str]]:
        """
        External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
        This is an advanced setting typically only needed by Windows Store application backends.
        Note that URLs within the current domain are always implicitly allowed.
        """
        return pulumi.get(self, "allowed_external_redirect_urls")

    @property
    @pulumi.getter(name="cookieExpiration")
    def cookie_expiration(self) -> Optional['outputs.CookieExpirationResponse']:
        """
        The configuration settings of the session cookie's expiration.
        """
        return pulumi.get(self, "cookie_expiration")

    @property
    @pulumi.getter
    def nonce(self) -> Optional['outputs.NonceResponse']:
        """
        The configuration settings of the nonce used in the login flow.
        """
        return pulumi.get(self, "nonce")

    @property
    @pulumi.getter(name="preserveUrlFragmentsForLogins")
    def preserve_url_fragments_for_logins(self) -> Optional[bool]:
        """
        <code>true</code> if the fragments from the request are preserved after the login request is made; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "preserve_url_fragments_for_logins")

    @property
    @pulumi.getter
    def routes(self) -> Optional['outputs.LoginRoutesResponse']:
        """
        The routes that specify the endpoints used for login and logout requests.
        """
        return pulumi.get(self, "routes")


@pulumi.output_type
class LoginRoutesResponse(dict):
    """
    The routes that specify the endpoints used for login and logout requests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logoutEndpoint":
            suggest = "logout_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoginRoutesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoginRoutesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoginRoutesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 logout_endpoint: Optional[str] = None):
        """
        The routes that specify the endpoints used for login and logout requests.
        :param str logout_endpoint: The endpoint at which a logout request should be made.
        """
        if logout_endpoint is not None:
            pulumi.set(__self__, "logout_endpoint", logout_endpoint)

    @property
    @pulumi.getter(name="logoutEndpoint")
    def logout_endpoint(self) -> Optional[str]:
        """
        The endpoint at which a logout request should be made.
        """
        return pulumi.get(self, "logout_endpoint")


@pulumi.output_type
class LoginScopesResponse(dict):
    """
    The configuration settings of the login flow, including the scopes that should be requested.
    """
    def __init__(__self__, *,
                 scopes: Optional[Sequence[str]] = None):
        """
        The configuration settings of the login flow, including the scopes that should be requested.
        :param Sequence[str] scopes: A list of the scopes that should be requested while authenticating.
        """
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        A list of the scopes that should be requested while authenticating.
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class ManagedEnvironmentStorageResponseProperties(dict):
    """
    Storage properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureFile":
            suggest = "azure_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedEnvironmentStorageResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedEnvironmentStorageResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedEnvironmentStorageResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_file: Optional['outputs.AzureFilePropertiesResponse'] = None):
        """
        Storage properties
        :param 'AzureFilePropertiesResponse' azure_file: Azure file properties
        """
        if azure_file is not None:
            pulumi.set(__self__, "azure_file", azure_file)

    @property
    @pulumi.getter(name="azureFile")
    def azure_file(self) -> Optional['outputs.AzureFilePropertiesResponse']:
        """
        Azure file properties
        """
        return pulumi.get(self, "azure_file")


@pulumi.output_type
class ManagedServiceIdentityResponse(dict):
    """
    Managed service identity (system assigned and/or user assigned identities)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedServiceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedServiceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedServiceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']] = None):
        """
        Managed service identity (system assigned and/or user assigned identities)
        :param str principal_id: The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
        :param str tenant_id: The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
        :param str type: Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        :param Mapping[str, 'UserAssignedIdentityResponse'] user_assigned_identities: The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']]:
        """
        The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class NonceResponse(dict):
    """
    The configuration settings of the nonce used in the login flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nonceExpirationInterval":
            suggest = "nonce_expiration_interval"
        elif key == "validateNonce":
            suggest = "validate_nonce"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NonceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NonceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NonceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 nonce_expiration_interval: Optional[str] = None,
                 validate_nonce: Optional[bool] = None):
        """
        The configuration settings of the nonce used in the login flow.
        :param str nonce_expiration_interval: The time after the request is made when the nonce should expire.
        :param bool validate_nonce: <code>false</code> if the nonce should not be validated while completing the login flow; otherwise, <code>true</code>.
        """
        if nonce_expiration_interval is not None:
            pulumi.set(__self__, "nonce_expiration_interval", nonce_expiration_interval)
        if validate_nonce is not None:
            pulumi.set(__self__, "validate_nonce", validate_nonce)

    @property
    @pulumi.getter(name="nonceExpirationInterval")
    def nonce_expiration_interval(self) -> Optional[str]:
        """
        The time after the request is made when the nonce should expire.
        """
        return pulumi.get(self, "nonce_expiration_interval")

    @property
    @pulumi.getter(name="validateNonce")
    def validate_nonce(self) -> Optional[bool]:
        """
        <code>false</code> if the nonce should not be validated while completing the login flow; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "validate_nonce")


@pulumi.output_type
class OpenIdConnectClientCredentialResponse(dict):
    """
    The authentication client credentials of the custom Open ID Connect provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientSecretSettingName":
            suggest = "client_secret_setting_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpenIdConnectClientCredentialResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpenIdConnectClientCredentialResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpenIdConnectClientCredentialResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_secret_setting_name: Optional[str] = None,
                 method: Optional[str] = None):
        """
        The authentication client credentials of the custom Open ID Connect provider.
        :param str client_secret_setting_name: The app setting that contains the client secret for the custom Open ID Connect provider.
        :param str method: The method that should be used to authenticate the user.
        """
        if client_secret_setting_name is not None:
            pulumi.set(__self__, "client_secret_setting_name", client_secret_setting_name)
        if method is not None:
            pulumi.set(__self__, "method", method)

    @property
    @pulumi.getter(name="clientSecretSettingName")
    def client_secret_setting_name(self) -> Optional[str]:
        """
        The app setting that contains the client secret for the custom Open ID Connect provider.
        """
        return pulumi.get(self, "client_secret_setting_name")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        The method that should be used to authenticate the user.
        """
        return pulumi.get(self, "method")


@pulumi.output_type
class OpenIdConnectConfigResponse(dict):
    """
    The configuration settings of the endpoints used for the custom Open ID Connect provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "certificationUri":
            suggest = "certification_uri"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"
        elif key == "wellKnownOpenIdConfiguration":
            suggest = "well_known_open_id_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpenIdConnectConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpenIdConnectConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpenIdConnectConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_endpoint: Optional[str] = None,
                 certification_uri: Optional[str] = None,
                 issuer: Optional[str] = None,
                 token_endpoint: Optional[str] = None,
                 well_known_open_id_configuration: Optional[str] = None):
        """
        The configuration settings of the endpoints used for the custom Open ID Connect provider.
        :param str authorization_endpoint: The endpoint to be used to make an authorization request.
        :param str certification_uri: The endpoint that provides the keys necessary to validate the token.
        :param str issuer: The endpoint that issues the token.
        :param str token_endpoint: The endpoint to be used to request a token.
        :param str well_known_open_id_configuration: The endpoint that contains all the configuration endpoints for the provider.
        """
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if certification_uri is not None:
            pulumi.set(__self__, "certification_uri", certification_uri)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if well_known_open_id_configuration is not None:
            pulumi.set(__self__, "well_known_open_id_configuration", well_known_open_id_configuration)

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[str]:
        """
        The endpoint to be used to make an authorization request.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="certificationUri")
    def certification_uri(self) -> Optional[str]:
        """
        The endpoint that provides the keys necessary to validate the token.
        """
        return pulumi.get(self, "certification_uri")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[str]:
        """
        The endpoint that issues the token.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[str]:
        """
        The endpoint to be used to request a token.
        """
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter(name="wellKnownOpenIdConfiguration")
    def well_known_open_id_configuration(self) -> Optional[str]:
        """
        The endpoint that contains all the configuration endpoints for the provider.
        """
        return pulumi.get(self, "well_known_open_id_configuration")


@pulumi.output_type
class OpenIdConnectLoginResponse(dict):
    """
    The configuration settings of the login flow of the custom Open ID Connect provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nameClaimType":
            suggest = "name_claim_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpenIdConnectLoginResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpenIdConnectLoginResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpenIdConnectLoginResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name_claim_type: Optional[str] = None,
                 scopes: Optional[Sequence[str]] = None):
        """
        The configuration settings of the login flow of the custom Open ID Connect provider.
        :param str name_claim_type: The name of the claim that contains the users name.
        :param Sequence[str] scopes: A list of the scopes that should be requested while authenticating.
        """
        if name_claim_type is not None:
            pulumi.set(__self__, "name_claim_type", name_claim_type)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter(name="nameClaimType")
    def name_claim_type(self) -> Optional[str]:
        """
        The name of the claim that contains the users name.
        """
        return pulumi.get(self, "name_claim_type")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        A list of the scopes that should be requested while authenticating.
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class OpenIdConnectRegistrationResponse(dict):
    """
    The configuration settings of the app registration for the custom Open ID Connect provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCredential":
            suggest = "client_credential"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "openIdConnectConfiguration":
            suggest = "open_id_connect_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpenIdConnectRegistrationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpenIdConnectRegistrationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpenIdConnectRegistrationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_credential: Optional['outputs.OpenIdConnectClientCredentialResponse'] = None,
                 client_id: Optional[str] = None,
                 open_id_connect_configuration: Optional['outputs.OpenIdConnectConfigResponse'] = None):
        """
        The configuration settings of the app registration for the custom Open ID Connect provider.
        :param 'OpenIdConnectClientCredentialResponse' client_credential: The authentication credentials of the custom Open ID Connect provider.
        :param str client_id: The client id of the custom Open ID Connect provider.
        :param 'OpenIdConnectConfigResponse' open_id_connect_configuration: The configuration settings of the endpoints used for the custom Open ID Connect provider.
        """
        if client_credential is not None:
            pulumi.set(__self__, "client_credential", client_credential)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if open_id_connect_configuration is not None:
            pulumi.set(__self__, "open_id_connect_configuration", open_id_connect_configuration)

    @property
    @pulumi.getter(name="clientCredential")
    def client_credential(self) -> Optional['outputs.OpenIdConnectClientCredentialResponse']:
        """
        The authentication credentials of the custom Open ID Connect provider.
        """
        return pulumi.get(self, "client_credential")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The client id of the custom Open ID Connect provider.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="openIdConnectConfiguration")
    def open_id_connect_configuration(self) -> Optional['outputs.OpenIdConnectConfigResponse']:
        """
        The configuration settings of the endpoints used for the custom Open ID Connect provider.
        """
        return pulumi.get(self, "open_id_connect_configuration")


@pulumi.output_type
class QueueScaleRuleResponse(dict):
    """
    Container App container Azure Queue based scaling rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueLength":
            suggest = "queue_length"
        elif key == "queueName":
            suggest = "queue_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueueScaleRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueueScaleRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueueScaleRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth: Optional[Sequence['outputs.ScaleRuleAuthResponse']] = None,
                 queue_length: Optional[int] = None,
                 queue_name: Optional[str] = None):
        """
        Container App container Azure Queue based scaling rule.
        :param Sequence['ScaleRuleAuthResponse'] auth: Authentication secrets for the queue scale rule.
        :param int queue_length: Queue length.
        :param str queue_name: Queue name.
        """
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if queue_length is not None:
            pulumi.set(__self__, "queue_length", queue_length)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)

    @property
    @pulumi.getter
    def auth(self) -> Optional[Sequence['outputs.ScaleRuleAuthResponse']]:
        """
        Authentication secrets for the queue scale rule.
        """
        return pulumi.get(self, "auth")

    @property
    @pulumi.getter(name="queueLength")
    def queue_length(self) -> Optional[int]:
        """
        Queue length.
        """
        return pulumi.get(self, "queue_length")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[str]:
        """
        Queue name.
        """
        return pulumi.get(self, "queue_name")


@pulumi.output_type
class RegistryCredentialsResponse(dict):
    """
    Container App Private Registry
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordSecretRef":
            suggest = "password_secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistryCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistryCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistryCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity: Optional[str] = None,
                 password_secret_ref: Optional[str] = None,
                 server: Optional[str] = None,
                 username: Optional[str] = None):
        """
        Container App Private Registry
        :param str identity: A Managed Identity to use to authenticate with Azure Container Registry. For user-assigned identities, use the full user-assigned identity Resource ID. For system-assigned identities, use 'system'
        :param str password_secret_ref: The name of the Secret that contains the registry login password
        :param str server: Container Registry Server
        :param str username: Container Registry Username
        """
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if password_secret_ref is not None:
            pulumi.set(__self__, "password_secret_ref", password_secret_ref)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def identity(self) -> Optional[str]:
        """
        A Managed Identity to use to authenticate with Azure Container Registry. For user-assigned identities, use the full user-assigned identity Resource ID. For system-assigned identities, use 'system'
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="passwordSecretRef")
    def password_secret_ref(self) -> Optional[str]:
        """
        The name of the Secret that contains the registry login password
        """
        return pulumi.get(self, "password_secret_ref")

    @property
    @pulumi.getter
    def server(self) -> Optional[str]:
        """
        Container Registry Server
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Container Registry Username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class RegistryInfoResponse(dict):
    """
    Container App registry information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryUrl":
            suggest = "registry_url"
        elif key == "registryUserName":
            suggest = "registry_user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistryInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistryInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistryInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registry_url: Optional[str] = None,
                 registry_user_name: Optional[str] = None):
        """
        Container App registry information.
        :param str registry_url: registry server Url.
        :param str registry_user_name: registry username.
        """
        if registry_url is not None:
            pulumi.set(__self__, "registry_url", registry_url)
        if registry_user_name is not None:
            pulumi.set(__self__, "registry_user_name", registry_user_name)

    @property
    @pulumi.getter(name="registryUrl")
    def registry_url(self) -> Optional[str]:
        """
        registry server Url.
        """
        return pulumi.get(self, "registry_url")

    @property
    @pulumi.getter(name="registryUserName")
    def registry_user_name(self) -> Optional[str]:
        """
        registry username.
        """
        return pulumi.get(self, "registry_user_name")


@pulumi.output_type
class ScaleResponse(dict):
    """
    Container App scaling configurations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReplicas":
            suggest = "max_replicas"
        elif key == "minReplicas":
            suggest = "min_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_replicas: Optional[int] = None,
                 min_replicas: Optional[int] = None,
                 rules: Optional[Sequence['outputs.ScaleRuleResponse']] = None):
        """
        Container App scaling configurations.
        :param int max_replicas: Optional. Maximum number of container replicas. Defaults to 10 if not set.
        :param int min_replicas: Optional. Minimum number of container replicas.
        :param Sequence['ScaleRuleResponse'] rules: Scaling rules.
        """
        if max_replicas is not None:
            pulumi.set(__self__, "max_replicas", max_replicas)
        if min_replicas is not None:
            pulumi.set(__self__, "min_replicas", min_replicas)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> Optional[int]:
        """
        Optional. Maximum number of container replicas. Defaults to 10 if not set.
        """
        return pulumi.get(self, "max_replicas")

    @property
    @pulumi.getter(name="minReplicas")
    def min_replicas(self) -> Optional[int]:
        """
        Optional. Minimum number of container replicas.
        """
        return pulumi.get(self, "min_replicas")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.ScaleRuleResponse']]:
        """
        Scaling rules.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class ScaleRuleAuthResponse(dict):
    """
    Auth Secrets for Container App Scale Rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretRef":
            suggest = "secret_ref"
        elif key == "triggerParameter":
            suggest = "trigger_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleRuleAuthResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleRuleAuthResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleRuleAuthResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_ref: Optional[str] = None,
                 trigger_parameter: Optional[str] = None):
        """
        Auth Secrets for Container App Scale Rule
        :param str secret_ref: Name of the Container App secret from which to pull the auth params.
        :param str trigger_parameter: Trigger Parameter that uses the secret
        """
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if trigger_parameter is not None:
            pulumi.set(__self__, "trigger_parameter", trigger_parameter)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[str]:
        """
        Name of the Container App secret from which to pull the auth params.
        """
        return pulumi.get(self, "secret_ref")

    @property
    @pulumi.getter(name="triggerParameter")
    def trigger_parameter(self) -> Optional[str]:
        """
        Trigger Parameter that uses the secret
        """
        return pulumi.get(self, "trigger_parameter")


@pulumi.output_type
class ScaleRuleResponse(dict):
    """
    Container App container scaling rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureQueue":
            suggest = "azure_queue"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_queue: Optional['outputs.QueueScaleRuleResponse'] = None,
                 custom: Optional['outputs.CustomScaleRuleResponse'] = None,
                 http: Optional['outputs.HttpScaleRuleResponse'] = None,
                 name: Optional[str] = None):
        """
        Container App container scaling rule.
        :param 'QueueScaleRuleResponse' azure_queue: Azure Queue based scaling.
        :param 'CustomScaleRuleResponse' custom: Custom scale rule.
        :param 'HttpScaleRuleResponse' http: HTTP requests based scaling.
        :param str name: Scale Rule Name
        """
        if azure_queue is not None:
            pulumi.set(__self__, "azure_queue", azure_queue)
        if custom is not None:
            pulumi.set(__self__, "custom", custom)
        if http is not None:
            pulumi.set(__self__, "http", http)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="azureQueue")
    def azure_queue(self) -> Optional['outputs.QueueScaleRuleResponse']:
        """
        Azure Queue based scaling.
        """
        return pulumi.get(self, "azure_queue")

    @property
    @pulumi.getter
    def custom(self) -> Optional['outputs.CustomScaleRuleResponse']:
        """
        Custom scale rule.
        """
        return pulumi.get(self, "custom")

    @property
    @pulumi.getter
    def http(self) -> Optional['outputs.HttpScaleRuleResponse']:
        """
        HTTP requests based scaling.
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Scale Rule Name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SecretResponse(dict):
    """
    Secret definition.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Secret definition.
        :param str name: Secret Name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Secret Name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TemplateResponse(dict):
    """
    Container App versioned application definition.
    Defines the desired state of an immutable revision.
    Any changes to this section Will result in a new revision being created
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "revisionSuffix":
            suggest = "revision_suffix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemplateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemplateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemplateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 containers: Optional[Sequence['outputs.ContainerResponse']] = None,
                 revision_suffix: Optional[str] = None,
                 scale: Optional['outputs.ScaleResponse'] = None,
                 volumes: Optional[Sequence['outputs.VolumeResponse']] = None):
        """
        Container App versioned application definition.
        Defines the desired state of an immutable revision.
        Any changes to this section Will result in a new revision being created
        :param Sequence['ContainerResponse'] containers: List of container definitions for the Container App.
        :param str revision_suffix: User friendly suffix that is appended to the revision name
        :param 'ScaleResponse' scale: Scaling properties for the Container App.
        :param Sequence['VolumeResponse'] volumes: List of volume definitions for the Container App.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if revision_suffix is not None:
            pulumi.set(__self__, "revision_suffix", revision_suffix)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def containers(self) -> Optional[Sequence['outputs.ContainerResponse']]:
        """
        List of container definitions for the Container App.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="revisionSuffix")
    def revision_suffix(self) -> Optional[str]:
        """
        User friendly suffix that is appended to the revision name
        """
        return pulumi.get(self, "revision_suffix")

    @property
    @pulumi.getter
    def scale(self) -> Optional['outputs.ScaleResponse']:
        """
        Scaling properties for the Container App.
        """
        return pulumi.get(self, "scale")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.VolumeResponse']]:
        """
        List of volume definitions for the Container App.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class TrafficWeightResponse(dict):
    """
    Traffic weight assigned to a revision
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latestRevision":
            suggest = "latest_revision"
        elif key == "revisionName":
            suggest = "revision_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrafficWeightResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrafficWeightResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrafficWeightResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: Optional[str] = None,
                 latest_revision: Optional[bool] = None,
                 revision_name: Optional[str] = None,
                 weight: Optional[int] = None):
        """
        Traffic weight assigned to a revision
        :param str label: Associates a traffic label with a revision
        :param bool latest_revision: Indicates that the traffic weight belongs to a latest stable revision
        :param str revision_name: Name of a revision
        :param int weight: Traffic weight assigned to a revision
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if latest_revision is None:
            latest_revision = False
        if latest_revision is not None:
            pulumi.set(__self__, "latest_revision", latest_revision)
        if revision_name is not None:
            pulumi.set(__self__, "revision_name", revision_name)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        Associates a traffic label with a revision
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> Optional[bool]:
        """
        Indicates that the traffic weight belongs to a latest stable revision
        """
        return pulumi.get(self, "latest_revision")

    @property
    @pulumi.getter(name="revisionName")
    def revision_name(self) -> Optional[str]:
        """
        Name of a revision
        """
        return pulumi.get(self, "revision_name")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        Traffic weight assigned to a revision
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class TwitterRegistrationResponse(dict):
    """
    The configuration settings of the app registration for the Twitter provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerKey":
            suggest = "consumer_key"
        elif key == "consumerSecretSettingName":
            suggest = "consumer_secret_setting_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TwitterRegistrationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TwitterRegistrationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TwitterRegistrationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_key: Optional[str] = None,
                 consumer_secret_setting_name: Optional[str] = None):
        """
        The configuration settings of the app registration for the Twitter provider.
        :param str consumer_key: The OAuth 1.0a consumer key of the Twitter application used for sign-in.
               This setting is required for enabling Twitter Sign-In.
               Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
        :param str consumer_secret_setting_name: The app setting name that contains the OAuth 1.0a consumer secret of the Twitter
               application used for sign-in.
        """
        if consumer_key is not None:
            pulumi.set(__self__, "consumer_key", consumer_key)
        if consumer_secret_setting_name is not None:
            pulumi.set(__self__, "consumer_secret_setting_name", consumer_secret_setting_name)

    @property
    @pulumi.getter(name="consumerKey")
    def consumer_key(self) -> Optional[str]:
        """
        The OAuth 1.0a consumer key of the Twitter application used for sign-in.
        This setting is required for enabling Twitter Sign-In.
        Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
        """
        return pulumi.get(self, "consumer_key")

    @property
    @pulumi.getter(name="consumerSecretSettingName")
    def consumer_secret_setting_name(self) -> Optional[str]:
        """
        The app setting name that contains the OAuth 1.0a consumer secret of the Twitter
        application used for sign-in.
        """
        return pulumi.get(self, "consumer_secret_setting_name")


@pulumi.output_type
class TwitterResponse(dict):
    """
    The configuration settings of the Twitter provider.
    """
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 registration: Optional['outputs.TwitterRegistrationResponse'] = None):
        """
        The configuration settings of the Twitter provider.
        :param bool enabled: <code>false</code> if the Twitter provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param 'TwitterRegistrationResponse' registration: The configuration settings of the app registration for the Twitter provider.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        <code>false</code> if the Twitter provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def registration(self) -> Optional['outputs.TwitterRegistrationResponse']:
        """
        The configuration settings of the app registration for the Twitter provider.
        """
        return pulumi.get(self, "registration")


@pulumi.output_type
class UserAssignedIdentityResponse(dict):
    """
    User assigned identity properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        User assigned identity properties
        :param str client_id: The client ID of the assigned identity.
        :param str principal_id: The principal ID of the assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID of the assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of the assigned identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class VnetConfigurationResponse(dict):
    """
    Configuration properties for apps environment to join a Virtual Network
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dockerBridgeCidr":
            suggest = "docker_bridge_cidr"
        elif key == "infrastructureSubnetId":
            suggest = "infrastructure_subnet_id"
        elif key == "platformReservedCidr":
            suggest = "platform_reserved_cidr"
        elif key == "platformReservedDnsIP":
            suggest = "platform_reserved_dns_ip"
        elif key == "runtimeSubnetId":
            suggest = "runtime_subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VnetConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VnetConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VnetConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 docker_bridge_cidr: Optional[str] = None,
                 infrastructure_subnet_id: Optional[str] = None,
                 internal: Optional[bool] = None,
                 platform_reserved_cidr: Optional[str] = None,
                 platform_reserved_dns_ip: Optional[str] = None,
                 runtime_subnet_id: Optional[str] = None):
        """
        Configuration properties for apps environment to join a Virtual Network
        :param str docker_bridge_cidr: CIDR notation IP range assigned to the Docker bridge, network. Must not overlap with any other provided IP ranges.
        :param str infrastructure_subnet_id: Resource ID of a subnet for infrastructure components. This subnet must be in the same VNET as the subnet defined in runtimeSubnetId. Must not overlap with any other provided IP ranges.
        :param bool internal: Boolean indicating the environment only has an internal load balancer. These environments do not have a public static IP resource. They must provide runtimeSubnetId and infrastructureSubnetId if enabling this property
        :param str platform_reserved_cidr: IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. Must not overlap with any other provided IP ranges.
        :param str platform_reserved_dns_ip:  An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server.
        :param str runtime_subnet_id: Resource ID of a subnet that Container App containers are injected into. This subnet must be in the same VNET as the subnet defined in infrastructureSubnetId. Must not overlap with any other provided IP ranges.
        """
        if docker_bridge_cidr is not None:
            pulumi.set(__self__, "docker_bridge_cidr", docker_bridge_cidr)
        if infrastructure_subnet_id is not None:
            pulumi.set(__self__, "infrastructure_subnet_id", infrastructure_subnet_id)
        if internal is not None:
            pulumi.set(__self__, "internal", internal)
        if platform_reserved_cidr is not None:
            pulumi.set(__self__, "platform_reserved_cidr", platform_reserved_cidr)
        if platform_reserved_dns_ip is not None:
            pulumi.set(__self__, "platform_reserved_dns_ip", platform_reserved_dns_ip)
        if runtime_subnet_id is not None:
            pulumi.set(__self__, "runtime_subnet_id", runtime_subnet_id)

    @property
    @pulumi.getter(name="dockerBridgeCidr")
    def docker_bridge_cidr(self) -> Optional[str]:
        """
        CIDR notation IP range assigned to the Docker bridge, network. Must not overlap with any other provided IP ranges.
        """
        return pulumi.get(self, "docker_bridge_cidr")

    @property
    @pulumi.getter(name="infrastructureSubnetId")
    def infrastructure_subnet_id(self) -> Optional[str]:
        """
        Resource ID of a subnet for infrastructure components. This subnet must be in the same VNET as the subnet defined in runtimeSubnetId. Must not overlap with any other provided IP ranges.
        """
        return pulumi.get(self, "infrastructure_subnet_id")

    @property
    @pulumi.getter
    def internal(self) -> Optional[bool]:
        """
        Boolean indicating the environment only has an internal load balancer. These environments do not have a public static IP resource. They must provide runtimeSubnetId and infrastructureSubnetId if enabling this property
        """
        return pulumi.get(self, "internal")

    @property
    @pulumi.getter(name="platformReservedCidr")
    def platform_reserved_cidr(self) -> Optional[str]:
        """
        IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. Must not overlap with any other provided IP ranges.
        """
        return pulumi.get(self, "platform_reserved_cidr")

    @property
    @pulumi.getter(name="platformReservedDnsIP")
    def platform_reserved_dns_ip(self) -> Optional[str]:
        """
         An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server.
        """
        return pulumi.get(self, "platform_reserved_dns_ip")

    @property
    @pulumi.getter(name="runtimeSubnetId")
    def runtime_subnet_id(self) -> Optional[str]:
        """
        Resource ID of a subnet that Container App containers are injected into. This subnet must be in the same VNET as the subnet defined in infrastructureSubnetId. Must not overlap with any other provided IP ranges.
        """
        return pulumi.get(self, "runtime_subnet_id")


@pulumi.output_type
class VolumeMountResponse(dict):
    """
    Volume mount for the Container App.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "volumeName":
            suggest = "volume_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeMountResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeMountResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeMountResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: Optional[str] = None,
                 volume_name: Optional[str] = None):
        """
        Volume mount for the Container App.
        :param str mount_path: Path within the container at which the volume should be mounted.Must not contain ':'.
        :param str volume_name: This must match the Name of a Volume.
        """
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if volume_name is not None:
            pulumi.set(__self__, "volume_name", volume_name)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[str]:
        """
        Path within the container at which the volume should be mounted.Must not contain ':'.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> Optional[str]:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "volume_name")


@pulumi.output_type
class VolumeResponse(dict):
    """
    Volume definitions for the Container App.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageName":
            suggest = "storage_name"
        elif key == "storageType":
            suggest = "storage_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 storage_name: Optional[str] = None,
                 storage_type: Optional[str] = None):
        """
        Volume definitions for the Container App.
        :param str name: Volume name.
        :param str storage_name: Name of storage resource. No need to provide for EmptyDir.
        :param str storage_type: Storage type for the volume. If not provided, use EmptyDir.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_name is not None:
            pulumi.set(__self__, "storage_name", storage_name)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Volume name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="storageName")
    def storage_name(self) -> Optional[str]:
        """
        Name of storage resource. No need to provide for EmptyDir.
        """
        return pulumi.get(self, "storage_name")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[str]:
        """
        Storage type for the volume. If not provided, use EmptyDir.
        """
        return pulumi.get(self, "storage_type")


