# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccountKeyMetadataResponse',
    'AnalyticalStorageConfigurationResponse',
    'ApiPropertiesResponse',
    'AuthenticationMethodLdapPropertiesResponse',
    'AutoscaleSettingsResponse',
    'BackupPolicyMigrationStateResponse',
    'CapabilityResponse',
    'CapacityResponse',
    'CassandraKeyspaceGetPropertiesResponseOptions',
    'CassandraKeyspaceGetPropertiesResponseResource',
    'CassandraPartitionKeyResponse',
    'CassandraSchemaResponse',
    'CassandraTableGetPropertiesResponseOptions',
    'CassandraTableGetPropertiesResponseResource',
    'CassandraViewGetPropertiesResponseOptions',
    'CassandraViewGetPropertiesResponseResource',
    'CertificateResponse',
    'ClientEncryptionIncludedPathResponse',
    'ClientEncryptionPolicyResponse',
    'ClusterKeyResponse',
    'ClusterResourceResponseProperties',
    'ColumnResponse',
    'CompositePathResponse',
    'ConflictResolutionPolicyResponse',
    'ConsistencyPolicyResponse',
    'ContainerPartitionKeyResponse',
    'ContinuousModeBackupPolicyResponse',
    'ContinuousModePropertiesResponse',
    'CorsPolicyResponse',
    'DataCenterResourceResponseProperties',
    'DataTransferRegionalServiceResourceResponse',
    'DataTransferServiceResourcePropertiesResponse',
    'DatabaseAccountConnectionStringResponse',
    'DatabaseAccountKeysMetadataResponse',
    'DatabaseRestoreResourceResponse',
    'DiagnosticLogSettingsResponse',
    'ExcludedPathResponse',
    'FailoverPolicyResponse',
    'GraphAPIComputeRegionalServiceResourceResponse',
    'GraphAPIComputeServiceResourcePropertiesResponse',
    'GraphResourceGetPropertiesResponseOptions',
    'GraphResourceGetPropertiesResponseResource',
    'GremlinDatabaseGetPropertiesResponseOptions',
    'GremlinDatabaseGetPropertiesResponseResource',
    'GremlinDatabaseRestoreResourceResponse',
    'GremlinGraphGetPropertiesResponseOptions',
    'GremlinGraphGetPropertiesResponseResource',
    'IncludedPathResponse',
    'IndexesResponse',
    'IndexingPolicyResponse',
    'IpAddressOrRangeResponse',
    'LocationResponse',
    'ManagedCassandraManagedServiceIdentityResponse',
    'ManagedServiceIdentityResponse',
    'ManagedServiceIdentityResponseUserAssignedIdentities',
    'MaterializedViewsBuilderRegionalServiceResourceResponse',
    'MaterializedViewsBuilderServiceResourcePropertiesResponse',
    'MongoDBCollectionGetPropertiesResponseOptions',
    'MongoDBCollectionGetPropertiesResponseResource',
    'MongoDBDatabaseGetPropertiesResponseOptions',
    'MongoDBDatabaseGetPropertiesResponseResource',
    'MongoIndexKeysResponse',
    'MongoIndexOptionsResponse',
    'MongoIndexResponse',
    'PeriodicModeBackupPolicyResponse',
    'PeriodicModePropertiesResponse',
    'PermissionResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointPropertyResponse',
    'PrivateLinkServiceConnectionStatePropertyResponse',
    'PrivilegeResponse',
    'PrivilegeResponseResource',
    'RestoreParametersResponse',
    'RoleResponse',
    'SeedNodeResponse',
    'SpatialSpecResponse',
    'SqlContainerGetPropertiesResponseOptions',
    'SqlContainerGetPropertiesResponseResource',
    'SqlDatabaseGetPropertiesResponseOptions',
    'SqlDatabaseGetPropertiesResponseResource',
    'SqlDedicatedGatewayRegionalServiceResourceResponse',
    'SqlDedicatedGatewayServiceResourcePropertiesResponse',
    'SqlStoredProcedureGetPropertiesResponseResource',
    'SqlTriggerGetPropertiesResponseResource',
    'SqlUserDefinedFunctionGetPropertiesResponseResource',
    'SystemDataResponse',
    'TableGetPropertiesResponseOptions',
    'TableGetPropertiesResponseResource',
    'UniqueKeyPolicyResponse',
    'UniqueKeyResponse',
    'VirtualNetworkRuleResponse',
]

@pulumi.output_type
class AccountKeyMetadataResponse(dict):
    """
    The metadata related to an access key for a given database account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "generationTime":
            suggest = "generation_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountKeyMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountKeyMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountKeyMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 generation_time: str):
        """
        The metadata related to an access key for a given database account.
        :param str generation_time: Generation time in UTC of the key in ISO-8601 format. If the value is missing from the object, it means that the last key regeneration was triggered before 2022-06-18.
        """
        pulumi.set(__self__, "generation_time", generation_time)

    @property
    @pulumi.getter(name="generationTime")
    def generation_time(self) -> str:
        """
        Generation time in UTC of the key in ISO-8601 format. If the value is missing from the object, it means that the last key regeneration was triggered before 2022-06-18.
        """
        return pulumi.get(self, "generation_time")


@pulumi.output_type
class AnalyticalStorageConfigurationResponse(dict):
    """
    Analytical storage specific properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "schemaType":
            suggest = "schema_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticalStorageConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticalStorageConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticalStorageConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schema_type: Optional[str] = None):
        """
        Analytical storage specific properties.
        :param str schema_type: Describes the types of schema for analytical storage.
        """
        if schema_type is not None:
            pulumi.set(__self__, "schema_type", schema_type)

    @property
    @pulumi.getter(name="schemaType")
    def schema_type(self) -> Optional[str]:
        """
        Describes the types of schema for analytical storage.
        """
        return pulumi.get(self, "schema_type")


@pulumi.output_type
class ApiPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverVersion":
            suggest = "server_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_version: Optional[str] = None):
        """
        :param str server_version: Describes the ServerVersion of an a MongoDB account.
        """
        if server_version is not None:
            pulumi.set(__self__, "server_version", server_version)

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> Optional[str]:
        """
        Describes the ServerVersion of an a MongoDB account.
        """
        return pulumi.get(self, "server_version")


@pulumi.output_type
class AuthenticationMethodLdapPropertiesResponse(dict):
    """
    Ldap authentication method properties. This feature is in preview.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "searchBaseDistinguishedName":
            suggest = "search_base_distinguished_name"
        elif key == "searchFilterTemplate":
            suggest = "search_filter_template"
        elif key == "serverCertificates":
            suggest = "server_certificates"
        elif key == "serverHostname":
            suggest = "server_hostname"
        elif key == "serverPort":
            suggest = "server_port"
        elif key == "serviceUserDistinguishedName":
            suggest = "service_user_distinguished_name"
        elif key == "serviceUserPassword":
            suggest = "service_user_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthenticationMethodLdapPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthenticationMethodLdapPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthenticationMethodLdapPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 search_base_distinguished_name: Optional[str] = None,
                 search_filter_template: Optional[str] = None,
                 server_certificates: Optional[Sequence['outputs.CertificateResponse']] = None,
                 server_hostname: Optional[str] = None,
                 server_port: Optional[int] = None,
                 service_user_distinguished_name: Optional[str] = None,
                 service_user_password: Optional[str] = None):
        """
        Ldap authentication method properties. This feature is in preview.
        :param str search_base_distinguished_name: Distinguished name of the object to start the recursive search of users from.
        :param str search_filter_template: Template to use for searching. Defaults to (cn=%s) where %s will be replaced by the username used to login.
        :param str server_hostname: Hostname of the LDAP server.
        :param int server_port: Port of the LDAP server.
        :param str service_user_distinguished_name: Distinguished name of the look up user account, who can look up user details on authentication.
        :param str service_user_password: Password of the look up user.
        """
        if search_base_distinguished_name is not None:
            pulumi.set(__self__, "search_base_distinguished_name", search_base_distinguished_name)
        if search_filter_template is not None:
            pulumi.set(__self__, "search_filter_template", search_filter_template)
        if server_certificates is not None:
            pulumi.set(__self__, "server_certificates", server_certificates)
        if server_hostname is not None:
            pulumi.set(__self__, "server_hostname", server_hostname)
        if server_port is not None:
            pulumi.set(__self__, "server_port", server_port)
        if service_user_distinguished_name is not None:
            pulumi.set(__self__, "service_user_distinguished_name", service_user_distinguished_name)
        if service_user_password is not None:
            pulumi.set(__self__, "service_user_password", service_user_password)

    @property
    @pulumi.getter(name="searchBaseDistinguishedName")
    def search_base_distinguished_name(self) -> Optional[str]:
        """
        Distinguished name of the object to start the recursive search of users from.
        """
        return pulumi.get(self, "search_base_distinguished_name")

    @property
    @pulumi.getter(name="searchFilterTemplate")
    def search_filter_template(self) -> Optional[str]:
        """
        Template to use for searching. Defaults to (cn=%s) where %s will be replaced by the username used to login.
        """
        return pulumi.get(self, "search_filter_template")

    @property
    @pulumi.getter(name="serverCertificates")
    def server_certificates(self) -> Optional[Sequence['outputs.CertificateResponse']]:
        return pulumi.get(self, "server_certificates")

    @property
    @pulumi.getter(name="serverHostname")
    def server_hostname(self) -> Optional[str]:
        """
        Hostname of the LDAP server.
        """
        return pulumi.get(self, "server_hostname")

    @property
    @pulumi.getter(name="serverPort")
    def server_port(self) -> Optional[int]:
        """
        Port of the LDAP server.
        """
        return pulumi.get(self, "server_port")

    @property
    @pulumi.getter(name="serviceUserDistinguishedName")
    def service_user_distinguished_name(self) -> Optional[str]:
        """
        Distinguished name of the look up user account, who can look up user details on authentication.
        """
        return pulumi.get(self, "service_user_distinguished_name")

    @property
    @pulumi.getter(name="serviceUserPassword")
    def service_user_password(self) -> Optional[str]:
        """
        Password of the look up user.
        """
        return pulumi.get(self, "service_user_password")


@pulumi.output_type
class AutoscaleSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxThroughput":
            suggest = "max_throughput"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_throughput: Optional[int] = None):
        """
        :param int max_throughput: Represents maximum throughput, the resource can scale up to.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[int]:
        """
        Represents maximum throughput, the resource can scale up to.
        """
        return pulumi.get(self, "max_throughput")


@pulumi.output_type
class BackupPolicyMigrationStateResponse(dict):
    """
    The object representing the state of the migration between the backup policies.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"
        elif key == "targetType":
            suggest = "target_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyMigrationStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyMigrationStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyMigrationStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_time: Optional[str] = None,
                 status: Optional[str] = None,
                 target_type: Optional[str] = None):
        """
        The object representing the state of the migration between the backup policies.
        :param str start_time: Time at which the backup policy migration started (ISO-8601 format).
        :param str status: Describes the status of migration between backup policy types.
        :param str target_type: Describes the target backup policy type of the backup policy migration.
        """
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Time at which the backup policy migration started (ISO-8601 format).
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Describes the status of migration between backup policy types.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[str]:
        """
        Describes the target backup policy type of the backup policy migration.
        """
        return pulumi.get(self, "target_type")


@pulumi.output_type
class CapabilityResponse(dict):
    """
    Cosmos DB capability object
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Cosmos DB capability object
        :param str name: Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values also include "EnableTable" and "EnableGremlin".
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values also include "EnableTable" and "EnableGremlin".
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CapacityResponse(dict):
    """
    The object that represents all properties related to capacity enforcement on an account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "totalThroughputLimit":
            suggest = "total_throughput_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CapacityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CapacityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CapacityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 total_throughput_limit: Optional[int] = None):
        """
        The object that represents all properties related to capacity enforcement on an account.
        :param int total_throughput_limit: The total throughput limit imposed on the account. A totalThroughputLimit of 2000 imposes a strict limit of max throughput that can be provisioned on that account to be 2000. A totalThroughputLimit of -1 indicates no limits on provisioning of throughput.
        """
        if total_throughput_limit is not None:
            pulumi.set(__self__, "total_throughput_limit", total_throughput_limit)

    @property
    @pulumi.getter(name="totalThroughputLimit")
    def total_throughput_limit(self) -> Optional[int]:
        """
        The total throughput limit imposed on the account. A totalThroughputLimit of 2000 imposes a strict limit of max throughput that can be provisioned on that account to be 2000. A totalThroughputLimit of -1 indicates no limits on provisioning of throughput.
        """
        return pulumi.get(self, "total_throughput_limit")


@pulumi.output_type
class CassandraKeyspaceGetPropertiesResponseOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscaleSettings":
            suggest = "autoscale_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CassandraKeyspaceGetPropertiesResponseOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CassandraKeyspaceGetPropertiesResponseOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CassandraKeyspaceGetPropertiesResponseOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale_settings: Optional['outputs.AutoscaleSettingsResponse'] = None,
                 throughput: Optional[int] = None):
        """
        :param 'AutoscaleSettingsResponse' autoscale_settings: Specifies the Autoscale settings.
        :param int throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        if autoscale_settings is not None:
            pulumi.set(__self__, "autoscale_settings", autoscale_settings)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @property
    @pulumi.getter(name="autoscaleSettings")
    def autoscale_settings(self) -> Optional['outputs.AutoscaleSettingsResponse']:
        """
        Specifies the Autoscale settings.
        """
        return pulumi.get(self, "autoscale_settings")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[int]:
        """
        Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        return pulumi.get(self, "throughput")


@pulumi.output_type
class CassandraKeyspaceGetPropertiesResponseResource(dict):
    def __init__(__self__, *,
                 etag: str,
                 id: str,
                 rid: str,
                 ts: float):
        """
        :param str etag: A system generated property representing the resource etag required for optimistic concurrency control.
        :param str id: Name of the Cosmos DB Cassandra keyspace
        :param str rid: A system generated property. A unique identifier.
        :param float ts: A system generated property that denotes the last updated timestamp of the resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "rid", rid)
        pulumi.set(__self__, "ts", ts)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A system generated property representing the resource etag required for optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Name of the Cosmos DB Cassandra keyspace
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rid(self) -> str:
        """
        A system generated property. A unique identifier.
        """
        return pulumi.get(self, "rid")

    @property
    @pulumi.getter
    def ts(self) -> float:
        """
        A system generated property that denotes the last updated timestamp of the resource.
        """
        return pulumi.get(self, "ts")


@pulumi.output_type
class CassandraPartitionKeyResponse(dict):
    """
    Cosmos DB Cassandra table partition key
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Cosmos DB Cassandra table partition key
        :param str name: Name of the Cosmos DB Cassandra table partition key
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the Cosmos DB Cassandra table partition key
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CassandraSchemaResponse(dict):
    """
    Cosmos DB Cassandra table schema
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterKeys":
            suggest = "cluster_keys"
        elif key == "partitionKeys":
            suggest = "partition_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CassandraSchemaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CassandraSchemaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CassandraSchemaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_keys: Optional[Sequence['outputs.ClusterKeyResponse']] = None,
                 columns: Optional[Sequence['outputs.ColumnResponse']] = None,
                 partition_keys: Optional[Sequence['outputs.CassandraPartitionKeyResponse']] = None):
        """
        Cosmos DB Cassandra table schema
        :param Sequence['ClusterKeyResponse'] cluster_keys: List of cluster key.
        :param Sequence['ColumnResponse'] columns: List of Cassandra table columns.
        :param Sequence['CassandraPartitionKeyResponse'] partition_keys: List of partition key.
        """
        if cluster_keys is not None:
            pulumi.set(__self__, "cluster_keys", cluster_keys)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if partition_keys is not None:
            pulumi.set(__self__, "partition_keys", partition_keys)

    @property
    @pulumi.getter(name="clusterKeys")
    def cluster_keys(self) -> Optional[Sequence['outputs.ClusterKeyResponse']]:
        """
        List of cluster key.
        """
        return pulumi.get(self, "cluster_keys")

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence['outputs.ColumnResponse']]:
        """
        List of Cassandra table columns.
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter(name="partitionKeys")
    def partition_keys(self) -> Optional[Sequence['outputs.CassandraPartitionKeyResponse']]:
        """
        List of partition key.
        """
        return pulumi.get(self, "partition_keys")


@pulumi.output_type
class CassandraTableGetPropertiesResponseOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscaleSettings":
            suggest = "autoscale_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CassandraTableGetPropertiesResponseOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CassandraTableGetPropertiesResponseOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CassandraTableGetPropertiesResponseOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale_settings: Optional['outputs.AutoscaleSettingsResponse'] = None,
                 throughput: Optional[int] = None):
        """
        :param 'AutoscaleSettingsResponse' autoscale_settings: Specifies the Autoscale settings.
        :param int throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        if autoscale_settings is not None:
            pulumi.set(__self__, "autoscale_settings", autoscale_settings)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @property
    @pulumi.getter(name="autoscaleSettings")
    def autoscale_settings(self) -> Optional['outputs.AutoscaleSettingsResponse']:
        """
        Specifies the Autoscale settings.
        """
        return pulumi.get(self, "autoscale_settings")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[int]:
        """
        Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        return pulumi.get(self, "throughput")


@pulumi.output_type
class CassandraTableGetPropertiesResponseResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analyticalStorageTtl":
            suggest = "analytical_storage_ttl"
        elif key == "defaultTtl":
            suggest = "default_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CassandraTableGetPropertiesResponseResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CassandraTableGetPropertiesResponseResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CassandraTableGetPropertiesResponseResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 id: str,
                 rid: str,
                 ts: float,
                 analytical_storage_ttl: Optional[int] = None,
                 default_ttl: Optional[int] = None,
                 schema: Optional['outputs.CassandraSchemaResponse'] = None):
        """
        :param str etag: A system generated property representing the resource etag required for optimistic concurrency control.
        :param str id: Name of the Cosmos DB Cassandra table
        :param str rid: A system generated property. A unique identifier.
        :param float ts: A system generated property that denotes the last updated timestamp of the resource.
        :param int analytical_storage_ttl: Analytical TTL.
        :param int default_ttl: Time to live of the Cosmos DB Cassandra table
        :param 'CassandraSchemaResponse' schema: Schema of the Cosmos DB Cassandra table
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "rid", rid)
        pulumi.set(__self__, "ts", ts)
        if analytical_storage_ttl is not None:
            pulumi.set(__self__, "analytical_storage_ttl", analytical_storage_ttl)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A system generated property representing the resource etag required for optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Name of the Cosmos DB Cassandra table
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rid(self) -> str:
        """
        A system generated property. A unique identifier.
        """
        return pulumi.get(self, "rid")

    @property
    @pulumi.getter
    def ts(self) -> float:
        """
        A system generated property that denotes the last updated timestamp of the resource.
        """
        return pulumi.get(self, "ts")

    @property
    @pulumi.getter(name="analyticalStorageTtl")
    def analytical_storage_ttl(self) -> Optional[int]:
        """
        Analytical TTL.
        """
        return pulumi.get(self, "analytical_storage_ttl")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[int]:
        """
        Time to live of the Cosmos DB Cassandra table
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter
    def schema(self) -> Optional['outputs.CassandraSchemaResponse']:
        """
        Schema of the Cosmos DB Cassandra table
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class CassandraViewGetPropertiesResponseOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscaleSettings":
            suggest = "autoscale_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CassandraViewGetPropertiesResponseOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CassandraViewGetPropertiesResponseOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CassandraViewGetPropertiesResponseOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale_settings: Optional['outputs.AutoscaleSettingsResponse'] = None,
                 throughput: Optional[int] = None):
        """
        :param 'AutoscaleSettingsResponse' autoscale_settings: Specifies the Autoscale settings.
        :param int throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        if autoscale_settings is not None:
            pulumi.set(__self__, "autoscale_settings", autoscale_settings)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @property
    @pulumi.getter(name="autoscaleSettings")
    def autoscale_settings(self) -> Optional['outputs.AutoscaleSettingsResponse']:
        """
        Specifies the Autoscale settings.
        """
        return pulumi.get(self, "autoscale_settings")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[int]:
        """
        Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        return pulumi.get(self, "throughput")


@pulumi.output_type
class CassandraViewGetPropertiesResponseResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "viewDefinition":
            suggest = "view_definition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CassandraViewGetPropertiesResponseResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CassandraViewGetPropertiesResponseResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CassandraViewGetPropertiesResponseResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 id: str,
                 rid: str,
                 ts: float,
                 view_definition: str):
        """
        :param str etag: A system generated property representing the resource etag required for optimistic concurrency control.
        :param str id: Name of the Cosmos DB Cassandra view
        :param str rid: A system generated property. A unique identifier.
        :param float ts: A system generated property that denotes the last updated timestamp of the resource.
        :param str view_definition: View Definition of the Cosmos DB Cassandra view
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "rid", rid)
        pulumi.set(__self__, "ts", ts)
        pulumi.set(__self__, "view_definition", view_definition)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A system generated property representing the resource etag required for optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Name of the Cosmos DB Cassandra view
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rid(self) -> str:
        """
        A system generated property. A unique identifier.
        """
        return pulumi.get(self, "rid")

    @property
    @pulumi.getter
    def ts(self) -> float:
        """
        A system generated property that denotes the last updated timestamp of the resource.
        """
        return pulumi.get(self, "ts")

    @property
    @pulumi.getter(name="viewDefinition")
    def view_definition(self) -> str:
        """
        View Definition of the Cosmos DB Cassandra view
        """
        return pulumi.get(self, "view_definition")


@pulumi.output_type
class CertificateResponse(dict):
    def __init__(__self__, *,
                 pem: Optional[str] = None):
        """
        :param str pem: PEM formatted public key.
        """
        if pem is not None:
            pulumi.set(__self__, "pem", pem)

    @property
    @pulumi.getter
    def pem(self) -> Optional[str]:
        """
        PEM formatted public key.
        """
        return pulumi.get(self, "pem")


@pulumi.output_type
class ClientEncryptionIncludedPathResponse(dict):
    """
    .
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientEncryptionKeyId":
            suggest = "client_encryption_key_id"
        elif key == "encryptionAlgorithm":
            suggest = "encryption_algorithm"
        elif key == "encryptionType":
            suggest = "encryption_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientEncryptionIncludedPathResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientEncryptionIncludedPathResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientEncryptionIncludedPathResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_encryption_key_id: str,
                 encryption_algorithm: str,
                 encryption_type: str,
                 path: str):
        """
        .
        :param str client_encryption_key_id: The identifier of the Client Encryption Key to be used to encrypt the path.
        :param str encryption_algorithm: The encryption algorithm which will be used. Eg - AEAD_AES_256_CBC_HMAC_SHA256.
        :param str encryption_type: The type of encryption to be performed. Eg - Deterministic, Randomized.
        :param str path: Path that needs to be encrypted.
        """
        pulumi.set(__self__, "client_encryption_key_id", client_encryption_key_id)
        pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        pulumi.set(__self__, "encryption_type", encryption_type)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="clientEncryptionKeyId")
    def client_encryption_key_id(self) -> str:
        """
        The identifier of the Client Encryption Key to be used to encrypt the path.
        """
        return pulumi.get(self, "client_encryption_key_id")

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> str:
        """
        The encryption algorithm which will be used. Eg - AEAD_AES_256_CBC_HMAC_SHA256.
        """
        return pulumi.get(self, "encryption_algorithm")

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> str:
        """
        The type of encryption to be performed. Eg - Deterministic, Randomized.
        """
        return pulumi.get(self, "encryption_type")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path that needs to be encrypted.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class ClientEncryptionPolicyResponse(dict):
    """
    Cosmos DB client encryption policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includedPaths":
            suggest = "included_paths"
        elif key == "policyFormatVersion":
            suggest = "policy_format_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientEncryptionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientEncryptionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientEncryptionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 included_paths: Sequence['outputs.ClientEncryptionIncludedPathResponse'],
                 policy_format_version: Optional[int] = None):
        """
        Cosmos DB client encryption policy.
        :param Sequence['ClientEncryptionIncludedPathResponse'] included_paths: Paths of the item that need encryption along with path-specific settings.
        :param int policy_format_version: Version of the client encryption policy definition. Please note, user passed value is ignored. Default policy version is 1.
        """
        pulumi.set(__self__, "included_paths", included_paths)
        if policy_format_version is None:
            policy_format_version = 1
        if policy_format_version is not None:
            pulumi.set(__self__, "policy_format_version", policy_format_version)

    @property
    @pulumi.getter(name="includedPaths")
    def included_paths(self) -> Sequence['outputs.ClientEncryptionIncludedPathResponse']:
        """
        Paths of the item that need encryption along with path-specific settings.
        """
        return pulumi.get(self, "included_paths")

    @property
    @pulumi.getter(name="policyFormatVersion")
    def policy_format_version(self) -> Optional[int]:
        """
        Version of the client encryption policy definition. Please note, user passed value is ignored. Default policy version is 1.
        """
        return pulumi.get(self, "policy_format_version")


@pulumi.output_type
class ClusterKeyResponse(dict):
    """
    Cosmos DB Cassandra table cluster key
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "orderBy":
            suggest = "order_by"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 order_by: Optional[str] = None):
        """
        Cosmos DB Cassandra table cluster key
        :param str name: Name of the Cosmos DB Cassandra table cluster key
        :param str order_by: Order of the Cosmos DB Cassandra table cluster key, only support "Asc" and "Desc"
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if order_by is not None:
            pulumi.set(__self__, "order_by", order_by)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the Cosmos DB Cassandra table cluster key
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[str]:
        """
        Order of the Cosmos DB Cassandra table cluster key, only support "Asc" and "Desc"
        """
        return pulumi.get(self, "order_by")


@pulumi.output_type
class ClusterResourceResponseProperties(dict):
    """
    Properties of a managed Cassandra cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gossipCertificates":
            suggest = "gossip_certificates"
        elif key == "seedNodes":
            suggest = "seed_nodes"
        elif key == "authenticationMethod":
            suggest = "authentication_method"
        elif key == "cassandraAuditLoggingEnabled":
            suggest = "cassandra_audit_logging_enabled"
        elif key == "cassandraVersion":
            suggest = "cassandra_version"
        elif key == "clientCertificates":
            suggest = "client_certificates"
        elif key == "clusterNameOverride":
            suggest = "cluster_name_override"
        elif key == "delegatedManagementSubnetId":
            suggest = "delegated_management_subnet_id"
        elif key == "externalGossipCertificates":
            suggest = "external_gossip_certificates"
        elif key == "externalSeedNodes":
            suggest = "external_seed_nodes"
        elif key == "hoursBetweenBackups":
            suggest = "hours_between_backups"
        elif key == "prometheusEndpoint":
            suggest = "prometheus_endpoint"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "repairEnabled":
            suggest = "repair_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterResourceResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterResourceResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterResourceResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gossip_certificates: Sequence['outputs.CertificateResponse'],
                 seed_nodes: Sequence['outputs.SeedNodeResponse'],
                 authentication_method: Optional[str] = None,
                 cassandra_audit_logging_enabled: Optional[bool] = None,
                 cassandra_version: Optional[str] = None,
                 client_certificates: Optional[Sequence['outputs.CertificateResponse']] = None,
                 cluster_name_override: Optional[str] = None,
                 deallocated: Optional[bool] = None,
                 delegated_management_subnet_id: Optional[str] = None,
                 external_gossip_certificates: Optional[Sequence['outputs.CertificateResponse']] = None,
                 external_seed_nodes: Optional[Sequence['outputs.SeedNodeResponse']] = None,
                 hours_between_backups: Optional[int] = None,
                 prometheus_endpoint: Optional['outputs.SeedNodeResponse'] = None,
                 provisioning_state: Optional[str] = None,
                 repair_enabled: Optional[bool] = None):
        """
        Properties of a managed Cassandra cluster.
        :param Sequence['CertificateResponse'] gossip_certificates: List of TLS certificates that unmanaged nodes must trust for gossip with managed nodes. All managed nodes will present TLS client certificates that are verifiable using one of the certificates provided in this property.
        :param Sequence['SeedNodeResponse'] seed_nodes: List of IP addresses of seed nodes in the managed data centers. These should be added to the seed node lists of all unmanaged nodes.
        :param str authentication_method: Which authentication method Cassandra should use to authenticate clients. 'None' turns off authentication, so should not be used except in emergencies. 'Cassandra' is the default password based authentication. The default is 'Cassandra'. 'Ldap' is in preview.
        :param bool cassandra_audit_logging_enabled: Whether Cassandra audit logging is enabled
        :param str cassandra_version: Which version of Cassandra should this cluster converge to running (e.g., 3.11). When updated, the cluster may take some time to migrate to the new version.
        :param Sequence['CertificateResponse'] client_certificates: List of TLS certificates used to authorize clients connecting to the cluster. All connections are TLS encrypted whether clientCertificates is set or not, but if clientCertificates is set, the managed Cassandra cluster will reject all connections not bearing a TLS client certificate that can be validated from one or more of the public certificates in this property.
        :param str cluster_name_override: If you need to set the clusterName property in cassandra.yaml to something besides the resource name of the cluster, set the value to use on this property.
        :param bool deallocated: Whether the cluster and associated data centers has been deallocated.
        :param str delegated_management_subnet_id: Resource id of a subnet that this cluster's management service should have its network interface attached to. The subnet must be routable to all subnets that will be delegated to data centers. The resource id must be of the form '/subscriptions/<subscription id>/resourceGroups/<resource group>/providers/Microsoft.Network/virtualNetworks/<virtual network>/subnets/<subnet>'
        :param Sequence['CertificateResponse'] external_gossip_certificates: List of TLS certificates used to authorize gossip from unmanaged data centers. The TLS certificates of all nodes in unmanaged data centers must be verifiable using one of the certificates provided in this property.
        :param Sequence['SeedNodeResponse'] external_seed_nodes: List of IP addresses of seed nodes in unmanaged data centers. These will be added to the seed node lists of all managed nodes.
        :param int hours_between_backups: Number of hours to wait between taking a backup of the cluster.
        :param 'SeedNodeResponse' prometheus_endpoint: Hostname or IP address where the Prometheus endpoint containing data about the managed Cassandra nodes can be reached.
        :param str provisioning_state: The status of the resource at the time the operation was called.
        :param bool repair_enabled: Should automatic repairs run on this cluster? If omitted, this is true, and should stay true unless you are running a hybrid cluster where you are already doing your own repairs.
        """
        pulumi.set(__self__, "gossip_certificates", gossip_certificates)
        pulumi.set(__self__, "seed_nodes", seed_nodes)
        if authentication_method is not None:
            pulumi.set(__self__, "authentication_method", authentication_method)
        if cassandra_audit_logging_enabled is not None:
            pulumi.set(__self__, "cassandra_audit_logging_enabled", cassandra_audit_logging_enabled)
        if cassandra_version is not None:
            pulumi.set(__self__, "cassandra_version", cassandra_version)
        if client_certificates is not None:
            pulumi.set(__self__, "client_certificates", client_certificates)
        if cluster_name_override is not None:
            pulumi.set(__self__, "cluster_name_override", cluster_name_override)
        if deallocated is not None:
            pulumi.set(__self__, "deallocated", deallocated)
        if delegated_management_subnet_id is not None:
            pulumi.set(__self__, "delegated_management_subnet_id", delegated_management_subnet_id)
        if external_gossip_certificates is not None:
            pulumi.set(__self__, "external_gossip_certificates", external_gossip_certificates)
        if external_seed_nodes is not None:
            pulumi.set(__self__, "external_seed_nodes", external_seed_nodes)
        if hours_between_backups is not None:
            pulumi.set(__self__, "hours_between_backups", hours_between_backups)
        if prometheus_endpoint is not None:
            pulumi.set(__self__, "prometheus_endpoint", prometheus_endpoint)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if repair_enabled is not None:
            pulumi.set(__self__, "repair_enabled", repair_enabled)

    @property
    @pulumi.getter(name="gossipCertificates")
    def gossip_certificates(self) -> Sequence['outputs.CertificateResponse']:
        """
        List of TLS certificates that unmanaged nodes must trust for gossip with managed nodes. All managed nodes will present TLS client certificates that are verifiable using one of the certificates provided in this property.
        """
        return pulumi.get(self, "gossip_certificates")

    @property
    @pulumi.getter(name="seedNodes")
    def seed_nodes(self) -> Sequence['outputs.SeedNodeResponse']:
        """
        List of IP addresses of seed nodes in the managed data centers. These should be added to the seed node lists of all unmanaged nodes.
        """
        return pulumi.get(self, "seed_nodes")

    @property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> Optional[str]:
        """
        Which authentication method Cassandra should use to authenticate clients. 'None' turns off authentication, so should not be used except in emergencies. 'Cassandra' is the default password based authentication. The default is 'Cassandra'. 'Ldap' is in preview.
        """
        return pulumi.get(self, "authentication_method")

    @property
    @pulumi.getter(name="cassandraAuditLoggingEnabled")
    def cassandra_audit_logging_enabled(self) -> Optional[bool]:
        """
        Whether Cassandra audit logging is enabled
        """
        return pulumi.get(self, "cassandra_audit_logging_enabled")

    @property
    @pulumi.getter(name="cassandraVersion")
    def cassandra_version(self) -> Optional[str]:
        """
        Which version of Cassandra should this cluster converge to running (e.g., 3.11). When updated, the cluster may take some time to migrate to the new version.
        """
        return pulumi.get(self, "cassandra_version")

    @property
    @pulumi.getter(name="clientCertificates")
    def client_certificates(self) -> Optional[Sequence['outputs.CertificateResponse']]:
        """
        List of TLS certificates used to authorize clients connecting to the cluster. All connections are TLS encrypted whether clientCertificates is set or not, but if clientCertificates is set, the managed Cassandra cluster will reject all connections not bearing a TLS client certificate that can be validated from one or more of the public certificates in this property.
        """
        return pulumi.get(self, "client_certificates")

    @property
    @pulumi.getter(name="clusterNameOverride")
    def cluster_name_override(self) -> Optional[str]:
        """
        If you need to set the clusterName property in cassandra.yaml to something besides the resource name of the cluster, set the value to use on this property.
        """
        return pulumi.get(self, "cluster_name_override")

    @property
    @pulumi.getter
    def deallocated(self) -> Optional[bool]:
        """
        Whether the cluster and associated data centers has been deallocated.
        """
        return pulumi.get(self, "deallocated")

    @property
    @pulumi.getter(name="delegatedManagementSubnetId")
    def delegated_management_subnet_id(self) -> Optional[str]:
        """
        Resource id of a subnet that this cluster's management service should have its network interface attached to. The subnet must be routable to all subnets that will be delegated to data centers. The resource id must be of the form '/subscriptions/<subscription id>/resourceGroups/<resource group>/providers/Microsoft.Network/virtualNetworks/<virtual network>/subnets/<subnet>'
        """
        return pulumi.get(self, "delegated_management_subnet_id")

    @property
    @pulumi.getter(name="externalGossipCertificates")
    def external_gossip_certificates(self) -> Optional[Sequence['outputs.CertificateResponse']]:
        """
        List of TLS certificates used to authorize gossip from unmanaged data centers. The TLS certificates of all nodes in unmanaged data centers must be verifiable using one of the certificates provided in this property.
        """
        return pulumi.get(self, "external_gossip_certificates")

    @property
    @pulumi.getter(name="externalSeedNodes")
    def external_seed_nodes(self) -> Optional[Sequence['outputs.SeedNodeResponse']]:
        """
        List of IP addresses of seed nodes in unmanaged data centers. These will be added to the seed node lists of all managed nodes.
        """
        return pulumi.get(self, "external_seed_nodes")

    @property
    @pulumi.getter(name="hoursBetweenBackups")
    def hours_between_backups(self) -> Optional[int]:
        """
        Number of hours to wait between taking a backup of the cluster.
        """
        return pulumi.get(self, "hours_between_backups")

    @property
    @pulumi.getter(name="prometheusEndpoint")
    def prometheus_endpoint(self) -> Optional['outputs.SeedNodeResponse']:
        """
        Hostname or IP address where the Prometheus endpoint containing data about the managed Cassandra nodes can be reached.
        """
        return pulumi.get(self, "prometheus_endpoint")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The status of the resource at the time the operation was called.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="repairEnabled")
    def repair_enabled(self) -> Optional[bool]:
        """
        Should automatic repairs run on this cluster? If omitted, this is true, and should stay true unless you are running a hybrid cluster where you are already doing your own repairs.
        """
        return pulumi.get(self, "repair_enabled")


@pulumi.output_type
class ColumnResponse(dict):
    """
    Cosmos DB Cassandra table column
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Cosmos DB Cassandra table column
        :param str name: Name of the Cosmos DB Cassandra table column
        :param str type: Type of the Cosmos DB Cassandra table column
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the Cosmos DB Cassandra table column
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the Cosmos DB Cassandra table column
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CompositePathResponse(dict):
    def __init__(__self__, *,
                 order: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str order: Sort order for composite paths.
        :param str path: The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
        """
        if order is not None:
            pulumi.set(__self__, "order", order)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def order(self) -> Optional[str]:
        """
        Sort order for composite paths.
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class ConflictResolutionPolicyResponse(dict):
    """
    The conflict resolution policy for the container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictResolutionPath":
            suggest = "conflict_resolution_path"
        elif key == "conflictResolutionProcedure":
            suggest = "conflict_resolution_procedure"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConflictResolutionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConflictResolutionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConflictResolutionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conflict_resolution_path: Optional[str] = None,
                 conflict_resolution_procedure: Optional[str] = None,
                 mode: Optional[str] = None):
        """
        The conflict resolution policy for the container.
        :param str conflict_resolution_path: The conflict resolution path in the case of LastWriterWins mode.
        :param str conflict_resolution_procedure: The procedure to resolve conflicts in the case of custom mode.
        :param str mode: Indicates the conflict resolution mode.
        """
        if conflict_resolution_path is not None:
            pulumi.set(__self__, "conflict_resolution_path", conflict_resolution_path)
        if conflict_resolution_procedure is not None:
            pulumi.set(__self__, "conflict_resolution_procedure", conflict_resolution_procedure)
        if mode is None:
            mode = 'LastWriterWins'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="conflictResolutionPath")
    def conflict_resolution_path(self) -> Optional[str]:
        """
        The conflict resolution path in the case of LastWriterWins mode.
        """
        return pulumi.get(self, "conflict_resolution_path")

    @property
    @pulumi.getter(name="conflictResolutionProcedure")
    def conflict_resolution_procedure(self) -> Optional[str]:
        """
        The procedure to resolve conflicts in the case of custom mode.
        """
        return pulumi.get(self, "conflict_resolution_procedure")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Indicates the conflict resolution mode.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class ConsistencyPolicyResponse(dict):
    """
    The consistency policy for the Cosmos DB database account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultConsistencyLevel":
            suggest = "default_consistency_level"
        elif key == "maxIntervalInSeconds":
            suggest = "max_interval_in_seconds"
        elif key == "maxStalenessPrefix":
            suggest = "max_staleness_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConsistencyPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConsistencyPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConsistencyPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_consistency_level: str,
                 max_interval_in_seconds: Optional[int] = None,
                 max_staleness_prefix: Optional[float] = None):
        """
        The consistency policy for the Cosmos DB database account.
        :param str default_consistency_level: The default consistency level and configuration settings of the Cosmos DB account.
        :param int max_interval_in_seconds: When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. Accepted range for this value is 5 - 86400. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
        :param float max_staleness_prefix: When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. Accepted range for this value is 1 – 2,147,483,647. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
        """
        pulumi.set(__self__, "default_consistency_level", default_consistency_level)
        if max_interval_in_seconds is not None:
            pulumi.set(__self__, "max_interval_in_seconds", max_interval_in_seconds)
        if max_staleness_prefix is not None:
            pulumi.set(__self__, "max_staleness_prefix", max_staleness_prefix)

    @property
    @pulumi.getter(name="defaultConsistencyLevel")
    def default_consistency_level(self) -> str:
        """
        The default consistency level and configuration settings of the Cosmos DB account.
        """
        return pulumi.get(self, "default_consistency_level")

    @property
    @pulumi.getter(name="maxIntervalInSeconds")
    def max_interval_in_seconds(self) -> Optional[int]:
        """
        When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. Accepted range for this value is 5 - 86400. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
        """
        return pulumi.get(self, "max_interval_in_seconds")

    @property
    @pulumi.getter(name="maxStalenessPrefix")
    def max_staleness_prefix(self) -> Optional[float]:
        """
        When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. Accepted range for this value is 1 – 2,147,483,647. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
        """
        return pulumi.get(self, "max_staleness_prefix")


@pulumi.output_type
class ContainerPartitionKeyResponse(dict):
    """
    The configuration of the partition key to be used for partitioning data into multiple partitions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "systemKey":
            suggest = "system_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerPartitionKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerPartitionKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerPartitionKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 system_key: bool,
                 kind: Optional[str] = None,
                 paths: Optional[Sequence[str]] = None,
                 version: Optional[int] = None):
        """
        The configuration of the partition key to be used for partitioning data into multiple partitions
        :param bool system_key: Indicates if the container is using a system generated partition key
        :param str kind: Indicates the kind of algorithm used for partitioning. For MultiHash, multiple partition keys (upto three maximum) are supported for container create
        :param Sequence[str] paths: List of paths using which data within the container can be partitioned
        :param int version: Indicates the version of the partition key definition
        """
        pulumi.set(__self__, "system_key", system_key)
        if kind is None:
            kind = 'Hash'
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="systemKey")
    def system_key(self) -> bool:
        """
        Indicates if the container is using a system generated partition key
        """
        return pulumi.get(self, "system_key")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Indicates the kind of algorithm used for partitioning. For MultiHash, multiple partition keys (upto three maximum) are supported for container create
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[str]]:
        """
        List of paths using which data within the container can be partitioned
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter
    def version(self) -> Optional[int]:
        """
        Indicates the version of the partition key definition
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ContinuousModeBackupPolicyResponse(dict):
    """
    The object representing continuous mode backup policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "continuousModeProperties":
            suggest = "continuous_mode_properties"
        elif key == "migrationState":
            suggest = "migration_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContinuousModeBackupPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContinuousModeBackupPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContinuousModeBackupPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 continuous_mode_properties: Optional['outputs.ContinuousModePropertiesResponse'] = None,
                 migration_state: Optional['outputs.BackupPolicyMigrationStateResponse'] = None):
        """
        The object representing continuous mode backup policy.
        :param str type: Describes the mode of backups.
               Expected value is 'Continuous'.
        :param 'ContinuousModePropertiesResponse' continuous_mode_properties: Configuration values for continuous mode backup
        :param 'BackupPolicyMigrationStateResponse' migration_state: The object representing the state of the migration between the backup policies.
        """
        pulumi.set(__self__, "type", 'Continuous')
        if continuous_mode_properties is not None:
            pulumi.set(__self__, "continuous_mode_properties", continuous_mode_properties)
        if migration_state is not None:
            pulumi.set(__self__, "migration_state", migration_state)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Describes the mode of backups.
        Expected value is 'Continuous'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="continuousModeProperties")
    def continuous_mode_properties(self) -> Optional['outputs.ContinuousModePropertiesResponse']:
        """
        Configuration values for continuous mode backup
        """
        return pulumi.get(self, "continuous_mode_properties")

    @property
    @pulumi.getter(name="migrationState")
    def migration_state(self) -> Optional['outputs.BackupPolicyMigrationStateResponse']:
        """
        The object representing the state of the migration between the backup policies.
        """
        return pulumi.get(self, "migration_state")


@pulumi.output_type
class ContinuousModePropertiesResponse(dict):
    """
    Configuration values for periodic mode backup
    """
    def __init__(__self__, *,
                 tier: Optional[str] = None):
        """
        Configuration values for periodic mode backup
        :param str tier: Enum to indicate type of Continuos backup mode
        """
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Enum to indicate type of Continuos backup mode
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class CorsPolicyResponse(dict):
    """
    The CORS policy for the Cosmos DB database account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "exposedHeaders":
            suggest = "exposed_headers"
        elif key == "maxAgeInSeconds":
            suggest = "max_age_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CorsPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CorsPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CorsPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_origins: str,
                 allowed_headers: Optional[str] = None,
                 allowed_methods: Optional[str] = None,
                 exposed_headers: Optional[str] = None,
                 max_age_in_seconds: Optional[float] = None):
        """
        The CORS policy for the Cosmos DB database account.
        :param str allowed_origins: The origin domains that are permitted to make a request against the service via CORS.
        :param str allowed_headers: The request headers that the origin domain may specify on the CORS request.
        :param str allowed_methods: The methods (HTTP request verbs) that the origin domain may use for a CORS request.
        :param str exposed_headers: The response headers that may be sent in the response to the CORS request and exposed by the browser to the request issuer.
        :param float max_age_in_seconds: The maximum amount time that a browser should cache the preflight OPTIONS request.
        """
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if exposed_headers is not None:
            pulumi.set(__self__, "exposed_headers", exposed_headers)
        if max_age_in_seconds is not None:
            pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> str:
        """
        The origin domains that are permitted to make a request against the service via CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[str]:
        """
        The request headers that the origin domain may specify on the CORS request.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[str]:
        """
        The methods (HTTP request verbs) that the origin domain may use for a CORS request.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="exposedHeaders")
    def exposed_headers(self) -> Optional[str]:
        """
        The response headers that may be sent in the response to the CORS request and exposed by the browser to the request issuer.
        """
        return pulumi.get(self, "exposed_headers")

    @property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> Optional[float]:
        """
        The maximum amount time that a browser should cache the preflight OPTIONS request.
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class DataCenterResourceResponseProperties(dict):
    """
    Properties of a managed Cassandra data center.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "seedNodes":
            suggest = "seed_nodes"
        elif key == "authenticationMethodLdapProperties":
            suggest = "authentication_method_ldap_properties"
        elif key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "backupStorageCustomerKeyUri":
            suggest = "backup_storage_customer_key_uri"
        elif key == "base64EncodedCassandraYamlFragment":
            suggest = "base64_encoded_cassandra_yaml_fragment"
        elif key == "dataCenterLocation":
            suggest = "data_center_location"
        elif key == "delegatedSubnetId":
            suggest = "delegated_subnet_id"
        elif key == "diskCapacity":
            suggest = "disk_capacity"
        elif key == "diskSku":
            suggest = "disk_sku"
        elif key == "managedDiskCustomerKeyUri":
            suggest = "managed_disk_customer_key_uri"
        elif key == "nodeCount":
            suggest = "node_count"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCenterResourceResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCenterResourceResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCenterResourceResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 seed_nodes: Sequence['outputs.SeedNodeResponse'],
                 authentication_method_ldap_properties: Optional['outputs.AuthenticationMethodLdapPropertiesResponse'] = None,
                 availability_zone: Optional[bool] = None,
                 backup_storage_customer_key_uri: Optional[str] = None,
                 base64_encoded_cassandra_yaml_fragment: Optional[str] = None,
                 data_center_location: Optional[str] = None,
                 delegated_subnet_id: Optional[str] = None,
                 disk_capacity: Optional[int] = None,
                 disk_sku: Optional[str] = None,
                 managed_disk_customer_key_uri: Optional[str] = None,
                 node_count: Optional[int] = None,
                 provisioning_state: Optional[str] = None,
                 sku: Optional[str] = None):
        """
        Properties of a managed Cassandra data center.
        :param Sequence['SeedNodeResponse'] seed_nodes: IP addresses for seed nodes in this data center. This is for reference. Generally you will want to use the seedNodes property on the cluster, which aggregates the seed nodes from all data centers in the cluster.
        :param 'AuthenticationMethodLdapPropertiesResponse' authentication_method_ldap_properties: Ldap authentication method properties. This feature is in preview.
        :param bool availability_zone: If the data center has Availability Zone feature, apply it to the Virtual Machine ScaleSet that host the cassandra data center virtual machines.
        :param str backup_storage_customer_key_uri: Indicates the Key Uri of the customer key to use for encryption of the backup storage account.
        :param str base64_encoded_cassandra_yaml_fragment: A fragment of a cassandra.yaml configuration file to be included in the cassandra.yaml for all nodes in this data center. The fragment should be Base64 encoded, and only a subset of keys are allowed.
        :param str data_center_location: The region this data center should be created in.
        :param str delegated_subnet_id: Resource id of a subnet the nodes in this data center should have their network interfaces connected to. The subnet must be in the same region specified in 'dataCenterLocation' and must be able to route to the subnet specified in the cluster's 'delegatedManagementSubnetId' property. This resource id will be of the form '/subscriptions/<subscription id>/resourceGroups/<resource group>/providers/Microsoft.Network/virtualNetworks/<virtual network>/subnets/<subnet>'.
        :param int disk_capacity: Number of disk used for data centers. Default value is 4.
        :param str disk_sku: Disk SKU used for data centers. Default value is P30.
        :param str managed_disk_customer_key_uri: Key uri to use for encryption of managed disks. Ensure the system assigned identity of the cluster has been assigned appropriate permissions(key get/wrap/unwrap permissions) on the key.
        :param int node_count: The number of nodes the data center should have. This is the desired number. After it is set, it may take some time for the data center to be scaled to match. To monitor the number of nodes and their status, use the fetchNodeStatus method on the cluster.
        :param str provisioning_state: The status of the resource at the time the operation was called.
        :param str sku: Virtual Machine SKU used for data centers. Default value is Standard_DS14_v2
        """
        pulumi.set(__self__, "seed_nodes", seed_nodes)
        if authentication_method_ldap_properties is not None:
            pulumi.set(__self__, "authentication_method_ldap_properties", authentication_method_ldap_properties)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_storage_customer_key_uri is not None:
            pulumi.set(__self__, "backup_storage_customer_key_uri", backup_storage_customer_key_uri)
        if base64_encoded_cassandra_yaml_fragment is not None:
            pulumi.set(__self__, "base64_encoded_cassandra_yaml_fragment", base64_encoded_cassandra_yaml_fragment)
        if data_center_location is not None:
            pulumi.set(__self__, "data_center_location", data_center_location)
        if delegated_subnet_id is not None:
            pulumi.set(__self__, "delegated_subnet_id", delegated_subnet_id)
        if disk_capacity is not None:
            pulumi.set(__self__, "disk_capacity", disk_capacity)
        if disk_sku is not None:
            pulumi.set(__self__, "disk_sku", disk_sku)
        if managed_disk_customer_key_uri is not None:
            pulumi.set(__self__, "managed_disk_customer_key_uri", managed_disk_customer_key_uri)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter(name="seedNodes")
    def seed_nodes(self) -> Sequence['outputs.SeedNodeResponse']:
        """
        IP addresses for seed nodes in this data center. This is for reference. Generally you will want to use the seedNodes property on the cluster, which aggregates the seed nodes from all data centers in the cluster.
        """
        return pulumi.get(self, "seed_nodes")

    @property
    @pulumi.getter(name="authenticationMethodLdapProperties")
    def authentication_method_ldap_properties(self) -> Optional['outputs.AuthenticationMethodLdapPropertiesResponse']:
        """
        Ldap authentication method properties. This feature is in preview.
        """
        return pulumi.get(self, "authentication_method_ldap_properties")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[bool]:
        """
        If the data center has Availability Zone feature, apply it to the Virtual Machine ScaleSet that host the cassandra data center virtual machines.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="backupStorageCustomerKeyUri")
    def backup_storage_customer_key_uri(self) -> Optional[str]:
        """
        Indicates the Key Uri of the customer key to use for encryption of the backup storage account.
        """
        return pulumi.get(self, "backup_storage_customer_key_uri")

    @property
    @pulumi.getter(name="base64EncodedCassandraYamlFragment")
    def base64_encoded_cassandra_yaml_fragment(self) -> Optional[str]:
        """
        A fragment of a cassandra.yaml configuration file to be included in the cassandra.yaml for all nodes in this data center. The fragment should be Base64 encoded, and only a subset of keys are allowed.
        """
        return pulumi.get(self, "base64_encoded_cassandra_yaml_fragment")

    @property
    @pulumi.getter(name="dataCenterLocation")
    def data_center_location(self) -> Optional[str]:
        """
        The region this data center should be created in.
        """
        return pulumi.get(self, "data_center_location")

    @property
    @pulumi.getter(name="delegatedSubnetId")
    def delegated_subnet_id(self) -> Optional[str]:
        """
        Resource id of a subnet the nodes in this data center should have their network interfaces connected to. The subnet must be in the same region specified in 'dataCenterLocation' and must be able to route to the subnet specified in the cluster's 'delegatedManagementSubnetId' property. This resource id will be of the form '/subscriptions/<subscription id>/resourceGroups/<resource group>/providers/Microsoft.Network/virtualNetworks/<virtual network>/subnets/<subnet>'.
        """
        return pulumi.get(self, "delegated_subnet_id")

    @property
    @pulumi.getter(name="diskCapacity")
    def disk_capacity(self) -> Optional[int]:
        """
        Number of disk used for data centers. Default value is 4.
        """
        return pulumi.get(self, "disk_capacity")

    @property
    @pulumi.getter(name="diskSku")
    def disk_sku(self) -> Optional[str]:
        """
        Disk SKU used for data centers. Default value is P30.
        """
        return pulumi.get(self, "disk_sku")

    @property
    @pulumi.getter(name="managedDiskCustomerKeyUri")
    def managed_disk_customer_key_uri(self) -> Optional[str]:
        """
        Key uri to use for encryption of managed disks. Ensure the system assigned identity of the cluster has been assigned appropriate permissions(key get/wrap/unwrap permissions) on the key.
        """
        return pulumi.get(self, "managed_disk_customer_key_uri")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[int]:
        """
        The number of nodes the data center should have. This is the desired number. After it is set, it may take some time for the data center to be scaled to match. To monitor the number of nodes and their status, use the fetchNodeStatus method on the cluster.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The status of the resource at the time the operation was called.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def sku(self) -> Optional[str]:
        """
        Virtual Machine SKU used for data centers. Default value is Standard_DS14_v2
        """
        return pulumi.get(self, "sku")


@pulumi.output_type
class DataTransferRegionalServiceResourceResponse(dict):
    """
    Resource for a regional service location.
    """
    def __init__(__self__, *,
                 location: str,
                 name: str,
                 status: str):
        """
        Resource for a regional service location.
        :param str location: The location name.
        :param str name: The regional service name.
        :param str status: Describes the status of a service.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location name.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The regional service name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Describes the status of a service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DataTransferServiceResourcePropertiesResponse(dict):
    """
    Properties for DataTransferServiceResource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationTime":
            suggest = "creation_time"
        elif key == "serviceType":
            suggest = "service_type"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceSize":
            suggest = "instance_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataTransferServiceResourcePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataTransferServiceResourcePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataTransferServiceResourcePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_time: str,
                 locations: Sequence['outputs.DataTransferRegionalServiceResourceResponse'],
                 service_type: str,
                 status: str,
                 instance_count: Optional[int] = None,
                 instance_size: Optional[str] = None):
        """
        Properties for DataTransferServiceResource.
        :param str creation_time: Time of the last state change (ISO-8601 format).
        :param Sequence['DataTransferRegionalServiceResourceResponse'] locations: An array that contains all of the locations for the service.
        :param str service_type: ServiceType for the service.
               Expected value is 'DataTransfer'.
        :param str status: Describes the status of a service.
        :param int instance_count: Instance count for the service.
        :param str instance_size: Instance type for the service.
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "locations", locations)
        pulumi.set(__self__, "service_type", 'DataTransfer')
        pulumi.set(__self__, "status", status)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size is not None:
            pulumi.set(__self__, "instance_size", instance_size)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Time of the last state change (ISO-8601 format).
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def locations(self) -> Sequence['outputs.DataTransferRegionalServiceResourceResponse']:
        """
        An array that contains all of the locations for the service.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> str:
        """
        ServiceType for the service.
        Expected value is 'DataTransfer'.
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Describes the status of a service.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        Instance count for the service.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceSize")
    def instance_size(self) -> Optional[str]:
        """
        Instance type for the service.
        """
        return pulumi.get(self, "instance_size")


@pulumi.output_type
class DatabaseAccountConnectionStringResponse(dict):
    """
    Connection string for the Cosmos DB account
    """
    def __init__(__self__, *,
                 connection_string: str,
                 description: str):
        """
        Connection string for the Cosmos DB account
        :param str connection_string: Value of the connection string
        :param str description: Description of the connection string
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        Value of the connection string
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the connection string
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class DatabaseAccountKeysMetadataResponse(dict):
    """
    The metadata related to each access key for the given Cosmos DB database account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryMasterKey":
            suggest = "primary_master_key"
        elif key == "primaryReadonlyMasterKey":
            suggest = "primary_readonly_master_key"
        elif key == "secondaryMasterKey":
            suggest = "secondary_master_key"
        elif key == "secondaryReadonlyMasterKey":
            suggest = "secondary_readonly_master_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseAccountKeysMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseAccountKeysMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseAccountKeysMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primary_master_key: Optional['outputs.AccountKeyMetadataResponse'] = None,
                 primary_readonly_master_key: Optional['outputs.AccountKeyMetadataResponse'] = None,
                 secondary_master_key: Optional['outputs.AccountKeyMetadataResponse'] = None,
                 secondary_readonly_master_key: Optional['outputs.AccountKeyMetadataResponse'] = None):
        """
        The metadata related to each access key for the given Cosmos DB database account.
        :param 'AccountKeyMetadataResponse' primary_master_key: The metadata related to the Primary Read-Write Key for the given Cosmos DB database account.
        :param 'AccountKeyMetadataResponse' primary_readonly_master_key: The metadata related to the Primary Read-Only Key for the given Cosmos DB database account.
        :param 'AccountKeyMetadataResponse' secondary_master_key: The metadata related to the Secondary Read-Write Key for the given Cosmos DB database account.
        :param 'AccountKeyMetadataResponse' secondary_readonly_master_key: The metadata related to the Secondary Read-Only Key for the given Cosmos DB database account.
        """
        if primary_master_key is not None:
            pulumi.set(__self__, "primary_master_key", primary_master_key)
        if primary_readonly_master_key is not None:
            pulumi.set(__self__, "primary_readonly_master_key", primary_readonly_master_key)
        if secondary_master_key is not None:
            pulumi.set(__self__, "secondary_master_key", secondary_master_key)
        if secondary_readonly_master_key is not None:
            pulumi.set(__self__, "secondary_readonly_master_key", secondary_readonly_master_key)

    @property
    @pulumi.getter(name="primaryMasterKey")
    def primary_master_key(self) -> Optional['outputs.AccountKeyMetadataResponse']:
        """
        The metadata related to the Primary Read-Write Key for the given Cosmos DB database account.
        """
        return pulumi.get(self, "primary_master_key")

    @property
    @pulumi.getter(name="primaryReadonlyMasterKey")
    def primary_readonly_master_key(self) -> Optional['outputs.AccountKeyMetadataResponse']:
        """
        The metadata related to the Primary Read-Only Key for the given Cosmos DB database account.
        """
        return pulumi.get(self, "primary_readonly_master_key")

    @property
    @pulumi.getter(name="secondaryMasterKey")
    def secondary_master_key(self) -> Optional['outputs.AccountKeyMetadataResponse']:
        """
        The metadata related to the Secondary Read-Write Key for the given Cosmos DB database account.
        """
        return pulumi.get(self, "secondary_master_key")

    @property
    @pulumi.getter(name="secondaryReadonlyMasterKey")
    def secondary_readonly_master_key(self) -> Optional['outputs.AccountKeyMetadataResponse']:
        """
        The metadata related to the Secondary Read-Only Key for the given Cosmos DB database account.
        """
        return pulumi.get(self, "secondary_readonly_master_key")


@pulumi.output_type
class DatabaseRestoreResourceResponse(dict):
    """
    Specific Databases to restore.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collectionNames":
            suggest = "collection_names"
        elif key == "databaseName":
            suggest = "database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseRestoreResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseRestoreResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseRestoreResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collection_names: Optional[Sequence[str]] = None,
                 database_name: Optional[str] = None):
        """
        Specific Databases to restore.
        :param Sequence[str] collection_names: The names of the collections available for restore.
        :param str database_name: The name of the database available for restore.
        """
        if collection_names is not None:
            pulumi.set(__self__, "collection_names", collection_names)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)

    @property
    @pulumi.getter(name="collectionNames")
    def collection_names(self) -> Optional[Sequence[str]]:
        """
        The names of the collections available for restore.
        """
        return pulumi.get(self, "collection_names")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        The name of the database available for restore.
        """
        return pulumi.get(self, "database_name")


@pulumi.output_type
class DiagnosticLogSettingsResponse(dict):
    """
    Indicates what diagnostic log settings are to be enabled.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableFullTextQuery":
            suggest = "enable_full_text_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiagnosticLogSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiagnosticLogSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiagnosticLogSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_full_text_query: Optional[str] = None):
        """
        Indicates what diagnostic log settings are to be enabled.
        :param str enable_full_text_query: Describe the level of detail with which queries are to be logged.
        """
        if enable_full_text_query is not None:
            pulumi.set(__self__, "enable_full_text_query", enable_full_text_query)

    @property
    @pulumi.getter(name="enableFullTextQuery")
    def enable_full_text_query(self) -> Optional[str]:
        """
        Describe the level of detail with which queries are to be logged.
        """
        return pulumi.get(self, "enable_full_text_query")


@pulumi.output_type
class ExcludedPathResponse(dict):
    def __init__(__self__, *,
                 path: Optional[str] = None):
        """
        :param str path: The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
        """
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class FailoverPolicyResponse(dict):
    """
    The failover policy for a given region of a database account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverPriority":
            suggest = "failover_priority"
        elif key == "locationName":
            suggest = "location_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FailoverPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FailoverPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FailoverPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 failover_priority: Optional[int] = None,
                 location_name: Optional[str] = None):
        """
        The failover policy for a given region of a database account.
        :param str id: The unique identifier of the region in which the database account replicates to. Example: &lt;accountName&gt;-&lt;locationName&gt;.
        :param int failover_priority: The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
        :param str location_name: The name of the region in which the database account exists.
        """
        pulumi.set(__self__, "id", id)
        if failover_priority is not None:
            pulumi.set(__self__, "failover_priority", failover_priority)
        if location_name is not None:
            pulumi.set(__self__, "location_name", location_name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique identifier of the region in which the database account replicates to. Example: &lt;accountName&gt;-&lt;locationName&gt;.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="failoverPriority")
    def failover_priority(self) -> Optional[int]:
        """
        The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
        """
        return pulumi.get(self, "failover_priority")

    @property
    @pulumi.getter(name="locationName")
    def location_name(self) -> Optional[str]:
        """
        The name of the region in which the database account exists.
        """
        return pulumi.get(self, "location_name")


@pulumi.output_type
class GraphAPIComputeRegionalServiceResourceResponse(dict):
    """
    Resource for a regional service location.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "graphApiComputeEndpoint":
            suggest = "graph_api_compute_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphAPIComputeRegionalServiceResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphAPIComputeRegionalServiceResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphAPIComputeRegionalServiceResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 graph_api_compute_endpoint: str,
                 location: str,
                 name: str,
                 status: str):
        """
        Resource for a regional service location.
        :param str graph_api_compute_endpoint: The regional endpoint for GraphAPICompute.
        :param str location: The location name.
        :param str name: The regional service name.
        :param str status: Describes the status of a service.
        """
        pulumi.set(__self__, "graph_api_compute_endpoint", graph_api_compute_endpoint)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="graphApiComputeEndpoint")
    def graph_api_compute_endpoint(self) -> str:
        """
        The regional endpoint for GraphAPICompute.
        """
        return pulumi.get(self, "graph_api_compute_endpoint")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location name.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The regional service name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Describes the status of a service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GraphAPIComputeServiceResourcePropertiesResponse(dict):
    """
    Properties for GraphAPIComputeServiceResource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationTime":
            suggest = "creation_time"
        elif key == "serviceType":
            suggest = "service_type"
        elif key == "graphApiComputeEndpoint":
            suggest = "graph_api_compute_endpoint"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceSize":
            suggest = "instance_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphAPIComputeServiceResourcePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphAPIComputeServiceResourcePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphAPIComputeServiceResourcePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_time: str,
                 locations: Sequence['outputs.GraphAPIComputeRegionalServiceResourceResponse'],
                 service_type: str,
                 status: str,
                 graph_api_compute_endpoint: Optional[str] = None,
                 instance_count: Optional[int] = None,
                 instance_size: Optional[str] = None):
        """
        Properties for GraphAPIComputeServiceResource.
        :param str creation_time: Time of the last state change (ISO-8601 format).
        :param Sequence['GraphAPIComputeRegionalServiceResourceResponse'] locations: An array that contains all of the locations for the service.
        :param str service_type: ServiceType for the service.
               Expected value is 'GraphAPICompute'.
        :param str status: Describes the status of a service.
        :param str graph_api_compute_endpoint: GraphAPICompute endpoint for the service.
        :param int instance_count: Instance count for the service.
        :param str instance_size: Instance type for the service.
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "locations", locations)
        pulumi.set(__self__, "service_type", 'GraphAPICompute')
        pulumi.set(__self__, "status", status)
        if graph_api_compute_endpoint is not None:
            pulumi.set(__self__, "graph_api_compute_endpoint", graph_api_compute_endpoint)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size is not None:
            pulumi.set(__self__, "instance_size", instance_size)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Time of the last state change (ISO-8601 format).
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def locations(self) -> Sequence['outputs.GraphAPIComputeRegionalServiceResourceResponse']:
        """
        An array that contains all of the locations for the service.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> str:
        """
        ServiceType for the service.
        Expected value is 'GraphAPICompute'.
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Describes the status of a service.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="graphApiComputeEndpoint")
    def graph_api_compute_endpoint(self) -> Optional[str]:
        """
        GraphAPICompute endpoint for the service.
        """
        return pulumi.get(self, "graph_api_compute_endpoint")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        Instance count for the service.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceSize")
    def instance_size(self) -> Optional[str]:
        """
        Instance type for the service.
        """
        return pulumi.get(self, "instance_size")


@pulumi.output_type
class GraphResourceGetPropertiesResponseOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscaleSettings":
            suggest = "autoscale_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphResourceGetPropertiesResponseOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphResourceGetPropertiesResponseOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphResourceGetPropertiesResponseOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale_settings: Optional['outputs.AutoscaleSettingsResponse'] = None,
                 throughput: Optional[int] = None):
        """
        :param 'AutoscaleSettingsResponse' autoscale_settings: Specifies the Autoscale settings.
        :param int throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        if autoscale_settings is not None:
            pulumi.set(__self__, "autoscale_settings", autoscale_settings)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @property
    @pulumi.getter(name="autoscaleSettings")
    def autoscale_settings(self) -> Optional['outputs.AutoscaleSettingsResponse']:
        """
        Specifies the Autoscale settings.
        """
        return pulumi.get(self, "autoscale_settings")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[int]:
        """
        Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        return pulumi.get(self, "throughput")


@pulumi.output_type
class GraphResourceGetPropertiesResponseResource(dict):
    def __init__(__self__, *,
                 id: str):
        """
        :param str id: Name of the Cosmos DB Graph
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Name of the Cosmos DB Graph
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GremlinDatabaseGetPropertiesResponseOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscaleSettings":
            suggest = "autoscale_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GremlinDatabaseGetPropertiesResponseOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GremlinDatabaseGetPropertiesResponseOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GremlinDatabaseGetPropertiesResponseOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale_settings: Optional['outputs.AutoscaleSettingsResponse'] = None,
                 throughput: Optional[int] = None):
        """
        :param 'AutoscaleSettingsResponse' autoscale_settings: Specifies the Autoscale settings.
        :param int throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        if autoscale_settings is not None:
            pulumi.set(__self__, "autoscale_settings", autoscale_settings)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @property
    @pulumi.getter(name="autoscaleSettings")
    def autoscale_settings(self) -> Optional['outputs.AutoscaleSettingsResponse']:
        """
        Specifies the Autoscale settings.
        """
        return pulumi.get(self, "autoscale_settings")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[int]:
        """
        Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        return pulumi.get(self, "throughput")


@pulumi.output_type
class GremlinDatabaseGetPropertiesResponseResource(dict):
    def __init__(__self__, *,
                 etag: str,
                 id: str,
                 rid: str,
                 ts: float):
        """
        :param str etag: A system generated property representing the resource etag required for optimistic concurrency control.
        :param str id: Name of the Cosmos DB Gremlin database
        :param str rid: A system generated property. A unique identifier.
        :param float ts: A system generated property that denotes the last updated timestamp of the resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "rid", rid)
        pulumi.set(__self__, "ts", ts)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A system generated property representing the resource etag required for optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Name of the Cosmos DB Gremlin database
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rid(self) -> str:
        """
        A system generated property. A unique identifier.
        """
        return pulumi.get(self, "rid")

    @property
    @pulumi.getter
    def ts(self) -> float:
        """
        A system generated property that denotes the last updated timestamp of the resource.
        """
        return pulumi.get(self, "ts")


@pulumi.output_type
class GremlinDatabaseRestoreResourceResponse(dict):
    """
    Specific Gremlin Databases to restore.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "graphNames":
            suggest = "graph_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GremlinDatabaseRestoreResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GremlinDatabaseRestoreResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GremlinDatabaseRestoreResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: Optional[str] = None,
                 graph_names: Optional[Sequence[str]] = None):
        """
        Specific Gremlin Databases to restore.
        :param str database_name: The name of the gremlin database available for restore.
        :param Sequence[str] graph_names: The names of the graphs available for restore.
        """
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if graph_names is not None:
            pulumi.set(__self__, "graph_names", graph_names)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        The name of the gremlin database available for restore.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="graphNames")
    def graph_names(self) -> Optional[Sequence[str]]:
        """
        The names of the graphs available for restore.
        """
        return pulumi.get(self, "graph_names")


@pulumi.output_type
class GremlinGraphGetPropertiesResponseOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscaleSettings":
            suggest = "autoscale_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GremlinGraphGetPropertiesResponseOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GremlinGraphGetPropertiesResponseOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GremlinGraphGetPropertiesResponseOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale_settings: Optional['outputs.AutoscaleSettingsResponse'] = None,
                 throughput: Optional[int] = None):
        """
        :param 'AutoscaleSettingsResponse' autoscale_settings: Specifies the Autoscale settings.
        :param int throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        if autoscale_settings is not None:
            pulumi.set(__self__, "autoscale_settings", autoscale_settings)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @property
    @pulumi.getter(name="autoscaleSettings")
    def autoscale_settings(self) -> Optional['outputs.AutoscaleSettingsResponse']:
        """
        Specifies the Autoscale settings.
        """
        return pulumi.get(self, "autoscale_settings")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[int]:
        """
        Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        return pulumi.get(self, "throughput")


@pulumi.output_type
class GremlinGraphGetPropertiesResponseResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analyticalStorageTtl":
            suggest = "analytical_storage_ttl"
        elif key == "conflictResolutionPolicy":
            suggest = "conflict_resolution_policy"
        elif key == "defaultTtl":
            suggest = "default_ttl"
        elif key == "indexingPolicy":
            suggest = "indexing_policy"
        elif key == "partitionKey":
            suggest = "partition_key"
        elif key == "uniqueKeyPolicy":
            suggest = "unique_key_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GremlinGraphGetPropertiesResponseResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GremlinGraphGetPropertiesResponseResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GremlinGraphGetPropertiesResponseResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 id: str,
                 rid: str,
                 ts: float,
                 analytical_storage_ttl: Optional[float] = None,
                 conflict_resolution_policy: Optional['outputs.ConflictResolutionPolicyResponse'] = None,
                 default_ttl: Optional[int] = None,
                 indexing_policy: Optional['outputs.IndexingPolicyResponse'] = None,
                 partition_key: Optional['outputs.ContainerPartitionKeyResponse'] = None,
                 unique_key_policy: Optional['outputs.UniqueKeyPolicyResponse'] = None):
        """
        :param str etag: A system generated property representing the resource etag required for optimistic concurrency control.
        :param str id: Name of the Cosmos DB Gremlin graph
        :param str rid: A system generated property. A unique identifier.
        :param float ts: A system generated property that denotes the last updated timestamp of the resource.
        :param float analytical_storage_ttl: Analytical TTL.
        :param 'ConflictResolutionPolicyResponse' conflict_resolution_policy: The conflict resolution policy for the graph.
        :param int default_ttl: Default time to live
        :param 'IndexingPolicyResponse' indexing_policy: The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the graph
        :param 'ContainerPartitionKeyResponse' partition_key: The configuration of the partition key to be used for partitioning data into multiple partitions
        :param 'UniqueKeyPolicyResponse' unique_key_policy: The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "rid", rid)
        pulumi.set(__self__, "ts", ts)
        if analytical_storage_ttl is not None:
            pulumi.set(__self__, "analytical_storage_ttl", analytical_storage_ttl)
        if conflict_resolution_policy is not None:
            pulumi.set(__self__, "conflict_resolution_policy", conflict_resolution_policy)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if indexing_policy is not None:
            pulumi.set(__self__, "indexing_policy", indexing_policy)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)
        if unique_key_policy is not None:
            pulumi.set(__self__, "unique_key_policy", unique_key_policy)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A system generated property representing the resource etag required for optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Name of the Cosmos DB Gremlin graph
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rid(self) -> str:
        """
        A system generated property. A unique identifier.
        """
        return pulumi.get(self, "rid")

    @property
    @pulumi.getter
    def ts(self) -> float:
        """
        A system generated property that denotes the last updated timestamp of the resource.
        """
        return pulumi.get(self, "ts")

    @property
    @pulumi.getter(name="analyticalStorageTtl")
    def analytical_storage_ttl(self) -> Optional[float]:
        """
        Analytical TTL.
        """
        return pulumi.get(self, "analytical_storage_ttl")

    @property
    @pulumi.getter(name="conflictResolutionPolicy")
    def conflict_resolution_policy(self) -> Optional['outputs.ConflictResolutionPolicyResponse']:
        """
        The conflict resolution policy for the graph.
        """
        return pulumi.get(self, "conflict_resolution_policy")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[int]:
        """
        Default time to live
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="indexingPolicy")
    def indexing_policy(self) -> Optional['outputs.IndexingPolicyResponse']:
        """
        The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the graph
        """
        return pulumi.get(self, "indexing_policy")

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional['outputs.ContainerPartitionKeyResponse']:
        """
        The configuration of the partition key to be used for partitioning data into multiple partitions
        """
        return pulumi.get(self, "partition_key")

    @property
    @pulumi.getter(name="uniqueKeyPolicy")
    def unique_key_policy(self) -> Optional['outputs.UniqueKeyPolicyResponse']:
        """
        The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
        """
        return pulumi.get(self, "unique_key_policy")


@pulumi.output_type
class IncludedPathResponse(dict):
    """
    The paths that are included in indexing
    """
    def __init__(__self__, *,
                 indexes: Optional[Sequence['outputs.IndexesResponse']] = None,
                 path: Optional[str] = None):
        """
        The paths that are included in indexing
        :param Sequence['IndexesResponse'] indexes: List of indexes for this path
        :param str path: The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
        """
        if indexes is not None:
            pulumi.set(__self__, "indexes", indexes)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def indexes(self) -> Optional[Sequence['outputs.IndexesResponse']]:
        """
        List of indexes for this path
        """
        return pulumi.get(self, "indexes")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class IndexesResponse(dict):
    """
    The indexes for the path.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_type: Optional[str] = None,
                 kind: Optional[str] = None,
                 precision: Optional[int] = None):
        """
        The indexes for the path.
        :param str data_type: The datatype for which the indexing behavior is applied to.
        :param str kind: Indicates the type of index.
        :param int precision: The precision of the index. -1 is maximum precision.
        """
        if data_type is None:
            data_type = 'String'
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if kind is None:
            kind = 'Hash'
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The datatype for which the indexing behavior is applied to.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Indicates the type of index.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def precision(self) -> Optional[int]:
        """
        The precision of the index. -1 is maximum precision.
        """
        return pulumi.get(self, "precision")


@pulumi.output_type
class IndexingPolicyResponse(dict):
    """
    Cosmos DB indexing policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compositeIndexes":
            suggest = "composite_indexes"
        elif key == "excludedPaths":
            suggest = "excluded_paths"
        elif key == "includedPaths":
            suggest = "included_paths"
        elif key == "indexingMode":
            suggest = "indexing_mode"
        elif key == "spatialIndexes":
            suggest = "spatial_indexes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexingPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexingPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexingPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic: Optional[bool] = None,
                 composite_indexes: Optional[Sequence[Sequence['outputs.CompositePathResponse']]] = None,
                 excluded_paths: Optional[Sequence['outputs.ExcludedPathResponse']] = None,
                 included_paths: Optional[Sequence['outputs.IncludedPathResponse']] = None,
                 indexing_mode: Optional[str] = None,
                 spatial_indexes: Optional[Sequence['outputs.SpatialSpecResponse']] = None):
        """
        Cosmos DB indexing policy
        :param bool automatic: Indicates if the indexing policy is automatic
        :param Sequence[Sequence['CompositePathResponse']] composite_indexes: List of composite path list
        :param Sequence['ExcludedPathResponse'] excluded_paths: List of paths to exclude from indexing
        :param Sequence['IncludedPathResponse'] included_paths: List of paths to include in the indexing
        :param str indexing_mode: Indicates the indexing mode.
        :param Sequence['SpatialSpecResponse'] spatial_indexes: List of spatial specifics
        """
        if automatic is not None:
            pulumi.set(__self__, "automatic", automatic)
        if composite_indexes is not None:
            pulumi.set(__self__, "composite_indexes", composite_indexes)
        if excluded_paths is not None:
            pulumi.set(__self__, "excluded_paths", excluded_paths)
        if included_paths is not None:
            pulumi.set(__self__, "included_paths", included_paths)
        if indexing_mode is None:
            indexing_mode = 'consistent'
        if indexing_mode is not None:
            pulumi.set(__self__, "indexing_mode", indexing_mode)
        if spatial_indexes is not None:
            pulumi.set(__self__, "spatial_indexes", spatial_indexes)

    @property
    @pulumi.getter
    def automatic(self) -> Optional[bool]:
        """
        Indicates if the indexing policy is automatic
        """
        return pulumi.get(self, "automatic")

    @property
    @pulumi.getter(name="compositeIndexes")
    def composite_indexes(self) -> Optional[Sequence[Sequence['outputs.CompositePathResponse']]]:
        """
        List of composite path list
        """
        return pulumi.get(self, "composite_indexes")

    @property
    @pulumi.getter(name="excludedPaths")
    def excluded_paths(self) -> Optional[Sequence['outputs.ExcludedPathResponse']]:
        """
        List of paths to exclude from indexing
        """
        return pulumi.get(self, "excluded_paths")

    @property
    @pulumi.getter(name="includedPaths")
    def included_paths(self) -> Optional[Sequence['outputs.IncludedPathResponse']]:
        """
        List of paths to include in the indexing
        """
        return pulumi.get(self, "included_paths")

    @property
    @pulumi.getter(name="indexingMode")
    def indexing_mode(self) -> Optional[str]:
        """
        Indicates the indexing mode.
        """
        return pulumi.get(self, "indexing_mode")

    @property
    @pulumi.getter(name="spatialIndexes")
    def spatial_indexes(self) -> Optional[Sequence['outputs.SpatialSpecResponse']]:
        """
        List of spatial specifics
        """
        return pulumi.get(self, "spatial_indexes")


@pulumi.output_type
class IpAddressOrRangeResponse(dict):
    """
    IpAddressOrRange object
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddressOrRange":
            suggest = "ip_address_or_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpAddressOrRangeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpAddressOrRangeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpAddressOrRangeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address_or_range: Optional[str] = None):
        """
        IpAddressOrRange object
        :param str ip_address_or_range: A single IPv4 address or a single IPv4 address range in CIDR format. Provided IPs must be well-formatted and cannot be contained in one of the following ranges: 10.0.0.0/8, 100.64.0.0/10, 172.16.0.0/12, 192.168.0.0/16, since these are not enforceable by the IP address filter. Example of valid inputs: “23.40.210.245” or “23.40.210.0/8”.
        """
        if ip_address_or_range is not None:
            pulumi.set(__self__, "ip_address_or_range", ip_address_or_range)

    @property
    @pulumi.getter(name="ipAddressOrRange")
    def ip_address_or_range(self) -> Optional[str]:
        """
        A single IPv4 address or a single IPv4 address range in CIDR format. Provided IPs must be well-formatted and cannot be contained in one of the following ranges: 10.0.0.0/8, 100.64.0.0/10, 172.16.0.0/12, 192.168.0.0/16, since these are not enforceable by the IP address filter. Example of valid inputs: “23.40.210.245” or “23.40.210.0/8”.
        """
        return pulumi.get(self, "ip_address_or_range")


@pulumi.output_type
class LocationResponse(dict):
    """
    A region in which the Azure Cosmos DB database account is deployed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "documentEndpoint":
            suggest = "document_endpoint"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "failoverPriority":
            suggest = "failover_priority"
        elif key == "isZoneRedundant":
            suggest = "is_zone_redundant"
        elif key == "locationName":
            suggest = "location_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 document_endpoint: str,
                 id: str,
                 provisioning_state: str,
                 failover_priority: Optional[int] = None,
                 is_zone_redundant: Optional[bool] = None,
                 location_name: Optional[str] = None):
        """
        A region in which the Azure Cosmos DB database account is deployed.
        :param str document_endpoint: The connection endpoint for the specific region. Example: https://&lt;accountName&gt;-&lt;locationName&gt;.documents.azure.com:443/
        :param str id: The unique identifier of the region within the database account. Example: &lt;accountName&gt;-&lt;locationName&gt;.
        :param str provisioning_state: The status of the Cosmos DB account at the time the operation was called. The status can be one of following. 'Creating' – the Cosmos DB account is being created. When an account is in Creating state, only properties that are specified as input for the Create Cosmos DB account operation are returned. 'Succeeded' – the Cosmos DB account is active for use. 'Updating' – the Cosmos DB account is being updated. 'Deleting' – the Cosmos DB account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'DeletionFailed' – the Cosmos DB account deletion failed.
        :param int failover_priority: The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
        :param bool is_zone_redundant: Flag to indicate whether or not this region is an AvailabilityZone region
        :param str location_name: The name of the region.
        """
        pulumi.set(__self__, "document_endpoint", document_endpoint)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if failover_priority is not None:
            pulumi.set(__self__, "failover_priority", failover_priority)
        if is_zone_redundant is not None:
            pulumi.set(__self__, "is_zone_redundant", is_zone_redundant)
        if location_name is not None:
            pulumi.set(__self__, "location_name", location_name)

    @property
    @pulumi.getter(name="documentEndpoint")
    def document_endpoint(self) -> str:
        """
        The connection endpoint for the specific region. Example: https://&lt;accountName&gt;-&lt;locationName&gt;.documents.azure.com:443/
        """
        return pulumi.get(self, "document_endpoint")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique identifier of the region within the database account. Example: &lt;accountName&gt;-&lt;locationName&gt;.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The status of the Cosmos DB account at the time the operation was called. The status can be one of following. 'Creating' – the Cosmos DB account is being created. When an account is in Creating state, only properties that are specified as input for the Create Cosmos DB account operation are returned. 'Succeeded' – the Cosmos DB account is active for use. 'Updating' – the Cosmos DB account is being updated. 'Deleting' – the Cosmos DB account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'DeletionFailed' – the Cosmos DB account deletion failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="failoverPriority")
    def failover_priority(self) -> Optional[int]:
        """
        The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
        """
        return pulumi.get(self, "failover_priority")

    @property
    @pulumi.getter(name="isZoneRedundant")
    def is_zone_redundant(self) -> Optional[bool]:
        """
        Flag to indicate whether or not this region is an AvailabilityZone region
        """
        return pulumi.get(self, "is_zone_redundant")

    @property
    @pulumi.getter(name="locationName")
    def location_name(self) -> Optional[str]:
        """
        The name of the region.
        """
        return pulumi.get(self, "location_name")


@pulumi.output_type
class ManagedCassandraManagedServiceIdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedCassandraManagedServiceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedCassandraManagedServiceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedCassandraManagedServiceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Identity for the resource.
        :param str principal_id: The object id of the identity resource.
        :param str tenant_id: The tenant id of the resource.
        :param str type: The type of the resource.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The object id of the identity resource.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id of the resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ManagedServiceIdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedServiceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedServiceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedServiceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.ManagedServiceIdentityResponseUserAssignedIdentities']] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal id of the system assigned identity. This property will only be provided for a system assigned identity.
        :param str tenant_id: The tenant id of the system assigned identity. This property will only be provided for a system assigned identity.
        :param str type: The type of identity used for the resource. The type 'SystemAssigned,UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
        :param Mapping[str, 'ManagedServiceIdentityResponseUserAssignedIdentities'] user_assigned_identities: The list of user identities associated with resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of the system assigned identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id of the system assigned identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of identity used for the resource. The type 'SystemAssigned,UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.ManagedServiceIdentityResponseUserAssignedIdentities']]:
        """
        The list of user identities associated with resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class ManagedServiceIdentityResponseUserAssignedIdentities(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedServiceIdentityResponseUserAssignedIdentities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedServiceIdentityResponseUserAssignedIdentities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedServiceIdentityResponseUserAssignedIdentities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        :param str client_id: The client id of user assigned identity.
        :param str principal_id: The principal id of user assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client id of user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class MaterializedViewsBuilderRegionalServiceResourceResponse(dict):
    """
    Resource for a regional service location.
    """
    def __init__(__self__, *,
                 location: str,
                 name: str,
                 status: str):
        """
        Resource for a regional service location.
        :param str location: The location name.
        :param str name: The regional service name.
        :param str status: Describes the status of a service.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location name.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The regional service name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Describes the status of a service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class MaterializedViewsBuilderServiceResourcePropertiesResponse(dict):
    """
    Properties for MaterializedViewsBuilderServiceResource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationTime":
            suggest = "creation_time"
        elif key == "serviceType":
            suggest = "service_type"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceSize":
            suggest = "instance_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaterializedViewsBuilderServiceResourcePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaterializedViewsBuilderServiceResourcePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaterializedViewsBuilderServiceResourcePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_time: str,
                 locations: Sequence['outputs.MaterializedViewsBuilderRegionalServiceResourceResponse'],
                 service_type: str,
                 status: str,
                 instance_count: Optional[int] = None,
                 instance_size: Optional[str] = None):
        """
        Properties for MaterializedViewsBuilderServiceResource.
        :param str creation_time: Time of the last state change (ISO-8601 format).
        :param Sequence['MaterializedViewsBuilderRegionalServiceResourceResponse'] locations: An array that contains all of the locations for the service.
        :param str service_type: ServiceType for the service.
               Expected value is 'MaterializedViewsBuilder'.
        :param str status: Describes the status of a service.
        :param int instance_count: Instance count for the service.
        :param str instance_size: Instance type for the service.
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "locations", locations)
        pulumi.set(__self__, "service_type", 'MaterializedViewsBuilder')
        pulumi.set(__self__, "status", status)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size is not None:
            pulumi.set(__self__, "instance_size", instance_size)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Time of the last state change (ISO-8601 format).
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def locations(self) -> Sequence['outputs.MaterializedViewsBuilderRegionalServiceResourceResponse']:
        """
        An array that contains all of the locations for the service.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> str:
        """
        ServiceType for the service.
        Expected value is 'MaterializedViewsBuilder'.
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Describes the status of a service.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        Instance count for the service.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceSize")
    def instance_size(self) -> Optional[str]:
        """
        Instance type for the service.
        """
        return pulumi.get(self, "instance_size")


@pulumi.output_type
class MongoDBCollectionGetPropertiesResponseOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscaleSettings":
            suggest = "autoscale_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MongoDBCollectionGetPropertiesResponseOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MongoDBCollectionGetPropertiesResponseOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MongoDBCollectionGetPropertiesResponseOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale_settings: Optional['outputs.AutoscaleSettingsResponse'] = None,
                 throughput: Optional[int] = None):
        """
        :param 'AutoscaleSettingsResponse' autoscale_settings: Specifies the Autoscale settings.
        :param int throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        if autoscale_settings is not None:
            pulumi.set(__self__, "autoscale_settings", autoscale_settings)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @property
    @pulumi.getter(name="autoscaleSettings")
    def autoscale_settings(self) -> Optional['outputs.AutoscaleSettingsResponse']:
        """
        Specifies the Autoscale settings.
        """
        return pulumi.get(self, "autoscale_settings")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[int]:
        """
        Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        return pulumi.get(self, "throughput")


@pulumi.output_type
class MongoDBCollectionGetPropertiesResponseResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analyticalStorageTtl":
            suggest = "analytical_storage_ttl"
        elif key == "shardKey":
            suggest = "shard_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MongoDBCollectionGetPropertiesResponseResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MongoDBCollectionGetPropertiesResponseResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MongoDBCollectionGetPropertiesResponseResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 id: str,
                 rid: str,
                 ts: float,
                 analytical_storage_ttl: Optional[int] = None,
                 indexes: Optional[Sequence['outputs.MongoIndexResponse']] = None,
                 shard_key: Optional[Mapping[str, str]] = None):
        """
        :param str etag: A system generated property representing the resource etag required for optimistic concurrency control.
        :param str id: Name of the Cosmos DB MongoDB collection
        :param str rid: A system generated property. A unique identifier.
        :param float ts: A system generated property that denotes the last updated timestamp of the resource.
        :param int analytical_storage_ttl: Analytical TTL.
        :param Sequence['MongoIndexResponse'] indexes: List of index keys
        :param Mapping[str, str] shard_key: A key-value pair of shard keys to be applied for the request.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "rid", rid)
        pulumi.set(__self__, "ts", ts)
        if analytical_storage_ttl is not None:
            pulumi.set(__self__, "analytical_storage_ttl", analytical_storage_ttl)
        if indexes is not None:
            pulumi.set(__self__, "indexes", indexes)
        if shard_key is not None:
            pulumi.set(__self__, "shard_key", shard_key)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A system generated property representing the resource etag required for optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Name of the Cosmos DB MongoDB collection
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rid(self) -> str:
        """
        A system generated property. A unique identifier.
        """
        return pulumi.get(self, "rid")

    @property
    @pulumi.getter
    def ts(self) -> float:
        """
        A system generated property that denotes the last updated timestamp of the resource.
        """
        return pulumi.get(self, "ts")

    @property
    @pulumi.getter(name="analyticalStorageTtl")
    def analytical_storage_ttl(self) -> Optional[int]:
        """
        Analytical TTL.
        """
        return pulumi.get(self, "analytical_storage_ttl")

    @property
    @pulumi.getter
    def indexes(self) -> Optional[Sequence['outputs.MongoIndexResponse']]:
        """
        List of index keys
        """
        return pulumi.get(self, "indexes")

    @property
    @pulumi.getter(name="shardKey")
    def shard_key(self) -> Optional[Mapping[str, str]]:
        """
        A key-value pair of shard keys to be applied for the request.
        """
        return pulumi.get(self, "shard_key")


@pulumi.output_type
class MongoDBDatabaseGetPropertiesResponseOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscaleSettings":
            suggest = "autoscale_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MongoDBDatabaseGetPropertiesResponseOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MongoDBDatabaseGetPropertiesResponseOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MongoDBDatabaseGetPropertiesResponseOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale_settings: Optional['outputs.AutoscaleSettingsResponse'] = None,
                 throughput: Optional[int] = None):
        """
        :param 'AutoscaleSettingsResponse' autoscale_settings: Specifies the Autoscale settings.
        :param int throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        if autoscale_settings is not None:
            pulumi.set(__self__, "autoscale_settings", autoscale_settings)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @property
    @pulumi.getter(name="autoscaleSettings")
    def autoscale_settings(self) -> Optional['outputs.AutoscaleSettingsResponse']:
        """
        Specifies the Autoscale settings.
        """
        return pulumi.get(self, "autoscale_settings")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[int]:
        """
        Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        return pulumi.get(self, "throughput")


@pulumi.output_type
class MongoDBDatabaseGetPropertiesResponseResource(dict):
    def __init__(__self__, *,
                 etag: str,
                 id: str,
                 rid: str,
                 ts: float):
        """
        :param str etag: A system generated property representing the resource etag required for optimistic concurrency control.
        :param str id: Name of the Cosmos DB MongoDB database
        :param str rid: A system generated property. A unique identifier.
        :param float ts: A system generated property that denotes the last updated timestamp of the resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "rid", rid)
        pulumi.set(__self__, "ts", ts)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A system generated property representing the resource etag required for optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Name of the Cosmos DB MongoDB database
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rid(self) -> str:
        """
        A system generated property. A unique identifier.
        """
        return pulumi.get(self, "rid")

    @property
    @pulumi.getter
    def ts(self) -> float:
        """
        A system generated property that denotes the last updated timestamp of the resource.
        """
        return pulumi.get(self, "ts")


@pulumi.output_type
class MongoIndexKeysResponse(dict):
    """
    Cosmos DB MongoDB collection resource object
    """
    def __init__(__self__, *,
                 keys: Optional[Sequence[str]] = None):
        """
        Cosmos DB MongoDB collection resource object
        :param Sequence[str] keys: List of keys for each MongoDB collection in the Azure Cosmos DB service
        """
        if keys is not None:
            pulumi.set(__self__, "keys", keys)

    @property
    @pulumi.getter
    def keys(self) -> Optional[Sequence[str]]:
        """
        List of keys for each MongoDB collection in the Azure Cosmos DB service
        """
        return pulumi.get(self, "keys")


@pulumi.output_type
class MongoIndexOptionsResponse(dict):
    """
    Cosmos DB MongoDB collection index options
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expireAfterSeconds":
            suggest = "expire_after_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MongoIndexOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MongoIndexOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MongoIndexOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expire_after_seconds: Optional[int] = None,
                 unique: Optional[bool] = None):
        """
        Cosmos DB MongoDB collection index options
        :param int expire_after_seconds: Expire after seconds
        :param bool unique: Is unique or not
        """
        if expire_after_seconds is not None:
            pulumi.set(__self__, "expire_after_seconds", expire_after_seconds)
        if unique is not None:
            pulumi.set(__self__, "unique", unique)

    @property
    @pulumi.getter(name="expireAfterSeconds")
    def expire_after_seconds(self) -> Optional[int]:
        """
        Expire after seconds
        """
        return pulumi.get(self, "expire_after_seconds")

    @property
    @pulumi.getter
    def unique(self) -> Optional[bool]:
        """
        Is unique or not
        """
        return pulumi.get(self, "unique")


@pulumi.output_type
class MongoIndexResponse(dict):
    """
    Cosmos DB MongoDB collection index key
    """
    def __init__(__self__, *,
                 key: Optional['outputs.MongoIndexKeysResponse'] = None,
                 options: Optional['outputs.MongoIndexOptionsResponse'] = None):
        """
        Cosmos DB MongoDB collection index key
        :param 'MongoIndexKeysResponse' key: Cosmos DB MongoDB collection index keys
        :param 'MongoIndexOptionsResponse' options: Cosmos DB MongoDB collection index key options
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if options is not None:
            pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def key(self) -> Optional['outputs.MongoIndexKeysResponse']:
        """
        Cosmos DB MongoDB collection index keys
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def options(self) -> Optional['outputs.MongoIndexOptionsResponse']:
        """
        Cosmos DB MongoDB collection index key options
        """
        return pulumi.get(self, "options")


@pulumi.output_type
class PeriodicModeBackupPolicyResponse(dict):
    """
    The object representing periodic mode backup policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "migrationState":
            suggest = "migration_state"
        elif key == "periodicModeProperties":
            suggest = "periodic_mode_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PeriodicModeBackupPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PeriodicModeBackupPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PeriodicModeBackupPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 migration_state: Optional['outputs.BackupPolicyMigrationStateResponse'] = None,
                 periodic_mode_properties: Optional['outputs.PeriodicModePropertiesResponse'] = None):
        """
        The object representing periodic mode backup policy.
        :param str type: Describes the mode of backups.
               Expected value is 'Periodic'.
        :param 'BackupPolicyMigrationStateResponse' migration_state: The object representing the state of the migration between the backup policies.
        :param 'PeriodicModePropertiesResponse' periodic_mode_properties: Configuration values for periodic mode backup
        """
        pulumi.set(__self__, "type", 'Periodic')
        if migration_state is not None:
            pulumi.set(__self__, "migration_state", migration_state)
        if periodic_mode_properties is not None:
            pulumi.set(__self__, "periodic_mode_properties", periodic_mode_properties)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Describes the mode of backups.
        Expected value is 'Periodic'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="migrationState")
    def migration_state(self) -> Optional['outputs.BackupPolicyMigrationStateResponse']:
        """
        The object representing the state of the migration between the backup policies.
        """
        return pulumi.get(self, "migration_state")

    @property
    @pulumi.getter(name="periodicModeProperties")
    def periodic_mode_properties(self) -> Optional['outputs.PeriodicModePropertiesResponse']:
        """
        Configuration values for periodic mode backup
        """
        return pulumi.get(self, "periodic_mode_properties")


@pulumi.output_type
class PeriodicModePropertiesResponse(dict):
    """
    Configuration values for periodic mode backup
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupIntervalInMinutes":
            suggest = "backup_interval_in_minutes"
        elif key == "backupRetentionIntervalInHours":
            suggest = "backup_retention_interval_in_hours"
        elif key == "backupStorageRedundancy":
            suggest = "backup_storage_redundancy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PeriodicModePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PeriodicModePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PeriodicModePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_interval_in_minutes: Optional[int] = None,
                 backup_retention_interval_in_hours: Optional[int] = None,
                 backup_storage_redundancy: Optional[str] = None):
        """
        Configuration values for periodic mode backup
        :param int backup_interval_in_minutes: An integer representing the interval in minutes between two backups
        :param int backup_retention_interval_in_hours: An integer representing the time (in hours) that each backup is retained
        :param str backup_storage_redundancy: Enum to indicate type of backup residency
        """
        if backup_interval_in_minutes is not None:
            pulumi.set(__self__, "backup_interval_in_minutes", backup_interval_in_minutes)
        if backup_retention_interval_in_hours is not None:
            pulumi.set(__self__, "backup_retention_interval_in_hours", backup_retention_interval_in_hours)
        if backup_storage_redundancy is not None:
            pulumi.set(__self__, "backup_storage_redundancy", backup_storage_redundancy)

    @property
    @pulumi.getter(name="backupIntervalInMinutes")
    def backup_interval_in_minutes(self) -> Optional[int]:
        """
        An integer representing the interval in minutes between two backups
        """
        return pulumi.get(self, "backup_interval_in_minutes")

    @property
    @pulumi.getter(name="backupRetentionIntervalInHours")
    def backup_retention_interval_in_hours(self) -> Optional[int]:
        """
        An integer representing the time (in hours) that each backup is retained
        """
        return pulumi.get(self, "backup_retention_interval_in_hours")

    @property
    @pulumi.getter(name="backupStorageRedundancy")
    def backup_storage_redundancy(self) -> Optional[str]:
        """
        Enum to indicate type of backup residency
        """
        return pulumi.get(self, "backup_storage_redundancy")


@pulumi.output_type
class PermissionResponse(dict):
    """
    The set of data plane operations permitted through this Role Definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataActions":
            suggest = "data_actions"
        elif key == "notDataActions":
            suggest = "not_data_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_actions: Optional[Sequence[str]] = None,
                 not_data_actions: Optional[Sequence[str]] = None):
        """
        The set of data plane operations permitted through this Role Definition.
        :param Sequence[str] data_actions: An array of data actions that are allowed.
        :param Sequence[str] not_data_actions: An array of data actions that are denied.
        """
        if data_actions is not None:
            pulumi.set(__self__, "data_actions", data_actions)
        if not_data_actions is not None:
            pulumi.set(__self__, "not_data_actions", not_data_actions)

    @property
    @pulumi.getter(name="dataActions")
    def data_actions(self) -> Optional[Sequence[str]]:
        """
        An array of data actions that are allowed.
        """
        return pulumi.get(self, "data_actions")

    @property
    @pulumi.getter(name="notDataActions")
    def not_data_actions(self) -> Optional[Sequence[str]]:
        """
        An array of data actions that are denied.
        """
        return pulumi.get(self, "not_data_actions")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    A private endpoint connection
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupId":
            suggest = "group_id"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 type: str,
                 group_id: Optional[str] = None,
                 private_endpoint: Optional['outputs.PrivateEndpointPropertyResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStatePropertyResponse'] = None,
                 provisioning_state: Optional[str] = None):
        """
        A private endpoint connection
        :param str id: Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        :param str name: The name of the resource
        :param str type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        :param str group_id: Group id of the private endpoint.
        :param 'PrivateEndpointPropertyResponse' private_endpoint: Private endpoint which the connection belongs to.
        :param 'PrivateLinkServiceConnectionStatePropertyResponse' private_link_service_connection_state: Connection State of the Private Endpoint Connection.
        :param str provisioning_state: Provisioning state of the private endpoint.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[str]:
        """
        Group id of the private endpoint.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointPropertyResponse']:
        """
        Private endpoint which the connection belongs to.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStatePropertyResponse']:
        """
        Connection State of the Private Endpoint Connection.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the private endpoint.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class PrivateEndpointPropertyResponse(dict):
    """
    Private endpoint which the connection belongs to.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Private endpoint which the connection belongs to.
        :param str id: Resource id of the private endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource id of the private endpoint.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStatePropertyResponse(dict):
    """
    Connection State of the Private Endpoint Connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStatePropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStatePropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStatePropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: str,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        Connection State of the Private Endpoint Connection.
        :param str actions_required: Any action that is required beyond basic workflow (approve/ reject/ disconnect)
        :param str description: The private link service connection description.
        :param str status: The private link service connection status.
        """
        pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> str:
        """
        Any action that is required beyond basic workflow (approve/ reject/ disconnect)
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The private link service connection description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The private link service connection status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PrivilegeResponse(dict):
    """
    The set of data plane operations permitted through this Role Definition.
    """
    def __init__(__self__, *,
                 actions: Optional[Sequence[str]] = None,
                 resource: Optional['outputs.PrivilegeResponseResource'] = None):
        """
        The set of data plane operations permitted through this Role Definition.
        :param Sequence[str] actions: An array of actions that are allowed.
        :param 'PrivilegeResponseResource' resource: An Azure Cosmos DB Mongo DB Resource.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence[str]]:
        """
        An array of actions that are allowed.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def resource(self) -> Optional['outputs.PrivilegeResponseResource']:
        """
        An Azure Cosmos DB Mongo DB Resource.
        """
        return pulumi.get(self, "resource")


@pulumi.output_type
class PrivilegeResponseResource(dict):
    """
    An Azure Cosmos DB Mongo DB Resource.
    """
    def __init__(__self__, *,
                 collection: Optional[str] = None,
                 db: Optional[str] = None):
        """
        An Azure Cosmos DB Mongo DB Resource.
        :param str collection: The collection name the role is applied.
        :param str db: The database name the role is applied.
        """
        if collection is not None:
            pulumi.set(__self__, "collection", collection)
        if db is not None:
            pulumi.set(__self__, "db", db)

    @property
    @pulumi.getter
    def collection(self) -> Optional[str]:
        """
        The collection name the role is applied.
        """
        return pulumi.get(self, "collection")

    @property
    @pulumi.getter
    def db(self) -> Optional[str]:
        """
        The database name the role is applied.
        """
        return pulumi.get(self, "db")


@pulumi.output_type
class RestoreParametersResponse(dict):
    """
    Parameters to indicate the information about the restore.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databasesToRestore":
            suggest = "databases_to_restore"
        elif key == "gremlinDatabasesToRestore":
            suggest = "gremlin_databases_to_restore"
        elif key == "restoreMode":
            suggest = "restore_mode"
        elif key == "restoreSource":
            suggest = "restore_source"
        elif key == "restoreTimestampInUtc":
            suggest = "restore_timestamp_in_utc"
        elif key == "tablesToRestore":
            suggest = "tables_to_restore"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestoreParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestoreParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestoreParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 databases_to_restore: Optional[Sequence['outputs.DatabaseRestoreResourceResponse']] = None,
                 gremlin_databases_to_restore: Optional[Sequence['outputs.GremlinDatabaseRestoreResourceResponse']] = None,
                 restore_mode: Optional[str] = None,
                 restore_source: Optional[str] = None,
                 restore_timestamp_in_utc: Optional[str] = None,
                 tables_to_restore: Optional[Sequence[str]] = None):
        """
        Parameters to indicate the information about the restore.
        :param Sequence['DatabaseRestoreResourceResponse'] databases_to_restore: List of specific databases available for restore.
        :param Sequence['GremlinDatabaseRestoreResourceResponse'] gremlin_databases_to_restore: List of specific gremlin databases available for restore.
        :param str restore_mode: Describes the mode of the restore.
        :param str restore_source: The id of the restorable database account from which the restore has to be initiated. For example: /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}
        :param str restore_timestamp_in_utc: Time to which the account has to be restored (ISO-8601 format).
        :param Sequence[str] tables_to_restore: List of specific tables available for restore.
        """
        if databases_to_restore is not None:
            pulumi.set(__self__, "databases_to_restore", databases_to_restore)
        if gremlin_databases_to_restore is not None:
            pulumi.set(__self__, "gremlin_databases_to_restore", gremlin_databases_to_restore)
        if restore_mode is not None:
            pulumi.set(__self__, "restore_mode", restore_mode)
        if restore_source is not None:
            pulumi.set(__self__, "restore_source", restore_source)
        if restore_timestamp_in_utc is not None:
            pulumi.set(__self__, "restore_timestamp_in_utc", restore_timestamp_in_utc)
        if tables_to_restore is not None:
            pulumi.set(__self__, "tables_to_restore", tables_to_restore)

    @property
    @pulumi.getter(name="databasesToRestore")
    def databases_to_restore(self) -> Optional[Sequence['outputs.DatabaseRestoreResourceResponse']]:
        """
        List of specific databases available for restore.
        """
        return pulumi.get(self, "databases_to_restore")

    @property
    @pulumi.getter(name="gremlinDatabasesToRestore")
    def gremlin_databases_to_restore(self) -> Optional[Sequence['outputs.GremlinDatabaseRestoreResourceResponse']]:
        """
        List of specific gremlin databases available for restore.
        """
        return pulumi.get(self, "gremlin_databases_to_restore")

    @property
    @pulumi.getter(name="restoreMode")
    def restore_mode(self) -> Optional[str]:
        """
        Describes the mode of the restore.
        """
        return pulumi.get(self, "restore_mode")

    @property
    @pulumi.getter(name="restoreSource")
    def restore_source(self) -> Optional[str]:
        """
        The id of the restorable database account from which the restore has to be initiated. For example: /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}
        """
        return pulumi.get(self, "restore_source")

    @property
    @pulumi.getter(name="restoreTimestampInUtc")
    def restore_timestamp_in_utc(self) -> Optional[str]:
        """
        Time to which the account has to be restored (ISO-8601 format).
        """
        return pulumi.get(self, "restore_timestamp_in_utc")

    @property
    @pulumi.getter(name="tablesToRestore")
    def tables_to_restore(self) -> Optional[Sequence[str]]:
        """
        List of specific tables available for restore.
        """
        return pulumi.get(self, "tables_to_restore")


@pulumi.output_type
class RoleResponse(dict):
    """
    The set of roles permitted through this Role Definition.
    """
    def __init__(__self__, *,
                 db: Optional[str] = None,
                 role: Optional[str] = None):
        """
        The set of roles permitted through this Role Definition.
        :param str db: The database name the role is applied.
        :param str role: The role name.
        """
        if db is not None:
            pulumi.set(__self__, "db", db)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def db(self) -> Optional[str]:
        """
        The database name the role is applied.
        """
        return pulumi.get(self, "db")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        The role name.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class SeedNodeResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SeedNodeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SeedNodeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SeedNodeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: Optional[str] = None):
        """
        :param str ip_address: IP address of this seed node.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        IP address of this seed node.
        """
        return pulumi.get(self, "ip_address")


@pulumi.output_type
class SpatialSpecResponse(dict):
    def __init__(__self__, *,
                 path: Optional[str] = None,
                 types: Optional[Sequence[str]] = None):
        """
        :param str path: The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
        :param Sequence[str] types: List of path's spatial type
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if types is not None:
            pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def types(self) -> Optional[Sequence[str]]:
        """
        List of path's spatial type
        """
        return pulumi.get(self, "types")


@pulumi.output_type
class SqlContainerGetPropertiesResponseOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscaleSettings":
            suggest = "autoscale_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlContainerGetPropertiesResponseOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlContainerGetPropertiesResponseOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlContainerGetPropertiesResponseOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale_settings: Optional['outputs.AutoscaleSettingsResponse'] = None,
                 throughput: Optional[int] = None):
        """
        :param 'AutoscaleSettingsResponse' autoscale_settings: Specifies the Autoscale settings.
        :param int throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        if autoscale_settings is not None:
            pulumi.set(__self__, "autoscale_settings", autoscale_settings)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @property
    @pulumi.getter(name="autoscaleSettings")
    def autoscale_settings(self) -> Optional['outputs.AutoscaleSettingsResponse']:
        """
        Specifies the Autoscale settings.
        """
        return pulumi.get(self, "autoscale_settings")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[int]:
        """
        Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        return pulumi.get(self, "throughput")


@pulumi.output_type
class SqlContainerGetPropertiesResponseResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analyticalStorageTtl":
            suggest = "analytical_storage_ttl"
        elif key == "clientEncryptionPolicy":
            suggest = "client_encryption_policy"
        elif key == "conflictResolutionPolicy":
            suggest = "conflict_resolution_policy"
        elif key == "defaultTtl":
            suggest = "default_ttl"
        elif key == "indexingPolicy":
            suggest = "indexing_policy"
        elif key == "partitionKey":
            suggest = "partition_key"
        elif key == "uniqueKeyPolicy":
            suggest = "unique_key_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlContainerGetPropertiesResponseResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlContainerGetPropertiesResponseResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlContainerGetPropertiesResponseResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 id: str,
                 rid: str,
                 ts: float,
                 analytical_storage_ttl: Optional[float] = None,
                 client_encryption_policy: Optional['outputs.ClientEncryptionPolicyResponse'] = None,
                 conflict_resolution_policy: Optional['outputs.ConflictResolutionPolicyResponse'] = None,
                 default_ttl: Optional[int] = None,
                 indexing_policy: Optional['outputs.IndexingPolicyResponse'] = None,
                 partition_key: Optional['outputs.ContainerPartitionKeyResponse'] = None,
                 unique_key_policy: Optional['outputs.UniqueKeyPolicyResponse'] = None):
        """
        :param str etag: A system generated property representing the resource etag required for optimistic concurrency control.
        :param str id: Name of the Cosmos DB SQL container
        :param str rid: A system generated property. A unique identifier.
        :param float ts: A system generated property that denotes the last updated timestamp of the resource.
        :param float analytical_storage_ttl: Analytical TTL.
        :param 'ClientEncryptionPolicyResponse' client_encryption_policy: The client encryption policy for the container.
        :param 'ConflictResolutionPolicyResponse' conflict_resolution_policy: The conflict resolution policy for the container.
        :param int default_ttl: Default time to live
        :param 'IndexingPolicyResponse' indexing_policy: The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
        :param 'ContainerPartitionKeyResponse' partition_key: The configuration of the partition key to be used for partitioning data into multiple partitions
        :param 'UniqueKeyPolicyResponse' unique_key_policy: The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "rid", rid)
        pulumi.set(__self__, "ts", ts)
        if analytical_storage_ttl is not None:
            pulumi.set(__self__, "analytical_storage_ttl", analytical_storage_ttl)
        if client_encryption_policy is not None:
            pulumi.set(__self__, "client_encryption_policy", client_encryption_policy)
        if conflict_resolution_policy is not None:
            pulumi.set(__self__, "conflict_resolution_policy", conflict_resolution_policy)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if indexing_policy is not None:
            pulumi.set(__self__, "indexing_policy", indexing_policy)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)
        if unique_key_policy is not None:
            pulumi.set(__self__, "unique_key_policy", unique_key_policy)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A system generated property representing the resource etag required for optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Name of the Cosmos DB SQL container
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rid(self) -> str:
        """
        A system generated property. A unique identifier.
        """
        return pulumi.get(self, "rid")

    @property
    @pulumi.getter
    def ts(self) -> float:
        """
        A system generated property that denotes the last updated timestamp of the resource.
        """
        return pulumi.get(self, "ts")

    @property
    @pulumi.getter(name="analyticalStorageTtl")
    def analytical_storage_ttl(self) -> Optional[float]:
        """
        Analytical TTL.
        """
        return pulumi.get(self, "analytical_storage_ttl")

    @property
    @pulumi.getter(name="clientEncryptionPolicy")
    def client_encryption_policy(self) -> Optional['outputs.ClientEncryptionPolicyResponse']:
        """
        The client encryption policy for the container.
        """
        return pulumi.get(self, "client_encryption_policy")

    @property
    @pulumi.getter(name="conflictResolutionPolicy")
    def conflict_resolution_policy(self) -> Optional['outputs.ConflictResolutionPolicyResponse']:
        """
        The conflict resolution policy for the container.
        """
        return pulumi.get(self, "conflict_resolution_policy")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[int]:
        """
        Default time to live
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="indexingPolicy")
    def indexing_policy(self) -> Optional['outputs.IndexingPolicyResponse']:
        """
        The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
        """
        return pulumi.get(self, "indexing_policy")

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional['outputs.ContainerPartitionKeyResponse']:
        """
        The configuration of the partition key to be used for partitioning data into multiple partitions
        """
        return pulumi.get(self, "partition_key")

    @property
    @pulumi.getter(name="uniqueKeyPolicy")
    def unique_key_policy(self) -> Optional['outputs.UniqueKeyPolicyResponse']:
        """
        The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
        """
        return pulumi.get(self, "unique_key_policy")


@pulumi.output_type
class SqlDatabaseGetPropertiesResponseOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscaleSettings":
            suggest = "autoscale_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlDatabaseGetPropertiesResponseOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlDatabaseGetPropertiesResponseOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlDatabaseGetPropertiesResponseOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale_settings: Optional['outputs.AutoscaleSettingsResponse'] = None,
                 throughput: Optional[int] = None):
        """
        :param 'AutoscaleSettingsResponse' autoscale_settings: Specifies the Autoscale settings.
        :param int throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        if autoscale_settings is not None:
            pulumi.set(__self__, "autoscale_settings", autoscale_settings)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @property
    @pulumi.getter(name="autoscaleSettings")
    def autoscale_settings(self) -> Optional['outputs.AutoscaleSettingsResponse']:
        """
        Specifies the Autoscale settings.
        """
        return pulumi.get(self, "autoscale_settings")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[int]:
        """
        Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        return pulumi.get(self, "throughput")


@pulumi.output_type
class SqlDatabaseGetPropertiesResponseResource(dict):
    def __init__(__self__, *,
                 etag: str,
                 id: str,
                 rid: str,
                 ts: float,
                 colls: Optional[str] = None,
                 users: Optional[str] = None):
        """
        :param str etag: A system generated property representing the resource etag required for optimistic concurrency control.
        :param str id: Name of the Cosmos DB SQL database
        :param str rid: A system generated property. A unique identifier.
        :param float ts: A system generated property that denotes the last updated timestamp of the resource.
        :param str colls: A system generated property that specified the addressable path of the collections resource.
        :param str users: A system generated property that specifies the addressable path of the users resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "rid", rid)
        pulumi.set(__self__, "ts", ts)
        if colls is not None:
            pulumi.set(__self__, "colls", colls)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A system generated property representing the resource etag required for optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Name of the Cosmos DB SQL database
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rid(self) -> str:
        """
        A system generated property. A unique identifier.
        """
        return pulumi.get(self, "rid")

    @property
    @pulumi.getter
    def ts(self) -> float:
        """
        A system generated property that denotes the last updated timestamp of the resource.
        """
        return pulumi.get(self, "ts")

    @property
    @pulumi.getter
    def colls(self) -> Optional[str]:
        """
        A system generated property that specified the addressable path of the collections resource.
        """
        return pulumi.get(self, "colls")

    @property
    @pulumi.getter
    def users(self) -> Optional[str]:
        """
        A system generated property that specifies the addressable path of the users resource.
        """
        return pulumi.get(self, "users")


@pulumi.output_type
class SqlDedicatedGatewayRegionalServiceResourceResponse(dict):
    """
    Resource for a regional service location.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sqlDedicatedGatewayEndpoint":
            suggest = "sql_dedicated_gateway_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlDedicatedGatewayRegionalServiceResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlDedicatedGatewayRegionalServiceResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlDedicatedGatewayRegionalServiceResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: str,
                 name: str,
                 sql_dedicated_gateway_endpoint: str,
                 status: str):
        """
        Resource for a regional service location.
        :param str location: The location name.
        :param str name: The regional service name.
        :param str sql_dedicated_gateway_endpoint: The regional endpoint for SqlDedicatedGateway.
        :param str status: Describes the status of a service.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sql_dedicated_gateway_endpoint", sql_dedicated_gateway_endpoint)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location name.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The regional service name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sqlDedicatedGatewayEndpoint")
    def sql_dedicated_gateway_endpoint(self) -> str:
        """
        The regional endpoint for SqlDedicatedGateway.
        """
        return pulumi.get(self, "sql_dedicated_gateway_endpoint")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Describes the status of a service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class SqlDedicatedGatewayServiceResourcePropertiesResponse(dict):
    """
    Properties for SqlDedicatedGatewayServiceResource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationTime":
            suggest = "creation_time"
        elif key == "serviceType":
            suggest = "service_type"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceSize":
            suggest = "instance_size"
        elif key == "sqlDedicatedGatewayEndpoint":
            suggest = "sql_dedicated_gateway_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlDedicatedGatewayServiceResourcePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlDedicatedGatewayServiceResourcePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlDedicatedGatewayServiceResourcePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_time: str,
                 locations: Sequence['outputs.SqlDedicatedGatewayRegionalServiceResourceResponse'],
                 service_type: str,
                 status: str,
                 instance_count: Optional[int] = None,
                 instance_size: Optional[str] = None,
                 sql_dedicated_gateway_endpoint: Optional[str] = None):
        """
        Properties for SqlDedicatedGatewayServiceResource.
        :param str creation_time: Time of the last state change (ISO-8601 format).
        :param Sequence['SqlDedicatedGatewayRegionalServiceResourceResponse'] locations: An array that contains all of the locations for the service.
        :param str service_type: ServiceType for the service.
               Expected value is 'SqlDedicatedGateway'.
        :param str status: Describes the status of a service.
        :param int instance_count: Instance count for the service.
        :param str instance_size: Instance type for the service.
        :param str sql_dedicated_gateway_endpoint: SqlDedicatedGateway endpoint for the service.
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "locations", locations)
        pulumi.set(__self__, "service_type", 'SqlDedicatedGateway')
        pulumi.set(__self__, "status", status)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size is not None:
            pulumi.set(__self__, "instance_size", instance_size)
        if sql_dedicated_gateway_endpoint is not None:
            pulumi.set(__self__, "sql_dedicated_gateway_endpoint", sql_dedicated_gateway_endpoint)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Time of the last state change (ISO-8601 format).
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def locations(self) -> Sequence['outputs.SqlDedicatedGatewayRegionalServiceResourceResponse']:
        """
        An array that contains all of the locations for the service.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> str:
        """
        ServiceType for the service.
        Expected value is 'SqlDedicatedGateway'.
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Describes the status of a service.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        Instance count for the service.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceSize")
    def instance_size(self) -> Optional[str]:
        """
        Instance type for the service.
        """
        return pulumi.get(self, "instance_size")

    @property
    @pulumi.getter(name="sqlDedicatedGatewayEndpoint")
    def sql_dedicated_gateway_endpoint(self) -> Optional[str]:
        """
        SqlDedicatedGateway endpoint for the service.
        """
        return pulumi.get(self, "sql_dedicated_gateway_endpoint")


@pulumi.output_type
class SqlStoredProcedureGetPropertiesResponseResource(dict):
    def __init__(__self__, *,
                 etag: str,
                 id: str,
                 rid: str,
                 ts: float,
                 body: Optional[str] = None):
        """
        :param str etag: A system generated property representing the resource etag required for optimistic concurrency control.
        :param str id: Name of the Cosmos DB SQL storedProcedure
        :param str rid: A system generated property. A unique identifier.
        :param float ts: A system generated property that denotes the last updated timestamp of the resource.
        :param str body: Body of the Stored Procedure
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "rid", rid)
        pulumi.set(__self__, "ts", ts)
        if body is not None:
            pulumi.set(__self__, "body", body)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A system generated property representing the resource etag required for optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Name of the Cosmos DB SQL storedProcedure
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rid(self) -> str:
        """
        A system generated property. A unique identifier.
        """
        return pulumi.get(self, "rid")

    @property
    @pulumi.getter
    def ts(self) -> float:
        """
        A system generated property that denotes the last updated timestamp of the resource.
        """
        return pulumi.get(self, "ts")

    @property
    @pulumi.getter
    def body(self) -> Optional[str]:
        """
        Body of the Stored Procedure
        """
        return pulumi.get(self, "body")


@pulumi.output_type
class SqlTriggerGetPropertiesResponseResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "triggerOperation":
            suggest = "trigger_operation"
        elif key == "triggerType":
            suggest = "trigger_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlTriggerGetPropertiesResponseResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlTriggerGetPropertiesResponseResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlTriggerGetPropertiesResponseResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 id: str,
                 rid: str,
                 ts: float,
                 body: Optional[str] = None,
                 trigger_operation: Optional[str] = None,
                 trigger_type: Optional[str] = None):
        """
        :param str etag: A system generated property representing the resource etag required for optimistic concurrency control.
        :param str id: Name of the Cosmos DB SQL trigger
        :param str rid: A system generated property. A unique identifier.
        :param float ts: A system generated property that denotes the last updated timestamp of the resource.
        :param str body: Body of the Trigger
        :param str trigger_operation: The operation the trigger is associated with
        :param str trigger_type: Type of the Trigger
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "rid", rid)
        pulumi.set(__self__, "ts", ts)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if trigger_operation is not None:
            pulumi.set(__self__, "trigger_operation", trigger_operation)
        if trigger_type is not None:
            pulumi.set(__self__, "trigger_type", trigger_type)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A system generated property representing the resource etag required for optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Name of the Cosmos DB SQL trigger
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rid(self) -> str:
        """
        A system generated property. A unique identifier.
        """
        return pulumi.get(self, "rid")

    @property
    @pulumi.getter
    def ts(self) -> float:
        """
        A system generated property that denotes the last updated timestamp of the resource.
        """
        return pulumi.get(self, "ts")

    @property
    @pulumi.getter
    def body(self) -> Optional[str]:
        """
        Body of the Trigger
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="triggerOperation")
    def trigger_operation(self) -> Optional[str]:
        """
        The operation the trigger is associated with
        """
        return pulumi.get(self, "trigger_operation")

    @property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> Optional[str]:
        """
        Type of the Trigger
        """
        return pulumi.get(self, "trigger_type")


@pulumi.output_type
class SqlUserDefinedFunctionGetPropertiesResponseResource(dict):
    def __init__(__self__, *,
                 etag: str,
                 id: str,
                 rid: str,
                 ts: float,
                 body: Optional[str] = None):
        """
        :param str etag: A system generated property representing the resource etag required for optimistic concurrency control.
        :param str id: Name of the Cosmos DB SQL userDefinedFunction
        :param str rid: A system generated property. A unique identifier.
        :param float ts: A system generated property that denotes the last updated timestamp of the resource.
        :param str body: Body of the User Defined Function
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "rid", rid)
        pulumi.set(__self__, "ts", ts)
        if body is not None:
            pulumi.set(__self__, "body", body)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A system generated property representing the resource etag required for optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Name of the Cosmos DB SQL userDefinedFunction
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rid(self) -> str:
        """
        A system generated property. A unique identifier.
        """
        return pulumi.get(self, "rid")

    @property
    @pulumi.getter
    def ts(self) -> float:
        """
        A system generated property that denotes the last updated timestamp of the resource.
        """
        return pulumi.get(self, "ts")

    @property
    @pulumi.getter
    def body(self) -> Optional[str]:
        """
        Body of the User Defined Function
        """
        return pulumi.get(self, "body")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TableGetPropertiesResponseOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscaleSettings":
            suggest = "autoscale_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableGetPropertiesResponseOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableGetPropertiesResponseOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableGetPropertiesResponseOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale_settings: Optional['outputs.AutoscaleSettingsResponse'] = None,
                 throughput: Optional[int] = None):
        """
        :param 'AutoscaleSettingsResponse' autoscale_settings: Specifies the Autoscale settings.
        :param int throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        if autoscale_settings is not None:
            pulumi.set(__self__, "autoscale_settings", autoscale_settings)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @property
    @pulumi.getter(name="autoscaleSettings")
    def autoscale_settings(self) -> Optional['outputs.AutoscaleSettingsResponse']:
        """
        Specifies the Autoscale settings.
        """
        return pulumi.get(self, "autoscale_settings")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[int]:
        """
        Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
        """
        return pulumi.get(self, "throughput")


@pulumi.output_type
class TableGetPropertiesResponseResource(dict):
    def __init__(__self__, *,
                 etag: str,
                 id: str,
                 rid: str,
                 ts: float):
        """
        :param str etag: A system generated property representing the resource etag required for optimistic concurrency control.
        :param str id: Name of the Cosmos DB table
        :param str rid: A system generated property. A unique identifier.
        :param float ts: A system generated property that denotes the last updated timestamp of the resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "rid", rid)
        pulumi.set(__self__, "ts", ts)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A system generated property representing the resource etag required for optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Name of the Cosmos DB table
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rid(self) -> str:
        """
        A system generated property. A unique identifier.
        """
        return pulumi.get(self, "rid")

    @property
    @pulumi.getter
    def ts(self) -> float:
        """
        A system generated property that denotes the last updated timestamp of the resource.
        """
        return pulumi.get(self, "ts")


@pulumi.output_type
class UniqueKeyPolicyResponse(dict):
    """
    The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "uniqueKeys":
            suggest = "unique_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UniqueKeyPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UniqueKeyPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UniqueKeyPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 unique_keys: Optional[Sequence['outputs.UniqueKeyResponse']] = None):
        """
        The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
        :param Sequence['UniqueKeyResponse'] unique_keys: List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
        """
        if unique_keys is not None:
            pulumi.set(__self__, "unique_keys", unique_keys)

    @property
    @pulumi.getter(name="uniqueKeys")
    def unique_keys(self) -> Optional[Sequence['outputs.UniqueKeyResponse']]:
        """
        List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
        """
        return pulumi.get(self, "unique_keys")


@pulumi.output_type
class UniqueKeyResponse(dict):
    """
    The unique key on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
    """
    def __init__(__self__, *,
                 paths: Optional[Sequence[str]] = None):
        """
        The unique key on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
        :param Sequence[str] paths: List of paths must be unique for each document in the Azure Cosmos DB service
        """
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[str]]:
        """
        List of paths must be unique for each document in the Azure Cosmos DB service
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class VirtualNetworkRuleResponse(dict):
    """
    Virtual Network ACL Rule object
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreMissingVNetServiceEndpoint":
            suggest = "ignore_missing_v_net_service_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 ignore_missing_v_net_service_endpoint: Optional[bool] = None):
        """
        Virtual Network ACL Rule object
        :param str id: Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
        :param bool ignore_missing_v_net_service_endpoint: Create firewall rule before the virtual network has vnet service endpoint enabled.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ignore_missing_v_net_service_endpoint is not None:
            pulumi.set(__self__, "ignore_missing_v_net_service_endpoint", ignore_missing_v_net_service_endpoint)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ignoreMissingVNetServiceEndpoint")
    def ignore_missing_v_net_service_endpoint(self) -> Optional[bool]:
        """
        Create firewall rule before the virtual network has vnet service endpoint enabled.
        """
        return pulumi.get(self, "ignore_missing_v_net_service_endpoint")


