# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AllowedAudiencesValidationArgs',
    'ApiDefinitionInfoArgs',
    'ApiManagementConfigArgs',
    'AppRegistrationArgs',
    'AppleRegistrationArgs',
    'AppleArgs',
    'ApplicationLogsConfigArgs',
    'AuthPlatformArgs',
    'AutoHealActionsArgs',
    'AutoHealCustomActionArgs',
    'AutoHealRulesArgs',
    'AutoHealTriggersArgs',
    'AzureActiveDirectoryLoginArgs',
    'AzureActiveDirectoryRegistrationArgs',
    'AzureActiveDirectoryValidationArgs',
    'AzureActiveDirectoryArgs',
    'AzureBlobStorageApplicationLogsConfigArgs',
    'AzureBlobStorageHttpLogsConfigArgs',
    'AzureStaticWebAppsRegistrationArgs',
    'AzureStaticWebAppsArgs',
    'AzureStorageInfoValueArgs',
    'AzureTableStorageApplicationLogsConfigArgs',
    'BackupSchedule',
    'BackupScheduleArgs',
    'BlobStorageTokenStoreArgs',
    'CapabilityArgs',
    'ClientRegistrationArgs',
    'CloningInfoArgs',
    'ConnStringInfoArgs',
    'ConnStringValueTypePairArgs',
    'CookieExpirationArgs',
    'CorsSettingsArgs',
    'CustomOpenIdConnectProviderArgs',
    'DatabaseBackupSetting',
    'DatabaseBackupSettingArgs',
    'EnabledConfigArgs',
    'ExperimentsArgs',
    'FacebookArgs',
    'FileSystemApplicationLogsConfigArgs',
    'FileSystemHttpLogsConfigArgs',
    'FileSystemTokenStoreArgs',
    'ForwardProxyArgs',
    'GitHubActionCodeConfigurationArgs',
    'GitHubActionConfigurationArgs',
    'GitHubActionContainerConfigurationArgs',
    'GitHubArgs',
    'GlobalValidationArgs',
    'GoogleArgs',
    'HandlerMappingArgs',
    'HostNameSslStateArgs',
    'HostingEnvironmentProfileArgs',
    'HttpLogsConfigArgs',
    'HttpSettingsRoutesArgs',
    'HttpSettingsArgs',
    'IdentityProvidersArgs',
    'IpSecurityRestrictionArgs',
    'JwtClaimChecksArgs',
    'KubeEnvironmentProfileArgs',
    'LegacyMicrosoftAccountArgs',
    'LoginRoutesArgs',
    'LoginScopesArgs',
    'LoginArgs',
    'ManagedServiceIdentityArgs',
    'NameValuePairArgs',
    'NonceArgs',
    'OpenIdConnectClientCredentialArgs',
    'OpenIdConnectConfigArgs',
    'OpenIdConnectLoginArgs',
    'OpenIdConnectRegistrationArgs',
    'PrivateLinkConnectionStateArgs',
    'PushSettingsArgs',
    'RampUpRuleArgs',
    'RequestsBasedTriggerArgs',
    'SiteConfigArgs',
    'SiteLimitsArgs',
    'SkuCapacityArgs',
    'SkuDescriptionArgs',
    'SlowRequestsBasedTriggerArgs',
    'StaticSiteBuildPropertiesArgs',
    'StaticSiteTemplateOptionsArgs',
    'StatusCodesBasedTriggerArgs',
    'StatusCodesRangeBasedTriggerArgs',
    'TokenStoreArgs',
    'TwitterRegistrationArgs',
    'TwitterArgs',
    'VirtualApplicationArgs',
    'VirtualDirectoryArgs',
    'VirtualNetworkProfileArgs',
]

@pulumi.input_type
class AllowedAudiencesValidationArgs:
    def __init__(__self__, *,
                 allowed_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration settings of the Allowed Audiences validation flow.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_audiences: The configuration settings of the allowed list of audiences from which to validate the JWT token.
        """
        if allowed_audiences is not None:
            pulumi.set(__self__, "allowed_audiences", allowed_audiences)

    @property
    @pulumi.getter(name="allowedAudiences")
    def allowed_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The configuration settings of the allowed list of audiences from which to validate the JWT token.
        """
        return pulumi.get(self, "allowed_audiences")

    @allowed_audiences.setter
    def allowed_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_audiences", value)


@pulumi.input_type
class ApiDefinitionInfoArgs:
    def __init__(__self__, *,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Information about the formal API definition for the app.
        :param pulumi.Input[str] url: The URL of the API definition.
        """
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the API definition.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class ApiManagementConfigArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Azure API management (APIM) configuration linked to the app.
        :param pulumi.Input[str] id: APIM-Api Identifier.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        APIM-Api Identifier.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class AppRegistrationArgs:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[str]] = None,
                 app_secret_setting_name: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the app registration for providers that have app ids and app secrets
        :param pulumi.Input[str] app_id: The App ID of the app used for login.
        :param pulumi.Input[str] app_secret_setting_name: The app setting name that contains the app secret.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_secret_setting_name is not None:
            pulumi.set(__self__, "app_secret_setting_name", app_secret_setting_name)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The App ID of the app used for login.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="appSecretSettingName")
    def app_secret_setting_name(self) -> Optional[pulumi.Input[str]]:
        """
        The app setting name that contains the app secret.
        """
        return pulumi.get(self, "app_secret_setting_name")

    @app_secret_setting_name.setter
    def app_secret_setting_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_secret_setting_name", value)


@pulumi.input_type
class AppleRegistrationArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret_setting_name: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the registration for the Apple provider
        :param pulumi.Input[str] client_id: The Client ID of the app used for login.
        :param pulumi.Input[str] client_secret_setting_name: The app setting name that contains the client secret.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret_setting_name is not None:
            pulumi.set(__self__, "client_secret_setting_name", client_secret_setting_name)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Client ID of the app used for login.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecretSettingName")
    def client_secret_setting_name(self) -> Optional[pulumi.Input[str]]:
        """
        The app setting name that contains the client secret.
        """
        return pulumi.get(self, "client_secret_setting_name")

    @client_secret_setting_name.setter
    def client_secret_setting_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret_setting_name", value)


@pulumi.input_type
class AppleArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 login: Optional[pulumi.Input['LoginScopesArgs']] = None,
                 registration: Optional[pulumi.Input['AppleRegistrationArgs']] = None):
        """
        The configuration settings of the Apple provider.
        :param pulumi.Input[bool] enabled: <code>false</code> if the Apple provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param pulumi.Input['LoginScopesArgs'] login: The configuration settings of the login flow.
        :param pulumi.Input['AppleRegistrationArgs'] registration: The configuration settings of the Apple registration.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the Apple provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input['LoginScopesArgs']]:
        """
        The configuration settings of the login flow.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input['LoginScopesArgs']]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def registration(self) -> Optional[pulumi.Input['AppleRegistrationArgs']]:
        """
        The configuration settings of the Apple registration.
        """
        return pulumi.get(self, "registration")

    @registration.setter
    def registration(self, value: Optional[pulumi.Input['AppleRegistrationArgs']]):
        pulumi.set(self, "registration", value)


@pulumi.input_type
class ApplicationLogsConfigArgs:
    def __init__(__self__, *,
                 azure_blob_storage: Optional[pulumi.Input['AzureBlobStorageApplicationLogsConfigArgs']] = None,
                 azure_table_storage: Optional[pulumi.Input['AzureTableStorageApplicationLogsConfigArgs']] = None,
                 file_system: Optional[pulumi.Input['FileSystemApplicationLogsConfigArgs']] = None):
        """
        Application logs configuration.
        :param pulumi.Input['AzureBlobStorageApplicationLogsConfigArgs'] azure_blob_storage: Application logs to blob storage configuration.
        :param pulumi.Input['AzureTableStorageApplicationLogsConfigArgs'] azure_table_storage: Application logs to azure table storage configuration.
        :param pulumi.Input['FileSystemApplicationLogsConfigArgs'] file_system: Application logs to file system configuration.
        """
        if azure_blob_storage is not None:
            pulumi.set(__self__, "azure_blob_storage", azure_blob_storage)
        if azure_table_storage is not None:
            pulumi.set(__self__, "azure_table_storage", azure_table_storage)
        if file_system is not None:
            pulumi.set(__self__, "file_system", file_system)

    @property
    @pulumi.getter(name="azureBlobStorage")
    def azure_blob_storage(self) -> Optional[pulumi.Input['AzureBlobStorageApplicationLogsConfigArgs']]:
        """
        Application logs to blob storage configuration.
        """
        return pulumi.get(self, "azure_blob_storage")

    @azure_blob_storage.setter
    def azure_blob_storage(self, value: Optional[pulumi.Input['AzureBlobStorageApplicationLogsConfigArgs']]):
        pulumi.set(self, "azure_blob_storage", value)

    @property
    @pulumi.getter(name="azureTableStorage")
    def azure_table_storage(self) -> Optional[pulumi.Input['AzureTableStorageApplicationLogsConfigArgs']]:
        """
        Application logs to azure table storage configuration.
        """
        return pulumi.get(self, "azure_table_storage")

    @azure_table_storage.setter
    def azure_table_storage(self, value: Optional[pulumi.Input['AzureTableStorageApplicationLogsConfigArgs']]):
        pulumi.set(self, "azure_table_storage", value)

    @property
    @pulumi.getter(name="fileSystem")
    def file_system(self) -> Optional[pulumi.Input['FileSystemApplicationLogsConfigArgs']]:
        """
        Application logs to file system configuration.
        """
        return pulumi.get(self, "file_system")

    @file_system.setter
    def file_system(self, value: Optional[pulumi.Input['FileSystemApplicationLogsConfigArgs']]):
        pulumi.set(self, "file_system", value)


@pulumi.input_type
class AuthPlatformArgs:
    def __init__(__self__, *,
                 config_file_path: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 runtime_version: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the platform of App Service Authentication/Authorization.
        :param pulumi.Input[str] config_file_path: The path of the config file containing auth settings if they come from a file.
               If the path is relative, base will the site's root directory.
        :param pulumi.Input[bool] enabled: <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
        :param pulumi.Input[str] runtime_version: The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
               The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
        """
        if config_file_path is not None:
            pulumi.set(__self__, "config_file_path", config_file_path)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter(name="configFilePath")
    def config_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path of the config file containing auth settings if they come from a file.
        If the path is relative, base will the site's root directory.
        """
        return pulumi.get(self, "config_file_path")

    @config_file_path.setter
    def config_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_file_path", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[str]]:
        """
        The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
        The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_version", value)


@pulumi.input_type
class AutoHealActionsArgs:
    def __init__(__self__, *,
                 action_type: Optional[pulumi.Input['AutoHealActionType']] = None,
                 custom_action: Optional[pulumi.Input['AutoHealCustomActionArgs']] = None,
                 min_process_execution_time: Optional[pulumi.Input[str]] = None):
        """
        Actions which to take by the auto-heal module when a rule is triggered.
        :param pulumi.Input['AutoHealActionType'] action_type: Predefined action to be taken.
        :param pulumi.Input['AutoHealCustomActionArgs'] custom_action: Custom action to be taken.
        :param pulumi.Input[str] min_process_execution_time: Minimum time the process must execute
               before taking the action
        """
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if custom_action is not None:
            pulumi.set(__self__, "custom_action", custom_action)
        if min_process_execution_time is not None:
            pulumi.set(__self__, "min_process_execution_time", min_process_execution_time)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[pulumi.Input['AutoHealActionType']]:
        """
        Predefined action to be taken.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: Optional[pulumi.Input['AutoHealActionType']]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter(name="customAction")
    def custom_action(self) -> Optional[pulumi.Input['AutoHealCustomActionArgs']]:
        """
        Custom action to be taken.
        """
        return pulumi.get(self, "custom_action")

    @custom_action.setter
    def custom_action(self, value: Optional[pulumi.Input['AutoHealCustomActionArgs']]):
        pulumi.set(self, "custom_action", value)

    @property
    @pulumi.getter(name="minProcessExecutionTime")
    def min_process_execution_time(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum time the process must execute
        before taking the action
        """
        return pulumi.get(self, "min_process_execution_time")

    @min_process_execution_time.setter
    def min_process_execution_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_process_execution_time", value)


@pulumi.input_type
class AutoHealCustomActionArgs:
    def __init__(__self__, *,
                 exe: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[str]] = None):
        """
        Custom action to be executed
        when an auto heal rule is triggered.
        :param pulumi.Input[str] exe: Executable to be run.
        :param pulumi.Input[str] parameters: Parameters for the executable.
        """
        if exe is not None:
            pulumi.set(__self__, "exe", exe)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def exe(self) -> Optional[pulumi.Input[str]]:
        """
        Executable to be run.
        """
        return pulumi.get(self, "exe")

    @exe.setter
    def exe(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exe", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[str]]:
        """
        Parameters for the executable.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class AutoHealRulesArgs:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input['AutoHealActionsArgs']] = None,
                 triggers: Optional[pulumi.Input['AutoHealTriggersArgs']] = None):
        """
        Rules that can be defined for auto-heal.
        :param pulumi.Input['AutoHealActionsArgs'] actions: Actions to be executed when a rule is triggered.
        :param pulumi.Input['AutoHealTriggersArgs'] triggers: Conditions that describe when to execute the auto-heal actions.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input['AutoHealActionsArgs']]:
        """
        Actions to be executed when a rule is triggered.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input['AutoHealActionsArgs']]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input['AutoHealTriggersArgs']]:
        """
        Conditions that describe when to execute the auto-heal actions.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input['AutoHealTriggersArgs']]):
        pulumi.set(self, "triggers", value)


@pulumi.input_type
class AutoHealTriggersArgs:
    def __init__(__self__, *,
                 private_bytes_in_kb: Optional[pulumi.Input[int]] = None,
                 requests: Optional[pulumi.Input['RequestsBasedTriggerArgs']] = None,
                 slow_requests: Optional[pulumi.Input['SlowRequestsBasedTriggerArgs']] = None,
                 slow_requests_with_path: Optional[pulumi.Input[Sequence[pulumi.Input['SlowRequestsBasedTriggerArgs']]]] = None,
                 status_codes: Optional[pulumi.Input[Sequence[pulumi.Input['StatusCodesBasedTriggerArgs']]]] = None,
                 status_codes_range: Optional[pulumi.Input[Sequence[pulumi.Input['StatusCodesRangeBasedTriggerArgs']]]] = None):
        """
        Triggers for auto-heal.
        :param pulumi.Input[int] private_bytes_in_kb: A rule based on private bytes.
        :param pulumi.Input['RequestsBasedTriggerArgs'] requests: A rule based on total requests.
        :param pulumi.Input['SlowRequestsBasedTriggerArgs'] slow_requests: A rule based on request execution time.
        :param pulumi.Input[Sequence[pulumi.Input['SlowRequestsBasedTriggerArgs']]] slow_requests_with_path: A rule based on multiple Slow Requests Rule with path
        :param pulumi.Input[Sequence[pulumi.Input['StatusCodesBasedTriggerArgs']]] status_codes: A rule based on status codes.
        :param pulumi.Input[Sequence[pulumi.Input['StatusCodesRangeBasedTriggerArgs']]] status_codes_range: A rule based on status codes ranges.
        """
        if private_bytes_in_kb is not None:
            pulumi.set(__self__, "private_bytes_in_kb", private_bytes_in_kb)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if slow_requests is not None:
            pulumi.set(__self__, "slow_requests", slow_requests)
        if slow_requests_with_path is not None:
            pulumi.set(__self__, "slow_requests_with_path", slow_requests_with_path)
        if status_codes is not None:
            pulumi.set(__self__, "status_codes", status_codes)
        if status_codes_range is not None:
            pulumi.set(__self__, "status_codes_range", status_codes_range)

    @property
    @pulumi.getter(name="privateBytesInKB")
    def private_bytes_in_kb(self) -> Optional[pulumi.Input[int]]:
        """
        A rule based on private bytes.
        """
        return pulumi.get(self, "private_bytes_in_kb")

    @private_bytes_in_kb.setter
    def private_bytes_in_kb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "private_bytes_in_kb", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input['RequestsBasedTriggerArgs']]:
        """
        A rule based on total requests.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input['RequestsBasedTriggerArgs']]):
        pulumi.set(self, "requests", value)

    @property
    @pulumi.getter(name="slowRequests")
    def slow_requests(self) -> Optional[pulumi.Input['SlowRequestsBasedTriggerArgs']]:
        """
        A rule based on request execution time.
        """
        return pulumi.get(self, "slow_requests")

    @slow_requests.setter
    def slow_requests(self, value: Optional[pulumi.Input['SlowRequestsBasedTriggerArgs']]):
        pulumi.set(self, "slow_requests", value)

    @property
    @pulumi.getter(name="slowRequestsWithPath")
    def slow_requests_with_path(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SlowRequestsBasedTriggerArgs']]]]:
        """
        A rule based on multiple Slow Requests Rule with path
        """
        return pulumi.get(self, "slow_requests_with_path")

    @slow_requests_with_path.setter
    def slow_requests_with_path(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SlowRequestsBasedTriggerArgs']]]]):
        pulumi.set(self, "slow_requests_with_path", value)

    @property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StatusCodesBasedTriggerArgs']]]]:
        """
        A rule based on status codes.
        """
        return pulumi.get(self, "status_codes")

    @status_codes.setter
    def status_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StatusCodesBasedTriggerArgs']]]]):
        pulumi.set(self, "status_codes", value)

    @property
    @pulumi.getter(name="statusCodesRange")
    def status_codes_range(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StatusCodesRangeBasedTriggerArgs']]]]:
        """
        A rule based on status codes ranges.
        """
        return pulumi.get(self, "status_codes_range")

    @status_codes_range.setter
    def status_codes_range(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StatusCodesRangeBasedTriggerArgs']]]]):
        pulumi.set(self, "status_codes_range", value)


@pulumi.input_type
class AzureActiveDirectoryLoginArgs:
    def __init__(__self__, *,
                 disable_www_authenticate: Optional[pulumi.Input[bool]] = None,
                 login_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration settings of the Azure Active Directory login flow.
        :param pulumi.Input[bool] disable_www_authenticate: <code>true</code> if the www-authenticate provider should be omitted from the request; otherwise, <code>false</code>.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] login_parameters: Login parameters to send to the OpenID Connect authorization endpoint when
               a user logs in. Each parameter must be in the form "key=value".
        """
        if disable_www_authenticate is not None:
            pulumi.set(__self__, "disable_www_authenticate", disable_www_authenticate)
        if login_parameters is not None:
            pulumi.set(__self__, "login_parameters", login_parameters)

    @property
    @pulumi.getter(name="disableWWWAuthenticate")
    def disable_www_authenticate(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> if the www-authenticate provider should be omitted from the request; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "disable_www_authenticate")

    @disable_www_authenticate.setter
    def disable_www_authenticate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_www_authenticate", value)

    @property
    @pulumi.getter(name="loginParameters")
    def login_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Login parameters to send to the OpenID Connect authorization endpoint when
        a user logs in. Each parameter must be in the form "key=value".
        """
        return pulumi.get(self, "login_parameters")

    @login_parameters.setter
    def login_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "login_parameters", value)


@pulumi.input_type
class AzureActiveDirectoryRegistrationArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret_certificate_issuer: Optional[pulumi.Input[str]] = None,
                 client_secret_certificate_subject_alternative_name: Optional[pulumi.Input[str]] = None,
                 client_secret_certificate_thumbprint: Optional[pulumi.Input[str]] = None,
                 client_secret_setting_name: Optional[pulumi.Input[str]] = None,
                 open_id_issuer: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the Azure Active Directory app registration.
        :param pulumi.Input[str] client_id: The Client ID of this relying party application, known as the client_id.
               This setting is required for enabling OpenID Connection authentication with Azure Active Directory or 
               other 3rd party OpenID Connect providers.
               More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
        :param pulumi.Input[str] client_secret_certificate_issuer: An alternative to the client secret thumbprint, that is the issuer of a certificate used for signing purposes. This property acts as
               a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        :param pulumi.Input[str] client_secret_certificate_subject_alternative_name: An alternative to the client secret thumbprint, that is the subject alternative name of a certificate used for signing purposes. This property acts as
               a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        :param pulumi.Input[str] client_secret_certificate_thumbprint: An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts as
               a replacement for the Client Secret. It is also optional.
        :param pulumi.Input[str] client_secret_setting_name: The app setting name that contains the client secret of the relying party application.
        :param pulumi.Input[str] open_id_issuer: The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
               When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://login.microsoftonline.com/v2.0/{tenant-guid}/.
               This URI is a case-sensitive identifier for the token issuer.
               More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret_certificate_issuer is not None:
            pulumi.set(__self__, "client_secret_certificate_issuer", client_secret_certificate_issuer)
        if client_secret_certificate_subject_alternative_name is not None:
            pulumi.set(__self__, "client_secret_certificate_subject_alternative_name", client_secret_certificate_subject_alternative_name)
        if client_secret_certificate_thumbprint is not None:
            pulumi.set(__self__, "client_secret_certificate_thumbprint", client_secret_certificate_thumbprint)
        if client_secret_setting_name is not None:
            pulumi.set(__self__, "client_secret_setting_name", client_secret_setting_name)
        if open_id_issuer is not None:
            pulumi.set(__self__, "open_id_issuer", open_id_issuer)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Client ID of this relying party application, known as the client_id.
        This setting is required for enabling OpenID Connection authentication with Azure Active Directory or 
        other 3rd party OpenID Connect providers.
        More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecretCertificateIssuer")
    def client_secret_certificate_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        An alternative to the client secret thumbprint, that is the issuer of a certificate used for signing purposes. This property acts as
        a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        """
        return pulumi.get(self, "client_secret_certificate_issuer")

    @client_secret_certificate_issuer.setter
    def client_secret_certificate_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret_certificate_issuer", value)

    @property
    @pulumi.getter(name="clientSecretCertificateSubjectAlternativeName")
    def client_secret_certificate_subject_alternative_name(self) -> Optional[pulumi.Input[str]]:
        """
        An alternative to the client secret thumbprint, that is the subject alternative name of a certificate used for signing purposes. This property acts as
        a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        """
        return pulumi.get(self, "client_secret_certificate_subject_alternative_name")

    @client_secret_certificate_subject_alternative_name.setter
    def client_secret_certificate_subject_alternative_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret_certificate_subject_alternative_name", value)

    @property
    @pulumi.getter(name="clientSecretCertificateThumbprint")
    def client_secret_certificate_thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts as
        a replacement for the Client Secret. It is also optional.
        """
        return pulumi.get(self, "client_secret_certificate_thumbprint")

    @client_secret_certificate_thumbprint.setter
    def client_secret_certificate_thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret_certificate_thumbprint", value)

    @property
    @pulumi.getter(name="clientSecretSettingName")
    def client_secret_setting_name(self) -> Optional[pulumi.Input[str]]:
        """
        The app setting name that contains the client secret of the relying party application.
        """
        return pulumi.get(self, "client_secret_setting_name")

    @client_secret_setting_name.setter
    def client_secret_setting_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret_setting_name", value)

    @property
    @pulumi.getter(name="openIdIssuer")
    def open_id_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
        When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://login.microsoftonline.com/v2.0/{tenant-guid}/.
        This URI is a case-sensitive identifier for the token issuer.
        More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
        """
        return pulumi.get(self, "open_id_issuer")

    @open_id_issuer.setter
    def open_id_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "open_id_issuer", value)


@pulumi.input_type
class AzureActiveDirectoryValidationArgs:
    def __init__(__self__, *,
                 allowed_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 jwt_claim_checks: Optional[pulumi.Input['JwtClaimChecksArgs']] = None):
        """
        The configuration settings of the Azure Active Directory token validation flow.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_audiences: The list of audiences that can make successful authentication/authorization requests.
        :param pulumi.Input['JwtClaimChecksArgs'] jwt_claim_checks: The configuration settings of the checks that should be made while validating the JWT Claims.
        """
        if allowed_audiences is not None:
            pulumi.set(__self__, "allowed_audiences", allowed_audiences)
        if jwt_claim_checks is not None:
            pulumi.set(__self__, "jwt_claim_checks", jwt_claim_checks)

    @property
    @pulumi.getter(name="allowedAudiences")
    def allowed_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of audiences that can make successful authentication/authorization requests.
        """
        return pulumi.get(self, "allowed_audiences")

    @allowed_audiences.setter
    def allowed_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_audiences", value)

    @property
    @pulumi.getter(name="jwtClaimChecks")
    def jwt_claim_checks(self) -> Optional[pulumi.Input['JwtClaimChecksArgs']]:
        """
        The configuration settings of the checks that should be made while validating the JWT Claims.
        """
        return pulumi.get(self, "jwt_claim_checks")

    @jwt_claim_checks.setter
    def jwt_claim_checks(self, value: Optional[pulumi.Input['JwtClaimChecksArgs']]):
        pulumi.set(self, "jwt_claim_checks", value)


@pulumi.input_type
class AzureActiveDirectoryArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 is_auto_provisioned: Optional[pulumi.Input[bool]] = None,
                 login: Optional[pulumi.Input['AzureActiveDirectoryLoginArgs']] = None,
                 registration: Optional[pulumi.Input['AzureActiveDirectoryRegistrationArgs']] = None,
                 validation: Optional[pulumi.Input['AzureActiveDirectoryValidationArgs']] = None):
        """
        The configuration settings of the Azure Active directory provider.
        :param pulumi.Input[bool] enabled: <code>false</code> if the Azure Active Directory provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param pulumi.Input[bool] is_auto_provisioned: Gets a value indicating whether the Azure AD configuration was auto-provisioned using 1st party tooling.
               This is an internal flag primarily intended to support the Azure Management Portal. Users should not
               read or write to this property.
        :param pulumi.Input['AzureActiveDirectoryLoginArgs'] login: The configuration settings of the Azure Active Directory login flow.
        :param pulumi.Input['AzureActiveDirectoryRegistrationArgs'] registration: The configuration settings of the Azure Active Directory app registration.
        :param pulumi.Input['AzureActiveDirectoryValidationArgs'] validation: The configuration settings of the Azure Active Directory token validation flow.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if is_auto_provisioned is not None:
            pulumi.set(__self__, "is_auto_provisioned", is_auto_provisioned)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)
        if validation is not None:
            pulumi.set(__self__, "validation", validation)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the Azure Active Directory provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="isAutoProvisioned")
    def is_auto_provisioned(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets a value indicating whether the Azure AD configuration was auto-provisioned using 1st party tooling.
        This is an internal flag primarily intended to support the Azure Management Portal. Users should not
        read or write to this property.
        """
        return pulumi.get(self, "is_auto_provisioned")

    @is_auto_provisioned.setter
    def is_auto_provisioned(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_provisioned", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input['AzureActiveDirectoryLoginArgs']]:
        """
        The configuration settings of the Azure Active Directory login flow.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input['AzureActiveDirectoryLoginArgs']]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def registration(self) -> Optional[pulumi.Input['AzureActiveDirectoryRegistrationArgs']]:
        """
        The configuration settings of the Azure Active Directory app registration.
        """
        return pulumi.get(self, "registration")

    @registration.setter
    def registration(self, value: Optional[pulumi.Input['AzureActiveDirectoryRegistrationArgs']]):
        pulumi.set(self, "registration", value)

    @property
    @pulumi.getter
    def validation(self) -> Optional[pulumi.Input['AzureActiveDirectoryValidationArgs']]:
        """
        The configuration settings of the Azure Active Directory token validation flow.
        """
        return pulumi.get(self, "validation")

    @validation.setter
    def validation(self, value: Optional[pulumi.Input['AzureActiveDirectoryValidationArgs']]):
        pulumi.set(self, "validation", value)


@pulumi.input_type
class AzureBlobStorageApplicationLogsConfigArgs:
    def __init__(__self__, *,
                 level: Optional[pulumi.Input['LogLevel']] = None,
                 retention_in_days: Optional[pulumi.Input[int]] = None,
                 sas_url: Optional[pulumi.Input[str]] = None):
        """
        Application logs azure blob storage configuration.
        :param pulumi.Input['LogLevel'] level: Log level.
        :param pulumi.Input[int] retention_in_days: Retention in days.
               Remove blobs older than X days.
               0 or lower means no retention.
        :param pulumi.Input[str] sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
        """
        if level is not None:
            pulumi.set(__self__, "level", level)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if sas_url is not None:
            pulumi.set(__self__, "sas_url", sas_url)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input['LogLevel']]:
        """
        Log level.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input['LogLevel']]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Retention in days.
        Remove blobs older than X days.
        0 or lower means no retention.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_in_days", value)

    @property
    @pulumi.getter(name="sasUrl")
    def sas_url(self) -> Optional[pulumi.Input[str]]:
        """
        SAS url to a azure blob container with read/write/list/delete permissions.
        """
        return pulumi.get(self, "sas_url")

    @sas_url.setter
    def sas_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_url", value)


@pulumi.input_type
class AzureBlobStorageHttpLogsConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 retention_in_days: Optional[pulumi.Input[int]] = None,
                 sas_url: Optional[pulumi.Input[str]] = None):
        """
        Http logs to azure blob storage configuration.
        :param pulumi.Input[bool] enabled: True if configuration is enabled, false if it is disabled and null if configuration is not set.
        :param pulumi.Input[int] retention_in_days: Retention in days.
               Remove blobs older than X days.
               0 or lower means no retention.
        :param pulumi.Input[str] sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if sas_url is not None:
            pulumi.set(__self__, "sas_url", sas_url)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if configuration is enabled, false if it is disabled and null if configuration is not set.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Retention in days.
        Remove blobs older than X days.
        0 or lower means no retention.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_in_days", value)

    @property
    @pulumi.getter(name="sasUrl")
    def sas_url(self) -> Optional[pulumi.Input[str]]:
        """
        SAS url to a azure blob container with read/write/list/delete permissions.
        """
        return pulumi.get(self, "sas_url")

    @sas_url.setter
    def sas_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_url", value)


@pulumi.input_type
class AzureStaticWebAppsRegistrationArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the registration for the Azure Static Web Apps provider
        :param pulumi.Input[str] client_id: The Client ID of the app used for login.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Client ID of the app used for login.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)


@pulumi.input_type
class AzureStaticWebAppsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 registration: Optional[pulumi.Input['AzureStaticWebAppsRegistrationArgs']] = None):
        """
        The configuration settings of the Azure Static Web Apps provider.
        :param pulumi.Input[bool] enabled: <code>false</code> if the Azure Static Web Apps provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param pulumi.Input['AzureStaticWebAppsRegistrationArgs'] registration: The configuration settings of the Azure Static Web Apps registration.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the Azure Static Web Apps provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def registration(self) -> Optional[pulumi.Input['AzureStaticWebAppsRegistrationArgs']]:
        """
        The configuration settings of the Azure Static Web Apps registration.
        """
        return pulumi.get(self, "registration")

    @registration.setter
    def registration(self, value: Optional[pulumi.Input['AzureStaticWebAppsRegistrationArgs']]):
        pulumi.set(self, "registration", value)


@pulumi.input_type
class AzureStorageInfoValueArgs:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[str]] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 mount_path: Optional[pulumi.Input[str]] = None,
                 share_name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['AzureStorageType']] = None):
        """
        Azure Files or Blob Storage access information value for dictionary storage.
        :param pulumi.Input[str] access_key: Access key for the storage account.
        :param pulumi.Input[str] account_name: Name of the storage account.
        :param pulumi.Input[str] mount_path: Path to mount the storage within the site's runtime environment.
        :param pulumi.Input[str] share_name: Name of the file share (container name, for Blob storage).
        :param pulumi.Input['AzureStorageType'] type: Type of storage.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if share_name is not None:
            pulumi.set(__self__, "share_name", share_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[str]]:
        """
        Access key for the storage account.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the storage account.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to mount the storage within the site's runtime environment.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the file share (container name, for Blob storage).
        """
        return pulumi.get(self, "share_name")

    @share_name.setter
    def share_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "share_name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['AzureStorageType']]:
        """
        Type of storage.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['AzureStorageType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class AzureTableStorageApplicationLogsConfigArgs:
    def __init__(__self__, *,
                 sas_url: pulumi.Input[str],
                 level: Optional[pulumi.Input['LogLevel']] = None):
        """
        Application logs to Azure table storage configuration.
        :param pulumi.Input[str] sas_url: SAS URL to an Azure table with add/query/delete permissions.
        :param pulumi.Input['LogLevel'] level: Log level.
        """
        pulumi.set(__self__, "sas_url", sas_url)
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter(name="sasUrl")
    def sas_url(self) -> pulumi.Input[str]:
        """
        SAS URL to an Azure table with add/query/delete permissions.
        """
        return pulumi.get(self, "sas_url")

    @sas_url.setter
    def sas_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "sas_url", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input['LogLevel']]:
        """
        Log level.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input['LogLevel']]):
        pulumi.set(self, "level", value)


@pulumi.input_type
class BackupSchedule:
    def __init__(__self__, *,
                 frequency_interval: int,
                 frequency_unit: 'FrequencyUnit',
                 keep_at_least_one_backup: bool,
                 retention_period_in_days: int,
                 start_time: Optional[str] = None):
        """
        Description of a backup schedule. Describes how often should be the backup performed and what should be the retention policy.
        :param int frequency_interval: How often the backup should be executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
        :param 'FrequencyUnit' frequency_unit: The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)
        :param bool keep_at_least_one_backup: True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
        :param int retention_period_in_days: After how many days backups should be deleted.
        :param str start_time: When the schedule should start working.
        """
        if frequency_interval is None:
            frequency_interval = 7
        pulumi.set(__self__, "frequency_interval", frequency_interval)
        if frequency_unit is None:
            frequency_unit = 'Day'
        pulumi.set(__self__, "frequency_unit", frequency_unit)
        if keep_at_least_one_backup is None:
            keep_at_least_one_backup = True
        pulumi.set(__self__, "keep_at_least_one_backup", keep_at_least_one_backup)
        if retention_period_in_days is None:
            retention_period_in_days = 30
        pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="frequencyInterval")
    def frequency_interval(self) -> int:
        """
        How often the backup should be executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
        """
        return pulumi.get(self, "frequency_interval")

    @frequency_interval.setter
    def frequency_interval(self, value: int):
        pulumi.set(self, "frequency_interval", value)

    @property
    @pulumi.getter(name="frequencyUnit")
    def frequency_unit(self) -> 'FrequencyUnit':
        """
        The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)
        """
        return pulumi.get(self, "frequency_unit")

    @frequency_unit.setter
    def frequency_unit(self, value: 'FrequencyUnit'):
        pulumi.set(self, "frequency_unit", value)

    @property
    @pulumi.getter(name="keepAtLeastOneBackup")
    def keep_at_least_one_backup(self) -> bool:
        """
        True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
        """
        return pulumi.get(self, "keep_at_least_one_backup")

    @keep_at_least_one_backup.setter
    def keep_at_least_one_backup(self, value: bool):
        pulumi.set(self, "keep_at_least_one_backup", value)

    @property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> int:
        """
        After how many days backups should be deleted.
        """
        return pulumi.get(self, "retention_period_in_days")

    @retention_period_in_days.setter
    def retention_period_in_days(self, value: int):
        pulumi.set(self, "retention_period_in_days", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        When the schedule should start working.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[str]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class BackupScheduleArgs:
    def __init__(__self__, *,
                 frequency_interval: pulumi.Input[int],
                 frequency_unit: pulumi.Input['FrequencyUnit'],
                 keep_at_least_one_backup: pulumi.Input[bool],
                 retention_period_in_days: pulumi.Input[int],
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        Description of a backup schedule. Describes how often should be the backup performed and what should be the retention policy.
        :param pulumi.Input[int] frequency_interval: How often the backup should be executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
        :param pulumi.Input['FrequencyUnit'] frequency_unit: The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)
        :param pulumi.Input[bool] keep_at_least_one_backup: True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
        :param pulumi.Input[int] retention_period_in_days: After how many days backups should be deleted.
        :param pulumi.Input[str] start_time: When the schedule should start working.
        """
        if frequency_interval is None:
            frequency_interval = 7
        pulumi.set(__self__, "frequency_interval", frequency_interval)
        if frequency_unit is None:
            frequency_unit = 'Day'
        pulumi.set(__self__, "frequency_unit", frequency_unit)
        if keep_at_least_one_backup is None:
            keep_at_least_one_backup = True
        pulumi.set(__self__, "keep_at_least_one_backup", keep_at_least_one_backup)
        if retention_period_in_days is None:
            retention_period_in_days = 30
        pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="frequencyInterval")
    def frequency_interval(self) -> pulumi.Input[int]:
        """
        How often the backup should be executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
        """
        return pulumi.get(self, "frequency_interval")

    @frequency_interval.setter
    def frequency_interval(self, value: pulumi.Input[int]):
        pulumi.set(self, "frequency_interval", value)

    @property
    @pulumi.getter(name="frequencyUnit")
    def frequency_unit(self) -> pulumi.Input['FrequencyUnit']:
        """
        The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)
        """
        return pulumi.get(self, "frequency_unit")

    @frequency_unit.setter
    def frequency_unit(self, value: pulumi.Input['FrequencyUnit']):
        pulumi.set(self, "frequency_unit", value)

    @property
    @pulumi.getter(name="keepAtLeastOneBackup")
    def keep_at_least_one_backup(self) -> pulumi.Input[bool]:
        """
        True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
        """
        return pulumi.get(self, "keep_at_least_one_backup")

    @keep_at_least_one_backup.setter
    def keep_at_least_one_backup(self, value: pulumi.Input[bool]):
        pulumi.set(self, "keep_at_least_one_backup", value)

    @property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> pulumi.Input[int]:
        """
        After how many days backups should be deleted.
        """
        return pulumi.get(self, "retention_period_in_days")

    @retention_period_in_days.setter
    def retention_period_in_days(self, value: pulumi.Input[int]):
        pulumi.set(self, "retention_period_in_days", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        When the schedule should start working.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class BlobStorageTokenStoreArgs:
    def __init__(__self__, *,
                 sas_url_setting_name: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the storage of the tokens if blob storage is used.
        :param pulumi.Input[str] sas_url_setting_name: The name of the app setting containing the SAS URL of the blob storage containing the tokens.
        """
        if sas_url_setting_name is not None:
            pulumi.set(__self__, "sas_url_setting_name", sas_url_setting_name)

    @property
    @pulumi.getter(name="sasUrlSettingName")
    def sas_url_setting_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the app setting containing the SAS URL of the blob storage containing the tokens.
        """
        return pulumi.get(self, "sas_url_setting_name")

    @sas_url_setting_name.setter
    def sas_url_setting_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_url_setting_name", value)


@pulumi.input_type
class CapabilityArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Describes the capabilities/features allowed for a specific SKU.
        :param pulumi.Input[str] name: Name of the SKU capability.
        :param pulumi.Input[str] reason: Reason of the SKU capability.
        :param pulumi.Input[str] value: Value of the SKU capability.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the SKU capability.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        Reason of the SKU capability.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value of the SKU capability.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ClientRegistrationArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret_setting_name: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the app registration for providers that have client ids and client secrets
        :param pulumi.Input[str] client_id: The Client ID of the app used for login.
        :param pulumi.Input[str] client_secret_setting_name: The app setting name that contains the client secret.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret_setting_name is not None:
            pulumi.set(__self__, "client_secret_setting_name", client_secret_setting_name)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Client ID of the app used for login.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecretSettingName")
    def client_secret_setting_name(self) -> Optional[pulumi.Input[str]]:
        """
        The app setting name that contains the client secret.
        """
        return pulumi.get(self, "client_secret_setting_name")

    @client_secret_setting_name.setter
    def client_secret_setting_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret_setting_name", value)


@pulumi.input_type
class CloningInfoArgs:
    def __init__(__self__, *,
                 source_web_app_id: pulumi.Input[str],
                 app_settings_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 clone_custom_host_names: Optional[pulumi.Input[bool]] = None,
                 clone_source_control: Optional[pulumi.Input[bool]] = None,
                 configure_load_balancing: Optional[pulumi.Input[bool]] = None,
                 correlation_id: Optional[pulumi.Input[str]] = None,
                 hosting_environment: Optional[pulumi.Input[str]] = None,
                 overwrite: Optional[pulumi.Input[bool]] = None,
                 source_web_app_location: Optional[pulumi.Input[str]] = None,
                 traffic_manager_profile_id: Optional[pulumi.Input[str]] = None,
                 traffic_manager_profile_name: Optional[pulumi.Input[str]] = None):
        """
        Information needed for cloning operation.
        :param pulumi.Input[str] source_web_app_id: ARM resource ID of the source app. App resource ID is of the form 
               /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName} for production slots and 
               /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for other slots.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] app_settings_overrides: Application setting overrides for cloned app. If specified, these settings override the settings cloned 
               from source app. Otherwise, application settings from source app are retained.
        :param pulumi.Input[bool] clone_custom_host_names: <code>true</code> to clone custom hostnames from source app; otherwise, <code>false</code>.
        :param pulumi.Input[bool] clone_source_control: <code>true</code> to clone source control from source app; otherwise, <code>false</code>.
        :param pulumi.Input[bool] configure_load_balancing: <code>true</code> to configure load balancing for source and destination app.
        :param pulumi.Input[str] correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning operations
               together to use the same snapshot.
        :param pulumi.Input[str] hosting_environment: App Service Environment.
        :param pulumi.Input[bool] overwrite: <code>true</code> to overwrite destination app; otherwise, <code>false</code>.
        :param pulumi.Input[str] source_web_app_location: Location of source app ex: West US or North Europe
        :param pulumi.Input[str] traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if it exists. Traffic Manager resource ID is of the form 
               /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
        :param pulumi.Input[str] traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only needed if Traffic Manager profile does not already exist.
        """
        pulumi.set(__self__, "source_web_app_id", source_web_app_id)
        if app_settings_overrides is not None:
            pulumi.set(__self__, "app_settings_overrides", app_settings_overrides)
        if clone_custom_host_names is not None:
            pulumi.set(__self__, "clone_custom_host_names", clone_custom_host_names)
        if clone_source_control is not None:
            pulumi.set(__self__, "clone_source_control", clone_source_control)
        if configure_load_balancing is not None:
            pulumi.set(__self__, "configure_load_balancing", configure_load_balancing)
        if correlation_id is not None:
            pulumi.set(__self__, "correlation_id", correlation_id)
        if hosting_environment is not None:
            pulumi.set(__self__, "hosting_environment", hosting_environment)
        if overwrite is not None:
            pulumi.set(__self__, "overwrite", overwrite)
        if source_web_app_location is not None:
            pulumi.set(__self__, "source_web_app_location", source_web_app_location)
        if traffic_manager_profile_id is not None:
            pulumi.set(__self__, "traffic_manager_profile_id", traffic_manager_profile_id)
        if traffic_manager_profile_name is not None:
            pulumi.set(__self__, "traffic_manager_profile_name", traffic_manager_profile_name)

    @property
    @pulumi.getter(name="sourceWebAppId")
    def source_web_app_id(self) -> pulumi.Input[str]:
        """
        ARM resource ID of the source app. App resource ID is of the form 
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName} for production slots and 
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for other slots.
        """
        return pulumi.get(self, "source_web_app_id")

    @source_web_app_id.setter
    def source_web_app_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_web_app_id", value)

    @property
    @pulumi.getter(name="appSettingsOverrides")
    def app_settings_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Application setting overrides for cloned app. If specified, these settings override the settings cloned 
        from source app. Otherwise, application settings from source app are retained.
        """
        return pulumi.get(self, "app_settings_overrides")

    @app_settings_overrides.setter
    def app_settings_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "app_settings_overrides", value)

    @property
    @pulumi.getter(name="cloneCustomHostNames")
    def clone_custom_host_names(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> to clone custom hostnames from source app; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "clone_custom_host_names")

    @clone_custom_host_names.setter
    def clone_custom_host_names(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "clone_custom_host_names", value)

    @property
    @pulumi.getter(name="cloneSourceControl")
    def clone_source_control(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> to clone source control from source app; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "clone_source_control")

    @clone_source_control.setter
    def clone_source_control(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "clone_source_control", value)

    @property
    @pulumi.getter(name="configureLoadBalancing")
    def configure_load_balancing(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> to configure load balancing for source and destination app.
        """
        return pulumi.get(self, "configure_load_balancing")

    @configure_load_balancing.setter
    def configure_load_balancing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "configure_load_balancing", value)

    @property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> Optional[pulumi.Input[str]]:
        """
        Correlation ID of cloning operation. This ID ties multiple cloning operations
        together to use the same snapshot.
        """
        return pulumi.get(self, "correlation_id")

    @correlation_id.setter
    def correlation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "correlation_id", value)

    @property
    @pulumi.getter(name="hostingEnvironment")
    def hosting_environment(self) -> Optional[pulumi.Input[str]]:
        """
        App Service Environment.
        """
        return pulumi.get(self, "hosting_environment")

    @hosting_environment.setter
    def hosting_environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hosting_environment", value)

    @property
    @pulumi.getter
    def overwrite(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> to overwrite destination app; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "overwrite")

    @overwrite.setter
    def overwrite(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "overwrite", value)

    @property
    @pulumi.getter(name="sourceWebAppLocation")
    def source_web_app_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location of source app ex: West US or North Europe
        """
        return pulumi.get(self, "source_web_app_location")

    @source_web_app_location.setter
    def source_web_app_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_web_app_location", value)

    @property
    @pulumi.getter(name="trafficManagerProfileId")
    def traffic_manager_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the Traffic Manager profile to use, if it exists. Traffic Manager resource ID is of the form 
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
        """
        return pulumi.get(self, "traffic_manager_profile_id")

    @traffic_manager_profile_id.setter
    def traffic_manager_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_manager_profile_id", value)

    @property
    @pulumi.getter(name="trafficManagerProfileName")
    def traffic_manager_profile_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of Traffic Manager profile to create. This is only needed if Traffic Manager profile does not already exist.
        """
        return pulumi.get(self, "traffic_manager_profile_name")

    @traffic_manager_profile_name.setter
    def traffic_manager_profile_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_manager_profile_name", value)


@pulumi.input_type
class ConnStringInfoArgs:
    def __init__(__self__, *,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['ConnectionStringType']] = None):
        """
        Database connection string information.
        :param pulumi.Input[str] connection_string: Connection string value.
        :param pulumi.Input[str] name: Name of connection string.
        :param pulumi.Input['ConnectionStringType'] type: Type of database.
        """
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        Connection string value.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of connection string.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ConnectionStringType']]:
        """
        Type of database.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ConnectionStringType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ConnStringValueTypePairArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['ConnectionStringType'],
                 value: pulumi.Input[str]):
        """
        Database connection string value to type pair.
        :param pulumi.Input['ConnectionStringType'] type: Type of database.
        :param pulumi.Input[str] value: Value of pair.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['ConnectionStringType']:
        """
        Type of database.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['ConnectionStringType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of pair.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class CookieExpirationArgs:
    def __init__(__self__, *,
                 convention: Optional[pulumi.Input['CookieExpirationConvention']] = None,
                 time_to_expiration: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the session cookie's expiration.
        :param pulumi.Input['CookieExpirationConvention'] convention: The convention used when determining the session cookie's expiration.
        :param pulumi.Input[str] time_to_expiration: The time after the request is made when the session cookie should expire.
        """
        if convention is not None:
            pulumi.set(__self__, "convention", convention)
        if time_to_expiration is not None:
            pulumi.set(__self__, "time_to_expiration", time_to_expiration)

    @property
    @pulumi.getter
    def convention(self) -> Optional[pulumi.Input['CookieExpirationConvention']]:
        """
        The convention used when determining the session cookie's expiration.
        """
        return pulumi.get(self, "convention")

    @convention.setter
    def convention(self, value: Optional[pulumi.Input['CookieExpirationConvention']]):
        pulumi.set(self, "convention", value)

    @property
    @pulumi.getter(name="timeToExpiration")
    def time_to_expiration(self) -> Optional[pulumi.Input[str]]:
        """
        The time after the request is made when the session cookie should expire.
        """
        return pulumi.get(self, "time_to_expiration")

    @time_to_expiration.setter
    def time_to_expiration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_to_expiration", value)


@pulumi.input_type
class CorsSettingsArgs:
    def __init__(__self__, *,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 support_credentials: Optional[pulumi.Input[bool]] = None):
        """
        Cross-Origin Resource Sharing (CORS) settings for the app.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: Gets or sets the list of origins that should be allowed to make cross-origin
               calls (for example: http://example.com:12345). Use "*" to allow all.
        :param pulumi.Input[bool] support_credentials: Gets or sets whether CORS requests with credentials are allowed. See 
               https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
               for more details.
        """
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if support_credentials is not None:
            pulumi.set(__self__, "support_credentials", support_credentials)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets the list of origins that should be allowed to make cross-origin
        calls (for example: http://example.com:12345). Use "*" to allow all.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="supportCredentials")
    def support_credentials(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets whether CORS requests with credentials are allowed. See 
        https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
        for more details.
        """
        return pulumi.get(self, "support_credentials")

    @support_credentials.setter
    def support_credentials(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "support_credentials", value)


@pulumi.input_type
class CustomOpenIdConnectProviderArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 login: Optional[pulumi.Input['OpenIdConnectLoginArgs']] = None,
                 registration: Optional[pulumi.Input['OpenIdConnectRegistrationArgs']] = None):
        """
        The configuration settings of the custom Open ID Connect provider.
        :param pulumi.Input[bool] enabled: <code>false</code> if the custom Open ID provider provider should not be enabled; otherwise, <code>true</code>.
        :param pulumi.Input['OpenIdConnectLoginArgs'] login: The configuration settings of the login flow of the custom Open ID Connect provider.
        :param pulumi.Input['OpenIdConnectRegistrationArgs'] registration: The configuration settings of the app registration for the custom Open ID Connect provider.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the custom Open ID provider provider should not be enabled; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input['OpenIdConnectLoginArgs']]:
        """
        The configuration settings of the login flow of the custom Open ID Connect provider.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input['OpenIdConnectLoginArgs']]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def registration(self) -> Optional[pulumi.Input['OpenIdConnectRegistrationArgs']]:
        """
        The configuration settings of the app registration for the custom Open ID Connect provider.
        """
        return pulumi.get(self, "registration")

    @registration.setter
    def registration(self, value: Optional[pulumi.Input['OpenIdConnectRegistrationArgs']]):
        pulumi.set(self, "registration", value)


@pulumi.input_type
class DatabaseBackupSetting:
    def __init__(__self__, *,
                 database_type: Union[str, 'DatabaseType'],
                 connection_string: Optional[str] = None,
                 connection_string_name: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Database backup settings.
        :param Union[str, 'DatabaseType'] database_type: Database type (e.g. SqlAzure / MySql).
        :param str connection_string: Contains a connection string to a database which is being backed up or restored. If the restore should happen to a new database, the database name inside is the new one.
        :param str connection_string_name: Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
               This is used during restore with overwrite connection strings options.
        """
        pulumi.set(__self__, "database_type", database_type)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if connection_string_name is not None:
            pulumi.set(__self__, "connection_string_name", connection_string_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Union[str, 'DatabaseType']:
        """
        Database type (e.g. SqlAzure / MySql).
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Union[str, 'DatabaseType']):
        pulumi.set(self, "database_type", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[str]:
        """
        Contains a connection string to a database which is being backed up or restored. If the restore should happen to a new database, the database name inside is the new one.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[str]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="connectionStringName")
    def connection_string_name(self) -> Optional[str]:
        """
        Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
        This is used during restore with overwrite connection strings options.
        """
        return pulumi.get(self, "connection_string_name")

    @connection_string_name.setter
    def connection_string_name(self, value: Optional[str]):
        pulumi.set(self, "connection_string_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class DatabaseBackupSettingArgs:
    def __init__(__self__, *,
                 database_type: pulumi.Input[Union[str, 'DatabaseType']],
                 connection_string: Optional[pulumi.Input[str]] = None,
                 connection_string_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Database backup settings.
        :param pulumi.Input[Union[str, 'DatabaseType']] database_type: Database type (e.g. SqlAzure / MySql).
        :param pulumi.Input[str] connection_string: Contains a connection string to a database which is being backed up or restored. If the restore should happen to a new database, the database name inside is the new one.
        :param pulumi.Input[str] connection_string_name: Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
               This is used during restore with overwrite connection strings options.
        """
        pulumi.set(__self__, "database_type", database_type)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if connection_string_name is not None:
            pulumi.set(__self__, "connection_string_name", connection_string_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Input[Union[str, 'DatabaseType']]:
        """
        Database type (e.g. SqlAzure / MySql).
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: pulumi.Input[Union[str, 'DatabaseType']]):
        pulumi.set(self, "database_type", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        Contains a connection string to a database which is being backed up or restored. If the restore should happen to a new database, the database name inside is the new one.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="connectionStringName")
    def connection_string_name(self) -> Optional[pulumi.Input[str]]:
        """
        Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
        This is used during restore with overwrite connection strings options.
        """
        return pulumi.get(self, "connection_string_name")

    @connection_string_name.setter
    def connection_string_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class EnabledConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Enabled configuration.
        :param pulumi.Input[bool] enabled: True if configuration is enabled, false if it is disabled and null if configuration is not set.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if configuration is enabled, false if it is disabled and null if configuration is not set.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ExperimentsArgs:
    def __init__(__self__, *,
                 ramp_up_rules: Optional[pulumi.Input[Sequence[pulumi.Input['RampUpRuleArgs']]]] = None):
        """
        Routing rules in production experiments.
        :param pulumi.Input[Sequence[pulumi.Input['RampUpRuleArgs']]] ramp_up_rules: List of ramp-up rules.
        """
        if ramp_up_rules is not None:
            pulumi.set(__self__, "ramp_up_rules", ramp_up_rules)

    @property
    @pulumi.getter(name="rampUpRules")
    def ramp_up_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RampUpRuleArgs']]]]:
        """
        List of ramp-up rules.
        """
        return pulumi.get(self, "ramp_up_rules")

    @ramp_up_rules.setter
    def ramp_up_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RampUpRuleArgs']]]]):
        pulumi.set(self, "ramp_up_rules", value)


@pulumi.input_type
class FacebookArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 graph_api_version: Optional[pulumi.Input[str]] = None,
                 login: Optional[pulumi.Input['LoginScopesArgs']] = None,
                 registration: Optional[pulumi.Input['AppRegistrationArgs']] = None):
        """
        The configuration settings of the Facebook provider.
        :param pulumi.Input[bool] enabled: <code>false</code> if the Facebook provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param pulumi.Input[str] graph_api_version: The version of the Facebook api to be used while logging in.
        :param pulumi.Input['LoginScopesArgs'] login: The configuration settings of the login flow.
        :param pulumi.Input['AppRegistrationArgs'] registration: The configuration settings of the app registration for the Facebook provider.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if graph_api_version is not None:
            pulumi.set(__self__, "graph_api_version", graph_api_version)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the Facebook provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="graphApiVersion")
    def graph_api_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the Facebook api to be used while logging in.
        """
        return pulumi.get(self, "graph_api_version")

    @graph_api_version.setter
    def graph_api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "graph_api_version", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input['LoginScopesArgs']]:
        """
        The configuration settings of the login flow.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input['LoginScopesArgs']]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def registration(self) -> Optional[pulumi.Input['AppRegistrationArgs']]:
        """
        The configuration settings of the app registration for the Facebook provider.
        """
        return pulumi.get(self, "registration")

    @registration.setter
    def registration(self, value: Optional[pulumi.Input['AppRegistrationArgs']]):
        pulumi.set(self, "registration", value)


@pulumi.input_type
class FileSystemApplicationLogsConfigArgs:
    def __init__(__self__, *,
                 level: Optional[pulumi.Input['LogLevel']] = None):
        """
        Application logs to file system configuration.
        :param pulumi.Input['LogLevel'] level: Log level.
        """
        if level is None:
            level = 'Off'
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input['LogLevel']]:
        """
        Log level.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input['LogLevel']]):
        pulumi.set(self, "level", value)


@pulumi.input_type
class FileSystemHttpLogsConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 retention_in_days: Optional[pulumi.Input[int]] = None,
                 retention_in_mb: Optional[pulumi.Input[int]] = None):
        """
        Http logs to file system configuration.
        :param pulumi.Input[bool] enabled: True if configuration is enabled, false if it is disabled and null if configuration is not set.
        :param pulumi.Input[int] retention_in_days: Retention in days.
               Remove files older than X days.
               0 or lower means no retention.
        :param pulumi.Input[int] retention_in_mb: Maximum size in megabytes that http log files can use.
               When reached old log files will be removed to make space for new ones.
               Value can range between 25 and 100.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if retention_in_mb is not None:
            pulumi.set(__self__, "retention_in_mb", retention_in_mb)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if configuration is enabled, false if it is disabled and null if configuration is not set.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Retention in days.
        Remove files older than X days.
        0 or lower means no retention.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_in_days", value)

    @property
    @pulumi.getter(name="retentionInMb")
    def retention_in_mb(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum size in megabytes that http log files can use.
        When reached old log files will be removed to make space for new ones.
        Value can range between 25 and 100.
        """
        return pulumi.get(self, "retention_in_mb")

    @retention_in_mb.setter
    def retention_in_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_in_mb", value)


@pulumi.input_type
class FileSystemTokenStoreArgs:
    def __init__(__self__, *,
                 directory: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the storage of the tokens if a file system is used.
        :param pulumi.Input[str] directory: The directory in which the tokens will be stored.
        """
        if directory is not None:
            pulumi.set(__self__, "directory", directory)

    @property
    @pulumi.getter
    def directory(self) -> Optional[pulumi.Input[str]]:
        """
        The directory in which the tokens will be stored.
        """
        return pulumi.get(self, "directory")

    @directory.setter
    def directory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "directory", value)


@pulumi.input_type
class ForwardProxyArgs:
    def __init__(__self__, *,
                 convention: Optional[pulumi.Input['ForwardProxyConvention']] = None,
                 custom_host_header_name: Optional[pulumi.Input[str]] = None,
                 custom_proto_header_name: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of a forward proxy used to make the requests.
        :param pulumi.Input['ForwardProxyConvention'] convention: The convention used to determine the url of the request made.
        :param pulumi.Input[str] custom_host_header_name: The name of the header containing the host of the request.
        :param pulumi.Input[str] custom_proto_header_name: The name of the header containing the scheme of the request.
        """
        if convention is not None:
            pulumi.set(__self__, "convention", convention)
        if custom_host_header_name is not None:
            pulumi.set(__self__, "custom_host_header_name", custom_host_header_name)
        if custom_proto_header_name is not None:
            pulumi.set(__self__, "custom_proto_header_name", custom_proto_header_name)

    @property
    @pulumi.getter
    def convention(self) -> Optional[pulumi.Input['ForwardProxyConvention']]:
        """
        The convention used to determine the url of the request made.
        """
        return pulumi.get(self, "convention")

    @convention.setter
    def convention(self, value: Optional[pulumi.Input['ForwardProxyConvention']]):
        pulumi.set(self, "convention", value)

    @property
    @pulumi.getter(name="customHostHeaderName")
    def custom_host_header_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the header containing the host of the request.
        """
        return pulumi.get(self, "custom_host_header_name")

    @custom_host_header_name.setter
    def custom_host_header_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_host_header_name", value)

    @property
    @pulumi.getter(name="customProtoHeaderName")
    def custom_proto_header_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the header containing the scheme of the request.
        """
        return pulumi.get(self, "custom_proto_header_name")

    @custom_proto_header_name.setter
    def custom_proto_header_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_proto_header_name", value)


@pulumi.input_type
class GitHubActionCodeConfigurationArgs:
    def __init__(__self__, *,
                 runtime_stack: Optional[pulumi.Input[str]] = None,
                 runtime_version: Optional[pulumi.Input[str]] = None):
        """
        The GitHub action code configuration.
        :param pulumi.Input[str] runtime_stack: Runtime stack is used to determine the workflow file content for code base apps.
        :param pulumi.Input[str] runtime_version: Runtime version is used to determine what build version to set in the workflow file.
        """
        if runtime_stack is not None:
            pulumi.set(__self__, "runtime_stack", runtime_stack)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter(name="runtimeStack")
    def runtime_stack(self) -> Optional[pulumi.Input[str]]:
        """
        Runtime stack is used to determine the workflow file content for code base apps.
        """
        return pulumi.get(self, "runtime_stack")

    @runtime_stack.setter
    def runtime_stack(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_stack", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[str]]:
        """
        Runtime version is used to determine what build version to set in the workflow file.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_version", value)


@pulumi.input_type
class GitHubActionConfigurationArgs:
    def __init__(__self__, *,
                 code_configuration: Optional[pulumi.Input['GitHubActionCodeConfigurationArgs']] = None,
                 container_configuration: Optional[pulumi.Input['GitHubActionContainerConfigurationArgs']] = None,
                 generate_workflow_file: Optional[pulumi.Input[bool]] = None,
                 is_linux: Optional[pulumi.Input[bool]] = None):
        """
        The GitHub action configuration.
        :param pulumi.Input['GitHubActionCodeConfigurationArgs'] code_configuration: GitHub Action code configuration.
        :param pulumi.Input['GitHubActionContainerConfigurationArgs'] container_configuration: GitHub Action container configuration.
        :param pulumi.Input[bool] generate_workflow_file: Workflow option to determine whether the workflow file should be generated and written to the repository.
        :param pulumi.Input[bool] is_linux: This will help determine the workflow configuration to select.
        """
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)
        if container_configuration is not None:
            pulumi.set(__self__, "container_configuration", container_configuration)
        if generate_workflow_file is not None:
            pulumi.set(__self__, "generate_workflow_file", generate_workflow_file)
        if is_linux is not None:
            pulumi.set(__self__, "is_linux", is_linux)

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional[pulumi.Input['GitHubActionCodeConfigurationArgs']]:
        """
        GitHub Action code configuration.
        """
        return pulumi.get(self, "code_configuration")

    @code_configuration.setter
    def code_configuration(self, value: Optional[pulumi.Input['GitHubActionCodeConfigurationArgs']]):
        pulumi.set(self, "code_configuration", value)

    @property
    @pulumi.getter(name="containerConfiguration")
    def container_configuration(self) -> Optional[pulumi.Input['GitHubActionContainerConfigurationArgs']]:
        """
        GitHub Action container configuration.
        """
        return pulumi.get(self, "container_configuration")

    @container_configuration.setter
    def container_configuration(self, value: Optional[pulumi.Input['GitHubActionContainerConfigurationArgs']]):
        pulumi.set(self, "container_configuration", value)

    @property
    @pulumi.getter(name="generateWorkflowFile")
    def generate_workflow_file(self) -> Optional[pulumi.Input[bool]]:
        """
        Workflow option to determine whether the workflow file should be generated and written to the repository.
        """
        return pulumi.get(self, "generate_workflow_file")

    @generate_workflow_file.setter
    def generate_workflow_file(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "generate_workflow_file", value)

    @property
    @pulumi.getter(name="isLinux")
    def is_linux(self) -> Optional[pulumi.Input[bool]]:
        """
        This will help determine the workflow configuration to select.
        """
        return pulumi.get(self, "is_linux")

    @is_linux.setter
    def is_linux(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_linux", value)


@pulumi.input_type
class GitHubActionContainerConfigurationArgs:
    def __init__(__self__, *,
                 image_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 server_url: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        The GitHub action container configuration.
        :param pulumi.Input[str] image_name: The image name for the build.
        :param pulumi.Input[str] password: The password used to upload the image to the container registry.
        :param pulumi.Input[str] server_url: The server URL for the container registry where the build will be hosted.
        :param pulumi.Input[str] username: The username used to upload the image to the container registry.
        """
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if server_url is not None:
            pulumi.set(__self__, "server_url", server_url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[str]]:
        """
        The image name for the build.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password used to upload the image to the container registry.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> Optional[pulumi.Input[str]]:
        """
        The server URL for the container registry where the build will be hosted.
        """
        return pulumi.get(self, "server_url")

    @server_url.setter
    def server_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_url", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username used to upload the image to the container registry.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class GitHubArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 login: Optional[pulumi.Input['LoginScopesArgs']] = None,
                 registration: Optional[pulumi.Input['ClientRegistrationArgs']] = None):
        """
        The configuration settings of the GitHub provider.
        :param pulumi.Input[bool] enabled: <code>false</code> if the GitHub provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param pulumi.Input['LoginScopesArgs'] login: The configuration settings of the login flow.
        :param pulumi.Input['ClientRegistrationArgs'] registration: The configuration settings of the app registration for the GitHub provider.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the GitHub provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input['LoginScopesArgs']]:
        """
        The configuration settings of the login flow.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input['LoginScopesArgs']]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def registration(self) -> Optional[pulumi.Input['ClientRegistrationArgs']]:
        """
        The configuration settings of the app registration for the GitHub provider.
        """
        return pulumi.get(self, "registration")

    @registration.setter
    def registration(self, value: Optional[pulumi.Input['ClientRegistrationArgs']]):
        pulumi.set(self, "registration", value)


@pulumi.input_type
class GlobalValidationArgs:
    def __init__(__self__, *,
                 excluded_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 redirect_to_provider: Optional[pulumi.Input[str]] = None,
                 require_authentication: Optional[pulumi.Input[bool]] = None,
                 unauthenticated_client_action: Optional[pulumi.Input['UnauthenticatedClientActionV2']] = None):
        """
        The configuration settings that determines the validation flow of users using App Service Authentication/Authorization.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_paths: The paths for which unauthenticated flow would not be redirected to the login page.
        :param pulumi.Input[str] redirect_to_provider: The default authentication provider to use when multiple providers are configured.
               This setting is only needed if multiple providers are configured and the unauthenticated client
               action is set to "RedirectToLoginPage".
        :param pulumi.Input[bool] require_authentication: <code>true</code> if the authentication flow is required any request is made; otherwise, <code>false</code>.
        :param pulumi.Input['UnauthenticatedClientActionV2'] unauthenticated_client_action: The action to take when an unauthenticated client attempts to access the app.
        """
        if excluded_paths is not None:
            pulumi.set(__self__, "excluded_paths", excluded_paths)
        if redirect_to_provider is not None:
            pulumi.set(__self__, "redirect_to_provider", redirect_to_provider)
        if require_authentication is not None:
            pulumi.set(__self__, "require_authentication", require_authentication)
        if unauthenticated_client_action is not None:
            pulumi.set(__self__, "unauthenticated_client_action", unauthenticated_client_action)

    @property
    @pulumi.getter(name="excludedPaths")
    def excluded_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The paths for which unauthenticated flow would not be redirected to the login page.
        """
        return pulumi.get(self, "excluded_paths")

    @excluded_paths.setter
    def excluded_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excluded_paths", value)

    @property
    @pulumi.getter(name="redirectToProvider")
    def redirect_to_provider(self) -> Optional[pulumi.Input[str]]:
        """
        The default authentication provider to use when multiple providers are configured.
        This setting is only needed if multiple providers are configured and the unauthenticated client
        action is set to "RedirectToLoginPage".
        """
        return pulumi.get(self, "redirect_to_provider")

    @redirect_to_provider.setter
    def redirect_to_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect_to_provider", value)

    @property
    @pulumi.getter(name="requireAuthentication")
    def require_authentication(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> if the authentication flow is required any request is made; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "require_authentication")

    @require_authentication.setter
    def require_authentication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_authentication", value)

    @property
    @pulumi.getter(name="unauthenticatedClientAction")
    def unauthenticated_client_action(self) -> Optional[pulumi.Input['UnauthenticatedClientActionV2']]:
        """
        The action to take when an unauthenticated client attempts to access the app.
        """
        return pulumi.get(self, "unauthenticated_client_action")

    @unauthenticated_client_action.setter
    def unauthenticated_client_action(self, value: Optional[pulumi.Input['UnauthenticatedClientActionV2']]):
        pulumi.set(self, "unauthenticated_client_action", value)


@pulumi.input_type
class GoogleArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 login: Optional[pulumi.Input['LoginScopesArgs']] = None,
                 registration: Optional[pulumi.Input['ClientRegistrationArgs']] = None,
                 validation: Optional[pulumi.Input['AllowedAudiencesValidationArgs']] = None):
        """
        The configuration settings of the Google provider.
        :param pulumi.Input[bool] enabled: <code>false</code> if the Google provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param pulumi.Input['LoginScopesArgs'] login: The configuration settings of the login flow.
        :param pulumi.Input['ClientRegistrationArgs'] registration: The configuration settings of the app registration for the Google provider.
        :param pulumi.Input['AllowedAudiencesValidationArgs'] validation: The configuration settings of the Azure Active Directory token validation flow.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)
        if validation is not None:
            pulumi.set(__self__, "validation", validation)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the Google provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input['LoginScopesArgs']]:
        """
        The configuration settings of the login flow.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input['LoginScopesArgs']]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def registration(self) -> Optional[pulumi.Input['ClientRegistrationArgs']]:
        """
        The configuration settings of the app registration for the Google provider.
        """
        return pulumi.get(self, "registration")

    @registration.setter
    def registration(self, value: Optional[pulumi.Input['ClientRegistrationArgs']]):
        pulumi.set(self, "registration", value)

    @property
    @pulumi.getter
    def validation(self) -> Optional[pulumi.Input['AllowedAudiencesValidationArgs']]:
        """
        The configuration settings of the Azure Active Directory token validation flow.
        """
        return pulumi.get(self, "validation")

    @validation.setter
    def validation(self, value: Optional[pulumi.Input['AllowedAudiencesValidationArgs']]):
        pulumi.set(self, "validation", value)


@pulumi.input_type
class HandlerMappingArgs:
    def __init__(__self__, *,
                 arguments: Optional[pulumi.Input[str]] = None,
                 extension: Optional[pulumi.Input[str]] = None,
                 script_processor: Optional[pulumi.Input[str]] = None):
        """
        The IIS handler mappings used to define which handler processes HTTP requests with certain extension. 
        For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php extension.
        :param pulumi.Input[str] arguments: Command-line arguments to be passed to the script processor.
        :param pulumi.Input[str] extension: Requests with this extension will be handled using the specified FastCGI application.
        :param pulumi.Input[str] script_processor: The absolute path to the FastCGI application.
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if script_processor is not None:
            pulumi.set(__self__, "script_processor", script_processor)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[str]]:
        """
        Command-line arguments to be passed to the script processor.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input[str]]:
        """
        Requests with this extension will be handled using the specified FastCGI application.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extension", value)

    @property
    @pulumi.getter(name="scriptProcessor")
    def script_processor(self) -> Optional[pulumi.Input[str]]:
        """
        The absolute path to the FastCGI application.
        """
        return pulumi.get(self, "script_processor")

    @script_processor.setter
    def script_processor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_processor", value)


@pulumi.input_type
class HostNameSslStateArgs:
    def __init__(__self__, *,
                 host_type: Optional[pulumi.Input['HostType']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ssl_state: Optional[pulumi.Input['SslState']] = None,
                 thumbprint: Optional[pulumi.Input[str]] = None,
                 to_update: Optional[pulumi.Input[bool]] = None,
                 virtual_ip: Optional[pulumi.Input[str]] = None):
        """
        SSL-enabled hostname.
        :param pulumi.Input['HostType'] host_type: Indicates whether the hostname is a standard or repository hostname.
        :param pulumi.Input[str] name: Hostname.
        :param pulumi.Input['SslState'] ssl_state: SSL type.
        :param pulumi.Input[str] thumbprint: SSL certificate thumbprint.
        :param pulumi.Input[bool] to_update: Set to <code>true</code> to update existing hostname.
        :param pulumi.Input[str] virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
        """
        if host_type is not None:
            pulumi.set(__self__, "host_type", host_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ssl_state is not None:
            pulumi.set(__self__, "ssl_state", ssl_state)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)
        if to_update is not None:
            pulumi.set(__self__, "to_update", to_update)
        if virtual_ip is not None:
            pulumi.set(__self__, "virtual_ip", virtual_ip)

    @property
    @pulumi.getter(name="hostType")
    def host_type(self) -> Optional[pulumi.Input['HostType']]:
        """
        Indicates whether the hostname is a standard or repository hostname.
        """
        return pulumi.get(self, "host_type")

    @host_type.setter
    def host_type(self, value: Optional[pulumi.Input['HostType']]):
        pulumi.set(self, "host_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sslState")
    def ssl_state(self) -> Optional[pulumi.Input['SslState']]:
        """
        SSL type.
        """
        return pulumi.get(self, "ssl_state")

    @ssl_state.setter
    def ssl_state(self, value: Optional[pulumi.Input['SslState']]):
        pulumi.set(self, "ssl_state", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        SSL certificate thumbprint.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint", value)

    @property
    @pulumi.getter(name="toUpdate")
    def to_update(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to <code>true</code> to update existing hostname.
        """
        return pulumi.get(self, "to_update")

    @to_update.setter
    def to_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "to_update", value)

    @property
    @pulumi.getter(name="virtualIP")
    def virtual_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual IP address assigned to the hostname if IP based SSL is enabled.
        """
        return pulumi.get(self, "virtual_ip")

    @virtual_ip.setter
    def virtual_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_ip", value)


@pulumi.input_type
class HostingEnvironmentProfileArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Specification for an App Service Environment to use for this resource.
        :param pulumi.Input[str] id: Resource ID of the App Service Environment.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID of the App Service Environment.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class HttpLogsConfigArgs:
    def __init__(__self__, *,
                 azure_blob_storage: Optional[pulumi.Input['AzureBlobStorageHttpLogsConfigArgs']] = None,
                 file_system: Optional[pulumi.Input['FileSystemHttpLogsConfigArgs']] = None):
        """
        Http logs configuration.
        :param pulumi.Input['AzureBlobStorageHttpLogsConfigArgs'] azure_blob_storage: Http logs to azure blob storage configuration.
        :param pulumi.Input['FileSystemHttpLogsConfigArgs'] file_system: Http logs to file system configuration.
        """
        if azure_blob_storage is not None:
            pulumi.set(__self__, "azure_blob_storage", azure_blob_storage)
        if file_system is not None:
            pulumi.set(__self__, "file_system", file_system)

    @property
    @pulumi.getter(name="azureBlobStorage")
    def azure_blob_storage(self) -> Optional[pulumi.Input['AzureBlobStorageHttpLogsConfigArgs']]:
        """
        Http logs to azure blob storage configuration.
        """
        return pulumi.get(self, "azure_blob_storage")

    @azure_blob_storage.setter
    def azure_blob_storage(self, value: Optional[pulumi.Input['AzureBlobStorageHttpLogsConfigArgs']]):
        pulumi.set(self, "azure_blob_storage", value)

    @property
    @pulumi.getter(name="fileSystem")
    def file_system(self) -> Optional[pulumi.Input['FileSystemHttpLogsConfigArgs']]:
        """
        Http logs to file system configuration.
        """
        return pulumi.get(self, "file_system")

    @file_system.setter
    def file_system(self, value: Optional[pulumi.Input['FileSystemHttpLogsConfigArgs']]):
        pulumi.set(self, "file_system", value)


@pulumi.input_type
class HttpSettingsRoutesArgs:
    def __init__(__self__, *,
                 api_prefix: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the paths HTTP requests.
        :param pulumi.Input[str] api_prefix: The prefix that should precede all the authentication/authorization paths.
        """
        if api_prefix is not None:
            pulumi.set(__self__, "api_prefix", api_prefix)

    @property
    @pulumi.getter(name="apiPrefix")
    def api_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix that should precede all the authentication/authorization paths.
        """
        return pulumi.get(self, "api_prefix")

    @api_prefix.setter
    def api_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_prefix", value)


@pulumi.input_type
class HttpSettingsArgs:
    def __init__(__self__, *,
                 forward_proxy: Optional[pulumi.Input['ForwardProxyArgs']] = None,
                 require_https: Optional[pulumi.Input[bool]] = None,
                 routes: Optional[pulumi.Input['HttpSettingsRoutesArgs']] = None):
        """
        The configuration settings of the HTTP requests for authentication and authorization requests made against App Service Authentication/Authorization.
        :param pulumi.Input['ForwardProxyArgs'] forward_proxy: The configuration settings of a forward proxy used to make the requests.
        :param pulumi.Input[bool] require_https: <code>false</code> if the authentication/authorization responses not having the HTTPS scheme are permissible; otherwise, <code>true</code>.
        :param pulumi.Input['HttpSettingsRoutesArgs'] routes: The configuration settings of the paths HTTP requests.
        """
        if forward_proxy is not None:
            pulumi.set(__self__, "forward_proxy", forward_proxy)
        if require_https is not None:
            pulumi.set(__self__, "require_https", require_https)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter(name="forwardProxy")
    def forward_proxy(self) -> Optional[pulumi.Input['ForwardProxyArgs']]:
        """
        The configuration settings of a forward proxy used to make the requests.
        """
        return pulumi.get(self, "forward_proxy")

    @forward_proxy.setter
    def forward_proxy(self, value: Optional[pulumi.Input['ForwardProxyArgs']]):
        pulumi.set(self, "forward_proxy", value)

    @property
    @pulumi.getter(name="requireHttps")
    def require_https(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the authentication/authorization responses not having the HTTPS scheme are permissible; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "require_https")

    @require_https.setter
    def require_https(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_https", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input['HttpSettingsRoutesArgs']]:
        """
        The configuration settings of the paths HTTP requests.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input['HttpSettingsRoutesArgs']]):
        pulumi.set(self, "routes", value)


@pulumi.input_type
class IdentityProvidersArgs:
    def __init__(__self__, *,
                 apple: Optional[pulumi.Input['AppleArgs']] = None,
                 azure_active_directory: Optional[pulumi.Input['AzureActiveDirectoryArgs']] = None,
                 azure_static_web_apps: Optional[pulumi.Input['AzureStaticWebAppsArgs']] = None,
                 custom_open_id_connect_providers: Optional[pulumi.Input[Mapping[str, pulumi.Input['CustomOpenIdConnectProviderArgs']]]] = None,
                 facebook: Optional[pulumi.Input['FacebookArgs']] = None,
                 git_hub: Optional[pulumi.Input['GitHubArgs']] = None,
                 google: Optional[pulumi.Input['GoogleArgs']] = None,
                 legacy_microsoft_account: Optional[pulumi.Input['LegacyMicrosoftAccountArgs']] = None,
                 twitter: Optional[pulumi.Input['TwitterArgs']] = None):
        """
        The configuration settings of each of the identity providers used to configure App Service Authentication/Authorization.
        :param pulumi.Input['AppleArgs'] apple: The configuration settings of the Apple provider.
        :param pulumi.Input['AzureActiveDirectoryArgs'] azure_active_directory: The configuration settings of the Azure Active directory provider.
        :param pulumi.Input['AzureStaticWebAppsArgs'] azure_static_web_apps: The configuration settings of the Azure Static Web Apps provider.
        :param pulumi.Input[Mapping[str, pulumi.Input['CustomOpenIdConnectProviderArgs']]] custom_open_id_connect_providers: The map of the name of the alias of each custom Open ID Connect provider to the
               configuration settings of the custom Open ID Connect provider.
        :param pulumi.Input['FacebookArgs'] facebook: The configuration settings of the Facebook provider.
        :param pulumi.Input['GitHubArgs'] git_hub: The configuration settings of the GitHub provider.
        :param pulumi.Input['GoogleArgs'] google: The configuration settings of the Google provider.
        :param pulumi.Input['LegacyMicrosoftAccountArgs'] legacy_microsoft_account: The configuration settings of the legacy Microsoft Account provider.
        :param pulumi.Input['TwitterArgs'] twitter: The configuration settings of the Twitter provider.
        """
        if apple is not None:
            pulumi.set(__self__, "apple", apple)
        if azure_active_directory is not None:
            pulumi.set(__self__, "azure_active_directory", azure_active_directory)
        if azure_static_web_apps is not None:
            pulumi.set(__self__, "azure_static_web_apps", azure_static_web_apps)
        if custom_open_id_connect_providers is not None:
            pulumi.set(__self__, "custom_open_id_connect_providers", custom_open_id_connect_providers)
        if facebook is not None:
            pulumi.set(__self__, "facebook", facebook)
        if git_hub is not None:
            pulumi.set(__self__, "git_hub", git_hub)
        if google is not None:
            pulumi.set(__self__, "google", google)
        if legacy_microsoft_account is not None:
            pulumi.set(__self__, "legacy_microsoft_account", legacy_microsoft_account)
        if twitter is not None:
            pulumi.set(__self__, "twitter", twitter)

    @property
    @pulumi.getter
    def apple(self) -> Optional[pulumi.Input['AppleArgs']]:
        """
        The configuration settings of the Apple provider.
        """
        return pulumi.get(self, "apple")

    @apple.setter
    def apple(self, value: Optional[pulumi.Input['AppleArgs']]):
        pulumi.set(self, "apple", value)

    @property
    @pulumi.getter(name="azureActiveDirectory")
    def azure_active_directory(self) -> Optional[pulumi.Input['AzureActiveDirectoryArgs']]:
        """
        The configuration settings of the Azure Active directory provider.
        """
        return pulumi.get(self, "azure_active_directory")

    @azure_active_directory.setter
    def azure_active_directory(self, value: Optional[pulumi.Input['AzureActiveDirectoryArgs']]):
        pulumi.set(self, "azure_active_directory", value)

    @property
    @pulumi.getter(name="azureStaticWebApps")
    def azure_static_web_apps(self) -> Optional[pulumi.Input['AzureStaticWebAppsArgs']]:
        """
        The configuration settings of the Azure Static Web Apps provider.
        """
        return pulumi.get(self, "azure_static_web_apps")

    @azure_static_web_apps.setter
    def azure_static_web_apps(self, value: Optional[pulumi.Input['AzureStaticWebAppsArgs']]):
        pulumi.set(self, "azure_static_web_apps", value)

    @property
    @pulumi.getter(name="customOpenIdConnectProviders")
    def custom_open_id_connect_providers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['CustomOpenIdConnectProviderArgs']]]]:
        """
        The map of the name of the alias of each custom Open ID Connect provider to the
        configuration settings of the custom Open ID Connect provider.
        """
        return pulumi.get(self, "custom_open_id_connect_providers")

    @custom_open_id_connect_providers.setter
    def custom_open_id_connect_providers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['CustomOpenIdConnectProviderArgs']]]]):
        pulumi.set(self, "custom_open_id_connect_providers", value)

    @property
    @pulumi.getter
    def facebook(self) -> Optional[pulumi.Input['FacebookArgs']]:
        """
        The configuration settings of the Facebook provider.
        """
        return pulumi.get(self, "facebook")

    @facebook.setter
    def facebook(self, value: Optional[pulumi.Input['FacebookArgs']]):
        pulumi.set(self, "facebook", value)

    @property
    @pulumi.getter(name="gitHub")
    def git_hub(self) -> Optional[pulumi.Input['GitHubArgs']]:
        """
        The configuration settings of the GitHub provider.
        """
        return pulumi.get(self, "git_hub")

    @git_hub.setter
    def git_hub(self, value: Optional[pulumi.Input['GitHubArgs']]):
        pulumi.set(self, "git_hub", value)

    @property
    @pulumi.getter
    def google(self) -> Optional[pulumi.Input['GoogleArgs']]:
        """
        The configuration settings of the Google provider.
        """
        return pulumi.get(self, "google")

    @google.setter
    def google(self, value: Optional[pulumi.Input['GoogleArgs']]):
        pulumi.set(self, "google", value)

    @property
    @pulumi.getter(name="legacyMicrosoftAccount")
    def legacy_microsoft_account(self) -> Optional[pulumi.Input['LegacyMicrosoftAccountArgs']]:
        """
        The configuration settings of the legacy Microsoft Account provider.
        """
        return pulumi.get(self, "legacy_microsoft_account")

    @legacy_microsoft_account.setter
    def legacy_microsoft_account(self, value: Optional[pulumi.Input['LegacyMicrosoftAccountArgs']]):
        pulumi.set(self, "legacy_microsoft_account", value)

    @property
    @pulumi.getter
    def twitter(self) -> Optional[pulumi.Input['TwitterArgs']]:
        """
        The configuration settings of the Twitter provider.
        """
        return pulumi.get(self, "twitter")

    @twitter.setter
    def twitter(self, value: Optional[pulumi.Input['TwitterArgs']]):
        pulumi.set(self, "twitter", value)


@pulumi.input_type
class IpSecurityRestrictionArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 subnet_mask: Optional[pulumi.Input[str]] = None,
                 subnet_traffic_tag: Optional[pulumi.Input[int]] = None,
                 tag: Optional[pulumi.Input[Union[str, 'IpFilterTag']]] = None,
                 vnet_subnet_resource_id: Optional[pulumi.Input[str]] = None,
                 vnet_traffic_tag: Optional[pulumi.Input[int]] = None):
        """
        IP security restriction on an app.
        :param pulumi.Input[str] action: Allow or Deny access for this IP range.
        :param pulumi.Input[str] description: IP restriction rule description.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]] headers: IP restriction rule headers.
               X-Forwarded-Host (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples). 
               The matching logic is ..
               - If the property is null or empty (default), all hosts(or lack of) are allowed.
               - A value is compared using ordinal-ignore-case (excluding port number).
               - Subdomain wildcards are permitted but don't match the root domain. For example, *.contoso.com matches the subdomain foo.contoso.com
                but not the root domain contoso.com or multi-level foo.bar.contoso.com
               - Unicode host names are allowed but are converted to Punycode for matching.
               
               X-Forwarded-For (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples).
               The matching logic is ..
               - If the property is null or empty (default), any forwarded-for chains (or lack of) are allowed.
               - If any address (excluding port number) in the chain (comma separated) matches the CIDR defined by the property.
               
               X-Azure-FDID and X-FD-HealthProbe.
               The matching logic is exact match.
        :param pulumi.Input[str] ip_address: IP address the security restriction is valid for.
               It can be in form of pure ipv4 address (required SubnetMask property) or
               CIDR notation such as ipv4/mask (leading bit match). For CIDR,
               SubnetMask property must not be specified.
        :param pulumi.Input[str] name: IP restriction rule name.
        :param pulumi.Input[int] priority: Priority of IP restriction rule.
        :param pulumi.Input[str] subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
        :param pulumi.Input[int] subnet_traffic_tag: (internal) Subnet traffic tag
        :param pulumi.Input[Union[str, 'IpFilterTag']] tag: Defines what this IP filter will be used for. This is to support IP filtering on proxies.
        :param pulumi.Input[str] vnet_subnet_resource_id: Virtual network resource id
        :param pulumi.Input[int] vnet_traffic_tag: (internal) Vnet traffic tag
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if subnet_mask is not None:
            pulumi.set(__self__, "subnet_mask", subnet_mask)
        if subnet_traffic_tag is not None:
            pulumi.set(__self__, "subnet_traffic_tag", subnet_traffic_tag)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if vnet_subnet_resource_id is not None:
            pulumi.set(__self__, "vnet_subnet_resource_id", vnet_subnet_resource_id)
        if vnet_traffic_tag is not None:
            pulumi.set(__self__, "vnet_traffic_tag", vnet_traffic_tag)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        Allow or Deny access for this IP range.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        IP restriction rule description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]]:
        """
        IP restriction rule headers.
        X-Forwarded-Host (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples). 
        The matching logic is ..
        - If the property is null or empty (default), all hosts(or lack of) are allowed.
        - A value is compared using ordinal-ignore-case (excluding port number).
        - Subdomain wildcards are permitted but don't match the root domain. For example, *.contoso.com matches the subdomain foo.contoso.com
         but not the root domain contoso.com or multi-level foo.bar.contoso.com
        - Unicode host names are allowed but are converted to Punycode for matching.

        X-Forwarded-For (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples).
        The matching logic is ..
        - If the property is null or empty (default), any forwarded-for chains (or lack of) are allowed.
        - If any address (excluding port number) in the chain (comma separated) matches the CIDR defined by the property.

        X-Azure-FDID and X-FD-HealthProbe.
        The matching logic is exact match.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address the security restriction is valid for.
        It can be in form of pure ipv4 address (required SubnetMask property) or
        CIDR notation such as ipv4/mask (leading bit match). For CIDR,
        SubnetMask property must not be specified.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        IP restriction rule name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority of IP restriction rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> Optional[pulumi.Input[str]]:
        """
        Subnet mask for the range of IP addresses the restriction is valid for.
        """
        return pulumi.get(self, "subnet_mask")

    @subnet_mask.setter
    def subnet_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_mask", value)

    @property
    @pulumi.getter(name="subnetTrafficTag")
    def subnet_traffic_tag(self) -> Optional[pulumi.Input[int]]:
        """
        (internal) Subnet traffic tag
        """
        return pulumi.get(self, "subnet_traffic_tag")

    @subnet_traffic_tag.setter
    def subnet_traffic_tag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "subnet_traffic_tag", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[Union[str, 'IpFilterTag']]]:
        """
        Defines what this IP filter will be used for. This is to support IP filtering on proxies.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[Union[str, 'IpFilterTag']]]):
        pulumi.set(self, "tag", value)

    @property
    @pulumi.getter(name="vnetSubnetResourceId")
    def vnet_subnet_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual network resource id
        """
        return pulumi.get(self, "vnet_subnet_resource_id")

    @vnet_subnet_resource_id.setter
    def vnet_subnet_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnet_subnet_resource_id", value)

    @property
    @pulumi.getter(name="vnetTrafficTag")
    def vnet_traffic_tag(self) -> Optional[pulumi.Input[int]]:
        """
        (internal) Vnet traffic tag
        """
        return pulumi.get(self, "vnet_traffic_tag")

    @vnet_traffic_tag.setter
    def vnet_traffic_tag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vnet_traffic_tag", value)


@pulumi.input_type
class JwtClaimChecksArgs:
    def __init__(__self__, *,
                 allowed_client_applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration settings of the checks that should be made while validating the JWT Claims.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_client_applications: The list of the allowed client applications.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_groups: The list of the allowed groups.
        """
        if allowed_client_applications is not None:
            pulumi.set(__self__, "allowed_client_applications", allowed_client_applications)
        if allowed_groups is not None:
            pulumi.set(__self__, "allowed_groups", allowed_groups)

    @property
    @pulumi.getter(name="allowedClientApplications")
    def allowed_client_applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of the allowed client applications.
        """
        return pulumi.get(self, "allowed_client_applications")

    @allowed_client_applications.setter
    def allowed_client_applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_client_applications", value)

    @property
    @pulumi.getter(name="allowedGroups")
    def allowed_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of the allowed groups.
        """
        return pulumi.get(self, "allowed_groups")

    @allowed_groups.setter
    def allowed_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_groups", value)


@pulumi.input_type
class KubeEnvironmentProfileArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Specification for a Kubernetes Environment to use for this resource.
        :param pulumi.Input[str] id: Resource ID of the Kubernetes Environment.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID of the Kubernetes Environment.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class LegacyMicrosoftAccountArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 login: Optional[pulumi.Input['LoginScopesArgs']] = None,
                 registration: Optional[pulumi.Input['ClientRegistrationArgs']] = None,
                 validation: Optional[pulumi.Input['AllowedAudiencesValidationArgs']] = None):
        """
        The configuration settings of the legacy Microsoft Account provider.
        :param pulumi.Input[bool] enabled: <code>false</code> if the legacy Microsoft Account provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param pulumi.Input['LoginScopesArgs'] login: The configuration settings of the login flow.
        :param pulumi.Input['ClientRegistrationArgs'] registration: The configuration settings of the app registration for the legacy Microsoft Account provider.
        :param pulumi.Input['AllowedAudiencesValidationArgs'] validation: The configuration settings of the legacy Microsoft Account provider token validation flow.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)
        if validation is not None:
            pulumi.set(__self__, "validation", validation)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the legacy Microsoft Account provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input['LoginScopesArgs']]:
        """
        The configuration settings of the login flow.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input['LoginScopesArgs']]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def registration(self) -> Optional[pulumi.Input['ClientRegistrationArgs']]:
        """
        The configuration settings of the app registration for the legacy Microsoft Account provider.
        """
        return pulumi.get(self, "registration")

    @registration.setter
    def registration(self, value: Optional[pulumi.Input['ClientRegistrationArgs']]):
        pulumi.set(self, "registration", value)

    @property
    @pulumi.getter
    def validation(self) -> Optional[pulumi.Input['AllowedAudiencesValidationArgs']]:
        """
        The configuration settings of the legacy Microsoft Account provider token validation flow.
        """
        return pulumi.get(self, "validation")

    @validation.setter
    def validation(self, value: Optional[pulumi.Input['AllowedAudiencesValidationArgs']]):
        pulumi.set(self, "validation", value)


@pulumi.input_type
class LoginRoutesArgs:
    def __init__(__self__, *,
                 logout_endpoint: Optional[pulumi.Input[str]] = None):
        """
        The routes that specify the endpoints used for login and logout requests.
        :param pulumi.Input[str] logout_endpoint: The endpoint at which a logout request should be made.
        """
        if logout_endpoint is not None:
            pulumi.set(__self__, "logout_endpoint", logout_endpoint)

    @property
    @pulumi.getter(name="logoutEndpoint")
    def logout_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint at which a logout request should be made.
        """
        return pulumi.get(self, "logout_endpoint")

    @logout_endpoint.setter
    def logout_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logout_endpoint", value)


@pulumi.input_type
class LoginScopesArgs:
    def __init__(__self__, *,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration settings of the login flow, including the scopes that should be requested.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: A list of the scopes that should be requested while authenticating.
        """
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the scopes that should be requested while authenticating.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes", value)


@pulumi.input_type
class LoginArgs:
    def __init__(__self__, *,
                 allowed_external_redirect_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cookie_expiration: Optional[pulumi.Input['CookieExpirationArgs']] = None,
                 nonce: Optional[pulumi.Input['NonceArgs']] = None,
                 preserve_url_fragments_for_logins: Optional[pulumi.Input[bool]] = None,
                 routes: Optional[pulumi.Input['LoginRoutesArgs']] = None,
                 token_store: Optional[pulumi.Input['TokenStoreArgs']] = None):
        """
        The configuration settings of the login flow of users using App Service Authentication/Authorization.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_external_redirect_urls: External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
               This is an advanced setting typically only needed by Windows Store application backends.
               Note that URLs within the current domain are always implicitly allowed.
        :param pulumi.Input['CookieExpirationArgs'] cookie_expiration: The configuration settings of the session cookie's expiration.
        :param pulumi.Input['NonceArgs'] nonce: The configuration settings of the nonce used in the login flow.
        :param pulumi.Input[bool] preserve_url_fragments_for_logins: <code>true</code> if the fragments from the request are preserved after the login request is made; otherwise, <code>false</code>.
        :param pulumi.Input['LoginRoutesArgs'] routes: The routes that specify the endpoints used for login and logout requests.
        :param pulumi.Input['TokenStoreArgs'] token_store: The configuration settings of the token store.
        """
        if allowed_external_redirect_urls is not None:
            pulumi.set(__self__, "allowed_external_redirect_urls", allowed_external_redirect_urls)
        if cookie_expiration is not None:
            pulumi.set(__self__, "cookie_expiration", cookie_expiration)
        if nonce is not None:
            pulumi.set(__self__, "nonce", nonce)
        if preserve_url_fragments_for_logins is not None:
            pulumi.set(__self__, "preserve_url_fragments_for_logins", preserve_url_fragments_for_logins)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if token_store is not None:
            pulumi.set(__self__, "token_store", token_store)

    @property
    @pulumi.getter(name="allowedExternalRedirectUrls")
    def allowed_external_redirect_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
        This is an advanced setting typically only needed by Windows Store application backends.
        Note that URLs within the current domain are always implicitly allowed.
        """
        return pulumi.get(self, "allowed_external_redirect_urls")

    @allowed_external_redirect_urls.setter
    def allowed_external_redirect_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_external_redirect_urls", value)

    @property
    @pulumi.getter(name="cookieExpiration")
    def cookie_expiration(self) -> Optional[pulumi.Input['CookieExpirationArgs']]:
        """
        The configuration settings of the session cookie's expiration.
        """
        return pulumi.get(self, "cookie_expiration")

    @cookie_expiration.setter
    def cookie_expiration(self, value: Optional[pulumi.Input['CookieExpirationArgs']]):
        pulumi.set(self, "cookie_expiration", value)

    @property
    @pulumi.getter
    def nonce(self) -> Optional[pulumi.Input['NonceArgs']]:
        """
        The configuration settings of the nonce used in the login flow.
        """
        return pulumi.get(self, "nonce")

    @nonce.setter
    def nonce(self, value: Optional[pulumi.Input['NonceArgs']]):
        pulumi.set(self, "nonce", value)

    @property
    @pulumi.getter(name="preserveUrlFragmentsForLogins")
    def preserve_url_fragments_for_logins(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> if the fragments from the request are preserved after the login request is made; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "preserve_url_fragments_for_logins")

    @preserve_url_fragments_for_logins.setter
    def preserve_url_fragments_for_logins(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve_url_fragments_for_logins", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input['LoginRoutesArgs']]:
        """
        The routes that specify the endpoints used for login and logout requests.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input['LoginRoutesArgs']]):
        pulumi.set(self, "routes", value)

    @property
    @pulumi.getter(name="tokenStore")
    def token_store(self) -> Optional[pulumi.Input['TokenStoreArgs']]:
        """
        The configuration settings of the token store.
        """
        return pulumi.get(self, "token_store")

    @token_store.setter
    def token_store(self, value: Optional[pulumi.Input['TokenStoreArgs']]):
        pulumi.set(self, "token_store", value)


@pulumi.input_type
class ManagedServiceIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ManagedServiceIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Managed service identity.
        :param pulumi.Input['ManagedServiceIdentityType'] type: Type of managed service identity.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The list of user assigned identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ManagedServiceIdentityType']]:
        """
        Type of managed service identity.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ManagedServiceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The list of user assigned identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class NameValuePairArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Name value pair.
        :param pulumi.Input[str] name: Pair name.
        :param pulumi.Input[str] value: Pair value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Pair name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Pair value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class NonceArgs:
    def __init__(__self__, *,
                 nonce_expiration_interval: Optional[pulumi.Input[str]] = None,
                 validate_nonce: Optional[pulumi.Input[bool]] = None):
        """
        The configuration settings of the nonce used in the login flow.
        :param pulumi.Input[str] nonce_expiration_interval: The time after the request is made when the nonce should expire.
        :param pulumi.Input[bool] validate_nonce: <code>false</code> if the nonce should not be validated while completing the login flow; otherwise, <code>true</code>.
        """
        if nonce_expiration_interval is not None:
            pulumi.set(__self__, "nonce_expiration_interval", nonce_expiration_interval)
        if validate_nonce is not None:
            pulumi.set(__self__, "validate_nonce", validate_nonce)

    @property
    @pulumi.getter(name="nonceExpirationInterval")
    def nonce_expiration_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The time after the request is made when the nonce should expire.
        """
        return pulumi.get(self, "nonce_expiration_interval")

    @nonce_expiration_interval.setter
    def nonce_expiration_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nonce_expiration_interval", value)

    @property
    @pulumi.getter(name="validateNonce")
    def validate_nonce(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the nonce should not be validated while completing the login flow; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "validate_nonce")

    @validate_nonce.setter
    def validate_nonce(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate_nonce", value)


@pulumi.input_type
class OpenIdConnectClientCredentialArgs:
    def __init__(__self__, *,
                 client_secret_setting_name: Optional[pulumi.Input[str]] = None,
                 method: Optional[pulumi.Input['ClientCredentialMethod']] = None):
        """
        The authentication client credentials of the custom Open ID Connect provider.
        :param pulumi.Input[str] client_secret_setting_name: The app setting that contains the client secret for the custom Open ID Connect provider.
        :param pulumi.Input['ClientCredentialMethod'] method: The method that should be used to authenticate the user.
        """
        if client_secret_setting_name is not None:
            pulumi.set(__self__, "client_secret_setting_name", client_secret_setting_name)
        if method is not None:
            pulumi.set(__self__, "method", method)

    @property
    @pulumi.getter(name="clientSecretSettingName")
    def client_secret_setting_name(self) -> Optional[pulumi.Input[str]]:
        """
        The app setting that contains the client secret for the custom Open ID Connect provider.
        """
        return pulumi.get(self, "client_secret_setting_name")

    @client_secret_setting_name.setter
    def client_secret_setting_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret_setting_name", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input['ClientCredentialMethod']]:
        """
        The method that should be used to authenticate the user.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input['ClientCredentialMethod']]):
        pulumi.set(self, "method", value)


@pulumi.input_type
class OpenIdConnectConfigArgs:
    def __init__(__self__, *,
                 authorization_endpoint: Optional[pulumi.Input[str]] = None,
                 certification_uri: Optional[pulumi.Input[str]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 token_endpoint: Optional[pulumi.Input[str]] = None,
                 well_known_open_id_configuration: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the endpoints used for the custom Open ID Connect provider.
        :param pulumi.Input[str] authorization_endpoint: The endpoint to be used to make an authorization request.
        :param pulumi.Input[str] certification_uri: The endpoint that provides the keys necessary to validate the token.
        :param pulumi.Input[str] issuer: The endpoint that issues the token.
        :param pulumi.Input[str] token_endpoint: The endpoint to be used to request a token.
        :param pulumi.Input[str] well_known_open_id_configuration: The endpoint that contains all the configuration endpoints for the provider.
        """
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if certification_uri is not None:
            pulumi.set(__self__, "certification_uri", certification_uri)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if well_known_open_id_configuration is not None:
            pulumi.set(__self__, "well_known_open_id_configuration", well_known_open_id_configuration)

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint to be used to make an authorization request.
        """
        return pulumi.get(self, "authorization_endpoint")

    @authorization_endpoint.setter
    def authorization_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_endpoint", value)

    @property
    @pulumi.getter(name="certificationUri")
    def certification_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint that provides the keys necessary to validate the token.
        """
        return pulumi.get(self, "certification_uri")

    @certification_uri.setter
    def certification_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certification_uri", value)

    @property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint that issues the token.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint to be used to request a token.
        """
        return pulumi.get(self, "token_endpoint")

    @token_endpoint.setter
    def token_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_endpoint", value)

    @property
    @pulumi.getter(name="wellKnownOpenIdConfiguration")
    def well_known_open_id_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint that contains all the configuration endpoints for the provider.
        """
        return pulumi.get(self, "well_known_open_id_configuration")

    @well_known_open_id_configuration.setter
    def well_known_open_id_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "well_known_open_id_configuration", value)


@pulumi.input_type
class OpenIdConnectLoginArgs:
    def __init__(__self__, *,
                 name_claim_type: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration settings of the login flow of the custom Open ID Connect provider.
        :param pulumi.Input[str] name_claim_type: The name of the claim that contains the users name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: A list of the scopes that should be requested while authenticating.
        """
        if name_claim_type is not None:
            pulumi.set(__self__, "name_claim_type", name_claim_type)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter(name="nameClaimType")
    def name_claim_type(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the claim that contains the users name.
        """
        return pulumi.get(self, "name_claim_type")

    @name_claim_type.setter
    def name_claim_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_claim_type", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the scopes that should be requested while authenticating.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes", value)


@pulumi.input_type
class OpenIdConnectRegistrationArgs:
    def __init__(__self__, *,
                 client_credential: Optional[pulumi.Input['OpenIdConnectClientCredentialArgs']] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 open_id_connect_configuration: Optional[pulumi.Input['OpenIdConnectConfigArgs']] = None):
        """
        The configuration settings of the app registration for the custom Open ID Connect provider.
        :param pulumi.Input['OpenIdConnectClientCredentialArgs'] client_credential: The authentication credentials of the custom Open ID Connect provider.
        :param pulumi.Input[str] client_id: The client id of the custom Open ID Connect provider.
        :param pulumi.Input['OpenIdConnectConfigArgs'] open_id_connect_configuration: The configuration settings of the endpoints used for the custom Open ID Connect provider.
        """
        if client_credential is not None:
            pulumi.set(__self__, "client_credential", client_credential)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if open_id_connect_configuration is not None:
            pulumi.set(__self__, "open_id_connect_configuration", open_id_connect_configuration)

    @property
    @pulumi.getter(name="clientCredential")
    def client_credential(self) -> Optional[pulumi.Input['OpenIdConnectClientCredentialArgs']]:
        """
        The authentication credentials of the custom Open ID Connect provider.
        """
        return pulumi.get(self, "client_credential")

    @client_credential.setter
    def client_credential(self, value: Optional[pulumi.Input['OpenIdConnectClientCredentialArgs']]):
        pulumi.set(self, "client_credential", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client id of the custom Open ID Connect provider.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="openIdConnectConfiguration")
    def open_id_connect_configuration(self) -> Optional[pulumi.Input['OpenIdConnectConfigArgs']]:
        """
        The configuration settings of the endpoints used for the custom Open ID Connect provider.
        """
        return pulumi.get(self, "open_id_connect_configuration")

    @open_id_connect_configuration.setter
    def open_id_connect_configuration(self, value: Optional[pulumi.Input['OpenIdConnectConfigArgs']]):
        pulumi.set(self, "open_id_connect_configuration", value)


@pulumi.input_type
class PrivateLinkConnectionStateArgs:
    def __init__(__self__, *,
                 actions_required: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        The state of a private link connection
        :param pulumi.Input[str] actions_required: ActionsRequired for a private link connection
        :param pulumi.Input[str] description: Description of a private link connection
        :param pulumi.Input[str] status: Status of a private link connection
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[pulumi.Input[str]]:
        """
        ActionsRequired for a private link connection
        """
        return pulumi.get(self, "actions_required")

    @actions_required.setter
    def actions_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "actions_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of a private link connection
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of a private link connection
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class PushSettingsArgs:
    def __init__(__self__, *,
                 is_push_enabled: pulumi.Input[bool],
                 dynamic_tags_json: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 tag_whitelist_json: Optional[pulumi.Input[str]] = None,
                 tags_requiring_auth: Optional[pulumi.Input[str]] = None):
        """
        Push settings for the App.
        :param pulumi.Input[bool] is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
        :param pulumi.Input[str] dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration endpoint.
        :param pulumi.Input[str] kind: Kind of resource.
        :param pulumi.Input[str] tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
        :param pulumi.Input[str] tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration endpoint.
               Tags can consist of alphanumeric characters and the following:
               '_', '@', '#', '.', ':', '-'. 
               Validation should be performed at the PushRequestHandler.
        """
        pulumi.set(__self__, "is_push_enabled", is_push_enabled)
        if dynamic_tags_json is not None:
            pulumi.set(__self__, "dynamic_tags_json", dynamic_tags_json)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if tag_whitelist_json is not None:
            pulumi.set(__self__, "tag_whitelist_json", tag_whitelist_json)
        if tags_requiring_auth is not None:
            pulumi.set(__self__, "tags_requiring_auth", tags_requiring_auth)

    @property
    @pulumi.getter(name="isPushEnabled")
    def is_push_enabled(self) -> pulumi.Input[bool]:
        """
        Gets or sets a flag indicating whether the Push endpoint is enabled.
        """
        return pulumi.get(self, "is_push_enabled")

    @is_push_enabled.setter
    def is_push_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_push_enabled", value)

    @property
    @pulumi.getter(name="dynamicTagsJson")
    def dynamic_tags_json(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration endpoint.
        """
        return pulumi.get(self, "dynamic_tags_json")

    @dynamic_tags_json.setter
    def dynamic_tags_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dynamic_tags_json", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of resource.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="tagWhitelistJson")
    def tag_whitelist_json(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
        """
        return pulumi.get(self, "tag_whitelist_json")

    @tag_whitelist_json.setter
    def tag_whitelist_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_whitelist_json", value)

    @property
    @pulumi.getter(name="tagsRequiringAuth")
    def tags_requiring_auth(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration endpoint.
        Tags can consist of alphanumeric characters and the following:
        '_', '@', '#', '.', ':', '-'. 
        Validation should be performed at the PushRequestHandler.
        """
        return pulumi.get(self, "tags_requiring_auth")

    @tags_requiring_auth.setter
    def tags_requiring_auth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tags_requiring_auth", value)


@pulumi.input_type
class RampUpRuleArgs:
    def __init__(__self__, *,
                 action_host_name: Optional[pulumi.Input[str]] = None,
                 change_decision_callback_url: Optional[pulumi.Input[str]] = None,
                 change_interval_in_minutes: Optional[pulumi.Input[int]] = None,
                 change_step: Optional[pulumi.Input[float]] = None,
                 max_reroute_percentage: Optional[pulumi.Input[float]] = None,
                 min_reroute_percentage: Optional[pulumi.Input[float]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 reroute_percentage: Optional[pulumi.Input[float]] = None):
        """
        Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or to gradually change routing % based on performance.
        :param pulumi.Input[str] action_host_name: Hostname of a slot to which the traffic will be redirected if decided to. E.g. myapp-stage.azurewebsites.net.
        :param pulumi.Input[str] change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback site extension which URL can be specified. See TiPCallback site extension for the scaffold and contracts.
               https://www.siteextensions.net/packages/TiPCallback/
        :param pulumi.Input[int] change_interval_in_minutes: Specifies interval in minutes to reevaluate ReroutePercentage.
        :param pulumi.Input[float] change_step: In auto ramp up scenario this is the step to add/remove from <code>ReroutePercentage</code> until it reaches \\n<code>MinReroutePercentage</code> or 
               <code>MaxReroutePercentage</code>. Site metrics are checked every N minutes specified in <code>ChangeIntervalInMinutes</code>.\\nCustom decision algorithm 
               can be provided in TiPCallback site extension which URL can be specified in <code>ChangeDecisionCallbackUrl</code>.
        :param pulumi.Input[float] max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will stay.
        :param pulumi.Input[float] min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will stay.
        :param pulumi.Input[str] name: Name of the routing rule. The recommended name would be to point to the slot which will receive the traffic in the experiment.
        :param pulumi.Input[float] reroute_percentage: Percentage of the traffic which will be redirected to <code>ActionHostName</code>.
        """
        if action_host_name is not None:
            pulumi.set(__self__, "action_host_name", action_host_name)
        if change_decision_callback_url is not None:
            pulumi.set(__self__, "change_decision_callback_url", change_decision_callback_url)
        if change_interval_in_minutes is not None:
            pulumi.set(__self__, "change_interval_in_minutes", change_interval_in_minutes)
        if change_step is not None:
            pulumi.set(__self__, "change_step", change_step)
        if max_reroute_percentage is not None:
            pulumi.set(__self__, "max_reroute_percentage", max_reroute_percentage)
        if min_reroute_percentage is not None:
            pulumi.set(__self__, "min_reroute_percentage", min_reroute_percentage)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reroute_percentage is not None:
            pulumi.set(__self__, "reroute_percentage", reroute_percentage)

    @property
    @pulumi.getter(name="actionHostName")
    def action_host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname of a slot to which the traffic will be redirected if decided to. E.g. myapp-stage.azurewebsites.net.
        """
        return pulumi.get(self, "action_host_name")

    @action_host_name.setter
    def action_host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_host_name", value)

    @property
    @pulumi.getter(name="changeDecisionCallbackUrl")
    def change_decision_callback_url(self) -> Optional[pulumi.Input[str]]:
        """
        Custom decision algorithm can be provided in TiPCallback site extension which URL can be specified. See TiPCallback site extension for the scaffold and contracts.
        https://www.siteextensions.net/packages/TiPCallback/
        """
        return pulumi.get(self, "change_decision_callback_url")

    @change_decision_callback_url.setter
    def change_decision_callback_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "change_decision_callback_url", value)

    @property
    @pulumi.getter(name="changeIntervalInMinutes")
    def change_interval_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies interval in minutes to reevaluate ReroutePercentage.
        """
        return pulumi.get(self, "change_interval_in_minutes")

    @change_interval_in_minutes.setter
    def change_interval_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "change_interval_in_minutes", value)

    @property
    @pulumi.getter(name="changeStep")
    def change_step(self) -> Optional[pulumi.Input[float]]:
        """
        In auto ramp up scenario this is the step to add/remove from <code>ReroutePercentage</code> until it reaches \\n<code>MinReroutePercentage</code> or 
        <code>MaxReroutePercentage</code>. Site metrics are checked every N minutes specified in <code>ChangeIntervalInMinutes</code>.\\nCustom decision algorithm 
        can be provided in TiPCallback site extension which URL can be specified in <code>ChangeDecisionCallbackUrl</code>.
        """
        return pulumi.get(self, "change_step")

    @change_step.setter
    def change_step(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "change_step", value)

    @property
    @pulumi.getter(name="maxReroutePercentage")
    def max_reroute_percentage(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies upper boundary below which ReroutePercentage will stay.
        """
        return pulumi.get(self, "max_reroute_percentage")

    @max_reroute_percentage.setter
    def max_reroute_percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_reroute_percentage", value)

    @property
    @pulumi.getter(name="minReroutePercentage")
    def min_reroute_percentage(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies lower boundary above which ReroutePercentage will stay.
        """
        return pulumi.get(self, "min_reroute_percentage")

    @min_reroute_percentage.setter
    def min_reroute_percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "min_reroute_percentage", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the routing rule. The recommended name would be to point to the slot which will receive the traffic in the experiment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="reroutePercentage")
    def reroute_percentage(self) -> Optional[pulumi.Input[float]]:
        """
        Percentage of the traffic which will be redirected to <code>ActionHostName</code>.
        """
        return pulumi.get(self, "reroute_percentage")

    @reroute_percentage.setter
    def reroute_percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "reroute_percentage", value)


@pulumi.input_type
class RequestsBasedTriggerArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None,
                 time_interval: Optional[pulumi.Input[str]] = None):
        """
        Trigger based on total requests.
        :param pulumi.Input[int] count: Request Count.
        :param pulumi.Input[str] time_interval: Time interval.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if time_interval is not None:
            pulumi.set(__self__, "time_interval", time_interval)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Request Count.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="timeInterval")
    def time_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Time interval.
        """
        return pulumi.get(self, "time_interval")

    @time_interval.setter
    def time_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_interval", value)


@pulumi.input_type
class SiteConfigArgs:
    def __init__(__self__, *,
                 acr_use_managed_identity_creds: Optional[pulumi.Input[bool]] = None,
                 acr_user_managed_identity_id: Optional[pulumi.Input[str]] = None,
                 always_on: Optional[pulumi.Input[bool]] = None,
                 api_definition: Optional[pulumi.Input['ApiDefinitionInfoArgs']] = None,
                 api_management_config: Optional[pulumi.Input['ApiManagementConfigArgs']] = None,
                 app_command_line: Optional[pulumi.Input[str]] = None,
                 app_settings: Optional[pulumi.Input[Sequence[pulumi.Input['NameValuePairArgs']]]] = None,
                 auto_heal_enabled: Optional[pulumi.Input[bool]] = None,
                 auto_heal_rules: Optional[pulumi.Input['AutoHealRulesArgs']] = None,
                 auto_swap_slot_name: Optional[pulumi.Input[str]] = None,
                 azure_storage_accounts: Optional[pulumi.Input[Mapping[str, pulumi.Input['AzureStorageInfoValueArgs']]]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['ConnStringInfoArgs']]]] = None,
                 cors: Optional[pulumi.Input['CorsSettingsArgs']] = None,
                 default_documents: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 detailed_error_logging_enabled: Optional[pulumi.Input[bool]] = None,
                 document_root: Optional[pulumi.Input[str]] = None,
                 experiments: Optional[pulumi.Input['ExperimentsArgs']] = None,
                 ftps_state: Optional[pulumi.Input[Union[str, 'FtpsState']]] = None,
                 function_app_scale_limit: Optional[pulumi.Input[int]] = None,
                 functions_runtime_scale_monitoring_enabled: Optional[pulumi.Input[bool]] = None,
                 handler_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['HandlerMappingArgs']]]] = None,
                 health_check_path: Optional[pulumi.Input[str]] = None,
                 http20_enabled: Optional[pulumi.Input[bool]] = None,
                 http_logging_enabled: Optional[pulumi.Input[bool]] = None,
                 ip_security_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input['IpSecurityRestrictionArgs']]]] = None,
                 java_container: Optional[pulumi.Input[str]] = None,
                 java_container_version: Optional[pulumi.Input[str]] = None,
                 java_version: Optional[pulumi.Input[str]] = None,
                 key_vault_reference_identity: Optional[pulumi.Input[str]] = None,
                 limits: Optional[pulumi.Input['SiteLimitsArgs']] = None,
                 linux_fx_version: Optional[pulumi.Input[str]] = None,
                 load_balancing: Optional[pulumi.Input['SiteLoadBalancing']] = None,
                 local_my_sql_enabled: Optional[pulumi.Input[bool]] = None,
                 logs_directory_size_limit: Optional[pulumi.Input[int]] = None,
                 managed_pipeline_mode: Optional[pulumi.Input['ManagedPipelineMode']] = None,
                 managed_service_identity_id: Optional[pulumi.Input[int]] = None,
                 min_tls_version: Optional[pulumi.Input[Union[str, 'SupportedTlsVersions']]] = None,
                 minimum_elastic_instance_count: Optional[pulumi.Input[int]] = None,
                 net_framework_version: Optional[pulumi.Input[str]] = None,
                 node_version: Optional[pulumi.Input[str]] = None,
                 number_of_workers: Optional[pulumi.Input[int]] = None,
                 php_version: Optional[pulumi.Input[str]] = None,
                 power_shell_version: Optional[pulumi.Input[str]] = None,
                 pre_warmed_instance_count: Optional[pulumi.Input[int]] = None,
                 public_network_access: Optional[pulumi.Input[str]] = None,
                 publishing_username: Optional[pulumi.Input[str]] = None,
                 push: Optional[pulumi.Input['PushSettingsArgs']] = None,
                 python_version: Optional[pulumi.Input[str]] = None,
                 remote_debugging_enabled: Optional[pulumi.Input[bool]] = None,
                 remote_debugging_version: Optional[pulumi.Input[str]] = None,
                 request_tracing_enabled: Optional[pulumi.Input[bool]] = None,
                 request_tracing_expiration_time: Optional[pulumi.Input[str]] = None,
                 scm_ip_security_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input['IpSecurityRestrictionArgs']]]] = None,
                 scm_ip_security_restrictions_use_main: Optional[pulumi.Input[bool]] = None,
                 scm_min_tls_version: Optional[pulumi.Input[Union[str, 'SupportedTlsVersions']]] = None,
                 scm_type: Optional[pulumi.Input[Union[str, 'ScmType']]] = None,
                 tracing_options: Optional[pulumi.Input[str]] = None,
                 use32_bit_worker_process: Optional[pulumi.Input[bool]] = None,
                 virtual_applications: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualApplicationArgs']]]] = None,
                 vnet_name: Optional[pulumi.Input[str]] = None,
                 vnet_private_ports_count: Optional[pulumi.Input[int]] = None,
                 vnet_route_all_enabled: Optional[pulumi.Input[bool]] = None,
                 web_sockets_enabled: Optional[pulumi.Input[bool]] = None,
                 website_time_zone: Optional[pulumi.Input[str]] = None,
                 windows_fx_version: Optional[pulumi.Input[str]] = None,
                 x_managed_service_identity_id: Optional[pulumi.Input[int]] = None):
        """
        Configuration of an App Service app.
        :param pulumi.Input[bool] acr_use_managed_identity_creds: Flag to use Managed Identity Creds for ACR pull
        :param pulumi.Input[str] acr_user_managed_identity_id: If using user managed identity, the user managed identity ClientId
        :param pulumi.Input[bool] always_on: <code>true</code> if Always On is enabled; otherwise, <code>false</code>.
        :param pulumi.Input['ApiDefinitionInfoArgs'] api_definition: Information about the formal API definition for the app.
        :param pulumi.Input['ApiManagementConfigArgs'] api_management_config: Azure API management settings linked to the app.
        :param pulumi.Input[str] app_command_line: App command line to launch.
        :param pulumi.Input[Sequence[pulumi.Input['NameValuePairArgs']]] app_settings: Application settings.
        :param pulumi.Input[bool] auto_heal_enabled: <code>true</code> if Auto Heal is enabled; otherwise, <code>false</code>.
        :param pulumi.Input['AutoHealRulesArgs'] auto_heal_rules: Auto Heal rules.
        :param pulumi.Input[str] auto_swap_slot_name: Auto-swap slot name.
        :param pulumi.Input[Mapping[str, pulumi.Input['AzureStorageInfoValueArgs']]] azure_storage_accounts: List of Azure Storage Accounts.
        :param pulumi.Input[Sequence[pulumi.Input['ConnStringInfoArgs']]] connection_strings: Connection strings.
        :param pulumi.Input['CorsSettingsArgs'] cors: Cross-Origin Resource Sharing (CORS) settings.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] default_documents: Default documents.
        :param pulumi.Input[bool] detailed_error_logging_enabled: <code>true</code> if detailed error logging is enabled; otherwise, <code>false</code>.
        :param pulumi.Input[str] document_root: Document root.
        :param pulumi.Input['ExperimentsArgs'] experiments: This is work around for polymorphic types.
        :param pulumi.Input[Union[str, 'FtpsState']] ftps_state: State of FTP / FTPS service
        :param pulumi.Input[int] function_app_scale_limit: Maximum number of workers that a site can scale out to.
               This setting only applies to the Consumption and Elastic Premium Plans
        :param pulumi.Input[bool] functions_runtime_scale_monitoring_enabled: Gets or sets a value indicating whether functions runtime scale monitoring is enabled. When enabled,
               the ScaleController will not monitor event sources directly, but will instead call to the
               runtime to get scale status.
        :param pulumi.Input[Sequence[pulumi.Input['HandlerMappingArgs']]] handler_mappings: Handler mappings.
        :param pulumi.Input[str] health_check_path: Health check path
        :param pulumi.Input[bool] http20_enabled: Http20Enabled: configures a web site to allow clients to connect over http2.0
        :param pulumi.Input[bool] http_logging_enabled: <code>true</code> if HTTP logging is enabled; otherwise, <code>false</code>.
        :param pulumi.Input[Sequence[pulumi.Input['IpSecurityRestrictionArgs']]] ip_security_restrictions: IP security restrictions for main.
        :param pulumi.Input[str] java_container: Java container.
        :param pulumi.Input[str] java_container_version: Java container version.
        :param pulumi.Input[str] java_version: Java version.
        :param pulumi.Input[str] key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
        :param pulumi.Input['SiteLimitsArgs'] limits: Site limits.
        :param pulumi.Input[str] linux_fx_version: Linux App Framework and version
        :param pulumi.Input['SiteLoadBalancing'] load_balancing: Site load balancing.
        :param pulumi.Input[bool] local_my_sql_enabled: <code>true</code> to enable local MySQL; otherwise, <code>false</code>.
        :param pulumi.Input[int] logs_directory_size_limit: HTTP logs directory size limit.
        :param pulumi.Input['ManagedPipelineMode'] managed_pipeline_mode: Managed pipeline mode.
        :param pulumi.Input[int] managed_service_identity_id: Managed Service Identity Id
        :param pulumi.Input[Union[str, 'SupportedTlsVersions']] min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL requests
        :param pulumi.Input[int] minimum_elastic_instance_count: Number of minimum instance count for a site
               This setting only applies to the Elastic Plans
        :param pulumi.Input[str] net_framework_version: .NET Framework version.
        :param pulumi.Input[str] node_version: Version of Node.js.
        :param pulumi.Input[int] number_of_workers: Number of workers.
        :param pulumi.Input[str] php_version: Version of PHP.
        :param pulumi.Input[str] power_shell_version: Version of PowerShell.
        :param pulumi.Input[int] pre_warmed_instance_count: Number of preWarmed instances.
               This setting only applies to the Consumption and Elastic Plans
        :param pulumi.Input[str] public_network_access: Property to allow or block all public traffic.
        :param pulumi.Input[str] publishing_username: Publishing user name.
        :param pulumi.Input['PushSettingsArgs'] push: Push endpoint settings.
        :param pulumi.Input[str] python_version: Version of Python.
        :param pulumi.Input[bool] remote_debugging_enabled: <code>true</code> if remote debugging is enabled; otherwise, <code>false</code>.
        :param pulumi.Input[str] remote_debugging_version: Remote debugging version.
        :param pulumi.Input[bool] request_tracing_enabled: <code>true</code> if request tracing is enabled; otherwise, <code>false</code>.
        :param pulumi.Input[str] request_tracing_expiration_time: Request tracing expiration time.
        :param pulumi.Input[Sequence[pulumi.Input['IpSecurityRestrictionArgs']]] scm_ip_security_restrictions: IP security restrictions for scm.
        :param pulumi.Input[bool] scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
        :param pulumi.Input[Union[str, 'SupportedTlsVersions']] scm_min_tls_version: ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site
        :param pulumi.Input[Union[str, 'ScmType']] scm_type: SCM type.
        :param pulumi.Input[str] tracing_options: Tracing options.
        :param pulumi.Input[bool] use32_bit_worker_process: <code>true</code> to use 32-bit worker process; otherwise, <code>false</code>.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualApplicationArgs']]] virtual_applications: Virtual applications.
        :param pulumi.Input[str] vnet_name: Virtual Network name.
        :param pulumi.Input[int] vnet_private_ports_count: The number of private ports assigned to this app. These will be assigned dynamically on runtime.
        :param pulumi.Input[bool] vnet_route_all_enabled: Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
        :param pulumi.Input[bool] web_sockets_enabled: <code>true</code> if WebSocket is enabled; otherwise, <code>false</code>.
        :param pulumi.Input[str] website_time_zone: Sets the time zone a site uses for generating timestamps. Compatible with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence over this config. For Linux, expects tz database values https://www.iana.org/time-zones (for a quick reference see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the time zones listed under HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Time Zones
        :param pulumi.Input[str] windows_fx_version: Xenon App Framework and version
        :param pulumi.Input[int] x_managed_service_identity_id: Explicit Managed Service Identity Id
        """
        if acr_use_managed_identity_creds is not None:
            pulumi.set(__self__, "acr_use_managed_identity_creds", acr_use_managed_identity_creds)
        if acr_user_managed_identity_id is not None:
            pulumi.set(__self__, "acr_user_managed_identity_id", acr_user_managed_identity_id)
        if always_on is not None:
            pulumi.set(__self__, "always_on", always_on)
        if api_definition is not None:
            pulumi.set(__self__, "api_definition", api_definition)
        if api_management_config is not None:
            pulumi.set(__self__, "api_management_config", api_management_config)
        if app_command_line is not None:
            pulumi.set(__self__, "app_command_line", app_command_line)
        if app_settings is not None:
            pulumi.set(__self__, "app_settings", app_settings)
        if auto_heal_enabled is not None:
            pulumi.set(__self__, "auto_heal_enabled", auto_heal_enabled)
        if auto_heal_rules is not None:
            pulumi.set(__self__, "auto_heal_rules", auto_heal_rules)
        if auto_swap_slot_name is not None:
            pulumi.set(__self__, "auto_swap_slot_name", auto_swap_slot_name)
        if azure_storage_accounts is not None:
            pulumi.set(__self__, "azure_storage_accounts", azure_storage_accounts)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if default_documents is not None:
            pulumi.set(__self__, "default_documents", default_documents)
        if detailed_error_logging_enabled is not None:
            pulumi.set(__self__, "detailed_error_logging_enabled", detailed_error_logging_enabled)
        if document_root is not None:
            pulumi.set(__self__, "document_root", document_root)
        if experiments is not None:
            pulumi.set(__self__, "experiments", experiments)
        if ftps_state is not None:
            pulumi.set(__self__, "ftps_state", ftps_state)
        if function_app_scale_limit is not None:
            pulumi.set(__self__, "function_app_scale_limit", function_app_scale_limit)
        if functions_runtime_scale_monitoring_enabled is not None:
            pulumi.set(__self__, "functions_runtime_scale_monitoring_enabled", functions_runtime_scale_monitoring_enabled)
        if handler_mappings is not None:
            pulumi.set(__self__, "handler_mappings", handler_mappings)
        if health_check_path is not None:
            pulumi.set(__self__, "health_check_path", health_check_path)
        if http20_enabled is None:
            http20_enabled = True
        if http20_enabled is not None:
            pulumi.set(__self__, "http20_enabled", http20_enabled)
        if http_logging_enabled is not None:
            pulumi.set(__self__, "http_logging_enabled", http_logging_enabled)
        if ip_security_restrictions is not None:
            pulumi.set(__self__, "ip_security_restrictions", ip_security_restrictions)
        if java_container is not None:
            pulumi.set(__self__, "java_container", java_container)
        if java_container_version is not None:
            pulumi.set(__self__, "java_container_version", java_container_version)
        if java_version is not None:
            pulumi.set(__self__, "java_version", java_version)
        if key_vault_reference_identity is not None:
            pulumi.set(__self__, "key_vault_reference_identity", key_vault_reference_identity)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if linux_fx_version is not None:
            pulumi.set(__self__, "linux_fx_version", linux_fx_version)
        if load_balancing is not None:
            pulumi.set(__self__, "load_balancing", load_balancing)
        if local_my_sql_enabled is None:
            local_my_sql_enabled = False
        if local_my_sql_enabled is not None:
            pulumi.set(__self__, "local_my_sql_enabled", local_my_sql_enabled)
        if logs_directory_size_limit is not None:
            pulumi.set(__self__, "logs_directory_size_limit", logs_directory_size_limit)
        if managed_pipeline_mode is not None:
            pulumi.set(__self__, "managed_pipeline_mode", managed_pipeline_mode)
        if managed_service_identity_id is not None:
            pulumi.set(__self__, "managed_service_identity_id", managed_service_identity_id)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if minimum_elastic_instance_count is not None:
            pulumi.set(__self__, "minimum_elastic_instance_count", minimum_elastic_instance_count)
        if net_framework_version is None:
            net_framework_version = 'v4.6'
        if net_framework_version is not None:
            pulumi.set(__self__, "net_framework_version", net_framework_version)
        if node_version is not None:
            pulumi.set(__self__, "node_version", node_version)
        if number_of_workers is not None:
            pulumi.set(__self__, "number_of_workers", number_of_workers)
        if php_version is not None:
            pulumi.set(__self__, "php_version", php_version)
        if power_shell_version is not None:
            pulumi.set(__self__, "power_shell_version", power_shell_version)
        if pre_warmed_instance_count is not None:
            pulumi.set(__self__, "pre_warmed_instance_count", pre_warmed_instance_count)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if publishing_username is not None:
            pulumi.set(__self__, "publishing_username", publishing_username)
        if push is not None:
            pulumi.set(__self__, "push", push)
        if python_version is not None:
            pulumi.set(__self__, "python_version", python_version)
        if remote_debugging_enabled is not None:
            pulumi.set(__self__, "remote_debugging_enabled", remote_debugging_enabled)
        if remote_debugging_version is not None:
            pulumi.set(__self__, "remote_debugging_version", remote_debugging_version)
        if request_tracing_enabled is not None:
            pulumi.set(__self__, "request_tracing_enabled", request_tracing_enabled)
        if request_tracing_expiration_time is not None:
            pulumi.set(__self__, "request_tracing_expiration_time", request_tracing_expiration_time)
        if scm_ip_security_restrictions is not None:
            pulumi.set(__self__, "scm_ip_security_restrictions", scm_ip_security_restrictions)
        if scm_ip_security_restrictions_use_main is not None:
            pulumi.set(__self__, "scm_ip_security_restrictions_use_main", scm_ip_security_restrictions_use_main)
        if scm_min_tls_version is not None:
            pulumi.set(__self__, "scm_min_tls_version", scm_min_tls_version)
        if scm_type is not None:
            pulumi.set(__self__, "scm_type", scm_type)
        if tracing_options is not None:
            pulumi.set(__self__, "tracing_options", tracing_options)
        if use32_bit_worker_process is not None:
            pulumi.set(__self__, "use32_bit_worker_process", use32_bit_worker_process)
        if virtual_applications is not None:
            pulumi.set(__self__, "virtual_applications", virtual_applications)
        if vnet_name is not None:
            pulumi.set(__self__, "vnet_name", vnet_name)
        if vnet_private_ports_count is not None:
            pulumi.set(__self__, "vnet_private_ports_count", vnet_private_ports_count)
        if vnet_route_all_enabled is not None:
            pulumi.set(__self__, "vnet_route_all_enabled", vnet_route_all_enabled)
        if web_sockets_enabled is not None:
            pulumi.set(__self__, "web_sockets_enabled", web_sockets_enabled)
        if website_time_zone is not None:
            pulumi.set(__self__, "website_time_zone", website_time_zone)
        if windows_fx_version is not None:
            pulumi.set(__self__, "windows_fx_version", windows_fx_version)
        if x_managed_service_identity_id is not None:
            pulumi.set(__self__, "x_managed_service_identity_id", x_managed_service_identity_id)

    @property
    @pulumi.getter(name="acrUseManagedIdentityCreds")
    def acr_use_managed_identity_creds(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to use Managed Identity Creds for ACR pull
        """
        return pulumi.get(self, "acr_use_managed_identity_creds")

    @acr_use_managed_identity_creds.setter
    def acr_use_managed_identity_creds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "acr_use_managed_identity_creds", value)

    @property
    @pulumi.getter(name="acrUserManagedIdentityID")
    def acr_user_managed_identity_id(self) -> Optional[pulumi.Input[str]]:
        """
        If using user managed identity, the user managed identity ClientId
        """
        return pulumi.get(self, "acr_user_managed_identity_id")

    @acr_user_managed_identity_id.setter
    def acr_user_managed_identity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acr_user_managed_identity_id", value)

    @property
    @pulumi.getter(name="alwaysOn")
    def always_on(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> if Always On is enabled; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "always_on")

    @always_on.setter
    def always_on(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "always_on", value)

    @property
    @pulumi.getter(name="apiDefinition")
    def api_definition(self) -> Optional[pulumi.Input['ApiDefinitionInfoArgs']]:
        """
        Information about the formal API definition for the app.
        """
        return pulumi.get(self, "api_definition")

    @api_definition.setter
    def api_definition(self, value: Optional[pulumi.Input['ApiDefinitionInfoArgs']]):
        pulumi.set(self, "api_definition", value)

    @property
    @pulumi.getter(name="apiManagementConfig")
    def api_management_config(self) -> Optional[pulumi.Input['ApiManagementConfigArgs']]:
        """
        Azure API management settings linked to the app.
        """
        return pulumi.get(self, "api_management_config")

    @api_management_config.setter
    def api_management_config(self, value: Optional[pulumi.Input['ApiManagementConfigArgs']]):
        pulumi.set(self, "api_management_config", value)

    @property
    @pulumi.getter(name="appCommandLine")
    def app_command_line(self) -> Optional[pulumi.Input[str]]:
        """
        App command line to launch.
        """
        return pulumi.get(self, "app_command_line")

    @app_command_line.setter
    def app_command_line(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_command_line", value)

    @property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NameValuePairArgs']]]]:
        """
        Application settings.
        """
        return pulumi.get(self, "app_settings")

    @app_settings.setter
    def app_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NameValuePairArgs']]]]):
        pulumi.set(self, "app_settings", value)

    @property
    @pulumi.getter(name="autoHealEnabled")
    def auto_heal_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> if Auto Heal is enabled; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "auto_heal_enabled")

    @auto_heal_enabled.setter
    def auto_heal_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_heal_enabled", value)

    @property
    @pulumi.getter(name="autoHealRules")
    def auto_heal_rules(self) -> Optional[pulumi.Input['AutoHealRulesArgs']]:
        """
        Auto Heal rules.
        """
        return pulumi.get(self, "auto_heal_rules")

    @auto_heal_rules.setter
    def auto_heal_rules(self, value: Optional[pulumi.Input['AutoHealRulesArgs']]):
        pulumi.set(self, "auto_heal_rules", value)

    @property
    @pulumi.getter(name="autoSwapSlotName")
    def auto_swap_slot_name(self) -> Optional[pulumi.Input[str]]:
        """
        Auto-swap slot name.
        """
        return pulumi.get(self, "auto_swap_slot_name")

    @auto_swap_slot_name.setter
    def auto_swap_slot_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_swap_slot_name", value)

    @property
    @pulumi.getter(name="azureStorageAccounts")
    def azure_storage_accounts(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['AzureStorageInfoValueArgs']]]]:
        """
        List of Azure Storage Accounts.
        """
        return pulumi.get(self, "azure_storage_accounts")

    @azure_storage_accounts.setter
    def azure_storage_accounts(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['AzureStorageInfoValueArgs']]]]):
        pulumi.set(self, "azure_storage_accounts", value)

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnStringInfoArgs']]]]:
        """
        Connection strings.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnStringInfoArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input['CorsSettingsArgs']]:
        """
        Cross-Origin Resource Sharing (CORS) settings.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input['CorsSettingsArgs']]):
        pulumi.set(self, "cors", value)

    @property
    @pulumi.getter(name="defaultDocuments")
    def default_documents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Default documents.
        """
        return pulumi.get(self, "default_documents")

    @default_documents.setter
    def default_documents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "default_documents", value)

    @property
    @pulumi.getter(name="detailedErrorLoggingEnabled")
    def detailed_error_logging_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> if detailed error logging is enabled; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "detailed_error_logging_enabled")

    @detailed_error_logging_enabled.setter
    def detailed_error_logging_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "detailed_error_logging_enabled", value)

    @property
    @pulumi.getter(name="documentRoot")
    def document_root(self) -> Optional[pulumi.Input[str]]:
        """
        Document root.
        """
        return pulumi.get(self, "document_root")

    @document_root.setter
    def document_root(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "document_root", value)

    @property
    @pulumi.getter
    def experiments(self) -> Optional[pulumi.Input['ExperimentsArgs']]:
        """
        This is work around for polymorphic types.
        """
        return pulumi.get(self, "experiments")

    @experiments.setter
    def experiments(self, value: Optional[pulumi.Input['ExperimentsArgs']]):
        pulumi.set(self, "experiments", value)

    @property
    @pulumi.getter(name="ftpsState")
    def ftps_state(self) -> Optional[pulumi.Input[Union[str, 'FtpsState']]]:
        """
        State of FTP / FTPS service
        """
        return pulumi.get(self, "ftps_state")

    @ftps_state.setter
    def ftps_state(self, value: Optional[pulumi.Input[Union[str, 'FtpsState']]]):
        pulumi.set(self, "ftps_state", value)

    @property
    @pulumi.getter(name="functionAppScaleLimit")
    def function_app_scale_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of workers that a site can scale out to.
        This setting only applies to the Consumption and Elastic Premium Plans
        """
        return pulumi.get(self, "function_app_scale_limit")

    @function_app_scale_limit.setter
    def function_app_scale_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "function_app_scale_limit", value)

    @property
    @pulumi.getter(name="functionsRuntimeScaleMonitoringEnabled")
    def functions_runtime_scale_monitoring_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets a value indicating whether functions runtime scale monitoring is enabled. When enabled,
        the ScaleController will not monitor event sources directly, but will instead call to the
        runtime to get scale status.
        """
        return pulumi.get(self, "functions_runtime_scale_monitoring_enabled")

    @functions_runtime_scale_monitoring_enabled.setter
    def functions_runtime_scale_monitoring_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "functions_runtime_scale_monitoring_enabled", value)

    @property
    @pulumi.getter(name="handlerMappings")
    def handler_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HandlerMappingArgs']]]]:
        """
        Handler mappings.
        """
        return pulumi.get(self, "handler_mappings")

    @handler_mappings.setter
    def handler_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HandlerMappingArgs']]]]):
        pulumi.set(self, "handler_mappings", value)

    @property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> Optional[pulumi.Input[str]]:
        """
        Health check path
        """
        return pulumi.get(self, "health_check_path")

    @health_check_path.setter
    def health_check_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_path", value)

    @property
    @pulumi.getter(name="http20Enabled")
    def http20_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Http20Enabled: configures a web site to allow clients to connect over http2.0
        """
        return pulumi.get(self, "http20_enabled")

    @http20_enabled.setter
    def http20_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http20_enabled", value)

    @property
    @pulumi.getter(name="httpLoggingEnabled")
    def http_logging_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> if HTTP logging is enabled; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "http_logging_enabled")

    @http_logging_enabled.setter
    def http_logging_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http_logging_enabled", value)

    @property
    @pulumi.getter(name="ipSecurityRestrictions")
    def ip_security_restrictions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpSecurityRestrictionArgs']]]]:
        """
        IP security restrictions for main.
        """
        return pulumi.get(self, "ip_security_restrictions")

    @ip_security_restrictions.setter
    def ip_security_restrictions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpSecurityRestrictionArgs']]]]):
        pulumi.set(self, "ip_security_restrictions", value)

    @property
    @pulumi.getter(name="javaContainer")
    def java_container(self) -> Optional[pulumi.Input[str]]:
        """
        Java container.
        """
        return pulumi.get(self, "java_container")

    @java_container.setter
    def java_container(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "java_container", value)

    @property
    @pulumi.getter(name="javaContainerVersion")
    def java_container_version(self) -> Optional[pulumi.Input[str]]:
        """
        Java container version.
        """
        return pulumi.get(self, "java_container_version")

    @java_container_version.setter
    def java_container_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "java_container_version", value)

    @property
    @pulumi.getter(name="javaVersion")
    def java_version(self) -> Optional[pulumi.Input[str]]:
        """
        Java version.
        """
        return pulumi.get(self, "java_version")

    @java_version.setter
    def java_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "java_version", value)

    @property
    @pulumi.getter(name="keyVaultReferenceIdentity")
    def key_vault_reference_identity(self) -> Optional[pulumi.Input[str]]:
        """
        Identity to use for Key Vault Reference authentication.
        """
        return pulumi.get(self, "key_vault_reference_identity")

    @key_vault_reference_identity.setter
    def key_vault_reference_identity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_reference_identity", value)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input['SiteLimitsArgs']]:
        """
        Site limits.
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input['SiteLimitsArgs']]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter(name="linuxFxVersion")
    def linux_fx_version(self) -> Optional[pulumi.Input[str]]:
        """
        Linux App Framework and version
        """
        return pulumi.get(self, "linux_fx_version")

    @linux_fx_version.setter
    def linux_fx_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linux_fx_version", value)

    @property
    @pulumi.getter(name="loadBalancing")
    def load_balancing(self) -> Optional[pulumi.Input['SiteLoadBalancing']]:
        """
        Site load balancing.
        """
        return pulumi.get(self, "load_balancing")

    @load_balancing.setter
    def load_balancing(self, value: Optional[pulumi.Input['SiteLoadBalancing']]):
        pulumi.set(self, "load_balancing", value)

    @property
    @pulumi.getter(name="localMySqlEnabled")
    def local_my_sql_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> to enable local MySQL; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "local_my_sql_enabled")

    @local_my_sql_enabled.setter
    def local_my_sql_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "local_my_sql_enabled", value)

    @property
    @pulumi.getter(name="logsDirectorySizeLimit")
    def logs_directory_size_limit(self) -> Optional[pulumi.Input[int]]:
        """
        HTTP logs directory size limit.
        """
        return pulumi.get(self, "logs_directory_size_limit")

    @logs_directory_size_limit.setter
    def logs_directory_size_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "logs_directory_size_limit", value)

    @property
    @pulumi.getter(name="managedPipelineMode")
    def managed_pipeline_mode(self) -> Optional[pulumi.Input['ManagedPipelineMode']]:
        """
        Managed pipeline mode.
        """
        return pulumi.get(self, "managed_pipeline_mode")

    @managed_pipeline_mode.setter
    def managed_pipeline_mode(self, value: Optional[pulumi.Input['ManagedPipelineMode']]):
        pulumi.set(self, "managed_pipeline_mode", value)

    @property
    @pulumi.getter(name="managedServiceIdentityId")
    def managed_service_identity_id(self) -> Optional[pulumi.Input[int]]:
        """
        Managed Service Identity Id
        """
        return pulumi.get(self, "managed_service_identity_id")

    @managed_service_identity_id.setter
    def managed_service_identity_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "managed_service_identity_id", value)

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[pulumi.Input[Union[str, 'SupportedTlsVersions']]]:
        """
        MinTlsVersion: configures the minimum version of TLS required for SSL requests
        """
        return pulumi.get(self, "min_tls_version")

    @min_tls_version.setter
    def min_tls_version(self, value: Optional[pulumi.Input[Union[str, 'SupportedTlsVersions']]]):
        pulumi.set(self, "min_tls_version", value)

    @property
    @pulumi.getter(name="minimumElasticInstanceCount")
    def minimum_elastic_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of minimum instance count for a site
        This setting only applies to the Elastic Plans
        """
        return pulumi.get(self, "minimum_elastic_instance_count")

    @minimum_elastic_instance_count.setter
    def minimum_elastic_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minimum_elastic_instance_count", value)

    @property
    @pulumi.getter(name="netFrameworkVersion")
    def net_framework_version(self) -> Optional[pulumi.Input[str]]:
        """
        .NET Framework version.
        """
        return pulumi.get(self, "net_framework_version")

    @net_framework_version.setter
    def net_framework_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "net_framework_version", value)

    @property
    @pulumi.getter(name="nodeVersion")
    def node_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of Node.js.
        """
        return pulumi.get(self, "node_version")

    @node_version.setter
    def node_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_version", value)

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> Optional[pulumi.Input[int]]:
        """
        Number of workers.
        """
        return pulumi.get(self, "number_of_workers")

    @number_of_workers.setter
    def number_of_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_workers", value)

    @property
    @pulumi.getter(name="phpVersion")
    def php_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of PHP.
        """
        return pulumi.get(self, "php_version")

    @php_version.setter
    def php_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "php_version", value)

    @property
    @pulumi.getter(name="powerShellVersion")
    def power_shell_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of PowerShell.
        """
        return pulumi.get(self, "power_shell_version")

    @power_shell_version.setter
    def power_shell_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "power_shell_version", value)

    @property
    @pulumi.getter(name="preWarmedInstanceCount")
    def pre_warmed_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of preWarmed instances.
        This setting only applies to the Consumption and Elastic Plans
        """
        return pulumi.get(self, "pre_warmed_instance_count")

    @pre_warmed_instance_count.setter
    def pre_warmed_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pre_warmed_instance_count", value)

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[str]]:
        """
        Property to allow or block all public traffic.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_network_access", value)

    @property
    @pulumi.getter(name="publishingUsername")
    def publishing_username(self) -> Optional[pulumi.Input[str]]:
        """
        Publishing user name.
        """
        return pulumi.get(self, "publishing_username")

    @publishing_username.setter
    def publishing_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publishing_username", value)

    @property
    @pulumi.getter
    def push(self) -> Optional[pulumi.Input['PushSettingsArgs']]:
        """
        Push endpoint settings.
        """
        return pulumi.get(self, "push")

    @push.setter
    def push(self, value: Optional[pulumi.Input['PushSettingsArgs']]):
        pulumi.set(self, "push", value)

    @property
    @pulumi.getter(name="pythonVersion")
    def python_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of Python.
        """
        return pulumi.get(self, "python_version")

    @python_version.setter
    def python_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "python_version", value)

    @property
    @pulumi.getter(name="remoteDebuggingEnabled")
    def remote_debugging_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> if remote debugging is enabled; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "remote_debugging_enabled")

    @remote_debugging_enabled.setter
    def remote_debugging_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remote_debugging_enabled", value)

    @property
    @pulumi.getter(name="remoteDebuggingVersion")
    def remote_debugging_version(self) -> Optional[pulumi.Input[str]]:
        """
        Remote debugging version.
        """
        return pulumi.get(self, "remote_debugging_version")

    @remote_debugging_version.setter
    def remote_debugging_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_debugging_version", value)

    @property
    @pulumi.getter(name="requestTracingEnabled")
    def request_tracing_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> if request tracing is enabled; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "request_tracing_enabled")

    @request_tracing_enabled.setter
    def request_tracing_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "request_tracing_enabled", value)

    @property
    @pulumi.getter(name="requestTracingExpirationTime")
    def request_tracing_expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        Request tracing expiration time.
        """
        return pulumi.get(self, "request_tracing_expiration_time")

    @request_tracing_expiration_time.setter
    def request_tracing_expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_tracing_expiration_time", value)

    @property
    @pulumi.getter(name="scmIpSecurityRestrictions")
    def scm_ip_security_restrictions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpSecurityRestrictionArgs']]]]:
        """
        IP security restrictions for scm.
        """
        return pulumi.get(self, "scm_ip_security_restrictions")

    @scm_ip_security_restrictions.setter
    def scm_ip_security_restrictions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpSecurityRestrictionArgs']]]]):
        pulumi.set(self, "scm_ip_security_restrictions", value)

    @property
    @pulumi.getter(name="scmIpSecurityRestrictionsUseMain")
    def scm_ip_security_restrictions_use_main(self) -> Optional[pulumi.Input[bool]]:
        """
        IP security restrictions for scm to use main.
        """
        return pulumi.get(self, "scm_ip_security_restrictions_use_main")

    @scm_ip_security_restrictions_use_main.setter
    def scm_ip_security_restrictions_use_main(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "scm_ip_security_restrictions_use_main", value)

    @property
    @pulumi.getter(name="scmMinTlsVersion")
    def scm_min_tls_version(self) -> Optional[pulumi.Input[Union[str, 'SupportedTlsVersions']]]:
        """
        ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site
        """
        return pulumi.get(self, "scm_min_tls_version")

    @scm_min_tls_version.setter
    def scm_min_tls_version(self, value: Optional[pulumi.Input[Union[str, 'SupportedTlsVersions']]]):
        pulumi.set(self, "scm_min_tls_version", value)

    @property
    @pulumi.getter(name="scmType")
    def scm_type(self) -> Optional[pulumi.Input[Union[str, 'ScmType']]]:
        """
        SCM type.
        """
        return pulumi.get(self, "scm_type")

    @scm_type.setter
    def scm_type(self, value: Optional[pulumi.Input[Union[str, 'ScmType']]]):
        pulumi.set(self, "scm_type", value)

    @property
    @pulumi.getter(name="tracingOptions")
    def tracing_options(self) -> Optional[pulumi.Input[str]]:
        """
        Tracing options.
        """
        return pulumi.get(self, "tracing_options")

    @tracing_options.setter
    def tracing_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tracing_options", value)

    @property
    @pulumi.getter(name="use32BitWorkerProcess")
    def use32_bit_worker_process(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> to use 32-bit worker process; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "use32_bit_worker_process")

    @use32_bit_worker_process.setter
    def use32_bit_worker_process(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use32_bit_worker_process", value)

    @property
    @pulumi.getter(name="virtualApplications")
    def virtual_applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualApplicationArgs']]]]:
        """
        Virtual applications.
        """
        return pulumi.get(self, "virtual_applications")

    @virtual_applications.setter
    def virtual_applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualApplicationArgs']]]]):
        pulumi.set(self, "virtual_applications", value)

    @property
    @pulumi.getter(name="vnetName")
    def vnet_name(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual Network name.
        """
        return pulumi.get(self, "vnet_name")

    @vnet_name.setter
    def vnet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnet_name", value)

    @property
    @pulumi.getter(name="vnetPrivatePortsCount")
    def vnet_private_ports_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of private ports assigned to this app. These will be assigned dynamically on runtime.
        """
        return pulumi.get(self, "vnet_private_ports_count")

    @vnet_private_ports_count.setter
    def vnet_private_ports_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vnet_private_ports_count", value)

    @property
    @pulumi.getter(name="vnetRouteAllEnabled")
    def vnet_route_all_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
        """
        return pulumi.get(self, "vnet_route_all_enabled")

    @vnet_route_all_enabled.setter
    def vnet_route_all_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vnet_route_all_enabled", value)

    @property
    @pulumi.getter(name="webSocketsEnabled")
    def web_sockets_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> if WebSocket is enabled; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "web_sockets_enabled")

    @web_sockets_enabled.setter
    def web_sockets_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "web_sockets_enabled", value)

    @property
    @pulumi.getter(name="websiteTimeZone")
    def website_time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Sets the time zone a site uses for generating timestamps. Compatible with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence over this config. For Linux, expects tz database values https://www.iana.org/time-zones (for a quick reference see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the time zones listed under HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Time Zones
        """
        return pulumi.get(self, "website_time_zone")

    @website_time_zone.setter
    def website_time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "website_time_zone", value)

    @property
    @pulumi.getter(name="windowsFxVersion")
    def windows_fx_version(self) -> Optional[pulumi.Input[str]]:
        """
        Xenon App Framework and version
        """
        return pulumi.get(self, "windows_fx_version")

    @windows_fx_version.setter
    def windows_fx_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "windows_fx_version", value)

    @property
    @pulumi.getter(name="xManagedServiceIdentityId")
    def x_managed_service_identity_id(self) -> Optional[pulumi.Input[int]]:
        """
        Explicit Managed Service Identity Id
        """
        return pulumi.get(self, "x_managed_service_identity_id")

    @x_managed_service_identity_id.setter
    def x_managed_service_identity_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "x_managed_service_identity_id", value)


@pulumi.input_type
class SiteLimitsArgs:
    def __init__(__self__, *,
                 max_disk_size_in_mb: Optional[pulumi.Input[float]] = None,
                 max_memory_in_mb: Optional[pulumi.Input[float]] = None,
                 max_percentage_cpu: Optional[pulumi.Input[float]] = None):
        """
        Metric limits set on an app.
        :param pulumi.Input[float] max_disk_size_in_mb: Maximum allowed disk size usage in MB.
        :param pulumi.Input[float] max_memory_in_mb: Maximum allowed memory usage in MB.
        :param pulumi.Input[float] max_percentage_cpu: Maximum allowed CPU usage percentage.
        """
        if max_disk_size_in_mb is not None:
            pulumi.set(__self__, "max_disk_size_in_mb", max_disk_size_in_mb)
        if max_memory_in_mb is not None:
            pulumi.set(__self__, "max_memory_in_mb", max_memory_in_mb)
        if max_percentage_cpu is not None:
            pulumi.set(__self__, "max_percentage_cpu", max_percentage_cpu)

    @property
    @pulumi.getter(name="maxDiskSizeInMb")
    def max_disk_size_in_mb(self) -> Optional[pulumi.Input[float]]:
        """
        Maximum allowed disk size usage in MB.
        """
        return pulumi.get(self, "max_disk_size_in_mb")

    @max_disk_size_in_mb.setter
    def max_disk_size_in_mb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_disk_size_in_mb", value)

    @property
    @pulumi.getter(name="maxMemoryInMb")
    def max_memory_in_mb(self) -> Optional[pulumi.Input[float]]:
        """
        Maximum allowed memory usage in MB.
        """
        return pulumi.get(self, "max_memory_in_mb")

    @max_memory_in_mb.setter
    def max_memory_in_mb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_memory_in_mb", value)

    @property
    @pulumi.getter(name="maxPercentageCpu")
    def max_percentage_cpu(self) -> Optional[pulumi.Input[float]]:
        """
        Maximum allowed CPU usage percentage.
        """
        return pulumi.get(self, "max_percentage_cpu")

    @max_percentage_cpu.setter
    def max_percentage_cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_percentage_cpu", value)


@pulumi.input_type
class SkuCapacityArgs:
    def __init__(__self__, *,
                 default: Optional[pulumi.Input[int]] = None,
                 elastic_maximum: Optional[pulumi.Input[int]] = None,
                 maximum: Optional[pulumi.Input[int]] = None,
                 minimum: Optional[pulumi.Input[int]] = None,
                 scale_type: Optional[pulumi.Input[str]] = None):
        """
        Description of the App Service plan scale options.
        :param pulumi.Input[int] default: Default number of workers for this App Service plan SKU.
        :param pulumi.Input[int] elastic_maximum: Maximum number of Elastic workers for this App Service plan SKU.
        :param pulumi.Input[int] maximum: Maximum number of workers for this App Service plan SKU.
        :param pulumi.Input[int] minimum: Minimum number of workers for this App Service plan SKU.
        :param pulumi.Input[str] scale_type: Available scale configurations for an App Service plan.
        """
        if default is not None:
            pulumi.set(__self__, "default", default)
        if elastic_maximum is not None:
            pulumi.set(__self__, "elastic_maximum", elastic_maximum)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)
        if scale_type is not None:
            pulumi.set(__self__, "scale_type", scale_type)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[int]]:
        """
        Default number of workers for this App Service plan SKU.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter(name="elasticMaximum")
    def elastic_maximum(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of Elastic workers for this App Service plan SKU.
        """
        return pulumi.get(self, "elastic_maximum")

    @elastic_maximum.setter
    def elastic_maximum(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "elastic_maximum", value)

    @property
    @pulumi.getter
    def maximum(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of workers for this App Service plan SKU.
        """
        return pulumi.get(self, "maximum")

    @maximum.setter
    def maximum(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum", value)

    @property
    @pulumi.getter
    def minimum(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of workers for this App Service plan SKU.
        """
        return pulumi.get(self, "minimum")

    @minimum.setter
    def minimum(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minimum", value)

    @property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> Optional[pulumi.Input[str]]:
        """
        Available scale configurations for an App Service plan.
        """
        return pulumi.get(self, "scale_type")

    @scale_type.setter
    def scale_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_type", value)


@pulumi.input_type
class SkuDescriptionArgs:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input['CapabilityArgs']]]] = None,
                 capacity: Optional[pulumi.Input[int]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 sku_capacity: Optional[pulumi.Input['SkuCapacityArgs']] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        Description of a SKU for a scalable resource.
        :param pulumi.Input[Sequence[pulumi.Input['CapabilityArgs']]] capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?
        :param pulumi.Input[int] capacity: Current number of instances assigned to the resource.
        :param pulumi.Input[str] family: Family code of the resource SKU.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: Locations of the SKU.
        :param pulumi.Input[str] name: Name of the resource SKU.
        :param pulumi.Input[str] size: Size specifier of the resource SKU.
        :param pulumi.Input['SkuCapacityArgs'] sku_capacity: Min, max, and default scale values of the SKU.
        :param pulumi.Input[str] tier: Service tier of the resource SKU.
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if sku_capacity is not None:
            pulumi.set(__self__, "sku_capacity", sku_capacity)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CapabilityArgs']]]]:
        """
        Capabilities of the SKU, e.g., is traffic manager enabled?
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CapabilityArgs']]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Current number of instances assigned to the resource.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        Family code of the resource SKU.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Locations of the SKU.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        Size specifier of the resource SKU.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="skuCapacity")
    def sku_capacity(self) -> Optional[pulumi.Input['SkuCapacityArgs']]:
        """
        Min, max, and default scale values of the SKU.
        """
        return pulumi.get(self, "sku_capacity")

    @sku_capacity.setter
    def sku_capacity(self, value: Optional[pulumi.Input['SkuCapacityArgs']]):
        pulumi.set(self, "sku_capacity", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        Service tier of the resource SKU.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SlowRequestsBasedTriggerArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 time_interval: Optional[pulumi.Input[str]] = None,
                 time_taken: Optional[pulumi.Input[str]] = None):
        """
        Trigger based on request execution time.
        :param pulumi.Input[int] count: Request Count.
        :param pulumi.Input[str] path: Request Path.
        :param pulumi.Input[str] time_interval: Time interval.
        :param pulumi.Input[str] time_taken: Time taken.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if time_interval is not None:
            pulumi.set(__self__, "time_interval", time_interval)
        if time_taken is not None:
            pulumi.set(__self__, "time_taken", time_taken)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Request Count.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Request Path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="timeInterval")
    def time_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Time interval.
        """
        return pulumi.get(self, "time_interval")

    @time_interval.setter
    def time_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_interval", value)

    @property
    @pulumi.getter(name="timeTaken")
    def time_taken(self) -> Optional[pulumi.Input[str]]:
        """
        Time taken.
        """
        return pulumi.get(self, "time_taken")

    @time_taken.setter
    def time_taken(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_taken", value)


@pulumi.input_type
class StaticSiteBuildPropertiesArgs:
    def __init__(__self__, *,
                 api_build_command: Optional[pulumi.Input[str]] = None,
                 api_location: Optional[pulumi.Input[str]] = None,
                 app_artifact_location: Optional[pulumi.Input[str]] = None,
                 app_build_command: Optional[pulumi.Input[str]] = None,
                 app_location: Optional[pulumi.Input[str]] = None,
                 github_action_secret_name_override: Optional[pulumi.Input[str]] = None,
                 output_location: Optional[pulumi.Input[str]] = None,
                 skip_github_action_workflow_generation: Optional[pulumi.Input[bool]] = None):
        """
        Build properties for the static site.
        :param pulumi.Input[str] api_build_command: A custom command to run during deployment of the Azure Functions API application.
        :param pulumi.Input[str] api_location: The path to the api code within the repository.
        :param pulumi.Input[str] app_artifact_location: Deprecated: The path of the app artifacts after building (deprecated in favor of OutputLocation)
        :param pulumi.Input[str] app_build_command: A custom command to run during deployment of the static content application.
        :param pulumi.Input[str] app_location: The path to the app code within the repository.
        :param pulumi.Input[str] github_action_secret_name_override: Github Action secret name override.
        :param pulumi.Input[str] output_location: The output path of the app after building.
        :param pulumi.Input[bool] skip_github_action_workflow_generation: Skip Github Action workflow generation.
        """
        if api_build_command is not None:
            pulumi.set(__self__, "api_build_command", api_build_command)
        if api_location is not None:
            pulumi.set(__self__, "api_location", api_location)
        if app_artifact_location is not None:
            pulumi.set(__self__, "app_artifact_location", app_artifact_location)
        if app_build_command is not None:
            pulumi.set(__self__, "app_build_command", app_build_command)
        if app_location is not None:
            pulumi.set(__self__, "app_location", app_location)
        if github_action_secret_name_override is not None:
            pulumi.set(__self__, "github_action_secret_name_override", github_action_secret_name_override)
        if output_location is not None:
            pulumi.set(__self__, "output_location", output_location)
        if skip_github_action_workflow_generation is not None:
            pulumi.set(__self__, "skip_github_action_workflow_generation", skip_github_action_workflow_generation)

    @property
    @pulumi.getter(name="apiBuildCommand")
    def api_build_command(self) -> Optional[pulumi.Input[str]]:
        """
        A custom command to run during deployment of the Azure Functions API application.
        """
        return pulumi.get(self, "api_build_command")

    @api_build_command.setter
    def api_build_command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_build_command", value)

    @property
    @pulumi.getter(name="apiLocation")
    def api_location(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the api code within the repository.
        """
        return pulumi.get(self, "api_location")

    @api_location.setter
    def api_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_location", value)

    @property
    @pulumi.getter(name="appArtifactLocation")
    def app_artifact_location(self) -> Optional[pulumi.Input[str]]:
        """
        Deprecated: The path of the app artifacts after building (deprecated in favor of OutputLocation)
        """
        return pulumi.get(self, "app_artifact_location")

    @app_artifact_location.setter
    def app_artifact_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_artifact_location", value)

    @property
    @pulumi.getter(name="appBuildCommand")
    def app_build_command(self) -> Optional[pulumi.Input[str]]:
        """
        A custom command to run during deployment of the static content application.
        """
        return pulumi.get(self, "app_build_command")

    @app_build_command.setter
    def app_build_command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_build_command", value)

    @property
    @pulumi.getter(name="appLocation")
    def app_location(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the app code within the repository.
        """
        return pulumi.get(self, "app_location")

    @app_location.setter
    def app_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_location", value)

    @property
    @pulumi.getter(name="githubActionSecretNameOverride")
    def github_action_secret_name_override(self) -> Optional[pulumi.Input[str]]:
        """
        Github Action secret name override.
        """
        return pulumi.get(self, "github_action_secret_name_override")

    @github_action_secret_name_override.setter
    def github_action_secret_name_override(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "github_action_secret_name_override", value)

    @property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> Optional[pulumi.Input[str]]:
        """
        The output path of the app after building.
        """
        return pulumi.get(self, "output_location")

    @output_location.setter
    def output_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_location", value)

    @property
    @pulumi.getter(name="skipGithubActionWorkflowGeneration")
    def skip_github_action_workflow_generation(self) -> Optional[pulumi.Input[bool]]:
        """
        Skip Github Action workflow generation.
        """
        return pulumi.get(self, "skip_github_action_workflow_generation")

    @skip_github_action_workflow_generation.setter
    def skip_github_action_workflow_generation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_github_action_workflow_generation", value)


@pulumi.input_type
class StaticSiteTemplateOptionsArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 is_private: Optional[pulumi.Input[bool]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 repository_name: Optional[pulumi.Input[str]] = None,
                 template_repository_url: Optional[pulumi.Input[str]] = None):
        """
        Template Options for the static site.
        :param pulumi.Input[str] description: Description of the newly generated repository.
        :param pulumi.Input[bool] is_private: Whether or not the newly generated repository is a private repository. Defaults to false (i.e. public).
        :param pulumi.Input[str] owner: Owner of the newly generated repository.
        :param pulumi.Input[str] repository_name: Name of the newly generated repository.
        :param pulumi.Input[str] template_repository_url: URL of the template repository. The newly generated repository will be based on this one.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_private is not None:
            pulumi.set(__self__, "is_private", is_private)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)
        if template_repository_url is not None:
            pulumi.set(__self__, "template_repository_url", template_repository_url)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the newly generated repository.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the newly generated repository is a private repository. Defaults to false (i.e. public).
        """
        return pulumi.get(self, "is_private")

    @is_private.setter
    def is_private(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_private", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        Owner of the newly generated repository.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the newly generated repository.
        """
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_name", value)

    @property
    @pulumi.getter(name="templateRepositoryUrl")
    def template_repository_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the template repository. The newly generated repository will be based on this one.
        """
        return pulumi.get(self, "template_repository_url")

    @template_repository_url.setter
    def template_repository_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_repository_url", value)


@pulumi.input_type
class StatusCodesBasedTriggerArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[int]] = None,
                 sub_status: Optional[pulumi.Input[int]] = None,
                 time_interval: Optional[pulumi.Input[str]] = None,
                 win32_status: Optional[pulumi.Input[int]] = None):
        """
        Trigger based on status code.
        :param pulumi.Input[int] count: Request Count.
        :param pulumi.Input[str] path: Request Path
        :param pulumi.Input[int] status: HTTP status code.
        :param pulumi.Input[int] sub_status: Request Sub Status.
        :param pulumi.Input[str] time_interval: Time interval.
        :param pulumi.Input[int] win32_status: Win32 error code.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sub_status is not None:
            pulumi.set(__self__, "sub_status", sub_status)
        if time_interval is not None:
            pulumi.set(__self__, "time_interval", time_interval)
        if win32_status is not None:
            pulumi.set(__self__, "win32_status", win32_status)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Request Count.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Request Path
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[int]]:
        """
        HTTP status code.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subStatus")
    def sub_status(self) -> Optional[pulumi.Input[int]]:
        """
        Request Sub Status.
        """
        return pulumi.get(self, "sub_status")

    @sub_status.setter
    def sub_status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sub_status", value)

    @property
    @pulumi.getter(name="timeInterval")
    def time_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Time interval.
        """
        return pulumi.get(self, "time_interval")

    @time_interval.setter
    def time_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_interval", value)

    @property
    @pulumi.getter(name="win32Status")
    def win32_status(self) -> Optional[pulumi.Input[int]]:
        """
        Win32 error code.
        """
        return pulumi.get(self, "win32_status")

    @win32_status.setter
    def win32_status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "win32_status", value)


@pulumi.input_type
class StatusCodesRangeBasedTriggerArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 status_codes: Optional[pulumi.Input[str]] = None,
                 time_interval: Optional[pulumi.Input[str]] = None):
        """
        Trigger based on range of status codes.
        :param pulumi.Input[int] count: Request Count.
        :param pulumi.Input[str] status_codes: HTTP status code.
        :param pulumi.Input[str] time_interval: Time interval.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if status_codes is not None:
            pulumi.set(__self__, "status_codes", status_codes)
        if time_interval is not None:
            pulumi.set(__self__, "time_interval", time_interval)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Request Count.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP status code.
        """
        return pulumi.get(self, "status_codes")

    @status_codes.setter
    def status_codes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status_codes", value)

    @property
    @pulumi.getter(name="timeInterval")
    def time_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Time interval.
        """
        return pulumi.get(self, "time_interval")

    @time_interval.setter
    def time_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_interval", value)


@pulumi.input_type
class TokenStoreArgs:
    def __init__(__self__, *,
                 azure_blob_storage: Optional[pulumi.Input['BlobStorageTokenStoreArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 file_system: Optional[pulumi.Input['FileSystemTokenStoreArgs']] = None,
                 token_refresh_extension_hours: Optional[pulumi.Input[float]] = None):
        """
        The configuration settings of the token store.
        :param pulumi.Input['BlobStorageTokenStoreArgs'] azure_blob_storage: The configuration settings of the storage of the tokens if blob storage is used.
        :param pulumi.Input[bool] enabled: <code>true</code> to durably store platform-specific security tokens that are obtained during login flows; otherwise, <code>false</code>.
                The default is <code>false</code>.
        :param pulumi.Input['FileSystemTokenStoreArgs'] file_system: The configuration settings of the storage of the tokens if a file system is used.
        :param pulumi.Input[float] token_refresh_extension_hours: The number of hours after session token expiration that a session token can be used to
               call the token refresh API. The default is 72 hours.
        """
        if azure_blob_storage is not None:
            pulumi.set(__self__, "azure_blob_storage", azure_blob_storage)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if file_system is not None:
            pulumi.set(__self__, "file_system", file_system)
        if token_refresh_extension_hours is not None:
            pulumi.set(__self__, "token_refresh_extension_hours", token_refresh_extension_hours)

    @property
    @pulumi.getter(name="azureBlobStorage")
    def azure_blob_storage(self) -> Optional[pulumi.Input['BlobStorageTokenStoreArgs']]:
        """
        The configuration settings of the storage of the tokens if blob storage is used.
        """
        return pulumi.get(self, "azure_blob_storage")

    @azure_blob_storage.setter
    def azure_blob_storage(self, value: Optional[pulumi.Input['BlobStorageTokenStoreArgs']]):
        pulumi.set(self, "azure_blob_storage", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> to durably store platform-specific security tokens that are obtained during login flows; otherwise, <code>false</code>.
         The default is <code>false</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="fileSystem")
    def file_system(self) -> Optional[pulumi.Input['FileSystemTokenStoreArgs']]:
        """
        The configuration settings of the storage of the tokens if a file system is used.
        """
        return pulumi.get(self, "file_system")

    @file_system.setter
    def file_system(self, value: Optional[pulumi.Input['FileSystemTokenStoreArgs']]):
        pulumi.set(self, "file_system", value)

    @property
    @pulumi.getter(name="tokenRefreshExtensionHours")
    def token_refresh_extension_hours(self) -> Optional[pulumi.Input[float]]:
        """
        The number of hours after session token expiration that a session token can be used to
        call the token refresh API. The default is 72 hours.
        """
        return pulumi.get(self, "token_refresh_extension_hours")

    @token_refresh_extension_hours.setter
    def token_refresh_extension_hours(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "token_refresh_extension_hours", value)


@pulumi.input_type
class TwitterRegistrationArgs:
    def __init__(__self__, *,
                 consumer_key: Optional[pulumi.Input[str]] = None,
                 consumer_secret_setting_name: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the app registration for the Twitter provider.
        :param pulumi.Input[str] consumer_key: The OAuth 1.0a consumer key of the Twitter application used for sign-in.
               This setting is required for enabling Twitter Sign-In.
               Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
        :param pulumi.Input[str] consumer_secret_setting_name: The app setting name that contains the OAuth 1.0a consumer secret of the Twitter
               application used for sign-in.
        """
        if consumer_key is not None:
            pulumi.set(__self__, "consumer_key", consumer_key)
        if consumer_secret_setting_name is not None:
            pulumi.set(__self__, "consumer_secret_setting_name", consumer_secret_setting_name)

    @property
    @pulumi.getter(name="consumerKey")
    def consumer_key(self) -> Optional[pulumi.Input[str]]:
        """
        The OAuth 1.0a consumer key of the Twitter application used for sign-in.
        This setting is required for enabling Twitter Sign-In.
        Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
        """
        return pulumi.get(self, "consumer_key")

    @consumer_key.setter
    def consumer_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_key", value)

    @property
    @pulumi.getter(name="consumerSecretSettingName")
    def consumer_secret_setting_name(self) -> Optional[pulumi.Input[str]]:
        """
        The app setting name that contains the OAuth 1.0a consumer secret of the Twitter
        application used for sign-in.
        """
        return pulumi.get(self, "consumer_secret_setting_name")

    @consumer_secret_setting_name.setter
    def consumer_secret_setting_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_secret_setting_name", value)


@pulumi.input_type
class TwitterArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 registration: Optional[pulumi.Input['TwitterRegistrationArgs']] = None):
        """
        The configuration settings of the Twitter provider.
        :param pulumi.Input[bool] enabled: <code>false</code> if the Twitter provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param pulumi.Input['TwitterRegistrationArgs'] registration: The configuration settings of the app registration for the Twitter provider.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the Twitter provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def registration(self) -> Optional[pulumi.Input['TwitterRegistrationArgs']]:
        """
        The configuration settings of the app registration for the Twitter provider.
        """
        return pulumi.get(self, "registration")

    @registration.setter
    def registration(self, value: Optional[pulumi.Input['TwitterRegistrationArgs']]):
        pulumi.set(self, "registration", value)


@pulumi.input_type
class VirtualApplicationArgs:
    def __init__(__self__, *,
                 physical_path: Optional[pulumi.Input[str]] = None,
                 preload_enabled: Optional[pulumi.Input[bool]] = None,
                 virtual_directories: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualDirectoryArgs']]]] = None,
                 virtual_path: Optional[pulumi.Input[str]] = None):
        """
        Virtual application in an app.
        :param pulumi.Input[str] physical_path: Physical path.
        :param pulumi.Input[bool] preload_enabled: <code>true</code> if preloading is enabled; otherwise, <code>false</code>.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualDirectoryArgs']]] virtual_directories: Virtual directories for virtual application.
        :param pulumi.Input[str] virtual_path: Virtual path.
        """
        if physical_path is not None:
            pulumi.set(__self__, "physical_path", physical_path)
        if preload_enabled is not None:
            pulumi.set(__self__, "preload_enabled", preload_enabled)
        if virtual_directories is not None:
            pulumi.set(__self__, "virtual_directories", virtual_directories)
        if virtual_path is not None:
            pulumi.set(__self__, "virtual_path", virtual_path)

    @property
    @pulumi.getter(name="physicalPath")
    def physical_path(self) -> Optional[pulumi.Input[str]]:
        """
        Physical path.
        """
        return pulumi.get(self, "physical_path")

    @physical_path.setter
    def physical_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "physical_path", value)

    @property
    @pulumi.getter(name="preloadEnabled")
    def preload_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> if preloading is enabled; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "preload_enabled")

    @preload_enabled.setter
    def preload_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preload_enabled", value)

    @property
    @pulumi.getter(name="virtualDirectories")
    def virtual_directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualDirectoryArgs']]]]:
        """
        Virtual directories for virtual application.
        """
        return pulumi.get(self, "virtual_directories")

    @virtual_directories.setter
    def virtual_directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualDirectoryArgs']]]]):
        pulumi.set(self, "virtual_directories", value)

    @property
    @pulumi.getter(name="virtualPath")
    def virtual_path(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual path.
        """
        return pulumi.get(self, "virtual_path")

    @virtual_path.setter
    def virtual_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_path", value)


@pulumi.input_type
class VirtualDirectoryArgs:
    def __init__(__self__, *,
                 physical_path: Optional[pulumi.Input[str]] = None,
                 virtual_path: Optional[pulumi.Input[str]] = None):
        """
        Directory for virtual application.
        :param pulumi.Input[str] physical_path: Physical path.
        :param pulumi.Input[str] virtual_path: Path to virtual application.
        """
        if physical_path is not None:
            pulumi.set(__self__, "physical_path", physical_path)
        if virtual_path is not None:
            pulumi.set(__self__, "virtual_path", virtual_path)

    @property
    @pulumi.getter(name="physicalPath")
    def physical_path(self) -> Optional[pulumi.Input[str]]:
        """
        Physical path.
        """
        return pulumi.get(self, "physical_path")

    @physical_path.setter
    def physical_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "physical_path", value)

    @property
    @pulumi.getter(name="virtualPath")
    def virtual_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to virtual application.
        """
        return pulumi.get(self, "virtual_path")

    @virtual_path.setter
    def virtual_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_path", value)


@pulumi.input_type
class VirtualNetworkProfileArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 subnet: Optional[pulumi.Input[str]] = None):
        """
        Specification for using a Virtual Network.
        :param pulumi.Input[str] id: Resource id of the Virtual Network.
        :param pulumi.Input[str] subnet: Subnet within the Virtual Network.
        """
        pulumi.set(__self__, "id", id)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Resource id of the Virtual Network.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Subnet within the Virtual Network.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)


