# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ResourceSkuResponse',
    'SignalRCorsSettingsResponse',
    'SignalRFeatureResponse',
]

@pulumi.output_type
class ResourceSkuResponse(dict):
    """
    The billing information of the SignalR resource.
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        The billing information of the SignalR resource.
        :param str name: The name of the SKU. Required.
               
               Allowed values: Standard_S1, Free_F1
        :param int capacity: Optional, integer. The unit count of SignalR resource. 1 by default.
               
               If present, following values are allowed:
                   Free: 1
                   Standard: 1,2,5,10,20,50,100
        :param str family: Optional string. For future use.
        :param str size: Optional string. For future use.
        :param str tier: Optional tier of this particular SKU. 'Standard' or 'Free'. 
               
               `Basic` is deprecated, use `Standard` instead.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU. Required.
        
        Allowed values: Standard_S1, Free_F1
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Optional, integer. The unit count of SignalR resource. 1 by default.
        
        If present, following values are allowed:
            Free: 1
            Standard: 1,2,5,10,20,50,100
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        Optional string. For future use.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        Optional string. For future use.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Optional tier of this particular SKU. 'Standard' or 'Free'. 
        
        `Basic` is deprecated, use `Standard` instead.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SignalRCorsSettingsResponse(dict):
    """
    Cross-Origin Resource Sharing (CORS) settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedOrigins":
            suggest = "allowed_origins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SignalRCorsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SignalRCorsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SignalRCorsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_origins: Optional[Sequence[str]] = None):
        """
        Cross-Origin Resource Sharing (CORS) settings.
        :param Sequence[str] allowed_origins: Gets or sets the list of origins that should be allowed to make cross-origin calls (for example: http://example.com:12345). Use "*" to allow all. If omitted, allow all by default.
        """
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the list of origins that should be allowed to make cross-origin calls (for example: http://example.com:12345). Use "*" to allow all. If omitted, allow all by default.
        """
        return pulumi.get(self, "allowed_origins")


@pulumi.output_type
class SignalRFeatureResponse(dict):
    """
    Feature of a SignalR resource, which controls the SignalR runtime behavior.
    """
    def __init__(__self__, *,
                 flag: str,
                 value: str,
                 properties: Optional[Mapping[str, str]] = None):
        """
        Feature of a SignalR resource, which controls the SignalR runtime behavior.
        :param str flag: FeatureFlags is the supported features of Azure SignalR service.
               - ServiceMode: Flag for backend server for SignalR service. Values allowed: "Default": have your own backend server; "Serverless": your application doesn't have a backend server; "Classic": for backward compatibility. Support both Default and Serverless mode but not recommended; "PredefinedOnly": for future use.
               - EnableConnectivityLogs: "true"/"false", to enable/disable the connectivity log category respectively.
        :param str value: Value of the feature flag. See Azure SignalR service document https://docs.microsoft.com/azure/azure-signalr/ for allowed values.
        :param Mapping[str, str] properties: Optional properties related to this feature.
        """
        pulumi.set(__self__, "flag", flag)
        pulumi.set(__self__, "value", value)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def flag(self) -> str:
        """
        FeatureFlags is the supported features of Azure SignalR service.
        - ServiceMode: Flag for backend server for SignalR service. Values allowed: "Default": have your own backend server; "Serverless": your application doesn't have a backend server; "Classic": for backward compatibility. Support both Default and Serverless mode but not recommended; "PredefinedOnly": for future use.
        - EnableConnectivityLogs: "true"/"false", to enable/disable the connectivity log category respectively.
        """
        return pulumi.get(self, "flag")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the feature flag. See Azure SignalR service document https://docs.microsoft.com/azure/azure-signalr/ for allowed values.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Optional properties related to this feature.
        """
        return pulumi.get(self, "properties")


