# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AuthorizationArgs',
    'BootstrapConfigurationArgs',
    'CodeRepositoryArgs',
    'PipelineTemplateArgs',
]

@pulumi.input_type
class AuthorizationArgs:
    def __init__(__self__, *,
                 authorization_type: pulumi.Input[Union[str, 'AuthorizationType']],
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Authorization info used to access a resource (like code repository).
        :param pulumi.Input[Union[str, 'AuthorizationType']] authorization_type: Type of authorization.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Authorization parameters corresponding to the authorization type.
        """
        pulumi.set(__self__, "authorization_type", authorization_type)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> pulumi.Input[Union[str, 'AuthorizationType']]:
        """
        Type of authorization.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: pulumi.Input[Union[str, 'AuthorizationType']]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Authorization parameters corresponding to the authorization type.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class BootstrapConfigurationArgs:
    def __init__(__self__, *,
                 template: pulumi.Input['PipelineTemplateArgs'],
                 source_repository: Optional[pulumi.Input['CodeRepositoryArgs']] = None):
        """
        Configuration used to bootstrap a Pipeline.
        :param pulumi.Input['PipelineTemplateArgs'] template: Template used to bootstrap the pipeline.
        :param pulumi.Input['CodeRepositoryArgs'] source_repository: Repository containing the source code for the pipeline. Currently only 'azurePipeline' pipeline type supports this.
        """
        pulumi.set(__self__, "template", template)
        if source_repository is not None:
            pulumi.set(__self__, "source_repository", source_repository)

    @property
    @pulumi.getter
    def template(self) -> pulumi.Input['PipelineTemplateArgs']:
        """
        Template used to bootstrap the pipeline.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: pulumi.Input['PipelineTemplateArgs']):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="sourceRepository")
    def source_repository(self) -> Optional[pulumi.Input['CodeRepositoryArgs']]:
        """
        Repository containing the source code for the pipeline. Currently only 'azurePipeline' pipeline type supports this.
        """
        return pulumi.get(self, "source_repository")

    @source_repository.setter
    def source_repository(self, value: Optional[pulumi.Input['CodeRepositoryArgs']]):
        pulumi.set(self, "source_repository", value)


@pulumi.input_type
class CodeRepositoryArgs:
    def __init__(__self__, *,
                 default_branch: pulumi.Input[str],
                 id: pulumi.Input[str],
                 repository_type: pulumi.Input[Union[str, 'CodeRepositoryType']],
                 authorization: Optional[pulumi.Input['AuthorizationArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Repository containing the source code for a pipeline.
        :param pulumi.Input[str] default_branch: Default branch used to configure Continuous Integration (CI) in the pipeline.
        :param pulumi.Input[str] id: Unique immutable identifier of the code repository.
        :param pulumi.Input[Union[str, 'CodeRepositoryType']] repository_type: Type of code repository.
        :param pulumi.Input['AuthorizationArgs'] authorization: Authorization info to access the code repository.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Repository-specific properties.
        """
        pulumi.set(__self__, "default_branch", default_branch)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "repository_type", repository_type)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> pulumi.Input[str]:
        """
        Default branch used to configure Continuous Integration (CI) in the pipeline.
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_branch", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Unique immutable identifier of the code repository.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="repositoryType")
    def repository_type(self) -> pulumi.Input[Union[str, 'CodeRepositoryType']]:
        """
        Type of code repository.
        """
        return pulumi.get(self, "repository_type")

    @repository_type.setter
    def repository_type(self, value: pulumi.Input[Union[str, 'CodeRepositoryType']]):
        pulumi.set(self, "repository_type", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input['AuthorizationArgs']]:
        """
        Authorization info to access the code repository.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input['AuthorizationArgs']]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Repository-specific properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class PipelineTemplateArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Template used to bootstrap the pipeline.
        :param pulumi.Input[str] id: Unique identifier of the pipeline template.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Dictionary of input parameters used in the pipeline template.
        """
        pulumi.set(__self__, "id", id)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Unique identifier of the pipeline template.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Dictionary of input parameters used in the pipeline template.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)


