# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ListAgentPoolQueueStatusResult',
    'AwaitableListAgentPoolQueueStatusResult',
    'list_agent_pool_queue_status',
    'list_agent_pool_queue_status_output',
]

@pulumi.output_type
class ListAgentPoolQueueStatusResult:
    """
    The QueueStatus of Agent Pool
    """
    def __init__(__self__, count=None):
        if count and not isinstance(count, int):
            raise TypeError("Expected argument 'count' to be a int")
        pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        The number of pending runs in the queue
        """
        return pulumi.get(self, "count")


class AwaitableListAgentPoolQueueStatusResult(ListAgentPoolQueueStatusResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ListAgentPoolQueueStatusResult(
            count=self.count)


def list_agent_pool_queue_status(agent_pool_name: Optional[str] = None,
                                 registry_name: Optional[str] = None,
                                 resource_group_name: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableListAgentPoolQueueStatusResult:
    """
    The QueueStatus of Agent Pool
    API Version: 2019-06-01-preview.


    :param str agent_pool_name: The name of the agent pool.
    :param str registry_name: The name of the container registry.
    :param str resource_group_name: The name of the resource group to which the container registry belongs.
    """
    __args__ = dict()
    __args__['agentPoolName'] = agent_pool_name
    __args__['registryName'] = registry_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:containerregistry:listAgentPoolQueueStatus', __args__, opts=opts, typ=ListAgentPoolQueueStatusResult).value

    return AwaitableListAgentPoolQueueStatusResult(
        count=__ret__.count)


@_utilities.lift_output_func(list_agent_pool_queue_status)
def list_agent_pool_queue_status_output(agent_pool_name: Optional[pulumi.Input[str]] = None,
                                        registry_name: Optional[pulumi.Input[str]] = None,
                                        resource_group_name: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ListAgentPoolQueueStatusResult]:
    """
    The QueueStatus of Agent Pool
    API Version: 2019-06-01-preview.


    :param str agent_pool_name: The name of the agent pool.
    :param str registry_name: The name of the container registry.
    :param str resource_group_name: The name of the resource group to which the container registry belongs.
    """
    ...
