# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'A2AContainerMappingInputArgs',
    'A2AEnableProtectionInputArgs',
    'A2APolicyCreationInputArgs',
    'A2AVmDiskInputDetailsArgs',
    'A2AVmManagedDiskInputDetailsArgs',
    'AddRecoveryServicesProviderInputPropertiesArgs',
    'AddVCenterRequestPropertiesArgs',
    'AzureFabricCreationInputArgs',
    'AzureToAzureCreateNetworkMappingInputArgs',
    'CreateNetworkMappingInputPropertiesArgs',
    'CreatePolicyInputPropertiesArgs',
    'CreateProtectionContainerMappingInputPropertiesArgs',
    'CreateRecoveryPlanInputPropertiesArgs',
    'DiskEncryptionInfoArgs',
    'DiskEncryptionKeyInfoArgs',
    'EnableMigrationInputPropertiesArgs',
    'EnableProtectionInputPropertiesArgs',
    'FabricCreationInputPropertiesArgs',
    'HyperVReplicaAzureEnableProtectionInputArgs',
    'HyperVReplicaAzurePolicyInputArgs',
    'HyperVReplicaBluePolicyInputArgs',
    'HyperVReplicaPolicyInputArgs',
    'IdentityProviderInputArgs',
    'InMageAzureV2EnableProtectionInputArgs',
    'InMageAzureV2PolicyInputArgs',
    'InMageDiskExclusionInputArgs',
    'InMageDiskSignatureExclusionOptionsArgs',
    'InMageEnableProtectionInputArgs',
    'InMagePolicyInputArgs',
    'InMageVolumeExclusionOptionsArgs',
    'KeyEncryptionKeyInfoArgs',
    'RecoveryPlanActionArgs',
    'RecoveryPlanGroupArgs',
    'RecoveryPlanProtectedItemArgs',
    'SanEnableProtectionInputArgs',
    'StorageMappingInputPropertiesArgs',
    'VMwareCbtContainerMappingInputArgs',
    'VMwareCbtDiskInputArgs',
    'VMwareCbtEnableMigrationInputArgs',
    'VMwareCbtPolicyCreationInputArgs',
    'VMwareV2FabricCreationInputArgs',
    'VmmToAzureCreateNetworkMappingInputArgs',
    'VmmToVmmCreateNetworkMappingInputArgs',
]

@pulumi.input_type
class A2AContainerMappingInputArgs:
    def __init__(__self__, *,
                 agent_auto_update_status: Optional[pulumi.Input[Union[str, 'AgentAutoUpdateStatus']]] = None,
                 automation_account_arm_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None):
        """
        A2A container mapping input.
        :param pulumi.Input[Union[str, 'AgentAutoUpdateStatus']] agent_auto_update_status: A value indicating whether the auto update is enabled.
        :param pulumi.Input[str] automation_account_arm_id: The automation account arm id.
        :param pulumi.Input[str] instance_type: The class type.
               Expected value is 'A2A'.
        """
        if agent_auto_update_status is not None:
            pulumi.set(__self__, "agent_auto_update_status", agent_auto_update_status)
        if automation_account_arm_id is not None:
            pulumi.set(__self__, "automation_account_arm_id", automation_account_arm_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'A2A')

    @property
    @pulumi.getter(name="agentAutoUpdateStatus")
    def agent_auto_update_status(self) -> Optional[pulumi.Input[Union[str, 'AgentAutoUpdateStatus']]]:
        """
        A value indicating whether the auto update is enabled.
        """
        return pulumi.get(self, "agent_auto_update_status")

    @agent_auto_update_status.setter
    def agent_auto_update_status(self, value: Optional[pulumi.Input[Union[str, 'AgentAutoUpdateStatus']]]):
        pulumi.set(self, "agent_auto_update_status", value)

    @property
    @pulumi.getter(name="automationAccountArmId")
    def automation_account_arm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The automation account arm id.
        """
        return pulumi.get(self, "automation_account_arm_id")

    @automation_account_arm_id.setter
    def automation_account_arm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "automation_account_arm_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The class type.
        Expected value is 'A2A'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)


@pulumi.input_type
class A2AEnableProtectionInputArgs:
    def __init__(__self__, *,
                 disk_encryption_info: Optional[pulumi.Input['DiskEncryptionInfoArgs']] = None,
                 fabric_object_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 multi_vm_group_name: Optional[pulumi.Input[str]] = None,
                 recovery_availability_set_id: Optional[pulumi.Input[str]] = None,
                 recovery_boot_diag_storage_account_id: Optional[pulumi.Input[str]] = None,
                 recovery_cloud_service_id: Optional[pulumi.Input[str]] = None,
                 recovery_container_id: Optional[pulumi.Input[str]] = None,
                 recovery_resource_group_id: Optional[pulumi.Input[str]] = None,
                 vm_disks: Optional[pulumi.Input[Sequence[pulumi.Input['A2AVmDiskInputDetailsArgs']]]] = None,
                 vm_managed_disks: Optional[pulumi.Input[Sequence[pulumi.Input['A2AVmManagedDiskInputDetailsArgs']]]] = None):
        """
        A2A enable protection input.
        :param pulumi.Input['DiskEncryptionInfoArgs'] disk_encryption_info: The recovery disk encryption information.
        :param pulumi.Input[str] fabric_object_id: The fabric specific object Id of the virtual machine.
        :param pulumi.Input[str] instance_type: The class type.
               Expected value is 'A2A'.
        :param pulumi.Input[str] multi_vm_group_name: The multi vm group name.
        :param pulumi.Input[str] recovery_availability_set_id: The recovery availability set Id.
        :param pulumi.Input[str] recovery_boot_diag_storage_account_id: The boot diagnostic storage account.
        :param pulumi.Input[str] recovery_cloud_service_id: The recovery cloud service Id. Valid for V1 scenarios.
        :param pulumi.Input[str] recovery_container_id: The recovery container Id.
        :param pulumi.Input[str] recovery_resource_group_id: The recovery resource group Id. Valid for V2 scenarios.
        :param pulumi.Input[Sequence[pulumi.Input['A2AVmDiskInputDetailsArgs']]] vm_disks: The list of vm disk details.
        :param pulumi.Input[Sequence[pulumi.Input['A2AVmManagedDiskInputDetailsArgs']]] vm_managed_disks: The list of vm managed disk details.
        """
        if disk_encryption_info is not None:
            pulumi.set(__self__, "disk_encryption_info", disk_encryption_info)
        if fabric_object_id is not None:
            pulumi.set(__self__, "fabric_object_id", fabric_object_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'A2A')
        if multi_vm_group_name is not None:
            pulumi.set(__self__, "multi_vm_group_name", multi_vm_group_name)
        if recovery_availability_set_id is not None:
            pulumi.set(__self__, "recovery_availability_set_id", recovery_availability_set_id)
        if recovery_boot_diag_storage_account_id is not None:
            pulumi.set(__self__, "recovery_boot_diag_storage_account_id", recovery_boot_diag_storage_account_id)
        if recovery_cloud_service_id is not None:
            pulumi.set(__self__, "recovery_cloud_service_id", recovery_cloud_service_id)
        if recovery_container_id is not None:
            pulumi.set(__self__, "recovery_container_id", recovery_container_id)
        if recovery_resource_group_id is not None:
            pulumi.set(__self__, "recovery_resource_group_id", recovery_resource_group_id)
        if vm_disks is not None:
            pulumi.set(__self__, "vm_disks", vm_disks)
        if vm_managed_disks is not None:
            pulumi.set(__self__, "vm_managed_disks", vm_managed_disks)

    @property
    @pulumi.getter(name="diskEncryptionInfo")
    def disk_encryption_info(self) -> Optional[pulumi.Input['DiskEncryptionInfoArgs']]:
        """
        The recovery disk encryption information.
        """
        return pulumi.get(self, "disk_encryption_info")

    @disk_encryption_info.setter
    def disk_encryption_info(self, value: Optional[pulumi.Input['DiskEncryptionInfoArgs']]):
        pulumi.set(self, "disk_encryption_info", value)

    @property
    @pulumi.getter(name="fabricObjectId")
    def fabric_object_id(self) -> Optional[pulumi.Input[str]]:
        """
        The fabric specific object Id of the virtual machine.
        """
        return pulumi.get(self, "fabric_object_id")

    @fabric_object_id.setter
    def fabric_object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fabric_object_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The class type.
        Expected value is 'A2A'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="multiVmGroupName")
    def multi_vm_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The multi vm group name.
        """
        return pulumi.get(self, "multi_vm_group_name")

    @multi_vm_group_name.setter
    def multi_vm_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_vm_group_name", value)

    @property
    @pulumi.getter(name="recoveryAvailabilitySetId")
    def recovery_availability_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The recovery availability set Id.
        """
        return pulumi.get(self, "recovery_availability_set_id")

    @recovery_availability_set_id.setter
    def recovery_availability_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recovery_availability_set_id", value)

    @property
    @pulumi.getter(name="recoveryBootDiagStorageAccountId")
    def recovery_boot_diag_storage_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The boot diagnostic storage account.
        """
        return pulumi.get(self, "recovery_boot_diag_storage_account_id")

    @recovery_boot_diag_storage_account_id.setter
    def recovery_boot_diag_storage_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recovery_boot_diag_storage_account_id", value)

    @property
    @pulumi.getter(name="recoveryCloudServiceId")
    def recovery_cloud_service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The recovery cloud service Id. Valid for V1 scenarios.
        """
        return pulumi.get(self, "recovery_cloud_service_id")

    @recovery_cloud_service_id.setter
    def recovery_cloud_service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recovery_cloud_service_id", value)

    @property
    @pulumi.getter(name="recoveryContainerId")
    def recovery_container_id(self) -> Optional[pulumi.Input[str]]:
        """
        The recovery container Id.
        """
        return pulumi.get(self, "recovery_container_id")

    @recovery_container_id.setter
    def recovery_container_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recovery_container_id", value)

    @property
    @pulumi.getter(name="recoveryResourceGroupId")
    def recovery_resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The recovery resource group Id. Valid for V2 scenarios.
        """
        return pulumi.get(self, "recovery_resource_group_id")

    @recovery_resource_group_id.setter
    def recovery_resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recovery_resource_group_id", value)

    @property
    @pulumi.getter(name="vmDisks")
    def vm_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['A2AVmDiskInputDetailsArgs']]]]:
        """
        The list of vm disk details.
        """
        return pulumi.get(self, "vm_disks")

    @vm_disks.setter
    def vm_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['A2AVmDiskInputDetailsArgs']]]]):
        pulumi.set(self, "vm_disks", value)

    @property
    @pulumi.getter(name="vmManagedDisks")
    def vm_managed_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['A2AVmManagedDiskInputDetailsArgs']]]]:
        """
        The list of vm managed disk details.
        """
        return pulumi.get(self, "vm_managed_disks")

    @vm_managed_disks.setter
    def vm_managed_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['A2AVmManagedDiskInputDetailsArgs']]]]):
        pulumi.set(self, "vm_managed_disks", value)


@pulumi.input_type
class A2APolicyCreationInputArgs:
    def __init__(__self__, *,
                 multi_vm_sync_status: pulumi.Input[Union[str, 'SetMultiVmSyncStatus']],
                 app_consistent_frequency_in_minutes: Optional[pulumi.Input[int]] = None,
                 crash_consistent_frequency_in_minutes: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 recovery_point_history: Optional[pulumi.Input[int]] = None):
        """
        A2A Policy creation input.
        :param pulumi.Input[Union[str, 'SetMultiVmSyncStatus']] multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
        :param pulumi.Input[int] app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in minutes).
        :param pulumi.Input[int] crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in minutes).
        :param pulumi.Input[str] instance_type: The class type.
               Expected value is 'A2A'.
        :param pulumi.Input[int] recovery_point_history: The duration in minutes until which the recovery points need to be stored.
        """
        pulumi.set(__self__, "multi_vm_sync_status", multi_vm_sync_status)
        if app_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "app_consistent_frequency_in_minutes", app_consistent_frequency_in_minutes)
        if crash_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "crash_consistent_frequency_in_minutes", crash_consistent_frequency_in_minutes)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'A2A')
        if recovery_point_history is not None:
            pulumi.set(__self__, "recovery_point_history", recovery_point_history)

    @property
    @pulumi.getter(name="multiVmSyncStatus")
    def multi_vm_sync_status(self) -> pulumi.Input[Union[str, 'SetMultiVmSyncStatus']]:
        """
        A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
        """
        return pulumi.get(self, "multi_vm_sync_status")

    @multi_vm_sync_status.setter
    def multi_vm_sync_status(self, value: pulumi.Input[Union[str, 'SetMultiVmSyncStatus']]):
        pulumi.set(self, "multi_vm_sync_status", value)

    @property
    @pulumi.getter(name="appConsistentFrequencyInMinutes")
    def app_consistent_frequency_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The app consistent snapshot frequency (in minutes).
        """
        return pulumi.get(self, "app_consistent_frequency_in_minutes")

    @app_consistent_frequency_in_minutes.setter
    def app_consistent_frequency_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "app_consistent_frequency_in_minutes", value)

    @property
    @pulumi.getter(name="crashConsistentFrequencyInMinutes")
    def crash_consistent_frequency_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The crash consistent snapshot frequency (in minutes).
        """
        return pulumi.get(self, "crash_consistent_frequency_in_minutes")

    @crash_consistent_frequency_in_minutes.setter
    def crash_consistent_frequency_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "crash_consistent_frequency_in_minutes", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The class type.
        Expected value is 'A2A'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="recoveryPointHistory")
    def recovery_point_history(self) -> Optional[pulumi.Input[int]]:
        """
        The duration in minutes until which the recovery points need to be stored.
        """
        return pulumi.get(self, "recovery_point_history")

    @recovery_point_history.setter
    def recovery_point_history(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_history", value)


@pulumi.input_type
class A2AVmDiskInputDetailsArgs:
    def __init__(__self__, *,
                 disk_uri: Optional[pulumi.Input[str]] = None,
                 primary_staging_azure_storage_account_id: Optional[pulumi.Input[str]] = None,
                 recovery_azure_storage_account_id: Optional[pulumi.Input[str]] = None):
        """
        Azure VM disk input details.
        :param pulumi.Input[str] disk_uri: The disk Uri.
        :param pulumi.Input[str] primary_staging_azure_storage_account_id: The primary staging storage account Id.
        :param pulumi.Input[str] recovery_azure_storage_account_id: The recovery VHD storage account Id.
        """
        if disk_uri is not None:
            pulumi.set(__self__, "disk_uri", disk_uri)
        if primary_staging_azure_storage_account_id is not None:
            pulumi.set(__self__, "primary_staging_azure_storage_account_id", primary_staging_azure_storage_account_id)
        if recovery_azure_storage_account_id is not None:
            pulumi.set(__self__, "recovery_azure_storage_account_id", recovery_azure_storage_account_id)

    @property
    @pulumi.getter(name="diskUri")
    def disk_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The disk Uri.
        """
        return pulumi.get(self, "disk_uri")

    @disk_uri.setter
    def disk_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_uri", value)

    @property
    @pulumi.getter(name="primaryStagingAzureStorageAccountId")
    def primary_staging_azure_storage_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The primary staging storage account Id.
        """
        return pulumi.get(self, "primary_staging_azure_storage_account_id")

    @primary_staging_azure_storage_account_id.setter
    def primary_staging_azure_storage_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_staging_azure_storage_account_id", value)

    @property
    @pulumi.getter(name="recoveryAzureStorageAccountId")
    def recovery_azure_storage_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The recovery VHD storage account Id.
        """
        return pulumi.get(self, "recovery_azure_storage_account_id")

    @recovery_azure_storage_account_id.setter
    def recovery_azure_storage_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recovery_azure_storage_account_id", value)


@pulumi.input_type
class A2AVmManagedDiskInputDetailsArgs:
    def __init__(__self__, *,
                 disk_id: Optional[pulumi.Input[str]] = None,
                 primary_staging_azure_storage_account_id: Optional[pulumi.Input[str]] = None,
                 recovery_replica_disk_account_type: Optional[pulumi.Input[str]] = None,
                 recovery_resource_group_id: Optional[pulumi.Input[str]] = None,
                 recovery_target_disk_account_type: Optional[pulumi.Input[str]] = None):
        """
        Azure VM managed disk input details.
        :param pulumi.Input[str] disk_id: The disk Id.
        :param pulumi.Input[str] primary_staging_azure_storage_account_id: The primary staging storage account Arm Id.
        :param pulumi.Input[str] recovery_replica_disk_account_type: The replica disk type. Its an optional value and will be same as source disk type if not user provided.
        :param pulumi.Input[str] recovery_resource_group_id: The target resource group Arm Id.
        :param pulumi.Input[str] recovery_target_disk_account_type: The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
        """
        if disk_id is not None:
            pulumi.set(__self__, "disk_id", disk_id)
        if primary_staging_azure_storage_account_id is not None:
            pulumi.set(__self__, "primary_staging_azure_storage_account_id", primary_staging_azure_storage_account_id)
        if recovery_replica_disk_account_type is not None:
            pulumi.set(__self__, "recovery_replica_disk_account_type", recovery_replica_disk_account_type)
        if recovery_resource_group_id is not None:
            pulumi.set(__self__, "recovery_resource_group_id", recovery_resource_group_id)
        if recovery_target_disk_account_type is not None:
            pulumi.set(__self__, "recovery_target_disk_account_type", recovery_target_disk_account_type)

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[pulumi.Input[str]]:
        """
        The disk Id.
        """
        return pulumi.get(self, "disk_id")

    @disk_id.setter
    def disk_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_id", value)

    @property
    @pulumi.getter(name="primaryStagingAzureStorageAccountId")
    def primary_staging_azure_storage_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The primary staging storage account Arm Id.
        """
        return pulumi.get(self, "primary_staging_azure_storage_account_id")

    @primary_staging_azure_storage_account_id.setter
    def primary_staging_azure_storage_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_staging_azure_storage_account_id", value)

    @property
    @pulumi.getter(name="recoveryReplicaDiskAccountType")
    def recovery_replica_disk_account_type(self) -> Optional[pulumi.Input[str]]:
        """
        The replica disk type. Its an optional value and will be same as source disk type if not user provided.
        """
        return pulumi.get(self, "recovery_replica_disk_account_type")

    @recovery_replica_disk_account_type.setter
    def recovery_replica_disk_account_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recovery_replica_disk_account_type", value)

    @property
    @pulumi.getter(name="recoveryResourceGroupId")
    def recovery_resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The target resource group Arm Id.
        """
        return pulumi.get(self, "recovery_resource_group_id")

    @recovery_resource_group_id.setter
    def recovery_resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recovery_resource_group_id", value)

    @property
    @pulumi.getter(name="recoveryTargetDiskAccountType")
    def recovery_target_disk_account_type(self) -> Optional[pulumi.Input[str]]:
        """
        The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
        """
        return pulumi.get(self, "recovery_target_disk_account_type")

    @recovery_target_disk_account_type.setter
    def recovery_target_disk_account_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recovery_target_disk_account_type", value)


@pulumi.input_type
class AddRecoveryServicesProviderInputPropertiesArgs:
    def __init__(__self__, *,
                 authentication_identity_input: pulumi.Input['IdentityProviderInputArgs'],
                 machine_name: pulumi.Input[str],
                 resource_access_identity_input: pulumi.Input['IdentityProviderInputArgs']):
        """
        The properties of an add provider request.
        :param pulumi.Input['IdentityProviderInputArgs'] authentication_identity_input: The identity provider input for DRA authentication.
        :param pulumi.Input[str] machine_name: The name of the machine where the provider is getting added.
        :param pulumi.Input['IdentityProviderInputArgs'] resource_access_identity_input: The identity provider input for resource access.
        """
        pulumi.set(__self__, "authentication_identity_input", authentication_identity_input)
        pulumi.set(__self__, "machine_name", machine_name)
        pulumi.set(__self__, "resource_access_identity_input", resource_access_identity_input)

    @property
    @pulumi.getter(name="authenticationIdentityInput")
    def authentication_identity_input(self) -> pulumi.Input['IdentityProviderInputArgs']:
        """
        The identity provider input for DRA authentication.
        """
        return pulumi.get(self, "authentication_identity_input")

    @authentication_identity_input.setter
    def authentication_identity_input(self, value: pulumi.Input['IdentityProviderInputArgs']):
        pulumi.set(self, "authentication_identity_input", value)

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> pulumi.Input[str]:
        """
        The name of the machine where the provider is getting added.
        """
        return pulumi.get(self, "machine_name")

    @machine_name.setter
    def machine_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "machine_name", value)

    @property
    @pulumi.getter(name="resourceAccessIdentityInput")
    def resource_access_identity_input(self) -> pulumi.Input['IdentityProviderInputArgs']:
        """
        The identity provider input for resource access.
        """
        return pulumi.get(self, "resource_access_identity_input")

    @resource_access_identity_input.setter
    def resource_access_identity_input(self, value: pulumi.Input['IdentityProviderInputArgs']):
        pulumi.set(self, "resource_access_identity_input", value)


@pulumi.input_type
class AddVCenterRequestPropertiesArgs:
    def __init__(__self__, *,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 process_server_id: Optional[pulumi.Input[str]] = None,
                 run_as_account_id: Optional[pulumi.Input[str]] = None):
        """
        The properties of an add vCenter request.
        :param pulumi.Input[str] friendly_name: The friendly name of the vCenter.
        :param pulumi.Input[str] ip_address: The IP address of the vCenter to be discovered.
        :param pulumi.Input[str] port: The port number for discovery.
        :param pulumi.Input[str] process_server_id: The process server Id from where the discovery is orchestrated.
        :param pulumi.Input[str] run_as_account_id: The account Id which has privileges to discover the vCenter.
        """
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if process_server_id is not None:
            pulumi.set(__self__, "process_server_id", process_server_id)
        if run_as_account_id is not None:
            pulumi.set(__self__, "run_as_account_id", run_as_account_id)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        The friendly name of the vCenter.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the vCenter to be discovered.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        The port number for discovery.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="processServerId")
    def process_server_id(self) -> Optional[pulumi.Input[str]]:
        """
        The process server Id from where the discovery is orchestrated.
        """
        return pulumi.get(self, "process_server_id")

    @process_server_id.setter
    def process_server_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "process_server_id", value)

    @property
    @pulumi.getter(name="runAsAccountId")
    def run_as_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account Id which has privileges to discover the vCenter.
        """
        return pulumi.get(self, "run_as_account_id")

    @run_as_account_id.setter
    def run_as_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_as_account_id", value)


@pulumi.input_type
class AzureFabricCreationInputArgs:
    def __init__(__self__, *,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None):
        """
        Fabric provider specific settings.
        :param pulumi.Input[str] instance_type: Gets the class type.
               Expected value is 'Azure'.
        :param pulumi.Input[str] location: The Location.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'Azure')
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Gets the class type.
        Expected value is 'Azure'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The Location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class AzureToAzureCreateNetworkMappingInputArgs:
    def __init__(__self__, *,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 primary_network_id: Optional[pulumi.Input[str]] = None):
        """
        Create network mappings input properties/behavior specific to Azure to Azure Network mapping.
        :param pulumi.Input[str] instance_type: The instance type.
               Expected value is 'AzureToAzure'.
        :param pulumi.Input[str] primary_network_id: The primary azure vnet Id.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'AzureToAzure')
        if primary_network_id is not None:
            pulumi.set(__self__, "primary_network_id", primary_network_id)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type.
        Expected value is 'AzureToAzure'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="primaryNetworkId")
    def primary_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The primary azure vnet Id.
        """
        return pulumi.get(self, "primary_network_id")

    @primary_network_id.setter
    def primary_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_network_id", value)


@pulumi.input_type
class CreateNetworkMappingInputPropertiesArgs:
    def __init__(__self__, *,
                 fabric_specific_details: Optional[pulumi.Input[Union['AzureToAzureCreateNetworkMappingInputArgs', 'VmmToAzureCreateNetworkMappingInputArgs', 'VmmToVmmCreateNetworkMappingInputArgs']]] = None,
                 recovery_fabric_name: Optional[pulumi.Input[str]] = None,
                 recovery_network_id: Optional[pulumi.Input[str]] = None):
        """
        Common input details for network mapping operation.
        :param pulumi.Input[Union['AzureToAzureCreateNetworkMappingInputArgs', 'VmmToAzureCreateNetworkMappingInputArgs', 'VmmToVmmCreateNetworkMappingInputArgs']] fabric_specific_details: Fabric specific input properties.
        :param pulumi.Input[str] recovery_fabric_name: Recovery fabric Name.
        :param pulumi.Input[str] recovery_network_id: Recovery network Id.
        """
        if fabric_specific_details is not None:
            pulumi.set(__self__, "fabric_specific_details", fabric_specific_details)
        if recovery_fabric_name is not None:
            pulumi.set(__self__, "recovery_fabric_name", recovery_fabric_name)
        if recovery_network_id is not None:
            pulumi.set(__self__, "recovery_network_id", recovery_network_id)

    @property
    @pulumi.getter(name="fabricSpecificDetails")
    def fabric_specific_details(self) -> Optional[pulumi.Input[Union['AzureToAzureCreateNetworkMappingInputArgs', 'VmmToAzureCreateNetworkMappingInputArgs', 'VmmToVmmCreateNetworkMappingInputArgs']]]:
        """
        Fabric specific input properties.
        """
        return pulumi.get(self, "fabric_specific_details")

    @fabric_specific_details.setter
    def fabric_specific_details(self, value: Optional[pulumi.Input[Union['AzureToAzureCreateNetworkMappingInputArgs', 'VmmToAzureCreateNetworkMappingInputArgs', 'VmmToVmmCreateNetworkMappingInputArgs']]]):
        pulumi.set(self, "fabric_specific_details", value)

    @property
    @pulumi.getter(name="recoveryFabricName")
    def recovery_fabric_name(self) -> Optional[pulumi.Input[str]]:
        """
        Recovery fabric Name.
        """
        return pulumi.get(self, "recovery_fabric_name")

    @recovery_fabric_name.setter
    def recovery_fabric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recovery_fabric_name", value)

    @property
    @pulumi.getter(name="recoveryNetworkId")
    def recovery_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        Recovery network Id.
        """
        return pulumi.get(self, "recovery_network_id")

    @recovery_network_id.setter
    def recovery_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recovery_network_id", value)


@pulumi.input_type
class CreatePolicyInputPropertiesArgs:
    def __init__(__self__, *,
                 provider_specific_input: Optional[pulumi.Input[Union['A2APolicyCreationInputArgs', 'HyperVReplicaAzurePolicyInputArgs', 'HyperVReplicaBluePolicyInputArgs', 'HyperVReplicaPolicyInputArgs', 'InMageAzureV2PolicyInputArgs', 'InMagePolicyInputArgs', 'VMwareCbtPolicyCreationInputArgs']]] = None):
        """
        Policy creation properties.
        :param pulumi.Input[Union['A2APolicyCreationInputArgs', 'HyperVReplicaAzurePolicyInputArgs', 'HyperVReplicaBluePolicyInputArgs', 'HyperVReplicaPolicyInputArgs', 'InMageAzureV2PolicyInputArgs', 'InMagePolicyInputArgs', 'VMwareCbtPolicyCreationInputArgs']] provider_specific_input: The ReplicationProviderSettings.
        """
        if provider_specific_input is not None:
            pulumi.set(__self__, "provider_specific_input", provider_specific_input)

    @property
    @pulumi.getter(name="providerSpecificInput")
    def provider_specific_input(self) -> Optional[pulumi.Input[Union['A2APolicyCreationInputArgs', 'HyperVReplicaAzurePolicyInputArgs', 'HyperVReplicaBluePolicyInputArgs', 'HyperVReplicaPolicyInputArgs', 'InMageAzureV2PolicyInputArgs', 'InMagePolicyInputArgs', 'VMwareCbtPolicyCreationInputArgs']]]:
        """
        The ReplicationProviderSettings.
        """
        return pulumi.get(self, "provider_specific_input")

    @provider_specific_input.setter
    def provider_specific_input(self, value: Optional[pulumi.Input[Union['A2APolicyCreationInputArgs', 'HyperVReplicaAzurePolicyInputArgs', 'HyperVReplicaBluePolicyInputArgs', 'HyperVReplicaPolicyInputArgs', 'InMageAzureV2PolicyInputArgs', 'InMagePolicyInputArgs', 'VMwareCbtPolicyCreationInputArgs']]]):
        pulumi.set(self, "provider_specific_input", value)


@pulumi.input_type
class CreateProtectionContainerMappingInputPropertiesArgs:
    def __init__(__self__, *,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 provider_specific_input: Optional[pulumi.Input[Union['A2AContainerMappingInputArgs', 'VMwareCbtContainerMappingInputArgs']]] = None,
                 target_protection_container_id: Optional[pulumi.Input[str]] = None):
        """
        Configure pairing input properties.
        :param pulumi.Input[str] policy_id: Applicable policy.
        :param pulumi.Input[Union['A2AContainerMappingInputArgs', 'VMwareCbtContainerMappingInputArgs']] provider_specific_input: Provider specific input for pairing.
        :param pulumi.Input[str] target_protection_container_id: The target unique protection container name.
        """
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if provider_specific_input is not None:
            pulumi.set(__self__, "provider_specific_input", provider_specific_input)
        if target_protection_container_id is not None:
            pulumi.set(__self__, "target_protection_container_id", target_protection_container_id)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Applicable policy.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="providerSpecificInput")
    def provider_specific_input(self) -> Optional[pulumi.Input[Union['A2AContainerMappingInputArgs', 'VMwareCbtContainerMappingInputArgs']]]:
        """
        Provider specific input for pairing.
        """
        return pulumi.get(self, "provider_specific_input")

    @provider_specific_input.setter
    def provider_specific_input(self, value: Optional[pulumi.Input[Union['A2AContainerMappingInputArgs', 'VMwareCbtContainerMappingInputArgs']]]):
        pulumi.set(self, "provider_specific_input", value)

    @property
    @pulumi.getter(name="targetProtectionContainerId")
    def target_protection_container_id(self) -> Optional[pulumi.Input[str]]:
        """
        The target unique protection container name.
        """
        return pulumi.get(self, "target_protection_container_id")

    @target_protection_container_id.setter
    def target_protection_container_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_protection_container_id", value)


@pulumi.input_type
class CreateRecoveryPlanInputPropertiesArgs:
    def __init__(__self__, *,
                 groups: pulumi.Input[Sequence[pulumi.Input['RecoveryPlanGroupArgs']]],
                 primary_fabric_id: pulumi.Input[str],
                 recovery_fabric_id: pulumi.Input[str],
                 failover_deployment_model: Optional[pulumi.Input[Union[str, 'FailoverDeploymentModel']]] = None):
        """
        Recovery plan creation properties.
        :param pulumi.Input[Sequence[pulumi.Input['RecoveryPlanGroupArgs']]] groups: The recovery plan groups.
        :param pulumi.Input[str] primary_fabric_id: The primary fabric Id.
        :param pulumi.Input[str] recovery_fabric_id: The recovery fabric Id.
        :param pulumi.Input[Union[str, 'FailoverDeploymentModel']] failover_deployment_model: The failover deployment model.
        """
        pulumi.set(__self__, "groups", groups)
        pulumi.set(__self__, "primary_fabric_id", primary_fabric_id)
        pulumi.set(__self__, "recovery_fabric_id", recovery_fabric_id)
        if failover_deployment_model is not None:
            pulumi.set(__self__, "failover_deployment_model", failover_deployment_model)

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Input[Sequence[pulumi.Input['RecoveryPlanGroupArgs']]]:
        """
        The recovery plan groups.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: pulumi.Input[Sequence[pulumi.Input['RecoveryPlanGroupArgs']]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="primaryFabricId")
    def primary_fabric_id(self) -> pulumi.Input[str]:
        """
        The primary fabric Id.
        """
        return pulumi.get(self, "primary_fabric_id")

    @primary_fabric_id.setter
    def primary_fabric_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_fabric_id", value)

    @property
    @pulumi.getter(name="recoveryFabricId")
    def recovery_fabric_id(self) -> pulumi.Input[str]:
        """
        The recovery fabric Id.
        """
        return pulumi.get(self, "recovery_fabric_id")

    @recovery_fabric_id.setter
    def recovery_fabric_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "recovery_fabric_id", value)

    @property
    @pulumi.getter(name="failoverDeploymentModel")
    def failover_deployment_model(self) -> Optional[pulumi.Input[Union[str, 'FailoverDeploymentModel']]]:
        """
        The failover deployment model.
        """
        return pulumi.get(self, "failover_deployment_model")

    @failover_deployment_model.setter
    def failover_deployment_model(self, value: Optional[pulumi.Input[Union[str, 'FailoverDeploymentModel']]]):
        pulumi.set(self, "failover_deployment_model", value)


@pulumi.input_type
class DiskEncryptionInfoArgs:
    def __init__(__self__, *,
                 disk_encryption_key_info: Optional[pulumi.Input['DiskEncryptionKeyInfoArgs']] = None,
                 key_encryption_key_info: Optional[pulumi.Input['KeyEncryptionKeyInfoArgs']] = None):
        """
        Recovery disk encryption info (BEK and KEK).
        :param pulumi.Input['DiskEncryptionKeyInfoArgs'] disk_encryption_key_info: The recovery KeyVault reference for secret.
        :param pulumi.Input['KeyEncryptionKeyInfoArgs'] key_encryption_key_info: The recovery KeyVault reference for key.
        """
        if disk_encryption_key_info is not None:
            pulumi.set(__self__, "disk_encryption_key_info", disk_encryption_key_info)
        if key_encryption_key_info is not None:
            pulumi.set(__self__, "key_encryption_key_info", key_encryption_key_info)

    @property
    @pulumi.getter(name="diskEncryptionKeyInfo")
    def disk_encryption_key_info(self) -> Optional[pulumi.Input['DiskEncryptionKeyInfoArgs']]:
        """
        The recovery KeyVault reference for secret.
        """
        return pulumi.get(self, "disk_encryption_key_info")

    @disk_encryption_key_info.setter
    def disk_encryption_key_info(self, value: Optional[pulumi.Input['DiskEncryptionKeyInfoArgs']]):
        pulumi.set(self, "disk_encryption_key_info", value)

    @property
    @pulumi.getter(name="keyEncryptionKeyInfo")
    def key_encryption_key_info(self) -> Optional[pulumi.Input['KeyEncryptionKeyInfoArgs']]:
        """
        The recovery KeyVault reference for key.
        """
        return pulumi.get(self, "key_encryption_key_info")

    @key_encryption_key_info.setter
    def key_encryption_key_info(self, value: Optional[pulumi.Input['KeyEncryptionKeyInfoArgs']]):
        pulumi.set(self, "key_encryption_key_info", value)


@pulumi.input_type
class DiskEncryptionKeyInfoArgs:
    def __init__(__self__, *,
                 key_vault_resource_arm_id: Optional[pulumi.Input[str]] = None,
                 secret_identifier: Optional[pulumi.Input[str]] = None):
        """
        Disk Encryption Key Information (BitLocker Encryption Key (BEK) on Windows).
        :param pulumi.Input[str] key_vault_resource_arm_id: The KeyVault resource ARM id for secret.
        :param pulumi.Input[str] secret_identifier: The secret url / identifier.
        """
        if key_vault_resource_arm_id is not None:
            pulumi.set(__self__, "key_vault_resource_arm_id", key_vault_resource_arm_id)
        if secret_identifier is not None:
            pulumi.set(__self__, "secret_identifier", secret_identifier)

    @property
    @pulumi.getter(name="keyVaultResourceArmId")
    def key_vault_resource_arm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The KeyVault resource ARM id for secret.
        """
        return pulumi.get(self, "key_vault_resource_arm_id")

    @key_vault_resource_arm_id.setter
    def key_vault_resource_arm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_resource_arm_id", value)

    @property
    @pulumi.getter(name="secretIdentifier")
    def secret_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The secret url / identifier.
        """
        return pulumi.get(self, "secret_identifier")

    @secret_identifier.setter
    def secret_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_identifier", value)


@pulumi.input_type
class EnableMigrationInputPropertiesArgs:
    def __init__(__self__, *,
                 policy_id: pulumi.Input[str],
                 provider_specific_details: pulumi.Input['VMwareCbtEnableMigrationInputArgs']):
        """
        Enable migration input properties.
        :param pulumi.Input[str] policy_id: The policy Id.
        :param pulumi.Input['VMwareCbtEnableMigrationInputArgs'] provider_specific_details: The provider specific details.
        """
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "provider_specific_details", provider_specific_details)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[str]:
        """
        The policy Id.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="providerSpecificDetails")
    def provider_specific_details(self) -> pulumi.Input['VMwareCbtEnableMigrationInputArgs']:
        """
        The provider specific details.
        """
        return pulumi.get(self, "provider_specific_details")

    @provider_specific_details.setter
    def provider_specific_details(self, value: pulumi.Input['VMwareCbtEnableMigrationInputArgs']):
        pulumi.set(self, "provider_specific_details", value)


@pulumi.input_type
class EnableProtectionInputPropertiesArgs:
    def __init__(__self__, *,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protectable_item_id: Optional[pulumi.Input[str]] = None,
                 provider_specific_details: Optional[pulumi.Input[Union['A2AEnableProtectionInputArgs', 'HyperVReplicaAzureEnableProtectionInputArgs', 'InMageAzureV2EnableProtectionInputArgs', 'InMageEnableProtectionInputArgs', 'SanEnableProtectionInputArgs']]] = None):
        """
        Enable protection input properties.
        :param pulumi.Input[str] policy_id: The Policy Id.
        :param pulumi.Input[str] protectable_item_id: The protectable item Id.
        :param pulumi.Input[Union['A2AEnableProtectionInputArgs', 'HyperVReplicaAzureEnableProtectionInputArgs', 'InMageAzureV2EnableProtectionInputArgs', 'InMageEnableProtectionInputArgs', 'SanEnableProtectionInputArgs']] provider_specific_details: The ReplicationProviderInput. For HyperVReplicaAzure provider, it will be AzureEnableProtectionInput object. For San provider, it will be SanEnableProtectionInput object. For HyperVReplicaAzure provider, it can be null.
        """
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protectable_item_id is not None:
            pulumi.set(__self__, "protectable_item_id", protectable_item_id)
        if provider_specific_details is not None:
            pulumi.set(__self__, "provider_specific_details", provider_specific_details)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Policy Id.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectableItemId")
    def protectable_item_id(self) -> Optional[pulumi.Input[str]]:
        """
        The protectable item Id.
        """
        return pulumi.get(self, "protectable_item_id")

    @protectable_item_id.setter
    def protectable_item_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protectable_item_id", value)

    @property
    @pulumi.getter(name="providerSpecificDetails")
    def provider_specific_details(self) -> Optional[pulumi.Input[Union['A2AEnableProtectionInputArgs', 'HyperVReplicaAzureEnableProtectionInputArgs', 'InMageAzureV2EnableProtectionInputArgs', 'InMageEnableProtectionInputArgs', 'SanEnableProtectionInputArgs']]]:
        """
        The ReplicationProviderInput. For HyperVReplicaAzure provider, it will be AzureEnableProtectionInput object. For San provider, it will be SanEnableProtectionInput object. For HyperVReplicaAzure provider, it can be null.
        """
        return pulumi.get(self, "provider_specific_details")

    @provider_specific_details.setter
    def provider_specific_details(self, value: Optional[pulumi.Input[Union['A2AEnableProtectionInputArgs', 'HyperVReplicaAzureEnableProtectionInputArgs', 'InMageAzureV2EnableProtectionInputArgs', 'InMageEnableProtectionInputArgs', 'SanEnableProtectionInputArgs']]]):
        pulumi.set(self, "provider_specific_details", value)


@pulumi.input_type
class FabricCreationInputPropertiesArgs:
    def __init__(__self__, *,
                 custom_details: Optional[pulumi.Input[Union['AzureFabricCreationInputArgs', 'VMwareV2FabricCreationInputArgs']]] = None):
        """
        Properties of site details provided during the time of site creation
        :param pulumi.Input[Union['AzureFabricCreationInputArgs', 'VMwareV2FabricCreationInputArgs']] custom_details: Fabric provider specific creation input.
        """
        if custom_details is not None:
            pulumi.set(__self__, "custom_details", custom_details)

    @property
    @pulumi.getter(name="customDetails")
    def custom_details(self) -> Optional[pulumi.Input[Union['AzureFabricCreationInputArgs', 'VMwareV2FabricCreationInputArgs']]]:
        """
        Fabric provider specific creation input.
        """
        return pulumi.get(self, "custom_details")

    @custom_details.setter
    def custom_details(self, value: Optional[pulumi.Input[Union['AzureFabricCreationInputArgs', 'VMwareV2FabricCreationInputArgs']]]):
        pulumi.set(self, "custom_details", value)


@pulumi.input_type
class HyperVReplicaAzureEnableProtectionInputArgs:
    def __init__(__self__, *,
                 disks_to_include: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_rdp_on_target_option: Optional[pulumi.Input[str]] = None,
                 hv_host_vm_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 log_storage_account_id: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 target_azure_network_id: Optional[pulumi.Input[str]] = None,
                 target_azure_subnet_id: Optional[pulumi.Input[str]] = None,
                 target_azure_v1_resource_group_id: Optional[pulumi.Input[str]] = None,
                 target_azure_v2_resource_group_id: Optional[pulumi.Input[str]] = None,
                 target_azure_vm_name: Optional[pulumi.Input[str]] = None,
                 target_storage_account_id: Optional[pulumi.Input[str]] = None,
                 use_managed_disks: Optional[pulumi.Input[str]] = None,
                 vhd_id: Optional[pulumi.Input[str]] = None,
                 vm_name: Optional[pulumi.Input[str]] = None):
        """
        Azure specific enable protection input.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disks_to_include: The list of VHD IDs of disks to be protected.
        :param pulumi.Input[str] enable_rdp_on_target_option: The selected option to enable RDP\\SSH on target vm after failover. String value of {SrsDataContract.EnableRDPOnTargetOption} enum.
        :param pulumi.Input[str] hv_host_vm_id: The Hyper-V host Vm Id.
        :param pulumi.Input[str] instance_type: The class type.
               Expected value is 'HyperVReplicaAzure'.
        :param pulumi.Input[str] log_storage_account_id: The storage account to be used for logging during replication.
        :param pulumi.Input[str] os_type: The OS type associated with vm.
        :param pulumi.Input[str] target_azure_network_id: The selected target Azure network Id.
        :param pulumi.Input[str] target_azure_subnet_id: The selected target Azure subnet Id.
        :param pulumi.Input[str] target_azure_v1_resource_group_id: The Id of the target resource group (for classic deployment) in which the failover VM is to be created.
        :param pulumi.Input[str] target_azure_v2_resource_group_id: The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created.
        :param pulumi.Input[str] target_azure_vm_name: The target azure Vm Name.
        :param pulumi.Input[str] target_storage_account_id: The storage account name.
        :param pulumi.Input[str] use_managed_disks: A value indicating whether managed disks should be used during failover.
        :param pulumi.Input[str] vhd_id: The OS disk VHD id associated with vm.
        :param pulumi.Input[str] vm_name: The Vm Name.
        """
        if disks_to_include is not None:
            pulumi.set(__self__, "disks_to_include", disks_to_include)
        if enable_rdp_on_target_option is not None:
            pulumi.set(__self__, "enable_rdp_on_target_option", enable_rdp_on_target_option)
        if hv_host_vm_id is not None:
            pulumi.set(__self__, "hv_host_vm_id", hv_host_vm_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'HyperVReplicaAzure')
        if log_storage_account_id is not None:
            pulumi.set(__self__, "log_storage_account_id", log_storage_account_id)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if target_azure_network_id is not None:
            pulumi.set(__self__, "target_azure_network_id", target_azure_network_id)
        if target_azure_subnet_id is not None:
            pulumi.set(__self__, "target_azure_subnet_id", target_azure_subnet_id)
        if target_azure_v1_resource_group_id is not None:
            pulumi.set(__self__, "target_azure_v1_resource_group_id", target_azure_v1_resource_group_id)
        if target_azure_v2_resource_group_id is not None:
            pulumi.set(__self__, "target_azure_v2_resource_group_id", target_azure_v2_resource_group_id)
        if target_azure_vm_name is not None:
            pulumi.set(__self__, "target_azure_vm_name", target_azure_vm_name)
        if target_storage_account_id is not None:
            pulumi.set(__self__, "target_storage_account_id", target_storage_account_id)
        if use_managed_disks is not None:
            pulumi.set(__self__, "use_managed_disks", use_managed_disks)
        if vhd_id is not None:
            pulumi.set(__self__, "vhd_id", vhd_id)
        if vm_name is not None:
            pulumi.set(__self__, "vm_name", vm_name)

    @property
    @pulumi.getter(name="disksToInclude")
    def disks_to_include(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of VHD IDs of disks to be protected.
        """
        return pulumi.get(self, "disks_to_include")

    @disks_to_include.setter
    def disks_to_include(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "disks_to_include", value)

    @property
    @pulumi.getter(name="enableRdpOnTargetOption")
    def enable_rdp_on_target_option(self) -> Optional[pulumi.Input[str]]:
        """
        The selected option to enable RDP\\SSH on target vm after failover. String value of {SrsDataContract.EnableRDPOnTargetOption} enum.
        """
        return pulumi.get(self, "enable_rdp_on_target_option")

    @enable_rdp_on_target_option.setter
    def enable_rdp_on_target_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_rdp_on_target_option", value)

    @property
    @pulumi.getter(name="hvHostVmId")
    def hv_host_vm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Hyper-V host Vm Id.
        """
        return pulumi.get(self, "hv_host_vm_id")

    @hv_host_vm_id.setter
    def hv_host_vm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hv_host_vm_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The class type.
        Expected value is 'HyperVReplicaAzure'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="logStorageAccountId")
    def log_storage_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The storage account to be used for logging during replication.
        """
        return pulumi.get(self, "log_storage_account_id")

    @log_storage_account_id.setter
    def log_storage_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_storage_account_id", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[str]]:
        """
        The OS type associated with vm.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="targetAzureNetworkId")
    def target_azure_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The selected target Azure network Id.
        """
        return pulumi.get(self, "target_azure_network_id")

    @target_azure_network_id.setter
    def target_azure_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_azure_network_id", value)

    @property
    @pulumi.getter(name="targetAzureSubnetId")
    def target_azure_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The selected target Azure subnet Id.
        """
        return pulumi.get(self, "target_azure_subnet_id")

    @target_azure_subnet_id.setter
    def target_azure_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_azure_subnet_id", value)

    @property
    @pulumi.getter(name="targetAzureV1ResourceGroupId")
    def target_azure_v1_resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the target resource group (for classic deployment) in which the failover VM is to be created.
        """
        return pulumi.get(self, "target_azure_v1_resource_group_id")

    @target_azure_v1_resource_group_id.setter
    def target_azure_v1_resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_azure_v1_resource_group_id", value)

    @property
    @pulumi.getter(name="targetAzureV2ResourceGroupId")
    def target_azure_v2_resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created.
        """
        return pulumi.get(self, "target_azure_v2_resource_group_id")

    @target_azure_v2_resource_group_id.setter
    def target_azure_v2_resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_azure_v2_resource_group_id", value)

    @property
    @pulumi.getter(name="targetAzureVmName")
    def target_azure_vm_name(self) -> Optional[pulumi.Input[str]]:
        """
        The target azure Vm Name.
        """
        return pulumi.get(self, "target_azure_vm_name")

    @target_azure_vm_name.setter
    def target_azure_vm_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_azure_vm_name", value)

    @property
    @pulumi.getter(name="targetStorageAccountId")
    def target_storage_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The storage account name.
        """
        return pulumi.get(self, "target_storage_account_id")

    @target_storage_account_id.setter
    def target_storage_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_storage_account_id", value)

    @property
    @pulumi.getter(name="useManagedDisks")
    def use_managed_disks(self) -> Optional[pulumi.Input[str]]:
        """
        A value indicating whether managed disks should be used during failover.
        """
        return pulumi.get(self, "use_managed_disks")

    @use_managed_disks.setter
    def use_managed_disks(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "use_managed_disks", value)

    @property
    @pulumi.getter(name="vhdId")
    def vhd_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OS disk VHD id associated with vm.
        """
        return pulumi.get(self, "vhd_id")

    @vhd_id.setter
    def vhd_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vhd_id", value)

    @property
    @pulumi.getter(name="vmName")
    def vm_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Vm Name.
        """
        return pulumi.get(self, "vm_name")

    @vm_name.setter
    def vm_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_name", value)


@pulumi.input_type
class HyperVReplicaAzurePolicyInputArgs:
    def __init__(__self__, *,
                 application_consistent_snapshot_frequency_in_hours: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 online_replication_start_time: Optional[pulumi.Input[str]] = None,
                 recovery_point_history_duration: Optional[pulumi.Input[int]] = None,
                 replication_interval: Optional[pulumi.Input[int]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Hyper-V Replica Azure specific input for creating a protection profile.
        :param pulumi.Input[int] application_consistent_snapshot_frequency_in_hours: The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM.
        :param pulumi.Input[str] instance_type: The class type.
               Expected value is 'HyperVReplicaAzure'.
        :param pulumi.Input[str] online_replication_start_time: The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately.
        :param pulumi.Input[int] recovery_point_history_duration: The duration (in hours) to which point the recovery history needs to be maintained.
        :param pulumi.Input[int] replication_interval: The replication interval.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] storage_accounts: The list of storage accounts to which the VMs in the primary cloud can replicate to.
        """
        if application_consistent_snapshot_frequency_in_hours is not None:
            pulumi.set(__self__, "application_consistent_snapshot_frequency_in_hours", application_consistent_snapshot_frequency_in_hours)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'HyperVReplicaAzure')
        if online_replication_start_time is not None:
            pulumi.set(__self__, "online_replication_start_time", online_replication_start_time)
        if recovery_point_history_duration is not None:
            pulumi.set(__self__, "recovery_point_history_duration", recovery_point_history_duration)
        if replication_interval is not None:
            pulumi.set(__self__, "replication_interval", replication_interval)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)

    @property
    @pulumi.getter(name="applicationConsistentSnapshotFrequencyInHours")
    def application_consistent_snapshot_frequency_in_hours(self) -> Optional[pulumi.Input[int]]:
        """
        The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM.
        """
        return pulumi.get(self, "application_consistent_snapshot_frequency_in_hours")

    @application_consistent_snapshot_frequency_in_hours.setter
    def application_consistent_snapshot_frequency_in_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "application_consistent_snapshot_frequency_in_hours", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The class type.
        Expected value is 'HyperVReplicaAzure'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="onlineReplicationStartTime")
    def online_replication_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately.
        """
        return pulumi.get(self, "online_replication_start_time")

    @online_replication_start_time.setter
    def online_replication_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "online_replication_start_time", value)

    @property
    @pulumi.getter(name="recoveryPointHistoryDuration")
    def recovery_point_history_duration(self) -> Optional[pulumi.Input[int]]:
        """
        The duration (in hours) to which point the recovery history needs to be maintained.
        """
        return pulumi.get(self, "recovery_point_history_duration")

    @recovery_point_history_duration.setter
    def recovery_point_history_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_history_duration", value)

    @property
    @pulumi.getter(name="replicationInterval")
    def replication_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The replication interval.
        """
        return pulumi.get(self, "replication_interval")

    @replication_interval.setter
    def replication_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replication_interval", value)

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of storage accounts to which the VMs in the primary cloud can replicate to.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "storage_accounts", value)


@pulumi.input_type
class HyperVReplicaBluePolicyInputArgs:
    def __init__(__self__, *,
                 allowed_authentication_type: Optional[pulumi.Input[int]] = None,
                 application_consistent_snapshot_frequency_in_hours: Optional[pulumi.Input[int]] = None,
                 compression: Optional[pulumi.Input[str]] = None,
                 initial_replication_method: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 offline_replication_export_path: Optional[pulumi.Input[str]] = None,
                 offline_replication_import_path: Optional[pulumi.Input[str]] = None,
                 online_replication_start_time: Optional[pulumi.Input[str]] = None,
                 recovery_points: Optional[pulumi.Input[int]] = None,
                 replica_deletion: Optional[pulumi.Input[str]] = None,
                 replication_frequency_in_seconds: Optional[pulumi.Input[int]] = None,
                 replication_port: Optional[pulumi.Input[int]] = None):
        """
        HyperV Replica Blue policy input.
        :param pulumi.Input[int] allowed_authentication_type: A value indicating the authentication type.
        :param pulumi.Input[int] application_consistent_snapshot_frequency_in_hours: A value indicating the application consistent frequency.
        :param pulumi.Input[str] compression: A value indicating whether compression has to be enabled.
        :param pulumi.Input[str] initial_replication_method: A value indicating whether IR is online.
        :param pulumi.Input[str] instance_type: The class type.
               Expected value is 'HyperVReplica2012R2'.
        :param pulumi.Input[str] offline_replication_export_path: A value indicating the offline IR export path.
        :param pulumi.Input[str] offline_replication_import_path: A value indicating the offline IR import path.
        :param pulumi.Input[str] online_replication_start_time: A value indicating the online IR start time.
        :param pulumi.Input[int] recovery_points: A value indicating the number of recovery points.
        :param pulumi.Input[str] replica_deletion: A value indicating whether the VM has to be auto deleted.
        :param pulumi.Input[int] replication_frequency_in_seconds: A value indicating the replication interval.
        :param pulumi.Input[int] replication_port: A value indicating the recovery HTTPS port.
        """
        if allowed_authentication_type is not None:
            pulumi.set(__self__, "allowed_authentication_type", allowed_authentication_type)
        if application_consistent_snapshot_frequency_in_hours is not None:
            pulumi.set(__self__, "application_consistent_snapshot_frequency_in_hours", application_consistent_snapshot_frequency_in_hours)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if initial_replication_method is not None:
            pulumi.set(__self__, "initial_replication_method", initial_replication_method)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'HyperVReplica2012R2')
        if offline_replication_export_path is not None:
            pulumi.set(__self__, "offline_replication_export_path", offline_replication_export_path)
        if offline_replication_import_path is not None:
            pulumi.set(__self__, "offline_replication_import_path", offline_replication_import_path)
        if online_replication_start_time is not None:
            pulumi.set(__self__, "online_replication_start_time", online_replication_start_time)
        if recovery_points is not None:
            pulumi.set(__self__, "recovery_points", recovery_points)
        if replica_deletion is not None:
            pulumi.set(__self__, "replica_deletion", replica_deletion)
        if replication_frequency_in_seconds is not None:
            pulumi.set(__self__, "replication_frequency_in_seconds", replication_frequency_in_seconds)
        if replication_port is not None:
            pulumi.set(__self__, "replication_port", replication_port)

    @property
    @pulumi.getter(name="allowedAuthenticationType")
    def allowed_authentication_type(self) -> Optional[pulumi.Input[int]]:
        """
        A value indicating the authentication type.
        """
        return pulumi.get(self, "allowed_authentication_type")

    @allowed_authentication_type.setter
    def allowed_authentication_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allowed_authentication_type", value)

    @property
    @pulumi.getter(name="applicationConsistentSnapshotFrequencyInHours")
    def application_consistent_snapshot_frequency_in_hours(self) -> Optional[pulumi.Input[int]]:
        """
        A value indicating the application consistent frequency.
        """
        return pulumi.get(self, "application_consistent_snapshot_frequency_in_hours")

    @application_consistent_snapshot_frequency_in_hours.setter
    def application_consistent_snapshot_frequency_in_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "application_consistent_snapshot_frequency_in_hours", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[str]]:
        """
        A value indicating whether compression has to be enabled.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter(name="initialReplicationMethod")
    def initial_replication_method(self) -> Optional[pulumi.Input[str]]:
        """
        A value indicating whether IR is online.
        """
        return pulumi.get(self, "initial_replication_method")

    @initial_replication_method.setter
    def initial_replication_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initial_replication_method", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The class type.
        Expected value is 'HyperVReplica2012R2'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="offlineReplicationExportPath")
    def offline_replication_export_path(self) -> Optional[pulumi.Input[str]]:
        """
        A value indicating the offline IR export path.
        """
        return pulumi.get(self, "offline_replication_export_path")

    @offline_replication_export_path.setter
    def offline_replication_export_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offline_replication_export_path", value)

    @property
    @pulumi.getter(name="offlineReplicationImportPath")
    def offline_replication_import_path(self) -> Optional[pulumi.Input[str]]:
        """
        A value indicating the offline IR import path.
        """
        return pulumi.get(self, "offline_replication_import_path")

    @offline_replication_import_path.setter
    def offline_replication_import_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offline_replication_import_path", value)

    @property
    @pulumi.getter(name="onlineReplicationStartTime")
    def online_replication_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        A value indicating the online IR start time.
        """
        return pulumi.get(self, "online_replication_start_time")

    @online_replication_start_time.setter
    def online_replication_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "online_replication_start_time", value)

    @property
    @pulumi.getter(name="recoveryPoints")
    def recovery_points(self) -> Optional[pulumi.Input[int]]:
        """
        A value indicating the number of recovery points.
        """
        return pulumi.get(self, "recovery_points")

    @recovery_points.setter
    def recovery_points(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_points", value)

    @property
    @pulumi.getter(name="replicaDeletion")
    def replica_deletion(self) -> Optional[pulumi.Input[str]]:
        """
        A value indicating whether the VM has to be auto deleted.
        """
        return pulumi.get(self, "replica_deletion")

    @replica_deletion.setter
    def replica_deletion(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_deletion", value)

    @property
    @pulumi.getter(name="replicationFrequencyInSeconds")
    def replication_frequency_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        A value indicating the replication interval.
        """
        return pulumi.get(self, "replication_frequency_in_seconds")

    @replication_frequency_in_seconds.setter
    def replication_frequency_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replication_frequency_in_seconds", value)

    @property
    @pulumi.getter(name="replicationPort")
    def replication_port(self) -> Optional[pulumi.Input[int]]:
        """
        A value indicating the recovery HTTPS port.
        """
        return pulumi.get(self, "replication_port")

    @replication_port.setter
    def replication_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replication_port", value)


@pulumi.input_type
class HyperVReplicaPolicyInputArgs:
    def __init__(__self__, *,
                 allowed_authentication_type: Optional[pulumi.Input[int]] = None,
                 application_consistent_snapshot_frequency_in_hours: Optional[pulumi.Input[int]] = None,
                 compression: Optional[pulumi.Input[str]] = None,
                 initial_replication_method: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 offline_replication_export_path: Optional[pulumi.Input[str]] = None,
                 offline_replication_import_path: Optional[pulumi.Input[str]] = None,
                 online_replication_start_time: Optional[pulumi.Input[str]] = None,
                 recovery_points: Optional[pulumi.Input[int]] = None,
                 replica_deletion: Optional[pulumi.Input[str]] = None,
                 replication_port: Optional[pulumi.Input[int]] = None):
        """
        Hyper-V Replica specific policy Input.
        :param pulumi.Input[int] allowed_authentication_type: A value indicating the authentication type.
        :param pulumi.Input[int] application_consistent_snapshot_frequency_in_hours: A value indicating the application consistent frequency.
        :param pulumi.Input[str] compression: A value indicating whether compression has to be enabled.
        :param pulumi.Input[str] initial_replication_method: A value indicating whether IR is online.
        :param pulumi.Input[str] instance_type: The class type.
               Expected value is 'HyperVReplica2012'.
        :param pulumi.Input[str] offline_replication_export_path: A value indicating the offline IR export path.
        :param pulumi.Input[str] offline_replication_import_path: A value indicating the offline IR import path.
        :param pulumi.Input[str] online_replication_start_time: A value indicating the online IR start time.
        :param pulumi.Input[int] recovery_points: A value indicating the number of recovery points.
        :param pulumi.Input[str] replica_deletion: A value indicating whether the VM has to be auto deleted.
        :param pulumi.Input[int] replication_port: A value indicating the recovery HTTPS port.
        """
        if allowed_authentication_type is not None:
            pulumi.set(__self__, "allowed_authentication_type", allowed_authentication_type)
        if application_consistent_snapshot_frequency_in_hours is not None:
            pulumi.set(__self__, "application_consistent_snapshot_frequency_in_hours", application_consistent_snapshot_frequency_in_hours)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if initial_replication_method is not None:
            pulumi.set(__self__, "initial_replication_method", initial_replication_method)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'HyperVReplica2012')
        if offline_replication_export_path is not None:
            pulumi.set(__self__, "offline_replication_export_path", offline_replication_export_path)
        if offline_replication_import_path is not None:
            pulumi.set(__self__, "offline_replication_import_path", offline_replication_import_path)
        if online_replication_start_time is not None:
            pulumi.set(__self__, "online_replication_start_time", online_replication_start_time)
        if recovery_points is not None:
            pulumi.set(__self__, "recovery_points", recovery_points)
        if replica_deletion is not None:
            pulumi.set(__self__, "replica_deletion", replica_deletion)
        if replication_port is not None:
            pulumi.set(__self__, "replication_port", replication_port)

    @property
    @pulumi.getter(name="allowedAuthenticationType")
    def allowed_authentication_type(self) -> Optional[pulumi.Input[int]]:
        """
        A value indicating the authentication type.
        """
        return pulumi.get(self, "allowed_authentication_type")

    @allowed_authentication_type.setter
    def allowed_authentication_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allowed_authentication_type", value)

    @property
    @pulumi.getter(name="applicationConsistentSnapshotFrequencyInHours")
    def application_consistent_snapshot_frequency_in_hours(self) -> Optional[pulumi.Input[int]]:
        """
        A value indicating the application consistent frequency.
        """
        return pulumi.get(self, "application_consistent_snapshot_frequency_in_hours")

    @application_consistent_snapshot_frequency_in_hours.setter
    def application_consistent_snapshot_frequency_in_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "application_consistent_snapshot_frequency_in_hours", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[str]]:
        """
        A value indicating whether compression has to be enabled.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter(name="initialReplicationMethod")
    def initial_replication_method(self) -> Optional[pulumi.Input[str]]:
        """
        A value indicating whether IR is online.
        """
        return pulumi.get(self, "initial_replication_method")

    @initial_replication_method.setter
    def initial_replication_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initial_replication_method", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The class type.
        Expected value is 'HyperVReplica2012'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="offlineReplicationExportPath")
    def offline_replication_export_path(self) -> Optional[pulumi.Input[str]]:
        """
        A value indicating the offline IR export path.
        """
        return pulumi.get(self, "offline_replication_export_path")

    @offline_replication_export_path.setter
    def offline_replication_export_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offline_replication_export_path", value)

    @property
    @pulumi.getter(name="offlineReplicationImportPath")
    def offline_replication_import_path(self) -> Optional[pulumi.Input[str]]:
        """
        A value indicating the offline IR import path.
        """
        return pulumi.get(self, "offline_replication_import_path")

    @offline_replication_import_path.setter
    def offline_replication_import_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offline_replication_import_path", value)

    @property
    @pulumi.getter(name="onlineReplicationStartTime")
    def online_replication_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        A value indicating the online IR start time.
        """
        return pulumi.get(self, "online_replication_start_time")

    @online_replication_start_time.setter
    def online_replication_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "online_replication_start_time", value)

    @property
    @pulumi.getter(name="recoveryPoints")
    def recovery_points(self) -> Optional[pulumi.Input[int]]:
        """
        A value indicating the number of recovery points.
        """
        return pulumi.get(self, "recovery_points")

    @recovery_points.setter
    def recovery_points(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_points", value)

    @property
    @pulumi.getter(name="replicaDeletion")
    def replica_deletion(self) -> Optional[pulumi.Input[str]]:
        """
        A value indicating whether the VM has to be auto deleted.
        """
        return pulumi.get(self, "replica_deletion")

    @replica_deletion.setter
    def replica_deletion(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_deletion", value)

    @property
    @pulumi.getter(name="replicationPort")
    def replication_port(self) -> Optional[pulumi.Input[int]]:
        """
        A value indicating the recovery HTTPS port.
        """
        return pulumi.get(self, "replication_port")

    @replication_port.setter
    def replication_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replication_port", value)


@pulumi.input_type
class IdentityProviderInputArgs:
    def __init__(__self__, *,
                 aad_authority: pulumi.Input[str],
                 application_id: pulumi.Input[str],
                 audience: pulumi.Input[str],
                 object_id: pulumi.Input[str],
                 tenant_id: pulumi.Input[str]):
        """
        Identity provider input.
        :param pulumi.Input[str] aad_authority: The base authority for Azure Active Directory authentication.
        :param pulumi.Input[str] application_id: The application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        :param pulumi.Input[str] audience: The intended Audience of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        :param pulumi.Input[str] object_id: The object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        :param pulumi.Input[str] tenant_id: The tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        pulumi.set(__self__, "aad_authority", aad_authority)
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="aadAuthority")
    def aad_authority(self) -> pulumi.Input[str]:
        """
        The base authority for Azure Active Directory authentication.
        """
        return pulumi.get(self, "aad_authority")

    @aad_authority.setter
    def aad_authority(self, value: pulumi.Input[str]):
        pulumi.set(self, "aad_authority", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[str]:
        """
        The application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def audience(self) -> pulumi.Input[str]:
        """
        The intended Audience of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: pulumi.Input[str]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Input[str]:
        """
        The object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class InMageAzureV2EnableProtectionInputArgs:
    def __init__(__self__, *,
                 storage_account_id: pulumi.Input[str],
                 disks_to_include: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_rdp_on_target_option: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 log_storage_account_id: Optional[pulumi.Input[str]] = None,
                 master_target_id: Optional[pulumi.Input[str]] = None,
                 multi_vm_group_id: Optional[pulumi.Input[str]] = None,
                 multi_vm_group_name: Optional[pulumi.Input[str]] = None,
                 process_server_id: Optional[pulumi.Input[str]] = None,
                 run_as_account_id: Optional[pulumi.Input[str]] = None,
                 target_azure_network_id: Optional[pulumi.Input[str]] = None,
                 target_azure_subnet_id: Optional[pulumi.Input[str]] = None,
                 target_azure_v1_resource_group_id: Optional[pulumi.Input[str]] = None,
                 target_azure_v2_resource_group_id: Optional[pulumi.Input[str]] = None,
                 target_azure_vm_name: Optional[pulumi.Input[str]] = None,
                 use_managed_disks: Optional[pulumi.Input[str]] = None):
        """
        VMware Azure specific enable protection input.
        :param pulumi.Input[str] storage_account_id: The storage account name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disks_to_include: The disks to include list.
        :param pulumi.Input[str] enable_rdp_on_target_option: The selected option to enable RDP\\SSH on target vm after failover. String value of {SrsDataContract.EnableRDPOnTargetOption} enum.
        :param pulumi.Input[str] instance_type: The class type.
               Expected value is 'InMageAzureV2'.
        :param pulumi.Input[str] log_storage_account_id: The storage account to be used for logging during replication.
        :param pulumi.Input[str] master_target_id: The Master target Id.
        :param pulumi.Input[str] multi_vm_group_id: The multi vm group Id.
        :param pulumi.Input[str] multi_vm_group_name: The multi vm group name.
        :param pulumi.Input[str] process_server_id: The Process Server Id.
        :param pulumi.Input[str] run_as_account_id: The CS account Id.
        :param pulumi.Input[str] target_azure_network_id: The selected target Azure network Id.
        :param pulumi.Input[str] target_azure_subnet_id: The selected target Azure subnet Id.
        :param pulumi.Input[str] target_azure_v1_resource_group_id: The Id of the target resource group (for classic deployment) in which the failover VM is to be created.
        :param pulumi.Input[str] target_azure_v2_resource_group_id: The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created.
        :param pulumi.Input[str] target_azure_vm_name: The target azure Vm Name.
        :param pulumi.Input[str] use_managed_disks: A value indicating whether managed disks should be used during failover.
        """
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if disks_to_include is not None:
            pulumi.set(__self__, "disks_to_include", disks_to_include)
        if enable_rdp_on_target_option is not None:
            pulumi.set(__self__, "enable_rdp_on_target_option", enable_rdp_on_target_option)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'InMageAzureV2')
        if log_storage_account_id is not None:
            pulumi.set(__self__, "log_storage_account_id", log_storage_account_id)
        if master_target_id is not None:
            pulumi.set(__self__, "master_target_id", master_target_id)
        if multi_vm_group_id is not None:
            pulumi.set(__self__, "multi_vm_group_id", multi_vm_group_id)
        if multi_vm_group_name is not None:
            pulumi.set(__self__, "multi_vm_group_name", multi_vm_group_name)
        if process_server_id is not None:
            pulumi.set(__self__, "process_server_id", process_server_id)
        if run_as_account_id is not None:
            pulumi.set(__self__, "run_as_account_id", run_as_account_id)
        if target_azure_network_id is not None:
            pulumi.set(__self__, "target_azure_network_id", target_azure_network_id)
        if target_azure_subnet_id is not None:
            pulumi.set(__self__, "target_azure_subnet_id", target_azure_subnet_id)
        if target_azure_v1_resource_group_id is not None:
            pulumi.set(__self__, "target_azure_v1_resource_group_id", target_azure_v1_resource_group_id)
        if target_azure_v2_resource_group_id is not None:
            pulumi.set(__self__, "target_azure_v2_resource_group_id", target_azure_v2_resource_group_id)
        if target_azure_vm_name is not None:
            pulumi.set(__self__, "target_azure_vm_name", target_azure_vm_name)
        if use_managed_disks is not None:
            pulumi.set(__self__, "use_managed_disks", use_managed_disks)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[str]:
        """
        The storage account name.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_account_id", value)

    @property
    @pulumi.getter(name="disksToInclude")
    def disks_to_include(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The disks to include list.
        """
        return pulumi.get(self, "disks_to_include")

    @disks_to_include.setter
    def disks_to_include(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "disks_to_include", value)

    @property
    @pulumi.getter(name="enableRdpOnTargetOption")
    def enable_rdp_on_target_option(self) -> Optional[pulumi.Input[str]]:
        """
        The selected option to enable RDP\\SSH on target vm after failover. String value of {SrsDataContract.EnableRDPOnTargetOption} enum.
        """
        return pulumi.get(self, "enable_rdp_on_target_option")

    @enable_rdp_on_target_option.setter
    def enable_rdp_on_target_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_rdp_on_target_option", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The class type.
        Expected value is 'InMageAzureV2'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="logStorageAccountId")
    def log_storage_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The storage account to be used for logging during replication.
        """
        return pulumi.get(self, "log_storage_account_id")

    @log_storage_account_id.setter
    def log_storage_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_storage_account_id", value)

    @property
    @pulumi.getter(name="masterTargetId")
    def master_target_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Master target Id.
        """
        return pulumi.get(self, "master_target_id")

    @master_target_id.setter
    def master_target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_target_id", value)

    @property
    @pulumi.getter(name="multiVmGroupId")
    def multi_vm_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The multi vm group Id.
        """
        return pulumi.get(self, "multi_vm_group_id")

    @multi_vm_group_id.setter
    def multi_vm_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_vm_group_id", value)

    @property
    @pulumi.getter(name="multiVmGroupName")
    def multi_vm_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The multi vm group name.
        """
        return pulumi.get(self, "multi_vm_group_name")

    @multi_vm_group_name.setter
    def multi_vm_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_vm_group_name", value)

    @property
    @pulumi.getter(name="processServerId")
    def process_server_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Process Server Id.
        """
        return pulumi.get(self, "process_server_id")

    @process_server_id.setter
    def process_server_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "process_server_id", value)

    @property
    @pulumi.getter(name="runAsAccountId")
    def run_as_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The CS account Id.
        """
        return pulumi.get(self, "run_as_account_id")

    @run_as_account_id.setter
    def run_as_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_as_account_id", value)

    @property
    @pulumi.getter(name="targetAzureNetworkId")
    def target_azure_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The selected target Azure network Id.
        """
        return pulumi.get(self, "target_azure_network_id")

    @target_azure_network_id.setter
    def target_azure_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_azure_network_id", value)

    @property
    @pulumi.getter(name="targetAzureSubnetId")
    def target_azure_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The selected target Azure subnet Id.
        """
        return pulumi.get(self, "target_azure_subnet_id")

    @target_azure_subnet_id.setter
    def target_azure_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_azure_subnet_id", value)

    @property
    @pulumi.getter(name="targetAzureV1ResourceGroupId")
    def target_azure_v1_resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the target resource group (for classic deployment) in which the failover VM is to be created.
        """
        return pulumi.get(self, "target_azure_v1_resource_group_id")

    @target_azure_v1_resource_group_id.setter
    def target_azure_v1_resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_azure_v1_resource_group_id", value)

    @property
    @pulumi.getter(name="targetAzureV2ResourceGroupId")
    def target_azure_v2_resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created.
        """
        return pulumi.get(self, "target_azure_v2_resource_group_id")

    @target_azure_v2_resource_group_id.setter
    def target_azure_v2_resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_azure_v2_resource_group_id", value)

    @property
    @pulumi.getter(name="targetAzureVmName")
    def target_azure_vm_name(self) -> Optional[pulumi.Input[str]]:
        """
        The target azure Vm Name.
        """
        return pulumi.get(self, "target_azure_vm_name")

    @target_azure_vm_name.setter
    def target_azure_vm_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_azure_vm_name", value)

    @property
    @pulumi.getter(name="useManagedDisks")
    def use_managed_disks(self) -> Optional[pulumi.Input[str]]:
        """
        A value indicating whether managed disks should be used during failover.
        """
        return pulumi.get(self, "use_managed_disks")

    @use_managed_disks.setter
    def use_managed_disks(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "use_managed_disks", value)


@pulumi.input_type
class InMageAzureV2PolicyInputArgs:
    def __init__(__self__, *,
                 multi_vm_sync_status: pulumi.Input[Union[str, 'SetMultiVmSyncStatus']],
                 app_consistent_frequency_in_minutes: Optional[pulumi.Input[int]] = None,
                 crash_consistent_frequency_in_minutes: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 recovery_point_history: Optional[pulumi.Input[int]] = None,
                 recovery_point_threshold_in_minutes: Optional[pulumi.Input[int]] = None):
        """
        VMWare Azure specific policy Input.
        :param pulumi.Input[Union[str, 'SetMultiVmSyncStatus']] multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
        :param pulumi.Input[int] app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in minutes).
        :param pulumi.Input[int] crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in minutes).
        :param pulumi.Input[str] instance_type: The class type.
               Expected value is 'InMageAzureV2'.
        :param pulumi.Input[int] recovery_point_history: The duration in minutes until which the recovery points need to be stored.
        :param pulumi.Input[int] recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
        """
        pulumi.set(__self__, "multi_vm_sync_status", multi_vm_sync_status)
        if app_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "app_consistent_frequency_in_minutes", app_consistent_frequency_in_minutes)
        if crash_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "crash_consistent_frequency_in_minutes", crash_consistent_frequency_in_minutes)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'InMageAzureV2')
        if recovery_point_history is not None:
            pulumi.set(__self__, "recovery_point_history", recovery_point_history)
        if recovery_point_threshold_in_minutes is not None:
            pulumi.set(__self__, "recovery_point_threshold_in_minutes", recovery_point_threshold_in_minutes)

    @property
    @pulumi.getter(name="multiVmSyncStatus")
    def multi_vm_sync_status(self) -> pulumi.Input[Union[str, 'SetMultiVmSyncStatus']]:
        """
        A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
        """
        return pulumi.get(self, "multi_vm_sync_status")

    @multi_vm_sync_status.setter
    def multi_vm_sync_status(self, value: pulumi.Input[Union[str, 'SetMultiVmSyncStatus']]):
        pulumi.set(self, "multi_vm_sync_status", value)

    @property
    @pulumi.getter(name="appConsistentFrequencyInMinutes")
    def app_consistent_frequency_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The app consistent snapshot frequency (in minutes).
        """
        return pulumi.get(self, "app_consistent_frequency_in_minutes")

    @app_consistent_frequency_in_minutes.setter
    def app_consistent_frequency_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "app_consistent_frequency_in_minutes", value)

    @property
    @pulumi.getter(name="crashConsistentFrequencyInMinutes")
    def crash_consistent_frequency_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The crash consistent snapshot frequency (in minutes).
        """
        return pulumi.get(self, "crash_consistent_frequency_in_minutes")

    @crash_consistent_frequency_in_minutes.setter
    def crash_consistent_frequency_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "crash_consistent_frequency_in_minutes", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The class type.
        Expected value is 'InMageAzureV2'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="recoveryPointHistory")
    def recovery_point_history(self) -> Optional[pulumi.Input[int]]:
        """
        The duration in minutes until which the recovery points need to be stored.
        """
        return pulumi.get(self, "recovery_point_history")

    @recovery_point_history.setter
    def recovery_point_history(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_history", value)

    @property
    @pulumi.getter(name="recoveryPointThresholdInMinutes")
    def recovery_point_threshold_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The recovery point threshold in minutes.
        """
        return pulumi.get(self, "recovery_point_threshold_in_minutes")

    @recovery_point_threshold_in_minutes.setter
    def recovery_point_threshold_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_threshold_in_minutes", value)


@pulumi.input_type
class InMageDiskExclusionInputArgs:
    def __init__(__self__, *,
                 disk_signature_options: Optional[pulumi.Input[Sequence[pulumi.Input['InMageDiskSignatureExclusionOptionsArgs']]]] = None,
                 volume_options: Optional[pulumi.Input[Sequence[pulumi.Input['InMageVolumeExclusionOptionsArgs']]]] = None):
        """
        DiskExclusionInput when doing enable protection of virtual machine in InMage provider.
        :param pulumi.Input[Sequence[pulumi.Input['InMageDiskSignatureExclusionOptionsArgs']]] disk_signature_options: The guest disk signature based option for disk exclusion.
        :param pulumi.Input[Sequence[pulumi.Input['InMageVolumeExclusionOptionsArgs']]] volume_options: The volume label based option for disk exclusion.
        """
        if disk_signature_options is not None:
            pulumi.set(__self__, "disk_signature_options", disk_signature_options)
        if volume_options is not None:
            pulumi.set(__self__, "volume_options", volume_options)

    @property
    @pulumi.getter(name="diskSignatureOptions")
    def disk_signature_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InMageDiskSignatureExclusionOptionsArgs']]]]:
        """
        The guest disk signature based option for disk exclusion.
        """
        return pulumi.get(self, "disk_signature_options")

    @disk_signature_options.setter
    def disk_signature_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InMageDiskSignatureExclusionOptionsArgs']]]]):
        pulumi.set(self, "disk_signature_options", value)

    @property
    @pulumi.getter(name="volumeOptions")
    def volume_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InMageVolumeExclusionOptionsArgs']]]]:
        """
        The volume label based option for disk exclusion.
        """
        return pulumi.get(self, "volume_options")

    @volume_options.setter
    def volume_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InMageVolumeExclusionOptionsArgs']]]]):
        pulumi.set(self, "volume_options", value)


@pulumi.input_type
class InMageDiskSignatureExclusionOptionsArgs:
    def __init__(__self__, *,
                 disk_signature: Optional[pulumi.Input[str]] = None):
        """
        Guest disk signature based disk exclusion option when doing enable protection of virtual machine in InMage provider.
        :param pulumi.Input[str] disk_signature: The guest signature of disk to be excluded from replication.
        """
        if disk_signature is not None:
            pulumi.set(__self__, "disk_signature", disk_signature)

    @property
    @pulumi.getter(name="diskSignature")
    def disk_signature(self) -> Optional[pulumi.Input[str]]:
        """
        The guest signature of disk to be excluded from replication.
        """
        return pulumi.get(self, "disk_signature")

    @disk_signature.setter
    def disk_signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_signature", value)


@pulumi.input_type
class InMageEnableProtectionInputArgs:
    def __init__(__self__, *,
                 master_target_id: pulumi.Input[str],
                 multi_vm_group_id: pulumi.Input[str],
                 multi_vm_group_name: pulumi.Input[str],
                 process_server_id: pulumi.Input[str],
                 retention_drive: pulumi.Input[str],
                 datastore_name: Optional[pulumi.Input[str]] = None,
                 disk_exclusion_input: Optional[pulumi.Input['InMageDiskExclusionInputArgs']] = None,
                 disks_to_include: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 run_as_account_id: Optional[pulumi.Input[str]] = None,
                 vm_friendly_name: Optional[pulumi.Input[str]] = None):
        """
        VMware Azure specific enable protection input.
        :param pulumi.Input[str] master_target_id: The Master Target Id.
        :param pulumi.Input[str] multi_vm_group_id: The multi vm group Id.
        :param pulumi.Input[str] multi_vm_group_name: The multi vm group name.
        :param pulumi.Input[str] process_server_id: The Process Server Id.
        :param pulumi.Input[str] retention_drive: The retention drive to use on the MT.
        :param pulumi.Input[str] datastore_name: The target data store name.
        :param pulumi.Input['InMageDiskExclusionInputArgs'] disk_exclusion_input: The enable disk exclusion input.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disks_to_include: The disks to include list.
        :param pulumi.Input[str] instance_type: The class type.
               Expected value is 'InMage'.
        :param pulumi.Input[str] run_as_account_id: The CS account Id.
        :param pulumi.Input[str] vm_friendly_name: The Vm Name.
        """
        pulumi.set(__self__, "master_target_id", master_target_id)
        pulumi.set(__self__, "multi_vm_group_id", multi_vm_group_id)
        pulumi.set(__self__, "multi_vm_group_name", multi_vm_group_name)
        pulumi.set(__self__, "process_server_id", process_server_id)
        pulumi.set(__self__, "retention_drive", retention_drive)
        if datastore_name is not None:
            pulumi.set(__self__, "datastore_name", datastore_name)
        if disk_exclusion_input is not None:
            pulumi.set(__self__, "disk_exclusion_input", disk_exclusion_input)
        if disks_to_include is not None:
            pulumi.set(__self__, "disks_to_include", disks_to_include)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'InMage')
        if run_as_account_id is not None:
            pulumi.set(__self__, "run_as_account_id", run_as_account_id)
        if vm_friendly_name is not None:
            pulumi.set(__self__, "vm_friendly_name", vm_friendly_name)

    @property
    @pulumi.getter(name="masterTargetId")
    def master_target_id(self) -> pulumi.Input[str]:
        """
        The Master Target Id.
        """
        return pulumi.get(self, "master_target_id")

    @master_target_id.setter
    def master_target_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "master_target_id", value)

    @property
    @pulumi.getter(name="multiVmGroupId")
    def multi_vm_group_id(self) -> pulumi.Input[str]:
        """
        The multi vm group Id.
        """
        return pulumi.get(self, "multi_vm_group_id")

    @multi_vm_group_id.setter
    def multi_vm_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "multi_vm_group_id", value)

    @property
    @pulumi.getter(name="multiVmGroupName")
    def multi_vm_group_name(self) -> pulumi.Input[str]:
        """
        The multi vm group name.
        """
        return pulumi.get(self, "multi_vm_group_name")

    @multi_vm_group_name.setter
    def multi_vm_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "multi_vm_group_name", value)

    @property
    @pulumi.getter(name="processServerId")
    def process_server_id(self) -> pulumi.Input[str]:
        """
        The Process Server Id.
        """
        return pulumi.get(self, "process_server_id")

    @process_server_id.setter
    def process_server_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "process_server_id", value)

    @property
    @pulumi.getter(name="retentionDrive")
    def retention_drive(self) -> pulumi.Input[str]:
        """
        The retention drive to use on the MT.
        """
        return pulumi.get(self, "retention_drive")

    @retention_drive.setter
    def retention_drive(self, value: pulumi.Input[str]):
        pulumi.set(self, "retention_drive", value)

    @property
    @pulumi.getter(name="datastoreName")
    def datastore_name(self) -> Optional[pulumi.Input[str]]:
        """
        The target data store name.
        """
        return pulumi.get(self, "datastore_name")

    @datastore_name.setter
    def datastore_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datastore_name", value)

    @property
    @pulumi.getter(name="diskExclusionInput")
    def disk_exclusion_input(self) -> Optional[pulumi.Input['InMageDiskExclusionInputArgs']]:
        """
        The enable disk exclusion input.
        """
        return pulumi.get(self, "disk_exclusion_input")

    @disk_exclusion_input.setter
    def disk_exclusion_input(self, value: Optional[pulumi.Input['InMageDiskExclusionInputArgs']]):
        pulumi.set(self, "disk_exclusion_input", value)

    @property
    @pulumi.getter(name="disksToInclude")
    def disks_to_include(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The disks to include list.
        """
        return pulumi.get(self, "disks_to_include")

    @disks_to_include.setter
    def disks_to_include(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "disks_to_include", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The class type.
        Expected value is 'InMage'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="runAsAccountId")
    def run_as_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The CS account Id.
        """
        return pulumi.get(self, "run_as_account_id")

    @run_as_account_id.setter
    def run_as_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_as_account_id", value)

    @property
    @pulumi.getter(name="vmFriendlyName")
    def vm_friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Vm Name.
        """
        return pulumi.get(self, "vm_friendly_name")

    @vm_friendly_name.setter
    def vm_friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_friendly_name", value)


@pulumi.input_type
class InMagePolicyInputArgs:
    def __init__(__self__, *,
                 multi_vm_sync_status: pulumi.Input[Union[str, 'SetMultiVmSyncStatus']],
                 app_consistent_frequency_in_minutes: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 recovery_point_history: Optional[pulumi.Input[int]] = None,
                 recovery_point_threshold_in_minutes: Optional[pulumi.Input[int]] = None):
        """
        VMWare Azure specific protection profile Input.
        :param pulumi.Input[Union[str, 'SetMultiVmSyncStatus']] multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
        :param pulumi.Input[int] app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in minutes).
        :param pulumi.Input[str] instance_type: The class type.
               Expected value is 'InMage'.
        :param pulumi.Input[int] recovery_point_history: The duration in minutes until which the recovery points need to be stored.
        :param pulumi.Input[int] recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
        """
        pulumi.set(__self__, "multi_vm_sync_status", multi_vm_sync_status)
        if app_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "app_consistent_frequency_in_minutes", app_consistent_frequency_in_minutes)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'InMage')
        if recovery_point_history is not None:
            pulumi.set(__self__, "recovery_point_history", recovery_point_history)
        if recovery_point_threshold_in_minutes is not None:
            pulumi.set(__self__, "recovery_point_threshold_in_minutes", recovery_point_threshold_in_minutes)

    @property
    @pulumi.getter(name="multiVmSyncStatus")
    def multi_vm_sync_status(self) -> pulumi.Input[Union[str, 'SetMultiVmSyncStatus']]:
        """
        A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
        """
        return pulumi.get(self, "multi_vm_sync_status")

    @multi_vm_sync_status.setter
    def multi_vm_sync_status(self, value: pulumi.Input[Union[str, 'SetMultiVmSyncStatus']]):
        pulumi.set(self, "multi_vm_sync_status", value)

    @property
    @pulumi.getter(name="appConsistentFrequencyInMinutes")
    def app_consistent_frequency_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The app consistent snapshot frequency (in minutes).
        """
        return pulumi.get(self, "app_consistent_frequency_in_minutes")

    @app_consistent_frequency_in_minutes.setter
    def app_consistent_frequency_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "app_consistent_frequency_in_minutes", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The class type.
        Expected value is 'InMage'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="recoveryPointHistory")
    def recovery_point_history(self) -> Optional[pulumi.Input[int]]:
        """
        The duration in minutes until which the recovery points need to be stored.
        """
        return pulumi.get(self, "recovery_point_history")

    @recovery_point_history.setter
    def recovery_point_history(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_history", value)

    @property
    @pulumi.getter(name="recoveryPointThresholdInMinutes")
    def recovery_point_threshold_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The recovery point threshold in minutes.
        """
        return pulumi.get(self, "recovery_point_threshold_in_minutes")

    @recovery_point_threshold_in_minutes.setter
    def recovery_point_threshold_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_threshold_in_minutes", value)


@pulumi.input_type
class InMageVolumeExclusionOptionsArgs:
    def __init__(__self__, *,
                 only_exclude_if_single_volume: Optional[pulumi.Input[str]] = None,
                 volume_label: Optional[pulumi.Input[str]] = None):
        """
        Guest disk signature based disk exclusion option when doing enable protection of virtual machine in InMage provider.
        :param pulumi.Input[str] only_exclude_if_single_volume: The value indicating whether to exclude multi volume disk or not. If a disk has multiple volumes and one of the volume has label matching with VolumeLabel this disk will be excluded from replication if OnlyExcludeIfSingleVolume is false.
        :param pulumi.Input[str] volume_label: The volume label. The disk having any volume with this label will be excluded from replication.
        """
        if only_exclude_if_single_volume is not None:
            pulumi.set(__self__, "only_exclude_if_single_volume", only_exclude_if_single_volume)
        if volume_label is not None:
            pulumi.set(__self__, "volume_label", volume_label)

    @property
    @pulumi.getter(name="onlyExcludeIfSingleVolume")
    def only_exclude_if_single_volume(self) -> Optional[pulumi.Input[str]]:
        """
        The value indicating whether to exclude multi volume disk or not. If a disk has multiple volumes and one of the volume has label matching with VolumeLabel this disk will be excluded from replication if OnlyExcludeIfSingleVolume is false.
        """
        return pulumi.get(self, "only_exclude_if_single_volume")

    @only_exclude_if_single_volume.setter
    def only_exclude_if_single_volume(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "only_exclude_if_single_volume", value)

    @property
    @pulumi.getter(name="volumeLabel")
    def volume_label(self) -> Optional[pulumi.Input[str]]:
        """
        The volume label. The disk having any volume with this label will be excluded from replication.
        """
        return pulumi.get(self, "volume_label")

    @volume_label.setter
    def volume_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_label", value)


@pulumi.input_type
class KeyEncryptionKeyInfoArgs:
    def __init__(__self__, *,
                 key_identifier: Optional[pulumi.Input[str]] = None,
                 key_vault_resource_arm_id: Optional[pulumi.Input[str]] = None):
        """
        Key Encryption Key (KEK) information.
        :param pulumi.Input[str] key_identifier: The key url / identifier.
        :param pulumi.Input[str] key_vault_resource_arm_id: The KeyVault resource ARM id for key.
        """
        if key_identifier is not None:
            pulumi.set(__self__, "key_identifier", key_identifier)
        if key_vault_resource_arm_id is not None:
            pulumi.set(__self__, "key_vault_resource_arm_id", key_vault_resource_arm_id)

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The key url / identifier.
        """
        return pulumi.get(self, "key_identifier")

    @key_identifier.setter
    def key_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_identifier", value)

    @property
    @pulumi.getter(name="keyVaultResourceArmId")
    def key_vault_resource_arm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The KeyVault resource ARM id for key.
        """
        return pulumi.get(self, "key_vault_resource_arm_id")

    @key_vault_resource_arm_id.setter
    def key_vault_resource_arm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_resource_arm_id", value)


@pulumi.input_type
class RecoveryPlanActionArgs:
    def __init__(__self__, *,
                 action_name: pulumi.Input[str],
                 failover_directions: pulumi.Input[Sequence[pulumi.Input[Union[str, 'PossibleOperationsDirections']]]],
                 failover_types: pulumi.Input[Sequence[pulumi.Input[Union[str, 'ReplicationProtectedItemOperation']]]]):
        """
        Recovery plan action details.
        :param pulumi.Input[str] action_name: The action name.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'PossibleOperationsDirections']]]] failover_directions: The list of failover directions.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'ReplicationProtectedItemOperation']]]] failover_types: The list of failover types.
        """
        pulumi.set(__self__, "action_name", action_name)
        pulumi.set(__self__, "failover_directions", failover_directions)
        pulumi.set(__self__, "failover_types", failover_types)

    @property
    @pulumi.getter(name="actionName")
    def action_name(self) -> pulumi.Input[str]:
        """
        The action name.
        """
        return pulumi.get(self, "action_name")

    @action_name.setter
    def action_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_name", value)

    @property
    @pulumi.getter(name="failoverDirections")
    def failover_directions(self) -> pulumi.Input[Sequence[pulumi.Input[Union[str, 'PossibleOperationsDirections']]]]:
        """
        The list of failover directions.
        """
        return pulumi.get(self, "failover_directions")

    @failover_directions.setter
    def failover_directions(self, value: pulumi.Input[Sequence[pulumi.Input[Union[str, 'PossibleOperationsDirections']]]]):
        pulumi.set(self, "failover_directions", value)

    @property
    @pulumi.getter(name="failoverTypes")
    def failover_types(self) -> pulumi.Input[Sequence[pulumi.Input[Union[str, 'ReplicationProtectedItemOperation']]]]:
        """
        The list of failover types.
        """
        return pulumi.get(self, "failover_types")

    @failover_types.setter
    def failover_types(self, value: pulumi.Input[Sequence[pulumi.Input[Union[str, 'ReplicationProtectedItemOperation']]]]):
        pulumi.set(self, "failover_types", value)


@pulumi.input_type
class RecoveryPlanGroupArgs:
    def __init__(__self__, *,
                 group_type: pulumi.Input[Union[str, 'RecoveryPlanGroupType']],
                 end_group_actions: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPlanActionArgs']]]] = None,
                 replication_protected_items: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPlanProtectedItemArgs']]]] = None,
                 start_group_actions: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPlanActionArgs']]]] = None):
        """
        Recovery plan group details.
        :param pulumi.Input[Union[str, 'RecoveryPlanGroupType']] group_type: The group type.
        :param pulumi.Input[Sequence[pulumi.Input['RecoveryPlanActionArgs']]] end_group_actions: The end group actions.
        :param pulumi.Input[Sequence[pulumi.Input['RecoveryPlanProtectedItemArgs']]] replication_protected_items: The list of protected items.
        :param pulumi.Input[Sequence[pulumi.Input['RecoveryPlanActionArgs']]] start_group_actions: The start group actions.
        """
        pulumi.set(__self__, "group_type", group_type)
        if end_group_actions is not None:
            pulumi.set(__self__, "end_group_actions", end_group_actions)
        if replication_protected_items is not None:
            pulumi.set(__self__, "replication_protected_items", replication_protected_items)
        if start_group_actions is not None:
            pulumi.set(__self__, "start_group_actions", start_group_actions)

    @property
    @pulumi.getter(name="groupType")
    def group_type(self) -> pulumi.Input[Union[str, 'RecoveryPlanGroupType']]:
        """
        The group type.
        """
        return pulumi.get(self, "group_type")

    @group_type.setter
    def group_type(self, value: pulumi.Input[Union[str, 'RecoveryPlanGroupType']]):
        pulumi.set(self, "group_type", value)

    @property
    @pulumi.getter(name="endGroupActions")
    def end_group_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPlanActionArgs']]]]:
        """
        The end group actions.
        """
        return pulumi.get(self, "end_group_actions")

    @end_group_actions.setter
    def end_group_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPlanActionArgs']]]]):
        pulumi.set(self, "end_group_actions", value)

    @property
    @pulumi.getter(name="replicationProtectedItems")
    def replication_protected_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPlanProtectedItemArgs']]]]:
        """
        The list of protected items.
        """
        return pulumi.get(self, "replication_protected_items")

    @replication_protected_items.setter
    def replication_protected_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPlanProtectedItemArgs']]]]):
        pulumi.set(self, "replication_protected_items", value)

    @property
    @pulumi.getter(name="startGroupActions")
    def start_group_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPlanActionArgs']]]]:
        """
        The start group actions.
        """
        return pulumi.get(self, "start_group_actions")

    @start_group_actions.setter
    def start_group_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPlanActionArgs']]]]):
        pulumi.set(self, "start_group_actions", value)


@pulumi.input_type
class RecoveryPlanProtectedItemArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[str]] = None):
        """
        Recovery plan protected item.
        :param pulumi.Input[str] id: The ARM Id of the recovery plan protected item.
        :param pulumi.Input[str] virtual_machine_id: The virtual machine Id.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARM Id of the recovery plan protected item.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual machine Id.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_id", value)


@pulumi.input_type
class SanEnableProtectionInputArgs:
    def __init__(__self__, *,
                 instance_type: Optional[pulumi.Input[str]] = None):
        """
        San enable protection provider specific input.
        :param pulumi.Input[str] instance_type: The class type.
               Expected value is 'San'.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'San')

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The class type.
        Expected value is 'San'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)


@pulumi.input_type
class StorageMappingInputPropertiesArgs:
    def __init__(__self__, *,
                 target_storage_classification_id: Optional[pulumi.Input[str]] = None):
        """
        Storage mapping input properties.
        :param pulumi.Input[str] target_storage_classification_id: The ID of the storage object.
        """
        if target_storage_classification_id is not None:
            pulumi.set(__self__, "target_storage_classification_id", target_storage_classification_id)

    @property
    @pulumi.getter(name="targetStorageClassificationId")
    def target_storage_classification_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the storage object.
        """
        return pulumi.get(self, "target_storage_classification_id")

    @target_storage_classification_id.setter
    def target_storage_classification_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_storage_classification_id", value)


@pulumi.input_type
class VMwareCbtContainerMappingInputArgs:
    def __init__(__self__, *,
                 key_vault_id: pulumi.Input[str],
                 key_vault_uri: pulumi.Input[str],
                 service_bus_connection_string_secret_name: pulumi.Input[str],
                 storage_account_id: pulumi.Input[str],
                 storage_account_sas_secret_name: pulumi.Input[str],
                 target_location: pulumi.Input[str],
                 instance_type: Optional[pulumi.Input[str]] = None):
        """
        VMwareCbt container mapping input.
        :param pulumi.Input[str] key_vault_id: The target key vault ARM Id.
        :param pulumi.Input[str] key_vault_uri: The target key vault URL.
        :param pulumi.Input[str] service_bus_connection_string_secret_name: The secret name of the service bus connection string.
        :param pulumi.Input[str] storage_account_id: The storage account ARM Id.
        :param pulumi.Input[str] storage_account_sas_secret_name: The secret name of the storage account.
        :param pulumi.Input[str] target_location: The target location.
        :param pulumi.Input[str] instance_type: The class type.
               Expected value is 'VMwareCbt'.
        """
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        pulumi.set(__self__, "key_vault_uri", key_vault_uri)
        pulumi.set(__self__, "service_bus_connection_string_secret_name", service_bus_connection_string_secret_name)
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        pulumi.set(__self__, "storage_account_sas_secret_name", storage_account_sas_secret_name)
        pulumi.set(__self__, "target_location", target_location)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'VMwareCbt')

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> pulumi.Input[str]:
        """
        The target key vault ARM Id.
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_vault_id", value)

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> pulumi.Input[str]:
        """
        The target key vault URL.
        """
        return pulumi.get(self, "key_vault_uri")

    @key_vault_uri.setter
    def key_vault_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_vault_uri", value)

    @property
    @pulumi.getter(name="serviceBusConnectionStringSecretName")
    def service_bus_connection_string_secret_name(self) -> pulumi.Input[str]:
        """
        The secret name of the service bus connection string.
        """
        return pulumi.get(self, "service_bus_connection_string_secret_name")

    @service_bus_connection_string_secret_name.setter
    def service_bus_connection_string_secret_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_bus_connection_string_secret_name", value)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[str]:
        """
        The storage account ARM Id.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_account_id", value)

    @property
    @pulumi.getter(name="storageAccountSasSecretName")
    def storage_account_sas_secret_name(self) -> pulumi.Input[str]:
        """
        The secret name of the storage account.
        """
        return pulumi.get(self, "storage_account_sas_secret_name")

    @storage_account_sas_secret_name.setter
    def storage_account_sas_secret_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_account_sas_secret_name", value)

    @property
    @pulumi.getter(name="targetLocation")
    def target_location(self) -> pulumi.Input[str]:
        """
        The target location.
        """
        return pulumi.get(self, "target_location")

    @target_location.setter
    def target_location(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_location", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The class type.
        Expected value is 'VMwareCbt'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)


@pulumi.input_type
class VMwareCbtDiskInputArgs:
    def __init__(__self__, *,
                 disk_id: pulumi.Input[str],
                 is_os_disk: pulumi.Input[str],
                 log_storage_account_id: pulumi.Input[str],
                 log_storage_account_sas_secret_name: pulumi.Input[str],
                 disk_encryption_set_id: Optional[pulumi.Input[str]] = None,
                 disk_type: Optional[pulumi.Input[Union[str, 'DiskAccountType']]] = None):
        """
        VMwareCbt disk input.
        :param pulumi.Input[str] disk_id: The disk Id.
        :param pulumi.Input[str] is_os_disk: A value indicating whether the disk is the OS disk.
        :param pulumi.Input[str] log_storage_account_id: The log storage account ARM Id.
        :param pulumi.Input[str] log_storage_account_sas_secret_name: The key vault secret name of the log storage account.
        :param pulumi.Input[str] disk_encryption_set_id: The DiskEncryptionSet ARM Id.
        :param pulumi.Input[Union[str, 'DiskAccountType']] disk_type: The disk type.
        """
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "is_os_disk", is_os_disk)
        pulumi.set(__self__, "log_storage_account_id", log_storage_account_id)
        pulumi.set(__self__, "log_storage_account_sas_secret_name", log_storage_account_sas_secret_name)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> pulumi.Input[str]:
        """
        The disk Id.
        """
        return pulumi.get(self, "disk_id")

    @disk_id.setter
    def disk_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "disk_id", value)

    @property
    @pulumi.getter(name="isOSDisk")
    def is_os_disk(self) -> pulumi.Input[str]:
        """
        A value indicating whether the disk is the OS disk.
        """
        return pulumi.get(self, "is_os_disk")

    @is_os_disk.setter
    def is_os_disk(self, value: pulumi.Input[str]):
        pulumi.set(self, "is_os_disk", value)

    @property
    @pulumi.getter(name="logStorageAccountId")
    def log_storage_account_id(self) -> pulumi.Input[str]:
        """
        The log storage account ARM Id.
        """
        return pulumi.get(self, "log_storage_account_id")

    @log_storage_account_id.setter
    def log_storage_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_storage_account_id", value)

    @property
    @pulumi.getter(name="logStorageAccountSasSecretName")
    def log_storage_account_sas_secret_name(self) -> pulumi.Input[str]:
        """
        The key vault secret name of the log storage account.
        """
        return pulumi.get(self, "log_storage_account_sas_secret_name")

    @log_storage_account_sas_secret_name.setter
    def log_storage_account_sas_secret_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_storage_account_sas_secret_name", value)

    @property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The DiskEncryptionSet ARM Id.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @disk_encryption_set_id.setter
    def disk_encryption_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_encryption_set_id", value)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[Union[str, 'DiskAccountType']]]:
        """
        The disk type.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[Union[str, 'DiskAccountType']]]):
        pulumi.set(self, "disk_type", value)


@pulumi.input_type
class VMwareCbtEnableMigrationInputArgs:
    def __init__(__self__, *,
                 data_mover_run_as_account_id: pulumi.Input[str],
                 disks_to_include: pulumi.Input[Sequence[pulumi.Input['VMwareCbtDiskInputArgs']]],
                 instance_type: pulumi.Input[str],
                 snapshot_run_as_account_id: pulumi.Input[str],
                 target_network_id: pulumi.Input[str],
                 target_resource_group_id: pulumi.Input[str],
                 vmware_machine_id: pulumi.Input[str],
                 license_type: Optional[pulumi.Input[Union[str, 'LicenseType']]] = None,
                 perform_auto_resync: Optional[pulumi.Input[str]] = None,
                 target_availability_set_id: Optional[pulumi.Input[str]] = None,
                 target_availability_zone: Optional[pulumi.Input[str]] = None,
                 target_boot_diagnostics_storage_account_id: Optional[pulumi.Input[str]] = None,
                 target_subnet_name: Optional[pulumi.Input[str]] = None,
                 target_vm_name: Optional[pulumi.Input[str]] = None,
                 target_vm_size: Optional[pulumi.Input[str]] = None):
        """
        VMwareCbt specific enable migration input.
        :param pulumi.Input[str] data_mover_run_as_account_id: The data mover RunAs account Id.
        :param pulumi.Input[Sequence[pulumi.Input['VMwareCbtDiskInputArgs']]] disks_to_include: The disks to include list.
        :param pulumi.Input[str] instance_type: The class type.
               Expected value is 'VMwareCbt'.
        :param pulumi.Input[str] snapshot_run_as_account_id: The snapshot RunAs account Id.
        :param pulumi.Input[str] target_network_id: The target network ARM Id.
        :param pulumi.Input[str] target_resource_group_id: The target resource group ARM Id.
        :param pulumi.Input[str] vmware_machine_id: The ARM Id of the VM discovered in VMware.
        :param pulumi.Input[Union[str, 'LicenseType']] license_type: License type.
        :param pulumi.Input[str] perform_auto_resync: A value indicating whether auto resync is to be done.
        :param pulumi.Input[str] target_availability_set_id: The target availability set ARM Id.
        :param pulumi.Input[str] target_availability_zone: The target availability zone.
        :param pulumi.Input[str] target_boot_diagnostics_storage_account_id: The target boot diagnostics storage account ARM Id.
        :param pulumi.Input[str] target_subnet_name: The target subnet name.
        :param pulumi.Input[str] target_vm_name: The target VM name.
        :param pulumi.Input[str] target_vm_size: The target VM size.
        """
        pulumi.set(__self__, "data_mover_run_as_account_id", data_mover_run_as_account_id)
        pulumi.set(__self__, "disks_to_include", disks_to_include)
        pulumi.set(__self__, "instance_type", 'VMwareCbt')
        pulumi.set(__self__, "snapshot_run_as_account_id", snapshot_run_as_account_id)
        pulumi.set(__self__, "target_network_id", target_network_id)
        pulumi.set(__self__, "target_resource_group_id", target_resource_group_id)
        pulumi.set(__self__, "vmware_machine_id", vmware_machine_id)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if perform_auto_resync is not None:
            pulumi.set(__self__, "perform_auto_resync", perform_auto_resync)
        if target_availability_set_id is not None:
            pulumi.set(__self__, "target_availability_set_id", target_availability_set_id)
        if target_availability_zone is not None:
            pulumi.set(__self__, "target_availability_zone", target_availability_zone)
        if target_boot_diagnostics_storage_account_id is not None:
            pulumi.set(__self__, "target_boot_diagnostics_storage_account_id", target_boot_diagnostics_storage_account_id)
        if target_subnet_name is not None:
            pulumi.set(__self__, "target_subnet_name", target_subnet_name)
        if target_vm_name is not None:
            pulumi.set(__self__, "target_vm_name", target_vm_name)
        if target_vm_size is not None:
            pulumi.set(__self__, "target_vm_size", target_vm_size)

    @property
    @pulumi.getter(name="dataMoverRunAsAccountId")
    def data_mover_run_as_account_id(self) -> pulumi.Input[str]:
        """
        The data mover RunAs account Id.
        """
        return pulumi.get(self, "data_mover_run_as_account_id")

    @data_mover_run_as_account_id.setter
    def data_mover_run_as_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_mover_run_as_account_id", value)

    @property
    @pulumi.getter(name="disksToInclude")
    def disks_to_include(self) -> pulumi.Input[Sequence[pulumi.Input['VMwareCbtDiskInputArgs']]]:
        """
        The disks to include list.
        """
        return pulumi.get(self, "disks_to_include")

    @disks_to_include.setter
    def disks_to_include(self, value: pulumi.Input[Sequence[pulumi.Input['VMwareCbtDiskInputArgs']]]):
        pulumi.set(self, "disks_to_include", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        The class type.
        Expected value is 'VMwareCbt'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="snapshotRunAsAccountId")
    def snapshot_run_as_account_id(self) -> pulumi.Input[str]:
        """
        The snapshot RunAs account Id.
        """
        return pulumi.get(self, "snapshot_run_as_account_id")

    @snapshot_run_as_account_id.setter
    def snapshot_run_as_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "snapshot_run_as_account_id", value)

    @property
    @pulumi.getter(name="targetNetworkId")
    def target_network_id(self) -> pulumi.Input[str]:
        """
        The target network ARM Id.
        """
        return pulumi.get(self, "target_network_id")

    @target_network_id.setter
    def target_network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_network_id", value)

    @property
    @pulumi.getter(name="targetResourceGroupId")
    def target_resource_group_id(self) -> pulumi.Input[str]:
        """
        The target resource group ARM Id.
        """
        return pulumi.get(self, "target_resource_group_id")

    @target_resource_group_id.setter
    def target_resource_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_group_id", value)

    @property
    @pulumi.getter(name="vmwareMachineId")
    def vmware_machine_id(self) -> pulumi.Input[str]:
        """
        The ARM Id of the VM discovered in VMware.
        """
        return pulumi.get(self, "vmware_machine_id")

    @vmware_machine_id.setter
    def vmware_machine_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vmware_machine_id", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[Union[str, 'LicenseType']]]:
        """
        License type.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[Union[str, 'LicenseType']]]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter(name="performAutoResync")
    def perform_auto_resync(self) -> Optional[pulumi.Input[str]]:
        """
        A value indicating whether auto resync is to be done.
        """
        return pulumi.get(self, "perform_auto_resync")

    @perform_auto_resync.setter
    def perform_auto_resync(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "perform_auto_resync", value)

    @property
    @pulumi.getter(name="targetAvailabilitySetId")
    def target_availability_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The target availability set ARM Id.
        """
        return pulumi.get(self, "target_availability_set_id")

    @target_availability_set_id.setter
    def target_availability_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_availability_set_id", value)

    @property
    @pulumi.getter(name="targetAvailabilityZone")
    def target_availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The target availability zone.
        """
        return pulumi.get(self, "target_availability_zone")

    @target_availability_zone.setter
    def target_availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_availability_zone", value)

    @property
    @pulumi.getter(name="targetBootDiagnosticsStorageAccountId")
    def target_boot_diagnostics_storage_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The target boot diagnostics storage account ARM Id.
        """
        return pulumi.get(self, "target_boot_diagnostics_storage_account_id")

    @target_boot_diagnostics_storage_account_id.setter
    def target_boot_diagnostics_storage_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_boot_diagnostics_storage_account_id", value)

    @property
    @pulumi.getter(name="targetSubnetName")
    def target_subnet_name(self) -> Optional[pulumi.Input[str]]:
        """
        The target subnet name.
        """
        return pulumi.get(self, "target_subnet_name")

    @target_subnet_name.setter
    def target_subnet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_subnet_name", value)

    @property
    @pulumi.getter(name="targetVmName")
    def target_vm_name(self) -> Optional[pulumi.Input[str]]:
        """
        The target VM name.
        """
        return pulumi.get(self, "target_vm_name")

    @target_vm_name.setter
    def target_vm_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_vm_name", value)

    @property
    @pulumi.getter(name="targetVmSize")
    def target_vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        The target VM size.
        """
        return pulumi.get(self, "target_vm_size")

    @target_vm_size.setter
    def target_vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_vm_size", value)


@pulumi.input_type
class VMwareCbtPolicyCreationInputArgs:
    def __init__(__self__, *,
                 app_consistent_frequency_in_minutes: Optional[pulumi.Input[int]] = None,
                 crash_consistent_frequency_in_minutes: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 recovery_point_history_in_minutes: Optional[pulumi.Input[int]] = None):
        """
        VMware Cbt policy creation input.
        :param pulumi.Input[int] app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in minutes).
        :param pulumi.Input[int] crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in minutes).
        :param pulumi.Input[str] instance_type: The class type.
               Expected value is 'VMwareCbt'.
        :param pulumi.Input[int] recovery_point_history_in_minutes: The duration in minutes until which the recovery points need to be stored.
        """
        if app_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "app_consistent_frequency_in_minutes", app_consistent_frequency_in_minutes)
        if crash_consistent_frequency_in_minutes is not None:
            pulumi.set(__self__, "crash_consistent_frequency_in_minutes", crash_consistent_frequency_in_minutes)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'VMwareCbt')
        if recovery_point_history_in_minutes is not None:
            pulumi.set(__self__, "recovery_point_history_in_minutes", recovery_point_history_in_minutes)

    @property
    @pulumi.getter(name="appConsistentFrequencyInMinutes")
    def app_consistent_frequency_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The app consistent snapshot frequency (in minutes).
        """
        return pulumi.get(self, "app_consistent_frequency_in_minutes")

    @app_consistent_frequency_in_minutes.setter
    def app_consistent_frequency_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "app_consistent_frequency_in_minutes", value)

    @property
    @pulumi.getter(name="crashConsistentFrequencyInMinutes")
    def crash_consistent_frequency_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The crash consistent snapshot frequency (in minutes).
        """
        return pulumi.get(self, "crash_consistent_frequency_in_minutes")

    @crash_consistent_frequency_in_minutes.setter
    def crash_consistent_frequency_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "crash_consistent_frequency_in_minutes", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The class type.
        Expected value is 'VMwareCbt'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="recoveryPointHistoryInMinutes")
    def recovery_point_history_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The duration in minutes until which the recovery points need to be stored.
        """
        return pulumi.get(self, "recovery_point_history_in_minutes")

    @recovery_point_history_in_minutes.setter
    def recovery_point_history_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_history_in_minutes", value)


@pulumi.input_type
class VMwareV2FabricCreationInputArgs:
    def __init__(__self__, *,
                 migration_solution_id: pulumi.Input[str],
                 instance_type: Optional[pulumi.Input[str]] = None,
                 physical_site_id: Optional[pulumi.Input[str]] = None,
                 vmware_site_id: Optional[pulumi.Input[str]] = None):
        """
        VMwareV2 fabric provider specific settings.
        :param pulumi.Input[str] migration_solution_id: The ARM Id of the migration solution.
        :param pulumi.Input[str] instance_type: Gets the class type.
               Expected value is 'VMwareV2'.
        :param pulumi.Input[str] physical_site_id: The ARM Id of the physical site.
        :param pulumi.Input[str] vmware_site_id: The ARM Id of the VMware site.
        """
        pulumi.set(__self__, "migration_solution_id", migration_solution_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'VMwareV2')
        if physical_site_id is not None:
            pulumi.set(__self__, "physical_site_id", physical_site_id)
        if vmware_site_id is not None:
            pulumi.set(__self__, "vmware_site_id", vmware_site_id)

    @property
    @pulumi.getter(name="migrationSolutionId")
    def migration_solution_id(self) -> pulumi.Input[str]:
        """
        The ARM Id of the migration solution.
        """
        return pulumi.get(self, "migration_solution_id")

    @migration_solution_id.setter
    def migration_solution_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "migration_solution_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Gets the class type.
        Expected value is 'VMwareV2'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="physicalSiteId")
    def physical_site_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARM Id of the physical site.
        """
        return pulumi.get(self, "physical_site_id")

    @physical_site_id.setter
    def physical_site_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "physical_site_id", value)

    @property
    @pulumi.getter(name="vmwareSiteId")
    def vmware_site_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARM Id of the VMware site.
        """
        return pulumi.get(self, "vmware_site_id")

    @vmware_site_id.setter
    def vmware_site_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vmware_site_id", value)


@pulumi.input_type
class VmmToAzureCreateNetworkMappingInputArgs:
    def __init__(__self__, *,
                 instance_type: Optional[pulumi.Input[str]] = None):
        """
        Create network mappings input properties/behavior specific to Vmm to Azure Network mapping.
        :param pulumi.Input[str] instance_type: The instance type.
               Expected value is 'VmmToAzure'.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'VmmToAzure')

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type.
        Expected value is 'VmmToAzure'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)


@pulumi.input_type
class VmmToVmmCreateNetworkMappingInputArgs:
    def __init__(__self__, *,
                 instance_type: Optional[pulumi.Input[str]] = None):
        """
        Create network mappings input properties/behavior specific to vmm to vmm Network mapping.
        :param pulumi.Input[str] instance_type: The instance type.
               Expected value is 'VmmToVmm'.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", 'VmmToVmm')

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type.
        Expected value is 'VmmToVmm'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)


