# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AutoscaleNotificationArgs',
    'AutoscaleProfileArgs',
    'EmailNotificationArgs',
    'MetricTriggerArgs',
    'RecurrenceArgs',
    'RecurrentScheduleArgs',
    'ScaleActionArgs',
    'ScaleCapacityArgs',
    'ScaleRuleMetricDimensionArgs',
    'ScaleRuleArgs',
    'TimeWindowArgs',
    'WebhookNotificationArgs',
]

@pulumi.input_type
class AutoscaleNotificationArgs:
    def __init__(__self__, *,
                 operation: pulumi.Input['OperationType'],
                 email: Optional[pulumi.Input['EmailNotificationArgs']] = None,
                 webhooks: Optional[pulumi.Input[Sequence[pulumi.Input['WebhookNotificationArgs']]]] = None):
        """
        Autoscale notification.
        :param pulumi.Input['OperationType'] operation: the operation associated with the notification and its value must be "scale"
        :param pulumi.Input['EmailNotificationArgs'] email: the email notification.
        :param pulumi.Input[Sequence[pulumi.Input['WebhookNotificationArgs']]] webhooks: the collection of webhook notifications.
        """
        pulumi.set(__self__, "operation", operation)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if webhooks is not None:
            pulumi.set(__self__, "webhooks", webhooks)

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Input['OperationType']:
        """
        the operation associated with the notification and its value must be "scale"
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: pulumi.Input['OperationType']):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input['EmailNotificationArgs']]:
        """
        the email notification.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input['EmailNotificationArgs']]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def webhooks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebhookNotificationArgs']]]]:
        """
        the collection of webhook notifications.
        """
        return pulumi.get(self, "webhooks")

    @webhooks.setter
    def webhooks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebhookNotificationArgs']]]]):
        pulumi.set(self, "webhooks", value)


@pulumi.input_type
class AutoscaleProfileArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input['ScaleCapacityArgs'],
                 name: pulumi.Input[str],
                 rules: pulumi.Input[Sequence[pulumi.Input['ScaleRuleArgs']]],
                 fixed_date: Optional[pulumi.Input['TimeWindowArgs']] = None,
                 recurrence: Optional[pulumi.Input['RecurrenceArgs']] = None):
        """
        Autoscale profile.
        :param pulumi.Input['ScaleCapacityArgs'] capacity: the number of instances that can be used during this profile.
        :param pulumi.Input[str] name: the name of the profile.
        :param pulumi.Input[Sequence[pulumi.Input['ScaleRuleArgs']]] rules: the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
        :param pulumi.Input['TimeWindowArgs'] fixed_date: the specific date-time for the profile. This element is not used if the Recurrence element is used.
        :param pulumi.Input['RecurrenceArgs'] recurrence: the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rules", rules)
        if fixed_date is not None:
            pulumi.set(__self__, "fixed_date", fixed_date)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Input['ScaleCapacityArgs']:
        """
        the number of instances that can be used during this profile.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input['ScaleCapacityArgs']):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        the name of the profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['ScaleRuleArgs']]]:
        """
        the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['ScaleRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="fixedDate")
    def fixed_date(self) -> Optional[pulumi.Input['TimeWindowArgs']]:
        """
        the specific date-time for the profile. This element is not used if the Recurrence element is used.
        """
        return pulumi.get(self, "fixed_date")

    @fixed_date.setter
    def fixed_date(self, value: Optional[pulumi.Input['TimeWindowArgs']]):
        pulumi.set(self, "fixed_date", value)

    @property
    @pulumi.getter
    def recurrence(self) -> Optional[pulumi.Input['RecurrenceArgs']]:
        """
        the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: Optional[pulumi.Input['RecurrenceArgs']]):
        pulumi.set(self, "recurrence", value)


@pulumi.input_type
class EmailNotificationArgs:
    def __init__(__self__, *,
                 custom_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 send_to_subscription_administrator: Optional[pulumi.Input[bool]] = None,
                 send_to_subscription_co_administrators: Optional[pulumi.Input[bool]] = None):
        """
        Email notification of an autoscale event.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_emails: the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
        :param pulumi.Input[bool] send_to_subscription_administrator: a value indicating whether to send email to subscription administrator.
        :param pulumi.Input[bool] send_to_subscription_co_administrators: a value indicating whether to send email to subscription co-administrators.
        """
        if custom_emails is not None:
            pulumi.set(__self__, "custom_emails", custom_emails)
        if send_to_subscription_administrator is None:
            send_to_subscription_administrator = False
        if send_to_subscription_administrator is not None:
            pulumi.set(__self__, "send_to_subscription_administrator", send_to_subscription_administrator)
        if send_to_subscription_co_administrators is None:
            send_to_subscription_co_administrators = False
        if send_to_subscription_co_administrators is not None:
            pulumi.set(__self__, "send_to_subscription_co_administrators", send_to_subscription_co_administrators)

    @property
    @pulumi.getter(name="customEmails")
    def custom_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
        """
        return pulumi.get(self, "custom_emails")

    @custom_emails.setter
    def custom_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_emails", value)

    @property
    @pulumi.getter(name="sendToSubscriptionAdministrator")
    def send_to_subscription_administrator(self) -> Optional[pulumi.Input[bool]]:
        """
        a value indicating whether to send email to subscription administrator.
        """
        return pulumi.get(self, "send_to_subscription_administrator")

    @send_to_subscription_administrator.setter
    def send_to_subscription_administrator(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_to_subscription_administrator", value)

    @property
    @pulumi.getter(name="sendToSubscriptionCoAdministrators")
    def send_to_subscription_co_administrators(self) -> Optional[pulumi.Input[bool]]:
        """
        a value indicating whether to send email to subscription co-administrators.
        """
        return pulumi.get(self, "send_to_subscription_co_administrators")

    @send_to_subscription_co_administrators.setter
    def send_to_subscription_co_administrators(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_to_subscription_co_administrators", value)


@pulumi.input_type
class MetricTriggerArgs:
    def __init__(__self__, *,
                 metric_name: pulumi.Input[str],
                 metric_resource_uri: pulumi.Input[str],
                 operator: pulumi.Input['ComparisonOperationType'],
                 statistic: pulumi.Input['MetricStatisticType'],
                 threshold: pulumi.Input[float],
                 time_aggregation: pulumi.Input['TimeAggregationType'],
                 time_grain: pulumi.Input[str],
                 time_window: pulumi.Input[str],
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleMetricDimensionArgs']]]] = None,
                 divide_per_instance: Optional[pulumi.Input[bool]] = None,
                 metric_namespace: Optional[pulumi.Input[str]] = None,
                 metric_resource_location: Optional[pulumi.Input[str]] = None):
        """
        The trigger that results in a scaling action.
        :param pulumi.Input[str] metric_name: the name of the metric that defines what the rule monitors.
        :param pulumi.Input[str] metric_resource_uri: the resource identifier of the resource the rule monitors.
        :param pulumi.Input['ComparisonOperationType'] operator: the operator that is used to compare the metric data and the threshold.
        :param pulumi.Input['MetricStatisticType'] statistic: the metric statistic type. How the metrics from multiple instances are combined.
        :param pulumi.Input[float] threshold: the threshold of the metric that triggers the scale action.
        :param pulumi.Input['TimeAggregationType'] time_aggregation: time aggregation type. How the data that is collected should be combined over time. The default value is Average.
        :param pulumi.Input[str] time_grain: the granularity of metrics the rule monitors. Must be one of the predefined values returned from metric definitions for the metric. Must be between 12 hours and 1 minute.
        :param pulumi.Input[str] time_window: the range of time in which instance data is collected. This value must be greater than the delay in metric collection, which can vary from resource-to-resource. Must be between 12 hours and 5 minutes.
        :param pulumi.Input[Sequence[pulumi.Input['ScaleRuleMetricDimensionArgs']]] dimensions: List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
        :param pulumi.Input[bool] divide_per_instance: a value indicating whether metric should divide per instance.
        :param pulumi.Input[str] metric_namespace: the namespace of the metric that defines what the rule monitors.
        :param pulumi.Input[str] metric_resource_location: the location of the resource the rule monitors.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "metric_resource_uri", metric_resource_uri)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "statistic", statistic)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "time_aggregation", time_aggregation)
        pulumi.set(__self__, "time_grain", time_grain)
        pulumi.set(__self__, "time_window", time_window)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if divide_per_instance is not None:
            pulumi.set(__self__, "divide_per_instance", divide_per_instance)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if metric_resource_location is not None:
            pulumi.set(__self__, "metric_resource_location", metric_resource_location)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        the name of the metric that defines what the rule monitors.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter(name="metricResourceUri")
    def metric_resource_uri(self) -> pulumi.Input[str]:
        """
        the resource identifier of the resource the rule monitors.
        """
        return pulumi.get(self, "metric_resource_uri")

    @metric_resource_uri.setter
    def metric_resource_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_resource_uri", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input['ComparisonOperationType']:
        """
        the operator that is used to compare the metric data and the threshold.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input['ComparisonOperationType']):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def statistic(self) -> pulumi.Input['MetricStatisticType']:
        """
        the metric statistic type. How the metrics from multiple instances are combined.
        """
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: pulumi.Input['MetricStatisticType']):
        pulumi.set(self, "statistic", value)

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[float]:
        """
        the threshold of the metric that triggers the scale action.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="timeAggregation")
    def time_aggregation(self) -> pulumi.Input['TimeAggregationType']:
        """
        time aggregation type. How the data that is collected should be combined over time. The default value is Average.
        """
        return pulumi.get(self, "time_aggregation")

    @time_aggregation.setter
    def time_aggregation(self, value: pulumi.Input['TimeAggregationType']):
        pulumi.set(self, "time_aggregation", value)

    @property
    @pulumi.getter(name="timeGrain")
    def time_grain(self) -> pulumi.Input[str]:
        """
        the granularity of metrics the rule monitors. Must be one of the predefined values returned from metric definitions for the metric. Must be between 12 hours and 1 minute.
        """
        return pulumi.get(self, "time_grain")

    @time_grain.setter
    def time_grain(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_grain", value)

    @property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> pulumi.Input[str]:
        """
        the range of time in which instance data is collected. This value must be greater than the delay in metric collection, which can vary from resource-to-resource. Must be between 12 hours and 5 minutes.
        """
        return pulumi.get(self, "time_window")

    @time_window.setter
    def time_window(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_window", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleMetricDimensionArgs']]]]:
        """
        List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleMetricDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="dividePerInstance")
    def divide_per_instance(self) -> Optional[pulumi.Input[bool]]:
        """
        a value indicating whether metric should divide per instance.
        """
        return pulumi.get(self, "divide_per_instance")

    @divide_per_instance.setter
    def divide_per_instance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "divide_per_instance", value)

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        the namespace of the metric that defines what the rule monitors.
        """
        return pulumi.get(self, "metric_namespace")

    @metric_namespace.setter
    def metric_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_namespace", value)

    @property
    @pulumi.getter(name="metricResourceLocation")
    def metric_resource_location(self) -> Optional[pulumi.Input[str]]:
        """
        the location of the resource the rule monitors.
        """
        return pulumi.get(self, "metric_resource_location")

    @metric_resource_location.setter
    def metric_resource_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_resource_location", value)


@pulumi.input_type
class RecurrenceArgs:
    def __init__(__self__, *,
                 frequency: pulumi.Input['RecurrenceFrequency'],
                 schedule: pulumi.Input['RecurrentScheduleArgs']):
        """
        The repeating times at which this profile begins. This element is not used if the FixedDate element is used.
        :param pulumi.Input['RecurrenceFrequency'] frequency: the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly.
        :param pulumi.Input['RecurrentScheduleArgs'] schedule: the scheduling constraints for when the profile begins.
        """
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Input['RecurrenceFrequency']:
        """
        the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input['RecurrenceFrequency']):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Input['RecurrentScheduleArgs']:
        """
        the scheduling constraints for when the profile begins.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input['RecurrentScheduleArgs']):
        pulumi.set(self, "schedule", value)


@pulumi.input_type
class RecurrentScheduleArgs:
    def __init__(__self__, *,
                 days: pulumi.Input[Sequence[pulumi.Input[str]]],
                 hours: pulumi.Input[Sequence[pulumi.Input[int]]],
                 minutes: pulumi.Input[Sequence[pulumi.Input[int]]],
                 time_zone: pulumi.Input[str]):
        """
        The scheduling constraints for when the profile begins.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] days: the collection of days that the profile takes effect on. Possible values are Sunday through Saturday.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] hours: A collection of hours that the profile takes effect on. Values supported are 0 to 23 on the 24-hour clock (AM/PM times are not supported).
        :param pulumi.Input[Sequence[pulumi.Input[int]]] minutes: A collection of minutes at which the profile takes effect at.
        :param pulumi.Input[str] time_zone: the timezone for the hours of the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def days(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        the collection of days that the profile takes effect on. Possible values are Sunday through Saturday.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter
    def hours(self) -> pulumi.Input[Sequence[pulumi.Input[int]]]:
        """
        A collection of hours that the profile takes effect on. Values supported are 0 to 23 on the 24-hour clock (AM/PM times are not supported).
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: pulumi.Input[Sequence[pulumi.Input[int]]]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> pulumi.Input[Sequence[pulumi.Input[int]]]:
        """
        A collection of minutes at which the profile takes effect at.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: pulumi.Input[Sequence[pulumi.Input[int]]]):
        pulumi.set(self, "minutes", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Input[str]:
        """
        the timezone for the hours of the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class ScaleActionArgs:
    def __init__(__self__, *,
                 cooldown: pulumi.Input[str],
                 direction: pulumi.Input['ScaleDirection'],
                 type: pulumi.Input['ScaleType'],
                 value: Optional[pulumi.Input[str]] = None):
        """
        The parameters for the scaling action.
        :param pulumi.Input[str] cooldown: the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
        :param pulumi.Input['ScaleDirection'] direction: the scale direction. Whether the scaling action increases or decreases the number of instances.
        :param pulumi.Input['ScaleType'] type: the type of action that should occur when the scale rule fires.
        :param pulumi.Input[str] value: the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is 1.
        """
        pulumi.set(__self__, "cooldown", cooldown)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "type", type)
        if value is None:
            value = '1'
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def cooldown(self) -> pulumi.Input[str]:
        """
        the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
        """
        return pulumi.get(self, "cooldown")

    @cooldown.setter
    def cooldown(self, value: pulumi.Input[str]):
        pulumi.set(self, "cooldown", value)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input['ScaleDirection']:
        """
        the scale direction. Whether the scaling action increases or decreases the number of instances.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input['ScaleDirection']):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['ScaleType']:
        """
        the type of action that should occur when the scale rule fires.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['ScaleType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is 1.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ScaleCapacityArgs:
    def __init__(__self__, *,
                 default: pulumi.Input[str],
                 maximum: pulumi.Input[str],
                 minimum: pulumi.Input[str]):
        """
        The number of instances that can be used during this profile.
        :param pulumi.Input[str] default: the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default.
        :param pulumi.Input[str] maximum: the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription.
        :param pulumi.Input[str] minimum: the minimum number of instances for the resource.
        """
        pulumi.set(__self__, "default", default)
        pulumi.set(__self__, "maximum", maximum)
        pulumi.set(__self__, "minimum", minimum)

    @property
    @pulumi.getter
    def default(self) -> pulumi.Input[str]:
        """
        the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: pulumi.Input[str]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def maximum(self) -> pulumi.Input[str]:
        """
        the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription.
        """
        return pulumi.get(self, "maximum")

    @maximum.setter
    def maximum(self, value: pulumi.Input[str]):
        pulumi.set(self, "maximum", value)

    @property
    @pulumi.getter
    def minimum(self) -> pulumi.Input[str]:
        """
        the minimum number of instances for the resource.
        """
        return pulumi.get(self, "minimum")

    @minimum.setter
    def minimum(self, value: pulumi.Input[str]):
        pulumi.set(self, "minimum", value)


@pulumi.input_type
class ScaleRuleMetricDimensionArgs:
    def __init__(__self__, *,
                 dimension_name: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'ScaleRuleMetricDimensionOperationType']],
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Specifies an auto scale rule metric dimension.
        :param pulumi.Input[str] dimension_name: Name of the dimension.
        :param pulumi.Input[Union[str, 'ScaleRuleMetricDimensionOperationType']] operator: the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: list of dimension values. For example: ["App1","App2"].
        """
        pulumi.set(__self__, "dimension_name", dimension_name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="dimensionName")
    def dimension_name(self) -> pulumi.Input[str]:
        """
        Name of the dimension.
        """
        return pulumi.get(self, "dimension_name")

    @dimension_name.setter
    def dimension_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "dimension_name", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'ScaleRuleMetricDimensionOperationType']]:
        """
        the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'ScaleRuleMetricDimensionOperationType']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        list of dimension values. For example: ["App1","App2"].
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class ScaleRuleArgs:
    def __init__(__self__, *,
                 metric_trigger: pulumi.Input['MetricTriggerArgs'],
                 scale_action: pulumi.Input['ScaleActionArgs']):
        """
        A rule that provide the triggers and parameters for the scaling action.
        :param pulumi.Input['MetricTriggerArgs'] metric_trigger: the trigger that results in a scaling action.
        :param pulumi.Input['ScaleActionArgs'] scale_action: the parameters for the scaling action.
        """
        pulumi.set(__self__, "metric_trigger", metric_trigger)
        pulumi.set(__self__, "scale_action", scale_action)

    @property
    @pulumi.getter(name="metricTrigger")
    def metric_trigger(self) -> pulumi.Input['MetricTriggerArgs']:
        """
        the trigger that results in a scaling action.
        """
        return pulumi.get(self, "metric_trigger")

    @metric_trigger.setter
    def metric_trigger(self, value: pulumi.Input['MetricTriggerArgs']):
        pulumi.set(self, "metric_trigger", value)

    @property
    @pulumi.getter(name="scaleAction")
    def scale_action(self) -> pulumi.Input['ScaleActionArgs']:
        """
        the parameters for the scaling action.
        """
        return pulumi.get(self, "scale_action")

    @scale_action.setter
    def scale_action(self, value: pulumi.Input['ScaleActionArgs']):
        pulumi.set(self, "scale_action", value)


@pulumi.input_type
class TimeWindowArgs:
    def __init__(__self__, *,
                 end: pulumi.Input[str],
                 start: pulumi.Input[str],
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        A specific date-time for the profile.
        :param pulumi.Input[str] end: the end time for the profile in ISO 8601 format.
        :param pulumi.Input[str] start: the start time for the profile in ISO 8601 format.
        :param pulumi.Input[str] time_zone: the timezone of the start and end times for the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def end(self) -> pulumi.Input[str]:
        """
        the end time for the profile in ISO 8601 format.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: pulumi.Input[str]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[str]:
        """
        the start time for the profile in ISO 8601 format.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[str]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        the timezone of the start and end times for the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class WebhookNotificationArgs:
    def __init__(__self__, *,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 service_uri: Optional[pulumi.Input[str]] = None):
        """
        Webhook notification of an autoscale event.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: a property bag of settings. This value can be empty.
        :param pulumi.Input[str] service_uri: the service address to receive the notification.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        a property bag of settings. This value can be empty.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[pulumi.Input[str]]:
        """
        the service address to receive the notification.
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_uri", value)


