# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetPredictionTrainingResultsResult',
    'AwaitableGetPredictionTrainingResultsResult',
    'get_prediction_training_results',
    'get_prediction_training_results_output',
]

@pulumi.output_type
class GetPredictionTrainingResultsResult:
    """
    The training results of the prediction.
    """
    def __init__(__self__, canonical_profiles=None, prediction_distribution=None, primary_profile_instance_count=None, score_name=None, tenant_id=None):
        if canonical_profiles and not isinstance(canonical_profiles, list):
            raise TypeError("Expected argument 'canonical_profiles' to be a list")
        pulumi.set(__self__, "canonical_profiles", canonical_profiles)
        if prediction_distribution and not isinstance(prediction_distribution, dict):
            raise TypeError("Expected argument 'prediction_distribution' to be a dict")
        pulumi.set(__self__, "prediction_distribution", prediction_distribution)
        if primary_profile_instance_count and not isinstance(primary_profile_instance_count, float):
            raise TypeError("Expected argument 'primary_profile_instance_count' to be a float")
        pulumi.set(__self__, "primary_profile_instance_count", primary_profile_instance_count)
        if score_name and not isinstance(score_name, str):
            raise TypeError("Expected argument 'score_name' to be a str")
        pulumi.set(__self__, "score_name", score_name)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="canonicalProfiles")
    def canonical_profiles(self) -> Sequence['outputs.CanonicalProfileDefinitionResponse']:
        """
        Canonical profiles.
        """
        return pulumi.get(self, "canonical_profiles")

    @property
    @pulumi.getter(name="predictionDistribution")
    def prediction_distribution(self) -> 'outputs.PredictionDistributionDefinitionResponse':
        """
        Prediction distribution.
        """
        return pulumi.get(self, "prediction_distribution")

    @property
    @pulumi.getter(name="primaryProfileInstanceCount")
    def primary_profile_instance_count(self) -> float:
        """
        Instance count of the primary profile.
        """
        return pulumi.get(self, "primary_profile_instance_count")

    @property
    @pulumi.getter(name="scoreName")
    def score_name(self) -> str:
        """
        Score name.
        """
        return pulumi.get(self, "score_name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The hub name.
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetPredictionTrainingResultsResult(GetPredictionTrainingResultsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPredictionTrainingResultsResult(
            canonical_profiles=self.canonical_profiles,
            prediction_distribution=self.prediction_distribution,
            primary_profile_instance_count=self.primary_profile_instance_count,
            score_name=self.score_name,
            tenant_id=self.tenant_id)


def get_prediction_training_results(hub_name: Optional[str] = None,
                                    prediction_name: Optional[str] = None,
                                    resource_group_name: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPredictionTrainingResultsResult:
    """
    The training results of the prediction.
    API Version: 2017-04-26.


    :param str hub_name: The name of the hub.
    :param str prediction_name: The name of the Prediction.
    :param str resource_group_name: The name of the resource group.
    """
    __args__ = dict()
    __args__['hubName'] = hub_name
    __args__['predictionName'] = prediction_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:customerinsights:getPredictionTrainingResults', __args__, opts=opts, typ=GetPredictionTrainingResultsResult).value

    return AwaitableGetPredictionTrainingResultsResult(
        canonical_profiles=__ret__.canonical_profiles,
        prediction_distribution=__ret__.prediction_distribution,
        primary_profile_instance_count=__ret__.primary_profile_instance_count,
        score_name=__ret__.score_name,
        tenant_id=__ret__.tenant_id)


@_utilities.lift_output_func(get_prediction_training_results)
def get_prediction_training_results_output(hub_name: Optional[pulumi.Input[str]] = None,
                                           prediction_name: Optional[pulumi.Input[str]] = None,
                                           resource_group_name: Optional[pulumi.Input[str]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPredictionTrainingResultsResult]:
    """
    The training results of the prediction.
    API Version: 2017-04-26.


    :param str hub_name: The name of the hub.
    :param str prediction_name: The name of the Prediction.
    :param str resource_group_name: The name of the resource group.
    """
    ...
