# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ClientInfoResponse',
    'IncidentAdditionalDataResponse',
    'IncidentLabelResponse',
    'IncidentOwnerInfoResponse',
    'SystemDataResponse',
    'WatchlistUserInfoResponse',
]

@pulumi.output_type
class ClientInfoResponse(dict):
    """
    Information on the client (user or application) that made some action
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"
        elif key == "userPrincipalName":
            suggest = "user_principal_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: Optional[str] = None,
                 name: Optional[str] = None,
                 object_id: Optional[str] = None,
                 user_principal_name: Optional[str] = None):
        """
        Information on the client (user or application) that made some action
        :param str email: The email of the client.
        :param str name: The name of the client.
        :param str object_id: The object id of the client.
        :param str user_principal_name: The user principal name of the client.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if user_principal_name is not None:
            pulumi.set(__self__, "user_principal_name", user_principal_name)

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        The email of the client.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the client.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        The object id of the client.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="userPrincipalName")
    def user_principal_name(self) -> Optional[str]:
        """
        The user principal name of the client.
        """
        return pulumi.get(self, "user_principal_name")


@pulumi.output_type
class IncidentAdditionalDataResponse(dict):
    """
    Incident additional data property bag.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertProductNames":
            suggest = "alert_product_names"
        elif key == "alertsCount":
            suggest = "alerts_count"
        elif key == "bookmarksCount":
            suggest = "bookmarks_count"
        elif key == "commentsCount":
            suggest = "comments_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentAdditionalDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentAdditionalDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentAdditionalDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alert_product_names: Sequence[str],
                 alerts_count: int,
                 bookmarks_count: int,
                 comments_count: int,
                 tactics: Sequence[str]):
        """
        Incident additional data property bag.
        :param Sequence[str] alert_product_names: List of product names of alerts in the incident
        :param int alerts_count: The number of alerts in the incident
        :param int bookmarks_count: The number of bookmarks in the incident
        :param int comments_count: The number of comments in the incident
        :param Sequence[str] tactics: The tactics associated with incident
        """
        pulumi.set(__self__, "alert_product_names", alert_product_names)
        pulumi.set(__self__, "alerts_count", alerts_count)
        pulumi.set(__self__, "bookmarks_count", bookmarks_count)
        pulumi.set(__self__, "comments_count", comments_count)
        pulumi.set(__self__, "tactics", tactics)

    @property
    @pulumi.getter(name="alertProductNames")
    def alert_product_names(self) -> Sequence[str]:
        """
        List of product names of alerts in the incident
        """
        return pulumi.get(self, "alert_product_names")

    @property
    @pulumi.getter(name="alertsCount")
    def alerts_count(self) -> int:
        """
        The number of alerts in the incident
        """
        return pulumi.get(self, "alerts_count")

    @property
    @pulumi.getter(name="bookmarksCount")
    def bookmarks_count(self) -> int:
        """
        The number of bookmarks in the incident
        """
        return pulumi.get(self, "bookmarks_count")

    @property
    @pulumi.getter(name="commentsCount")
    def comments_count(self) -> int:
        """
        The number of comments in the incident
        """
        return pulumi.get(self, "comments_count")

    @property
    @pulumi.getter
    def tactics(self) -> Sequence[str]:
        """
        The tactics associated with incident
        """
        return pulumi.get(self, "tactics")


@pulumi.output_type
class IncidentLabelResponse(dict):
    """
    Represents an incident label
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelName":
            suggest = "label_name"
        elif key == "labelType":
            suggest = "label_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentLabelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentLabelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentLabelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label_name: str,
                 label_type: str):
        """
        Represents an incident label
        :param str label_name: The name of the label
        :param str label_type: The type of the label
        """
        pulumi.set(__self__, "label_name", label_name)
        pulumi.set(__self__, "label_type", label_type)

    @property
    @pulumi.getter(name="labelName")
    def label_name(self) -> str:
        """
        The name of the label
        """
        return pulumi.get(self, "label_name")

    @property
    @pulumi.getter(name="labelType")
    def label_type(self) -> str:
        """
        The type of the label
        """
        return pulumi.get(self, "label_type")


@pulumi.output_type
class IncidentOwnerInfoResponse(dict):
    """
    Information on the user an incident is assigned to
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignedTo":
            suggest = "assigned_to"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "userPrincipalName":
            suggest = "user_principal_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentOwnerInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentOwnerInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentOwnerInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assigned_to: Optional[str] = None,
                 email: Optional[str] = None,
                 object_id: Optional[str] = None,
                 user_principal_name: Optional[str] = None):
        """
        Information on the user an incident is assigned to
        :param str assigned_to: The name of the user the incident is assigned to.
        :param str email: The email of the user the incident is assigned to.
        :param str object_id: The object id of the user the incident is assigned to.
        :param str user_principal_name: The user principal name of the user the incident is assigned to.
        """
        if assigned_to is not None:
            pulumi.set(__self__, "assigned_to", assigned_to)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if user_principal_name is not None:
            pulumi.set(__self__, "user_principal_name", user_principal_name)

    @property
    @pulumi.getter(name="assignedTo")
    def assigned_to(self) -> Optional[str]:
        """
        The name of the user the incident is assigned to.
        """
        return pulumi.get(self, "assigned_to")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        The email of the user the incident is assigned to.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        The object id of the user the incident is assigned to.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="userPrincipalName")
    def user_principal_name(self) -> Optional[str]:
        """
        The user principal name of the user the incident is assigned to.
        """
        return pulumi.get(self, "user_principal_name")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class WatchlistUserInfoResponse(dict):
    """
    User information that made some action
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WatchlistUserInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WatchlistUserInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WatchlistUserInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: str,
                 name: str,
                 object_id: Optional[str] = None):
        """
        User information that made some action
        :param str email: The email of the user.
        :param str name: The name of the user.
        :param str object_id: The object id of the user.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        The object id of the user.
        """
        return pulumi.get(self, "object_id")


