# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = ['FileServerArgs', 'FileServer']

@pulumi.input_type
class FileServerArgs:
    def __init__(__self__, *,
                 backup_schedule_group_id: pulumi.Input[str],
                 device_name: pulumi.Input[str],
                 domain_name: pulumi.Input[str],
                 manager_name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 storage_domain_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 file_server_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FileServer resource.
        :param pulumi.Input[str] backup_schedule_group_id: The backup policy id.
        :param pulumi.Input[str] device_name: The device name.
        :param pulumi.Input[str] domain_name: Domain of the file server
        :param pulumi.Input[str] manager_name: The manager name
        :param pulumi.Input[str] resource_group_name: The resource group name
        :param pulumi.Input[str] storage_domain_id: The storage domain id.
        :param pulumi.Input[str] description: The description of the file server
        :param pulumi.Input[str] file_server_name: The file server name.
        """
        pulumi.set(__self__, "backup_schedule_group_id", backup_schedule_group_id)
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "manager_name", manager_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "storage_domain_id", storage_domain_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_server_name is not None:
            pulumi.set(__self__, "file_server_name", file_server_name)

    @property
    @pulumi.getter(name="backupScheduleGroupId")
    def backup_schedule_group_id(self) -> pulumi.Input[str]:
        """
        The backup policy id.
        """
        return pulumi.get(self, "backup_schedule_group_id")

    @backup_schedule_group_id.setter
    def backup_schedule_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "backup_schedule_group_id", value)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> pulumi.Input[str]:
        """
        The device name.
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        Domain of the file server
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="managerName")
    def manager_name(self) -> pulumi.Input[str]:
        """
        The manager name
        """
        return pulumi.get(self, "manager_name")

    @manager_name.setter
    def manager_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "manager_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The resource group name
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="storageDomainId")
    def storage_domain_id(self) -> pulumi.Input[str]:
        """
        The storage domain id.
        """
        return pulumi.get(self, "storage_domain_id")

    @storage_domain_id.setter
    def storage_domain_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_domain_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the file server
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fileServerName")
    def file_server_name(self) -> Optional[pulumi.Input[str]]:
        """
        The file server name.
        """
        return pulumi.get(self, "file_server_name")

    @file_server_name.setter
    def file_server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_server_name", value)


warnings.warn("""Version 2016-10-01 will be removed in v2 of the provider.""", DeprecationWarning)


class FileServer(pulumi.CustomResource):
    warnings.warn("""Version 2016-10-01 will be removed in v2 of the provider.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_schedule_group_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_name: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 file_server_name: Optional[pulumi.Input[str]] = None,
                 manager_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 storage_domain_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The file server.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backup_schedule_group_id: The backup policy id.
        :param pulumi.Input[str] description: The description of the file server
        :param pulumi.Input[str] device_name: The device name.
        :param pulumi.Input[str] domain_name: Domain of the file server
        :param pulumi.Input[str] file_server_name: The file server name.
        :param pulumi.Input[str] manager_name: The manager name
        :param pulumi.Input[str] resource_group_name: The resource group name
        :param pulumi.Input[str] storage_domain_id: The storage domain id.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The file server.

        :param str resource_name: The name of the resource.
        :param FileServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_schedule_group_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_name: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 file_server_name: Optional[pulumi.Input[str]] = None,
                 manager_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 storage_domain_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        pulumi.log.warn("""FileServer is deprecated: Version 2016-10-01 will be removed in v2 of the provider.""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileServerArgs.__new__(FileServerArgs)

            if backup_schedule_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'backup_schedule_group_id'")
            __props__.__dict__["backup_schedule_group_id"] = backup_schedule_group_id
            __props__.__dict__["description"] = description
            if device_name is None and not opts.urn:
                raise TypeError("Missing required property 'device_name'")
            __props__.__dict__["device_name"] = device_name
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["file_server_name"] = file_server_name
            if manager_name is None and not opts.urn:
                raise TypeError("Missing required property 'manager_name'")
            __props__.__dict__["manager_name"] = manager_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if storage_domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_domain_id'")
            __props__.__dict__["storage_domain_id"] = storage_domain_id
            __props__.__dict__["name"] = None
            __props__.__dict__["type"] = None
        super(FileServer, __self__).__init__(
            'azure-native:storsimple/v20161001:FileServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'FileServer':
        """
        Get an existing FileServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FileServerArgs.__new__(FileServerArgs)

        __props__.__dict__["backup_schedule_group_id"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["domain_name"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["storage_domain_id"] = None
        __props__.__dict__["type"] = None
        return FileServer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backupScheduleGroupId")
    def backup_schedule_group_id(self) -> pulumi.Output[str]:
        """
        The backup policy id.
        """
        return pulumi.get(self, "backup_schedule_group_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the file server
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        Domain of the file server
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="storageDomainId")
    def storage_domain_id(self) -> pulumi.Output[str]:
        """
        The storage domain id.
        """
        return pulumi.get(self, "storage_domain_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type.
        """
        return pulumi.get(self, "type")

