# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'DiskPoolVolumeArgs',
    'IdentitySourceArgs',
    'ManagementClusterArgs',
    'NetAppVolumeArgs',
    'PSCredentialExecutionParameterArgs',
    'ScriptSecureStringExecutionParameterArgs',
    'ScriptStringExecutionParameterArgs',
    'SkuArgs',
    'VmHostPlacementPolicyPropertiesArgs',
    'VmVmPlacementPolicyPropertiesArgs',
    'WorkloadNetworkSegmentSubnetArgs',
]

@pulumi.input_type
class DiskPoolVolumeArgs:
    def __init__(__self__, *,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 lun_name: Optional[pulumi.Input[str]] = None):
        """
        An iSCSI volume from Microsoft.StoragePool provider
        :param pulumi.Input[Sequence[pulumi.Input[str]]] endpoints: iSCSI provider target IP address list
        :param pulumi.Input[str] lun_name: Name of the LUN to be used
        """
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if lun_name is not None:
            pulumi.set(__self__, "lun_name", lun_name)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        iSCSI provider target IP address list
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="lunName")
    def lun_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the LUN to be used
        """
        return pulumi.get(self, "lun_name")

    @lun_name.setter
    def lun_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lun_name", value)


@pulumi.input_type
class IdentitySourceArgs:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[str]] = None,
                 base_group_dn: Optional[pulumi.Input[str]] = None,
                 base_user_dn: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 primary_server: Optional[pulumi.Input[str]] = None,
                 secondary_server: Optional[pulumi.Input[str]] = None,
                 ssl: Optional[pulumi.Input[Union[str, 'SslEnum']]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        vCenter Single Sign On Identity Source
        :param pulumi.Input[str] alias: The domain's NetBIOS name
        :param pulumi.Input[str] base_group_dn: The base distinguished name for groups
        :param pulumi.Input[str] base_user_dn: The base distinguished name for users
        :param pulumi.Input[str] domain: The domain's dns name
        :param pulumi.Input[str] name: The name of the identity source
        :param pulumi.Input[str] password: The password of the Active Directory user with a minimum of read-only access to Base DN for users and groups.
        :param pulumi.Input[str] primary_server: Primary server URL
        :param pulumi.Input[str] secondary_server: Secondary server URL
        :param pulumi.Input[Union[str, 'SslEnum']] ssl: Protect LDAP communication using SSL certificate (LDAPS)
        :param pulumi.Input[str] username: The ID of an Active Directory user with a minimum of read-only access to Base DN for users and group
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if base_group_dn is not None:
            pulumi.set(__self__, "base_group_dn", base_group_dn)
        if base_user_dn is not None:
            pulumi.set(__self__, "base_user_dn", base_user_dn)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if primary_server is not None:
            pulumi.set(__self__, "primary_server", primary_server)
        if secondary_server is not None:
            pulumi.set(__self__, "secondary_server", secondary_server)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        The domain's NetBIOS name
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter(name="baseGroupDN")
    def base_group_dn(self) -> Optional[pulumi.Input[str]]:
        """
        The base distinguished name for groups
        """
        return pulumi.get(self, "base_group_dn")

    @base_group_dn.setter
    def base_group_dn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_group_dn", value)

    @property
    @pulumi.getter(name="baseUserDN")
    def base_user_dn(self) -> Optional[pulumi.Input[str]]:
        """
        The base distinguished name for users
        """
        return pulumi.get(self, "base_user_dn")

    @base_user_dn.setter
    def base_user_dn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_user_dn", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain's dns name
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the identity source
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the Active Directory user with a minimum of read-only access to Base DN for users and groups.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="primaryServer")
    def primary_server(self) -> Optional[pulumi.Input[str]]:
        """
        Primary server URL
        """
        return pulumi.get(self, "primary_server")

    @primary_server.setter
    def primary_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_server", value)

    @property
    @pulumi.getter(name="secondaryServer")
    def secondary_server(self) -> Optional[pulumi.Input[str]]:
        """
        Secondary server URL
        """
        return pulumi.get(self, "secondary_server")

    @secondary_server.setter
    def secondary_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_server", value)

    @property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input[Union[str, 'SslEnum']]]:
        """
        Protect LDAP communication using SSL certificate (LDAPS)
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input[Union[str, 'SslEnum']]]):
        pulumi.set(self, "ssl", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of an Active Directory user with a minimum of read-only access to Base DN for users and group
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ManagementClusterArgs:
    def __init__(__self__, *,
                 cluster_size: pulumi.Input[int]):
        """
        The properties of a default cluster
        :param pulumi.Input[int] cluster_size: The cluster size
        """
        pulumi.set(__self__, "cluster_size", cluster_size)

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> pulumi.Input[int]:
        """
        The cluster size
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "cluster_size", value)


@pulumi.input_type
class NetAppVolumeArgs:
    def __init__(__self__, *,
                 nfs_file_path: Optional[pulumi.Input[str]] = None,
                 nfs_provider_ip: Optional[pulumi.Input[str]] = None):
        """
        An Azure NetApp Files volume from Microsoft.NetApp provider
        :param pulumi.Input[str] nfs_file_path: File path through which the NFS volume is exposed by the provider
        :param pulumi.Input[str] nfs_provider_ip: IP address of the NFS provider
        """
        if nfs_file_path is not None:
            pulumi.set(__self__, "nfs_file_path", nfs_file_path)
        if nfs_provider_ip is not None:
            pulumi.set(__self__, "nfs_provider_ip", nfs_provider_ip)

    @property
    @pulumi.getter(name="nfsFilePath")
    def nfs_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        File path through which the NFS volume is exposed by the provider
        """
        return pulumi.get(self, "nfs_file_path")

    @nfs_file_path.setter
    def nfs_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nfs_file_path", value)

    @property
    @pulumi.getter(name="nfsProviderIp")
    def nfs_provider_ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of the NFS provider
        """
        return pulumi.get(self, "nfs_provider_ip")

    @nfs_provider_ip.setter
    def nfs_provider_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nfs_provider_ip", value)


@pulumi.input_type
class PSCredentialExecutionParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        a powershell credential object
        :param pulumi.Input[str] name: The parameter name
        :param pulumi.Input[str] type: The type of execution parameter
               Expected value is 'Credential'.
        :param pulumi.Input[str] password: password for login
        :param pulumi.Input[str] username: username for login
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'Credential')
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The parameter name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of execution parameter
        Expected value is 'Credential'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        password for login
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        username for login
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ScriptSecureStringExecutionParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 secure_value: Optional[pulumi.Input[str]] = None):
        """
        a plain text value execution parameter
        :param pulumi.Input[str] name: The parameter name
        :param pulumi.Input[str] type: The type of execution parameter
               Expected value is 'SecureValue'.
        :param pulumi.Input[str] secure_value: A secure value for the passed parameter, not to be stored in logs
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'SecureValue')
        if secure_value is not None:
            pulumi.set(__self__, "secure_value", secure_value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The parameter name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of execution parameter
        Expected value is 'SecureValue'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="secureValue")
    def secure_value(self) -> Optional[pulumi.Input[str]]:
        """
        A secure value for the passed parameter, not to be stored in logs
        """
        return pulumi.get(self, "secure_value")

    @secure_value.setter
    def secure_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secure_value", value)


@pulumi.input_type
class ScriptStringExecutionParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None):
        """
        a plain text value execution parameter
        :param pulumi.Input[str] name: The parameter name
        :param pulumi.Input[str] type: The type of execution parameter
               Expected value is 'Value'.
        :param pulumi.Input[str] value: The value for the passed parameter
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'Value')
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The parameter name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of execution parameter
        Expected value is 'Value'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value for the passed parameter
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str]):
        """
        The resource model definition representing SKU
        :param pulumi.Input[str] name: The name of the SKU.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class VmHostPlacementPolicyPropertiesArgs:
    def __init__(__self__, *,
                 affinity_type: pulumi.Input[Union[str, 'AffinityType']],
                 host_members: pulumi.Input[Sequence[pulumi.Input[str]]],
                 type: pulumi.Input[str],
                 vm_members: pulumi.Input[Sequence[pulumi.Input[str]]],
                 display_name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[Union[str, 'PlacementPolicyState']]] = None):
        """
        VM-Host placement policy properties
        :param pulumi.Input[Union[str, 'AffinityType']] affinity_type: placement policy affinity type
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_members: Host members list
        :param pulumi.Input[str] type: placement policy type
               Expected value is 'VmHost'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vm_members: Virtual machine members list
        :param pulumi.Input[str] display_name: Display name of the placement policy
        :param pulumi.Input[Union[str, 'PlacementPolicyState']] state: Whether the placement policy is enabled or disabled
        """
        pulumi.set(__self__, "affinity_type", affinity_type)
        pulumi.set(__self__, "host_members", host_members)
        pulumi.set(__self__, "type", 'VmHost')
        pulumi.set(__self__, "vm_members", vm_members)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="affinityType")
    def affinity_type(self) -> pulumi.Input[Union[str, 'AffinityType']]:
        """
        placement policy affinity type
        """
        return pulumi.get(self, "affinity_type")

    @affinity_type.setter
    def affinity_type(self, value: pulumi.Input[Union[str, 'AffinityType']]):
        pulumi.set(self, "affinity_type", value)

    @property
    @pulumi.getter(name="hostMembers")
    def host_members(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Host members list
        """
        return pulumi.get(self, "host_members")

    @host_members.setter
    def host_members(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "host_members", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        placement policy type
        Expected value is 'VmHost'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vmMembers")
    def vm_members(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Virtual machine members list
        """
        return pulumi.get(self, "vm_members")

    @vm_members.setter
    def vm_members(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "vm_members", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of the placement policy
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'PlacementPolicyState']]]:
        """
        Whether the placement policy is enabled or disabled
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'PlacementPolicyState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class VmVmPlacementPolicyPropertiesArgs:
    def __init__(__self__, *,
                 affinity_type: pulumi.Input[Union[str, 'AffinityType']],
                 type: pulumi.Input[str],
                 vm_members: pulumi.Input[Sequence[pulumi.Input[str]]],
                 display_name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[Union[str, 'PlacementPolicyState']]] = None):
        """
        VM-VM placement policy properties
        :param pulumi.Input[Union[str, 'AffinityType']] affinity_type: placement policy affinity type
        :param pulumi.Input[str] type: placement policy type
               Expected value is 'VmVm'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vm_members: Virtual machine members list
        :param pulumi.Input[str] display_name: Display name of the placement policy
        :param pulumi.Input[Union[str, 'PlacementPolicyState']] state: Whether the placement policy is enabled or disabled
        """
        pulumi.set(__self__, "affinity_type", affinity_type)
        pulumi.set(__self__, "type", 'VmVm')
        pulumi.set(__self__, "vm_members", vm_members)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="affinityType")
    def affinity_type(self) -> pulumi.Input[Union[str, 'AffinityType']]:
        """
        placement policy affinity type
        """
        return pulumi.get(self, "affinity_type")

    @affinity_type.setter
    def affinity_type(self, value: pulumi.Input[Union[str, 'AffinityType']]):
        pulumi.set(self, "affinity_type", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        placement policy type
        Expected value is 'VmVm'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vmMembers")
    def vm_members(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Virtual machine members list
        """
        return pulumi.get(self, "vm_members")

    @vm_members.setter
    def vm_members(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "vm_members", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of the placement policy
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'PlacementPolicyState']]]:
        """
        Whether the placement policy is enabled or disabled
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'PlacementPolicyState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class WorkloadNetworkSegmentSubnetArgs:
    def __init__(__self__, *,
                 dhcp_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway_address: Optional[pulumi.Input[str]] = None):
        """
        Subnet configuration for segment
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dhcp_ranges: DHCP Range assigned for subnet.
        :param pulumi.Input[str] gateway_address: Gateway address.
        """
        if dhcp_ranges is not None:
            pulumi.set(__self__, "dhcp_ranges", dhcp_ranges)
        if gateway_address is not None:
            pulumi.set(__self__, "gateway_address", gateway_address)

    @property
    @pulumi.getter(name="dhcpRanges")
    def dhcp_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        DHCP Range assigned for subnet.
        """
        return pulumi.get(self, "dhcp_ranges")

    @dhcp_ranges.setter
    def dhcp_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dhcp_ranges", value)

    @property
    @pulumi.getter(name="gatewayAddress")
    def gateway_address(self) -> Optional[pulumi.Input[str]]:
        """
        Gateway address.
        """
        return pulumi.get(self, "gateway_address")

    @gateway_address.setter
    def gateway_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_address", value)


