# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'PrivateEndpointConnectionPropertiesResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'ResourceIdResponse',
    'SiteAgentPropertiesResponse',
    'SitePropertiesResponse',
    'SiteSpnPropertiesResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class PrivateEndpointConnectionPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_endpoint: 'outputs.ResourceIdResponse',
                 provisioning_state: str,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStateResponse'] = None):
        pulumi.set(__self__, "private_endpoint", private_endpoint)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> 'outputs.ResourceIdResponse':
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStateResponse']:
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


@pulumi.output_type
class ResourceIdResponse(dict):
    def __init__(__self__, *,
                 id: str):
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")


@pulumi.output_type
class SiteAgentPropertiesResponse(dict):
    """
    Class for site agent properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastHeartBeatUtc":
            suggest = "last_heart_beat_utc"
        elif key == "keyVaultId":
            suggest = "key_vault_id"
        elif key == "keyVaultUri":
            suggest = "key_vault_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteAgentPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteAgentPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteAgentPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 last_heart_beat_utc: str,
                 version: str,
                 key_vault_id: Optional[str] = None,
                 key_vault_uri: Optional[str] = None):
        """
        Class for site agent properties.
        :param str id: ID of the agent.
        :param str last_heart_beat_utc: Last heartbeat time of the agent in UTC.
        :param str version: Version of the agent.
        :param str key_vault_id: Key vault ARM Id.
        :param str key_vault_uri: Key vault URI.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_heart_beat_utc", last_heart_beat_utc)
        pulumi.set(__self__, "version", version)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if key_vault_uri is not None:
            pulumi.set(__self__, "key_vault_uri", key_vault_uri)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the agent.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastHeartBeatUtc")
    def last_heart_beat_utc(self) -> str:
        """
        Last heartbeat time of the agent in UTC.
        """
        return pulumi.get(self, "last_heart_beat_utc")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version of the agent.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> Optional[str]:
        """
        Key vault ARM Id.
        """
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> Optional[str]:
        """
        Key vault URI.
        """
        return pulumi.get(self, "key_vault_uri")


@pulumi.output_type
class SitePropertiesResponse(dict):
    """
    Class for site properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceEndpoint":
            suggest = "service_endpoint"
        elif key == "agentDetails":
            suggest = "agent_details"
        elif key == "applianceName":
            suggest = "appliance_name"
        elif key == "discoverySolutionId":
            suggest = "discovery_solution_id"
        elif key == "servicePrincipalIdentityDetails":
            suggest = "service_principal_identity_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SitePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SitePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SitePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_endpoint: str,
                 agent_details: Optional['outputs.SiteAgentPropertiesResponse'] = None,
                 appliance_name: Optional[str] = None,
                 discovery_solution_id: Optional[str] = None,
                 service_principal_identity_details: Optional['outputs.SiteSpnPropertiesResponse'] = None):
        """
        Class for site properties.
        :param str service_endpoint: Service endpoint.
        :param 'SiteAgentPropertiesResponse' agent_details: On-premises agent details.
        :param str appliance_name: Appliance Name.
        :param str discovery_solution_id: ARM ID of migration hub solution for SDS.
        :param 'SiteSpnPropertiesResponse' service_principal_identity_details: Service principal identity details used by agent for communication to the service.
        """
        pulumi.set(__self__, "service_endpoint", service_endpoint)
        if agent_details is not None:
            pulumi.set(__self__, "agent_details", agent_details)
        if appliance_name is not None:
            pulumi.set(__self__, "appliance_name", appliance_name)
        if discovery_solution_id is not None:
            pulumi.set(__self__, "discovery_solution_id", discovery_solution_id)
        if service_principal_identity_details is not None:
            pulumi.set(__self__, "service_principal_identity_details", service_principal_identity_details)

    @property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> str:
        """
        Service endpoint.
        """
        return pulumi.get(self, "service_endpoint")

    @property
    @pulumi.getter(name="agentDetails")
    def agent_details(self) -> Optional['outputs.SiteAgentPropertiesResponse']:
        """
        On-premises agent details.
        """
        return pulumi.get(self, "agent_details")

    @property
    @pulumi.getter(name="applianceName")
    def appliance_name(self) -> Optional[str]:
        """
        Appliance Name.
        """
        return pulumi.get(self, "appliance_name")

    @property
    @pulumi.getter(name="discoverySolutionId")
    def discovery_solution_id(self) -> Optional[str]:
        """
        ARM ID of migration hub solution for SDS.
        """
        return pulumi.get(self, "discovery_solution_id")

    @property
    @pulumi.getter(name="servicePrincipalIdentityDetails")
    def service_principal_identity_details(self) -> Optional['outputs.SiteSpnPropertiesResponse']:
        """
        Service principal identity details used by agent for communication to the service.
        """
        return pulumi.get(self, "service_principal_identity_details")


@pulumi.output_type
class SiteSpnPropertiesResponse(dict):
    """
    Class for site properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aadAuthority":
            suggest = "aad_authority"
        elif key == "applicationId":
            suggest = "application_id"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "rawCertData":
            suggest = "raw_cert_data"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteSpnPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteSpnPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteSpnPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aad_authority: Optional[str] = None,
                 application_id: Optional[str] = None,
                 audience: Optional[str] = None,
                 object_id: Optional[str] = None,
                 raw_cert_data: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Class for site properties.
        :param str aad_authority: AAD Authority URL which was used to request the token for the service principal.
        :param str application_id: Application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        :param str audience: Intended audience for the service principal.
        :param str object_id: Object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        :param str raw_cert_data: Raw certificate data for building certificate expiry flows.
        :param str tenant_id: Tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        if aad_authority is not None:
            pulumi.set(__self__, "aad_authority", aad_authority)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if raw_cert_data is not None:
            pulumi.set(__self__, "raw_cert_data", raw_cert_data)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="aadAuthority")
    def aad_authority(self) -> Optional[str]:
        """
        AAD Authority URL which was used to request the token for the service principal.
        """
        return pulumi.get(self, "aad_authority")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        """
        Application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def audience(self) -> Optional[str]:
        """
        Intended audience for the service principal.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        Object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="rawCertData")
    def raw_cert_data(self) -> Optional[str]:
        """
        Raw certificate data for building certificate expiry flows.
        """
        return pulumi.get(self, "raw_cert_data")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The type of identity that last modified the resource.
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


