# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DataCollectionRuleResponseDataSources',
    'DataCollectionRuleResponseDestinations',
    'DataFlowResponse',
    'DestinationsSpecResponseAzureMonitorMetrics',
    'ExtensionDataSourceResponse',
    'LogAnalyticsDestinationResponse',
    'PerfCounterDataSourceResponse',
    'SyslogDataSourceResponse',
    'WindowsEventLogDataSourceResponse',
]

@pulumi.output_type
class DataCollectionRuleResponseDataSources(dict):
    """
    The specification of data sources. 
    This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "performanceCounters":
            suggest = "performance_counters"
        elif key == "windowsEventLogs":
            suggest = "windows_event_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCollectionRuleResponseDataSources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCollectionRuleResponseDataSources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCollectionRuleResponseDataSources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extensions: Optional[Sequence['outputs.ExtensionDataSourceResponse']] = None,
                 performance_counters: Optional[Sequence['outputs.PerfCounterDataSourceResponse']] = None,
                 syslog: Optional[Sequence['outputs.SyslogDataSourceResponse']] = None,
                 windows_event_logs: Optional[Sequence['outputs.WindowsEventLogDataSourceResponse']] = None):
        """
        The specification of data sources. 
        This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
        :param Sequence['ExtensionDataSourceResponse'] extensions: The list of Azure VM extension data source configurations.
        :param Sequence['PerfCounterDataSourceResponse'] performance_counters: The list of performance counter data source configurations.
        :param Sequence['SyslogDataSourceResponse'] syslog: The list of Syslog data source configurations.
        :param Sequence['WindowsEventLogDataSourceResponse'] windows_event_logs: The list of Windows Event Log data source configurations.
        """
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if performance_counters is not None:
            pulumi.set(__self__, "performance_counters", performance_counters)
        if syslog is not None:
            pulumi.set(__self__, "syslog", syslog)
        if windows_event_logs is not None:
            pulumi.set(__self__, "windows_event_logs", windows_event_logs)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence['outputs.ExtensionDataSourceResponse']]:
        """
        The list of Azure VM extension data source configurations.
        """
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter(name="performanceCounters")
    def performance_counters(self) -> Optional[Sequence['outputs.PerfCounterDataSourceResponse']]:
        """
        The list of performance counter data source configurations.
        """
        return pulumi.get(self, "performance_counters")

    @property
    @pulumi.getter
    def syslog(self) -> Optional[Sequence['outputs.SyslogDataSourceResponse']]:
        """
        The list of Syslog data source configurations.
        """
        return pulumi.get(self, "syslog")

    @property
    @pulumi.getter(name="windowsEventLogs")
    def windows_event_logs(self) -> Optional[Sequence['outputs.WindowsEventLogDataSourceResponse']]:
        """
        The list of Windows Event Log data source configurations.
        """
        return pulumi.get(self, "windows_event_logs")


@pulumi.output_type
class DataCollectionRuleResponseDestinations(dict):
    """
    The specification of destinations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureMonitorMetrics":
            suggest = "azure_monitor_metrics"
        elif key == "logAnalytics":
            suggest = "log_analytics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCollectionRuleResponseDestinations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCollectionRuleResponseDestinations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCollectionRuleResponseDestinations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_monitor_metrics: Optional['outputs.DestinationsSpecResponseAzureMonitorMetrics'] = None,
                 log_analytics: Optional[Sequence['outputs.LogAnalyticsDestinationResponse']] = None):
        """
        The specification of destinations.
        :param 'DestinationsSpecResponseAzureMonitorMetrics' azure_monitor_metrics: Azure Monitor Metrics destination.
        :param Sequence['LogAnalyticsDestinationResponse'] log_analytics: List of Log Analytics destinations.
        """
        if azure_monitor_metrics is not None:
            pulumi.set(__self__, "azure_monitor_metrics", azure_monitor_metrics)
        if log_analytics is not None:
            pulumi.set(__self__, "log_analytics", log_analytics)

    @property
    @pulumi.getter(name="azureMonitorMetrics")
    def azure_monitor_metrics(self) -> Optional['outputs.DestinationsSpecResponseAzureMonitorMetrics']:
        """
        Azure Monitor Metrics destination.
        """
        return pulumi.get(self, "azure_monitor_metrics")

    @property
    @pulumi.getter(name="logAnalytics")
    def log_analytics(self) -> Optional[Sequence['outputs.LogAnalyticsDestinationResponse']]:
        """
        List of Log Analytics destinations.
        """
        return pulumi.get(self, "log_analytics")


@pulumi.output_type
class DataFlowResponse(dict):
    """
    Definition of which streams are sent to which destinations.
    """
    def __init__(__self__, *,
                 destinations: Optional[Sequence[str]] = None,
                 streams: Optional[Sequence[str]] = None):
        """
        Definition of which streams are sent to which destinations.
        :param Sequence[str] destinations: List of destinations for this data flow.
        :param Sequence[str] streams: List of streams for this data flow.
        """
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence[str]]:
        """
        List of destinations for this data flow.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def streams(self) -> Optional[Sequence[str]]:
        """
        List of streams for this data flow.
        """
        return pulumi.get(self, "streams")


@pulumi.output_type
class DestinationsSpecResponseAzureMonitorMetrics(dict):
    """
    Azure Monitor Metrics destination.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Azure Monitor Metrics destination.
        :param str name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ExtensionDataSourceResponse(dict):
    """
    Definition of which data will be collected from a separate VM extension that integrates with the Azure Monitor Agent.
    Collected from either Windows and Linux machines, depending on which extension is defined.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extensionName":
            suggest = "extension_name"
        elif key == "extensionSettings":
            suggest = "extension_settings"
        elif key == "inputDataSources":
            suggest = "input_data_sources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtensionDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtensionDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtensionDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extension_name: str,
                 extension_settings: Optional[Any] = None,
                 input_data_sources: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 streams: Optional[Sequence[str]] = None):
        """
        Definition of which data will be collected from a separate VM extension that integrates with the Azure Monitor Agent.
        Collected from either Windows and Linux machines, depending on which extension is defined.
        :param str extension_name: The name of the VM extension.
        :param Any extension_settings: The extension settings. The format is specific for particular extension.
        :param Sequence[str] input_data_sources: The list of data sources this extension needs data from.
        :param str name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param Sequence[str] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        pulumi.set(__self__, "extension_name", extension_name)
        if extension_settings is not None:
            pulumi.set(__self__, "extension_settings", extension_settings)
        if input_data_sources is not None:
            pulumi.set(__self__, "input_data_sources", input_data_sources)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="extensionName")
    def extension_name(self) -> str:
        """
        The name of the VM extension.
        """
        return pulumi.get(self, "extension_name")

    @property
    @pulumi.getter(name="extensionSettings")
    def extension_settings(self) -> Optional[Any]:
        """
        The extension settings. The format is specific for particular extension.
        """
        return pulumi.get(self, "extension_settings")

    @property
    @pulumi.getter(name="inputDataSources")
    def input_data_sources(self) -> Optional[Sequence[str]]:
        """
        The list of data sources this extension needs data from.
        """
        return pulumi.get(self, "input_data_sources")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def streams(self) -> Optional[Sequence[str]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")


@pulumi.output_type
class LogAnalyticsDestinationResponse(dict):
    """
    Log Analytics destination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workspaceId":
            suggest = "workspace_id"
        elif key == "workspaceResourceId":
            suggest = "workspace_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogAnalyticsDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogAnalyticsDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogAnalyticsDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 workspace_id: str,
                 name: Optional[str] = None,
                 workspace_resource_id: Optional[str] = None):
        """
        Log Analytics destination.
        :param str workspace_id: The Customer ID of the Log Analytics workspace.
        :param str name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        :param str workspace_resource_id: The resource ID of the Log Analytics workspace.
        """
        pulumi.set(__self__, "workspace_id", workspace_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if workspace_resource_id is not None:
            pulumi.set(__self__, "workspace_resource_id", workspace_resource_id)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> str:
        """
        The Customer ID of the Log Analytics workspace.
        """
        return pulumi.get(self, "workspace_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="workspaceResourceId")
    def workspace_resource_id(self) -> Optional[str]:
        """
        The resource ID of the Log Analytics workspace.
        """
        return pulumi.get(self, "workspace_resource_id")


@pulumi.output_type
class PerfCounterDataSourceResponse(dict):
    """
    Definition of which performance counters will be collected and how they will be collected by this data collection rule.
    Collected from both Windows and Linux machines where the counter is present.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "counterSpecifiers":
            suggest = "counter_specifiers"
        elif key == "samplingFrequencyInSeconds":
            suggest = "sampling_frequency_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PerfCounterDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PerfCounterDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PerfCounterDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 counter_specifiers: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 sampling_frequency_in_seconds: Optional[int] = None,
                 streams: Optional[Sequence[str]] = None):
        """
        Definition of which performance counters will be collected and how they will be collected by this data collection rule.
        Collected from both Windows and Linux machines where the counter is present.
        :param Sequence[str] counter_specifiers: A list of specifier names of the performance counters you want to collect.
               Use a wildcard (*) to collect a counter for all instances.
               To get a list of performance counters on Windows, run the command 'typeperf'.
        :param str name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param int sampling_frequency_in_seconds: The number of seconds between consecutive counter measurements (samples).
        :param Sequence[str] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        if counter_specifiers is not None:
            pulumi.set(__self__, "counter_specifiers", counter_specifiers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sampling_frequency_in_seconds is not None:
            pulumi.set(__self__, "sampling_frequency_in_seconds", sampling_frequency_in_seconds)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="counterSpecifiers")
    def counter_specifiers(self) -> Optional[Sequence[str]]:
        """
        A list of specifier names of the performance counters you want to collect.
        Use a wildcard (*) to collect a counter for all instances.
        To get a list of performance counters on Windows, run the command 'typeperf'.
        """
        return pulumi.get(self, "counter_specifiers")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="samplingFrequencyInSeconds")
    def sampling_frequency_in_seconds(self) -> Optional[int]:
        """
        The number of seconds between consecutive counter measurements (samples).
        """
        return pulumi.get(self, "sampling_frequency_in_seconds")

    @property
    @pulumi.getter
    def streams(self) -> Optional[Sequence[str]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")


@pulumi.output_type
class SyslogDataSourceResponse(dict):
    """
    Definition of which syslog data will be collected and how it will be collected.
    Only collected from Linux machines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "facilityNames":
            suggest = "facility_names"
        elif key == "logLevels":
            suggest = "log_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SyslogDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SyslogDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SyslogDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 facility_names: Optional[Sequence[str]] = None,
                 log_levels: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 streams: Optional[Sequence[str]] = None):
        """
        Definition of which syslog data will be collected and how it will be collected.
        Only collected from Linux machines.
        :param Sequence[str] facility_names: The list of facility names.
        :param Sequence[str] log_levels: The log levels to collect.
        :param str name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param Sequence[str] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        if facility_names is not None:
            pulumi.set(__self__, "facility_names", facility_names)
        if log_levels is not None:
            pulumi.set(__self__, "log_levels", log_levels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="facilityNames")
    def facility_names(self) -> Optional[Sequence[str]]:
        """
        The list of facility names.
        """
        return pulumi.get(self, "facility_names")

    @property
    @pulumi.getter(name="logLevels")
    def log_levels(self) -> Optional[Sequence[str]]:
        """
        The log levels to collect.
        """
        return pulumi.get(self, "log_levels")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def streams(self) -> Optional[Sequence[str]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")


@pulumi.output_type
class WindowsEventLogDataSourceResponse(dict):
    """
    Definition of which Windows Event Log events will be collected and how they will be collected.
    Only collected from Windows machines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "xPathQueries":
            suggest = "x_path_queries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsEventLogDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsEventLogDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsEventLogDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 streams: Optional[Sequence[str]] = None,
                 x_path_queries: Optional[Sequence[str]] = None):
        """
        Definition of which Windows Event Log events will be collected and how they will be collected.
        Only collected from Windows machines.
        :param str name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param Sequence[str] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        :param Sequence[str] x_path_queries: A list of Windows Event Log queries in XPATH format.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)
        if x_path_queries is not None:
            pulumi.set(__self__, "x_path_queries", x_path_queries)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def streams(self) -> Optional[Sequence[str]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")

    @property
    @pulumi.getter(name="xPathQueries")
    def x_path_queries(self) -> Optional[Sequence[str]]:
        """
        A list of Windows Event Log queries in XPATH format.
        """
        return pulumi.get(self, "x_path_queries")


