# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'AccumulatedType',
    'ChartType',
    'ConnectorBillingModel',
    'CostAllocationPolicyType',
    'CostAllocationResourceType',
    'DaysOfWeek',
    'ExportType',
    'FileFormat',
    'FormatType',
    'FunctionType',
    'GranularityType',
    'KpiTypeType',
    'MetricType',
    'OperatorType',
    'PivotTypeType',
    'RecurrenceType',
    'ReportColumnType',
    'ReportConfigColumnType',
    'ReportGranularityType',
    'ReportTimeframeType',
    'ReportType',
    'RuleStatus',
    'ScheduleFrequency',
    'ScheduledActionKind',
    'ScheduledActionStatus',
    'StatusType',
    'TimeframeType',
    'WeeksOfMonth',
]


class AccumulatedType(str, Enum):
    """
    Show costs accumulated over time.
    """
    TRUE = "true"
    FALSE = "false"


class ChartType(str, Enum):
    """
    Chart type of the main view in Cost Analysis. Required.
    """
    AREA = "Area"
    LINE = "Line"
    STACKED_COLUMN = "StackedColumn"
    GROUPED_COLUMN = "GroupedColumn"
    TABLE = "Table"


class ConnectorBillingModel(str, Enum):
    """
    Connector billing model
    """
    TRIAL = "trial"
    AUTO_UPGRADE = "autoUpgrade"
    PREMIUM = "premium"
    EXPIRED = "expired"


class CostAllocationPolicyType(str, Enum):
    """
    Method of cost allocation for the rule
    """
    FIXED_PROPORTION = "FixedProportion"


class CostAllocationResourceType(str, Enum):
    """
    Type of resources contained in this cost allocation rule
    """
    DIMENSION = "Dimension"
    """
    Indicates an Azure dimension such as a subscription id or resource group name is being used for allocation.
    """
    TAG = "Tag"
    """
    Allocates cost based on Azure Tag key value pairs.
    """


class DaysOfWeek(str, Enum):
    """
    Days of Week.
    """
    MONDAY = "Monday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"
    THURSDAY = "Thursday"
    FRIDAY = "Friday"
    SATURDAY = "Saturday"
    SUNDAY = "Sunday"


class ExportType(str, Enum):
    """
    The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do not yet provide data for charges or amortization for service reservations.
    """
    USAGE = "Usage"
    ACTUAL_COST = "ActualCost"
    AMORTIZED_COST = "AmortizedCost"


class FileFormat(str, Enum):
    """
    Destination of the view data. Currently only csv format is supported.
    """
    CSV = "Csv"


class FormatType(str, Enum):
    """
    The format of the report being delivered.
    """
    CSV = "Csv"


class FunctionType(str, Enum):
    """
    The name of the aggregation function to use.
    """
    AVG = "Avg"
    MAX = "Max"
    MIN = "Min"
    SUM = "Sum"


class GranularityType(str, Enum):
    """
    The granularity of rows in the report.
    """
    DAILY = "Daily"
    HOURLY = "Hourly"


class KpiTypeType(str, Enum):
    """
    KPI type (Forecast, Budget).
    """
    FORECAST = "Forecast"
    BUDGET = "Budget"


class MetricType(str, Enum):
    """
    Metric to use when displaying costs.
    """
    ACTUAL_COST = "ActualCost"
    AMORTIZED_COST = "AmortizedCost"
    AHUB = "AHUB"


class OperatorType(str, Enum):
    """
    The operator to use for comparison.
    """
    IN_ = "In"
    CONTAINS = "Contains"


class PivotTypeType(str, Enum):
    """
    Data type to show in view.
    """
    DIMENSION = "Dimension"
    TAG_KEY = "TagKey"


class RecurrenceType(str, Enum):
    """
    The schedule recurrence.
    """
    DAILY = "Daily"
    WEEKLY = "Weekly"
    MONTHLY = "Monthly"
    ANNUALLY = "Annually"


class ReportColumnType(str, Enum):
    """
    Has type of the column to group.
    """
    TAG = "Tag"
    DIMENSION = "Dimension"


class ReportConfigColumnType(str, Enum):
    """
    Has type of the column to group.
    """
    TAG = "Tag"
    DIMENSION = "Dimension"


class ReportGranularityType(str, Enum):
    """
    The granularity of rows in the report.
    """
    DAILY = "Daily"
    MONTHLY = "Monthly"


class ReportTimeframeType(str, Enum):
    """
    The time frame for pulling data for the report. If custom, then a specific time period must be provided.
    """
    WEEK_TO_DATE = "WeekToDate"
    MONTH_TO_DATE = "MonthToDate"
    YEAR_TO_DATE = "YearToDate"
    CUSTOM = "Custom"


class ReportType(str, Enum):
    """
    The type of the report. Usage represents actual usage, forecast represents forecasted data and UsageAndForecast represents both usage and forecasted data. Actual usage and forecasted data can be differentiated based on dates.
    """
    USAGE = "Usage"


class RuleStatus(str, Enum):
    """
    Status of the rule
    """
    NOT_ACTIVE = "NotActive"
    """
    Rule is saved but not used to allocate costs.
    """
    ACTIVE = "Active"
    """
    Rule is saved and impacting cost allocation.
    """
    PROCESSING = "Processing"
    """
    Rule is saved and cost allocation is being updated. Readonly value that cannot be submitted in a put request.
    """


class ScheduleFrequency(str, Enum):
    """
    Frequency of the schedule.
    """
    DAILY = "Daily"
    """
    Cost analysis data will be emailed every day.
    """
    WEEKLY = "Weekly"
    """
    Cost analysis data will be emailed every week.
    """
    MONTHLY = "Monthly"
    """
    Cost analysis data will be emailed every month.
    """


class ScheduledActionKind(str, Enum):
    """
    Kind of the scheduled action.
    """
    EMAIL = "Email"
    """
    Cost analysis data will be emailed.
    """


class ScheduledActionStatus(str, Enum):
    """
    Status of the scheduled action.
    """
    DISABLED = "Disabled"
    """
    Scheduled action is saved but will not be executed.
    """
    ENABLED = "Enabled"
    """
    Scheduled action is saved and will be executed.
    """


class StatusType(str, Enum):
    """
    The status of the schedule. Whether active or not. If inactive, the report's scheduled execution is paused.
    """
    ACTIVE = "Active"
    INACTIVE = "Inactive"


class TimeframeType(str, Enum):
    """
    The time frame for pulling data for the report. If custom, then a specific time period must be provided.
    """
    WEEK_TO_DATE = "WeekToDate"
    MONTH_TO_DATE = "MonthToDate"
    CUSTOM = "Custom"


class WeeksOfMonth(str, Enum):
    """
    Weeks of month.
    """
    FIRST = "First"
    SECOND = "Second"
    THIRD = "Third"
    FOURTH = "Fourth"
    LAST = "Last"
