# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CreationDataResponse',
    'DataDiskImageEncryptionResponse',
    'DisallowedResponse',
    'DiskSkuResponse',
    'EncryptionImagesResponse',
    'EncryptionResponse',
    'EncryptionSetIdentityResponse',
    'EncryptionSettingsCollectionResponse',
    'EncryptionSettingsElementResponse',
    'ExtendedLocationResponse',
    'GalleryApplicationVersionPublishingProfileResponse',
    'GalleryArtifactVersionSourceResponse',
    'GalleryDataDiskImageResponse',
    'GalleryIdentifierResponse',
    'GalleryImageFeatureResponse',
    'GalleryImageIdentifierResponse',
    'GalleryImageVersionPublishingProfileResponse',
    'GalleryImageVersionStorageProfileResponse',
    'GalleryOSDiskImageResponse',
    'ImageDiskReferenceResponse',
    'ImagePurchasePlanResponse',
    'KeyForDiskEncryptionSetResponse',
    'KeyVaultAndKeyReferenceResponse',
    'KeyVaultAndSecretReferenceResponse',
    'OSDiskImageEncryptionResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'PurchasePlanResponse',
    'RecommendedMachineConfigurationResponse',
    'RegionalReplicationStatusResponse',
    'ReplicationStatusResponse',
    'ResourceRangeResponse',
    'ShareInfoElementResponse',
    'SharingProfileGroupResponse',
    'SharingProfileResponse',
    'SnapshotSkuResponse',
    'SourceVaultResponse',
    'TargetRegionResponse',
    'UserArtifactManageResponse',
    'UserArtifactSourceResponse',
]

@pulumi.output_type
class CreationDataResponse(dict):
    """
    Data used when creating a disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createOption":
            suggest = "create_option"
        elif key == "sourceUniqueId":
            suggest = "source_unique_id"
        elif key == "galleryImageReference":
            suggest = "gallery_image_reference"
        elif key == "imageReference":
            suggest = "image_reference"
        elif key == "logicalSectorSize":
            suggest = "logical_sector_size"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "sourceUri":
            suggest = "source_uri"
        elif key == "storageAccountId":
            suggest = "storage_account_id"
        elif key == "uploadSizeBytes":
            suggest = "upload_size_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CreationDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CreationDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CreationDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_option: str,
                 source_unique_id: str,
                 gallery_image_reference: Optional['outputs.ImageDiskReferenceResponse'] = None,
                 image_reference: Optional['outputs.ImageDiskReferenceResponse'] = None,
                 logical_sector_size: Optional[int] = None,
                 source_resource_id: Optional[str] = None,
                 source_uri: Optional[str] = None,
                 storage_account_id: Optional[str] = None,
                 upload_size_bytes: Optional[float] = None):
        """
        Data used when creating a disk.
        :param str create_option: This enumerates the possible sources of a disk's creation.
        :param str source_unique_id: If this field is set, this is the unique id identifying the source of this resource.
        :param 'ImageDiskReferenceResponse' gallery_image_reference: Required if creating from a Gallery Image. The id of the ImageDiskReference will be the ARM id of the shared galley image version from which to create a disk.
        :param 'ImageDiskReferenceResponse' image_reference: Disk source information.
        :param int logical_sector_size: Logical sector size in bytes for Ultra disks. Supported values are 512 ad 4096. 4096 is the default.
        :param str source_resource_id: If createOption is Copy, this is the ARM id of the source snapshot or disk.
        :param str source_uri: If createOption is Import, this is the URI of a blob to be imported into a managed disk.
        :param str storage_account_id: Required if createOption is Import. The Azure Resource Manager identifier of the storage account containing the blob to import as a disk.
        :param float upload_size_bytes: If createOption is Upload, this is the size of the contents of the upload including the VHD footer. This value should be between 20972032 (20 MiB + 512 bytes for the VHD footer) and 35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
        """
        pulumi.set(__self__, "create_option", create_option)
        pulumi.set(__self__, "source_unique_id", source_unique_id)
        if gallery_image_reference is not None:
            pulumi.set(__self__, "gallery_image_reference", gallery_image_reference)
        if image_reference is not None:
            pulumi.set(__self__, "image_reference", image_reference)
        if logical_sector_size is not None:
            pulumi.set(__self__, "logical_sector_size", logical_sector_size)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if source_uri is not None:
            pulumi.set(__self__, "source_uri", source_uri)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if upload_size_bytes is not None:
            pulumi.set(__self__, "upload_size_bytes", upload_size_bytes)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> str:
        """
        This enumerates the possible sources of a disk's creation.
        """
        return pulumi.get(self, "create_option")

    @property
    @pulumi.getter(name="sourceUniqueId")
    def source_unique_id(self) -> str:
        """
        If this field is set, this is the unique id identifying the source of this resource.
        """
        return pulumi.get(self, "source_unique_id")

    @property
    @pulumi.getter(name="galleryImageReference")
    def gallery_image_reference(self) -> Optional['outputs.ImageDiskReferenceResponse']:
        """
        Required if creating from a Gallery Image. The id of the ImageDiskReference will be the ARM id of the shared galley image version from which to create a disk.
        """
        return pulumi.get(self, "gallery_image_reference")

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> Optional['outputs.ImageDiskReferenceResponse']:
        """
        Disk source information.
        """
        return pulumi.get(self, "image_reference")

    @property
    @pulumi.getter(name="logicalSectorSize")
    def logical_sector_size(self) -> Optional[int]:
        """
        Logical sector size in bytes for Ultra disks. Supported values are 512 ad 4096. 4096 is the default.
        """
        return pulumi.get(self, "logical_sector_size")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        If createOption is Copy, this is the ARM id of the source snapshot or disk.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> Optional[str]:
        """
        If createOption is Import, this is the URI of a blob to be imported into a managed disk.
        """
        return pulumi.get(self, "source_uri")

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[str]:
        """
        Required if createOption is Import. The Azure Resource Manager identifier of the storage account containing the blob to import as a disk.
        """
        return pulumi.get(self, "storage_account_id")

    @property
    @pulumi.getter(name="uploadSizeBytes")
    def upload_size_bytes(self) -> Optional[float]:
        """
        If createOption is Upload, this is the size of the contents of the upload including the VHD footer. This value should be between 20972032 (20 MiB + 512 bytes for the VHD footer) and 35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
        """
        return pulumi.get(self, "upload_size_bytes")


@pulumi.output_type
class DataDiskImageEncryptionResponse(dict):
    """
    Contains encryption settings for a data disk image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataDiskImageEncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataDiskImageEncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataDiskImageEncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lun: int,
                 disk_encryption_set_id: Optional[str] = None):
        """
        Contains encryption settings for a data disk image.
        :param int lun: This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
        :param str disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption set.
        """
        pulumi.set(__self__, "lun", lun)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)

    @property
    @pulumi.getter
    def lun(self) -> int:
        """
        This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
        """
        return pulumi.get(self, "lun")

    @property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[str]:
        """
        A relative URI containing the resource ID of the disk encryption set.
        """
        return pulumi.get(self, "disk_encryption_set_id")


@pulumi.output_type
class DisallowedResponse(dict):
    """
    Describes the disallowed disk types.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskTypes":
            suggest = "disk_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DisallowedResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DisallowedResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DisallowedResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_types: Optional[Sequence[str]] = None):
        """
        Describes the disallowed disk types.
        :param Sequence[str] disk_types: A list of disk types.
        """
        if disk_types is not None:
            pulumi.set(__self__, "disk_types", disk_types)

    @property
    @pulumi.getter(name="diskTypes")
    def disk_types(self) -> Optional[Sequence[str]]:
        """
        A list of disk types.
        """
        return pulumi.get(self, "disk_types")


@pulumi.output_type
class DiskSkuResponse(dict):
    """
    The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, or UltraSSD_LRS.
    """
    def __init__(__self__, *,
                 tier: str,
                 name: Optional[str] = None):
        """
        The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, or UltraSSD_LRS.
        :param str tier: The sku tier.
        :param str name: The sku name.
        """
        pulumi.set(__self__, "tier", tier)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The sku tier.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The sku name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class EncryptionImagesResponse(dict):
    """
    Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataDiskImages":
            suggest = "data_disk_images"
        elif key == "osDiskImage":
            suggest = "os_disk_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionImagesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionImagesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionImagesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_disk_images: Optional[Sequence['outputs.DataDiskImageEncryptionResponse']] = None,
                 os_disk_image: Optional['outputs.OSDiskImageEncryptionResponse'] = None):
        """
        Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
        :param Sequence['DataDiskImageEncryptionResponse'] data_disk_images: A list of encryption specifications for data disk images.
        :param 'OSDiskImageEncryptionResponse' os_disk_image: Contains encryption settings for an OS disk image.
        """
        if data_disk_images is not None:
            pulumi.set(__self__, "data_disk_images", data_disk_images)
        if os_disk_image is not None:
            pulumi.set(__self__, "os_disk_image", os_disk_image)

    @property
    @pulumi.getter(name="dataDiskImages")
    def data_disk_images(self) -> Optional[Sequence['outputs.DataDiskImageEncryptionResponse']]:
        """
        A list of encryption specifications for data disk images.
        """
        return pulumi.get(self, "data_disk_images")

    @property
    @pulumi.getter(name="osDiskImage")
    def os_disk_image(self) -> Optional['outputs.OSDiskImageEncryptionResponse']:
        """
        Contains encryption settings for an OS disk image.
        """
        return pulumi.get(self, "os_disk_image")


@pulumi.output_type
class EncryptionResponse(dict):
    """
    Encryption at rest settings for disk or snapshot
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption_set_id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Encryption at rest settings for disk or snapshot
        :param str disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling encryption at rest.
        :param str type: The type of key used to encrypt the data of the disk.
        """
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[str]:
        """
        ResourceId of the disk encryption set to use for enabling encryption at rest.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of key used to encrypt the data of the disk.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EncryptionSetIdentityResponse(dict):
    """
    The managed identity for the disk encryption set. It should be given permission on the key vault before it can be used to encrypt disks.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionSetIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionSetIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionSetIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        The managed identity for the disk encryption set. It should be given permission on the key vault before it can be used to encrypt disks.
        :param str principal_id: The object id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-identity-principal-id header in the PUT request if the resource has a systemAssigned(implicit) identity
        :param str tenant_id: The tenant id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-client-tenant-id header in the PUT request if the resource has a systemAssigned(implicit) identity
        :param str type: The type of Managed Identity used by the DiskEncryptionSet. Only SystemAssigned is supported for new creations. Disk Encryption Sets can be updated with Identity type None during migration of subscription to a new Azure Active Directory tenant; it will cause the encrypted resources to lose access to the keys.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The object id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-identity-principal-id header in the PUT request if the resource has a systemAssigned(implicit) identity
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-client-tenant-id header in the PUT request if the resource has a systemAssigned(implicit) identity
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of Managed Identity used by the DiskEncryptionSet. Only SystemAssigned is supported for new creations. Disk Encryption Sets can be updated with Identity type None during migration of subscription to a new Azure Active Directory tenant; it will cause the encrypted resources to lose access to the keys.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EncryptionSettingsCollectionResponse(dict):
    """
    Encryption settings for disk or snapshot
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionSettings":
            suggest = "encryption_settings"
        elif key == "encryptionSettingsVersion":
            suggest = "encryption_settings_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionSettingsCollectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionSettingsCollectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionSettingsCollectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 encryption_settings: Optional[Sequence['outputs.EncryptionSettingsElementResponse']] = None,
                 encryption_settings_version: Optional[str] = None):
        """
        Encryption settings for disk or snapshot
        :param bool enabled: Set this flag to true and provide DiskEncryptionKey and optional KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object, the existing settings remain unchanged.
        :param Sequence['EncryptionSettingsElementResponse'] encryption_settings: A collection of encryption settings, one for each disk volume.
        :param str encryption_settings_version: Describes what type of encryption is used for the disks. Once this field is set, it cannot be overwritten. '1.0' corresponds to Azure Disk Encryption with AAD app.'1.1' corresponds to Azure Disk Encryption.
        """
        pulumi.set(__self__, "enabled", enabled)
        if encryption_settings is not None:
            pulumi.set(__self__, "encryption_settings", encryption_settings)
        if encryption_settings_version is not None:
            pulumi.set(__self__, "encryption_settings_version", encryption_settings_version)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Set this flag to true and provide DiskEncryptionKey and optional KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object, the existing settings remain unchanged.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="encryptionSettings")
    def encryption_settings(self) -> Optional[Sequence['outputs.EncryptionSettingsElementResponse']]:
        """
        A collection of encryption settings, one for each disk volume.
        """
        return pulumi.get(self, "encryption_settings")

    @property
    @pulumi.getter(name="encryptionSettingsVersion")
    def encryption_settings_version(self) -> Optional[str]:
        """
        Describes what type of encryption is used for the disks. Once this field is set, it cannot be overwritten. '1.0' corresponds to Azure Disk Encryption with AAD app.'1.1' corresponds to Azure Disk Encryption.
        """
        return pulumi.get(self, "encryption_settings_version")


@pulumi.output_type
class EncryptionSettingsElementResponse(dict):
    """
    Encryption settings for one disk volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionKey":
            suggest = "disk_encryption_key"
        elif key == "keyEncryptionKey":
            suggest = "key_encryption_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionSettingsElementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionSettingsElementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionSettingsElementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption_key: Optional['outputs.KeyVaultAndSecretReferenceResponse'] = None,
                 key_encryption_key: Optional['outputs.KeyVaultAndKeyReferenceResponse'] = None):
        """
        Encryption settings for one disk volume.
        :param 'KeyVaultAndSecretReferenceResponse' disk_encryption_key: Key Vault Secret Url and vault id of the disk encryption key
        :param 'KeyVaultAndKeyReferenceResponse' key_encryption_key: Key Vault Key Url and vault id of the key encryption key. KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
        """
        if disk_encryption_key is not None:
            pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        if key_encryption_key is not None:
            pulumi.set(__self__, "key_encryption_key", key_encryption_key)

    @property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> Optional['outputs.KeyVaultAndSecretReferenceResponse']:
        """
        Key Vault Secret Url and vault id of the disk encryption key
        """
        return pulumi.get(self, "disk_encryption_key")

    @property
    @pulumi.getter(name="keyEncryptionKey")
    def key_encryption_key(self) -> Optional['outputs.KeyVaultAndKeyReferenceResponse']:
        """
        Key Vault Key Url and vault id of the key encryption key. KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
        """
        return pulumi.get(self, "key_encryption_key")


@pulumi.output_type
class ExtendedLocationResponse(dict):
    """
    The complex type of the extended location.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The complex type of the extended location.
        :param str name: The name of the extended location.
        :param str type: The type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the extended location.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GalleryApplicationVersionPublishingProfileResponse(dict):
    """
    The publishing profile of a gallery image version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publishedDate":
            suggest = "published_date"
        elif key == "enableHealthCheck":
            suggest = "enable_health_check"
        elif key == "endOfLifeDate":
            suggest = "end_of_life_date"
        elif key == "excludeFromLatest":
            suggest = "exclude_from_latest"
        elif key == "manageActions":
            suggest = "manage_actions"
        elif key == "replicaCount":
            suggest = "replica_count"
        elif key == "storageAccountType":
            suggest = "storage_account_type"
        elif key == "targetRegions":
            suggest = "target_regions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GalleryApplicationVersionPublishingProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GalleryApplicationVersionPublishingProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GalleryApplicationVersionPublishingProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 published_date: str,
                 source: 'outputs.UserArtifactSourceResponse',
                 enable_health_check: Optional[bool] = None,
                 end_of_life_date: Optional[str] = None,
                 exclude_from_latest: Optional[bool] = None,
                 manage_actions: Optional['outputs.UserArtifactManageResponse'] = None,
                 replica_count: Optional[int] = None,
                 storage_account_type: Optional[str] = None,
                 target_regions: Optional[Sequence['outputs.TargetRegionResponse']] = None):
        """
        The publishing profile of a gallery image version.
        :param str published_date: The timestamp for when the gallery image version is published.
        :param 'UserArtifactSourceResponse' source: The source image from which the Image Version is going to be created.
        :param bool enable_health_check: Optional. Whether or not this application reports health.
        :param str end_of_life_date: The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
        :param bool exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
        :param int replica_count: The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
        :param str storage_account_type: Specifies the storage account type to be used to store the image. This property is not updatable.
        :param Sequence['TargetRegionResponse'] target_regions: The target regions where the Image Version is going to be replicated to. This property is updatable.
        """
        pulumi.set(__self__, "published_date", published_date)
        pulumi.set(__self__, "source", source)
        if enable_health_check is not None:
            pulumi.set(__self__, "enable_health_check", enable_health_check)
        if end_of_life_date is not None:
            pulumi.set(__self__, "end_of_life_date", end_of_life_date)
        if exclude_from_latest is not None:
            pulumi.set(__self__, "exclude_from_latest", exclude_from_latest)
        if manage_actions is not None:
            pulumi.set(__self__, "manage_actions", manage_actions)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)
        if target_regions is not None:
            pulumi.set(__self__, "target_regions", target_regions)

    @property
    @pulumi.getter(name="publishedDate")
    def published_date(self) -> str:
        """
        The timestamp for when the gallery image version is published.
        """
        return pulumi.get(self, "published_date")

    @property
    @pulumi.getter
    def source(self) -> 'outputs.UserArtifactSourceResponse':
        """
        The source image from which the Image Version is going to be created.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="enableHealthCheck")
    def enable_health_check(self) -> Optional[bool]:
        """
        Optional. Whether or not this application reports health.
        """
        return pulumi.get(self, "enable_health_check")

    @property
    @pulumi.getter(name="endOfLifeDate")
    def end_of_life_date(self) -> Optional[str]:
        """
        The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
        """
        return pulumi.get(self, "end_of_life_date")

    @property
    @pulumi.getter(name="excludeFromLatest")
    def exclude_from_latest(self) -> Optional[bool]:
        """
        If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
        """
        return pulumi.get(self, "exclude_from_latest")

    @property
    @pulumi.getter(name="manageActions")
    def manage_actions(self) -> Optional['outputs.UserArtifactManageResponse']:
        return pulumi.get(self, "manage_actions")

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[int]:
        """
        The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
        """
        return pulumi.get(self, "replica_count")

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[str]:
        """
        Specifies the storage account type to be used to store the image. This property is not updatable.
        """
        return pulumi.get(self, "storage_account_type")

    @property
    @pulumi.getter(name="targetRegions")
    def target_regions(self) -> Optional[Sequence['outputs.TargetRegionResponse']]:
        """
        The target regions where the Image Version is going to be replicated to. This property is updatable.
        """
        return pulumi.get(self, "target_regions")


@pulumi.output_type
class GalleryArtifactVersionSourceResponse(dict):
    """
    The gallery artifact version source.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        The gallery artifact version source.
        :param str id: The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.
        :param str uri: The uri of the gallery artifact version source. Currently used to specify vhd/blob source.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        The uri of the gallery artifact version source. Currently used to specify vhd/blob source.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GalleryDataDiskImageResponse(dict):
    """
    This is the data disk image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeInGB":
            suggest = "size_in_gb"
        elif key == "hostCaching":
            suggest = "host_caching"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GalleryDataDiskImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GalleryDataDiskImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GalleryDataDiskImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lun: int,
                 size_in_gb: int,
                 host_caching: Optional[str] = None,
                 source: Optional['outputs.GalleryArtifactVersionSourceResponse'] = None):
        """
        This is the data disk image.
        :param int lun: This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
        :param int size_in_gb: This property indicates the size of the VHD to be created.
        :param str host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
        :param 'GalleryArtifactVersionSourceResponse' source: The gallery artifact version source.
        """
        pulumi.set(__self__, "lun", lun)
        pulumi.set(__self__, "size_in_gb", size_in_gb)
        if host_caching is not None:
            pulumi.set(__self__, "host_caching", host_caching)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def lun(self) -> int:
        """
        This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
        """
        return pulumi.get(self, "lun")

    @property
    @pulumi.getter(name="sizeInGB")
    def size_in_gb(self) -> int:
        """
        This property indicates the size of the VHD to be created.
        """
        return pulumi.get(self, "size_in_gb")

    @property
    @pulumi.getter(name="hostCaching")
    def host_caching(self) -> Optional[str]:
        """
        The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
        """
        return pulumi.get(self, "host_caching")

    @property
    @pulumi.getter
    def source(self) -> Optional['outputs.GalleryArtifactVersionSourceResponse']:
        """
        The gallery artifact version source.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class GalleryIdentifierResponse(dict):
    """
    Describes the gallery unique name.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "uniqueName":
            suggest = "unique_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GalleryIdentifierResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GalleryIdentifierResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GalleryIdentifierResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 unique_name: str):
        """
        Describes the gallery unique name.
        :param str unique_name: The unique name of the Shared Image Gallery. This name is generated automatically by Azure.
        """
        pulumi.set(__self__, "unique_name", unique_name)

    @property
    @pulumi.getter(name="uniqueName")
    def unique_name(self) -> str:
        """
        The unique name of the Shared Image Gallery. This name is generated automatically by Azure.
        """
        return pulumi.get(self, "unique_name")


@pulumi.output_type
class GalleryImageFeatureResponse(dict):
    """
    A feature for gallery image.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        A feature for gallery image.
        :param str name: The name of the gallery image feature.
        :param str value: The value of the gallery image feature.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the gallery image feature.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the gallery image feature.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GalleryImageIdentifierResponse(dict):
    """
    This is the gallery image definition identifier.
    """
    def __init__(__self__, *,
                 offer: str,
                 publisher: str,
                 sku: str):
        """
        This is the gallery image definition identifier.
        :param str offer: The name of the gallery image definition offer.
        :param str publisher: The name of the gallery image definition publisher.
        :param str sku: The name of the gallery image definition SKU.
        """
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter
    def offer(self) -> str:
        """
        The name of the gallery image definition offer.
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter
    def publisher(self) -> str:
        """
        The name of the gallery image definition publisher.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def sku(self) -> str:
        """
        The name of the gallery image definition SKU.
        """
        return pulumi.get(self, "sku")


@pulumi.output_type
class GalleryImageVersionPublishingProfileResponse(dict):
    """
    The publishing profile of a gallery image Version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publishedDate":
            suggest = "published_date"
        elif key == "endOfLifeDate":
            suggest = "end_of_life_date"
        elif key == "excludeFromLatest":
            suggest = "exclude_from_latest"
        elif key == "replicaCount":
            suggest = "replica_count"
        elif key == "storageAccountType":
            suggest = "storage_account_type"
        elif key == "targetRegions":
            suggest = "target_regions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GalleryImageVersionPublishingProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GalleryImageVersionPublishingProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GalleryImageVersionPublishingProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 published_date: str,
                 end_of_life_date: Optional[str] = None,
                 exclude_from_latest: Optional[bool] = None,
                 replica_count: Optional[int] = None,
                 storage_account_type: Optional[str] = None,
                 target_regions: Optional[Sequence['outputs.TargetRegionResponse']] = None):
        """
        The publishing profile of a gallery image Version.
        :param str published_date: The timestamp for when the gallery image version is published.
        :param str end_of_life_date: The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
        :param bool exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
        :param int replica_count: The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
        :param str storage_account_type: Specifies the storage account type to be used to store the image. This property is not updatable.
        :param Sequence['TargetRegionResponse'] target_regions: The target regions where the Image Version is going to be replicated to. This property is updatable.
        """
        pulumi.set(__self__, "published_date", published_date)
        if end_of_life_date is not None:
            pulumi.set(__self__, "end_of_life_date", end_of_life_date)
        if exclude_from_latest is not None:
            pulumi.set(__self__, "exclude_from_latest", exclude_from_latest)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)
        if target_regions is not None:
            pulumi.set(__self__, "target_regions", target_regions)

    @property
    @pulumi.getter(name="publishedDate")
    def published_date(self) -> str:
        """
        The timestamp for when the gallery image version is published.
        """
        return pulumi.get(self, "published_date")

    @property
    @pulumi.getter(name="endOfLifeDate")
    def end_of_life_date(self) -> Optional[str]:
        """
        The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
        """
        return pulumi.get(self, "end_of_life_date")

    @property
    @pulumi.getter(name="excludeFromLatest")
    def exclude_from_latest(self) -> Optional[bool]:
        """
        If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
        """
        return pulumi.get(self, "exclude_from_latest")

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[int]:
        """
        The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
        """
        return pulumi.get(self, "replica_count")

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[str]:
        """
        Specifies the storage account type to be used to store the image. This property is not updatable.
        """
        return pulumi.get(self, "storage_account_type")

    @property
    @pulumi.getter(name="targetRegions")
    def target_regions(self) -> Optional[Sequence['outputs.TargetRegionResponse']]:
        """
        The target regions where the Image Version is going to be replicated to. This property is updatable.
        """
        return pulumi.get(self, "target_regions")


@pulumi.output_type
class GalleryImageVersionStorageProfileResponse(dict):
    """
    This is the storage profile of a Gallery Image Version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataDiskImages":
            suggest = "data_disk_images"
        elif key == "osDiskImage":
            suggest = "os_disk_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GalleryImageVersionStorageProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GalleryImageVersionStorageProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GalleryImageVersionStorageProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_disk_images: Optional[Sequence['outputs.GalleryDataDiskImageResponse']] = None,
                 os_disk_image: Optional['outputs.GalleryOSDiskImageResponse'] = None,
                 source: Optional['outputs.GalleryArtifactVersionSourceResponse'] = None):
        """
        This is the storage profile of a Gallery Image Version.
        :param Sequence['GalleryDataDiskImageResponse'] data_disk_images: A list of data disk images.
        :param 'GalleryOSDiskImageResponse' os_disk_image: This is the OS disk image.
        :param 'GalleryArtifactVersionSourceResponse' source: The gallery artifact version source.
        """
        if data_disk_images is not None:
            pulumi.set(__self__, "data_disk_images", data_disk_images)
        if os_disk_image is not None:
            pulumi.set(__self__, "os_disk_image", os_disk_image)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="dataDiskImages")
    def data_disk_images(self) -> Optional[Sequence['outputs.GalleryDataDiskImageResponse']]:
        """
        A list of data disk images.
        """
        return pulumi.get(self, "data_disk_images")

    @property
    @pulumi.getter(name="osDiskImage")
    def os_disk_image(self) -> Optional['outputs.GalleryOSDiskImageResponse']:
        """
        This is the OS disk image.
        """
        return pulumi.get(self, "os_disk_image")

    @property
    @pulumi.getter
    def source(self) -> Optional['outputs.GalleryArtifactVersionSourceResponse']:
        """
        The gallery artifact version source.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class GalleryOSDiskImageResponse(dict):
    """
    This is the OS disk image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeInGB":
            suggest = "size_in_gb"
        elif key == "hostCaching":
            suggest = "host_caching"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GalleryOSDiskImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GalleryOSDiskImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GalleryOSDiskImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size_in_gb: int,
                 host_caching: Optional[str] = None,
                 source: Optional['outputs.GalleryArtifactVersionSourceResponse'] = None):
        """
        This is the OS disk image.
        :param int size_in_gb: This property indicates the size of the VHD to be created.
        :param str host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
        :param 'GalleryArtifactVersionSourceResponse' source: The gallery artifact version source.
        """
        pulumi.set(__self__, "size_in_gb", size_in_gb)
        if host_caching is not None:
            pulumi.set(__self__, "host_caching", host_caching)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="sizeInGB")
    def size_in_gb(self) -> int:
        """
        This property indicates the size of the VHD to be created.
        """
        return pulumi.get(self, "size_in_gb")

    @property
    @pulumi.getter(name="hostCaching")
    def host_caching(self) -> Optional[str]:
        """
        The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
        """
        return pulumi.get(self, "host_caching")

    @property
    @pulumi.getter
    def source(self) -> Optional['outputs.GalleryArtifactVersionSourceResponse']:
        """
        The gallery artifact version source.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class ImageDiskReferenceResponse(dict):
    """
    The source image used for creating the disk.
    """
    def __init__(__self__, *,
                 id: str,
                 lun: Optional[int] = None):
        """
        The source image used for creating the disk.
        :param str id: A relative uri containing either a Platform Image Repository or user image reference.
        :param int lun: If the disk is created from an image's data disk, this is an index that indicates which of the data disks in the image to use. For OS disks, this field is null.
        """
        pulumi.set(__self__, "id", id)
        if lun is not None:
            pulumi.set(__self__, "lun", lun)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A relative uri containing either a Platform Image Repository or user image reference.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def lun(self) -> Optional[int]:
        """
        If the disk is created from an image's data disk, this is an index that indicates which of the data disks in the image to use. For OS disks, this field is null.
        """
        return pulumi.get(self, "lun")


@pulumi.output_type
class ImagePurchasePlanResponse(dict):
    """
    Describes the gallery image definition purchase plan. This is used by marketplace images.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 product: Optional[str] = None,
                 publisher: Optional[str] = None):
        """
        Describes the gallery image definition purchase plan. This is used by marketplace images.
        :param str name: The plan ID.
        :param str product: The product ID.
        :param str publisher: The publisher ID.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The plan ID.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def product(self) -> Optional[str]:
        """
        The product ID.
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The publisher ID.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class KeyForDiskEncryptionSetResponse(dict):
    """
    Key Vault Key Url to be used for server side encryption of Managed Disks and Snapshots
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUrl":
            suggest = "key_url"
        elif key == "sourceVault":
            suggest = "source_vault"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyForDiskEncryptionSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyForDiskEncryptionSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyForDiskEncryptionSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_url: str,
                 source_vault: Optional['outputs.SourceVaultResponse'] = None):
        """
        Key Vault Key Url to be used for server side encryption of Managed Disks and Snapshots
        :param str key_url: Fully versioned Key Url pointing to a key in KeyVault
        :param 'SourceVaultResponse' source_vault: Resource id of the KeyVault containing the key or secret. This property is optional and cannot be used if the KeyVault subscription is not the same as the Disk Encryption Set subscription.
        """
        pulumi.set(__self__, "key_url", key_url)
        if source_vault is not None:
            pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> str:
        """
        Fully versioned Key Url pointing to a key in KeyVault
        """
        return pulumi.get(self, "key_url")

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> Optional['outputs.SourceVaultResponse']:
        """
        Resource id of the KeyVault containing the key or secret. This property is optional and cannot be used if the KeyVault subscription is not the same as the Disk Encryption Set subscription.
        """
        return pulumi.get(self, "source_vault")


@pulumi.output_type
class KeyVaultAndKeyReferenceResponse(dict):
    """
    Key Vault Key Url and vault id of KeK, KeK is optional and when provided is used to unwrap the encryptionKey
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUrl":
            suggest = "key_url"
        elif key == "sourceVault":
            suggest = "source_vault"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultAndKeyReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultAndKeyReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultAndKeyReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_url: str,
                 source_vault: 'outputs.SourceVaultResponse'):
        """
        Key Vault Key Url and vault id of KeK, KeK is optional and when provided is used to unwrap the encryptionKey
        :param str key_url: Url pointing to a key or secret in KeyVault
        :param 'SourceVaultResponse' source_vault: Resource id of the KeyVault containing the key or secret
        """
        pulumi.set(__self__, "key_url", key_url)
        pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> str:
        """
        Url pointing to a key or secret in KeyVault
        """
        return pulumi.get(self, "key_url")

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> 'outputs.SourceVaultResponse':
        """
        Resource id of the KeyVault containing the key or secret
        """
        return pulumi.get(self, "source_vault")


@pulumi.output_type
class KeyVaultAndSecretReferenceResponse(dict):
    """
    Key Vault Secret Url and vault id of the encryption key 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretUrl":
            suggest = "secret_url"
        elif key == "sourceVault":
            suggest = "source_vault"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultAndSecretReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultAndSecretReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultAndSecretReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_url: str,
                 source_vault: 'outputs.SourceVaultResponse'):
        """
        Key Vault Secret Url and vault id of the encryption key 
        :param str secret_url: Url pointing to a key or secret in KeyVault
        :param 'SourceVaultResponse' source_vault: Resource id of the KeyVault containing the key or secret
        """
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> str:
        """
        Url pointing to a key or secret in KeyVault
        """
        return pulumi.get(self, "secret_url")

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> 'outputs.SourceVaultResponse':
        """
        Resource id of the KeyVault containing the key or secret
        """
        return pulumi.get(self, "source_vault")


@pulumi.output_type
class OSDiskImageEncryptionResponse(dict):
    """
    Contains encryption settings for an OS disk image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSDiskImageEncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSDiskImageEncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSDiskImageEncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption_set_id: Optional[str] = None):
        """
        Contains encryption settings for an OS disk image.
        :param str disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption set.
        """
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)

    @property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[str]:
        """
        A relative URI containing the resource ID of the disk encryption set.
        """
        return pulumi.get(self, "disk_encryption_set_id")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    The Private Endpoint Connection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 private_link_service_connection_state: 'outputs.PrivateLinkServiceConnectionStateResponse',
                 provisioning_state: str,
                 type: str,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None):
        """
        The Private Endpoint Connection resource.
        :param str id: private endpoint connection Id
        :param str name: private endpoint connection name
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: A collection of information about the state of the connection between DiskAccess and Virtual Network.
        :param str provisioning_state: The provisioning state of the private endpoint connection resource.
        :param str type: private endpoint connection type
        :param 'PrivateEndpointResponse' private_endpoint: The resource of private end point.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        private endpoint connection Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        private endpoint connection name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.PrivateLinkServiceConnectionStateResponse':
        """
        A collection of information about the state of the connection between DiskAccess and Virtual Network.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the private endpoint connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        private endpoint connection type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The resource of private end point.
        """
        return pulumi.get(self, "private_endpoint")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The Private Endpoint resource.
        :param str id: The ARM identifier for Private Endpoint
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ARM identifier for Private Endpoint
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    A collection of information about the state of the connection between service consumer and provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param str actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The reason for approval/rejection of the connection.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PurchasePlanResponse(dict):
    """
    Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "promotionCode":
            suggest = "promotion_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PurchasePlanResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PurchasePlanResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PurchasePlanResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 product: str,
                 publisher: str,
                 promotion_code: Optional[str] = None):
        """
        Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.
        :param str name: The plan ID.
        :param str product: Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
        :param str publisher: The publisher ID.
        :param str promotion_code: The Offer Promotion Code.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "publisher", publisher)
        if promotion_code is not None:
            pulumi.set(__self__, "promotion_code", promotion_code)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The plan ID.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def product(self) -> str:
        """
        Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter
    def publisher(self) -> str:
        """
        The publisher ID.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter(name="promotionCode")
    def promotion_code(self) -> Optional[str]:
        """
        The Offer Promotion Code.
        """
        return pulumi.get(self, "promotion_code")


@pulumi.output_type
class RecommendedMachineConfigurationResponse(dict):
    """
    The properties describe the recommended machine configuration for this Image Definition. These properties are updatable.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vCPUs":
            suggest = "v_cpus"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecommendedMachineConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecommendedMachineConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecommendedMachineConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory: Optional['outputs.ResourceRangeResponse'] = None,
                 v_cpus: Optional['outputs.ResourceRangeResponse'] = None):
        """
        The properties describe the recommended machine configuration for this Image Definition. These properties are updatable.
        :param 'ResourceRangeResponse' memory: Describes the resource range.
        :param 'ResourceRangeResponse' v_cpus: Describes the resource range.
        """
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if v_cpus is not None:
            pulumi.set(__self__, "v_cpus", v_cpus)

    @property
    @pulumi.getter
    def memory(self) -> Optional['outputs.ResourceRangeResponse']:
        """
        Describes the resource range.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="vCPUs")
    def v_cpus(self) -> Optional['outputs.ResourceRangeResponse']:
        """
        Describes the resource range.
        """
        return pulumi.get(self, "v_cpus")


@pulumi.output_type
class RegionalReplicationStatusResponse(dict):
    """
    This is the regional replication status.
    """
    def __init__(__self__, *,
                 details: str,
                 progress: int,
                 region: str,
                 state: str):
        """
        This is the regional replication status.
        :param str details: The details of the replication status.
        :param int progress: It indicates progress of the replication job.
        :param str region: The region to which the gallery image version is being replicated to.
        :param str state: This is the regional replication state.
        """
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def details(self) -> str:
        """
        The details of the replication status.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def progress(self) -> int:
        """
        It indicates progress of the replication job.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region to which the gallery image version is being replicated to.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        This is the regional replication state.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ReplicationStatusResponse(dict):
    """
    This is the replication status of the gallery image version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aggregatedState":
            suggest = "aggregated_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aggregated_state: str,
                 summary: Sequence['outputs.RegionalReplicationStatusResponse']):
        """
        This is the replication status of the gallery image version.
        :param str aggregated_state: This is the aggregated replication status based on all the regional replication status flags.
        :param Sequence['RegionalReplicationStatusResponse'] summary: This is a summary of replication status for each region.
        """
        pulumi.set(__self__, "aggregated_state", aggregated_state)
        pulumi.set(__self__, "summary", summary)

    @property
    @pulumi.getter(name="aggregatedState")
    def aggregated_state(self) -> str:
        """
        This is the aggregated replication status based on all the regional replication status flags.
        """
        return pulumi.get(self, "aggregated_state")

    @property
    @pulumi.getter
    def summary(self) -> Sequence['outputs.RegionalReplicationStatusResponse']:
        """
        This is a summary of replication status for each region.
        """
        return pulumi.get(self, "summary")


@pulumi.output_type
class ResourceRangeResponse(dict):
    """
    Describes the resource range.
    """
    def __init__(__self__, *,
                 max: Optional[int] = None,
                 min: Optional[int] = None):
        """
        Describes the resource range.
        :param int max: The maximum number of the resource.
        :param int min: The minimum number of the resource.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[int]:
        """
        The maximum number of the resource.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[int]:
        """
        The minimum number of the resource.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class ShareInfoElementResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vmUri":
            suggest = "vm_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShareInfoElementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShareInfoElementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShareInfoElementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vm_uri: str):
        """
        :param str vm_uri: A relative URI containing the ID of the VM that has the disk attached.
        """
        pulumi.set(__self__, "vm_uri", vm_uri)

    @property
    @pulumi.getter(name="vmUri")
    def vm_uri(self) -> str:
        """
        A relative URI containing the ID of the VM that has the disk attached.
        """
        return pulumi.get(self, "vm_uri")


@pulumi.output_type
class SharingProfileGroupResponse(dict):
    """
    Group of the gallery sharing profile
    """
    def __init__(__self__, *,
                 ids: Optional[Sequence[str]] = None,
                 type: Optional[str] = None):
        """
        Group of the gallery sharing profile
        :param Sequence[str] ids: A list of subscription/tenant ids the gallery is aimed to be shared to.
        :param str type: This property allows you to specify the type of sharing group. <br><br> Possible values are: <br><br> **Subscriptions** <br><br> **AADTenants**
        """
        if ids is not None:
            pulumi.set(__self__, "ids", ids)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        """
        A list of subscription/tenant ids the gallery is aimed to be shared to.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        This property allows you to specify the type of sharing group. <br><br> Possible values are: <br><br> **Subscriptions** <br><br> **AADTenants**
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SharingProfileResponse(dict):
    """
    Profile for gallery sharing to subscription or tenant
    """
    def __init__(__self__, *,
                 groups: Sequence['outputs.SharingProfileGroupResponse'],
                 permissions: Optional[str] = None):
        """
        Profile for gallery sharing to subscription or tenant
        :param Sequence['SharingProfileGroupResponse'] groups: A list of sharing profile groups.
        :param str permissions: This property allows you to specify the permission of sharing gallery. <br><br> Possible values are: <br><br> **Private** <br><br> **Groups**
        """
        pulumi.set(__self__, "groups", groups)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.SharingProfileGroupResponse']:
        """
        A list of sharing profile groups.
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def permissions(self) -> Optional[str]:
        """
        This property allows you to specify the permission of sharing gallery. <br><br> Possible values are: <br><br> **Private** <br><br> **Groups**
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class SnapshotSkuResponse(dict):
    """
    The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is an optional parameter for incremental snapshot and the default behavior is the SKU will be set to the same sku as the previous snapshot
    """
    def __init__(__self__, *,
                 tier: str,
                 name: Optional[str] = None):
        """
        The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is an optional parameter for incremental snapshot and the default behavior is the SKU will be set to the same sku as the previous snapshot
        :param str tier: The sku tier.
        :param str name: The sku name.
        """
        pulumi.set(__self__, "tier", tier)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The sku tier.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The sku name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SourceVaultResponse(dict):
    """
    The vault id is an Azure Resource Manager Resource id in the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        The vault id is an Azure Resource Manager Resource id in the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}
        :param str id: Resource Id
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class TargetRegionResponse(dict):
    """
    Describes the target region information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionalReplicaCount":
            suggest = "regional_replica_count"
        elif key == "storageAccountType":
            suggest = "storage_account_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetRegionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetRegionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetRegionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 encryption: Optional['outputs.EncryptionImagesResponse'] = None,
                 regional_replica_count: Optional[int] = None,
                 storage_account_type: Optional[str] = None):
        """
        Describes the target region information.
        :param str name: The name of the region.
        :param 'EncryptionImagesResponse' encryption: Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
        :param int regional_replica_count: The number of replicas of the Image Version to be created per region. This property is updatable.
        :param str storage_account_type: Specifies the storage account type to be used to store the image. This property is not updatable.
        """
        pulumi.set(__self__, "name", name)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if regional_replica_count is not None:
            pulumi.set(__self__, "regional_replica_count", regional_replica_count)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the region.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.EncryptionImagesResponse']:
        """
        Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="regionalReplicaCount")
    def regional_replica_count(self) -> Optional[int]:
        """
        The number of replicas of the Image Version to be created per region. This property is updatable.
        """
        return pulumi.get(self, "regional_replica_count")

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[str]:
        """
        Specifies the storage account type to be used to store the image. This property is not updatable.
        """
        return pulumi.get(self, "storage_account_type")


@pulumi.output_type
class UserArtifactManageResponse(dict):
    def __init__(__self__, *,
                 install: str,
                 remove: str,
                 update: Optional[str] = None):
        """
        :param str install: Required. The path and arguments to install the gallery application. This is limited to 4096 characters.
        :param str remove: Required. The path and arguments to remove the gallery application. This is limited to 4096 characters.
        :param str update: Optional. The path and arguments to update the gallery application. If not present, then update operation will invoke remove command on the previous version and install command on the current version of the gallery application. This is limited to 4096 characters.
        """
        pulumi.set(__self__, "install", install)
        pulumi.set(__self__, "remove", remove)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def install(self) -> str:
        """
        Required. The path and arguments to install the gallery application. This is limited to 4096 characters.
        """
        return pulumi.get(self, "install")

    @property
    @pulumi.getter
    def remove(self) -> str:
        """
        Required. The path and arguments to remove the gallery application. This is limited to 4096 characters.
        """
        return pulumi.get(self, "remove")

    @property
    @pulumi.getter
    def update(self) -> Optional[str]:
        """
        Optional. The path and arguments to update the gallery application. If not present, then update operation will invoke remove command on the previous version and install command on the current version of the gallery application. This is limited to 4096 characters.
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class UserArtifactSourceResponse(dict):
    """
    The source image from which the Image Version is going to be created.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mediaLink":
            suggest = "media_link"
        elif key == "defaultConfigurationLink":
            suggest = "default_configuration_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserArtifactSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserArtifactSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserArtifactSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 media_link: str,
                 default_configuration_link: Optional[str] = None):
        """
        The source image from which the Image Version is going to be created.
        :param str media_link: Required. The mediaLink of the artifact, must be a readable storage page blob.
        :param str default_configuration_link: Optional. The defaultConfigurationLink of the artifact, must be a readable storage page blob.
        """
        pulumi.set(__self__, "media_link", media_link)
        if default_configuration_link is not None:
            pulumi.set(__self__, "default_configuration_link", default_configuration_link)

    @property
    @pulumi.getter(name="mediaLink")
    def media_link(self) -> str:
        """
        Required. The mediaLink of the artifact, must be a readable storage page blob.
        """
        return pulumi.get(self, "media_link")

    @property
    @pulumi.getter(name="defaultConfigurationLink")
    def default_configuration_link(self) -> Optional[str]:
        """
        Optional. The defaultConfigurationLink of the artifact, must be a readable storage page blob.
        """
        return pulumi.get(self, "default_configuration_link")


