# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ActivityDependencyResponse',
    'ActivityPolicyResponse',
    'AmazonMWSLinkedServiceResponse',
    'AmazonMWSObjectDatasetResponse',
    'AmazonMWSSourceResponse',
    'AmazonRedshiftLinkedServiceResponse',
    'AmazonRedshiftSourceResponse',
    'AmazonS3DatasetResponse',
    'AmazonS3LinkedServiceResponse',
    'AvroFormatResponse',
    'AzureBatchLinkedServiceResponse',
    'AzureBlobDatasetResponse',
    'AzureDataLakeAnalyticsLinkedServiceResponse',
    'AzureDataLakeStoreDatasetResponse',
    'AzureDataLakeStoreLinkedServiceResponse',
    'AzureDataLakeStoreSinkResponse',
    'AzureDataLakeStoreSourceResponse',
    'AzureDatabricksLinkedServiceResponse',
    'AzureKeyVaultLinkedServiceResponse',
    'AzureKeyVaultSecretReferenceResponse',
    'AzureMLBatchExecutionActivityResponse',
    'AzureMLLinkedServiceResponse',
    'AzureMLUpdateResourceActivityResponse',
    'AzureMLWebServiceFileResponse',
    'AzureMySqlLinkedServiceResponse',
    'AzureMySqlSourceResponse',
    'AzureMySqlTableDatasetResponse',
    'AzurePostgreSqlLinkedServiceResponse',
    'AzurePostgreSqlSourceResponse',
    'AzurePostgreSqlTableDatasetResponse',
    'AzureQueueSinkResponse',
    'AzureSearchIndexDatasetResponse',
    'AzureSearchIndexSinkResponse',
    'AzureSearchLinkedServiceResponse',
    'AzureSqlDWLinkedServiceResponse',
    'AzureSqlDWTableDatasetResponse',
    'AzureSqlDatabaseLinkedServiceResponse',
    'AzureSqlTableDatasetResponse',
    'AzureStorageLinkedServiceResponse',
    'AzureTableDatasetResponse',
    'AzureTableSinkResponse',
    'AzureTableSourceResponse',
    'BlobEventsTriggerResponse',
    'BlobSinkResponse',
    'BlobSourceResponse',
    'BlobTriggerResponse',
    'CassandraLinkedServiceResponse',
    'CassandraSourceResponse',
    'CassandraTableDatasetResponse',
    'ConcurLinkedServiceResponse',
    'ConcurObjectDatasetResponse',
    'ConcurSourceResponse',
    'ControlActivityResponse',
    'CopyActivityResponse',
    'CosmosDbLinkedServiceResponse',
    'CouchbaseLinkedServiceResponse',
    'CouchbaseSourceResponse',
    'CouchbaseTableDatasetResponse',
    'CustomActivityReferenceObjectResponse',
    'CustomActivityResponse',
    'CustomDataSourceLinkedServiceResponse',
    'CustomDatasetResponse',
    'DataLakeAnalyticsUSQLActivityResponse',
    'DatabricksNotebookActivityResponse',
    'DatasetBZip2CompressionResponse',
    'DatasetDeflateCompressionResponse',
    'DatasetGZipCompressionResponse',
    'DatasetReferenceResponse',
    'DatasetZipDeflateCompressionResponse',
    'Db2LinkedServiceResponse',
    'DistcpSettingsResponse',
    'DocumentDbCollectionDatasetResponse',
    'DocumentDbCollectionSinkResponse',
    'DocumentDbCollectionSourceResponse',
    'DrillLinkedServiceResponse',
    'DrillSourceResponse',
    'DrillTableDatasetResponse',
    'DynamicsEntityDatasetResponse',
    'DynamicsLinkedServiceResponse',
    'DynamicsSinkResponse',
    'DynamicsSourceResponse',
    'EloquaLinkedServiceResponse',
    'EloquaObjectDatasetResponse',
    'EloquaSourceResponse',
    'EntityReferenceResponse',
    'ExecutePipelineActivityResponse',
    'ExecuteSSISPackageActivityResponse',
    'ExecutionActivityResponse',
    'ExpressionResponse',
    'FactoryIdentityResponse',
    'FactoryVSTSConfigurationResponse',
    'FileServerLinkedServiceResponse',
    'FileShareDatasetResponse',
    'FileSystemSinkResponse',
    'FileSystemSourceResponse',
    'FilterActivityResponse',
    'ForEachActivityResponse',
    'FtpServerLinkedServiceResponse',
    'GetMetadataActivityResponse',
    'GoogleBigQueryLinkedServiceResponse',
    'GoogleBigQueryObjectDatasetResponse',
    'GoogleBigQuerySourceResponse',
    'GreenplumLinkedServiceResponse',
    'GreenplumSourceResponse',
    'GreenplumTableDatasetResponse',
    'HBaseLinkedServiceResponse',
    'HBaseObjectDatasetResponse',
    'HBaseSourceResponse',
    'HDInsightHiveActivityResponse',
    'HDInsightLinkedServiceResponse',
    'HDInsightMapReduceActivityResponse',
    'HDInsightOnDemandLinkedServiceResponse',
    'HDInsightPigActivityResponse',
    'HDInsightSparkActivityResponse',
    'HDInsightStreamingActivityResponse',
    'HdfsLinkedServiceResponse',
    'HdfsSourceResponse',
    'HiveLinkedServiceResponse',
    'HiveObjectDatasetResponse',
    'HiveSourceResponse',
    'HttpDatasetResponse',
    'HttpLinkedServiceResponse',
    'HttpSourceResponse',
    'HubspotLinkedServiceResponse',
    'HubspotObjectDatasetResponse',
    'HubspotSourceResponse',
    'IfConditionActivityResponse',
    'ImpalaLinkedServiceResponse',
    'ImpalaObjectDatasetResponse',
    'ImpalaSourceResponse',
    'IntegrationRuntimeComputePropertiesResponse',
    'IntegrationRuntimeCustomSetupScriptPropertiesResponse',
    'IntegrationRuntimeDataProxyPropertiesResponse',
    'IntegrationRuntimeReferenceResponse',
    'IntegrationRuntimeSsisCatalogInfoResponse',
    'IntegrationRuntimeSsisPropertiesResponse',
    'IntegrationRuntimeVNetPropertiesResponse',
    'JiraLinkedServiceResponse',
    'JiraObjectDatasetResponse',
    'JiraSourceResponse',
    'JsonFormatResponse',
    'LinkedIntegrationRuntimeKeyResponse',
    'LinkedIntegrationRuntimeRbacResponse',
    'LinkedIntegrationRuntimeResponse',
    'LinkedServiceReferenceResponse',
    'LookupActivityResponse',
    'MagentoLinkedServiceResponse',
    'MagentoObjectDatasetResponse',
    'MagentoSourceResponse',
    'ManagedIntegrationRuntimeErrorResponse',
    'ManagedIntegrationRuntimeNodeResponse',
    'ManagedIntegrationRuntimeOperationResultResponse',
    'ManagedIntegrationRuntimeResponse',
    'ManagedIntegrationRuntimeStatusResponse',
    'MariaDBLinkedServiceResponse',
    'MariaDBSourceResponse',
    'MariaDBTableDatasetResponse',
    'MarketoLinkedServiceResponse',
    'MarketoObjectDatasetResponse',
    'MarketoSourceResponse',
    'MongoDbCollectionDatasetResponse',
    'MongoDbLinkedServiceResponse',
    'MongoDbSourceResponse',
    'MultiplePipelineTriggerResponse',
    'MySqlLinkedServiceResponse',
    'NetezzaLinkedServiceResponse',
    'NetezzaSourceResponse',
    'NetezzaTableDatasetResponse',
    'ODataLinkedServiceResponse',
    'ODataResourceDatasetResponse',
    'OdbcLinkedServiceResponse',
    'OdbcSinkResponse',
    'OracleLinkedServiceResponse',
    'OracleSinkResponse',
    'OracleSourceResponse',
    'OracleTableDatasetResponse',
    'OrcFormatResponse',
    'ParameterSpecificationResponse',
    'ParquetFormatResponse',
    'PaypalLinkedServiceResponse',
    'PaypalObjectDatasetResponse',
    'PaypalSourceResponse',
    'PhoenixLinkedServiceResponse',
    'PhoenixObjectDatasetResponse',
    'PhoenixSourceResponse',
    'PipelineReferenceResponse',
    'PolybaseSettingsResponse',
    'PostgreSqlLinkedServiceResponse',
    'PrestoLinkedServiceResponse',
    'PrestoObjectDatasetResponse',
    'PrestoSourceResponse',
    'QuickBooksLinkedServiceResponse',
    'QuickBooksObjectDatasetResponse',
    'QuickBooksSourceResponse',
    'RecurrenceScheduleOccurrenceResponse',
    'RecurrenceScheduleResponse',
    'RedirectIncompatibleRowSettingsResponse',
    'RedshiftUnloadSettingsResponse',
    'RelationalSourceResponse',
    'RelationalTableDatasetResponse',
    'ResponsysLinkedServiceResponse',
    'ResponsysObjectDatasetResponse',
    'ResponsysSourceResponse',
    'RetryPolicyResponse',
    'SSISAccessCredentialResponse',
    'SSISExecutionCredentialResponse',
    'SSISExecutionParameterResponse',
    'SSISLogLocationResponse',
    'SSISPackageLocationResponse',
    'SSISPropertyOverrideResponse',
    'SalesforceLinkedServiceResponse',
    'SalesforceMarketingCloudLinkedServiceResponse',
    'SalesforceMarketingCloudObjectDatasetResponse',
    'SalesforceMarketingCloudSourceResponse',
    'SalesforceObjectDatasetResponse',
    'SalesforceSinkResponse',
    'SalesforceSourceResponse',
    'SapBWLinkedServiceResponse',
    'SapCloudForCustomerLinkedServiceResponse',
    'SapCloudForCustomerResourceDatasetResponse',
    'SapCloudForCustomerSinkResponse',
    'SapCloudForCustomerSourceResponse',
    'SapEccLinkedServiceResponse',
    'SapEccResourceDatasetResponse',
    'SapEccSourceResponse',
    'SapHanaLinkedServiceResponse',
    'ScheduleTriggerRecurrenceResponse',
    'ScheduleTriggerResponse',
    'SecureStringResponse',
    'SelfHostedIntegrationRuntimeNodeResponse',
    'SelfHostedIntegrationRuntimeResponse',
    'SelfHostedIntegrationRuntimeStatusResponse',
    'ServiceNowLinkedServiceResponse',
    'ServiceNowObjectDatasetResponse',
    'ServiceNowSourceResponse',
    'SftpServerLinkedServiceResponse',
    'ShopifyLinkedServiceResponse',
    'ShopifyObjectDatasetResponse',
    'ShopifySourceResponse',
    'SparkLinkedServiceResponse',
    'SparkObjectDatasetResponse',
    'SparkSourceResponse',
    'SqlDWSinkResponse',
    'SqlDWSourceResponse',
    'SqlServerLinkedServiceResponse',
    'SqlServerStoredProcedureActivityResponse',
    'SqlServerTableDatasetResponse',
    'SqlSinkResponse',
    'SqlSourceResponse',
    'SquareLinkedServiceResponse',
    'SquareObjectDatasetResponse',
    'SquareSourceResponse',
    'StagingSettingsResponse',
    'StoredProcedureParameterResponse',
    'SybaseLinkedServiceResponse',
    'TeradataLinkedServiceResponse',
    'TextFormatResponse',
    'TriggerPipelineReferenceResponse',
    'TumblingWindowTriggerResponse',
    'UntilActivityResponse',
    'VerticaLinkedServiceResponse',
    'VerticaSourceResponse',
    'VerticaTableDatasetResponse',
    'WaitActivityResponse',
    'WebActivityAuthenticationResponse',
    'WebActivityResponse',
    'WebAnonymousAuthenticationResponse',
    'WebBasicAuthenticationResponse',
    'WebClientCertificateAuthenticationResponse',
    'WebLinkedServiceResponse',
    'WebSourceResponse',
    'WebTableDatasetResponse',
    'XeroLinkedServiceResponse',
    'XeroObjectDatasetResponse',
    'XeroSourceResponse',
    'ZohoLinkedServiceResponse',
    'ZohoObjectDatasetResponse',
    'ZohoSourceResponse',
]

@pulumi.output_type
class ActivityDependencyResponse(dict):
    """
    Activity dependency information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependencyConditions":
            suggest = "dependency_conditions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActivityDependencyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActivityDependencyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActivityDependencyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activity: str,
                 dependency_conditions: Sequence[str]):
        """
        Activity dependency information.
        :param str activity: Activity name.
        :param Sequence[str] dependency_conditions: Match-Condition for the dependency.
        """
        pulumi.set(__self__, "activity", activity)
        pulumi.set(__self__, "dependency_conditions", dependency_conditions)

    @property
    @pulumi.getter
    def activity(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "activity")

    @property
    @pulumi.getter(name="dependencyConditions")
    def dependency_conditions(self) -> Sequence[str]:
        """
        Match-Condition for the dependency.
        """
        return pulumi.get(self, "dependency_conditions")


@pulumi.output_type
class ActivityPolicyResponse(dict):
    """
    Execution policy for an activity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retryIntervalInSeconds":
            suggest = "retry_interval_in_seconds"
        elif key == "secureOutput":
            suggest = "secure_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActivityPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActivityPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActivityPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retry: Optional[Any] = None,
                 retry_interval_in_seconds: Optional[int] = None,
                 secure_output: Optional[bool] = None,
                 timeout: Optional[Any] = None):
        """
        Execution policy for an activity.
        :param Any retry: Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
        :param int retry_interval_in_seconds: Interval between each retry attempt (in seconds). The default is 30 sec.
        :param bool secure_output: When set to true, Output from activity is considered as secure and will not be logged to monitoring.
        :param Any timeout: Specifies the timeout for the activity to run. The default timeout is 7 days. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if retry_interval_in_seconds is not None:
            pulumi.set(__self__, "retry_interval_in_seconds", retry_interval_in_seconds)
        if secure_output is not None:
            pulumi.set(__self__, "secure_output", secure_output)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def retry(self) -> Optional[Any]:
        """
        Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "retry")

    @property
    @pulumi.getter(name="retryIntervalInSeconds")
    def retry_interval_in_seconds(self) -> Optional[int]:
        """
        Interval between each retry attempt (in seconds). The default is 30 sec.
        """
        return pulumi.get(self, "retry_interval_in_seconds")

    @property
    @pulumi.getter(name="secureOutput")
    def secure_output(self) -> Optional[bool]:
        """
        When set to true, Output from activity is considered as secure and will not be logged to monitoring.
        """
        return pulumi.get(self, "secure_output")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[Any]:
        """
        Specifies the timeout for the activity to run. The default timeout is 7 days. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class AmazonMWSLinkedServiceResponse(dict):
    """
    Amazon Marketplace Web Service linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"
        elif key == "marketplaceID":
            suggest = "marketplace_id"
        elif key == "sellerID":
            suggest = "seller_id"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "mwsAuthToken":
            suggest = "mws_auth_token"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "useEncryptedEndpoints":
            suggest = "use_encrypted_endpoints"
        elif key == "useHostVerification":
            suggest = "use_host_verification"
        elif key == "usePeerVerification":
            suggest = "use_peer_verification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AmazonMWSLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AmazonMWSLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AmazonMWSLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_id: Any,
                 endpoint: Any,
                 marketplace_id: Any,
                 seller_id: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 mws_auth_token: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 secret_key: Optional[Any] = None,
                 use_encrypted_endpoints: Optional[Any] = None,
                 use_host_verification: Optional[Any] = None,
                 use_peer_verification: Optional[Any] = None):
        """
        Amazon Marketplace Web Service linked service.
        :param Any access_key_id: The access key id used to access data.
        :param Any endpoint: The endpoint of the Amazon MWS server, (i.e. mws.amazonservices.com)
        :param Any marketplace_id: The Amazon Marketplace ID you want to retrieve data from. To retrieve data from multiple Marketplace IDs, separate them with a comma (,). (i.e. A2EUQ1WTGCTBG2)
        :param Any seller_id: The Amazon seller ID.
        :param str type: Type of linked service.
               Expected value is 'AmazonMWS'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] mws_auth_token: The Amazon MWS authentication token.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] secret_key: The secret key used to access data.
        :param Any use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        :param Any use_host_verification: Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        :param Any use_peer_verification: Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        pulumi.set(__self__, "access_key_id", access_key_id)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "marketplace_id", marketplace_id)
        pulumi.set(__self__, "seller_id", seller_id)
        pulumi.set(__self__, "type", 'AmazonMWS')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if mws_auth_token is not None:
            pulumi.set(__self__, "mws_auth_token", mws_auth_token)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if use_encrypted_endpoints is not None:
            pulumi.set(__self__, "use_encrypted_endpoints", use_encrypted_endpoints)
        if use_host_verification is not None:
            pulumi.set(__self__, "use_host_verification", use_host_verification)
        if use_peer_verification is not None:
            pulumi.set(__self__, "use_peer_verification", use_peer_verification)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Any:
        """
        The access key id used to access data.
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter
    def endpoint(self) -> Any:
        """
        The endpoint of the Amazon MWS server, (i.e. mws.amazonservices.com)
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="marketplaceID")
    def marketplace_id(self) -> Any:
        """
        The Amazon Marketplace ID you want to retrieve data from. To retrieve data from multiple Marketplace IDs, separate them with a comma (,). (i.e. A2EUQ1WTGCTBG2)
        """
        return pulumi.get(self, "marketplace_id")

    @property
    @pulumi.getter(name="sellerID")
    def seller_id(self) -> Any:
        """
        The Amazon seller ID.
        """
        return pulumi.get(self, "seller_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'AmazonMWS'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter(name="mwsAuthToken")
    def mws_auth_token(self) -> Optional[Any]:
        """
        The Amazon MWS authentication token.
        """
        return pulumi.get(self, "mws_auth_token")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[Any]:
        """
        The secret key used to access data.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="useEncryptedEndpoints")
    def use_encrypted_endpoints(self) -> Optional[Any]:
        """
        Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        """
        return pulumi.get(self, "use_encrypted_endpoints")

    @property
    @pulumi.getter(name="useHostVerification")
    def use_host_verification(self) -> Optional[Any]:
        """
        Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_host_verification")

    @property
    @pulumi.getter(name="usePeerVerification")
    def use_peer_verification(self) -> Optional[Any]:
        """
        Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_peer_verification")


@pulumi.output_type
class AmazonMWSObjectDatasetResponse(dict):
    """
    Amazon Marketplace Web Service dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AmazonMWSObjectDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AmazonMWSObjectDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AmazonMWSObjectDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Amazon Marketplace Web Service dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'AmazonMWSObject'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'AmazonMWSObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'AmazonMWSObject'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class AmazonMWSSourceResponse(dict):
    """
    A copy activity Amazon Marketplace Web Service source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AmazonMWSSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AmazonMWSSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AmazonMWSSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Amazon Marketplace Web Service source.
        :param str type: Copy source type.
               Expected value is 'AmazonMWSSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'AmazonMWSSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'AmazonMWSSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class AmazonRedshiftLinkedServiceResponse(dict):
    """
    Linked service for Amazon Redshift.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AmazonRedshiftLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AmazonRedshiftLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AmazonRedshiftLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database: Any,
                 server: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 port: Optional[Any] = None,
                 username: Optional[Any] = None):
        """
        Linked service for Amazon Redshift.
        :param Any database: The database name of the Amazon Redshift source. Type: string (or Expression with resultType string).
        :param Any server: The name of the Amazon Redshift server. Type: string (or Expression with resultType string).
        :param str type: Type of linked service.
               Expected value is 'AmazonRedshift'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: The password of the Amazon Redshift source.
        :param Any port: The TCP port number that the Amazon Redshift server uses to listen for client connections. The default value is 5439. Type: integer (or Expression with resultType integer).
        :param Any username: The username of the Amazon Redshift source. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "server", server)
        pulumi.set(__self__, "type", 'AmazonRedshift')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def database(self) -> Any:
        """
        The database name of the Amazon Redshift source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def server(self) -> Any:
        """
        The name of the Amazon Redshift server. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'AmazonRedshift'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        The password of the Amazon Redshift source.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The TCP port number that the Amazon Redshift server uses to listen for client connections. The default value is 5439. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def username(self) -> Optional[Any]:
        """
        The username of the Amazon Redshift source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class AmazonRedshiftSourceResponse(dict):
    """
    A copy activity source for Amazon Redshift Source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "redshiftUnloadSettings":
            suggest = "redshift_unload_settings"
        elif key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AmazonRedshiftSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AmazonRedshiftSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AmazonRedshiftSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 redshift_unload_settings: Optional['outputs.RedshiftUnloadSettingsResponse'] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity source for Amazon Redshift Source.
        :param str type: Copy source type.
               Expected value is 'AmazonRedshiftSource'.
        :param Any query: Database query. Type: string (or Expression with resultType string).
        :param 'RedshiftUnloadSettingsResponse' redshift_unload_settings: The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3.
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'AmazonRedshiftSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if redshift_unload_settings is not None:
            pulumi.set(__self__, "redshift_unload_settings", redshift_unload_settings)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'AmazonRedshiftSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        Database query. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="redshiftUnloadSettings")
    def redshift_unload_settings(self) -> Optional['outputs.RedshiftUnloadSettingsResponse']:
        """
        The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3.
        """
        return pulumi.get(self, "redshift_unload_settings")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class AmazonS3DatasetResponse(dict):
    """
    A single Amazon Simple Storage Service (S3) object or a set of S3 objects.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AmazonS3DatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AmazonS3DatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AmazonS3DatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: Any,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 compression: Optional[Any] = None,
                 description: Optional[str] = None,
                 format: Optional[Any] = None,
                 key: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 prefix: Optional[Any] = None,
                 structure: Optional[Any] = None,
                 version: Optional[Any] = None):
        """
        A single Amazon Simple Storage Service (S3) object or a set of S3 objects.
        :param Any bucket_name: The name of the Amazon S3 bucket. Type: string (or Expression with resultType string).
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'AmazonS3Object'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param Union['DatasetBZip2CompressionResponse', 'DatasetDeflateCompressionResponse', 'DatasetGZipCompressionResponse', 'DatasetZipDeflateCompressionResponse'] compression: The data compression method used for the Amazon S3 object.
        :param str description: Dataset description.
        :param Union['AvroFormatResponse', 'JsonFormatResponse', 'OrcFormatResponse', 'ParquetFormatResponse', 'TextFormatResponse'] format: The format of files.
        :param Any key: The key of the Amazon S3 object. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any prefix: The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        :param Any version: The version for the S3 object. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'AmazonS3Object')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Any:
        """
        The name of the Amazon S3 bucket. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'AmazonS3Object'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def compression(self) -> Optional[Any]:
        """
        The data compression method used for the Amazon S3 object.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def format(self) -> Optional[Any]:
        """
        The format of files.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def key(self) -> Optional[Any]:
        """
        The key of the Amazon S3 object. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[Any]:
        """
        The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @property
    @pulumi.getter
    def version(self) -> Optional[Any]:
        """
        The version for the S3 object. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class AmazonS3LinkedServiceResponse(dict):
    """
    Linked service for Amazon S3.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "secretAccessKey":
            suggest = "secret_access_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AmazonS3LinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AmazonS3LinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AmazonS3LinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 access_key_id: Optional[Any] = None,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 secret_access_key: Optional[Any] = None):
        """
        Linked service for Amazon S3.
        :param str type: Type of linked service.
               Expected value is 'AmazonS3'.
        :param Any access_key_id: The access key identifier of the Amazon S3 Identity and Access Management (IAM) user. Type: string (or Expression with resultType string).
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] secret_access_key: The secret access key of the Amazon S3 Identity and Access Management (IAM) user.
        """
        pulumi.set(__self__, "type", 'AmazonS3')
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'AmazonS3'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[Any]:
        """
        The access key identifier of the Amazon S3 Identity and Access Management (IAM) user. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[Any]:
        """
        The secret access key of the Amazon S3 Identity and Access Management (IAM) user.
        """
        return pulumi.get(self, "secret_access_key")


@pulumi.output_type
class AvroFormatResponse(dict):
    """
    The data stored in Avro format.
    """
    def __init__(__self__, *,
                 type: str,
                 deserializer: Optional[Any] = None,
                 serializer: Optional[Any] = None):
        """
        The data stored in Avro format.
        :param str type: Type of dataset storage format.
               Expected value is 'AvroFormat'.
        :param Any deserializer: Deserializer. Type: string (or Expression with resultType string).
        :param Any serializer: Serializer. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "type", 'AvroFormat')
        if deserializer is not None:
            pulumi.set(__self__, "deserializer", deserializer)
        if serializer is not None:
            pulumi.set(__self__, "serializer", serializer)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset storage format.
        Expected value is 'AvroFormat'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def deserializer(self) -> Optional[Any]:
        """
        Deserializer. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "deserializer")

    @property
    @pulumi.getter
    def serializer(self) -> Optional[Any]:
        """
        Serializer. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "serializer")


@pulumi.output_type
class AzureBatchLinkedServiceResponse(dict):
    """
    Azure Batch linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "batchUri":
            suggest = "batch_uri"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "poolName":
            suggest = "pool_name"
        elif key == "accessKey":
            suggest = "access_key"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureBatchLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureBatchLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureBatchLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: Any,
                 batch_uri: Any,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 pool_name: Any,
                 type: str,
                 access_key: Optional[Any] = None,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None):
        """
        Azure Batch linked service.
        :param Any account_name: The Azure Batch account name. Type: string (or Expression with resultType string).
        :param Any batch_uri: The Azure Batch URI. Type: string (or Expression with resultType string).
        :param 'LinkedServiceReferenceResponse' linked_service_name: The Azure Storage linked service reference.
        :param Any pool_name: The Azure Batch pool name. Type: string (or Expression with resultType string).
        :param str type: Type of linked service.
               Expected value is 'AzureBatch'.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] access_key: The Azure Batch account access key.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "batch_uri", batch_uri)
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "pool_name", pool_name)
        pulumi.set(__self__, "type", 'AzureBatch')
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Any:
        """
        The Azure Batch account name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="batchUri")
    def batch_uri(self) -> Any:
        """
        The Azure Batch URI. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "batch_uri")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        The Azure Storage linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> Any:
        """
        The Azure Batch pool name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "pool_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'AzureBatch'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[Any]:
        """
        The Azure Batch account access key.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class AzureBlobDatasetResponse(dict):
    """
    The Azure Blob storage.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "fileName":
            suggest = "file_name"
        elif key == "folderPath":
            suggest = "folder_path"
        elif key == "tableRootLocation":
            suggest = "table_root_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureBlobDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureBlobDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureBlobDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 compression: Optional[Any] = None,
                 description: Optional[str] = None,
                 file_name: Optional[Any] = None,
                 folder_path: Optional[Any] = None,
                 format: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None,
                 table_root_location: Optional[Any] = None):
        """
        The Azure Blob storage.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'AzureBlob'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param Union['DatasetBZip2CompressionResponse', 'DatasetDeflateCompressionResponse', 'DatasetGZipCompressionResponse', 'DatasetZipDeflateCompressionResponse'] compression: The data compression method used for the blob storage.
        :param str description: Dataset description.
        :param Any file_name: The name of the Azure Blob. Type: string (or Expression with resultType string).
        :param Any folder_path: The path of the Azure Blob storage. Type: string (or Expression with resultType string).
        :param Union['AvroFormatResponse', 'JsonFormatResponse', 'OrcFormatResponse', 'ParquetFormatResponse', 'TextFormatResponse'] format: The format of the Azure Blob storage.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        :param Any table_root_location: The root of blob path. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'AzureBlob')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if folder_path is not None:
            pulumi.set(__self__, "folder_path", folder_path)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)
        if table_root_location is not None:
            pulumi.set(__self__, "table_root_location", table_root_location)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'AzureBlob'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def compression(self) -> Optional[Any]:
        """
        The data compression method used for the blob storage.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[Any]:
        """
        The name of the Azure Blob. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> Optional[Any]:
        """
        The path of the Azure Blob storage. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "folder_path")

    @property
    @pulumi.getter
    def format(self) -> Optional[Any]:
        """
        The format of the Azure Blob storage.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @property
    @pulumi.getter(name="tableRootLocation")
    def table_root_location(self) -> Optional[Any]:
        """
        The root of blob path. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "table_root_location")


@pulumi.output_type
class AzureDataLakeAnalyticsLinkedServiceResponse(dict):
    """
    Azure Data Lake Analytics linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "dataLakeAnalyticsUri":
            suggest = "data_lake_analytics_uri"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "resourceGroupName":
            suggest = "resource_group_name"
        elif key == "servicePrincipalId":
            suggest = "service_principal_id"
        elif key == "servicePrincipalKey":
            suggest = "service_principal_key"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureDataLakeAnalyticsLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureDataLakeAnalyticsLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureDataLakeAnalyticsLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: Any,
                 tenant: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 data_lake_analytics_uri: Optional[Any] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 resource_group_name: Optional[Any] = None,
                 service_principal_id: Optional[Any] = None,
                 service_principal_key: Optional[Any] = None,
                 subscription_id: Optional[Any] = None):
        """
        Azure Data Lake Analytics linked service.
        :param Any account_name: The Azure Data Lake Analytics account name. Type: string (or Expression with resultType string).
        :param Any tenant: The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        :param str type: Type of linked service.
               Expected value is 'AzureDataLakeAnalytics'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param Any data_lake_analytics_uri: Azure Data Lake Analytics URI Type: string (or Expression with resultType string).
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Any resource_group_name: Data Lake Analytics account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
        :param Any service_principal_id: The ID of the application used to authenticate against the Azure Data Lake Analytics account. Type: string (or Expression with resultType string).
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] service_principal_key: The Key of the application used to authenticate against the Azure Data Lake Analytics account.
        :param Any subscription_id: Data Lake Analytics account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "tenant", tenant)
        pulumi.set(__self__, "type", 'AzureDataLakeAnalytics')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if data_lake_analytics_uri is not None:
            pulumi.set(__self__, "data_lake_analytics_uri", data_lake_analytics_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Any:
        """
        The Azure Data Lake Analytics account name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def tenant(self) -> Any:
        """
        The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "tenant")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'AzureDataLakeAnalytics'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter(name="dataLakeAnalyticsUri")
    def data_lake_analytics_uri(self) -> Optional[Any]:
        """
        Azure Data Lake Analytics URI Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "data_lake_analytics_uri")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[Any]:
        """
        Data Lake Analytics account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[Any]:
        """
        The ID of the application used to authenticate against the Azure Data Lake Analytics account. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "service_principal_id")

    @property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[Any]:
        """
        The Key of the application used to authenticate against the Azure Data Lake Analytics account.
        """
        return pulumi.get(self, "service_principal_key")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[Any]:
        """
        Data Lake Analytics account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class AzureDataLakeStoreDatasetResponse(dict):
    """
    Azure Data Lake Store dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "folderPath":
            suggest = "folder_path"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "fileName":
            suggest = "file_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureDataLakeStoreDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureDataLakeStoreDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureDataLakeStoreDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 folder_path: Any,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 compression: Optional[Any] = None,
                 description: Optional[str] = None,
                 file_name: Optional[Any] = None,
                 format: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Azure Data Lake Store dataset.
        :param Any folder_path: Path to the folder in the Azure Data Lake Store. Type: string (or Expression with resultType string).
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'AzureDataLakeStoreFile'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param Union['DatasetBZip2CompressionResponse', 'DatasetDeflateCompressionResponse', 'DatasetGZipCompressionResponse', 'DatasetZipDeflateCompressionResponse'] compression: The data compression method used for the item(s) in the Azure Data Lake Store.
        :param str description: Dataset description.
        :param Any file_name: The name of the file in the Azure Data Lake Store. Type: string (or Expression with resultType string).
        :param Union['AvroFormatResponse', 'JsonFormatResponse', 'OrcFormatResponse', 'ParquetFormatResponse', 'TextFormatResponse'] format: The format of the Data Lake Store.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "folder_path", folder_path)
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'AzureDataLakeStoreFile')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> Any:
        """
        Path to the folder in the Azure Data Lake Store. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "folder_path")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'AzureDataLakeStoreFile'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def compression(self) -> Optional[Any]:
        """
        The data compression method used for the item(s) in the Azure Data Lake Store.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[Any]:
        """
        The name of the file in the Azure Data Lake Store. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter
    def format(self) -> Optional[Any]:
        """
        The format of the Data Lake Store.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class AzureDataLakeStoreLinkedServiceResponse(dict):
    """
    Azure Data Lake Store linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataLakeStoreUri":
            suggest = "data_lake_store_uri"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "resourceGroupName":
            suggest = "resource_group_name"
        elif key == "servicePrincipalId":
            suggest = "service_principal_id"
        elif key == "servicePrincipalKey":
            suggest = "service_principal_key"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureDataLakeStoreLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureDataLakeStoreLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureDataLakeStoreLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_lake_store_uri: Any,
                 type: str,
                 account_name: Optional[Any] = None,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 resource_group_name: Optional[Any] = None,
                 service_principal_id: Optional[Any] = None,
                 service_principal_key: Optional[Any] = None,
                 subscription_id: Optional[Any] = None,
                 tenant: Optional[Any] = None):
        """
        Azure Data Lake Store linked service.
        :param Any data_lake_store_uri: Data Lake Store service URI. Type: string (or Expression with resultType string).
        :param str type: Type of linked service.
               Expected value is 'AzureDataLakeStore'.
        :param Any account_name: Data Lake Store account name. Type: string (or Expression with resultType string).
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Any resource_group_name: Data Lake Store account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
        :param Any service_principal_id: The ID of the application used to authenticate against the Azure Data Lake Store account. Type: string (or Expression with resultType string).
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] service_principal_key: The Key of the application used to authenticate against the Azure Data Lake Store account.
        :param Any subscription_id: Data Lake Store account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
        :param Any tenant: The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "data_lake_store_uri", data_lake_store_uri)
        pulumi.set(__self__, "type", 'AzureDataLakeStore')
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)

    @property
    @pulumi.getter(name="dataLakeStoreUri")
    def data_lake_store_uri(self) -> Any:
        """
        Data Lake Store service URI. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "data_lake_store_uri")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'AzureDataLakeStore'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[Any]:
        """
        Data Lake Store account name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[Any]:
        """
        Data Lake Store account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[Any]:
        """
        The ID of the application used to authenticate against the Azure Data Lake Store account. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "service_principal_id")

    @property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[Any]:
        """
        The Key of the application used to authenticate against the Azure Data Lake Store account.
        """
        return pulumi.get(self, "service_principal_key")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[Any]:
        """
        Data Lake Store account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter
    def tenant(self) -> Optional[Any]:
        """
        The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "tenant")


@pulumi.output_type
class AzureDataLakeStoreSinkResponse(dict):
    """
    A copy activity Azure Data Lake Store sink.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyBehavior":
            suggest = "copy_behavior"
        elif key == "sinkRetryCount":
            suggest = "sink_retry_count"
        elif key == "sinkRetryWait":
            suggest = "sink_retry_wait"
        elif key == "writeBatchSize":
            suggest = "write_batch_size"
        elif key == "writeBatchTimeout":
            suggest = "write_batch_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureDataLakeStoreSinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureDataLakeStoreSinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureDataLakeStoreSinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 copy_behavior: Optional[Any] = None,
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None):
        """
        A copy activity Azure Data Lake Store sink.
        :param str type: Copy sink type.
               Expected value is 'AzureDataLakeStoreSink'.
        :param Any copy_behavior: The type of copy behavior for copy sink.
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'AzureDataLakeStoreSink')
        if copy_behavior is not None:
            pulumi.set(__self__, "copy_behavior", copy_behavior)
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy sink type.
        Expected value is 'AzureDataLakeStoreSink'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="copyBehavior")
    def copy_behavior(self) -> Optional[Any]:
        """
        The type of copy behavior for copy sink.
        """
        return pulumi.get(self, "copy_behavior")

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")


@pulumi.output_type
class AzureDataLakeStoreSourceResponse(dict):
    """
    A copy activity Azure Data Lake source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureDataLakeStoreSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureDataLakeStoreSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureDataLakeStoreSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 recursive: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Azure Data Lake source.
        :param str type: Copy source type.
               Expected value is 'AzureDataLakeStoreSource'.
        :param Any recursive: If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'AzureDataLakeStoreSource')
        if recursive is not None:
            pulumi.set(__self__, "recursive", recursive)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'AzureDataLakeStoreSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def recursive(self) -> Optional[Any]:
        """
        If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "recursive")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class AzureDatabricksLinkedServiceResponse(dict):
    """
    Azure Databricks linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessToken":
            suggest = "access_token"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "existingClusterId":
            suggest = "existing_cluster_id"
        elif key == "newClusterNodeType":
            suggest = "new_cluster_node_type"
        elif key == "newClusterNumOfWorker":
            suggest = "new_cluster_num_of_worker"
        elif key == "newClusterSparkConf":
            suggest = "new_cluster_spark_conf"
        elif key == "newClusterVersion":
            suggest = "new_cluster_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureDatabricksLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureDatabricksLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureDatabricksLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_token: Any,
                 domain: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 existing_cluster_id: Optional[Any] = None,
                 new_cluster_node_type: Optional[Any] = None,
                 new_cluster_num_of_worker: Optional[Any] = None,
                 new_cluster_spark_conf: Optional[Mapping[str, Any]] = None,
                 new_cluster_version: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None):
        """
        Azure Databricks linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] access_token: Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression with resultType string).
        :param Any domain: <REGION>.azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType string).
        :param str type: Type of linked service.
               Expected value is 'AzureDatabricks'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Any existing_cluster_id: The id of an existing cluster that will be used for all runs of this job. Type: string (or Expression with resultType string).
        :param Any new_cluster_node_type: The node types of new cluster. Type: string (or Expression with resultType string).
        :param Any new_cluster_num_of_worker: Number of worker nodes that new cluster should have. A string formatted Int32, like '1' means numOfWorker is 1 or '1:10' means auto-scale from 1 as min and 10 as max. Type: string (or Expression with resultType string).
        :param Mapping[str, Any] new_cluster_spark_conf: a set of optional, user-specified Spark configuration key-value pairs.
        :param Any new_cluster_version: The Spark version of new cluster. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "access_token", access_token)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "type", 'AzureDatabricks')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if existing_cluster_id is not None:
            pulumi.set(__self__, "existing_cluster_id", existing_cluster_id)
        if new_cluster_node_type is not None:
            pulumi.set(__self__, "new_cluster_node_type", new_cluster_node_type)
        if new_cluster_num_of_worker is not None:
            pulumi.set(__self__, "new_cluster_num_of_worker", new_cluster_num_of_worker)
        if new_cluster_spark_conf is not None:
            pulumi.set(__self__, "new_cluster_spark_conf", new_cluster_spark_conf)
        if new_cluster_version is not None:
            pulumi.set(__self__, "new_cluster_version", new_cluster_version)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Any:
        """
        Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter
    def domain(self) -> Any:
        """
        <REGION>.azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'AzureDatabricks'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter(name="existingClusterId")
    def existing_cluster_id(self) -> Optional[Any]:
        """
        The id of an existing cluster that will be used for all runs of this job. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "existing_cluster_id")

    @property
    @pulumi.getter(name="newClusterNodeType")
    def new_cluster_node_type(self) -> Optional[Any]:
        """
        The node types of new cluster. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "new_cluster_node_type")

    @property
    @pulumi.getter(name="newClusterNumOfWorker")
    def new_cluster_num_of_worker(self) -> Optional[Any]:
        """
        Number of worker nodes that new cluster should have. A string formatted Int32, like '1' means numOfWorker is 1 or '1:10' means auto-scale from 1 as min and 10 as max. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "new_cluster_num_of_worker")

    @property
    @pulumi.getter(name="newClusterSparkConf")
    def new_cluster_spark_conf(self) -> Optional[Mapping[str, Any]]:
        """
        a set of optional, user-specified Spark configuration key-value pairs.
        """
        return pulumi.get(self, "new_cluster_spark_conf")

    @property
    @pulumi.getter(name="newClusterVersion")
    def new_cluster_version(self) -> Optional[Any]:
        """
        The Spark version of new cluster. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "new_cluster_version")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class AzureKeyVaultLinkedServiceResponse(dict):
    """
    Azure Key Vault linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"
        elif key == "connectVia":
            suggest = "connect_via"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureKeyVaultLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureKeyVaultLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureKeyVaultLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None):
        """
        Azure Key Vault linked service.
        :param Any base_url: The base URL of the Azure Key Vault. e.g. https://myakv.vault.azure.net Type: string (or Expression with resultType string).
        :param str type: Type of linked service.
               Expected value is 'AzureKeyVault'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "type", 'AzureKeyVault')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Any:
        """
        The base URL of the Azure Key Vault. e.g. https://myakv.vault.azure.net Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'AzureKeyVault'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class AzureKeyVaultSecretReferenceResponse(dict):
    """
    Azure Key Vault secret reference.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"
        elif key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureKeyVaultSecretReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureKeyVaultSecretReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureKeyVaultSecretReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_name: Any,
                 store: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 secret_version: Optional[Any] = None):
        """
        Azure Key Vault secret reference.
        :param Any secret_name: The name of the secret in Azure Key Vault. Type: string (or Expression with resultType string).
        :param 'LinkedServiceReferenceResponse' store: The Azure Key Vault linked service reference.
        :param str type: Type of the secret.
               Expected value is 'AzureKeyVaultSecret'.
        :param Any secret_version: The version of the secret in Azure Key Vault. The default value is the latest version of the secret. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "store", store)
        pulumi.set(__self__, "type", 'AzureKeyVaultSecret')
        if secret_version is not None:
            pulumi.set(__self__, "secret_version", secret_version)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Any:
        """
        The name of the secret in Azure Key Vault. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "secret_name")

    @property
    @pulumi.getter
    def store(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        The Azure Key Vault linked service reference.
        """
        return pulumi.get(self, "store")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the secret.
        Expected value is 'AzureKeyVaultSecret'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> Optional[Any]:
        """
        The version of the secret in Azure Key Vault. The default value is the latest version of the secret. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class AzureMLBatchExecutionActivityResponse(dict):
    """
    Azure ML Batch Execution activity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOn":
            suggest = "depends_on"
        elif key == "globalParameters":
            suggest = "global_parameters"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "webServiceInputs":
            suggest = "web_service_inputs"
        elif key == "webServiceOutputs":
            suggest = "web_service_outputs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureMLBatchExecutionActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureMLBatchExecutionActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureMLBatchExecutionActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None,
                 global_parameters: Optional[Mapping[str, Any]] = None,
                 linked_service_name: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 policy: Optional['outputs.ActivityPolicyResponse'] = None,
                 web_service_inputs: Optional[Mapping[str, 'outputs.AzureMLWebServiceFileResponse']] = None,
                 web_service_outputs: Optional[Mapping[str, 'outputs.AzureMLWebServiceFileResponse']] = None):
        """
        Azure ML Batch Execution activity.
        :param str name: Activity name.
        :param str type: Type of activity.
               Expected value is 'AzureMLBatchExecution'.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        :param Mapping[str, Any] global_parameters: Key,Value pairs to be passed to the Azure ML Batch Execution Service endpoint. Keys must match the names of web service parameters defined in the published Azure ML web service. Values will be passed in the GlobalParameters property of the Azure ML batch execution request.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param 'ActivityPolicyResponse' policy: Activity policy.
        :param Mapping[str, 'AzureMLWebServiceFileResponse'] web_service_inputs: Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Inputs to AzureMLWebServiceFile objects specifying the input Blob locations.. This information will be passed in the WebServiceInputs property of the Azure ML batch execution request.
        :param Mapping[str, 'AzureMLWebServiceFileResponse'] web_service_outputs: Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Outputs to AzureMLWebServiceFile objects specifying the output Blob locations. This information will be passed in the WebServiceOutputs property of the Azure ML batch execution request.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'AzureMLBatchExecution')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if global_parameters is not None:
            pulumi.set(__self__, "global_parameters", global_parameters)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if web_service_inputs is not None:
            pulumi.set(__self__, "web_service_inputs", web_service_inputs)
        if web_service_outputs is not None:
            pulumi.set(__self__, "web_service_outputs", web_service_outputs)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'AzureMLBatchExecution'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="globalParameters")
    def global_parameters(self) -> Optional[Mapping[str, Any]]:
        """
        Key,Value pairs to be passed to the Azure ML Batch Execution Service endpoint. Keys must match the names of web service parameters defined in the published Azure ML web service. Values will be passed in the GlobalParameters property of the Azure ML batch execution request.
        """
        return pulumi.get(self, "global_parameters")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def policy(self) -> Optional['outputs.ActivityPolicyResponse']:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="webServiceInputs")
    def web_service_inputs(self) -> Optional[Mapping[str, 'outputs.AzureMLWebServiceFileResponse']]:
        """
        Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Inputs to AzureMLWebServiceFile objects specifying the input Blob locations.. This information will be passed in the WebServiceInputs property of the Azure ML batch execution request.
        """
        return pulumi.get(self, "web_service_inputs")

    @property
    @pulumi.getter(name="webServiceOutputs")
    def web_service_outputs(self) -> Optional[Mapping[str, 'outputs.AzureMLWebServiceFileResponse']]:
        """
        Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Outputs to AzureMLWebServiceFile objects specifying the output Blob locations. This information will be passed in the WebServiceOutputs property of the Azure ML batch execution request.
        """
        return pulumi.get(self, "web_service_outputs")


@pulumi.output_type
class AzureMLLinkedServiceResponse(dict):
    """
    Azure ML Web Service linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "mlEndpoint":
            suggest = "ml_endpoint"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "servicePrincipalId":
            suggest = "service_principal_id"
        elif key == "servicePrincipalKey":
            suggest = "service_principal_key"
        elif key == "updateResourceEndpoint":
            suggest = "update_resource_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureMLLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureMLLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureMLLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Any,
                 ml_endpoint: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 service_principal_id: Optional[Any] = None,
                 service_principal_key: Optional[Any] = None,
                 tenant: Optional[Any] = None,
                 update_resource_endpoint: Optional[Any] = None):
        """
        Azure ML Web Service linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] api_key: The API key for accessing the Azure ML model endpoint.
        :param Any ml_endpoint: The Batch Execution REST URL for an Azure ML Web Service endpoint. Type: string (or Expression with resultType string).
        :param str type: Type of linked service.
               Expected value is 'AzureML'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Any service_principal_id: The ID of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML web service. Type: string (or Expression with resultType string).
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] service_principal_key: The key of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML web service.
        :param Any tenant: The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        :param Any update_resource_endpoint: The Update Resource REST URL for an Azure ML Web Service endpoint. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "ml_endpoint", ml_endpoint)
        pulumi.set(__self__, "type", 'AzureML')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)
        if update_resource_endpoint is not None:
            pulumi.set(__self__, "update_resource_endpoint", update_resource_endpoint)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Any:
        """
        The API key for accessing the Azure ML model endpoint.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="mlEndpoint")
    def ml_endpoint(self) -> Any:
        """
        The Batch Execution REST URL for an Azure ML Web Service endpoint. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "ml_endpoint")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'AzureML'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[Any]:
        """
        The ID of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML web service. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "service_principal_id")

    @property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[Any]:
        """
        The key of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML web service.
        """
        return pulumi.get(self, "service_principal_key")

    @property
    @pulumi.getter
    def tenant(self) -> Optional[Any]:
        """
        The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "tenant")

    @property
    @pulumi.getter(name="updateResourceEndpoint")
    def update_resource_endpoint(self) -> Optional[Any]:
        """
        The Update Resource REST URL for an Azure ML Web Service endpoint. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "update_resource_endpoint")


@pulumi.output_type
class AzureMLUpdateResourceActivityResponse(dict):
    """
    Azure ML Update Resource management activity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trainedModelFilePath":
            suggest = "trained_model_file_path"
        elif key == "trainedModelLinkedServiceName":
            suggest = "trained_model_linked_service_name"
        elif key == "trainedModelName":
            suggest = "trained_model_name"
        elif key == "dependsOn":
            suggest = "depends_on"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureMLUpdateResourceActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureMLUpdateResourceActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureMLUpdateResourceActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 trained_model_file_path: Any,
                 trained_model_linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 trained_model_name: Any,
                 type: str,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None,
                 linked_service_name: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 policy: Optional['outputs.ActivityPolicyResponse'] = None):
        """
        Azure ML Update Resource management activity.
        :param str name: Activity name.
        :param Any trained_model_file_path: The relative file path in trainedModelLinkedService to represent the .ilearner file that will be uploaded by the update operation.  Type: string (or Expression with resultType string).
        :param 'LinkedServiceReferenceResponse' trained_model_linked_service_name: Name of Azure Storage linked service holding the .ilearner file that will be uploaded by the update operation.
        :param Any trained_model_name: Name of the Trained Model module in the Web Service experiment to be updated. Type: string (or Expression with resultType string).
        :param str type: Type of activity.
               Expected value is 'AzureMLUpdateResource'.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param 'ActivityPolicyResponse' policy: Activity policy.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "trained_model_file_path", trained_model_file_path)
        pulumi.set(__self__, "trained_model_linked_service_name", trained_model_linked_service_name)
        pulumi.set(__self__, "trained_model_name", trained_model_name)
        pulumi.set(__self__, "type", 'AzureMLUpdateResource')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="trainedModelFilePath")
    def trained_model_file_path(self) -> Any:
        """
        The relative file path in trainedModelLinkedService to represent the .ilearner file that will be uploaded by the update operation.  Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "trained_model_file_path")

    @property
    @pulumi.getter(name="trainedModelLinkedServiceName")
    def trained_model_linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Name of Azure Storage linked service holding the .ilearner file that will be uploaded by the update operation.
        """
        return pulumi.get(self, "trained_model_linked_service_name")

    @property
    @pulumi.getter(name="trainedModelName")
    def trained_model_name(self) -> Any:
        """
        Name of the Trained Model module in the Web Service experiment to be updated. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "trained_model_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'AzureMLUpdateResource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def policy(self) -> Optional['outputs.ActivityPolicyResponse']:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")


@pulumi.output_type
class AzureMLWebServiceFileResponse(dict):
    """
    Azure ML WebService Input/Output file
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePath":
            suggest = "file_path"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureMLWebServiceFileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureMLWebServiceFileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureMLWebServiceFileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_path: Any,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse'):
        """
        Azure ML WebService Input/Output file
        :param Any file_path: The relative file path, including container name, in the Azure Blob Storage specified by the LinkedService. Type: string (or Expression with resultType string).
        :param 'LinkedServiceReferenceResponse' linked_service_name: Reference to an Azure Storage LinkedService, where Azure ML WebService Input/Output file located.
        """
        pulumi.set(__self__, "file_path", file_path)
        pulumi.set(__self__, "linked_service_name", linked_service_name)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Any:
        """
        The relative file path, including container name, in the Azure Blob Storage specified by the LinkedService. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "file_path")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Reference to an Azure Storage LinkedService, where Azure ML WebService Input/Output file located.
        """
        return pulumi.get(self, "linked_service_name")


@pulumi.output_type
class AzureMySqlLinkedServiceResponse(dict):
    """
    Azure MySQL database linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureMySqlLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureMySqlLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureMySqlLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None):
        """
        Azure MySQL database linked service.
        :param Any connection_string: The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param str type: Type of linked service.
               Expected value is 'AzureMySql'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "type", 'AzureMySql')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Any:
        """
        The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'AzureMySql'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class AzureMySqlSourceResponse(dict):
    """
    A copy activity Azure MySQL source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureMySqlSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureMySqlSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureMySqlSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Azure MySQL source.
        :param str type: Copy source type.
               Expected value is 'AzureMySqlSource'.
        :param Any query: Database query. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'AzureMySqlSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'AzureMySqlSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        Database query. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class AzureMySqlTableDatasetResponse(dict):
    """
    The Azure MySQL database dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureMySqlTableDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureMySqlTableDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureMySqlTableDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None,
                 table_name: Optional[Any] = None):
        """
        The Azure MySQL database dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'AzureMySqlTable'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        :param Any table_name: The Azure MySQL database table name. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'AzureMySqlTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'AzureMySqlTable'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[Any]:
        """
        The Azure MySQL database table name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "table_name")


@pulumi.output_type
class AzurePostgreSqlLinkedServiceResponse(dict):
    """
    Azure PostgreSQL linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectVia":
            suggest = "connect_via"
        elif key == "connectionString":
            suggest = "connection_string"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzurePostgreSqlLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzurePostgreSqlLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzurePostgreSqlLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 connection_string: Optional[Any] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None):
        """
        Azure PostgreSQL linked service.
        :param str type: Type of linked service.
               Expected value is 'AzurePostgreSql'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param Any connection_string: An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "type", 'AzurePostgreSql')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'AzurePostgreSql'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[Any]:
        """
        An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class AzurePostgreSqlSourceResponse(dict):
    """
    A copy activity Azure PostgreSQL source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzurePostgreSqlSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzurePostgreSqlSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzurePostgreSqlSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Azure PostgreSQL source.
        :param str type: Copy source type.
               Expected value is 'AzurePostgreSqlSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'AzurePostgreSqlSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'AzurePostgreSqlSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class AzurePostgreSqlTableDatasetResponse(dict):
    """
    Azure PostgreSQL dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzurePostgreSqlTableDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzurePostgreSqlTableDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzurePostgreSqlTableDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Azure PostgreSQL dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'AzurePostgreSqlTable'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'AzurePostgreSqlTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'AzurePostgreSqlTable'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class AzureQueueSinkResponse(dict):
    """
    A copy activity Azure Queue sink.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sinkRetryCount":
            suggest = "sink_retry_count"
        elif key == "sinkRetryWait":
            suggest = "sink_retry_wait"
        elif key == "writeBatchSize":
            suggest = "write_batch_size"
        elif key == "writeBatchTimeout":
            suggest = "write_batch_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureQueueSinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureQueueSinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureQueueSinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None):
        """
        A copy activity Azure Queue sink.
        :param str type: Copy sink type.
               Expected value is 'AzureQueueSink'.
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'AzureQueueSink')
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy sink type.
        Expected value is 'AzureQueueSink'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")


@pulumi.output_type
class AzureSearchIndexDatasetResponse(dict):
    """
    The Azure Search Index.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexName":
            suggest = "index_name"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSearchIndexDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSearchIndexDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSearchIndexDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index_name: Any,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        The Azure Search Index.
        :param Any index_name: The name of the Azure Search Index. Type: string (or Expression with resultType string).
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'AzureSearchIndex'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "index_name", index_name)
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'AzureSearchIndex')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> Any:
        """
        The name of the Azure Search Index. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "index_name")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'AzureSearchIndex'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class AzureSearchIndexSinkResponse(dict):
    """
    A copy activity Azure Search Index sink.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sinkRetryCount":
            suggest = "sink_retry_count"
        elif key == "sinkRetryWait":
            suggest = "sink_retry_wait"
        elif key == "writeBatchSize":
            suggest = "write_batch_size"
        elif key == "writeBatchTimeout":
            suggest = "write_batch_timeout"
        elif key == "writeBehavior":
            suggest = "write_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSearchIndexSinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSearchIndexSinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSearchIndexSinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None,
                 write_behavior: Optional[str] = None):
        """
        A copy activity Azure Search Index sink.
        :param str type: Copy sink type.
               Expected value is 'AzureSearchIndexSink'.
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param str write_behavior: Specify the write behavior when upserting documents into Azure Search Index.
        """
        pulumi.set(__self__, "type", 'AzureSearchIndexSink')
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)
        if write_behavior is not None:
            pulumi.set(__self__, "write_behavior", write_behavior)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy sink type.
        Expected value is 'AzureSearchIndexSink'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")

    @property
    @pulumi.getter(name="writeBehavior")
    def write_behavior(self) -> Optional[str]:
        """
        Specify the write behavior when upserting documents into Azure Search Index.
        """
        return pulumi.get(self, "write_behavior")


@pulumi.output_type
class AzureSearchLinkedServiceResponse(dict):
    """
    Linked service for Windows Azure Search Service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSearchLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSearchLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSearchLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 url: Any,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 key: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None):
        """
        Linked service for Windows Azure Search Service.
        :param str type: Type of linked service.
               Expected value is 'AzureSearch'.
        :param Any url: URL for Azure Search service. Type: string (or Expression with resultType string).
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] key: Admin Key for Azure Search service
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "type", 'AzureSearch')
        pulumi.set(__self__, "url", url)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'AzureSearch'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> Any:
        """
        URL for Azure Search service. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def key(self) -> Optional[Any]:
        """
        Admin Key for Azure Search service
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class AzureSqlDWLinkedServiceResponse(dict):
    """
    Azure SQL Data Warehouse linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "servicePrincipalId":
            suggest = "service_principal_id"
        elif key == "servicePrincipalKey":
            suggest = "service_principal_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSqlDWLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSqlDWLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSqlDWLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 service_principal_id: Optional[Any] = None,
                 service_principal_key: Optional[Any] = None,
                 tenant: Optional[Any] = None):
        """
        Azure SQL Data Warehouse linked service.
        :param Any connection_string: The connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param str type: Type of linked service.
               Expected value is 'AzureSqlDW'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Any service_principal_id: The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] service_principal_key: The key of the service principal used to authenticate against Azure SQL Data Warehouse.
        :param Any tenant: The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "type", 'AzureSqlDW')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Any:
        """
        The connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'AzureSqlDW'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[Any]:
        """
        The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "service_principal_id")

    @property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[Any]:
        """
        The key of the service principal used to authenticate against Azure SQL Data Warehouse.
        """
        return pulumi.get(self, "service_principal_key")

    @property
    @pulumi.getter
    def tenant(self) -> Optional[Any]:
        """
        The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "tenant")


@pulumi.output_type
class AzureSqlDWTableDatasetResponse(dict):
    """
    The Azure SQL Data Warehouse dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSqlDWTableDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSqlDWTableDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSqlDWTableDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 table_name: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        The Azure SQL Data Warehouse dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param Any table_name: The table name of the Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
        :param str type: Type of dataset.
               Expected value is 'AzureSqlDWTable'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "type", 'AzureSqlDWTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Any:
        """
        The table name of the Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'AzureSqlDWTable'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class AzureSqlDatabaseLinkedServiceResponse(dict):
    """
    Microsoft Azure SQL Database linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "servicePrincipalId":
            suggest = "service_principal_id"
        elif key == "servicePrincipalKey":
            suggest = "service_principal_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSqlDatabaseLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSqlDatabaseLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSqlDatabaseLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 service_principal_id: Optional[Any] = None,
                 service_principal_key: Optional[Any] = None,
                 tenant: Optional[Any] = None):
        """
        Microsoft Azure SQL Database linked service.
        :param Any connection_string: The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param str type: Type of linked service.
               Expected value is 'AzureSqlDatabase'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Any service_principal_id: The ID of the service principal used to authenticate against Azure SQL Database. Type: string (or Expression with resultType string).
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] service_principal_key: The key of the service principal used to authenticate against Azure SQL Database.
        :param Any tenant: The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "type", 'AzureSqlDatabase')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Any:
        """
        The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'AzureSqlDatabase'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[Any]:
        """
        The ID of the service principal used to authenticate against Azure SQL Database. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "service_principal_id")

    @property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[Any]:
        """
        The key of the service principal used to authenticate against Azure SQL Database.
        """
        return pulumi.get(self, "service_principal_key")

    @property
    @pulumi.getter
    def tenant(self) -> Optional[Any]:
        """
        The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "tenant")


@pulumi.output_type
class AzureSqlTableDatasetResponse(dict):
    """
    The Azure SQL Server database dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSqlTableDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSqlTableDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSqlTableDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 table_name: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        The Azure SQL Server database dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param Any table_name: The table name of the Azure SQL database. Type: string (or Expression with resultType string).
        :param str type: Type of dataset.
               Expected value is 'AzureSqlTable'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "type", 'AzureSqlTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Any:
        """
        The table name of the Azure SQL database. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'AzureSqlTable'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class AzureStorageLinkedServiceResponse(dict):
    """
    The storage account linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectVia":
            suggest = "connect_via"
        elif key == "connectionString":
            suggest = "connection_string"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "sasUri":
            suggest = "sas_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureStorageLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureStorageLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureStorageLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 connection_string: Optional[Any] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 sas_uri: Optional[Any] = None):
        """
        The storage account linked service.
        :param str type: Type of linked service.
               Expected value is 'AzureStorage'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param Any connection_string: The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] sas_uri: SAS URI of the Azure Storage resource. It is mutually exclusive with connectionString property.
        """
        pulumi.set(__self__, "type", 'AzureStorage')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if sas_uri is not None:
            pulumi.set(__self__, "sas_uri", sas_uri)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'AzureStorage'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[Any]:
        """
        The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="sasUri")
    def sas_uri(self) -> Optional[Any]:
        """
        SAS URI of the Azure Storage resource. It is mutually exclusive with connectionString property.
        """
        return pulumi.get(self, "sas_uri")


@pulumi.output_type
class AzureTableDatasetResponse(dict):
    """
    The Azure Table storage dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureTableDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureTableDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureTableDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 table_name: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        The Azure Table storage dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param Any table_name: The table name of the Azure Table storage. Type: string (or Expression with resultType string).
        :param str type: Type of dataset.
               Expected value is 'AzureTable'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "type", 'AzureTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Any:
        """
        The table name of the Azure Table storage. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'AzureTable'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class AzureTableSinkResponse(dict):
    """
    A copy activity Azure Table sink.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureTableDefaultPartitionKeyValue":
            suggest = "azure_table_default_partition_key_value"
        elif key == "azureTableInsertType":
            suggest = "azure_table_insert_type"
        elif key == "azureTablePartitionKeyName":
            suggest = "azure_table_partition_key_name"
        elif key == "azureTableRowKeyName":
            suggest = "azure_table_row_key_name"
        elif key == "sinkRetryCount":
            suggest = "sink_retry_count"
        elif key == "sinkRetryWait":
            suggest = "sink_retry_wait"
        elif key == "writeBatchSize":
            suggest = "write_batch_size"
        elif key == "writeBatchTimeout":
            suggest = "write_batch_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureTableSinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureTableSinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureTableSinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 azure_table_default_partition_key_value: Optional[Any] = None,
                 azure_table_insert_type: Optional[Any] = None,
                 azure_table_partition_key_name: Optional[Any] = None,
                 azure_table_row_key_name: Optional[Any] = None,
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None):
        """
        A copy activity Azure Table sink.
        :param str type: Copy sink type.
               Expected value is 'AzureTableSink'.
        :param Any azure_table_default_partition_key_value: Azure Table default partition key value. Type: string (or Expression with resultType string).
        :param Any azure_table_insert_type: Azure Table insert type. Type: string (or Expression with resultType string).
        :param Any azure_table_partition_key_name: Azure Table partition key name. Type: string (or Expression with resultType string).
        :param Any azure_table_row_key_name: Azure Table row key name. Type: string (or Expression with resultType string).
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'AzureTableSink')
        if azure_table_default_partition_key_value is not None:
            pulumi.set(__self__, "azure_table_default_partition_key_value", azure_table_default_partition_key_value)
        if azure_table_insert_type is not None:
            pulumi.set(__self__, "azure_table_insert_type", azure_table_insert_type)
        if azure_table_partition_key_name is not None:
            pulumi.set(__self__, "azure_table_partition_key_name", azure_table_partition_key_name)
        if azure_table_row_key_name is not None:
            pulumi.set(__self__, "azure_table_row_key_name", azure_table_row_key_name)
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy sink type.
        Expected value is 'AzureTableSink'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="azureTableDefaultPartitionKeyValue")
    def azure_table_default_partition_key_value(self) -> Optional[Any]:
        """
        Azure Table default partition key value. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "azure_table_default_partition_key_value")

    @property
    @pulumi.getter(name="azureTableInsertType")
    def azure_table_insert_type(self) -> Optional[Any]:
        """
        Azure Table insert type. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "azure_table_insert_type")

    @property
    @pulumi.getter(name="azureTablePartitionKeyName")
    def azure_table_partition_key_name(self) -> Optional[Any]:
        """
        Azure Table partition key name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "azure_table_partition_key_name")

    @property
    @pulumi.getter(name="azureTableRowKeyName")
    def azure_table_row_key_name(self) -> Optional[Any]:
        """
        Azure Table row key name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "azure_table_row_key_name")

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")


@pulumi.output_type
class AzureTableSourceResponse(dict):
    """
    A copy activity Azure Table source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureTableSourceIgnoreTableNotFound":
            suggest = "azure_table_source_ignore_table_not_found"
        elif key == "azureTableSourceQuery":
            suggest = "azure_table_source_query"
        elif key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureTableSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureTableSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureTableSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 azure_table_source_ignore_table_not_found: Optional[Any] = None,
                 azure_table_source_query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Azure Table source.
        :param str type: Copy source type.
               Expected value is 'AzureTableSource'.
        :param Any azure_table_source_ignore_table_not_found: Azure Table source ignore table not found. Type: boolean (or Expression with resultType boolean).
        :param Any azure_table_source_query: Azure Table source query. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'AzureTableSource')
        if azure_table_source_ignore_table_not_found is not None:
            pulumi.set(__self__, "azure_table_source_ignore_table_not_found", azure_table_source_ignore_table_not_found)
        if azure_table_source_query is not None:
            pulumi.set(__self__, "azure_table_source_query", azure_table_source_query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'AzureTableSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="azureTableSourceIgnoreTableNotFound")
    def azure_table_source_ignore_table_not_found(self) -> Optional[Any]:
        """
        Azure Table source ignore table not found. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "azure_table_source_ignore_table_not_found")

    @property
    @pulumi.getter(name="azureTableSourceQuery")
    def azure_table_source_query(self) -> Optional[Any]:
        """
        Azure Table source query. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "azure_table_source_query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class BlobEventsTriggerResponse(dict):
    """
    Trigger that runs every time a Blob event occurs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runtimeState":
            suggest = "runtime_state"
        elif key == "blobPathBeginsWith":
            suggest = "blob_path_begins_with"
        elif key == "blobPathEndsWith":
            suggest = "blob_path_ends_with"
        elif key == "ignoreEmptyBlobs":
            suggest = "ignore_empty_blobs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlobEventsTriggerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlobEventsTriggerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlobEventsTriggerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 events: Sequence[str],
                 runtime_state: str,
                 scope: str,
                 type: str,
                 blob_path_begins_with: Optional[str] = None,
                 blob_path_ends_with: Optional[str] = None,
                 description: Optional[str] = None,
                 ignore_empty_blobs: Optional[bool] = None,
                 pipelines: Optional[Sequence['outputs.TriggerPipelineReferenceResponse']] = None):
        """
        Trigger that runs every time a Blob event occurs.
        :param Sequence[str] events: The type of events that cause this trigger to fire.
        :param str runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
        :param str scope: The ARM resource ID of the Storage Account.
        :param str type: Trigger type.
               Expected value is 'BlobEventsTrigger'.
        :param str blob_path_begins_with: The blob path must begin with the pattern provided for trigger to fire. For example, '/records/blobs/december/' will only fire the trigger for blobs in the december folder under the records container. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
        :param str blob_path_ends_with: The blob path must end with the pattern provided for trigger to fire. For example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a december folder. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
        :param str description: Trigger description.
        :param bool ignore_empty_blobs: If set to true, blobs with zero bytes will be ignored.
        :param Sequence['TriggerPipelineReferenceResponse'] pipelines: Pipelines that need to be started.
        """
        pulumi.set(__self__, "events", events)
        pulumi.set(__self__, "runtime_state", runtime_state)
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "type", 'BlobEventsTrigger')
        if blob_path_begins_with is not None:
            pulumi.set(__self__, "blob_path_begins_with", blob_path_begins_with)
        if blob_path_ends_with is not None:
            pulumi.set(__self__, "blob_path_ends_with", blob_path_ends_with)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ignore_empty_blobs is not None:
            pulumi.set(__self__, "ignore_empty_blobs", ignore_empty_blobs)
        if pipelines is not None:
            pulumi.set(__self__, "pipelines", pipelines)

    @property
    @pulumi.getter
    def events(self) -> Sequence[str]:
        """
        The type of events that cause this trigger to fire.
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter(name="runtimeState")
    def runtime_state(self) -> str:
        """
        Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
        """
        return pulumi.get(self, "runtime_state")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        The ARM resource ID of the Storage Account.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Trigger type.
        Expected value is 'BlobEventsTrigger'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="blobPathBeginsWith")
    def blob_path_begins_with(self) -> Optional[str]:
        """
        The blob path must begin with the pattern provided for trigger to fire. For example, '/records/blobs/december/' will only fire the trigger for blobs in the december folder under the records container. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
        """
        return pulumi.get(self, "blob_path_begins_with")

    @property
    @pulumi.getter(name="blobPathEndsWith")
    def blob_path_ends_with(self) -> Optional[str]:
        """
        The blob path must end with the pattern provided for trigger to fire. For example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a december folder. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
        """
        return pulumi.get(self, "blob_path_ends_with")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Trigger description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ignoreEmptyBlobs")
    def ignore_empty_blobs(self) -> Optional[bool]:
        """
        If set to true, blobs with zero bytes will be ignored.
        """
        return pulumi.get(self, "ignore_empty_blobs")

    @property
    @pulumi.getter
    def pipelines(self) -> Optional[Sequence['outputs.TriggerPipelineReferenceResponse']]:
        """
        Pipelines that need to be started.
        """
        return pulumi.get(self, "pipelines")


@pulumi.output_type
class BlobSinkResponse(dict):
    """
    A copy activity Azure Blob sink.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blobWriterAddHeader":
            suggest = "blob_writer_add_header"
        elif key == "blobWriterDateTimeFormat":
            suggest = "blob_writer_date_time_format"
        elif key == "blobWriterOverwriteFiles":
            suggest = "blob_writer_overwrite_files"
        elif key == "copyBehavior":
            suggest = "copy_behavior"
        elif key == "sinkRetryCount":
            suggest = "sink_retry_count"
        elif key == "sinkRetryWait":
            suggest = "sink_retry_wait"
        elif key == "writeBatchSize":
            suggest = "write_batch_size"
        elif key == "writeBatchTimeout":
            suggest = "write_batch_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlobSinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlobSinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlobSinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 blob_writer_add_header: Optional[Any] = None,
                 blob_writer_date_time_format: Optional[Any] = None,
                 blob_writer_overwrite_files: Optional[Any] = None,
                 copy_behavior: Optional[Any] = None,
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None):
        """
        A copy activity Azure Blob sink.
        :param str type: Copy sink type.
               Expected value is 'BlobSink'.
        :param Any blob_writer_add_header: Blob writer add header. Type: boolean (or Expression with resultType boolean).
        :param Any blob_writer_date_time_format: Blob writer date time format. Type: string (or Expression with resultType string).
        :param Any blob_writer_overwrite_files: Blob writer overwrite files. Type: boolean (or Expression with resultType boolean).
        :param Any copy_behavior: The type of copy behavior for copy sink.
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'BlobSink')
        if blob_writer_add_header is not None:
            pulumi.set(__self__, "blob_writer_add_header", blob_writer_add_header)
        if blob_writer_date_time_format is not None:
            pulumi.set(__self__, "blob_writer_date_time_format", blob_writer_date_time_format)
        if blob_writer_overwrite_files is not None:
            pulumi.set(__self__, "blob_writer_overwrite_files", blob_writer_overwrite_files)
        if copy_behavior is not None:
            pulumi.set(__self__, "copy_behavior", copy_behavior)
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy sink type.
        Expected value is 'BlobSink'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="blobWriterAddHeader")
    def blob_writer_add_header(self) -> Optional[Any]:
        """
        Blob writer add header. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "blob_writer_add_header")

    @property
    @pulumi.getter(name="blobWriterDateTimeFormat")
    def blob_writer_date_time_format(self) -> Optional[Any]:
        """
        Blob writer date time format. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "blob_writer_date_time_format")

    @property
    @pulumi.getter(name="blobWriterOverwriteFiles")
    def blob_writer_overwrite_files(self) -> Optional[Any]:
        """
        Blob writer overwrite files. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "blob_writer_overwrite_files")

    @property
    @pulumi.getter(name="copyBehavior")
    def copy_behavior(self) -> Optional[Any]:
        """
        The type of copy behavior for copy sink.
        """
        return pulumi.get(self, "copy_behavior")

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")


@pulumi.output_type
class BlobSourceResponse(dict):
    """
    A copy activity Azure Blob source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "skipHeaderLineCount":
            suggest = "skip_header_line_count"
        elif key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"
        elif key == "treatEmptyAsNull":
            suggest = "treat_empty_as_null"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlobSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlobSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlobSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 recursive: Optional[Any] = None,
                 skip_header_line_count: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None,
                 treat_empty_as_null: Optional[Any] = None):
        """
        A copy activity Azure Blob source.
        :param str type: Copy source type.
               Expected value is 'BlobSource'.
        :param Any recursive: If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
        :param Any skip_header_line_count: Number of header lines to skip from each blob. Type: integer (or Expression with resultType integer).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any treat_empty_as_null: Treat empty as null. Type: boolean (or Expression with resultType boolean).
        """
        pulumi.set(__self__, "type", 'BlobSource')
        if recursive is not None:
            pulumi.set(__self__, "recursive", recursive)
        if skip_header_line_count is not None:
            pulumi.set(__self__, "skip_header_line_count", skip_header_line_count)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)
        if treat_empty_as_null is not None:
            pulumi.set(__self__, "treat_empty_as_null", treat_empty_as_null)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'BlobSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def recursive(self) -> Optional[Any]:
        """
        If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "recursive")

    @property
    @pulumi.getter(name="skipHeaderLineCount")
    def skip_header_line_count(self) -> Optional[Any]:
        """
        Number of header lines to skip from each blob. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "skip_header_line_count")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @property
    @pulumi.getter(name="treatEmptyAsNull")
    def treat_empty_as_null(self) -> Optional[Any]:
        """
        Treat empty as null. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "treat_empty_as_null")


@pulumi.output_type
class BlobTriggerResponse(dict):
    """
    Trigger that runs every time the selected Blob container changes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "folderPath":
            suggest = "folder_path"
        elif key == "linkedService":
            suggest = "linked_service"
        elif key == "maxConcurrency":
            suggest = "max_concurrency"
        elif key == "runtimeState":
            suggest = "runtime_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlobTriggerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlobTriggerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlobTriggerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 folder_path: str,
                 linked_service: 'outputs.LinkedServiceReferenceResponse',
                 max_concurrency: int,
                 runtime_state: str,
                 type: str,
                 description: Optional[str] = None,
                 pipelines: Optional[Sequence['outputs.TriggerPipelineReferenceResponse']] = None):
        """
        Trigger that runs every time the selected Blob container changes.
        :param str folder_path: The path of the container/folder that will trigger the pipeline.
        :param 'LinkedServiceReferenceResponse' linked_service: The Azure Storage linked service reference.
        :param int max_concurrency: The max number of parallel files to handle when it is triggered.
        :param str runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
        :param str type: Trigger type.
               Expected value is 'BlobTrigger'.
        :param str description: Trigger description.
        :param Sequence['TriggerPipelineReferenceResponse'] pipelines: Pipelines that need to be started.
        """
        pulumi.set(__self__, "folder_path", folder_path)
        pulumi.set(__self__, "linked_service", linked_service)
        pulumi.set(__self__, "max_concurrency", max_concurrency)
        pulumi.set(__self__, "runtime_state", runtime_state)
        pulumi.set(__self__, "type", 'BlobTrigger')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if pipelines is not None:
            pulumi.set(__self__, "pipelines", pipelines)

    @property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> str:
        """
        The path of the container/folder that will trigger the pipeline.
        """
        return pulumi.get(self, "folder_path")

    @property
    @pulumi.getter(name="linkedService")
    def linked_service(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        The Azure Storage linked service reference.
        """
        return pulumi.get(self, "linked_service")

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> int:
        """
        The max number of parallel files to handle when it is triggered.
        """
        return pulumi.get(self, "max_concurrency")

    @property
    @pulumi.getter(name="runtimeState")
    def runtime_state(self) -> str:
        """
        Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
        """
        return pulumi.get(self, "runtime_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Trigger type.
        Expected value is 'BlobTrigger'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Trigger description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def pipelines(self) -> Optional[Sequence['outputs.TriggerPipelineReferenceResponse']]:
        """
        Pipelines that need to be started.
        """
        return pulumi.get(self, "pipelines")


@pulumi.output_type
class CassandraLinkedServiceResponse(dict):
    """
    Linked service for Cassandra data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CassandraLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CassandraLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CassandraLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 authentication_type: Optional[Any] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 port: Optional[Any] = None,
                 username: Optional[Any] = None):
        """
        Linked service for Cassandra data source.
        :param Any host: Host name for connection. Type: string (or Expression with resultType string).
        :param str type: Type of linked service.
               Expected value is 'Cassandra'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param Any authentication_type: AuthenticationType to be used for connection. Type: string (or Expression with resultType string).
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: Password for authentication.
        :param Any port: The port for the connection. Type: integer (or Expression with resultType integer).
        :param Any username: Username for authentication. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'Cassandra')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        Host name for connection. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Cassandra'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[Any]:
        """
        AuthenticationType to be used for connection. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        Password for authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The port for the connection. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def username(self) -> Optional[Any]:
        """
        Username for authentication. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class CassandraSourceResponse(dict):
    """
    A copy activity source for a Cassandra database.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consistencyLevel":
            suggest = "consistency_level"
        elif key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CassandraSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CassandraSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CassandraSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 consistency_level: Optional[str] = None,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity source for a Cassandra database.
        :param str type: Copy source type.
               Expected value is 'CassandraSource'.
        :param str consistency_level: The consistency level specifies how many Cassandra servers must respond to a read request before returning data to the client application. Cassandra checks the specified number of Cassandra servers for data to satisfy the read request. Must be one of cassandraSourceReadConsistencyLevels. The default value is 'ONE'. It is case-insensitive.
        :param Any query: Database query. Should be a SQL-92 query expression or Cassandra Query Language (CQL) command. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'CassandraSource')
        if consistency_level is not None:
            pulumi.set(__self__, "consistency_level", consistency_level)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'CassandraSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="consistencyLevel")
    def consistency_level(self) -> Optional[str]:
        """
        The consistency level specifies how many Cassandra servers must respond to a read request before returning data to the client application. Cassandra checks the specified number of Cassandra servers for data to satisfy the read request. Must be one of cassandraSourceReadConsistencyLevels. The default value is 'ONE'. It is case-insensitive.
        """
        return pulumi.get(self, "consistency_level")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        Database query. Should be a SQL-92 query expression or Cassandra Query Language (CQL) command. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class CassandraTableDatasetResponse(dict):
    """
    The Cassandra database dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CassandraTableDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CassandraTableDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CassandraTableDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 keyspace: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None,
                 table_name: Optional[Any] = None):
        """
        The Cassandra database dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'CassandraTable'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Any keyspace: The keyspace of the Cassandra database. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        :param Any table_name: The table name of the Cassandra database. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'CassandraTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if keyspace is not None:
            pulumi.set(__self__, "keyspace", keyspace)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'CassandraTable'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def keyspace(self) -> Optional[Any]:
        """
        The keyspace of the Cassandra database. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "keyspace")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[Any]:
        """
        The table name of the Cassandra database. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "table_name")


@pulumi.output_type
class ConcurLinkedServiceResponse(dict):
    """
    Concur Service linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "useEncryptedEndpoints":
            suggest = "use_encrypted_endpoints"
        elif key == "useHostVerification":
            suggest = "use_host_verification"
        elif key == "usePeerVerification":
            suggest = "use_peer_verification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConcurLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConcurLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConcurLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Any,
                 type: str,
                 username: Any,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 use_encrypted_endpoints: Optional[Any] = None,
                 use_host_verification: Optional[Any] = None,
                 use_peer_verification: Optional[Any] = None):
        """
        Concur Service linked service.
        :param Any client_id: Application client_id supplied by Concur App Management.
        :param str type: Type of linked service.
               Expected value is 'Concur'.
        :param Any username: The user name that you use to access Concur Service.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: The password corresponding to the user name that you provided in the username field.
        :param Any use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        :param Any use_host_verification: Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        :param Any use_peer_verification: Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "type", 'Concur')
        pulumi.set(__self__, "username", username)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if use_encrypted_endpoints is not None:
            pulumi.set(__self__, "use_encrypted_endpoints", use_encrypted_endpoints)
        if use_host_verification is not None:
            pulumi.set(__self__, "use_host_verification", use_host_verification)
        if use_peer_verification is not None:
            pulumi.set(__self__, "use_peer_verification", use_peer_verification)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Any:
        """
        Application client_id supplied by Concur App Management.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Concur'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def username(self) -> Any:
        """
        The user name that you use to access Concur Service.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        The password corresponding to the user name that you provided in the username field.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="useEncryptedEndpoints")
    def use_encrypted_endpoints(self) -> Optional[Any]:
        """
        Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        """
        return pulumi.get(self, "use_encrypted_endpoints")

    @property
    @pulumi.getter(name="useHostVerification")
    def use_host_verification(self) -> Optional[Any]:
        """
        Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_host_verification")

    @property
    @pulumi.getter(name="usePeerVerification")
    def use_peer_verification(self) -> Optional[Any]:
        """
        Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_peer_verification")


@pulumi.output_type
class ConcurObjectDatasetResponse(dict):
    """
    Concur Service dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConcurObjectDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConcurObjectDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConcurObjectDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Concur Service dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'ConcurObject'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'ConcurObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'ConcurObject'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class ConcurSourceResponse(dict):
    """
    A copy activity Concur Service source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConcurSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConcurSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConcurSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Concur Service source.
        :param str type: Copy source type.
               Expected value is 'ConcurSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'ConcurSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'ConcurSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class ControlActivityResponse(dict):
    """
    Base class for all control activities like IfCondition, ForEach , Until.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOn":
            suggest = "depends_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControlActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControlActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControlActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None):
        """
        Base class for all control activities like IfCondition, ForEach , Until.
        :param str name: Activity name.
        :param str type: Type of activity.
               Expected value is 'Container'.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'Container')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'Container'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class CopyActivityResponse(dict):
    """
    Copy activity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudDataMovementUnits":
            suggest = "cloud_data_movement_units"
        elif key == "dependsOn":
            suggest = "depends_on"
        elif key == "enableSkipIncompatibleRow":
            suggest = "enable_skip_incompatible_row"
        elif key == "enableStaging":
            suggest = "enable_staging"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "parallelCopies":
            suggest = "parallel_copies"
        elif key == "redirectIncompatibleRowSettings":
            suggest = "redirect_incompatible_row_settings"
        elif key == "stagingSettings":
            suggest = "staging_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CopyActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CopyActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CopyActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 sink: Any,
                 source: Any,
                 type: str,
                 cloud_data_movement_units: Optional[Any] = None,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None,
                 enable_skip_incompatible_row: Optional[Any] = None,
                 enable_staging: Optional[Any] = None,
                 inputs: Optional[Sequence['outputs.DatasetReferenceResponse']] = None,
                 linked_service_name: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 outputs: Optional[Sequence['outputs.DatasetReferenceResponse']] = None,
                 parallel_copies: Optional[Any] = None,
                 policy: Optional['outputs.ActivityPolicyResponse'] = None,
                 redirect_incompatible_row_settings: Optional['outputs.RedirectIncompatibleRowSettingsResponse'] = None,
                 staging_settings: Optional['outputs.StagingSettingsResponse'] = None,
                 translator: Optional[Any] = None):
        """
        Copy activity.
        :param str name: Activity name.
        :param Union['AzureDataLakeStoreSinkResponse', 'AzureQueueSinkResponse', 'AzureSearchIndexSinkResponse', 'AzureTableSinkResponse', 'BlobSinkResponse', 'DocumentDbCollectionSinkResponse', 'DynamicsSinkResponse', 'FileSystemSinkResponse', 'OdbcSinkResponse', 'OracleSinkResponse', 'SalesforceSinkResponse', 'SapCloudForCustomerSinkResponse', 'SqlDWSinkResponse', 'SqlSinkResponse'] sink: Copy activity sink.
        :param Union['AmazonMWSSourceResponse', 'AmazonRedshiftSourceResponse', 'AzureDataLakeStoreSourceResponse', 'AzureMySqlSourceResponse', 'AzurePostgreSqlSourceResponse', 'AzureTableSourceResponse', 'BlobSourceResponse', 'CassandraSourceResponse', 'ConcurSourceResponse', 'CouchbaseSourceResponse', 'DocumentDbCollectionSourceResponse', 'DrillSourceResponse', 'DynamicsSourceResponse', 'EloquaSourceResponse', 'FileSystemSourceResponse', 'GoogleBigQuerySourceResponse', 'GreenplumSourceResponse', 'HBaseSourceResponse', 'HdfsSourceResponse', 'HiveSourceResponse', 'HttpSourceResponse', 'HubspotSourceResponse', 'ImpalaSourceResponse', 'JiraSourceResponse', 'MagentoSourceResponse', 'MariaDBSourceResponse', 'MarketoSourceResponse', 'MongoDbSourceResponse', 'NetezzaSourceResponse', 'OracleSourceResponse', 'PaypalSourceResponse', 'PhoenixSourceResponse', 'PrestoSourceResponse', 'QuickBooksSourceResponse', 'RelationalSourceResponse', 'ResponsysSourceResponse', 'SalesforceMarketingCloudSourceResponse', 'SalesforceSourceResponse', 'SapCloudForCustomerSourceResponse', 'SapEccSourceResponse', 'ServiceNowSourceResponse', 'ShopifySourceResponse', 'SparkSourceResponse', 'SqlDWSourceResponse', 'SqlSourceResponse', 'SquareSourceResponse', 'VerticaSourceResponse', 'WebSourceResponse', 'XeroSourceResponse', 'ZohoSourceResponse'] source: Copy activity source.
        :param str type: Type of activity.
               Expected value is 'Copy'.
        :param Any cloud_data_movement_units: Maximum number of cloud data movement units that can be used to perform this data movement. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        :param Any enable_skip_incompatible_row: Whether to skip incompatible row. Default value is false. Type: boolean (or Expression with resultType boolean).
        :param Any enable_staging: Specifies whether to copy data via an interim staging. Default value is false. Type: boolean (or Expression with resultType boolean).
        :param Sequence['DatasetReferenceResponse'] inputs: List of inputs for the activity.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param Sequence['DatasetReferenceResponse'] outputs: List of outputs for the activity.
        :param Any parallel_copies: Maximum number of concurrent sessions opened on the source or sink to avoid overloading the data store. Type: integer (or Expression with resultType integer), minimum: 0.
        :param 'ActivityPolicyResponse' policy: Activity policy.
        :param 'RedirectIncompatibleRowSettingsResponse' redirect_incompatible_row_settings: Redirect incompatible row settings when EnableSkipIncompatibleRow is true.
        :param 'StagingSettingsResponse' staging_settings: Specifies interim staging settings when EnableStaging is true.
        :param Any translator: Copy activity translator. If not specified, tabular translator is used.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sink", sink)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "type", 'Copy')
        if cloud_data_movement_units is not None:
            pulumi.set(__self__, "cloud_data_movement_units", cloud_data_movement_units)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_skip_incompatible_row is not None:
            pulumi.set(__self__, "enable_skip_incompatible_row", enable_skip_incompatible_row)
        if enable_staging is not None:
            pulumi.set(__self__, "enable_staging", enable_staging)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if parallel_copies is not None:
            pulumi.set(__self__, "parallel_copies", parallel_copies)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if redirect_incompatible_row_settings is not None:
            pulumi.set(__self__, "redirect_incompatible_row_settings", redirect_incompatible_row_settings)
        if staging_settings is not None:
            pulumi.set(__self__, "staging_settings", staging_settings)
        if translator is not None:
            pulumi.set(__self__, "translator", translator)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def sink(self) -> Any:
        """
        Copy activity sink.
        """
        return pulumi.get(self, "sink")

    @property
    @pulumi.getter
    def source(self) -> Any:
        """
        Copy activity source.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'Copy'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="cloudDataMovementUnits")
    def cloud_data_movement_units(self) -> Optional[Any]:
        """
        Maximum number of cloud data movement units that can be used to perform this data movement. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "cloud_data_movement_units")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableSkipIncompatibleRow")
    def enable_skip_incompatible_row(self) -> Optional[Any]:
        """
        Whether to skip incompatible row. Default value is false. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "enable_skip_incompatible_row")

    @property
    @pulumi.getter(name="enableStaging")
    def enable_staging(self) -> Optional[Any]:
        """
        Specifies whether to copy data via an interim staging. Default value is false. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "enable_staging")

    @property
    @pulumi.getter
    def inputs(self) -> Optional[Sequence['outputs.DatasetReferenceResponse']]:
        """
        List of inputs for the activity.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def outputs(self) -> Optional[Sequence['outputs.DatasetReferenceResponse']]:
        """
        List of outputs for the activity.
        """
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter(name="parallelCopies")
    def parallel_copies(self) -> Optional[Any]:
        """
        Maximum number of concurrent sessions opened on the source or sink to avoid overloading the data store. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "parallel_copies")

    @property
    @pulumi.getter
    def policy(self) -> Optional['outputs.ActivityPolicyResponse']:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="redirectIncompatibleRowSettings")
    def redirect_incompatible_row_settings(self) -> Optional['outputs.RedirectIncompatibleRowSettingsResponse']:
        """
        Redirect incompatible row settings when EnableSkipIncompatibleRow is true.
        """
        return pulumi.get(self, "redirect_incompatible_row_settings")

    @property
    @pulumi.getter(name="stagingSettings")
    def staging_settings(self) -> Optional['outputs.StagingSettingsResponse']:
        """
        Specifies interim staging settings when EnableStaging is true.
        """
        return pulumi.get(self, "staging_settings")

    @property
    @pulumi.getter
    def translator(self) -> Optional[Any]:
        """
        Copy activity translator. If not specified, tabular translator is used.
        """
        return pulumi.get(self, "translator")


@pulumi.output_type
class CosmosDbLinkedServiceResponse(dict):
    """
    Microsoft Azure Cosmos Database (CosmosDB) linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CosmosDbLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CosmosDbLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CosmosDbLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None):
        """
        Microsoft Azure Cosmos Database (CosmosDB) linked service.
        :param Any connection_string: The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param str type: Type of linked service.
               Expected value is 'CosmosDb'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "type", 'CosmosDb')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Any:
        """
        The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'CosmosDb'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class CouchbaseLinkedServiceResponse(dict):
    """
    Couchbase server linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectVia":
            suggest = "connect_via"
        elif key == "connectionString":
            suggest = "connection_string"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CouchbaseLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CouchbaseLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CouchbaseLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 connection_string: Optional[Any] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None):
        """
        Couchbase server linked service.
        :param str type: Type of linked service.
               Expected value is 'Couchbase'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param Any connection_string: An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "type", 'Couchbase')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Couchbase'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[Any]:
        """
        An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class CouchbaseSourceResponse(dict):
    """
    A copy activity Couchbase server source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CouchbaseSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CouchbaseSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CouchbaseSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Couchbase server source.
        :param str type: Copy source type.
               Expected value is 'CouchbaseSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'CouchbaseSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'CouchbaseSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class CouchbaseTableDatasetResponse(dict):
    """
    Couchbase server dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CouchbaseTableDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CouchbaseTableDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CouchbaseTableDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Couchbase server dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'CouchbaseTable'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'CouchbaseTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'CouchbaseTable'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class CustomActivityReferenceObjectResponse(dict):
    """
    Reference objects for custom activity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServices":
            suggest = "linked_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomActivityReferenceObjectResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomActivityReferenceObjectResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomActivityReferenceObjectResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datasets: Optional[Sequence['outputs.DatasetReferenceResponse']] = None,
                 linked_services: Optional[Sequence['outputs.LinkedServiceReferenceResponse']] = None):
        """
        Reference objects for custom activity
        :param Sequence['DatasetReferenceResponse'] datasets: Dataset references.
        :param Sequence['LinkedServiceReferenceResponse'] linked_services: Linked service references.
        """
        if datasets is not None:
            pulumi.set(__self__, "datasets", datasets)
        if linked_services is not None:
            pulumi.set(__self__, "linked_services", linked_services)

    @property
    @pulumi.getter
    def datasets(self) -> Optional[Sequence['outputs.DatasetReferenceResponse']]:
        """
        Dataset references.
        """
        return pulumi.get(self, "datasets")

    @property
    @pulumi.getter(name="linkedServices")
    def linked_services(self) -> Optional[Sequence['outputs.LinkedServiceReferenceResponse']]:
        """
        Linked service references.
        """
        return pulumi.get(self, "linked_services")


@pulumi.output_type
class CustomActivityResponse(dict):
    """
    Custom activity type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOn":
            suggest = "depends_on"
        elif key == "extendedProperties":
            suggest = "extended_properties"
        elif key == "folderPath":
            suggest = "folder_path"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "referenceObjects":
            suggest = "reference_objects"
        elif key == "resourceLinkedService":
            suggest = "resource_linked_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: Any,
                 name: str,
                 type: str,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None,
                 extended_properties: Optional[Mapping[str, Any]] = None,
                 folder_path: Optional[Any] = None,
                 linked_service_name: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 policy: Optional['outputs.ActivityPolicyResponse'] = None,
                 reference_objects: Optional['outputs.CustomActivityReferenceObjectResponse'] = None,
                 resource_linked_service: Optional['outputs.LinkedServiceReferenceResponse'] = None):
        """
        Custom activity type.
        :param Any command: Command for custom activity Type: string (or Expression with resultType string).
        :param str name: Activity name.
        :param str type: Type of activity.
               Expected value is 'Custom'.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        :param Mapping[str, Any] extended_properties: User defined property bag. There is no restriction on the keys or values that can be used. The user specified custom activity has the full responsibility to consume and interpret the content defined.
        :param Any folder_path: Folder path for resource files Type: string (or Expression with resultType string).
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param 'ActivityPolicyResponse' policy: Activity policy.
        :param 'CustomActivityReferenceObjectResponse' reference_objects: Reference objects
        :param 'LinkedServiceReferenceResponse' resource_linked_service: Resource linked service reference.
        """
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'Custom')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if extended_properties is not None:
            pulumi.set(__self__, "extended_properties", extended_properties)
        if folder_path is not None:
            pulumi.set(__self__, "folder_path", folder_path)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if reference_objects is not None:
            pulumi.set(__self__, "reference_objects", reference_objects)
        if resource_linked_service is not None:
            pulumi.set(__self__, "resource_linked_service", resource_linked_service)

    @property
    @pulumi.getter
    def command(self) -> Any:
        """
        Command for custom activity Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'Custom'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="extendedProperties")
    def extended_properties(self) -> Optional[Mapping[str, Any]]:
        """
        User defined property bag. There is no restriction on the keys or values that can be used. The user specified custom activity has the full responsibility to consume and interpret the content defined.
        """
        return pulumi.get(self, "extended_properties")

    @property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> Optional[Any]:
        """
        Folder path for resource files Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "folder_path")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def policy(self) -> Optional['outputs.ActivityPolicyResponse']:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="referenceObjects")
    def reference_objects(self) -> Optional['outputs.CustomActivityReferenceObjectResponse']:
        """
        Reference objects
        """
        return pulumi.get(self, "reference_objects")

    @property
    @pulumi.getter(name="resourceLinkedService")
    def resource_linked_service(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Resource linked service reference.
        """
        return pulumi.get(self, "resource_linked_service")


@pulumi.output_type
class CustomDataSourceLinkedServiceResponse(dict):
    """
    Custom linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectVia":
            suggest = "connect_via"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDataSourceLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDataSourceLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDataSourceLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None):
        """
        Custom linked service.
        :param str type: Type of linked service.
               Expected value is 'CustomDataSource'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "type", 'CustomDataSource')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'CustomDataSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class CustomDatasetResponse(dict):
    """
    The custom dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        The custom dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'CustomDataset'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'CustomDataset')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'CustomDataset'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class DataLakeAnalyticsUSQLActivityResponse(dict):
    """
    Data Lake Analytics U-SQL activity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scriptLinkedService":
            suggest = "script_linked_service"
        elif key == "scriptPath":
            suggest = "script_path"
        elif key == "compilationMode":
            suggest = "compilation_mode"
        elif key == "degreeOfParallelism":
            suggest = "degree_of_parallelism"
        elif key == "dependsOn":
            suggest = "depends_on"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "runtimeVersion":
            suggest = "runtime_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLakeAnalyticsUSQLActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLakeAnalyticsUSQLActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLakeAnalyticsUSQLActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 script_linked_service: 'outputs.LinkedServiceReferenceResponse',
                 script_path: Any,
                 type: str,
                 compilation_mode: Optional[Any] = None,
                 degree_of_parallelism: Optional[Any] = None,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None,
                 linked_service_name: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 parameters: Optional[Mapping[str, Any]] = None,
                 policy: Optional['outputs.ActivityPolicyResponse'] = None,
                 priority: Optional[Any] = None,
                 runtime_version: Optional[Any] = None):
        """
        Data Lake Analytics U-SQL activity.
        :param str name: Activity name.
        :param 'LinkedServiceReferenceResponse' script_linked_service: Script linked service reference.
        :param Any script_path: Case-sensitive path to folder that contains the U-SQL script. Type: string (or Expression with resultType string).
        :param str type: Type of activity.
               Expected value is 'DataLakeAnalyticsU-SQL'.
        :param Any compilation_mode: Compilation mode of U-SQL. Must be one of these values : Semantic, Full and SingleBox. Type: string (or Expression with resultType string).
        :param Any degree_of_parallelism: The maximum number of nodes simultaneously used to run the job. Default value is 1. Type: integer (or Expression with resultType integer), minimum: 1.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param Mapping[str, Any] parameters: Parameters for U-SQL job request.
        :param 'ActivityPolicyResponse' policy: Activity policy.
        :param Any priority: Determines which jobs out of all that are queued should be selected to run first. The lower the number, the higher the priority. Default value is 1000. Type: integer (or Expression with resultType integer), minimum: 1.
        :param Any runtime_version: Runtime version of the U-SQL engine to use. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "script_linked_service", script_linked_service)
        pulumi.set(__self__, "script_path", script_path)
        pulumi.set(__self__, "type", 'DataLakeAnalyticsU-SQL')
        if compilation_mode is not None:
            pulumi.set(__self__, "compilation_mode", compilation_mode)
        if degree_of_parallelism is not None:
            pulumi.set(__self__, "degree_of_parallelism", degree_of_parallelism)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scriptLinkedService")
    def script_linked_service(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Script linked service reference.
        """
        return pulumi.get(self, "script_linked_service")

    @property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Any:
        """
        Case-sensitive path to folder that contains the U-SQL script. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "script_path")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'DataLakeAnalyticsU-SQL'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="compilationMode")
    def compilation_mode(self) -> Optional[Any]:
        """
        Compilation mode of U-SQL. Must be one of these values : Semantic, Full and SingleBox. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "compilation_mode")

    @property
    @pulumi.getter(name="degreeOfParallelism")
    def degree_of_parallelism(self) -> Optional[Any]:
        """
        The maximum number of nodes simultaneously used to run the job. Default value is 1. Type: integer (or Expression with resultType integer), minimum: 1.
        """
        return pulumi.get(self, "degree_of_parallelism")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, Any]]:
        """
        Parameters for U-SQL job request.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def policy(self) -> Optional['outputs.ActivityPolicyResponse']:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def priority(self) -> Optional[Any]:
        """
        Determines which jobs out of all that are queued should be selected to run first. The lower the number, the higher the priority. Default value is 1000. Type: integer (or Expression with resultType integer), minimum: 1.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[Any]:
        """
        Runtime version of the U-SQL engine to use. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class DatabricksNotebookActivityResponse(dict):
    """
    DatabricksNotebook activity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notebookPath":
            suggest = "notebook_path"
        elif key == "baseParameters":
            suggest = "base_parameters"
        elif key == "dependsOn":
            suggest = "depends_on"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabricksNotebookActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabricksNotebookActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabricksNotebookActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 notebook_path: Any,
                 type: str,
                 base_parameters: Optional[Mapping[str, Any]] = None,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None,
                 linked_service_name: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 policy: Optional['outputs.ActivityPolicyResponse'] = None):
        """
        DatabricksNotebook activity.
        :param str name: Activity name.
        :param Any notebook_path: The absolute path of the notebook to be run in the Databricks Workspace. This path must begin with a slash. Type: string (or Expression with resultType string).
        :param str type: Type of activity.
               Expected value is 'DatabricksNotebook'.
        :param Mapping[str, Any] base_parameters: Base parameters to be used for each run of this job.If the notebook takes a parameter that is not specified, the default value from the notebook will be used.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param 'ActivityPolicyResponse' policy: Activity policy.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "notebook_path", notebook_path)
        pulumi.set(__self__, "type", 'DatabricksNotebook')
        if base_parameters is not None:
            pulumi.set(__self__, "base_parameters", base_parameters)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notebookPath")
    def notebook_path(self) -> Any:
        """
        The absolute path of the notebook to be run in the Databricks Workspace. This path must begin with a slash. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "notebook_path")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'DatabricksNotebook'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="baseParameters")
    def base_parameters(self) -> Optional[Mapping[str, Any]]:
        """
        Base parameters to be used for each run of this job.If the notebook takes a parameter that is not specified, the default value from the notebook will be used.
        """
        return pulumi.get(self, "base_parameters")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def policy(self) -> Optional['outputs.ActivityPolicyResponse']:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")


@pulumi.output_type
class DatasetBZip2CompressionResponse(dict):
    """
    The BZip2 compression method used on a dataset.
    """
    def __init__(__self__, *,
                 type: str):
        """
        The BZip2 compression method used on a dataset.
        :param str type: Type of dataset compression.
               Expected value is 'BZip2'.
        """
        pulumi.set(__self__, "type", 'BZip2')

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset compression.
        Expected value is 'BZip2'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DatasetDeflateCompressionResponse(dict):
    """
    The Deflate compression method used on a dataset.
    """
    def __init__(__self__, *,
                 type: str,
                 level: Optional[str] = None):
        """
        The Deflate compression method used on a dataset.
        :param str type: Type of dataset compression.
               Expected value is 'Deflate'.
        :param str level: The Deflate compression level.
        """
        pulumi.set(__self__, "type", 'Deflate')
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset compression.
        Expected value is 'Deflate'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        The Deflate compression level.
        """
        return pulumi.get(self, "level")


@pulumi.output_type
class DatasetGZipCompressionResponse(dict):
    """
    The GZip compression method used on a dataset.
    """
    def __init__(__self__, *,
                 type: str,
                 level: Optional[str] = None):
        """
        The GZip compression method used on a dataset.
        :param str type: Type of dataset compression.
               Expected value is 'GZip'.
        :param str level: The GZip compression level.
        """
        pulumi.set(__self__, "type", 'GZip')
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset compression.
        Expected value is 'GZip'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        The GZip compression level.
        """
        return pulumi.get(self, "level")


@pulumi.output_type
class DatasetReferenceResponse(dict):
    """
    Dataset reference type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referenceName":
            suggest = "reference_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reference_name: str,
                 type: str,
                 parameters: Optional[Mapping[str, Any]] = None):
        """
        Dataset reference type.
        :param str reference_name: Reference dataset name.
        :param str type: Dataset reference type.
        :param Mapping[str, Any] parameters: Arguments for dataset.
        """
        pulumi.set(__self__, "reference_name", reference_name)
        pulumi.set(__self__, "type", type)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="referenceName")
    def reference_name(self) -> str:
        """
        Reference dataset name.
        """
        return pulumi.get(self, "reference_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Dataset reference type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, Any]]:
        """
        Arguments for dataset.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DatasetZipDeflateCompressionResponse(dict):
    """
    The ZipDeflate compression method used on a dataset.
    """
    def __init__(__self__, *,
                 type: str,
                 level: Optional[str] = None):
        """
        The ZipDeflate compression method used on a dataset.
        :param str type: Type of dataset compression.
               Expected value is 'ZipDeflate'.
        :param str level: The ZipDeflate compression level.
        """
        pulumi.set(__self__, "type", 'ZipDeflate')
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset compression.
        Expected value is 'ZipDeflate'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        The ZipDeflate compression level.
        """
        return pulumi.get(self, "level")


@pulumi.output_type
class Db2LinkedServiceResponse(dict):
    """
    Linked service for DB2 data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Db2LinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Db2LinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Db2LinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database: Any,
                 server: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 authentication_type: Optional[str] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 username: Optional[Any] = None):
        """
        Linked service for DB2 data source.
        :param Any database: Database name for connection. Type: string (or Expression with resultType string).
        :param Any server: Server name for connection. Type: string (or Expression with resultType string).
        :param str type: Type of linked service.
               Expected value is 'Db2'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str authentication_type: AuthenticationType to be used for connection.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: Password for authentication.
        :param Any username: Username for authentication. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "server", server)
        pulumi.set(__self__, "type", 'Db2')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def database(self) -> Any:
        """
        Database name for connection. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def server(self) -> Any:
        """
        Server name for connection. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Db2'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[str]:
        """
        AuthenticationType to be used for connection.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        Password for authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[Any]:
        """
        Username for authentication. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class DistcpSettingsResponse(dict):
    """
    Distcp settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceManagerEndpoint":
            suggest = "resource_manager_endpoint"
        elif key == "tempScriptPath":
            suggest = "temp_script_path"
        elif key == "distcpOptions":
            suggest = "distcp_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistcpSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistcpSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistcpSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_manager_endpoint: Any,
                 temp_script_path: Any,
                 distcp_options: Optional[Any] = None):
        """
        Distcp settings.
        :param Any resource_manager_endpoint: Specifies the Yarn ResourceManager endpoint. Type: string (or Expression with resultType string).
        :param Any temp_script_path: Specifies an existing folder path which will be used to store temp Distcp command script. The script file is generated by ADF and will be removed after Copy job finished. Type: string (or Expression with resultType string).
        :param Any distcp_options: Specifies the Distcp options. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "resource_manager_endpoint", resource_manager_endpoint)
        pulumi.set(__self__, "temp_script_path", temp_script_path)
        if distcp_options is not None:
            pulumi.set(__self__, "distcp_options", distcp_options)

    @property
    @pulumi.getter(name="resourceManagerEndpoint")
    def resource_manager_endpoint(self) -> Any:
        """
        Specifies the Yarn ResourceManager endpoint. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "resource_manager_endpoint")

    @property
    @pulumi.getter(name="tempScriptPath")
    def temp_script_path(self) -> Any:
        """
        Specifies an existing folder path which will be used to store temp Distcp command script. The script file is generated by ADF and will be removed after Copy job finished. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "temp_script_path")

    @property
    @pulumi.getter(name="distcpOptions")
    def distcp_options(self) -> Optional[Any]:
        """
        Specifies the Distcp options. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "distcp_options")


@pulumi.output_type
class DocumentDbCollectionDatasetResponse(dict):
    """
    Microsoft Azure Document Database Collection dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collectionName":
            suggest = "collection_name"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentDbCollectionDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentDbCollectionDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentDbCollectionDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collection_name: Any,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Microsoft Azure Document Database Collection dataset.
        :param Any collection_name: Document Database collection name. Type: string (or Expression with resultType string).
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'DocumentDbCollection'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "collection_name", collection_name)
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'DocumentDbCollection')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="collectionName")
    def collection_name(self) -> Any:
        """
        Document Database collection name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "collection_name")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'DocumentDbCollection'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class DocumentDbCollectionSinkResponse(dict):
    """
    A copy activity Document Database Collection sink.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nestingSeparator":
            suggest = "nesting_separator"
        elif key == "sinkRetryCount":
            suggest = "sink_retry_count"
        elif key == "sinkRetryWait":
            suggest = "sink_retry_wait"
        elif key == "writeBatchSize":
            suggest = "write_batch_size"
        elif key == "writeBatchTimeout":
            suggest = "write_batch_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentDbCollectionSinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentDbCollectionSinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentDbCollectionSinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 nesting_separator: Optional[Any] = None,
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None):
        """
        A copy activity Document Database Collection sink.
        :param str type: Copy sink type.
               Expected value is 'DocumentDbCollectionSink'.
        :param Any nesting_separator: Nested properties separator. Default is . (dot). Type: string (or Expression with resultType string).
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'DocumentDbCollectionSink')
        if nesting_separator is not None:
            pulumi.set(__self__, "nesting_separator", nesting_separator)
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy sink type.
        Expected value is 'DocumentDbCollectionSink'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="nestingSeparator")
    def nesting_separator(self) -> Optional[Any]:
        """
        Nested properties separator. Default is . (dot). Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "nesting_separator")

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")


@pulumi.output_type
class DocumentDbCollectionSourceResponse(dict):
    """
    A copy activity Document Database Collection source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nestingSeparator":
            suggest = "nesting_separator"
        elif key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentDbCollectionSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentDbCollectionSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentDbCollectionSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 nesting_separator: Optional[Any] = None,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Document Database Collection source.
        :param str type: Copy source type.
               Expected value is 'DocumentDbCollectionSource'.
        :param Any nesting_separator: Nested properties separator. Type: string (or Expression with resultType string).
        :param Any query: Documents query. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'DocumentDbCollectionSource')
        if nesting_separator is not None:
            pulumi.set(__self__, "nesting_separator", nesting_separator)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'DocumentDbCollectionSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="nestingSeparator")
    def nesting_separator(self) -> Optional[Any]:
        """
        Nested properties separator. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "nesting_separator")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        Documents query. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class DrillLinkedServiceResponse(dict):
    """
    Drill server linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectVia":
            suggest = "connect_via"
        elif key == "connectionString":
            suggest = "connection_string"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DrillLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DrillLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DrillLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 connection_string: Optional[Any] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None):
        """
        Drill server linked service.
        :param str type: Type of linked service.
               Expected value is 'Drill'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param Any connection_string: An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "type", 'Drill')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Drill'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[Any]:
        """
        An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DrillSourceResponse(dict):
    """
    A copy activity Drill server source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DrillSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DrillSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DrillSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Drill server source.
        :param str type: Copy source type.
               Expected value is 'DrillSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'DrillSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'DrillSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class DrillTableDatasetResponse(dict):
    """
    Drill server dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DrillTableDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DrillTableDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DrillTableDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Drill server dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'DrillTable'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'DrillTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'DrillTable'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class DynamicsEntityDatasetResponse(dict):
    """
    The Dynamics entity dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "entityName":
            suggest = "entity_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DynamicsEntityDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DynamicsEntityDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DynamicsEntityDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 entity_name: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        The Dynamics entity dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'DynamicsEntity'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Any entity_name: The logical name of the entity. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'DynamicsEntity')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entity_name is not None:
            pulumi.set(__self__, "entity_name", entity_name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'DynamicsEntity'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="entityName")
    def entity_name(self) -> Optional[Any]:
        """
        The logical name of the entity. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "entity_name")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class DynamicsLinkedServiceResponse(dict):
    """
    Dynamics linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "deploymentType":
            suggest = "deployment_type"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "hostName":
            suggest = "host_name"
        elif key == "organizationName":
            suggest = "organization_name"
        elif key == "serviceUri":
            suggest = "service_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DynamicsLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DynamicsLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DynamicsLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_type: str,
                 deployment_type: str,
                 type: str,
                 username: Any,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 host_name: Optional[Any] = None,
                 organization_name: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 port: Optional[Any] = None,
                 service_uri: Optional[Any] = None):
        """
        Dynamics linked service.
        :param str authentication_type: The authentication type to connect to Dynamics server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario. Type: string (or Expression with resultType string).
        :param str deployment_type: The deployment type of the Dynamics instance. 'Online' for Dynamics Online and 'OnPremisesWithIfd' for Dynamics on-premises with Ifd. Type: string (or Expression with resultType string).
        :param str type: Type of linked service.
               Expected value is 'Dynamics'.
        :param Any username: User name to access the Dynamics instance. Type: string (or Expression with resultType string).
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Any host_name: The host name of the on-premises Dynamics server. The property is required for on-prem and not allowed for online. Type: string (or Expression with resultType string).
        :param Any organization_name: The organization name of the Dynamics instance. The property is required for on-prem and required for online when there are more than one Dynamics instances associated with the user. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: Password to access the Dynamics instance.
        :param Any port: The port of on-premises Dynamics server. The property is required for on-prem and not allowed for online. Default is 443. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any service_uri: The URL to the Microsoft Dynamics server. The property is required for on-line and not allowed for on-prem. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "deployment_type", deployment_type)
        pulumi.set(__self__, "type", 'Dynamics')
        pulumi.set(__self__, "username", username)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> str:
        """
        The authentication type to connect to Dynamics server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        The deployment type of the Dynamics instance. 'Online' for Dynamics Online and 'OnPremisesWithIfd' for Dynamics on-premises with Ifd. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Dynamics'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def username(self) -> Any:
        """
        User name to access the Dynamics instance. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[Any]:
        """
        The host name of the on-premises Dynamics server. The property is required for on-prem and not allowed for online. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[Any]:
        """
        The organization name of the Dynamics instance. The property is required for on-prem and required for online when there are more than one Dynamics instances associated with the user. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        Password to access the Dynamics instance.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The port of on-premises Dynamics server. The property is required for on-prem and not allowed for online. Default is 443. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[Any]:
        """
        The URL to the Microsoft Dynamics server. The property is required for on-line and not allowed for on-prem. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "service_uri")


@pulumi.output_type
class DynamicsSinkResponse(dict):
    """
    A copy activity Dynamics sink.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "writeBehavior":
            suggest = "write_behavior"
        elif key == "ignoreNullValues":
            suggest = "ignore_null_values"
        elif key == "sinkRetryCount":
            suggest = "sink_retry_count"
        elif key == "sinkRetryWait":
            suggest = "sink_retry_wait"
        elif key == "writeBatchSize":
            suggest = "write_batch_size"
        elif key == "writeBatchTimeout":
            suggest = "write_batch_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DynamicsSinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DynamicsSinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DynamicsSinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 write_behavior: str,
                 ignore_null_values: Optional[Any] = None,
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None):
        """
        A copy activity Dynamics sink.
        :param str type: Copy sink type.
               Expected value is 'DynamicsSink'.
        :param str write_behavior: The write behavior for the operation.
        :param Any ignore_null_values: The flag indicating whether ignore null values from input dataset (except key fields) during write operation. Default is false. Type: boolean (or Expression with resultType boolean).
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'DynamicsSink')
        pulumi.set(__self__, "write_behavior", write_behavior)
        if ignore_null_values is not None:
            pulumi.set(__self__, "ignore_null_values", ignore_null_values)
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy sink type.
        Expected value is 'DynamicsSink'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="writeBehavior")
    def write_behavior(self) -> str:
        """
        The write behavior for the operation.
        """
        return pulumi.get(self, "write_behavior")

    @property
    @pulumi.getter(name="ignoreNullValues")
    def ignore_null_values(self) -> Optional[Any]:
        """
        The flag indicating whether ignore null values from input dataset (except key fields) during write operation. Default is false. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "ignore_null_values")

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")


@pulumi.output_type
class DynamicsSourceResponse(dict):
    """
    A copy activity Dynamics source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DynamicsSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DynamicsSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DynamicsSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Dynamics source.
        :param str type: Copy source type.
               Expected value is 'DynamicsSource'.
        :param Any query: FetchXML is a proprietary query language that is used in Microsoft Dynamics (online & on-premises). Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'DynamicsSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'DynamicsSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        FetchXML is a proprietary query language that is used in Microsoft Dynamics (online & on-premises). Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class EloquaLinkedServiceResponse(dict):
    """
    Eloqua server linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "useEncryptedEndpoints":
            suggest = "use_encrypted_endpoints"
        elif key == "useHostVerification":
            suggest = "use_host_verification"
        elif key == "usePeerVerification":
            suggest = "use_peer_verification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EloquaLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EloquaLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EloquaLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: Any,
                 type: str,
                 username: Any,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 use_encrypted_endpoints: Optional[Any] = None,
                 use_host_verification: Optional[Any] = None,
                 use_peer_verification: Optional[Any] = None):
        """
        Eloqua server linked service.
        :param Any endpoint: The endpoint of the Eloqua server. (i.e. eloqua.example.com)
        :param str type: Type of linked service.
               Expected value is 'Eloqua'.
        :param Any username: The site name and user name of your Eloqua account in the form: sitename/username. (i.e. Eloqua/Alice)
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: The password corresponding to the user name.
        :param Any use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        :param Any use_host_verification: Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        :param Any use_peer_verification: Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "type", 'Eloqua')
        pulumi.set(__self__, "username", username)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if use_encrypted_endpoints is not None:
            pulumi.set(__self__, "use_encrypted_endpoints", use_encrypted_endpoints)
        if use_host_verification is not None:
            pulumi.set(__self__, "use_host_verification", use_host_verification)
        if use_peer_verification is not None:
            pulumi.set(__self__, "use_peer_verification", use_peer_verification)

    @property
    @pulumi.getter
    def endpoint(self) -> Any:
        """
        The endpoint of the Eloqua server. (i.e. eloqua.example.com)
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Eloqua'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def username(self) -> Any:
        """
        The site name and user name of your Eloqua account in the form: sitename/username. (i.e. Eloqua/Alice)
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        The password corresponding to the user name.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="useEncryptedEndpoints")
    def use_encrypted_endpoints(self) -> Optional[Any]:
        """
        Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        """
        return pulumi.get(self, "use_encrypted_endpoints")

    @property
    @pulumi.getter(name="useHostVerification")
    def use_host_verification(self) -> Optional[Any]:
        """
        Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_host_verification")

    @property
    @pulumi.getter(name="usePeerVerification")
    def use_peer_verification(self) -> Optional[Any]:
        """
        Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_peer_verification")


@pulumi.output_type
class EloquaObjectDatasetResponse(dict):
    """
    Eloqua server dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EloquaObjectDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EloquaObjectDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EloquaObjectDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Eloqua server dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'EloquaObject'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'EloquaObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'EloquaObject'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class EloquaSourceResponse(dict):
    """
    A copy activity Eloqua server source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EloquaSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EloquaSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EloquaSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Eloqua server source.
        :param str type: Copy source type.
               Expected value is 'EloquaSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'EloquaSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'EloquaSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class EntityReferenceResponse(dict):
    """
    The entity reference.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referenceName":
            suggest = "reference_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntityReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntityReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntityReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reference_name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The entity reference.
        :param str reference_name: The name of this referenced entity.
        :param str type: The type of this referenced entity.
        """
        if reference_name is not None:
            pulumi.set(__self__, "reference_name", reference_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="referenceName")
    def reference_name(self) -> Optional[str]:
        """
        The name of this referenced entity.
        """
        return pulumi.get(self, "reference_name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of this referenced entity.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ExecutePipelineActivityResponse(dict):
    """
    Execute pipeline activity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOn":
            suggest = "depends_on"
        elif key == "waitOnCompletion":
            suggest = "wait_on_completion"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExecutePipelineActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExecutePipelineActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExecutePipelineActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 pipeline: 'outputs.PipelineReferenceResponse',
                 type: str,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, Any]] = None,
                 wait_on_completion: Optional[bool] = None):
        """
        Execute pipeline activity.
        :param str name: Activity name.
        :param 'PipelineReferenceResponse' pipeline: Pipeline reference.
        :param str type: Type of activity.
               Expected value is 'ExecutePipeline'.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        :param Mapping[str, Any] parameters: Pipeline parameters.
        :param bool wait_on_completion: Defines whether activity execution will wait for the dependent pipeline execution to finish. Default is false.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pipeline", pipeline)
        pulumi.set(__self__, "type", 'ExecutePipeline')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if wait_on_completion is not None:
            pulumi.set(__self__, "wait_on_completion", wait_on_completion)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def pipeline(self) -> 'outputs.PipelineReferenceResponse':
        """
        Pipeline reference.
        """
        return pulumi.get(self, "pipeline")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'ExecutePipeline'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, Any]]:
        """
        Pipeline parameters.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="waitOnCompletion")
    def wait_on_completion(self) -> Optional[bool]:
        """
        Defines whether activity execution will wait for the dependent pipeline execution to finish. Default is false.
        """
        return pulumi.get(self, "wait_on_completion")


@pulumi.output_type
class ExecuteSSISPackageActivityResponse(dict):
    """
    Execute SSIS package activity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectVia":
            suggest = "connect_via"
        elif key == "packageLocation":
            suggest = "package_location"
        elif key == "dependsOn":
            suggest = "depends_on"
        elif key == "environmentPath":
            suggest = "environment_path"
        elif key == "executionCredential":
            suggest = "execution_credential"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "logLocation":
            suggest = "log_location"
        elif key == "loggingLevel":
            suggest = "logging_level"
        elif key == "packageConnectionManagers":
            suggest = "package_connection_managers"
        elif key == "packageParameters":
            suggest = "package_parameters"
        elif key == "projectConnectionManagers":
            suggest = "project_connection_managers"
        elif key == "projectParameters":
            suggest = "project_parameters"
        elif key == "propertyOverrides":
            suggest = "property_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExecuteSSISPackageActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExecuteSSISPackageActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExecuteSSISPackageActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_via: 'outputs.IntegrationRuntimeReferenceResponse',
                 name: str,
                 package_location: 'outputs.SSISPackageLocationResponse',
                 type: str,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None,
                 environment_path: Optional[Any] = None,
                 execution_credential: Optional['outputs.SSISExecutionCredentialResponse'] = None,
                 linked_service_name: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 log_location: Optional['outputs.SSISLogLocationResponse'] = None,
                 logging_level: Optional[Any] = None,
                 package_connection_managers: Optional[Mapping[str, Mapping[str, 'outputs.SSISExecutionParameterResponse']]] = None,
                 package_parameters: Optional[Mapping[str, 'outputs.SSISExecutionParameterResponse']] = None,
                 policy: Optional['outputs.ActivityPolicyResponse'] = None,
                 project_connection_managers: Optional[Mapping[str, Mapping[str, 'outputs.SSISExecutionParameterResponse']]] = None,
                 project_parameters: Optional[Mapping[str, 'outputs.SSISExecutionParameterResponse']] = None,
                 property_overrides: Optional[Mapping[str, 'outputs.SSISPropertyOverrideResponse']] = None,
                 runtime: Optional[Any] = None):
        """
        Execute SSIS package activity.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str name: Activity name.
        :param 'SSISPackageLocationResponse' package_location: SSIS package location.
        :param str type: Type of activity.
               Expected value is 'ExecuteSSISPackage'.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        :param Any environment_path: The environment path to execute the SSIS package. Type: string (or Expression with resultType string).
        :param 'SSISExecutionCredentialResponse' execution_credential: The package execution credential.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param 'SSISLogLocationResponse' log_location: SSIS package execution log location.
        :param Any logging_level: The logging level of SSIS package execution. Type: string (or Expression with resultType string).
        :param Mapping[str, Mapping[str, 'SSISExecutionParameterResponse']] package_connection_managers: The package level connection managers to execute the SSIS package.
        :param Mapping[str, 'SSISExecutionParameterResponse'] package_parameters: The package level parameters to execute the SSIS package.
        :param 'ActivityPolicyResponse' policy: Activity policy.
        :param Mapping[str, Mapping[str, 'SSISExecutionParameterResponse']] project_connection_managers: The project level connection managers to execute the SSIS package.
        :param Mapping[str, 'SSISExecutionParameterResponse'] project_parameters: The project level parameters to execute the SSIS package.
        :param Mapping[str, 'SSISPropertyOverrideResponse'] property_overrides: The property overrides to execute the SSIS package.
        :param Any runtime: Specifies the runtime to execute SSIS package. The value should be "x86" or "x64". Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "connect_via", connect_via)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "package_location", package_location)
        pulumi.set(__self__, "type", 'ExecuteSSISPackage')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_path is not None:
            pulumi.set(__self__, "environment_path", environment_path)
        if execution_credential is not None:
            pulumi.set(__self__, "execution_credential", execution_credential)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if log_location is not None:
            pulumi.set(__self__, "log_location", log_location)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if package_connection_managers is not None:
            pulumi.set(__self__, "package_connection_managers", package_connection_managers)
        if package_parameters is not None:
            pulumi.set(__self__, "package_parameters", package_parameters)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if project_connection_managers is not None:
            pulumi.set(__self__, "project_connection_managers", project_connection_managers)
        if project_parameters is not None:
            pulumi.set(__self__, "project_parameters", project_parameters)
        if property_overrides is not None:
            pulumi.set(__self__, "property_overrides", property_overrides)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> 'outputs.IntegrationRuntimeReferenceResponse':
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="packageLocation")
    def package_location(self) -> 'outputs.SSISPackageLocationResponse':
        """
        SSIS package location.
        """
        return pulumi.get(self, "package_location")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'ExecuteSSISPackage'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="environmentPath")
    def environment_path(self) -> Optional[Any]:
        """
        The environment path to execute the SSIS package. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "environment_path")

    @property
    @pulumi.getter(name="executionCredential")
    def execution_credential(self) -> Optional['outputs.SSISExecutionCredentialResponse']:
        """
        The package execution credential.
        """
        return pulumi.get(self, "execution_credential")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter(name="logLocation")
    def log_location(self) -> Optional['outputs.SSISLogLocationResponse']:
        """
        SSIS package execution log location.
        """
        return pulumi.get(self, "log_location")

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[Any]:
        """
        The logging level of SSIS package execution. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "logging_level")

    @property
    @pulumi.getter(name="packageConnectionManagers")
    def package_connection_managers(self) -> Optional[Mapping[str, Mapping[str, 'outputs.SSISExecutionParameterResponse']]]:
        """
        The package level connection managers to execute the SSIS package.
        """
        return pulumi.get(self, "package_connection_managers")

    @property
    @pulumi.getter(name="packageParameters")
    def package_parameters(self) -> Optional[Mapping[str, 'outputs.SSISExecutionParameterResponse']]:
        """
        The package level parameters to execute the SSIS package.
        """
        return pulumi.get(self, "package_parameters")

    @property
    @pulumi.getter
    def policy(self) -> Optional['outputs.ActivityPolicyResponse']:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="projectConnectionManagers")
    def project_connection_managers(self) -> Optional[Mapping[str, Mapping[str, 'outputs.SSISExecutionParameterResponse']]]:
        """
        The project level connection managers to execute the SSIS package.
        """
        return pulumi.get(self, "project_connection_managers")

    @property
    @pulumi.getter(name="projectParameters")
    def project_parameters(self) -> Optional[Mapping[str, 'outputs.SSISExecutionParameterResponse']]:
        """
        The project level parameters to execute the SSIS package.
        """
        return pulumi.get(self, "project_parameters")

    @property
    @pulumi.getter(name="propertyOverrides")
    def property_overrides(self) -> Optional[Mapping[str, 'outputs.SSISPropertyOverrideResponse']]:
        """
        The property overrides to execute the SSIS package.
        """
        return pulumi.get(self, "property_overrides")

    @property
    @pulumi.getter
    def runtime(self) -> Optional[Any]:
        """
        Specifies the runtime to execute SSIS package. The value should be "x86" or "x64". Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "runtime")


@pulumi.output_type
class ExecutionActivityResponse(dict):
    """
    Base class for all execution activities.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOn":
            suggest = "depends_on"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExecutionActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExecutionActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExecutionActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None,
                 linked_service_name: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 policy: Optional['outputs.ActivityPolicyResponse'] = None):
        """
        Base class for all execution activities.
        :param str name: Activity name.
        :param str type: Type of activity.
               Expected value is 'Execution'.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param 'ActivityPolicyResponse' policy: Activity policy.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'Execution')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'Execution'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def policy(self) -> Optional['outputs.ActivityPolicyResponse']:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")


@pulumi.output_type
class ExpressionResponse(dict):
    """
    Azure Data Factory expression definition.
    """
    def __init__(__self__, *,
                 type: str,
                 value: str):
        """
        Azure Data Factory expression definition.
        :param str type: Expression type.
        :param str value: Expression value.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Expression type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Expression value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class FactoryIdentityResponse(dict):
    """
    Identity properties of the factory resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FactoryIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FactoryIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FactoryIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str):
        """
        Identity properties of the factory resource.
        :param str principal_id: The principal id of the identity.
        :param str tenant_id: The client tenant id of the identity.
        :param str type: The identity type. Currently the only supported type is 'SystemAssigned'.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of the identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The client tenant id of the identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The identity type. Currently the only supported type is 'SystemAssigned'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FactoryVSTSConfigurationResponse(dict):
    """
    Factory's VSTS repo information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "collaborationBranch":
            suggest = "collaboration_branch"
        elif key == "lastCommitId":
            suggest = "last_commit_id"
        elif key == "projectName":
            suggest = "project_name"
        elif key == "repositoryName":
            suggest = "repository_name"
        elif key == "rootFolder":
            suggest = "root_folder"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FactoryVSTSConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FactoryVSTSConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FactoryVSTSConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: Optional[str] = None,
                 collaboration_branch: Optional[str] = None,
                 last_commit_id: Optional[str] = None,
                 project_name: Optional[str] = None,
                 repository_name: Optional[str] = None,
                 root_folder: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Factory's VSTS repo information.
        :param str account_name: VSTS account name.
        :param str collaboration_branch: VSTS collaboration branch.
        :param str last_commit_id: VSTS last commit id.
        :param str project_name: VSTS project name.
        :param str repository_name: VSTS repository name.
        :param str root_folder: VSTS root folder.
        :param str tenant_id: VSTS tenant id.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if collaboration_branch is not None:
            pulumi.set(__self__, "collaboration_branch", collaboration_branch)
        if last_commit_id is not None:
            pulumi.set(__self__, "last_commit_id", last_commit_id)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)
        if root_folder is not None:
            pulumi.set(__self__, "root_folder", root_folder)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        VSTS account name.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="collaborationBranch")
    def collaboration_branch(self) -> Optional[str]:
        """
        VSTS collaboration branch.
        """
        return pulumi.get(self, "collaboration_branch")

    @property
    @pulumi.getter(name="lastCommitId")
    def last_commit_id(self) -> Optional[str]:
        """
        VSTS last commit id.
        """
        return pulumi.get(self, "last_commit_id")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[str]:
        """
        VSTS project name.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[str]:
        """
        VSTS repository name.
        """
        return pulumi.get(self, "repository_name")

    @property
    @pulumi.getter(name="rootFolder")
    def root_folder(self) -> Optional[str]:
        """
        VSTS root folder.
        """
        return pulumi.get(self, "root_folder")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        VSTS tenant id.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class FileServerLinkedServiceResponse(dict):
    """
    File system linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileServerLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileServerLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileServerLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 user_id: Optional[Any] = None):
        """
        File system linked service.
        :param Any host: Host name of the server. Type: string (or Expression with resultType string).
        :param str type: Type of linked service.
               Expected value is 'FileServer'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: Password to logon the server.
        :param Any user_id: User ID to logon the server. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'FileServer')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        Host name of the server. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'FileServer'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        Password to logon the server.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[Any]:
        """
        User ID to logon the server. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class FileShareDatasetResponse(dict):
    """
    An on-premises file system dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "fileFilter":
            suggest = "file_filter"
        elif key == "fileName":
            suggest = "file_name"
        elif key == "folderPath":
            suggest = "folder_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileShareDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileShareDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileShareDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 compression: Optional[Any] = None,
                 description: Optional[str] = None,
                 file_filter: Optional[Any] = None,
                 file_name: Optional[Any] = None,
                 folder_path: Optional[Any] = None,
                 format: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        An on-premises file system dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'FileShare'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param Union['DatasetBZip2CompressionResponse', 'DatasetDeflateCompressionResponse', 'DatasetGZipCompressionResponse', 'DatasetZipDeflateCompressionResponse'] compression: The data compression method used for the file system.
        :param str description: Dataset description.
        :param Any file_filter: Specify a filter to be used to select a subset of files in the folderPath rather than all files. Type: string (or Expression with resultType string).
        :param Any file_name: The name of the on-premises file system. Type: string (or Expression with resultType string).
        :param Any folder_path: The path of the on-premises file system. Type: string (or Expression with resultType string).
        :param Union['AvroFormatResponse', 'JsonFormatResponse', 'OrcFormatResponse', 'ParquetFormatResponse', 'TextFormatResponse'] format: The format of the files.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'FileShare')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_filter is not None:
            pulumi.set(__self__, "file_filter", file_filter)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if folder_path is not None:
            pulumi.set(__self__, "folder_path", folder_path)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'FileShare'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def compression(self) -> Optional[Any]:
        """
        The data compression method used for the file system.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fileFilter")
    def file_filter(self) -> Optional[Any]:
        """
        Specify a filter to be used to select a subset of files in the folderPath rather than all files. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "file_filter")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[Any]:
        """
        The name of the on-premises file system. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> Optional[Any]:
        """
        The path of the on-premises file system. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "folder_path")

    @property
    @pulumi.getter
    def format(self) -> Optional[Any]:
        """
        The format of the files.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class FileSystemSinkResponse(dict):
    """
    A copy activity file system sink.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyBehavior":
            suggest = "copy_behavior"
        elif key == "sinkRetryCount":
            suggest = "sink_retry_count"
        elif key == "sinkRetryWait":
            suggest = "sink_retry_wait"
        elif key == "writeBatchSize":
            suggest = "write_batch_size"
        elif key == "writeBatchTimeout":
            suggest = "write_batch_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemSinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemSinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemSinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 copy_behavior: Optional[Any] = None,
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None):
        """
        A copy activity file system sink.
        :param str type: Copy sink type.
               Expected value is 'FileSystemSink'.
        :param Any copy_behavior: The type of copy behavior for copy sink.
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'FileSystemSink')
        if copy_behavior is not None:
            pulumi.set(__self__, "copy_behavior", copy_behavior)
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy sink type.
        Expected value is 'FileSystemSink'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="copyBehavior")
    def copy_behavior(self) -> Optional[Any]:
        """
        The type of copy behavior for copy sink.
        """
        return pulumi.get(self, "copy_behavior")

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")


@pulumi.output_type
class FileSystemSourceResponse(dict):
    """
    A copy activity file system source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 recursive: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity file system source.
        :param str type: Copy source type.
               Expected value is 'FileSystemSource'.
        :param Any recursive: If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'FileSystemSource')
        if recursive is not None:
            pulumi.set(__self__, "recursive", recursive)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'FileSystemSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def recursive(self) -> Optional[Any]:
        """
        If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "recursive")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class FilterActivityResponse(dict):
    """
    Filter and return results from input array based on the conditions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOn":
            suggest = "depends_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FilterActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FilterActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FilterActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: 'outputs.ExpressionResponse',
                 items: 'outputs.ExpressionResponse',
                 name: str,
                 type: str,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None):
        """
        Filter and return results from input array based on the conditions.
        :param 'ExpressionResponse' condition: Condition to be used for filtering the input.
        :param 'ExpressionResponse' items: Input array on which filter should be applied.
        :param str name: Activity name.
        :param str type: Type of activity.
               Expected value is 'Filter'.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'Filter')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExpressionResponse':
        """
        Condition to be used for filtering the input.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def items(self) -> 'outputs.ExpressionResponse':
        """
        Input array on which filter should be applied.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'Filter'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ForEachActivityResponse(dict):
    """
    This activity is used for iterating over a collection and execute given activities.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchCount":
            suggest = "batch_count"
        elif key == "dependsOn":
            suggest = "depends_on"
        elif key == "isSequential":
            suggest = "is_sequential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ForEachActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ForEachActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ForEachActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activities: Sequence[Any],
                 items: 'outputs.ExpressionResponse',
                 name: str,
                 type: str,
                 batch_count: Optional[int] = None,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None,
                 is_sequential: Optional[bool] = None):
        """
        This activity is used for iterating over a collection and execute given activities.
        :param Sequence[Union['AzureMLBatchExecutionActivityResponse', 'AzureMLUpdateResourceActivityResponse', 'ControlActivityResponse', 'CopyActivityResponse', 'CustomActivityResponse', 'DataLakeAnalyticsUSQLActivityResponse', 'DatabricksNotebookActivityResponse', 'ExecutePipelineActivityResponse', 'ExecuteSSISPackageActivityResponse', 'ExecutionActivityResponse', 'FilterActivityResponse', 'ForEachActivityResponse', 'GetMetadataActivityResponse', 'HDInsightHiveActivityResponse', 'HDInsightMapReduceActivityResponse', 'HDInsightPigActivityResponse', 'HDInsightSparkActivityResponse', 'HDInsightStreamingActivityResponse', 'IfConditionActivityResponse', 'LookupActivityResponse', 'SqlServerStoredProcedureActivityResponse', 'UntilActivityResponse', 'WaitActivityResponse', 'WebActivityResponse']] activities: List of activities to execute .
        :param 'ExpressionResponse' items: Collection to iterate.
        :param str name: Activity name.
        :param str type: Type of activity.
               Expected value is 'ForEach'.
        :param int batch_count: Batch count to be used for controlling the number of parallel execution (when isSequential is set to false).
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        :param bool is_sequential: Should the loop be executed in sequence or in parallel (max 50)
        """
        pulumi.set(__self__, "activities", activities)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'ForEach')
        if batch_count is not None:
            pulumi.set(__self__, "batch_count", batch_count)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_sequential is not None:
            pulumi.set(__self__, "is_sequential", is_sequential)

    @property
    @pulumi.getter
    def activities(self) -> Sequence[Any]:
        """
        List of activities to execute .
        """
        return pulumi.get(self, "activities")

    @property
    @pulumi.getter
    def items(self) -> 'outputs.ExpressionResponse':
        """
        Collection to iterate.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'ForEach'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="batchCount")
    def batch_count(self) -> Optional[int]:
        """
        Batch count to be used for controlling the number of parallel execution (when isSequential is set to false).
        """
        return pulumi.get(self, "batch_count")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isSequential")
    def is_sequential(self) -> Optional[bool]:
        """
        Should the loop be executed in sequence or in parallel (max 50)
        """
        return pulumi.get(self, "is_sequential")


@pulumi.output_type
class FtpServerLinkedServiceResponse(dict):
    """
    A FTP server Linked Service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "enableServerCertificateValidation":
            suggest = "enable_server_certificate_validation"
        elif key == "enableSsl":
            suggest = "enable_ssl"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FtpServerLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FtpServerLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FtpServerLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 authentication_type: Optional[str] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 enable_server_certificate_validation: Optional[Any] = None,
                 enable_ssl: Optional[Any] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 port: Optional[Any] = None,
                 user_name: Optional[Any] = None):
        """
        A FTP server Linked Service.
        :param Any host: Host name of the FTP server. Type: string (or Expression with resultType string).
        :param str type: Type of linked service.
               Expected value is 'FtpServer'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str authentication_type: The authentication type to be used to connect to the FTP server.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any enable_server_certificate_validation: If true, validate the FTP server SSL certificate when connect over SSL/TLS channel. Default value is true. Type: boolean (or Expression with resultType boolean).
        :param Any enable_ssl: If true, connect to the FTP server over SSL/TLS channel. Default value is true. Type: boolean (or Expression with resultType boolean).
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: Password to logon the FTP server.
        :param Any port: The TCP port number that the FTP server uses to listen for client connections. Default value is 21. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any user_name: Username to logon the FTP server. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'FtpServer')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_server_certificate_validation is not None:
            pulumi.set(__self__, "enable_server_certificate_validation", enable_server_certificate_validation)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        Host name of the FTP server. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'FtpServer'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[str]:
        """
        The authentication type to be used to connect to the FTP server.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableServerCertificateValidation")
    def enable_server_certificate_validation(self) -> Optional[Any]:
        """
        If true, validate the FTP server SSL certificate when connect over SSL/TLS channel. Default value is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "enable_server_certificate_validation")

    @property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[Any]:
        """
        If true, connect to the FTP server over SSL/TLS channel. Default value is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "enable_ssl")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        Password to logon the FTP server.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The TCP port number that the FTP server uses to listen for client connections. Default value is 21. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[Any]:
        """
        Username to logon the FTP server. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class GetMetadataActivityResponse(dict):
    """
    Activity to get metadata of dataset
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOn":
            suggest = "depends_on"
        elif key == "fieldList":
            suggest = "field_list"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GetMetadataActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GetMetadataActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GetMetadataActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: 'outputs.DatasetReferenceResponse',
                 name: str,
                 type: str,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None,
                 field_list: Optional[Sequence[Any]] = None,
                 linked_service_name: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 policy: Optional['outputs.ActivityPolicyResponse'] = None):
        """
        Activity to get metadata of dataset
        :param 'DatasetReferenceResponse' dataset: GetMetadata activity dataset reference.
        :param str name: Activity name.
        :param str type: Type of activity.
               Expected value is 'GetMetadata'.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        :param Sequence[Any] field_list: Fields of metadata to get from dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param 'ActivityPolicyResponse' policy: Activity policy.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'GetMetadata')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if field_list is not None:
            pulumi.set(__self__, "field_list", field_list)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def dataset(self) -> 'outputs.DatasetReferenceResponse':
        """
        GetMetadata activity dataset reference.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'GetMetadata'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fieldList")
    def field_list(self) -> Optional[Sequence[Any]]:
        """
        Fields of metadata to get from dataset.
        """
        return pulumi.get(self, "field_list")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def policy(self) -> Optional['outputs.ActivityPolicyResponse']:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")


@pulumi.output_type
class GoogleBigQueryLinkedServiceResponse(dict):
    """
    Google BigQuery service linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "additionalProjects":
            suggest = "additional_projects"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "keyFilePath":
            suggest = "key_file_path"
        elif key == "refreshToken":
            suggest = "refresh_token"
        elif key == "requestGoogleDriveScope":
            suggest = "request_google_drive_scope"
        elif key == "trustedCertPath":
            suggest = "trusted_cert_path"
        elif key == "useSystemTrustStore":
            suggest = "use_system_trust_store"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleBigQueryLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleBigQueryLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleBigQueryLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_type: str,
                 project: Any,
                 type: str,
                 additional_projects: Optional[Any] = None,
                 annotations: Optional[Sequence[Any]] = None,
                 client_id: Optional[Any] = None,
                 client_secret: Optional[Any] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 email: Optional[Any] = None,
                 encrypted_credential: Optional[Any] = None,
                 key_file_path: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 refresh_token: Optional[Any] = None,
                 request_google_drive_scope: Optional[Any] = None,
                 trusted_cert_path: Optional[Any] = None,
                 use_system_trust_store: Optional[Any] = None):
        """
        Google BigQuery service linked service.
        :param str authentication_type: The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
        :param Any project: The default BigQuery project to query against.
        :param str type: Type of linked service.
               Expected value is 'GoogleBigQuery'.
        :param Any additional_projects: A comma-separated list of public BigQuery projects to access.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] client_id: The client id of the google application used to acquire the refresh token.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] client_secret: The client secret of the google application used to acquire the refresh token.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any email: The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Any key_file_path: The full path to the .p12 key file that is used to authenticate the service account email address and can only be used on self-hosted IR.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] refresh_token: The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
        :param Any request_google_drive_scope: Whether to request access to Google Drive. Allowing Google Drive access enables support for federated tables that combine BigQuery data with data from Google Drive. The default value is false.
        :param Any trusted_cert_path: The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        :param Any use_system_trust_store: Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "type", 'GoogleBigQuery')
        if additional_projects is not None:
            pulumi.set(__self__, "additional_projects", additional_projects)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if key_file_path is not None:
            pulumi.set(__self__, "key_file_path", key_file_path)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if request_google_drive_scope is not None:
            pulumi.set(__self__, "request_google_drive_scope", request_google_drive_scope)
        if trusted_cert_path is not None:
            pulumi.set(__self__, "trusted_cert_path", trusted_cert_path)
        if use_system_trust_store is not None:
            pulumi.set(__self__, "use_system_trust_store", use_system_trust_store)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> str:
        """
        The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter
    def project(self) -> Any:
        """
        The default BigQuery project to query against.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'GoogleBigQuery'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="additionalProjects")
    def additional_projects(self) -> Optional[Any]:
        """
        A comma-separated list of public BigQuery projects to access.
        """
        return pulumi.get(self, "additional_projects")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[Any]:
        """
        The client id of the google application used to acquire the refresh token.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[Any]:
        """
        The client secret of the google application used to acquire the refresh token.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def email(self) -> Optional[Any]:
        """
        The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter(name="keyFilePath")
    def key_file_path(self) -> Optional[Any]:
        """
        The full path to the .p12 key file that is used to authenticate the service account email address and can only be used on self-hosted IR.
        """
        return pulumi.get(self, "key_file_path")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[Any]:
        """
        The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
        """
        return pulumi.get(self, "refresh_token")

    @property
    @pulumi.getter(name="requestGoogleDriveScope")
    def request_google_drive_scope(self) -> Optional[Any]:
        """
        Whether to request access to Google Drive. Allowing Google Drive access enables support for federated tables that combine BigQuery data with data from Google Drive. The default value is false.
        """
        return pulumi.get(self, "request_google_drive_scope")

    @property
    @pulumi.getter(name="trustedCertPath")
    def trusted_cert_path(self) -> Optional[Any]:
        """
        The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        """
        return pulumi.get(self, "trusted_cert_path")

    @property
    @pulumi.getter(name="useSystemTrustStore")
    def use_system_trust_store(self) -> Optional[Any]:
        """
        Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        """
        return pulumi.get(self, "use_system_trust_store")


@pulumi.output_type
class GoogleBigQueryObjectDatasetResponse(dict):
    """
    Google BigQuery service dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleBigQueryObjectDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleBigQueryObjectDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleBigQueryObjectDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Google BigQuery service dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'GoogleBigQueryObject'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'GoogleBigQueryObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'GoogleBigQueryObject'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class GoogleBigQuerySourceResponse(dict):
    """
    A copy activity Google BigQuery service source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleBigQuerySourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleBigQuerySourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleBigQuerySourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Google BigQuery service source.
        :param str type: Copy source type.
               Expected value is 'GoogleBigQuerySource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'GoogleBigQuerySource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'GoogleBigQuerySource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class GreenplumLinkedServiceResponse(dict):
    """
    Greenplum Database linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectVia":
            suggest = "connect_via"
        elif key == "connectionString":
            suggest = "connection_string"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GreenplumLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GreenplumLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GreenplumLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 connection_string: Optional[Any] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None):
        """
        Greenplum Database linked service.
        :param str type: Type of linked service.
               Expected value is 'Greenplum'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param Any connection_string: An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "type", 'Greenplum')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Greenplum'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[Any]:
        """
        An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class GreenplumSourceResponse(dict):
    """
    A copy activity Greenplum Database source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GreenplumSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GreenplumSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GreenplumSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Greenplum Database source.
        :param str type: Copy source type.
               Expected value is 'GreenplumSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'GreenplumSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'GreenplumSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class GreenplumTableDatasetResponse(dict):
    """
    Greenplum Database dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GreenplumTableDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GreenplumTableDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GreenplumTableDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Greenplum Database dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'GreenplumTable'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'GreenplumTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'GreenplumTable'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class HBaseLinkedServiceResponse(dict):
    """
    HBase server linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "allowHostNameCNMismatch":
            suggest = "allow_host_name_cn_mismatch"
        elif key == "allowSelfSignedServerCert":
            suggest = "allow_self_signed_server_cert"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "enableSsl":
            suggest = "enable_ssl"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "httpPath":
            suggest = "http_path"
        elif key == "trustedCertPath":
            suggest = "trusted_cert_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HBaseLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HBaseLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HBaseLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_type: str,
                 host: Any,
                 type: str,
                 allow_host_name_cn_mismatch: Optional[Any] = None,
                 allow_self_signed_server_cert: Optional[Any] = None,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 enable_ssl: Optional[Any] = None,
                 encrypted_credential: Optional[Any] = None,
                 http_path: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 port: Optional[Any] = None,
                 trusted_cert_path: Optional[Any] = None,
                 username: Optional[Any] = None):
        """
        HBase server linked service.
        :param str authentication_type: The authentication mechanism to use to connect to the HBase server.
        :param Any host: The IP address or host name of the HBase server. (i.e. 192.168.222.160)
        :param str type: Type of linked service.
               Expected value is 'HBase'.
        :param Any allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        :param Any allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from the server. The default value is false.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Any http_path: The partial URL corresponding to the HBase server. (i.e. /gateway/sandbox/hbase/version)
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: The password corresponding to the user name.
        :param Any port: The TCP port that the HBase instance uses to listen for client connections. The default value is 9090.
        :param Any trusted_cert_path: The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        :param Any username: The user name used to connect to the HBase instance.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'HBase')
        if allow_host_name_cn_mismatch is not None:
            pulumi.set(__self__, "allow_host_name_cn_mismatch", allow_host_name_cn_mismatch)
        if allow_self_signed_server_cert is not None:
            pulumi.set(__self__, "allow_self_signed_server_cert", allow_self_signed_server_cert)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if http_path is not None:
            pulumi.set(__self__, "http_path", http_path)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if trusted_cert_path is not None:
            pulumi.set(__self__, "trusted_cert_path", trusted_cert_path)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> str:
        """
        The authentication mechanism to use to connect to the HBase server.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        The IP address or host name of the HBase server. (i.e. 192.168.222.160)
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'HBase'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="allowHostNameCNMismatch")
    def allow_host_name_cn_mismatch(self) -> Optional[Any]:
        """
        Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        """
        return pulumi.get(self, "allow_host_name_cn_mismatch")

    @property
    @pulumi.getter(name="allowSelfSignedServerCert")
    def allow_self_signed_server_cert(self) -> Optional[Any]:
        """
        Specifies whether to allow self-signed certificates from the server. The default value is false.
        """
        return pulumi.get(self, "allow_self_signed_server_cert")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[Any]:
        """
        Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        """
        return pulumi.get(self, "enable_ssl")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter(name="httpPath")
    def http_path(self) -> Optional[Any]:
        """
        The partial URL corresponding to the HBase server. (i.e. /gateway/sandbox/hbase/version)
        """
        return pulumi.get(self, "http_path")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        The password corresponding to the user name.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The TCP port that the HBase instance uses to listen for client connections. The default value is 9090.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="trustedCertPath")
    def trusted_cert_path(self) -> Optional[Any]:
        """
        The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        """
        return pulumi.get(self, "trusted_cert_path")

    @property
    @pulumi.getter
    def username(self) -> Optional[Any]:
        """
        The user name used to connect to the HBase instance.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class HBaseObjectDatasetResponse(dict):
    """
    HBase server dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HBaseObjectDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HBaseObjectDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HBaseObjectDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        HBase server dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'HBaseObject'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'HBaseObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'HBaseObject'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class HBaseSourceResponse(dict):
    """
    A copy activity HBase server source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HBaseSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HBaseSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HBaseSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity HBase server source.
        :param str type: Copy source type.
               Expected value is 'HBaseSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'HBaseSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'HBaseSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class HDInsightHiveActivityResponse(dict):
    """
    HDInsight Hive activity type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOn":
            suggest = "depends_on"
        elif key == "getDebugInfo":
            suggest = "get_debug_info"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "scriptLinkedService":
            suggest = "script_linked_service"
        elif key == "scriptPath":
            suggest = "script_path"
        elif key == "storageLinkedServices":
            suggest = "storage_linked_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HDInsightHiveActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HDInsightHiveActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HDInsightHiveActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 arguments: Optional[Sequence[Any]] = None,
                 defines: Optional[Mapping[str, Any]] = None,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None,
                 get_debug_info: Optional[str] = None,
                 linked_service_name: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 policy: Optional['outputs.ActivityPolicyResponse'] = None,
                 script_linked_service: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 script_path: Optional[Any] = None,
                 storage_linked_services: Optional[Sequence['outputs.LinkedServiceReferenceResponse']] = None):
        """
        HDInsight Hive activity type.
        :param str name: Activity name.
        :param str type: Type of activity.
               Expected value is 'HDInsightHive'.
        :param Sequence[Any] arguments: User specified arguments to HDInsightActivity.
        :param Mapping[str, Any] defines: Allows user to specify defines for Hive job request.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        :param str get_debug_info: Debug info option.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param 'ActivityPolicyResponse' policy: Activity policy.
        :param 'LinkedServiceReferenceResponse' script_linked_service: Script linked service reference.
        :param Any script_path: Script path. Type: string (or Expression with resultType string).
        :param Sequence['LinkedServiceReferenceResponse'] storage_linked_services: Storage linked service references.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'HDInsightHive')
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if defines is not None:
            pulumi.set(__self__, "defines", defines)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if get_debug_info is not None:
            pulumi.set(__self__, "get_debug_info", get_debug_info)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if script_linked_service is not None:
            pulumi.set(__self__, "script_linked_service", script_linked_service)
        if script_path is not None:
            pulumi.set(__self__, "script_path", script_path)
        if storage_linked_services is not None:
            pulumi.set(__self__, "storage_linked_services", storage_linked_services)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'HDInsightHive'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def arguments(self) -> Optional[Sequence[Any]]:
        """
        User specified arguments to HDInsightActivity.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter
    def defines(self) -> Optional[Mapping[str, Any]]:
        """
        Allows user to specify defines for Hive job request.
        """
        return pulumi.get(self, "defines")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="getDebugInfo")
    def get_debug_info(self) -> Optional[str]:
        """
        Debug info option.
        """
        return pulumi.get(self, "get_debug_info")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def policy(self) -> Optional['outputs.ActivityPolicyResponse']:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="scriptLinkedService")
    def script_linked_service(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Script linked service reference.
        """
        return pulumi.get(self, "script_linked_service")

    @property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Optional[Any]:
        """
        Script path. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "script_path")

    @property
    @pulumi.getter(name="storageLinkedServices")
    def storage_linked_services(self) -> Optional[Sequence['outputs.LinkedServiceReferenceResponse']]:
        """
        Storage linked service references.
        """
        return pulumi.get(self, "storage_linked_services")


@pulumi.output_type
class HDInsightLinkedServiceResponse(dict):
    """
    HDInsight linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterUri":
            suggest = "cluster_uri"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "hcatalogLinkedServiceName":
            suggest = "hcatalog_linked_service_name"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HDInsightLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HDInsightLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HDInsightLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_uri: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 hcatalog_linked_service_name: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 linked_service_name: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 user_name: Optional[Any] = None):
        """
        HDInsight linked service.
        :param Any cluster_uri: HDInsight cluster URI. Type: string (or Expression with resultType string).
        :param str type: Type of linked service.
               Expected value is 'HDInsight'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param 'LinkedServiceReferenceResponse' hcatalog_linked_service_name: A reference to the Azure SQL linked service that points to the HCatalog database.
        :param 'LinkedServiceReferenceResponse' linked_service_name: The Azure Storage linked service reference.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: HDInsight cluster password.
        :param Any user_name: HDInsight cluster user name. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "cluster_uri", cluster_uri)
        pulumi.set(__self__, "type", 'HDInsight')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if hcatalog_linked_service_name is not None:
            pulumi.set(__self__, "hcatalog_linked_service_name", hcatalog_linked_service_name)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="clusterUri")
    def cluster_uri(self) -> Any:
        """
        HDInsight cluster URI. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "cluster_uri")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'HDInsight'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter(name="hcatalogLinkedServiceName")
    def hcatalog_linked_service_name(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        A reference to the Azure SQL linked service that points to the HCatalog database.
        """
        return pulumi.get(self, "hcatalog_linked_service_name")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        The Azure Storage linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        HDInsight cluster password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[Any]:
        """
        HDInsight cluster user name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class HDInsightMapReduceActivityResponse(dict):
    """
    HDInsight MapReduce activity type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "className":
            suggest = "class_name"
        elif key == "jarFilePath":
            suggest = "jar_file_path"
        elif key == "dependsOn":
            suggest = "depends_on"
        elif key == "getDebugInfo":
            suggest = "get_debug_info"
        elif key == "jarLibs":
            suggest = "jar_libs"
        elif key == "jarLinkedService":
            suggest = "jar_linked_service"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "storageLinkedServices":
            suggest = "storage_linked_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HDInsightMapReduceActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HDInsightMapReduceActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HDInsightMapReduceActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 class_name: Any,
                 jar_file_path: Any,
                 name: str,
                 type: str,
                 arguments: Optional[Sequence[Any]] = None,
                 defines: Optional[Mapping[str, Any]] = None,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None,
                 get_debug_info: Optional[str] = None,
                 jar_libs: Optional[Sequence[Any]] = None,
                 jar_linked_service: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 linked_service_name: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 policy: Optional['outputs.ActivityPolicyResponse'] = None,
                 storage_linked_services: Optional[Sequence['outputs.LinkedServiceReferenceResponse']] = None):
        """
        HDInsight MapReduce activity type.
        :param Any class_name: Class name. Type: string (or Expression with resultType string).
        :param Any jar_file_path: Jar path. Type: string (or Expression with resultType string).
        :param str name: Activity name.
        :param str type: Type of activity.
               Expected value is 'HDInsightMapReduce'.
        :param Sequence[Any] arguments: User specified arguments to HDInsightActivity.
        :param Mapping[str, Any] defines: Allows user to specify defines for the MapReduce job request.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        :param str get_debug_info: Debug info option.
        :param Sequence[Any] jar_libs: Jar libs.
        :param 'LinkedServiceReferenceResponse' jar_linked_service: Jar linked service reference.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param 'ActivityPolicyResponse' policy: Activity policy.
        :param Sequence['LinkedServiceReferenceResponse'] storage_linked_services: Storage linked service references.
        """
        pulumi.set(__self__, "class_name", class_name)
        pulumi.set(__self__, "jar_file_path", jar_file_path)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'HDInsightMapReduce')
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if defines is not None:
            pulumi.set(__self__, "defines", defines)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if get_debug_info is not None:
            pulumi.set(__self__, "get_debug_info", get_debug_info)
        if jar_libs is not None:
            pulumi.set(__self__, "jar_libs", jar_libs)
        if jar_linked_service is not None:
            pulumi.set(__self__, "jar_linked_service", jar_linked_service)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if storage_linked_services is not None:
            pulumi.set(__self__, "storage_linked_services", storage_linked_services)

    @property
    @pulumi.getter(name="className")
    def class_name(self) -> Any:
        """
        Class name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "class_name")

    @property
    @pulumi.getter(name="jarFilePath")
    def jar_file_path(self) -> Any:
        """
        Jar path. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "jar_file_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'HDInsightMapReduce'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def arguments(self) -> Optional[Sequence[Any]]:
        """
        User specified arguments to HDInsightActivity.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter
    def defines(self) -> Optional[Mapping[str, Any]]:
        """
        Allows user to specify defines for the MapReduce job request.
        """
        return pulumi.get(self, "defines")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="getDebugInfo")
    def get_debug_info(self) -> Optional[str]:
        """
        Debug info option.
        """
        return pulumi.get(self, "get_debug_info")

    @property
    @pulumi.getter(name="jarLibs")
    def jar_libs(self) -> Optional[Sequence[Any]]:
        """
        Jar libs.
        """
        return pulumi.get(self, "jar_libs")

    @property
    @pulumi.getter(name="jarLinkedService")
    def jar_linked_service(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Jar linked service reference.
        """
        return pulumi.get(self, "jar_linked_service")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def policy(self) -> Optional['outputs.ActivityPolicyResponse']:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="storageLinkedServices")
    def storage_linked_services(self) -> Optional[Sequence['outputs.LinkedServiceReferenceResponse']]:
        """
        Storage linked service references.
        """
        return pulumi.get(self, "storage_linked_services")


@pulumi.output_type
class HDInsightOnDemandLinkedServiceResponse(dict):
    """
    HDInsight ondemand linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterResourceGroup":
            suggest = "cluster_resource_group"
        elif key == "clusterSize":
            suggest = "cluster_size"
        elif key == "hostSubscriptionId":
            suggest = "host_subscription_id"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "timeToLive":
            suggest = "time_to_live"
        elif key == "additionalLinkedServiceNames":
            suggest = "additional_linked_service_names"
        elif key == "clusterNamePrefix":
            suggest = "cluster_name_prefix"
        elif key == "clusterPassword":
            suggest = "cluster_password"
        elif key == "clusterSshPassword":
            suggest = "cluster_ssh_password"
        elif key == "clusterSshUserName":
            suggest = "cluster_ssh_user_name"
        elif key == "clusterType":
            suggest = "cluster_type"
        elif key == "clusterUserName":
            suggest = "cluster_user_name"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "coreConfiguration":
            suggest = "core_configuration"
        elif key == "dataNodeSize":
            suggest = "data_node_size"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "hBaseConfiguration":
            suggest = "h_base_configuration"
        elif key == "hcatalogLinkedServiceName":
            suggest = "hcatalog_linked_service_name"
        elif key == "hdfsConfiguration":
            suggest = "hdfs_configuration"
        elif key == "headNodeSize":
            suggest = "head_node_size"
        elif key == "hiveConfiguration":
            suggest = "hive_configuration"
        elif key == "mapReduceConfiguration":
            suggest = "map_reduce_configuration"
        elif key == "oozieConfiguration":
            suggest = "oozie_configuration"
        elif key == "servicePrincipalId":
            suggest = "service_principal_id"
        elif key == "servicePrincipalKey":
            suggest = "service_principal_key"
        elif key == "sparkVersion":
            suggest = "spark_version"
        elif key == "stormConfiguration":
            suggest = "storm_configuration"
        elif key == "yarnConfiguration":
            suggest = "yarn_configuration"
        elif key == "zookeeperNodeSize":
            suggest = "zookeeper_node_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HDInsightOnDemandLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HDInsightOnDemandLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HDInsightOnDemandLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_resource_group: Any,
                 cluster_size: Any,
                 host_subscription_id: Any,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 tenant: Any,
                 time_to_live: Any,
                 type: str,
                 version: Any,
                 additional_linked_service_names: Optional[Sequence['outputs.LinkedServiceReferenceResponse']] = None,
                 annotations: Optional[Sequence[Any]] = None,
                 cluster_name_prefix: Optional[Any] = None,
                 cluster_password: Optional[Any] = None,
                 cluster_ssh_password: Optional[Any] = None,
                 cluster_ssh_user_name: Optional[Any] = None,
                 cluster_type: Optional[Any] = None,
                 cluster_user_name: Optional[Any] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 core_configuration: Optional[Any] = None,
                 data_node_size: Optional[Any] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 h_base_configuration: Optional[Any] = None,
                 hcatalog_linked_service_name: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 hdfs_configuration: Optional[Any] = None,
                 head_node_size: Optional[Any] = None,
                 hive_configuration: Optional[Any] = None,
                 map_reduce_configuration: Optional[Any] = None,
                 oozie_configuration: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 service_principal_id: Optional[Any] = None,
                 service_principal_key: Optional[Any] = None,
                 spark_version: Optional[Any] = None,
                 storm_configuration: Optional[Any] = None,
                 yarn_configuration: Optional[Any] = None,
                 zookeeper_node_size: Optional[Any] = None):
        """
        HDInsight ondemand linked service.
        :param Any cluster_resource_group: The resource group where the cluster belongs. Type: string (or Expression with resultType string).
        :param Any cluster_size: Number of worker/data nodes in the cluster. Suggestion value: 4. Type: string (or Expression with resultType string).
        :param Any host_subscription_id: The customer’s subscription to host the cluster. Type: string (or Expression with resultType string).
        :param 'LinkedServiceReferenceResponse' linked_service_name: Azure Storage linked service to be used by the on-demand cluster for storing and processing data.
        :param Any tenant: The Tenant id/name to which the service principal belongs. Type: string (or Expression with resultType string).
        :param Any time_to_live: The allowed idle time for the on-demand HDInsight cluster. Specifies how long the on-demand HDInsight cluster stays alive after completion of an activity run if there are no other active jobs in the cluster. The minimum value is 5 mins. Type: string (or Expression with resultType string).
        :param str type: Type of linked service.
               Expected value is 'HDInsightOnDemand'.
        :param Any version: Version of the HDInsight cluster.  Type: string (or Expression with resultType string).
        :param Sequence['LinkedServiceReferenceResponse'] additional_linked_service_names: Specifies additional storage accounts for the HDInsight linked service so that the Data Factory service can register them on your behalf.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param Any cluster_name_prefix: The prefix of cluster name, postfix will be distinct with timestamp. Type: string (or Expression with resultType string).
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] cluster_password: The password to access the cluster.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] cluster_ssh_password: The password to SSH remotely connect cluster’s node (for Linux).
        :param Any cluster_ssh_user_name: The username to SSH remotely connect to cluster’s node (for Linux). Type: string (or Expression with resultType string).
        :param Any cluster_type: The cluster type. Type: string (or Expression with resultType string).
        :param Any cluster_user_name: The username to access the cluster. Type: string (or Expression with resultType string).
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param Any core_configuration: Specifies the core configuration parameters (as in core-site.xml) for the HDInsight cluster to be created.
        :param Any data_node_size: Specifies the size of the data node for the HDInsight cluster.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Any h_base_configuration: Specifies the HBase configuration parameters (hbase-site.xml) for the HDInsight cluster.
        :param 'LinkedServiceReferenceResponse' hcatalog_linked_service_name: The name of Azure SQL linked service that point to the HCatalog database. The on-demand HDInsight cluster is created by using the Azure SQL database as the metastore.
        :param Any hdfs_configuration: Specifies the HDFS configuration parameters (hdfs-site.xml) for the HDInsight cluster.
        :param Any head_node_size: Specifies the size of the head node for the HDInsight cluster.
        :param Any hive_configuration: Specifies the hive configuration parameters (hive-site.xml) for the HDInsight cluster.
        :param Any map_reduce_configuration: Specifies the MapReduce configuration parameters (mapred-site.xml) for the HDInsight cluster.
        :param Any oozie_configuration: Specifies the Oozie configuration parameters (oozie-site.xml) for the HDInsight cluster.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Any service_principal_id: The service principal id for the hostSubscriptionId. Type: string (or Expression with resultType string).
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] service_principal_key: The key for the service principal id.
        :param Any spark_version: The version of spark if the cluster type is 'spark'. Type: string (or Expression with resultType string).
        :param Any storm_configuration: Specifies the Storm configuration parameters (storm-site.xml) for the HDInsight cluster.
        :param Any yarn_configuration: Specifies the Yarn configuration parameters (yarn-site.xml) for the HDInsight cluster.
        :param Any zookeeper_node_size: Specifies the size of the Zoo Keeper node for the HDInsight cluster.
        """
        pulumi.set(__self__, "cluster_resource_group", cluster_resource_group)
        pulumi.set(__self__, "cluster_size", cluster_size)
        pulumi.set(__self__, "host_subscription_id", host_subscription_id)
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "tenant", tenant)
        pulumi.set(__self__, "time_to_live", time_to_live)
        pulumi.set(__self__, "type", 'HDInsightOnDemand')
        pulumi.set(__self__, "version", version)
        if additional_linked_service_names is not None:
            pulumi.set(__self__, "additional_linked_service_names", additional_linked_service_names)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if cluster_name_prefix is not None:
            pulumi.set(__self__, "cluster_name_prefix", cluster_name_prefix)
        if cluster_password is not None:
            pulumi.set(__self__, "cluster_password", cluster_password)
        if cluster_ssh_password is not None:
            pulumi.set(__self__, "cluster_ssh_password", cluster_ssh_password)
        if cluster_ssh_user_name is not None:
            pulumi.set(__self__, "cluster_ssh_user_name", cluster_ssh_user_name)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if cluster_user_name is not None:
            pulumi.set(__self__, "cluster_user_name", cluster_user_name)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if core_configuration is not None:
            pulumi.set(__self__, "core_configuration", core_configuration)
        if data_node_size is not None:
            pulumi.set(__self__, "data_node_size", data_node_size)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if h_base_configuration is not None:
            pulumi.set(__self__, "h_base_configuration", h_base_configuration)
        if hcatalog_linked_service_name is not None:
            pulumi.set(__self__, "hcatalog_linked_service_name", hcatalog_linked_service_name)
        if hdfs_configuration is not None:
            pulumi.set(__self__, "hdfs_configuration", hdfs_configuration)
        if head_node_size is not None:
            pulumi.set(__self__, "head_node_size", head_node_size)
        if hive_configuration is not None:
            pulumi.set(__self__, "hive_configuration", hive_configuration)
        if map_reduce_configuration is not None:
            pulumi.set(__self__, "map_reduce_configuration", map_reduce_configuration)
        if oozie_configuration is not None:
            pulumi.set(__self__, "oozie_configuration", oozie_configuration)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if spark_version is not None:
            pulumi.set(__self__, "spark_version", spark_version)
        if storm_configuration is not None:
            pulumi.set(__self__, "storm_configuration", storm_configuration)
        if yarn_configuration is not None:
            pulumi.set(__self__, "yarn_configuration", yarn_configuration)
        if zookeeper_node_size is not None:
            pulumi.set(__self__, "zookeeper_node_size", zookeeper_node_size)

    @property
    @pulumi.getter(name="clusterResourceGroup")
    def cluster_resource_group(self) -> Any:
        """
        The resource group where the cluster belongs. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "cluster_resource_group")

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> Any:
        """
        Number of worker/data nodes in the cluster. Suggestion value: 4. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "cluster_size")

    @property
    @pulumi.getter(name="hostSubscriptionId")
    def host_subscription_id(self) -> Any:
        """
        The customer’s subscription to host the cluster. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "host_subscription_id")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Azure Storage linked service to be used by the on-demand cluster for storing and processing data.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def tenant(self) -> Any:
        """
        The Tenant id/name to which the service principal belongs. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "tenant")

    @property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> Any:
        """
        The allowed idle time for the on-demand HDInsight cluster. Specifies how long the on-demand HDInsight cluster stays alive after completion of an activity run if there are no other active jobs in the cluster. The minimum value is 5 mins. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "time_to_live")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'HDInsightOnDemand'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> Any:
        """
        Version of the HDInsight cluster.  Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="additionalLinkedServiceNames")
    def additional_linked_service_names(self) -> Optional[Sequence['outputs.LinkedServiceReferenceResponse']]:
        """
        Specifies additional storage accounts for the HDInsight linked service so that the Data Factory service can register them on your behalf.
        """
        return pulumi.get(self, "additional_linked_service_names")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="clusterNamePrefix")
    def cluster_name_prefix(self) -> Optional[Any]:
        """
        The prefix of cluster name, postfix will be distinct with timestamp. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "cluster_name_prefix")

    @property
    @pulumi.getter(name="clusterPassword")
    def cluster_password(self) -> Optional[Any]:
        """
        The password to access the cluster.
        """
        return pulumi.get(self, "cluster_password")

    @property
    @pulumi.getter(name="clusterSshPassword")
    def cluster_ssh_password(self) -> Optional[Any]:
        """
        The password to SSH remotely connect cluster’s node (for Linux).
        """
        return pulumi.get(self, "cluster_ssh_password")

    @property
    @pulumi.getter(name="clusterSshUserName")
    def cluster_ssh_user_name(self) -> Optional[Any]:
        """
        The username to SSH remotely connect to cluster’s node (for Linux). Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "cluster_ssh_user_name")

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[Any]:
        """
        The cluster type. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "cluster_type")

    @property
    @pulumi.getter(name="clusterUserName")
    def cluster_user_name(self) -> Optional[Any]:
        """
        The username to access the cluster. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "cluster_user_name")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter(name="coreConfiguration")
    def core_configuration(self) -> Optional[Any]:
        """
        Specifies the core configuration parameters (as in core-site.xml) for the HDInsight cluster to be created.
        """
        return pulumi.get(self, "core_configuration")

    @property
    @pulumi.getter(name="dataNodeSize")
    def data_node_size(self) -> Optional[Any]:
        """
        Specifies the size of the data node for the HDInsight cluster.
        """
        return pulumi.get(self, "data_node_size")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter(name="hBaseConfiguration")
    def h_base_configuration(self) -> Optional[Any]:
        """
        Specifies the HBase configuration parameters (hbase-site.xml) for the HDInsight cluster.
        """
        return pulumi.get(self, "h_base_configuration")

    @property
    @pulumi.getter(name="hcatalogLinkedServiceName")
    def hcatalog_linked_service_name(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        The name of Azure SQL linked service that point to the HCatalog database. The on-demand HDInsight cluster is created by using the Azure SQL database as the metastore.
        """
        return pulumi.get(self, "hcatalog_linked_service_name")

    @property
    @pulumi.getter(name="hdfsConfiguration")
    def hdfs_configuration(self) -> Optional[Any]:
        """
        Specifies the HDFS configuration parameters (hdfs-site.xml) for the HDInsight cluster.
        """
        return pulumi.get(self, "hdfs_configuration")

    @property
    @pulumi.getter(name="headNodeSize")
    def head_node_size(self) -> Optional[Any]:
        """
        Specifies the size of the head node for the HDInsight cluster.
        """
        return pulumi.get(self, "head_node_size")

    @property
    @pulumi.getter(name="hiveConfiguration")
    def hive_configuration(self) -> Optional[Any]:
        """
        Specifies the hive configuration parameters (hive-site.xml) for the HDInsight cluster.
        """
        return pulumi.get(self, "hive_configuration")

    @property
    @pulumi.getter(name="mapReduceConfiguration")
    def map_reduce_configuration(self) -> Optional[Any]:
        """
        Specifies the MapReduce configuration parameters (mapred-site.xml) for the HDInsight cluster.
        """
        return pulumi.get(self, "map_reduce_configuration")

    @property
    @pulumi.getter(name="oozieConfiguration")
    def oozie_configuration(self) -> Optional[Any]:
        """
        Specifies the Oozie configuration parameters (oozie-site.xml) for the HDInsight cluster.
        """
        return pulumi.get(self, "oozie_configuration")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[Any]:
        """
        The service principal id for the hostSubscriptionId. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "service_principal_id")

    @property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[Any]:
        """
        The key for the service principal id.
        """
        return pulumi.get(self, "service_principal_key")

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> Optional[Any]:
        """
        The version of spark if the cluster type is 'spark'. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "spark_version")

    @property
    @pulumi.getter(name="stormConfiguration")
    def storm_configuration(self) -> Optional[Any]:
        """
        Specifies the Storm configuration parameters (storm-site.xml) for the HDInsight cluster.
        """
        return pulumi.get(self, "storm_configuration")

    @property
    @pulumi.getter(name="yarnConfiguration")
    def yarn_configuration(self) -> Optional[Any]:
        """
        Specifies the Yarn configuration parameters (yarn-site.xml) for the HDInsight cluster.
        """
        return pulumi.get(self, "yarn_configuration")

    @property
    @pulumi.getter(name="zookeeperNodeSize")
    def zookeeper_node_size(self) -> Optional[Any]:
        """
        Specifies the size of the Zoo Keeper node for the HDInsight cluster.
        """
        return pulumi.get(self, "zookeeper_node_size")


@pulumi.output_type
class HDInsightPigActivityResponse(dict):
    """
    HDInsight Pig activity type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOn":
            suggest = "depends_on"
        elif key == "getDebugInfo":
            suggest = "get_debug_info"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "scriptLinkedService":
            suggest = "script_linked_service"
        elif key == "scriptPath":
            suggest = "script_path"
        elif key == "storageLinkedServices":
            suggest = "storage_linked_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HDInsightPigActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HDInsightPigActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HDInsightPigActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 arguments: Optional[Sequence[Any]] = None,
                 defines: Optional[Mapping[str, Any]] = None,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None,
                 get_debug_info: Optional[str] = None,
                 linked_service_name: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 policy: Optional['outputs.ActivityPolicyResponse'] = None,
                 script_linked_service: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 script_path: Optional[Any] = None,
                 storage_linked_services: Optional[Sequence['outputs.LinkedServiceReferenceResponse']] = None):
        """
        HDInsight Pig activity type.
        :param str name: Activity name.
        :param str type: Type of activity.
               Expected value is 'HDInsightPig'.
        :param Sequence[Any] arguments: User specified arguments to HDInsightActivity.
        :param Mapping[str, Any] defines: Allows user to specify defines for Pig job request.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        :param str get_debug_info: Debug info option.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param 'ActivityPolicyResponse' policy: Activity policy.
        :param 'LinkedServiceReferenceResponse' script_linked_service: Script linked service reference.
        :param Any script_path: Script path. Type: string (or Expression with resultType string).
        :param Sequence['LinkedServiceReferenceResponse'] storage_linked_services: Storage linked service references.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'HDInsightPig')
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if defines is not None:
            pulumi.set(__self__, "defines", defines)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if get_debug_info is not None:
            pulumi.set(__self__, "get_debug_info", get_debug_info)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if script_linked_service is not None:
            pulumi.set(__self__, "script_linked_service", script_linked_service)
        if script_path is not None:
            pulumi.set(__self__, "script_path", script_path)
        if storage_linked_services is not None:
            pulumi.set(__self__, "storage_linked_services", storage_linked_services)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'HDInsightPig'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def arguments(self) -> Optional[Sequence[Any]]:
        """
        User specified arguments to HDInsightActivity.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter
    def defines(self) -> Optional[Mapping[str, Any]]:
        """
        Allows user to specify defines for Pig job request.
        """
        return pulumi.get(self, "defines")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="getDebugInfo")
    def get_debug_info(self) -> Optional[str]:
        """
        Debug info option.
        """
        return pulumi.get(self, "get_debug_info")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def policy(self) -> Optional['outputs.ActivityPolicyResponse']:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="scriptLinkedService")
    def script_linked_service(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Script linked service reference.
        """
        return pulumi.get(self, "script_linked_service")

    @property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Optional[Any]:
        """
        Script path. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "script_path")

    @property
    @pulumi.getter(name="storageLinkedServices")
    def storage_linked_services(self) -> Optional[Sequence['outputs.LinkedServiceReferenceResponse']]:
        """
        Storage linked service references.
        """
        return pulumi.get(self, "storage_linked_services")


@pulumi.output_type
class HDInsightSparkActivityResponse(dict):
    """
    HDInsight Spark activity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entryFilePath":
            suggest = "entry_file_path"
        elif key == "rootPath":
            suggest = "root_path"
        elif key == "className":
            suggest = "class_name"
        elif key == "dependsOn":
            suggest = "depends_on"
        elif key == "getDebugInfo":
            suggest = "get_debug_info"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "proxyUser":
            suggest = "proxy_user"
        elif key == "sparkConfig":
            suggest = "spark_config"
        elif key == "sparkJobLinkedService":
            suggest = "spark_job_linked_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HDInsightSparkActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HDInsightSparkActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HDInsightSparkActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entry_file_path: Any,
                 name: str,
                 root_path: Any,
                 type: str,
                 arguments: Optional[Sequence[Any]] = None,
                 class_name: Optional[str] = None,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None,
                 get_debug_info: Optional[str] = None,
                 linked_service_name: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 policy: Optional['outputs.ActivityPolicyResponse'] = None,
                 proxy_user: Optional[Any] = None,
                 spark_config: Optional[Mapping[str, Any]] = None,
                 spark_job_linked_service: Optional['outputs.LinkedServiceReferenceResponse'] = None):
        """
        HDInsight Spark activity.
        :param Any entry_file_path: The relative path to the root folder of the code/package to be executed. Type: string (or Expression with resultType string).
        :param str name: Activity name.
        :param Any root_path: The root path in 'sparkJobLinkedService' for all the job’s files. Type: string (or Expression with resultType string).
        :param str type: Type of activity.
               Expected value is 'HDInsightSpark'.
        :param Sequence[Any] arguments: The user-specified arguments to HDInsightSparkActivity.
        :param str class_name: The application's Java/Spark main class.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        :param str get_debug_info: Debug info option.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param 'ActivityPolicyResponse' policy: Activity policy.
        :param Any proxy_user: The user to impersonate that will execute the job. Type: string (or Expression with resultType string).
        :param Mapping[str, Any] spark_config: Spark configuration property.
        :param 'LinkedServiceReferenceResponse' spark_job_linked_service: The storage linked service for uploading the entry file and dependencies, and for receiving logs.
        """
        pulumi.set(__self__, "entry_file_path", entry_file_path)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "root_path", root_path)
        pulumi.set(__self__, "type", 'HDInsightSpark')
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if class_name is not None:
            pulumi.set(__self__, "class_name", class_name)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if get_debug_info is not None:
            pulumi.set(__self__, "get_debug_info", get_debug_info)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if proxy_user is not None:
            pulumi.set(__self__, "proxy_user", proxy_user)
        if spark_config is not None:
            pulumi.set(__self__, "spark_config", spark_config)
        if spark_job_linked_service is not None:
            pulumi.set(__self__, "spark_job_linked_service", spark_job_linked_service)

    @property
    @pulumi.getter(name="entryFilePath")
    def entry_file_path(self) -> Any:
        """
        The relative path to the root folder of the code/package to be executed. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "entry_file_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="rootPath")
    def root_path(self) -> Any:
        """
        The root path in 'sparkJobLinkedService' for all the job’s files. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "root_path")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'HDInsightSpark'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def arguments(self) -> Optional[Sequence[Any]]:
        """
        The user-specified arguments to HDInsightSparkActivity.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="className")
    def class_name(self) -> Optional[str]:
        """
        The application's Java/Spark main class.
        """
        return pulumi.get(self, "class_name")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="getDebugInfo")
    def get_debug_info(self) -> Optional[str]:
        """
        Debug info option.
        """
        return pulumi.get(self, "get_debug_info")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def policy(self) -> Optional['outputs.ActivityPolicyResponse']:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="proxyUser")
    def proxy_user(self) -> Optional[Any]:
        """
        The user to impersonate that will execute the job. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "proxy_user")

    @property
    @pulumi.getter(name="sparkConfig")
    def spark_config(self) -> Optional[Mapping[str, Any]]:
        """
        Spark configuration property.
        """
        return pulumi.get(self, "spark_config")

    @property
    @pulumi.getter(name="sparkJobLinkedService")
    def spark_job_linked_service(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        The storage linked service for uploading the entry file and dependencies, and for receiving logs.
        """
        return pulumi.get(self, "spark_job_linked_service")


@pulumi.output_type
class HDInsightStreamingActivityResponse(dict):
    """
    HDInsight streaming activity type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePaths":
            suggest = "file_paths"
        elif key == "commandEnvironment":
            suggest = "command_environment"
        elif key == "dependsOn":
            suggest = "depends_on"
        elif key == "fileLinkedService":
            suggest = "file_linked_service"
        elif key == "getDebugInfo":
            suggest = "get_debug_info"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "storageLinkedServices":
            suggest = "storage_linked_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HDInsightStreamingActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HDInsightStreamingActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HDInsightStreamingActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_paths: Sequence[Any],
                 input: Any,
                 mapper: Any,
                 name: str,
                 output: Any,
                 reducer: Any,
                 type: str,
                 arguments: Optional[Sequence[Any]] = None,
                 combiner: Optional[Any] = None,
                 command_environment: Optional[Sequence[Any]] = None,
                 defines: Optional[Mapping[str, Any]] = None,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None,
                 file_linked_service: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 get_debug_info: Optional[str] = None,
                 linked_service_name: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 policy: Optional['outputs.ActivityPolicyResponse'] = None,
                 storage_linked_services: Optional[Sequence['outputs.LinkedServiceReferenceResponse']] = None):
        """
        HDInsight streaming activity type.
        :param Sequence[Any] file_paths: Paths to streaming job files. Can be directories.
        :param Any input: Input blob path. Type: string (or Expression with resultType string).
        :param Any mapper: Mapper executable name. Type: string (or Expression with resultType string).
        :param str name: Activity name.
        :param Any output: Output blob path. Type: string (or Expression with resultType string).
        :param Any reducer: Reducer executable name. Type: string (or Expression with resultType string).
        :param str type: Type of activity.
               Expected value is 'HDInsightStreaming'.
        :param Sequence[Any] arguments: User specified arguments to HDInsightActivity.
        :param Any combiner: Combiner executable name. Type: string (or Expression with resultType string).
        :param Sequence[Any] command_environment: Command line environment values.
        :param Mapping[str, Any] defines: Allows user to specify defines for streaming job request.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        :param 'LinkedServiceReferenceResponse' file_linked_service: Linked service reference where the files are located.
        :param str get_debug_info: Debug info option.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param 'ActivityPolicyResponse' policy: Activity policy.
        :param Sequence['LinkedServiceReferenceResponse'] storage_linked_services: Storage linked service references.
        """
        pulumi.set(__self__, "file_paths", file_paths)
        pulumi.set(__self__, "input", input)
        pulumi.set(__self__, "mapper", mapper)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "reducer", reducer)
        pulumi.set(__self__, "type", 'HDInsightStreaming')
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if combiner is not None:
            pulumi.set(__self__, "combiner", combiner)
        if command_environment is not None:
            pulumi.set(__self__, "command_environment", command_environment)
        if defines is not None:
            pulumi.set(__self__, "defines", defines)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_linked_service is not None:
            pulumi.set(__self__, "file_linked_service", file_linked_service)
        if get_debug_info is not None:
            pulumi.set(__self__, "get_debug_info", get_debug_info)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if storage_linked_services is not None:
            pulumi.set(__self__, "storage_linked_services", storage_linked_services)

    @property
    @pulumi.getter(name="filePaths")
    def file_paths(self) -> Sequence[Any]:
        """
        Paths to streaming job files. Can be directories.
        """
        return pulumi.get(self, "file_paths")

    @property
    @pulumi.getter
    def input(self) -> Any:
        """
        Input blob path. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "input")

    @property
    @pulumi.getter
    def mapper(self) -> Any:
        """
        Mapper executable name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "mapper")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def output(self) -> Any:
        """
        Output blob path. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def reducer(self) -> Any:
        """
        Reducer executable name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "reducer")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'HDInsightStreaming'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def arguments(self) -> Optional[Sequence[Any]]:
        """
        User specified arguments to HDInsightActivity.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter
    def combiner(self) -> Optional[Any]:
        """
        Combiner executable name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "combiner")

    @property
    @pulumi.getter(name="commandEnvironment")
    def command_environment(self) -> Optional[Sequence[Any]]:
        """
        Command line environment values.
        """
        return pulumi.get(self, "command_environment")

    @property
    @pulumi.getter
    def defines(self) -> Optional[Mapping[str, Any]]:
        """
        Allows user to specify defines for streaming job request.
        """
        return pulumi.get(self, "defines")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fileLinkedService")
    def file_linked_service(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Linked service reference where the files are located.
        """
        return pulumi.get(self, "file_linked_service")

    @property
    @pulumi.getter(name="getDebugInfo")
    def get_debug_info(self) -> Optional[str]:
        """
        Debug info option.
        """
        return pulumi.get(self, "get_debug_info")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def policy(self) -> Optional['outputs.ActivityPolicyResponse']:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="storageLinkedServices")
    def storage_linked_services(self) -> Optional[Sequence['outputs.LinkedServiceReferenceResponse']]:
        """
        Storage linked service references.
        """
        return pulumi.get(self, "storage_linked_services")


@pulumi.output_type
class HdfsLinkedServiceResponse(dict):
    """
    Hadoop Distributed File System (HDFS) linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HdfsLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HdfsLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HdfsLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 url: Any,
                 annotations: Optional[Sequence[Any]] = None,
                 authentication_type: Optional[Any] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 user_name: Optional[Any] = None):
        """
        Hadoop Distributed File System (HDFS) linked service.
        :param str type: Type of linked service.
               Expected value is 'Hdfs'.
        :param Any url: The URL of the HDFS service endpoint, e.g. http://myhostname:50070/webhdfs/v1 . Type: string (or Expression with resultType string).
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param Any authentication_type: Type of authentication used to connect to the HDFS. Possible values are: Anonymous and Windows. Type: string (or Expression with resultType string).
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: Password for Windows authentication.
        :param Any user_name: User name for Windows authentication. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "type", 'Hdfs')
        pulumi.set(__self__, "url", url)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Hdfs'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> Any:
        """
        The URL of the HDFS service endpoint, e.g. http://myhostname:50070/webhdfs/v1 . Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[Any]:
        """
        Type of authentication used to connect to the HDFS. Possible values are: Anonymous and Windows. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        Password for Windows authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[Any]:
        """
        User name for Windows authentication. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class HdfsSourceResponse(dict):
    """
    A copy activity HDFS source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distcpSettings":
            suggest = "distcp_settings"
        elif key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HdfsSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HdfsSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HdfsSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 distcp_settings: Optional['outputs.DistcpSettingsResponse'] = None,
                 recursive: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity HDFS source.
        :param str type: Copy source type.
               Expected value is 'HdfsSource'.
        :param 'DistcpSettingsResponse' distcp_settings: Specifies Distcp-related settings.
        :param Any recursive: If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'HdfsSource')
        if distcp_settings is not None:
            pulumi.set(__self__, "distcp_settings", distcp_settings)
        if recursive is not None:
            pulumi.set(__self__, "recursive", recursive)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'HdfsSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="distcpSettings")
    def distcp_settings(self) -> Optional['outputs.DistcpSettingsResponse']:
        """
        Specifies Distcp-related settings.
        """
        return pulumi.get(self, "distcp_settings")

    @property
    @pulumi.getter
    def recursive(self) -> Optional[Any]:
        """
        If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "recursive")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class HiveLinkedServiceResponse(dict):
    """
    Hive Server linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "allowHostNameCNMismatch":
            suggest = "allow_host_name_cn_mismatch"
        elif key == "allowSelfSignedServerCert":
            suggest = "allow_self_signed_server_cert"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "enableSsl":
            suggest = "enable_ssl"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "httpPath":
            suggest = "http_path"
        elif key == "serverType":
            suggest = "server_type"
        elif key == "serviceDiscoveryMode":
            suggest = "service_discovery_mode"
        elif key == "thriftTransportProtocol":
            suggest = "thrift_transport_protocol"
        elif key == "trustedCertPath":
            suggest = "trusted_cert_path"
        elif key == "useNativeQuery":
            suggest = "use_native_query"
        elif key == "useSystemTrustStore":
            suggest = "use_system_trust_store"
        elif key == "zooKeeperNameSpace":
            suggest = "zoo_keeper_name_space"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HiveLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HiveLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HiveLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_type: str,
                 host: Any,
                 type: str,
                 allow_host_name_cn_mismatch: Optional[Any] = None,
                 allow_self_signed_server_cert: Optional[Any] = None,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 enable_ssl: Optional[Any] = None,
                 encrypted_credential: Optional[Any] = None,
                 http_path: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 port: Optional[Any] = None,
                 server_type: Optional[str] = None,
                 service_discovery_mode: Optional[Any] = None,
                 thrift_transport_protocol: Optional[str] = None,
                 trusted_cert_path: Optional[Any] = None,
                 use_native_query: Optional[Any] = None,
                 use_system_trust_store: Optional[Any] = None,
                 username: Optional[Any] = None,
                 zoo_keeper_name_space: Optional[Any] = None):
        """
        Hive Server linked service.
        :param str authentication_type: The authentication method used to access the Hive server.
        :param Any host: IP address or host name of the Hive server, separated by ';' for multiple hosts (only when serviceDiscoveryMode is enable).
        :param str type: Type of linked service.
               Expected value is 'Hive'.
        :param Any allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        :param Any allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from the server. The default value is false.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Any http_path: The partial URL corresponding to the Hive server.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: The password corresponding to the user name that you provided in the Username field
        :param Any port: The TCP port that the Hive server uses to listen for client connections.
        :param str server_type: The type of Hive server.
        :param Any service_discovery_mode: true to indicate using the ZooKeeper service, false not.
        :param str thrift_transport_protocol: The transport protocol to use in the Thrift layer.
        :param Any trusted_cert_path: The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        :param Any use_native_query: Specifies whether the driver uses native HiveQL queries,or converts them into an equivalent form in HiveQL.
        :param Any use_system_trust_store: Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        :param Any username: The user name that you use to access Hive Server.
        :param Any zoo_keeper_name_space: The namespace on ZooKeeper under which Hive Server 2 nodes are added.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'Hive')
        if allow_host_name_cn_mismatch is not None:
            pulumi.set(__self__, "allow_host_name_cn_mismatch", allow_host_name_cn_mismatch)
        if allow_self_signed_server_cert is not None:
            pulumi.set(__self__, "allow_self_signed_server_cert", allow_self_signed_server_cert)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if http_path is not None:
            pulumi.set(__self__, "http_path", http_path)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if server_type is not None:
            pulumi.set(__self__, "server_type", server_type)
        if service_discovery_mode is not None:
            pulumi.set(__self__, "service_discovery_mode", service_discovery_mode)
        if thrift_transport_protocol is not None:
            pulumi.set(__self__, "thrift_transport_protocol", thrift_transport_protocol)
        if trusted_cert_path is not None:
            pulumi.set(__self__, "trusted_cert_path", trusted_cert_path)
        if use_native_query is not None:
            pulumi.set(__self__, "use_native_query", use_native_query)
        if use_system_trust_store is not None:
            pulumi.set(__self__, "use_system_trust_store", use_system_trust_store)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if zoo_keeper_name_space is not None:
            pulumi.set(__self__, "zoo_keeper_name_space", zoo_keeper_name_space)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> str:
        """
        The authentication method used to access the Hive server.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        IP address or host name of the Hive server, separated by ';' for multiple hosts (only when serviceDiscoveryMode is enable).
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Hive'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="allowHostNameCNMismatch")
    def allow_host_name_cn_mismatch(self) -> Optional[Any]:
        """
        Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        """
        return pulumi.get(self, "allow_host_name_cn_mismatch")

    @property
    @pulumi.getter(name="allowSelfSignedServerCert")
    def allow_self_signed_server_cert(self) -> Optional[Any]:
        """
        Specifies whether to allow self-signed certificates from the server. The default value is false.
        """
        return pulumi.get(self, "allow_self_signed_server_cert")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[Any]:
        """
        Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        """
        return pulumi.get(self, "enable_ssl")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter(name="httpPath")
    def http_path(self) -> Optional[Any]:
        """
        The partial URL corresponding to the Hive server.
        """
        return pulumi.get(self, "http_path")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        The password corresponding to the user name that you provided in the Username field
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The TCP port that the Hive server uses to listen for client connections.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> Optional[str]:
        """
        The type of Hive server.
        """
        return pulumi.get(self, "server_type")

    @property
    @pulumi.getter(name="serviceDiscoveryMode")
    def service_discovery_mode(self) -> Optional[Any]:
        """
        true to indicate using the ZooKeeper service, false not.
        """
        return pulumi.get(self, "service_discovery_mode")

    @property
    @pulumi.getter(name="thriftTransportProtocol")
    def thrift_transport_protocol(self) -> Optional[str]:
        """
        The transport protocol to use in the Thrift layer.
        """
        return pulumi.get(self, "thrift_transport_protocol")

    @property
    @pulumi.getter(name="trustedCertPath")
    def trusted_cert_path(self) -> Optional[Any]:
        """
        The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        """
        return pulumi.get(self, "trusted_cert_path")

    @property
    @pulumi.getter(name="useNativeQuery")
    def use_native_query(self) -> Optional[Any]:
        """
        Specifies whether the driver uses native HiveQL queries,or converts them into an equivalent form in HiveQL.
        """
        return pulumi.get(self, "use_native_query")

    @property
    @pulumi.getter(name="useSystemTrustStore")
    def use_system_trust_store(self) -> Optional[Any]:
        """
        Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        """
        return pulumi.get(self, "use_system_trust_store")

    @property
    @pulumi.getter
    def username(self) -> Optional[Any]:
        """
        The user name that you use to access Hive Server.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="zooKeeperNameSpace")
    def zoo_keeper_name_space(self) -> Optional[Any]:
        """
        The namespace on ZooKeeper under which Hive Server 2 nodes are added.
        """
        return pulumi.get(self, "zoo_keeper_name_space")


@pulumi.output_type
class HiveObjectDatasetResponse(dict):
    """
    Hive Server dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HiveObjectDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HiveObjectDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HiveObjectDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Hive Server dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'HiveObject'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'HiveObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'HiveObject'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class HiveSourceResponse(dict):
    """
    A copy activity Hive Server source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HiveSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HiveSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HiveSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Hive Server source.
        :param str type: Copy source type.
               Expected value is 'HiveSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'HiveSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'HiveSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class HttpDatasetResponse(dict):
    """
    A file in an HTTP web server.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "additionalHeaders":
            suggest = "additional_headers"
        elif key == "relativeUrl":
            suggest = "relative_url"
        elif key == "requestBody":
            suggest = "request_body"
        elif key == "requestMethod":
            suggest = "request_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 additional_headers: Optional[Any] = None,
                 annotations: Optional[Sequence[Any]] = None,
                 compression: Optional[Any] = None,
                 description: Optional[str] = None,
                 format: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 relative_url: Optional[Any] = None,
                 request_body: Optional[Any] = None,
                 request_method: Optional[Any] = None,
                 structure: Optional[Any] = None):
        """
        A file in an HTTP web server.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'HttpFile'.
        :param Any additional_headers: The headers for the HTTP Request. e.g. request-header-name-1:request-header-value-1
               ...
               request-header-name-n:request-header-value-n Type: string (or Expression with resultType string).
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param Union['DatasetBZip2CompressionResponse', 'DatasetDeflateCompressionResponse', 'DatasetGZipCompressionResponse', 'DatasetZipDeflateCompressionResponse'] compression: The data compression method used on files.
        :param str description: Dataset description.
        :param Union['AvroFormatResponse', 'JsonFormatResponse', 'OrcFormatResponse', 'ParquetFormatResponse', 'TextFormatResponse'] format: The format of files.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any relative_url: The relative URL based on the URL in the HttpLinkedService refers to an HTTP file Type: string (or Expression with resultType string).
        :param Any request_body: The body for the HTTP request. Type: string (or Expression with resultType string).
        :param Any request_method: The HTTP method for the HTTP request. Type: string (or Expression with resultType string).
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'HttpFile')
        if additional_headers is not None:
            pulumi.set(__self__, "additional_headers", additional_headers)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if relative_url is not None:
            pulumi.set(__self__, "relative_url", relative_url)
        if request_body is not None:
            pulumi.set(__self__, "request_body", request_body)
        if request_method is not None:
            pulumi.set(__self__, "request_method", request_method)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'HttpFile'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="additionalHeaders")
    def additional_headers(self) -> Optional[Any]:
        """
        The headers for the HTTP Request. e.g. request-header-name-1:request-header-value-1
        ...
        request-header-name-n:request-header-value-n Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "additional_headers")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def compression(self) -> Optional[Any]:
        """
        The data compression method used on files.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def format(self) -> Optional[Any]:
        """
        The format of files.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="relativeUrl")
    def relative_url(self) -> Optional[Any]:
        """
        The relative URL based on the URL in the HttpLinkedService refers to an HTTP file Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "relative_url")

    @property
    @pulumi.getter(name="requestBody")
    def request_body(self) -> Optional[Any]:
        """
        The body for the HTTP request. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "request_body")

    @property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> Optional[Any]:
        """
        The HTTP method for the HTTP request. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "request_method")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class HttpLinkedServiceResponse(dict):
    """
    Linked service for an HTTP source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "certThumbprint":
            suggest = "cert_thumbprint"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "embeddedCertData":
            suggest = "embedded_cert_data"
        elif key == "enableServerCertificateValidation":
            suggest = "enable_server_certificate_validation"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 url: Any,
                 annotations: Optional[Sequence[Any]] = None,
                 authentication_type: Optional[str] = None,
                 cert_thumbprint: Optional[Any] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 embedded_cert_data: Optional[Any] = None,
                 enable_server_certificate_validation: Optional[Any] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 user_name: Optional[Any] = None):
        """
        Linked service for an HTTP source.
        :param str type: Type of linked service.
               Expected value is 'HttpServer'.
        :param Any url: The base URL of the HTTP endpoint, e.g. https://www.microsoft.com. Type: string (or Expression with resultType string).
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str authentication_type: The authentication type to be used to connect to the HTTP server.
        :param Any cert_thumbprint: Thumbprint of certificate for ClientCertificate authentication. Only valid for on-premises copy. For on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any embedded_cert_data: Base64 encoded certificate data for ClientCertificate authentication. For on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
        :param Any enable_server_certificate_validation: If true, validate the HTTPS server SSL certificate. Default value is true. Type: boolean (or Expression with resultType boolean).
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: Password for Basic, Digest, Windows, or ClientCertificate with EmbeddedCertData authentication.
        :param Any user_name: User name for Basic, Digest, or Windows authentication. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "type", 'HttpServer')
        pulumi.set(__self__, "url", url)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if cert_thumbprint is not None:
            pulumi.set(__self__, "cert_thumbprint", cert_thumbprint)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if embedded_cert_data is not None:
            pulumi.set(__self__, "embedded_cert_data", embedded_cert_data)
        if enable_server_certificate_validation is not None:
            pulumi.set(__self__, "enable_server_certificate_validation", enable_server_certificate_validation)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'HttpServer'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> Any:
        """
        The base URL of the HTTP endpoint, e.g. https://www.microsoft.com. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[str]:
        """
        The authentication type to be used to connect to the HTTP server.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="certThumbprint")
    def cert_thumbprint(self) -> Optional[Any]:
        """
        Thumbprint of certificate for ClientCertificate authentication. Only valid for on-premises copy. For on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "cert_thumbprint")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="embeddedCertData")
    def embedded_cert_data(self) -> Optional[Any]:
        """
        Base64 encoded certificate data for ClientCertificate authentication. For on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "embedded_cert_data")

    @property
    @pulumi.getter(name="enableServerCertificateValidation")
    def enable_server_certificate_validation(self) -> Optional[Any]:
        """
        If true, validate the HTTPS server SSL certificate. Default value is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "enable_server_certificate_validation")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        Password for Basic, Digest, Windows, or ClientCertificate with EmbeddedCertData authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[Any]:
        """
        User name for Basic, Digest, or Windows authentication. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class HttpSourceResponse(dict):
    """
    A copy activity source for an HTTP file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpRequestTimeout":
            suggest = "http_request_timeout"
        elif key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 http_request_timeout: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity source for an HTTP file.
        :param str type: Copy source type.
               Expected value is 'HttpSource'.
        :param Any http_request_timeout: Specifies the timeout for a HTTP client to get HTTP response from HTTP server. The default value is equivalent to System.Net.HttpWebRequest.Timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'HttpSource')
        if http_request_timeout is not None:
            pulumi.set(__self__, "http_request_timeout", http_request_timeout)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'HttpSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="httpRequestTimeout")
    def http_request_timeout(self) -> Optional[Any]:
        """
        Specifies the timeout for a HTTP client to get HTTP response from HTTP server. The default value is equivalent to System.Net.HttpWebRequest.Timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "http_request_timeout")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class HubspotLinkedServiceResponse(dict):
    """
    Hubspot Service linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "accessToken":
            suggest = "access_token"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "refreshToken":
            suggest = "refresh_token"
        elif key == "useEncryptedEndpoints":
            suggest = "use_encrypted_endpoints"
        elif key == "useHostVerification":
            suggest = "use_host_verification"
        elif key == "usePeerVerification":
            suggest = "use_peer_verification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HubspotLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HubspotLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HubspotLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Any,
                 type: str,
                 access_token: Optional[Any] = None,
                 annotations: Optional[Sequence[Any]] = None,
                 client_secret: Optional[Any] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 refresh_token: Optional[Any] = None,
                 use_encrypted_endpoints: Optional[Any] = None,
                 use_host_verification: Optional[Any] = None,
                 use_peer_verification: Optional[Any] = None):
        """
        Hubspot Service linked service.
        :param Any client_id: The client ID associated with your Hubspot application.
        :param str type: Type of linked service.
               Expected value is 'Hubspot'.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] access_token: The access token obtained when initially authenticating your OAuth integration.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] client_secret: The client secret associated with your Hubspot application.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] refresh_token: The refresh token obtained when initially authenticating your OAuth integration.
        :param Any use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        :param Any use_host_verification: Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        :param Any use_peer_verification: Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "type", 'Hubspot')
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if use_encrypted_endpoints is not None:
            pulumi.set(__self__, "use_encrypted_endpoints", use_encrypted_endpoints)
        if use_host_verification is not None:
            pulumi.set(__self__, "use_host_verification", use_host_verification)
        if use_peer_verification is not None:
            pulumi.set(__self__, "use_peer_verification", use_peer_verification)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Any:
        """
        The client ID associated with your Hubspot application.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Hubspot'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[Any]:
        """
        The access token obtained when initially authenticating your OAuth integration.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[Any]:
        """
        The client secret associated with your Hubspot application.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[Any]:
        """
        The refresh token obtained when initially authenticating your OAuth integration.
        """
        return pulumi.get(self, "refresh_token")

    @property
    @pulumi.getter(name="useEncryptedEndpoints")
    def use_encrypted_endpoints(self) -> Optional[Any]:
        """
        Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        """
        return pulumi.get(self, "use_encrypted_endpoints")

    @property
    @pulumi.getter(name="useHostVerification")
    def use_host_verification(self) -> Optional[Any]:
        """
        Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_host_verification")

    @property
    @pulumi.getter(name="usePeerVerification")
    def use_peer_verification(self) -> Optional[Any]:
        """
        Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_peer_verification")


@pulumi.output_type
class HubspotObjectDatasetResponse(dict):
    """
    Hubspot Service dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HubspotObjectDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HubspotObjectDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HubspotObjectDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Hubspot Service dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'HubspotObject'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'HubspotObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'HubspotObject'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class HubspotSourceResponse(dict):
    """
    A copy activity Hubspot Service source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HubspotSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HubspotSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HubspotSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Hubspot Service source.
        :param str type: Copy source type.
               Expected value is 'HubspotSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'HubspotSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'HubspotSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class IfConditionActivityResponse(dict):
    """
    This activity evaluates a boolean expression and executes either the activities under the ifTrueActivities property or the ifFalseActivities property depending on the result of the expression.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOn":
            suggest = "depends_on"
        elif key == "ifFalseActivities":
            suggest = "if_false_activities"
        elif key == "ifTrueActivities":
            suggest = "if_true_activities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IfConditionActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IfConditionActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IfConditionActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expression: 'outputs.ExpressionResponse',
                 name: str,
                 type: str,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None,
                 if_false_activities: Optional[Sequence[Any]] = None,
                 if_true_activities: Optional[Sequence[Any]] = None):
        """
        This activity evaluates a boolean expression and executes either the activities under the ifTrueActivities property or the ifFalseActivities property depending on the result of the expression.
        :param 'ExpressionResponse' expression: An expression that would evaluate to Boolean. This is used to determine the block of activities (ifTrueActivities or ifFalseActivities) that will be executed.
        :param str name: Activity name.
        :param str type: Type of activity.
               Expected value is 'IfCondition'.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        :param Sequence[Union['AzureMLBatchExecutionActivityResponse', 'AzureMLUpdateResourceActivityResponse', 'ControlActivityResponse', 'CopyActivityResponse', 'CustomActivityResponse', 'DataLakeAnalyticsUSQLActivityResponse', 'DatabricksNotebookActivityResponse', 'ExecutePipelineActivityResponse', 'ExecuteSSISPackageActivityResponse', 'ExecutionActivityResponse', 'FilterActivityResponse', 'ForEachActivityResponse', 'GetMetadataActivityResponse', 'HDInsightHiveActivityResponse', 'HDInsightMapReduceActivityResponse', 'HDInsightPigActivityResponse', 'HDInsightSparkActivityResponse', 'HDInsightStreamingActivityResponse', 'IfConditionActivityResponse', 'LookupActivityResponse', 'SqlServerStoredProcedureActivityResponse', 'UntilActivityResponse', 'WaitActivityResponse', 'WebActivityResponse']] if_false_activities: List of activities to execute if expression is evaluated to false. This is an optional property and if not provided, the activity will exit without any action.
        :param Sequence[Union['AzureMLBatchExecutionActivityResponse', 'AzureMLUpdateResourceActivityResponse', 'ControlActivityResponse', 'CopyActivityResponse', 'CustomActivityResponse', 'DataLakeAnalyticsUSQLActivityResponse', 'DatabricksNotebookActivityResponse', 'ExecutePipelineActivityResponse', 'ExecuteSSISPackageActivityResponse', 'ExecutionActivityResponse', 'FilterActivityResponse', 'ForEachActivityResponse', 'GetMetadataActivityResponse', 'HDInsightHiveActivityResponse', 'HDInsightMapReduceActivityResponse', 'HDInsightPigActivityResponse', 'HDInsightSparkActivityResponse', 'HDInsightStreamingActivityResponse', 'IfConditionActivityResponse', 'LookupActivityResponse', 'SqlServerStoredProcedureActivityResponse', 'UntilActivityResponse', 'WaitActivityResponse', 'WebActivityResponse']] if_true_activities: List of activities to execute if expression is evaluated to true. This is an optional property and if not provided, the activity will exit without any action.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'IfCondition')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if if_false_activities is not None:
            pulumi.set(__self__, "if_false_activities", if_false_activities)
        if if_true_activities is not None:
            pulumi.set(__self__, "if_true_activities", if_true_activities)

    @property
    @pulumi.getter
    def expression(self) -> 'outputs.ExpressionResponse':
        """
        An expression that would evaluate to Boolean. This is used to determine the block of activities (ifTrueActivities or ifFalseActivities) that will be executed.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'IfCondition'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ifFalseActivities")
    def if_false_activities(self) -> Optional[Sequence[Any]]:
        """
        List of activities to execute if expression is evaluated to false. This is an optional property and if not provided, the activity will exit without any action.
        """
        return pulumi.get(self, "if_false_activities")

    @property
    @pulumi.getter(name="ifTrueActivities")
    def if_true_activities(self) -> Optional[Sequence[Any]]:
        """
        List of activities to execute if expression is evaluated to true. This is an optional property and if not provided, the activity will exit without any action.
        """
        return pulumi.get(self, "if_true_activities")


@pulumi.output_type
class ImpalaLinkedServiceResponse(dict):
    """
    Impala server linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "allowHostNameCNMismatch":
            suggest = "allow_host_name_cn_mismatch"
        elif key == "allowSelfSignedServerCert":
            suggest = "allow_self_signed_server_cert"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "enableSsl":
            suggest = "enable_ssl"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "trustedCertPath":
            suggest = "trusted_cert_path"
        elif key == "useSystemTrustStore":
            suggest = "use_system_trust_store"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImpalaLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImpalaLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImpalaLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_type: str,
                 host: Any,
                 type: str,
                 allow_host_name_cn_mismatch: Optional[Any] = None,
                 allow_self_signed_server_cert: Optional[Any] = None,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 enable_ssl: Optional[Any] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 port: Optional[Any] = None,
                 trusted_cert_path: Optional[Any] = None,
                 use_system_trust_store: Optional[Any] = None,
                 username: Optional[Any] = None):
        """
        Impala server linked service.
        :param str authentication_type: The authentication type to use.
        :param Any host: The IP address or host name of the Impala server. (i.e. 192.168.222.160)
        :param str type: Type of linked service.
               Expected value is 'Impala'.
        :param Any allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        :param Any allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from the server. The default value is false.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: The password corresponding to the user name when using UsernameAndPassword.
        :param Any port: The TCP port that the Impala server uses to listen for client connections. The default value is 21050.
        :param Any trusted_cert_path: The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        :param Any use_system_trust_store: Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        :param Any username: The user name used to access the Impala server. The default value is anonymous when using SASLUsername.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'Impala')
        if allow_host_name_cn_mismatch is not None:
            pulumi.set(__self__, "allow_host_name_cn_mismatch", allow_host_name_cn_mismatch)
        if allow_self_signed_server_cert is not None:
            pulumi.set(__self__, "allow_self_signed_server_cert", allow_self_signed_server_cert)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if trusted_cert_path is not None:
            pulumi.set(__self__, "trusted_cert_path", trusted_cert_path)
        if use_system_trust_store is not None:
            pulumi.set(__self__, "use_system_trust_store", use_system_trust_store)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> str:
        """
        The authentication type to use.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        The IP address or host name of the Impala server. (i.e. 192.168.222.160)
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Impala'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="allowHostNameCNMismatch")
    def allow_host_name_cn_mismatch(self) -> Optional[Any]:
        """
        Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        """
        return pulumi.get(self, "allow_host_name_cn_mismatch")

    @property
    @pulumi.getter(name="allowSelfSignedServerCert")
    def allow_self_signed_server_cert(self) -> Optional[Any]:
        """
        Specifies whether to allow self-signed certificates from the server. The default value is false.
        """
        return pulumi.get(self, "allow_self_signed_server_cert")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[Any]:
        """
        Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        """
        return pulumi.get(self, "enable_ssl")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        The password corresponding to the user name when using UsernameAndPassword.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The TCP port that the Impala server uses to listen for client connections. The default value is 21050.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="trustedCertPath")
    def trusted_cert_path(self) -> Optional[Any]:
        """
        The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        """
        return pulumi.get(self, "trusted_cert_path")

    @property
    @pulumi.getter(name="useSystemTrustStore")
    def use_system_trust_store(self) -> Optional[Any]:
        """
        Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        """
        return pulumi.get(self, "use_system_trust_store")

    @property
    @pulumi.getter
    def username(self) -> Optional[Any]:
        """
        The user name used to access the Impala server. The default value is anonymous when using SASLUsername.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ImpalaObjectDatasetResponse(dict):
    """
    Impala server dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImpalaObjectDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImpalaObjectDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImpalaObjectDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Impala server dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'ImpalaObject'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'ImpalaObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'ImpalaObject'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class ImpalaSourceResponse(dict):
    """
    A copy activity Impala server source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImpalaSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImpalaSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImpalaSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Impala server source.
        :param str type: Copy source type.
               Expected value is 'ImpalaSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'ImpalaSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'ImpalaSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class IntegrationRuntimeComputePropertiesResponse(dict):
    """
    The compute resource properties for managed integration runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxParallelExecutionsPerNode":
            suggest = "max_parallel_executions_per_node"
        elif key == "nodeSize":
            suggest = "node_size"
        elif key == "numberOfNodes":
            suggest = "number_of_nodes"
        elif key == "vNetProperties":
            suggest = "v_net_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationRuntimeComputePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationRuntimeComputePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationRuntimeComputePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: Optional[str] = None,
                 max_parallel_executions_per_node: Optional[int] = None,
                 node_size: Optional[str] = None,
                 number_of_nodes: Optional[int] = None,
                 v_net_properties: Optional['outputs.IntegrationRuntimeVNetPropertiesResponse'] = None):
        """
        The compute resource properties for managed integration runtime.
        :param str location: The location for managed integration runtime. The supported regions could be found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
        :param int max_parallel_executions_per_node: Maximum parallel executions count per node for managed integration runtime.
        :param str node_size: The node size requirement to managed integration runtime.
        :param int number_of_nodes: The required number of nodes for managed integration runtime.
        :param 'IntegrationRuntimeVNetPropertiesResponse' v_net_properties: VNet properties for managed integration runtime.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_parallel_executions_per_node is not None:
            pulumi.set(__self__, "max_parallel_executions_per_node", max_parallel_executions_per_node)
        if node_size is not None:
            pulumi.set(__self__, "node_size", node_size)
        if number_of_nodes is not None:
            pulumi.set(__self__, "number_of_nodes", number_of_nodes)
        if v_net_properties is not None:
            pulumi.set(__self__, "v_net_properties", v_net_properties)

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The location for managed integration runtime. The supported regions could be found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maxParallelExecutionsPerNode")
    def max_parallel_executions_per_node(self) -> Optional[int]:
        """
        Maximum parallel executions count per node for managed integration runtime.
        """
        return pulumi.get(self, "max_parallel_executions_per_node")

    @property
    @pulumi.getter(name="nodeSize")
    def node_size(self) -> Optional[str]:
        """
        The node size requirement to managed integration runtime.
        """
        return pulumi.get(self, "node_size")

    @property
    @pulumi.getter(name="numberOfNodes")
    def number_of_nodes(self) -> Optional[int]:
        """
        The required number of nodes for managed integration runtime.
        """
        return pulumi.get(self, "number_of_nodes")

    @property
    @pulumi.getter(name="vNetProperties")
    def v_net_properties(self) -> Optional['outputs.IntegrationRuntimeVNetPropertiesResponse']:
        """
        VNet properties for managed integration runtime.
        """
        return pulumi.get(self, "v_net_properties")


@pulumi.output_type
class IntegrationRuntimeCustomSetupScriptPropertiesResponse(dict):
    """
    Custom setup script properties for a managed dedicated integration runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blobContainerUri":
            suggest = "blob_container_uri"
        elif key == "sasToken":
            suggest = "sas_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationRuntimeCustomSetupScriptPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationRuntimeCustomSetupScriptPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationRuntimeCustomSetupScriptPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blob_container_uri: Optional[str] = None,
                 sas_token: Optional['outputs.SecureStringResponse'] = None):
        """
        Custom setup script properties for a managed dedicated integration runtime.
        :param str blob_container_uri: The URI of the Azure blob container that contains the custom setup script.
        :param 'SecureStringResponse' sas_token: The SAS token of the Azure blob container.
        """
        if blob_container_uri is not None:
            pulumi.set(__self__, "blob_container_uri", blob_container_uri)
        if sas_token is not None:
            pulumi.set(__self__, "sas_token", sas_token)

    @property
    @pulumi.getter(name="blobContainerUri")
    def blob_container_uri(self) -> Optional[str]:
        """
        The URI of the Azure blob container that contains the custom setup script.
        """
        return pulumi.get(self, "blob_container_uri")

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> Optional['outputs.SecureStringResponse']:
        """
        The SAS token of the Azure blob container.
        """
        return pulumi.get(self, "sas_token")


@pulumi.output_type
class IntegrationRuntimeDataProxyPropertiesResponse(dict):
    """
    Data proxy properties for a managed dedicated integration runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectVia":
            suggest = "connect_via"
        elif key == "stagingLinkedService":
            suggest = "staging_linked_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationRuntimeDataProxyPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationRuntimeDataProxyPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationRuntimeDataProxyPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_via: Optional['outputs.EntityReferenceResponse'] = None,
                 path: Optional[str] = None,
                 staging_linked_service: Optional['outputs.EntityReferenceResponse'] = None):
        """
        Data proxy properties for a managed dedicated integration runtime.
        :param 'EntityReferenceResponse' connect_via: The self-hosted integration runtime reference.
        :param str path: The path to contain the staged data in the Blob storage.
        :param 'EntityReferenceResponse' staging_linked_service: The staging linked service reference.
        """
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if staging_linked_service is not None:
            pulumi.set(__self__, "staging_linked_service", staging_linked_service)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.EntityReferenceResponse']:
        """
        The self-hosted integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to contain the staged data in the Blob storage.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="stagingLinkedService")
    def staging_linked_service(self) -> Optional['outputs.EntityReferenceResponse']:
        """
        The staging linked service reference.
        """
        return pulumi.get(self, "staging_linked_service")


@pulumi.output_type
class IntegrationRuntimeReferenceResponse(dict):
    """
    Integration runtime reference type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referenceName":
            suggest = "reference_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationRuntimeReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationRuntimeReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationRuntimeReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reference_name: str,
                 type: str,
                 parameters: Optional[Mapping[str, Any]] = None):
        """
        Integration runtime reference type.
        :param str reference_name: Reference integration runtime name.
        :param str type: Type of integration runtime.
        :param Mapping[str, Any] parameters: Arguments for integration runtime.
        """
        pulumi.set(__self__, "reference_name", reference_name)
        pulumi.set(__self__, "type", type)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="referenceName")
    def reference_name(self) -> str:
        """
        Reference integration runtime name.
        """
        return pulumi.get(self, "reference_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of integration runtime.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, Any]]:
        """
        Arguments for integration runtime.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class IntegrationRuntimeSsisCatalogInfoResponse(dict):
    """
    Catalog information for managed dedicated integration runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogAdminPassword":
            suggest = "catalog_admin_password"
        elif key == "catalogAdminUserName":
            suggest = "catalog_admin_user_name"
        elif key == "catalogPricingTier":
            suggest = "catalog_pricing_tier"
        elif key == "catalogServerEndpoint":
            suggest = "catalog_server_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationRuntimeSsisCatalogInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationRuntimeSsisCatalogInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationRuntimeSsisCatalogInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_admin_password: Optional['outputs.SecureStringResponse'] = None,
                 catalog_admin_user_name: Optional[str] = None,
                 catalog_pricing_tier: Optional[str] = None,
                 catalog_server_endpoint: Optional[str] = None):
        """
        Catalog information for managed dedicated integration runtime.
        :param 'SecureStringResponse' catalog_admin_password: The password of the administrator user account of the catalog database.
        :param str catalog_admin_user_name: The administrator user name of catalog database.
        :param str catalog_pricing_tier: The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
        :param str catalog_server_endpoint: The catalog database server URL.
        """
        if catalog_admin_password is not None:
            pulumi.set(__self__, "catalog_admin_password", catalog_admin_password)
        if catalog_admin_user_name is not None:
            pulumi.set(__self__, "catalog_admin_user_name", catalog_admin_user_name)
        if catalog_pricing_tier is not None:
            pulumi.set(__self__, "catalog_pricing_tier", catalog_pricing_tier)
        if catalog_server_endpoint is not None:
            pulumi.set(__self__, "catalog_server_endpoint", catalog_server_endpoint)

    @property
    @pulumi.getter(name="catalogAdminPassword")
    def catalog_admin_password(self) -> Optional['outputs.SecureStringResponse']:
        """
        The password of the administrator user account of the catalog database.
        """
        return pulumi.get(self, "catalog_admin_password")

    @property
    @pulumi.getter(name="catalogAdminUserName")
    def catalog_admin_user_name(self) -> Optional[str]:
        """
        The administrator user name of catalog database.
        """
        return pulumi.get(self, "catalog_admin_user_name")

    @property
    @pulumi.getter(name="catalogPricingTier")
    def catalog_pricing_tier(self) -> Optional[str]:
        """
        The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
        """
        return pulumi.get(self, "catalog_pricing_tier")

    @property
    @pulumi.getter(name="catalogServerEndpoint")
    def catalog_server_endpoint(self) -> Optional[str]:
        """
        The catalog database server URL.
        """
        return pulumi.get(self, "catalog_server_endpoint")


@pulumi.output_type
class IntegrationRuntimeSsisPropertiesResponse(dict):
    """
    SSIS properties for managed integration runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogInfo":
            suggest = "catalog_info"
        elif key == "customSetupScriptProperties":
            suggest = "custom_setup_script_properties"
        elif key == "dataProxyProperties":
            suggest = "data_proxy_properties"
        elif key == "licenseType":
            suggest = "license_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationRuntimeSsisPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationRuntimeSsisPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationRuntimeSsisPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_info: Optional['outputs.IntegrationRuntimeSsisCatalogInfoResponse'] = None,
                 custom_setup_script_properties: Optional['outputs.IntegrationRuntimeCustomSetupScriptPropertiesResponse'] = None,
                 data_proxy_properties: Optional['outputs.IntegrationRuntimeDataProxyPropertiesResponse'] = None,
                 edition: Optional[str] = None,
                 license_type: Optional[str] = None):
        """
        SSIS properties for managed integration runtime.
        :param 'IntegrationRuntimeSsisCatalogInfoResponse' catalog_info: Catalog information for managed dedicated integration runtime.
        :param 'IntegrationRuntimeCustomSetupScriptPropertiesResponse' custom_setup_script_properties: Custom setup script properties for a managed dedicated integration runtime.
        :param 'IntegrationRuntimeDataProxyPropertiesResponse' data_proxy_properties: Data proxy properties for a managed dedicated integration runtime.
        :param str edition: The edition for the SSIS Integration Runtime
        :param str license_type: License type for bringing your own license scenario.
        """
        if catalog_info is not None:
            pulumi.set(__self__, "catalog_info", catalog_info)
        if custom_setup_script_properties is not None:
            pulumi.set(__self__, "custom_setup_script_properties", custom_setup_script_properties)
        if data_proxy_properties is not None:
            pulumi.set(__self__, "data_proxy_properties", data_proxy_properties)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)

    @property
    @pulumi.getter(name="catalogInfo")
    def catalog_info(self) -> Optional['outputs.IntegrationRuntimeSsisCatalogInfoResponse']:
        """
        Catalog information for managed dedicated integration runtime.
        """
        return pulumi.get(self, "catalog_info")

    @property
    @pulumi.getter(name="customSetupScriptProperties")
    def custom_setup_script_properties(self) -> Optional['outputs.IntegrationRuntimeCustomSetupScriptPropertiesResponse']:
        """
        Custom setup script properties for a managed dedicated integration runtime.
        """
        return pulumi.get(self, "custom_setup_script_properties")

    @property
    @pulumi.getter(name="dataProxyProperties")
    def data_proxy_properties(self) -> Optional['outputs.IntegrationRuntimeDataProxyPropertiesResponse']:
        """
        Data proxy properties for a managed dedicated integration runtime.
        """
        return pulumi.get(self, "data_proxy_properties")

    @property
    @pulumi.getter
    def edition(self) -> Optional[str]:
        """
        The edition for the SSIS Integration Runtime
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[str]:
        """
        License type for bringing your own license scenario.
        """
        return pulumi.get(self, "license_type")


@pulumi.output_type
class IntegrationRuntimeVNetPropertiesResponse(dict):
    """
    VNet properties for managed integration runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vNetId":
            suggest = "v_net_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationRuntimeVNetPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationRuntimeVNetPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationRuntimeVNetPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet: Optional[str] = None,
                 v_net_id: Optional[str] = None):
        """
        VNet properties for managed integration runtime.
        :param str subnet: The name of the subnet this integration runtime will join.
        :param str v_net_id: The ID of the VNet that this integration runtime will join.
        """
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if v_net_id is not None:
            pulumi.set(__self__, "v_net_id", v_net_id)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[str]:
        """
        The name of the subnet this integration runtime will join.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="vNetId")
    def v_net_id(self) -> Optional[str]:
        """
        The ID of the VNet that this integration runtime will join.
        """
        return pulumi.get(self, "v_net_id")


@pulumi.output_type
class JiraLinkedServiceResponse(dict):
    """
    Jira Service linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "useEncryptedEndpoints":
            suggest = "use_encrypted_endpoints"
        elif key == "useHostVerification":
            suggest = "use_host_verification"
        elif key == "usePeerVerification":
            suggest = "use_peer_verification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JiraLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JiraLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JiraLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: Any,
                 type: str,
                 username: Any,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 port: Optional[Any] = None,
                 use_encrypted_endpoints: Optional[Any] = None,
                 use_host_verification: Optional[Any] = None,
                 use_peer_verification: Optional[Any] = None):
        """
        Jira Service linked service.
        :param Any host: The IP address or host name of the Jira service. (e.g. jira.example.com)
        :param str type: Type of linked service.
               Expected value is 'Jira'.
        :param Any username: The user name that you use to access Jira Service.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: The password corresponding to the user name that you provided in the username field.
        :param Any port: The TCP port that the Jira server uses to listen for client connections. The default value is 443 if connecting through HTTPS, or 8080 if connecting through HTTP.
        :param Any use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        :param Any use_host_verification: Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        :param Any use_peer_verification: Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'Jira')
        pulumi.set(__self__, "username", username)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if use_encrypted_endpoints is not None:
            pulumi.set(__self__, "use_encrypted_endpoints", use_encrypted_endpoints)
        if use_host_verification is not None:
            pulumi.set(__self__, "use_host_verification", use_host_verification)
        if use_peer_verification is not None:
            pulumi.set(__self__, "use_peer_verification", use_peer_verification)

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        The IP address or host name of the Jira service. (e.g. jira.example.com)
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Jira'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def username(self) -> Any:
        """
        The user name that you use to access Jira Service.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        The password corresponding to the user name that you provided in the username field.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The TCP port that the Jira server uses to listen for client connections. The default value is 443 if connecting through HTTPS, or 8080 if connecting through HTTP.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="useEncryptedEndpoints")
    def use_encrypted_endpoints(self) -> Optional[Any]:
        """
        Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        """
        return pulumi.get(self, "use_encrypted_endpoints")

    @property
    @pulumi.getter(name="useHostVerification")
    def use_host_verification(self) -> Optional[Any]:
        """
        Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_host_verification")

    @property
    @pulumi.getter(name="usePeerVerification")
    def use_peer_verification(self) -> Optional[Any]:
        """
        Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_peer_verification")


@pulumi.output_type
class JiraObjectDatasetResponse(dict):
    """
    Jira Service dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JiraObjectDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JiraObjectDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JiraObjectDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Jira Service dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'JiraObject'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'JiraObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'JiraObject'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class JiraSourceResponse(dict):
    """
    A copy activity Jira Service source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JiraSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JiraSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JiraSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Jira Service source.
        :param str type: Copy source type.
               Expected value is 'JiraSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'JiraSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'JiraSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class JsonFormatResponse(dict):
    """
    The data stored in JSON format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encodingName":
            suggest = "encoding_name"
        elif key == "filePattern":
            suggest = "file_pattern"
        elif key == "jsonNodeReference":
            suggest = "json_node_reference"
        elif key == "jsonPathDefinition":
            suggest = "json_path_definition"
        elif key == "nestingSeparator":
            suggest = "nesting_separator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JsonFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JsonFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JsonFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 deserializer: Optional[Any] = None,
                 encoding_name: Optional[Any] = None,
                 file_pattern: Optional[str] = None,
                 json_node_reference: Optional[Any] = None,
                 json_path_definition: Optional[Any] = None,
                 nesting_separator: Optional[Any] = None,
                 serializer: Optional[Any] = None):
        """
        The data stored in JSON format.
        :param str type: Type of dataset storage format.
               Expected value is 'JsonFormat'.
        :param Any deserializer: Deserializer. Type: string (or Expression with resultType string).
        :param Any encoding_name: The code page name of the preferred encoding. If not provided, the default value is 'utf-8', unless the byte order mark (BOM) denotes another Unicode encoding. The full list of supported values can be found in the 'Name' column of the table of encodings in the following reference: https://go.microsoft.com/fwlink/?linkid=861078. Type: string (or Expression with resultType string).
        :param str file_pattern: File pattern of JSON. To be more specific, the way of separating a collection of JSON objects. The default value is 'setOfObjects'. It is case-sensitive.
        :param Any json_node_reference: The JSONPath of the JSON array element to be flattened. Example: "$.ArrayPath". Type: string (or Expression with resultType string).
        :param Any json_path_definition: The JSONPath definition for each column mapping with a customized column name to extract data from JSON file. For fields under root object, start with "$"; for fields inside the array chosen by jsonNodeReference property, start from the array element. Example: {"Column1": "$.Column1Path", "Column2": "Column2PathInArray"}. Type: object (or Expression with resultType object).
        :param Any nesting_separator: The character used to separate nesting levels. Default value is '.' (dot). Type: string (or Expression with resultType string).
        :param Any serializer: Serializer. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "type", 'JsonFormat')
        if deserializer is not None:
            pulumi.set(__self__, "deserializer", deserializer)
        if encoding_name is not None:
            pulumi.set(__self__, "encoding_name", encoding_name)
        if file_pattern is not None:
            pulumi.set(__self__, "file_pattern", file_pattern)
        if json_node_reference is not None:
            pulumi.set(__self__, "json_node_reference", json_node_reference)
        if json_path_definition is not None:
            pulumi.set(__self__, "json_path_definition", json_path_definition)
        if nesting_separator is not None:
            pulumi.set(__self__, "nesting_separator", nesting_separator)
        if serializer is not None:
            pulumi.set(__self__, "serializer", serializer)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset storage format.
        Expected value is 'JsonFormat'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def deserializer(self) -> Optional[Any]:
        """
        Deserializer. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "deserializer")

    @property
    @pulumi.getter(name="encodingName")
    def encoding_name(self) -> Optional[Any]:
        """
        The code page name of the preferred encoding. If not provided, the default value is 'utf-8', unless the byte order mark (BOM) denotes another Unicode encoding. The full list of supported values can be found in the 'Name' column of the table of encodings in the following reference: https://go.microsoft.com/fwlink/?linkid=861078. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encoding_name")

    @property
    @pulumi.getter(name="filePattern")
    def file_pattern(self) -> Optional[str]:
        """
        File pattern of JSON. To be more specific, the way of separating a collection of JSON objects. The default value is 'setOfObjects'. It is case-sensitive.
        """
        return pulumi.get(self, "file_pattern")

    @property
    @pulumi.getter(name="jsonNodeReference")
    def json_node_reference(self) -> Optional[Any]:
        """
        The JSONPath of the JSON array element to be flattened. Example: "$.ArrayPath". Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "json_node_reference")

    @property
    @pulumi.getter(name="jsonPathDefinition")
    def json_path_definition(self) -> Optional[Any]:
        """
        The JSONPath definition for each column mapping with a customized column name to extract data from JSON file. For fields under root object, start with "$"; for fields inside the array chosen by jsonNodeReference property, start from the array element. Example: {"Column1": "$.Column1Path", "Column2": "Column2PathInArray"}. Type: object (or Expression with resultType object).
        """
        return pulumi.get(self, "json_path_definition")

    @property
    @pulumi.getter(name="nestingSeparator")
    def nesting_separator(self) -> Optional[Any]:
        """
        The character used to separate nesting levels. Default value is '.' (dot). Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "nesting_separator")

    @property
    @pulumi.getter
    def serializer(self) -> Optional[Any]:
        """
        Serializer. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "serializer")


@pulumi.output_type
class LinkedIntegrationRuntimeKeyResponse(dict):
    """
    The base definition of a secret type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationType":
            suggest = "authorization_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinkedIntegrationRuntimeKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinkedIntegrationRuntimeKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinkedIntegrationRuntimeKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_type: str,
                 key: 'outputs.SecureStringResponse'):
        """
        The base definition of a secret type.
        :param str authorization_type: Type of the secret.
               Expected value is 'Key'.
        :param 'SecureStringResponse' key: Type of the secret.
        """
        pulumi.set(__self__, "authorization_type", 'Key')
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> str:
        """
        Type of the secret.
        Expected value is 'Key'.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter
    def key(self) -> 'outputs.SecureStringResponse':
        """
        Type of the secret.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class LinkedIntegrationRuntimeRbacResponse(dict):
    """
    The base definition of a secret type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationType":
            suggest = "authorization_type"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinkedIntegrationRuntimeRbacResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinkedIntegrationRuntimeRbacResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinkedIntegrationRuntimeRbacResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_type: str,
                 resource_id: str):
        """
        The base definition of a secret type.
        :param str authorization_type: Type of the secret.
               Expected value is 'RBAC'.
        :param str resource_id: The resource ID of the integration runtime to be shared.
        """
        pulumi.set(__self__, "authorization_type", 'RBAC')
        pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> str:
        """
        Type of the secret.
        Expected value is 'RBAC'.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The resource ID of the integration runtime to be shared.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class LinkedIntegrationRuntimeResponse(dict):
    """
    The linked integration runtime information.
    """
    def __init__(__self__, *,
                 create_time: str,
                 data_factory_location: str,
                 data_factory_name: str,
                 name: str,
                 subscription_id: str):
        """
        The linked integration runtime information.
        :param str create_time: The creating time of the linked integration runtime.
        :param str data_factory_location: The location of the data factory for which the linked integration runtime belong to.
        :param str data_factory_name: The name of the data factory for which the linked integration runtime belong to.
        :param str name: The name of the linked integration runtime.
        :param str subscription_id: The subscription ID for which the linked integration runtime belong to.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "data_factory_location", data_factory_location)
        pulumi.set(__self__, "data_factory_name", data_factory_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creating time of the linked integration runtime.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataFactoryLocation")
    def data_factory_location(self) -> str:
        """
        The location of the data factory for which the linked integration runtime belong to.
        """
        return pulumi.get(self, "data_factory_location")

    @property
    @pulumi.getter(name="dataFactoryName")
    def data_factory_name(self) -> str:
        """
        The name of the data factory for which the linked integration runtime belong to.
        """
        return pulumi.get(self, "data_factory_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the linked integration runtime.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        """
        The subscription ID for which the linked integration runtime belong to.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class LinkedServiceReferenceResponse(dict):
    """
    Linked service reference type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referenceName":
            suggest = "reference_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinkedServiceReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinkedServiceReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinkedServiceReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reference_name: str,
                 type: str,
                 parameters: Optional[Mapping[str, Any]] = None):
        """
        Linked service reference type.
        :param str reference_name: Reference LinkedService name.
        :param str type: Linked service reference type.
        :param Mapping[str, Any] parameters: Arguments for LinkedService.
        """
        pulumi.set(__self__, "reference_name", reference_name)
        pulumi.set(__self__, "type", type)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="referenceName")
    def reference_name(self) -> str:
        """
        Reference LinkedService name.
        """
        return pulumi.get(self, "reference_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Linked service reference type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, Any]]:
        """
        Arguments for LinkedService.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class LookupActivityResponse(dict):
    """
    Lookup activity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOn":
            suggest = "depends_on"
        elif key == "firstRowOnly":
            suggest = "first_row_only"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LookupActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LookupActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LookupActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: 'outputs.DatasetReferenceResponse',
                 name: str,
                 source: Any,
                 type: str,
                 depends_on: Optional[Sequence['outputs.ActivityDependencyResponse']] = None,
                 description: Optional[str] = None,
                 first_row_only: Optional[Any] = None,
                 linked_service_name: Optional['outputs.LinkedServiceReferenceResponse'] = None,
                 policy: Optional['outputs.ActivityPolicyResponse'] = None):
        """
        Lookup activity.
        :param 'DatasetReferenceResponse' dataset: Lookup activity dataset reference.
        :param str name: Activity name.
        :param Union['AmazonMWSSourceResponse', 'AmazonRedshiftSourceResponse', 'AzureDataLakeStoreSourceResponse', 'AzureMySqlSourceResponse', 'AzurePostgreSqlSourceResponse', 'AzureTableSourceResponse', 'BlobSourceResponse', 'CassandraSourceResponse', 'ConcurSourceResponse', 'CouchbaseSourceResponse', 'DocumentDbCollectionSourceResponse', 'DrillSourceResponse', 'DynamicsSourceResponse', 'EloquaSourceResponse', 'FileSystemSourceResponse', 'GoogleBigQuerySourceResponse', 'GreenplumSourceResponse', 'HBaseSourceResponse', 'HdfsSourceResponse', 'HiveSourceResponse', 'HttpSourceResponse', 'HubspotSourceResponse', 'ImpalaSourceResponse', 'JiraSourceResponse', 'MagentoSourceResponse', 'MariaDBSourceResponse', 'MarketoSourceResponse', 'MongoDbSourceResponse', 'NetezzaSourceResponse', 'OracleSourceResponse', 'PaypalSourceResponse', 'PhoenixSourceResponse', 'PrestoSourceResponse', 'QuickBooksSourceResponse', 'RelationalSourceResponse', 'ResponsysSourceResponse', 'SalesforceMarketingCloudSourceResponse', 'SalesforceSourceResponse', 'SapCloudForCustomerSourceResponse', 'SapEccSourceResponse', 'ServiceNowSourceResponse', 'ShopifySourceResponse', 'SparkSourceResponse', 'SqlDWSourceResponse', 'SqlSourceResponse', 'SquareSourceResponse', 'VerticaSourceResponse', 'WebSourceResponse', 'XeroSourceResponse', 'ZohoSourceResponse'] source: Dataset-specific source properties, same as copy activity source.
        :param str type: Type of activity.
               Expected value is 'Lookup'.
        :param Sequence['ActivityDependencyResponse'] depends_on: Activity depends on condition.
        :param str description: Activity description.
        :param Any first_row_only: Whether to return first row or all rows. Default value is true. Type: boolean (or Expression with resultType boolean).
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param 'ActivityPolicyResponse' policy: Activity policy.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "type", 'Lookup')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if first_row_only is not None:
            pulumi.set(__self__, "first_row_only", first_row_only)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def dataset(self) -> 'outputs.DatasetReferenceResponse':
        """
        Lookup activity dataset reference.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def source(self) -> Any:
        """
        Dataset-specific source properties, same as copy activity source.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of activity.
        Expected value is 'Lookup'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ActivityDependencyResponse']]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="firstRowOnly")
    def first_row_only(self) -> Optional[Any]:
        """
        Whether to return first row or all rows. Default value is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "first_row_only")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional['outputs.LinkedServiceReferenceResponse']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def policy(self) -> Optional['outputs.ActivityPolicyResponse']:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")


@pulumi.output_type
class MagentoLinkedServiceResponse(dict):
    """
    Magento server linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessToken":
            suggest = "access_token"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "useEncryptedEndpoints":
            suggest = "use_encrypted_endpoints"
        elif key == "useHostVerification":
            suggest = "use_host_verification"
        elif key == "usePeerVerification":
            suggest = "use_peer_verification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MagentoLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MagentoLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MagentoLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: Any,
                 type: str,
                 access_token: Optional[Any] = None,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 use_encrypted_endpoints: Optional[Any] = None,
                 use_host_verification: Optional[Any] = None,
                 use_peer_verification: Optional[Any] = None):
        """
        Magento server linked service.
        :param Any host: The URL of the Magento instance. (i.e. 192.168.222.110/magento3)
        :param str type: Type of linked service.
               Expected value is 'Magento'.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] access_token: The access token from Magento.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Any use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        :param Any use_host_verification: Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        :param Any use_peer_verification: Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'Magento')
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if use_encrypted_endpoints is not None:
            pulumi.set(__self__, "use_encrypted_endpoints", use_encrypted_endpoints)
        if use_host_verification is not None:
            pulumi.set(__self__, "use_host_verification", use_host_verification)
        if use_peer_verification is not None:
            pulumi.set(__self__, "use_peer_verification", use_peer_verification)

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        The URL of the Magento instance. (i.e. 192.168.222.110/magento3)
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Magento'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[Any]:
        """
        The access token from Magento.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="useEncryptedEndpoints")
    def use_encrypted_endpoints(self) -> Optional[Any]:
        """
        Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        """
        return pulumi.get(self, "use_encrypted_endpoints")

    @property
    @pulumi.getter(name="useHostVerification")
    def use_host_verification(self) -> Optional[Any]:
        """
        Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_host_verification")

    @property
    @pulumi.getter(name="usePeerVerification")
    def use_peer_verification(self) -> Optional[Any]:
        """
        Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_peer_verification")


@pulumi.output_type
class MagentoObjectDatasetResponse(dict):
    """
    Magento server dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MagentoObjectDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MagentoObjectDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MagentoObjectDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Magento server dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'MagentoObject'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'MagentoObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'MagentoObject'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class MagentoSourceResponse(dict):
    """
    A copy activity Magento server source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MagentoSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MagentoSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MagentoSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Magento server source.
        :param str type: Copy source type.
               Expected value is 'MagentoSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'MagentoSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'MagentoSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class ManagedIntegrationRuntimeErrorResponse(dict):
    """
    Error definition for managed integration runtime.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 parameters: Sequence[str],
                 time: str):
        """
        Error definition for managed integration runtime.
        :param str code: Error code.
        :param str message: Error message.
        :param Sequence[str] parameters: Managed integration runtime error parameters.
        :param str time: The time when the error occurred.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence[str]:
        """
        Managed integration runtime error parameters.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def time(self) -> str:
        """
        The time when the error occurred.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class ManagedIntegrationRuntimeNodeResponse(dict):
    """
    Properties of integration runtime node.
    """
    def __init__(__self__, *,
                 node_id: str,
                 status: str,
                 errors: Optional[Sequence['outputs.ManagedIntegrationRuntimeErrorResponse']] = None):
        """
        Properties of integration runtime node.
        :param str node_id: The managed integration runtime node id.
        :param str status: The managed integration runtime node status.
        :param Sequence['ManagedIntegrationRuntimeErrorResponse'] errors: The errors that occurred on this integration runtime node.
        """
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "status", status)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        The managed integration runtime node id.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The managed integration runtime node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def errors(self) -> Optional[Sequence['outputs.ManagedIntegrationRuntimeErrorResponse']]:
        """
        The errors that occurred on this integration runtime node.
        """
        return pulumi.get(self, "errors")


@pulumi.output_type
class ManagedIntegrationRuntimeOperationResultResponse(dict):
    """
    Properties of managed integration runtime operation result.
    """
    def __init__(__self__, *,
                 activity_id: str,
                 error_code: str,
                 parameters: Sequence[str],
                 result: str,
                 start_time: str,
                 type: str):
        """
        Properties of managed integration runtime operation result.
        :param str activity_id: The activity id for the operation request.
        :param str error_code: The error code.
        :param Sequence[str] parameters: Managed integration runtime error parameters.
        :param str result: The operation result.
        :param str start_time: The start time of the operation.
        :param str type: The operation type. Could be start or stop.
        """
        pulumi.set(__self__, "activity_id", activity_id)
        pulumi.set(__self__, "error_code", error_code)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "result", result)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="activityId")
    def activity_id(self) -> str:
        """
        The activity id for the operation request.
        """
        return pulumi.get(self, "activity_id")

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> str:
        """
        The error code.
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence[str]:
        """
        Managed integration runtime error parameters.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def result(self) -> str:
        """
        The operation result.
        """
        return pulumi.get(self, "result")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time of the operation.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The operation type. Could be start or stop.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ManagedIntegrationRuntimeResponse(dict):
    """
    Managed integration runtime, including managed elastic and managed dedicated integration runtimes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeProperties":
            suggest = "compute_properties"
        elif key == "ssisProperties":
            suggest = "ssis_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedIntegrationRuntimeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedIntegrationRuntimeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedIntegrationRuntimeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state: str,
                 type: str,
                 compute_properties: Optional['outputs.IntegrationRuntimeComputePropertiesResponse'] = None,
                 description: Optional[str] = None,
                 ssis_properties: Optional['outputs.IntegrationRuntimeSsisPropertiesResponse'] = None):
        """
        Managed integration runtime, including managed elastic and managed dedicated integration runtimes.
        :param str state: Integration runtime state, only valid for managed dedicated integration runtime.
        :param str type: The type of integration runtime.
               Expected value is 'Managed'.
        :param 'IntegrationRuntimeComputePropertiesResponse' compute_properties: The compute resource for managed integration runtime.
        :param str description: Integration runtime description.
        :param 'IntegrationRuntimeSsisPropertiesResponse' ssis_properties: SSIS properties for managed integration runtime.
        """
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", 'Managed')
        if compute_properties is not None:
            pulumi.set(__self__, "compute_properties", compute_properties)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ssis_properties is not None:
            pulumi.set(__self__, "ssis_properties", ssis_properties)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Integration runtime state, only valid for managed dedicated integration runtime.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of integration runtime.
        Expected value is 'Managed'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="computeProperties")
    def compute_properties(self) -> Optional['outputs.IntegrationRuntimeComputePropertiesResponse']:
        """
        The compute resource for managed integration runtime.
        """
        return pulumi.get(self, "compute_properties")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Integration runtime description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ssisProperties")
    def ssis_properties(self) -> Optional['outputs.IntegrationRuntimeSsisPropertiesResponse']:
        """
        SSIS properties for managed integration runtime.
        """
        return pulumi.get(self, "ssis_properties")


@pulumi.output_type
class ManagedIntegrationRuntimeStatusResponse(dict):
    """
    Managed integration runtime status.
    """
    def __init__(__self__, *,
                 create_time: str,
                 data_factory_name: str,
                 last_operation: 'outputs.ManagedIntegrationRuntimeOperationResultResponse',
                 nodes: Sequence['outputs.ManagedIntegrationRuntimeNodeResponse'],
                 other_errors: Sequence['outputs.ManagedIntegrationRuntimeErrorResponse'],
                 state: str,
                 type: Optional[str] = None):
        """
        Managed integration runtime status.
        :param str create_time: The time at which the integration runtime was created, in ISO8601 format.
        :param str data_factory_name: The data factory name which the integration runtime belong to.
        :param 'ManagedIntegrationRuntimeOperationResultResponse' last_operation: The last operation result that occurred on this integration runtime.
        :param Sequence['ManagedIntegrationRuntimeNodeResponse'] nodes: The list of nodes for managed integration runtime.
        :param Sequence['ManagedIntegrationRuntimeErrorResponse'] other_errors: The errors that occurred on this integration runtime.
        :param str state: The state of integration runtime.
        :param str type: The type of integration runtime.
               Expected value is 'Managed'.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "data_factory_name", data_factory_name)
        pulumi.set(__self__, "last_operation", last_operation)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "other_errors", other_errors)
        pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", 'Managed')

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time at which the integration runtime was created, in ISO8601 format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataFactoryName")
    def data_factory_name(self) -> str:
        """
        The data factory name which the integration runtime belong to.
        """
        return pulumi.get(self, "data_factory_name")

    @property
    @pulumi.getter(name="lastOperation")
    def last_operation(self) -> 'outputs.ManagedIntegrationRuntimeOperationResultResponse':
        """
        The last operation result that occurred on this integration runtime.
        """
        return pulumi.get(self, "last_operation")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.ManagedIntegrationRuntimeNodeResponse']:
        """
        The list of nodes for managed integration runtime.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="otherErrors")
    def other_errors(self) -> Sequence['outputs.ManagedIntegrationRuntimeErrorResponse']:
        """
        The errors that occurred on this integration runtime.
        """
        return pulumi.get(self, "other_errors")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of integration runtime.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of integration runtime.
        Expected value is 'Managed'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MariaDBLinkedServiceResponse(dict):
    """
    MariaDB server linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectVia":
            suggest = "connect_via"
        elif key == "connectionString":
            suggest = "connection_string"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MariaDBLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MariaDBLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MariaDBLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 connection_string: Optional[Any] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None):
        """
        MariaDB server linked service.
        :param str type: Type of linked service.
               Expected value is 'MariaDB'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param Any connection_string: An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "type", 'MariaDB')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'MariaDB'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[Any]:
        """
        An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class MariaDBSourceResponse(dict):
    """
    A copy activity MariaDB server source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MariaDBSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MariaDBSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MariaDBSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity MariaDB server source.
        :param str type: Copy source type.
               Expected value is 'MariaDBSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'MariaDBSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'MariaDBSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class MariaDBTableDatasetResponse(dict):
    """
    MariaDB server dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MariaDBTableDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MariaDBTableDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MariaDBTableDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        MariaDB server dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'MariaDBTable'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'MariaDBTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'MariaDBTable'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class MarketoLinkedServiceResponse(dict):
    """
    Marketo server linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "useEncryptedEndpoints":
            suggest = "use_encrypted_endpoints"
        elif key == "useHostVerification":
            suggest = "use_host_verification"
        elif key == "usePeerVerification":
            suggest = "use_peer_verification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MarketoLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MarketoLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MarketoLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Any,
                 endpoint: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 client_secret: Optional[Any] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 use_encrypted_endpoints: Optional[Any] = None,
                 use_host_verification: Optional[Any] = None,
                 use_peer_verification: Optional[Any] = None):
        """
        Marketo server linked service.
        :param Any client_id: The client Id of your Marketo service.
        :param Any endpoint: The endpoint of the Marketo server. (i.e. 123-ABC-321.mktorest.com)
        :param str type: Type of linked service.
               Expected value is 'Marketo'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] client_secret: The client secret of your Marketo service.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Any use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        :param Any use_host_verification: Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        :param Any use_peer_verification: Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "type", 'Marketo')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if use_encrypted_endpoints is not None:
            pulumi.set(__self__, "use_encrypted_endpoints", use_encrypted_endpoints)
        if use_host_verification is not None:
            pulumi.set(__self__, "use_host_verification", use_host_verification)
        if use_peer_verification is not None:
            pulumi.set(__self__, "use_peer_verification", use_peer_verification)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Any:
        """
        The client Id of your Marketo service.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter
    def endpoint(self) -> Any:
        """
        The endpoint of the Marketo server. (i.e. 123-ABC-321.mktorest.com)
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Marketo'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[Any]:
        """
        The client secret of your Marketo service.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="useEncryptedEndpoints")
    def use_encrypted_endpoints(self) -> Optional[Any]:
        """
        Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        """
        return pulumi.get(self, "use_encrypted_endpoints")

    @property
    @pulumi.getter(name="useHostVerification")
    def use_host_verification(self) -> Optional[Any]:
        """
        Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_host_verification")

    @property
    @pulumi.getter(name="usePeerVerification")
    def use_peer_verification(self) -> Optional[Any]:
        """
        Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_peer_verification")


@pulumi.output_type
class MarketoObjectDatasetResponse(dict):
    """
    Marketo server dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MarketoObjectDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MarketoObjectDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MarketoObjectDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Marketo server dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'MarketoObject'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'MarketoObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'MarketoObject'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class MarketoSourceResponse(dict):
    """
    A copy activity Marketo server source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MarketoSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MarketoSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MarketoSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Marketo server source.
        :param str type: Copy source type.
               Expected value is 'MarketoSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'MarketoSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'MarketoSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class MongoDbCollectionDatasetResponse(dict):
    """
    The MongoDB database dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collectionName":
            suggest = "collection_name"
        elif key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MongoDbCollectionDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MongoDbCollectionDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MongoDbCollectionDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collection_name: Any,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        The MongoDB database dataset.
        :param Any collection_name: The table name of the MongoDB database. Type: string (or Expression with resultType string).
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'MongoDbCollection'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "collection_name", collection_name)
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'MongoDbCollection')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="collectionName")
    def collection_name(self) -> Any:
        """
        The table name of the MongoDB database. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "collection_name")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'MongoDbCollection'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class MongoDbLinkedServiceResponse(dict):
    """
    Linked service for MongoDb data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "allowSelfSignedServerCert":
            suggest = "allow_self_signed_server_cert"
        elif key == "authSource":
            suggest = "auth_source"
        elif key == "authenticationType":
            suggest = "authentication_type"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "enableSsl":
            suggest = "enable_ssl"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MongoDbLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MongoDbLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MongoDbLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: Any,
                 server: Any,
                 type: str,
                 allow_self_signed_server_cert: Optional[Any] = None,
                 annotations: Optional[Sequence[Any]] = None,
                 auth_source: Optional[Any] = None,
                 authentication_type: Optional[str] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 enable_ssl: Optional[Any] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 port: Optional[Any] = None,
                 username: Optional[Any] = None):
        """
        Linked service for MongoDb data source.
        :param Any database_name: The name of the MongoDB database that you want to access. Type: string (or Expression with resultType string).
        :param Any server: The IP address or server name of the MongoDB server. Type: string (or Expression with resultType string).
        :param str type: Type of linked service.
               Expected value is 'MongoDb'.
        :param Any allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from the server. The default value is false. Type: boolean (or Expression with resultType boolean).
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param Any auth_source: Database to verify the username and password. Type: string (or Expression with resultType string).
        :param str authentication_type: The authentication type to be used to connect to the MongoDB database.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The default value is false. Type: boolean (or Expression with resultType boolean).
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: Password for authentication.
        :param Any port: The TCP port number that the MongoDB server uses to listen for client connections. The default value is 27017. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any username: Username for authentication. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "server", server)
        pulumi.set(__self__, "type", 'MongoDb')
        if allow_self_signed_server_cert is not None:
            pulumi.set(__self__, "allow_self_signed_server_cert", allow_self_signed_server_cert)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if auth_source is not None:
            pulumi.set(__self__, "auth_source", auth_source)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Any:
        """
        The name of the MongoDB database that you want to access. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def server(self) -> Any:
        """
        The IP address or server name of the MongoDB server. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'MongoDb'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="allowSelfSignedServerCert")
    def allow_self_signed_server_cert(self) -> Optional[Any]:
        """
        Specifies whether to allow self-signed certificates from the server. The default value is false. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "allow_self_signed_server_cert")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="authSource")
    def auth_source(self) -> Optional[Any]:
        """
        Database to verify the username and password. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "auth_source")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[str]:
        """
        The authentication type to be used to connect to the MongoDB database.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[Any]:
        """
        Specifies whether the connections to the server are encrypted using SSL. The default value is false. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "enable_ssl")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        Password for authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The TCP port number that the MongoDB server uses to listen for client connections. The default value is 27017. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def username(self) -> Optional[Any]:
        """
        Username for authentication. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class MongoDbSourceResponse(dict):
    """
    A copy activity source for a MongoDB database.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MongoDbSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MongoDbSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MongoDbSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity source for a MongoDB database.
        :param str type: Copy source type.
               Expected value is 'MongoDbSource'.
        :param Any query: Database query. Should be a SQL-92 query expression. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'MongoDbSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'MongoDbSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        Database query. Should be a SQL-92 query expression. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class MultiplePipelineTriggerResponse(dict):
    """
    Base class for all triggers that support one to many model for trigger to pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runtimeState":
            suggest = "runtime_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiplePipelineTriggerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiplePipelineTriggerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiplePipelineTriggerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 runtime_state: str,
                 type: str,
                 description: Optional[str] = None,
                 pipelines: Optional[Sequence['outputs.TriggerPipelineReferenceResponse']] = None):
        """
        Base class for all triggers that support one to many model for trigger to pipeline.
        :param str runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
        :param str type: Trigger type.
               Expected value is 'MultiplePipelineTrigger'.
        :param str description: Trigger description.
        :param Sequence['TriggerPipelineReferenceResponse'] pipelines: Pipelines that need to be started.
        """
        pulumi.set(__self__, "runtime_state", runtime_state)
        pulumi.set(__self__, "type", 'MultiplePipelineTrigger')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if pipelines is not None:
            pulumi.set(__self__, "pipelines", pipelines)

    @property
    @pulumi.getter(name="runtimeState")
    def runtime_state(self) -> str:
        """
        Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
        """
        return pulumi.get(self, "runtime_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Trigger type.
        Expected value is 'MultiplePipelineTrigger'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Trigger description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def pipelines(self) -> Optional[Sequence['outputs.TriggerPipelineReferenceResponse']]:
        """
        Pipelines that need to be started.
        """
        return pulumi.get(self, "pipelines")


@pulumi.output_type
class MySqlLinkedServiceResponse(dict):
    """
    Linked service for MySQL data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MySqlLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MySqlLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MySqlLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None):
        """
        Linked service for MySQL data source.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] connection_string: The connection string.
        :param str type: Type of linked service.
               Expected value is 'MySql'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "type", 'MySql')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Any:
        """
        The connection string.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'MySql'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class NetezzaLinkedServiceResponse(dict):
    """
    Netezza linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectVia":
            suggest = "connect_via"
        elif key == "connectionString":
            suggest = "connection_string"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetezzaLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetezzaLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetezzaLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 connection_string: Optional[Any] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None):
        """
        Netezza linked service.
        :param str type: Type of linked service.
               Expected value is 'Netezza'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param Any connection_string: An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "type", 'Netezza')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Netezza'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[Any]:
        """
        An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class NetezzaSourceResponse(dict):
    """
    A copy activity Netezza source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetezzaSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetezzaSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetezzaSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Netezza source.
        :param str type: Copy source type.
               Expected value is 'NetezzaSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'NetezzaSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'NetezzaSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class NetezzaTableDatasetResponse(dict):
    """
    Netezza dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetezzaTableDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetezzaTableDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetezzaTableDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Netezza dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'NetezzaTable'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'NetezzaTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'NetezzaTable'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class ODataLinkedServiceResponse(dict):
    """
    Open Data Protocol (OData) linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ODataLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ODataLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ODataLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 url: Any,
                 annotations: Optional[Sequence[Any]] = None,
                 authentication_type: Optional[str] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 user_name: Optional[Any] = None):
        """
        Open Data Protocol (OData) linked service.
        :param str type: Type of linked service.
               Expected value is 'OData'.
        :param Any url: The URL of the OData service endpoint. Type: string (or Expression with resultType string).
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str authentication_type: Type of authentication used to connect to the OData service.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: Password of the OData service.
        :param Any user_name: User name of the OData service. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "type", 'OData')
        pulumi.set(__self__, "url", url)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'OData'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> Any:
        """
        The URL of the OData service endpoint. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[str]:
        """
        Type of authentication used to connect to the OData service.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        Password of the OData service.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[Any]:
        """
        User name of the OData service. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class ODataResourceDatasetResponse(dict):
    """
    The Open Data Protocol (OData) resource dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ODataResourceDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ODataResourceDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ODataResourceDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 path: Optional[Any] = None,
                 structure: Optional[Any] = None):
        """
        The Open Data Protocol (OData) resource dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'ODataResource'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any path: The OData resource path. Type: string (or Expression with resultType string).
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'ODataResource')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'ODataResource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def path(self) -> Optional[Any]:
        """
        The OData resource path. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class OdbcLinkedServiceResponse(dict):
    """
    Open Database Connectivity (ODBC) linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "authenticationType":
            suggest = "authentication_type"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OdbcLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OdbcLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OdbcLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 authentication_type: Optional[Any] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 credential: Optional[Any] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 user_name: Optional[Any] = None):
        """
        Open Database Connectivity (ODBC) linked service.
        :param Any connection_string: The non-access credential portion of the connection string as well as an optional encrypted credential. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param str type: Type of linked service.
               Expected value is 'Odbc'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param Any authentication_type: Type of authentication used to connect to the ODBC data store. Possible values are: Anonymous and Basic. Type: string (or Expression with resultType string).
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] credential: The access credential portion of the connection string specified in driver-specific property-value format.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: Password for Basic authentication.
        :param Any user_name: User name for Basic authentication. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "type", 'Odbc')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if credential is not None:
            pulumi.set(__self__, "credential", credential)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Any:
        """
        The non-access credential portion of the connection string as well as an optional encrypted credential. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Odbc'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[Any]:
        """
        Type of authentication used to connect to the ODBC data store. Possible values are: Anonymous and Basic. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def credential(self) -> Optional[Any]:
        """
        The access credential portion of the connection string specified in driver-specific property-value format.
        """
        return pulumi.get(self, "credential")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        Password for Basic authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[Any]:
        """
        User name for Basic authentication. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class OdbcSinkResponse(dict):
    """
    A copy activity ODBC sink.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preCopyScript":
            suggest = "pre_copy_script"
        elif key == "sinkRetryCount":
            suggest = "sink_retry_count"
        elif key == "sinkRetryWait":
            suggest = "sink_retry_wait"
        elif key == "writeBatchSize":
            suggest = "write_batch_size"
        elif key == "writeBatchTimeout":
            suggest = "write_batch_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OdbcSinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OdbcSinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OdbcSinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 pre_copy_script: Optional[Any] = None,
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None):
        """
        A copy activity ODBC sink.
        :param str type: Copy sink type.
               Expected value is 'OdbcSink'.
        :param Any pre_copy_script: A query to execute before starting the copy. Type: string (or Expression with resultType string).
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'OdbcSink')
        if pre_copy_script is not None:
            pulumi.set(__self__, "pre_copy_script", pre_copy_script)
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy sink type.
        Expected value is 'OdbcSink'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="preCopyScript")
    def pre_copy_script(self) -> Optional[Any]:
        """
        A query to execute before starting the copy. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "pre_copy_script")

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")


@pulumi.output_type
class OracleLinkedServiceResponse(dict):
    """
    Oracle database.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OracleLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OracleLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OracleLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None):
        """
        Oracle database.
        :param Any connection_string: The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param str type: Type of linked service.
               Expected value is 'Oracle'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "type", 'Oracle')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Any:
        """
        The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Oracle'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class OracleSinkResponse(dict):
    """
    A copy activity Oracle sink.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preCopyScript":
            suggest = "pre_copy_script"
        elif key == "sinkRetryCount":
            suggest = "sink_retry_count"
        elif key == "sinkRetryWait":
            suggest = "sink_retry_wait"
        elif key == "writeBatchSize":
            suggest = "write_batch_size"
        elif key == "writeBatchTimeout":
            suggest = "write_batch_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OracleSinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OracleSinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OracleSinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 pre_copy_script: Optional[Any] = None,
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None):
        """
        A copy activity Oracle sink.
        :param str type: Copy sink type.
               Expected value is 'OracleSink'.
        :param Any pre_copy_script: SQL pre-copy script. Type: string (or Expression with resultType string).
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'OracleSink')
        if pre_copy_script is not None:
            pulumi.set(__self__, "pre_copy_script", pre_copy_script)
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy sink type.
        Expected value is 'OracleSink'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="preCopyScript")
    def pre_copy_script(self) -> Optional[Any]:
        """
        SQL pre-copy script. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "pre_copy_script")

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")


@pulumi.output_type
class OracleSourceResponse(dict):
    """
    A copy activity Oracle source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oracleReaderQuery":
            suggest = "oracle_reader_query"
        elif key == "queryTimeout":
            suggest = "query_timeout"
        elif key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OracleSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OracleSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OracleSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 oracle_reader_query: Optional[Any] = None,
                 query_timeout: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Oracle source.
        :param str type: Copy source type.
               Expected value is 'OracleSource'.
        :param Any oracle_reader_query: Oracle reader query. Type: string (or Expression with resultType string).
        :param Any query_timeout: Query timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'OracleSource')
        if oracle_reader_query is not None:
            pulumi.set(__self__, "oracle_reader_query", oracle_reader_query)
        if query_timeout is not None:
            pulumi.set(__self__, "query_timeout", query_timeout)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'OracleSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="oracleReaderQuery")
    def oracle_reader_query(self) -> Optional[Any]:
        """
        Oracle reader query. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "oracle_reader_query")

    @property
    @pulumi.getter(name="queryTimeout")
    def query_timeout(self) -> Optional[Any]:
        """
        Query timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "query_timeout")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class OracleTableDatasetResponse(dict):
    """
    The on-premises Oracle database dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OracleTableDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OracleTableDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OracleTableDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 table_name: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        The on-premises Oracle database dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param Any table_name: The table name of the on-premises Oracle database. Type: string (or Expression with resultType string).
        :param str type: Type of dataset.
               Expected value is 'OracleTable'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "type", 'OracleTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Any:
        """
        The table name of the on-premises Oracle database. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'OracleTable'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class OrcFormatResponse(dict):
    """
    The data stored in Optimized Row Columnar (ORC) format.
    """
    def __init__(__self__, *,
                 type: str,
                 deserializer: Optional[Any] = None,
                 serializer: Optional[Any] = None):
        """
        The data stored in Optimized Row Columnar (ORC) format.
        :param str type: Type of dataset storage format.
               Expected value is 'OrcFormat'.
        :param Any deserializer: Deserializer. Type: string (or Expression with resultType string).
        :param Any serializer: Serializer. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "type", 'OrcFormat')
        if deserializer is not None:
            pulumi.set(__self__, "deserializer", deserializer)
        if serializer is not None:
            pulumi.set(__self__, "serializer", serializer)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset storage format.
        Expected value is 'OrcFormat'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def deserializer(self) -> Optional[Any]:
        """
        Deserializer. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "deserializer")

    @property
    @pulumi.getter
    def serializer(self) -> Optional[Any]:
        """
        Serializer. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "serializer")


@pulumi.output_type
class ParameterSpecificationResponse(dict):
    """
    Definition of a single parameter for an entity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParameterSpecificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParameterSpecificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParameterSpecificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 default_value: Optional[Any] = None):
        """
        Definition of a single parameter for an entity.
        :param str type: Parameter type.
        :param Any default_value: Default value of parameter.
        """
        pulumi.set(__self__, "type", type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Parameter type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[Any]:
        """
        Default value of parameter.
        """
        return pulumi.get(self, "default_value")


@pulumi.output_type
class ParquetFormatResponse(dict):
    """
    The data stored in Parquet format.
    """
    def __init__(__self__, *,
                 type: str,
                 deserializer: Optional[Any] = None,
                 serializer: Optional[Any] = None):
        """
        The data stored in Parquet format.
        :param str type: Type of dataset storage format.
               Expected value is 'ParquetFormat'.
        :param Any deserializer: Deserializer. Type: string (or Expression with resultType string).
        :param Any serializer: Serializer. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "type", 'ParquetFormat')
        if deserializer is not None:
            pulumi.set(__self__, "deserializer", deserializer)
        if serializer is not None:
            pulumi.set(__self__, "serializer", serializer)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset storage format.
        Expected value is 'ParquetFormat'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def deserializer(self) -> Optional[Any]:
        """
        Deserializer. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "deserializer")

    @property
    @pulumi.getter
    def serializer(self) -> Optional[Any]:
        """
        Serializer. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "serializer")


@pulumi.output_type
class PaypalLinkedServiceResponse(dict):
    """
    Paypal Service linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "useEncryptedEndpoints":
            suggest = "use_encrypted_endpoints"
        elif key == "useHostVerification":
            suggest = "use_host_verification"
        elif key == "usePeerVerification":
            suggest = "use_peer_verification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PaypalLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PaypalLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PaypalLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Any,
                 host: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 client_secret: Optional[Any] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 use_encrypted_endpoints: Optional[Any] = None,
                 use_host_verification: Optional[Any] = None,
                 use_peer_verification: Optional[Any] = None):
        """
        Paypal Service linked service.
        :param Any client_id: The client ID associated with your PayPal application.
        :param Any host: The URL of the PayPal instance. (i.e. api.sandbox.paypal.com)
        :param str type: Type of linked service.
               Expected value is 'Paypal'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] client_secret: The client secret associated with your PayPal application.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Any use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        :param Any use_host_verification: Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        :param Any use_peer_verification: Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'Paypal')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if use_encrypted_endpoints is not None:
            pulumi.set(__self__, "use_encrypted_endpoints", use_encrypted_endpoints)
        if use_host_verification is not None:
            pulumi.set(__self__, "use_host_verification", use_host_verification)
        if use_peer_verification is not None:
            pulumi.set(__self__, "use_peer_verification", use_peer_verification)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Any:
        """
        The client ID associated with your PayPal application.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        The URL of the PayPal instance. (i.e. api.sandbox.paypal.com)
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Paypal'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[Any]:
        """
        The client secret associated with your PayPal application.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="useEncryptedEndpoints")
    def use_encrypted_endpoints(self) -> Optional[Any]:
        """
        Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        """
        return pulumi.get(self, "use_encrypted_endpoints")

    @property
    @pulumi.getter(name="useHostVerification")
    def use_host_verification(self) -> Optional[Any]:
        """
        Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_host_verification")

    @property
    @pulumi.getter(name="usePeerVerification")
    def use_peer_verification(self) -> Optional[Any]:
        """
        Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_peer_verification")


@pulumi.output_type
class PaypalObjectDatasetResponse(dict):
    """
    Paypal Service dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PaypalObjectDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PaypalObjectDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PaypalObjectDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Paypal Service dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'PaypalObject'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'PaypalObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'PaypalObject'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class PaypalSourceResponse(dict):
    """
    A copy activity Paypal Service source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PaypalSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PaypalSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PaypalSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Paypal Service source.
        :param str type: Copy source type.
               Expected value is 'PaypalSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'PaypalSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'PaypalSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class PhoenixLinkedServiceResponse(dict):
    """
    Phoenix server linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "allowHostNameCNMismatch":
            suggest = "allow_host_name_cn_mismatch"
        elif key == "allowSelfSignedServerCert":
            suggest = "allow_self_signed_server_cert"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "enableSsl":
            suggest = "enable_ssl"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "httpPath":
            suggest = "http_path"
        elif key == "trustedCertPath":
            suggest = "trusted_cert_path"
        elif key == "useSystemTrustStore":
            suggest = "use_system_trust_store"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PhoenixLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PhoenixLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PhoenixLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_type: str,
                 host: Any,
                 type: str,
                 allow_host_name_cn_mismatch: Optional[Any] = None,
                 allow_self_signed_server_cert: Optional[Any] = None,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 enable_ssl: Optional[Any] = None,
                 encrypted_credential: Optional[Any] = None,
                 http_path: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 port: Optional[Any] = None,
                 trusted_cert_path: Optional[Any] = None,
                 use_system_trust_store: Optional[Any] = None,
                 username: Optional[Any] = None):
        """
        Phoenix server linked service.
        :param str authentication_type: The authentication mechanism used to connect to the Phoenix server.
        :param Any host: The IP address or host name of the Phoenix server. (i.e. 192.168.222.160)
        :param str type: Type of linked service.
               Expected value is 'Phoenix'.
        :param Any allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        :param Any allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from the server. The default value is false.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Any http_path: The partial URL corresponding to the Phoenix server. (i.e. /gateway/sandbox/phoenix/version). The default value is hbasephoenix if using WindowsAzureHDInsightService.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: The password corresponding to the user name.
        :param Any port: The TCP port that the Phoenix server uses to listen for client connections. The default value is 8765.
        :param Any trusted_cert_path: The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        :param Any use_system_trust_store: Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        :param Any username: The user name used to connect to the Phoenix server.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'Phoenix')
        if allow_host_name_cn_mismatch is not None:
            pulumi.set(__self__, "allow_host_name_cn_mismatch", allow_host_name_cn_mismatch)
        if allow_self_signed_server_cert is not None:
            pulumi.set(__self__, "allow_self_signed_server_cert", allow_self_signed_server_cert)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if http_path is not None:
            pulumi.set(__self__, "http_path", http_path)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if trusted_cert_path is not None:
            pulumi.set(__self__, "trusted_cert_path", trusted_cert_path)
        if use_system_trust_store is not None:
            pulumi.set(__self__, "use_system_trust_store", use_system_trust_store)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> str:
        """
        The authentication mechanism used to connect to the Phoenix server.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        The IP address or host name of the Phoenix server. (i.e. 192.168.222.160)
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Phoenix'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="allowHostNameCNMismatch")
    def allow_host_name_cn_mismatch(self) -> Optional[Any]:
        """
        Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        """
        return pulumi.get(self, "allow_host_name_cn_mismatch")

    @property
    @pulumi.getter(name="allowSelfSignedServerCert")
    def allow_self_signed_server_cert(self) -> Optional[Any]:
        """
        Specifies whether to allow self-signed certificates from the server. The default value is false.
        """
        return pulumi.get(self, "allow_self_signed_server_cert")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[Any]:
        """
        Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        """
        return pulumi.get(self, "enable_ssl")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter(name="httpPath")
    def http_path(self) -> Optional[Any]:
        """
        The partial URL corresponding to the Phoenix server. (i.e. /gateway/sandbox/phoenix/version). The default value is hbasephoenix if using WindowsAzureHDInsightService.
        """
        return pulumi.get(self, "http_path")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        The password corresponding to the user name.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The TCP port that the Phoenix server uses to listen for client connections. The default value is 8765.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="trustedCertPath")
    def trusted_cert_path(self) -> Optional[Any]:
        """
        The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        """
        return pulumi.get(self, "trusted_cert_path")

    @property
    @pulumi.getter(name="useSystemTrustStore")
    def use_system_trust_store(self) -> Optional[Any]:
        """
        Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        """
        return pulumi.get(self, "use_system_trust_store")

    @property
    @pulumi.getter
    def username(self) -> Optional[Any]:
        """
        The user name used to connect to the Phoenix server.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class PhoenixObjectDatasetResponse(dict):
    """
    Phoenix server dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PhoenixObjectDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PhoenixObjectDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PhoenixObjectDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Phoenix server dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'PhoenixObject'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'PhoenixObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'PhoenixObject'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class PhoenixSourceResponse(dict):
    """
    A copy activity Phoenix server source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PhoenixSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PhoenixSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PhoenixSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Phoenix server source.
        :param str type: Copy source type.
               Expected value is 'PhoenixSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'PhoenixSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'PhoenixSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class PipelineReferenceResponse(dict):
    """
    Pipeline reference type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referenceName":
            suggest = "reference_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reference_name: str,
                 type: str,
                 name: Optional[str] = None):
        """
        Pipeline reference type.
        :param str reference_name: Reference pipeline name.
        :param str type: Pipeline reference type.
        :param str name: Reference name.
        """
        pulumi.set(__self__, "reference_name", reference_name)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="referenceName")
    def reference_name(self) -> str:
        """
        Reference pipeline name.
        """
        return pulumi.get(self, "reference_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Pipeline reference type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Reference name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PolybaseSettingsResponse(dict):
    """
    PolyBase settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rejectSampleValue":
            suggest = "reject_sample_value"
        elif key == "rejectType":
            suggest = "reject_type"
        elif key == "rejectValue":
            suggest = "reject_value"
        elif key == "useTypeDefault":
            suggest = "use_type_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolybaseSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolybaseSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolybaseSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reject_sample_value: Optional[Any] = None,
                 reject_type: Optional[str] = None,
                 reject_value: Optional[Any] = None,
                 use_type_default: Optional[Any] = None):
        """
        PolyBase settings.
        :param Any reject_sample_value: Determines the number of rows to attempt to retrieve before the PolyBase recalculates the percentage of rejected rows. Type: integer (or Expression with resultType integer), minimum: 0.
        :param str reject_type: Reject type.
        :param Any reject_value: Specifies the value or the percentage of rows that can be rejected before the query fails. Type: number (or Expression with resultType number), minimum: 0.
        :param Any use_type_default: Specifies how to handle missing values in delimited text files when PolyBase retrieves data from the text file. Type: boolean (or Expression with resultType boolean).
        """
        if reject_sample_value is not None:
            pulumi.set(__self__, "reject_sample_value", reject_sample_value)
        if reject_type is not None:
            pulumi.set(__self__, "reject_type", reject_type)
        if reject_value is not None:
            pulumi.set(__self__, "reject_value", reject_value)
        if use_type_default is not None:
            pulumi.set(__self__, "use_type_default", use_type_default)

    @property
    @pulumi.getter(name="rejectSampleValue")
    def reject_sample_value(self) -> Optional[Any]:
        """
        Determines the number of rows to attempt to retrieve before the PolyBase recalculates the percentage of rejected rows. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "reject_sample_value")

    @property
    @pulumi.getter(name="rejectType")
    def reject_type(self) -> Optional[str]:
        """
        Reject type.
        """
        return pulumi.get(self, "reject_type")

    @property
    @pulumi.getter(name="rejectValue")
    def reject_value(self) -> Optional[Any]:
        """
        Specifies the value or the percentage of rows that can be rejected before the query fails. Type: number (or Expression with resultType number), minimum: 0.
        """
        return pulumi.get(self, "reject_value")

    @property
    @pulumi.getter(name="useTypeDefault")
    def use_type_default(self) -> Optional[Any]:
        """
        Specifies how to handle missing values in delimited text files when PolyBase retrieves data from the text file. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "use_type_default")


@pulumi.output_type
class PostgreSqlLinkedServiceResponse(dict):
    """
    Linked service for PostgreSQL data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PostgreSqlLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PostgreSqlLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PostgreSqlLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None):
        """
        Linked service for PostgreSQL data source.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] connection_string: The connection string.
        :param str type: Type of linked service.
               Expected value is 'PostgreSql'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "type", 'PostgreSql')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Any:
        """
        The connection string.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'PostgreSql'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class PrestoLinkedServiceResponse(dict):
    """
    Presto server linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "serverVersion":
            suggest = "server_version"
        elif key == "allowHostNameCNMismatch":
            suggest = "allow_host_name_cn_mismatch"
        elif key == "allowSelfSignedServerCert":
            suggest = "allow_self_signed_server_cert"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "enableSsl":
            suggest = "enable_ssl"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "timeZoneID":
            suggest = "time_zone_id"
        elif key == "trustedCertPath":
            suggest = "trusted_cert_path"
        elif key == "useSystemTrustStore":
            suggest = "use_system_trust_store"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrestoLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrestoLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrestoLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_type: str,
                 catalog: Any,
                 host: Any,
                 server_version: Any,
                 type: str,
                 allow_host_name_cn_mismatch: Optional[Any] = None,
                 allow_self_signed_server_cert: Optional[Any] = None,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 enable_ssl: Optional[Any] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 port: Optional[Any] = None,
                 time_zone_id: Optional[Any] = None,
                 trusted_cert_path: Optional[Any] = None,
                 use_system_trust_store: Optional[Any] = None,
                 username: Optional[Any] = None):
        """
        Presto server linked service.
        :param str authentication_type: The authentication mechanism used to connect to the Presto server.
        :param Any catalog: The catalog context for all request against the server.
        :param Any host: The IP address or host name of the Presto server. (i.e. 192.168.222.160)
        :param Any server_version: The version of the Presto server. (i.e. 0.148-t)
        :param str type: Type of linked service.
               Expected value is 'Presto'.
        :param Any allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        :param Any allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from the server. The default value is false.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: The password corresponding to the user name.
        :param Any port: The TCP port that the Presto server uses to listen for client connections. The default value is 8080.
        :param Any time_zone_id: The local time zone used by the connection. Valid values for this option are specified in the IANA Time Zone Database. The default value is the system time zone.
        :param Any trusted_cert_path: The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        :param Any use_system_trust_store: Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        :param Any username: The user name used to connect to the Presto server.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "catalog", catalog)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "server_version", server_version)
        pulumi.set(__self__, "type", 'Presto')
        if allow_host_name_cn_mismatch is not None:
            pulumi.set(__self__, "allow_host_name_cn_mismatch", allow_host_name_cn_mismatch)
        if allow_self_signed_server_cert is not None:
            pulumi.set(__self__, "allow_self_signed_server_cert", allow_self_signed_server_cert)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if time_zone_id is not None:
            pulumi.set(__self__, "time_zone_id", time_zone_id)
        if trusted_cert_path is not None:
            pulumi.set(__self__, "trusted_cert_path", trusted_cert_path)
        if use_system_trust_store is not None:
            pulumi.set(__self__, "use_system_trust_store", use_system_trust_store)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> str:
        """
        The authentication mechanism used to connect to the Presto server.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter
    def catalog(self) -> Any:
        """
        The catalog context for all request against the server.
        """
        return pulumi.get(self, "catalog")

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        The IP address or host name of the Presto server. (i.e. 192.168.222.160)
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> Any:
        """
        The version of the Presto server. (i.e. 0.148-t)
        """
        return pulumi.get(self, "server_version")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Presto'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="allowHostNameCNMismatch")
    def allow_host_name_cn_mismatch(self) -> Optional[Any]:
        """
        Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        """
        return pulumi.get(self, "allow_host_name_cn_mismatch")

    @property
    @pulumi.getter(name="allowSelfSignedServerCert")
    def allow_self_signed_server_cert(self) -> Optional[Any]:
        """
        Specifies whether to allow self-signed certificates from the server. The default value is false.
        """
        return pulumi.get(self, "allow_self_signed_server_cert")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[Any]:
        """
        Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        """
        return pulumi.get(self, "enable_ssl")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        The password corresponding to the user name.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The TCP port that the Presto server uses to listen for client connections. The default value is 8080.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="timeZoneID")
    def time_zone_id(self) -> Optional[Any]:
        """
        The local time zone used by the connection. Valid values for this option are specified in the IANA Time Zone Database. The default value is the system time zone.
        """
        return pulumi.get(self, "time_zone_id")

    @property
    @pulumi.getter(name="trustedCertPath")
    def trusted_cert_path(self) -> Optional[Any]:
        """
        The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        """
        return pulumi.get(self, "trusted_cert_path")

    @property
    @pulumi.getter(name="useSystemTrustStore")
    def use_system_trust_store(self) -> Optional[Any]:
        """
        Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        """
        return pulumi.get(self, "use_system_trust_store")

    @property
    @pulumi.getter
    def username(self) -> Optional[Any]:
        """
        The user name used to connect to the Presto server.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class PrestoObjectDatasetResponse(dict):
    """
    Presto server dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrestoObjectDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrestoObjectDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrestoObjectDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Presto server dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'PrestoObject'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'PrestoObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'PrestoObject'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class PrestoSourceResponse(dict):
    """
    A copy activity Presto server source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrestoSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrestoSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrestoSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Presto server source.
        :param str type: Copy source type.
               Expected value is 'PrestoSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'PrestoSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'PrestoSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class QuickBooksLinkedServiceResponse(dict):
    """
    QuickBooks server linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessToken":
            suggest = "access_token"
        elif key == "accessTokenSecret":
            suggest = "access_token_secret"
        elif key == "companyId":
            suggest = "company_id"
        elif key == "consumerKey":
            suggest = "consumer_key"
        elif key == "consumerSecret":
            suggest = "consumer_secret"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "useEncryptedEndpoints":
            suggest = "use_encrypted_endpoints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickBooksLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickBooksLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickBooksLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_token: Any,
                 access_token_secret: Any,
                 company_id: Any,
                 consumer_key: Any,
                 consumer_secret: Any,
                 endpoint: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 use_encrypted_endpoints: Optional[Any] = None):
        """
        QuickBooks server linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] access_token: The access token for OAuth 1.0 authentication.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] access_token_secret: The access token secret for OAuth 1.0 authentication.
        :param Any company_id: The company ID of the QuickBooks company to authorize.
        :param Any consumer_key: The consumer key for OAuth 1.0 authentication.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] consumer_secret: The consumer secret for OAuth 1.0 authentication.
        :param Any endpoint: The endpoint of the QuickBooks server. (i.e. quickbooks.api.intuit.com)
        :param str type: Type of linked service.
               Expected value is 'QuickBooks'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Any use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        """
        pulumi.set(__self__, "access_token", access_token)
        pulumi.set(__self__, "access_token_secret", access_token_secret)
        pulumi.set(__self__, "company_id", company_id)
        pulumi.set(__self__, "consumer_key", consumer_key)
        pulumi.set(__self__, "consumer_secret", consumer_secret)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "type", 'QuickBooks')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if use_encrypted_endpoints is not None:
            pulumi.set(__self__, "use_encrypted_endpoints", use_encrypted_endpoints)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Any:
        """
        The access token for OAuth 1.0 authentication.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="accessTokenSecret")
    def access_token_secret(self) -> Any:
        """
        The access token secret for OAuth 1.0 authentication.
        """
        return pulumi.get(self, "access_token_secret")

    @property
    @pulumi.getter(name="companyId")
    def company_id(self) -> Any:
        """
        The company ID of the QuickBooks company to authorize.
        """
        return pulumi.get(self, "company_id")

    @property
    @pulumi.getter(name="consumerKey")
    def consumer_key(self) -> Any:
        """
        The consumer key for OAuth 1.0 authentication.
        """
        return pulumi.get(self, "consumer_key")

    @property
    @pulumi.getter(name="consumerSecret")
    def consumer_secret(self) -> Any:
        """
        The consumer secret for OAuth 1.0 authentication.
        """
        return pulumi.get(self, "consumer_secret")

    @property
    @pulumi.getter
    def endpoint(self) -> Any:
        """
        The endpoint of the QuickBooks server. (i.e. quickbooks.api.intuit.com)
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'QuickBooks'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="useEncryptedEndpoints")
    def use_encrypted_endpoints(self) -> Optional[Any]:
        """
        Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        """
        return pulumi.get(self, "use_encrypted_endpoints")


@pulumi.output_type
class QuickBooksObjectDatasetResponse(dict):
    """
    QuickBooks server dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickBooksObjectDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickBooksObjectDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickBooksObjectDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        QuickBooks server dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'QuickBooksObject'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'QuickBooksObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'QuickBooksObject'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class QuickBooksSourceResponse(dict):
    """
    A copy activity QuickBooks server source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickBooksSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickBooksSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickBooksSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity QuickBooks server source.
        :param str type: Copy source type.
               Expected value is 'QuickBooksSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'QuickBooksSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'QuickBooksSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class RecurrenceScheduleOccurrenceResponse(dict):
    """
    The recurrence schedule occurrence.
    """
    def __init__(__self__, *,
                 day: Optional[str] = None,
                 occurrence: Optional[int] = None):
        """
        The recurrence schedule occurrence.
        :param str day: The day of the week.
        :param int occurrence: The occurrence.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if occurrence is not None:
            pulumi.set(__self__, "occurrence", occurrence)

    @property
    @pulumi.getter
    def day(self) -> Optional[str]:
        """
        The day of the week.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def occurrence(self) -> Optional[int]:
        """
        The occurrence.
        """
        return pulumi.get(self, "occurrence")


@pulumi.output_type
class RecurrenceScheduleResponse(dict):
    """
    The recurrence schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monthDays":
            suggest = "month_days"
        elif key == "monthlyOccurrences":
            suggest = "monthly_occurrences"
        elif key == "weekDays":
            suggest = "week_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecurrenceScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecurrenceScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecurrenceScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hours: Optional[Sequence[int]] = None,
                 minutes: Optional[Sequence[int]] = None,
                 month_days: Optional[Sequence[int]] = None,
                 monthly_occurrences: Optional[Sequence['outputs.RecurrenceScheduleOccurrenceResponse']] = None,
                 week_days: Optional[Sequence[str]] = None):
        """
        The recurrence schedule.
        :param Sequence[int] hours: The hours.
        :param Sequence[int] minutes: The minutes.
        :param Sequence[int] month_days: The month days.
        :param Sequence['RecurrenceScheduleOccurrenceResponse'] monthly_occurrences: The monthly occurrences.
        :param Sequence[str] week_days: The days of the week.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if month_days is not None:
            pulumi.set(__self__, "month_days", month_days)
        if monthly_occurrences is not None:
            pulumi.set(__self__, "monthly_occurrences", monthly_occurrences)
        if week_days is not None:
            pulumi.set(__self__, "week_days", week_days)

    @property
    @pulumi.getter
    def hours(self) -> Optional[Sequence[int]]:
        """
        The hours.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Optional[Sequence[int]]:
        """
        The minutes.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter(name="monthDays")
    def month_days(self) -> Optional[Sequence[int]]:
        """
        The month days.
        """
        return pulumi.get(self, "month_days")

    @property
    @pulumi.getter(name="monthlyOccurrences")
    def monthly_occurrences(self) -> Optional[Sequence['outputs.RecurrenceScheduleOccurrenceResponse']]:
        """
        The monthly occurrences.
        """
        return pulumi.get(self, "monthly_occurrences")

    @property
    @pulumi.getter(name="weekDays")
    def week_days(self) -> Optional[Sequence[str]]:
        """
        The days of the week.
        """
        return pulumi.get(self, "week_days")


@pulumi.output_type
class RedirectIncompatibleRowSettingsResponse(dict):
    """
    Redirect incompatible row settings
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RedirectIncompatibleRowSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RedirectIncompatibleRowSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RedirectIncompatibleRowSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: Any,
                 path: Optional[Any] = None):
        """
        Redirect incompatible row settings
        :param Any linked_service_name: Name of the Azure Storage, Storage SAS, or Azure Data Lake Store linked service used for redirecting incompatible row. Must be specified if redirectIncompatibleRowSettings is specified. Type: string (or Expression with resultType string).
        :param Any path: The path for storing the redirect incompatible row data. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Any:
        """
        Name of the Azure Storage, Storage SAS, or Azure Data Lake Store linked service used for redirecting incompatible row. Must be specified if redirectIncompatibleRowSettings is specified. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def path(self) -> Optional[Any]:
        """
        The path for storing the redirect incompatible row data. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class RedshiftUnloadSettingsResponse(dict):
    """
    The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "s3LinkedServiceName":
            suggest = "s3_linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RedshiftUnloadSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RedshiftUnloadSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RedshiftUnloadSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: Any,
                 s3_linked_service_name: 'outputs.LinkedServiceReferenceResponse'):
        """
        The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3.
        :param Any bucket_name: The bucket of the interim Amazon S3 which will be used to store the unloaded data from Amazon Redshift source. The bucket must be in the same region as the Amazon Redshift source. Type: string (or Expression with resultType string).
        :param 'LinkedServiceReferenceResponse' s3_linked_service_name: The name of the Amazon S3 linked service which will be used for the unload operation when copying from the Amazon Redshift source.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "s3_linked_service_name", s3_linked_service_name)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Any:
        """
        The bucket of the interim Amazon S3 which will be used to store the unloaded data from Amazon Redshift source. The bucket must be in the same region as the Amazon Redshift source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="s3LinkedServiceName")
    def s3_linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        The name of the Amazon S3 linked service which will be used for the unload operation when copying from the Amazon Redshift source.
        """
        return pulumi.get(self, "s3_linked_service_name")


@pulumi.output_type
class RelationalSourceResponse(dict):
    """
    A copy activity source for various relational databases.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RelationalSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RelationalSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RelationalSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity source for various relational databases.
        :param str type: Copy source type.
               Expected value is 'RelationalSource'.
        :param Any query: Database query. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'RelationalSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'RelationalSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        Database query. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class RelationalTableDatasetResponse(dict):
    """
    The relational table dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"
        elif key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RelationalTableDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RelationalTableDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RelationalTableDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None,
                 table_name: Optional[Any] = None):
        """
        The relational table dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'RelationalTable'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        :param Any table_name: The relational table name. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'RelationalTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'RelationalTable'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[Any]:
        """
        The relational table name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "table_name")


@pulumi.output_type
class ResponsysLinkedServiceResponse(dict):
    """
    Responsys linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "useEncryptedEndpoints":
            suggest = "use_encrypted_endpoints"
        elif key == "useHostVerification":
            suggest = "use_host_verification"
        elif key == "usePeerVerification":
            suggest = "use_peer_verification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponsysLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponsysLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponsysLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Any,
                 endpoint: Any,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 client_secret: Optional[Any] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 use_encrypted_endpoints: Optional[Any] = None,
                 use_host_verification: Optional[Any] = None,
                 use_peer_verification: Optional[Any] = None):
        """
        Responsys linked service.
        :param Any client_id: The client ID associated with the Responsys application. Type: string (or Expression with resultType string).
        :param Any endpoint: The endpoint of the Responsys server.
        :param str type: Type of linked service.
               Expected value is 'Responsys'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] client_secret: The client secret associated with the Responsys application. Type: string (or Expression with resultType string).
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Any use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true. Type: boolean (or Expression with resultType boolean).
        :param Any use_host_verification: Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true. Type: boolean (or Expression with resultType boolean).
        :param Any use_peer_verification: Specifies whether to verify the identity of the server when connecting over SSL. The default value is true. Type: boolean (or Expression with resultType boolean).
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "type", 'Responsys')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if use_encrypted_endpoints is not None:
            pulumi.set(__self__, "use_encrypted_endpoints", use_encrypted_endpoints)
        if use_host_verification is not None:
            pulumi.set(__self__, "use_host_verification", use_host_verification)
        if use_peer_verification is not None:
            pulumi.set(__self__, "use_peer_verification", use_peer_verification)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Any:
        """
        The client ID associated with the Responsys application. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter
    def endpoint(self) -> Any:
        """
        The endpoint of the Responsys server.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Responsys'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[Any]:
        """
        The client secret associated with the Responsys application. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="useEncryptedEndpoints")
    def use_encrypted_endpoints(self) -> Optional[Any]:
        """
        Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "use_encrypted_endpoints")

    @property
    @pulumi.getter(name="useHostVerification")
    def use_host_verification(self) -> Optional[Any]:
        """
        Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "use_host_verification")

    @property
    @pulumi.getter(name="usePeerVerification")
    def use_peer_verification(self) -> Optional[Any]:
        """
        Specifies whether to verify the identity of the server when connecting over SSL. The default value is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "use_peer_verification")


@pulumi.output_type
class ResponsysObjectDatasetResponse(dict):
    """
    Responsys dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceName":
            suggest = "linked_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponsysObjectDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponsysObjectDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponsysObjectDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_name: 'outputs.LinkedServiceReferenceResponse',
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 structure: Optional[Any] = None):
        """
        Responsys dataset.
        :param 'LinkedServiceReferenceResponse' linked_service_name: Linked service reference.
        :param str type: Type of dataset.
               Expected value is 'ResponsysObject'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param str description: Dataset description.
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'ResponsysObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> 'outputs.LinkedServiceReferenceResponse':
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of dataset.
        Expected value is 'ResponsysObject'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")


@pulumi.output_type
class ResponsysSourceResponse(dict):
    """
    A copy activity Responsys source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRetryCount":
            suggest = "source_retry_count"
        elif key == "sourceRetryWait":
            suggest = "source_retry_wait"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponsysSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponsysSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponsysSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Responsys source.
        :param str type: Copy source type.
               Expected value is 'ResponsysSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'ResponsysSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Copy source type.
        Expected value is 'ResponsysSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")


@pulumi.output_type
class RetryPolicyResponse(dict):
    """
    Execution policy for an activity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalInSeconds":
            suggest = "interval_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RetryPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RetryPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RetryPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[Any] = None,
                 interval_in_seconds: Optional[int] = None):
        """
        Execution policy for an activity.
        :param Any count: Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
        :param int interval_in_seconds: Interval between retries in seconds. Default is 30.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)

    @property
    @pulumi.getter
    def count(self) -> Optional[Any]:
        """
        Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[int]:
        """
        Interval between retries in seconds. Default is 30.
        """
        return pulumi.get(self, "interval_in_seconds")


@pulumi.output_type
class SSISAccessCredentialResponse(dict):
    """
    SSIS access credential.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SSISAccessCredentialResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SSISAccessCredentialResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SSISAccessCredentialResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain: Any,
                 password: Any,
                 user_name: Any):
        """
        SSIS access credential.
        :param Any domain: Domain for windows authentication.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: Password for windows authentication.
        :param Any user_name: UseName for windows authentication.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def domain(self) -> Any:
        """
        Domain for windows authentication.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def password(self) -> Any:
        """
        Password for windows authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Any:
        """
        UseName for windows authentication.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class SSISExecutionCredentialResponse(dict):
    """
    SSIS package execution credential.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SSISExecutionCredentialResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SSISExecutionCredentialResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SSISExecutionCredentialResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain: Any,
                 password: 'outputs.SecureStringResponse',
                 user_name: Any):
        """
        SSIS package execution credential.
        :param Any domain: Domain for windows authentication.
        :param 'SecureStringResponse' password: Password for windows authentication.
        :param Any user_name: UseName for windows authentication.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def domain(self) -> Any:
        """
        Domain for windows authentication.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def password(self) -> 'outputs.SecureStringResponse':
        """
        Password for windows authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Any:
        """
        UseName for windows authentication.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class SSISExecutionParameterResponse(dict):
    """
    SSIS execution parameter.
    """
    def __init__(__self__, *,
                 value: Any):
        """
        SSIS execution parameter.
        :param Any value: SSIS package execution parameter value. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> Any:
        """
        SSIS package execution parameter value. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SSISLogLocationResponse(dict):
    """
    SSIS package execution log location
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logPath":
            suggest = "log_path"
        elif key == "accessCredential":
            suggest = "access_credential"
        elif key == "logRefreshInterval":
            suggest = "log_refresh_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SSISLogLocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SSISLogLocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SSISLogLocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_path: Any,
                 type: str,
                 access_credential: Optional['outputs.SSISAccessCredentialResponse'] = None,
                 log_refresh_interval: Optional[Any] = None):
        """
        SSIS package execution log location
        :param Any log_path: The SSIS package execution log path. Type: string (or Expression with resultType string).
        :param str type: The type of SSIS log location.
        :param 'SSISAccessCredentialResponse' access_credential: The package execution log access credential.
        :param Any log_refresh_interval: Specifies the interval to refresh log. The default interval is 5 minutes. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "log_path", log_path)
        pulumi.set(__self__, "type", type)
        if access_credential is not None:
            pulumi.set(__self__, "access_credential", access_credential)
        if log_refresh_interval is not None:
            pulumi.set(__self__, "log_refresh_interval", log_refresh_interval)

    @property
    @pulumi.getter(name="logPath")
    def log_path(self) -> Any:
        """
        The SSIS package execution log path. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "log_path")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of SSIS log location.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="accessCredential")
    def access_credential(self) -> Optional['outputs.SSISAccessCredentialResponse']:
        """
        The package execution log access credential.
        """
        return pulumi.get(self, "access_credential")

    @property
    @pulumi.getter(name="logRefreshInterval")
    def log_refresh_interval(self) -> Optional[Any]:
        """
        Specifies the interval to refresh log. The default interval is 5 minutes. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "log_refresh_interval")


@pulumi.output_type
class SSISPackageLocationResponse(dict):
    """
    SSIS package location.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "packagePath":
            suggest = "package_path"
        elif key == "accessCredential":
            suggest = "access_credential"
        elif key == "configurationPath":
            suggest = "configuration_path"
        elif key == "packagePassword":
            suggest = "package_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SSISPackageLocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SSISPackageLocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SSISPackageLocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 package_path: Any,
                 access_credential: Optional['outputs.SSISAccessCredentialResponse'] = None,
                 configuration_path: Optional[Any] = None,
                 package_password: Optional[Any] = None,
                 type: Optional[str] = None):
        """
        SSIS package location.
        :param Any package_path: The SSIS package path. Type: string (or Expression with resultType string).
        :param 'SSISAccessCredentialResponse' access_credential: The package access credential.
        :param Any configuration_path: The configuration file of the package execution. Type: string (or Expression with resultType string).
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] package_password: Password of the package.
        :param str type: The type of SSIS package location.
        """
        pulumi.set(__self__, "package_path", package_path)
        if access_credential is not None:
            pulumi.set(__self__, "access_credential", access_credential)
        if configuration_path is not None:
            pulumi.set(__self__, "configuration_path", configuration_path)
        if package_password is not None:
            pulumi.set(__self__, "package_password", package_password)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="packagePath")
    def package_path(self) -> Any:
        """
        The SSIS package path. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "package_path")

    @property
    @pulumi.getter(name="accessCredential")
    def access_credential(self) -> Optional['outputs.SSISAccessCredentialResponse']:
        """
        The package access credential.
        """
        return pulumi.get(self, "access_credential")

    @property
    @pulumi.getter(name="configurationPath")
    def configuration_path(self) -> Optional[Any]:
        """
        The configuration file of the package execution. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "configuration_path")

    @property
    @pulumi.getter(name="packagePassword")
    def package_password(self) -> Optional[Any]:
        """
        Password of the package.
        """
        return pulumi.get(self, "package_password")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of SSIS package location.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SSISPropertyOverrideResponse(dict):
    """
    SSIS property override.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isSensitive":
            suggest = "is_sensitive"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SSISPropertyOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SSISPropertyOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SSISPropertyOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: Any,
                 is_sensitive: Optional[bool] = None):
        """
        SSIS property override.
        :param Any value: SSIS package property override value. Type: string (or Expression with resultType string).
        :param bool is_sensitive: Whether SSIS package property override value is sensitive data. Value will be encrypted in SSISDB if it is true
        """
        pulumi.set(__self__, "value", value)
        if is_sensitive is not None:
            pulumi.set(__self__, "is_sensitive", is_sensitive)

    @property
    @pulumi.getter
    def value(self) -> Any:
        """
        SSIS package property override value. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="isSensitive")
    def is_sensitive(self) -> Optional[bool]:
        """
        Whether SSIS package property override value is sensitive data. Value will be encrypted in SSISDB if it is true
        """
        return pulumi.get(self, "is_sensitive")


@pulumi.output_type
class SalesforceLinkedServiceResponse(dict):
    """
    Linked service for Salesforce.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "environmentUrl":
            suggest = "environment_url"
        elif key == "securityToken":
            suggest = "security_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SalesforceLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SalesforceLinkedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SalesforceLinkedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 annotations: Optional[Sequence[Any]] = None,
                 connect_via: Optional['outputs.IntegrationRuntimeReferenceResponse'] = None,
                 description: Optional[str] = None,
                 encrypted_credential: Optional[Any] = None,
                 environment_url: Optional[Any] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']] = None,
                 password: Optional[Any] = None,
                 security_token: Optional[Any] = None,
                 username: Optional[Any] = None):
        """
        Linked service for Salesforce.
        :param str type: Type of linked service.
               Expected value is 'Salesforce'.
        :param Sequence[Any] annotations: List of tags that can be used for describing the Dataset.
        :param 'IntegrationRuntimeReferenceResponse' connect_via: The integration runtime reference.
        :param str description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Any environment_url: The URL of Salesforce instance. Default is 'https://login.salesforce.com'. To copy data from sandbox, specify 'https://test.salesforce.com'. To copy data from custom domain, specify, for example, 'https://[domain].my.salesforce.com'. Type: string (or Expression with resultType string).
        :param Mapping[str, 'ParameterSpecificationResponse'] parameters: Parameters for linked service.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] password: The password for Basic authentication of the Salesforce instance.
        :param Union['AzureKeyVaultSecretReferenceResponse', 'SecureStringResponse'] security_token: The security token is required to remotely access Salesforce instance.
        :param Any username: The username for Basic authentication of the Salesforce instance. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "type", 'Salesforce')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if environment_url is not None:
            pulumi.set(__self__, "environment_url", environment_url)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if security_token is not None:
            pulumi.set(__self__, "security_token", security_token)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of linked service.
        Expected value is 'Salesforce'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.IntegrationRuntimeReferenceResponse']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter(name="environmentUrl")
    def environment_url(self) -> Optional[Any]:
        """
        The URL of Salesforce instance. Default is 'https://login.salesforce.com'. To copy data from sandbox, specify 'https://test.salesforce.com'. To copy data from custom domain, specify, for example, 'https://[domain].my.salesforce.com'. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "environment_url")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> Optional[Any]:
        """
        The password for Basic authentication of the Salesforce instance.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="securityToken")
    def security_token(self) -> Optional[Any]:
        """
        The security token is required to remotely access Salesforce instance.
        """
        return pulumi.get(self, "security_token")

    @property
    @pulumi.getter
    def username(self) -> Optional[Any]:
        """
        The username for Basic authentication of the Salesforce instance. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SalesforceMarketingCloudLinkedServiceResponse(dict):
    """
    Salesforce Marketing Cloud linked service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "connectVia":
            suggest = "connect_via"
        elif key == "encryptedCredential":
            suggest = "encrypted_credential"
        elif key == "useEncryptedEndpoints":
            suggest = "use_encrypted_endpoints"
        elif key == "useHostVerification":
            suggest = "use_host_verification"
        elif key == "usePeerVerification":
            suggest = "use_peer_verification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SalesforceMarketingCloudLinkedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> An