# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AddRemoveIncrementalNamedPartitionScalingMechanismArgs',
    'ApplicationHealthPolicyArgs',
    'ApplicationTypeVersionsCleanupPolicyArgs',
    'ApplicationUpgradePolicyArgs',
    'ApplicationUserAssignedIdentityArgs',
    'AveragePartitionLoadScalingTriggerArgs',
    'AverageServiceLoadScalingTriggerArgs',
    'AzureActiveDirectoryArgs',
    'ClientCertificateArgs',
    'EndpointRangeDescriptionArgs',
    'FrontendConfigurationArgs',
    'IPTagArgs',
    'LoadBalancingRuleArgs',
    'ManagedIdentityArgs',
    'NamedPartitionSchemeArgs',
    'NetworkSecurityRuleArgs',
    'NodeTypeSkuArgs',
    'PartitionInstanceCountScaleMechanismArgs',
    'RollingUpgradeMonitoringPolicyArgs',
    'ScalingPolicyArgs',
    'ServiceCorrelationArgs',
    'ServiceLoadMetricArgs',
    'ServicePlacementInvalidDomainPolicyArgs',
    'ServicePlacementNonPartiallyPlaceServicePolicyArgs',
    'ServicePlacementPreferPrimaryDomainPolicyArgs',
    'ServicePlacementRequireDomainDistributionPolicyArgs',
    'ServicePlacementRequiredDomainPolicyArgs',
    'ServiceTypeHealthPolicyArgs',
    'SettingsParameterDescriptionArgs',
    'SettingsSectionDescriptionArgs',
    'SingletonPartitionSchemeArgs',
    'SkuArgs',
    'StatefulServicePropertiesArgs',
    'StatelessServicePropertiesArgs',
    'SubResourceArgs',
    'UniformInt64RangePartitionSchemeArgs',
    'VMSSExtensionArgs',
    'VaultCertificateArgs',
    'VaultSecretGroupArgs',
    'VmManagedIdentityArgs',
]

@pulumi.input_type
class AddRemoveIncrementalNamedPartitionScalingMechanismArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 max_partition_count: pulumi.Input[int],
                 min_partition_count: pulumi.Input[int],
                 scale_increment: pulumi.Input[int]):
        """
        Represents a scaling mechanism for adding or removing named partitions of a stateless service. Partition names are in the format '0','1'...'N-1'.
        :param pulumi.Input[str] kind: Enumerates the ways that a service can be partitioned.
               Expected value is 'AddRemoveIncrementalNamedPartition'.
        :param pulumi.Input[int] max_partition_count: Maximum number of named partitions of the service.
        :param pulumi.Input[int] min_partition_count: Minimum number of named partitions of the service.
        :param pulumi.Input[int] scale_increment: The number of instances to add or remove during a scaling operation.
        """
        pulumi.set(__self__, "kind", 'AddRemoveIncrementalNamedPartition')
        pulumi.set(__self__, "max_partition_count", max_partition_count)
        pulumi.set(__self__, "min_partition_count", min_partition_count)
        pulumi.set(__self__, "scale_increment", scale_increment)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        Enumerates the ways that a service can be partitioned.
        Expected value is 'AddRemoveIncrementalNamedPartition'.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="maxPartitionCount")
    def max_partition_count(self) -> pulumi.Input[int]:
        """
        Maximum number of named partitions of the service.
        """
        return pulumi.get(self, "max_partition_count")

    @max_partition_count.setter
    def max_partition_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_partition_count", value)

    @property
    @pulumi.getter(name="minPartitionCount")
    def min_partition_count(self) -> pulumi.Input[int]:
        """
        Minimum number of named partitions of the service.
        """
        return pulumi.get(self, "min_partition_count")

    @min_partition_count.setter
    def min_partition_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_partition_count", value)

    @property
    @pulumi.getter(name="scaleIncrement")
    def scale_increment(self) -> pulumi.Input[int]:
        """
        The number of instances to add or remove during a scaling operation.
        """
        return pulumi.get(self, "scale_increment")

    @scale_increment.setter
    def scale_increment(self, value: pulumi.Input[int]):
        pulumi.set(self, "scale_increment", value)


@pulumi.input_type
class ApplicationHealthPolicyArgs:
    def __init__(__self__, *,
                 consider_warning_as_error: pulumi.Input[bool],
                 max_percent_unhealthy_deployed_applications: pulumi.Input[int],
                 default_service_type_health_policy: Optional[pulumi.Input['ServiceTypeHealthPolicyArgs']] = None,
                 service_type_health_policy_map: Optional[pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeHealthPolicyArgs']]]] = None):
        """
        Defines a health policy used to evaluate the health of an application or one of its children entities.

        :param pulumi.Input[bool] consider_warning_as_error: Indicates whether warnings are treated with the same severity as errors.
        :param pulumi.Input[int] max_percent_unhealthy_deployed_applications: The maximum allowed percentage of unhealthy deployed applications. Allowed values are Byte values from zero to 100.
               The percentage represents the maximum tolerated percentage of deployed applications that can be unhealthy before the application is considered in error.
               This is calculated by dividing the number of unhealthy deployed applications over the number of nodes where the application is currently deployed on in the cluster.
               The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
        :param pulumi.Input['ServiceTypeHealthPolicyArgs'] default_service_type_health_policy: The health policy used by default to evaluate the health of a service type.
        :param pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeHealthPolicyArgs']]] service_type_health_policy_map: The map with service type health policy per service type name. The map is empty by default.
        """
        pulumi.set(__self__, "consider_warning_as_error", consider_warning_as_error)
        pulumi.set(__self__, "max_percent_unhealthy_deployed_applications", max_percent_unhealthy_deployed_applications)
        if default_service_type_health_policy is not None:
            pulumi.set(__self__, "default_service_type_health_policy", default_service_type_health_policy)
        if service_type_health_policy_map is not None:
            pulumi.set(__self__, "service_type_health_policy_map", service_type_health_policy_map)

    @property
    @pulumi.getter(name="considerWarningAsError")
    def consider_warning_as_error(self) -> pulumi.Input[bool]:
        """
        Indicates whether warnings are treated with the same severity as errors.
        """
        return pulumi.get(self, "consider_warning_as_error")

    @consider_warning_as_error.setter
    def consider_warning_as_error(self, value: pulumi.Input[bool]):
        pulumi.set(self, "consider_warning_as_error", value)

    @property
    @pulumi.getter(name="maxPercentUnhealthyDeployedApplications")
    def max_percent_unhealthy_deployed_applications(self) -> pulumi.Input[int]:
        """
        The maximum allowed percentage of unhealthy deployed applications. Allowed values are Byte values from zero to 100.
        The percentage represents the maximum tolerated percentage of deployed applications that can be unhealthy before the application is considered in error.
        This is calculated by dividing the number of unhealthy deployed applications over the number of nodes where the application is currently deployed on in the cluster.
        The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
        """
        return pulumi.get(self, "max_percent_unhealthy_deployed_applications")

    @max_percent_unhealthy_deployed_applications.setter
    def max_percent_unhealthy_deployed_applications(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_percent_unhealthy_deployed_applications", value)

    @property
    @pulumi.getter(name="defaultServiceTypeHealthPolicy")
    def default_service_type_health_policy(self) -> Optional[pulumi.Input['ServiceTypeHealthPolicyArgs']]:
        """
        The health policy used by default to evaluate the health of a service type.
        """
        return pulumi.get(self, "default_service_type_health_policy")

    @default_service_type_health_policy.setter
    def default_service_type_health_policy(self, value: Optional[pulumi.Input['ServiceTypeHealthPolicyArgs']]):
        pulumi.set(self, "default_service_type_health_policy", value)

    @property
    @pulumi.getter(name="serviceTypeHealthPolicyMap")
    def service_type_health_policy_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeHealthPolicyArgs']]]]:
        """
        The map with service type health policy per service type name. The map is empty by default.
        """
        return pulumi.get(self, "service_type_health_policy_map")

    @service_type_health_policy_map.setter
    def service_type_health_policy_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeHealthPolicyArgs']]]]):
        pulumi.set(self, "service_type_health_policy_map", value)


@pulumi.input_type
class ApplicationTypeVersionsCleanupPolicyArgs:
    def __init__(__self__, *,
                 max_unused_versions_to_keep: pulumi.Input[int]):
        """
        The policy used to clean up unused versions. When the policy is not specified explicitly, the default unused application versions to keep will be 3.
        :param pulumi.Input[int] max_unused_versions_to_keep: Number of unused versions per application type to keep.
        """
        pulumi.set(__self__, "max_unused_versions_to_keep", max_unused_versions_to_keep)

    @property
    @pulumi.getter(name="maxUnusedVersionsToKeep")
    def max_unused_versions_to_keep(self) -> pulumi.Input[int]:
        """
        Number of unused versions per application type to keep.
        """
        return pulumi.get(self, "max_unused_versions_to_keep")

    @max_unused_versions_to_keep.setter
    def max_unused_versions_to_keep(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_unused_versions_to_keep", value)


@pulumi.input_type
class ApplicationUpgradePolicyArgs:
    def __init__(__self__, *,
                 application_health_policy: Optional[pulumi.Input['ApplicationHealthPolicyArgs']] = None,
                 force_restart: Optional[pulumi.Input[bool]] = None,
                 instance_close_delay_duration: Optional[pulumi.Input[float]] = None,
                 recreate_application: Optional[pulumi.Input[bool]] = None,
                 rolling_upgrade_monitoring_policy: Optional[pulumi.Input['RollingUpgradeMonitoringPolicyArgs']] = None,
                 upgrade_mode: Optional[pulumi.Input[Union[str, 'RollingUpgradeMode']]] = None,
                 upgrade_replica_set_check_timeout: Optional[pulumi.Input[float]] = None):
        """
        Describes the policy for a monitored application upgrade.
        :param pulumi.Input['ApplicationHealthPolicyArgs'] application_health_policy: Defines a health policy used to evaluate the health of an application or one of its children entities.
        :param pulumi.Input[bool] force_restart: If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
        :param pulumi.Input[float] instance_close_delay_duration: Duration in seconds, to wait before a stateless instance is closed, to allow the active requests to drain gracefully. This would be effective when the instance is closing during the application/cluster upgrade, only for those instances which have a non-zero delay duration configured in the service description.
        :param pulumi.Input[bool] recreate_application: Determines whether the application should be recreated on update. If value=true, the rest of the upgrade policy parameters are not allowed.
        :param pulumi.Input['RollingUpgradeMonitoringPolicyArgs'] rolling_upgrade_monitoring_policy: The policy used for monitoring the application upgrade
        :param pulumi.Input[Union[str, 'RollingUpgradeMode']] upgrade_mode: The mode used to monitor health during a rolling upgrade. The values are Monitored, and UnmonitoredAuto.
        :param pulumi.Input[float] upgrade_replica_set_check_timeout: The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
        """
        if application_health_policy is not None:
            pulumi.set(__self__, "application_health_policy", application_health_policy)
        if force_restart is not None:
            pulumi.set(__self__, "force_restart", force_restart)
        if instance_close_delay_duration is not None:
            pulumi.set(__self__, "instance_close_delay_duration", instance_close_delay_duration)
        if recreate_application is not None:
            pulumi.set(__self__, "recreate_application", recreate_application)
        if rolling_upgrade_monitoring_policy is not None:
            pulumi.set(__self__, "rolling_upgrade_monitoring_policy", rolling_upgrade_monitoring_policy)
        if upgrade_mode is not None:
            pulumi.set(__self__, "upgrade_mode", upgrade_mode)
        if upgrade_replica_set_check_timeout is not None:
            pulumi.set(__self__, "upgrade_replica_set_check_timeout", upgrade_replica_set_check_timeout)

    @property
    @pulumi.getter(name="applicationHealthPolicy")
    def application_health_policy(self) -> Optional[pulumi.Input['ApplicationHealthPolicyArgs']]:
        """
        Defines a health policy used to evaluate the health of an application or one of its children entities.
        """
        return pulumi.get(self, "application_health_policy")

    @application_health_policy.setter
    def application_health_policy(self, value: Optional[pulumi.Input['ApplicationHealthPolicyArgs']]):
        pulumi.set(self, "application_health_policy", value)

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
        """
        return pulumi.get(self, "force_restart")

    @force_restart.setter
    def force_restart(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_restart", value)

    @property
    @pulumi.getter(name="instanceCloseDelayDuration")
    def instance_close_delay_duration(self) -> Optional[pulumi.Input[float]]:
        """
        Duration in seconds, to wait before a stateless instance is closed, to allow the active requests to drain gracefully. This would be effective when the instance is closing during the application/cluster upgrade, only for those instances which have a non-zero delay duration configured in the service description.
        """
        return pulumi.get(self, "instance_close_delay_duration")

    @instance_close_delay_duration.setter
    def instance_close_delay_duration(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "instance_close_delay_duration", value)

    @property
    @pulumi.getter(name="recreateApplication")
    def recreate_application(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether the application should be recreated on update. If value=true, the rest of the upgrade policy parameters are not allowed.
        """
        return pulumi.get(self, "recreate_application")

    @recreate_application.setter
    def recreate_application(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "recreate_application", value)

    @property
    @pulumi.getter(name="rollingUpgradeMonitoringPolicy")
    def rolling_upgrade_monitoring_policy(self) -> Optional[pulumi.Input['RollingUpgradeMonitoringPolicyArgs']]:
        """
        The policy used for monitoring the application upgrade
        """
        return pulumi.get(self, "rolling_upgrade_monitoring_policy")

    @rolling_upgrade_monitoring_policy.setter
    def rolling_upgrade_monitoring_policy(self, value: Optional[pulumi.Input['RollingUpgradeMonitoringPolicyArgs']]):
        pulumi.set(self, "rolling_upgrade_monitoring_policy", value)

    @property
    @pulumi.getter(name="upgradeMode")
    def upgrade_mode(self) -> Optional[pulumi.Input[Union[str, 'RollingUpgradeMode']]]:
        """
        The mode used to monitor health during a rolling upgrade. The values are Monitored, and UnmonitoredAuto.
        """
        return pulumi.get(self, "upgrade_mode")

    @upgrade_mode.setter
    def upgrade_mode(self, value: Optional[pulumi.Input[Union[str, 'RollingUpgradeMode']]]):
        pulumi.set(self, "upgrade_mode", value)

    @property
    @pulumi.getter(name="upgradeReplicaSetCheckTimeout")
    def upgrade_replica_set_check_timeout(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
        """
        return pulumi.get(self, "upgrade_replica_set_check_timeout")

    @upgrade_replica_set_check_timeout.setter
    def upgrade_replica_set_check_timeout(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "upgrade_replica_set_check_timeout", value)


@pulumi.input_type
class ApplicationUserAssignedIdentityArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 principal_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The friendly name of user assigned identity.
        :param pulumi.Input[str] principal_id: The principal id of user assigned identity.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The friendly name of user assigned identity.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[str]:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal_id", value)


@pulumi.input_type
class AveragePartitionLoadScalingTriggerArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 lower_load_threshold: pulumi.Input[float],
                 metric_name: pulumi.Input[str],
                 scale_interval: pulumi.Input[str],
                 upper_load_threshold: pulumi.Input[float]):
        """
        Represents a scaling trigger related to an average load of a metric/resource of a partition.
        :param pulumi.Input[str] kind: Enumerates the ways that a service can be partitioned.
               Expected value is 'AveragePartitionLoadTrigger'.
        :param pulumi.Input[float] lower_load_threshold: The lower limit of the load below which a scale in operation should be performed.
        :param pulumi.Input[str] metric_name: The name of the metric for which usage should be tracked.
        :param pulumi.Input[str] scale_interval: The period in seconds on which a decision is made whether to scale or not. This property should come in ISO 8601 format "hh:mm:ss".
        :param pulumi.Input[float] upper_load_threshold: The upper limit of the load beyond which a scale out operation should be performed.
        """
        pulumi.set(__self__, "kind", 'AveragePartitionLoadTrigger')
        pulumi.set(__self__, "lower_load_threshold", lower_load_threshold)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "scale_interval", scale_interval)
        pulumi.set(__self__, "upper_load_threshold", upper_load_threshold)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        Enumerates the ways that a service can be partitioned.
        Expected value is 'AveragePartitionLoadTrigger'.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="lowerLoadThreshold")
    def lower_load_threshold(self) -> pulumi.Input[float]:
        """
        The lower limit of the load below which a scale in operation should be performed.
        """
        return pulumi.get(self, "lower_load_threshold")

    @lower_load_threshold.setter
    def lower_load_threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "lower_load_threshold", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        The name of the metric for which usage should be tracked.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter(name="scaleInterval")
    def scale_interval(self) -> pulumi.Input[str]:
        """
        The period in seconds on which a decision is made whether to scale or not. This property should come in ISO 8601 format "hh:mm:ss".
        """
        return pulumi.get(self, "scale_interval")

    @scale_interval.setter
    def scale_interval(self, value: pulumi.Input[str]):
        pulumi.set(self, "scale_interval", value)

    @property
    @pulumi.getter(name="upperLoadThreshold")
    def upper_load_threshold(self) -> pulumi.Input[float]:
        """
        The upper limit of the load beyond which a scale out operation should be performed.
        """
        return pulumi.get(self, "upper_load_threshold")

    @upper_load_threshold.setter
    def upper_load_threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "upper_load_threshold", value)


@pulumi.input_type
class AverageServiceLoadScalingTriggerArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 lower_load_threshold: pulumi.Input[float],
                 metric_name: pulumi.Input[str],
                 scale_interval: pulumi.Input[str],
                 upper_load_threshold: pulumi.Input[float],
                 use_only_primary_load: pulumi.Input[bool]):
        """
        Represents a scaling policy related to an average load of a metric/resource of a service.
        :param pulumi.Input[str] kind: Enumerates the ways that a service can be partitioned.
               Expected value is 'AverageServiceLoadTrigger'.
        :param pulumi.Input[float] lower_load_threshold: The lower limit of the load below which a scale in operation should be performed.
        :param pulumi.Input[str] metric_name: The name of the metric for which usage should be tracked.
        :param pulumi.Input[str] scale_interval: The period in seconds on which a decision is made whether to scale or not. This property should come in ISO 8601 format "hh:mm:ss".
        :param pulumi.Input[float] upper_load_threshold: The upper limit of the load beyond which a scale out operation should be performed.
        :param pulumi.Input[bool] use_only_primary_load: Flag determines whether only the load of primary replica should be considered for scaling. If set to true, then trigger will only consider the load of primary replicas of stateful service. If set to false, trigger will consider load of all replicas. This parameter cannot be set to true for stateless service.
        """
        pulumi.set(__self__, "kind", 'AverageServiceLoadTrigger')
        pulumi.set(__self__, "lower_load_threshold", lower_load_threshold)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "scale_interval", scale_interval)
        pulumi.set(__self__, "upper_load_threshold", upper_load_threshold)
        pulumi.set(__self__, "use_only_primary_load", use_only_primary_load)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        Enumerates the ways that a service can be partitioned.
        Expected value is 'AverageServiceLoadTrigger'.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="lowerLoadThreshold")
    def lower_load_threshold(self) -> pulumi.Input[float]:
        """
        The lower limit of the load below which a scale in operation should be performed.
        """
        return pulumi.get(self, "lower_load_threshold")

    @lower_load_threshold.setter
    def lower_load_threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "lower_load_threshold", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        The name of the metric for which usage should be tracked.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter(name="scaleInterval")
    def scale_interval(self) -> pulumi.Input[str]:
        """
        The period in seconds on which a decision is made whether to scale or not. This property should come in ISO 8601 format "hh:mm:ss".
        """
        return pulumi.get(self, "scale_interval")

    @scale_interval.setter
    def scale_interval(self, value: pulumi.Input[str]):
        pulumi.set(self, "scale_interval", value)

    @property
    @pulumi.getter(name="upperLoadThreshold")
    def upper_load_threshold(self) -> pulumi.Input[float]:
        """
        The upper limit of the load beyond which a scale out operation should be performed.
        """
        return pulumi.get(self, "upper_load_threshold")

    @upper_load_threshold.setter
    def upper_load_threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "upper_load_threshold", value)

    @property
    @pulumi.getter(name="useOnlyPrimaryLoad")
    def use_only_primary_load(self) -> pulumi.Input[bool]:
        """
        Flag determines whether only the load of primary replica should be considered for scaling. If set to true, then trigger will only consider the load of primary replicas of stateful service. If set to false, trigger will consider load of all replicas. This parameter cannot be set to true for stateless service.
        """
        return pulumi.get(self, "use_only_primary_load")

    @use_only_primary_load.setter
    def use_only_primary_load(self, value: pulumi.Input[bool]):
        pulumi.set(self, "use_only_primary_load", value)


@pulumi.input_type
class AzureActiveDirectoryArgs:
    def __init__(__self__, *,
                 client_application: Optional[pulumi.Input[str]] = None,
                 cluster_application: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        The settings to enable AAD authentication on the cluster.
        :param pulumi.Input[str] client_application: Azure active directory client application id.
        :param pulumi.Input[str] cluster_application: Azure active directory cluster application id.
        :param pulumi.Input[str] tenant_id: Azure active directory tenant id.
        """
        if client_application is not None:
            pulumi.set(__self__, "client_application", client_application)
        if cluster_application is not None:
            pulumi.set(__self__, "cluster_application", cluster_application)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientApplication")
    def client_application(self) -> Optional[pulumi.Input[str]]:
        """
        Azure active directory client application id.
        """
        return pulumi.get(self, "client_application")

    @client_application.setter
    def client_application(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_application", value)

    @property
    @pulumi.getter(name="clusterApplication")
    def cluster_application(self) -> Optional[pulumi.Input[str]]:
        """
        Azure active directory cluster application id.
        """
        return pulumi.get(self, "cluster_application")

    @cluster_application.setter
    def cluster_application(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_application", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure active directory tenant id.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class ClientCertificateArgs:
    def __init__(__self__, *,
                 is_admin: pulumi.Input[bool],
                 common_name: Optional[pulumi.Input[str]] = None,
                 issuer_thumbprint: Optional[pulumi.Input[str]] = None,
                 thumbprint: Optional[pulumi.Input[str]] = None):
        """
        Client certificate definition.
        :param pulumi.Input[bool] is_admin: Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
        :param pulumi.Input[str] common_name: Certificate common name.
        :param pulumi.Input[str] issuer_thumbprint: Issuer thumbprint for the certificate. Only used together with CommonName.
        :param pulumi.Input[str] thumbprint: Certificate thumbprint.
        """
        pulumi.set(__self__, "is_admin", is_admin)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if issuer_thumbprint is not None:
            pulumi.set(__self__, "issuer_thumbprint", issuer_thumbprint)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> pulumi.Input[bool]:
        """
        Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_admin", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate common name.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter(name="issuerThumbprint")
    def issuer_thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        Issuer thumbprint for the certificate. Only used together with CommonName.
        """
        return pulumi.get(self, "issuer_thumbprint")

    @issuer_thumbprint.setter
    def issuer_thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_thumbprint", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate thumbprint.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.input_type
class EndpointRangeDescriptionArgs:
    def __init__(__self__, *,
                 end_port: pulumi.Input[int],
                 start_port: pulumi.Input[int]):
        """
        Port range details
        :param pulumi.Input[int] end_port: End port of a range of ports
        :param pulumi.Input[int] start_port: Starting port of a range of ports
        """
        pulumi.set(__self__, "end_port", end_port)
        pulumi.set(__self__, "start_port", start_port)

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> pulumi.Input[int]:
        """
        End port of a range of ports
        """
        return pulumi.get(self, "end_port")

    @end_port.setter
    def end_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "end_port", value)

    @property
    @pulumi.getter(name="startPort")
    def start_port(self) -> pulumi.Input[int]:
        """
        Starting port of a range of ports
        """
        return pulumi.get(self, "start_port")

    @start_port.setter
    def start_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "start_port", value)


@pulumi.input_type
class FrontendConfigurationArgs:
    def __init__(__self__, *,
                 ip_address_type: Optional[pulumi.Input[Union[str, 'IPAddressType']]] = None,
                 load_balancer_backend_address_pool_id: Optional[pulumi.Input[str]] = None,
                 load_balancer_inbound_nat_pool_id: Optional[pulumi.Input[str]] = None):
        """
        Describes the frontend configurations for the node type.
        :param pulumi.Input[Union[str, 'IPAddressType']] ip_address_type: The IP address type of this frontend configuration. If omitted the default value is IPv4.
        :param pulumi.Input[str] load_balancer_backend_address_pool_id: The resource Id of the Load Balancer backend address pool that the VM instances of the node type are associated with. The format of the resource Id is '/subscriptions/<subscriptionId>/resourceGroups/<resourceGroupName>/providers/Microsoft.Network/loadBalancers/<loadBalancerName>/backendAddressPools/<backendAddressPoolName>'.
        :param pulumi.Input[str] load_balancer_inbound_nat_pool_id: The resource Id of the Load Balancer inbound NAT pool that the VM instances of the node type are associated with. The format of the resource Id is '/subscriptions/<subscriptionId>/resourceGroups/<resourceGroupName>/providers/Microsoft.Network/loadBalancers/<loadBalancerName>/inboundNatPools/<inboundNatPoolName>'.
        """
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if load_balancer_backend_address_pool_id is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pool_id", load_balancer_backend_address_pool_id)
        if load_balancer_inbound_nat_pool_id is not None:
            pulumi.set(__self__, "load_balancer_inbound_nat_pool_id", load_balancer_inbound_nat_pool_id)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[Union[str, 'IPAddressType']]]:
        """
        The IP address type of this frontend configuration. If omitted the default value is IPv4.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[Union[str, 'IPAddressType']]]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter(name="loadBalancerBackendAddressPoolId")
    def load_balancer_backend_address_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource Id of the Load Balancer backend address pool that the VM instances of the node type are associated with. The format of the resource Id is '/subscriptions/<subscriptionId>/resourceGroups/<resourceGroupName>/providers/Microsoft.Network/loadBalancers/<loadBalancerName>/backendAddressPools/<backendAddressPoolName>'.
        """
        return pulumi.get(self, "load_balancer_backend_address_pool_id")

    @load_balancer_backend_address_pool_id.setter
    def load_balancer_backend_address_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_backend_address_pool_id", value)

    @property
    @pulumi.getter(name="loadBalancerInboundNatPoolId")
    def load_balancer_inbound_nat_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource Id of the Load Balancer inbound NAT pool that the VM instances of the node type are associated with. The format of the resource Id is '/subscriptions/<subscriptionId>/resourceGroups/<resourceGroupName>/providers/Microsoft.Network/loadBalancers/<loadBalancerName>/inboundNatPools/<inboundNatPoolName>'.
        """
        return pulumi.get(self, "load_balancer_inbound_nat_pool_id")

    @load_balancer_inbound_nat_pool_id.setter
    def load_balancer_inbound_nat_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_inbound_nat_pool_id", value)


@pulumi.input_type
class IPTagArgs:
    def __init__(__self__, *,
                 ip_tag_type: pulumi.Input[str],
                 tag: pulumi.Input[str]):
        """
        IPTag associated with the object.
        :param pulumi.Input[str] ip_tag_type: The IP tag type.
        :param pulumi.Input[str] tag: The value of the IP tag.
        """
        pulumi.set(__self__, "ip_tag_type", ip_tag_type)
        pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="ipTagType")
    def ip_tag_type(self) -> pulumi.Input[str]:
        """
        The IP tag type.
        """
        return pulumi.get(self, "ip_tag_type")

    @ip_tag_type.setter
    def ip_tag_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_tag_type", value)

    @property
    @pulumi.getter
    def tag(self) -> pulumi.Input[str]:
        """
        The value of the IP tag.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: pulumi.Input[str]):
        pulumi.set(self, "tag", value)


@pulumi.input_type
class LoadBalancingRuleArgs:
    def __init__(__self__, *,
                 backend_port: pulumi.Input[int],
                 frontend_port: pulumi.Input[int],
                 probe_protocol: pulumi.Input[Union[str, 'ProbeProtocol']],
                 protocol: pulumi.Input[Union[str, 'Protocol']],
                 probe_port: Optional[pulumi.Input[int]] = None,
                 probe_request_path: Optional[pulumi.Input[str]] = None):
        """
        Describes a load balancing rule.
        :param pulumi.Input[int] backend_port: The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
        :param pulumi.Input[int] frontend_port: The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 1 and 65534.
        :param pulumi.Input[Union[str, 'ProbeProtocol']] probe_protocol: the reference to the load balancer probe used by the load balancing rule.
        :param pulumi.Input[Union[str, 'Protocol']] protocol: The reference to the transport protocol used by the load balancing rule.
        :param pulumi.Input[int] probe_port: The prob port used by the load balancing rule. Acceptable values are between 1 and 65535.
        :param pulumi.Input[str] probe_request_path: The probe request path. Only supported for HTTP/HTTPS probes.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "probe_protocol", probe_protocol)
        pulumi.set(__self__, "protocol", protocol)
        if probe_port is not None:
            pulumi.set(__self__, "probe_port", probe_port)
        if probe_request_path is not None:
            pulumi.set(__self__, "probe_request_path", probe_request_path)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> pulumi.Input[int]:
        """
        The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
        """
        return pulumi.get(self, "backend_port")

    @backend_port.setter
    def backend_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "backend_port", value)

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> pulumi.Input[int]:
        """
        The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 1 and 65534.
        """
        return pulumi.get(self, "frontend_port")

    @frontend_port.setter
    def frontend_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "frontend_port", value)

    @property
    @pulumi.getter(name="probeProtocol")
    def probe_protocol(self) -> pulumi.Input[Union[str, 'ProbeProtocol']]:
        """
        the reference to the load balancer probe used by the load balancing rule.
        """
        return pulumi.get(self, "probe_protocol")

    @probe_protocol.setter
    def probe_protocol(self, value: pulumi.Input[Union[str, 'ProbeProtocol']]):
        pulumi.set(self, "probe_protocol", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[Union[str, 'Protocol']]:
        """
        The reference to the transport protocol used by the load balancing rule.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[Union[str, 'Protocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="probePort")
    def probe_port(self) -> Optional[pulumi.Input[int]]:
        """
        The prob port used by the load balancing rule. Acceptable values are between 1 and 65535.
        """
        return pulumi.get(self, "probe_port")

    @probe_port.setter
    def probe_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "probe_port", value)

    @property
    @pulumi.getter(name="probeRequestPath")
    def probe_request_path(self) -> Optional[pulumi.Input[str]]:
        """
        The probe request path. Only supported for HTTP/HTTPS probes.
        """
        return pulumi.get(self, "probe_request_path")

    @probe_request_path.setter
    def probe_request_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "probe_request_path", value)


@pulumi.input_type
class ManagedIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ManagedIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Describes the managed identities for an Azure resource.
        :param pulumi.Input['ManagedIdentityType'] type: The type of managed identity for the resource.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form:
               '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ManagedIdentityType']]:
        """
        The type of managed identity for the resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ManagedIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form:
        '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class NamedPartitionSchemeArgs:
    def __init__(__self__, *,
                 names: pulumi.Input[Sequence[pulumi.Input[str]]],
                 partition_scheme: pulumi.Input[str]):
        """
        Describes the named partition scheme of the service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] names: Array for the names of the partitions.
        :param pulumi.Input[str] partition_scheme: Enumerates the ways that a service can be partitioned.
               Expected value is 'Named'.
        """
        pulumi.set(__self__, "names", names)
        pulumi.set(__self__, "partition_scheme", 'Named')

    @property
    @pulumi.getter
    def names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Array for the names of the partitions.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter(name="partitionScheme")
    def partition_scheme(self) -> pulumi.Input[str]:
        """
        Enumerates the ways that a service can be partitioned.
        Expected value is 'Named'.
        """
        return pulumi.get(self, "partition_scheme")

    @partition_scheme.setter
    def partition_scheme(self, value: pulumi.Input[str]):
        pulumi.set(self, "partition_scheme", value)


@pulumi.input_type
class NetworkSecurityRuleArgs:
    def __init__(__self__, *,
                 access: pulumi.Input[Union[str, 'Access']],
                 direction: pulumi.Input[Union[str, 'Direction']],
                 name: pulumi.Input[str],
                 priority: pulumi.Input[int],
                 protocol: pulumi.Input[Union[str, 'NsgProtocol']],
                 description: Optional[pulumi.Input[str]] = None,
                 destination_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 destination_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Describes a network security rule.
        :param pulumi.Input[Union[str, 'Access']] access: The network traffic is allowed or denied.
        :param pulumi.Input[Union[str, 'Direction']] direction: Network security rule direction.
        :param pulumi.Input[str] name: Network security rule name.
        :param pulumi.Input[int] priority: The priority of the rule. The value can be in the range 1000 to 3000. Values outside this range are reserved for Service Fabric ManagerCluster Resource Provider. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        :param pulumi.Input[Union[str, 'NsgProtocol']] protocol: Network protocol this rule applies to.
        :param pulumi.Input[str] description: Network security rule description.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_address_prefixes: The destination address prefixes. CIDR or destination IP ranges.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_port_ranges: The destination port ranges.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_address_prefixes: The CIDR or source IP ranges.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_port_ranges: The source port ranges.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "protocol", protocol)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_address_prefixes is not None:
            pulumi.set(__self__, "destination_address_prefixes", destination_address_prefixes)
        if destination_port_ranges is not None:
            pulumi.set(__self__, "destination_port_ranges", destination_port_ranges)
        if source_address_prefixes is not None:
            pulumi.set(__self__, "source_address_prefixes", source_address_prefixes)
        if source_port_ranges is not None:
            pulumi.set(__self__, "source_port_ranges", source_port_ranges)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Input[Union[str, 'Access']]:
        """
        The network traffic is allowed or denied.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: pulumi.Input[Union[str, 'Access']]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input[Union[str, 'Direction']]:
        """
        Network security rule direction.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[Union[str, 'Direction']]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Network security rule name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        The priority of the rule. The value can be in the range 1000 to 3000. Values outside this range are reserved for Service Fabric ManagerCluster Resource Provider. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[Union[str, 'NsgProtocol']]:
        """
        Network protocol this rule applies to.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[Union[str, 'NsgProtocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Network security rule description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationAddressPrefixes")
    def destination_address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The destination address prefixes. CIDR or destination IP ranges.
        """
        return pulumi.get(self, "destination_address_prefixes")

    @destination_address_prefixes.setter
    def destination_address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_address_prefixes", value)

    @property
    @pulumi.getter(name="destinationPortRanges")
    def destination_port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The destination port ranges.
        """
        return pulumi.get(self, "destination_port_ranges")

    @destination_port_ranges.setter
    def destination_port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_port_ranges", value)

    @property
    @pulumi.getter(name="sourceAddressPrefixes")
    def source_address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The CIDR or source IP ranges.
        """
        return pulumi.get(self, "source_address_prefixes")

    @source_address_prefixes.setter
    def source_address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_address_prefixes", value)

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The source port ranges.
        """
        return pulumi.get(self, "source_port_ranges")

    @source_port_ranges.setter
    def source_port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_port_ranges", value)


@pulumi.input_type
class NodeTypeSkuArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input[int],
                 name: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        Describes a node type sku.
        :param pulumi.Input[int] capacity: The number of nodes in the node type.<br /><br />If present in request it will override properties.vmInstanceCount.
        :param pulumi.Input[str] name: The sku name. <br /><br />Name is internally generated and is used in auto-scale scenarios.<br /> Property does not allow to be changed to other values than generated.<br /> To avoid deployment errors please omit the property.
        :param pulumi.Input[str] tier: Specifies the tier of the node type. <br /><br /> Possible Values:<br /> **Standard**
        """
        pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Input[int]:
        """
        The number of nodes in the node type.<br /><br />If present in request it will override properties.vmInstanceCount.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The sku name. <br /><br />Name is internally generated and is used in auto-scale scenarios.<br /> Property does not allow to be changed to other values than generated.<br /> To avoid deployment errors please omit the property.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the tier of the node type. <br /><br /> Possible Values:<br /> **Standard**
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class PartitionInstanceCountScaleMechanismArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 max_instance_count: pulumi.Input[int],
                 min_instance_count: pulumi.Input[int],
                 scale_increment: pulumi.Input[int]):
        """
        Represents a scaling mechanism for adding or removing instances of stateless service partition.
        :param pulumi.Input[str] kind: Enumerates the ways that a service can be partitioned.
               Expected value is 'ScalePartitionInstanceCount'.
        :param pulumi.Input[int] max_instance_count: Maximum number of instances of the partition.
        :param pulumi.Input[int] min_instance_count: Minimum number of instances of the partition.
        :param pulumi.Input[int] scale_increment: The number of instances to add or remove during a scaling operation.
        """
        pulumi.set(__self__, "kind", 'ScalePartitionInstanceCount')
        pulumi.set(__self__, "max_instance_count", max_instance_count)
        pulumi.set(__self__, "min_instance_count", min_instance_count)
        pulumi.set(__self__, "scale_increment", scale_increment)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        Enumerates the ways that a service can be partitioned.
        Expected value is 'ScalePartitionInstanceCount'.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> pulumi.Input[int]:
        """
        Maximum number of instances of the partition.
        """
        return pulumi.get(self, "max_instance_count")

    @max_instance_count.setter
    def max_instance_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_instance_count", value)

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> pulumi.Input[int]:
        """
        Minimum number of instances of the partition.
        """
        return pulumi.get(self, "min_instance_count")

    @min_instance_count.setter
    def min_instance_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_instance_count", value)

    @property
    @pulumi.getter(name="scaleIncrement")
    def scale_increment(self) -> pulumi.Input[int]:
        """
        The number of instances to add or remove during a scaling operation.
        """
        return pulumi.get(self, "scale_increment")

    @scale_increment.setter
    def scale_increment(self, value: pulumi.Input[int]):
        pulumi.set(self, "scale_increment", value)


@pulumi.input_type
class RollingUpgradeMonitoringPolicyArgs:
    def __init__(__self__, *,
                 failure_action: pulumi.Input[Union[str, 'FailureAction']],
                 health_check_retry_timeout: pulumi.Input[str],
                 health_check_stable_duration: pulumi.Input[str],
                 health_check_wait_duration: pulumi.Input[str],
                 upgrade_domain_timeout: pulumi.Input[str],
                 upgrade_timeout: pulumi.Input[str]):
        """
        The policy used for monitoring the application upgrade
        :param pulumi.Input[Union[str, 'FailureAction']] failure_action: The compensating action to perform when a Monitored upgrade encounters monitoring policy or health policy violations. Invalid indicates the failure action is invalid. Rollback specifies that the upgrade will start rolling back automatically. Manual indicates that the upgrade will switch to UnmonitoredManual upgrade mode.
        :param pulumi.Input[str] health_check_retry_timeout: The amount of time to retry health evaluation when the application or cluster is unhealthy before FailureAction is executed. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
        :param pulumi.Input[str] health_check_stable_duration: The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
        :param pulumi.Input[str] health_check_wait_duration: The amount of time to wait after completing an upgrade domain before applying health policies. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
        :param pulumi.Input[str] upgrade_domain_timeout: The amount of time each upgrade domain has to complete before FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
        :param pulumi.Input[str] upgrade_timeout: The amount of time the overall upgrade has to complete before FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
        """
        pulumi.set(__self__, "failure_action", failure_action)
        pulumi.set(__self__, "health_check_retry_timeout", health_check_retry_timeout)
        pulumi.set(__self__, "health_check_stable_duration", health_check_stable_duration)
        pulumi.set(__self__, "health_check_wait_duration", health_check_wait_duration)
        pulumi.set(__self__, "upgrade_domain_timeout", upgrade_domain_timeout)
        pulumi.set(__self__, "upgrade_timeout", upgrade_timeout)

    @property
    @pulumi.getter(name="failureAction")
    def failure_action(self) -> pulumi.Input[Union[str, 'FailureAction']]:
        """
        The compensating action to perform when a Monitored upgrade encounters monitoring policy or health policy violations. Invalid indicates the failure action is invalid. Rollback specifies that the upgrade will start rolling back automatically. Manual indicates that the upgrade will switch to UnmonitoredManual upgrade mode.
        """
        return pulumi.get(self, "failure_action")

    @failure_action.setter
    def failure_action(self, value: pulumi.Input[Union[str, 'FailureAction']]):
        pulumi.set(self, "failure_action", value)

    @property
    @pulumi.getter(name="healthCheckRetryTimeout")
    def health_check_retry_timeout(self) -> pulumi.Input[str]:
        """
        The amount of time to retry health evaluation when the application or cluster is unhealthy before FailureAction is executed. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
        """
        return pulumi.get(self, "health_check_retry_timeout")

    @health_check_retry_timeout.setter
    def health_check_retry_timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "health_check_retry_timeout", value)

    @property
    @pulumi.getter(name="healthCheckStableDuration")
    def health_check_stable_duration(self) -> pulumi.Input[str]:
        """
        The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
        """
        return pulumi.get(self, "health_check_stable_duration")

    @health_check_stable_duration.setter
    def health_check_stable_duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "health_check_stable_duration", value)

    @property
    @pulumi.getter(name="healthCheckWaitDuration")
    def health_check_wait_duration(self) -> pulumi.Input[str]:
        """
        The amount of time to wait after completing an upgrade domain before applying health policies. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
        """
        return pulumi.get(self, "health_check_wait_duration")

    @health_check_wait_duration.setter
    def health_check_wait_duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "health_check_wait_duration", value)

    @property
    @pulumi.getter(name="upgradeDomainTimeout")
    def upgrade_domain_timeout(self) -> pulumi.Input[str]:
        """
        The amount of time each upgrade domain has to complete before FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
        """
        return pulumi.get(self, "upgrade_domain_timeout")

    @upgrade_domain_timeout.setter
    def upgrade_domain_timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "upgrade_domain_timeout", value)

    @property
    @pulumi.getter(name="upgradeTimeout")
    def upgrade_timeout(self) -> pulumi.Input[str]:
        """
        The amount of time the overall upgrade has to complete before FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
        """
        return pulumi.get(self, "upgrade_timeout")

    @upgrade_timeout.setter
    def upgrade_timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "upgrade_timeout", value)


@pulumi.input_type
class ScalingPolicyArgs:
    def __init__(__self__, *,
                 scaling_mechanism: pulumi.Input[Union['AddRemoveIncrementalNamedPartitionScalingMechanismArgs', 'PartitionInstanceCountScaleMechanismArgs']],
                 scaling_trigger: pulumi.Input[Union['AveragePartitionLoadScalingTriggerArgs', 'AverageServiceLoadScalingTriggerArgs']]):
        """
        Specifies a metric to load balance a service during runtime.
        :param pulumi.Input[Union['AddRemoveIncrementalNamedPartitionScalingMechanismArgs', 'PartitionInstanceCountScaleMechanismArgs']] scaling_mechanism: Specifies the mechanism associated with this scaling policy
        :param pulumi.Input[Union['AveragePartitionLoadScalingTriggerArgs', 'AverageServiceLoadScalingTriggerArgs']] scaling_trigger: Specifies the trigger associated with this scaling policy.
        """
        pulumi.set(__self__, "scaling_mechanism", scaling_mechanism)
        pulumi.set(__self__, "scaling_trigger", scaling_trigger)

    @property
    @pulumi.getter(name="scalingMechanism")
    def scaling_mechanism(self) -> pulumi.Input[Union['AddRemoveIncrementalNamedPartitionScalingMechanismArgs', 'PartitionInstanceCountScaleMechanismArgs']]:
        """
        Specifies the mechanism associated with this scaling policy
        """
        return pulumi.get(self, "scaling_mechanism")

    @scaling_mechanism.setter
    def scaling_mechanism(self, value: pulumi.Input[Union['AddRemoveIncrementalNamedPartitionScalingMechanismArgs', 'PartitionInstanceCountScaleMechanismArgs']]):
        pulumi.set(self, "scaling_mechanism", value)

    @property
    @pulumi.getter(name="scalingTrigger")
    def scaling_trigger(self) -> pulumi.Input[Union['AveragePartitionLoadScalingTriggerArgs', 'AverageServiceLoadScalingTriggerArgs']]:
        """
        Specifies the trigger associated with this scaling policy.
        """
        return pulumi.get(self, "scaling_trigger")

    @scaling_trigger.setter
    def scaling_trigger(self, value: pulumi.Input[Union['AveragePartitionLoadScalingTriggerArgs', 'AverageServiceLoadScalingTriggerArgs']]):
        pulumi.set(self, "scaling_trigger", value)


@pulumi.input_type
class ServiceCorrelationArgs:
    def __init__(__self__, *,
                 scheme: pulumi.Input[Union[str, 'ServiceCorrelationScheme']],
                 service_name: pulumi.Input[str]):
        """
        Creates a particular correlation between services.
        :param pulumi.Input[Union[str, 'ServiceCorrelationScheme']] scheme: The ServiceCorrelationScheme which describes the relationship between this service and the service specified via ServiceName.
        :param pulumi.Input[str] service_name: The Arm Resource ID of the service that the correlation relationship is established with.
        """
        pulumi.set(__self__, "scheme", scheme)
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter
    def scheme(self) -> pulumi.Input[Union[str, 'ServiceCorrelationScheme']]:
        """
        The ServiceCorrelationScheme which describes the relationship between this service and the service specified via ServiceName.
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: pulumi.Input[Union[str, 'ServiceCorrelationScheme']]):
        pulumi.set(self, "scheme", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        The Arm Resource ID of the service that the correlation relationship is established with.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class ServiceLoadMetricArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 default_load: Optional[pulumi.Input[int]] = None,
                 primary_default_load: Optional[pulumi.Input[int]] = None,
                 secondary_default_load: Optional[pulumi.Input[int]] = None,
                 weight: Optional[pulumi.Input[Union[str, 'ServiceLoadMetricWeight']]] = None):
        """
        Specifies a metric to load balance a service during runtime.
        :param pulumi.Input[str] name: The name of the metric. If the service chooses to report load during runtime, the load metric name should match the name that is specified in Name exactly. Note that metric names are case sensitive.
        :param pulumi.Input[int] default_load: Used only for Stateless services. The default amount of load, as a number, that this service creates for this metric.
        :param pulumi.Input[int] primary_default_load: Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Primary replica.
        :param pulumi.Input[int] secondary_default_load: Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Secondary replica.
        :param pulumi.Input[Union[str, 'ServiceLoadMetricWeight']] weight: The service load metric relative weight, compared to other metrics configured for this service, as a number.
        """
        pulumi.set(__self__, "name", name)
        if default_load is not None:
            pulumi.set(__self__, "default_load", default_load)
        if primary_default_load is not None:
            pulumi.set(__self__, "primary_default_load", primary_default_load)
        if secondary_default_load is not None:
            pulumi.set(__self__, "secondary_default_load", secondary_default_load)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the metric. If the service chooses to report load during runtime, the load metric name should match the name that is specified in Name exactly. Note that metric names are case sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="defaultLoad")
    def default_load(self) -> Optional[pulumi.Input[int]]:
        """
        Used only for Stateless services. The default amount of load, as a number, that this service creates for this metric.
        """
        return pulumi.get(self, "default_load")

    @default_load.setter
    def default_load(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_load", value)

    @property
    @pulumi.getter(name="primaryDefaultLoad")
    def primary_default_load(self) -> Optional[pulumi.Input[int]]:
        """
        Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Primary replica.
        """
        return pulumi.get(self, "primary_default_load")

    @primary_default_load.setter
    def primary_default_load(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "primary_default_load", value)

    @property
    @pulumi.getter(name="secondaryDefaultLoad")
    def secondary_default_load(self) -> Optional[pulumi.Input[int]]:
        """
        Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Secondary replica.
        """
        return pulumi.get(self, "secondary_default_load")

    @secondary_default_load.setter
    def secondary_default_load(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "secondary_default_load", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[Union[str, 'ServiceLoadMetricWeight']]]:
        """
        The service load metric relative weight, compared to other metrics configured for this service, as a number.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[Union[str, 'ServiceLoadMetricWeight']]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class ServicePlacementInvalidDomainPolicyArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        Describes the policy to be used for placement of a Service Fabric service where a particular fault or upgrade domain should not be used for placement of the instances or replicas of that service.
        :param pulumi.Input[str] domain_name: The name of the domain that should not be used for placement.
        :param pulumi.Input[str] type: The type of placement policy for a service fabric service. Following are the possible values.
               Expected value is 'InvalidDomain'.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "type", 'InvalidDomain')

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The name of the domain that should not be used for placement.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of placement policy for a service fabric service. Following are the possible values.
        Expected value is 'InvalidDomain'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ServicePlacementNonPartiallyPlaceServicePolicyArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str]):
        """
        The name of the domain that should used for placement as per this policy.
        :param pulumi.Input[str] type: The type of placement policy for a service fabric service. Following are the possible values.
               Expected value is 'NonPartiallyPlaceService'.
        """
        pulumi.set(__self__, "type", 'NonPartiallyPlaceService')

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of placement policy for a service fabric service. Following are the possible values.
        Expected value is 'NonPartiallyPlaceService'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ServicePlacementPreferPrimaryDomainPolicyArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        Describes the policy to be used for placement of a Service Fabric service where the service's 
        Primary replicas should optimally be placed in a particular domain.

        This placement policy is usually used with fault domains in scenarios where the Service Fabric
        cluster is geographically distributed in order to indicate that a service's primary replica should
        be located in a particular fault domain, which in geo-distributed scenarios usually aligns with regional
        or datacenter boundaries. Note that since this is an optimization it is possible that the Primary replica
        may not end up located in this domain due to failures, capacity limits, or other constraints.

        :param pulumi.Input[str] domain_name: The name of the domain that should used for placement as per this policy.
        :param pulumi.Input[str] type: The type of placement policy for a service fabric service. Following are the possible values.
               Expected value is 'PreferredPrimaryDomain'.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "type", 'PreferredPrimaryDomain')

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The name of the domain that should used for placement as per this policy.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of placement policy for a service fabric service. Following are the possible values.
        Expected value is 'PreferredPrimaryDomain'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ServicePlacementRequireDomainDistributionPolicyArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        Describes the policy to be used for placement of a Service Fabric service where two replicas
        from the same partition should never be placed in the same fault or upgrade domain.

        While this is not common it can expose the service to an increased risk of concurrent failures
        due to unplanned outages or other cases of subsequent/concurrent failures. As an example, consider
        a case where replicas are deployed across different data center, with one replica per location.
        In the event that one of the datacenters goes offline, normally the replica that was placed in that
        datacenter will be packed into one of the remaining datacenters. If this is not desirable then this
        policy should be set.

        :param pulumi.Input[str] domain_name: The name of the domain that should used for placement as per this policy.
        :param pulumi.Input[str] type: The type of placement policy for a service fabric service. Following are the possible values.
               Expected value is 'RequiredDomainDistribution'.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "type", 'RequiredDomainDistribution')

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The name of the domain that should used for placement as per this policy.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of placement policy for a service fabric service. Following are the possible values.
        Expected value is 'RequiredDomainDistribution'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ServicePlacementRequiredDomainPolicyArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        Describes the policy to be used for placement of a Service Fabric service where the instances or replicas of that service must be placed in a particular domain.
        :param pulumi.Input[str] domain_name: The name of the domain that should used for placement as per this policy.
        :param pulumi.Input[str] type: The type of placement policy for a service fabric service. Following are the possible values.
               Expected value is 'RequiredDomain'.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "type", 'RequiredDomain')

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The name of the domain that should used for placement as per this policy.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of placement policy for a service fabric service. Following are the possible values.
        Expected value is 'RequiredDomain'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ServiceTypeHealthPolicyArgs:
    def __init__(__self__, *,
                 max_percent_unhealthy_partitions_per_service: pulumi.Input[int],
                 max_percent_unhealthy_replicas_per_partition: pulumi.Input[int],
                 max_percent_unhealthy_services: pulumi.Input[int]):
        """
        Represents the health policy used to evaluate the health of services belonging to a service type.

        :param pulumi.Input[int] max_percent_unhealthy_partitions_per_service: The maximum allowed percentage of unhealthy partitions per service.
               
               The percentage represents the maximum tolerated percentage of partitions that can be unhealthy before the service is considered in error.
               If the percentage is respected but there is at least one unhealthy partition, the health is evaluated as Warning.
               The percentage is calculated by dividing the number of unhealthy partitions over the total number of partitions in the service.
               The computation rounds up to tolerate one failure on small numbers of partitions.
        :param pulumi.Input[int] max_percent_unhealthy_replicas_per_partition: The maximum allowed percentage of unhealthy replicas per partition.
               
               The percentage represents the maximum tolerated percentage of replicas that can be unhealthy before the partition is considered in error.
               If the percentage is respected but there is at least one unhealthy replica, the health is evaluated as Warning.
               The percentage is calculated by dividing the number of unhealthy replicas over the total number of replicas in the partition.
               The computation rounds up to tolerate one failure on small numbers of replicas.
        :param pulumi.Input[int] max_percent_unhealthy_services: The maximum allowed percentage of unhealthy services.
               
               The percentage represents the maximum tolerated percentage of services that can be unhealthy before the application is considered in error.
               If the percentage is respected but there is at least one unhealthy service, the health is evaluated as Warning.
               This is calculated by dividing the number of unhealthy services of the specific service type over the total number of services of the specific service type.
               The computation rounds up to tolerate one failure on small numbers of services.
        """
        pulumi.set(__self__, "max_percent_unhealthy_partitions_per_service", max_percent_unhealthy_partitions_per_service)
        pulumi.set(__self__, "max_percent_unhealthy_replicas_per_partition", max_percent_unhealthy_replicas_per_partition)
        pulumi.set(__self__, "max_percent_unhealthy_services", max_percent_unhealthy_services)

    @property
    @pulumi.getter(name="maxPercentUnhealthyPartitionsPerService")
    def max_percent_unhealthy_partitions_per_service(self) -> pulumi.Input[int]:
        """
        The maximum allowed percentage of unhealthy partitions per service.

        The percentage represents the maximum tolerated percentage of partitions that can be unhealthy before the service is considered in error.
        If the percentage is respected but there is at least one unhealthy partition, the health is evaluated as Warning.
        The percentage is calculated by dividing the number of unhealthy partitions over the total number of partitions in the service.
        The computation rounds up to tolerate one failure on small numbers of partitions.
        """
        return pulumi.get(self, "max_percent_unhealthy_partitions_per_service")

    @max_percent_unhealthy_partitions_per_service.setter
    def max_percent_unhealthy_partitions_per_service(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_percent_unhealthy_partitions_per_service", value)

    @property
    @pulumi.getter(name="maxPercentUnhealthyReplicasPerPartition")
    def max_percent_unhealthy_replicas_per_partition(self) -> pulumi.Input[int]:
        """
        The maximum allowed percentage of unhealthy replicas per partition.

        The percentage represents the maximum tolerated percentage of replicas that can be unhealthy before the partition is considered in error.
        If the percentage is respected but there is at least one unhealthy replica, the health is evaluated as Warning.
        The percentage is calculated by dividing the number of unhealthy replicas over the total number of replicas in the partition.
        The computation rounds up to tolerate one failure on small numbers of replicas.
        """
        return pulumi.get(self, "max_percent_unhealthy_replicas_per_partition")

    @max_percent_unhealthy_replicas_per_partition.setter
    def max_percent_unhealthy_replicas_per_partition(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_percent_unhealthy_replicas_per_partition", value)

    @property
    @pulumi.getter(name="maxPercentUnhealthyServices")
    def max_percent_unhealthy_services(self) -> pulumi.Input[int]:
        """
        The maximum allowed percentage of unhealthy services.

        The percentage represents the maximum tolerated percentage of services that can be unhealthy before the application is considered in error.
        If the percentage is respected but there is at least one unhealthy service, the health is evaluated as Warning.
        This is calculated by dividing the number of unhealthy services of the specific service type over the total number of services of the specific service type.
        The computation rounds up to tolerate one failure on small numbers of services.
        """
        return pulumi.get(self, "max_percent_unhealthy_services")

    @max_percent_unhealthy_services.setter
    def max_percent_unhealthy_services(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_percent_unhealthy_services", value)


@pulumi.input_type
class SettingsParameterDescriptionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Describes a parameter in fabric settings of the cluster.
        :param pulumi.Input[str] name: The parameter name of fabric setting.
        :param pulumi.Input[str] value: The parameter value of fabric setting.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The parameter name of fabric setting.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The parameter value of fabric setting.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class SettingsSectionDescriptionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input[Sequence[pulumi.Input['SettingsParameterDescriptionArgs']]]):
        """
        Describes a section in the fabric settings of the cluster.
        :param pulumi.Input[str] name: The section name of the fabric settings.
        :param pulumi.Input[Sequence[pulumi.Input['SettingsParameterDescriptionArgs']]] parameters: The collection of parameters in the section.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The section name of the fabric settings.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input[Sequence[pulumi.Input['SettingsParameterDescriptionArgs']]]:
        """
        The collection of parameters in the section.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input[Sequence[pulumi.Input['SettingsParameterDescriptionArgs']]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class SingletonPartitionSchemeArgs:
    def __init__(__self__, *,
                 partition_scheme: pulumi.Input[str]):
        """
        Describes the partition scheme of a singleton-partitioned, or non-partitioned service.
        :param pulumi.Input[str] partition_scheme: Enumerates the ways that a service can be partitioned.
               Expected value is 'Singleton'.
        """
        pulumi.set(__self__, "partition_scheme", 'Singleton')

    @property
    @pulumi.getter(name="partitionScheme")
    def partition_scheme(self) -> pulumi.Input[str]:
        """
        Enumerates the ways that a service can be partitioned.
        Expected value is 'Singleton'.
        """
        return pulumi.get(self, "partition_scheme")

    @partition_scheme.setter
    def partition_scheme(self, value: pulumi.Input[str]):
        pulumi.set(self, "partition_scheme", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'SkuName']]):
        """
        Service Fabric managed cluster Sku definition
        :param pulumi.Input[Union[str, 'SkuName']] name: Sku Name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'SkuName']]:
        """
        Sku Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'SkuName']]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class StatefulServicePropertiesArgs:
    def __init__(__self__, *,
                 partition_description: pulumi.Input[Union['NamedPartitionSchemeArgs', 'SingletonPartitionSchemeArgs', 'UniformInt64RangePartitionSchemeArgs']],
                 service_kind: pulumi.Input[str],
                 service_type_name: pulumi.Input[str],
                 correlation_scheme: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCorrelationArgs']]]] = None,
                 default_move_cost: Optional[pulumi.Input[Union[str, 'MoveCost']]] = None,
                 has_persisted_state: Optional[pulumi.Input[bool]] = None,
                 min_replica_set_size: Optional[pulumi.Input[int]] = None,
                 placement_constraints: Optional[pulumi.Input[str]] = None,
                 quorum_loss_wait_duration: Optional[pulumi.Input[str]] = None,
                 replica_restart_wait_duration: Optional[pulumi.Input[str]] = None,
                 scaling_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyArgs']]]] = None,
                 service_load_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLoadMetricArgs']]]] = None,
                 service_package_activation_mode: Optional[pulumi.Input[Union[str, 'ServicePackageActivationMode']]] = None,
                 service_placement_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePlacementInvalidDomainPolicyArgs', 'ServicePlacementNonPartiallyPlaceServicePolicyArgs', 'ServicePlacementPreferPrimaryDomainPolicyArgs', 'ServicePlacementRequireDomainDistributionPolicyArgs', 'ServicePlacementRequiredDomainPolicyArgs']]]]] = None,
                 service_placement_time_limit: Optional[pulumi.Input[str]] = None,
                 stand_by_replica_keep_duration: Optional[pulumi.Input[str]] = None,
                 target_replica_set_size: Optional[pulumi.Input[int]] = None):
        """
        The properties of a stateful service resource.
        :param pulumi.Input[Union['NamedPartitionSchemeArgs', 'SingletonPartitionSchemeArgs', 'UniformInt64RangePartitionSchemeArgs']] partition_description: Describes how the service is partitioned.
        :param pulumi.Input[str] service_kind: The kind of service (Stateless or Stateful).
               Expected value is 'Stateful'.
        :param pulumi.Input[str] service_type_name: The name of the service type
        :param pulumi.Input[Sequence[pulumi.Input['ServiceCorrelationArgs']]] correlation_scheme: A list that describes the correlation of the service with other services.
        :param pulumi.Input[Union[str, 'MoveCost']] default_move_cost: Specifies the move cost for the service.
        :param pulumi.Input[bool] has_persisted_state: A flag indicating whether this is a persistent service which stores states on the local disk. If it is then the value of this property is true, if not it is false.
        :param pulumi.Input[int] min_replica_set_size: The minimum replica set size as a number.
        :param pulumi.Input[str] placement_constraints: The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
        :param pulumi.Input[str] quorum_loss_wait_duration: The maximum duration for which a partition is allowed to be in a state of quorum loss, represented in ISO 8601 format "hh:mm:ss".
        :param pulumi.Input[str] replica_restart_wait_duration: The duration between when a replica goes down and when a new replica is created, represented in ISO 8601 format "hh:mm:ss".
        :param pulumi.Input[Sequence[pulumi.Input['ScalingPolicyArgs']]] scaling_policies: Scaling policies for this service.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLoadMetricArgs']]] service_load_metrics: The service load metrics is given as an array of ServiceLoadMetric objects.
        :param pulumi.Input[Union[str, 'ServicePackageActivationMode']] service_package_activation_mode: The activation Mode of the service package
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServicePlacementInvalidDomainPolicyArgs', 'ServicePlacementNonPartiallyPlaceServicePolicyArgs', 'ServicePlacementPreferPrimaryDomainPolicyArgs', 'ServicePlacementRequireDomainDistributionPolicyArgs', 'ServicePlacementRequiredDomainPolicyArgs']]]] service_placement_policies: A list that describes the correlation of the service with other services.
        :param pulumi.Input[str] service_placement_time_limit: The duration for which replicas can stay InBuild before reporting that build is stuck, represented in ISO 8601 format "hh:mm:ss".
        :param pulumi.Input[str] stand_by_replica_keep_duration: The definition on how long StandBy replicas should be maintained before being removed, represented in ISO 8601 format "hh:mm:ss".
        :param pulumi.Input[int] target_replica_set_size: The target replica set size as a number.
        """
        pulumi.set(__self__, "partition_description", partition_description)
        pulumi.set(__self__, "service_kind", 'Stateful')
        pulumi.set(__self__, "service_type_name", service_type_name)
        if correlation_scheme is not None:
            pulumi.set(__self__, "correlation_scheme", correlation_scheme)
        if default_move_cost is not None:
            pulumi.set(__self__, "default_move_cost", default_move_cost)
        if has_persisted_state is not None:
            pulumi.set(__self__, "has_persisted_state", has_persisted_state)
        if min_replica_set_size is not None:
            pulumi.set(__self__, "min_replica_set_size", min_replica_set_size)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if quorum_loss_wait_duration is not None:
            pulumi.set(__self__, "quorum_loss_wait_duration", quorum_loss_wait_duration)
        if replica_restart_wait_duration is not None:
            pulumi.set(__self__, "replica_restart_wait_duration", replica_restart_wait_duration)
        if scaling_policies is not None:
            pulumi.set(__self__, "scaling_policies", scaling_policies)
        if service_load_metrics is not None:
            pulumi.set(__self__, "service_load_metrics", service_load_metrics)
        if service_package_activation_mode is not None:
            pulumi.set(__self__, "service_package_activation_mode", service_package_activation_mode)
        if service_placement_policies is not None:
            pulumi.set(__self__, "service_placement_policies", service_placement_policies)
        if service_placement_time_limit is not None:
            pulumi.set(__self__, "service_placement_time_limit", service_placement_time_limit)
        if stand_by_replica_keep_duration is not None:
            pulumi.set(__self__, "stand_by_replica_keep_duration", stand_by_replica_keep_duration)
        if target_replica_set_size is not None:
            pulumi.set(__self__, "target_replica_set_size", target_replica_set_size)

    @property
    @pulumi.getter(name="partitionDescription")
    def partition_description(self) -> pulumi.Input[Union['NamedPartitionSchemeArgs', 'SingletonPartitionSchemeArgs', 'UniformInt64RangePartitionSchemeArgs']]:
        """
        Describes how the service is partitioned.
        """
        return pulumi.get(self, "partition_description")

    @partition_description.setter
    def partition_description(self, value: pulumi.Input[Union['NamedPartitionSchemeArgs', 'SingletonPartitionSchemeArgs', 'UniformInt64RangePartitionSchemeArgs']]):
        pulumi.set(self, "partition_description", value)

    @property
    @pulumi.getter(name="serviceKind")
    def service_kind(self) -> pulumi.Input[str]:
        """
        The kind of service (Stateless or Stateful).
        Expected value is 'Stateful'.
        """
        return pulumi.get(self, "service_kind")

    @service_kind.setter
    def service_kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_kind", value)

    @property
    @pulumi.getter(name="serviceTypeName")
    def service_type_name(self) -> pulumi.Input[str]:
        """
        The name of the service type
        """
        return pulumi.get(self, "service_type_name")

    @service_type_name.setter
    def service_type_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_type_name", value)

    @property
    @pulumi.getter(name="correlationScheme")
    def correlation_scheme(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCorrelationArgs']]]]:
        """
        A list that describes the correlation of the service with other services.
        """
        return pulumi.get(self, "correlation_scheme")

    @correlation_scheme.setter
    def correlation_scheme(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCorrelationArgs']]]]):
        pulumi.set(self, "correlation_scheme", value)

    @property
    @pulumi.getter(name="defaultMoveCost")
    def default_move_cost(self) -> Optional[pulumi.Input[Union[str, 'MoveCost']]]:
        """
        Specifies the move cost for the service.
        """
        return pulumi.get(self, "default_move_cost")

    @default_move_cost.setter
    def default_move_cost(self, value: Optional[pulumi.Input[Union[str, 'MoveCost']]]):
        pulumi.set(self, "default_move_cost", value)

    @property
    @pulumi.getter(name="hasPersistedState")
    def has_persisted_state(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether this is a persistent service which stores states on the local disk. If it is then the value of this property is true, if not it is false.
        """
        return pulumi.get(self, "has_persisted_state")

    @has_persisted_state.setter
    def has_persisted_state(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_persisted_state", value)

    @property
    @pulumi.getter(name="minReplicaSetSize")
    def min_replica_set_size(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum replica set size as a number.
        """
        return pulumi.get(self, "min_replica_set_size")

    @min_replica_set_size.setter
    def min_replica_set_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_replica_set_size", value)

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[pulumi.Input[str]]:
        """
        The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
        """
        return pulumi.get(self, "placement_constraints")

    @placement_constraints.setter
    def placement_constraints(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_constraints", value)

    @property
    @pulumi.getter(name="quorumLossWaitDuration")
    def quorum_loss_wait_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum duration for which a partition is allowed to be in a state of quorum loss, represented in ISO 8601 format "hh:mm:ss".
        """
        return pulumi.get(self, "quorum_loss_wait_duration")

    @quorum_loss_wait_duration.setter
    def quorum_loss_wait_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quorum_loss_wait_duration", value)

    @property
    @pulumi.getter(name="replicaRestartWaitDuration")
    def replica_restart_wait_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration between when a replica goes down and when a new replica is created, represented in ISO 8601 format "hh:mm:ss".
        """
        return pulumi.get(self, "replica_restart_wait_duration")

    @replica_restart_wait_duration.setter
    def replica_restart_wait_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_restart_wait_duration", value)

    @property
    @pulumi.getter(name="scalingPolicies")
    def scaling_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyArgs']]]]:
        """
        Scaling policies for this service.
        """
        return pulumi.get(self, "scaling_policies")

    @scaling_policies.setter
    def scaling_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyArgs']]]]):
        pulumi.set(self, "scaling_policies", value)

    @property
    @pulumi.getter(name="serviceLoadMetrics")
    def service_load_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLoadMetricArgs']]]]:
        """
        The service load metrics is given as an array of ServiceLoadMetric objects.
        """
        return pulumi.get(self, "service_load_metrics")

    @service_load_metrics.setter
    def service_load_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLoadMetricArgs']]]]):
        pulumi.set(self, "service_load_metrics", value)

    @property
    @pulumi.getter(name="servicePackageActivationMode")
    def service_package_activation_mode(self) -> Optional[pulumi.Input[Union[str, 'ServicePackageActivationMode']]]:
        """
        The activation Mode of the service package
        """
        return pulumi.get(self, "service_package_activation_mode")

    @service_package_activation_mode.setter
    def service_package_activation_mode(self, value: Optional[pulumi.Input[Union[str, 'ServicePackageActivationMode']]]):
        pulumi.set(self, "service_package_activation_mode", value)

    @property
    @pulumi.getter(name="servicePlacementPolicies")
    def service_placement_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePlacementInvalidDomainPolicyArgs', 'ServicePlacementNonPartiallyPlaceServicePolicyArgs', 'ServicePlacementPreferPrimaryDomainPolicyArgs', 'ServicePlacementRequireDomainDistributionPolicyArgs', 'ServicePlacementRequiredDomainPolicyArgs']]]]]:
        """
        A list that describes the correlation of the service with other services.
        """
        return pulumi.get(self, "service_placement_policies")

    @service_placement_policies.setter
    def service_placement_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePlacementInvalidDomainPolicyArgs', 'ServicePlacementNonPartiallyPlaceServicePolicyArgs', 'ServicePlacementPreferPrimaryDomainPolicyArgs', 'ServicePlacementRequireDomainDistributionPolicyArgs', 'ServicePlacementRequiredDomainPolicyArgs']]]]]):
        pulumi.set(self, "service_placement_policies", value)

    @property
    @pulumi.getter(name="servicePlacementTimeLimit")
    def service_placement_time_limit(self) -> Optional[pulumi.Input[str]]:
        """
        The duration for which replicas can stay InBuild before reporting that build is stuck, represented in ISO 8601 format "hh:mm:ss".
        """
        return pulumi.get(self, "service_placement_time_limit")

    @service_placement_time_limit.setter
    def service_placement_time_limit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_placement_time_limit", value)

    @property
    @pulumi.getter(name="standByReplicaKeepDuration")
    def stand_by_replica_keep_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The definition on how long StandBy replicas should be maintained before being removed, represented in ISO 8601 format "hh:mm:ss".
        """
        return pulumi.get(self, "stand_by_replica_keep_duration")

    @stand_by_replica_keep_duration.setter
    def stand_by_replica_keep_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stand_by_replica_keep_duration", value)

    @property
    @pulumi.getter(name="targetReplicaSetSize")
    def target_replica_set_size(self) -> Optional[pulumi.Input[int]]:
        """
        The target replica set size as a number.
        """
        return pulumi.get(self, "target_replica_set_size")

    @target_replica_set_size.setter
    def target_replica_set_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_replica_set_size", value)


@pulumi.input_type
class StatelessServicePropertiesArgs:
    def __init__(__self__, *,
                 instance_count: pulumi.Input[int],
                 partition_description: pulumi.Input[Union['NamedPartitionSchemeArgs', 'SingletonPartitionSchemeArgs', 'UniformInt64RangePartitionSchemeArgs']],
                 service_kind: pulumi.Input[str],
                 service_type_name: pulumi.Input[str],
                 correlation_scheme: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCorrelationArgs']]]] = None,
                 default_move_cost: Optional[pulumi.Input[Union[str, 'MoveCost']]] = None,
                 min_instance_count: Optional[pulumi.Input[int]] = None,
                 min_instance_percentage: Optional[pulumi.Input[int]] = None,
                 placement_constraints: Optional[pulumi.Input[str]] = None,
                 scaling_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyArgs']]]] = None,
                 service_load_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLoadMetricArgs']]]] = None,
                 service_package_activation_mode: Optional[pulumi.Input[Union[str, 'ServicePackageActivationMode']]] = None,
                 service_placement_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePlacementInvalidDomainPolicyArgs', 'ServicePlacementNonPartiallyPlaceServicePolicyArgs', 'ServicePlacementPreferPrimaryDomainPolicyArgs', 'ServicePlacementRequireDomainDistributionPolicyArgs', 'ServicePlacementRequiredDomainPolicyArgs']]]]] = None):
        """
        The properties of a stateless service resource.
        :param pulumi.Input[int] instance_count: The instance count.
        :param pulumi.Input[Union['NamedPartitionSchemeArgs', 'SingletonPartitionSchemeArgs', 'UniformInt64RangePartitionSchemeArgs']] partition_description: Describes how the service is partitioned.
        :param pulumi.Input[str] service_kind: The kind of service (Stateless or Stateful).
               Expected value is 'Stateless'.
        :param pulumi.Input[str] service_type_name: The name of the service type
        :param pulumi.Input[Sequence[pulumi.Input['ServiceCorrelationArgs']]] correlation_scheme: A list that describes the correlation of the service with other services.
        :param pulumi.Input[Union[str, 'MoveCost']] default_move_cost: Specifies the move cost for the service.
        :param pulumi.Input[int] min_instance_count: MinInstanceCount is the minimum number of instances that must be up to meet the EnsureAvailability safety check during operations like upgrade or deactivate node. The actual number that is used is max( MinInstanceCount, ceil( MinInstancePercentage/100.0 * InstanceCount) ). Note, if InstanceCount is set to -1, during MinInstanceCount computation -1 is first converted into the number of nodes on which the instances are allowed to be placed according to the placement constraints on the service.
        :param pulumi.Input[int] min_instance_percentage: MinInstancePercentage is the minimum percentage of InstanceCount that must be up to meet the EnsureAvailability safety check during operations like upgrade or deactivate node. The actual number that is used is max( MinInstanceCount, ceil( MinInstancePercentage/100.0 * InstanceCount) ). Note, if InstanceCount is set to -1, during MinInstancePercentage computation, -1 is first converted into the number of nodes on which the instances are allowed to be placed according to the placement constraints on the service.
        :param pulumi.Input[str] placement_constraints: The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
        :param pulumi.Input[Sequence[pulumi.Input['ScalingPolicyArgs']]] scaling_policies: Scaling policies for this service.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLoadMetricArgs']]] service_load_metrics: The service load metrics is given as an array of ServiceLoadMetric objects.
        :param pulumi.Input[Union[str, 'ServicePackageActivationMode']] service_package_activation_mode: The activation Mode of the service package
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServicePlacementInvalidDomainPolicyArgs', 'ServicePlacementNonPartiallyPlaceServicePolicyArgs', 'ServicePlacementPreferPrimaryDomainPolicyArgs', 'ServicePlacementRequireDomainDistributionPolicyArgs', 'ServicePlacementRequiredDomainPolicyArgs']]]] service_placement_policies: A list that describes the correlation of the service with other services.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "partition_description", partition_description)
        pulumi.set(__self__, "service_kind", 'Stateless')
        pulumi.set(__self__, "service_type_name", service_type_name)
        if correlation_scheme is not None:
            pulumi.set(__self__, "correlation_scheme", correlation_scheme)
        if default_move_cost is not None:
            pulumi.set(__self__, "default_move_cost", default_move_cost)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)
        if min_instance_percentage is not None:
            pulumi.set(__self__, "min_instance_percentage", min_instance_percentage)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if scaling_policies is not None:
            pulumi.set(__self__, "scaling_policies", scaling_policies)
        if service_load_metrics is not None:
            pulumi.set(__self__, "service_load_metrics", service_load_metrics)
        if service_package_activation_mode is not None:
            pulumi.set(__self__, "service_package_activation_mode", service_package_activation_mode)
        if service_placement_policies is not None:
            pulumi.set(__self__, "service_placement_policies", service_placement_policies)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Input[int]:
        """
        The instance count.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="partitionDescription")
    def partition_description(self) -> pulumi.Input[Union['NamedPartitionSchemeArgs', 'SingletonPartitionSchemeArgs', 'UniformInt64RangePartitionSchemeArgs']]:
        """
        Describes how the service is partitioned.
        """
        return pulumi.get(self, "partition_description")

    @partition_description.setter
    def partition_description(self, value: pulumi.Input[Union['NamedPartitionSchemeArgs', 'SingletonPartitionSchemeArgs', 'UniformInt64RangePartitionSchemeArgs']]):
        pulumi.set(self, "partition_description", value)

    @property
    @pulumi.getter(name="serviceKind")
    def service_kind(self) -> pulumi.Input[str]:
        """
        The kind of service (Stateless or Stateful).
        Expected value is 'Stateless'.
        """
        return pulumi.get(self, "service_kind")

    @service_kind.setter
    def service_kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_kind", value)

    @property
    @pulumi.getter(name="serviceTypeName")
    def service_type_name(self) -> pulumi.Input[str]:
        """
        The name of the service type
        """
        return pulumi.get(self, "service_type_name")

    @service_type_name.setter
    def service_type_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_type_name", value)

    @property
    @pulumi.getter(name="correlationScheme")
    def correlation_scheme(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCorrelationArgs']]]]:
        """
        A list that describes the correlation of the service with other services.
        """
        return pulumi.get(self, "correlation_scheme")

    @correlation_scheme.setter
    def correlation_scheme(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCorrelationArgs']]]]):
        pulumi.set(self, "correlation_scheme", value)

    @property
    @pulumi.getter(name="defaultMoveCost")
    def default_move_cost(self) -> Optional[pulumi.Input[Union[str, 'MoveCost']]]:
        """
        Specifies the move cost for the service.
        """
        return pulumi.get(self, "default_move_cost")

    @default_move_cost.setter
    def default_move_cost(self, value: Optional[pulumi.Input[Union[str, 'MoveCost']]]):
        pulumi.set(self, "default_move_cost", value)

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        MinInstanceCount is the minimum number of instances that must be up to meet the EnsureAvailability safety check during operations like upgrade or deactivate node. The actual number that is used is max( MinInstanceCount, ceil( MinInstancePercentage/100.0 * InstanceCount) ). Note, if InstanceCount is set to -1, during MinInstanceCount computation -1 is first converted into the number of nodes on which the instances are allowed to be placed according to the placement constraints on the service.
        """
        return pulumi.get(self, "min_instance_count")

    @min_instance_count.setter
    def min_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instance_count", value)

    @property
    @pulumi.getter(name="minInstancePercentage")
    def min_instance_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        MinInstancePercentage is the minimum percentage of InstanceCount that must be up to meet the EnsureAvailability safety check during operations like upgrade or deactivate node. The actual number that is used is max( MinInstanceCount, ceil( MinInstancePercentage/100.0 * InstanceCount) ). Note, if InstanceCount is set to -1, during MinInstancePercentage computation, -1 is first converted into the number of nodes on which the instances are allowed to be placed according to the placement constraints on the service.
        """
        return pulumi.get(self, "min_instance_percentage")

    @min_instance_percentage.setter
    def min_instance_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instance_percentage", value)

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[pulumi.Input[str]]:
        """
        The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
        """
        return pulumi.get(self, "placement_constraints")

    @placement_constraints.setter
    def placement_constraints(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_constraints", value)

    @property
    @pulumi.getter(name="scalingPolicies")
    def scaling_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyArgs']]]]:
        """
        Scaling policies for this service.
        """
        return pulumi.get(self, "scaling_policies")

    @scaling_policies.setter
    def scaling_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyArgs']]]]):
        pulumi.set(self, "scaling_policies", value)

    @property
    @pulumi.getter(name="serviceLoadMetrics")
    def service_load_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLoadMetricArgs']]]]:
        """
        The service load metrics is given as an array of ServiceLoadMetric objects.
        """
        return pulumi.get(self, "service_load_metrics")

    @service_load_metrics.setter
    def service_load_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLoadMetricArgs']]]]):
        pulumi.set(self, "service_load_metrics", value)

    @property
    @pulumi.getter(name="servicePackageActivationMode")
    def service_package_activation_mode(self) -> Optional[pulumi.Input[Union[str, 'ServicePackageActivationMode']]]:
        """
        The activation Mode of the service package
        """
        return pulumi.get(self, "service_package_activation_mode")

    @service_package_activation_mode.setter
    def service_package_activation_mode(self, value: Optional[pulumi.Input[Union[str, 'ServicePackageActivationMode']]]):
        pulumi.set(self, "service_package_activation_mode", value)

    @property
    @pulumi.getter(name="servicePlacementPolicies")
    def service_placement_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePlacementInvalidDomainPolicyArgs', 'ServicePlacementNonPartiallyPlaceServicePolicyArgs', 'ServicePlacementPreferPrimaryDomainPolicyArgs', 'ServicePlacementRequireDomainDistributionPolicyArgs', 'ServicePlacementRequiredDomainPolicyArgs']]]]]:
        """
        A list that describes the correlation of the service with other services.
        """
        return pulumi.get(self, "service_placement_policies")

    @service_placement_policies.setter
    def service_placement_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePlacementInvalidDomainPolicyArgs', 'ServicePlacementNonPartiallyPlaceServicePolicyArgs', 'ServicePlacementPreferPrimaryDomainPolicyArgs', 'ServicePlacementRequireDomainDistributionPolicyArgs', 'ServicePlacementRequiredDomainPolicyArgs']]]]]):
        pulumi.set(self, "service_placement_policies", value)


@pulumi.input_type
class SubResourceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Azure resource identifier.
        :param pulumi.Input[str] id: Azure resource identifier.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure resource identifier.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class UniformInt64RangePartitionSchemeArgs:
    def __init__(__self__, *,
                 count: pulumi.Input[int],
                 high_key: pulumi.Input[float],
                 low_key: pulumi.Input[float],
                 partition_scheme: pulumi.Input[str]):
        """
        Describes a partitioning scheme where an integer range is allocated evenly across a number of partitions.
        :param pulumi.Input[int] count: The number of partitions.
        :param pulumi.Input[float] high_key: The upper bound of the partition key range that
               should be split between the partition ‘Count’
        :param pulumi.Input[float] low_key: The lower bound of the partition key range that
               should be split between the partition ‘Count’
        :param pulumi.Input[str] partition_scheme: Enumerates the ways that a service can be partitioned.
               Expected value is 'UniformInt64Range'.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "high_key", high_key)
        pulumi.set(__self__, "low_key", low_key)
        pulumi.set(__self__, "partition_scheme", 'UniformInt64Range')

    @property
    @pulumi.getter
    def count(self) -> pulumi.Input[int]:
        """
        The number of partitions.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: pulumi.Input[int]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="highKey")
    def high_key(self) -> pulumi.Input[float]:
        """
        The upper bound of the partition key range that
        should be split between the partition ‘Count’
        """
        return pulumi.get(self, "high_key")

    @high_key.setter
    def high_key(self, value: pulumi.Input[float]):
        pulumi.set(self, "high_key", value)

    @property
    @pulumi.getter(name="lowKey")
    def low_key(self) -> pulumi.Input[float]:
        """
        The lower bound of the partition key range that
        should be split between the partition ‘Count’
        """
        return pulumi.get(self, "low_key")

    @low_key.setter
    def low_key(self, value: pulumi.Input[float]):
        pulumi.set(self, "low_key", value)

    @property
    @pulumi.getter(name="partitionScheme")
    def partition_scheme(self) -> pulumi.Input[str]:
        """
        Enumerates the ways that a service can be partitioned.
        Expected value is 'UniformInt64Range'.
        """
        return pulumi.get(self, "partition_scheme")

    @partition_scheme.setter
    def partition_scheme(self, value: pulumi.Input[str]):
        pulumi.set(self, "partition_scheme", value)


@pulumi.input_type
class VMSSExtensionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 publisher: pulumi.Input[str],
                 type: pulumi.Input[str],
                 type_handler_version: pulumi.Input[str],
                 auto_upgrade_minor_version: Optional[pulumi.Input[bool]] = None,
                 force_update_tag: Optional[pulumi.Input[str]] = None,
                 protected_settings: Optional[Any] = None,
                 provision_after_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 settings: Optional[Any] = None):
        """
        Specifies set of extensions that should be installed onto the virtual machines.
        :param pulumi.Input[str] name: The name of the extension.
        :param pulumi.Input[str] publisher: The name of the extension handler publisher.
        :param pulumi.Input[str] type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :param pulumi.Input[str] type_handler_version: Specifies the version of the script handler.
        :param pulumi.Input[bool] auto_upgrade_minor_version: Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        :param pulumi.Input[str] force_update_tag: If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
        :param Any protected_settings: The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] provision_after_extensions: Collection of extension names after which this extension needs to be provisioned.
        :param Any settings: Json formatted public settings for the extension.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "type_handler_version", type_handler_version)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if provision_after_extensions is not None:
            pulumi.set(__self__, "provision_after_extensions", provision_after_extensions)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the extension.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def publisher(self) -> pulumi.Input[str]:
        """
        The name of the extension handler publisher.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: pulumi.Input[str]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the type of the extension; an example is "CustomScriptExtension".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> pulumi.Input[str]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")

    @type_handler_version.setter
    def type_handler_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "type_handler_version", value)

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @auto_upgrade_minor_version.setter
    def auto_upgrade_minor_version(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_upgrade_minor_version", value)

    @property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[pulumi.Input[str]]:
        """
        If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
        """
        return pulumi.get(self, "force_update_tag")

    @force_update_tag.setter
    def force_update_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "force_update_tag", value)

    @property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[Any]:
        """
        The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        """
        return pulumi.get(self, "protected_settings")

    @protected_settings.setter
    def protected_settings(self, value: Optional[Any]):
        pulumi.set(self, "protected_settings", value)

    @property
    @pulumi.getter(name="provisionAfterExtensions")
    def provision_after_extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Collection of extension names after which this extension needs to be provisioned.
        """
        return pulumi.get(self, "provision_after_extensions")

    @provision_after_extensions.setter
    def provision_after_extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "provision_after_extensions", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[Any]:
        """
        Json formatted public settings for the extension.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[Any]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class VaultCertificateArgs:
    def __init__(__self__, *,
                 certificate_store: pulumi.Input[str],
                 certificate_url: pulumi.Input[str]):
        """
        Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM.
        :param pulumi.Input[str] certificate_store: For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. <br><br>For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name <UppercaseThumbprint>.crt for the X509 certificate file and <UppercaseThumbprint>.prv for private key. Both of these files are .pem formatted.
        :param pulumi.Input[str] certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>}
        """
        pulumi.set(__self__, "certificate_store", certificate_store)
        pulumi.set(__self__, "certificate_url", certificate_url)

    @property
    @pulumi.getter(name="certificateStore")
    def certificate_store(self) -> pulumi.Input[str]:
        """
        For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. <br><br>For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name <UppercaseThumbprint>.crt for the X509 certificate file and <UppercaseThumbprint>.prv for private key. Both of these files are .pem formatted.
        """
        return pulumi.get(self, "certificate_store")

    @certificate_store.setter
    def certificate_store(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_store", value)

    @property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> pulumi.Input[str]:
        """
        This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>}
        """
        return pulumi.get(self, "certificate_url")

    @certificate_url.setter
    def certificate_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_url", value)


@pulumi.input_type
class VaultSecretGroupArgs:
    def __init__(__self__, *,
                 source_vault: pulumi.Input['SubResourceArgs'],
                 vault_certificates: pulumi.Input[Sequence[pulumi.Input['VaultCertificateArgs']]]):
        """
        Specifies set of certificates that should be installed onto the virtual machines.
        :param pulumi.Input['SubResourceArgs'] source_vault: The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
        :param pulumi.Input[Sequence[pulumi.Input['VaultCertificateArgs']]] vault_certificates: The list of key vault references in SourceVault which contain certificates.
        """
        pulumi.set(__self__, "source_vault", source_vault)
        pulumi.set(__self__, "vault_certificates", vault_certificates)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> pulumi.Input['SubResourceArgs']:
        """
        The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
        """
        return pulumi.get(self, "source_vault")

    @source_vault.setter
    def source_vault(self, value: pulumi.Input['SubResourceArgs']):
        pulumi.set(self, "source_vault", value)

    @property
    @pulumi.getter(name="vaultCertificates")
    def vault_certificates(self) -> pulumi.Input[Sequence[pulumi.Input['VaultCertificateArgs']]]:
        """
        The list of key vault references in SourceVault which contain certificates.
        """
        return pulumi.get(self, "vault_certificates")

    @vault_certificates.setter
    def vault_certificates(self, value: pulumi.Input[Sequence[pulumi.Input['VaultCertificateArgs']]]):
        pulumi.set(self, "vault_certificates", value)


@pulumi.input_type
class VmManagedIdentityArgs:
    def __init__(__self__, *,
                 user_assigned_identities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Identities for the virtual machine scale set under the node type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_assigned_identities: The list of user identities associated with the virtual machine scale set under the node type. Each entry will be an ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of user identities associated with the virtual machine scale set under the node type. Each entry will be an ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_assigned_identities", value)


