# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AKSResponse',
    'AKSResponseProperties',
    'AksNetworkingConfigurationResponse',
    'AmlComputeNodeInformationResponse',
    'AmlComputeResponse',
    'AmlComputeResponseProperties',
    'DataFactoryResponse',
    'DataLakeAnalyticsResponse',
    'DataLakeAnalyticsResponseProperties',
    'DatabricksResponse',
    'DatabricksResponseProperties',
    'EncryptionPropertyResponse',
    'ErrorDetailResponse',
    'ErrorResponseResponse',
    'HDInsightResponse',
    'HDInsightResponseProperties',
    'IdentityResponse',
    'KeyVaultPropertiesResponse',
    'MachineLearningServiceErrorResponse',
    'NodeStateCountsResponse',
    'PasswordResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'RegistryListCredentialsResultResponse',
    'ResourceIdResponse',
    'ScaleSettingsResponse',
    'SkuResponse',
    'SslConfigurationResponse',
    'SystemServiceResponse',
    'UserAccountCredentialsResponse',
    'VirtualMachineResponse',
    'VirtualMachineResponseProperties',
    'VirtualMachineSshCredentialsResponse',
]

@pulumi.output_type
class AKSResponse(dict):
    """
    A Machine Learning compute based on AKS.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional['outputs.AKSResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A Machine Learning compute based on AKS.
        :param str compute_type: The type of compute
               Expected value is 'AKS'.
        :param str created_on: The date and time when the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The date and time when the compute was last modified.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param 'AKSResponseProperties' properties: AKS properties
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'AKS')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'AKS'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The date and time when the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The date and time when the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.AKSResponseProperties']:
        """
        AKS properties
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class AKSResponseProperties(dict):
    """
    AKS properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "systemServices":
            suggest = "system_services"
        elif key == "agentCount":
            suggest = "agent_count"
        elif key == "agentVMSize":
            suggest = "agent_vm_size"
        elif key == "aksNetworkingConfiguration":
            suggest = "aks_networking_configuration"
        elif key == "clusterFqdn":
            suggest = "cluster_fqdn"
        elif key == "sslConfiguration":
            suggest = "ssl_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 system_services: Sequence['outputs.SystemServiceResponse'],
                 agent_count: Optional[int] = None,
                 agent_vm_size: Optional[str] = None,
                 aks_networking_configuration: Optional['outputs.AksNetworkingConfigurationResponse'] = None,
                 cluster_fqdn: Optional[str] = None,
                 ssl_configuration: Optional['outputs.SslConfigurationResponse'] = None):
        """
        AKS properties
        :param Sequence['SystemServiceResponse'] system_services: System services
        :param int agent_count: Number of agents
        :param str agent_vm_size: Agent virtual machine size
        :param 'AksNetworkingConfigurationResponse' aks_networking_configuration: AKS networking configuration for vnet
        :param str cluster_fqdn: Cluster full qualified domain name
        :param 'SslConfigurationResponse' ssl_configuration: SSL configuration
        """
        pulumi.set(__self__, "system_services", system_services)
        if agent_count is not None:
            pulumi.set(__self__, "agent_count", agent_count)
        if agent_vm_size is not None:
            pulumi.set(__self__, "agent_vm_size", agent_vm_size)
        if aks_networking_configuration is not None:
            pulumi.set(__self__, "aks_networking_configuration", aks_networking_configuration)
        if cluster_fqdn is not None:
            pulumi.set(__self__, "cluster_fqdn", cluster_fqdn)
        if ssl_configuration is not None:
            pulumi.set(__self__, "ssl_configuration", ssl_configuration)

    @property
    @pulumi.getter(name="systemServices")
    def system_services(self) -> Sequence['outputs.SystemServiceResponse']:
        """
        System services
        """
        return pulumi.get(self, "system_services")

    @property
    @pulumi.getter(name="agentCount")
    def agent_count(self) -> Optional[int]:
        """
        Number of agents
        """
        return pulumi.get(self, "agent_count")

    @property
    @pulumi.getter(name="agentVMSize")
    def agent_vm_size(self) -> Optional[str]:
        """
        Agent virtual machine size
        """
        return pulumi.get(self, "agent_vm_size")

    @property
    @pulumi.getter(name="aksNetworkingConfiguration")
    def aks_networking_configuration(self) -> Optional['outputs.AksNetworkingConfigurationResponse']:
        """
        AKS networking configuration for vnet
        """
        return pulumi.get(self, "aks_networking_configuration")

    @property
    @pulumi.getter(name="clusterFqdn")
    def cluster_fqdn(self) -> Optional[str]:
        """
        Cluster full qualified domain name
        """
        return pulumi.get(self, "cluster_fqdn")

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> Optional['outputs.SslConfigurationResponse']:
        """
        SSL configuration
        """
        return pulumi.get(self, "ssl_configuration")


@pulumi.output_type
class AksNetworkingConfigurationResponse(dict):
    """
    Advance configuration for AKS networking
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsServiceIP":
            suggest = "dns_service_ip"
        elif key == "dockerBridgeCidr":
            suggest = "docker_bridge_cidr"
        elif key == "serviceCidr":
            suggest = "service_cidr"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AksNetworkingConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AksNetworkingConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AksNetworkingConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_service_ip: Optional[str] = None,
                 docker_bridge_cidr: Optional[str] = None,
                 service_cidr: Optional[str] = None,
                 subnet_id: Optional[str] = None):
        """
        Advance configuration for AKS networking
        :param str dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        :param str docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        :param str service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        :param str subnet_id: Virtual network subnet resource ID the compute nodes belong to
        """
        if dns_service_ip is not None:
            pulumi.set(__self__, "dns_service_ip", dns_service_ip)
        if docker_bridge_cidr is not None:
            pulumi.set(__self__, "docker_bridge_cidr", docker_bridge_cidr)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="dnsServiceIP")
    def dns_service_ip(self) -> Optional[str]:
        """
        An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        """
        return pulumi.get(self, "dns_service_ip")

    @property
    @pulumi.getter(name="dockerBridgeCidr")
    def docker_bridge_cidr(self) -> Optional[str]:
        """
        A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        """
        return pulumi.get(self, "docker_bridge_cidr")

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[str]:
        """
        A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        """
        return pulumi.get(self, "service_cidr")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        Virtual network subnet resource ID the compute nodes belong to
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class AmlComputeNodeInformationResponse(dict):
    """
    Compute node information related to a AmlCompute.
    """
    def __init__(__self__, *,
                 node_id: str,
                 node_state: str,
                 port: float,
                 private_ip_address: str,
                 public_ip_address: str,
                 run_id: str):
        """
        Compute node information related to a AmlCompute.
        :param str node_id: ID of the compute node.
        :param str node_state: State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted.
        :param float port: SSH port number of the node.
        :param str private_ip_address: Private IP address of the compute node.
        :param str public_ip_address: Public IP address of the compute node.
        :param str run_id: ID of the Experiment running on the node, if any else null.
        """
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_state", node_state)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        pulumi.set(__self__, "run_id", run_id)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        ID of the compute node.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeState")
    def node_state(self) -> str:
        """
        State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted.
        """
        return pulumi.get(self, "node_state")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        SSH port number of the node.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> str:
        """
        Private IP address of the compute node.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        """
        Public IP address of the compute node.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> str:
        """
        ID of the Experiment running on the node, if any else null.
        """
        return pulumi.get(self, "run_id")


@pulumi.output_type
class AmlComputeResponse(dict):
    """
    An Azure Machine Learning compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AmlComputeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AmlComputeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AmlComputeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional['outputs.AmlComputeResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        An Azure Machine Learning compute.
        :param str compute_type: The type of compute
               Expected value is 'AmlCompute'.
        :param str created_on: The date and time when the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The date and time when the compute was last modified.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param 'AmlComputeResponseProperties' properties: AML Compute properties
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'AmlCompute')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'AmlCompute'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The date and time when the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The date and time when the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.AmlComputeResponseProperties']:
        """
        AML Compute properties
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class AmlComputeResponseProperties(dict):
    """
    AML Compute properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocationState":
            suggest = "allocation_state"
        elif key == "allocationStateTransitionTime":
            suggest = "allocation_state_transition_time"
        elif key == "currentNodeCount":
            suggest = "current_node_count"
        elif key == "nodeStateCounts":
            suggest = "node_state_counts"
        elif key == "targetNodeCount":
            suggest = "target_node_count"
        elif key == "remoteLoginPortPublicAccess":
            suggest = "remote_login_port_public_access"
        elif key == "scaleSettings":
            suggest = "scale_settings"
        elif key == "userAccountCredentials":
            suggest = "user_account_credentials"
        elif key == "vmPriority":
            suggest = "vm_priority"
        elif key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AmlComputeResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AmlComputeResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AmlComputeResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation_state: str,
                 allocation_state_transition_time: str,
                 current_node_count: int,
                 errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 node_state_counts: 'outputs.NodeStateCountsResponse',
                 target_node_count: int,
                 remote_login_port_public_access: Optional[str] = None,
                 scale_settings: Optional['outputs.ScaleSettingsResponse'] = None,
                 subnet: Optional['outputs.ResourceIdResponse'] = None,
                 user_account_credentials: Optional['outputs.UserAccountCredentialsResponse'] = None,
                 vm_priority: Optional[str] = None,
                 vm_size: Optional[str] = None):
        """
        AML Compute properties
        :param str allocation_state: Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute.
        :param str allocation_state_transition_time: The time at which the compute entered its current allocation state.
        :param int current_node_count: The number of compute nodes currently assigned to the compute.
        :param Sequence['MachineLearningServiceErrorResponse'] errors: Collection of errors encountered by various compute nodes during node setup.
        :param 'NodeStateCountsResponse' node_state_counts: Counts of various node states on the compute.
        :param int target_node_count: The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes the target node count for the ongoing resize operation. If the allocationState is steady, this property denotes the target node count for the previous resize operation.
        :param str remote_login_port_public_access: State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
        :param 'ScaleSettingsResponse' scale_settings: Scale settings for AML Compute
        :param 'ResourceIdResponse' subnet: Virtual network subnet resource ID the compute nodes belong to.
        :param 'UserAccountCredentialsResponse' user_account_credentials: Credentials for an administrator user account that will be created on each compute node.
        :param str vm_priority: Virtual Machine priority
        :param str vm_size: Virtual Machine Size
        """
        pulumi.set(__self__, "allocation_state", allocation_state)
        pulumi.set(__self__, "allocation_state_transition_time", allocation_state_transition_time)
        pulumi.set(__self__, "current_node_count", current_node_count)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "node_state_counts", node_state_counts)
        pulumi.set(__self__, "target_node_count", target_node_count)
        if remote_login_port_public_access is None:
            remote_login_port_public_access = 'NotSpecified'
        if remote_login_port_public_access is not None:
            pulumi.set(__self__, "remote_login_port_public_access", remote_login_port_public_access)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if user_account_credentials is not None:
            pulumi.set(__self__, "user_account_credentials", user_account_credentials)
        if vm_priority is not None:
            pulumi.set(__self__, "vm_priority", vm_priority)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="allocationState")
    def allocation_state(self) -> str:
        """
        Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute.
        """
        return pulumi.get(self, "allocation_state")

    @property
    @pulumi.getter(name="allocationStateTransitionTime")
    def allocation_state_transition_time(self) -> str:
        """
        The time at which the compute entered its current allocation state.
        """
        return pulumi.get(self, "allocation_state_transition_time")

    @property
    @pulumi.getter(name="currentNodeCount")
    def current_node_count(self) -> int:
        """
        The number of compute nodes currently assigned to the compute.
        """
        return pulumi.get(self, "current_node_count")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Collection of errors encountered by various compute nodes during node setup.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="nodeStateCounts")
    def node_state_counts(self) -> 'outputs.NodeStateCountsResponse':
        """
        Counts of various node states on the compute.
        """
        return pulumi.get(self, "node_state_counts")

    @property
    @pulumi.getter(name="targetNodeCount")
    def target_node_count(self) -> int:
        """
        The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes the target node count for the ongoing resize operation. If the allocationState is steady, this property denotes the target node count for the previous resize operation.
        """
        return pulumi.get(self, "target_node_count")

    @property
    @pulumi.getter(name="remoteLoginPortPublicAccess")
    def remote_login_port_public_access(self) -> Optional[str]:
        """
        State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
        """
        return pulumi.get(self, "remote_login_port_public_access")

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional['outputs.ScaleSettingsResponse']:
        """
        Scale settings for AML Compute
        """
        return pulumi.get(self, "scale_settings")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.ResourceIdResponse']:
        """
        Virtual network subnet resource ID the compute nodes belong to.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="userAccountCredentials")
    def user_account_credentials(self) -> Optional['outputs.UserAccountCredentialsResponse']:
        """
        Credentials for an administrator user account that will be created on each compute node.
        """
        return pulumi.get(self, "user_account_credentials")

    @property
    @pulumi.getter(name="vmPriority")
    def vm_priority(self) -> Optional[str]:
        """
        Virtual Machine priority
        """
        return pulumi.get(self, "vm_priority")

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[str]:
        """
        Virtual Machine Size
        """
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class DataFactoryResponse(dict):
    """
    A DataFactory compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataFactoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataFactoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataFactoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 resource_id: Optional[str] = None):
        """
        A DataFactory compute.
        :param str compute_type: The type of compute
               Expected value is 'DataFactory'.
        :param str created_on: The date and time when the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The date and time when the compute was last modified.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'DataFactory')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'DataFactory'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The date and time when the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The date and time when the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class DataLakeAnalyticsResponse(dict):
    """
    A DataLakeAnalytics compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLakeAnalyticsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLakeAnalyticsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLakeAnalyticsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional['outputs.DataLakeAnalyticsResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A DataLakeAnalytics compute.
        :param str compute_type: The type of compute
               Expected value is 'DataLakeAnalytics'.
        :param str created_on: The date and time when the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The date and time when the compute was last modified.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'DataLakeAnalytics')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'DataLakeAnalytics'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The date and time when the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The date and time when the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.DataLakeAnalyticsResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class DataLakeAnalyticsResponseProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataLakeStoreAccountName":
            suggest = "data_lake_store_account_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLakeAnalyticsResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLakeAnalyticsResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLakeAnalyticsResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_lake_store_account_name: Optional[str] = None):
        """
        :param str data_lake_store_account_name: DataLake Store Account Name
        """
        if data_lake_store_account_name is not None:
            pulumi.set(__self__, "data_lake_store_account_name", data_lake_store_account_name)

    @property
    @pulumi.getter(name="dataLakeStoreAccountName")
    def data_lake_store_account_name(self) -> Optional[str]:
        """
        DataLake Store Account Name
        """
        return pulumi.get(self, "data_lake_store_account_name")


@pulumi.output_type
class DatabricksResponse(dict):
    """
    A DataFactory compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabricksResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabricksResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabricksResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional['outputs.DatabricksResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A DataFactory compute.
        :param str compute_type: The type of compute
               Expected value is 'Databricks'.
        :param str created_on: The date and time when the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The date and time when the compute was last modified.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'Databricks')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'Databricks'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The date and time when the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The date and time when the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.DatabricksResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class DatabricksResponseProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databricksAccessToken":
            suggest = "databricks_access_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabricksResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabricksResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabricksResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 databricks_access_token: Optional[str] = None):
        """
        :param str databricks_access_token: Databricks access token
        """
        if databricks_access_token is not None:
            pulumi.set(__self__, "databricks_access_token", databricks_access_token)

    @property
    @pulumi.getter(name="databricksAccessToken")
    def databricks_access_token(self) -> Optional[str]:
        """
        Databricks access token
        """
        return pulumi.get(self, "databricks_access_token")


@pulumi.output_type
class EncryptionPropertyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionPropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionPropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionPropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_vault_properties: 'outputs.KeyVaultPropertiesResponse',
                 status: str):
        """
        :param 'KeyVaultPropertiesResponse' key_vault_properties: Customer Key vault properties.
        :param str status: Indicates whether or not the encryption is enabled for the workspace.
        """
        pulumi.set(__self__, "key_vault_properties", key_vault_properties)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> 'outputs.KeyVaultPropertiesResponse':
        """
        Customer Key vault properties.
        """
        return pulumi.get(self, "key_vault_properties")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates whether or not the encryption is enabled for the workspace.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ErrorDetailResponse(dict):
    """
    Error detail information.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str):
        """
        Error detail information.
        :param str code: Error code.
        :param str message: Error message.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Error message.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ErrorResponseResponse(dict):
    """
    Error response information.
    """
    def __init__(__self__, *,
                 code: str,
                 details: Sequence['outputs.ErrorDetailResponse'],
                 message: str):
        """
        Error response information.
        :param str code: Error code.
        :param Sequence['ErrorDetailResponse'] details: An array of error detail objects.
        :param str message: Error message.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.ErrorDetailResponse']:
        """
        An array of error detail objects.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Error message.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class HDInsightResponse(dict):
    """
    A HDInsight compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HDInsightResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HDInsightResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HDInsightResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional['outputs.HDInsightResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A HDInsight compute.
        :param str compute_type: The type of compute
               Expected value is 'HDInsight'.
        :param str created_on: The date and time when the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The date and time when the compute was last modified.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'HDInsight')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'HDInsight'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The date and time when the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The date and time when the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.HDInsightResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class HDInsightResponseProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "administratorAccount":
            suggest = "administrator_account"
        elif key == "sshPort":
            suggest = "ssh_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HDInsightResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HDInsightResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HDInsightResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 administrator_account: Optional['outputs.VirtualMachineSshCredentialsResponse'] = None,
                 ssh_port: Optional[int] = None):
        """
        :param str address: Public IP address of the master node of the cluster.
        :param 'VirtualMachineSshCredentialsResponse' administrator_account: Admin credentials for master node of the cluster
        :param int ssh_port: Port open for ssh connections on the master node of the cluster.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if administrator_account is not None:
            pulumi.set(__self__, "administrator_account", administrator_account)
        if ssh_port is not None:
            pulumi.set(__self__, "ssh_port", ssh_port)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Public IP address of the master node of the cluster.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="administratorAccount")
    def administrator_account(self) -> Optional['outputs.VirtualMachineSshCredentialsResponse']:
        """
        Admin credentials for master node of the cluster
        """
        return pulumi.get(self, "administrator_account")

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> Optional[int]:
        """
        Port open for ssh connections on the master node of the cluster.
        """
        return pulumi.get(self, "ssh_port")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class KeyVaultPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyIdentifier":
            suggest = "key_identifier"
        elif key == "keyVaultArmId":
            suggest = "key_vault_arm_id"
        elif key == "identityClientId":
            suggest = "identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_identifier: str,
                 key_vault_arm_id: str,
                 identity_client_id: Optional[str] = None):
        """
        :param str key_identifier: Key vault uri to access the encryption key.
        :param str key_vault_arm_id: The ArmId of the keyVault where the customer owned encryption key is present.
        :param str identity_client_id: For future use - The client id of the identity which will be used to access key vault.
        """
        pulumi.set(__self__, "key_identifier", key_identifier)
        pulumi.set(__self__, "key_vault_arm_id", key_vault_arm_id)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> str:
        """
        Key vault uri to access the encryption key.
        """
        return pulumi.get(self, "key_identifier")

    @property
    @pulumi.getter(name="keyVaultArmId")
    def key_vault_arm_id(self) -> str:
        """
        The ArmId of the keyVault where the customer owned encryption key is present.
        """
        return pulumi.get(self, "key_vault_arm_id")

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[str]:
        """
        For future use - The client id of the identity which will be used to access key vault.
        """
        return pulumi.get(self, "identity_client_id")


@pulumi.output_type
class MachineLearningServiceErrorResponse(dict):
    """
    Wrapper for error response to follow ARM guidelines.
    """
    def __init__(__self__, *,
                 error: 'outputs.ErrorResponseResponse'):
        """
        Wrapper for error response to follow ARM guidelines.
        :param 'ErrorResponseResponse' error: The error response.
        """
        pulumi.set(__self__, "error", error)

    @property
    @pulumi.getter
    def error(self) -> 'outputs.ErrorResponseResponse':
        """
        The error response.
        """
        return pulumi.get(self, "error")


@pulumi.output_type
class NodeStateCountsResponse(dict):
    """
    Counts of various compute node states on the amlCompute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleNodeCount":
            suggest = "idle_node_count"
        elif key == "leavingNodeCount":
            suggest = "leaving_node_count"
        elif key == "preemptedNodeCount":
            suggest = "preempted_node_count"
        elif key == "preparingNodeCount":
            suggest = "preparing_node_count"
        elif key == "runningNodeCount":
            suggest = "running_node_count"
        elif key == "unusableNodeCount":
            suggest = "unusable_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeStateCountsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeStateCountsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeStateCountsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idle_node_count: int,
                 leaving_node_count: int,
                 preempted_node_count: int,
                 preparing_node_count: int,
                 running_node_count: int,
                 unusable_node_count: int):
        """
        Counts of various compute node states on the amlCompute.
        :param int idle_node_count: Number of compute nodes in idle state.
        :param int leaving_node_count: Number of compute nodes which are leaving the amlCompute.
        :param int preempted_node_count: Number of compute nodes which are in preempted state.
        :param int preparing_node_count: Number of compute nodes which are being prepared.
        :param int running_node_count: Number of compute nodes which are running jobs.
        :param int unusable_node_count: Number of compute nodes which are in unusable state.
        """
        pulumi.set(__self__, "idle_node_count", idle_node_count)
        pulumi.set(__self__, "leaving_node_count", leaving_node_count)
        pulumi.set(__self__, "preempted_node_count", preempted_node_count)
        pulumi.set(__self__, "preparing_node_count", preparing_node_count)
        pulumi.set(__self__, "running_node_count", running_node_count)
        pulumi.set(__self__, "unusable_node_count", unusable_node_count)

    @property
    @pulumi.getter(name="idleNodeCount")
    def idle_node_count(self) -> int:
        """
        Number of compute nodes in idle state.
        """
        return pulumi.get(self, "idle_node_count")

    @property
    @pulumi.getter(name="leavingNodeCount")
    def leaving_node_count(self) -> int:
        """
        Number of compute nodes which are leaving the amlCompute.
        """
        return pulumi.get(self, "leaving_node_count")

    @property
    @pulumi.getter(name="preemptedNodeCount")
    def preempted_node_count(self) -> int:
        """
        Number of compute nodes which are in preempted state.
        """
        return pulumi.get(self, "preempted_node_count")

    @property
    @pulumi.getter(name="preparingNodeCount")
    def preparing_node_count(self) -> int:
        """
        Number of compute nodes which are being prepared.
        """
        return pulumi.get(self, "preparing_node_count")

    @property
    @pulumi.getter(name="runningNodeCount")
    def running_node_count(self) -> int:
        """
        Number of compute nodes which are running jobs.
        """
        return pulumi.get(self, "running_node_count")

    @property
    @pulumi.getter(name="unusableNodeCount")
    def unusable_node_count(self) -> int:
        """
        Number of compute nodes which are in unusable state.
        """
        return pulumi.get(self, "unusable_node_count")


@pulumi.output_type
class PasswordResponse(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The Private Endpoint resource.
        :param str id: The ARM identifier for Private Endpoint
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ARM identifier for Private Endpoint
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    A collection of information about the state of the connection between service consumer and provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionRequired":
            suggest = "action_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param str action_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The reason for approval/rejection of the connection.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if action_required is not None:
            pulumi.set(__self__, "action_required", action_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionRequired")
    def action_required(self) -> Optional[str]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "action_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class RegistryListCredentialsResultResponse(dict):
    def __init__(__self__, *,
                 location: str,
                 username: str,
                 passwords: Optional[Sequence['outputs.PasswordResponse']] = None):
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "username", username)
        if passwords is not None:
            pulumi.set(__self__, "passwords", passwords)

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def passwords(self) -> Optional[Sequence['outputs.PasswordResponse']]:
        return pulumi.get(self, "passwords")


@pulumi.output_type
class ResourceIdResponse(dict):
    """
    Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
    """
    def __init__(__self__, *,
                 id: str):
        """
        Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
        :param str id: The ID of the resource
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the resource
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ScaleSettingsResponse(dict):
    """
    scale settings for AML Compute
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "minNodeCount":
            suggest = "min_node_count"
        elif key == "nodeIdleTimeBeforeScaleDown":
            suggest = "node_idle_time_before_scale_down"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_node_count: int,
                 min_node_count: Optional[int] = None,
                 node_idle_time_before_scale_down: Optional[str] = None):
        """
        scale settings for AML Compute
        :param int max_node_count: Max number of nodes to use
        :param int min_node_count: Min number of nodes to use
        :param str node_idle_time_before_scale_down: Node Idle Time before scaling down amlCompute
        """
        pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is None:
            min_node_count = 0
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)
        if node_idle_time_before_scale_down is not None:
            pulumi.set(__self__, "node_idle_time_before_scale_down", node_idle_time_before_scale_down)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> int:
        """
        Max number of nodes to use
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[int]:
        """
        Min number of nodes to use
        """
        return pulumi.get(self, "min_node_count")

    @property
    @pulumi.getter(name="nodeIdleTimeBeforeScaleDown")
    def node_idle_time_before_scale_down(self) -> Optional[str]:
        """
        Node Idle Time before scaling down amlCompute
        """
        return pulumi.get(self, "node_idle_time_before_scale_down")


@pulumi.output_type
class SkuResponse(dict):
    """
    Sku of the resource
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        Sku of the resource
        :param str name: Name of the sku
        :param str tier: Tier of the sku like Basic or Enterprise
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the sku
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Tier of the sku like Basic or Enterprise
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SslConfigurationResponse(dict):
    """
    The ssl configuration for scoring
    """
    def __init__(__self__, *,
                 cert: Optional[str] = None,
                 cname: Optional[str] = None,
                 key: Optional[str] = None,
                 status: Optional[str] = None):
        """
        The ssl configuration for scoring
        :param str cert: Cert data
        :param str cname: CNAME of the cert
        :param str key: Key data
        :param str status: Enable or disable ssl for scoring
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def cert(self) -> Optional[str]:
        """
        Cert data
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter
    def cname(self) -> Optional[str]:
        """
        CNAME of the cert
        """
        return pulumi.get(self, "cname")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        Key data
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Enable or disable ssl for scoring
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class SystemServiceResponse(dict):
    """
    A system service running on a compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicIpAddress":
            suggest = "public_ip_address"
        elif key == "systemServiceType":
            suggest = "system_service_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_ip_address: str,
                 system_service_type: str,
                 version: str):
        """
        A system service running on a compute.
        :param str public_ip_address: Public IP address
        :param str system_service_type: The type of this system service.
        :param str version: The version for this type.
        """
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        pulumi.set(__self__, "system_service_type", system_service_type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        """
        Public IP address
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter(name="systemServiceType")
    def system_service_type(self) -> str:
        """
        The type of this system service.
        """
        return pulumi.get(self, "system_service_type")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version for this type.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class UserAccountCredentialsResponse(dict):
    """
    Settings for user account that gets created on each on the nodes of a compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminUserName":
            suggest = "admin_user_name"
        elif key == "adminUserPassword":
            suggest = "admin_user_password"
        elif key == "adminUserSshPublicKey":
            suggest = "admin_user_ssh_public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAccountCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAccountCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAccountCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_user_name: str,
                 admin_user_password: Optional[str] = None,
                 admin_user_ssh_public_key: Optional[str] = None):
        """
        Settings for user account that gets created on each on the nodes of a compute.
        :param str admin_user_name: Name of the administrator user account which can be used to SSH to nodes.
        :param str admin_user_password: Password of the administrator user account.
        :param str admin_user_ssh_public_key: SSH public key of the administrator user account.
        """
        pulumi.set(__self__, "admin_user_name", admin_user_name)
        if admin_user_password is not None:
            pulumi.set(__self__, "admin_user_password", admin_user_password)
        if admin_user_ssh_public_key is not None:
            pulumi.set(__self__, "admin_user_ssh_public_key", admin_user_ssh_public_key)

    @property
    @pulumi.getter(name="adminUserName")
    def admin_user_name(self) -> str:
        """
        Name of the administrator user account which can be used to SSH to nodes.
        """
        return pulumi.get(self, "admin_user_name")

    @property
    @pulumi.getter(name="adminUserPassword")
    def admin_user_password(self) -> Optional[str]:
        """
        Password of the administrator user account.
        """
        return pulumi.get(self, "admin_user_password")

    @property
    @pulumi.getter(name="adminUserSshPublicKey")
    def admin_user_ssh_public_key(self) -> Optional[str]:
        """
        SSH public key of the administrator user account.
        """
        return pulumi.get(self, "admin_user_ssh_public_key")


@pulumi.output_type
class VirtualMachineResponse(dict):
    """
    A Machine Learning compute based on Azure Virtual Machines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional['outputs.VirtualMachineResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A Machine Learning compute based on Azure Virtual Machines.
        :param str compute_type: The type of compute
               Expected value is 'VirtualMachine'.
        :param str created_on: The date and time when the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The date and time when the compute was last modified.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'VirtualMachine')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'VirtualMachine'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The date and time when the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The date and time when the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.VirtualMachineResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class VirtualMachineResponseProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "administratorAccount":
            suggest = "administrator_account"
        elif key == "sshPort":
            suggest = "ssh_port"
        elif key == "virtualMachineSize":
            suggest = "virtual_machine_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 administrator_account: Optional['outputs.VirtualMachineSshCredentialsResponse'] = None,
                 ssh_port: Optional[int] = None,
                 virtual_machine_size: Optional[str] = None):
        """
        :param str address: Public IP address of the virtual machine.
        :param 'VirtualMachineSshCredentialsResponse' administrator_account: Admin credentials for virtual machine
        :param int ssh_port: Port open for ssh connections.
        :param str virtual_machine_size: Virtual Machine size
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if administrator_account is not None:
            pulumi.set(__self__, "administrator_account", administrator_account)
        if ssh_port is not None:
            pulumi.set(__self__, "ssh_port", ssh_port)
        if virtual_machine_size is not None:
            pulumi.set(__self__, "virtual_machine_size", virtual_machine_size)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Public IP address of the virtual machine.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="administratorAccount")
    def administrator_account(self) -> Optional['outputs.VirtualMachineSshCredentialsResponse']:
        """
        Admin credentials for virtual machine
        """
        return pulumi.get(self, "administrator_account")

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> Optional[int]:
        """
        Port open for ssh connections.
        """
        return pulumi.get(self, "ssh_port")

    @property
    @pulumi.getter(name="virtualMachineSize")
    def virtual_machine_size(self) -> Optional[str]:
        """
        Virtual Machine size
        """
        return pulumi.get(self, "virtual_machine_size")


@pulumi.output_type
class VirtualMachineSshCredentialsResponse(dict):
    """
    Admin credentials for virtual machine
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKeyData":
            suggest = "private_key_data"
        elif key == "publicKeyData":
            suggest = "public_key_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineSshCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineSshCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineSshCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: Optional[str] = None,
                 private_key_data: Optional[str] = None,
                 public_key_data: Optional[str] = None,
                 username: Optional[str] = None):
        """
        Admin credentials for virtual machine
        :param str password: Password of admin account
        :param str private_key_data: Private key data
        :param str public_key_data: Public key data
        :param str username: Username of admin account
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key_data is not None:
            pulumi.set(__self__, "private_key_data", private_key_data)
        if public_key_data is not None:
            pulumi.set(__self__, "public_key_data", public_key_data)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password of admin account
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="privateKeyData")
    def private_key_data(self) -> Optional[str]:
        """
        Private key data
        """
        return pulumi.get(self, "private_key_data")

    @property
    @pulumi.getter(name="publicKeyData")
    def public_key_data(self) -> Optional[str]:
        """
        Public key data
        """
        return pulumi.get(self, "public_key_data")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username of admin account
        """
        return pulumi.get(self, "username")


