# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'ApplicationDeltaHealthPolicyArgs',
    'ApplicationHealthPolicyArgs',
    'AzureActiveDirectoryArgs',
    'CertificateDescriptionArgs',
    'ClientCertificateCommonNameArgs',
    'ClientCertificateThumbprintArgs',
    'ClusterHealthPolicyArgs',
    'ClusterUpgradeDeltaHealthPolicyArgs',
    'ClusterUpgradePolicyArgs',
    'DiagnosticsStorageAccountConfigArgs',
    'EndpointRangeDescriptionArgs',
    'NodeTypeDescriptionArgs',
    'ServerCertificateCommonNamesArgs',
    'ServerCertificateCommonNameArgs',
    'ServiceTypeDeltaHealthPolicyArgs',
    'ServiceTypeHealthPolicyArgs',
    'SettingsParameterDescriptionArgs',
    'SettingsSectionDescriptionArgs',
]

@pulumi.input_type
class ApplicationDeltaHealthPolicyArgs:
    def __init__(__self__, *,
                 default_service_type_delta_health_policy: Optional[pulumi.Input['ServiceTypeDeltaHealthPolicyArgs']] = None,
                 service_type_delta_health_policies: Optional[pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeDeltaHealthPolicyArgs']]]] = None):
        """
        Defines a delta health policy used to evaluate the health of an application or one of its child entities when upgrading the cluster.

        :param pulumi.Input['ServiceTypeDeltaHealthPolicyArgs'] default_service_type_delta_health_policy: The delta health policy used by default to evaluate the health of a service type when upgrading the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeDeltaHealthPolicyArgs']]] service_type_delta_health_policies: The map with service type delta health policy per service type name. The map is empty by default.
        """
        if default_service_type_delta_health_policy is not None:
            pulumi.set(__self__, "default_service_type_delta_health_policy", default_service_type_delta_health_policy)
        if service_type_delta_health_policies is not None:
            pulumi.set(__self__, "service_type_delta_health_policies", service_type_delta_health_policies)

    @property
    @pulumi.getter(name="defaultServiceTypeDeltaHealthPolicy")
    def default_service_type_delta_health_policy(self) -> Optional[pulumi.Input['ServiceTypeDeltaHealthPolicyArgs']]:
        """
        The delta health policy used by default to evaluate the health of a service type when upgrading the cluster.
        """
        return pulumi.get(self, "default_service_type_delta_health_policy")

    @default_service_type_delta_health_policy.setter
    def default_service_type_delta_health_policy(self, value: Optional[pulumi.Input['ServiceTypeDeltaHealthPolicyArgs']]):
        pulumi.set(self, "default_service_type_delta_health_policy", value)

    @property
    @pulumi.getter(name="serviceTypeDeltaHealthPolicies")
    def service_type_delta_health_policies(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeDeltaHealthPolicyArgs']]]]:
        """
        The map with service type delta health policy per service type name. The map is empty by default.
        """
        return pulumi.get(self, "service_type_delta_health_policies")

    @service_type_delta_health_policies.setter
    def service_type_delta_health_policies(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeDeltaHealthPolicyArgs']]]]):
        pulumi.set(self, "service_type_delta_health_policies", value)


@pulumi.input_type
class ApplicationHealthPolicyArgs:
    def __init__(__self__, *,
                 default_service_type_health_policy: Optional[pulumi.Input['ServiceTypeHealthPolicyArgs']] = None,
                 service_type_health_policies: Optional[pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeHealthPolicyArgs']]]] = None):
        """
        Defines a health policy used to evaluate the health of an application or one of its children entities.

        :param pulumi.Input['ServiceTypeHealthPolicyArgs'] default_service_type_health_policy: The health policy used by default to evaluate the health of a service type.
        :param pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeHealthPolicyArgs']]] service_type_health_policies: The map with service type health policy per service type name. The map is empty by default.
        """
        if default_service_type_health_policy is not None:
            pulumi.set(__self__, "default_service_type_health_policy", default_service_type_health_policy)
        if service_type_health_policies is not None:
            pulumi.set(__self__, "service_type_health_policies", service_type_health_policies)

    @property
    @pulumi.getter(name="defaultServiceTypeHealthPolicy")
    def default_service_type_health_policy(self) -> Optional[pulumi.Input['ServiceTypeHealthPolicyArgs']]:
        """
        The health policy used by default to evaluate the health of a service type.
        """
        return pulumi.get(self, "default_service_type_health_policy")

    @default_service_type_health_policy.setter
    def default_service_type_health_policy(self, value: Optional[pulumi.Input['ServiceTypeHealthPolicyArgs']]):
        pulumi.set(self, "default_service_type_health_policy", value)

    @property
    @pulumi.getter(name="serviceTypeHealthPolicies")
    def service_type_health_policies(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeHealthPolicyArgs']]]]:
        """
        The map with service type health policy per service type name. The map is empty by default.
        """
        return pulumi.get(self, "service_type_health_policies")

    @service_type_health_policies.setter
    def service_type_health_policies(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeHealthPolicyArgs']]]]):
        pulumi.set(self, "service_type_health_policies", value)


@pulumi.input_type
class AzureActiveDirectoryArgs:
    def __init__(__self__, *,
                 client_application: Optional[pulumi.Input[str]] = None,
                 cluster_application: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        The settings to enable AAD authentication on the cluster.
        :param pulumi.Input[str] client_application: Azure active directory client application id.
        :param pulumi.Input[str] cluster_application: Azure active directory cluster application id.
        :param pulumi.Input[str] tenant_id: Azure active directory tenant id.
        """
        if client_application is not None:
            pulumi.set(__self__, "client_application", client_application)
        if cluster_application is not None:
            pulumi.set(__self__, "cluster_application", cluster_application)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientApplication")
    def client_application(self) -> Optional[pulumi.Input[str]]:
        """
        Azure active directory client application id.
        """
        return pulumi.get(self, "client_application")

    @client_application.setter
    def client_application(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_application", value)

    @property
    @pulumi.getter(name="clusterApplication")
    def cluster_application(self) -> Optional[pulumi.Input[str]]:
        """
        Azure active directory cluster application id.
        """
        return pulumi.get(self, "cluster_application")

    @cluster_application.setter
    def cluster_application(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_application", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure active directory tenant id.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class CertificateDescriptionArgs:
    def __init__(__self__, *,
                 thumbprint: pulumi.Input[str],
                 thumbprint_secondary: Optional[pulumi.Input[str]] = None,
                 x509_store_name: Optional[pulumi.Input[str]] = None):
        """
        Describes the certificate details.
        :param pulumi.Input[str] thumbprint: Thumbprint of the primary certificate.
        :param pulumi.Input[str] thumbprint_secondary: Thumbprint of the secondary certificate.
        :param pulumi.Input[str] x509_store_name: The local certificate store location.
        """
        pulumi.set(__self__, "thumbprint", thumbprint)
        if thumbprint_secondary is not None:
            pulumi.set(__self__, "thumbprint_secondary", thumbprint_secondary)
        if x509_store_name is not None:
            pulumi.set(__self__, "x509_store_name", x509_store_name)

    @property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Input[str]:
        """
        Thumbprint of the primary certificate.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: pulumi.Input[str]):
        pulumi.set(self, "thumbprint", value)

    @property
    @pulumi.getter(name="thumbprintSecondary")
    def thumbprint_secondary(self) -> Optional[pulumi.Input[str]]:
        """
        Thumbprint of the secondary certificate.
        """
        return pulumi.get(self, "thumbprint_secondary")

    @thumbprint_secondary.setter
    def thumbprint_secondary(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint_secondary", value)

    @property
    @pulumi.getter(name="x509StoreName")
    def x509_store_name(self) -> Optional[pulumi.Input[str]]:
        """
        The local certificate store location.
        """
        return pulumi.get(self, "x509_store_name")

    @x509_store_name.setter
    def x509_store_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x509_store_name", value)


@pulumi.input_type
class ClientCertificateCommonNameArgs:
    def __init__(__self__, *,
                 certificate_common_name: pulumi.Input[str],
                 certificate_issuer_thumbprint: pulumi.Input[str],
                 is_admin: pulumi.Input[bool]):
        """
        Describes the client certificate details using common name.
        :param pulumi.Input[str] certificate_common_name: The common name of the client certificate.
        :param pulumi.Input[str] certificate_issuer_thumbprint: The issuer thumbprint of the client certificate.
        :param pulumi.Input[bool] is_admin: Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
        """
        pulumi.set(__self__, "certificate_common_name", certificate_common_name)
        pulumi.set(__self__, "certificate_issuer_thumbprint", certificate_issuer_thumbprint)
        pulumi.set(__self__, "is_admin", is_admin)

    @property
    @pulumi.getter(name="certificateCommonName")
    def certificate_common_name(self) -> pulumi.Input[str]:
        """
        The common name of the client certificate.
        """
        return pulumi.get(self, "certificate_common_name")

    @certificate_common_name.setter
    def certificate_common_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_common_name", value)

    @property
    @pulumi.getter(name="certificateIssuerThumbprint")
    def certificate_issuer_thumbprint(self) -> pulumi.Input[str]:
        """
        The issuer thumbprint of the client certificate.
        """
        return pulumi.get(self, "certificate_issuer_thumbprint")

    @certificate_issuer_thumbprint.setter
    def certificate_issuer_thumbprint(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_issuer_thumbprint", value)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> pulumi.Input[bool]:
        """
        Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_admin", value)


@pulumi.input_type
class ClientCertificateThumbprintArgs:
    def __init__(__self__, *,
                 certificate_thumbprint: pulumi.Input[str],
                 is_admin: pulumi.Input[bool]):
        """
        Describes the client certificate details using thumbprint.
        :param pulumi.Input[str] certificate_thumbprint: The thumbprint of the client certificate.
        :param pulumi.Input[bool] is_admin: Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
        """
        pulumi.set(__self__, "certificate_thumbprint", certificate_thumbprint)
        pulumi.set(__self__, "is_admin", is_admin)

    @property
    @pulumi.getter(name="certificateThumbprint")
    def certificate_thumbprint(self) -> pulumi.Input[str]:
        """
        The thumbprint of the client certificate.
        """
        return pulumi.get(self, "certificate_thumbprint")

    @certificate_thumbprint.setter
    def certificate_thumbprint(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_thumbprint", value)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> pulumi.Input[bool]:
        """
        Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_admin", value)


@pulumi.input_type
class ClusterHealthPolicyArgs:
    def __init__(__self__, *,
                 application_health_policies: Optional[pulumi.Input[Mapping[str, pulumi.Input['ApplicationHealthPolicyArgs']]]] = None,
                 max_percent_unhealthy_applications: Optional[pulumi.Input[int]] = None,
                 max_percent_unhealthy_nodes: Optional[pulumi.Input[int]] = None):
        """
        Defines a health policy used to evaluate the health of the cluster or of a cluster node.

        :param pulumi.Input[Mapping[str, pulumi.Input['ApplicationHealthPolicyArgs']]] application_health_policies: Defines the application health policy map used to evaluate the health of an application or one of its children entities.
        :param pulumi.Input[int] max_percent_unhealthy_applications: The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications to be unhealthy, this value would be 10.
               
               The percentage represents the maximum tolerated percentage of applications that can be unhealthy before the cluster is considered in error.
               If the percentage is respected but there is at least one unhealthy application, the health is evaluated as Warning.
               This is calculated by dividing the number of unhealthy applications over the total number of application instances in the cluster, excluding applications of application types that are included in the ApplicationTypeHealthPolicyMap.
               The computation rounds up to tolerate one failure on small numbers of applications. Default percentage is zero.
        :param pulumi.Input[int] max_percent_unhealthy_nodes: The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10.
               
               The percentage represents the maximum tolerated percentage of nodes that can be unhealthy before the cluster is considered in error.
               If the percentage is respected but there is at least one unhealthy node, the health is evaluated as Warning.
               The percentage is calculated by dividing the number of unhealthy nodes over the total number of nodes in the cluster.
               The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
               
               In large clusters, some nodes will always be down or out for repairs, so this percentage should be configured to tolerate that.
        """
        if application_health_policies is not None:
            pulumi.set(__self__, "application_health_policies", application_health_policies)
        if max_percent_unhealthy_applications is None:
            max_percent_unhealthy_applications = 0
        if max_percent_unhealthy_applications is not None:
            pulumi.set(__self__, "max_percent_unhealthy_applications", max_percent_unhealthy_applications)
        if max_percent_unhealthy_nodes is None:
            max_percent_unhealthy_nodes = 0
        if max_percent_unhealthy_nodes is not None:
            pulumi.set(__self__, "max_percent_unhealthy_nodes", max_percent_unhealthy_nodes)

    @property
    @pulumi.getter(name="applicationHealthPolicies")
    def application_health_policies(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ApplicationHealthPolicyArgs']]]]:
        """
        Defines the application health policy map used to evaluate the health of an application or one of its children entities.
        """
        return pulumi.get(self, "application_health_policies")

    @application_health_policies.setter
    def application_health_policies(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ApplicationHealthPolicyArgs']]]]):
        pulumi.set(self, "application_health_policies", value)

    @property
    @pulumi.getter(name="maxPercentUnhealthyApplications")
    def max_percent_unhealthy_applications(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications to be unhealthy, this value would be 10.

        The percentage represents the maximum tolerated percentage of applications that can be unhealthy before the cluster is considered in error.
        If the percentage is respected but there is at least one unhealthy application, the health is evaluated as Warning.
        This is calculated by dividing the number of unhealthy applications over the total number of application instances in the cluster, excluding applications of application types that are included in the ApplicationTypeHealthPolicyMap.
        The computation rounds up to tolerate one failure on small numbers of applications. Default percentage is zero.
        """
        return pulumi.get(self, "max_percent_unhealthy_applications")

    @max_percent_unhealthy_applications.setter
    def max_percent_unhealthy_applications(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_percent_unhealthy_applications", value)

    @property
    @pulumi.getter(name="maxPercentUnhealthyNodes")
    def max_percent_unhealthy_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10.

        The percentage represents the maximum tolerated percentage of nodes that can be unhealthy before the cluster is considered in error.
        If the percentage is respected but there is at least one unhealthy node, the health is evaluated as Warning.
        The percentage is calculated by dividing the number of unhealthy nodes over the total number of nodes in the cluster.
        The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.

        In large clusters, some nodes will always be down or out for repairs, so this percentage should be configured to tolerate that.
        """
        return pulumi.get(self, "max_percent_unhealthy_nodes")

    @max_percent_unhealthy_nodes.setter
    def max_percent_unhealthy_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_percent_unhealthy_nodes", value)


@pulumi.input_type
class ClusterUpgradeDeltaHealthPolicyArgs:
    def __init__(__self__, *,
                 max_percent_delta_unhealthy_applications: pulumi.Input[int],
                 max_percent_delta_unhealthy_nodes: pulumi.Input[int],
                 max_percent_upgrade_domain_delta_unhealthy_nodes: pulumi.Input[int],
                 application_delta_health_policies: Optional[pulumi.Input[Mapping[str, pulumi.Input['ApplicationDeltaHealthPolicyArgs']]]] = None):
        """
        Describes the delta health policies for the cluster upgrade.
        :param pulumi.Input[int] max_percent_delta_unhealthy_applications: The maximum allowed percentage of applications health degradation allowed during cluster upgrades.
               The delta is measured between the state of the applications at the beginning of upgrade and the state of the applications at the time of the health evaluation.
               The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits. System services are not included in this.
        :param pulumi.Input[int] max_percent_delta_unhealthy_nodes: The maximum allowed percentage of nodes health degradation allowed during cluster upgrades.
               The delta is measured between the state of the nodes at the beginning of upgrade and the state of the nodes at the time of the health evaluation.
               The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
        :param pulumi.Input[int] max_percent_upgrade_domain_delta_unhealthy_nodes: The maximum allowed percentage of upgrade domain nodes health degradation allowed during cluster upgrades.
               The delta is measured between the state of the upgrade domain nodes at the beginning of upgrade and the state of the upgrade domain nodes at the time of the health evaluation.
               The check is performed after every upgrade domain upgrade completion for all completed upgrade domains to make sure the state of the upgrade domains is within tolerated limits.
        :param pulumi.Input[Mapping[str, pulumi.Input['ApplicationDeltaHealthPolicyArgs']]] application_delta_health_policies: Defines the application delta health policy map used to evaluate the health of an application or one of its child entities when upgrading the cluster.
        """
        pulumi.set(__self__, "max_percent_delta_unhealthy_applications", max_percent_delta_unhealthy_applications)
        pulumi.set(__self__, "max_percent_delta_unhealthy_nodes", max_percent_delta_unhealthy_nodes)
        pulumi.set(__self__, "max_percent_upgrade_domain_delta_unhealthy_nodes", max_percent_upgrade_domain_delta_unhealthy_nodes)
        if application_delta_health_policies is not None:
            pulumi.set(__self__, "application_delta_health_policies", application_delta_health_policies)

    @property
    @pulumi.getter(name="maxPercentDeltaUnhealthyApplications")
    def max_percent_delta_unhealthy_applications(self) -> pulumi.Input[int]:
        """
        The maximum allowed percentage of applications health degradation allowed during cluster upgrades.
        The delta is measured between the state of the applications at the beginning of upgrade and the state of the applications at the time of the health evaluation.
        The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits. System services are not included in this.
        """
        return pulumi.get(self, "max_percent_delta_unhealthy_applications")

    @max_percent_delta_unhealthy_applications.setter
    def max_percent_delta_unhealthy_applications(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_percent_delta_unhealthy_applications", value)

    @property
    @pulumi.getter(name="maxPercentDeltaUnhealthyNodes")
    def max_percent_delta_unhealthy_nodes(self) -> pulumi.Input[int]:
        """
        The maximum allowed percentage of nodes health degradation allowed during cluster upgrades.
        The delta is measured between the state of the nodes at the beginning of upgrade and the state of the nodes at the time of the health evaluation.
        The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
        """
        return pulumi.get(self, "max_percent_delta_unhealthy_nodes")

    @max_percent_delta_unhealthy_nodes.setter
    def max_percent_delta_unhealthy_nodes(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_percent_delta_unhealthy_nodes", value)

    @property
    @pulumi.getter(name="maxPercentUpgradeDomainDeltaUnhealthyNodes")
    def max_percent_upgrade_domain_delta_unhealthy_nodes(self) -> pulumi.Input[int]:
        """
        The maximum allowed percentage of upgrade domain nodes health degradation allowed during cluster upgrades.
        The delta is measured between the state of the upgrade domain nodes at the beginning of upgrade and the state of the upgrade domain nodes at the time of the health evaluation.
        The check is performed after every upgrade domain upgrade completion for all completed upgrade domains to make sure the state of the upgrade domains is within tolerated limits.
        """
        return pulumi.get(self, "max_percent_upgrade_domain_delta_unhealthy_nodes")

    @max_percent_upgrade_domain_delta_unhealthy_nodes.setter
    def max_percent_upgrade_domain_delta_unhealthy_nodes(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_percent_upgrade_domain_delta_unhealthy_nodes", value)

    @property
    @pulumi.getter(name="applicationDeltaHealthPolicies")
    def application_delta_health_policies(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ApplicationDeltaHealthPolicyArgs']]]]:
        """
        Defines the application delta health policy map used to evaluate the health of an application or one of its child entities when upgrading the cluster.
        """
        return pulumi.get(self, "application_delta_health_policies")

    @application_delta_health_policies.setter
    def application_delta_health_policies(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ApplicationDeltaHealthPolicyArgs']]]]):
        pulumi.set(self, "application_delta_health_policies", value)


@pulumi.input_type
class ClusterUpgradePolicyArgs:
    def __init__(__self__, *,
                 health_check_retry_timeout: pulumi.Input[str],
                 health_check_stable_duration: pulumi.Input[str],
                 health_check_wait_duration: pulumi.Input[str],
                 health_policy: pulumi.Input['ClusterHealthPolicyArgs'],
                 upgrade_domain_timeout: pulumi.Input[str],
                 upgrade_replica_set_check_timeout: pulumi.Input[str],
                 upgrade_timeout: pulumi.Input[str],
                 delta_health_policy: Optional[pulumi.Input['ClusterUpgradeDeltaHealthPolicyArgs']] = None,
                 force_restart: Optional[pulumi.Input[bool]] = None):
        """
        Describes the policy used when upgrading the cluster.
        :param pulumi.Input[str] health_check_retry_timeout: The amount of time to retry health evaluation when the application or cluster is unhealthy before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param pulumi.Input[str] health_check_stable_duration: The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param pulumi.Input[str] health_check_wait_duration: The length of time to wait after completing an upgrade domain before performing health checks. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param pulumi.Input['ClusterHealthPolicyArgs'] health_policy: The cluster health policy used when upgrading the cluster.
        :param pulumi.Input[str] upgrade_domain_timeout: The amount of time each upgrade domain has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param pulumi.Input[str] upgrade_replica_set_check_timeout: The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param pulumi.Input[str] upgrade_timeout: The amount of time the overall upgrade has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param pulumi.Input['ClusterUpgradeDeltaHealthPolicyArgs'] delta_health_policy: The cluster delta health policy used when upgrading the cluster.
        :param pulumi.Input[bool] force_restart: If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
        """
        pulumi.set(__self__, "health_check_retry_timeout", health_check_retry_timeout)
        pulumi.set(__self__, "health_check_stable_duration", health_check_stable_duration)
        pulumi.set(__self__, "health_check_wait_duration", health_check_wait_duration)
        pulumi.set(__self__, "health_policy", health_policy)
        pulumi.set(__self__, "upgrade_domain_timeout", upgrade_domain_timeout)
        pulumi.set(__self__, "upgrade_replica_set_check_timeout", upgrade_replica_set_check_timeout)
        pulumi.set(__self__, "upgrade_timeout", upgrade_timeout)
        if delta_health_policy is not None:
            pulumi.set(__self__, "delta_health_policy", delta_health_policy)
        if force_restart is not None:
            pulumi.set(__self__, "force_restart", force_restart)

    @property
    @pulumi.getter(name="healthCheckRetryTimeout")
    def health_check_retry_timeout(self) -> pulumi.Input[str]:
        """
        The amount of time to retry health evaluation when the application or cluster is unhealthy before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "health_check_retry_timeout")

    @health_check_retry_timeout.setter
    def health_check_retry_timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "health_check_retry_timeout", value)

    @property
    @pulumi.getter(name="healthCheckStableDuration")
    def health_check_stable_duration(self) -> pulumi.Input[str]:
        """
        The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "health_check_stable_duration")

    @health_check_stable_duration.setter
    def health_check_stable_duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "health_check_stable_duration", value)

    @property
    @pulumi.getter(name="healthCheckWaitDuration")
    def health_check_wait_duration(self) -> pulumi.Input[str]:
        """
        The length of time to wait after completing an upgrade domain before performing health checks. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "health_check_wait_duration")

    @health_check_wait_duration.setter
    def health_check_wait_duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "health_check_wait_duration", value)

    @property
    @pulumi.getter(name="healthPolicy")
    def health_policy(self) -> pulumi.Input['ClusterHealthPolicyArgs']:
        """
        The cluster health policy used when upgrading the cluster.
        """
        return pulumi.get(self, "health_policy")

    @health_policy.setter
    def health_policy(self, value: pulumi.Input['ClusterHealthPolicyArgs']):
        pulumi.set(self, "health_policy", value)

    @property
    @pulumi.getter(name="upgradeDomainTimeout")
    def upgrade_domain_timeout(self) -> pulumi.Input[str]:
        """
        The amount of time each upgrade domain has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "upgrade_domain_timeout")

    @upgrade_domain_timeout.setter
    def upgrade_domain_timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "upgrade_domain_timeout", value)

    @property
    @pulumi.getter(name="upgradeReplicaSetCheckTimeout")
    def upgrade_replica_set_check_timeout(self) -> pulumi.Input[str]:
        """
        The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "upgrade_replica_set_check_timeout")

    @upgrade_replica_set_check_timeout.setter
    def upgrade_replica_set_check_timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "upgrade_replica_set_check_timeout", value)

    @property
    @pulumi.getter(name="upgradeTimeout")
    def upgrade_timeout(self) -> pulumi.Input[str]:
        """
        The amount of time the overall upgrade has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "upgrade_timeout")

    @upgrade_timeout.setter
    def upgrade_timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "upgrade_timeout", value)

    @property
    @pulumi.getter(name="deltaHealthPolicy")
    def delta_health_policy(self) -> Optional[pulumi.Input['ClusterUpgradeDeltaHealthPolicyArgs']]:
        """
        The cluster delta health policy used when upgrading the cluster.
        """
        return pulumi.get(self, "delta_health_policy")

    @delta_health_policy.setter
    def delta_health_policy(self, value: Optional[pulumi.Input['ClusterUpgradeDeltaHealthPolicyArgs']]):
        pulumi.set(self, "delta_health_policy", value)

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
        """
        return pulumi.get(self, "force_restart")

    @force_restart.setter
    def force_restart(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_restart", value)


@pulumi.input_type
class DiagnosticsStorageAccountConfigArgs:
    def __init__(__self__, *,
                 blob_endpoint: pulumi.Input[str],
                 protected_account_key_name: pulumi.Input[str],
                 queue_endpoint: pulumi.Input[str],
                 storage_account_name: pulumi.Input[str],
                 table_endpoint: pulumi.Input[str]):
        """
        The storage account information for storing Service Fabric diagnostic logs.
        :param pulumi.Input[str] blob_endpoint: The blob endpoint of the azure storage account.
        :param pulumi.Input[str] protected_account_key_name: The protected diagnostics storage key name.
        :param pulumi.Input[str] queue_endpoint: The queue endpoint of the azure storage account.
        :param pulumi.Input[str] storage_account_name: The Azure storage account name.
        :param pulumi.Input[str] table_endpoint: The table endpoint of the azure storage account.
        """
        pulumi.set(__self__, "blob_endpoint", blob_endpoint)
        pulumi.set(__self__, "protected_account_key_name", protected_account_key_name)
        pulumi.set(__self__, "queue_endpoint", queue_endpoint)
        pulumi.set(__self__, "storage_account_name", storage_account_name)
        pulumi.set(__self__, "table_endpoint", table_endpoint)

    @property
    @pulumi.getter(name="blobEndpoint")
    def blob_endpoint(self) -> pulumi.Input[str]:
        """
        The blob endpoint of the azure storage account.
        """
        return pulumi.get(self, "blob_endpoint")

    @blob_endpoint.setter
    def blob_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "blob_endpoint", value)

    @property
    @pulumi.getter(name="protectedAccountKeyName")
    def protected_account_key_name(self) -> pulumi.Input[str]:
        """
        The protected diagnostics storage key name.
        """
        return pulumi.get(self, "protected_account_key_name")

    @protected_account_key_name.setter
    def protected_account_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_account_key_name", value)

    @property
    @pulumi.getter(name="queueEndpoint")
    def queue_endpoint(self) -> pulumi.Input[str]:
        """
        The queue endpoint of the azure storage account.
        """
        return pulumi.get(self, "queue_endpoint")

    @queue_endpoint.setter
    def queue_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "queue_endpoint", value)

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> pulumi.Input[str]:
        """
        The Azure storage account name.
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_account_name", value)

    @property
    @pulumi.getter(name="tableEndpoint")
    def table_endpoint(self) -> pulumi.Input[str]:
        """
        The table endpoint of the azure storage account.
        """
        return pulumi.get(self, "table_endpoint")

    @table_endpoint.setter
    def table_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_endpoint", value)


@pulumi.input_type
class EndpointRangeDescriptionArgs:
    def __init__(__self__, *,
                 end_port: pulumi.Input[int],
                 start_port: pulumi.Input[int]):
        """
        Port range details
        :param pulumi.Input[int] end_port: End port of a range of ports
        :param pulumi.Input[int] start_port: Starting port of a range of ports
        """
        pulumi.set(__self__, "end_port", end_port)
        pulumi.set(__self__, "start_port", start_port)

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> pulumi.Input[int]:
        """
        End port of a range of ports
        """
        return pulumi.get(self, "end_port")

    @end_port.setter
    def end_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "end_port", value)

    @property
    @pulumi.getter(name="startPort")
    def start_port(self) -> pulumi.Input[int]:
        """
        Starting port of a range of ports
        """
        return pulumi.get(self, "start_port")

    @start_port.setter
    def start_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "start_port", value)


@pulumi.input_type
class NodeTypeDescriptionArgs:
    def __init__(__self__, *,
                 client_connection_endpoint_port: pulumi.Input[int],
                 http_gateway_endpoint_port: pulumi.Input[int],
                 is_primary: pulumi.Input[bool],
                 name: pulumi.Input[str],
                 vm_instance_count: pulumi.Input[int],
                 application_ports: Optional[pulumi.Input['EndpointRangeDescriptionArgs']] = None,
                 capacities: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 durability_level: Optional[pulumi.Input[str]] = None,
                 ephemeral_ports: Optional[pulumi.Input['EndpointRangeDescriptionArgs']] = None,
                 placement_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 reverse_proxy_endpoint_port: Optional[pulumi.Input[int]] = None):
        """
        Describes a node type in the cluster, each node type represents sub set of nodes in the cluster.
        :param pulumi.Input[int] client_connection_endpoint_port: The TCP cluster management endpoint port.
        :param pulumi.Input[int] http_gateway_endpoint_port: The HTTP cluster management endpoint port.
        :param pulumi.Input[bool] is_primary: The node type on which system services will run. Only one node type should be marked as primary. Primary node type cannot be deleted or changed for existing clusters.
        :param pulumi.Input[str] name: The name of the node type.
        :param pulumi.Input[int] vm_instance_count: The number of nodes in the node type. This count should match the capacity property in the corresponding VirtualMachineScaleSet resource.
        :param pulumi.Input['EndpointRangeDescriptionArgs'] application_ports: The range of ports from which cluster assigned port to Service Fabric applications.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] capacities: The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
        :param pulumi.Input[str] durability_level: The durability level of the node type. Learn about [DurabilityLevel](https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity).
               
                 - Bronze - No privileges. This is the default.
                 - Silver - The infrastructure jobs can be paused for a duration of 10 minutes per UD.
                 - Gold - The infrastructure jobs can be paused for a duration of 2 hours per UD. Gold durability can be enabled only on full node VM SKUs like D15_V2, G5 etc.
        :param pulumi.Input['EndpointRangeDescriptionArgs'] ephemeral_ports: The range of ephemeral ports that nodes in this node type should be configured with.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] placement_properties: The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
        :param pulumi.Input[int] reverse_proxy_endpoint_port: The endpoint used by reverse proxy.
        """
        pulumi.set(__self__, "client_connection_endpoint_port", client_connection_endpoint_port)
        pulumi.set(__self__, "http_gateway_endpoint_port", http_gateway_endpoint_port)
        pulumi.set(__self__, "is_primary", is_primary)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "vm_instance_count", vm_instance_count)
        if application_ports is not None:
            pulumi.set(__self__, "application_ports", application_ports)
        if capacities is not None:
            pulumi.set(__self__, "capacities", capacities)
        if durability_level is not None:
            pulumi.set(__self__, "durability_level", durability_level)
        if ephemeral_ports is not None:
            pulumi.set(__self__, "ephemeral_ports", ephemeral_ports)
        if placement_properties is not None:
            pulumi.set(__self__, "placement_properties", placement_properties)
        if reverse_proxy_endpoint_port is not None:
            pulumi.set(__self__, "reverse_proxy_endpoint_port", reverse_proxy_endpoint_port)

    @property
    @pulumi.getter(name="clientConnectionEndpointPort")
    def client_connection_endpoint_port(self) -> pulumi.Input[int]:
        """
        The TCP cluster management endpoint port.
        """
        return pulumi.get(self, "client_connection_endpoint_port")

    @client_connection_endpoint_port.setter
    def client_connection_endpoint_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "client_connection_endpoint_port", value)

    @property
    @pulumi.getter(name="httpGatewayEndpointPort")
    def http_gateway_endpoint_port(self) -> pulumi.Input[int]:
        """
        The HTTP cluster management endpoint port.
        """
        return pulumi.get(self, "http_gateway_endpoint_port")

    @http_gateway_endpoint_port.setter
    def http_gateway_endpoint_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "http_gateway_endpoint_port", value)

    @property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> pulumi.Input[bool]:
        """
        The node type on which system services will run. Only one node type should be marked as primary. Primary node type cannot be deleted or changed for existing clusters.
        """
        return pulumi.get(self, "is_primary")

    @is_primary.setter
    def is_primary(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_primary", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the node type.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="vmInstanceCount")
    def vm_instance_count(self) -> pulumi.Input[int]:
        """
        The number of nodes in the node type. This count should match the capacity property in the corresponding VirtualMachineScaleSet resource.
        """
        return pulumi.get(self, "vm_instance_count")

    @vm_instance_count.setter
    def vm_instance_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "vm_instance_count", value)

    @property
    @pulumi.getter(name="applicationPorts")
    def application_ports(self) -> Optional[pulumi.Input['EndpointRangeDescriptionArgs']]:
        """
        The range of ports from which cluster assigned port to Service Fabric applications.
        """
        return pulumi.get(self, "application_ports")

    @application_ports.setter
    def application_ports(self, value: Optional[pulumi.Input['EndpointRangeDescriptionArgs']]):
        pulumi.set(self, "application_ports", value)

    @property
    @pulumi.getter
    def capacities(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
        """
        return pulumi.get(self, "capacities")

    @capacities.setter
    def capacities(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "capacities", value)

    @property
    @pulumi.getter(name="durabilityLevel")
    def durability_level(self) -> Optional[pulumi.Input[str]]:
        """
        The durability level of the node type. Learn about [DurabilityLevel](https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity).

          - Bronze - No privileges. This is the default.
          - Silver - The infrastructure jobs can be paused for a duration of 10 minutes per UD.
          - Gold - The infrastructure jobs can be paused for a duration of 2 hours per UD. Gold durability can be enabled only on full node VM SKUs like D15_V2, G5 etc.
        """
        return pulumi.get(self, "durability_level")

    @durability_level.setter
    def durability_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "durability_level", value)

    @property
    @pulumi.getter(name="ephemeralPorts")
    def ephemeral_ports(self) -> Optional[pulumi.Input['EndpointRangeDescriptionArgs']]:
        """
        The range of ephemeral ports that nodes in this node type should be configured with.
        """
        return pulumi.get(self, "ephemeral_ports")

    @ephemeral_ports.setter
    def ephemeral_ports(self, value: Optional[pulumi.Input['EndpointRangeDescriptionArgs']]):
        pulumi.set(self, "ephemeral_ports", value)

    @property
    @pulumi.getter(name="placementProperties")
    def placement_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
        """
        return pulumi.get(self, "placement_properties")

    @placement_properties.setter
    def placement_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "placement_properties", value)

    @property
    @pulumi.getter(name="reverseProxyEndpointPort")
    def reverse_proxy_endpoint_port(self) -> Optional[pulumi.Input[int]]:
        """
        The endpoint used by reverse proxy.
        """
        return pulumi.get(self, "reverse_proxy_endpoint_port")

    @reverse_proxy_endpoint_port.setter
    def reverse_proxy_endpoint_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "reverse_proxy_endpoint_port", value)


@pulumi.input_type
class ServerCertificateCommonNamesArgs:
    def __init__(__self__, *,
                 common_names: Optional[pulumi.Input[Sequence[pulumi.Input['ServerCertificateCommonNameArgs']]]] = None,
                 x509_store_name: Optional[pulumi.Input[str]] = None):
        """
        Describes a list of server certificates referenced by common name that are used to secure the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ServerCertificateCommonNameArgs']]] common_names: The list of server certificates referenced by common name that are used to secure the cluster.
        :param pulumi.Input[str] x509_store_name: The local certificate store location.
        """
        if common_names is not None:
            pulumi.set(__self__, "common_names", common_names)
        if x509_store_name is not None:
            pulumi.set(__self__, "x509_store_name", x509_store_name)

    @property
    @pulumi.getter(name="commonNames")
    def common_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerCertificateCommonNameArgs']]]]:
        """
        The list of server certificates referenced by common name that are used to secure the cluster.
        """
        return pulumi.get(self, "common_names")

    @common_names.setter
    def common_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerCertificateCommonNameArgs']]]]):
        pulumi.set(self, "common_names", value)

    @property
    @pulumi.getter(name="x509StoreName")
    def x509_store_name(self) -> Optional[pulumi.Input[str]]:
        """
        The local certificate store location.
        """
        return pulumi.get(self, "x509_store_name")

    @x509_store_name.setter
    def x509_store_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x509_store_name", value)


@pulumi.input_type
class ServerCertificateCommonNameArgs:
    def __init__(__self__, *,
                 certificate_common_name: pulumi.Input[str],
                 certificate_issuer_thumbprint: pulumi.Input[str]):
        """
        Describes the server certificate details using common name.
        :param pulumi.Input[str] certificate_common_name: The common name of the server certificate.
        :param pulumi.Input[str] certificate_issuer_thumbprint: The issuer thumbprint of the server certificate.
        """
        pulumi.set(__self__, "certificate_common_name", certificate_common_name)
        pulumi.set(__self__, "certificate_issuer_thumbprint", certificate_issuer_thumbprint)

    @property
    @pulumi.getter(name="certificateCommonName")
    def certificate_common_name(self) -> pulumi.Input[str]:
        """
        The common name of the server certificate.
        """
        return pulumi.get(self, "certificate_common_name")

    @certificate_common_name.setter
    def certificate_common_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_common_name", value)

    @property
    @pulumi.getter(name="certificateIssuerThumbprint")
    def certificate_issuer_thumbprint(self) -> pulumi.Input[str]:
        """
        The issuer thumbprint of the server certificate.
        """
        return pulumi.get(self, "certificate_issuer_thumbprint")

    @certificate_issuer_thumbprint.setter
    def certificate_issuer_thumbprint(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_issuer_thumbprint", value)


@pulumi.input_type
class ServiceTypeDeltaHealthPolicyArgs:
    def __init__(__self__, *,
                 max_percent_delta_unhealthy_services: Optional[pulumi.Input[int]] = None):
        """
        Represents the delta health policy used to evaluate the health of services belonging to a service type when upgrading the cluster.

        :param pulumi.Input[int] max_percent_delta_unhealthy_services: The maximum allowed percentage of services health degradation allowed during cluster upgrades.
               The delta is measured between the state of the services at the beginning of upgrade and the state of the services at the time of the health evaluation.
               The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
        """
        if max_percent_delta_unhealthy_services is None:
            max_percent_delta_unhealthy_services = 0
        if max_percent_delta_unhealthy_services is not None:
            pulumi.set(__self__, "max_percent_delta_unhealthy_services", max_percent_delta_unhealthy_services)

    @property
    @pulumi.getter(name="maxPercentDeltaUnhealthyServices")
    def max_percent_delta_unhealthy_services(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum allowed percentage of services health degradation allowed during cluster upgrades.
        The delta is measured between the state of the services at the beginning of upgrade and the state of the services at the time of the health evaluation.
        The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
        """
        return pulumi.get(self, "max_percent_delta_unhealthy_services")

    @max_percent_delta_unhealthy_services.setter
    def max_percent_delta_unhealthy_services(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_percent_delta_unhealthy_services", value)


@pulumi.input_type
class ServiceTypeHealthPolicyArgs:
    def __init__(__self__, *,
                 max_percent_unhealthy_services: Optional[pulumi.Input[int]] = None):
        """
        Represents the health policy used to evaluate the health of services belonging to a service type.

        :param pulumi.Input[int] max_percent_unhealthy_services: The maximum percentage of services allowed to be unhealthy before your application is considered in error.
        """
        if max_percent_unhealthy_services is None:
            max_percent_unhealthy_services = 0
        if max_percent_unhealthy_services is not None:
            pulumi.set(__self__, "max_percent_unhealthy_services", max_percent_unhealthy_services)

    @property
    @pulumi.getter(name="maxPercentUnhealthyServices")
    def max_percent_unhealthy_services(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum percentage of services allowed to be unhealthy before your application is considered in error.
        """
        return pulumi.get(self, "max_percent_unhealthy_services")

    @max_percent_unhealthy_services.setter
    def max_percent_unhealthy_services(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_percent_unhealthy_services", value)


@pulumi.input_type
class SettingsParameterDescriptionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Describes a parameter in fabric settings of the cluster.
        :param pulumi.Input[str] name: The parameter name of fabric setting.
        :param pulumi.Input[str] value: The parameter value of fabric setting.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The parameter name of fabric setting.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The parameter value of fabric setting.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class SettingsSectionDescriptionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input[Sequence[pulumi.Input['SettingsParameterDescriptionArgs']]]):
        """
        Describes a section in the fabric settings of the cluster.
        :param pulumi.Input[str] name: The section name of the fabric settings.
        :param pulumi.Input[Sequence[pulumi.Input['SettingsParameterDescriptionArgs']]] parameters: The collection of parameters in the section.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The section name of the fabric settings.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input[Sequence[pulumi.Input['SettingsParameterDescriptionArgs']]]:
        """
        The collection of parameters in the section.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input[Sequence[pulumi.Input['SettingsParameterDescriptionArgs']]]):
        pulumi.set(self, "parameters", value)


