# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetDatabaseSqlVulnerabilityAssessmentRuleBaselineResult',
    'AwaitableGetDatabaseSqlVulnerabilityAssessmentRuleBaselineResult',
    'get_database_sql_vulnerability_assessment_rule_baseline',
    'get_database_sql_vulnerability_assessment_rule_baseline_output',
]

@pulumi.output_type
class GetDatabaseSqlVulnerabilityAssessmentRuleBaselineResult:
    """
    A database sql vulnerability assessment rule baseline.
    """
    def __init__(__self__, id=None, name=None, results=None, system_data=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def results(self) -> Sequence[Sequence[str]]:
        """
        The rule baseline result
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        SystemData of DatabaseSqlVulnerabilityAssessmentRuleBaselineResource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")


class AwaitableGetDatabaseSqlVulnerabilityAssessmentRuleBaselineResult(GetDatabaseSqlVulnerabilityAssessmentRuleBaselineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseSqlVulnerabilityAssessmentRuleBaselineResult(
            id=self.id,
            name=self.name,
            results=self.results,
            system_data=self.system_data,
            type=self.type)


def get_database_sql_vulnerability_assessment_rule_baseline(baseline_name: Optional[str] = None,
                                                            database_name: Optional[str] = None,
                                                            resource_group_name: Optional[str] = None,
                                                            rule_id: Optional[str] = None,
                                                            server_name: Optional[str] = None,
                                                            vulnerability_assessment_name: Optional[str] = None,
                                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseSqlVulnerabilityAssessmentRuleBaselineResult:
    """
    A database sql vulnerability assessment rule baseline.


    :param str database_name: The name of the database.
    :param str resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    :param str rule_id: The vulnerability assessment rule ID.
    :param str server_name: The name of the server.
    :param str vulnerability_assessment_name: The name of the vulnerability assessment.
    """
    __args__ = dict()
    __args__['baselineName'] = baseline_name
    __args__['databaseName'] = database_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['ruleId'] = rule_id
    __args__['serverName'] = server_name
    __args__['vulnerabilityAssessmentName'] = vulnerability_assessment_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:sql/v20220201preview:getDatabaseSqlVulnerabilityAssessmentRuleBaseline', __args__, opts=opts, typ=GetDatabaseSqlVulnerabilityAssessmentRuleBaselineResult).value

    return AwaitableGetDatabaseSqlVulnerabilityAssessmentRuleBaselineResult(
        id=__ret__.id,
        name=__ret__.name,
        results=__ret__.results,
        system_data=__ret__.system_data,
        type=__ret__.type)


@_utilities.lift_output_func(get_database_sql_vulnerability_assessment_rule_baseline)
def get_database_sql_vulnerability_assessment_rule_baseline_output(baseline_name: Optional[pulumi.Input[str]] = None,
                                                                   database_name: Optional[pulumi.Input[str]] = None,
                                                                   resource_group_name: Optional[pulumi.Input[str]] = None,
                                                                   rule_id: Optional[pulumi.Input[str]] = None,
                                                                   server_name: Optional[pulumi.Input[str]] = None,
                                                                   vulnerability_assessment_name: Optional[pulumi.Input[str]] = None,
                                                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDatabaseSqlVulnerabilityAssessmentRuleBaselineResult]:
    """
    A database sql vulnerability assessment rule baseline.


    :param str database_name: The name of the database.
    :param str resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    :param str rule_id: The vulnerability assessment rule ID.
    :param str server_name: The name of the server.
    :param str vulnerability_assessment_name: The name of the vulnerability assessment.
    """
    ...
