# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'InputLinuxParametersArgs',
    'InputPatchConfigurationArgs',
    'InputWindowsParametersArgs',
    'TaskPropertiesArgs',
]

@pulumi.input_type
class InputLinuxParametersArgs:
    def __init__(__self__, *,
                 classifications_to_include: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 package_name_masks_to_exclude: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 package_name_masks_to_include: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties for patching a Linux machine.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] classifications_to_include: Classification category of patches to be patched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] package_name_masks_to_exclude: Package names to be excluded for patching.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] package_name_masks_to_include: Package names to be included for patching.
        """
        if classifications_to_include is not None:
            pulumi.set(__self__, "classifications_to_include", classifications_to_include)
        if package_name_masks_to_exclude is not None:
            pulumi.set(__self__, "package_name_masks_to_exclude", package_name_masks_to_exclude)
        if package_name_masks_to_include is not None:
            pulumi.set(__self__, "package_name_masks_to_include", package_name_masks_to_include)

    @property
    @pulumi.getter(name="classificationsToInclude")
    def classifications_to_include(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Classification category of patches to be patched
        """
        return pulumi.get(self, "classifications_to_include")

    @classifications_to_include.setter
    def classifications_to_include(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "classifications_to_include", value)

    @property
    @pulumi.getter(name="packageNameMasksToExclude")
    def package_name_masks_to_exclude(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Package names to be excluded for patching.
        """
        return pulumi.get(self, "package_name_masks_to_exclude")

    @package_name_masks_to_exclude.setter
    def package_name_masks_to_exclude(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "package_name_masks_to_exclude", value)

    @property
    @pulumi.getter(name="packageNameMasksToInclude")
    def package_name_masks_to_include(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Package names to be included for patching.
        """
        return pulumi.get(self, "package_name_masks_to_include")

    @package_name_masks_to_include.setter
    def package_name_masks_to_include(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "package_name_masks_to_include", value)


@pulumi.input_type
class InputPatchConfigurationArgs:
    def __init__(__self__, *,
                 linux_parameters: Optional[pulumi.Input['InputLinuxParametersArgs']] = None,
                 post_tasks: Optional[pulumi.Input[Sequence[pulumi.Input['TaskPropertiesArgs']]]] = None,
                 pre_tasks: Optional[pulumi.Input[Sequence[pulumi.Input['TaskPropertiesArgs']]]] = None,
                 reboot_setting: Optional[pulumi.Input[Union[str, 'RebootOptions']]] = None,
                 windows_parameters: Optional[pulumi.Input['InputWindowsParametersArgs']] = None):
        """
        Input configuration for a patch run
        :param pulumi.Input['InputLinuxParametersArgs'] linux_parameters: Input parameters specific to patching Linux machine. For Windows machines, do not pass this property.
        :param pulumi.Input[Sequence[pulumi.Input['TaskPropertiesArgs']]] post_tasks: List of post tasks. e.g. [{'source' :'runbook', 'taskScope': 'Resource', 'parameters': { 'arg1': 'value1'}}]
        :param pulumi.Input[Sequence[pulumi.Input['TaskPropertiesArgs']]] pre_tasks: List of pre tasks. e.g. [{'source' :'runbook', 'taskScope': 'Global', 'parameters': { 'arg1': 'value1'}}]
        :param pulumi.Input[Union[str, 'RebootOptions']] reboot_setting: Possible reboot preference as defined by the user based on which it would be decided to reboot the machine or not after the patch operation is completed.
        :param pulumi.Input['InputWindowsParametersArgs'] windows_parameters: Input parameters specific to patching a Windows machine. For Linux machines, do not pass this property.
        """
        if linux_parameters is not None:
            pulumi.set(__self__, "linux_parameters", linux_parameters)
        if post_tasks is not None:
            pulumi.set(__self__, "post_tasks", post_tasks)
        if pre_tasks is not None:
            pulumi.set(__self__, "pre_tasks", pre_tasks)
        if reboot_setting is not None:
            pulumi.set(__self__, "reboot_setting", reboot_setting)
        if windows_parameters is not None:
            pulumi.set(__self__, "windows_parameters", windows_parameters)

    @property
    @pulumi.getter(name="linuxParameters")
    def linux_parameters(self) -> Optional[pulumi.Input['InputLinuxParametersArgs']]:
        """
        Input parameters specific to patching Linux machine. For Windows machines, do not pass this property.
        """
        return pulumi.get(self, "linux_parameters")

    @linux_parameters.setter
    def linux_parameters(self, value: Optional[pulumi.Input['InputLinuxParametersArgs']]):
        pulumi.set(self, "linux_parameters", value)

    @property
    @pulumi.getter(name="postTasks")
    def post_tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskPropertiesArgs']]]]:
        """
        List of post tasks. e.g. [{'source' :'runbook', 'taskScope': 'Resource', 'parameters': { 'arg1': 'value1'}}]
        """
        return pulumi.get(self, "post_tasks")

    @post_tasks.setter
    def post_tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskPropertiesArgs']]]]):
        pulumi.set(self, "post_tasks", value)

    @property
    @pulumi.getter(name="preTasks")
    def pre_tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskPropertiesArgs']]]]:
        """
        List of pre tasks. e.g. [{'source' :'runbook', 'taskScope': 'Global', 'parameters': { 'arg1': 'value1'}}]
        """
        return pulumi.get(self, "pre_tasks")

    @pre_tasks.setter
    def pre_tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskPropertiesArgs']]]]):
        pulumi.set(self, "pre_tasks", value)

    @property
    @pulumi.getter(name="rebootSetting")
    def reboot_setting(self) -> Optional[pulumi.Input[Union[str, 'RebootOptions']]]:
        """
        Possible reboot preference as defined by the user based on which it would be decided to reboot the machine or not after the patch operation is completed.
        """
        return pulumi.get(self, "reboot_setting")

    @reboot_setting.setter
    def reboot_setting(self, value: Optional[pulumi.Input[Union[str, 'RebootOptions']]]):
        pulumi.set(self, "reboot_setting", value)

    @property
    @pulumi.getter(name="windowsParameters")
    def windows_parameters(self) -> Optional[pulumi.Input['InputWindowsParametersArgs']]:
        """
        Input parameters specific to patching a Windows machine. For Linux machines, do not pass this property.
        """
        return pulumi.get(self, "windows_parameters")

    @windows_parameters.setter
    def windows_parameters(self, value: Optional[pulumi.Input['InputWindowsParametersArgs']]):
        pulumi.set(self, "windows_parameters", value)


@pulumi.input_type
class InputWindowsParametersArgs:
    def __init__(__self__, *,
                 classifications_to_include: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exclude_kbs_requiring_reboot: Optional[pulumi.Input[bool]] = None,
                 kb_numbers_to_exclude: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kb_numbers_to_include: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties for patching a Windows machine.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] classifications_to_include: Classification category of patches to be patched
        :param pulumi.Input[bool] exclude_kbs_requiring_reboot: Exclude patches which need reboot
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kb_numbers_to_exclude: Windows KBID to be excluded for patching.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kb_numbers_to_include: Windows KBID to be included for patching.
        """
        if classifications_to_include is not None:
            pulumi.set(__self__, "classifications_to_include", classifications_to_include)
        if exclude_kbs_requiring_reboot is not None:
            pulumi.set(__self__, "exclude_kbs_requiring_reboot", exclude_kbs_requiring_reboot)
        if kb_numbers_to_exclude is not None:
            pulumi.set(__self__, "kb_numbers_to_exclude", kb_numbers_to_exclude)
        if kb_numbers_to_include is not None:
            pulumi.set(__self__, "kb_numbers_to_include", kb_numbers_to_include)

    @property
    @pulumi.getter(name="classificationsToInclude")
    def classifications_to_include(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Classification category of patches to be patched
        """
        return pulumi.get(self, "classifications_to_include")

    @classifications_to_include.setter
    def classifications_to_include(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "classifications_to_include", value)

    @property
    @pulumi.getter(name="excludeKbsRequiringReboot")
    def exclude_kbs_requiring_reboot(self) -> Optional[pulumi.Input[bool]]:
        """
        Exclude patches which need reboot
        """
        return pulumi.get(self, "exclude_kbs_requiring_reboot")

    @exclude_kbs_requiring_reboot.setter
    def exclude_kbs_requiring_reboot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_kbs_requiring_reboot", value)

    @property
    @pulumi.getter(name="kbNumbersToExclude")
    def kb_numbers_to_exclude(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Windows KBID to be excluded for patching.
        """
        return pulumi.get(self, "kb_numbers_to_exclude")

    @kb_numbers_to_exclude.setter
    def kb_numbers_to_exclude(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "kb_numbers_to_exclude", value)

    @property
    @pulumi.getter(name="kbNumbersToInclude")
    def kb_numbers_to_include(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Windows KBID to be included for patching.
        """
        return pulumi.get(self, "kb_numbers_to_include")

    @kb_numbers_to_include.setter
    def kb_numbers_to_include(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "kb_numbers_to_include", value)


@pulumi.input_type
class TaskPropertiesArgs:
    def __init__(__self__, *,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 task_scope: Optional[pulumi.Input[Union[str, 'TaskScope']]] = None):
        """
        Task properties of the software update configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Gets or sets the parameters of the task.
        :param pulumi.Input[str] source: Gets or sets the name of the runbook.
        :param pulumi.Input[Union[str, 'TaskScope']] task_scope: Global Task execute once when schedule trigger. Resource task execute for each VM.
        """
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if task_scope is None:
            task_scope = 'Global'
        if task_scope is not None:
            pulumi.set(__self__, "task_scope", task_scope)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Gets or sets the parameters of the task.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the name of the runbook.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="taskScope")
    def task_scope(self) -> Optional[pulumi.Input[Union[str, 'TaskScope']]]:
        """
        Global Task execute once when schedule trigger. Resource task execute for each VM.
        """
        return pulumi.get(self, "task_scope")

    @task_scope.setter
    def task_scope(self, value: Optional[pulumi.Input[Union[str, 'TaskScope']]]):
        pulumi.set(self, "task_scope", value)


