# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'DigitalTwinsSkuInfoArgs',
    'EventGridArgs',
    'EventHubArgs',
    'ServiceBusArgs',
]

@pulumi.input_type
class DigitalTwinsSkuInfoArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'DigitalTwinsSku']]):
        """
        Information about the SKU of the DigitalTwinsInstance.
        :param pulumi.Input[Union[str, 'DigitalTwinsSku']] name: The name of the SKU.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'DigitalTwinsSku']]:
        """
        The name of the SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'DigitalTwinsSku']]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class EventGridArgs:
    def __init__(__self__, *,
                 access_key1: pulumi.Input[str],
                 access_key2: pulumi.Input[str],
                 endpoint_type: pulumi.Input[str],
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 topic_endpoint: Optional[pulumi.Input[str]] = None):
        """
        properties related to eventgrid.
        :param pulumi.Input[str] access_key1: EventGrid secondary accesskey. Will be obfuscated during read
        :param pulumi.Input[str] access_key2: EventGrid secondary accesskey. Will be obfuscated during read
        :param pulumi.Input[str] endpoint_type: The type of Digital Twins endpoint
               Expected value is 'EventGrid'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The resource tags.
        :param pulumi.Input[str] topic_endpoint: EventGrid Topic Endpoint
        """
        pulumi.set(__self__, "access_key1", access_key1)
        pulumi.set(__self__, "access_key2", access_key2)
        pulumi.set(__self__, "endpoint_type", 'EventGrid')
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if topic_endpoint is not None:
            pulumi.set(__self__, "topic_endpoint", topic_endpoint)

    @property
    @pulumi.getter(name="accessKey1")
    def access_key1(self) -> pulumi.Input[str]:
        """
        EventGrid secondary accesskey. Will be obfuscated during read
        """
        return pulumi.get(self, "access_key1")

    @access_key1.setter
    def access_key1(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_key1", value)

    @property
    @pulumi.getter(name="accessKey2")
    def access_key2(self) -> pulumi.Input[str]:
        """
        EventGrid secondary accesskey. Will be obfuscated during read
        """
        return pulumi.get(self, "access_key2")

    @access_key2.setter
    def access_key2(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_key2", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[str]:
        """
        The type of Digital Twins endpoint
        Expected value is 'EventGrid'.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="topicEndpoint")
    def topic_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        EventGrid Topic Endpoint
        """
        return pulumi.get(self, "topic_endpoint")

    @topic_endpoint.setter
    def topic_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_endpoint", value)


@pulumi.input_type
class EventHubArgs:
    def __init__(__self__, *,
                 connection_string_primary_key: pulumi.Input[str],
                 connection_string_secondary_key: pulumi.Input[str],
                 endpoint_type: pulumi.Input[str],
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        properties related to eventhub.
        :param pulumi.Input[str] connection_string_primary_key: PrimaryConnectionString of the endpoint. Will be obfuscated during read
        :param pulumi.Input[str] connection_string_secondary_key: SecondaryConnectionString of the endpoint. Will be obfuscated during read
        :param pulumi.Input[str] endpoint_type: The type of Digital Twins endpoint
               Expected value is 'EventHub'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The resource tags.
        """
        pulumi.set(__self__, "connection_string_primary_key", connection_string_primary_key)
        pulumi.set(__self__, "connection_string_secondary_key", connection_string_secondary_key)
        pulumi.set(__self__, "endpoint_type", 'EventHub')
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="connectionStringPrimaryKey")
    def connection_string_primary_key(self) -> pulumi.Input[str]:
        """
        PrimaryConnectionString of the endpoint. Will be obfuscated during read
        """
        return pulumi.get(self, "connection_string_primary_key")

    @connection_string_primary_key.setter
    def connection_string_primary_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_string_primary_key", value)

    @property
    @pulumi.getter(name="connectionStringSecondaryKey")
    def connection_string_secondary_key(self) -> pulumi.Input[str]:
        """
        SecondaryConnectionString of the endpoint. Will be obfuscated during read
        """
        return pulumi.get(self, "connection_string_secondary_key")

    @connection_string_secondary_key.setter
    def connection_string_secondary_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_string_secondary_key", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[str]:
        """
        The type of Digital Twins endpoint
        Expected value is 'EventHub'.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class ServiceBusArgs:
    def __init__(__self__, *,
                 endpoint_type: pulumi.Input[str],
                 primary_connection_string: pulumi.Input[str],
                 secondary_connection_string: pulumi.Input[str],
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        properties related to servicebus.
        :param pulumi.Input[str] endpoint_type: The type of Digital Twins endpoint
               Expected value is 'ServiceBus'.
        :param pulumi.Input[str] primary_connection_string: PrimaryConnectionString of the endpoint. Will be obfuscated during read
        :param pulumi.Input[str] secondary_connection_string: SecondaryConnectionString of the endpoint. Will be obfuscated during read
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The resource tags.
        """
        pulumi.set(__self__, "endpoint_type", 'ServiceBus')
        pulumi.set(__self__, "primary_connection_string", primary_connection_string)
        pulumi.set(__self__, "secondary_connection_string", secondary_connection_string)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[str]:
        """
        The type of Digital Twins endpoint
        Expected value is 'ServiceBus'.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> pulumi.Input[str]:
        """
        PrimaryConnectionString of the endpoint. Will be obfuscated during read
        """
        return pulumi.get(self, "primary_connection_string")

    @primary_connection_string.setter
    def primary_connection_string(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_connection_string", value)

    @property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> pulumi.Input[str]:
        """
        SecondaryConnectionString of the endpoint. Will be obfuscated during read
        """
        return pulumi.get(self, "secondary_connection_string")

    @secondary_connection_string.setter
    def secondary_connection_string(self, value: pulumi.Input[str]):
        pulumi.set(self, "secondary_connection_string", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


