# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AddActionGroupsArgs',
    'AlertProcessingRulePropertiesArgs',
    'ConditionArgs',
    'DailyRecurrenceArgs',
    'MonthlyRecurrenceArgs',
    'RemoveAllActionGroupsArgs',
    'ScheduleArgs',
    'WeeklyRecurrenceArgs',
]

@pulumi.input_type
class AddActionGroupsArgs:
    def __init__(__self__, *,
                 action_group_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 action_type: pulumi.Input[str]):
        """
        Add action groups to alert processing rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] action_group_ids: List of action group Ids to add to alert processing rule.
        :param pulumi.Input[str] action_type: Action that should be applied.
               Expected value is 'AddActionGroups'.
        """
        pulumi.set(__self__, "action_group_ids", action_group_ids)
        pulumi.set(__self__, "action_type", 'AddActionGroups')

    @property
    @pulumi.getter(name="actionGroupIds")
    def action_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of action group Ids to add to alert processing rule.
        """
        return pulumi.get(self, "action_group_ids")

    @action_group_ids.setter
    def action_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "action_group_ids", value)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input[str]:
        """
        Action that should be applied.
        Expected value is 'AddActionGroups'.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_type", value)


@pulumi.input_type
class AlertProcessingRulePropertiesArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input[Union['AddActionGroupsArgs', 'RemoveAllActionGroupsArgs']]]],
                 scopes: pulumi.Input[Sequence[pulumi.Input[str]]],
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['ConditionArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 schedule: Optional[pulumi.Input['ScheduleArgs']] = None):
        """
        Alert processing rule properties defining scopes, conditions and scheduling logic for alert processing rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AddActionGroupsArgs', 'RemoveAllActionGroupsArgs']]]] actions: Actions to be applied.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: Scopes on which alert processing rule will apply.
        :param pulumi.Input[Sequence[pulumi.Input['ConditionArgs']]] conditions: Conditions on which alerts will be filtered.
        :param pulumi.Input[str] description: Description of alert processing rule.
        :param pulumi.Input[bool] enabled: Indicates if the given alert processing rule is enabled or disabled.
        :param pulumi.Input['ScheduleArgs'] schedule: Scheduling for alert processing rule.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "scopes", scopes)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is None:
            enabled = True
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input[Union['AddActionGroupsArgs', 'RemoveAllActionGroupsArgs']]]]:
        """
        Actions to be applied.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input[Union['AddActionGroupsArgs', 'RemoveAllActionGroupsArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Scopes on which alert processing rule will apply.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConditionArgs']]]]:
        """
        Conditions on which alerts will be filtered.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of alert processing rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the given alert processing rule is enabled or disabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['ScheduleArgs']]:
        """
        Scheduling for alert processing rule.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['ScheduleArgs']]):
        pulumi.set(self, "schedule", value)


@pulumi.input_type
class ConditionArgs:
    def __init__(__self__, *,
                 field: Optional[pulumi.Input[Union[str, 'Field']]] = None,
                 operator: Optional[pulumi.Input[Union[str, 'Operator']]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Condition to trigger an alert processing rule.
        :param pulumi.Input[Union[str, 'Field']] field: Field for a given condition.
        :param pulumi.Input[Union[str, 'Operator']] operator: Operator for a given condition.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: List of values to match for a given condition.
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[Union[str, 'Field']]]:
        """
        Field for a given condition.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[Union[str, 'Field']]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[Union[str, 'Operator']]]:
        """
        Operator for a given condition.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[Union[str, 'Operator']]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of values to match for a given condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class DailyRecurrenceArgs:
    def __init__(__self__, *,
                 end_time: pulumi.Input[str],
                 recurrence_type: pulumi.Input[str],
                 start_time: pulumi.Input[str]):
        """
        Daily recurrence object.
        :param pulumi.Input[str] end_time: End time for recurrence.
        :param pulumi.Input[str] recurrence_type: Specifies when the recurrence should be applied.
               Expected value is 'Daily'.
        :param pulumi.Input[str] start_time: Start time for recurrence.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "recurrence_type", 'Daily')
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Input[str]:
        """
        End time for recurrence.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> pulumi.Input[str]:
        """
        Specifies when the recurrence should be applied.
        Expected value is 'Daily'.
        """
        return pulumi.get(self, "recurrence_type")

    @recurrence_type.setter
    def recurrence_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "recurrence_type", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[str]:
        """
        Start time for recurrence.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class MonthlyRecurrenceArgs:
    def __init__(__self__, *,
                 days_of_month: pulumi.Input[Sequence[pulumi.Input[int]]],
                 recurrence_type: pulumi.Input[str],
                 end_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        Monthly recurrence object.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] days_of_month: Specifies the values for monthly recurrence pattern.
        :param pulumi.Input[str] recurrence_type: Specifies when the recurrence should be applied.
               Expected value is 'Monthly'.
        :param pulumi.Input[str] end_time: End time for recurrence.
        :param pulumi.Input[str] start_time: Start time for recurrence.
        """
        pulumi.set(__self__, "days_of_month", days_of_month)
        pulumi.set(__self__, "recurrence_type", 'Monthly')
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="daysOfMonth")
    def days_of_month(self) -> pulumi.Input[Sequence[pulumi.Input[int]]]:
        """
        Specifies the values for monthly recurrence pattern.
        """
        return pulumi.get(self, "days_of_month")

    @days_of_month.setter
    def days_of_month(self, value: pulumi.Input[Sequence[pulumi.Input[int]]]):
        pulumi.set(self, "days_of_month", value)

    @property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> pulumi.Input[str]:
        """
        Specifies when the recurrence should be applied.
        Expected value is 'Monthly'.
        """
        return pulumi.get(self, "recurrence_type")

    @recurrence_type.setter
    def recurrence_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "recurrence_type", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        End time for recurrence.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Start time for recurrence.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class RemoveAllActionGroupsArgs:
    def __init__(__self__, *,
                 action_type: pulumi.Input[str]):
        """
        Indicates if all action groups should be removed.
        :param pulumi.Input[str] action_type: Action that should be applied.
               Expected value is 'RemoveAllActionGroups'.
        """
        pulumi.set(__self__, "action_type", 'RemoveAllActionGroups')

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input[str]:
        """
        Action that should be applied.
        Expected value is 'RemoveAllActionGroups'.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_type", value)


@pulumi.input_type
class ScheduleArgs:
    def __init__(__self__, *,
                 effective_from: Optional[pulumi.Input[str]] = None,
                 effective_until: Optional[pulumi.Input[str]] = None,
                 recurrences: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DailyRecurrenceArgs', 'MonthlyRecurrenceArgs', 'WeeklyRecurrenceArgs']]]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        Scheduling configuration for a given alert processing rule.
        :param pulumi.Input[str] effective_from: Scheduling effective from time. Date-Time in ISO-8601 format without timezone suffix.
        :param pulumi.Input[str] effective_until: Scheduling effective until time. Date-Time in ISO-8601 format without timezone suffix.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DailyRecurrenceArgs', 'MonthlyRecurrenceArgs', 'WeeklyRecurrenceArgs']]]] recurrences: List of recurrences.
        :param pulumi.Input[str] time_zone: Scheduling time zone.
        """
        if effective_from is not None:
            pulumi.set(__self__, "effective_from", effective_from)
        if effective_until is not None:
            pulumi.set(__self__, "effective_until", effective_until)
        if recurrences is not None:
            pulumi.set(__self__, "recurrences", recurrences)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="effectiveFrom")
    def effective_from(self) -> Optional[pulumi.Input[str]]:
        """
        Scheduling effective from time. Date-Time in ISO-8601 format without timezone suffix.
        """
        return pulumi.get(self, "effective_from")

    @effective_from.setter
    def effective_from(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_from", value)

    @property
    @pulumi.getter(name="effectiveUntil")
    def effective_until(self) -> Optional[pulumi.Input[str]]:
        """
        Scheduling effective until time. Date-Time in ISO-8601 format without timezone suffix.
        """
        return pulumi.get(self, "effective_until")

    @effective_until.setter
    def effective_until(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_until", value)

    @property
    @pulumi.getter
    def recurrences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['DailyRecurrenceArgs', 'MonthlyRecurrenceArgs', 'WeeklyRecurrenceArgs']]]]]:
        """
        List of recurrences.
        """
        return pulumi.get(self, "recurrences")

    @recurrences.setter
    def recurrences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DailyRecurrenceArgs', 'MonthlyRecurrenceArgs', 'WeeklyRecurrenceArgs']]]]]):
        pulumi.set(self, "recurrences", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Scheduling time zone.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class WeeklyRecurrenceArgs:
    def __init__(__self__, *,
                 days_of_week: pulumi.Input[Sequence[pulumi.Input[Union[str, 'DaysOfWeek']]]],
                 recurrence_type: pulumi.Input[str],
                 end_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        Weekly recurrence object.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'DaysOfWeek']]]] days_of_week: Specifies the values for weekly recurrence pattern.
        :param pulumi.Input[str] recurrence_type: Specifies when the recurrence should be applied.
               Expected value is 'Weekly'.
        :param pulumi.Input[str] end_time: End time for recurrence.
        :param pulumi.Input[str] start_time: Start time for recurrence.
        """
        pulumi.set(__self__, "days_of_week", days_of_week)
        pulumi.set(__self__, "recurrence_type", 'Weekly')
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="daysOfWeek")
    def days_of_week(self) -> pulumi.Input[Sequence[pulumi.Input[Union[str, 'DaysOfWeek']]]]:
        """
        Specifies the values for weekly recurrence pattern.
        """
        return pulumi.get(self, "days_of_week")

    @days_of_week.setter
    def days_of_week(self, value: pulumi.Input[Sequence[pulumi.Input[Union[str, 'DaysOfWeek']]]]):
        pulumi.set(self, "days_of_week", value)

    @property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> pulumi.Input[str]:
        """
        Specifies when the recurrence should be applied.
        Expected value is 'Weekly'.
        """
        return pulumi.get(self, "recurrence_type")

    @recurrence_type.setter
    def recurrence_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "recurrence_type", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        End time for recurrence.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Start time for recurrence.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


