# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ConsolePropertiesResponse',
    'StorageProfileResponse',
    'TerminalSettingsResponse',
    'UserPropertiesResponse',
]

@pulumi.output_type
class ConsolePropertiesResponse(dict):
    """
    Cloud shell console properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osType":
            suggest = "os_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConsolePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConsolePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConsolePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_type: str,
                 provisioning_state: str,
                 uri: str):
        """
        Cloud shell console properties.
        :param str os_type: The operating system type of the cloud shell.
        :param str provisioning_state: Provisioning state of the console.
        :param str uri: Uri of the console.
        """
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The operating system type of the cloud shell.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the console.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Uri of the console.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class StorageProfileResponse(dict):
    """
    The storage profile of the user settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeInGB":
            suggest = "disk_size_in_gb"
        elif key == "fileShareName":
            suggest = "file_share_name"
        elif key == "storageAccountResourceId":
            suggest = "storage_account_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size_in_gb: Optional[int] = None,
                 file_share_name: Optional[str] = None,
                 storage_account_resource_id: Optional[str] = None):
        """
        The storage profile of the user settings.
        :param int disk_size_in_gb: Size of file share
        :param str file_share_name: Name of the mounted file share. 63 characters or less, lowercase alphabet, numbers, and -
        :param str storage_account_resource_id: Full resource ID of storage account.
        """
        if disk_size_in_gb is not None:
            pulumi.set(__self__, "disk_size_in_gb", disk_size_in_gb)
        if file_share_name is not None:
            pulumi.set(__self__, "file_share_name", file_share_name)
        if storage_account_resource_id is not None:
            pulumi.set(__self__, "storage_account_resource_id", storage_account_resource_id)

    @property
    @pulumi.getter(name="diskSizeInGB")
    def disk_size_in_gb(self) -> Optional[int]:
        """
        Size of file share
        """
        return pulumi.get(self, "disk_size_in_gb")

    @property
    @pulumi.getter(name="fileShareName")
    def file_share_name(self) -> Optional[str]:
        """
        Name of the mounted file share. 63 characters or less, lowercase alphabet, numbers, and -
        """
        return pulumi.get(self, "file_share_name")

    @property
    @pulumi.getter(name="storageAccountResourceId")
    def storage_account_resource_id(self) -> Optional[str]:
        """
        Full resource ID of storage account.
        """
        return pulumi.get(self, "storage_account_resource_id")


@pulumi.output_type
class TerminalSettingsResponse(dict):
    """
    Settings for terminal appearance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fontSize":
            suggest = "font_size"
        elif key == "fontStyle":
            suggest = "font_style"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TerminalSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TerminalSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TerminalSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 font_size: Optional[str] = None,
                 font_style: Optional[str] = None):
        """
        Settings for terminal appearance.
        :param str font_size: Size of terminal font.
        :param str font_style: Style of terminal font.
        """
        if font_size is not None:
            pulumi.set(__self__, "font_size", font_size)
        if font_style is not None:
            pulumi.set(__self__, "font_style", font_style)

    @property
    @pulumi.getter(name="fontSize")
    def font_size(self) -> Optional[str]:
        """
        Size of terminal font.
        """
        return pulumi.get(self, "font_size")

    @property
    @pulumi.getter(name="fontStyle")
    def font_style(self) -> Optional[str]:
        """
        Style of terminal font.
        """
        return pulumi.get(self, "font_style")


@pulumi.output_type
class UserPropertiesResponse(dict):
    """
    The cloud shell user settings properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preferredLocation":
            suggest = "preferred_location"
        elif key == "preferredOsType":
            suggest = "preferred_os_type"
        elif key == "preferredShellType":
            suggest = "preferred_shell_type"
        elif key == "storageProfile":
            suggest = "storage_profile"
        elif key == "terminalSettings":
            suggest = "terminal_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preferred_location: str,
                 preferred_os_type: str,
                 preferred_shell_type: str,
                 storage_profile: 'outputs.StorageProfileResponse',
                 terminal_settings: 'outputs.TerminalSettingsResponse'):
        """
        The cloud shell user settings properties.
        :param str preferred_location: The preferred location of the cloud shell.
        :param str preferred_os_type: The operating system type of the cloud shell. Deprecated, use preferredShellType.
        :param str preferred_shell_type: The shell type of the cloud shell.
        :param 'StorageProfileResponse' storage_profile: The storage profile of the user settings.
        :param 'TerminalSettingsResponse' terminal_settings: Settings for terminal appearance.
        """
        pulumi.set(__self__, "preferred_location", preferred_location)
        pulumi.set(__self__, "preferred_os_type", preferred_os_type)
        pulumi.set(__self__, "preferred_shell_type", preferred_shell_type)
        pulumi.set(__self__, "storage_profile", storage_profile)
        pulumi.set(__self__, "terminal_settings", terminal_settings)

    @property
    @pulumi.getter(name="preferredLocation")
    def preferred_location(self) -> str:
        """
        The preferred location of the cloud shell.
        """
        return pulumi.get(self, "preferred_location")

    @property
    @pulumi.getter(name="preferredOsType")
    def preferred_os_type(self) -> str:
        """
        The operating system type of the cloud shell. Deprecated, use preferredShellType.
        """
        return pulumi.get(self, "preferred_os_type")

    @property
    @pulumi.getter(name="preferredShellType")
    def preferred_shell_type(self) -> str:
        """
        The shell type of the cloud shell.
        """
        return pulumi.get(self, "preferred_shell_type")

    @property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> 'outputs.StorageProfileResponse':
        """
        The storage profile of the user settings.
        """
        return pulumi.get(self, "storage_profile")

    @property
    @pulumi.getter(name="terminalSettings")
    def terminal_settings(self) -> 'outputs.TerminalSettingsResponse':
        """
        Settings for terminal appearance.
        """
        return pulumi.get(self, "terminal_settings")


