# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AppSkuInfoArgs',
    'NetworkRuleSetIpRuleArgs',
    'NetworkRuleSetsArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'SystemAssignedServiceIdentityArgs',
]

@pulumi.input_type
class AppSkuInfoArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'AppSku']]):
        """
        Information about the SKU of the IoT Central application.
        :param pulumi.Input[Union[str, 'AppSku']] name: The name of the SKU.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'AppSku']]:
        """
        The name of the SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'AppSku']]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class NetworkRuleSetIpRuleArgs:
    def __init__(__self__, *,
                 filter_name: Optional[pulumi.Input[str]] = None,
                 ip_mask: Optional[pulumi.Input[str]] = None):
        """
        An object for an IP range that will be allowed access.
        :param pulumi.Input[str] filter_name: The readable name of the IP rule.
        :param pulumi.Input[str] ip_mask: The CIDR block defining the IP range.
        """
        if filter_name is not None:
            pulumi.set(__self__, "filter_name", filter_name)
        if ip_mask is not None:
            pulumi.set(__self__, "ip_mask", ip_mask)

    @property
    @pulumi.getter(name="filterName")
    def filter_name(self) -> Optional[pulumi.Input[str]]:
        """
        The readable name of the IP rule.
        """
        return pulumi.get(self, "filter_name")

    @filter_name.setter
    def filter_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_name", value)

    @property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block defining the IP range.
        """
        return pulumi.get(self, "ip_mask")

    @ip_mask.setter
    def ip_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_mask", value)


@pulumi.input_type
class NetworkRuleSetsArgs:
    def __init__(__self__, *,
                 apply_to_devices: Optional[pulumi.Input[bool]] = None,
                 apply_to_io_t_central: Optional[pulumi.Input[bool]] = None,
                 default_action: Optional[pulumi.Input[Union[str, 'NetworkAction']]] = None,
                 ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkRuleSetIpRuleArgs']]]] = None):
        """
        Network Rule Set Properties of this IoT Central application.
        :param pulumi.Input[bool] apply_to_devices: Whether these rules apply for device connectivity to IoT Hub and Device Provisioning service associated with this application.
        :param pulumi.Input[bool] apply_to_io_t_central: Whether these rules apply for connectivity via IoT Central web portal and APIs.
        :param pulumi.Input[Union[str, 'NetworkAction']] default_action: The default network action to apply.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkRuleSetIpRuleArgs']]] ip_rules: List of IP rules.
        """
        if apply_to_devices is None:
            apply_to_devices = False
        if apply_to_devices is not None:
            pulumi.set(__self__, "apply_to_devices", apply_to_devices)
        if apply_to_io_t_central is None:
            apply_to_io_t_central = False
        if apply_to_io_t_central is not None:
            pulumi.set(__self__, "apply_to_io_t_central", apply_to_io_t_central)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)

    @property
    @pulumi.getter(name="applyToDevices")
    def apply_to_devices(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether these rules apply for device connectivity to IoT Hub and Device Provisioning service associated with this application.
        """
        return pulumi.get(self, "apply_to_devices")

    @apply_to_devices.setter
    def apply_to_devices(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_to_devices", value)

    @property
    @pulumi.getter(name="applyToIoTCentral")
    def apply_to_io_t_central(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether these rules apply for connectivity via IoT Central web portal and APIs.
        """
        return pulumi.get(self, "apply_to_io_t_central")

    @apply_to_io_t_central.setter
    def apply_to_io_t_central(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_to_io_t_central", value)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[Union[str, 'NetworkAction']]]:
        """
        The default network action to apply.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[Union[str, 'NetworkAction']]]):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkRuleSetIpRuleArgs']]]]:
        """
        List of IP rules.
        """
        return pulumi.get(self, "ip_rules")

    @ip_rules.setter
    def ip_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkRuleSetIpRuleArgs']]]]):
        pulumi.set(self, "ip_rules", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 actions_required: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param pulumi.Input[str] actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param pulumi.Input[str] description: The reason for approval/rejection of the connection.
        :param pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']] status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[pulumi.Input[str]]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @actions_required.setter
    def actions_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "actions_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class SystemAssignedServiceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'SystemAssignedServiceIdentityType']]):
        """
        Managed service identity (either system assigned, or none)
        :param pulumi.Input[Union[str, 'SystemAssignedServiceIdentityType']] type: Type of managed service identity (either system assigned, or none).
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'SystemAssignedServiceIdentityType']]:
        """
        Type of managed service identity (either system assigned, or none).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'SystemAssignedServiceIdentityType']]):
        pulumi.set(self, "type", value)


