# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AppWhitelistingIssueSummaryResponse',
    'JitNetworkAccessPolicyVirtualMachineResponse',
    'JitNetworkAccessPortRuleResponse',
    'JitNetworkAccessRequestPortResponse',
    'JitNetworkAccessRequestResponse',
    'JitNetworkAccessRequestVirtualMachineResponse',
    'PathRecommendationResponse',
    'ProtectionModeResponse',
    'PublisherInfoResponse',
    'UserRecommendationResponse',
    'VmRecommendationResponse',
]

@pulumi.output_type
class AppWhitelistingIssueSummaryResponse(dict):
    """
    Represents a summary of the alerts of the VM/server group
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numberOfVms":
            suggest = "number_of_vms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppWhitelistingIssueSummaryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppWhitelistingIssueSummaryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppWhitelistingIssueSummaryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issue: Optional[str] = None,
                 number_of_vms: Optional[float] = None):
        """
        Represents a summary of the alerts of the VM/server group
        :param str issue: An alert that VMs/servers within a group can have
        :param float number_of_vms: The number of machines in the VM/server group that have this alert
        """
        if issue is not None:
            pulumi.set(__self__, "issue", issue)
        if number_of_vms is not None:
            pulumi.set(__self__, "number_of_vms", number_of_vms)

    @property
    @pulumi.getter
    def issue(self) -> Optional[str]:
        """
        An alert that VMs/servers within a group can have
        """
        return pulumi.get(self, "issue")

    @property
    @pulumi.getter(name="numberOfVms")
    def number_of_vms(self) -> Optional[float]:
        """
        The number of machines in the VM/server group that have this alert
        """
        return pulumi.get(self, "number_of_vms")


@pulumi.output_type
class JitNetworkAccessPolicyVirtualMachineResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicIpAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JitNetworkAccessPolicyVirtualMachineResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JitNetworkAccessPolicyVirtualMachineResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JitNetworkAccessPolicyVirtualMachineResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 ports: Sequence['outputs.JitNetworkAccessPortRuleResponse'],
                 public_ip_address: Optional[str] = None):
        """
        :param str id: Resource ID of the virtual machine that is linked to this policy
        :param Sequence['JitNetworkAccessPortRuleResponse'] ports: Port configurations for the virtual machine
        :param str public_ip_address: Public IP address of the Azure Firewall that is linked to this policy, if applicable
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ports", ports)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID of the virtual machine that is linked to this policy
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.JitNetworkAccessPortRuleResponse']:
        """
        Port configurations for the virtual machine
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[str]:
        """
        Public IP address of the Azure Firewall that is linked to this policy, if applicable
        """
        return pulumi.get(self, "public_ip_address")


@pulumi.output_type
class JitNetworkAccessPortRuleResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRequestAccessDuration":
            suggest = "max_request_access_duration"
        elif key == "allowedSourceAddressPrefix":
            suggest = "allowed_source_address_prefix"
        elif key == "allowedSourceAddressPrefixes":
            suggest = "allowed_source_address_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JitNetworkAccessPortRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JitNetworkAccessPortRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JitNetworkAccessPortRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_request_access_duration: str,
                 number: int,
                 protocol: str,
                 allowed_source_address_prefix: Optional[str] = None,
                 allowed_source_address_prefixes: Optional[Sequence[str]] = None):
        """
        :param str max_request_access_duration: Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
        :param str allowed_source_address_prefix: Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        :param Sequence[str] allowed_source_address_prefixes: Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        """
        pulumi.set(__self__, "max_request_access_duration", max_request_access_duration)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "protocol", protocol)
        if allowed_source_address_prefix is not None:
            pulumi.set(__self__, "allowed_source_address_prefix", allowed_source_address_prefix)
        if allowed_source_address_prefixes is not None:
            pulumi.set(__self__, "allowed_source_address_prefixes", allowed_source_address_prefixes)

    @property
    @pulumi.getter(name="maxRequestAccessDuration")
    def max_request_access_duration(self) -> str:
        """
        Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
        """
        return pulumi.get(self, "max_request_access_duration")

    @property
    @pulumi.getter
    def number(self) -> int:
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="allowedSourceAddressPrefix")
    def allowed_source_address_prefix(self) -> Optional[str]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        """
        return pulumi.get(self, "allowed_source_address_prefix")

    @property
    @pulumi.getter(name="allowedSourceAddressPrefixes")
    def allowed_source_address_prefixes(self) -> Optional[Sequence[str]]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        """
        return pulumi.get(self, "allowed_source_address_prefixes")


@pulumi.output_type
class JitNetworkAccessRequestPortResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTimeUtc":
            suggest = "end_time_utc"
        elif key == "statusReason":
            suggest = "status_reason"
        elif key == "allowedSourceAddressPrefix":
            suggest = "allowed_source_address_prefix"
        elif key == "allowedSourceAddressPrefixes":
            suggest = "allowed_source_address_prefixes"
        elif key == "mappedPort":
            suggest = "mapped_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JitNetworkAccessRequestPortResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JitNetworkAccessRequestPortResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JitNetworkAccessRequestPortResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time_utc: str,
                 number: int,
                 status: str,
                 status_reason: str,
                 allowed_source_address_prefix: Optional[str] = None,
                 allowed_source_address_prefixes: Optional[Sequence[str]] = None,
                 mapped_port: Optional[int] = None):
        """
        :param str end_time_utc: The date & time at which the request ends in UTC
        :param str status: The status of the port
        :param str status_reason: A description of why the `status` has its value
        :param str allowed_source_address_prefix: Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        :param Sequence[str] allowed_source_address_prefixes: Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        :param int mapped_port: The port which is mapped to this port's `number` in the Azure Firewall, if applicable
        """
        pulumi.set(__self__, "end_time_utc", end_time_utc)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_reason", status_reason)
        if allowed_source_address_prefix is not None:
            pulumi.set(__self__, "allowed_source_address_prefix", allowed_source_address_prefix)
        if allowed_source_address_prefixes is not None:
            pulumi.set(__self__, "allowed_source_address_prefixes", allowed_source_address_prefixes)
        if mapped_port is not None:
            pulumi.set(__self__, "mapped_port", mapped_port)

    @property
    @pulumi.getter(name="endTimeUtc")
    def end_time_utc(self) -> str:
        """
        The date & time at which the request ends in UTC
        """
        return pulumi.get(self, "end_time_utc")

    @property
    @pulumi.getter
    def number(self) -> int:
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the port
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> str:
        """
        A description of why the `status` has its value
        """
        return pulumi.get(self, "status_reason")

    @property
    @pulumi.getter(name="allowedSourceAddressPrefix")
    def allowed_source_address_prefix(self) -> Optional[str]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        """
        return pulumi.get(self, "allowed_source_address_prefix")

    @property
    @pulumi.getter(name="allowedSourceAddressPrefixes")
    def allowed_source_address_prefixes(self) -> Optional[Sequence[str]]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        """
        return pulumi.get(self, "allowed_source_address_prefixes")

    @property
    @pulumi.getter(name="mappedPort")
    def mapped_port(self) -> Optional[int]:
        """
        The port which is mapped to this port's `number` in the Azure Firewall, if applicable
        """
        return pulumi.get(self, "mapped_port")


@pulumi.output_type
class JitNetworkAccessRequestResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTimeUtc":
            suggest = "start_time_utc"
        elif key == "virtualMachines":
            suggest = "virtual_machines"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JitNetworkAccessRequestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JitNetworkAccessRequestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JitNetworkAccessRequestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 requestor: str,
                 start_time_utc: str,
                 virtual_machines: Sequence['outputs.JitNetworkAccessRequestVirtualMachineResponse'],
                 justification: Optional[str] = None):
        """
        :param str requestor: The identity of the person who made the request
        :param str start_time_utc: The start time of the request in UTC
        :param str justification: The justification for making the initiate request
        """
        pulumi.set(__self__, "requestor", requestor)
        pulumi.set(__self__, "start_time_utc", start_time_utc)
        pulumi.set(__self__, "virtual_machines", virtual_machines)
        if justification is not None:
            pulumi.set(__self__, "justification", justification)

    @property
    @pulumi.getter
    def requestor(self) -> str:
        """
        The identity of the person who made the request
        """
        return pulumi.get(self, "requestor")

    @property
    @pulumi.getter(name="startTimeUtc")
    def start_time_utc(self) -> str:
        """
        The start time of the request in UTC
        """
        return pulumi.get(self, "start_time_utc")

    @property
    @pulumi.getter(name="virtualMachines")
    def virtual_machines(self) -> Sequence['outputs.JitNetworkAccessRequestVirtualMachineResponse']:
        return pulumi.get(self, "virtual_machines")

    @property
    @pulumi.getter
    def justification(self) -> Optional[str]:
        """
        The justification for making the initiate request
        """
        return pulumi.get(self, "justification")


@pulumi.output_type
class JitNetworkAccessRequestVirtualMachineResponse(dict):
    def __init__(__self__, *,
                 id: str,
                 ports: Sequence['outputs.JitNetworkAccessRequestPortResponse']):
        """
        :param str id: Resource ID of the virtual machine that is linked to this policy
        :param Sequence['JitNetworkAccessRequestPortResponse'] ports: The ports that were opened for the virtual machine
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID of the virtual machine that is linked to this policy
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.JitNetworkAccessRequestPortResponse']:
        """
        The ports that were opened for the virtual machine
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class PathRecommendationResponse(dict):
    """
    Represents a path that is recommended to be allowed and its properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationStatus":
            suggest = "configuration_status"
        elif key == "fileType":
            suggest = "file_type"
        elif key == "publisherInfo":
            suggest = "publisher_info"
        elif key == "userSids":
            suggest = "user_sids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathRecommendationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathRecommendationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathRecommendationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[str] = None,
                 common: Optional[bool] = None,
                 configuration_status: Optional[str] = None,
                 file_type: Optional[str] = None,
                 path: Optional[str] = None,
                 publisher_info: Optional['outputs.PublisherInfoResponse'] = None,
                 type: Optional[str] = None,
                 user_sids: Optional[Sequence[str]] = None,
                 usernames: Optional[Sequence['outputs.UserRecommendationResponse']] = None):
        """
        Represents a path that is recommended to be allowed and its properties
        :param str action: The recommendation action of the VM/server or rule
        :param bool common: Whether the path is commonly run on the machine
        :param str configuration_status: The configuration status of the VM/server group or machine or rule on the machine
        :param str file_type: The type of the file (for Linux files - Executable is used)
        :param str path: The full path to whitelist
        :param 'PublisherInfoResponse' publisher_info: Represents the publisher information of a process/rule
        :param str type: The type of the rule to be allowed
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if common is not None:
            pulumi.set(__self__, "common", common)
        if configuration_status is not None:
            pulumi.set(__self__, "configuration_status", configuration_status)
        if file_type is not None:
            pulumi.set(__self__, "file_type", file_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if publisher_info is not None:
            pulumi.set(__self__, "publisher_info", publisher_info)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_sids is not None:
            pulumi.set(__self__, "user_sids", user_sids)
        if usernames is not None:
            pulumi.set(__self__, "usernames", usernames)

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        The recommendation action of the VM/server or rule
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def common(self) -> Optional[bool]:
        """
        Whether the path is commonly run on the machine
        """
        return pulumi.get(self, "common")

    @property
    @pulumi.getter(name="configurationStatus")
    def configuration_status(self) -> Optional[str]:
        """
        The configuration status of the VM/server group or machine or rule on the machine
        """
        return pulumi.get(self, "configuration_status")

    @property
    @pulumi.getter(name="fileType")
    def file_type(self) -> Optional[str]:
        """
        The type of the file (for Linux files - Executable is used)
        """
        return pulumi.get(self, "file_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The full path to whitelist
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="publisherInfo")
    def publisher_info(self) -> Optional['outputs.PublisherInfoResponse']:
        """
        Represents the publisher information of a process/rule
        """
        return pulumi.get(self, "publisher_info")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the rule to be allowed
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userSids")
    def user_sids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "user_sids")

    @property
    @pulumi.getter
    def usernames(self) -> Optional[Sequence['outputs.UserRecommendationResponse']]:
        return pulumi.get(self, "usernames")


@pulumi.output_type
class ProtectionModeResponse(dict):
    """
    The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux.
    """
    def __init__(__self__, *,
                 exe: Optional[str] = None,
                 executable: Optional[str] = None,
                 msi: Optional[str] = None,
                 script: Optional[str] = None):
        """
        The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux.
        :param str exe: The application control policy enforcement/protection mode of the VM/server group
        :param str executable: The application control policy enforcement/protection mode of the VM/server group
        :param str msi: The application control policy enforcement/protection mode of the VM/server group
        :param str script: The application control policy enforcement/protection mode of the VM/server group
        """
        if exe is not None:
            pulumi.set(__self__, "exe", exe)
        if executable is not None:
            pulumi.set(__self__, "executable", executable)
        if msi is not None:
            pulumi.set(__self__, "msi", msi)
        if script is not None:
            pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def exe(self) -> Optional[str]:
        """
        The application control policy enforcement/protection mode of the VM/server group
        """
        return pulumi.get(self, "exe")

    @property
    @pulumi.getter
    def executable(self) -> Optional[str]:
        """
        The application control policy enforcement/protection mode of the VM/server group
        """
        return pulumi.get(self, "executable")

    @property
    @pulumi.getter
    def msi(self) -> Optional[str]:
        """
        The application control policy enforcement/protection mode of the VM/server group
        """
        return pulumi.get(self, "msi")

    @property
    @pulumi.getter
    def script(self) -> Optional[str]:
        """
        The application control policy enforcement/protection mode of the VM/server group
        """
        return pulumi.get(self, "script")


@pulumi.output_type
class PublisherInfoResponse(dict):
    """
    Represents the publisher information of a process/rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "binaryName":
            suggest = "binary_name"
        elif key == "productName":
            suggest = "product_name"
        elif key == "publisherName":
            suggest = "publisher_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublisherInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublisherInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublisherInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 binary_name: Optional[str] = None,
                 product_name: Optional[str] = None,
                 publisher_name: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Represents the publisher information of a process/rule
        :param str binary_name: The "OriginalName" field taken from the file's version resource
        :param str product_name: The product name taken from the file's version resource
        :param str publisher_name: The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country
        :param str version: The binary file version taken from the file's version resource
        """
        if binary_name is not None:
            pulumi.set(__self__, "binary_name", binary_name)
        if product_name is not None:
            pulumi.set(__self__, "product_name", product_name)
        if publisher_name is not None:
            pulumi.set(__self__, "publisher_name", publisher_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="binaryName")
    def binary_name(self) -> Optional[str]:
        """
        The "OriginalName" field taken from the file's version resource
        """
        return pulumi.get(self, "binary_name")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[str]:
        """
        The product name taken from the file's version resource
        """
        return pulumi.get(self, "product_name")

    @property
    @pulumi.getter(name="publisherName")
    def publisher_name(self) -> Optional[str]:
        """
        The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country
        """
        return pulumi.get(self, "publisher_name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The binary file version taken from the file's version resource
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class UserRecommendationResponse(dict):
    """
    Represents a user that is recommended to be allowed for a certain rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recommendationAction":
            suggest = "recommendation_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserRecommendationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserRecommendationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserRecommendationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recommendation_action: Optional[str] = None,
                 username: Optional[str] = None):
        """
        Represents a user that is recommended to be allowed for a certain rule
        :param str recommendation_action: The recommendation action of the VM/server or rule
        :param str username: Represents a user that is recommended to be allowed for a certain rule
        """
        if recommendation_action is not None:
            pulumi.set(__self__, "recommendation_action", recommendation_action)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="recommendationAction")
    def recommendation_action(self) -> Optional[str]:
        """
        The recommendation action of the VM/server or rule
        """
        return pulumi.get(self, "recommendation_action")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Represents a user that is recommended to be allowed for a certain rule
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class VmRecommendationResponse(dict):
    """
    Represents a machine that is part of a VM/server group
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationStatus":
            suggest = "configuration_status"
        elif key == "enforcementSupport":
            suggest = "enforcement_support"
        elif key == "recommendationAction":
            suggest = "recommendation_action"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmRecommendationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmRecommendationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmRecommendationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_status: Optional[str] = None,
                 enforcement_support: Optional[str] = None,
                 recommendation_action: Optional[str] = None,
                 resource_id: Optional[str] = None):
        """
        Represents a machine that is part of a VM/server group
        :param str configuration_status: The configuration status of the VM/server group or machine or rule on the machine
        :param str enforcement_support: The VM/server supportability of Enforce feature
        :param str recommendation_action: The recommendation action of the VM/server or rule
        :param str resource_id: The full azure resource id of the machine
        """
        if configuration_status is not None:
            pulumi.set(__self__, "configuration_status", configuration_status)
        if enforcement_support is not None:
            pulumi.set(__self__, "enforcement_support", enforcement_support)
        if recommendation_action is not None:
            pulumi.set(__self__, "recommendation_action", recommendation_action)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="configurationStatus")
    def configuration_status(self) -> Optional[str]:
        """
        The configuration status of the VM/server group or machine or rule on the machine
        """
        return pulumi.get(self, "configuration_status")

    @property
    @pulumi.getter(name="enforcementSupport")
    def enforcement_support(self) -> Optional[str]:
        """
        The VM/server supportability of Enforce feature
        """
        return pulumi.get(self, "enforcement_support")

    @property
    @pulumi.getter(name="recommendationAction")
    def recommendation_action(self) -> Optional[str]:
        """
        The recommendation action of the VM/server or rule
        """
        return pulumi.get(self, "recommendation_action")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The full azure resource id of the machine
        """
        return pulumi.get(self, "resource_id")


