# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ActiveDirectoryPropertiesResponse',
    'AzureFilesIdentityBasedAuthenticationResponse',
    'BlobInventoryPolicyDefinitionResponse',
    'BlobInventoryPolicyFilterResponse',
    'BlobInventoryPolicyRuleResponse',
    'BlobInventoryPolicySchemaResponse',
    'BlobRestoreParametersResponse',
    'BlobRestoreRangeResponse',
    'BlobRestoreStatusResponse',
    'ChangeFeedResponse',
    'CorsRuleResponse',
    'CorsRulesResponse',
    'CustomDomainResponse',
    'DateAfterCreationResponse',
    'DateAfterModificationResponse',
    'DeleteRetentionPolicyResponse',
    'EncryptionIdentityResponse',
    'EncryptionResponse',
    'EncryptionScopeKeyVaultPropertiesResponse',
    'EncryptionServiceResponse',
    'EncryptionServicesResponse',
    'EndpointsResponse',
    'ExtendedLocationResponse',
    'GeoReplicationStatsResponse',
    'IPRuleResponse',
    'IdentityResponse',
    'ImmutabilityPolicyPropertiesResponse',
    'KeyCreationTimeResponse',
    'KeyPolicyResponse',
    'KeyVaultPropertiesResponse',
    'LastAccessTimeTrackingPolicyResponse',
    'LegalHoldPropertiesResponse',
    'ManagementPolicyActionResponse',
    'ManagementPolicyBaseBlobResponse',
    'ManagementPolicyDefinitionResponse',
    'ManagementPolicyFilterResponse',
    'ManagementPolicyRuleResponse',
    'ManagementPolicySchemaResponse',
    'ManagementPolicySnapShotResponse',
    'ManagementPolicyVersionResponse',
    'MultichannelResponse',
    'NetworkRuleSetResponse',
    'ObjectReplicationPolicyFilterResponse',
    'ObjectReplicationPolicyRuleResponse',
    'PermissionScopeResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'ProtocolSettingsResponse',
    'ResourceAccessRuleResponse',
    'RestorePolicyPropertiesResponse',
    'RoutingPreferenceResponse',
    'SasPolicyResponse',
    'SkuResponse',
    'SmbSettingResponse',
    'SshPublicKeyResponse',
    'StorageAccountInternetEndpointsResponse',
    'StorageAccountKeyResponse',
    'StorageAccountMicrosoftEndpointsResponse',
    'SystemDataResponse',
    'TagFilterResponse',
    'TagPropertyResponse',
    'UpdateHistoryPropertyResponse',
    'UserAssignedIdentityResponse',
    'VirtualNetworkRuleResponse',
]

@pulumi.output_type
class ActiveDirectoryPropertiesResponse(dict):
    """
    Settings properties for Active Directory (AD).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureStorageSid":
            suggest = "azure_storage_sid"
        elif key == "domainGuid":
            suggest = "domain_guid"
        elif key == "domainName":
            suggest = "domain_name"
        elif key == "domainSid":
            suggest = "domain_sid"
        elif key == "forestName":
            suggest = "forest_name"
        elif key == "netBiosDomainName":
            suggest = "net_bios_domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActiveDirectoryPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActiveDirectoryPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActiveDirectoryPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_storage_sid: str,
                 domain_guid: str,
                 domain_name: str,
                 domain_sid: str,
                 forest_name: str,
                 net_bios_domain_name: str):
        """
        Settings properties for Active Directory (AD).
        :param str azure_storage_sid: Specifies the security identifier (SID) for Azure Storage.
        :param str domain_guid: Specifies the domain GUID.
        :param str domain_name: Specifies the primary domain that the AD DNS server is authoritative for.
        :param str domain_sid: Specifies the security identifier (SID).
        :param str forest_name: Specifies the Active Directory forest to get.
        :param str net_bios_domain_name: Specifies the NetBIOS domain name.
        """
        pulumi.set(__self__, "azure_storage_sid", azure_storage_sid)
        pulumi.set(__self__, "domain_guid", domain_guid)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "domain_sid", domain_sid)
        pulumi.set(__self__, "forest_name", forest_name)
        pulumi.set(__self__, "net_bios_domain_name", net_bios_domain_name)

    @property
    @pulumi.getter(name="azureStorageSid")
    def azure_storage_sid(self) -> str:
        """
        Specifies the security identifier (SID) for Azure Storage.
        """
        return pulumi.get(self, "azure_storage_sid")

    @property
    @pulumi.getter(name="domainGuid")
    def domain_guid(self) -> str:
        """
        Specifies the domain GUID.
        """
        return pulumi.get(self, "domain_guid")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        Specifies the primary domain that the AD DNS server is authoritative for.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="domainSid")
    def domain_sid(self) -> str:
        """
        Specifies the security identifier (SID).
        """
        return pulumi.get(self, "domain_sid")

    @property
    @pulumi.getter(name="forestName")
    def forest_name(self) -> str:
        """
        Specifies the Active Directory forest to get.
        """
        return pulumi.get(self, "forest_name")

    @property
    @pulumi.getter(name="netBiosDomainName")
    def net_bios_domain_name(self) -> str:
        """
        Specifies the NetBIOS domain name.
        """
        return pulumi.get(self, "net_bios_domain_name")


@pulumi.output_type
class AzureFilesIdentityBasedAuthenticationResponse(dict):
    """
    Settings for Azure Files identity based authentication.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "directoryServiceOptions":
            suggest = "directory_service_options"
        elif key == "activeDirectoryProperties":
            suggest = "active_directory_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFilesIdentityBasedAuthenticationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFilesIdentityBasedAuthenticationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFilesIdentityBasedAuthenticationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 directory_service_options: str,
                 active_directory_properties: Optional['outputs.ActiveDirectoryPropertiesResponse'] = None):
        """
        Settings for Azure Files identity based authentication.
        :param str directory_service_options: Indicates the directory service used.
        :param 'ActiveDirectoryPropertiesResponse' active_directory_properties: Required if choose AD.
        """
        pulumi.set(__self__, "directory_service_options", directory_service_options)
        if active_directory_properties is not None:
            pulumi.set(__self__, "active_directory_properties", active_directory_properties)

    @property
    @pulumi.getter(name="directoryServiceOptions")
    def directory_service_options(self) -> str:
        """
        Indicates the directory service used.
        """
        return pulumi.get(self, "directory_service_options")

    @property
    @pulumi.getter(name="activeDirectoryProperties")
    def active_directory_properties(self) -> Optional['outputs.ActiveDirectoryPropertiesResponse']:
        """
        Required if choose AD.
        """
        return pulumi.get(self, "active_directory_properties")


@pulumi.output_type
class BlobInventoryPolicyDefinitionResponse(dict):
    """
    An object that defines the blob inventory rule. Each definition consists of a set of filters.
    """
    def __init__(__self__, *,
                 filters: 'outputs.BlobInventoryPolicyFilterResponse'):
        """
        An object that defines the blob inventory rule. Each definition consists of a set of filters.
        :param 'BlobInventoryPolicyFilterResponse' filters: An object that defines the filter set.
        """
        pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def filters(self) -> 'outputs.BlobInventoryPolicyFilterResponse':
        """
        An object that defines the filter set.
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class BlobInventoryPolicyFilterResponse(dict):
    """
    An object that defines the blob inventory rule filter conditions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blobTypes":
            suggest = "blob_types"
        elif key == "includeBlobVersions":
            suggest = "include_blob_versions"
        elif key == "includeSnapshots":
            suggest = "include_snapshots"
        elif key == "prefixMatch":
            suggest = "prefix_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlobInventoryPolicyFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlobInventoryPolicyFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlobInventoryPolicyFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blob_types: Sequence[str],
                 include_blob_versions: Optional[bool] = None,
                 include_snapshots: Optional[bool] = None,
                 prefix_match: Optional[Sequence[str]] = None):
        """
        An object that defines the blob inventory rule filter conditions.
        :param Sequence[str] blob_types: An array of predefined enum values. Valid values include blockBlob, appendBlob, pageBlob. Hns accounts does not support pageBlobs.
        :param bool include_blob_versions: Includes blob versions in blob inventory when value set to true.
        :param bool include_snapshots: Includes blob snapshots in blob inventory when value set to true.
        :param Sequence[str] prefix_match: An array of strings for blob prefixes to be matched.
        """
        pulumi.set(__self__, "blob_types", blob_types)
        if include_blob_versions is not None:
            pulumi.set(__self__, "include_blob_versions", include_blob_versions)
        if include_snapshots is not None:
            pulumi.set(__self__, "include_snapshots", include_snapshots)
        if prefix_match is not None:
            pulumi.set(__self__, "prefix_match", prefix_match)

    @property
    @pulumi.getter(name="blobTypes")
    def blob_types(self) -> Sequence[str]:
        """
        An array of predefined enum values. Valid values include blockBlob, appendBlob, pageBlob. Hns accounts does not support pageBlobs.
        """
        return pulumi.get(self, "blob_types")

    @property
    @pulumi.getter(name="includeBlobVersions")
    def include_blob_versions(self) -> Optional[bool]:
        """
        Includes blob versions in blob inventory when value set to true.
        """
        return pulumi.get(self, "include_blob_versions")

    @property
    @pulumi.getter(name="includeSnapshots")
    def include_snapshots(self) -> Optional[bool]:
        """
        Includes blob snapshots in blob inventory when value set to true.
        """
        return pulumi.get(self, "include_snapshots")

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> Optional[Sequence[str]]:
        """
        An array of strings for blob prefixes to be matched.
        """
        return pulumi.get(self, "prefix_match")


@pulumi.output_type
class BlobInventoryPolicyRuleResponse(dict):
    """
    An object that wraps the blob inventory rule. Each rule is uniquely defined by name.
    """
    def __init__(__self__, *,
                 definition: 'outputs.BlobInventoryPolicyDefinitionResponse',
                 enabled: bool,
                 name: str):
        """
        An object that wraps the blob inventory rule. Each rule is uniquely defined by name.
        :param 'BlobInventoryPolicyDefinitionResponse' definition: An object that defines the blob inventory policy rule.
        :param bool enabled: Rule is enabled when set to true.
        :param str name: A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
        """
        pulumi.set(__self__, "definition", definition)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def definition(self) -> 'outputs.BlobInventoryPolicyDefinitionResponse':
        """
        An object that defines the blob inventory policy rule.
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Rule is enabled when set to true.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class BlobInventoryPolicySchemaResponse(dict):
    """
    The storage account blob inventory policy rules.
    """
    def __init__(__self__, *,
                 destination: str,
                 enabled: bool,
                 rules: Sequence['outputs.BlobInventoryPolicyRuleResponse'],
                 type: str):
        """
        The storage account blob inventory policy rules.
        :param str destination: Container name where blob inventory files are stored. Must be pre-created.
        :param bool enabled: Policy is enabled if set to true.
        :param Sequence['BlobInventoryPolicyRuleResponse'] rules: The storage account blob inventory policy rules. The rule is applied when it is enabled.
        :param str type: The valid value is Inventory
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        Container name where blob inventory files are stored. Must be pre-created.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Policy is enabled if set to true.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.BlobInventoryPolicyRuleResponse']:
        """
        The storage account blob inventory policy rules. The rule is applied when it is enabled.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The valid value is Inventory
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class BlobRestoreParametersResponse(dict):
    """
    Blob restore parameters
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blobRanges":
            suggest = "blob_ranges"
        elif key == "timeToRestore":
            suggest = "time_to_restore"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlobRestoreParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlobRestoreParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlobRestoreParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blob_ranges: Sequence['outputs.BlobRestoreRangeResponse'],
                 time_to_restore: str):
        """
        Blob restore parameters
        :param Sequence['BlobRestoreRangeResponse'] blob_ranges: Blob ranges to restore.
        :param str time_to_restore: Restore blob to the specified time.
        """
        pulumi.set(__self__, "blob_ranges", blob_ranges)
        pulumi.set(__self__, "time_to_restore", time_to_restore)

    @property
    @pulumi.getter(name="blobRanges")
    def blob_ranges(self) -> Sequence['outputs.BlobRestoreRangeResponse']:
        """
        Blob ranges to restore.
        """
        return pulumi.get(self, "blob_ranges")

    @property
    @pulumi.getter(name="timeToRestore")
    def time_to_restore(self) -> str:
        """
        Restore blob to the specified time.
        """
        return pulumi.get(self, "time_to_restore")


@pulumi.output_type
class BlobRestoreRangeResponse(dict):
    """
    Blob range
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endRange":
            suggest = "end_range"
        elif key == "startRange":
            suggest = "start_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlobRestoreRangeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlobRestoreRangeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlobRestoreRangeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_range: str,
                 start_range: str):
        """
        Blob range
        :param str end_range: Blob end range. This is exclusive. Empty means account end.
        :param str start_range: Blob start range. This is inclusive. Empty means account start.
        """
        pulumi.set(__self__, "end_range", end_range)
        pulumi.set(__self__, "start_range", start_range)

    @property
    @pulumi.getter(name="endRange")
    def end_range(self) -> str:
        """
        Blob end range. This is exclusive. Empty means account end.
        """
        return pulumi.get(self, "end_range")

    @property
    @pulumi.getter(name="startRange")
    def start_range(self) -> str:
        """
        Blob start range. This is inclusive. Empty means account start.
        """
        return pulumi.get(self, "start_range")


@pulumi.output_type
class BlobRestoreStatusResponse(dict):
    """
    Blob restore status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureReason":
            suggest = "failure_reason"
        elif key == "restoreId":
            suggest = "restore_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlobRestoreStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlobRestoreStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlobRestoreStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_reason: str,
                 parameters: 'outputs.BlobRestoreParametersResponse',
                 restore_id: str,
                 status: str):
        """
        Blob restore status.
        :param str failure_reason: Failure reason when blob restore is failed.
        :param 'BlobRestoreParametersResponse' parameters: Blob restore request parameters.
        :param str restore_id: Id for tracking blob restore request.
        :param str status: The status of blob restore progress. Possible values are: - InProgress: Indicates that blob restore is ongoing. - Complete: Indicates that blob restore has been completed successfully. - Failed: Indicates that blob restore is failed.
        """
        pulumi.set(__self__, "failure_reason", failure_reason)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "restore_id", restore_id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> str:
        """
        Failure reason when blob restore is failed.
        """
        return pulumi.get(self, "failure_reason")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.BlobRestoreParametersResponse':
        """
        Blob restore request parameters.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="restoreId")
    def restore_id(self) -> str:
        """
        Id for tracking blob restore request.
        """
        return pulumi.get(self, "restore_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of blob restore progress. Possible values are: - InProgress: Indicates that blob restore is ongoing. - Complete: Indicates that blob restore has been completed successfully. - Failed: Indicates that blob restore is failed.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ChangeFeedResponse(dict):
    """
    The blob service properties for change feed events.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionInDays":
            suggest = "retention_in_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChangeFeedResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChangeFeedResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChangeFeedResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 retention_in_days: Optional[int] = None):
        """
        The blob service properties for change feed events.
        :param bool enabled: Indicates whether change feed event logging is enabled for the Blob service.
        :param int retention_in_days: Indicates the duration of changeFeed retention in days. Minimum value is 1 day and maximum value is 146000 days (400 years). A null value indicates an infinite retention of the change feed.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Indicates whether change feed event logging is enabled for the Blob service.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[int]:
        """
        Indicates the duration of changeFeed retention in days. Minimum value is 1 day and maximum value is 146000 days (400 years). A null value indicates an infinite retention of the change feed.
        """
        return pulumi.get(self, "retention_in_days")


@pulumi.output_type
class CorsRuleResponse(dict):
    """
    Specifies a CORS rule for the Blob service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "exposedHeaders":
            suggest = "exposed_headers"
        elif key == "maxAgeInSeconds":
            suggest = "max_age_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CorsRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CorsRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CorsRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_headers: Sequence[str],
                 allowed_methods: Sequence[str],
                 allowed_origins: Sequence[str],
                 exposed_headers: Sequence[str],
                 max_age_in_seconds: int):
        """
        Specifies a CORS rule for the Blob service.
        :param Sequence[str] allowed_headers: Required if CorsRule element is present. A list of headers allowed to be part of the cross-origin request.
        :param Sequence[str] allowed_methods: Required if CorsRule element is present. A list of HTTP methods that are allowed to be executed by the origin.
        :param Sequence[str] allowed_origins: Required if CorsRule element is present. A list of origin domains that will be allowed via CORS, or "*" to allow all domains
        :param Sequence[str] exposed_headers: Required if CorsRule element is present. A list of response headers to expose to CORS clients.
        :param int max_age_in_seconds: Required if CorsRule element is present. The number of seconds that the client/browser should cache a preflight response.
        """
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "exposed_headers", exposed_headers)
        pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[str]:
        """
        Required if CorsRule element is present. A list of headers allowed to be part of the cross-origin request.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[str]:
        """
        Required if CorsRule element is present. A list of HTTP methods that are allowed to be executed by the origin.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[str]:
        """
        Required if CorsRule element is present. A list of origin domains that will be allowed via CORS, or "*" to allow all domains
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="exposedHeaders")
    def exposed_headers(self) -> Sequence[str]:
        """
        Required if CorsRule element is present. A list of response headers to expose to CORS clients.
        """
        return pulumi.get(self, "exposed_headers")

    @property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> int:
        """
        Required if CorsRule element is present. The number of seconds that the client/browser should cache a preflight response.
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class CorsRulesResponse(dict):
    """
    Sets the CORS rules. You can include up to five CorsRule elements in the request. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "corsRules":
            suggest = "cors_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CorsRulesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CorsRulesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CorsRulesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cors_rules: Optional[Sequence['outputs.CorsRuleResponse']] = None):
        """
        Sets the CORS rules. You can include up to five CorsRule elements in the request. 
        :param Sequence['CorsRuleResponse'] cors_rules: The List of CORS rules. You can include up to five CorsRule elements in the request. 
        """
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)

    @property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Optional[Sequence['outputs.CorsRuleResponse']]:
        """
        The List of CORS rules. You can include up to five CorsRule elements in the request. 
        """
        return pulumi.get(self, "cors_rules")


@pulumi.output_type
class CustomDomainResponse(dict):
    """
    The custom domain assigned to this storage account. This can be set via Update.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useSubDomainName":
            suggest = "use_sub_domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDomainResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDomainResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDomainResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 use_sub_domain_name: Optional[bool] = None):
        """
        The custom domain assigned to this storage account. This can be set via Update.
        :param str name: Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
        :param bool use_sub_domain_name: Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
        """
        pulumi.set(__self__, "name", name)
        if use_sub_domain_name is not None:
            pulumi.set(__self__, "use_sub_domain_name", use_sub_domain_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="useSubDomainName")
    def use_sub_domain_name(self) -> Optional[bool]:
        """
        Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
        """
        return pulumi.get(self, "use_sub_domain_name")


@pulumi.output_type
class DateAfterCreationResponse(dict):
    """
    Object to define the number of days after creation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysAfterCreationGreaterThan":
            suggest = "days_after_creation_greater_than"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DateAfterCreationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DateAfterCreationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DateAfterCreationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_after_creation_greater_than: float):
        """
        Object to define the number of days after creation.
        :param float days_after_creation_greater_than: Value indicating the age in days after creation
        """
        pulumi.set(__self__, "days_after_creation_greater_than", days_after_creation_greater_than)

    @property
    @pulumi.getter(name="daysAfterCreationGreaterThan")
    def days_after_creation_greater_than(self) -> float:
        """
        Value indicating the age in days after creation
        """
        return pulumi.get(self, "days_after_creation_greater_than")


@pulumi.output_type
class DateAfterModificationResponse(dict):
    """
    Object to define the number of days after object last modification Or last access. Properties daysAfterModificationGreaterThan and daysAfterLastAccessTimeGreaterThan are mutually exclusive.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysAfterLastAccessTimeGreaterThan":
            suggest = "days_after_last_access_time_greater_than"
        elif key == "daysAfterModificationGreaterThan":
            suggest = "days_after_modification_greater_than"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DateAfterModificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DateAfterModificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DateAfterModificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_after_last_access_time_greater_than: Optional[float] = None,
                 days_after_modification_greater_than: Optional[float] = None):
        """
        Object to define the number of days after object last modification Or last access. Properties daysAfterModificationGreaterThan and daysAfterLastAccessTimeGreaterThan are mutually exclusive.
        :param float days_after_last_access_time_greater_than: Value indicating the age in days after last blob access. This property can only be used in conjunction with last access time tracking policy
        :param float days_after_modification_greater_than: Value indicating the age in days after last modification
        """
        if days_after_last_access_time_greater_than is not None:
            pulumi.set(__self__, "days_after_last_access_time_greater_than", days_after_last_access_time_greater_than)
        if days_after_modification_greater_than is not None:
            pulumi.set(__self__, "days_after_modification_greater_than", days_after_modification_greater_than)

    @property
    @pulumi.getter(name="daysAfterLastAccessTimeGreaterThan")
    def days_after_last_access_time_greater_than(self) -> Optional[float]:
        """
        Value indicating the age in days after last blob access. This property can only be used in conjunction with last access time tracking policy
        """
        return pulumi.get(self, "days_after_last_access_time_greater_than")

    @property
    @pulumi.getter(name="daysAfterModificationGreaterThan")
    def days_after_modification_greater_than(self) -> Optional[float]:
        """
        Value indicating the age in days after last modification
        """
        return pulumi.get(self, "days_after_modification_greater_than")


@pulumi.output_type
class DeleteRetentionPolicyResponse(dict):
    """
    The service properties for soft delete.
    """
    def __init__(__self__, *,
                 days: Optional[int] = None,
                 enabled: Optional[bool] = None):
        """
        The service properties for soft delete.
        :param int days: Indicates the number of days that the deleted item should be retained. The minimum specified value can be 1 and the maximum value can be 365.
        :param bool enabled: Indicates whether DeleteRetentionPolicy is enabled.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Indicates the number of days that the deleted item should be retained. The minimum specified value can be 1 and the maximum value can be 365.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Indicates whether DeleteRetentionPolicy is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class EncryptionIdentityResponse(dict):
    """
    Encryption identity for the storage account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionUserAssignedIdentity":
            suggest = "encryption_user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_user_assigned_identity: Optional[str] = None):
        """
        Encryption identity for the storage account.
        :param str encryption_user_assigned_identity: Resource identifier of the UserAssigned identity to be associated with server-side encryption on the storage account.
        """
        if encryption_user_assigned_identity is not None:
            pulumi.set(__self__, "encryption_user_assigned_identity", encryption_user_assigned_identity)

    @property
    @pulumi.getter(name="encryptionUserAssignedIdentity")
    def encryption_user_assigned_identity(self) -> Optional[str]:
        """
        Resource identifier of the UserAssigned identity to be associated with server-side encryption on the storage account.
        """
        return pulumi.get(self, "encryption_user_assigned_identity")


@pulumi.output_type
class EncryptionResponse(dict):
    """
    The encryption settings on the storage account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keySource":
            suggest = "key_source"
        elif key == "encryptionIdentity":
            suggest = "encryption_identity"
        elif key == "keyVaultProperties":
            suggest = "key_vault_properties"
        elif key == "requireInfrastructureEncryption":
            suggest = "require_infrastructure_encryption"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_source: str,
                 encryption_identity: Optional['outputs.EncryptionIdentityResponse'] = None,
                 key_vault_properties: Optional['outputs.KeyVaultPropertiesResponse'] = None,
                 require_infrastructure_encryption: Optional[bool] = None,
                 services: Optional['outputs.EncryptionServicesResponse'] = None):
        """
        The encryption settings on the storage account.
        :param str key_source: The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault
        :param 'EncryptionIdentityResponse' encryption_identity: The identity to be used with service-side encryption at rest.
        :param 'KeyVaultPropertiesResponse' key_vault_properties: Properties provided by key vault.
        :param bool require_infrastructure_encryption: A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for data at rest.
        :param 'EncryptionServicesResponse' services: List of services which support encryption.
        """
        if key_source is None:
            key_source = 'Microsoft.Storage'
        pulumi.set(__self__, "key_source", key_source)
        if encryption_identity is not None:
            pulumi.set(__self__, "encryption_identity", encryption_identity)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)
        if require_infrastructure_encryption is not None:
            pulumi.set(__self__, "require_infrastructure_encryption", require_infrastructure_encryption)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter(name="keySource")
    def key_source(self) -> str:
        """
        The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault
        """
        return pulumi.get(self, "key_source")

    @property
    @pulumi.getter(name="encryptionIdentity")
    def encryption_identity(self) -> Optional['outputs.EncryptionIdentityResponse']:
        """
        The identity to be used with service-side encryption at rest.
        """
        return pulumi.get(self, "encryption_identity")

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional['outputs.KeyVaultPropertiesResponse']:
        """
        Properties provided by key vault.
        """
        return pulumi.get(self, "key_vault_properties")

    @property
    @pulumi.getter(name="requireInfrastructureEncryption")
    def require_infrastructure_encryption(self) -> Optional[bool]:
        """
        A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for data at rest.
        """
        return pulumi.get(self, "require_infrastructure_encryption")

    @property
    @pulumi.getter
    def services(self) -> Optional['outputs.EncryptionServicesResponse']:
        """
        List of services which support encryption.
        """
        return pulumi.get(self, "services")


@pulumi.output_type
class EncryptionScopeKeyVaultPropertiesResponse(dict):
    """
    The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentVersionedKeyIdentifier":
            suggest = "current_versioned_key_identifier"
        elif key == "lastKeyRotationTimestamp":
            suggest = "last_key_rotation_timestamp"
        elif key == "keyUri":
            suggest = "key_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionScopeKeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionScopeKeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionScopeKeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_versioned_key_identifier: str,
                 last_key_rotation_timestamp: str,
                 key_uri: Optional[str] = None):
        """
        The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
        :param str current_versioned_key_identifier: The object identifier of the current versioned Key Vault Key in use.
        :param str last_key_rotation_timestamp: Timestamp of last rotation of the Key Vault Key.
        :param str key_uri: The object identifier for a key vault key object. When applied, the encryption scope will use the key referenced by the identifier to enable customer-managed key support on this encryption scope.
        """
        pulumi.set(__self__, "current_versioned_key_identifier", current_versioned_key_identifier)
        pulumi.set(__self__, "last_key_rotation_timestamp", last_key_rotation_timestamp)
        if key_uri is not None:
            pulumi.set(__self__, "key_uri", key_uri)

    @property
    @pulumi.getter(name="currentVersionedKeyIdentifier")
    def current_versioned_key_identifier(self) -> str:
        """
        The object identifier of the current versioned Key Vault Key in use.
        """
        return pulumi.get(self, "current_versioned_key_identifier")

    @property
    @pulumi.getter(name="lastKeyRotationTimestamp")
    def last_key_rotation_timestamp(self) -> str:
        """
        Timestamp of last rotation of the Key Vault Key.
        """
        return pulumi.get(self, "last_key_rotation_timestamp")

    @property
    @pulumi.getter(name="keyUri")
    def key_uri(self) -> Optional[str]:
        """
        The object identifier for a key vault key object. When applied, the encryption scope will use the key referenced by the identifier to enable customer-managed key support on this encryption scope.
        """
        return pulumi.get(self, "key_uri")


@pulumi.output_type
class EncryptionServiceResponse(dict):
    """
    A service that allows server-side encryption to be used.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastEnabledTime":
            suggest = "last_enabled_time"
        elif key == "keyType":
            suggest = "key_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_enabled_time: str,
                 enabled: Optional[bool] = None,
                 key_type: Optional[str] = None):
        """
        A service that allows server-side encryption to be used.
        :param str last_enabled_time: Gets a rough estimate of the date/time when the encryption was last enabled by the user. Only returned when encryption is enabled. There might be some unencrypted blobs which were written after this time, as it is just a rough estimate.
        :param bool enabled: A boolean indicating whether or not the service encrypts the data as it is stored.
        :param str key_type: Encryption key type to be used for the encryption service. 'Account' key type implies that an account-scoped encryption key will be used. 'Service' key type implies that a default service key is used.
        """
        pulumi.set(__self__, "last_enabled_time", last_enabled_time)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)

    @property
    @pulumi.getter(name="lastEnabledTime")
    def last_enabled_time(self) -> str:
        """
        Gets a rough estimate of the date/time when the encryption was last enabled by the user. Only returned when encryption is enabled. There might be some unencrypted blobs which were written after this time, as it is just a rough estimate.
        """
        return pulumi.get(self, "last_enabled_time")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        A boolean indicating whether or not the service encrypts the data as it is stored.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[str]:
        """
        Encryption key type to be used for the encryption service. 'Account' key type implies that an account-scoped encryption key will be used. 'Service' key type implies that a default service key is used.
        """
        return pulumi.get(self, "key_type")


@pulumi.output_type
class EncryptionServicesResponse(dict):
    """
    A list of services that support encryption.
    """
    def __init__(__self__, *,
                 blob: Optional['outputs.EncryptionServiceResponse'] = None,
                 file: Optional['outputs.EncryptionServiceResponse'] = None,
                 queue: Optional['outputs.EncryptionServiceResponse'] = None,
                 table: Optional['outputs.EncryptionServiceResponse'] = None):
        """
        A list of services that support encryption.
        :param 'EncryptionServiceResponse' blob: The encryption function of the blob storage service.
        :param 'EncryptionServiceResponse' file: The encryption function of the file storage service.
        :param 'EncryptionServiceResponse' queue: The encryption function of the queue storage service.
        :param 'EncryptionServiceResponse' table: The encryption function of the table storage service.
        """
        if blob is not None:
            pulumi.set(__self__, "blob", blob)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if queue is not None:
            pulumi.set(__self__, "queue", queue)
        if table is not None:
            pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter
    def blob(self) -> Optional['outputs.EncryptionServiceResponse']:
        """
        The encryption function of the blob storage service.
        """
        return pulumi.get(self, "blob")

    @property
    @pulumi.getter
    def file(self) -> Optional['outputs.EncryptionServiceResponse']:
        """
        The encryption function of the file storage service.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def queue(self) -> Optional['outputs.EncryptionServiceResponse']:
        """
        The encryption function of the queue storage service.
        """
        return pulumi.get(self, "queue")

    @property
    @pulumi.getter
    def table(self) -> Optional['outputs.EncryptionServiceResponse']:
        """
        The encryption function of the table storage service.
        """
        return pulumi.get(self, "table")


@pulumi.output_type
class EndpointsResponse(dict):
    """
    The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "internetEndpoints":
            suggest = "internet_endpoints"
        elif key == "microsoftEndpoints":
            suggest = "microsoft_endpoints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blob: str,
                 dfs: str,
                 file: str,
                 queue: str,
                 table: str,
                 web: str,
                 internet_endpoints: Optional['outputs.StorageAccountInternetEndpointsResponse'] = None,
                 microsoft_endpoints: Optional['outputs.StorageAccountMicrosoftEndpointsResponse'] = None):
        """
        The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object.
        :param str blob: Gets the blob endpoint.
        :param str dfs: Gets the dfs endpoint.
        :param str file: Gets the file endpoint.
        :param str queue: Gets the queue endpoint.
        :param str table: Gets the table endpoint.
        :param str web: Gets the web endpoint.
        :param 'StorageAccountInternetEndpointsResponse' internet_endpoints: Gets the internet routing storage endpoints
        :param 'StorageAccountMicrosoftEndpointsResponse' microsoft_endpoints: Gets the microsoft routing storage endpoints.
        """
        pulumi.set(__self__, "blob", blob)
        pulumi.set(__self__, "dfs", dfs)
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "queue", queue)
        pulumi.set(__self__, "table", table)
        pulumi.set(__self__, "web", web)
        if internet_endpoints is not None:
            pulumi.set(__self__, "internet_endpoints", internet_endpoints)
        if microsoft_endpoints is not None:
            pulumi.set(__self__, "microsoft_endpoints", microsoft_endpoints)

    @property
    @pulumi.getter
    def blob(self) -> str:
        """
        Gets the blob endpoint.
        """
        return pulumi.get(self, "blob")

    @property
    @pulumi.getter
    def dfs(self) -> str:
        """
        Gets the dfs endpoint.
        """
        return pulumi.get(self, "dfs")

    @property
    @pulumi.getter
    def file(self) -> str:
        """
        Gets the file endpoint.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def queue(self) -> str:
        """
        Gets the queue endpoint.
        """
        return pulumi.get(self, "queue")

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Gets the table endpoint.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def web(self) -> str:
        """
        Gets the web endpoint.
        """
        return pulumi.get(self, "web")

    @property
    @pulumi.getter(name="internetEndpoints")
    def internet_endpoints(self) -> Optional['outputs.StorageAccountInternetEndpointsResponse']:
        """
        Gets the internet routing storage endpoints
        """
        return pulumi.get(self, "internet_endpoints")

    @property
    @pulumi.getter(name="microsoftEndpoints")
    def microsoft_endpoints(self) -> Optional['outputs.StorageAccountMicrosoftEndpointsResponse']:
        """
        Gets the microsoft routing storage endpoints.
        """
        return pulumi.get(self, "microsoft_endpoints")


@pulumi.output_type
class ExtendedLocationResponse(dict):
    """
    The complex type of the extended location.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The complex type of the extended location.
        :param str name: The name of the extended location.
        :param str type: The type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the extended location.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GeoReplicationStatsResponse(dict):
    """
    Statistics related to replication for storage account's Blob, Table, Queue and File services. It is only available when geo-redundant replication is enabled for the storage account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canFailover":
            suggest = "can_failover"
        elif key == "lastSyncTime":
            suggest = "last_sync_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GeoReplicationStatsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GeoReplicationStatsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GeoReplicationStatsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 can_failover: bool,
                 last_sync_time: str,
                 status: str):
        """
        Statistics related to replication for storage account's Blob, Table, Queue and File services. It is only available when geo-redundant replication is enabled for the storage account.
        :param bool can_failover: A boolean flag which indicates whether or not account failover is supported for the account.
        :param str last_sync_time: All primary writes preceding this UTC date/time value are guaranteed to be available for read operations. Primary writes following this point in time may or may not be available for reads. Element may be default value if value of LastSyncTime is not available, this can happen if secondary is offline or we are in bootstrap.
        :param str status: The status of the secondary location. Possible values are: - Live: Indicates that the secondary location is active and operational. - Bootstrap: Indicates initial synchronization from the primary location to the secondary location is in progress.This typically occurs when replication is first enabled. - Unavailable: Indicates that the secondary location is temporarily unavailable.
        """
        pulumi.set(__self__, "can_failover", can_failover)
        pulumi.set(__self__, "last_sync_time", last_sync_time)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="canFailover")
    def can_failover(self) -> bool:
        """
        A boolean flag which indicates whether or not account failover is supported for the account.
        """
        return pulumi.get(self, "can_failover")

    @property
    @pulumi.getter(name="lastSyncTime")
    def last_sync_time(self) -> str:
        """
        All primary writes preceding this UTC date/time value are guaranteed to be available for read operations. Primary writes following this point in time may or may not be available for reads. Element may be default value if value of LastSyncTime is not available, this can happen if secondary is offline or we are in bootstrap.
        """
        return pulumi.get(self, "last_sync_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the secondary location. Possible values are: - Live: Indicates that the secondary location is active and operational. - Bootstrap: Indicates initial synchronization from the primary location to the secondary location is in progress.This typically occurs when replication is first enabled. - Unavailable: Indicates that the secondary location is temporarily unavailable.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class IPRuleResponse(dict):
    """
    IP rule with specific IP or IP range in CIDR format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iPAddressOrRange":
            suggest = "i_p_address_or_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 i_p_address_or_range: str,
                 action: Optional[str] = None):
        """
        IP rule with specific IP or IP range in CIDR format.
        :param str i_p_address_or_range: Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
        :param str action: The action of IP ACL rule.
        """
        pulumi.set(__self__, "i_p_address_or_range", i_p_address_or_range)
        if action is None:
            action = 'Allow'
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="iPAddressOrRange")
    def i_p_address_or_range(self) -> str:
        """
        Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
        """
        return pulumi.get(self, "i_p_address_or_range")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        The action of IP ACL rule.
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        :param Mapping[str, 'UserAssignedIdentityResponse'] user_assigned_identities: Gets or sets a list of key value pairs that describe the set of User Assigned identities that will be used with this storage account. The key is the ARM resource identifier of the identity. Only 1 User Assigned identity is permitted here.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']]:
        """
        Gets or sets a list of key value pairs that describe the set of User Assigned identities that will be used with this storage account. The key is the ARM resource identifier of the identity. Only 1 User Assigned identity is permitted here.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class ImmutabilityPolicyPropertiesResponse(dict):
    """
    The properties of an ImmutabilityPolicy of a blob container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateHistory":
            suggest = "update_history"
        elif key == "allowProtectedAppendWrites":
            suggest = "allow_protected_append_writes"
        elif key == "immutabilityPeriodSinceCreationInDays":
            suggest = "immutability_period_since_creation_in_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImmutabilityPolicyPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImmutabilityPolicyPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImmutabilityPolicyPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 state: str,
                 update_history: Sequence['outputs.UpdateHistoryPropertyResponse'],
                 allow_protected_append_writes: Optional[bool] = None,
                 immutability_period_since_creation_in_days: Optional[int] = None):
        """
        The properties of an ImmutabilityPolicy of a blob container.
        :param str etag: ImmutabilityPolicy Etag.
        :param str state: The ImmutabilityPolicy state of a blob container, possible values include: Locked and Unlocked.
        :param Sequence['UpdateHistoryPropertyResponse'] update_history: The ImmutabilityPolicy update history of the blob container.
        :param bool allow_protected_append_writes: This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API
        :param int immutability_period_since_creation_in_days: The immutability period for the blobs in the container since the policy creation, in days.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "update_history", update_history)
        if allow_protected_append_writes is not None:
            pulumi.set(__self__, "allow_protected_append_writes", allow_protected_append_writes)
        if immutability_period_since_creation_in_days is not None:
            pulumi.set(__self__, "immutability_period_since_creation_in_days", immutability_period_since_creation_in_days)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        ImmutabilityPolicy Etag.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The ImmutabilityPolicy state of a blob container, possible values include: Locked and Unlocked.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateHistory")
    def update_history(self) -> Sequence['outputs.UpdateHistoryPropertyResponse']:
        """
        The ImmutabilityPolicy update history of the blob container.
        """
        return pulumi.get(self, "update_history")

    @property
    @pulumi.getter(name="allowProtectedAppendWrites")
    def allow_protected_append_writes(self) -> Optional[bool]:
        """
        This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API
        """
        return pulumi.get(self, "allow_protected_append_writes")

    @property
    @pulumi.getter(name="immutabilityPeriodSinceCreationInDays")
    def immutability_period_since_creation_in_days(self) -> Optional[int]:
        """
        The immutability period for the blobs in the container since the policy creation, in days.
        """
        return pulumi.get(self, "immutability_period_since_creation_in_days")


@pulumi.output_type
class KeyCreationTimeResponse(dict):
    """
    Storage account keys creation time.
    """
    def __init__(__self__, *,
                 key1: Optional[str] = None,
                 key2: Optional[str] = None):
        """
        Storage account keys creation time.
        """
        if key1 is not None:
            pulumi.set(__self__, "key1", key1)
        if key2 is not None:
            pulumi.set(__self__, "key2", key2)

    @property
    @pulumi.getter
    def key1(self) -> Optional[str]:
        return pulumi.get(self, "key1")

    @property
    @pulumi.getter
    def key2(self) -> Optional[str]:
        return pulumi.get(self, "key2")


@pulumi.output_type
class KeyPolicyResponse(dict):
    """
    KeyPolicy assigned to the storage account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyExpirationPeriodInDays":
            suggest = "key_expiration_period_in_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_expiration_period_in_days: int):
        """
        KeyPolicy assigned to the storage account.
        :param int key_expiration_period_in_days: The key expiration period in days.
        """
        pulumi.set(__self__, "key_expiration_period_in_days", key_expiration_period_in_days)

    @property
    @pulumi.getter(name="keyExpirationPeriodInDays")
    def key_expiration_period_in_days(self) -> int:
        """
        The key expiration period in days.
        """
        return pulumi.get(self, "key_expiration_period_in_days")


@pulumi.output_type
class KeyVaultPropertiesResponse(dict):
    """
    Properties of key vault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentVersionedKeyIdentifier":
            suggest = "current_versioned_key_identifier"
        elif key == "lastKeyRotationTimestamp":
            suggest = "last_key_rotation_timestamp"
        elif key == "keyName":
            suggest = "key_name"
        elif key == "keyVaultUri":
            suggest = "key_vault_uri"
        elif key == "keyVersion":
            suggest = "key_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_versioned_key_identifier: str,
                 last_key_rotation_timestamp: str,
                 key_name: Optional[str] = None,
                 key_vault_uri: Optional[str] = None,
                 key_version: Optional[str] = None):
        """
        Properties of key vault.
        :param str current_versioned_key_identifier: The object identifier of the current versioned Key Vault Key in use.
        :param str last_key_rotation_timestamp: Timestamp of last rotation of the Key Vault Key.
        :param str key_name: The name of KeyVault key.
        :param str key_vault_uri: The Uri of KeyVault.
        :param str key_version: The version of KeyVault key.
        """
        pulumi.set(__self__, "current_versioned_key_identifier", current_versioned_key_identifier)
        pulumi.set(__self__, "last_key_rotation_timestamp", last_key_rotation_timestamp)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_vault_uri is not None:
            pulumi.set(__self__, "key_vault_uri", key_vault_uri)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)

    @property
    @pulumi.getter(name="currentVersionedKeyIdentifier")
    def current_versioned_key_identifier(self) -> str:
        """
        The object identifier of the current versioned Key Vault Key in use.
        """
        return pulumi.get(self, "current_versioned_key_identifier")

    @property
    @pulumi.getter(name="lastKeyRotationTimestamp")
    def last_key_rotation_timestamp(self) -> str:
        """
        Timestamp of last rotation of the Key Vault Key.
        """
        return pulumi.get(self, "last_key_rotation_timestamp")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[str]:
        """
        The name of KeyVault key.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> Optional[str]:
        """
        The Uri of KeyVault.
        """
        return pulumi.get(self, "key_vault_uri")

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[str]:
        """
        The version of KeyVault key.
        """
        return pulumi.get(self, "key_version")


@pulumi.output_type
class LastAccessTimeTrackingPolicyResponse(dict):
    """
    The blob service properties for Last access time based tracking policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blobType":
            suggest = "blob_type"
        elif key == "trackingGranularityInDays":
            suggest = "tracking_granularity_in_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LastAccessTimeTrackingPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LastAccessTimeTrackingPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LastAccessTimeTrackingPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: bool,
                 blob_type: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 tracking_granularity_in_days: Optional[int] = None):
        """
        The blob service properties for Last access time based tracking policy.
        :param bool enable: When set to true last access time based tracking is enabled.
        :param Sequence[str] blob_type: An array of predefined supported blob types. Only blockBlob is the supported value. This field is currently read only
        :param str name: Name of the policy. The valid value is AccessTimeTracking. This field is currently read only
        :param int tracking_granularity_in_days: The field specifies blob object tracking granularity in days, typically how often the blob object should be tracked.This field is currently read only with value as 1
        """
        pulumi.set(__self__, "enable", enable)
        if blob_type is not None:
            pulumi.set(__self__, "blob_type", blob_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tracking_granularity_in_days is not None:
            pulumi.set(__self__, "tracking_granularity_in_days", tracking_granularity_in_days)

    @property
    @pulumi.getter
    def enable(self) -> bool:
        """
        When set to true last access time based tracking is enabled.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="blobType")
    def blob_type(self) -> Optional[Sequence[str]]:
        """
        An array of predefined supported blob types. Only blockBlob is the supported value. This field is currently read only
        """
        return pulumi.get(self, "blob_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the policy. The valid value is AccessTimeTracking. This field is currently read only
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="trackingGranularityInDays")
    def tracking_granularity_in_days(self) -> Optional[int]:
        """
        The field specifies blob object tracking granularity in days, typically how often the blob object should be tracked.This field is currently read only with value as 1
        """
        return pulumi.get(self, "tracking_granularity_in_days")


@pulumi.output_type
class LegalHoldPropertiesResponse(dict):
    """
    The LegalHold property of a blob container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hasLegalHold":
            suggest = "has_legal_hold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LegalHoldPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LegalHoldPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LegalHoldPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 has_legal_hold: bool,
                 tags: Optional[Sequence['outputs.TagPropertyResponse']] = None):
        """
        The LegalHold property of a blob container.
        :param bool has_legal_hold: The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold public property is set to false by SRP if all existing legal hold tags are cleared out. There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
        :param Sequence['TagPropertyResponse'] tags: The list of LegalHold tags of a blob container.
        """
        pulumi.set(__self__, "has_legal_hold", has_legal_hold)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="hasLegalHold")
    def has_legal_hold(self) -> bool:
        """
        The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold public property is set to false by SRP if all existing legal hold tags are cleared out. There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
        """
        return pulumi.get(self, "has_legal_hold")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.TagPropertyResponse']]:
        """
        The list of LegalHold tags of a blob container.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ManagementPolicyActionResponse(dict):
    """
    Actions are applied to the filtered blobs when the execution condition is met.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseBlob":
            suggest = "base_blob"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementPolicyActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementPolicyActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementPolicyActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_blob: Optional['outputs.ManagementPolicyBaseBlobResponse'] = None,
                 snapshot: Optional['outputs.ManagementPolicySnapShotResponse'] = None,
                 version: Optional['outputs.ManagementPolicyVersionResponse'] = None):
        """
        Actions are applied to the filtered blobs when the execution condition is met.
        :param 'ManagementPolicyBaseBlobResponse' base_blob: The management policy action for base blob
        :param 'ManagementPolicySnapShotResponse' snapshot: The management policy action for snapshot
        :param 'ManagementPolicyVersionResponse' version: The management policy action for version
        """
        if base_blob is not None:
            pulumi.set(__self__, "base_blob", base_blob)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="baseBlob")
    def base_blob(self) -> Optional['outputs.ManagementPolicyBaseBlobResponse']:
        """
        The management policy action for base blob
        """
        return pulumi.get(self, "base_blob")

    @property
    @pulumi.getter
    def snapshot(self) -> Optional['outputs.ManagementPolicySnapShotResponse']:
        """
        The management policy action for snapshot
        """
        return pulumi.get(self, "snapshot")

    @property
    @pulumi.getter
    def version(self) -> Optional['outputs.ManagementPolicyVersionResponse']:
        """
        The management policy action for version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ManagementPolicyBaseBlobResponse(dict):
    """
    Management policy action for base blob.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableAutoTierToHotFromCool":
            suggest = "enable_auto_tier_to_hot_from_cool"
        elif key == "tierToArchive":
            suggest = "tier_to_archive"
        elif key == "tierToCool":
            suggest = "tier_to_cool"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementPolicyBaseBlobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementPolicyBaseBlobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementPolicyBaseBlobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete: Optional['outputs.DateAfterModificationResponse'] = None,
                 enable_auto_tier_to_hot_from_cool: Optional[bool] = None,
                 tier_to_archive: Optional['outputs.DateAfterModificationResponse'] = None,
                 tier_to_cool: Optional['outputs.DateAfterModificationResponse'] = None):
        """
        Management policy action for base blob.
        :param 'DateAfterModificationResponse' delete: The function to delete the blob
        :param bool enable_auto_tier_to_hot_from_cool: This property enables auto tiering of a blob from cool to hot on a blob access. This property requires tierToCool.daysAfterLastAccessTimeGreaterThan.
        :param 'DateAfterModificationResponse' tier_to_archive: The function to tier blobs to archive storage. Support blobs currently at Hot or Cool tier
        :param 'DateAfterModificationResponse' tier_to_cool: The function to tier blobs to cool storage. Support blobs currently at Hot tier
        """
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if enable_auto_tier_to_hot_from_cool is not None:
            pulumi.set(__self__, "enable_auto_tier_to_hot_from_cool", enable_auto_tier_to_hot_from_cool)
        if tier_to_archive is not None:
            pulumi.set(__self__, "tier_to_archive", tier_to_archive)
        if tier_to_cool is not None:
            pulumi.set(__self__, "tier_to_cool", tier_to_cool)

    @property
    @pulumi.getter
    def delete(self) -> Optional['outputs.DateAfterModificationResponse']:
        """
        The function to delete the blob
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter(name="enableAutoTierToHotFromCool")
    def enable_auto_tier_to_hot_from_cool(self) -> Optional[bool]:
        """
        This property enables auto tiering of a blob from cool to hot on a blob access. This property requires tierToCool.daysAfterLastAccessTimeGreaterThan.
        """
        return pulumi.get(self, "enable_auto_tier_to_hot_from_cool")

    @property
    @pulumi.getter(name="tierToArchive")
    def tier_to_archive(self) -> Optional['outputs.DateAfterModificationResponse']:
        """
        The function to tier blobs to archive storage. Support blobs currently at Hot or Cool tier
        """
        return pulumi.get(self, "tier_to_archive")

    @property
    @pulumi.getter(name="tierToCool")
    def tier_to_cool(self) -> Optional['outputs.DateAfterModificationResponse']:
        """
        The function to tier blobs to cool storage. Support blobs currently at Hot tier
        """
        return pulumi.get(self, "tier_to_cool")


@pulumi.output_type
class ManagementPolicyDefinitionResponse(dict):
    """
    An object that defines the Lifecycle rule. Each definition is made up with a filters set and an actions set.
    """
    def __init__(__self__, *,
                 actions: 'outputs.ManagementPolicyActionResponse',
                 filters: Optional['outputs.ManagementPolicyFilterResponse'] = None):
        """
        An object that defines the Lifecycle rule. Each definition is made up with a filters set and an actions set.
        :param 'ManagementPolicyActionResponse' actions: An object that defines the action set.
        :param 'ManagementPolicyFilterResponse' filters: An object that defines the filter set.
        """
        pulumi.set(__self__, "actions", actions)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def actions(self) -> 'outputs.ManagementPolicyActionResponse':
        """
        An object that defines the action set.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def filters(self) -> Optional['outputs.ManagementPolicyFilterResponse']:
        """
        An object that defines the filter set.
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class ManagementPolicyFilterResponse(dict):
    """
    Filters limit rule actions to a subset of blobs within the storage account. If multiple filters are defined, a logical AND is performed on all filters. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blobTypes":
            suggest = "blob_types"
        elif key == "blobIndexMatch":
            suggest = "blob_index_match"
        elif key == "prefixMatch":
            suggest = "prefix_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementPolicyFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementPolicyFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementPolicyFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blob_types: Sequence[str],
                 blob_index_match: Optional[Sequence['outputs.TagFilterResponse']] = None,
                 prefix_match: Optional[Sequence[str]] = None):
        """
        Filters limit rule actions to a subset of blobs within the storage account. If multiple filters are defined, a logical AND is performed on all filters. 
        :param Sequence[str] blob_types: An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob.
        :param Sequence['TagFilterResponse'] blob_index_match: An array of blob index tag based filters, there can be at most 10 tag filters
        :param Sequence[str] prefix_match: An array of strings for prefixes to be match.
        """
        pulumi.set(__self__, "blob_types", blob_types)
        if blob_index_match is not None:
            pulumi.set(__self__, "blob_index_match", blob_index_match)
        if prefix_match is not None:
            pulumi.set(__self__, "prefix_match", prefix_match)

    @property
    @pulumi.getter(name="blobTypes")
    def blob_types(self) -> Sequence[str]:
        """
        An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob.
        """
        return pulumi.get(self, "blob_types")

    @property
    @pulumi.getter(name="blobIndexMatch")
    def blob_index_match(self) -> Optional[Sequence['outputs.TagFilterResponse']]:
        """
        An array of blob index tag based filters, there can be at most 10 tag filters
        """
        return pulumi.get(self, "blob_index_match")

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> Optional[Sequence[str]]:
        """
        An array of strings for prefixes to be match.
        """
        return pulumi.get(self, "prefix_match")


@pulumi.output_type
class ManagementPolicyRuleResponse(dict):
    """
    An object that wraps the Lifecycle rule. Each rule is uniquely defined by name.
    """
    def __init__(__self__, *,
                 definition: 'outputs.ManagementPolicyDefinitionResponse',
                 name: str,
                 type: str,
                 enabled: Optional[bool] = None):
        """
        An object that wraps the Lifecycle rule. Each rule is uniquely defined by name.
        :param 'ManagementPolicyDefinitionResponse' definition: An object that defines the Lifecycle rule.
        :param str name: A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
        :param str type: The valid value is Lifecycle
        :param bool enabled: Rule is enabled if set to true.
        """
        pulumi.set(__self__, "definition", definition)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def definition(self) -> 'outputs.ManagementPolicyDefinitionResponse':
        """
        An object that defines the Lifecycle rule.
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The valid value is Lifecycle
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Rule is enabled if set to true.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ManagementPolicySchemaResponse(dict):
    """
    The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
    """
    def __init__(__self__, *,
                 rules: Sequence['outputs.ManagementPolicyRuleResponse']):
        """
        The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
        :param Sequence['ManagementPolicyRuleResponse'] rules: The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.ManagementPolicyRuleResponse']:
        """
        The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class ManagementPolicySnapShotResponse(dict):
    """
    Management policy action for snapshot.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tierToArchive":
            suggest = "tier_to_archive"
        elif key == "tierToCool":
            suggest = "tier_to_cool"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementPolicySnapShotResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementPolicySnapShotResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementPolicySnapShotResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete: Optional['outputs.DateAfterCreationResponse'] = None,
                 tier_to_archive: Optional['outputs.DateAfterCreationResponse'] = None,
                 tier_to_cool: Optional['outputs.DateAfterCreationResponse'] = None):
        """
        Management policy action for snapshot.
        :param 'DateAfterCreationResponse' delete: The function to delete the blob snapshot
        :param 'DateAfterCreationResponse' tier_to_archive: The function to tier blob snapshot to archive storage. Support blob snapshot currently at Hot or Cool tier
        :param 'DateAfterCreationResponse' tier_to_cool: The function to tier blob snapshot to cool storage. Support blob snapshot currently at Hot tier
        """
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if tier_to_archive is not None:
            pulumi.set(__self__, "tier_to_archive", tier_to_archive)
        if tier_to_cool is not None:
            pulumi.set(__self__, "tier_to_cool", tier_to_cool)

    @property
    @pulumi.getter
    def delete(self) -> Optional['outputs.DateAfterCreationResponse']:
        """
        The function to delete the blob snapshot
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter(name="tierToArchive")
    def tier_to_archive(self) -> Optional['outputs.DateAfterCreationResponse']:
        """
        The function to tier blob snapshot to archive storage. Support blob snapshot currently at Hot or Cool tier
        """
        return pulumi.get(self, "tier_to_archive")

    @property
    @pulumi.getter(name="tierToCool")
    def tier_to_cool(self) -> Optional['outputs.DateAfterCreationResponse']:
        """
        The function to tier blob snapshot to cool storage. Support blob snapshot currently at Hot tier
        """
        return pulumi.get(self, "tier_to_cool")


@pulumi.output_type
class ManagementPolicyVersionResponse(dict):
    """
    Management policy action for blob version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tierToArchive":
            suggest = "tier_to_archive"
        elif key == "tierToCool":
            suggest = "tier_to_cool"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementPolicyVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementPolicyVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementPolicyVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete: Optional['outputs.DateAfterCreationResponse'] = None,
                 tier_to_archive: Optional['outputs.DateAfterCreationResponse'] = None,
                 tier_to_cool: Optional['outputs.DateAfterCreationResponse'] = None):
        """
        Management policy action for blob version.
        :param 'DateAfterCreationResponse' delete: The function to delete the blob version
        :param 'DateAfterCreationResponse' tier_to_archive: The function to tier blob version to archive storage. Support blob version currently at Hot or Cool tier
        :param 'DateAfterCreationResponse' tier_to_cool: The function to tier blob version to cool storage. Support blob version currently at Hot tier
        """
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if tier_to_archive is not None:
            pulumi.set(__self__, "tier_to_archive", tier_to_archive)
        if tier_to_cool is not None:
            pulumi.set(__self__, "tier_to_cool", tier_to_cool)

    @property
    @pulumi.getter
    def delete(self) -> Optional['outputs.DateAfterCreationResponse']:
        """
        The function to delete the blob version
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter(name="tierToArchive")
    def tier_to_archive(self) -> Optional['outputs.DateAfterCreationResponse']:
        """
        The function to tier blob version to archive storage. Support blob version currently at Hot or Cool tier
        """
        return pulumi.get(self, "tier_to_archive")

    @property
    @pulumi.getter(name="tierToCool")
    def tier_to_cool(self) -> Optional['outputs.DateAfterCreationResponse']:
        """
        The function to tier blob version to cool storage. Support blob version currently at Hot tier
        """
        return pulumi.get(self, "tier_to_cool")


@pulumi.output_type
class MultichannelResponse(dict):
    """
    Multichannel setting. Applies to Premium FileStorage only.
    """
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        Multichannel setting. Applies to Premium FileStorage only.
        :param bool enabled: Indicates whether multichannel is enabled
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Indicates whether multichannel is enabled
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class NetworkRuleSetResponse(dict):
    """
    Network rule set
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "ipRules":
            suggest = "ip_rules"
        elif key == "resourceAccessRules":
            suggest = "resource_access_rules"
        elif key == "virtualNetworkRules":
            suggest = "virtual_network_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkRuleSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkRuleSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkRuleSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_action: str,
                 bypass: Optional[str] = None,
                 ip_rules: Optional[Sequence['outputs.IPRuleResponse']] = None,
                 resource_access_rules: Optional[Sequence['outputs.ResourceAccessRuleResponse']] = None,
                 virtual_network_rules: Optional[Sequence['outputs.VirtualNetworkRuleResponse']] = None):
        """
        Network rule set
        :param str default_action: Specifies the default action of allow or deny when no other rules match.
        :param str bypass: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics.
        :param Sequence['IPRuleResponse'] ip_rules: Sets the IP ACL rules
        :param Sequence['ResourceAccessRuleResponse'] resource_access_rules: Sets the resource access rules
        :param Sequence['VirtualNetworkRuleResponse'] virtual_network_rules: Sets the virtual network rules
        """
        if default_action is None:
            default_action = 'Allow'
        pulumi.set(__self__, "default_action", default_action)
        if bypass is None:
            bypass = 'AzureServices'
        if bypass is not None:
            pulumi.set(__self__, "bypass", bypass)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if resource_access_rules is not None:
            pulumi.set(__self__, "resource_access_rules", resource_access_rules)
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> str:
        """
        Specifies the default action of allow or deny when no other rules match.
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter
    def bypass(self) -> Optional[str]:
        """
        Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics.
        """
        return pulumi.get(self, "bypass")

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[Sequence['outputs.IPRuleResponse']]:
        """
        Sets the IP ACL rules
        """
        return pulumi.get(self, "ip_rules")

    @property
    @pulumi.getter(name="resourceAccessRules")
    def resource_access_rules(self) -> Optional[Sequence['outputs.ResourceAccessRuleResponse']]:
        """
        Sets the resource access rules
        """
        return pulumi.get(self, "resource_access_rules")

    @property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[Sequence['outputs.VirtualNetworkRuleResponse']]:
        """
        Sets the virtual network rules
        """
        return pulumi.get(self, "virtual_network_rules")


@pulumi.output_type
class ObjectReplicationPolicyFilterResponse(dict):
    """
    Filters limit replication to a subset of blobs within the storage account. A logical OR is performed on values in the filter. If multiple filters are defined, a logical AND is performed on all filters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minCreationTime":
            suggest = "min_creation_time"
        elif key == "prefixMatch":
            suggest = "prefix_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectReplicationPolicyFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectReplicationPolicyFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectReplicationPolicyFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_creation_time: Optional[str] = None,
                 prefix_match: Optional[Sequence[str]] = None):
        """
        Filters limit replication to a subset of blobs within the storage account. A logical OR is performed on values in the filter. If multiple filters are defined, a logical AND is performed on all filters.
        :param str min_creation_time: Blobs created after the time will be replicated to the destination. It must be in datetime format 'yyyy-MM-ddTHH:mm:ssZ'. Example: 2020-02-19T16:05:00Z
        :param Sequence[str] prefix_match: Optional. Filters the results to replicate only blobs whose names begin with the specified prefix.
        """
        if min_creation_time is not None:
            pulumi.set(__self__, "min_creation_time", min_creation_time)
        if prefix_match is not None:
            pulumi.set(__self__, "prefix_match", prefix_match)

    @property
    @pulumi.getter(name="minCreationTime")
    def min_creation_time(self) -> Optional[str]:
        """
        Blobs created after the time will be replicated to the destination. It must be in datetime format 'yyyy-MM-ddTHH:mm:ssZ'. Example: 2020-02-19T16:05:00Z
        """
        return pulumi.get(self, "min_creation_time")

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> Optional[Sequence[str]]:
        """
        Optional. Filters the results to replicate only blobs whose names begin with the specified prefix.
        """
        return pulumi.get(self, "prefix_match")


@pulumi.output_type
class ObjectReplicationPolicyRuleResponse(dict):
    """
    The replication policy rule between two containers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationContainer":
            suggest = "destination_container"
        elif key == "sourceContainer":
            suggest = "source_container"
        elif key == "ruleId":
            suggest = "rule_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectReplicationPolicyRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectReplicationPolicyRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectReplicationPolicyRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_container: str,
                 source_container: str,
                 filters: Optional['outputs.ObjectReplicationPolicyFilterResponse'] = None,
                 rule_id: Optional[str] = None):
        """
        The replication policy rule between two containers.
        :param str destination_container: Required. Destination container name.
        :param str source_container: Required. Source container name.
        :param 'ObjectReplicationPolicyFilterResponse' filters: Optional. An object that defines the filter set.
        :param str rule_id: Rule Id is auto-generated for each new rule on destination account. It is required for put policy on source account.
        """
        pulumi.set(__self__, "destination_container", destination_container)
        pulumi.set(__self__, "source_container", source_container)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)

    @property
    @pulumi.getter(name="destinationContainer")
    def destination_container(self) -> str:
        """
        Required. Destination container name.
        """
        return pulumi.get(self, "destination_container")

    @property
    @pulumi.getter(name="sourceContainer")
    def source_container(self) -> str:
        """
        Required. Source container name.
        """
        return pulumi.get(self, "source_container")

    @property
    @pulumi.getter
    def filters(self) -> Optional['outputs.ObjectReplicationPolicyFilterResponse']:
        """
        Optional. An object that defines the filter set.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[str]:
        """
        Rule Id is auto-generated for each new rule on destination account. It is required for put policy on source account.
        """
        return pulumi.get(self, "rule_id")


@pulumi.output_type
class PermissionScopeResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceName":
            suggest = "resource_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionScopeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionScopeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionScopeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permissions: str,
                 resource_name: str,
                 service: str):
        """
        :param str permissions: The permissions for the local user. Possible values include: Read (r), Write (w), Delete (d), List (l), and Create (c).
        :param str resource_name: The name of resource, normally the container name or the file share name, used by the local user.
        :param str service: The service used by the local user, e.g. blob, file.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def permissions(self) -> str:
        """
        The permissions for the local user. Possible values include: Read (r), Write (w), Delete (d), List (l), and Create (c).
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        """
        The name of resource, normally the container name or the file share name, used by the local user.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        The service used by the local user, e.g. blob, file.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    The Private Endpoint Connection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 private_link_service_connection_state: 'outputs.PrivateLinkServiceConnectionStateResponse',
                 provisioning_state: str,
                 type: str,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None):
        """
        The Private Endpoint Connection resource.
        :param str id: Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        :param str name: The name of the resource
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: A collection of information about the state of the connection between service consumer and provider.
        :param str provisioning_state: The provisioning state of the private endpoint connection resource.
        :param str type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        :param 'PrivateEndpointResponse' private_endpoint: The resource of private end point.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.PrivateLinkServiceConnectionStateResponse':
        """
        A collection of information about the state of the connection between service consumer and provider.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the private endpoint connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The resource of private end point.
        """
        return pulumi.get(self, "private_endpoint")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The Private Endpoint resource.
        :param str id: The ARM identifier for Private Endpoint
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ARM identifier for Private Endpoint
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    A collection of information about the state of the connection between service consumer and provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionRequired":
            suggest = "action_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param str action_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The reason for approval/rejection of the connection.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if action_required is not None:
            pulumi.set(__self__, "action_required", action_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionRequired")
    def action_required(self) -> Optional[str]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "action_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ProtocolSettingsResponse(dict):
    """
    Protocol settings for file service
    """
    def __init__(__self__, *,
                 smb: Optional['outputs.SmbSettingResponse'] = None):
        """
        Protocol settings for file service
        :param 'SmbSettingResponse' smb: Setting for SMB protocol
        """
        if smb is not None:
            pulumi.set(__self__, "smb", smb)

    @property
    @pulumi.getter
    def smb(self) -> Optional['outputs.SmbSettingResponse']:
        """
        Setting for SMB protocol
        """
        return pulumi.get(self, "smb")


@pulumi.output_type
class ResourceAccessRuleResponse(dict):
    """
    Resource Access Rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceAccessRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceAccessRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceAccessRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Resource Access Rule.
        :param str resource_id: Resource Id
        :param str tenant_id: Tenant Id
        """
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Tenant Id
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class RestorePolicyPropertiesResponse(dict):
    """
    The blob service properties for blob restore policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastEnabledTime":
            suggest = "last_enabled_time"
        elif key == "minRestoreTime":
            suggest = "min_restore_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestorePolicyPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestorePolicyPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestorePolicyPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 last_enabled_time: str,
                 min_restore_time: str,
                 days: Optional[int] = None):
        """
        The blob service properties for blob restore policy
        :param bool enabled: Blob restore is enabled if set to true.
        :param str last_enabled_time: Deprecated in favor of minRestoreTime property.
        :param str min_restore_time: Returns the minimum date and time that the restore can be started.
        :param int days: how long this blob can be restored. It should be great than zero and less than DeleteRetentionPolicy.days.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "last_enabled_time", last_enabled_time)
        pulumi.set(__self__, "min_restore_time", min_restore_time)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Blob restore is enabled if set to true.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="lastEnabledTime")
    def last_enabled_time(self) -> str:
        """
        Deprecated in favor of minRestoreTime property.
        """
        return pulumi.get(self, "last_enabled_time")

    @property
    @pulumi.getter(name="minRestoreTime")
    def min_restore_time(self) -> str:
        """
        Returns the minimum date and time that the restore can be started.
        """
        return pulumi.get(self, "min_restore_time")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        how long this blob can be restored. It should be great than zero and less than DeleteRetentionPolicy.days.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class RoutingPreferenceResponse(dict):
    """
    Routing preference defines the type of network, either microsoft or internet routing to be used to deliver the user data, the default option is microsoft routing
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publishInternetEndpoints":
            suggest = "publish_internet_endpoints"
        elif key == "publishMicrosoftEndpoints":
            suggest = "publish_microsoft_endpoints"
        elif key == "routingChoice":
            suggest = "routing_choice"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingPreferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingPreferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingPreferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 publish_internet_endpoints: Optional[bool] = None,
                 publish_microsoft_endpoints: Optional[bool] = None,
                 routing_choice: Optional[str] = None):
        """
        Routing preference defines the type of network, either microsoft or internet routing to be used to deliver the user data, the default option is microsoft routing
        :param bool publish_internet_endpoints: A boolean flag which indicates whether internet routing storage endpoints are to be published
        :param bool publish_microsoft_endpoints: A boolean flag which indicates whether microsoft routing storage endpoints are to be published
        :param str routing_choice: Routing Choice defines the kind of network routing opted by the user.
        """
        if publish_internet_endpoints is not None:
            pulumi.set(__self__, "publish_internet_endpoints", publish_internet_endpoints)
        if publish_microsoft_endpoints is not None:
            pulumi.set(__self__, "publish_microsoft_endpoints", publish_microsoft_endpoints)
        if routing_choice is not None:
            pulumi.set(__self__, "routing_choice", routing_choice)

    @property
    @pulumi.getter(name="publishInternetEndpoints")
    def publish_internet_endpoints(self) -> Optional[bool]:
        """
        A boolean flag which indicates whether internet routing storage endpoints are to be published
        """
        return pulumi.get(self, "publish_internet_endpoints")

    @property
    @pulumi.getter(name="publishMicrosoftEndpoints")
    def publish_microsoft_endpoints(self) -> Optional[bool]:
        """
        A boolean flag which indicates whether microsoft routing storage endpoints are to be published
        """
        return pulumi.get(self, "publish_microsoft_endpoints")

    @property
    @pulumi.getter(name="routingChoice")
    def routing_choice(self) -> Optional[str]:
        """
        Routing Choice defines the kind of network routing opted by the user.
        """
        return pulumi.get(self, "routing_choice")


@pulumi.output_type
class SasPolicyResponse(dict):
    """
    SasPolicy assigned to the storage account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationAction":
            suggest = "expiration_action"
        elif key == "sasExpirationPeriod":
            suggest = "sas_expiration_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SasPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SasPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SasPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiration_action: str,
                 sas_expiration_period: str):
        """
        SasPolicy assigned to the storage account.
        :param str expiration_action: The SAS expiration action. Can only be Log.
        :param str sas_expiration_period: The SAS expiration period, DD.HH:MM:SS.
        """
        if expiration_action is None:
            expiration_action = 'Log'
        pulumi.set(__self__, "expiration_action", expiration_action)
        pulumi.set(__self__, "sas_expiration_period", sas_expiration_period)

    @property
    @pulumi.getter(name="expirationAction")
    def expiration_action(self) -> str:
        """
        The SAS expiration action. Can only be Log.
        """
        return pulumi.get(self, "expiration_action")

    @property
    @pulumi.getter(name="sasExpirationPeriod")
    def sas_expiration_period(self) -> str:
        """
        The SAS expiration period, DD.HH:MM:SS.
        """
        return pulumi.get(self, "sas_expiration_period")


@pulumi.output_type
class SkuResponse(dict):
    """
    The SKU of the storage account.
    """
    def __init__(__self__, *,
                 name: str,
                 tier: str):
        """
        The SKU of the storage account.
        :param str name: The SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was called accountType.
        :param str tier: The SKU tier. This is based on the SKU name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was called accountType.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The SKU tier. This is based on the SKU name.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SmbSettingResponse(dict):
    """
    Setting for SMB protocol
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationMethods":
            suggest = "authentication_methods"
        elif key == "channelEncryption":
            suggest = "channel_encryption"
        elif key == "kerberosTicketEncryption":
            suggest = "kerberos_ticket_encryption"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SmbSettingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SmbSettingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SmbSettingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_methods: Optional[str] = None,
                 channel_encryption: Optional[str] = None,
                 kerberos_ticket_encryption: Optional[str] = None,
                 multichannel: Optional['outputs.MultichannelResponse'] = None,
                 versions: Optional[str] = None):
        """
        Setting for SMB protocol
        :param str authentication_methods: SMB authentication methods supported by server. Valid values are NTLMv2, Kerberos. Should be passed as a string with delimiter ';'.
        :param str channel_encryption: SMB channel encryption supported by server. Valid values are AES-128-CCM, AES-128-GCM, AES-256-GCM. Should be passed as a string with delimiter ';'.
        :param str kerberos_ticket_encryption: Kerberos ticket encryption supported by server. Valid values are RC4-HMAC, AES-256. Should be passed as a string with delimiter ';'
        :param 'MultichannelResponse' multichannel: Multichannel setting. Applies to Premium FileStorage only.
        :param str versions: SMB protocol versions supported by server. Valid values are SMB2.1, SMB3.0, SMB3.1.1. Should be passed as a string with delimiter ';'.
        """
        if authentication_methods is not None:
            pulumi.set(__self__, "authentication_methods", authentication_methods)
        if channel_encryption is not None:
            pulumi.set(__self__, "channel_encryption", channel_encryption)
        if kerberos_ticket_encryption is not None:
            pulumi.set(__self__, "kerberos_ticket_encryption", kerberos_ticket_encryption)
        if multichannel is not None:
            pulumi.set(__self__, "multichannel", multichannel)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter(name="authenticationMethods")
    def authentication_methods(self) -> Optional[str]:
        """
        SMB authentication methods supported by server. Valid values are NTLMv2, Kerberos. Should be passed as a string with delimiter ';'.
        """
        return pulumi.get(self, "authentication_methods")

    @property
    @pulumi.getter(name="channelEncryption")
    def channel_encryption(self) -> Optional[str]:
        """
        SMB channel encryption supported by server. Valid values are AES-128-CCM, AES-128-GCM, AES-256-GCM. Should be passed as a string with delimiter ';'.
        """
        return pulumi.get(self, "channel_encryption")

    @property
    @pulumi.getter(name="kerberosTicketEncryption")
    def kerberos_ticket_encryption(self) -> Optional[str]:
        """
        Kerberos ticket encryption supported by server. Valid values are RC4-HMAC, AES-256. Should be passed as a string with delimiter ';'
        """
        return pulumi.get(self, "kerberos_ticket_encryption")

    @property
    @pulumi.getter
    def multichannel(self) -> Optional['outputs.MultichannelResponse']:
        """
        Multichannel setting. Applies to Premium FileStorage only.
        """
        return pulumi.get(self, "multichannel")

    @property
    @pulumi.getter
    def versions(self) -> Optional[str]:
        """
        SMB protocol versions supported by server. Valid values are SMB2.1, SMB3.0, SMB3.1.1. Should be passed as a string with delimiter ';'.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class SshPublicKeyResponse(dict):
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 key: Optional[str] = None):
        """
        :param str description: Optional. It is used to store the function/usage of the key
        :param str key: Ssh public key base64 encoded. The format should be: '<keyType> <keyData>', e.g. ssh-rsa AAAABBBB
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Optional. It is used to store the function/usage of the key
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        Ssh public key base64 encoded. The format should be: '<keyType> <keyData>', e.g. ssh-rsa AAAABBBB
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class StorageAccountInternetEndpointsResponse(dict):
    """
    The URIs that are used to perform a retrieval of a public blob, file, web or dfs object via a internet routing endpoint.
    """
    def __init__(__self__, *,
                 blob: str,
                 dfs: str,
                 file: str,
                 web: str):
        """
        The URIs that are used to perform a retrieval of a public blob, file, web or dfs object via a internet routing endpoint.
        :param str blob: Gets the blob endpoint.
        :param str dfs: Gets the dfs endpoint.
        :param str file: Gets the file endpoint.
        :param str web: Gets the web endpoint.
        """
        pulumi.set(__self__, "blob", blob)
        pulumi.set(__self__, "dfs", dfs)
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "web", web)

    @property
    @pulumi.getter
    def blob(self) -> str:
        """
        Gets the blob endpoint.
        """
        return pulumi.get(self, "blob")

    @property
    @pulumi.getter
    def dfs(self) -> str:
        """
        Gets the dfs endpoint.
        """
        return pulumi.get(self, "dfs")

    @property
    @pulumi.getter
    def file(self) -> str:
        """
        Gets the file endpoint.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def web(self) -> str:
        """
        Gets the web endpoint.
        """
        return pulumi.get(self, "web")


@pulumi.output_type
class StorageAccountKeyResponse(dict):
    """
    An access key for the storage account.
    """
    def __init__(__self__, *,
                 creation_time: str,
                 key_name: str,
                 permissions: str,
                 value: str):
        """
        An access key for the storage account.
        :param str creation_time: Creation time of the key, in round trip date format.
        :param str key_name: Name of the key.
        :param str permissions: Permissions for the key -- read-only or full permissions.
        :param str value: Base 64-encoded value of the key.
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Creation time of the key, in round trip date format.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        Name of the key.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def permissions(self) -> str:
        """
        Permissions for the key -- read-only or full permissions.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Base 64-encoded value of the key.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class StorageAccountMicrosoftEndpointsResponse(dict):
    """
    The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object via a microsoft routing endpoint.
    """
    def __init__(__self__, *,
                 blob: str,
                 dfs: str,
                 file: str,
                 queue: str,
                 table: str,
                 web: str):
        """
        The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object via a microsoft routing endpoint.
        :param str blob: Gets the blob endpoint.
        :param str dfs: Gets the dfs endpoint.
        :param str file: Gets the file endpoint.
        :param str queue: Gets the queue endpoint.
        :param str table: Gets the table endpoint.
        :param str web: Gets the web endpoint.
        """
        pulumi.set(__self__, "blob", blob)
        pulumi.set(__self__, "dfs", dfs)
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "queue", queue)
        pulumi.set(__self__, "table", table)
        pulumi.set(__self__, "web", web)

    @property
    @pulumi.getter
    def blob(self) -> str:
        """
        Gets the blob endpoint.
        """
        return pulumi.get(self, "blob")

    @property
    @pulumi.getter
    def dfs(self) -> str:
        """
        Gets the dfs endpoint.
        """
        return pulumi.get(self, "dfs")

    @property
    @pulumi.getter
    def file(self) -> str:
        """
        Gets the file endpoint.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def queue(self) -> str:
        """
        Gets the queue endpoint.
        """
        return pulumi.get(self, "queue")

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Gets the table endpoint.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def web(self) -> str:
        """
        Gets the web endpoint.
        """
        return pulumi.get(self, "web")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TagFilterResponse(dict):
    """
    Blob index tag based filtering for blob objects
    """
    def __init__(__self__, *,
                 name: str,
                 op: str,
                 value: str):
        """
        Blob index tag based filtering for blob objects
        :param str name: This is the filter tag name, it can have 1 - 128 characters
        :param str op: This is the comparison operator which is used for object comparison and filtering. Only == (equality operator) is currently supported
        :param str value: This is the filter tag value field used for tag based filtering, it can have 0 - 256 characters
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        This is the filter tag name, it can have 1 - 128 characters
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        This is the comparison operator which is used for object comparison and filtering. Only == (equality operator) is currently supported
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        This is the filter tag value field used for tag based filtering, it can have 0 - 256 characters
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TagPropertyResponse(dict):
    """
    A tag of the LegalHold of a blob container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdentifier":
            suggest = "object_identifier"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TagPropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TagPropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TagPropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_identifier: str,
                 tag: str,
                 tenant_id: str,
                 timestamp: str,
                 upn: str):
        """
        A tag of the LegalHold of a blob container.
        :param str object_identifier: Returns the Object ID of the user who added the tag.
        :param str tag: The tag value.
        :param str tenant_id: Returns the Tenant ID that issued the token for the user who added the tag.
        :param str timestamp: Returns the date and time the tag was added.
        :param str upn: Returns the User Principal Name of the user who added the tag.
        """
        pulumi.set(__self__, "object_identifier", object_identifier)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "timestamp", timestamp)
        pulumi.set(__self__, "upn", upn)

    @property
    @pulumi.getter(name="objectIdentifier")
    def object_identifier(self) -> str:
        """
        Returns the Object ID of the user who added the tag.
        """
        return pulumi.get(self, "object_identifier")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        The tag value.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        Returns the Tenant ID that issued the token for the user who added the tag.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def timestamp(self) -> str:
        """
        Returns the date and time the tag was added.
        """
        return pulumi.get(self, "timestamp")

    @property
    @pulumi.getter
    def upn(self) -> str:
        """
        Returns the User Principal Name of the user who added the tag.
        """
        return pulumi.get(self, "upn")


@pulumi.output_type
class UpdateHistoryPropertyResponse(dict):
    """
    An update history of the ImmutabilityPolicy of a blob container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "immutabilityPeriodSinceCreationInDays":
            suggest = "immutability_period_since_creation_in_days"
        elif key == "objectIdentifier":
            suggest = "object_identifier"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpdateHistoryPropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpdateHistoryPropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpdateHistoryPropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 immutability_period_since_creation_in_days: int,
                 object_identifier: str,
                 tenant_id: str,
                 timestamp: str,
                 update: str,
                 upn: str):
        """
        An update history of the ImmutabilityPolicy of a blob container.
        :param int immutability_period_since_creation_in_days: The immutability period for the blobs in the container since the policy creation, in days.
        :param str object_identifier: Returns the Object ID of the user who updated the ImmutabilityPolicy.
        :param str tenant_id: Returns the Tenant ID that issued the token for the user who updated the ImmutabilityPolicy.
        :param str timestamp: Returns the date and time the ImmutabilityPolicy was updated.
        :param str update: The ImmutabilityPolicy update type of a blob container, possible values include: put, lock and extend.
        :param str upn: Returns the User Principal Name of the user who updated the ImmutabilityPolicy.
        """
        pulumi.set(__self__, "immutability_period_since_creation_in_days", immutability_period_since_creation_in_days)
        pulumi.set(__self__, "object_identifier", object_identifier)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "timestamp", timestamp)
        pulumi.set(__self__, "update", update)
        pulumi.set(__self__, "upn", upn)

    @property
    @pulumi.getter(name="immutabilityPeriodSinceCreationInDays")
    def immutability_period_since_creation_in_days(self) -> int:
        """
        The immutability period for the blobs in the container since the policy creation, in days.
        """
        return pulumi.get(self, "immutability_period_since_creation_in_days")

    @property
    @pulumi.getter(name="objectIdentifier")
    def object_identifier(self) -> str:
        """
        Returns the Object ID of the user who updated the ImmutabilityPolicy.
        """
        return pulumi.get(self, "object_identifier")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        Returns the Tenant ID that issued the token for the user who updated the ImmutabilityPolicy.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def timestamp(self) -> str:
        """
        Returns the date and time the ImmutabilityPolicy was updated.
        """
        return pulumi.get(self, "timestamp")

    @property
    @pulumi.getter
    def update(self) -> str:
        """
        The ImmutabilityPolicy update type of a blob container, possible values include: put, lock and extend.
        """
        return pulumi.get(self, "update")

    @property
    @pulumi.getter
    def upn(self) -> str:
        """
        Returns the User Principal Name of the user who updated the ImmutabilityPolicy.
        """
        return pulumi.get(self, "upn")


@pulumi.output_type
class UserAssignedIdentityResponse(dict):
    """
    UserAssignedIdentity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        UserAssignedIdentity for the resource.
        :param str client_id: The client ID of the identity.
        :param str principal_id: The principal ID of the identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID of the identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of the identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class VirtualNetworkRuleResponse(dict):
    """
    Virtual Network rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "virtualNetworkResourceId":
            suggest = "virtual_network_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 virtual_network_resource_id: str,
                 action: Optional[str] = None,
                 state: Optional[str] = None):
        """
        Virtual Network rule.
        :param str virtual_network_resource_id: Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        :param str action: The action of virtual network rule.
        :param str state: Gets the state of virtual network rule.
        """
        pulumi.set(__self__, "virtual_network_resource_id", virtual_network_resource_id)
        if action is None:
            action = 'Allow'
        if action is not None:
            pulumi.set(__self__, "action", action)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="virtualNetworkResourceId")
    def virtual_network_resource_id(self) -> str:
        """
        Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        """
        return pulumi.get(self, "virtual_network_resource_id")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        The action of virtual network rule.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Gets the state of virtual network rule.
        """
        return pulumi.get(self, "state")


